"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsCertificate = exports.TlsMode = void 0;
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
var TlsMode;
(function (TlsMode) {
    TlsMode["STRICT"] = "STRICT";
    TlsMode["PERMISSIVE"] = "PERMISSIVE";
    TlsMode["DISABLED"] = "DISABLED";
})(TlsMode = exports.TlsMode || (exports.TlsMode = {}));
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props) {
        return new FileTlsCertificate(props);
    }
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props) {
        return new AcmTlsCertificate(props);
    }
}
exports.TlsCertificate = TlsCertificate;
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.acmCertificate = props.certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.certificateChain = props.certificateChainPath;
        this.privateKey = props.privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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