from nonebot import logger, on_command
from nonebot.matcher import Matcher

from ..message import send_song_media
from ..resolver import ResolvedSong


async def upload_handler_0(matcher: Matcher, song: ResolvedSong):
    if not song:
        await matcher.finish("未能从您的消息中解析到有效歌曲信息")

    try:
        await send_song_media(song, as_file=True)
    except Exception:
        logger.exception(f"Failed to upload {song} as file")
        await matcher.finish("上传失败，请检查后台输出")


def __register_upload_matcher():
    matcher_lyric = on_command("上传", aliases={"upload"})
    matcher_lyric.handle()(upload_handler_0)


__register_upload_matcher()
