import dataclasses
from dataclasses import dataclass
from opentelemetry._logs import LogRecord, Logger, LoggerProvider
from opentelemetry.util.types import _ExtendedAttributes
from threading import Lock
from typing import Any
from weakref import WeakSet

@dataclass
class ProxyLoggerProvider(LoggerProvider):
    """A logger provider that wraps another internal logger provider allowing it to be re-assigned."""
    provider: LoggerProvider
    loggers: WeakSet[ProxyLogger] = dataclasses.field(default_factory=WeakSet)
    lock: Lock = dataclasses.field(default_factory=Lock)
    suppressed_scopes: set[str] = dataclasses.field(default_factory=set)
    def get_logger(self, name: str, version: str | None = None, schema_url: str | None = None, attributes: _ExtendedAttributes | None = None) -> Logger: ...
    def suppress_scopes(self, *scopes: str) -> None: ...
    def set_provider(self, logger_provider: LoggerProvider) -> None: ...
    def __getattr__(self, item: str) -> Any: ...

@dataclass(eq=False)
class ProxyLogger(Logger):
    logger: Logger
    name: str
    version: str | None = ...
    schema_url: str | None = ...
    attributes: _ExtendedAttributes | None = ...
    def emit(self, record: LogRecord) -> None: ...
    def set_logger(self, provider: LoggerProvider) -> None: ...
    def __getattr__(self, item: str): ...
