"""taken from
https://www.math.ubc.ca/~cass/frivs/latin/latin-dict-full.html
"""
#pylint: disable=C0302,R1702,R0123,W0212,W0120,W0102,C1801,C0123,E0611,E0401,W0150,W0612,C0330,C0301

WORDS = {
    "consisto": ["be", "formed", "consist", "stop", "stay"],
    "basium": ["kiss"],
    "degenero": ["be", "unlike", "one's", "kind", "fall", "off", "degenerate"],
    "sibimet": ["them", "themselves"],
    "letalis": ["mortal", "deadly", "fatal"],
    "pupillus,pupilla": ["orphan", "ward"],
    "depopulo,depopulor": ["lay", "waste", "ravage", "devastate"],
    "nego": ["deny"],
    "paulatim": ["gradually", "little", "by", "little"],
    "oporotheca": ["place", "for", "keeping", "fruit"],
    "trium,fontium": ["trois-fontaines", "marne", "vitry-le-francais"],
    "pumilius,pumilio": ["dwarf"],
    "creta": ["chalk", "fuller's", "earth"],
    "pauci": ["few", "few", "some"],
    "confugo": ["flee", "have", "recourse", "take", "refuge"],
    "onus": ["load", "burden", "weight", "trouble", "charge", "public", "road", "tax"],
    "plebs,plebis": ["common", "people", "masses", "crowd"],
    "depraedor,depredor": ["plunder", "lay", "waste", "pillage", "ravage"],
    "emptio": ["buying", "purchase"],
    "laetatio,letatio": ["rejoicing", "joy"],
    "vicissitudo": ["change", "alteration"],
    "doctus": ["taught", "instructed", "learned", "tutored"],
    "erga": ["toward", "about"],
    "aequitas,equitas": ["justice", "fairness", "equity"],
    "filius": ["son"],
    "stabilitas": ["firmness", "stability", "durability"],
    "devenio": ["come", "arrive", "at", "reach"],
    "itaque": ["adv", "so", "therefore"],
    "contactus": ["touching", "contact", "contagion"],
    "traiectensium": ["utrecht"],
    "iaceo": ["lie", "lie", "prostrate", "lie", "dead"],
    "iterum": ["again", "second", "time", "once", "more"],
    "reformo": ["form", "again", "mould", "anew"],
    "causa": ["case", "at", "law", "case", "law-suit", "situation", "condition"],
    "solio": [],
    "sermo": ["discussion", "talk", "common", "talk", "conversation", "rumor"],
    "exuro,exussum": ["burn", "down", "burn", "set", "on", "fire"],
    "quippe": ["certainly", "be", "sure", "indeed", "course"],
    "egredior": ["egressus", "go", "out", "leave", "depart", "exit"],
    "curvus": ["arched", "bent", "bowed", "curved", "crooked", "wrong", "morally", "crooked"],
    "plecto": ["punish"],
    "nimium": ["adv", "too", "much", "overmuch", "excessively"],
    "fruor": ["have", "benefit", "enjoy"],
    "formica": ["ant"],
    "cohaero,cohero,cohesi,cohesum": ["adhere", "stick", "together"],
    "adulatio": ["fawning", "flattery", "sycophancy", "buttering", "up"],
    "contemplor": ["mark", "out", "regard", "consider", "carefully", "survey"],
    "relinquo": ["leave", "behind", "bequeath", "abandon", "forsake"],
    "fodio": ["prick", "sting", "jab"],
    "iaculum": ["dart", "javelin", "short", "spear"],
    "iucundus": ["agreeable", "pleasant", "gratifying"],
    "iuvo": ["help", "aid", "assist", "please"],
    "hora": ["hour", "time"],
    "accipio": ["consider", "oneself", "indebted", "receive", "learn", "take"],
    "pulso": ["strike", "hours"],
    "stipes,itis": ["log", "tree-trunk", "branch", "post", "club", "blockhead"],
    "decerto": ["contend", "fight", "finish"],
    "pervalidus": ["very", "strong"],
    "quaesitio,quesitio": ["investigation", "interrogation"],
    "quidem": ["indeed", "certainly", "at", "least", "not", "even"],
    "pando": ["stretch", "out", "spread", "out", "extent"],
    "monasterium": ["monastery", "abbey", "convent"],
    "diutinus": ["lasting", "long", "time", "enduring", "long-lived"],
    "scio,scivi,scitum": ["scio", "know"],
    "flatus": ["blowing", "blast", "breathing", "arrogance", "haughtiness"],
    "tibi": ["dat", "you", "i", "can't", "give", "you", "anything", "but", "love", "baby"],
    "emercor": ["buy", "up"],
    "periclitor": ["test", "make", "trial", "put", "in", "peril", "endanger"],
    "luctisonus": ["sad-sounding", "mournful", "baleful"],
    "promissor": ["promiser", "suretor", "guarantor"],
    "voluptuosus,": ["voluptuosus", "delightful", "pleasurable"],
    "scelestus": ["wicked", "accursed", "infamous", "criminal"],
    "exsto": ["stand", "out", "be", "extant", "appear", "project", "show", "itself"],
    "conduco": ["hire", "employ", "for", "wages", "among", "many", "other", "meanings"],
    "linteum": ["linen", "napkin"],
    "qualiter": ["as", "just", "as"],
    "fuga": ["flight", "escape"],
    "verus": ["true", "real", "proper", "right"],
    "conscientia": ["conscience", "consciousness", "knowledge"],
    "fidelis": ["faithful", "loyal", "true"],
    "coma": ["hair", "head", "leaves", "rays", "light"],
    "fugo": ["put", "flight", "chase", "away", "drive", "inexile", "pursue"],
    "lacertosus": ["muscular", "powerful"],
    "aptus": ["suitable", "appropriate", "fitting"],
    "toties,toties": ["so", "often", "so", "many", "times"],
    "vester,vestra,vestrum": ["vester", "pl", "your", "yours"],
    "liquidus": ["fluid", "flowing", "liquid", "clear", "evident", "certain"],
    "proinde": ["consequently", "therefore", "as", "result"],
    "ingemuo,,dat": ["groan", "sigh", "over"],
    "mei": ["my", "mine", "my", "heart", "belongs", "daddy", "that", "old", "gang", "mine"],
    "eruo": ["dig", "up", "pull", "out", "raze", "demolish"],
    "alo,alui,altum": ["nourish", "cherish", "support", "sustain", "maintain", "keep"],
    "vulticulus": ["look", "aspect", "appearance"],
    "quandoquidem": ["since", "because"],
    "studio": ["dat", "study", "pursue", "eagerly", "be", "eager", "for"],
    "prolabor": ["slide", "forward", "slip", "forward", "fall", "forward", "fall", "down"],
    "quantum,in,me,est": ["quantum", "in", "as", "much", "as", "in", "me", "lies"],
    "quodammodo": ["in", "certain", "way", "in", "certain", "measure"],
    "suscipio": ["raise", "up", "maintain", "support", "accept", "receive", "undertake"],
    "praepono,prepono": ["set", "over", "prefer"],
    "caritas": ["dearness", "affection", "charity"],
    "triduum": ["period", "three", "days"],
    "praegravo,pregravo": ["press", "heavily", "upon", "weigh", "down", "oppress"],
    "forum": ["market", "place", "town", "square"],
    "supplex": ["kneeling", "entreating", "suppliant"],
    "irritus": ["undecided", "void", "unfixed", "no", "effect"],
    "femina": ["woman"],
    "irritum": ["nothingness", "worthlessness", "vanity"],
    "dedico": ["dedicate"],
    "comburo": ["burn", "up", "ruin", "consume"],
    "pectus,pectoris": ["heart", "breast"],
    "arcus": ["bow", "bow", "arrows", "arch", "bend", "arc"],
    "cubicularis": ["pertaining", "bedroom"],
    "infantia": ["infancy", "babyhood"],
    "menapiorum": [""],
    "artificiosus": ["skillful", "accomplished", "skillfuly", "made"],
    "delinquo": ["fail", "be", "wanting", "fail", "in", "duty", "commit", "crime"],
    "plenus": ["full", "complete", "full", "satisfied", "rich", "mature", "plump"],
    "somnium": ["dream", "fancy", "day-dream", "foolishness", "nonsense"],
    "lens,lentis": ["lentil"],
    "insto": ["pursue", "eagerly", "devote", "oneself", "to"],
    "aer,aeris": ["air", "atmosphere", "ether", "weather"],
    "contrado": ["deliver", "together", "wholly"],
    "dedecus": ["shame", "dishonor", "disgrace", "crime", "dishonorable", "act"],
    "comminuo": ["scatter", "weaken", "damage"],
    "triginta": ["inedl", "thirty"],
    "armo": ["provide", "arms", "arm", "equip", "fit", "out"],
    "nocens": ["bad", "wicked", "injurious", "culpable", "evil"],
    "comminus": ["hand", "hand", "in", "close", "combat"],
    "confiteor,confessus": ["confess", "own", "up", "admit", "acknowledge"],
    "pario": ["bear", "bring", "forth", "produce", "create", "make", "get"],
    "lacertus": ["upper", "arm", "strength"],
    "imperiosus": ["imperious", "domineering", "powerful"],
    "luctus": ["lamentation", "mourning", "grief"],
    "arma": ["arms", "weapons"],
    "cupressus": ["cypress", "cypress", "wood", "cypress-wood", "casket"],
    "illata": ["cause", "occasion"],
    "magister": ["master", "canon", "master", "school", "professor"],
    "novus": ["new", "fresh", "young", "inexperienced", "revived", "refreshed"],
    "cubicularius": ["bed-chamber", "servant", "chamberlain"],
    "fultus": ["supporter"],
    "tabgo,tetigi,tactum": ["touch"],
    "infirmitas": ["weakness", "feebleness", "instability", "fickleness"],
    "marcieniensis": ["marchiennes"],
    "infodio,infodi,infossum": ["infodio", "dig", "in", "bury"],
    "impello,impuli,impulsum": ["impello", "set", "in", "mortion", "impel", "urge", "on"],
    "ocius": ["quick", "fleet", "sooner", "faster"],
    "ergo": ["adv", "accordingly", "then", "therefore"],
    "spectaculum": ["spectacle", "show"],
    "exertus": ["tested", "tried", "approved", "experienced"],
    "ludio,ludius": ["actor", "player"],
    "quantocius,quantotius": ["as", "quickly", "as", "possible"],
    "cohibeo": ["confine", "restrain", "hold", "back", "repress"],
    "tam,quam": ["as", "as", "possible"],
    "praefinio,prefinio": ["appoint", "ahead", "time"],
    "carmen": ["song", "poem"],
    "gloria": ["fame", "renown", "glory"],
    "recondo": ["lay", "up", "store", "hoard"],
    "pipio": ["chirp", "tweet", "pipe"],
    "repleo": ["replenish", "fill", "up", "fill", "up", "again", "fill", "satisfy"],
    "progressus": ["advance", "going", "forward", "increase", "royal", "circuit"],
    "pirus": ["pear", "tree"],
    "iudex": ["judge", "juror"],
    "distinguo": ["mark", "off", "distinguish", "divide", "separate"],
    "pirum": ["pear"],
    "vulgivagus,": ["vulgivagus", "wandering", "vagrant", "itinerant"],
    "secuutus": ["follower", "pursuer"],
    "induco": ["bring", "in", "introduce", "induce", "persuade", "decide"],
    "persuadeo,persuasi,persuasum": ["persuade"],
    "re,vera": ["in", "truth"],
    "quos": ["masc", "pl", "those", "whom", "he", "accused", "treachery"],
    "hoc": ["neut", "sing", "break", "this!", "fetter"],
    "furtificus": ["thievish"],
    "quot": ["how", "many", "as", "many", "indecl"],
    "puga,pyga": ["buttocks"],
    "promutuus": ["cash", "advanced", "prepaid", "arraigned", "beforehand"],
    "approbo": ["approve"],
    "etiam": ["adv", "even", "also"],
    "fefello": ["be", "failed", "by", "disappointed", "by", "something"],
    "hos": ["masc", "pl", "they", "burned", "these", "houses", "ground"],
    "quod": ["neut", "sing", "nom", "war", "which", "killed", "so", "many"],
    "disputatio": ["debate", "dispute", "discussion"],
    "summissus,from,summitto": ["let", "down", "lowered", "gentle", "mild"],
    "tutis": ["protected", "safe", "secure"],
    "alioquin": ["adv", "otherwise", "in", "some", "respects", "in", "general"],
    "aegresco,egresco": ["fall", "ill", "become", "troubled", "grow", "worse"],
    "maero": ["grieve", "sorrow"],
    "crinis": ["hair"],
    "quapropter": ["wherefore"],
    "ancilla": ["maidservant", "also", "used", "by", "nuns", "describe", "themselves"],
    "dimidium": ["half"],
    "cunae": ["nest", "for", "young", "birds"],
    "poposco": ["see"],
    "volatilis,": ["volatilis", "winged", "flying", "swift", "rapid", "fleeting", "transitory"],
    "urbs,urbis": ["city"],
    "despero": ["be", "without", "hope", "despair", "despair", "give", "up"],
    "sedo": ["settle", "smooth", "calm", "allay"],
    "congruus": ["agreeing", "fit", "suitable"],
    "plaga": ["district", "zone", "region"],
    "bestia": ["animal", "beast"],
    "praeter": ["adj", "except;", "prep", "acc", "besides", "beyond", "more", "than"],
    "pertingo": ["stretch", "out", "extend"],
    "pessimus": ["worst", "see", "malus"],
    "vere": ["truly", "really", "actually", "rightly"],
    "percipio,percepi,perceptum": ["gain", "learn", "perceive", "understand"],
    "commessatio,onis": ["eating", "together"],
    "sentio": ["feel", "perceive", "experience", "hold", "an", "opinion"],
    "moveo,moti,motum": ["move", "arouse", "affect", "influence"],
    "imperceptus": ["unperceived", "unknown"],
    "nequitia,nequities": ["worthlessness", "badness", "wickedness"],
    "platea": ["street", "courtyard"],
    "impleo": ["fill", "in", "up", "satisfy", "content", "fulfil", "perform"],
    "turpis": ["foul", "ugly", "disgraceful", "morally", "corrupt"],
    "viduata": ["deprived", "widowed", "bereft"],
    "derideo": ["laugh", "at", "mock", "deride"],
    "vito": ["avoid", "shun"],
    "truculenter": ["adv", "wildly", "savagely", "fiercely", "cruelly", "roughly"],
    "scisco": ["investigate", "ask", "inquire", "vote", "ordain", "resolve"],
    "aliquo": ["adv", "in", "some", "direction"],
    "consuo,consui,consutum": ["sew", "together", "stitch"],
    "talio,-onis": ["talio", "-onis:", "retribution"],
    "sophismata": ["false", "conclusions", "logical", "fallacies"],
    "millies,milies": ["thousand", "times"],
    "repeto": ["return", "begin", "again", "deduce", "recall", "recollect"],
    "secedo": ["go", "apart", "withdraw"],
    "radicitus": ["by", "roots", "utterly"],
    "ambulo": ["walk"],
    "nuntius": ["messenger", "message"],
    "durus": ["hard", "harsh", "tough", "strong,enduring", "rough", "rude", "uncouth"],
    "pius": ["dutiful", "godly", "holy", "upright", "kind", "honest", "affectionate"],
    "imber,ymber": ["rain", "shower", "rain", "storm", "pelting", "rain"],
    "templovium": ["templeuve", "villa", "near", "cisoing"],
    "creo": ["create", "make"],
    "brevitas": ["shortness", "brevity"],
    "prius": ["before", "formerly"],
    "perseverantia": ["perseverance", "persistence"],
    "ceterus": ["other", "rest"],
    "piscator": ["fisherman"],
    "opportunitatus": [],
    "rideo,risi,risum": ["laugh", "at", "laugh"],
    "tremo": ["tremble", "shake", "shudder"],
    "laboriose": ["laboriously", "with", "great", "effort"],
    "alos": ["some"],
    "lento": ["bend"],
    "denuo": ["anew", "again", "second", "time", "afresh"],
    "querimonia": ["complaint", "charge", "in", "court"],
    "lente": ["slowly", "calmly", "cooly", "deliberately"],
    "iter,itineris": ["road", "route", "journey"],
    "blanditia": ["blandishments", "attractions", "allurement", "charm"],
    "regula": ["rule", "monastic", "rule"],
    "recordatio": ["recollection", "memory", "recall"],
    "crepusculum": ["dusk", "twilight"],
    "curator": ["guardian", "overseer"],
    "beneficium": ["benefit", "favor", "service", "privilege", "right"],
    "stillicidium": ["dripping", "moisture", "rainwater", "from", "eaves"],
    "doleo": ["suffer", "pain", "be", "pained", "grieve"],
    "sicut": ["as", "just", "as", "as", "it", "were", "verb", "in", "subj", "just", "as", "if"],
    "praenuntio,prenuntio": ["foretell", "announce", "before", "hand"],
    "redemptor": ["redeemer", "christ"],
    "improviso": ["unexpected"],
    "vitium": ["fault", "vice", "crime"],
    "praecipuus,precipuus": ["excellent", "distinguished", "extraordinary"],
    "perpetuus": ["perpetual", "lasting", "continuous", "uninterrupted"],
    "cogo,coegi,coactum": ["bring", "together", "drive", "draw"],
    "capitulus": ["chapter", "chapter", "meeting", "chapter", "house"],
    "sortitus": ["casting", "lots", "deciding", "by", "lot"],
    "explicatus": ["explanation", "exposition"],
    "solutio": ["loosening", "payment", "solution", "explanation"],
    "crapula": ["wine-drinking", "intoxication", "drunkenness"],
    "singultim": ["stammeringly"],
    "evenio": ["come", "pass", "happen", "befall"],
    "vado": ["go", "hasten", "rush"],
    "rex,rgis": ["king"],
    "nonnumquam": ["sometimes"],
    "forte": ["by", "chance", "by", "luck", "accidentally"],
    "aduro,adustum": ["set", "fire", "burn", "singe", "kindle", "light"],
    "adfero,affero": ["bring", "news", "report", "apply", "bring", "bear"],
    "mando": ["commit", "entrust", "order", "command"],
    "facio": ["trans", "make", "do", "act", "perform", "cause", "bring", "about"],
    "palam": ["openly", "publicly", "abl", "in", "presence", "of"],
    "attonbitus": ["frantic", "inspired", "thunder-struck", "stunned"],
    "sanitas": ["health", "soundness", "mend", "sanity"],
    "angelus": ["angel"],
    "videlicet": ["adv", "ironically", "course", "be", "sure"],
    "propono": ["display", "publish", "relate", "tell", "propose", "promise"],
    "inscribo": ["inscribe", "entitle", "enlist"],
    "amplexus": ["an", "embracing", "surrounding", "loving", "embrace", "[euphemism]",
    "amplio:", "enlarge", "increase", "improve"],
    "voco,in,dubium,": ["call", "inquestion"],
    "vorax,": ["gluttonous", "voracious"],
    "cibo": ["food", "for", "animals"],
    "volubilis,": ["volubilis", "rolling", "revolving", "turning", "around", "changeable", "inconstant"],
    "infit": ["he", "she", "it", "begins", "begins", "speak"],
    "attero": ["weaken", "ruin", "rub", "against", "rub", "away", "erode"],
    "ventito": ["come", "often", "visit", "frequently"],
    "ne,quidem": ["not", "even"],
    "tristis": ["sad", "gloomy", "downcast"],
    "contemptim": ["contemptuously"],
    "lepor,lepos": ["charm", "wit", "elegance"],
    "praenuntius,prenuncius": ["foretelling", "harbinger", "omen", "token"],
    "suppono,subpono": ["put", "in", "place", "substitute", "forge"],
    "everto": ["turn", "out", "eject", "dislodge", "overturn", "destroy", "ruin"],
    "lacerta": ["lizard"],
    "infenso": ["attack", "avenge"],
    "morbus": ["sickness", "disease", "illness"],
    "increpo": ["of", "persons", "chide", "rebuke"],
    "ordinatio": ["rule", "government", "order", "arrangment", "regulation"],
    "tener,tenera,tenerum": ["tener", "tender", "delicate", "soft", "young"],
    "hostis": ["an", "enemy", "state"],
    "imperator": ["commander", "in", "chief", "general", "emperor"],
    "prevenire": ["come", "go", "before", "hand", "attend"],
    "infectum,reddere": ["revoke", "render", "impossible", "make", "void", "annul"],
    "saepius,sepius": ["often", "frequently", "repeatedly"],
    "pergo": ["continue", "proceed", "go", "on", "with"],
    "devotio": ["christian", "piety", "devotion", "zeal"],
    "cunctus": ["all", "all", "collectively", "whole"],
    "horum": ["these"],
    "inicio,inieci,iniectum": ["inicio", "throw", "on", "put", "on", "don", "inspire"],
    "longus": ["long"],
    "adepto": ["obtain", "get", "acquire"],
    "decet": ["it", "is", "seemly", "comely", "suitable", "proper"],
    "enim": ["for", "in", "fact", "truly", "may", "often", "be", "omitted"],
    "erepo": ["creep", "out", "creep", "over", "creep", "up"],
    "innotesco,innotui": ["become", "known"],
    "niger": ["black"],
    "dulcedo": ["sweetness", "pleasantness", "charm"],
    "celebrus": ["abounding", "in", "rich", "in", "much", "frequented", "respected"],
    "clementia": ["indulgence", "forbearance", "humanity", "mercy", "gentleness"],
    "quoniam": ["since", "whereas", "because"],
    "facillimus": ["easiest", "most", "agreeable", "pleasantest"],
    "suadeo": ["recommend", "advise", "person"],
    "lego": ["gather", "choose", "collect", "pass", "through", "read"],
    "insons,insontis": ["guiltless", "innocent"],
    "ingenium": ["innate", "character", "talent", "nature"],
    "custodia": ["protection", "custody"],
    "tot": ["indecl", "so", "many"],
    "caput,capitis": ["head", "top", "summit", "chief"],
    "inferne": ["on", "lower", "side", "below"],
    "oportet": ["it", "is", "proper", "one", "should", "one", "ought"],
    "blandior": ["flatter", "caress", "dat", "coax"],
    "fidens": ["confident", "without", "fear", "courageous"],
    "laboriosus": ["toilsome", "laborious", "persons", "industrious", "toiling"],
    "uxor": ["wife", "spouse"],
    "adaugeo": ["make", "greater", "add", "increase"],
    "furor": ["madness", "rage", "frenzy"],
    "quadraginta": ["forty", "indecl"],
    "servo": ["watch", "over", "keep", "protect", "observe", "save", "reserve"],
    "intercipio,intercepi,interceptum": ["intercipio", "intercept"],
    "infidelis": ["unfaithful", "disloyal", "untrue"],
    "cito": ["quickly", "rapidly", "speedily"],
    "cibus": ["food", "for", "men", "animals"],
    "quamvis": ["however", "much", "although", "as", "much", "as", "you", "like"],
    "opportunitas": ["fitness", "suitability", "convenience", "advantage"],
    "diffama,-tus": ["diffama", "-tus:", "spread", "around", "made", "known"],
    "signum": ["sign", "seal", "indication", "sign"],
    "passer": ["sparrow"],
    "abbatia": ["abbey", "monastery"],
    "celeriter": ["rapidly", "quickly", "swiftly", "speedily"],
    "aeneus,eneus": ["made", "copper", "bronze", "brazen"],
    "verto": ["flee", "interpret", "understand", "upset", "overthrow"],
    "terga,dare": ["flee", "retreat", "run", "away"],
    "auctoritas": ["authority"],
    "vulpes,volpes": ["fox"],
    "infortunium": ["misfortune", "bad", "luck", "punishment"],
    "dapifer": ["seneschal"],
    "succurro": ["run", "up", "under", "aid", "assist", "help"],
    "digressio": ["separation", "departure", "digression"],
    "effectus": ["doing", "execution", "performance", "effect", "result"],
    "contente": ["eagerly", "earnestly"],
    "praeeo,preeo": ["go", "before", "precede", "say", "in", "advance", "order"],
    "plures": ["more", "numerous", "several", "many"],
    "cornu": ["horn"],
    "cattus": ["cat"],
    "longe": ["far"],
    "sitio": ["be", "thirsty"],
    "remuneror": ["repay", "reward"],
    "quemadmodum": ["how", "in", "what", "manner"],
    "corripio": ["seize", "snatch", "up", "steal", "of", "disease", "attack"],
    "quantus,quantus": ["as", "great", "as", "as", "much", "as"],
    "conspicio": ["catch", "sight", "perceive", "behold", "understand"],
    "insolita": ["unaccustomed", "unusual"],
    "impedo": ["entangle", "ensnare", "hinder", "prevent", "obstruct"],
    "ex,improviso": ["suddenly"],
    "litterae": ["pl", "letter", "epistle", "missive", "note", "literature"],
    "quando": ["interr", "when", "if", "ever"],
    "capio": ["seize", "take", "choose", "attack", "injure", "comprehend"],
    "absorbeo": ["swallow", "gulp", "down", "carry", "away", "engross"],
    "canonicus": ["canonical", "according", "canons", "legal", "lawful", "right"],
    "rego,rexi,rectum": ["rego", "guide", "direct", "rule"],
    "umquam": ["ever", "at", "any", "time"],
    "furtum": ["theft", "stolen", "property", "trick", "deceit"],
    "lentitudo": ["slowness", "apathy", "sluggishness"],
    "nitesco": ["begin", "shine", "grow", "sleek"],
    "alveus": ["hollow", "basket", "bed", "of", "river"],
    "victoria": ["victory"],
    "desidiosus": ["lazy", "unmotivated"],
    "successio": ["succeeding", "succession", "descent", "descendant"],
    "exustio": ["burning", "up", "conflagration"],
    "gravo": ["oppress", "burden", "make", "suffer"],
    "quas": ["fem", "pl", "fates", "against", "whom", "he", "struggled"],
    "molestus": ["troublesome", "disagreeable", "annoying"],
    "labefacto": ["weaken", "disturb", "shake", "violently"],
    "aetas": ["an", "age", "stage", "period", "life", "time", "era"],
    "inficio,infeci,infectum": ["inficio", "tinge", "dye", "stain", "imbue"],
    "pudendus": ["shameful", "disgraceful"],
    "inveteratus": ["hardened", "by", "age", "long-standing"],
    "illarum": ["fem", "pl", "gen", "city", "wall", "had", "four", "those", "gates"],
    "morior": ["die", "wither", "away", "decay"],
    "gravitas": ["weight", "seriousness", "dignity", "importance"],
    "privatus": ["private", "unofficial", "private", "person"],
    "devito": ["avoid"],
    "curia": ["court"],
    "levamen": ["alleviation", "mitigation", "solace", "refreshment"],
    "exheres": ["disinherited"],
    "celebrer": ["famous", "renowned"],
    "speciosus": ["beautiful", "handsome", "imposing", "specious", "plausible"],
    "probo": ["show", "prove", "demonstrate", "approve", "find", "good", "judge"],
    "mitis": ["mild", "gentle", "ripe", "mature"],
    "conscius": ["conscious", "aware", "of"],
    "pia,pium": ["honest", "godly", "holy", "pious", "dutiful", "patriotic"],
    "elemosina": ["alms"],
    "suffragium": ["vote", "franchise", "approval", "support", "aid", "assistance"],
    "imbrium": ["of", "rain"],
    "priscus": ["ancient", "antique", "former", "old", "days", "venerable"],
    "enumero": ["count", "count", "up", "enumerate"],
    "excolo": ["honor", "deity", "polish", "adorn", "refine", "serve"],
    "colligo": ["gather", "together", "collect", "assemble"],
    "expletio": ["satisfying"],
    "lacus": ["hollow", "lake", "pool", "pond", "trough", "tank", "tub"],
    "ater,atra,atrum": ["dark"],
    "cribro": ["sift"],
    "volo,sibi,velle": ["mean", "signify", "denote"],
    "cupio": ["desire", "wish", "long", "for", "desire"],
    "quaeso,queso": ["seek", "for", "ask", "for"],
    "infecundus": ["barren", "sterile"],
    "regnum": ["rule", "authority", "kingdom", "realm"],
    "invideo": ["envy", "be", "jealous", "look", "upon", "with", "envy"],
    "studium": ["eagerness", "zeal"],
    "thema": ["subject", "topic", "theme"],
    "devoco": ["call", "away", "call", "down", "call", "aside"],
    "uter,utrius": ["either", "two"],
    "imperium": ["power", "command", "authority", "command", "rule", "control"],
    "ingero": ["go", "off", "betake", "oneself", "pour", "forth", "inflict"],
    "cameracum": ["cambrai"],
    "altus": ["high", "deep"],
    "spes": ["hope"],
    "de": ["prep", "abl", "down", "from", "from", "concerning", "about"],
    "se,habere": ["keep", "oneself"],
    "scaber": ["scabby", "rough"],
    "comptus": ["head-dress", "hairband"],
    "satura": ["satire"],
    "imprimis": ["especially", "particularly", "specifically"],
    "feretrum": ["bier", "litter"],
    "saturo": ["fill", "satisfy"],
    "edico": ["announce", "declare"],
    "praemitto": ["send", "forward", "dispatch", "send", "in", "advance"],
    "consuetudo": ["custom", "usage", "habit", "intimacy", "familiar", "acquaintance"],
    "suscito": ["stir", "up", "arouse", "excite"],
    "mater,matris": ["mother"],
    "disco": ["learn", "become", "acquainted", "with"],
    "indigeo": ["require", "need", "stand", "in", "need", "of"],
    "nuper": ["newly", "recently", "not", "long", "ago"],
    "macies": ["thiness", "gauntness", "poverty", "barrenness"],
    "ictus": ["blow", "bite", "stroke", "bolt", "thrust"],
    "despecto": ["overlook", "despise", "look", "down", "upon"],
    "importunus": ["unsuitable", "unfavorable", "troublesome", "inconsiderate"],
    "acquiro": ["acquire", "gain", "get", "obtain"],
    "curtus": ["shortened", "mutilated", "defective", "gelded"],
    "trellum": ["tre", "blon", "castle", "in", "hannonia"],
    "beatus": ["blessed", "fortunate", "sometimes", "'saint'"],
    "profundum": ["depth", "abyss", "chasm", "sea"],
    "vespillo": ["undertaker"],
    "septem": ["seven"],
    "lactatio": ["enticement", "come-on"],
    "profundus": ["deep", "profound", "high", "thick", "dense", "boundless"],
    "ficus": ["fig", "tree"],
    "voluntarius,": ["voluntarius", "voluntary"],
    "atrox": ["terrible", "cruel", "horror"],
    "tergus": ["back", "skin", "hide", "leather"],
    "progenies": ["descent", "lineage", "progeny", "offspring", "descendants"],
    "accedo": ["approach", "come", "near", "be", "added"],
    "peto": ["ask", "for", "beg", "request", "demand", "sue", "for"],
    "templum": ["sacred", "precinct", "temple", "sometimes", "church"],
    "hospes": ["guest", "host", "stranger"],
    "medicus": ["doctor", "physician"],
    "exsilium": ["exile", "banishment"],
    "ira": ["anger", "wrath"],
    "lacero": ["tear", "pieces", "mangle", "squander", "money", "slander", "someone"],
    "mare,maris": ["sea"],
    "colo,colui,cultum": ["cultivate", "cherish"],
    "caveo,cavi,cautum": ["beware", "avoid", "look", "out", "for"],
    "leviter": ["lightly", "softly", "slightly"],
    "credo": ["believe", "trust", "commit", "trust", "in", "rely", "on", "think"],
    "natura": ["nature"],
    "deprecor": ["beg", "by", "entreaty", "excuse", "oneself", "curse"],
    "reprehendo": ["blame", "reprove", "refute", "hold", "back", "check", "catch"],
    "familiaris": ["belonging", "household", "friendly", "intimate"],
    "impetus": ["attack", "onset", "rapid", "motion", "impulse", "passion", "force"],
    "invitus": ["unwilling", "against", "one's", "will"],
    "mutuus": ["loan", "make", "loan", "for"],
    "propugnaculum": ["fortification", "rampart", "defense"],
    "arceo": ["shut", "up", "enclose"],
    "quae,que": ["fem", "sing", "nom", "milkmaid", "who", "loved", "prince"],
    "conscendo": ["ascend", "mount", "go", "up"],
    "occulto": ["secretly"],
    "cur": ["why", "wherefore"],
    "precipio": ["anticipate", "instruct", "advise", "warn"],
    "proficio": ["advance", "assist", "help", "aid", "be", "use"],
    "propinquo": ["intrans", "come", "near", "draw", "near", "approach"],
    "puter": ["rotten", "decayed", "putrid", "loose", "crumbling", "flabby"],
    "noster,nostra,nostrum": ["noster", "our", "ours"],
    "utilis": ["useful", "advantageous", "helpful"],
    "admonitio": ["warning", "reminder"],
    "supellex,supellectilis": ["furniture", "apparatus", "gear"],
    "puteo": ["stink", "be", "redolent", "smell", "bad"],
    "decretum": ["decree", "judgment", "edict", "order"],
    "genus": ["kind", "sort", "class", "category"],
    "adhaero": ["hang", "stick", "adhere"],
    "confido": ["have", "confidence", "in", "be", "confident", "rely", "upon"],
    "calamus": ["anything", "made", "reed", "pen", "arrow", "pipe"],
    "tricesimus": ["thirtieth"],
    "econtra": ["same", "against", "opposite"],
    "sollicitus": ["troubled", "anxious", "concerned", "worried"],
    "qualiscumque": ["of", "any", "kind", "whatever", "any", "whatever"],
    "orbis,terrarum": ["world", "earth"],
    "privigna": ["step-daughter"],
    "mirus": ["wonderful", "astonishing", "extraordinary"],
    "recordor": ["remember", "think", "recollect", "ponder", "over"],
    "marceniense": ["marchiennes"],
    "promo,prompsi,promptum": ["promo", "produce", "disclose", "bring", "forth"],
    "revertor,reverti,reversus": ["revertor", "return", "come", "back"],
    "uredo": ["plant", "blight"],
    "hae,he": ["fem", "pl", "nom", "these", "speeches", "were", "very", "fine"],
    "specus": ["cave", "cavern", "grotto", "den"],
    "copia": ["abundance", "supply"],
    "progenitor": ["founder", "family", "ancestor"],
    "locupleto": ["enrich", "make", "wealthy"],
    "loquax,loquacis": ["talkative", "loquacious", "garrulous"],
    "pro": ["abl", "in", "front", "before", "on", "behalf", "for"],
    "desino": ["cease", "stop", "end", "desist"],
    "obvius": ["on", "way", "in", "way", "in", "dat", "open", "accessible"],
    "preastolatio,prestolatio": ["waiting", "for", "expectation"],
    "excito": ["call", "forth", "bring", "about", "wake", "raise", "up"],
    "investigo": ["track", "down", "investigate"],
    "vernandense": ["vermandois"],
    "deduco": ["lad", "out", "colonists", "found", "colony"],
    "laqueum": ["noose", "halter", "snare", "trap"],
    "vultuosus": ["grimacing", "affected"],
    "offensio": ["striking", "knocking", "hitting", "against", "blow"],
    "utpote": ["namely", "seeing", "that", "inasmuch", "as", "since"],
    "atqui": ["yet", "still"],
    "fluctus": ["billow", "wave"],
    "atque": ["and"],
    "repo,repsi,reptum": ["repo", "creep", "crawl"],
    "sponte": ["willingly", "one's", "own", "accord", "unaided"],
    "servio": ["dat", "be", "slave", "serve"],
    "iniquus": ["unequal", "unjust", "unfair"],
    "aliquantum": ["noun", "good", "deal"],
    "personam,gero": ["act", "part"],
    "curiositas": ["curiosity", "inquisitiveness", "nosiness"],
    "monstro": ["show", "appoint", "point", "out", "ordain"],
    "sanctus": ["holy", "sacred", "saint"],
    "copiae,copie": ["supplies", "troops", "forces"],
    "aliquantus": ["some", "size", "moderate"],
    "conventus": ["coming", "together", "assembly", "union", "congress"],
    "maneo": ["remain", "stay", "stay", "night", "last", "endure", "abide", "by"],
    "mactabilis": ["deadly", "lethal"],
    "monachus": ["monk"],
    "cimentarius": ["mason"],
    "prolato": ["enlarge", "lengthen", "extend", "put", "off", "defer"],
    "cotidie": ["daily", "every", "day"],
    "semper": ["always", "ever"],
    "textilis": ["woven", "fabric", "piece", "cloth"],
    "eluvies": ["flowing", "over", "flood", "inundation"],
    "differtus": ["stuffed", "full", "crammed", "jammed"],
    "ludo,lusi,lusum": ["ludo", "play", "sport", "imitate", "banter", "delude", "deceive"],
    "umerus,humerus": ["shoulder", "upper", "arm"],
    "quantuvis": ["as", "great", "as", "you", "please", "however", "great"],
    "in": ["abl", "in"],
    "ambianis": ["amiens"],
    "siligo,-inis": ["siligo", "-inis:", "wheat", "flour"],
    "potius": ["rather", "preferably"],
    "ineptio": ["play", "fool", "trifle"],
    "aegrus": ["ill", "diseased", "unwell"],
    "compleo": ["fill", "up", "man", "bring", "up", "strength", "fulfill"],
    "aliqui": ["some"],
    "quartus": ["fourth"],
    "seductor": ["seducer"],
    "silenti,etc": ["dead"],
    "pecco": ["do", "wrong", "err", "sin", "go", "astray"],
    "solus": ["alone", "only", "only"],
    "restituo": ["restore", "put", "back", "replace", "reinstate", "repair"],
    "miles,militis": ["soldier", "warrior", "knight"],
    "praetermissio,pretermissio": ["neglect", "passing", "over", "omission"],
    "diluo": ["of", "troubles", "remove", "resolve"],
    "quadruplor": ["be", "an", "informant"],
    "somnus": ["sleep"],
    "infeliciter": ["unhappily"],
    "laganum": ["cake"],
    "memoria": ["memory", "remembrance", "recall", "recollection"],
    "et,et": ["both", "and"],
    "hanc": ["fem", "sing", "she", "wasted", "this", "her", "youth"],
    "percontor,percunctor": ["inquire", "interrogate", "investigate"],
    "concisus": ["cut", "up", "broken", "brief", "concise"],
    "ingens": ["of", "immoderate", "size", "vast", "huge", "monstrous", "remarkable"],
    "baiulus": ["porter", "pall-bearer", "carrier", "burden"],
    "periculosus": ["hazardous", "dangerous"],
    "amicus": ["friend", "comrade"],
    "tunc": ["then", "at", "that", "time"],
    "praemo,premo": ["press", "down", "strike", "down"],
    "plumbum,album": ["tin"],
    "catervatim": ["in", "troops", "in", "masses"],
    "indagatio": ["investigation"],
    "orior,oriri,ortus": ["rise", "become", "visible", "appear"],
    "carcer": ["prison", "cell", "jail", "dungeon"],
    "aestas,estas": ["summer"],
    "fortiter": ["strongly", "bravely"],
    "video,vidi,visum": ["see", "observe", "understand", "comprehend"],
    "abutor": ["use", "abusive", "language", "use", "word", "incorrectly"],
    "ita,ut": ["with", "subj", "in", "such", "way", "that"],
    "provectus": ["advanced", "advanced", "in", "age"],
    "qualis": ["of", "what", "kind?", "kind", "that"],
    "lethargus": ["drowsiness", "apathy", "sleepiness", "coma"],
    "maxime": ["greatly", "exceedingly", "highest", "degree", "very"],
    "ritus": ["usage", "ceremony", "rite"],
    "pusillus": ["tiny", "puny", "petty", "mean"],
    "blesense": ["blois"],
    "cognatus": ["related", "by", "blood", "noun", "relative", "kinsman"],
    "jugis": ["continual", "ceaseless", "perennial", "constant"],
    "corpus,corporis": ["body", "corpse"],
    "somnio": ["dream", "dream", "imagine", "foolishly"],
    "superbus": ["overbearing", "arrogant", "haughty", "proud"],
    "proluo,prolu,prolutum": ["wash", "away", "wash", "clean"],
    "via": ["road", "way", "street"],
    "intendo": ["extend", "aim", "direct", "direct", "one's", "course", "aim", "at"],
    "erubesco": ["inf", "blush", "acc", "blush", "for", "respect"],
    "permoveo": ["excite", "agitate", "stir", "up", "move"],
    "usque": ["all", "way", "up", "to", "even", "to"],
    "permitto,permissi,permissum": ["allow", "permit", "let"],
    "ustulo": ["burn", "scorch", "singe"],
    "opprobrium": ["reproach", "disgrace"],
    "hac": ["fem", "sing", "abl", "he", "who", "lives", "by", "this", "sword", ""],
    "avaritia": ["avarice", "greed"],
    "antea": ["adv", "before", "previously", "formerly"],
    "denego": ["refuse", "deny", "reject"],
    "rumor": ["rumor", "gossip"],
    "bonus,melior,optimus": ["bonus", "good", "better", "best"],
    "tempestas": ["storm", "weather"],
    "dolus": ["fraud", "deceit", "guile", "treachery", "trap"],
    "has": ["fem", "pl", "they", "gave", "these", "their", "lives", "for", "faith"],
    "copiose": ["fully", "at", "length", "copiously"],
    "apud": ["prep", "among", "in", "presence", "at", "at", "house", "of"],
    "cunabula": ["cradle"],
    "ops": ["singular:", "power", "power", "aid", "power", "help"],
    "persequor,persequi,persecutus": ["persequor", "follow", "pursue", "take", "revenge"],
    "subnecto": ["bind", "on", "beneath", "tie"],
    "lucrum": ["gain", "profit"],
    "labor,lapsus": ["slip", "glide", "slide"],
    "tergeo,tergo,tersi,tersum": ["tergeo", "tergo", "wipe", "scour", "clean"],
    "mensis,mensis": ["month"],
    "munio": ["fortify", "defend", "protect", "build", "road"],
    "nescio": ["be", "ignorant", "be", "unaware", "not", "know", "be", "unknowing"],
    "condato": [],
    "misereo,misereor": ["pity"],
    "nitor": ["brilliance", "brightness", "glow", "elegance", "splendor"],
    "tamquam,tanquam": ["as", "just", "as", "like", "as", "just", "as", "if"],
    "fluo": ["flow", "pour", "stream"],
    "adnuo": ["nod", "assent"],
    "consulatio": ["deliberation", "inquiry", "full", "consideration"],
    "infervesco": ["come", "boil", "become", "hot"],
    "plico": ["fold"],
    "ademptio": ["taking", "away"],
    "pertineo": ["pertain", "relate", "concern"],
    "pestifer": ["pestilential", "injurious", "damaging", "plaguey"],
    "opisthotonos": ["disease", "where", "body", "is", "curved", "backward"],
    "inceptum": ["beginning", "attempt", "enterprise"],
    "spiculum": ["sharp", "point", "sting", "spear", "dart"],
    "comiter": ["courteously", "in", "kindly", "friendly", "manner"],
    "textus": ["woven", "cloth", "web"],
    "helcim": ["helchin", "on", "left", "bank", "scheldt"],
    "facunditas": ["fertility", "quickness", "readiness", "speech"],
    "gemblacensis": ["gembloux"],
    "propello": ["drive", "before", "one", "drive", "away"],
    "facina,-oris": ["bad", "deed", "crime", "villainy", "deed", "action"],
    "aliquotiens": ["some", "times"],
    "instigo": ["goad", "incite", "stimulate", "urge"],
    "proloquor": ["speak", "out", "declare", "openly"],
    "clibanus": ["oven", "furnace", "tray", "for", "bread", "making"],
    "illudo,illusi,illusum": ["mock", "make", "fun", "ridicule"],
    "inflexio": ["bendings", "swaying"],
    "volubiliter,": ["fluently"],
    "schola": ["school", "elite", "troop", "soldiers"],
    "magnopere,magnus,opere": ["magnopere", "very", "very", "much"],
    "feteo": ["have", "bad", "odor", "stink"],
    "pronuntio": ["proclaim", "announce", "declaim"],
    "suspendo,suspendi,suspensum": ["suspend", "hang"],
    "appello": ["call", "name", "summon"],
    "peior": ["worse", "see", "malus"],
    "antepono": ["dat", "put", "before", "prefer", "favor", "promote"],
    "sapienter": ["wisely", "judiciously"],
    "idem,eadem,idem": ["idem", "same"],
    "amor": ["love", "affection", "infatuation", "passion"],
    "quin": ["but", "come", "now", "rather", "indeed"],
    "renuo": ["deny", "refuse", "reject"],
    "fortunatus": ["fortunate", "lucky", "happy"],
    "meretrix,meretricis": ["prostitute", "whore", "harlot"],
    "lentesco": ["become", "soft", "flexible", "sticky", "weaken", "slacken"],
    "libenter": ["willingly", "with", "pleasure"],
    "flax,falcis": ["sickle", "bill-hook", "pruning", "hook"],
    "reconcilio": ["restore", "repair", "of", "persons", "unite", "reconcile"],
    "tersus": ["clean", "neat", "correct"],
    "esurio": ["be", "hungry", "hunger"],
    "ploratus": ["weeping", "lamenting"],
    "hunc": ["masc", "sing", "he", "ate", "this", "fruit"],
    "refectorium": ["refectory", "monastic", "mess", "hall"],
    "simul": ["at", "once", "at", "same", "time", "together"],
    "plus": ["more"],
    "supernus": ["above", "superior"],
    "animi": ["at", "heart"],
    "dolose": ["slyly", "deceitfully"],
    "adeo": ["approach", "visit", "come", "undertake"],
    "curis,quris": ["spear"],
    "lacesso": ["harass", "attack"],
    "erro": ["wander", "stray", "rove", "be", "mistaken", "err", "go", "astray"],
    "aureus": ["golden"],
    "promisce,promiscue": ["indiscriminately"],
    "longe,lateque": ["far", "wide"],
    "pulpitum": ["platform", "stage"],
    "perfruor": ["execute", "completely", "enjoy", "full"],
    "iocus": ["joke", "jest", "jape", "gag"],
    "perlustro": ["pass", "through", "survey", "look", "examine"],
    "doctrina": ["doctrine", "teaching", "instruction", "learning"],
    "patefacio": ["disclose", "expose", "open", "make", "open"],
    "praetereo,pretereo": ["pass", "over", "pass", "by", "omit"],
    "invenio": ["come", "upon", "find", "discover"],
    "abeo": ["digress", "change", "vanish", "disappear"],
    "novo": ["make", "anew", "refresh", "revive", "change", "alter", "invent"],
    "respicio": ["look", "back", "provide", "for", "respect", "have", "regard", "for"],
    "pons,pontis": ["bridge"],
    "corbeiam": ["corbie"],
    "expiscor": ["fish", "out", "find", "out", "discover"],
    "salsus": ["salty", "witty"],
    "liberaliter": ["courteously", "generously", "honorably"],
    "abstergo": ["wipe", "off", "clean", "away"],
    "lamnia,lammina,lamna": ["lamnia", "sheet", "metal", "coin", "knife", "blade", "nutshell"],
    "tonsor": ["barbar"],
    "diuturnus": ["lasting", "long", "time", "long", "duration"],
    "voveo,vovi,votum,": ["voveo", "vovi", "votum", "promise", "god", "vow", "pray", "for"],
    "neo": ["spin", "interweave", "spin", "thread", "yarn"],
    "transmitto": ["send", "carry", "convey", "across"],
    "thesaurus": ["treasure", "horde", "store-room", "treasury"],
    "exordium": ["beginning", "especially", "speech"],
    "removeo": ["draw", "back", "set", "aside", "take", "away"],
    "mos,moris": ["will", "inclination", "custom", "wont", "usage", "rule"],
    "pulex": ["flea"],
    "hortus,ortus": ["garden", "pl", "grounds", "park"],
    "victus": ["living", "manner", "life", "nourishment", "food"],
    "medius": ["middle", "middle", "of"],
    "quaestuosus,questuosus": ["profitable", "fond", "gain", "rich"],
    "judicium": ["trial", "legal", "investigation", "judgement", "decision"],
    "pello,pepulli,pulsum": ["pello", "hit", "beat", "exile", "drive", "away", "banish"],
    "demonstro": ["indicate", "show", "describe", "explain"],
    "inquis": ["you", "say"],
    "laeto,leto": ["laeleto:", "cheer", "gladden", "make", "joyful"],
    "perpetro": ["complete", "accomplish", "perform"],
    "infelix": ["unfruitful", "barren", "unproductive", "infertile"],
    "dubito": ["doubt", "hesitate"],
    "cuius": ["fem", "sing", "gen", "queen", "vices", "whom", "were", "many"],
    "imitabilis": ["that", "can", "be", "imitated"],
    "ipsemet": ["his", "own", "very", "self"],
    "potestas": ["power", "ability", "authority", "opportunity"],
    "libellus": ["little", "book"],
    "adsuesco,assuesco": ["grow", "accustomed", "used", "make", "familiar"],
    "labores,solis": ["eclipse", "sun"],
    "relucesco": ["become", "bright", "again"],
    "depono": ["put", "down", "lay", "aside"],
    "sordesco": ["become", "dirty"],
    "recupero": ["regain", "recoup", "recover"],
    "constupro": ["ravish", "corrupt"],
    "pereo": ["pass", "away", "be", "destroyed", "perish"],
    "rememdium": ["cure", "remedy", "nostrum", "medicine"],
    "premo,pressi,pressum": ["premo", "squeeze", "press", "down", "strike", "down"],
    "stips,stipis": ["small", "coin", "gift"],
    "quattuor": ["four", "indecl"],
    "strenuus": ["brisk", "active", "vigorous", "turbulent", "restive"],
    "traiectum": ["maastricht"],
    "sanctus,egidius": ["st", "gilles"],
    "communis": ["common", "general", "run", "mill"],
    "praecepio,precepio": ["precept", "preconception"],
    "vivo,vixi,victum,": ["live", "be", "alive"],
    "vesper": ["evening", "star", "evening"],
    "pluit,pluvit": ["it", "is", "raining", "shower", "is", "falling"],
    "libatio": ["libation"],
    "positus": ["position", "place", "arrangment"],
    "mire": ["wonderfully", "marvellously", "uncommonly"],
    "agnosco": ["recognize", "understand", "perceive"],
    "excedo": ["trans", "exceed", "leave", "pass", "beyond"],
    "prohibeo": ["prevent", "hinder", "restrain", "prohibit", "forbid"],
    "profundo,frofui,profusum": ["profundo", "pour", "forth", "gush", "stream"],
    "laetitia,letitia": ["fertility", "richness", "grace", "joy", "delight"],
    "concupiscentia": ["avarice", "covetousness"],
    "apostolus": ["legal", "notice", "sent", "higher", "tribunal", "ecc", "apostle"],
    "fugitivus": ["fugitive:", "deserter", "runaway", "slave"],
    "affligeniensis,haffligeniensis": ["afflighem"],
    "identidem": ["again", "again", "repeatedly"],
    "nequam": ["worthless", "good", "for", "nothing", "bad"],
    "itero": ["repeat", "say", "again", "iterate"],
    "impendeo": ["hang", "over", "threaten", "menace", "be", "imminent"],
    "singultus": ["sobbing", "death", "rattle"],
    "frequentia": ["large", "concourse", "population", "numerous", "assembly"],
    "damno": ["condemn", "damn"],
    "thorax": ["breastplate"],
    "lasesco": ["become", "tired", "grow", "weary"],
    "redemptio": ["ransoming", "redemption", "buying", "back", "farming", "taxes"],
    "brevis": ["short", "small", "brief"],
    "lac,lactis": ["milk"],
    "fructus,fructus": ["fruit", "profit", "enjoyment", "produce"],
    "specto": ["look", "at", "watch", "see"],
    "inservio": ["be", "slave", "serve", "be", "devoted", "to"],
    "posthabeo": ["[posthabito]:", "put", "after", "consider", "less", "account"],
    "imcomposite": ["incompositione", "in"],
    "praecedo,precedo": ["precede", "go", "before", "surpass", "excel"],
    "fulgeo,fulsi,": ["fulgeo", "fulsi", "flash", "shine", "beam"],
    "antiquus": ["ancient", "old", "hoary"],
    "cedo": ["dat", "give", "ground", "submit", "be", "inferior", "to"],
    "attollo": ["raise", "lift", "up", "elevate", "excite", "exalt"],
    "exspecto": ["look", "for", "expect", "await", "wait", "for"],
    "quingenti": ["five", "hundred"],
    "apto": ["fit", "adapt", "adjust", "make", "ready", "fit"],
    "laeve,leve": ["left-handedly", "awkwardly"],
    "furtim": ["by", "stealth", "stealthily"],
    "levamentum": ["comfort", "easing", "alleviation", "consolation"],
    "pictoratus": ["painted", "cloth", "embroidered"],
    "leo": ["lion"],
    "abundans": ["abundant", "overflowing", "abounding", "in"],
    "informis": ["formless", "shapeless", "deformed", "hideous"],
    "infidelitas": ["faithlessness", "disloyalty"],
    "profero": ["carry", "out", "bring", "forth"],
    "severitas": ["severity", "rigor", "sternness", "strictness"],
    "charisma,carisma": ["gift", "present"],
    "saevio": ["rage", "be", "furious", "take", "violent", "action"],
    "plagiarius": ["kid-napper", "plagiarist"],
    "fenestra": ["window"],
    "humo": ["cover", "with", "earth", "bury"],
    "terror": ["fright", "fear", "terror"],
    "vel": ["or", "adv", "even", "actually", "for", "example"],
    "immundus": ["foul", "impure"],
    "berlinmonte": ["berlaimont", "near", "le", "quesnoy"],
    "nomen": ["name", "roman", "power"],
    "appropinquo": ["dat", "near", "drawn", "near", "come", "close", "approach"],
    "effervo": ["boil", "up"],
    "pugno": ["fight"],
    "persevero": ["persist", "persevere", "continue"],
    "humilis": ["lowly", "humble"],
    "eximo": ["free", "release", "take", "out", "remove", "waste"],
    "sequax": ["following", "attending", "pursuing"],
    "protestor,protesto": ["declare", "in", "public", "affirm", "bear", "witness"],
    "vultus,": ["vultus", "expression", "face", "countenance", "look", "aspect"],
    "incipio": ["take", "in", "hand", "begin", "commence"],
    "plusculus": ["somewhat", "more", "rather", "more"],
    "concepta": ["measures", "capacity"],
    "voluptas,": ["voluptas", "pleasure"],
    "reluctor": ["struggle", "against", "resist"],
    "prosum,profuturus": ["be", "useful", "benefit", "do", "good"],
    "lenocinor": ["pander", "flatter", "make", "up", "promote", "advance"],
    "aperte": ["openly", "frankly"],
    "suggero": ["bring", "up", "supply", "provide", "add", "attach", "place", "next"],
    "gigno,genuit": ["bring", "forth", "bear", "beget", "father"],
    "diu": ["long", "while", "long", "time", "for", "long", "time"],
    "infortunatus": ["unfortunate", "unhappy", "unlucky"],
    "coaegresco": ["become", "sick", "at", "same", "time"],
    "cetera": ["for", "rest", "otherwise"],
    "villa": ["country", "house", "country", "estate", "med", "manor", "village"],
    "sum,fui,futurus": ["sum", "be", "exist"],
    "immodicus": ["immoderate", "excessive", "beyond", "measure"],
    "ceteri": ["remaining", "rest", "others"],
    "magnus,maior,maximus": ["magnus", "large", "great", "important"],
    "cavus": ["hole", "pit"],
    "impedimentum": ["hindrance", "impediment", "obstacle", "difficulty"],
    "nusquam": ["nowhere", "in", "no", "place", "nothing", "for", "nothing", "never"],
    "placitum": ["accord", "agreement", "pact", "assembly", "for", "judgment"],
    "crur,cruris": ["leg", "shank", "shin", "also", "foot"],
    "allatus,adfero": ["having", "been", "brought"],
    "vis,vires": ["pl", "force", "power", "strength", "might", "influence"],
    "repente": ["suddenly", "unexpectedly"],
    "navis,navis": ["ship", "vessel", "boat"],
    "nomine,tenus,nominetenus": ["nomine", "as", "far", "as", "meaning", "word", "extends"],
    "exitium": ["destruction", "ruin"],
    "vomer,": ["plowshare"],
    "discedo": ["discessum", "break", "up", "depart", "go", "away", "pass", "away"],
    "sumptus": ["expense", "cost"],
    "curso": ["run", "back", "forth"],
    "infidus": ["untrue", "disloyal"],
    "servitus": ["servitude", "slavery"],
    "addo": ["give", "bring", "place", "inspire", "cause", "add", "join"],
    "frequentatio": ["frequency", "crowding"],
    "subitus": ["sudden", "unexpected"],
    "casso": ["bring", "naught", "destroy", "annul", "make", "void"],
    "ille,illa,illud": ["ille", "that", "former", "famous", "he", "she", "it"],
    "infesto": ["attack", "disquiet"],
    "pactum": ["agreement", "contract", "covenant", "pact"],
    "digressus": ["separation", "departure", "digression"],
    "torqueo": ["twist", "curl", "rack", "torture", "torment", "distort", "test"],
    "aliquanta": ["moderate", "some", "size"],
    "aliquanto": ["somewhat", "considerably"],
    "lactuca": ["lettuce"],
    "timidus": ["fearful", "timid"],
    "tabella": ["writing", "tablet"],
    "vulgo,": ["vulgo", "spread", "publish", "impart", "make", "accessible"],
    "modio": ["grain", "measure", "bushel", "basket"],
    "culpo": ["blame", "censure", "accuse"],
    "salutor": ["visitor", "caller"],
    "peregrinus": ["wanderer", "foreigner", "stranger", "pilgrim", "crusader"],
    "scribo,scripsi,scriptum": ["scribo", "write", "compose"],
    "tero,trivi,tritum": ["tero", "rub", "wear", "out"],
    "culpa": ["fault", "blame", "esp", "against", "chastity"],
    "coerceo": ["surround", "enclose", "restrain", "confine"],
    "feliciter": ["happily"],
    "necdum,neque,dum": ["not", "yet"],
    "infeste": ["in", "hostile", "manner", "belligerently"],
    "ustilo": ["burn"],
    "macellarius": ["butcher", "slaughter-house"],
    "quercus": ["oak", "tree"],
    "nosco": ["become", "acquainted", "with", "get", "know"],
    "extollo": ["lift", "up", "raise", "up", "erect", "elevate", "exalt"],
    "instar": ["form", "figure", "after", "fashion", "like"],
    "rursus": ["on", "other", "hand", "in", "return", "back", "again"],
    "compes,compedis": ["fetters", "shackles", "chained"],
    "purus": ["pure", "free", "from"],
    "labefacio,labefeci,labefactum": ["labefacio", "shake", "loosen", "impair"],
    "modus": ["measure", "bound", "limit", "manner", "method", "mode", "way"],
    "canis": ["dog"],
    "vergo": ["bend", "incline", "verge", "draw", "an", "end"],
    "post": ["after", "behind"],
    "demergo": ["sink", "plunge", "into", "dip", "under", "go", "indebt"],
    "iam": ["moreover", "henceforth", "indeed", "just", "further"],
    "dubium": ["doubt", "hesitation", "reservation"],
    "praeteritus,preteritus": ["past"],
    "super": ["adv", "over", "above", "besides", "beyond", "moreover", "remaining"],
    "insideo": ["sit", "upon", "something", "be", "firmly", "placed"],
    "consummatio": ["completion", "summing", "up", "adding", "up"],
    "punctum": ["prick", "little", "hole", "puncture", "point", "spot", "place"],
    "oppono,opposui,oppositum": ["oppono", "set", "against", "oppose", "be", "opposite"],
    "provisor": ["one", "who", "provides", "for", "against"],
    "pulvis": ["dust", "powder", "arena", "scene", "action"],
    "intellego,intellexi,intellectum": ["intellego", "understand", "comprehend", "see"],
    "infinitus": ["unlimited", "infinite", "without", "bounds", "boundless", "limitless"],
    "omitto": ["omit", "leave", "out", "let", "go"],
    "virtus": ["manliness", "excellence", "character", "worth", "courage"],
    "cognosco": ["examine", "inquire", "learn"],
    "munitio": ["fortifying", "defense", "works", "bridging", "fortification"],
    "adverto": ["turn", "towards", "direct", "one's", "attention", "attract"],
    "curriculum": ["running", "race", "lap", "around", "track", "course"],
    "superne": ["from", "above", "above"],
    "tandem": ["at", "last", "finally"],
    "inda": ["cornelism", "anster"],
    "similis": ["similar", "like", "resembling"],
    "carus": ["dear", "beloved", "costly", "high-priced", "expensive"],
    "orator": ["orator", "speaker"],
    "ventus": ["wind"],
    "promulgatio": ["publication", "promulgation", "of", "law"],
    "poema,poematis": ["poem", "verse", "rhyme"],
    "exsequor,exequor": ["follow", "grave", "follow", "end"],
    "triumphus": ["triumphal", "procession", "triumph"],
    "ibi": ["there"],
    "brachants": ["brabant"],
    "commisceo": ["intermingle", "join", "mix"],
    "pluo": ["rain", "shower", "sprinkle"],
    "efficio": ["do", "produce", "effect", "make", "bring", "about", "cause", "prove"],
    "conversatio": ["way", "manner", "life", "monastic", "life"],
    "privo": ["deprive"],
    "foveo,fovi,fotum": ["foveo", "cherish"],
    "vigor": ["vigor", "liveliness"],
    "districtus,fr,distringo": ["strict", "severe", "hesitating", "busy"],
    "aurum": ["gold"],
    "nemo": ["no", "one", "nobody"],
    "liberatio": ["release", "liberation", "acquittal", "setting", "free"],
    "puniceus": ["purple", "red"],
    "galea": ["helmet"],
    "evito": ["shun", "avoid;", "also", "kill"],
    "elemosinarius": ["almoner", "person", "in", "charge", "providing", "charity"],
    "puppis": ["stern", "ship", "poop"],
    "phitonicum": [],
    "vesco,vescor": ["feed", "eat"],
    "numquam": ["at", "no", "time", "never"],
    "strues": ["piles", "heaps", "masses"],
    "triduana": ["lasting", "three", "days"],
    "perterreo": ["terrify"],
    "parco": ["inf:", "forbear", "to", "avoid", "spare", "keep", "oneself", "from"],
    "panis,panis": ["bread"],
    "eloquens": ["eloquent", "persuasive", "fluent"],
    "promiscus,promiscuus": ["mixed", "indiscriminate", "commonplace", "usual"],
    "praefero,prefero": ["anticipate", "carry", "by", "ride", "by"],
    "infector": ["dyer"],
    "eripio": ["eripui", "ereptum", "snatch", "away", "take", "away", "rescue"],
    "fateor": ["confess", "admit", "allow", "reveal", "make", "known"],
    "paupertas": ["beggardry", "poverty", "humble", "circumstances"],
    "concipio": ["take", "lay", "hold", "receive", "take", "in"],
    "levo": ["raise", "lift", "up", "relieve", "ease", "diminish", "weaken", "impair"],
    "quantuslibet": ["as", "much", "as", "you", "will", "as", "great", "as", "you", "will"],
    "etenim": ["for", "indeed"],
    "iussu": ["abl", "at", "command", "by", "order", "of"],
    "placide": ["quitely", "gently"],
    "paternus": ["of", "father", "paternal", "native"],
    "dignosco,dignosco": ["distinguish", "recognize", "as", "different"],
    "cubitum,ire": ["go", "bed", "retire"],
    "neco": ["kill", "slay", "put", "death"],
    "opto": ["desire", "wish", "for", "want"],
    "sperno,sprevi,spretum": ["sperno", "scorn", "despise", "spurn"],
    "oculus": ["eye"],
    "facile": ["easily"],
    "proximus": ["nearest", "closest", "next"],
    "sanctimonialis": ["nun"],
    "irrito": ["irritate", "exasperate", "excite"],
    "si": ["if"],
    "concupisco": ["covet", "aim", "at", "desire", "eagerly"],
    "pudicus": ["modest", "chaste"],
    "sanctifico": ["sanctify", "make", "holy"],
    "letifer": ["deadly", "mortal"],
    "pervenio": ["reach", "attain", "reach", "be", "passed", "to"],
    "differo": ["delay", "postpone", "differ", "be", "different"],
    "possessio": ["possession", "property"],
    "jaculum": ["dart", "javelin"],
    "quisquis": ["whoever", "whatever", "whatsoever", "anything", "at", "all"],
    "dulcidine": ["sweetly", "pleasantly", "charmingly"],
    "fere": ["almost", "nearly", "not", "quite", "generally"],
    "ianua": ["door"],
    "firmus": ["firm", "strong", "reliable", "solid"],
    "forma": ["form", "shape", "beauty"],
    "lenimentus": ["alleviation", "improvement", "mitigation"],
    "laetor,letor": ["rejoice", "be", "joyful"],
    "subsequor": ["follow", "after"],
    "formo": ["shape", "form", "fashion"],
    "offero": ["bring", "forward", "place", "before", "present", "offer", "expose"],
    "verumtamen,verumptamen": ["notwithstanding", "nevertheless"],
    "faveo": ["dat", "be", "favorable", "aid", "support", "help", "fawning", "like", "that", "dog", "cringing", "flattery"],
    "absens,absentis": ["absent", "missing", "away", "gone"],
    "officina": ["workshop", "factor"],
    "illas": ["fem", "pl", "they", "gave", "those", "their", "lives", "for", "faith"],
    "profugus": ["fleeing", "fugitive", "banished", "migratory"],
    "non": ["not"],
    "perdo": ["destroy", "ruin", "waste", "scatter", "squander"],
    "minuo,minui,minutum": ["minuo", "less", "diminish", "decrease", "grow", "smaller"],
    "heniis,harniis": ["hames"],
    "contemplatio": ["survey", "contemplation"],
    "monasteriense": ["munster"],
    "detrimentum": ["damage", "loss", "detriment"],
    "commemoro": ["remind", "relate", "mention"],
    "manus,manus": ["hand", "band", "handwriting"],
    "suus,sua,suum": ["refl", "poss", "adj", "his", "her", "its", "their", "own"],
    "oblivio": ["forgetfulness", "oblivion"],
    "exhorresco": ["be", "horrified", "shake", "shudder", "dread", "tremble", "at"],
    "nos": ["us", "they", "tried", "tell", "us", "we're", "too", "young"],
    "tenuis": ["thin", "slight", "feeble", "slim", "slender"],
    "obduro": ["be", "hard", "persist", "endure", "last", "hold", "out"],
    "creatura": ["creature", "servant"],
    "opera": ["work", "pains", "labor"],
    "sopor": ["deep", "sleep"],
    "avarus": ["greedy", "avaricious"],
    "nimirum": ["of", "course", "undoubtedly", "certainly", "sometimes", "ironical"],
    "thymum": ["herb", "thyme"],
    "mitesco": ["grow", "mild", "ameliorate"],
    "vetus": ["old"],
    "olim": ["at", "that", "time", "formerly", "once", "for", "long", "time", "now"],
    "sato": ["sow", "plant"],
    "acceptus": ["welcome", "pleasant", "agreeable"],
    "incubo": ["hang", "over", "dwell", "in", "lie", "heavily", "upon"],
    "aeternus,eternus": ["eternal", "everlasting", "without", "end"],
    "compatior": ["suffer", "with", "one", "feel", "pity", "have", "compassion"],
    "volo,": ["volo", "wish", "want", "will", "ordain", "suppose", "maintain", "that", "be", "willing"],
    "divinus": ["divine", "sacred"],
    "cernuus": ["falling", "headlong"],
    "labor,laboris": ["labor", "work", "toil"],
    "auctor": ["author", "originator"],
    "civis": ["citizen", "townsman", "bourgeois", "burgess"],
    "seputus": ["buried", "sunk", "immersed"],
    "vindico,vindicatum": ["claim", "arrogate", "assume", "appropriate"],
    "querulus": ["complaining", "whining", "lamenting"],
    "grando,onis": ["hailstorm"],
    "ex": ["e", "prep", "abl", "out", "from", "within", "from", "on", "account", "of"],
    "pessum,do": ["destroy", "ruin", "wreck"],
    "subiungo": ["yoke", "beneath", "join", "attach", "subdue", "subjugate"],
    "suppellex,suppellectilus": ["household", "articles", "furniture", "goods"],
    "innotesco": ["become", "know", "noted"],
    "adipiscor": ["come", "up", "overtake", "obtain"],
    "punitor": ["punisher", "avenger"],
    "pluvialis": ["pertaining", "rain", "rain"],
    "excrucio": ["torment", "torture", "cause", "great", "pain"],
    "summopere": ["very", "much", "exceedingly"],
    "damnatio": ["condemnation"],
    "voluntas,": ["voluntas", "last", "will", "testament", "meaning", "sense"],
    "sursum": ["upwards", "up", "down"],
    "fulcio": ["support", "strengthen", "uphold", "besiege", "oppress"],
    "quare": ["wherefore", "why", "because", "which", "thing"],
    "patior": ["suffer", "endure", "permit"],
    "repetitio": ["repetition"],
    "suasoria": ["persuasive", "discourse"],
    "consto": ["be", "established", "stand", "firm", "stop", "endure"],
    "oro": ["speak", "argue", "plead", "orate", "beg", "entreat"],
    "nonnullus": ["some", "pl", "several"],
    "deludo": ["mock", "cheat"],
    "pervideo,pervidi,pervisum": ["pervideo", "look", "over", "survey", "inspect", "discern"],
    "equidem": ["adv", "indeed", "truly", "for", "my", "part"],
    "paries,parietis": ["wall"],
    "praecox,precox": ["ripe", "beforehand", "premature"],
    "insciens": ["unknowing", "unaware", "ignorant"],
    "gusto": ["taste"],
    "ministro": ["attend", "wait", "upon", "assist"],
    "excellentia": ["excellence", "merit", "worth"],
    "proventus": ["growing", "up", "increase", "crop", "yield", "issue"],
    "impenetrabiilis": ["impenetrable"],
    "placo": ["placate", "appease"],
    "opes": ["pl", "means", "wealth", "abundance", "riches", "resources"],
    "maiores": ["pl", "ancestors"],
    "audax": ["bold"],
    "queritor": ["complain", "excessively", "whine", "gripe"],
    "incassum": ["in", "vain"],
    "consido": ["set", "down", "settle"],
    "tempus,temporis": ["time"],
    "vicinus": ["neighbor", "med", "resident"],
    "silens": ["silent", "still"],
    "lactans": ["giving", "milk"],
    "tollo,sustuli,sublatum": ["tollo", "lift", "up", "raise", "elevate", "carry", "away"],
    "otium": ["ease", "leisure", "inactivity"],
    "insequor": ["follow", "pursue", "assail", "reproach", "rebuke", "attack"],
    "labia,labium": ["labia", "labium:lip", "labiae:", "lips"],
    "tepesco": ["cool", "grow", "lukewarm", "decrease"],
    "paciscor": ["make", "bargain", "agreement", "covenant", "deal"],
    "purgatio": ["cleaning", "out", "cleansing", "excsuing", "justification"],
    "obsequium": ["indulgence", "pliancy", "submission"],
    "breviter": ["briefly"],
    "surgo,surrexi,surrectum": ["surgo", "get", "up", "arise"],
    "aranea": ["spider's", "web"],
    "venio,veni,ventum": ["venio", "come"],
    "expugno": ["capture", "overcome", "subdue", "take", "by", "storm", "gain"],
    "interdico": ["forbid", "prohibit", "interdict"],
    "excusatio": ["excuse"],
    "similitudo": ["likeness", "resemblance", "uniformity"],
    "advenio": ["come", "arrive", "reach"],
    "cervus": ["stag", "deer"],
    "plerumque": ["for", "most", "part", "generally", "commonly", "mostly"],
    "quam": ["fem", "sing", "church", "which", "lord", "loved"],
    "gratus": ["pleasing", "agreeable", "grateful"],
    "sodalitas": ["fellowship", "companionship", "secret", "society"],
    "mansuetus": ["mild", "soft", "gentle"],
    "labruscum": ["wild", "grape"],
    "quae": ["fem", "pl", "nom", "let", "those", "women", "who", "have", "ears", "hear", ""],
    "tempero": ["dat", "control", "use", "with", "moderation", "spare"],
    "inventor": ["inventor", "discoverer"],
    "requiro": ["ask", "for", "look", "for", "demand", "desire", "miss"],
    "brabatensium": ["brabant"],
    "eminor": ["threaten", "menace"],
    "proficiscor": ["depart", "set", "out", "start", "forward", "arise"],
    "impendo": ["lay", "out", "expand", "weigh", "out"],
    "maeror,meror": ["mourning", "grief", "sorrow"],
    "werumensium": ["wittewierum"],
    "nolo,nolle,nolui": ["nolo", "be", "unwilling", "wish", "not", "refuse"],
    "volaticus,": ["volaticus", "winged", "flying", "inconstant", "unreliable", "flighty"],
    "furibundus": ["raging", "furious", "inspired"],
    "sero": ["sow", "plant", "also", "late", "at", "late", "hour"],
    "instituo": ["establish", "found", "institute"],
    "sublime": ["on", "high", "aloft"],
    "ait": ["he", "says"],
    "temptatio": ["trial", "temptation"],
    "grassor": ["go", "about", "go", "ahead", "proceed", "attack"],
    "admiratio": ["wonder", "astonishment", "surprise", "admiration"],
    "periurium": ["perjury", "oath-breaking", "forswearing", "an", "oath"],
    "praesto,presto": ["praespresto:", "do", "perform", "display", "fulfill", "offer", "present"],
    "rotundus": ["wheel-shaped", "round"],
    "ascisco": ["receive", "admit", "adopt", "take", "up", "approve"],
    "synagoga": ["synagogue"],
    "talis": ["of", "such", "kind", "such"],
    "promereo,promereor": ["deserve", "merit"],
    "coruscus": ["a", "flashing", "twinkling", "shaking", "trembling"],
    "lambo": ["lick", "of", "rivers", "wash"],
    "quibus": ["fem", "pl", "abl", "beards", "by", "which", "pirates", "were", "known"],
    "misceo,miscui,mixtum": ["misceo", "mix", "mingle", "blend"],
    "editio": ["publishing", "book", "an", "announcement"],
    "ingravesco": ["become", "heavy", "become", "burden"],
    "perseco": ["cut", "through", "dissect", "cut", "away"],
    "novitas": ["newness", "novelty", "strangeness"],
    "nota": ["mark", "token", "note", "sign"],
    "conicio": ["hurl", "throw", "put", "together", "conjecture"],
    "praestans,prestans": ["excellent", "distinguished", "imminent"],
    "deus": ["god"],
    "rusticus": ["rustic", "rural", "peasant"],
    "recuperatio": ["recovery", "recuperation"],
    "summisse": ["humbly", "softly", "calmly", "modestly"],
    "petitus": ["inclining", "toward"],
    "argumentum": ["proof", "evidence"],
    "dexter": ["right", "on", "right"],
    "ipse,ipsa,ipsum": ["ipse", "himself", "herself", "itself"],
    "malo,mallui,malus": ["malo", "choose", "prefer"],
    "asper": ["rough", "harsh", "severe"],
    "abundantia": ["abundance", "bounty", "plenty"],
    "spolio": ["strip", "plunder", "despoil", "rob", "loot"],
    "quereia,querella": ["complaint", "complaining"],
    "placidus": ["quiet", "still", "gentle"],
    "exheredo": ["disinherit"],
    "promoveo,promovi,promotum": ["promoveo", "push", "forward", "move", "ahead", "advance"],
    "concutio": ["shake", "together", "agitate", "alarm", "disturb", "shatter"],
    "dolor": ["pain", "grief", "misery", "pain", "suffering"],
    "superfluo": ["flow", "over", "overflow", "be", "superfluous"],
    "prout": ["just", "as", "according", "to"],
    "annus": ["year"],
    "depromo": ["take", "down", "produce", "fetch", "out"],
    "depulso": ["push", "aside", "thrust", "away"],
    "rhetor": ["rhetorician", "teacher", "rhetoric"],
    "opprimo,oppressi,oppressum": ["opprimo", "suppress", "overwhelm", "overpower", "check"],
    "sonitus": ["noise", "sound"],
    "campana": ["bell"],
    "exitus": ["going", "out", "going", "forth", "exit", "end", "finish"],
    "congregatio": ["assembly", "society", "union"],
    "fero,tuli,latum": ["fero", "carry", "bring", "tell", "relate", "much", "else"],
    "corruo": ["fall", "ground", "sink", "down", "be", "ruined", "destroyed"],
    "testis": ["one", "who", "gives", "evidence", "witness", "spectator", "testicle"],
    "extremus": ["outermost", "last", "extreme"],
    "ratio": ["reckoning", "account", "reason", "judgment", "consideration"],
    "consilium": ["advice", "suggestion", "wisdom", "plan", "purpose", "judgment"],
    "plurimi": ["at", "highest", "price", "highest", "worth"],
    "quam,plures": ["as", "many", "as", "possible"],
    "perduco": ["lead", "through", "conduct", "carry", "through"],
    "pluma": ["feather", "featherbed", "pen"],
    "dico": ["dictum", "", "say", "tell", "speak", "name", "call", "pronounce"],
    "prex,precis": ["request", "entreaty", "prayer"],
    "disputo": ["discuss"],
    "praeficio,preficio,prefeci,prefectum": ["praeficio", "preficio", "put", "in", "charge", "of"],
    "adulescentia": ["youth"],
    "pactus": ["agreed-upon", "stipulated", "betrothed"],
    "promineo": ["stand", "out", "jut", "extend"],
    "parens,parentis": ["parent"],
    "utroque": ["both", "sides", "in", "both", "directions", "at", "each", "point"],
    "exsertus,exertus": ["project", "thrust", "forward"],
    "quamtotius": ["?", "completely"],
    "administratio": ["giving", "help", "administration", "government"],
    "commoveo": ["move", "violently", "disturb", "shake", "excite", "upset"],
    "litigo": ["quarrel", "dispute"],
    "laudunum": ["laon"],
    "digestor": ["arranger", "composer", "one", "who", "makes", "pattern"],
    "picea": ["spruce", "tree"],
    "forsit,forsan,forsitan": ["forsit", "perhaps", "probably"],
    "oppugno": ["fight", "against", "attack", "assault", "assail"],
    "pendo": ["weigh", "value", "consider", "judge", "esteem"],
    "usitas": ["customary", "usual"],
    "tardus": ["slow", "late", "tardy"],
    "primo": ["first", "at", "first", "at", "beginning", "at", "start"],
    "discidium": ["separation", "division", "disagreement", "tearing", "apart"],
    "gladius": ["sword"],
    "despiciens": ["contemptuous"],
    "iste,ista,istud": ["iste", "that", "sometimes", "pejorative"],
    "incredibilis": ["incredible", "unbelievable"],
    "quinquennis": ["five", "years", "old"],
    "inclutus,inclitus": ["celebrated", "famous", "renowned"],
    "thesis": ["proposition", "thesis"],
    "concido": ["be", "ruined", "fail", "cut", "up", "cut", "down", "destroy"],
    "construo,construxi,constructum": ["construo", "construct", "build", "arrange"],
    "volens,": ["volens", "willing", "favorable"],
    "inquit": ["he", "she", "it", "says"],
    "poena": ["pain", "punishment", "penalty", "pay", "penalty"],
    "laboro": ["trans", "work", "out", "prepare", "arrange", "form", "elaborate"],
    "promeritum": ["desserts", "promise"],
    "pluris": ["gen", "at", "higher", "price", "great", "value"],
    "dives": ["rich", "opulent", "wealthy"],
    "vita": ["life", "way", "life"],
    "concero": ["connect", "join", "twine", "join", "in", "conflict"],
    "ebullio": ["boil", "up", "bubble", "up", "appear", "produce", "in", "abundance"],
    "incito": ["excite", "spur", "inspire", "increase", "hasten", "urge", "on"],
    "niveus": ["white", "snowy"],
    "saepenumero": ["repeated", "again", "again"],
    "improbus": ["inferior", "bad", "wicked", "persistent", "perverse", "bold"],
    "infirmatio": ["weakening", "refusing", "invalidating"],
    "creber": ["thick", "frequent", "numerous"],
    "diruo": ["demolish", "destroy", "ruin"],
    "tantus": ["so", "large", "so", "great", "such", "size"],
    "illiam": ["fem", "sing", "she", "wasted", "that", "her", "youth"],
    "tantum": ["only"],
    "ambitus": ["border", "edge", "extent", "going", "around", "circuit"],
    "sanctus,eleutherius": ["st", "eligius"],
    "aliquando": ["at", "any", "time", "sometimes", "occasionally", "at", "last"],
    "contego": ["cover", "shield", "protect", "defend"],
    "lenocinium": ["enticement", "allurement"],
    "nullus": ["not", "any", "no", "none"],
    "quondam": ["formerly", "once", "at", "one", "time", "erstwhile"],
    "tui": ["your", "yours", "i", "read", "your", "letter", "that", "said", "dear", "john"],
    "tum": ["at", "that", "time", "then", "thereupon", "in", "next", "place"],
    "inflecto,inflexi,inflectum": ["bend", "bow", "curve"],
    "auxatia": ["alsace"],
    "clarus": ["clear", "bright", "renowned", "famous", "illustrious"],
    "dirunitas": ["long", "duration"],
    "infirmus": ["not", "strong", "weak", "feeble", "sometimes", "sick", "ill"],
    "demum": ["at", "length", "at", "last", "finally"],
    "idcirco": ["on", "that", "account", "for", "that", "reason", "for", "that", "purpose"],
    "canto": ["sing"],
    "diluculo": ["dawn", "daybreak"],
    "primum": ["at", "first", "for", "first", "time", "in", "first", "place"],
    "mane": ["morning", "early", "in", "morning", "early"],
    "pro,eo": ["because", "fact", "because", "for", "this", "reason"],
    "singulus": ["single", "separate", "one", "at", "time", "one", "each"],
    "thymbra": ["herb", "savory"],
    "animus": ["character", "intellect", "memory", "consciousness", "often", "mind"],
    "considero": ["look", "at", "regard", "carefully"],
    "creptio": ["taking", "by", "force", "seizure"],
    "colloco": ["place", "put", "arrange"],
    "minime": ["in", "least", "degree", "very", "little", "not", "at", "all", "by", "no", "means"],
    "navigatio": ["voyage", "navigation"],
    "color": ["color"],
    "maculosus": ["spotted", "speckled", "polluted"],
    "desino,desiit": ["leave", "off", "give", "over", "cease", "stop", "desist"],
    "cuiusmodi": ["of", "what", "kind"],
    "requiesco,requievi,requietum": ["requiesco", "rest"],
    "graviter": ["heavily", "seriously"],
    "cometissa,comitissa": ["countess"],
    "dux,ducis": ["leader", "guide", "commander", "general", "duke"],
    "infitias,ire": ["deny"],
    "ante": ["prep", "before", "in", "front", "adv", "before", "previously"],
    "temeritas": ["rashness", "temerity"],
    "hic,haec,hec,hoc": ["hic", "haec", "hec", "", "hoc:", "this", "latter", "he", "she", "it"],
    "praesidium,presidium": ["guard", "garrison", "detachment", "protection"],
    "fortasse": ["perhaps"],
    "concedo": ["concede", "yield", "allow", "grant", "withdraw", "give", "up"],
    "mensa": ["table"],
    "cupido": ["passion", "desire", "wanting", "yearning", "longing"],
    "quinam,quaenam,quenam,quodnam": ["quinam", "quaenam", "which?", "what?"],
    "velut": ["just", "as", "like", "even", "as"],
    "acies": ["keenness", "edge", "sharpness", "battle-line", "battlefield"],
    "quater": ["four", "times", "again", "again"],
    "renuntio": ["declare", "announce", "report", "give", "notice"],
    "velum": ["sail", "covering", "awning", "curtain"],
    "prorsus": ["forward", "straight", "ahead", "sum", "up", "utterly", "wholly"],
    "dictator": ["dictator"],
    "desparatus": ["given", "up", "on", "desperate"],
    "careo": ["abl", "sep", "be", "without", "be", "deprived", "lack", "want"],
    "fructuarius": ["fruitful", "fertile"],
    "industria": ["industry", "diligence"],
    "rependo": ["ransom", "pay", "back", "requite"],
    "superficies": ["surface", "top"],
    "iratus": ["angry", "wrathful"],
    "malbodiensis": ["maubeuge"],
    "aliquot": ["some", "several"],
    "ornatus": ["dress", "attire", "equipment", "ornament", "embellishment"],
    "rus,ruris": ["country", "countryside", "rural", "area"],
    "emineo": ["stand", "out", "project", "be", "remarkable", "conspicuous"],
    "loginquitas": ["distance", "remoteness", "isolation"],
    "multum": ["much", "greatly"],
    "interrogatio": ["interrogation", "inquiry"],
    "repono": ["deposit", "lay", "up", "store", "requite"],
    "prenda": ["booty", "loot", "stolen", "goods"],
    "summa": ["highest", "part", "whole", "sum"],
    "flumen": ["river"],
    "impero": ["give", "orders", "command", "rule", "hold", "sway"],
    "propinquus": ["near", "close", "similar", "nearly", "related"],
    "taedium,tedium": ["disgust", "weariness", "boredom"],
    "alter": ["adv", "otherwise"],
    "absconditus": ["hidden", "concealed"],
    "mors,mortis": ["death"],
    "servus": ["slave", "serf"],
    "crux,crucis": ["cross"],
    "pertraho": ["drag", "forcibly", "conduct", "entice", "allure"],
    "perperam": ["wrongly", "falsely"],
    "versus": ["line", "verse"],
    "cicuta": ["hemlock"],
    "denuntio": ["announce", "officially", "pronounce", "declare"],
    "securus": ["safe", "secure", "free", "from", "care", "unworried", "unconcerned"],
    "eatenus": ["so", "far", "thus", "far", "up", "then"],
    "angustus": ["narrow", "limited", "strait", "tight", "constricted"],
    "glorior": ["glory", "boast", "pride", "oneself"],
    "gestum,gero": ["carriage", "bearing", "having", "borne"],
    "fama": ["talk", "report", "rumor", "tradition"],
    "obligatus": ["bound", "under", "an", "obligation"],
    "purgo": ["clean", "cleanse", "purify", "clear", "away", "wash", "off", "justify"],
    "inflo": ["blow", "in", "inspire", "puff", "up", "elate"],
    "par": ["equal", "like"],
    "ovis,ovis": ["sheep"],
    "erudio": ["instruct", "teach", "educate"],
    "doctor": ["teacher"],
    "narro": ["make", "known", "say", "speak", "narrate"],
    "supra": ["above"],
    "exhilaro": ["make", "cheerful"],
    "ignosco": ["dat", "overlook", "forgive", "pardon"],
    "deprimo,depressus": ["press", "down", "depress", "low-lying"],
    "labrum": ["lip", "edge", "rim", "bathing", "tub"],
    "praeconor,preconor": ["be", "public", "crier", "herald", "proclaim"],
    "madidus": ["wet", "moist", "soaked", "boiled", "soft", "drunk", "dyed", "steeped"],
    "pullus": ["young", "animal", "chicken", "chick"],
    "effugio": ["effugi", "effugiturus", "flee", "from", "escape", "elude", "run", "away"],
    "obstinatus": ["firm", "resolved", "staunch"],
    "transeo": ["go", "over", "pass", "over", "cross", "over", "go", "past"],
    "commodo": ["make", "fit", "adapt", "please", "oblige", "serve"],
    "proluvier": ["inundation", "scouring", "discharge"],
    "publicus": ["of", "people", "public", "open", "all"],
    "statua": ["statue"],
    "precipue": ["chiefly", "especially", "particularly"],
    "delicate": ["adv", "luxuriously"],
    "reverto": ["go", "back", "return", "revert"],
    "statuo": ["cause", "stand", "establish", "place", "set", "up"],
    "prognatus": ["born", "sprung", "from", "son"],
    "odium": ["hatred"],
    "defero": ["hand", "over", "carry", "down", "communicate", "offer", "refer"],
    "conor": ["undertake", "try", "venture", "presume", "attempt"],
    "nutus": ["nod", "command", "will", "gravitation", "movement", "down"],
    "no": ["nare", "navi", "swim", "float", "fly", "sail"],
    "distulo": ["past", "delay"],
    "comprovincialis": ["born", "in", "same", "province"],
    "decipio": ["deceptus", "ensnare", "trap", "beguile", "deceive", "cheat"],
    "latus,-eris": ["latus", "-eris:", "sides", "flank", "lungs", ""],
    "inruo,irruo": ["rush", "in", "fling", "in"],
    "obicio,obieci,obiectum": ["obicio", "offer", "throw", "in", "someone's", "teeth"],
    "solvo": ["loosen", "untie", "release", "free", "dissolve", "break", "up"],
    "satis": ["enough", "sufficient", "sufficiently"],
    "munimentum": ["fortification", "protection", "defenses"],
    "adversus": ["facing", "opposite", "opposing"],
    "deprehensio": ["detection"],
    "inritus,irritus": ["void", "invalid", "in", "vain", "useless", "ineffectual"],
    "fungor,fungi,functus": ["fungor", "occupy", "oneself", "perform", "do", "execute"],
    "putus": ["pure", "unmixed", "unadulterated"],
    "proprius": ["one's", "own", "permanent", "special", "peculiar"],
    "consueta": ["customary", "usual"],
    "qui,quae,que,quod": ["qui", "quae", "which", "what", "that"],
    "decerno": ["decide", "determine", "settle"],
    "satio": ["satisfy", "sate"],
    "moneo": ["warn", "admonish", "remind", "advise", "instruct"],
    "demulceo": ["stroke", "down", "caress", "by", "stroking"],
    "dolosus": ["crafty", "cunning", "sly", "deceitful"],
    "invictus": ["unconquer", "unconquerable", "undefeated"],
    "ceterum": ["adv", "otherwise", "moreover", "but"],
    "defaeco": ["cleanse", "purify", "purge"],
    "praedico,predico": ["warn", "admonish", "instruct", "foretell"],
    "uticensium": ["evroul"],
    "caecus": ["blind", "sightless"],
    "odio": ["hate", "despite", "hold", "in", "contempt", "dislike", "strongly"],
    "hinc": ["from", "this", "place", "hence"],
    "praetorgredior,pretergredior": ["pass", "beyond", "go", "beyond"],
    "supersum": ["be", "superfluous", "remain"],
    "detego,detectum": ["uncover", "lay", "bare", "disclose"],
    "induco,indux,inductum": ["induco", "lead", "in", "introduce", "induce", "influence"],
    "hodiernus": ["of", "today"],
    "mox": ["soon", "presently", "then", "thereupon"],
    "atavus": ["great-great-great", "grandfather", "ancestor"],
    "amo": ["love", "like", "be", "fond", "cherish"],
    "vacuus": ["empty", "devoid", "free", "from"],
    "courtacum": ["courtrai"],
    "excessum": ["departure", "death", "digression"],
    "sordeo": ["be", "dirty", "appear", "vile"],
    "egenus": ["in", "want", "in", "need", "destitute"],
    "sumo": ["take", "choose", "obtain", "buy", "take", "for", "granted", "assume"],
    "imitor": ["imitate"],
    "pocius,potius": ["rather", "preferably"],
    "fortuna": ["fortune", "luck", "fate", "chance"],
    "clam": ["secretly", "in", "secret"],
    "patronus": ["patron", "protector"],
    "malum": ["evil", "misfortune", "misdeed", "crime", "injury", "damage"],
    "conitor": ["press", "upon", "struggle", "reach"],
    "inceptor": ["beginner"],
    "una": ["adv", "in", "one", "together"],
    "pertorqueo": ["twist", "distort"],
    "mons,montis": ["mountain", "mount"],
    "praesentia,presentia": ["presence", "presence", "mind", "effect", "power"],
    "adamo": ["fall", "in", "love", "with", "find", "pleasure", "in"],
    "inter": ["between", "among"],
    "pallium": ["coverlet", "mantle", "cloak"],
    "pestis,pestis": ["plague", "epidemic", "pestilence", "destruction", "curse"],
    "constituo": ["arrange", "decide", "appoint", "settle", "found", "set", "up"],
    "argentum": ["silver", "money"],
    "quarum": ["fem", "pl", "gen", "their", "envy", "jealousy", "which", "we", "know"],
    "improvidus": ["improvident", "negligent", "thoughtless", "feckless"],
    "praesum,presum": ["be", "at", "head", "be", "in", "charge", "of"],
    "gravatus": ["sick", "oppressed", "ill"],
    "adflicto,affligo": ["injure", "weaken", "discourage", "damage", "break"],
    "pono,posui,positum": ["pono", "lay", "place", "put", "set", "milit", "post", "station"],
    "utrimque": ["from", "both", "sides", "on", "both", "sides"],
    "plector": ["be", "punished"],
    "regina": ["queen"],
    "eluvio": ["inundation"],
    "pepulo": [],
    "frux,frugi": ["fruits", "earth"],
    "provideo": ["foresee", "provide", "make", "provision", "for"],
    "matera,mairia": ["?vat", "for", "fermentation", "beer"],
    "deficio": ["fail", "weaken", "be", "in", "want"],
    "vapulus": ["flogged", "beaten", "knocked", "about"],
    "sano": ["heal"],
    "pulmentum": ["anything", "eaten", "with", "bread", "sauce", "relish"],
    "inflatus": ["blowing", "into", "blast", "inspiration"],
    "tubineus": ["cone", "shaped"],
    "retraho,retraxi,retractum": ["retraho", "draw", "back", "pull", "back"],
    "vulnero,": ["vulnero", "wound", "injure", "hurt", "harm"],
    "gratia,agere": ["dat", "thank"],
    "aedificium,edificium": ["building", "structure"],
    "externus": ["outer", "foreign", "outside", "external"],
    "consuasor": ["advisor", "counselor"],
    "refero": ["bring", "back", "message", "refer"],
    "quernus": ["oaken"],
    "contentus": ["strained", "stretched", "eager", "zealous"],
    "sollicitudo": ["concern", "anxiety", "solicitude", "worry"],
    "insensatus": ["irrational"],
    "vulgaris,": ["vulgaris", "common", "ordinary", "usual"],
    "mereo,mereor": ["deserve", "earn", "be", "entitled", "merit"],
    "dominatus": ["rule", "mastery", "tyranny", "domination"],
    "ciminatio": ["accusation", "calumny", "charge"],
    "sabbatum": ["sabbath"],
    "calamitas": ["calamity", "misfortune", "disaster"],
    "puchre": ["beautifully", "finely", "handsomely"],
    "festino": ["hasten", "hurry", "speed"],
    "lector": ["reader"],
    "somniculouse": ["sleepily", "drowsily"],
    "impello": ["drive", "against", "strike", "upon"],
    "lex,legis": ["law", "statute", "covenant", "agreement"],
    "tamdiu": ["for", "such", "long", "time"],
    "palma": ["palm"],
    "autem": ["moreover", "however", "but", "also"],
    "imago": ["image", "likeness"],
    "venia": ["grace", "indulgence", "favor", "pardon", "forgiveness"],
    "vix,": ["vix", "scarcely", "hardly", "with", "difficulty", "barely"],
    "proletarius": ["citizen", "lowest", "rank"],
    "edoceo": ["inform", "fully", "instruct", "thoroughly"],
    "determino": ["fix", "limits", "set", "boundaries", "delimit"],
    "habeo,habui,habitum": ["habeo", "have", "hold", "possess", "consider", "regard"],
    "fortis": ["strong", "brave"],
    "superbia": ["pride", "arrogance"],
    "quantus": ["how", "great?", "how", "great!", "how", "much", "as", "great", "as"],
    "interdum": ["sometimes", "now", "then", "at", "times"],
    "impedito": ["hinderance"],
    "missa": ["holy", "mass"],
    "gravis": ["heavy", "weighty", "serious", "important", "severe", "grievous"],
    "siclinium": ["seclin", "in", "melanchois"],
    "illae,ille": ["fem", "pl", "nom", "those", "women", "must", "die!"],
    "sese": ["se:", "himself", "herself", "itself"],
    "lepide": ["charmingly", "wittily", "elegantly", "pleasantly"],
    "caelestis": ["heavenly", "celestial", "noun", "god", "dweller", "in", "heaven"],
    "dispono": ["arrange", "put", "in", "order", "draw", "up", "troops"],
    "neque,nec": ["not", "nor"],
    "illum": ["masc", "sing", "he", "ate", "that", "fruit"],
    "ligo": ["bind", "tie"],
    "ecquando": ["at", "any", "time?", "ever?"],
    "pulmo": ["lung"],
    "tantummodo": ["only", "just", "just", "so", "long", "as"],
    "illud": ["neut", "sing", "break", "those", "fetters"],
    "illuc": ["thither", "that", "place", "that", "matter", "that", "person"],
    "deripio": ["tear", "down", "snatch", "away"],
    "tredecim": ["indecl", "thirteen"],
    "punio": ["punish", "avenge", "gave", "vengeance"],
    "loricatus": ["wearing", "armor", "armored"],
    "infitialis": ["negative", "containing", "no", "rejection"],
    "casus": ["accident", "chance", "fortune"],
    "pretereo": ["go", "by", "pass", "by", "escape"],
    "mica": ["crumb", "morsel", "grain"],
    "adhuc": ["till", "then", "till", "now", "still", "even", "now", "besides", "also", "yet"],
    "taceo,tacuitacitum": ["be", "silent", "leave", "unmentioned"],
    "promptus": ["ready", "at", "hand", "visible", "apparent"],
    "terminus": ["boundary", "mark", "limit", "end", "border"],
    "munero,munerior": ["give", "present"],
    "pugnaculum": ["fortress"],
    "montensem": ["mons"],
    "funis,-is": ["funis", "-is:", "rope", "cord", "line"],
    "acer": ["sharp", "keen", "eager", "severe", "fierce"],
    "difficultas": ["difficulty", "need", "trouble", "distress"],
    "vomica,": ["ulcer", "sore", "boil", "plague", "curse"],
    "exemplar": ["model", "pattern", "original", "prototype", "book", "copy"],
    "arto": ["press", "together", "reduce", "abridged"],
    "terebro": ["bore", "through", "perforate"],
    "conqueror": ["complain", "loudly"],
    "factum": ["deed", "accomplishment", "work", "act", "achievement"],
    "siquidem": ["since", "indeed"],
    "deporto": ["carry", "off", "take", "away"],
    "cunctator": ["delayer", "procrastinator"],
    "imputo": ["lay", "charge", "enter", "in", "an", "account", "impute", "to"],
    "carpo": ["pluck", "seize", "grab", "lay", "hold", "hold", "on", "to"],
    "expello,expuli,expulsum,": ["expello", "expuli", "expulsum", "drive", "out", "expel", "force", "out", "banish"],
    "videor": ["be", "seen", "seem", "appear"],
    "instructus": ["trained", "taught"],
    "sive,seu": ["or", "if"],
    "audentia": ["boldness", "courage"],
    "mundo": ["clean"],
    "gratulor": ["wish", "person", "joy", "congratulate", "give", "thanks"],
    "intro": ["walk", "into", "enter", "make", "one's", "way", "into"],
    "at": ["but", "more", "emphatic", "emotional", "than", "sed"],
    "nefas": ["wrong", "sin"],
    "fugio": ["flee", "escape", "run", "away", "avoid", "shun"],
    "multus": ["much", "great"],
    "macula": ["stain", "mark", "spot", "blemish", "fault", "flaw"],
    "recipio,recepi,receptum": ["recipio", "go", "back", "retire", "recede", "retreat"],
    "praebeo,prebeo": ["refl", "show", "oneself", "present", "oneself"],
    "lux,lucis": ["light"],
    "praeproperus,preproperus": ["over-hasty", "precipitate"],
    "repens": ["sudden", "unexpected", "fresh", "recent"],
    "civitas": ["state", "citizenship", "city-state"],
    "gaudium": ["joy", "delight", "happiness"],
    "compes": ["fetters", "shackles", "chains"],
    "molestia": ["annoyance", "troublesomeness", "stiffness", "affectation"],
    "curatio": ["attention", "medical", "attention", "healing", "curing"],
    "astrum": ["star", "constellation"],
    "praesul,presul": ["dancer", "presider", "protector", "director"],
    "commissum": ["undertaking", "that", "which", "is", "entrusted"],
    "terra": ["earth", "ground", "land", "country", "soil"],
    "revolvo": ["unroll", "book", "go", "over", "again", "repeat"],
    "compello": ["drive", "together", "collect", "force", "compel"],
    "coepi": ["pres", "incipio", "began", "started", "undertook", "initiated"],
    "polleo": ["be", "strong", "powerful", "able"],
    "lues": ["plague", "pestilence", "calamity"],
    "prudens": ["prudent", "wise"],
    "rostrum": ["bill", "bird", "beak"],
    "pertimesco": ["become", "very", "much", "afraid"],
    "cenaculum": ["garret", "attic"],
    "quotienscumque": ["however", "often"],
    "lucror": ["gain", "profit", "win"],
    "barba": ["beard", "whiskers"],
    "recro": ["recreate", "restore", "revive"],
    "diversus": ["different", "unlike", "opposed", "hostile"],
    "appareo": ["become", "visible", "appear", "manifest"],
    "caste": ["purely", "spotlessly", "purely", "uprightly", "chastely"],
    "laudator": ["praiser"],
    "cognomen": ["surname", "family", "name", "nick-name"],
    "alius,alia,aliud": ["alius", "other", "another", "someone", "else", "something", "else"],
    "epulo": ["sumptuous", "food", "banquet", "feast"],
    "scamnum": ["bench", "stool"],
    "fiducia": ["confidence", "trust", "assurance"],
    "vociferor,": ["vociferor", "cry", "aloud", "shout"],
    "immo": ["by", "all", "means", "by", "no", "means", "on", "contrary"],
    "expeto": ["demand", "require", "desire", "strive", "after", "make", "for"],
    "libertas": ["freedom", "liberty", "independence", "frankness", "candor"],
    "revenio": ["come", "back", "return"],
    "tu": ["you", "old", "heidelberg", "you", "are", "finest"],
    "pecunia": ["money"],
    "liberalitas": ["courtesy", "kindness", "generousity", "grant"],
    "angulus": ["corner", "niche"],
    "asporto": ["carry", "off", "take", "away"],
    "mutatio": ["change", "alteration", "transformation"],
    "te": ["acc", "you", "i", "got", "you", "babe"],
    "auxilium": ["aid", "help", "assistance", "support"],
    "fore,forem": ["future", "infinitive", "sum"],
    "nutrimentus": ["nourishment"],
    "viridis": ["green"],
    "levidensis": ["thin", "slight", "poor"],
    "soleo": ["be", "accustomed", "be", "used", "to"],
    "perfusus": ["steeped", "soaked", "drenched"],
    "novem": ["nine"],
    "exesto": ["extra", "esto"],
    "sono": ["make", "noise", "sing", "celebrate", "of", "words", "mean"],
    "ago,egi,actum,": ["ago", "egi", "actum", "spend", "time", "live", "manage", "drive", "lead"],
    "stipes": ["log", "stump", "tree", "trunk", "branch", "post", "club"],
    "gesto": ["carry", "bear", "about"],
    "secerno,secrevi,secretum": ["secerno", "separate"],
    "scrinium": ["bookcase", "case", "for", "papers"],
    "perfectus": ["complete", "finished", "done", "perfect", "without", "flaw"],
    "vero": ["in", "truth", "indeed", "be", "sure", "however"],
    "scilicet": ["evidently", "certainly", "course", "no", "doubt", "assuredly"],
    "alter,altera,alterum": ["second", "other", "one"],
    "tametsi": ["even", "if", "although"],
    "certus": ["settled", "resolved", "decided", "definite", "certain", "sure"],
    "sane": ["rationally", "sensibly", "really", "indeed", "be", "sure"],
    "brocherota": ["broqueroi"],
    "laus": ["praise", "glory", "fame"],
    "conscindo": ["tear", "in", "pieces"],
    "pater,patris": ["father"],
    "prae,quam,pre,quam": ["prae", "quam", "in", "comparison", "with"],
    "aeger,eger": ["sick", "ill"],
    "incido": ["fall", "in", "on", "fall", "in", "with", "happen", "occur"],
    "meditor,meditatus": ["reflect", "upon", "consider", "ponder", "practice"],
    "superus,superior,supremus,or,summus": ["superus", "superior", "supremus", "above", "upper", "high"],
    "quidam,quaedam,quedam,quidam": ["quidam", "quaedam", "certain", "person", "thing", "kind", "of"],
    "prolixus": ["wide", "broad", "long", "willing", "obliging", "favorable"],
    "degusto": ["taste"],
    "ter": ["three", "times", "thrice"],
    "paratus": ["preparation", "fitting", "out", "equipment"],
    "absque": ["without"],
    "aggredior": ["go", "approach", "address", "attack"],
    "sub": ["acc", "dat", "under", "up", "under", "close", "beneath", "below"],
    "dido,dididi,didtum": ["dido", "separate", "divide", "distribute"],
    "persolvo": ["unloose", "explain", "expound", "pay", "off", "debt", "pay"],
    "deleo": ["deletum", "", "destroy", "wipe", "out", "erase"],
    "sui": ["himself", "herself", "itself"],
    "contemno": ["think", "meanly", "despise", "condemn", "hate"],
    "cubitum": ["elbow", "cubit"],
    "frumentum": ["grain"],
    "urbanus": ["urban", "urbane", "pertaining", "city"],
    "exercitus": ["army"],
    "puerilis": ["childish", "boyish", "foolish"],
    "evoco": ["draw", "out", "draw", "on", "produce", "recall", "colors"],
    "lemures": ["pl", "only", "ghosts", "phantoms"],
    "humanus": ["pertaining", "man", "humane", "humane", "cultured", "refined"],
    "turba": ["uproar", "disturbance", "mob", "crowd", "multitude"],
    "seditio": ["dissension", "quarrel", "insurrection", "mutiny", "rising"],
    "littera": ["letter", "of", "alphabet"],
    "nequeo": ["not", "be", "able", "be", "impossible"],
    "digredior,digredi,digressus": ["digredior", "depart", "deviate", "digress"],
    "iugis,iuge": ["perpetual", "continuous"],
    "spargo,sparsi,sparsum": ["spargo", "scatter", "strew", "spread"],
    "misere": ["wretchedly", "miserably"],
    "stella": ["star"],
    "valde": ["intensely", "very", "much", "extremely", "greatly"],
    "vespera": ["evening", "prayer", "vespers"],
    "quotiens": ["often"],
    "dicto": ["say", "often", "dictate", "get", "written", "down"],
    "mores,morium": ["ways", "conduct", "character", "morals"],
    "pica": ["jay", "magpie"],
    "prior,prius": ["former", "prior"],
    "perspicuus": ["transparent", "bright", "clear", "evident"],
    "lesciense,monastery,of": ["lesciense", "liessies"],
    "emerio": ["obtain", "by", "service", "earn", "completely", "deserve", "well"],
    "iungo,iunxi,iunctum": ["iungo", "join"],
    "madide": ["drunkenly"],
    "huic": ["fem", "sing", "dat", "there", "is", "statue", "in", "this", "abbey"],
    "secus,atque,or,quam": ["secus", "atque", "differently", "from", "otherwise", "than"],
    "vir": ["man", "hero", "man", "courage"],
    "vis": ["sing", "violence", "large", "number", "quantity", "force", "nature"],
    "lectica": ["litter", "bier"],
    "modicus": ["ordinary", "undistinguished", "within", "bounds"],
    "calco": ["tread", "trample", "upon"],
    "tego,texi,tectum": ["tego", "cover", "bury", "conceal", "hide", "protect", "shield"],
    "infideliter": ["faithlessly", "disloyally"],
    "memor": ["mindful", "remembering", "grateful", "thoughful", "prudent"],
    "proditor": ["traitor", "betrayer"],
    "rotomagense": ["rouen"],
    "silva": ["woods", "forest"],
    "principatus": ["rule", "dominion", "pre-eminence", "first", "place"],
    "liber": ["child", "offspring"],
    "quasi": ["as", "if", "just", "as", "just", "as", "if", "as", "it", "were", "sort", "of"],
    "converto": ["turn", "around", "cause", "turn", "adopt", "monastic", "life"],
    "intumesco": ["sell", "sell", "up", "sell", "with", "anger"],
    "demo": ["take", "away", "subtract"],
    "lacrimabilis": ["lamentable", "deplorable", "woeful"],
    "ager,agri": ["ager", "agri", "farm", "field", "acre"],
    "mora": ["delay"],
    "male,peius,pessime": ["male", "badly", "ill", "wrongly"],
    "minor": ["smaller", "less", "slighter"],
    "balbus": ["stammering", "stuttering", "fumbling"],
    "inflecto": ["warp", "change", "sway", "affect"],
    "turbo": ["disturb", "upset", "throw", "indisorder", "confuse", "unsettle"],
    "compositio": ["composition", "agreement", "pact", "arrangement"],
    "miro": ["wonder"],
    "populus": ["people", "people", "nation", "crowd", "multitude", "host"],
    "laetabilis,letabilis": ["joyous", "glad"],
    "compono": ["put", "together", "compose"],
    "expedio": ["free", "from", "snare", "disentangle", "set", "free", "ready"],
    "indignus": ["unworthy", "lacking", "in", "merit", "unfit"],
    "diabolus": ["devil", "satan"],
    "avoco": ["call", "away", "divert"],
    "electus": ["chosen", "select"],
    "excuso": ["exempt", "from", "blame", "excuse", "make", "excuses", "plead"],
    "condico": ["agree", "fix", "settle", "make", "arrangements"],
    "hic": ["masc", "nom", "sing", "this", "house", "is", "filthy"],
    "fusus": ["from", "fundo", "spread", "out", "extended", "wide", "copious"],
    "quadrum": ["square"],
    "congrego": ["gather", "together", "assemble", "convene"],
    "occasio": ["favorable", "moment", "opportunity"],
    "terminatio": ["termination", "determination", "setting", "boundaries"],
    "succendo": ["kindle", "set", "afire", "from", "below"],
    "vos,": ["you"],
    "velociter": ["quickly", "rapidly", "swiftly"],
    "compater": ["godfather", "man's", "child"],
    "illis": ["neut", "pl", "dat", "listen", "these", "orders"],
    "nondum": ["not", "yet"],
    "primoris": ["first", "foremost", "most", "distinguished", "first"],
    "comparo": ["compare"],
    "redarguo": ["disprove", "refute", "with", "gen", "prove", "guilty", "convict"],
    "saltem": ["at", "least", "at", "all", "events"],
    "minimus": ["least", "smallest", "slightest"],
    "lentus": ["tough", "resistant", "tenacious", "supple", "pliant", ""],
    "excludo": ["shut", "out", "exclude"],
    "quicquid": ["whoever", "whatever", "whatsoever", "anything", "at", "all"],
    "pristinus": ["former", "venerable", "ancient"],
    "artificiose": ["skillfully"],
    "pugna": ["fight", "battle", "conflict", "set-to"],
    "secus": ["wrongly", "badly", "not", "as", "one", "would", "wish"],
    "pyus,pyxidis": ["little", "box", "casket"],
    "influo,influi,influxum": ["influo", "flow", "in", "rush", "in", "steal", "in"],
    "pecto": ["comb", "card", "thrash", "card", "wool"],
    "plerusque": ["very", "many", "great", "number", "large", "part", "greater", "part"],
    "tertius": ["third"],
    "inimicus": ["personal", "enemy", "foe", "opponent"],
    "pictor": ["painter"],
    "plene": ["adv", "completely", "wholly", "fully"],
    "constringo,constrixi,constrictum": ["constringo", "bind", "confine", "restrain"],
    "adultus": ["adj", "grown", "up", "mature", "adult", "age"],
    "didicerat": [],
    "uterque": ["gen", "utriusque", "both", "each", "side", "each", "party"],
    "relego,relegi,relectum": ["relego", "read", "again", "re-read"],
    "levatio": ["alleviation", "mitigation", "solace"],
    "trado,tradidi,traditum": ["surrender", "hand", "over", "transmit", "teach"],
    "sacculus": ["purse", "little", "bag", "little", "sack"],
    "prolicio,prolixi": ["lure", "forth", "entice"],
    "ulciscor": ["take", "vengeance", "for", "avenge", "take", "vengeance", "on"],
    "malens": ["preferring"],
    "lacrimosus": ["tearful", "mournful", "shedding", "tears"],
    "aufero": ["carry", "away", "remove", "steal", "carry", "off", "make", "away", "with"],
    "plane": ["plainly", "clearly"],
    "nimis": ["adv", "too", "much", "overmuch", "excessively"],
    "praepositus,prepositus": ["monastic", "prior"],
    "defigo": ["fasten", "down", "secure", "fix", "firmly", "concentrate", "fix", "upon"],
    "turpe": ["disgrace"],
    "quin,etiam": ["why", "even", "in", "fact", "moreover"],
    "cruentus": ["bloody", "bloodthirsty", "blood-red"],
    "mestitia": ["misfortune?"],
    "correptius": ["more", "shortly"],
    "debilito": ["weaken", "enervate", "sap", "exhaust"],
    "tamisium": ["sieve", "sifter"],
    "plaustrum": ["wagon", "cart", "charles", "wain"],
    "immotus": ["unmoved"],
    "protraho,protractus": ["draw", "out", "protract", "defer", "make", "known"],
    "obliquo": ["turn", "sideways", "turn", "aside"],
    "eventus": ["consequence", "issue", "result", "occurrence", "experience"],
    "fas,est": ["fas", "est::", "it", "is", "right", "it", "is", "fitting", "it", "is", "lawful"],
    "ita": ["in", "narration", "so;", "with", "adj", "adv", "so", "so", "very"],
    "nox,noctis": ["night"],
    "cerno": ["separate", "sift", "distinguish", "decide", "resolve", "determine"],
    "iudico": ["judge", "consider"],
    "articulus": ["of", "time", "moment", "crisis"],
    "peritus": ["skilled", "expert"],
    "thermae": ["warm", "springs", "warm", "baths"],
    "ostium": ["entrance", "door"],
    "putesco": ["putrefy", "day", "rot"],
    "siccus": ["dry", "thirsty", "sober", "temperate"],
    "averto": ["turn", "away", "avert", "avoid", "turn", "back"],
    "priores,um": ["forefathers", "ancestors"],
    "termes": ["tree", "branch", "especially", "olive"],
    "vesica": ["bladder", "bladder-like", "tumor"],
    "adsidue,assidue": ["continuously", "without", "remission"],
    "lacer": ["torn", "mangled", "cut", "pieces"],
    "sal,salis": ["salt", "wit"],
    "diutius": ["longer", "too", "long", "period", "time"],
    "clamor": ["loud", "shouting", "cry"],
    "recito": ["read", "aloud", "recite"],
    "filia": ["daughter"],
    "gandavum": ["ghent"],
    "ploro": ["lament", "weep", "weep", "over"],
    "conatus": ["exertion", "effort", "undertaking", "impulse", "inclination"],
    "parilis": ["similar", "like", "equal"],
    "intus": ["within"],
    "libido": ["whim", "caprice", "violent", "desire", "passionate", "longing"],
    "praecipio,precipio": ["instruct", "advise", "warn", "anticipate"],
    "tabellae": ["letter", "document"],
    "vestio,vestivi,vestitum": ["vestio", "clothe"],
    "quadrigae": ["four-horse", "team"],
    "denuncio": ["declare", "give", "notice", "announce"],
    "xiphias": ["sword-fish"],
    "propter": ["near", "close", "on", "account", "because", "of"],
    "supplicium": ["punishment"],
    "mussito": ["grumble", "mutter"],
    "principium": ["beginning"],
    "delectatio": ["delight", "pleasure", "enjoyment"],
    "triduanus": ["three", "days'", "duration", "lasting", "three", "days"],
    "feculentia": ["dregs", "lees", "impurities", "filth"],
    "porta": ["gate", "entrance"],
    "coniuratio": ["conspiracy", "plot"],
    "memoratus": ["mentioned"],
    "concilium": ["council"],
    "adulescens": ["young", "man", "youth", "lad"],
    "socius": ["partner", "comrade", "associate", "ally", "fellow"],
    "eligo": ["pick", "out", "select", "choose"],
    "contristo": ["sadden", "afflict", "damage", "of", "crops"],
    "sordes": ["filth", "meanness", "stinginess"],
    "res,rei": ["thing", "matter", "business", "affair"],
    "frustra": ["in", "vain", "mistakenly", "wantonly", "without", "reason"],
    "ideo": ["for", "that", "reason", "on", "that", "account", "therefore"],
    "reduco": ["lead", "back", "bring", "back", "return"],
    "precor": ["pray", "beg", "entreat", "invoke"],
    "comminor": ["threaten"],
    "autus": ["increase", "enlargement", "growth"],
    "frigus": ["cold", "coolness", "cold", "winter", "dullness", "indolence"],
    "aestivus,estivus": ["pertaining", "summer"],
    "quantum": ["how", "much?", "how", "much!", "as", "much", "as"],
    "voro,": ["eat", "greedily", "swallow", "up", "consume", "gorge", "oneself"],
    "infra,inferius,infimus": ["infra", "low", "down"],
    "clamo": ["call", "shout", "cry", "aloud", "proclaim", "declare"],
    "glacialis": ["icy", "frozen", "full", "ice"],
    "prolatio": ["bringing", "forward", "mentioning", "extension", "deferring"],
    "queribundus": ["complaining", "plaintive", "whining"],
    "discipulus": ["disciple", "student", "learner", "pupil"],
    "sanctimonia": ["purity", "charity", "virtue", "sanctity", "sacredness"],
    "lucerna": ["lamp"],
    "tactus": ["sense", "feeling", "touch"],
    "fortitudo": ["physical", "strength", "courage", "moral", "bravery"],
    "saluto": ["wish", "well", "greet", "visit", "reverence", "pay", "respect", "to"],
    "acervus": ["heap", "mass"],
    "retribuo": ["give", "again", "give", "as", "due"],
    "se,astringo": ["commit", "oneself", "to"],
    "vallum": ["palisade", "earthen", "wall", "entrenchment", "rampart"],
    "mus,muris": ["mouse"],
    "necessarius": ["necessary", "needed", "essential"],
    "gemo": ["sigh", "groan", "wail"],
    "satago": ["have", "one's", "hands", "full", "have", "enough", "do"],
    "infensus": ["hostile", "aggressive", "arms", "aimed", "ready", "spirit", "dangerous"],
    "demoror": ["loiter", "linger", "tarry", "belay"],
    "illacrimo": ["dat", "weep", "over"],
    "labo": ["totter", "sink", "begin", "fall"],
    "festinatio": ["speed", "haste"],
    "callide": ["skillfully", "cleverly", "cunningly", "slyly", "subtly"],
    "dolens": ["painfully"],
    "prodigiosus": ["unnatural", "wonderful", "miraculous", "amazing"],
    "totidem": ["just", "as", "many"],
    "vilicus,villicus": ["pertaining", "an", "estate", "overseer", "steward"],
    "prolecto": ["entice", "allure"],
    "velox": ["quick", "rapid", "swift", "fast"],
    "obdormio": ["fall", "asleep"],
    "tornacense": ["tournai"],
    "persisto": ["persist", "persevere"],
    "nivellensem": ["nivelles", "city", "monastery"],
    "theologus": ["theologian"],
    "celer": ["quick", "swift", "rapid", "speedy", "fast"],
    "spoliatio": ["plundering", "looting", "stripping", "robbing"],
    "defluo": ["flow", "away", "disappear", "be", "lost"],
    "demitto": ["set", "down", "let", "fall", "offer", "payment", "church", "lower"],
    "sidus": ["constellation", "star"],
    "sequor,sequi,secutus": ["sequor", "follow", "trail"],
    "certe,certo": ["adv", "certainly", "assuredly"],
    "audacia": ["boldness", "dash", "daring", "audacity"],
    "adduco": ["lead", "induce", "persuade"],
    "pudor": ["modesty", "bashfulness"],
    "fatum": ["fate", "destiny", "doom", "lot", "weird"],
    "cado": ["fall", "drop", "plummet", "topple"],
    "opus,operis": ["work", "labor", "work", "done", "completed", "work", "building"],
    "mulier": ["woman"],
    "curtracus": ["courtrai"],
    "eloquentia": ["eloquence", "readiness", "speech", "fluency", "persuasiveness"],
    "coniuratus": ["conspirator", "plotter"],
    "modestus": ["orderly", "within", "bounds", "moderate", "restrained"],
    "contra": ["against"],
    "moleste": ["take", "annoyance"],
    "lascivio": ["run", "riot", "play", "be", "wanton"],
    "tripudio": ["leap", "jump", "dance", "as", "in", "religious", "procession"],
    "igitur": ["therefore", "consequently", "for", "this", "reason"],
    "aspicio": ["look", "at", "behold", "gaze", "at", "see"],
    "amicitia": ["friendship"],
    "paro": ["prepare", "get", "ready", "set", "put", "furnish", "supply", "buy"],
    "etsi": ["acsi", "even", "if", "although"],
    "consulo": ["look", "interests", "come", "conclusion"],
    "rogo": ["ask", "ask", "for"],
    "cursito": ["run", "up", "down"],
    "sileo": ["be", "still", "silent", "acc", "be", "silent", "about", "rest"],
    "invisus": ["hated", "hateful"],
    "ioco,iocor": ["joke", "jest", "make", "merry"],
    "ulterius": ["farther", "more", "advanced", "more", "remote"],
    "incurro": ["run", "into", "assail", "attack", "raid", "into", "come", "upon"],
    "defendo": ["defend", "ward", "off", "protect", "shelter"],
    "reus": ["defendant", "accused", "answerable", "bound"],
    "redundo": ["overflow", "stream", "over", "overflow", "excess", "flood"],
    "plura": ["more", "numerous", "several", "many"],
    "ruo,rui,rutum": ["ruo", "rush", "fall", "be", "ruined"],
    "claustrum": ["bolt", "bar", "prison", "den", "pen", "enclosure", "cloister"],
    "consilio": ["intentionally", "on", "purpose", "designedly"],
    "inrideo": ["laugh", "at", "mock", "ridicule"],
    "feritas": ["wildness", "savageness"],
    "perfero": ["bear", "suffer", "endure"],
    "aut,aut": ["either", "or"],
    "importo": ["bring", "in", "introduce", "import", "bring", "upon", "cause"],
    "vinum": ["wine"],
    "suffoco": ["strangle", "choke", "suffocate"],
    "complectus": ["embrace", "grasp"],
    "plurimus": ["most", "very", "many"],
    "paene,pene": ["nearly", "almost"],
    "cruciamentum": ["torture", "torment"],
    "umbra": ["shade", "shadow"],
    "primitus": ["first", "for", "first", "time"],
    "impudenter": ["impudently", "insolently", "presumptuously"],
    "audacter,audaciter": ["boldly", "proudly", "fearlessly"],
    "delecto": ["attract", "delight", "pass", "abl", "take", "delight", "in"],
    "ordo": ["rank", "class", "order"],
    "cathalaunenses": ["chalons"],
    "treverim": ["triers"],
    "utrum,an": ["whether", "or"],
    "admoveo": ["move", "bring", "up", "apply"],
    "volup,": ["volup", "agreeably", "pleasantly"],
    "cursus": ["race", "running", "race", "course", "race", "track", "course"],
    "inferus": ["below", "under", "southern"],
    "redeo": ["fall", "back", "upon", "be", "reduced", "be", "brought", "to"],
    "distribuo": ["distribute", "divide"],
    "procedo": ["go", "ahead", "proceed", "advance", "continue"],
    "miror": ["marvel", "at", "admire", "wonder"],
    "audio": ["hear", "hearken", "listen", "to"],
    "apparatus": ["equipment", "gear", "machinery", "splendor", "magnificence"],
    "hactenus": ["hitherto", "up", "this", "point", "so", "far"],
    "vereor": ["respect", "fear", "be", "in", "dread", "be", "afraid"],
    "pungo,pupugi,punctum": ["pungo", "prick", "puncture", "stab", "touch", "move"],
    "mador": ["wetness", "moisture"],
    "quaero,quero": ["miss", "want", "seek", "know", "obtain", "get"],
    "pulchellus": ["pretty"],
    "finis": ["end", "limit", "boundary", "purpose"],
    "perscitus": ["very", "clever", "exceedingly", "sharp"],
    "obtineo": ["hold", "keep", "possess", "maintain", "continue"],
    "consulto": ["consider", "carefully", "weigh", "ponder"],
    "comitatus": ["train", "retinue", "following", "war", "band"],
    "certo": ["contend", "settle", "dispute", "settle", "by", "combat"],
    "postulo": ["ask"],
    "cauda": ["tail", "an", "animal"],
    "mel,mellis": ["honey"],
    "iubeo,iussi,iussum": ["iubeo", "order", "command"],
    "chirographum": ["autograph", "person's", "own", "handwriting", "written", "charter"],
    "teneo": ["grasp", "know", "understand"],
    "caries": ["rottenness", "corruption", "decay"],
    "initium": ["beginning", "start", "commencement", "origin"],
    "divinitus": ["divine", "influence", "admirably", "nobly", "by", "inspiration"],
    "nobis": ["dat", "us", "world", "belongs", "us"],
    "bos,bovis,": ["cow", "ox", "bull"],
    "arbustus": ["planted", "with", "trees"],
    "quem": ["masc", "sing", "man", "whom", "king", "struck"],
    "queo": ["be", "able"],
    "solum": ["adv", "alone", "only"],
    "redigo,redactum": ["bring", "reduce", "condition", "lessen"],
    "macero": ["soften", "weaken", "reduce", "torment"],
    "rudimentum": ["trial", "attempt", "essay"],
    "iniustus": ["unjust", "inequitable", "unfair"],
    "iniuria": ["injury", "damage", "hurt", "injustice", "wrong"],
    "militaris,-e": ["militaris", "-e:", "soldier", "military", "martial"],
    "destituo": ["set", "down", "place", "abandon", "leave", "in", "lurch"],
    "unus": ["one", "only", "one", "at", "same", "time", "single", "alone"],
    "accendo": ["kindle", "illuminate", "inflame"],
    "mortuus": ["dead", "deceased", "passed", "away", "gone", "west", "departed"],
    "didico": ["be", "told"],
    "procer": ["chief", "noble", "prince"],
    "gratia": ["in", "abl", "on", "account", "of"],
    "irascor,iratus": ["be", "angry", "be", "wrathful"],
    "iaculator": ["iaculator::", "thrower", "javelin", "man", "spear", "thrower"],
    "nunquam": ["never"],
    "lacto": ["allure", "entice", "wheedle"],
    "scabies": ["itch", "mange", "rash"],
    "salus": ["health", "safety", "well-being", "salvation", "salutation"],
    "praeda,preda": ["plunder", "booty", "spoils", "war", "loot", "gain", "prey"],
    "claudeo": ["limp", "halt", "be", "lame", "hobble"],
    "pevela": ["pevle", "near", "cisoing"],
    "theca": ["case", "envelope", "covering"],
    "lacrimo": ["weep", "shed", "tears", "exude", "drip"],
    "deorsum": ["downwards"],
    "lamenta,neut,pl": ["weeping", "wailing"],
    "pecus": ["single", "head", "cattle", "especially", "sheep"],
    "curto": ["shorten", "abbreviate"],
    "ars,artis": ["skill", "method", "technique", "conduct", "character"],
    "continuus": ["connected", "together", "continuous", "uninterrupted"],
    "nascor,nasci,natus": ["nascor", "be", "born", "spring", "forth"],
    "mundus": ["clean", "neat", "elegant"],
    "creator": ["creator", "founder"],
    "potens": ["able", "mighty", "powerful", "strong"],
    "nichilominus": ["nevertheless"],
    "inultus": ["unavenged", "unpunished"],
    "adstringo": ["draw", "together", "tighten", "bind"],
    "ara": ["altar"],
    "sed": ["but", "indeed", "what", "is", "more"],
    "cultura": ["cultivation"],
    "intueor": ["look", "at", "attentively", "gaze", "at", "consider"],
    "utor,uti,usus": ["utor", "use", "employ", "possess", "enjoy", "associate", "with", "find"],
    "aro": ["plow"],
    "expers": ["wanting", "destitute", "not", "sharing", "in"],
    "tres,tria": ["three"],
    "curiosus": ["careful", "attentive", "curious", "inquisitive", "worn", "out", "by", "cares"],
    "sepelio": ["ruin", "destroy", "bury"],
    "mucro": ["sharp", "point", "edge", "dagger", "point"],
    "se,gero": ["conduct", "oneself", "conduct", "carry", "on"],
    "insolitus": ["unaccustomed", "unusual", "strange", "uncommon"],
    "nunc,quidem": ["at", "one", "time", "then"],
    "catena": ["chain", "fetters"],
    "quaestus,questus": ["profit", "source", "profit", "gaining", "getting"],
    "molior": ["build", "erect", "construct", "contrive", "toil", "struggle"],
    "bibo": ["drink", "quaff"],
    "interficio,interfeci,interfectum": ["interficio", "kill", "murder", "slay"],
    "frugalitas": ["frugality", "economy", "pinching", "pennies"],
    "immortalis": ["immortal"],
    "comprobo": ["approve", "fully", "confirm", "prove", "establish"],
    "metim": ["metz"],
    "rogo,eum,ut,subjunctive": ["rogo", "eum", "ask", "someone", "do", "something"],
    "repere": ["crawl"],
    "accusator": ["accusor", "plaintiff"],
    "amitto": ["send", "away", "let", "go", "let", "slip", "lose"],
    "contradictio": ["speaking", "against", "contradiction"],
    "informatio": ["concept", "idea"],
    "peruro,perussi,perustum": ["peruro", "burn", "up", "consume", "inflame", "gall", "chafe"],
    "caterva": ["crowd", "troop", "flock"],
    "mortifera": ["deadly", "things"],
    "prolapsio": ["slipping", "sliding"],
    "audeo": ["part", "ausus", "dare"],
    "senectus": ["old", "age", "dotage"],
    "laesio,lesio": ["rhetorical", "attack", "wounding"],
    "comperio": ["disclose", "fully", "find", "out", "with", "certainty"],
    "intentio": ["effort", "exertion", "attention", "intent", "attack", "accusation"],
    "emiror": ["wonder", "at", "exceedingly"],
    "devoveo": ["consecrate", "sacrifice", "devote", "curse", "execrate"],
    "parvus,minor,minimus": ["parvus", "small", "little"],
    "misericordia": ["pity", "mercy"],
    "pullulo": ["shoot", "up", "sprout", "burgeon"],
    "consumo": ["spend", "employ", "use", "up", "finish", "waste", "away", "destroy"],
    "infirme": ["weakly", "faintly"],
    "leto": ["kill", "slay"],
    "reliquum": ["remainder", "what", "is", "left", "leavings"],
    "lacunar": ["panelled", "ceiling"],
    "infirmo": ["weaken", "shake", "invalidate", "annull"],
    "probitas": ["probity", "uprightness", "honesty"],
    "duo": ["two"],
    "limen,limina": ["threshold"],
    "miser": ["wretched", "unfortunate", "miserable"],
    "intentus": ["thorough", "tense", "anxious", "strict"],
    "proelium": ["battle"],
    "incompositus": ["disorder", "lack", "regularity"],
    "homo,hominis": ["human", "being", "man"],
    "defetiscor,defessus": ["grow", "tired", "weary"],
    "profecto": ["truly", "really", "indeed"],
    "destinatus": ["resolute", "firm", "determined", "with", "one's", "mind", "made", "up"],
    "immanitas": ["savagery", "frightfulness"],
    "appositus": ["placed", "near", "approaching", "appropriate", "appositively"],
    "pupa": ["doll", "little", "girl"],
    "hi": ["masc", "pl", "nom", "these", "men", "are", "loyal", "king"],
    "proinde,ut": ["just", "as"],
    "largior": ["lavish", "bestow", "grant", "give", "abundantly"],
    "exemplum": ["pattern", "model", "example", ""],
    "omnino": ["altogether", "entirely", "wholly", "certainly", "completely"],
    "lenitas,lenitudo": ["smoothness", "gentleness", "mildness"],
    "instructus,from,instruo": ["equipped", "trained", "supplied"],
    "ignis": ["fire"],
    "impraesentiarum": ["for", "present", "in", "present", "circumstances"],
    "labellum": ["little", "lip", "small", "washing", "vessel"],
    "impedio": ["entangle", "ensnare", "obstruct", "surround", "hinder", "prevent"],
    "milia": ["pl", "thousands"],
    "error": ["error", "mistake", "going", "astray"],
    "defessus": ["weary", "tired"],
    "putator": ["pruner"],
    "dummodo": ["conj", "subj", "provided"],
    "arcesso,accerso": ["bring", "fetch", "summon", "call", "for"],
    "jugiter": ["continually", "perpetually", "constantly", "instantly"],
    "prosum": ["with", "dat", "be", "useful", "do", "good", "benefit"],
    "dilgenter": ["attentively", "earnestly", "carefully", "diligently"],
    "propositum": ["design", "purpose", "scheme", "theme", "discourse"],
    "gens": ["clan", "race", "nation", "people", "tribe"],
    "regius": ["royal", "regal"],
    "postquam": ["after"],
    "reddo": ["give", "back", "restore", "return", "answer", "translate", "render"],
    "simul,atque": ["as", "soon", "as"],
    "comedo,comedi,comesum": ["comedo", "eat", "up", "consume", "waste", "squander"],
    "subseco": ["cut", "away", "pare"],
    "hortor": ["exhort", "incite", "encourage"],
    "prosperitas": ["prosperity", "good", "fortune"],
    "decor": ["beauty", "grace"],
    "infecunditas": ["barrenness", "sterility"],
    "horrendus": ["horrible", "dreadful"],
    "contingo": ["contactum", "touch", "closely", "happen", "befall"],
    "quies,quietis": ["quiet", "rest", "peace"],
    "educo": ["draw", "out", "lead", "out", "march", "out", "bring", "up", "rear", "sue"],
    "dulcis": ["sweet", "pleasant", "agreeable"],
    "cautela": ["caution", "precaution", "security"],
    "experior,experiri,expertus,": ["experior", "experiri", "expertus", "try", "test", "experience", "prove"],
    "sapiens": ["wise", "judicious"],
    "nonus": ["ninth"],
    "mitto,misi,missum": ["send", "dispatch"],
    "singuli": ["one", "each", "one", "apiece", "single", "separate"],
    "censura": ["judgement"],
    "epistula": ["letter", "epistle", "missive", "message"],
    "amplus": ["large", "spacious", "ample", "great", "important", "honorable"],
    "liber,libri": ["book"],
    "maculo": ["stain", "blemish", "defile", "pollute"],
    "depereo": ["perish", "be", "utterly", "ruined"],
    "incontinencia": ["lack", "restrain", "incontinence"],
    "sto,steti,statum": ["sto", "stand", "stand", "still", "stand", "firm"],
    "civilis": ["civil", "civic"],
    "mereo": ["deserve", "gain", "obtain", "serve", "as", "soldier"],
    "abbas,abbatis": ["father", "abbot"],
    "incorruptus": ["uncorrupted", "genuine", "pure"],
    "incertus": ["uncertain", "doubtful", "unsure", "hesitant"],
    "dusiol,petram": ["duissenpierre"],
    "carnutum,carnotum": ["chartres"],
    "oportunitas": ["convenience", "fitness", "advantage", "opportunity"],
    "auditor": ["hearer", "listener"],
    "juventus": ["age", "youth", "years"],
    "toties": ["often", "so", "many", "times"],
    "consummo": ["add", "together", "sum", "up", "make", "perfect", "complete"],
    "pollen": ["also", "pollis", "fine", "flour", "fine", "meal"],
    "immineo": ["hang", "over", "be", "imminent", "threaten"],
    "consultum": ["decree"],
    "hilaris": ["cheerful", "merry", "gay"],
    "corrigo": ["make", "correct", "make", "right"],
    "indo,past,indidi": ["establish", "cause", "occasion"],
    "ordine,ordinem": ["regularly", "appropriately", "properly"],
    "corroboro": ["strengthen"],
    "infligo,inflixi,inflictum": ["infligo", "strike", "hit", "knock", "cause", "damage"],
    "piper,piperis": ["pepper"],
    "atrebatum": ["arras"],
    "pollex": ["thumb", "big", "toe"],
    "praemium,premium": ["reward", "prize"],
    "pateo": ["be", "revealed", "stand", "open", "be", "clear", "plain"],
    "contemptus": ["despised", "despicable", "contemptible"],
    "dito": ["enrich", "make", "wealthy"],
    "scriptor": ["writer", "author", "scribe"],
    "insinuo": ["insinuate", "work", "one's", "way", "in", "intimate"],
    "consuesco": ["accustom", "inure", "habituate"],
    "infula": ["insignia", "office"],
    "revoco": ["call", "back", "recover", "refer", "revoke"],
    "cultellus": ["little", "knife"],
    "fio,fieri,factus": ["fio", "be", "made", "be", "done", "become"],
    "tamen": ["notwithstanding", "nevertheless", "yet", "still", "for", "all", "that"],
    "extra": ["prep", "beyond", "outside"],
    "stabilis": ["firm", "stable", "steadfast"],
    "quadratus": ["square", "square"],
    "cum": ["with", "subjunctive", "when", "as", "while", "since", "although"],
    "respondeo,respondi,responsum": ["respondeo", "answer", "reply", "respond"],
    "effero,extuli,elatum": ["effero", "carry", "out", "bury", "lift", "up", "exalt"],
    "peracto": ["carry", "through", "complete", "accomplish"],
    "cui": ["neut", "sing", "dat", "monster", "whom", "cattle", "belonged"],
    "metus": ["fear", "dread", "anxiety"],
    "abduco": ["lead", "take", "away", "detach", "withdraw"],
    "proveho": ["carry", "on", "carry", "forward", "advance", "promote"],
    "prolusio": ["preliminary", "exercise", "prelude"],
    "corturiacum": ["courtrai"],
    "industrius": ["industrious", "diligent", "assiduous", "hard-working"],
    "mancipo": ["sell", "formally", "give", "up"],
    "sitis": ["thirst", "dryness", "drought", "eager", "desire"],
    "integer": ["whole", "untouched", "unhurt", "undamaged", "complete", "entire"],
    "comis": ["courteous", "kind", "friendly"],
    "bis": ["twice"],
    "prudentia": ["foresight", "wisdom", "discretion"],
    "expilatio": ["plundering", "taking", "booty"],
    "valens": ["strong", "powerful", "healthy", "able", "worthwhile"],
    "gregatim": ["in", "flocks", "herds", "troops", "crowds"],
    "deputo": ["count", "estimate", "prune", "cut", "off"],
    "pendeo": ["hang", "depend", "be", "suspended", "be", "uncertain", "undecided"],
    "facundia": ["facultas:", "feasibility", "opportunity", "resources", "abundance"],
    "cupiditas": ["ambition", "avarice", "party", "spirit", "eager", "desire"],
    "continuo": ["adv", "immediately", "at", "once"],
    "ignoro": ["be", "ignorant", "not", "neglect", "overlook"],
    "aegre,egre": ["adv", "hardly", "scarcely", "with", "difficulty", "laboriously"],
    "promontorium": ["peak", "mountain", "crest", "ridge", "promontory"],
    "lenio": ["mitigate", "relieve", "make", "better"],
    "indutiae": ["truce", "armistice", "suspension", "hostilities"],
    "potissimum": ["adv", "chiefly", "most", "all"],
    "exilis": ["thin", "slender", "meager"],
    "praestantia,prestantia": ["superiority", "excellence"],
    "dextera": ["right", "hand"],
    "progredior": ["go", "forth", "advance", "proceed", "go", "out"],
    "exturbo": ["drive", "away", "thrust", "out"],
    "pax,pacis": ["peace"],
    "pala": ["spade", "peel", "for", "putting", "bread", "in", "oven"],
    "succedo": ["approach", "submit"],
    "lenis": ["smooth", "gentle", "kind", "mild"],
    "lamia": ["witch", "vampire"],
    "licet": ["as", "conj", "granted", "that", "although"],
    "tendo": ["direct", "one's", "course", "tend", "make", "head", "for"],
    "proprie": ["exclusively", "particularly", "peculiarly", "properly"],
    "saeta": ["hair"],
    "singularis": ["alone", "unique", "extraordinary", "individual", "singular"],
    "invado": ["assail", "usurp", "seize", "attack", "fall", "upon"],
    "teres": ["rounded", "polished", "smooth", "fine", "elegant"],
    "exclamo": ["shout", "cry", "aloud", "exclaim", "call", "someone", "by", "name"],
    "patiens": ["patient", "gen", "capable", "enduring"],
    "immunda": ["unclean", "impure", "dirty", "foul"],
    "perverto,perverti,perversum": ["turn", "upside", "down", "overturn", "overthrow"],
    "tepidus": ["warm", "luke-warm", "tepid"],
    "exhibeo,exibeo": ["produce", "show", "display", "offer", "allow", "cause"],
    "cogito": ["think", "ruminate", "ponder", "consider", "plan"],
    "veritas": ["truth"],
    "pravitas": ["crookedness", "depravity", "deformity", "perversity"],
    "infra": ["below", "under", "time", "later", "than"],
    "immerito": ["undeservingly", "without", "merit", "unjustifiably"],
    "res,publica": ["commonwealth", "state", "republic", "public", "business"],
    "ferme,fere": ["almost", "about"],
    "arca,archa": ["chest", "box", "money", "box", "coffin", "cell"],
    "quilibet": ["anyone", "anything"],
    "relevo": ["lift", "again", "lighten", "alleviate", "relieve"],
    "lentulus": ["rather", "slow", "little", "slow"],
    "letaliter": ["mortally", "fatally"],
    "vulariter,": ["vulariter", "in", "common", "way", "ordinary", "manner"],
    "titulus": ["label", "title", "placard"],
    "libere": ["freely", "openly", "frankly"],
    "onero": ["load", "burden", "oppress", "fill", "up"],
    "aiunt": ["they", "say"],
    "libero": ["set", "free", "deliver", "liberate", "release", "exempt"],
    "illorum": ["neut", "pl", "gen", "cattle", "these", "monsters", "were", "fat"],
    "letum": ["death", "ruin", "annihilation"],
    "lacrima,heliandum": ["amber"],
    "atrocitas": ["hashness", "cruelty", "frightfulness", "barbarity", "horror"],
    "undique": ["from", "all", "sides", "everywhere", "on", "all", "sides", "altogether"],
    "juvenis": ["young", "man", "youth"],
    "praesto": ["stand", "before", "be", "outstanding", "excell", "surpass", "show"],
    "admiror": ["wonder", "at", "admire", "marvel", "at"],
    "qualislibet": ["of", "what", "sort", "you", "will"],
    "mutuo": ["borrowed", "lend"],
    "dignitas": ["merit", "worth", "prestige", "dignity"],
    "multus,plus,plurimum": ["multus", "much", "lot"],
    "plumbum": ["lead", "bullet", "lead", "pipe"],
    "locus": ["place", "location", "situation", "spot"],
    "is,ea,id": ["is", "this", "that", "he", "she", "it"],
    "lamentatio": ["weeping", "wailing", "lamenting"],
    "coadunatio": ["gathering", "together", "summing", "up", "uniting"],
    "modica": ["moderate", "within", "bounds", "limited", "undistinguished"],
    "rubor": ["redness", "blush", "modesty", "shame", "disgrace"],
    "solium": ["chair", "state", "throne", "bath-tub"],
    "vinitor": ["vine-dresser", "man", "who", "prunes", "grape", "vines"],
    "facultas": ["power", "means", "opportunity", "capacity", "ability", "stock"],
    "prehendo": ["seize", "snatch", "grasp", "detain", "arrest"],
    "candidus": ["bright", "shining", "white"],
    "exerceo": ["train", "cultivate", "keep", "at", "work", "exercise", "practice"],
    "occupo": ["take", "possession", "grasp", "seize", "enjoy", "get", "start", "on"],
    "moleste,fero": ["i", "take", "annoyance"],
    "degero": ["pass", "time", "live"],
    "ciminosus": ["reproachful", "slanderous"],
    "adfectus,affectus": ["influenced", "worked", "upon"],
    "purgamentum": ["rubbish", "trash", "filth", "sweepings"],
    "custos": ["guardian", "keeper", "watchman", "attendant", "guard", "spy"],
    "boloniense": ["bouillon"],
    "divitiae,divitie": ["riches", "wealth"],
    "pareo": ["dat", "be", "obedient", "obey"],
    "vomito,": ["vomit", "forth", "throw", "up"],
    "infero": ["abstract", "things", "bring", "on", "occasion", "cause"],
    "impudens": ["impudent", "shameless", "insolent", "presumptuous"],
    "mugio": ["groan", "bellow", "roar", "low"],
    "inferi": ["those", "down", "below", "dead"],
    "exquisitus": ["sought", "after", "exquisite", "excellent", "fine", "delicate"],
    "posterus,postremo": ["subsequent", "following", "next", "future"],
    "polliceor": ["promise", "offer"],
    "invito": ["invite", "summon"],
    "lino": ["smear", "befoul", "dirty"],
    "comperte": ["on", "good", "authority"],
    "familia": ["family", "household"],
    "postea": ["afterwards"],
    "serio": ["seriously"],
    "auris": ["ear"],
    "lamentor": ["weep", "wail", "lament", "trans", "bewail"],
    "quorum": ["masc", "pl", "gen", "army", "half", "which", "was", "ill"],
    "protinus": ["forward", "further", "on", "continuously", "immediately"],
    "prae,dulcis,pre,dulcis": ["prae", "dulcis", "exceedingly", "sweet"],
    "malus,peior,pessimus": ["malus", "bad", "wicked", "evil"],
    "vinco,vici,victum": ["vinco", "conquer", "overcome", "master", "win", "surpass", "excel"],
    "negotium": ["employment", "business", "task", "occupation", "pains"],
    "ut": ["subj", "command", "that"],
    "melior": ["better"],
    "praesumo,presumo": ["anticipate", "take", "for", "granted"],
    "us": ["foreign", "acquired"],
    "aggero": ["make", "mound", "heap", "up", "increase"],
    "faenum,fenum": ["hay"],
    "labiosus": ["having", "large", "lips"],
    "appono": ["place", "near", "put", "serve", "put", "on", "table"],
    "exhibeo": ["show", "present", "allow", "display", "present", "offer"],
    "constans": ["steady", "firm", "unchanging", "constant", "unwavering"],
    "erogo": ["pay", "out", "expend", "disburse"],
    "monitio": ["admonition", "warning"],
    "spiritus": ["breath", "breathing", "life", "spirit"],
    "obtestor": ["implore", "entreat", "beg", "call", "as", "witness"],
    "diligentia": ["diligence", "industry", "perseverance", "persistence"],
    "lectus": ["bed"],
    "conspergo": ["sprinkle", "bestrew"],
    "obviam": ["on", "way", "in", "way", "dat", "towards", "against"],
    "aveho": ["carry", "away", "remove", "avexi", "avectum", ""],
    "pertinacia": ["firmness", "obstinacy", "stubbornness"],
    "cura": ["management", "administration", "care", "concern", "charge"],
    "curo": ["gerundive", "see", "thing", "being", "done", "cure", "rest"],
    "lacuna": ["hole", "empty", "space", "pond", "pool", "deficiency", "loss"],
    "materia": ["material", "substance", "matter"],
    "utique": ["at", "any", "rate", "certainly", "at", "least"],
    "macresco": ["become", "lean", "skinny", "thin"],
    "constupator": ["ravisher", "debaucher"],
    "omnigenus": ["of", "all", "kinds"],
    "effringo,effrego": ["break", "break", "open"],
    "qualitas": ["quality", "property"],
    "prohibitio": ["prohibition", "restrain", "forbidding"],
    "inflatio": ["inflation", "flatulence"],
    "avesniis": ["avesnes"],
    "superna": ["northeast", "by", "north", "wind"],
    "anser": ["goose"],
    "humanitas": ["kindness", "culture", "refinement"],
    "posteri": ["posterity"],
    "iucunditas": ["pleasure", "charm"],
    "amaritudo": ["bitterness"],
    "leno": ["procurer", "go-between"],
    "accommodo": ["adjust", "adapt", "accommodate", "oneself"],
    "bellicus": ["martial", "military", "war-like"],
    "patrocinor": ["protect", "defend", "support", "patronize"],
    "acerbitas": ["harshness", "bitterness"],
    "exorsus": ["begun"],
    "equus": ["horse", "steed", "mount"],
    "potior": ["gen", "dat", "possess", "hold", "get", "possession", "of"],
    "verbera": ["in", "pl", "blows", "beating", "thrashing"],
    "eicio,eiectum": ["throw", "out", "eject", "drive", "out"],
    "contagio,contagium": ["contagion", "infection", "touching", "contact"],
    "orbis": ["circle", "orb"],
    "defleo": ["bewail", "weep", "for"],
    "aperio": ["uncover", "lay", "bare", "reveal", "make", "clear"],
    "constanter": ["steadily", "firmly"],
    "senex,senis": ["old", "aged", "old", "man"],
    "frustra,esse": ["be", "deceived", "be", "mistaken"],
    "mendosus": ["faulty", "full", "faults"],
    "contineo,contigi,contectum": ["contineo", "border", "on", "befall", "good", "luck"],
    "edo": ["put", "forth", "give", "out"],
    "commoneo": ["impress", "upon", "one", "remind"],
    "coniuro": ["take", "an", "oath", "together", "plot", "conspire"],
    "cursim": ["hastily", "quickly", "rapidly"],
    "fas": ["divine", "law", "command", "fate", "destiny", "lawful", "allowed"],
    "adeptio": ["attainment", "obtaining"],
    "princeps": ["chief", "prince"],
    "frendo": ["gnash", "teeth", "crush", "bruise", "grind"],
    "nunc": ["now", "at", "present", "time"],
    "pasco": ["graze", "forage", "browse"],
    "incido,in,mentionem": ["incido", "happen", "mention"],
    "surculus": ["shoot", "sprout"],
    "frango,fracta": ["break", "in", "pieces", "shatter"],
    "infitior": ["deny", "deny", "debt", "refuse", "return", "something"],
    "ego": ["i", ";", "i", "can't", "live", "without", "you", "baby"],
    "consuefacio": ["accustom", "acclimate", "become", "used", "to"],
    "relaxo": ["loosen", "enlarge", "relax", "ease", "lighten"],
    "pestifere": ["destructively", "injuriously"],
    "includo": ["shut", "in", "enclose", "establish", "siege", "surround"],
    "sepulchrum": ["grave", "tomb", "sepulcher"],
    "inops": ["poor", "helpless", "in", "need"],
    "ferrum": ["iron", "sword"],
    "procul": ["far", "at", "from", "distance"],
    "andegavense": ["anjou"],
    "bellus": ["beautiful", "pretty", "charming", "handsome"],
    "vestis": ["clothing", "garment", "covering", "blanket", "carpet", "tapestry"],
    "claudus": ["lame"],
    "illic": ["there", "at", "that", "place", "therein", "in", "that", "matter"],
    "desolo": ["leave", "desolate", "abandoned", "forsake"],
    "coloro": ["color"],
    "caute,cautim": ["cautiously", "with", "security"],
    "domina,domina": ["lady", "mistress"],
    "passim": ["far", "wide", "everywhere", "scattered", "about"],
    "accuso": ["accuse", "blame", "find", "fault", "with"],
    "sacrificum": ["sacrifice"],
    "bellum": ["war"],
    "cresco": ["grow", "increase", "expand"],
    "bardus": ["stupid", "slow", "dull"],
    "carbo,carbonis": ["carbon", "coal", "charcoal"],
    "famulatus": ["servitude", "slavery", "service"],
    "ius,iurandum,iuris,iurandi,etc": ["ius", "iurandum", "iuris", "iurandi", "oath"],
    "domus": ["house", "home", "residence"],
    "hunnam": ["bunna"],
    "tumultus": ["uprising", "disturbance", "riot", "tumult"],
    "magis": ["more", "greater", "extent", "rather", "for", "preference"],
    "nequaquam": ["by", "no", "means", "not", "at", "all"],
    "dimitto": ["break", "up", "dismiss", "leave", "abandon"],
    "contages": ["touch", "contact"],
    "sanus": ["sound", "healthy", "sane"],
    "falsus": ["false", "deceptive"],
    "contineo": ["hold", "back", "restrain"],
    "indignatio": ["indignation"],
    "decens,decenter": ["properly", "fittingly", "suitably"],
    "nuntio": ["announce", "report", "relate"],
    "indomitus": ["untamed", "wild"],
    "ignavus": ["lazy", "listless", "inert", "sluggish", "cowardly", "coward"],
    "insula": ["island"],
    "redono": ["give", "back", "give", "up"],
    "aurissiodorenses": ["auxerre", "dept", "yonne", "between", "paris", "dijon"],
    "victor": ["victor", "winner"],
    "crastinus": ["of", "morrow", "morrow"],
    "mollio": ["soften", "make", "pliant"],
    "quaestio,questio": ["seeking", "searching", "inquiry", "investigation"],
    "firmo": ["assert", "maintain", "strengthen", "make", "firm", "encourage"],
    "procurator": ["manager", "bailiff", "agent"],
    "exinde": ["thence", "next", "thereupon", "after", "that", "then", "accordingly"],
    "mille": ["thousand"],
    "crebro": ["repeatedly", "often", "one", "after", "other", "time", "after", "time"],
    "quisque": ["each", "one", "each", "person"],
    "celo": ["hide", "conceal", "keep", "secret"],
    "adficio": ["affect", "afflict", "weaken", "sap", "exhaust", "drain"],
    "mollis": ["adj", "soft", "pliant", "flexible", "easily", "moved", "gentle"],
    "sacrilegus": ["sacrilegious", "impious"],
    "famulus": ["servant"],
    "ludus": ["game", "sport", "school"],
    "desipio": ["act", "foolishly", "play", "fool", "make", "an", "ass", "one's", "self"],
    "ultio,ultionis": ["avenging", "punishment", "revenge"],
    "santiago": ["st", "james"],
    "toties,totiens": ["so", "many", "times", "so", "often"],
    "sino": ["allow", "suffer", "permit", "let"],
    "deliciae": ["allurements", "charms", "delights", "fancies", "sweetheart"],
    "consurgo": ["stand", "up", "rise", "up", "arise", "break", "out"],
    "dissero": ["examine", "treat", "discuss"],
    "tenus": ["after", "name", "in", "abl", "gen", "up", "down", "as", "far", "as"],
    "sine": ["abl", "without"],
    "decoro": ["beautify", "embellish", "adorn"],
    "vultur,voltur,vulturius,volturius": ["vulture"],
    "ventosus": ["full", "wind", "windy", "breezy"],
    "remaneo": ["remain", "behind", "stay", "continue"],
    "trans": ["acc", "across"],
    "pariter": ["equally", "in", "like", "manner", "as", "well"],
    "auctus": ["growth", "enlargement", "increase"],
    "perscribo": ["write", "out", "write", "down", "place", "on", "record"],
    "pulchritudo,pulchritudinis": ["beauty", "fineness"],
    "inolesco": ["grow", "in", "on"],
    "posco": ["call", "upon", "ask", "earnestly", "request"],
    "exoro": ["prevail", "upon", "person", "entreat", "successfully"],
    "niteo": ["shine", "glitter", "be", "bright", "glow", "be", "sleek", "flourish"],
    "honor": ["honor", "esteem", "public", "office"],
    "possum,posse,potum": ["possum", "be", "able", "avail", "have", "influence"],
    "claro": ["make", "bright", "clear", "make", "clear", "in", "mind"],
    "quovis": ["whatever", "place", "you", "will"],
    "potissimus": ["best", "all", "chief", "principal"],
    "puella": ["girl"],
    "centum": ["indecl", "one", "hundred", "100"],
    "mancipo,mancepo": ["sell", "formally", "turn", "over", "give", "in charge"],
    "peccatus": ["sin"],
    "vigilo": ["be", "awake", "watch", "be", "vigilant", "keep", "vigil"],
    "timor": ["fear", "dread", "object", "causing", "fear"],
    "matertera": ["maternal", "aunt"],
    "combibo": ["drink", "up", "suck", "in"],
    "duco": ["calculate", "count", "reckon", "esteem", "considered"],
    "perdignus": ["very", "worthy"],
    "sollicito": ["stir", "up", "incite", "arouse"],
    "lima": ["file", "polishing", "revision"],
    "stabulaus": ["stavelot"],
    "admitto": ["admit", "receive"],
    "cras": ["adv", "tomorrow", "on", "morrow"],
    "sustineo": ["hold", "up", "sustain", "endure"],
    "gero": ["carry", "bear", "wear", "bear", "give", "birth", "carry", "about"],
    "oblittero": ["cancel", "blot", "out"],
    "votum,": ["votum", "prayer", "wish", "desire", "promise", "god"],
    "dilabor": ["break", "up", "scatter", "dissolve", "slip", "away", "fall", "apart"],
    "humus": ["ground", "earth", "soil", "land", "country"],
    "silentium": ["religion", "faultlessness", "perfection"],
    "laetifico,letifico": ["fertilize", "cheer", "gladden", "delight"],
    "pollicitus": ["promised", "promise"],
    "arbustum": ["vineyard", "planted", "with", "trees"],
    "tergo,a,tergo,": ["tergo", "tergo", "in", "rear", "from", "behind"],
    "sedeo,sedi,sessum": ["sedeo", "sit"],
    "polenta": ["pearl", "barley", "barley", "groats"],
    "ferus": ["fierce", "wild", "savage", "untamed"],
    "castellandum": ["chateaudun"],
    "mihi": ["dat", "me", "give", "me", "land", "lots", "land"],
    "acerbus": ["bitter", "gloomy", "dark"],
    "aldenard": ["audenarde"],
    "decumbo": ["fall", "fall", "into", "lie", "down"],
    "infamo": ["put", "shame", "disgrace"],
    "sententia": ["opinion", "thought", "way", "thinking", "meaning", "purpose"],
    "pupula": ["pupil", "eye"],
    "inquam": ["i", "say"],
    "alii": ["some", "others"],
    "solitudo,solitudinis": ["loneliness", "solitude"],
    "prompte": ["promptly", "resolutely", "readily"],
    "perturbo": ["disturb", "trouble", "perturb", "disrupt"],
    "donum": ["gift", "present", "donation"],
    "huius": ["fem", "sing", "gen", "they", "are", "fond", "this", "change"],
    "insisto": ["enter", "upon", "[a", "journey]", "tread;", "with", "d", "follow"],
    "sensus": ["feeling", "sense"],
    "promptu": ["in", "be", "ready", "be", "easy", "be", "clear"],
    "hodie": ["today"],
    "vindico": ["avenge", "punish", "liberate", "deliver", "protect"],
    "expostulo": ["demand", "earnestly", "make", "claim"],
    "varietas": ["variety", "differences", "diversity"],
    "invetero": ["give", "duration", "render", "old"],
    "plorator": ["lamenter"],
    "lamentabilis": ["lamentable", "mournful"],
    "vitiosus": ["vicious", "full", "vice", "corrupt"],
    "dulcitudo,dulcitudinis": ["dum:", "while", "as", "long", "as", "until"],
    "invicem": ["one", "after", "other", "by", "turns", "mutually", "each", "other"],
    "loci": ["pl", "passages", "in", "literary", "works"],
    "loco": ["place", "put", "position"],
    "promissio": ["promise"],
    "exorior": ["rise", "spring", "up", "issue", "appear", "come", "forward"],
    "his": ["neut", "pl", "abl", "she", "earned", "it", "by", "these", "her", "deeds"],
    "admoneo": ["admonish", "advise"],
    "venustas": ["loveliness", "charm", "attractiveness", "beauty"],
    "scindo": ["cut", "rend", "split", "divide", "separate"],
    "tam": ["such", "degree", "so", "so", "far"],
    "trepide": ["with", "trepidation", "in", "confusion"],
    "tantillus": ["so", "little", "so", "small"],
    "armarium": ["cupboard", "chest", "safe", "for", "food", "clothing", "money"],
    "perficio,perfeci,perfectum": ["perficio", "do", "thoroughly", "accomplish", "bring", "about"],
    "conculco": ["tread", "under", "foot", "despise", "oppress", "suppress"],
    "lama": ["bog", "slough"],
    "usus": ["use", "experience", "skill", "advantage"],
    "elatus": ["puff-up", "proud", "oneself", "arrogant"],
    "scaldus": ["scheldt"],
    "palea": ["chaff"],
    "fortunate": ["fortunately"],
    "sic": ["so", "thus", "yes", "that", "is", "so", "that", "is", "right"],
    "natio": ["nation", "people"],
    "callidus": ["clever", "dextrous", "experienced", "skilful", "cunning", "sly"],
    "proinde,quasi,proinde,ac,si": ["proinde", "quasi", "proinde", "just", "as", "if"],
    "extorqueo": ["twist", "wrench", "dislocate", "extort", "by", "force"],
    "progigno,progenui,progenitum": ["progigno", "engender", "bring", "forth"],
    "pueriliter": ["boyishly", "childishly", "foolishly"],
    "advoco": ["summon", "call", "call", "in", "an", "advisor"],
    "eximius": ["extraordinary", "excellent", "fine", "superb"],
    "dudum": ["for", "long", "while", "long", "while", "ago", "some", "time", "age"],
    "penitus": ["adv", "inside", "widely", "through", "through", "completely"],
    "comprehendo": ["embrace", "take", "firmly", "include", "seize"],
    "cuppedia": ["delicacies", "candies", "sweetmeats"],
    "luxuria": ["luxury", "extravagance", "opulence"],
    "arbor": ["tree"],
    "doceo,docui,doctum": ["doceo", "instruct", "teach", "tutor"],
    "inflammatio": ["setting", "afire", "people", "inflaming", "souls", "inspiring"],
    "prolix": ["long", "stretching"],
    "rapio,rapui,ratum": ["rapio", "seize", "snatch", "carry", "away"],
    "infinitas,infinitio": ["eternity", "infinity", "endlessness"],
    "repletus": ["filled", "full"],
    "invalesco": ["gather", "strength", "become", "stronger"],
    "turbatio": ["disturbance", "confusion"],
    "dissimulo": ["conceal", "disguise", "keep", "secret"],
    "dies,diei": ["day"],
    "desidero": ["long", "for", "wish", "for", "greatly", "miss"],
    "coloratus": ["colored", "dark-complexioned"],
    "deprecator": ["intercessor", "one", "who", "pleads", "on", "behalf"],
    "mitigo": ["make", "mild", "ripe", "make", "smooth", "pacify", "appease"],
    "intereo": ["perish", "die"],
    "madesco": ["get", "wet"],
    "verecundia": ["feeling", "shame", "shame", "bashfulness"],
    "lingua": ["language", "tongue", "speech"],
    "contabesco": ["waste", "slowly", "away", "decline", "in", "health"],
    "subito": ["suddenly", "unexpectedly"],
    "prae,se,ferre,pre,se,ferre": ["prae", "se", "ferre", "pre", "show", "exhibit", "on", "account", "of"],
    "muto": ["punish", "fine", "mulct"],
    "agnitio": ["recognition", "knowledge"],
    "piscis,piscis": ["fish"],
    "lutosensis": ["leuze"],
    "spero": ["hope", "for", "hope"],
    "praecido": ["cut", "short", "lop", "mutilate"],
    "custodiae,custodie": ["guards", "wardens"],
    "os,oris": ["mouth", "face", "countenance"],
    "prosequor,prosecutus": ["attack", "go", "with", "pursue", "attend"],
    "testimonium": ["proof", "evidence", "witness", "indication"],
    "occido,occidi,occasum": ["occido", "fall", "fall", "down", "for", "sun", "set"],
    "mediocris": ["ordinary", "average", "fair", "moderate", "mediocre"],
    "cedo,cessi,cessum": ["cedo", "grant", "yield"],
    "episcopalis": ["episcopal"],
    "fautor": ["favorer", "promoter", "patron", "partisan", "supporter"],
    "labor": ["hardship", "fatigue", "distress"],
    "mellitus": ["honeyed", "sweet", "as", "honey"],
    "obruo": ["overwhelm", "destroy"],
    "decorus": ["beautiful", "graceful", "charming", "proper", "fit", "becoming"],
    "saepe,sepe": ["often", "frequently", "repeatedly"],
    "detineo": ["hold", "off", "hold", "back", "detain"],
    "prosper": ["favorable", "fortunate", "lucky", "prosperous"],
    "metuo": ["fear", "dread", "be", "frightened"],
    "ullus": ["any"],
    "compositus": ["orderly", "matching", "made", "up", "pieces"],
    "lacrima": ["tears", "exudations", "from", "some", "plants"],
    "facilis": ["easy", "agreeable", "affable", "pleasant"],
    "tribuo": ["give", "out", "divide", "allot", "assign", "grant", "give", "allow"],
    "officium": ["duty", "service", "job"],
    "nihil": ["undeclinable", "nothing"],
    "quamobrem,quam,ob,rem": ["quamobrem", "quam", "wherefore?", "why?", "for", "which", "reason"],
    "dissimilis": ["unlike", "different", "disparate", "dissimilar", "distinct"],
    "frons": ["forehead", "brow", "front"],
    "celeritas": ["speed", "swiftness", "rapidity", "quickness"],
    "praeclarus,preclarus": ["excellent", "famous", "beautiful", "striking"],
    "habitus": ["disposed", "in", "certain", "condition"],
    "eximietate": ["uncommonness", "excellence"],
    "labrusca": ["wild", "grape", "vine"],
    "cunctor": ["delay", "impede", "hold", "up"],
    "modo": ["now", "just", "now", "only"],
    "tungris": ["tongres"],
    "amoveo": ["move", "away", "remove", "take", "out", "shift"],
    "socer": ["father", "in", "law"],
    "salveo": ["be", "well", "be", "in", "good", "health"],
    "namucense": ["namur"],
    "pes,pedis": ["foot"],
    "fines,finium": ["boundaries", "limits", "territory"],
    "epulor": ["feast", "feast", "on"],
    "puteus": ["well", "pit"],
    "illo": ["masc", "sing", "abl", "he", "gave", "plenty", "for", "that", "field"],
    "lepus": ["hare", "rabbit"],
    "festinus": ["hastening", "hasty"],
    "recolo": ["reflect", "upon", "consider", "recall"],
    "illi": ["neut", "sing", "dat", "i'd", "give", "my", "right", "arm", "for", "those", "cookies"],
    "vinculum": ["bond", "fetter", "tie"],
    "fors,fortis": ["chance", "luck", "fortune"],
    "laetificus,letificus": ["gladdening", "joyous", "spreading", "happiness"],
    "statim": ["firmly", "steadfastly", "on", "spot", "at", "once", "immediately"],
    "pessum": ["ground", "bottom", "downward"],
    "phasma,phasmatis": ["ghost", "spirit", "specter"],
    "illa": ["neut", "pl", "nom", "those", "arms", "belong", "victor"],
    "quamquam": ["nevertheless", "yet", "beginning", "sentence", "though"],
    "traho,traxi,tractum": ["drag", "pull", "derive", "get"],
    "omnipotens": ["all-powerful", "almighty", "omnipotent"],
    "semel": ["single", "time", "for", "first", "time", "even", "once", "once", "ever"],
    "remando": ["send", "back", "word"],
    "exulto": ["exult", "be", "joyful"],
    "vehemens": ["violent", "furious", "impetuous"],
    "aliquid": ["someone", "somebody", "something"],
    "postpono": ["put", "after", "consider", "secondary"],
    "vehementer": ["violently", "forcefully", "strongly", "exceedingly"],
    "quisnam,quidnam": ["who", "what"],
    "vestigium": ["footstep", "trace", "mark"],
    "aliquis": ["someone", "anyone", "anything", "adv", "in", "any", "respect"],
    "nepos,nepotis": ["grandson"],
    "contigo": ["with", "dat", "happen", "befall"],
    "opinio": ["opinion", "report", "rumor", "conjecture", "report"],
    "carnotense": ["chartres"],
    "exigo": ["complete", "finish", "determine", "decide", "settle"],
    "unde": ["whence", "from", "where", "how", "from", "whom"],
    "occurro": ["fall", "upon", "attack", "work", "against", "counteract"],
    "lapsus": ["fall", "fault", "error", "sliding", "graduate", "movement"],
    "sarcina": ["bundle", "pack", "burden", "load"],
    "flamma": ["flame", "fire"],
    "sceleratus": ["wicked", "accursed", "infamous", "criminal"],
    "acidus": ["sharp", "sour"],
    "inedicabilis": ["unexplainable", "inexplicable"],
    "insania": ["insanity", "irrationality", "madness", "folly"],
    "domesticus": ["domestic", "civil"],
    "domito": ["tame", "subdue", "break", "in"],
    "lucrosus": ["profitable", "gainful"],
    "supervacuus": ["superfluous", "arrive", "come", "up", "arrive", "unexpectedly"],
    "quo": ["neut", "sing", "abl", "eagerness", "through", "which", "he", "died"],
    "scaphium,sciphus": ["cap", "pot", "bowl", "drinking", "vessel"],
    "morsus": ["biting", "bite", "also", "sting", "pain"],
    "impensa": ["expense", "outlay"],
    "pyropus": ["bronze"],
    "profor,profari,profatus": ["profor", "speak", "out"],
    "praeterea,preterea": ["besides", "further", "hereafter"],
    "infigo": ["fix", "fasten", "imprint", "impress"],
    "instruo": ["prepare", "provide", "draw", "up", "an", "order", "battle"],
    "hordeum,ordeum": ["barley"],
    "timeo": ["fear", "be", "afraid", "dread"],
    "abscido": ["cut", "off", "separate", "take", "away"],
    "vox,vocis,": ["vox", "vocis", "voice", "word", "med", "power", "right", "authority"],
    "voluptarius,": ["voluptarius", "pleasant", "one", "devoted", "pleasure"],
    "pharetra": ["quiver"],
    "theatrum": ["theater"],
    "caelum": ["sky", "heaven"],
    "utrum": ["whether"],
    "resumo,resumpsi,resumptum": ["renew", "repeat", "resume"],
    "optimus": ["one", "best", "aristocrat", "noble"],
    "fatigo": ["worry", "fatigue", "vex", "harass", "tease"],
    "aegretudo,egretudo": ["sickness", "mental", "illness"],
    "crustulum": ["pastry", "cookie"],
    "frater": ["brother"],
    "scelus,sceleris": ["crime", "sin", "evil", "deed", "wickedness"],
    "pauper": ["poor", "with", "few", "means", "poverty-stricken"],
    "opportune": ["adv", "opportunely", "conveniently"],
    "cinis,cineris": ["ashes", "embers"],
    "adopto": ["wish", "for", "oneself", "adopt", "select", "pick", "out"],
    "contemptio": ["scorn", "disdain", "contempt"],
    "coniecto": ["throw", "together", "infer", "guess", "conclude"],
    "perturpis": ["very", "disgraceful"],
    "delego": ["transfer", "commit", "assign", "impute", "attribute", "ascribe"],
    "lacteus": ["of", "milk", "milky", "milk-white"],
    "volva,vulva,": ["volva", "vulva", "womb", "particularly", "that", "sow"],
    "harum": ["fem", "pl", "gen", "city", "wall", "had", "four", "these", "gates"],
    "iudicium": ["judgment", "decision", "opinion", "trial"],
    "excipio": ["excepi", "exceptum", "take", "out", "except", "take", "capture"],
    "corona": ["crown", "diadem"],
    "eluo": ["wash", "out", "rinse", "cleanse", "squander", "waste"],
    "taruennam": ["rouanne"],
    "lugeo": ["mourn", "be", "in", "mourning", "grieve", "tans,", "lament", "bewail"],
    "benevolentia": ["benevolence", "kindness", "good", "will"],
    "ingratus": ["ungrateful", "unpleasant", "disagreeable"],
    "impendium": ["expenditures", "outlay", "interest", "on", "loan"],
    "comes,comitis": ["companion", "friend", "comrade", "count"],
    "directus": ["plain", "simple", "direct", "open", "straightforward"],
    "tabernus": ["booth", "hut", "cottage", "hove", "small", "shop", "inn", "tavern"],
    "despicio": ["look", "down", "regard", "from", "above", "despise"],
    "merces,mercedis": ["pay", "reward", "recompense", "compensation"],
    "orno": ["equip", "furnish", "supply", "decorate", "adorn"],
    "iuro": ["swear", "make", "an", "oath"],
    "prudenter": ["wisely", "discreetly"],
    "universus": ["combined", "in", "one", "whole", "entire"],
    "inanis": ["empty", "vain", "inane"],
    "purpura": ["purple", "dye", "purple", "cloth", "high", "rank", "emperorship"],
    "equitatus": ["cavalry", "horsemen", "classical"],
    "amiculum": ["cloak", "cape"],
    "universum": ["universe", "world"],
    "innuo": ["give", "nod", "give", "sign", "to"],
    "torrens": ["rushing", "seething", "burning", "parched", "torrent"],
    "amplitudo": ["size", "breadth", "dignity", "grandeur", "greatness"],
    "inflammo": ["set", "on", "fire", "inflame", "torch", "kindle"],
    "macto": ["magnify", "glorify", "honor", "slay", "fight", "punish", "afflict"],
    "numerus": ["total", "category", "class", "number"],
    "temperantia": ["moderation", "self-control", "temperance"],
    "circumvenio": ["beset", "assail"],
    "provolvere,se": ["throw", "oneself", "down", "abase", "oneself"],
    "somniculosus": ["sleepy", "drowsy"],
    "relictus": ["fr", "relinquo", "having", "inherited", "been", "bequeathed"],
    "recuso": ["refuse"],
    "dictata": ["things", "dictated", "lessons", "presents"],
    "vaco": ["be", "free", "from", "work", "master", "property"],
    "seorsum": ["apart", "separately"],
    "tracto": ["drag", "handle", "treat", "discuss", "deal", "with"],
    "concito": ["move", "violently", "stir", "up", "excite"],
    "delibero": ["consider", "deliberate"],
    "nihilum": ["nothing"],
    "impunitus": ["unpunished", "unrestrained", "safe"],
    "laevus,levus": ["left", "hand", "left", "side", "left-handed"],
    "finitimus,finitumus": ["neighboring", "adjacent", "related", "similar"],
    "pignus": ["pawn", "pledge", "token", "in", "pl", "persons", "in", "pledges", "of"],
    "inconsulte": ["indiscreetly"],
    "eo,ire,itum": ["eo", "go", "advance", "proceed", "travel", "move", "along", "progress"],
    "hasnonium": ["hasnon"],
    "calculus": ["pebble", "stone"],
    "progressio": ["advance", "progress", "increase"],
    "pertinaciter": ["stubbornly", "obstinately"],
    "promitto": ["let", "go", "forward", "send", "forth", "promise", "undertake"],
    "prope": ["near", "near", "not", "far", "not", "long", "from", "now"],
    "quadrivium": ["crossroads", "place", "where", "four", "roads", "meet"],
    "nusquam,esse": ["not", "exist"],
    "iumentum": ["beast", "burden"],
    "rigor": ["stiffness", "hardness", "sternness"],
    "quadruplator": ["an", "exaggerator", "informer"],
    "iugis,e": ["perpetual", "continuous"],
    "fides": ["promise", "assurance", "word", "honor", "engagement"],
    "iacio": ["throw", "cast", "hurl", "lay", "scatter", "diffuse"],
    "inexpugnabilis": ["impregnable", "unconquerable", "not", "be", "taken", "by", "force"],
    "hostes,hostium": ["enemy"],
    "hypocrita": ["hypocrite"],
    "dens": ["dentis", "tooth"],
    "alienus": ["somebody", "else's", "foreign", "alien", "strange", "different"],
    "letanie": ["litany"],
    "inde": ["thence", "from", "there", "for", "that", "reason", "thereafter", "then"],
    "oratio": ["speech", "address", "oration"],
    "infectus": ["unworked", "not", "done", "unfinished", "incomplete"],
    "fimus": ["dung", "dirt", "filth", "manure"],
    "fundo": ["milit", "rout", "scatter", "defeat", "put", "flight"],
    "conforto": ["strengthen", "much"],
    "hereditas": ["inheritance", "often", "simply", "'property'"],
    "territo": ["scare", "frighten", "intimidate"],
    "praecelsus,precelsus": ["exceedingly", "high"],
    "contraho": ["draw", "together", "collect", "assemble", "carry", "out"],
    "dedecor": ["unseemly", "shameful", "disgraceful", "dishonorable"],
    "magus": ["magical"],
    "inflatius": ["too", "pompous", "on", "grander", "scale"],
    "vulnus,": ["vulnus", "wound"],
    "aliqua": ["some"],
    "texo": ["main", "verb", "for", "weaving", "cloth"],
    "contamino": ["pollute", "infect"],
    "ver,veris": ["spring", "production", "spring"],
    "frequento": ["crowd", "collect", "in", "large", "number", "visit"],
    "quisquam": ["anyone", "anything"],
    "diligo": ["choose", "out", "esteem", "highly", "prize", "love"],
    "nutrio": ["suckle", "nourish", "bring", "up", "rear"],
    "exaequo,exequo": ["be", "like", "equal", "make", "level", "even", "relate"],
    "textor,textrix": ["weaver"],
    "aestus,estus": ["heat", "tide"],
    "insperatus": ["unexpected", "unlooked", "for", "unanticipated"],
    "egeo": ["need", "lack", "want", "be", "without"],
    "animadverto": ["turn", "mind", "take", "notice", "see", "perceive"],
    "virgo": ["maiden", "virgin", "young", "girl"],
    "lemma": ["theme", "title", "epigram"],
    "dormio": ["sleep", "slumber", "siesta", "nap"],
    "hesito,haesito": ["be", "unsure", "uncertain", "wavering"],
    "pruma": ["prums"],
    "intempestivus": ["unseasonable", "untimely", "immoderate"],
    "praesentia,presencia": ["power", "effect"],
    "virga": ["green", "twig", "rod", "stick", "wand", "broom", "streak", "stripe"],
    "rarus": ["rare", "uncommon"],
    "voco,": ["voco", "call", "summon", "name", "invite"],
    "lebes": ["copper", "kettle", "basin", "cauldron"],
    "tergiversatio": ["backwardness", "reluctance", "evasion"],
    "laedo,ledo": ["strike", "hit", "hurt", "damage", "offend", "annoy", "violate"],
    "cubo": ["lie", "down", "recline"],
    "proficuus": ["proficiscor:", "start", "forward", "set", "out", "depart", "arise"],
    "matrimonium": ["marriage"],
    "emo,emi,emptum": ["emo", "buy", "purchase"],
    "tergum": ["back", "rear"],
    "transfero,transtuli,translatum": ["transfero", "carry", "across", "transfer", "convey"],
    "do,dare,dedi,datum": ["do", "dare", "give", "offer", "convey", "offer", "donate", "furnish"],
    "exsequor": ["execute", "avenge", "punish", "relate", "describe", "explain"],
    "effundo": ["pour", "out", "pour", "forth", "shed", "utter"],
    "emendo": ["amend", "correct"],
    "trucido": ["kill", "cruelly", "slay", "butcher", "massacre", "slaughter"],
    "simulatio": ["pretense"],
    "nisi": ["if", "not", "unless", "except"],
    "dumtaxat": ["at", "least", "not", "less", "than", "at", "most", "not", "more", "than"],
    "currus": ["cart", "plow", "with", "wheels"],
    "nutrimens": ["food", "nourishment"],
    "partim": ["partly", "some"],
    "cunctatio": ["delay"],
    "volutabrum,": ["volutabrum", "pigsty", "slough"],
    "tumulus": ["mound", "grave", "heap", "earth"],
    "edo,edi,essum": ["edo", "eat", "consume", "devour", "waste"],
    "furs": ["thief"],
    "idoneus": ["proper", "worthy", "fitting", "deserving", "capable"],
    "penus,us": ["provender", "supplies", "victuals"],
    "benigne": ["kindly", "generously"],
    "progener": ["husband", "grand-daughter"],
    "proicio": ["throw", "forth", "fling", "abandon"],
    "ignarus": ["ignorant", "not", "knowing"],
    "asvesniis": ["of", "avesnes"],
    "moguntienses": ["mainz"],
    "elementum": ["first", "principle", "element", "basic", "constituent"],
    "thalassinus": ["sea-green"],
    "alioqui": ["adv", "otherwise"],
    "utilitas": ["utility", "usefulness"],
    "cubiculum": ["bedroom", "sleeping", "chamber"],
    "pugnacitas": ["desire", "fight", "pugnacity"],
    "pars,partis": ["part", "share", "direction"],
    "eminus": ["at", "distance", "from", "distance"],
    "supero": ["be", "above", "have", "upper", "hand", "surpass", "conquer", "overcome"],
    "exitiabilis,exitialis,exitosus": ["exitiabilis", "fatal", "deadly", "destructive", "lethal"],
    "pudeo": ["be", "ashamed"],
    "valetudo": ["health", "good", "health", "bad", "health"],
    "praevenio,prevenio": ["come", "before", "anticipate"],
    "pugnus": ["fist"],
    "tabula": ["board", "plank", "gaming", "board", "painted", "panel"],
    "membrana": ["thin", "skin", "film", "parchment", "membrane", "prepared", "skin"],
    "quercetum": ["an", "oak", "grove", "oak", "forest"],
    "convoco": ["call", "together", "convene"],
    "desposco": ["demand"],
    "legio": ["legion"],
    "leviculus": ["empty-headed", "vain", "silly"],
    "illos": ["masc", "pl", "they", "burned", "those", "houses", "ground"],
    "infelicitas": ["bad", "luck", "misfortune"],
    "quassatio": ["shaking"],
    "ilico": ["on", "spot", "immediately"],
    "totus": ["whole", "entire", "complete", "all"],
    "diligens": ["diligent", "careful"],
    "fidelitas": ["fidelity", "loyalty", "homage"],
    "fabula": ["fable", "story", "tale", "play"],
    "aqua": ["water"],
    "emoveo": ["move", "away", "remove", "take", "away"],
    "supplanto": ["trip", "up"],
    "insurgo,insurgi,insurrectum": ["insurgo", "rise", "up", "rebel", "revolt"],
    "arbitro,arbitror": ["witness", "bear", "witness", "judge", "arbitrate"],
    "periclitatus": ["put", "in", "peril", "endangered"],
    "expositus": ["open", "accessible", "exposed"],
    "perniciosus": ["pernicious", "destructive"],
    "demens": ["dementis", "insane", "mad", "out", "one's", "mind", "foolish"],
    "indico": ["proclaim", "make", "publicly", "known", "announce", "disclose"],
    "universitas": ["whole", "total", "universe", "world", "university"],
    "crudelis": ["cruel"],
    "adiuvo": ["help", "aid", "assist"],
    "commeo": ["go", "up", "down", "back", "forth", "in", "out"],
    "alter,alter": ["one", "other"],
    "claudo,clausus": ["confine", "shut", "up", "close", "blockade", "besiege"],
    "reperio": ["get", "again", "find", "ascertain", "discover", "invent"],
    "maiestas": ["majesty", "dignity", "greatness"],
    "pretium": ["price", "value", "reward"],
    "sol,solis": ["sun"],
    "promus": ["steward", "butler"],
    "quid": ["neut", "quis", "what"],
    "quia": ["because"],
    "ceno": ["dine"],
    "expetens": ["desirous", "eager"],
    "necesse": ["necessary", "unavoidable", "indispensable"],
    "cena": ["dinner", "meal"],
    "levitas": ["lightness", "levity", "fickleness", "inconstancy", "groundlessness"],
    "vilitas": ["cheapness", "low-price", "worthlessness"],
    "pessum,ire": ["sink", "be", "ruined", "destroyed", "be", "put", "an", "end"],
    "viduo": ["deprive"],
    "noster,nostri": ["our", "ours", "that", "old", "dream", "ours"],
    "jumentum": ["draft", "animal"],
    "confero": ["discuss", "debate", "confer", "betake", "oneself", "devote"],
    "patruus": ["paternal", "uncle"],
    "meus": ["my"],
    "dominus,domino": ["master", "lord"],
    "vorago,": ["chasm", "pit", "abyss"],
    "donec": ["up", "time", "when", "until", "as", "long", "as", "while"],
    "privus": ["with", "gen", "deprived", "of"],
    "pertinax": ["persistent", "firm", "mean", "stubborn", "obstinate"],
    "multi": ["many", "numerous", "common", "herd"],
    "multo": ["by", "much", "by", "far", "by", "great", "deal", "by", "lot"],
    "pomum": ["fruit", "apple"],
    "secundum": ["inf", "following", "after", "during", "according", "to"],
    "quantuscumque,quantacumque,quantumcumque": ["quantuscumque", "however", "great"],
    "iustus": ["just", "right", "equitable"],
    "insidiae": ["pl", "treachery", "ambush", "plot", "conspiracy"],
    "dissolutus": ["lax", "weak", "wanting", "in", "energy", "dissolute", "profligate"],
    "cursor": ["runner", "carrier", "messenger"],
    "tutamen,tutaminis": ["defense", "protection"],
    "notarius": ["stenographer", "class", "notary", "legal", "scribe"],
    "cohortor": ["encourage", "incite", "exhort"],
    "macer": ["thin", "lean"],
    "secundus": ["second"],
    "impetro": ["get", "accomplish", "effect", "obtain", "by", "asking"],
    "felix,felicis": ["lucky", "fortunate", "happy"],
    "ultra": ["beyond", "on", "far", "side", "of"],
    "commodum": ["convenience", "advantage", "opportunity", "comfort"],
    "debeo": ["owe", "be", "morally", "bound", "be", "bound", "by"],
    "varius": ["various", "varied"],
    "inviso": ["go", "see", "visit", "inspect", "look", "at"],
    "ne": ["that", "not", "in", "order", "that", "not", "in", "order", "not", "to"],
    "capto": ["grab", "try", "get", "grab", "at"],
    "infletus": ["unwept", "unmourned", "unlamented"],
    "recognosco": ["recognize", "recollect", "recall"],
    "conservo": ["preserve", "conserve", "maintain", "keep", "hold", "to"],
    "introduco": ["lead", "in", "introduce"],
    "arx,arcis": ["citadel", "stronghold", "fortress", "keep", "donjon"],
    "vendolius": ["vendeuil"],
    "operor": ["work", "labor", "toil", "take", "pains"],
    "subvenio": ["come", "aid", "succor", "relieve", "help", "assist"],
    "cohors": ["yard", "enclosure", "troop", "1", "10", "legion"],
    "arguo": ["show", "make", "clear", "attempt", "show"],
    "sanctus,rodoenus": ["st", "ouen"],
    "dilato": ["spread", "out", "extend", "expand", "increase"],
    "quasso": ["shake", "violently", "shake", "pieces", "break", "shatter"],
    "patientia": ["patience", "suffering", "endurance"],
    "pulcher,pulchra,pulchrum": ["pulcher", "beautiful", "handsome", "fine"],
    "quoque": ["also", "too"],
    "inflexus": ["bending", "curving"],
    "viriliter": ["manfully"],
    "eques,equitis": ["horseman", "cavalry", "man", "rider", "classical"],
    "plango,planxi,plactum": ["plango", "strike", "beat", "bewail", "mourn"],
    "laceratio": ["tearing", "mangling"],
    "perimo,peremi,peremptum": ["perimo", "destroy"],
    "saeta,equina": ["horse-hair"],
    "memini,meminisse": ["remember"],
    "turbo,onis": ["hurricane", "tornado", "that", "which", "spins"],
    "labes,labis": ["stain", "blemish", "disgrace", "infamy", "misfortune"],
    "lupus": ["wolf"],
    "infindo,infidi,infissum": ["infindo", "cut", "into"],
    "monstrum": ["portent", "omen", "monster"],
    "aegresco": ["become", "ill", "grow", "worse", "be", "ill"],
    "defungo": ["discharge", "one's", "duties", "quit", "retire", "die", "finish"],
    "tenax": ["grasping", "stingy", "clinging", "frugal", "obstinate"],
    "expono,exposui,expositum,": ["expono", "exposui", "expositum", "set", "forth", "explain", "expose"],
    "tolero": ["tolerate", "bear", "endure", "sustain"],
    "canonus": ["canon", "member", "cathedral", "chapter", "canonry", "augustinian"],
    "fleo": ["weep", "cry", "shed", "tears", "sob"],
    "absum": ["be", "absent", "be", "away", "be", "missing"],
    "rhetoricus": ["rhetorical"],
    "patria": ["fatherland", "one's", "native", "country", "homeland"],
    "turbatus": ["angered", "exasperated", "disturbed", "restless", "troubled"],
    "asperitas": ["roughness", "severity", "harshness", "fierceness"],
    "difficilis": ["difficult", "hard", "troublesome"],
    "malmundarium": ["malmedy"],
    "praeceptum,preceptum": ["precept"],
    "piger,pigra,pigrum": ["piger", "lazy", "slow", "dull"],
    "nidor": ["vapor", "smell", "reek", "odor"],
    "validus": ["strong", "mighty", "powerful", "exceeding"],
    "corrumpo": ["documents", "falsify", "character", "corrupt"],
    "scelero": ["pollute", "with", "guilt", "with", "blood"],
    "cribrum": ["sieve"],
    "instanter": ["urgently"],
    "adsum": ["assist", "be", "present", "be", "near", "be", "in", "attendance"],
    "redundantia": ["overflowing", "redundancy"],
    "infestus": ["aggressive", "hostile", "dangerous"],
    "nomine,tenus": ["nominally", "in", "name"],
    "cariosus": ["rotten", "decayed"],
    "incola,ae": ["resident", "inhabitant", "place"],
    "st,richarius": ["st", "riquier"],
    "prominens": ["jutting", "out", "standing", "out", "projection"],
    "haud": ["no", "not", "at", "all", "by", "no", "means"],
    "calcar,-is": ["calcar", "-is:", "spur"],
    "moratlis": ["mortal"],
    "confestim": ["immediately", "without", "delay"],
    "in,praesentia": ["for", "present"],
    "tondeo,totondi,tonsum": ["tondeo", "shave", "shear", "clip", "mow", "reap", "browse"],
    "plumbeus": ["leaden", "made", "lead", "dull", "stupid", "heavy", "oppressive", "bad"],
    "ostendo": ["show", "reveal", "present", "make", "plain", "declare"],
    "amissio,amissus": ["loss"],
    "increpare": ["rebuke", "chide", "scold"],
    "procinctu": ["prepared", "ready", "for", "battle"],
    "vobis,": ["dat", "you", "i'm", "talkin'", "you", "yeah", "talkin'", "'bout", "cindy"],
    "rota": ["wheel"],
    "maritus": ["husband"],
    "crinitus": ["long", "haired"],
    "emanio": ["flow", "out", "spread", "arise", "emanate", "originate"],
    "conturbo": ["confuse", "scatter", "throw", "inconfusion", "distress"],
    "terreo": ["frighten", "terrify", "scare", "away", "deter"],
    "pluvia": ["rain", "shower"],
    "derelinquo": ["forsake", "desert", "abandon"],
    "cometes": ["comet"],
    "capillus": ["hair"],
    "percutio,percussum": ["strike", "hard", "pierce", "transfix", "shock"],
    "haec,hec": ["neut", "pl", "deborah", "always", "won", "these", "wars"],
    "peragro": ["wander", "through", "travel", "through"],
    "quatenus,quatinus": ["how", "far", "what", "extent", "where", "seeing", "that"],
    "aequus,equus": ["level", "even", "calm", "equal", "favorable", "just"],
    "parum,minus,minime": ["parum", "adv", "little", "too", "little", "not", "enough"],
    "mandatum": ["order", "decree", "mandate", "instruction"],
    "puer": ["boy"],
    "noceo": ["dat", "do", "harm", "inflict", "injury", "hurt"],
    "viscus": ["flesh", "internal", "organs", "bowels", "entrails", "heart"],
    "quomodo": ["in", "what", "manner", "how", "in", "whatever", "way", "somehow"],
    "forensis,e": ["legal"],
    "retineo": ["hold", "back", "restrain", "detain", "keep", "maintain"],
    "serius": ["serious", "grave", "solemn"],
    "honorabilis": ["respectful"],
    "episcopus": ["bishop"],
    "natalis,natalis": ["birthday"],
    "loquor,locutus": ["say", "speak", "tell"],
    "necne": ["or", "not"],
    "procella": ["storm", "tempest", "gale"],
    "pulpa": ["flesh"],
    "poeta": ["masc", "poet"],
    "tabesco": ["melt", "waste", "away", "pine", "be", "spoiled"],
    "simplex": ["simple", "unaffected"],
    "liber,libera,liberum": ["liber", "free", "independent", "unrestricted"],
    "valeo,valui,valiturus": ["valeo", "be", "strong", "have", "power", "be", "well"],
    "assentator": ["flatterer", "sycophant", "yes-man"],
    "talus": ["ankle", "ankle", "bone"],
    "vulgus,": ["vulgus", "common", "people", "mob", "rabble"],
    "dignus": ["abl", "worthy", "worthy", "meritorious"],
    "verbum": ["word"],
    "pulsus": ["beating", "blow", "push", "impulse", "influence"],
    "universi": ["all", "together"],
    "uberrime": ["most", "luxuriantly", "most", "abundantly", "most", "fruitfully"],
    "universe": ["generally", "in", "general"],
    "queror": ["complain", "lament", "bewail", "dogs", "whine", "whimper"],
    "opportunus": ["fit", "suitable", "time", "favorable", "dat", "liable", "to"],
    "adicio": ["direct", "address", "apply", "throw", "to"],
    "inclino": ["bend", "incline", "turn", "change", "fall", "back", "waver"],
    "sapientia": ["wisdom"],
    "proles": ["offspring", "descendants", "posterity", "plants:", "fruit"],
    "substantia": ["substance", "essence", "means", "subsistence", "property"],
    "occursus": ["meeting", "falling", "in", "running", "ineach", "other"],
    "optimates": ["aristocratic", "party"],
    "ignotus": ["unknown", "obscure", "ignorant", "ignoble"],
    "meridianus": ["midday", "afternoon", "south"],
    "comitto": ["entrust", "commit"],
    "aegrotatio,egrotatio": ["sickness", "illness"],
    "indebitus": ["not", "owed", "not", "due"],
    "lemiscus": ["ribbon"],
    "perculsus": ["shock"],
    "spolium": ["spoils", "plunder", "booty"],
    "luna": ["moon"],
    "termino": ["restrict", "define", "close", "set", "limit", "to"],
    "liberalis": ["courteous", "generous", "gentlemanly"],
    "invidia": ["envy", "jealousy", "hatred"],
    "expleo": ["make", "losses", "good", "fulfil", "discharge", "duties"],
    "priusquam": ["before"],
    "crucio": ["torture", "torment"],
    "vilis": ["cheap", "worth", "little"],
    "resisto": ["resist", "make", "stand", "oppose"],
    "helnonensis": ["elnon"],
    "diripio": ["separate", "tear", "apart", "pillage", "devastate", "lay", "waste"],
    "vae": ["interj", "woe", "alas", "woe", "to"],
    "explico": ["unfold", "unroll", "disentangle", "explain", "expound"],
    "propero": ["hasten", "accelerate", "speed", "up"],
    "repugno": ["fight", "against", "oppose", "resist", "be", "incompatible", "with"],
    "bene,melior,optime": ["well", "better", "best"],
    "consitor": ["sower", "planter"],
    "quanto": ["by", "how", "much", "comp", "adj", "adv"],
    "quanti": ["for", "how", "much", "at", "what", "price"],
    "obviam,ire": ["dat", "go", "meet", "oppose", "help", "remedy"],
    "omnis": ["all", "every"],
    "scientia": ["knowledge", "science", "skill"],
    "rectus": ["right", "correct", "proper", "upright", "natural", "plain"],
    "stultus": ["foolish", "fool"],
    "decimus": ["tenth"],
    "progenero": ["produce", "engender"],
    "quamdiu": ["such", "long", "time"],
    "amita": ["father's", "sister", "paternal", "aunt"],
    "collum": ["neck"],
    "rectum": ["virtue", "right"],
    "nauta": ["sailor"],
    "puto": ["clear", "settle", "up", "consider", "think", "believe", "suppose", "judge"],
    "navigo": ["sail", "navigate"],
    "placet": ["it", "is", "agreed", "it", "is", "resolved", "it", "seems", "good"],
    "salvus": ["safe", "sound"],
    "curvo": ["bend", "arch", "curve", "influence"],
    "recedo": ["go", "back", "retreat", "retire", "disappear"],
    "lepidus": ["charming", "witty", "pleasant", "elegant"],
    "legens,legentis": ["reader"],
    "laetans": ["rejoicing", "joyous"],
    "legatus": ["deputy", "ambassador", "envoy"],
    "levis": ["light", "slight", "trivial", "beardless", "bald", "light-armed"],
    "thema,thematis": ["theme"],
    "discrepo": ["differ", "be", "different", "vary", "disagree"],
    "leodie": ["liege"],
    "legatarius": ["legatee"],
    "placeo": ["dat", "please", "be", "agreeable", "to"],
    "profiteor": ["acknowledge", "confess", "offer", "promise"],
    "duro": ["harden", "last", "endure"],
    "nonnisi": ["not?", "not", "unless"],
    "deinde": ["next", "then", "thereafter", "from", "that", "place"],
    "sulum": ["each", "every"],
    "hoienses": ["huy", "belgium", "between", "liege", "namur"],
    "vestrum,vestri": ["your", "yours", "you", "make", "sing", "about", "your", "pretty", "gals"],
    "ille": ["masc", "nom", "sing", "that", "house", "is", "filthy"],
    "praevenio": ["get", "start", "of"],
    "speculum": ["mirror"],
    "illaturos": ["from", "infero", "'they", "would", "cause'"],
    "adimpleo": ["fulfill", "perform"],
    "dictito": ["say", "often", "reiterate"],
    "manentia": ["permanency"],
    "munus,muneris": ["service", "office", "function", "duty", "gift"],
    "scio": ["know", "understand"],
    "plorabilis": ["deplorable"],
    "sufficio": ["be", "sufficient", "suffice", "be", "enough"],
    "denique": ["at", "last", "finally", "again", "in", "short"],
    "pugnax": ["fond", "fighting", "combative", "stubborn", "contentious"],
    "studiose": ["eagerly"],
    "paganus": ["countryman", "peasant", "pagan"],
    "ecclesia": ["church"],
    "periculum": ["danger", "risk"],
    "contendo": ["assert", "maintain", "shoot", "missile", "cast"],
    "laudo": ["praise", "extoll", "commend", "name", "mention", "cite", "quote"],
    "expleo,explevi,expletum": ["fill", "up", "complete", "finish"],
    "pronepos,proneptos": ["great-grandson"],
    "prae,pre": ["adv", "before", "in", "front"],
    "ubi": ["when", "as", "soon", "as", "wherein", "whereby", "whereas"],
    "neque,neque": ["neither", "nor"],
    "adsumo,assumo": ["take", "oneself", "claim", "appropriate", "call"],
    "iuxta": ["close", "near", "time", "just", "before"],
    "nominatim": ["by", "name", "expressly"],
    "expletus": ["part", "perfect", "complete"],
    "illius": ["masc", "fem", "neut", "gen", "sing", "go", "ahead", "eat", "some", "that"],
    "praefoco,prefoco": ["choke", "suffocate"],
    "mens,mentis": ["mind", "thought", "intention", "intellect"],
    "sollers": ["clever", "skillful"],
    "laqueus": ["snare", "trap", "noose"],
    "ius,iuris": ["justice", "law", "right"],
    "porro": ["forward", "further", "next", "in", "turn", "of", "time", "long", "ago"],
    "tyrannus": ["tyrant", "absolute", "ruler"],
    "exstinguo,exstingui,exstinctum": ["extinguish", "put", "out"],
    "lubricus": ["oily", "slippery", "slick"],
    "competo": ["be", "appropriate", "suitable", "fit"]
}
