# Generated by Django 4.1.2 on 2022-10-21 19:30

from django.db import migrations, models
import django.db.models.deletion
import django_telemetry.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='WebTelemetry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=django_telemetry.models.gen_uuid, editable=False, unique=True)),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('host', models.CharField(max_length=1000)),
                ('path', models.CharField(max_length=1000)),
                ('method', models.CharField(max_length=50)),
                ('uri', models.CharField(max_length=2000)),
                ('status_code', models.IntegerField()),
                ('user_agent', models.CharField(blank=True, max_length=1000, null=True)),
                ('remote_addr', models.GenericIPAddressField()),
                ('remote_addr_fwd', models.GenericIPAddressField(blank=True, null=True)),
                ('meta', models.TextField()),
                ('headers', models.TextField()),
                ('cookies', models.TextField(blank=True, null=True)),
                ('get', models.TextField(blank=True, null=True)),
                ('post', models.TextField(blank=True, null=True)),
                ('raw_post', models.TextField(blank=True, null=True)),
                ('is_secure', models.BooleanField()),
                ('is_ajax', models.BooleanField()),
                ('response', models.TextField(blank=True, null=True)),
                ('duration', models.CharField(blank=True, max_length=255, null=True)),
                ('user_id', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='WebQuery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sql', models.TextField(null=True)),
                ('time', models.CharField(max_length=255, null=True)),
                ('telemetry', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='queries', to='django_telemetry.webtelemetry')),
            ],
        ),
    ]
