"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const start_execution_1 = require("../../lib/stepfunctions/start-execution");
/*
 * Stack verification steps:
 * * aws stepfunctions start-execution --input '{"hello": "world"}' --state-machine-arn <StateMachineARN>
 * * aws stepfunctions describe-execution --execution-arn <execution-arn>
 * * The output here should contain `status: "SUCCEEDED"` and `output`: '"Output": { "hello": "world"},'
 */
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const child = new sfn.StateMachine(this, 'Child', {
            definition: new sfn.Pass(this, 'Pass'),
        });
        const parent = new sfn.StateMachine(this, 'Parent', {
            definition: new start_execution_1.StepFunctionsStartExecution(this, 'Task', {
                stateMachine: child,
                input: sfn.TaskInput.fromObject({
                    hello: sfn.JsonPath.stringAt('$.hello'),
                }),
                integrationPattern: sfn.IntegrationPattern.RUN_JOB,
            }),
        });
        new core_1.CfnOutput(this, 'StateMachineARN', {
            value: parent.stateMachineArn,
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'integ-sfn-start-execution');
app.synth();
//# sourceMappingURL=data:application/json;base64,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