"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionInstance = exports.SubscriptionInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "SubscriptionInstanceProperty", { enumerable: true, get: function () { return dts_generated_1.RosSubscriptionInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::SubscriptionInstance`
 */
class SubscriptionInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::SubscriptionInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSubscriptionInstance = new dts_generated_1.RosSubscriptionInstance(this, id, {
            configuration: props.configuration,
            usedTime: props.usedTime,
            period: props.period,
            payType: props.payType,
            sourceEndpointInstanceType: props.sourceEndpointInstanceType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSubscriptionInstance;
        this.attrPrivateHost = rosSubscriptionInstance.attrPrivateHost;
        this.attrPublicHost = rosSubscriptionInstance.attrPublicHost;
        this.attrSubscribeTopic = rosSubscriptionInstance.attrSubscribeTopic;
        this.attrSubscriptionInstanceId = rosSubscriptionInstance.attrSubscriptionInstanceId;
        this.attrVpcHost = rosSubscriptionInstance.attrVpcHost;
    }
}
exports.SubscriptionInstance = SubscriptionInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3Vic2NyaXB0aW9uaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdWJzY3JpcHRpb25pbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTBEO0FBRXRCLDZHQUYzQix1Q0FBdUIsT0FFZ0M7QUFpRGhFOztHQUVHO0FBQ0gsTUFBYSxvQkFBcUIsU0FBUSxHQUFHLENBQUMsUUFBUTtJQWdDbEQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUFtQyxFQUFFLEVBQUUsbUNBQTJDLElBQUk7UUFDaEksS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLHVCQUF1QixHQUFHLElBQUksdUNBQXVCLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNuRSxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLDBCQUEwQjtZQUM1RCxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDbkIsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyx1QkFBdUIsQ0FBQztRQUN4QyxJQUFJLENBQUMsZUFBZSxHQUFHLHVCQUF1QixDQUFDLGVBQWUsQ0FBQztRQUMvRCxJQUFJLENBQUMsY0FBYyxHQUFHLHVCQUF1QixDQUFDLGNBQWMsQ0FBQztRQUM3RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsdUJBQXVCLENBQUMsa0JBQWtCLENBQUM7UUFDckUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLHVCQUF1QixDQUFDLDBCQUEwQixDQUFDO1FBQ3JGLElBQUksQ0FBQyxXQUFXLEdBQUcsdUJBQXVCLENBQUMsV0FBVyxDQUFDO0lBQzNELENBQUM7Q0FDSjtBQXpERCxvREF5REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NTdWJzY3JpcHRpb25JbnN0YW5jZSB9IGZyb20gJy4vZHRzLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1N1YnNjcmlwdGlvbkluc3RhbmNlIGFzIFN1YnNjcmlwdGlvbkluc3RhbmNlUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkRUUzo6U3Vic2NyaXB0aW9uSW5zdGFuY2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3Vic2NyaXB0aW9uSW5zdGFuY2VQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb25maWd1cmF0aW9uOiBTdWJzY3JpcHRpb24gY29uZmlndXJhdGlvbi5cbiAgICAgKi9cbiAgICByZWFkb25seSBjb25maWd1cmF0aW9uPzogUm9zU3Vic2NyaXB0aW9uSW5zdGFuY2UuQ29uZmlndXJhdGlvblByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGF5VHlwZTogUGF5bWVudCB0eXBlLiBWYWxpZCB2YWx1ZTpcbiAgICAgKiBQb3N0UGFpZDogUGF5LWFzLXlvdS1nbywgd2hpY2ggaXMgZGVmYXVsdCB2YWx1ZS5cbiAgICAgKiBQcmVQYWlkOiBzdWJzY3JpcHRpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGF5VHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHBlcmlvZDogVGhlIHVuaXQgb2YgdGhlIHN1YnNjcmlwdGlvbiBsZW5ndGguIFZhbGlkIHZhbHVlczogWWVhciBhbmQgTW9udGguXG4gICAgICogTm90ZTogWW91IG11c3Qgc3BlY2lmeSB0aGlzIHBhcmFtZXRlciBvbmx5IGlmIHlvdSBzZXQgdGhlIFBheVR5cGUgcGFyYW1ldGVyIHRvIFByZVBhaWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc291cmNlRW5kcG9pbnRJbnN0YW5jZVR5cGU6IERhdGEgc3Vic2NyaXB0aW9uIGluc3RhbmNlIHR5cGUsIHZhbHVlIGlzOk15U1FMOiBBcHNhcmFEQiBSRFMgZm9yIE15U1FMIGluc3RhbmNlIG9yIHNlbGYtbWFuYWdlZCBNeVNRTCBkYXRhYmFzZS5cbiAgICAgKiBQb2xhckRCOiBQb2xhckRCIGZvciBNeVNRTCBjbHVzdGVyLlxuICAgICAqIHBvbGFyZGJfbzogUG9sYXJEQiBPIEVkaXRpb24gY2x1c3Rlci5cbiAgICAgKiBwb2xhcmRiX3BnOiBQb2xhckRCIGZvciBQb3N0Z3JlU1FMIGNsdXN0ZXIuXG4gICAgICogRFJEUzogUG9sYXJEQi1YIGluc3RhbmNlIFYxLjAgb3IgVjIuMC5cbiAgICAgKiBQb3N0Z3JlU1FMOiBzZWxmLW1hbmFnZWQgUG9zdGdyZVNRTCBkYXRhYmFzZS5cbiAgICAgKiBPcmFjbGU6IHNlbGYtbWFuYWdlZCBPcmFjbGUgZGF0YWJhc2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc291cmNlRW5kcG9pbnRJbnN0YW5jZVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWdzOiBUYWdzIHRvIGF0dGFjaCB0byBpbnN0YW5jZS4gTWF4IHN1cHBvcnQgMjAgdGFncyB0byBhZGQgZHVyaW5nIGNyZWF0ZSBpbnN0YW5jZS4gRWFjaCB0YWcgd2l0aCB0d28gcHJvcGVydGllcyBLZXkgYW5kIFZhbHVlLCBhbmQgS2V5IGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBSb3NTdWJzY3JpcHRpb25JbnN0YW5jZS5UYWdzUHJvcGVydHlbXTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHVzZWRUaW1lOiBUaGUgc3Vic2NyaXB0aW9uIGxlbmd0aC5cbiAgICAgKiBOb3RlOiBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIG9ubHkgaWYgeW91IHNldCB0aGUgUGF5VHlwZSBwYXJhbWV0ZXIgdG8gUHJlUGFpZC5cbiAgICAgKiBZb3UgY2FuIHNldCB0aGUgUGVyaW9kIHBhcmFtZXRlciB0byBzcGVjaWZ5IHRoZSB1bml0IG9mIHRoZSBzdWJzY3JpcHRpb24gbGVuZ3RoLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHVzZWRUaW1lPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpEVFM6OlN1YnNjcmlwdGlvbkluc3RhbmNlYFxuICovXG5leHBvcnQgY2xhc3MgU3Vic2NyaXB0aW9uSW5zdGFuY2UgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFByaXZhdGVIb3N0OiBQcml2YXRlIGhvc3QuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJQcml2YXRlSG9zdDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFB1YmxpY0hvc3Q6IFB1YmxpYyBob3N0LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUHVibGljSG9zdDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFN1YnNjcmliZVRvcGljOiBUaGUgdG9waWMgb2YgdGhlIGNoYW5nZSB0cmFja2luZyBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clN1YnNjcmliZVRvcGljOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgU3Vic2NyaXB0aW9uSW5zdGFuY2VJZDogVGhlIElEIG9mIERhdGEgc3Vic2NyaXB0aW9uIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU3Vic2NyaXB0aW9uSW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFZQQ0hvc3Q6IFZQQyBob3N0LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVnBjSG9zdDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46OkRUUzo6U3Vic2NyaXB0aW9uSW5zdGFuY2VgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFN1YnNjcmlwdGlvbkluc3RhbmNlUHJvcHMgPSB7fSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NTdWJzY3JpcHRpb25JbnN0YW5jZSA9IG5ldyBSb3NTdWJzY3JpcHRpb25JbnN0YW5jZSh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIGNvbmZpZ3VyYXRpb246IHByb3BzLmNvbmZpZ3VyYXRpb24sXG4gICAgICAgICAgICB1c2VkVGltZTogcHJvcHMudXNlZFRpbWUsXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCxcbiAgICAgICAgICAgIHBheVR5cGU6IHByb3BzLnBheVR5cGUsXG4gICAgICAgICAgICBzb3VyY2VFbmRwb2ludEluc3RhbmNlVHlwZTogcHJvcHMuc291cmNlRW5kcG9pbnRJbnN0YW5jZVR5cGUsXG4gICAgICAgICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1N1YnNjcmlwdGlvbkluc3RhbmNlO1xuICAgICAgICB0aGlzLmF0dHJQcml2YXRlSG9zdCA9IHJvc1N1YnNjcmlwdGlvbkluc3RhbmNlLmF0dHJQcml2YXRlSG9zdDtcbiAgICAgICAgdGhpcy5hdHRyUHVibGljSG9zdCA9IHJvc1N1YnNjcmlwdGlvbkluc3RhbmNlLmF0dHJQdWJsaWNIb3N0O1xuICAgICAgICB0aGlzLmF0dHJTdWJzY3JpYmVUb3BpYyA9IHJvc1N1YnNjcmlwdGlvbkluc3RhbmNlLmF0dHJTdWJzY3JpYmVUb3BpYztcbiAgICAgICAgdGhpcy5hdHRyU3Vic2NyaXB0aW9uSW5zdGFuY2VJZCA9IHJvc1N1YnNjcmlwdGlvbkluc3RhbmNlLmF0dHJTdWJzY3JpcHRpb25JbnN0YW5jZUlkO1xuICAgICAgICB0aGlzLmF0dHJWcGNIb3N0ID0gcm9zU3Vic2NyaXB0aW9uSW5zdGFuY2UuYXR0clZwY0hvc3Q7XG4gICAgfVxufVxuIl19