# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### KongEcs <a name="KongEcs" id="kong-data-plane.KongEcs"></a>

#### Initializers <a name="Initializers" id="kong-data-plane.KongEcs.Initializer"></a>

```typescript
import { KongEcs } from 'kong-data-plane'

new KongEcs(scope: Construct, id: string, props: KongEcsDataPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEcs.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcs.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcs.Initializer.parameter.props">props</a></code> | <code><a href="#kong-data-plane.KongEcsDataPlaneProps">KongEcsDataPlaneProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-data-plane.KongEcs.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-data-plane.KongEcs.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-data-plane.KongEcs.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-data-plane.KongEcsDataPlaneProps">KongEcsDataPlaneProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEcs.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-data-plane.KongEcs.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEcs.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-data-plane.KongEcs.isConstruct"></a>

```typescript
import { KongEcs } from 'kong-data-plane'

KongEcs.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-data-plane.KongEcs.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEcs.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-data-plane.KongEcs.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### KongEks <a name="KongEks" id="kong-data-plane.KongEks"></a>

#### Initializers <a name="Initializers" id="kong-data-plane.KongEks.Initializer"></a>

```typescript
import { KongEks } from 'kong-data-plane'

new KongEks(scope: Construct, id: string, props: KongEksDataPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | - represents the scope for all the resources. |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.id">id</a></code> | <code>string</code> | - this is a a scope-unique id. |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.props">props</a></code> | <code><a href="#kong-data-plane.KongEksDataPlaneProps">KongEksDataPlaneProps</a></code> | - user provided props for the construct. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-data-plane.KongEks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

represents the scope for all the resources.

---

##### `id`<sup>Required</sup> <a name="id" id="kong-data-plane.KongEks.Initializer.parameter.id"></a>

- *Type:* string

this is a a scope-unique id.

---

##### `props`<sup>Required</sup> <a name="props" id="kong-data-plane.KongEks.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-data-plane.KongEksDataPlaneProps">KongEksDataPlaneProps</a>

user provided props for the construct.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEks.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-data-plane.KongEks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-data-plane.KongEks.isConstruct"></a>

```typescript
import { KongEks } from 'kong-data-plane'

KongEks.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-data-plane.KongEks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-data-plane.KongEks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


## Structs <a name="Structs" id="Structs"></a>

### DataPlaneTelemetryProps <a name="DataPlaneTelemetryProps" id="kong-data-plane.DataPlaneTelemetryProps"></a>

#### Initializer <a name="Initializer" id="kong-data-plane.DataPlaneTelemetryProps.Initializer"></a>

```typescript
import { DataPlaneTelemetryProps } from 'kong-data-plane'

const dataPlaneTelemetryProps: DataPlaneTelemetryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.DataPlaneTelemetryProps.property.createPrometheusWorkspace">createPrometheusWorkspace</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-data-plane.DataPlaneTelemetryProps.property.prometheusEndpoint">prometheusEndpoint</a></code> | <code>string</code> | *No description.* |

---

##### `createPrometheusWorkspace`<sup>Required</sup> <a name="createPrometheusWorkspace" id="kong-data-plane.DataPlaneTelemetryProps.property.createPrometheusWorkspace"></a>

```typescript
public readonly createPrometheusWorkspace: boolean;
```

- *Type:* boolean

---

##### `prometheusEndpoint`<sup>Optional</sup> <a name="prometheusEndpoint" id="kong-data-plane.DataPlaneTelemetryProps.property.prometheusEndpoint"></a>

```typescript
public readonly prometheusEndpoint: string;
```

- *Type:* string

---

### KongEcsDataPlaneProps <a name="KongEcsDataPlaneProps" id="kong-data-plane.KongEcsDataPlaneProps"></a>

#### Initializer <a name="Initializer" id="kong-data-plane.KongEcsDataPlaneProps.Initializer"></a>

```typescript
import { KongEcsDataPlaneProps } from 'kong-data-plane'

const kongEcsDataPlaneProps: KongEcsDataPlaneProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.clusterDns">clusterDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.clusterProps">clusterProps</a></code> | <code>aws-cdk-lib.aws_ecs.ClusterProps</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.desiredCount">desiredCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.kongTaskProps">kongTaskProps</a></code> | <code>aws-cdk-lib.aws_ecs.FargateTaskDefinitionProps</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.telemetryDns">telemetryDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.image">image</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.internetFacing">internetFacing</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEcsDataPlaneProps.property.licenseSecret">licenseSecret</a></code> | <code>string</code> | *No description.* |

---

##### `clusterDns`<sup>Required</sup> <a name="clusterDns" id="kong-data-plane.KongEcsDataPlaneProps.property.clusterDns"></a>

```typescript
public readonly clusterDns: string;
```

- *Type:* string

---

##### `clusterProps`<sup>Required</sup> <a name="clusterProps" id="kong-data-plane.KongEcsDataPlaneProps.property.clusterProps"></a>

```typescript
public readonly clusterProps: ClusterProps;
```

- *Type:* aws-cdk-lib.aws_ecs.ClusterProps

---

##### `desiredCount`<sup>Required</sup> <a name="desiredCount" id="kong-data-plane.KongEcsDataPlaneProps.property.desiredCount"></a>

```typescript
public readonly desiredCount: number;
```

- *Type:* number

---

##### `kongTaskProps`<sup>Required</sup> <a name="kongTaskProps" id="kong-data-plane.KongEcsDataPlaneProps.property.kongTaskProps"></a>

```typescript
public readonly kongTaskProps: FargateTaskDefinitionProps;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateTaskDefinitionProps

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-data-plane.KongEcsDataPlaneProps.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `telemetryDns`<sup>Required</sup> <a name="telemetryDns" id="kong-data-plane.KongEcsDataPlaneProps.property.telemetryDns"></a>

```typescript
public readonly telemetryDns: string;
```

- *Type:* string

---

##### `image`<sup>Optional</sup> <a name="image" id="kong-data-plane.KongEcsDataPlaneProps.property.image"></a>

```typescript
public readonly image: string;
```

- *Type:* string

---

##### `internetFacing`<sup>Optional</sup> <a name="internetFacing" id="kong-data-plane.KongEcsDataPlaneProps.property.internetFacing"></a>

```typescript
public readonly internetFacing: boolean;
```

- *Type:* boolean

---

##### `licenseSecret`<sup>Optional</sup> <a name="licenseSecret" id="kong-data-plane.KongEcsDataPlaneProps.property.licenseSecret"></a>

```typescript
public readonly licenseSecret: string;
```

- *Type:* string

---

### KongEksDataPlaneProps <a name="KongEksDataPlaneProps" id="kong-data-plane.KongEksDataPlaneProps"></a>

#### Initializer <a name="Initializer" id="kong-data-plane.KongEksDataPlaneProps.Initializer"></a>

```typescript
import { KongEksDataPlaneProps } from 'kong-data-plane'

const kongEksDataPlaneProps: KongEksDataPlaneProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.clusterDns">clusterDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.dataPlaneClusterProps">dataPlaneClusterProps</a></code> | <code>aws-cdk-lib.aws_eks.ClusterProps</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.dataPlaneNodeProps">dataPlaneNodeProps</a></code> | <code>aws-cdk-lib.aws_eks.NodegroupOptions</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.kongTelemetryOptions">kongTelemetryOptions</a></code> | <code><a href="#kong-data-plane.DataPlaneTelemetryProps">DataPlaneTelemetryProps</a></code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.licenseSecretsName">licenseSecretsName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-data-plane.KongEksDataPlaneProps.property.telemetryDns">telemetryDns</a></code> | <code>string</code> | *No description.* |

---

##### `clusterDns`<sup>Required</sup> <a name="clusterDns" id="kong-data-plane.KongEksDataPlaneProps.property.clusterDns"></a>

```typescript
public readonly clusterDns: string;
```

- *Type:* string

---

##### `dataPlaneClusterProps`<sup>Required</sup> <a name="dataPlaneClusterProps" id="kong-data-plane.KongEksDataPlaneProps.property.dataPlaneClusterProps"></a>

```typescript
public readonly dataPlaneClusterProps: ClusterProps;
```

- *Type:* aws-cdk-lib.aws_eks.ClusterProps

> [https://docs.aws.amazon.com/cdk/api/latest/docs/](https://docs.aws.amazon.com/cdk/api/latest/docs/)

---

##### `dataPlaneNodeProps`<sup>Required</sup> <a name="dataPlaneNodeProps" id="kong-data-plane.KongEksDataPlaneProps.property.dataPlaneNodeProps"></a>

```typescript
public readonly dataPlaneNodeProps: NodegroupOptions;
```

- *Type:* aws-cdk-lib.aws_eks.NodegroupOptions

---

##### `kongTelemetryOptions`<sup>Required</sup> <a name="kongTelemetryOptions" id="kong-data-plane.KongEksDataPlaneProps.property.kongTelemetryOptions"></a>

```typescript
public readonly kongTelemetryOptions: DataPlaneTelemetryProps;
```

- *Type:* <a href="#kong-data-plane.DataPlaneTelemetryProps">DataPlaneTelemetryProps</a>

---

##### `licenseSecretsName`<sup>Required</sup> <a name="licenseSecretsName" id="kong-data-plane.KongEksDataPlaneProps.property.licenseSecretsName"></a>

```typescript
public readonly licenseSecretsName: string;
```

- *Type:* string

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-data-plane.KongEksDataPlaneProps.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `telemetryDns`<sup>Required</sup> <a name="telemetryDns" id="kong-data-plane.KongEksDataPlaneProps.property.telemetryDns"></a>

```typescript
public readonly telemetryDns: string;
```

- *Type:* string

---



