/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 *     
 */

#include "sipAPI_core.h"

        #include <wx/ctrlsub.h>



PyDoc_STRVAR(doc_wxItemContainerImmutable_GetCount, "GetCount() -> unsignedint\n"
"\n"
"Returns the number of items in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            uint sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetCount);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the control is empty or false if it has some items.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_IsEmpty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetString, "GetString(n) -> String\n"
"\n"
"Returns the label of the item with the given index.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        uint n;
        const  ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
             ::wxString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetString);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetString(n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetStrings, "GetStrings() -> ArrayString\n"
"\n"
"Returns the array of the labels of all items in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetStrings(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetStrings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetStrings());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetStrings, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetString, "SetString(n, string)\n"
"\n"
"Sets the label for the given item.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        uint n;
        const  ::wxString* string;
        int stringState = 0;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
            sipName_string,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BuJ1", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n, sipType_wxString, &string, &stringState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_SetString);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetString(n,*string);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_FindString, "FindString(string, caseSensitive=False) -> int\n"
"\n"
"Finds an item whose label matches the given string.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_FindString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_FindString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* string;
        int stringState = 0;
        bool caseSensitive = 0;
        const  ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_caseSensitive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, sipType_wxString, &string, &stringState, &caseSensitive))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxItemContainerImmutable::FindString(*string,caseSensitive) : sipCpp->FindString(*string,caseSensitive));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_FindString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetSelection, "SetSelection(n)\n"
"\n"
"Sets the selection to the given item n or removes the selection\n"
"entirely if n == wxNOT_FOUND.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        int n;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_SetSelection);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSelection(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetSelection, "GetSelection() -> int\n"
"\n"
"Returns the index of the selected item or wxNOT_FOUND if no item is\n"
"selected.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetSelection(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetSelection);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetStringSelection, "SetStringSelection(string) -> bool\n"
"\n"
"Selects the item with the specified string in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetStringSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetStringSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* string;
        int stringState = 0;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, sipType_wxString, &string, &stringState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetStringSelection(*string);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetStringSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetStringSelection, "GetStringSelection() -> String\n"
"\n"
"Returns the label of the selected item or an empty string if no item\n"
"is selected.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetStringSelection(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetStringSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxItemContainerImmutable::GetStringSelection() : sipCpp->GetStringSelection()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetStringSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_Select, "Select(n)\n"
"\n"
"This is the same as SetSelection() and exists only because it is\n"
"slightly more natural for controls which support multiple selection.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_Select(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_Select(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Select(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_Select, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxItemContainerImmutable(void *, int);}
static void release_wxItemContainerImmutable(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxItemContainerImmutable *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxItemContainerImmutable(sipSimpleWrapper *);}
static void dealloc_wxItemContainerImmutable(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxItemContainerImmutable(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxItemContainerImmutable[] = {
    {sipName_FindString, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_FindString), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_FindString},
    {sipName_GetCount, meth_wxItemContainerImmutable_GetCount, METH_VARARGS, doc_wxItemContainerImmutable_GetCount},
    {sipName_GetSelection, meth_wxItemContainerImmutable_GetSelection, METH_VARARGS, doc_wxItemContainerImmutable_GetSelection},
    {sipName_GetString, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_GetString), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_GetString},
    {sipName_GetStringSelection, meth_wxItemContainerImmutable_GetStringSelection, METH_VARARGS, doc_wxItemContainerImmutable_GetStringSelection},
    {sipName_GetStrings, meth_wxItemContainerImmutable_GetStrings, METH_VARARGS, doc_wxItemContainerImmutable_GetStrings},
    {sipName_IsEmpty, meth_wxItemContainerImmutable_IsEmpty, METH_VARARGS, doc_wxItemContainerImmutable_IsEmpty},
    {sipName_Select, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_Select), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_Select},
    {sipName_SetSelection, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_SetSelection), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_SetSelection},
    {sipName_SetString, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_SetString), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_SetString},
    {sipName_SetStringSelection, SIP_MLMETH_CAST(meth_wxItemContainerImmutable_SetStringSelection), METH_VARARGS|METH_KEYWORDS, doc_wxItemContainerImmutable_SetStringSelection}
};

sipVariableDef variables_wxItemContainerImmutable[] = {
    {PropertyVariable, sipName_Strings, &methods_wxItemContainerImmutable[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_StringSelection, &methods_wxItemContainerImmutable[4], &methods_wxItemContainerImmutable[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Selection, &methods_wxItemContainerImmutable[2], &methods_wxItemContainerImmutable[8], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Count, &methods_wxItemContainerImmutable[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxItemContainerImmutable, "ItemContainerImmutable()\n"
"\n"
"wxItemContainer defines an interface which is implemented by all\n"
"controls which have string subitems each of which may be selected.");


sipClassTypeDef sipTypeDef__core_wxItemContainerImmutable = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxItemContainerImmutable,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_ItemContainerImmutable,
        {0, 0, 1},
        11, methods_wxItemContainerImmutable,
        0, SIP_NULLPTR,
        4, variables_wxItemContainerImmutable,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxItemContainerImmutable,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxItemContainerImmutable,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxItemContainerImmutable,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
