# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-10-25 15:27
from __future__ import unicode_literals

import calaccess_raw.annotations
import calaccess_raw.fields
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("calaccess_raw", "0007_auto_20160831_0132"),
    ]

    operations = [
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F425",
                        b"Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 1, Committee Information",
                    ),
                    (
                        b"F450",
                        b"Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 3, Committee Information",
                    ),
                    (
                        b"F460",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 2",
                    ),
                    (
                        b"F465",
                        b"Form 465 (Supplemental Independent Expenditure Report): Part 5, Filing Officers",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=23
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=31
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F400",
                        b"Form 400 (Statement of Organization (Slate Mailer Organization)): Part 3, Individuals Who Authorize Contents Of Slate Mailers",
                    ),
                    (
                        b"F410",
                        b"Form 410 (Statement of Organization (Recipient Committee)): Part 4, Type of Committee",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=38
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=46, id="2712033-Cal-Format-1-05-02", start_page=45
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=59, id="2712034-Cal-Format-201", start_page=58
                    ),
                ],
                help_text="Form type of the filing the record is included in. This must equal the form_type of the parent filing's cover (CVR) record.",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        b"Form 400 (Statement of Organization (Slate Mailer Organization)): Part 5, Verification",
                    ),
                    (
                        "F401",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Cover Page",
                    ),
                    (
                        "F402",
                        b"Form 402 (Statement of Termination (Slate Mailer Organization)): Verification",
                    ),
                    (
                        "F410",
                        b"Form 410 (Statement of Organization (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F425",
                        b"Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F450",
                        b"Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 4, Verification",
                    ),
                    (
                        "F460",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 1",
                    ),
                    (
                        "F461",
                        b"Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 4, Verification",
                    ),
                    (
                        "F465",
                        b"Form 465 (Supplemental Independent Expenditure Report): Part 6, Verification",
                    ),
                    ("F511", b"Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=50
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=64
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F425",
                        b"Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", b"Form 496: Late Independent Expenditure Report"),
                    ("F497", b"Form 497: Late Contribution Report"),
                    (
                        "F498",
                        b"Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F511", b"Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=18
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=22
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="reportname",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                ],
                db_column="REPORTNAME",
                documentcloud_pages=(
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=15
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=20
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=19
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=26
                    ),
                ),
                help_text="Attached campaign disclosure statement type. Legal values are 450, 460, and 461.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F470",
                        b"Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=22
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=29
                    ),
                ],
                help_text="Type of Filing or Formset. The value of this column will always be equal to F470.",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        b"Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        b"Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        "F410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=46
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=59
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    )
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=33
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=45
                    ),
                ],
                help_text="Schedule Name/ID: (F - Sched F / Accrued Expenses)",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="efsfilinglogcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F400",
                        b"Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        b"F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        b"F402",
                        b"Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        b"F410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        b"F425",
                        b"Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    (b"F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    (b"F496", b"Form 496: Late Independent Expenditure Report"),
                    (b"F497", b"Form 497: Late Contribution Report"),
                    (
                        b"F498",
                        b"Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    (b"F601", b"Form 601: Lobbying Firm Registration Statement"),
                    (b"F602", b"Form 602: Lobbying Firm Activity Authorization"),
                    (
                        b"F603",
                        b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    (b"F604", b"Form 604: Lobbyist Certification Statement"),
                    (b"F606", b"Form 606: Notice of Termination"),
                    (b"F607", b"Form 607: Notice of Withdrawal"),
                    (b"F615", b"Form 615: Lobbyist Report"),
                    (b"F625", b"Form 625: Report of Lobbying Firm"),
                    (
                        b"F635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (b"F645", b"Form 645: Report of Person Spending $5,000 or More"),
                    ("BADFORMAT 253", "Unknown"),
                    ("form", "Unknown"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=8, id="2711624-Overview", start_page=4
                    )
                ],
                help_text="Name of the source filing form or schedule",
                max_length=250,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F450P5",
                        b"Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        b"D",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        b"E",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        b"G",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        b"F461P5",
                        b"Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        b"F465P3",
                        b"Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        b"F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=31
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=42
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="f495p2cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"F495",
                        b"Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=26
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=35
                    ),
                ],
                help_text="Name of the source filing form to which the Form 495 is attached (must equal Form_Type in CVR record)",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F400",
                        b"Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        b"F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        b"F402",
                        b"Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (b"F405", b"Form 405: Amendment to Campaign Disclosure Statement"),
                    (
                        b"F410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (b"F415", b"Form 415: Title Unknown"),
                    (b"F416", b"Form 416: Title Unknown"),
                    (
                        b"F419",
                        b"Form 419: Campaign Disclosure Statement, Long Form (Ballot Measure Committee)",
                    ),
                    (
                        b"F420",
                        b"Form 420: Campaign Disclosure Statement, Long Form (Recipient Committee)",
                    ),
                    (
                        b"F425",
                        b"Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (b"F430", b"Form 430: Title Unknown"),
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    (b"F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    (
                        b"F470",
                        b"Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    (
                        b"F490",
                        b"Form 490: Campaign Disclosure Statement, Long Form (Officeholders and Candidates)",
                    ),
                    (
                        b"F495",
                        b"Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                    (b"F496", b"Form 496: Late Independent Expenditure Report"),
                    (b"F497", b"Form 497: Late Contribution Report"),
                    (
                        b"F498",
                        b"Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    (b"F501", b"Form 501: Candidate Intention Statement"),
                    (b"F502", b"Form 502: Campaign Bank Account Statement"),
                    (b"F511", b"Form 511: Paid Spokesperson Report"),
                    (b"E530", b"Electronic Form 530: Electronic Issue Advocacy Report"),
                    (b"F601", b"Form 601: Lobbying Firm Registration Statement"),
                    (b"F602", b"Form 602: Lobbying Firm Activity Authorization"),
                    (
                        b"F603",
                        b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    (b"F604", b"Form 604: Lobbyist Certification Statement"),
                    (
                        b"F605",
                        b"Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    (b"F606", b"Form 606: Notice of Termination"),
                    (b"F607", b"Form 607: Notice of Withdrawal"),
                    (b"F615", b"Form 615: Lobbyist Report"),
                    (b"F625", b"Form 625: Report of Lobbying Firm"),
                    (
                        b"S630",
                        b"Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                    ),
                    (
                        b"F635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        b"S635-C",
                        b"Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        b"S640",
                        b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    (b"F645", b"Form 645: Report of Person Spending $5,000 or More"),
                    (b"F690", b"Form 690: Amendment to Lobbying Disclosure Report"),
                    (b"F700", b"Form 700: Statement of Economic Interest"),
                    (
                        b"F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    ("F111", "Unknown"),
                    ("F410 AT", "Unknown"),
                    ("F410ATR", "Unknown"),
                    ("F421", "Unknown"),
                    ("F440", "Unknown"),
                    (
                        "F470S",
                        b"Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    ("F480", "Unknown"),
                    ("F500", "Unknown"),
                    (
                        "F501502",
                        "Forms 501 and/or 502 (Candidate Intention and/or Bank Account Statements)",
                    ),
                    ("F555", "Unknown"),
                    ("F666", "Unknown"),
                    ("F777", "Unknown"),
                    ("F888", "Unknown"),
                    ("F999", "Unknown"),
                ],
                db_column="FORM_ID",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711614-CalAccessTablesWeb", start_page=65
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="headercd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("AF490", "Form 490, Part A"),
                    ("AP1", "Allocation Part 1"),
                    ("AP2", "Allocation Part 2"),
                    ("BF490", "Form 490, Part B"),
                    ("CF490", "Form 490, Part C"),
                    ("DF490", "Form 490, Part D"),
                    ("EF490", "Form 490, Part E"),
                    (
                        "F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("FF490", "Form 490, Part F"),
                    ("HF490", "Form 490, Part H"),
                    ("IF490", "Form 490, Part I"),
                ],
                db_column="FORM_ID",
                help_text="Form identification code",
                max_length=5,
                verbose_name="Form ID",
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F615P2",
                        b"Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        b"F625P4B",
                        b"Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        b"F635P4B",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        b"F645P3B",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=64
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=79, id="2712034-Cal-Format-201", start_page=78
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="lempcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F601P2A",
                        b"Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        b"F601P2B",
                        b"Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=75
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=90
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F615P1",
                        b"Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        b"F625P3A",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        b"F635P3C",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        b"F645P2A",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=61
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=74
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"B1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        b"B2",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        b"B3",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        b"H",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        b"H1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        b"H2",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        b"H3",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=35
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=47
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="lothcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F625P3B",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=63
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=77
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F625P2",
                        b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        b"F635P3B",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=62
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=76
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (b"E530", b"Electronic Form 530: Electronic Issue Advocacy Report"),
                    (
                        b"F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        b"F401A",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        b"A",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        b"A-1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A-1, Contributions Transferred to Special Election Commitee",
                    ),
                    (
                        b"C",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        b"I",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        b"F496P3",
                        b"Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=29
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=37
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="int_rate",
            field=calaccess_raw.fields.CharField(
                blank=True,
                db_column="INT_RATE",
                help_text="This field is undocumented. The observed values look like filer_ids taken from section 5, cover page 2 of Form 460 (Related Committees Not Included in this Statement).",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="receivedfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        b"F400",
                        b"Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        b"F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        b"F402",
                        b"Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        b"F410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        b"F425",
                        b"Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    (b"F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    (b"F496", b"Form 496: Late Independent Expenditure Report"),
                    (b"F497", b"Form 497: Late Contribution Report"),
                    (
                        b"F498",
                        b"Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    (b"F601", b"Form 601: Lobbying Firm Registration Statement"),
                    (b"F602", b"Form 602: Lobbying Firm Activity Authorization"),
                    (
                        b"F603",
                        b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    (b"F604", b"Form 604: Lobbyist Certification Statement"),
                    (b"F606", b"Form 606: Notice of Termination"),
                    (b"F607", b"Form 607: Notice of Withdrawal"),
                    (b"F615", b"Form 615: Lobbyist Report"),
                    (b"F625", b"Form 625: Report of Lobbying Firm"),
                    (
                        b"F635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (b"F645", b"Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_ID",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=8, id="2711624-Overview", start_page=4
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form identification code",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        b"F401B",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        b"F401B-1",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        b"F401C",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule C, Persons Receiving $1,000 or More",
                    ),
                    (
                        b"F401D",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule D, Candidates and Measures Not Listed on Schedule A",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=39
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=51
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F497P1",
                        b"Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        b"F497P2",
                        b"Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=41
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=54
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        b"F498-A",
                        b"Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        b"F498-R",
                        b"Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=43
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=56
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="smrycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        b"F401A",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        b"F401B",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        b"F401B-1",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"A",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        b"B1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        b"B2",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        b"B3",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        b"C",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        b"D",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        b"E",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        b"F",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    (
                        b"G",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        b"H",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        b"H1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        b"H2",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        b"H3",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                    (
                        b"I",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        b"F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    (b"F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    (b"F625", b"Form 625: Report of Lobbying Firm"),
                    (
                        b"F625P2",
                        b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        b"F625P3A",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        b"F625P3B",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        b"F635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        b"F635P3A",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section A, Payments To In-house Employee Lobbyists",
                    ),
                    (
                        b"F635P3B",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        b"F635P3C",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        b"F635P3D",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section D, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        b"F635P3E",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section E, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before The California Public Utilities Commission",
                    ),
                    (
                        b"S640",
                        b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    (b"F645", b"Form 645: Report of Person Spending $5,000 or More"),
                    (
                        b"F645P2A",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        b"F645P2B",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section B, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        b"F645P2C",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section C, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before the California Public Utilities Commission",
                    ),
                    (
                        b"F900",
                        b"Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        "401A",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value=b"F401A",
                            documentcloud_id=None,
                            end_page=7,
                            form=calaccess_raw.annotations.FilingForm(
                                b"F401",
                                b"Campaign Disclosure Statement (Slate Mailer Organization)",
                                description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id=b"2781366-401-2005-01",
                                group=b"CAMPAIGN",
                            ),
                            id=b"A",
                            start_page=5,
                            title=b"Schedule A, Payments Received",
                        ),
                    ),
                    (
                        "401B",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value=b"F401B",
                            documentcloud_id=None,
                            end_page=9,
                            form=calaccess_raw.annotations.FilingForm(
                                b"F401",
                                b"Campaign Disclosure Statement (Slate Mailer Organization)",
                                description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id=b"2781366-401-2005-01",
                                group=b"CAMPAIGN",
                            ),
                            id=b"B",
                            start_page=8,
                            title=b"Schedule B, Payments Made",
                        ),
                    ),
                    (
                        "401B-1",
                        calaccess_raw.annotations.FilingFormSection(
                            db_value=b"F401B-1",
                            documentcloud_id=None,
                            end_page=None,
                            form=calaccess_raw.annotations.FilingForm(
                                b"F401",
                                b"Campaign Disclosure Statement (Slate Mailer Organization)",
                                description=b"Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id=b"2781366-401-2005-01",
                                group=b"CAMPAIGN",
                            ),
                            id=b"B-1",
                            start_page=10,
                            title=b"Schedule B-1, Payments Made by Agent or Independent Contractor",
                        ),
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=86
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=28, id="2712033-Cal-Format-1-05-02", start_page=27
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=60, id="2712033-Cal-Format-1-05-02", start_page=59
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=37, id="2712034-Cal-Format-201", start_page=36
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        end_page=74, id="2712034-Cal-Format-201", start_page=73
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="pform_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"A",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        b"B1",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        b"B2",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        b"C",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        b"D",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        b"F450P5",
                        b"Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        b"H",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                ],
                db_column="PFORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=18
                    )
                ],
                help_text="Parent Schedule Type",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="textmemocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        b"F401",
                        b"Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (b"F405", b"Form 405: Amendment to Campaign Disclosure Statement"),
                    (
                        b"F410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        b"F425",
                        b"Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        b"F450",
                        b"Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        b"F460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        b"F461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    (b"F465", b"Form 465: Supplemental Independent Expenditure Report"),
                    (b"F496", b"Form 496: Late Independent Expenditure Report"),
                    (b"F497", b"Form 497: Late Contribution Report"),
                    (
                        b"F498",
                        b"Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    (b"F601", b"Form 601: Lobbying Firm Registration Statement"),
                    (b"F602", b"Form 602: Lobbying Firm Activity Authorization"),
                    (
                        b"F603",
                        b"Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    (b"F604", b"Form 604: Lobbyist Certification Statement"),
                    (
                        b"F605",
                        b"Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    (b"F606", b"Form 606: Notice of Termination"),
                    (b"F607", b"Form 607: Notice of Withdrawal"),
                    (b"F615", b"Form 615: Lobbyist Report"),
                    (b"F625", b"Form 625: Report of Lobbying Firm"),
                    (
                        b"F635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (b"F645", b"Form 645: Report of Person Spending $5,000 or More"),
                    (
                        b"S630",
                        b"Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635) ",
                    ),
                    (
                        b"S635-C",
                        b"Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        b"S640",
                        b"Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    (
                        "410",
                        b"Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "460",
                        b"Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        b"Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("465", b"Form 465: Supplemental Independent Expenditure Report"),
                    ("496", b"Form 496: Late Independent Expenditure Report"),
                    ("497", b"Form 497: Late Contribution Report"),
                    (
                        "497P1",
                        b"Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "497P2",
                        b"Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F401A",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "F401B",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        b"Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F450P5",
                        b"Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "F461P1",
                        b"Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 1, Name and Address of Filer",
                    ),
                    (
                        "F461P2",
                        b"Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 2, Nature and Interests of Filer",
                    ),
                    (
                        "F461P5",
                        b"Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        "F465P3",
                        b"Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        "F496P3",
                        b"Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                    (
                        "F497P1",
                        b"Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "F497P2",
                        b"Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F498-A",
                        b"Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        "F498-R",
                        b"Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                    (
                        "F601P2A",
                        b"Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        "F601P2B",
                        b"Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                    (
                        "F615P1",
                        b"Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        "F615P2",
                        b"Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        "F625P2",
                        b"Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F625P3A",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F625P3B",
                        b"Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        "F625P4B",
                        b"Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "S635",
                        b"Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "F635P3B",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        "F635P3C",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F635P4B",
                        b"Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F645P2A",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        "F645P3B",
                        b"Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                    ("S497", b"Form 497: Late Contribution Report"),
                    (
                        "S635C",
                        b"Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    ("A", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A4", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A6", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("B", "Schedule B of any form (e.g., Forms 401 or 460)"),
                    ("B1", "Schedule B, Part 1 of Forms 401 or 460"),
                    ("B2", "Schedule B, Part 2 of Forms 401 or 460"),
                    ("B3", "Schedule B, Part 3 of Forms 401 or 460"),
                    ("C", "Schedule C of any form (e.g., Forms 401 or F460)"),
                    ("COMMENTS", "Possibly comments by FPPC for any form?"),
                    ("CVR", "Cover page for any form (e.g., Forms 460, 461 or 497)"),
                    ("D", "Schedule D of any form (e.g., Forms 401, 460 or 461)"),
                    (
                        "DEBTF",
                        b"Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    ("E", "Schedule E of any form (e.g., Forms 460, 461 or 465)"),
                    ("EXPNT", "Expenditures outlined on any form (e.g. Form 460)"),
                    ("F", "Schedule F of any form (e.g., Form 460)"),
                    ("G", "Schedule G of any form (e.g., Form 460)"),
                    ("H", "Schedule H of any form (e.g., Form 460)"),
                    ("H1", "Schedule H, Part 1 of any form (e.g., Form 460)"),
                    ("H2", "Schedule H2, Part 2 of any form (e.g., Form 460)"),
                    ("H3", "Schedule H3, Part 3 of any form (e.g., Form 460)"),
                    ("I", "Schedule I of any form (e.g., Form 460)"),
                    ("PT5", "Part 5 of any form (e.g., Form 461"),
                    ("RCPTB1", "Schedule B, Part 1 of any form (e.g., Form 460"),
                    ("RCPTC", "Schedule C of any form (e.g., Form 460)"),
                    ("RCPTI", "Schedule I of any form (e.g., Form 460)"),
                    ("SCH A", "Schedule A of any form (e.g., Form 460)"),
                    ("SF", "Schedule F of any form (e.g., Form 460)"),
                    ("SPLT", "A memo that applies to multiple items?"),
                    ("SMRY", "Summary section of any form (e.g., Form 460)"),
                    ("SUM", "Summary section of any form (e.g., Form 460)"),
                    ("SUMMARY", "Summary section of any form (e.g., Form 460)"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.DocumentCloud(
                        id="2711616-MapCalFormat2Fields", start_page=90
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712034-Cal-Format-201", start_page=16
                    ),
                    calaccess_raw.annotations.DocumentCloud(
                        id="2712033-Cal-Format-1-05-02", start_page=13
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
                verbose_name="form type",
            ),
        ),
    ]
