# tlp-client

**tlp-client** is a set of python3 client libraries and tools for the
[transLectures Platform (TLP)](https://ttp.mllp.upv.es/doc), developed by the
[MLLP-VRAIN](https://mllp.upv.es) research group. It can be used to integrate
your media repository's backend with all TLP services, which include automatic
multilingual subtitling, dubbing, and professional post-editing for on-demand
contents.

## Installation

**tlp-client** is avalable on PyPI:

```bash
--$ python3 -m pip install tlp-client
# or
--$ pip3 install tlp-client
```

It supports Python 3.5+.

## Library

**tlp-client** module mainly implements the `TLPSpeechClient`,
`TLPTextClient` and `TLPWebClient` classes that provides
several methods to interact with the `/speech`, `/text` and `/web` APIs of the
*transLectures-UPV Platform*.

Below are shown some examples on interacting with the `/speech`
API. Using this library to query `/text` and `/web` API interfaces is pretty similar.

First, we have to import the `tlp_client` library and create a
`TLPSpeechClient` class instance, using the appropriate argument values. E.g.:

```python3
>>> import tlp_client
>>> tlp = tlp_client.TLPSpeechClient("https://my-tlp-instance.com/api/v3", 
                                     "https://my-tlp-instance.com/player", 
                                     "my-api-user", 
                                     "my-api-key")
```

To **get the list of subtitle languages available** for a particular Media ID:

```python3
>>> tlp.api_langs("media-id-1")
>>> print(tlp.get_printable_response_data())
```

To **download a subtitles file**, for instance, English subtitles in SRT format:

```python3
>>> tlp.api_get("media-id-1", "en", form="srt")
>>> tlp.save_response_data("/path/to/my/media_subs.en.srt")
```

To **Generate and upload a Media Package File** to the TLP Server is also quite straightforward:
   
```python3 
>>> # Initialise Manifest, definining media ID:
>>> tlp.manifest_init("media-id-2")
>>> # Add some metadata (media language and title are mandatory)
>>> tlp.manifest_set_metadata(language="en", title="Testing tlp_client")
>>> # Add video/audio file (can be a public URL/URI, also)
>>> tlp.manifest_set_main_media_file("/path/to/my/media_file.mp4")
>>> # Enable Ingest Service's Test Mode, since we are doing a test:
>>> tlp.manifest_set_options(test_mode=True)
>>> # Generate Media Package File and upload it via the /ingest/new interface:
>>> tlp.api_ingest_new()
>>> # Why to print the response? I just want the upload ID!
>>> upload_id = tlp.ret_data['id']
```

To **track the progress** of our first upload: 

```python3
>>> tlp.api_status(upload_id)
>>> print(tlp.get_printable_response_data())
```
    
You can build the most **complex Media Package** in the world, but only if you want!
   
```python3
>>> tlp.manifest_init("media-id-3")
>>> tlp.manifest_set_metadata(language="en", title="Really testing tlp_client")
>>> tlp.manifest_set_main_media_file("/path/to/my/media_file.mp4")
>>> # Add a related text file to improve transcription quality
>>> tlp.manifest_add_attachment("/path/to/my/doc_file.pdf", 
                                 tlp_client.TLPClient.FTYPE_CODE_DOCUMENT)
>>> # Request Spanish subtitles (English are generated by default):
>>> tlp.manifest_add_subtitles_request("es")
>>> # Request also a text-to-speech synthesized Spanish audiotrack:
>>> tlp.manifest_add_audiotrack_request("es")
>>> # ...
>>> # AND FINALLY...
>>> tlp.api_ingest_new()
>>> # Mere curiosity... print me the generated Manifest JSON object!
>>> print(tlp.get_printable_manifest())
``` 

Extended documentation of this module can be find either [here](https://ttp.mllp.upv.es/doc/clients/python3) or running `help(tlp_client)`.

For **further information** you might check the [full documentation of the transLectures-UPV Platform](https://ttp.mllp.upv.es/doc).

## Commandline tools

**tlp-client** comes with three handy command-line tools that make use of the
`tlp_client` python3 module: 
- `tlp-api-cli`
- `tlp-player-urlgen`
- `tlp-transedit-urlgen`. 

All them require a configuration file (`config.ini`) to work. By default they
look on the working directory. The --config-file` option allows to provide it
manually. Please note that the `--print-sample-config-file` option can be used
to generate a template `config.ini` file: 


```ini
--$ tlp-api-cli --print-sample-config-file
[general]
web_service_url = 
player_url = 
translation_editor_url = 
web_translation_editor_url = 

[http_auth]
enabled = no
username = 
password = 

[api_client_auth]
enabled = yes
username = 
secret_key = 
request_key_expire_lifetime = 

[player_user_info]
user_id = 
user_full_name = 
user_confidence = 

```

Configuration parameters have to be properly set up,
using your TLP's instance service URLs and API credentials. These can be retrieved from
the *API* section of your TLP instance's web platform interface (e.g.
[https://ttp.mllp.upv.es/index.php?page=api](https://ttp.mllp.upv.es/index.php?page=api)).


### tlp-api-cli

**tlp-api-cli** makes use of the TLP Python3 Client Library (tlp-client) and implements all TLP API endpoint calls. 

#### Examples of use:

  - To upload a new English video file (with ID "my-media-1234") and request English and
    Spanish subtitles [/speech/ingest/new API call]:

```bash
--$ tlp-api-cli speech ingest new --language "en" \
                                  --title "My first video" \
                                  --media-file "/path/to/my/video.mp4" \
                                  --requested-languages-subs en \
                                  --requested-languages-subs es \
                                  "my-media-1234"
```

  - To check the status of an uploaded video, using an upload ID returned by
    the /speech/ingest/new interface (i.e. "up-1234") [/speech/status API   
    call:
   
```bash
--$ tlp-api-cli speech status "up-1234"
```

  - To get the subtitle languages available for the video ID "my-media-1234"
    [/speech/langs API call]:

```bash
--$ tlp-api-cli speech langs "my-media-1234"
```

  - To get English subtitles in SRT format for the video ID "my-media-1234" [/speech/get
    API call]:

```bash
--$ tlp-api-cli speech get --format "srt" "my-media-1234" "en" 
```

### tlp-player-urlgen

**tlp-player-urlgen** generates valid URLs to call/embed the TLP Player for a media object ID. 

```bash
--$ tlp-player-urlgen my-media-1234
```

### tlp-transedit-urlgen

**tlp-transedit-urlgen** generates valid URLs to call/embed the TLP translation editor for a document object ID and translation language. 

```bash
--$ tlp-transedit-urlgen my-document-5678 en
```
