import { Construct } from '@aws-cdk/core';
import { ITopic } from '@aws-cdk/aws-sns';
import { ISlackChannelConfiguration, MSTeamsIncomingWebhookConfiguration } from '@cloudcomponents/cdk-chatops';
import { INotificationRule } from './notification-rules';
export interface NotificationTargetProperty {
    readonly targetType: TargetType.SNS | TargetType.AWS_CHATBOT_SLACK;
    readonly targetAddress: string;
}
export interface INotificationTarget {
    bind(scope: Construct, rule: INotificationRule): NotificationTargetProperty;
}
export declare class SnsTopic implements INotificationTarget {
    private readonly topic;
    constructor(topic: ITopic);
    bind(_scope: Construct, _rule: INotificationRule): NotificationTargetProperty;
}
export declare class SlackChannel implements INotificationTarget {
    private readonly channel;
    constructor(channel: ISlackChannelConfiguration);
    bind(_scope: Construct, _rule: INotificationRule): NotificationTargetProperty;
}
export declare class MSTeamsIncomingWebhook implements INotificationTarget {
    private readonly webhook;
    constructor(webhook: MSTeamsIncomingWebhookConfiguration);
    bind(scope: Construct, _rule: INotificationRule): NotificationTargetProperty;
}
export declare enum TargetType {
    SNS = "SNS",
    AWS_CHATBOT_SLACK = "AWSChatbotSlack"
}
