# *[WIP]* Elden Ring Database

A parsable, autogenerated, JSON-based wikipedia for Elden Ring. Readable by any; human or program alike.

# Features

Adopting this database in a project is beneficial beyond just providing the data itself:

### Reliable sources

* All the data is ripped straight from the game files using [Yabber](https://github.com/JKAnderson/Yabber) and [Yapped Rune Bear](https://github.com/vawser/Yapped-Rune-Bear).
* Dependency on Yapped Rune Bear's [Paramdex](https://github.com/vawser/Yapped-Rune-Bear/tree/main/Paramdex/ER) for naming of some properties.

### 99%<sup>1</sup> of data is autogenerated

* Values are free from human error and always up-to-date.
* Values are effortlessly regenerated with new game releases.
* Convoluted game parameters are automatically converted into a coherent layout, without losing information<sup>2</sup>.

### User contributed information

* Made in mind with user contributions, new findings can be available in every adaptation of this database.
* Interesting remarks about an item or a weapon's true combo list is kept up to date.
* Designed for easy PRs where every item is contained within its own file.
* Ability to specify game version ranges for which a particular information is valid.
* Each human change is checked for correctness (by accepting a PR) and validity (by CI verifying JSON schema).

### JSON schema guarantee

* JSON layout adheres to a strictly defined schema structure, ensuring integrity of all values.
* JSON schema is a standard that many tools use to, for example, autogenerate data classes.

### Shallow structure

* Structure of JSON designed as shallow and straightforward to parse as possible.
* Digging into nested fields is avoided, while retaining a logically sensible layout.

### Data for multiple game versions

* Every game version from 1.04.1 and up.
* Sources are retained across versions, [sources manifest file](https://github.com/EldenRingDatabase/erdb/blob/master/source/manifest.json).

### Always available

* No extra servers, data is hosted right in this repo, uptime is that of GitHub's.
* Download the files and check for updates (recommended) or view the raw content online.

<sup>1</sup> Some values or means of retrieving them are hardcoded in very specific cases, all listed [here](https://github.com/EldenRingDatabase/erdb/wiki/Data-Generation-Completeness). \
<sup>2</sup> Unnecessary information is lost, ex. armor's separate values for bleed/frostbite are treated as a single robustness value.
