"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("./common");
const component_1 = require("./component");
const eslint_1 = require("./eslint");
const node_project_1 = require("./node-project");
const sample_file_1 = require("./sample-file");
const tasks_1 = require("./tasks");
const textfile_1 = require("./textfile");
const typescript_config_1 = require("./typescript-config");
const typescript_typedoc_1 = require("./typescript-typedoc");
const projenrc_1 = require("./typescript/projenrc");
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
class TypeScriptProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : 'lib';
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : 'docs/';
        this.compileTask.exec('tsc');
        this.watchTask = this.addTask('watch', {
            description: 'Watch & compile in the background',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'tsc -w',
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : 'test';
        this.gitignore.include(`/${this.testdir}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        // by default, we first run tests (jest compiles the typescript in the background) and only then we compile.
        const compileBeforeTest = (_k = options.compileBeforeTest) !== null && _k !== void 0 ? _k : compiledTests;
        if (compileBeforeTest) {
            this.buildTask.spawn(this.compileTask);
            this.buildTask.spawn(this.testTask);
        }
        else {
            this.buildTask.spawn(this.testTask);
            this.buildTask.spawn(this.compileTask);
        }
        if ((_l = options.package) !== null && _l !== void 0 ? _l : true) {
            this.packageTask = this.addTask('package', {
                description: 'Create an npm tarball',
                category: tasks_1.TaskCategory.RELEASE,
            });
            this.packageTask.exec('rm -fr dist');
            this.packageTask.exec('mkdir -p dist/js');
            this.packageTask.exec(`${this.package.packageManager} pack`);
            this.packageTask.exec('mv *.tgz dist/js/');
            this.buildTask.spawn(this.packageTask);
        }
        if (options.entrypointTypes || this.entrypoint !== '') {
            const entrypointTypes = (_m = options.entrypointTypes) !== null && _m !== void 0 ? _m : `${path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, '.js')).replace(/\\/g, '/')}.d.ts`;
            this.package.addField('types', entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ['es2018'],
            module: 'CommonJS',
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: 'ES2018',
        };
        if (!options.disableTsconfig) {
            const baseTsconfig = {
                include: [`${this.srcdir}/**/*.ts`],
                exclude: [
                    'node_modules',
                    this.libdir,
                ],
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            };
            this.tsconfig = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        this.gitignore.exclude(`/${this.libdir}`);
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(`/${this.libdir}`);
        this.gitignore.include(`/${this.srcdir}`);
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.exclude(`/${this.srcdir}`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.js`);
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude('/dist');
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude('dist'); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude('/tsconfig.json');
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude('/.github');
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude('/.vscode');
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude('/.idea');
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('/.projenrc.js');
        // tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them for us.
        // just run them directly from javascript.
        if (this.jest && compiledTests) {
            this.addDevDeps('@types/jest');
            const testout = path.posix.relative(this.srcdir, this.testdir);
            const libtest = path.posix.join(this.libdir, testout);
            const srctest = this.testdir;
            this.jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
            this.jest.addWatchIgnorePattern(`/${this.srcdir}/`);
            const resolveSnapshotPath = (test, ext) => {
                const fullpath = test.replace(libtest, srctest);
                return path.join(path.dirname(fullpath), '__snapshots__', path.basename(fullpath, '.js') + '.ts' + ext);
            };
            const resolveTestPath = (snap, ext) => {
                const filename = path.basename(snap, '.ts' + ext) + '.js';
                const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
                return path.join(dir, filename);
            };
            const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, 'jest-snapshot-resolver.js'));
            resolver.addLine('const path = require("path");');
            resolver.addLine(`const libtest = "${libtest}";`);
            resolver.addLine(`const srctest= "${srctest}";`);
            resolver.addLine('module.exports = {');
            resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
            resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
            resolver.addLine('  testPathForConsistencyCheck: path.join(\'some\', \'__tests__\', \'example.test.js\')');
            resolver.addLine('};');
            this.jest.addSnapshotResolver(`./${resolver.path}`);
        }
        if (this.jest && !compiledTests) {
            this.jest.addTestMatch('**\/__tests__/**\/*.ts?(x)');
            this.jest.addTestMatch('**\/?(*.)+(spec|test).ts?(x)');
            const baseTsconfig = {
                fileName: 'tsconfig.jest.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            // create a tsconfig for jest that does NOT include outDir and rootDir and
            // includes both "src" and "test" as inputs.
            const tsconfig = this.jest.generateTypescriptConfig(mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
            // if we test before compilation, remove the lib/ directory before running
            // tests so that we get a clean slate for testing.
            if (!compileBeforeTest) {
                // make sure to delete "lib" *before* running tests to ensure that
                // test code does not take a dependency on "lib" and instead on "src".
                this.testTask.prependExec(`rm -fr ${this.libdir}/`);
            }
            // compile test code
            this.testCompileTask.exec(`tsc --noEmit --project ${tsconfig.fileName}`);
        }
        if ((_y = options.eslint) !== null && _y !== void 0 ? _y : true) {
            this.eslint = new eslint_1.Eslint(this, {
                tsconfigPath: './tsconfig.eslint.json',
                dirs: [this.srcdir],
                devdirs: [this.testdir, 'build-tools'],
                fileExtensions: ['.ts', '.tsx'],
                ...options.eslintOptions,
            });
            const baseTsconfig = {
                fileName: 'tsconfig.eslint.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            this.tsconfigEslint = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        const tsver = options.typescriptVersion ? `@${options.typescriptVersion}` : '';
        this.addDevDeps(`typescript${tsver}`, `@types/node@^${(_z = this.package.minNodeVersion) !== null && _z !== void 0 ? _z : '10.17.0'}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_0 = options.sampleCode) !== null && _0 !== void 0 ? _0 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_typedoc_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_1 = options.projenrcTs) !== null && _1 !== void 0 ? _1 : false;
        if (projenrcTypeScript) {
            new projenrc_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.TypeScriptProject", version: "0.17.78" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            'export class Hello {',
            '  public sayHello() {',
            '    return \'hello, world!\';',
            '  }',
            '}',
        ].join('\n');
        const testCode = [
            "import { Hello } from '../src';",
            '',
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            '});',
        ].join('\n');
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                'index.ts': srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                'hello.test.ts': testCode,
            },
        });
    }
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: '',
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.TypeScriptAppProject", version: "0.17.78" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.TypeScriptLibraryProject", version: "0.17.78" };
;
/**
 * @internal
 */
function mergeTsconfigOptions(options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [
                ...(_d = previous.include) !== null && _d !== void 0 ? _d : [],
                ...(_e = current.include) !== null && _e !== void 0 ? _e : [],
            ],
            exclude: [
                ...(_f = previous.exclude) !== null && _f !== void 0 ? _f : [],
                ...(_g = current.exclude) !== null && _g !== void 0 ? _g : [],
            ],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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