"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const JSII_RELEASE_VERSION = 'latest';
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * kw
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        this.workflow = options.workflow;
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options) {
        var _b;
        const npmTokenSecret = (_b = options.npmTokenSecret) !== null && _b !== void 0 ? _b : 'NPM_TOKEN';
        this.workflow.addJobs({
            release_npm: {
                'name': 'Release to NPM',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-npm'),
                        env: {
                            NPM_TOKEN: `\${{ secrets.${npmTokenSecret} }}`,
                            NPM_DIST_TAG: options.distTag,
                            NPM_REGISTRY: options.registry,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options) {
        var _b;
        const nugetApiKeySecret = (_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY';
        this.workflow.addJobs({
            release_nuget: {
                'name': 'Release to Nuget',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-nuget'),
                        env: {
                            NUGET_API_KEY: `\${{ secrets.${nugetApiKeySecret} }}`,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options) {
        var _b, _c, _d, _e, _f;
        const mavenGpgPrivateKeySecret = (_b = options.mavenGpgPrivateKeySecret) !== null && _b !== void 0 ? _b : 'MAVEN_GPG_PRIVATE_KEY';
        const mavenGpgPrivateKeyPassphrase = (_c = options.mavenGpgPrivateKeyPassphrase) !== null && _c !== void 0 ? _c : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE';
        const mavenUsername = (_d = options.mavenUsername) !== null && _d !== void 0 ? _d : 'MAVEN_USERNAME';
        const mavenPassword = (_e = options.mavenPassword) !== null && _e !== void 0 ? _e : 'MAVEN_PASSWORD';
        const mavenStagingProfileId = (_f = options.mavenStagingProfileId) !== null && _f !== void 0 ? _f : 'MAVEN_STAGING_PROFILE_ID';
        this.workflow.addJobs({
            release_maven: {
                'name': 'Release to Maven',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-maven'),
                        env: {
                            MAVEN_ENDPOINT: options.mavenEndpoint,
                            MAVEN_SERVER_ID: options.mavenServerId,
                            MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
                            MAVEN_GPG_PRIVATE_KEY: `\${{ secrets.${mavenGpgPrivateKeySecret} }}`,
                            MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: `\${{ secrets.${mavenGpgPrivateKeyPassphrase} }}`,
                            MAVEN_PASSWORD: `\${{ secrets.${mavenPassword} }}`,
                            MAVEN_USERNAME: `\${{ secrets.${mavenUsername} }}`,
                            MAVEN_STAGING_PROFILE_ID: `\${{ secrets.${mavenStagingProfileId} }}`,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options) {
        var _b, _c;
        const twineUsername = (_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME';
        const twinePassword = (_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD';
        this.workflow.addJobs({
            release_pypi: {
                'name': 'Release to PyPi',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-pypi'),
                        env: {
                            TWINE_USERNAME: `\${{ secrets.${twineUsername} }}`,
                            TWINE_PASSWORD: `\${{ secrets.${twinePassword} }}`,
                            ...(options.twineRegistryUrl && { TWINE_REPOSITORY_URL: options.twineRegistryUrl }),
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options) {
        var _b, _c, _d;
        const githubTokenSecret = (_b = options.githubTokenSecret) !== null && _b !== void 0 ? _b : 'GO_GITHUB_TOKEN';
        this.workflow.addJobs({
            release_golang: {
                'name': 'Release to Go',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-golang'),
                        env: {
                            GITHUB_REPO: options.githubRepo,
                            GITHUB_TOKEN: `\${{ secrets.${githubTokenSecret} }}`,
                            GIT_BRANCH: options.gitBranch,
                            GIT_USER_NAME: (_c = options.gitUserName) !== null && _c !== void 0 ? _c : 'GitHub Actions',
                            GIT_USER_EMAIL: (_d = options.gitUserEmail) !== null && _d !== void 0 ? _d : 'github-actions@github.com',
                            GIT_COMMIT_MESSAGE: options.gitCommitMessage,
                        },
                    },
                ],
            },
        });
    }
    renderJsiiReleaseCommand(subcommand) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${subcommand}`;
    }
    renderDownloadArtifactStep() {
        return {
            name: 'Download build artifacts',
            uses: 'actions/download-artifact@v2',
            with: {
                name: this.artifactName,
                path: 'dist',
            },
        };
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.Publisher", version: "0.17.78" };
//# sourceMappingURL=data:application/json;base64,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