import * as inventory from '../inventory';
import { NewProjectOptionHints } from '../option-hints';
/**
 * Options for `renderProjectOptions`.
 */
export interface RenderProjectOptions {
    /**
     * The project type to render.
     */
    readonly type: inventory.ProjectType;
    /**
     * Project arguments as passed to `projen new`.
     */
    readonly args: Record<string, any>;
    /**
     * Include commented out options.
     * @default NewProjectOptionHints.FEATURED
     */
    readonly comments?: NewProjectOptionHints;
    /**
     * Inject a `__new__` attribute to the project constructor with a stringified
     * version of the project parameters and a `jsiiFqn` attribute that includes
     * the FQN of the project type. This is needed in order to generate initial
     * projenrc files.
     *
     * @default false
     */
    readonly bootstrap?: boolean;
}
/**
 * Renders options as if the project was created via `projen new` (embeds the __new__ field).
 */
export declare function renderProjenNewOptions(fqn: string, args: Record<string, any>, comments?: NewProjectOptionHints): any;
export declare function resolveNewProject(opts: any): {
    args: Record<string, any>;
    fqn: string;
    type: inventory.ProjectType;
    comments: NewProjectOptionHints;
} | undefined;
/**
 * Prints all parameters that can be used in a project type, alongside their descriptions.
 *
 * Parameters in `params` that aren't undefined are rendered as defaults,
 * while all other parameters are rendered as commented out.
 */
export declare function renderJavaScriptOptions(opts: RenderProjectOptions): string;
