# VirtualNavigation_Client.py
#
# Copyright 2018 Eiichi Inohira
# This software may be modified and distributed under the terms
# of the MIT license
#
# For python3
# For HRI Engine

"""VirtualNavigation_Client
"""

import threading
# import logging
import xmlrpc.client

from pyrois import RoIS_Common, RoIS_HRI


class Command(RoIS_Common.Command):
    """Command
    """
    def __init__(self, uri):
        self._uri = uri
        self._proxy = xmlrpc.client.ServerProxy(self._uri)

    def start(self):
        status = RoIS_HRI.ReturnCode_t(self._proxy.start())
        return status

    def stop(self):
        status = RoIS_HRI.ReturnCode_t(self._proxy.stop())
        return status

    def suspend(self):
        status = RoIS_HRI.ReturnCode_t(self._proxy.suspend())
        return status

    def resume(self):
        status = RoIS_HRI.ReturnCode_t(self._proxy.resume())
        return status

    def set_parameter(self, target_position, time_limit, routing_policy):
        status = self._proxy.set_parameter(target_position, time_limit, routing_policy)
        status = RoIS_HRI.ReturnCode_t(status)
        return status
    

class Query(RoIS_Common.Query):
    """Query
    """
    def __init__(self, uri):
        self._uri = uri
        self._proxy = xmlrpc.client.ServerProxy(self._uri)

    def component_status(self):
        status, c_status = self._proxy.component_status()
        return (RoIS_HRI.ReturnCode_t(status), RoIS_Common.Component_Status(c_status))
    
    def get_parameter(self):
        (status, target_position, time_limit, routing_policy) = self._proxy.get_parameter()
        return (RoIS_HRI.ReturnCode_t(status), target_position, time_limit, routing_policy)

import time

class Event(RoIS_Common.Event):
    """Event
    """
    def __init__(self, uri):
        self._uri = uri
        self._e_proxy = xmlrpc.client.ServerProxy(self._uri)
        self.events = []
        # if logger is not None:
        #     self.logger = logger
                
    def start_th(self):
       self.th = threading.Thread(target=self.event_loop)
       self.th.start()

    def event_loop(self):
       """event_loop
       """
       while True:
           time.sleep(1)
           try:
               self.poll_event()
           except xmlrpc.client.ProtocolError as e:
               print("ProtocolError", e)
               continue
           except ConnectionRefusedError as e:
               print("ConnectionRefusedError ", e)
               continue

    def poll_event(self):
       """poll_event
       """
       msg = self._e_proxy.poll_event()
       (params, methodname) = xmlrpc.client.loads(msg)


class VirtualNavigation_Client(Command, Query, Event):
    """VirtualNavigation_Client
    """
    def __init__(self, uri, engine_event_queue):
        self._uri = uri
        self._proxy = xmlrpc.client.ServerProxy(self._uri)
        self._e_proxy = xmlrpc.client.ServerProxy(self._uri)
        self.events = []
        self.engine_event_queue = engine_event_queue
        self.start_th()

    def poll_event(self):
        """poll_event
        """
        msg = self._e_proxy.poll_event()
        (params, methodname) = xmlrpc.client.loads(msg)
        self.engine_event_queue.put(msg)
