---
name: Bug Report
about: Help us make Nexios better by reporting bugs
labels: bug
---

## 🐞 **Bug Report**

Thank you for helping us improve Nexios! We're sorry you've encountered a bug, and we’ll do our best to get it fixed quickly.

Please provide as much detail as you can. This will help us identify the issue faster. If you can, attach any error logs or screenshots — they make all the difference!

### 1. **What version of Nexios are you using?**  
Include the version number or commit hash that you’re currently working with.  
Example: `v0.1.0`, `commit abc123`.

---

### 2. **Describe the bug**  
Give a clear and concise description of the issue you’ve run into.  
Example: *"When I run `nexios create`, it gives me a `ModuleNotFoundError`."*

---

### 3. **Steps to Reproduce**  
Please provide detailed steps to reproduce the bug. The more specific, the better!

1. Step one
2. Step two
3. Step three

---

### 4. **What did you expect to happen?**  
Tell us what you expected the outcome to be after following the steps.

Example: *“I expected the command to run successfully and create a new Nexios project.”*

---

### 5. **What actually happened?**  
Let us know what went wrong or what was unexpected.

Example: *“Instead of running, I got an error saying the module was missing.”*

---

### 6. **What is your environment?**  
Tell us a bit about your environment: Operating System, Python version, any relevant libraries, etc.  

Example:  
- OS: Ubuntu 20.04  
- Python: 3.9  
- Other libraries you’re using: Django 3.1, etc.

---

### 7. **Additional context**  
If there’s anything else that could help us fix the bug, let us know! You can attach logs, screenshots, or any other info.

---
