## Main Methodology
### 开发目标
1.开发者只需要预先提供pytorch风格的算与目标硬件，
就可以得到由这些算子组成的模型的延迟预测器。

### 组成
解析器 Parser
解析算子描述文件为一系列算子，解析模型至对应算子。

### 方案1
开发者编写ops_list.yaml
```yaml
ops: None
torch.nn:
    Conv1d:
        in_channels: [8, 16, 32]
        out_channels: [16, 32, 64]
        kernel_size: [3, 5, 7]
        stride: [1, 2]
        padding: [1, 2]
        input_shape: [[1, 8, 16], [1, 16, 16], [1, 32, 16]]  # 注意长度
    ReLU:
        no_params: true
        input_shape: [[1, 1], [1, 3]]
    Sigmoid:
        no_params: true
        input_shape: [[1, 1], [1, 4]]
    Linear:
        in_features: [8, 16]
        out_features: [16, 32]
        input_shape: [[1, 8], [1, 16]]
```
### 难点
算子多层级化，不同后端的基础算子的融合模式不同
，**假设暂时不考虑算子融合**，关键在于：
* 将目标编写的算子(可能是多种基类封装的算子)
转化为对应的mnn算子
* 测试对应算子的延迟
* 基于算子延迟表，预测给定模型的预测延迟
* 将模型直接转为mnn并测试延迟与算子测算法进行对比

多种算子，同类算子下不同配置，怎么写？

```python
# pytorch算子
class ops(nn.Module):
    def __init__(self):
        super(ops, self).__init__()
        self.sub_obs = ...
        ...
    def

```