"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class OpenSearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::OpenSearchAccessPolicy',
            onUpdate: {
                action: 'updateDomainConfig',
                service: 'OpenSearch',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPaths: ['DomainConfig.AccessPolicies'],
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromStatements([new iam.PolicyStatement({ actions: ['es:UpdateDomainConfig'], resources: [props.domainArn] })]),
        });
    }
}
exports.OpenSearchAccessPolicy = OpenSearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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