# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoleAssignmentsArgs', 'RoleAssignments']

@pulumi.input_type
class RoleAssignmentsArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group_identifier: Optional[pulumi.Input[str]] = None,
                 role_identifier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RoleAssignments resource.
        :param pulumi.Input[bool] disabled: Disabled or not.
        :param pulumi.Input[str] identifier: Identifier for role assignment.
        :param pulumi.Input[bool] managed: Managed or not.
        :param pulumi.Input[str] org_id: Org identifier.
        :param pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]] principals: Principal.
        :param pulumi.Input[str] project_id: Project Identifier
        :param pulumi.Input[str] resource_group_identifier: Resource group identifier.
        :param pulumi.Input[str] role_identifier: Role identifier.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_group_identifier is not None:
            pulumi.set(__self__, "resource_group_identifier", resource_group_identifier)
        if role_identifier is not None:
            pulumi.set(__self__, "role_identifier", role_identifier)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disabled or not.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for role assignment.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Managed or not.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Org identifier.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]]:
        """
        Principal.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="resourceGroupIdentifier")
    def resource_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group identifier.
        """
        return pulumi.get(self, "resource_group_identifier")

    @resource_group_identifier.setter
    def resource_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_identifier", value)

    @property
    @pulumi.getter(name="roleIdentifier")
    def role_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Role identifier.
        """
        return pulumi.get(self, "role_identifier")

    @role_identifier.setter
    def role_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_identifier", value)


@pulumi.input_type
class _RoleAssignmentsState:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group_identifier: Optional[pulumi.Input[str]] = None,
                 role_identifier: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RoleAssignments resources.
        :param pulumi.Input[bool] disabled: Disabled or not.
        :param pulumi.Input[str] identifier: Identifier for role assignment.
        :param pulumi.Input[bool] managed: Managed or not.
        :param pulumi.Input[str] org_id: Org identifier.
        :param pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]] principals: Principal.
        :param pulumi.Input[str] project_id: Project Identifier
        :param pulumi.Input[str] resource_group_identifier: Resource group identifier.
        :param pulumi.Input[str] role_identifier: Role identifier.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_group_identifier is not None:
            pulumi.set(__self__, "resource_group_identifier", resource_group_identifier)
        if role_identifier is not None:
            pulumi.set(__self__, "role_identifier", role_identifier)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disabled or not.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for role assignment.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Managed or not.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Org identifier.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]]:
        """
        Principal.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleAssignmentsPrincipalArgs']]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="resourceGroupIdentifier")
    def resource_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group identifier.
        """
        return pulumi.get(self, "resource_group_identifier")

    @resource_group_identifier.setter
    def resource_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_identifier", value)

    @property
    @pulumi.getter(name="roleIdentifier")
    def role_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Role identifier.
        """
        return pulumi.get(self, "role_identifier")

    @role_identifier.setter
    def role_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_identifier", value)


class RoleAssignments(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleAssignmentsPrincipalArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group_identifier: Optional[pulumi.Input[str]] = None,
                 role_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating role assignments in Harness.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        #To create a role binding in service account
        example1_role_assignments = harness.platform.RoleAssignments("example1RoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier=harness_platform_service_account["test"]["id"],
                type="SERVICE_ACCOUNT",
            )],
            disabled=False,
            managed=False)
        #To create a role binding in user group 
        example1_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example1Platform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier=harness_platform_usergroup["test"]["id"],
                type="USER_GROUP",
            )],
            disabled=False,
            managed=False)
        example2_role_assignments = harness.platform.RoleAssignments("example2RoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="user_id",
                type="USER",
            )],
            disabled=False,
            managed=False)
        example2_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example2Platform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="service_id",
                type="SERVICE",
            )],
            disabled=False,
            managed=False)
        example2_harness_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example2HarnessPlatform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="api_key_id",
                type="API_KEY",
            )],
            disabled=False,
            managed=False)
        ```

        ## Import

        Import using roleassignments id

        ```sh
         $ pulumi import harness:platform/roleAssignments:RoleAssignments example <role_assignments_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: Disabled or not.
        :param pulumi.Input[str] identifier: Identifier for role assignment.
        :param pulumi.Input[bool] managed: Managed or not.
        :param pulumi.Input[str] org_id: Org identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleAssignmentsPrincipalArgs']]]] principals: Principal.
        :param pulumi.Input[str] project_id: Project Identifier
        :param pulumi.Input[str] resource_group_identifier: Resource group identifier.
        :param pulumi.Input[str] role_identifier: Role identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleAssignmentsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating role assignments in Harness.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        #To create a role binding in service account
        example1_role_assignments = harness.platform.RoleAssignments("example1RoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier=harness_platform_service_account["test"]["id"],
                type="SERVICE_ACCOUNT",
            )],
            disabled=False,
            managed=False)
        #To create a role binding in user group 
        example1_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example1Platform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier=harness_platform_usergroup["test"]["id"],
                type="USER_GROUP",
            )],
            disabled=False,
            managed=False)
        example2_role_assignments = harness.platform.RoleAssignments("example2RoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="user_id",
                type="USER",
            )],
            disabled=False,
            managed=False)
        example2_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example2Platform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="service_id",
                type="SERVICE",
            )],
            disabled=False,
            managed=False)
        example2_harness_platform_role_assignments_role_assignments = harness.platform.RoleAssignments("example2HarnessPlatform/roleAssignmentsRoleAssignments",
            identifier="identifier",
            org_id="org_id",
            project_id="project_id",
            resource_group_identifier="_all_project_level_resources",
            role_identifier="_project_viewer",
            principals=[harness.platform.RoleAssignmentsPrincipalArgs(
                identifier="api_key_id",
                type="API_KEY",
            )],
            disabled=False,
            managed=False)
        ```

        ## Import

        Import using roleassignments id

        ```sh
         $ pulumi import harness:platform/roleAssignments:RoleAssignments example <role_assignments_id>
        ```

        :param str resource_name: The name of the resource.
        :param RoleAssignmentsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleAssignmentsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleAssignmentsPrincipalArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group_identifier: Optional[pulumi.Input[str]] = None,
                 role_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleAssignmentsArgs.__new__(RoleAssignmentsArgs)

            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["managed"] = managed
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["principals"] = principals
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["resource_group_identifier"] = resource_group_identifier
            __props__.__dict__["role_identifier"] = role_identifier
        super(RoleAssignments, __self__).__init__(
            'harness:platform/roleAssignments:RoleAssignments',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            managed: Optional[pulumi.Input[bool]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleAssignmentsPrincipalArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            resource_group_identifier: Optional[pulumi.Input[str]] = None,
            role_identifier: Optional[pulumi.Input[str]] = None) -> 'RoleAssignments':
        """
        Get an existing RoleAssignments resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: Disabled or not.
        :param pulumi.Input[str] identifier: Identifier for role assignment.
        :param pulumi.Input[bool] managed: Managed or not.
        :param pulumi.Input[str] org_id: Org identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleAssignmentsPrincipalArgs']]]] principals: Principal.
        :param pulumi.Input[str] project_id: Project Identifier
        :param pulumi.Input[str] resource_group_identifier: Resource group identifier.
        :param pulumi.Input[str] role_identifier: Role identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleAssignmentsState.__new__(_RoleAssignmentsState)

        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["managed"] = managed
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["principals"] = principals
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_group_identifier"] = resource_group_identifier
        __props__.__dict__["role_identifier"] = role_identifier
        return RoleAssignments(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Disabled or not.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier for role assignment.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def managed(self) -> pulumi.Output[Optional[bool]]:
        """
        Managed or not.
        """
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Org identifier.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Optional[Sequence['outputs.RoleAssignmentsPrincipal']]]:
        """
        Principal.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="resourceGroupIdentifier")
    def resource_group_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Resource group identifier.
        """
        return pulumi.get(self, "resource_group_identifier")

    @property
    @pulumi.getter(name="roleIdentifier")
    def role_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Role identifier.
        """
        return pulumi.get(self, "role_identifier")

