# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AppDynamicsConnectorApiToken',
    'AppDynamicsConnectorUsernamePassword',
    'ArtifactoryConnectorCredentials',
    'AwsCCConnectorCrossAccountAccess',
    'AwsConnectorCrossAccountAccess',
    'AwsConnectorInheritFromDelegate',
    'AwsConnectorIrsa',
    'AwsConnectorManual',
    'AwsKmsConnectorCredentials',
    'AwsKmsConnectorCredentialsAssumeRole',
    'AwsKmsConnectorCredentialsManual',
    'AwsSecretManagerConnectorCredentials',
    'AwsSecretManagerConnectorCredentialsAssumeRole',
    'AwsSecretManagerConnectorCredentialsManual',
    'BitbucketConnectorApiAuthentication',
    'BitbucketConnectorCredentials',
    'BitbucketConnectorCredentialsHttp',
    'BitbucketConnectorCredentialsSsh',
    'DockerConnectorCredentials',
    'EnvironmentClustersMappingCluster',
    'GcpConnectorInheritFromDelegate',
    'GcpConnectorManual',
    'GitConnectorCredentials',
    'GitConnectorCredentialsHttp',
    'GitConnectorCredentialsSsh',
    'GitOpsAgentMetadata',
    'GitOpsClusterQuery',
    'GitOpsClusterQueryId',
    'GitOpsClusterRequest',
    'GitOpsClusterRequestCluster',
    'GitOpsClusterRequestClusterConfig',
    'GitOpsClusterRequestClusterConfigAwsAuthConfig',
    'GitOpsClusterRequestClusterConfigExecProviderConfig',
    'GitOpsClusterRequestClusterConfigTlsClientConfig',
    'GitOpsClusterRequestClusterInfo',
    'GitOpsClusterRequestClusterInfoCacheInfo',
    'GitOpsClusterRequestClusterInfoConnectionState',
    'GitOpsClusterRequestClusterInfoConnectionStateAttemptedAt',
    'GitOpsClusterRequestClusterRefreshRequestedAt',
    'GitOpsClusterRequestId',
    'GitOpsClusterRequestUpdateMask',
    'GitOpsRepositoryRepo',
    'GitOpsRepositoryUpdateMask',
    'GithubConnectorApiAuthentication',
    'GithubConnectorApiAuthenticationGithubApp',
    'GithubConnectorCredentials',
    'GithubConnectorCredentialsHttp',
    'GithubConnectorCredentialsSsh',
    'GitlabConnectorApiAuthentication',
    'GitlabConnectorCredentials',
    'GitlabConnectorCredentialsHttp',
    'GitlabConnectorCredentialsSsh',
    'HelmConnectorCredentials',
    'KubernetesConnectorClientKeyCert',
    'KubernetesConnectorInheritFromDelegate',
    'KubernetesConnectorOpenidConnect',
    'KubernetesConnectorServiceAccount',
    'KubernetesConnectorUsernamePassword',
    'NexusConnectorCredentials',
    'PrometheusConnectorHeader',
    'ResourceGroupIncludedScope',
    'ResourceGroupResourceFilter',
    'ResourceGroupResourceFilterResource',
    'ResourceGroupResourceFilterResourceAttributeFilter',
    'RoleAssignmentsPrincipal',
    'SecretSshkeyKerberos',
    'SecretSshkeyKerberosTgtKeyTabFilePathSpec',
    'SecretSshkeyKerberosTgtPasswordSpec',
    'SecretSshkeySsh',
    'SecretSshkeySshSshPasswordCredential',
    'SecretSshkeySshSshkeyPathCredential',
    'SecretSshkeySshSshkeyReferenceCredential',
    'UsergroupNotificationConfig',
    'VariablesSpec',
    'GetAppDynamicsConnectorApiTokenResult',
    'GetAppDynamicsConnectorUsernamePasswordResult',
    'GetArtifactoryConnectorCredentialResult',
    'GetAwsCCConnectorCrossAccountAccessResult',
    'GetAwsConnectorCrossAccountAccessResult',
    'GetAwsConnectorInheritFromDelegateResult',
    'GetAwsConnectorIrsaResult',
    'GetAwsConnectorManualResult',
    'GetAwsKmsConnectorCredentialResult',
    'GetAwsKmsConnectorCredentialAssumeRoleResult',
    'GetAwsKmsConnectorCredentialManualResult',
    'GetAwsSecretManagerConnectorCredentialResult',
    'GetAwsSecretManagerConnectorCredentialAssumeRoleResult',
    'GetAwsSecretManagerConnectorCredentialManualResult',
    'GetBitbucketConnectorApiAuthenticationResult',
    'GetBitbucketConnectorCredentialResult',
    'GetBitbucketConnectorCredentialHttpResult',
    'GetBitbucketConnectorCredentialSshResult',
    'GetDockerConnectorCredentialResult',
    'GetGcpConnectorInheritFromDelegateResult',
    'GetGcpConnectorManualResult',
    'GetGitConnectorCredentialResult',
    'GetGitConnectorCredentialHttpResult',
    'GetGitConnectorCredentialSshResult',
    'GetGithubConnectorApiAuthenticationResult',
    'GetGithubConnectorApiAuthenticationGithubAppResult',
    'GetGithubConnectorCredentialResult',
    'GetGithubConnectorCredentialHttpResult',
    'GetGithubConnectorCredentialSshResult',
    'GetGitlabConnectorApiAuthenticationResult',
    'GetGitlabConnectorCredentialResult',
    'GetGitlabConnectorCredentialHttpResult',
    'GetGitlabConnectorCredentialSshResult',
    'GetGitopsAgentMetadataResult',
    'GetGitopsClusterQueryResult',
    'GetGitopsClusterQueryIdResult',
    'GetGitopsClusterRequestResult',
    'GetGitopsClusterRequestClusterResult',
    'GetGitopsClusterRequestClusterConfigResult',
    'GetGitopsClusterRequestClusterConfigAwsAuthConfigResult',
    'GetGitopsClusterRequestClusterConfigExecProviderConfigResult',
    'GetGitopsClusterRequestClusterConfigTlsClientConfigResult',
    'GetGitopsClusterRequestClusterInfoResult',
    'GetGitopsClusterRequestClusterInfoCacheInfoResult',
    'GetGitopsClusterRequestClusterInfoConnectionStateResult',
    'GetGitopsClusterRequestClusterInfoConnectionStateAttemptedAtResult',
    'GetGitopsClusterRequestClusterRefreshRequestedAtResult',
    'GetGitopsClusterRequestIdResult',
    'GetGitopsClusterRequestUpdateMaskResult',
    'GetGitopsRepositoryRepoResult',
    'GetGitopsRepositoryUpdateMaskResult',
    'GetHelmConnectorCredentialResult',
    'GetKubernetesConnectorClientKeyCertResult',
    'GetKubernetesConnectorInheritFromDelegateResult',
    'GetKubernetesConnectorOpenidConnectResult',
    'GetKubernetesConnectorServiceAccountResult',
    'GetKubernetesConnectorUsernamePasswordResult',
    'GetNexusConnectorCredentialResult',
    'GetPermissionsPermissionResult',
    'GetPrometheusConnectorHeaderResult',
    'GetResourceGroupIncludedScopeResult',
    'GetResourceGroupResourceFilterResult',
    'GetResourceGroupResourceFilterResourceResult',
    'GetResourceGroupResourceFilterResourceAttributeFilterResult',
    'GetRoleAssignmentsPrincipalResult',
    'GetSecretSshkeyKerberoResult',
    'GetSecretSshkeyKerberoTgtKeyTabFilePathSpecResult',
    'GetSecretSshkeyKerberoTgtPasswordSpecResult',
    'GetSecretSshkeySshResult',
    'GetSecretSshkeySshSshPasswordCredentialResult',
    'GetSecretSshkeySshSshkeyPathCredentialResult',
    'GetSecretSshkeySshSshkeyReferenceCredentialResult',
    'GetUsergroupNotificationConfigResult',
]

@pulumi.output_type
class AppDynamicsConnectorApiToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretRef":
            suggest = "client_secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDynamicsConnectorApiToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDynamicsConnectorApiToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDynamicsConnectorApiToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret_ref: str):
        """
        :param str client_id: The client id used for connecting to App Dynamics.
        :param str client_secret_ref: Reference to the Harness secret containing the App Dynamics client secret.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret_ref", client_secret_ref)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id used for connecting to App Dynamics.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretRef")
    def client_secret_ref(self) -> str:
        """
        Reference to the Harness secret containing the App Dynamics client secret.
        """
        return pulumi.get(self, "client_secret_ref")


@pulumi.output_type
class AppDynamicsConnectorUsernamePassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDynamicsConnectorUsernamePassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDynamicsConnectorUsernamePassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDynamicsConnectorUsernamePassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: str):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ArtifactoryConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactoryConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactoryConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactoryConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class AwsCCConnectorCrossAccountAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCCConnectorCrossAccountAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCCConnectorCrossAccountAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCCConnectorCrossAccountAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        """
        :param str external_id: The external id of the role to use for cross-account access. This is a random unique value to provide additional secure authentication.
        :param str role_arn: The ARN of the role to use for cross-account access.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        The external id of the role to use for cross-account access. This is a random unique value to provide additional secure authentication.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role to use for cross-account access.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AwsConnectorCrossAccountAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsConnectorCrossAccountAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsConnectorCrossAccountAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsConnectorCrossAccountAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 external_id: Optional[str] = None):
        """
        :param str role_arn: The Amazon Resource Name (ARN) of the role that you want to assume. This is an IAM role in the target AWS account.
        :param str external_id: If the administrator of the account to which the role belongs provided you with an external ID, then enter that value.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the role that you want to assume. This is an IAM role in the target AWS account.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        If the administrator of the account to which the role belongs provided you with an external ID, then enter that value.
        """
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsConnectorInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsConnectorInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsConnectorInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsConnectorInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsConnectorIrsa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsConnectorIrsa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsConnectorIrsa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsConnectorIrsa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsConnectorManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"
        elif key == "accessKey":
            suggest = "access_key"
        elif key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsConnectorManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsConnectorManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsConnectorManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: str,
                 access_key: Optional[str] = None,
                 access_key_ref: Optional[str] = None,
                 delegate_selectors: Optional[Sequence[str]] = None):
        """
        :param str secret_key_ref: Reference to the Harness secret containing the aws secret key.
        :param str access_key: AWS access key.
        :param str access_key_ref: Reference to the Harness secret containing the aws access key.
        :param Sequence[str] delegate_selectors: Connect only use delegates with these tags.
        """
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if access_key_ref is not None:
            pulumi.set(__self__, "access_key_ref", access_key_ref)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        """
        Reference to the Harness secret containing the aws secret key.
        """
        return pulumi.get(self, "secret_key_ref")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        AWS access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> Optional[str]:
        """
        Reference to the Harness secret containing the aws access key.
        """
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[Sequence[str]]:
        """
        Connect only use delegates with these tags.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsKmsConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assumeRole":
            suggest = "assume_role"
        elif key == "inheritFromDelegate":
            suggest = "inherit_from_delegate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assume_role: Optional['outputs.AwsKmsConnectorCredentialsAssumeRole'] = None,
                 inherit_from_delegate: Optional[bool] = None,
                 manual: Optional['outputs.AwsKmsConnectorCredentialsManual'] = None):
        """
        :param 'AwsKmsConnectorCredentialsAssumeRoleArgs' assume_role: Connect using STS assume role.
        :param bool inherit_from_delegate: Inherit the credentials from from the delegate.
        :param 'AwsKmsConnectorCredentialsManualArgs' manual: Specify the AWS key and secret used for authenticating.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional['outputs.AwsKmsConnectorCredentialsAssumeRole']:
        """
        Connect using STS assume role.
        """
        return pulumi.get(self, "assume_role")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[bool]:
        """
        Inherit the credentials from from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manual(self) -> Optional['outputs.AwsKmsConnectorCredentialsManual']:
        """
        Specify the AWS key and secret used for authenticating.
        """
        return pulumi.get(self, "manual")


@pulumi.output_type
class AwsKmsConnectorCredentialsAssumeRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsConnectorCredentialsAssumeRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsConnectorCredentialsAssumeRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsConnectorCredentialsAssumeRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 role_arn: str,
                 external_id: Optional[str] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsKmsConnectorCredentialsManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsConnectorCredentialsManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsConnectorCredentialsManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsConnectorCredentialsManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class AwsSecretManagerConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assumeRole":
            suggest = "assume_role"
        elif key == "inheritFromDelegate":
            suggest = "inherit_from_delegate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assume_role: Optional['outputs.AwsSecretManagerConnectorCredentialsAssumeRole'] = None,
                 inherit_from_delegate: Optional[bool] = None,
                 manual: Optional['outputs.AwsSecretManagerConnectorCredentialsManual'] = None):
        """
        :param 'AwsSecretManagerConnectorCredentialsAssumeRoleArgs' assume_role: Connect using STS assume role.
        :param bool inherit_from_delegate: Inherit the credentials from from the delegate.
        :param 'AwsSecretManagerConnectorCredentialsManualArgs' manual: Specify the AWS key and secret used for authenticating.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional['outputs.AwsSecretManagerConnectorCredentialsAssumeRole']:
        """
        Connect using STS assume role.
        """
        return pulumi.get(self, "assume_role")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[bool]:
        """
        Inherit the credentials from from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manual(self) -> Optional['outputs.AwsSecretManagerConnectorCredentialsManual']:
        """
        Specify the AWS key and secret used for authenticating.
        """
        return pulumi.get(self, "manual")


@pulumi.output_type
class AwsSecretManagerConnectorCredentialsAssumeRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerConnectorCredentialsAssumeRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerConnectorCredentialsAssumeRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerConnectorCredentialsAssumeRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 role_arn: str,
                 external_id: Optional[str] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsSecretManagerConnectorCredentialsManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerConnectorCredentialsManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerConnectorCredentialsManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerConnectorCredentialsManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class BitbucketConnectorApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketConnectorApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketConnectorApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketConnectorApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str token_ref: Personal access token for interacting with the BitBucket api.
        :param str username: The username used for connecting to the api.
        :param str username_ref: The name of the Harness secret containing the username.
        """
        pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        """
        Personal access token for interacting with the BitBucket api.
        """
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username used for connecting to the api.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        The name of the Harness secret containing the username.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class BitbucketConnectorCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.BitbucketConnectorCredentialsHttp'] = None,
                 ssh: Optional['outputs.BitbucketConnectorCredentialsSsh'] = None):
        """
        :param 'BitbucketConnectorCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'BitbucketConnectorCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.BitbucketConnectorCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.BitbucketConnectorCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class BitbucketConnectorCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketConnectorCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketConnectorCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketConnectorCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        if password_ref is not None:
            pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> Optional[str]:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class BitbucketConnectorCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketConnectorCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketConnectorCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketConnectorCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class DockerConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: The reference to the password to use for the docker registry.
        :param str username: The username to use for the docker registry.
        :param str username_ref: The reference to the username to use for the docker registry.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        The reference to the password to use for the docker registry.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to use for the docker registry.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        The reference to the username to use for the docker registry.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class EnvironmentClustersMappingCluster(dict):
    def __init__(__self__, *,
                 identifier: Optional[str] = None,
                 name: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        :param str identifier: account Identifier of the account
        :param str name: name of the cluster
        :param str scope: scope at which the cluster exists in harness gitops, project vs org vs account
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        account Identifier of the account
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of the cluster
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope at which the cluster exists in harness gitops, project vs org vs account
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GcpConnectorInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpConnectorInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpConnectorInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpConnectorInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GcpConnectorManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpConnectorManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpConnectorManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpConnectorManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        """
        :param Sequence[str] delegate_selectors: The delegates to connect with.
        :param str secret_key_ref: Reference to the Harness secret containing the secret key.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to connect with.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        """
        Reference to the Harness secret containing the secret key.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GitConnectorCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GitConnectorCredentialsHttp'] = None,
                 ssh: Optional['outputs.GitConnectorCredentialsSsh'] = None):
        """
        :param 'GitConnectorCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GitConnectorCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GitConnectorCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GitConnectorCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GitConnectorCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitConnectorCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitConnectorCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitConnectorCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GitConnectorCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitConnectorCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitConnectorCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitConnectorCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GitOpsAgentMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highAvailability":
            suggest = "high_availability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsAgentMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsAgentMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsAgentMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_availability: Optional[bool] = None,
                 namespace: Optional[str] = None):
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[bool]:
        return pulumi.get(self, "high_availability")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GitOpsClusterQuery(dict):
    def __init__(__self__, *,
                 ids: Optional[Sequence['outputs.GitOpsClusterQueryId']] = None,
                 name: Optional[str] = None,
                 server: Optional[str] = None):
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GitOpsClusterQueryId']]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        return pulumi.get(self, "server")


@pulumi.output_type
class GitOpsClusterQueryId(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GitOpsClusterRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateMasks":
            suggest = "update_masks"
        elif key == "updatedFields":
            suggest = "updated_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clusters: Optional[Sequence['outputs.GitOpsClusterRequestCluster']] = None,
                 ids: Optional[Sequence['outputs.GitOpsClusterRequestId']] = None,
                 update_masks: Optional[Sequence['outputs.GitOpsClusterRequestUpdateMask']] = None,
                 updated_fields: Optional[Sequence[str]] = None,
                 upsert: Optional[bool] = None):
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if updated_fields is not None:
            pulumi.set(__self__, "updated_fields", updated_fields)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence['outputs.GitOpsClusterRequestCluster']]:
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GitOpsClusterRequestId']]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> Optional[Sequence['outputs.GitOpsClusterRequestUpdateMask']]:
        return pulumi.get(self, "update_masks")

    @property
    @pulumi.getter(name="updatedFields")
    def updated_fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "updated_fields")

    @property
    @pulumi.getter
    def upsert(self) -> Optional[bool]:
        return pulumi.get(self, "upsert")


@pulumi.output_type
class GitOpsClusterRequestCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterResources":
            suggest = "cluster_resources"
        elif key == "refreshRequestedAts":
            suggest = "refresh_requested_ats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server: str,
                 annotations: Optional[Mapping[str, str]] = None,
                 cluster_resources: Optional[bool] = None,
                 configs: Optional[Sequence['outputs.GitOpsClusterRequestClusterConfig']] = None,
                 infos: Optional[Sequence['outputs.GitOpsClusterRequestClusterInfo']] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 namespaces: Optional[Sequence[str]] = None,
                 project: Optional[str] = None,
                 refresh_requested_ats: Optional[Sequence['outputs.GitOpsClusterRequestClusterRefreshRequestedAt']] = None,
                 shard: Optional[str] = None):
        pulumi.set(__self__, "server", server)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_resources is not None:
            pulumi.set(__self__, "cluster_resources", cluster_resources)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if refresh_requested_ats is not None:
            pulumi.set(__self__, "refresh_requested_ats", refresh_requested_ats)
        if shard is not None:
            pulumi.set(__self__, "shard", shard)

    @property
    @pulumi.getter
    def server(self) -> str:
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterResources")
    def cluster_resources(self) -> Optional[bool]:
        return pulumi.get(self, "cluster_resources")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterConfig']]:
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def infos(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterInfo']]:
        return pulumi.get(self, "infos")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="refreshRequestedAts")
    def refresh_requested_ats(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterRefreshRequestedAt']]:
        return pulumi.get(self, "refresh_requested_ats")

    @property
    @pulumi.getter
    def shard(self) -> Optional[str]:
        return pulumi.get(self, "shard")


@pulumi.output_type
class GitOpsClusterRequestClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAuthConfigs":
            suggest = "aws_auth_configs"
        elif key == "bearerToken":
            suggest = "bearer_token"
        elif key == "clusterConnectionType":
            suggest = "cluster_connection_type"
        elif key == "execProviderConfigs":
            suggest = "exec_provider_configs"
        elif key == "tlsClientConfigs":
            suggest = "tls_client_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_auth_configs: Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigAwsAuthConfig']] = None,
                 bearer_token: Optional[str] = None,
                 cluster_connection_type: Optional[str] = None,
                 exec_provider_configs: Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigExecProviderConfig']] = None,
                 password: Optional[str] = None,
                 tls_client_configs: Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigTlsClientConfig']] = None,
                 username: Optional[str] = None):
        if aws_auth_configs is not None:
            pulumi.set(__self__, "aws_auth_configs", aws_auth_configs)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)
        if cluster_connection_type is not None:
            pulumi.set(__self__, "cluster_connection_type", cluster_connection_type)
        if exec_provider_configs is not None:
            pulumi.set(__self__, "exec_provider_configs", exec_provider_configs)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if tls_client_configs is not None:
            pulumi.set(__self__, "tls_client_configs", tls_client_configs)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="awsAuthConfigs")
    def aws_auth_configs(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigAwsAuthConfig']]:
        return pulumi.get(self, "aws_auth_configs")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[str]:
        return pulumi.get(self, "bearer_token")

    @property
    @pulumi.getter(name="clusterConnectionType")
    def cluster_connection_type(self) -> Optional[str]:
        return pulumi.get(self, "cluster_connection_type")

    @property
    @pulumi.getter(name="execProviderConfigs")
    def exec_provider_configs(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigExecProviderConfig']]:
        return pulumi.get(self, "exec_provider_configs")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="tlsClientConfigs")
    def tls_client_configs(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterConfigTlsClientConfig']]:
        return pulumi.get(self, "tls_client_configs")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")


@pulumi.output_type
class GitOpsClusterRequestClusterConfigAwsAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "roleARN":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterConfigAwsAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterConfigAwsAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterConfigAwsAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 role_arn: Optional[str] = None):
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GitOpsClusterRequestClusterConfigExecProviderConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "installHint":
            suggest = "install_hint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterConfigExecProviderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterConfigExecProviderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterConfigExecProviderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[str] = None,
                 env: Optional[Mapping[str, str]] = None,
                 install_hint: Optional[str] = None):
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if install_hint is not None:
            pulumi.set(__self__, "install_hint", install_hint)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="installHint")
    def install_hint(self) -> Optional[str]:
        return pulumi.get(self, "install_hint")


@pulumi.output_type
class GitOpsClusterRequestClusterConfigTlsClientConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caData":
            suggest = "ca_data"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterConfigTlsClientConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterConfigTlsClientConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterConfigTlsClientConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_data: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 server_name: Optional[str] = None):
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        return pulumi.get(self, "server_name")


@pulumi.output_type
class GitOpsClusterRequestClusterInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersions":
            suggest = "api_versions"
        elif key == "applicationsCount":
            suggest = "applications_count"
        elif key == "cacheInfos":
            suggest = "cache_infos"
        elif key == "connectionStates":
            suggest = "connection_states"
        elif key == "serverVersion":
            suggest = "server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_versions: Optional[Sequence[str]] = None,
                 applications_count: Optional[str] = None,
                 cache_infos: Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoCacheInfo']] = None,
                 connection_states: Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoConnectionState']] = None,
                 server_version: Optional[str] = None):
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if applications_count is not None:
            pulumi.set(__self__, "applications_count", applications_count)
        if cache_infos is not None:
            pulumi.set(__self__, "cache_infos", cache_infos)
        if connection_states is not None:
            pulumi.set(__self__, "connection_states", connection_states)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter(name="applicationsCount")
    def applications_count(self) -> Optional[str]:
        return pulumi.get(self, "applications_count")

    @property
    @pulumi.getter(name="cacheInfos")
    def cache_infos(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoCacheInfo']]:
        return pulumi.get(self, "cache_infos")

    @property
    @pulumi.getter(name="connectionStates")
    def connection_states(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoConnectionState']]:
        return pulumi.get(self, "connection_states")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[str]:
        return pulumi.get(self, "server_version")


@pulumi.output_type
class GitOpsClusterRequestClusterInfoCacheInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apisCount":
            suggest = "apis_count"
        elif key == "lastCacheSyncTime":
            suggest = "last_cache_sync_time"
        elif key == "resourcesCount":
            suggest = "resources_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterInfoCacheInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterInfoCacheInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterInfoCacheInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apis_count: Optional[str] = None,
                 last_cache_sync_time: Optional[str] = None,
                 resources_count: Optional[str] = None):
        if apis_count is not None:
            pulumi.set(__self__, "apis_count", apis_count)
        if last_cache_sync_time is not None:
            pulumi.set(__self__, "last_cache_sync_time", last_cache_sync_time)
        if resources_count is not None:
            pulumi.set(__self__, "resources_count", resources_count)

    @property
    @pulumi.getter(name="apisCount")
    def apis_count(self) -> Optional[str]:
        return pulumi.get(self, "apis_count")

    @property
    @pulumi.getter(name="lastCacheSyncTime")
    def last_cache_sync_time(self) -> Optional[str]:
        return pulumi.get(self, "last_cache_sync_time")

    @property
    @pulumi.getter(name="resourcesCount")
    def resources_count(self) -> Optional[str]:
        return pulumi.get(self, "resources_count")


@pulumi.output_type
class GitOpsClusterRequestClusterInfoConnectionState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attemptedAts":
            suggest = "attempted_ats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsClusterRequestClusterInfoConnectionState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsClusterRequestClusterInfoConnectionState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsClusterRequestClusterInfoConnectionState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempted_ats: Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoConnectionStateAttemptedAt']] = None,
                 message: Optional[str] = None,
                 status: Optional[str] = None):
        if attempted_ats is not None:
            pulumi.set(__self__, "attempted_ats", attempted_ats)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="attemptedAts")
    def attempted_ats(self) -> Optional[Sequence['outputs.GitOpsClusterRequestClusterInfoConnectionStateAttemptedAt']]:
        return pulumi.get(self, "attempted_ats")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class GitOpsClusterRequestClusterInfoConnectionStateAttemptedAt(dict):
    def __init__(__self__, *,
                 nanos: Optional[int] = None,
                 seconds: Optional[str] = None):
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[str]:
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GitOpsClusterRequestClusterRefreshRequestedAt(dict):
    def __init__(__self__, *,
                 nanos: Optional[int] = None,
                 seconds: Optional[str] = None):
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[str]:
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GitOpsClusterRequestId(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GitOpsClusterRequestUpdateMask(dict):
    def __init__(__self__, *,
                 paths: Optional[Sequence[str]] = None):
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "paths")


@pulumi.output_type
class GitOpsRepositoryRepo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "enableLfs":
            suggest = "enable_lfs"
        elif key == "enableOci":
            suggest = "enable_oci"
        elif key == "githubAppEnterpriseBaseUrl":
            suggest = "github_app_enterprise_base_url"
        elif key == "githubAppId":
            suggest = "github_app_id"
        elif key == "githubAppInstallationId":
            suggest = "github_app_installation_id"
        elif key == "githubAppPrivateKey":
            suggest = "github_app_private_key"
        elif key == "inheritedCreds":
            suggest = "inherited_creds"
        elif key == "insecureIgnoreHostKey":
            suggest = "insecure_ignore_host_key"
        elif key == "sshPrivateKey":
            suggest = "ssh_private_key"
        elif key == "tlsClientCertData":
            suggest = "tls_client_cert_data"
        elif key == "tlsClientCertKey":
            suggest = "tls_client_cert_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitOpsRepositoryRepo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitOpsRepositoryRepo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitOpsRepositoryRepo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: str,
                 repo: str,
                 enable_lfs: Optional[bool] = None,
                 enable_oci: Optional[bool] = None,
                 github_app_enterprise_base_url: Optional[str] = None,
                 github_app_id: Optional[str] = None,
                 github_app_installation_id: Optional[str] = None,
                 github_app_private_key: Optional[str] = None,
                 inherited_creds: Optional[bool] = None,
                 insecure: Optional[bool] = None,
                 insecure_ignore_host_key: Optional[bool] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 project: Optional[str] = None,
                 proxy: Optional[str] = None,
                 ssh_private_key: Optional[str] = None,
                 tls_client_cert_data: Optional[str] = None,
                 tls_client_cert_key: Optional[str] = None,
                 type_: Optional[str] = None,
                 username: Optional[str] = None):
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "repo", repo)
        if enable_lfs is not None:
            pulumi.set(__self__, "enable_lfs", enable_lfs)
        if enable_oci is not None:
            pulumi.set(__self__, "enable_oci", enable_oci)
        if github_app_enterprise_base_url is not None:
            pulumi.set(__self__, "github_app_enterprise_base_url", github_app_enterprise_base_url)
        if github_app_id is not None:
            pulumi.set(__self__, "github_app_id", github_app_id)
        if github_app_installation_id is not None:
            pulumi.set(__self__, "github_app_installation_id", github_app_installation_id)
        if github_app_private_key is not None:
            pulumi.set(__self__, "github_app_private_key", github_app_private_key)
        if inherited_creds is not None:
            pulumi.set(__self__, "inherited_creds", inherited_creds)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if insecure_ignore_host_key is not None:
            pulumi.set(__self__, "insecure_ignore_host_key", insecure_ignore_host_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if tls_client_cert_data is not None:
            pulumi.set(__self__, "tls_client_cert_data", tls_client_cert_data)
        if tls_client_cert_key is not None:
            pulumi.set(__self__, "tls_client_cert_key", tls_client_cert_key)
        if type_ is not None:
            pulumi.set(__self__, "type_", type_)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter
    def repo(self) -> str:
        return pulumi.get(self, "repo")

    @property
    @pulumi.getter(name="enableLfs")
    def enable_lfs(self) -> Optional[bool]:
        return pulumi.get(self, "enable_lfs")

    @property
    @pulumi.getter(name="enableOci")
    def enable_oci(self) -> Optional[bool]:
        return pulumi.get(self, "enable_oci")

    @property
    @pulumi.getter(name="githubAppEnterpriseBaseUrl")
    def github_app_enterprise_base_url(self) -> Optional[str]:
        return pulumi.get(self, "github_app_enterprise_base_url")

    @property
    @pulumi.getter(name="githubAppId")
    def github_app_id(self) -> Optional[str]:
        return pulumi.get(self, "github_app_id")

    @property
    @pulumi.getter(name="githubAppInstallationId")
    def github_app_installation_id(self) -> Optional[str]:
        return pulumi.get(self, "github_app_installation_id")

    @property
    @pulumi.getter(name="githubAppPrivateKey")
    def github_app_private_key(self) -> Optional[str]:
        return pulumi.get(self, "github_app_private_key")

    @property
    @pulumi.getter(name="inheritedCreds")
    def inherited_creds(self) -> Optional[bool]:
        return pulumi.get(self, "inherited_creds")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="insecureIgnoreHostKey")
    def insecure_ignore_host_key(self) -> Optional[bool]:
        return pulumi.get(self, "insecure_ignore_host_key")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def proxy(self) -> Optional[str]:
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[str]:
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter(name="tlsClientCertData")
    def tls_client_cert_data(self) -> Optional[str]:
        return pulumi.get(self, "tls_client_cert_data")

    @property
    @pulumi.getter(name="tlsClientCertKey")
    def tls_client_cert_key(self) -> Optional[str]:
        return pulumi.get(self, "tls_client_cert_key")

    @property
    @pulumi.getter
    def type_(self) -> Optional[str]:
        return pulumi.get(self, "type_")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")


@pulumi.output_type
class GitOpsRepositoryUpdateMask(dict):
    def __init__(__self__, *,
                 paths: Optional[Sequence[str]] = None):
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "paths")


@pulumi.output_type
class GithubConnectorApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubApp":
            suggest = "github_app"
        elif key == "tokenRef":
            suggest = "token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubConnectorApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubConnectorApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubConnectorApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_app: Optional['outputs.GithubConnectorApiAuthenticationGithubApp'] = None,
                 token_ref: Optional[str] = None):
        """
        :param 'GithubConnectorApiAuthenticationGithubAppArgs' github_app: Configuration for using the github app for interacting with the github api.
        :param str token_ref: Personal access token for interacting with the github api.
        """
        if github_app is not None:
            pulumi.set(__self__, "github_app", github_app)
        if token_ref is not None:
            pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="githubApp")
    def github_app(self) -> Optional['outputs.GithubConnectorApiAuthenticationGithubApp']:
        """
        Configuration for using the github app for interacting with the github api.
        """
        return pulumi.get(self, "github_app")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> Optional[str]:
        """
        Personal access token for interacting with the github api.
        """
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GithubConnectorApiAuthenticationGithubApp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "installationId":
            suggest = "installation_id"
        elif key == "privateKeyRef":
            suggest = "private_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubConnectorApiAuthenticationGithubApp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubConnectorApiAuthenticationGithubApp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubConnectorApiAuthenticationGithubApp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: str,
                 installation_id: str,
                 private_key_ref: str):
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "private_key_ref", private_key_ref)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter(name="privateKeyRef")
    def private_key_ref(self) -> str:
        return pulumi.get(self, "private_key_ref")


@pulumi.output_type
class GithubConnectorCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GithubConnectorCredentialsHttp'] = None,
                 ssh: Optional['outputs.GithubConnectorCredentialsSsh'] = None):
        """
        :param 'GithubConnectorCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GithubConnectorCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GithubConnectorCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GithubConnectorCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GithubConnectorCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubConnectorCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubConnectorCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubConnectorCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GithubConnectorCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubConnectorCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubConnectorCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubConnectorCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GitlabConnectorApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabConnectorApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabConnectorApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabConnectorApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str):
        """
        :param str token_ref: Personal access token for interacting with the gitlab api.
        """
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        """
        Personal access token for interacting with the gitlab api.
        """
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GitlabConnectorCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GitlabConnectorCredentialsHttp'] = None,
                 ssh: Optional['outputs.GitlabConnectorCredentialsSsh'] = None):
        """
        :param 'GitlabConnectorCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GitlabConnectorCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GitlabConnectorCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GitlabConnectorCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GitlabConnectorCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabConnectorCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabConnectorCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabConnectorCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: Optional[str] = None,
                 token_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        if password_ref is not None:
            pulumi.set(__self__, "password_ref", password_ref)
        if token_ref is not None:
            pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> Optional[str]:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> Optional[str]:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GitlabConnectorCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabConnectorCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabConnectorCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabConnectorCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class HelmConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HelmConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HelmConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HelmConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class KubernetesConnectorClientKeyCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertRef":
            suggest = "client_cert_ref"
        elif key == "clientKeyAlgorithm":
            suggest = "client_key_algorithm"
        elif key == "clientKeyRef":
            suggest = "client_key_ref"
        elif key == "masterUrl":
            suggest = "master_url"
        elif key == "caCertRef":
            suggest = "ca_cert_ref"
        elif key == "clientKeyPassphraseRef":
            suggest = "client_key_passphrase_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnectorClientKeyCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnectorClientKeyCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnectorClientKeyCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert_ref: str,
                 client_key_algorithm: str,
                 client_key_ref: str,
                 master_url: str,
                 ca_cert_ref: Optional[str] = None,
                 client_key_passphrase_ref: Optional[str] = None):
        """
        :param str client_cert_ref: Reference to the secret containing the client certificate for the connector.
        :param str client_key_algorithm: The algorithm used to generate the client key for the connector. Valid values are RSA, EC
        :param str client_key_ref: Reference to the secret containing the client key for the connector.
        :param str master_url: The URL of the Kubernetes cluster.
        :param str ca_cert_ref: Reference to the secret containing the CA certificate for the connector.
        :param str client_key_passphrase_ref: Reference to the secret containing the client key passphrase for the connector.
        """
        pulumi.set(__self__, "client_cert_ref", client_cert_ref)
        pulumi.set(__self__, "client_key_algorithm", client_key_algorithm)
        pulumi.set(__self__, "client_key_ref", client_key_ref)
        pulumi.set(__self__, "master_url", master_url)
        if ca_cert_ref is not None:
            pulumi.set(__self__, "ca_cert_ref", ca_cert_ref)
        if client_key_passphrase_ref is not None:
            pulumi.set(__self__, "client_key_passphrase_ref", client_key_passphrase_ref)

    @property
    @pulumi.getter(name="clientCertRef")
    def client_cert_ref(self) -> str:
        """
        Reference to the secret containing the client certificate for the connector.
        """
        return pulumi.get(self, "client_cert_ref")

    @property
    @pulumi.getter(name="clientKeyAlgorithm")
    def client_key_algorithm(self) -> str:
        """
        The algorithm used to generate the client key for the connector. Valid values are RSA, EC
        """
        return pulumi.get(self, "client_key_algorithm")

    @property
    @pulumi.getter(name="clientKeyRef")
    def client_key_ref(self) -> str:
        """
        Reference to the secret containing the client key for the connector.
        """
        return pulumi.get(self, "client_key_ref")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="caCertRef")
    def ca_cert_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the CA certificate for the connector.
        """
        return pulumi.get(self, "ca_cert_ref")

    @property
    @pulumi.getter(name="clientKeyPassphraseRef")
    def client_key_passphrase_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the client key passphrase for the connector.
        """
        return pulumi.get(self, "client_key_passphrase_ref")


@pulumi.output_type
class KubernetesConnectorInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnectorInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnectorInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnectorInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: Selectors to use for the delegate.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class KubernetesConnectorOpenidConnect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIdRef":
            suggest = "client_id_ref"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "masterUrl":
            suggest = "master_url"
        elif key == "passwordRef":
            suggest = "password_ref"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnectorOpenidConnect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnectorOpenidConnect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnectorOpenidConnect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id_ref: str,
                 issuer_url: str,
                 master_url: str,
                 password_ref: str,
                 scopes: Optional[Sequence[str]] = None,
                 secret_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str client_id_ref: Reference to the secret containing the client ID for the connector.
        :param str issuer_url: The URL of the OpenID Connect issuer.
        :param str master_url: The URL of the Kubernetes cluster.
        :param str password_ref: Reference to the secret containing the password for the connector.
        :param Sequence[str] scopes: Scopes to request for the connector.
        :param str secret_ref: Reference to the secret containing the client secret for the connector.
        :param str username: Username for the connector.
        :param str username_ref: Reference to the secret containing the username for the connector.
        """
        pulumi.set(__self__, "client_id_ref", client_id_ref)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="clientIdRef")
    def client_id_ref(self) -> str:
        """
        Reference to the secret containing the client ID for the connector.
        """
        return pulumi.get(self, "client_id_ref")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        """
        The URL of the OpenID Connect issuer.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to the secret containing the password for the connector.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes to request for the connector.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the client secret for the connector.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for the connector.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the username for the connector.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class KubernetesConnectorServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUrl":
            suggest = "master_url"
        elif key == "serviceAccountTokenRef":
            suggest = "service_account_token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnectorServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnectorServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnectorServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_url: str,
                 service_account_token_ref: str):
        """
        :param str master_url: The URL of the Kubernetes cluster.
        :param str service_account_token_ref: Reference to the secret containing the service account token for the connector.
        """
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "service_account_token_ref", service_account_token_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="serviceAccountTokenRef")
    def service_account_token_ref(self) -> str:
        """
        Reference to the secret containing the service account token for the connector.
        """
        return pulumi.get(self, "service_account_token_ref")


@pulumi.output_type
class KubernetesConnectorUsernamePassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUrl":
            suggest = "master_url"
        elif key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnectorUsernamePassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnectorUsernamePassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnectorUsernamePassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_url: str,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str master_url: The URL of the Kubernetes cluster.
        :param str password_ref: Reference to the secret containing the password for the connector.
        :param str username: Username for the connector.
        :param str username_ref: Reference to the secret containing the username for the connector.
        """
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to the secret containing the password for the connector.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for the connector.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the username for the connector.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class NexusConnectorCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NexusConnectorCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NexusConnectorCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NexusConnectorCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class PrometheusConnectorHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptedValueRef":
            suggest = "encrypted_value_ref"
        elif key == "valueEncrypted":
            suggest = "value_encrypted"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusConnectorHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusConnectorHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusConnectorHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 encrypted_value_ref: Optional[str] = None,
                 value: Optional[str] = None,
                 value_encrypted: Optional[bool] = None):
        """
        :param str key: Key.
        :param str encrypted_value_ref: Encrypted value reference.
        :param str value: Value.
        :param bool value_encrypted: Encrypted value.
        """
        pulumi.set(__self__, "key", key)
        if encrypted_value_ref is not None:
            pulumi.set(__self__, "encrypted_value_ref", encrypted_value_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_encrypted is not None:
            pulumi.set(__self__, "value_encrypted", value_encrypted)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="encryptedValueRef")
    def encrypted_value_ref(self) -> Optional[str]:
        """
        Encrypted value reference.
        """
        return pulumi.get(self, "encrypted_value_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueEncrypted")
    def value_encrypted(self) -> Optional[bool]:
        """
        Encrypted value.
        """
        return pulumi.get(self, "value_encrypted")


@pulumi.output_type
class ResourceGroupIncludedScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "orgId":
            suggest = "org_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupIncludedScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupIncludedScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupIncludedScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 account_id: Optional[str] = None,
                 org_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str filter: Can be one of these 2 EXCLUDING*CHILD*SCOPES or INCLUDING*CHILD*SCOPES
        :param str account_id: Account Identifier of the account
        :param str org_id: Organization Identifier
        :param str project_id: Project Identifier
        """
        pulumi.set(__self__, "filter", filter)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Can be one of these 2 EXCLUDING*CHILD*SCOPES or INCLUDING*CHILD*SCOPES
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        Account Identifier of the account
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Organization Identifier
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class ResourceGroupResourceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeAllResources":
            suggest = "include_all_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupResourceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupResourceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupResourceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_all_resources: Optional[bool] = None,
                 resources: Optional[Sequence['outputs.ResourceGroupResourceFilterResource']] = None):
        """
        :param bool include_all_resources: Include all resource or not
        :param Sequence['ResourceGroupResourceFilterResourceArgs'] resources: Resources for a resource group
        """
        if include_all_resources is not None:
            pulumi.set(__self__, "include_all_resources", include_all_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="includeAllResources")
    def include_all_resources(self) -> Optional[bool]:
        """
        Include all resource or not
        """
        return pulumi.get(self, "include_all_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.ResourceGroupResourceFilterResource']]:
        """
        Resources for a resource group
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ResourceGroupResourceFilterResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "attributeFilters":
            suggest = "attribute_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupResourceFilterResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupResourceFilterResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupResourceFilterResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 attribute_filters: Optional[Sequence['outputs.ResourceGroupResourceFilterResourceAttributeFilter']] = None,
                 identifiers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "resource_type", resource_type)
        if attribute_filters is not None:
            pulumi.set(__self__, "attribute_filters", attribute_filters)
        if identifiers is not None:
            pulumi.set(__self__, "identifiers", identifiers)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="attributeFilters")
    def attribute_filters(self) -> Optional[Sequence['outputs.ResourceGroupResourceFilterResourceAttributeFilter']]:
        return pulumi.get(self, "attribute_filters")

    @property
    @pulumi.getter
    def identifiers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "identifiers")


@pulumi.output_type
class ResourceGroupResourceFilterResourceAttributeFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeValues":
            suggest = "attribute_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupResourceFilterResourceAttributeFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupResourceFilterResourceAttributeFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupResourceFilterResourceAttributeFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: Optional[str] = None,
                 attribute_values: Optional[Sequence[str]] = None):
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if attribute_values is not None:
            pulumi.set(__self__, "attribute_values", attribute_values)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[str]:
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValues")
    def attribute_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "attribute_values")


@pulumi.output_type
class RoleAssignmentsPrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scopeLevel":
            suggest = "scope_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleAssignmentsPrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleAssignmentsPrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleAssignmentsPrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identifier: Optional[str] = None,
                 scope_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str identifier: Identifier.
        :param str scope_level: Scope level.
        :param str type: Type.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if scope_level is not None:
            pulumi.set(__self__, "scope_level", scope_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        Identifier.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="scopeLevel")
    def scope_level(self) -> Optional[str]:
        """
        Scope level.
        """
        return pulumi.get(self, "scope_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SecretSshkeyKerberos(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tgtGenerationMethod":
            suggest = "tgt_generation_method"
        elif key == "tgtKeyTabFilePathSpec":
            suggest = "tgt_key_tab_file_path_spec"
        elif key == "tgtPasswordSpec":
            suggest = "tgt_password_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeyKerberos. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeyKerberos.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeyKerberos.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal: str,
                 realm: str,
                 tgt_generation_method: Optional[str] = None,
                 tgt_key_tab_file_path_spec: Optional['outputs.SecretSshkeyKerberosTgtKeyTabFilePathSpec'] = None,
                 tgt_password_spec: Optional['outputs.SecretSshkeyKerberosTgtPasswordSpec'] = None):
        """
        :param str principal: Username to use for authentication.
        :param str realm: Reference to a secret containing the password to use for authentication.
        :param str tgt_generation_method: Method to generate tgt
        :param 'SecretSshkeyKerberosTgtKeyTabFilePathSpecArgs' tgt_key_tab_file_path_spec: Authenticate to App Dynamics using username and password.
        :param 'SecretSshkeyKerberosTgtPasswordSpecArgs' tgt_password_spec: Authenticate to App Dynamics using username and password.
        """
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "realm", realm)
        if tgt_generation_method is not None:
            pulumi.set(__self__, "tgt_generation_method", tgt_generation_method)
        if tgt_key_tab_file_path_spec is not None:
            pulumi.set(__self__, "tgt_key_tab_file_path_spec", tgt_key_tab_file_path_spec)
        if tgt_password_spec is not None:
            pulumi.set(__self__, "tgt_password_spec", tgt_password_spec)

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="tgtGenerationMethod")
    def tgt_generation_method(self) -> Optional[str]:
        """
        Method to generate tgt
        """
        return pulumi.get(self, "tgt_generation_method")

    @property
    @pulumi.getter(name="tgtKeyTabFilePathSpec")
    def tgt_key_tab_file_path_spec(self) -> Optional['outputs.SecretSshkeyKerberosTgtKeyTabFilePathSpec']:
        """
        Authenticate to App Dynamics using username and password.
        """
        return pulumi.get(self, "tgt_key_tab_file_path_spec")

    @property
    @pulumi.getter(name="tgtPasswordSpec")
    def tgt_password_spec(self) -> Optional['outputs.SecretSshkeyKerberosTgtPasswordSpec']:
        """
        Authenticate to App Dynamics using username and password.
        """
        return pulumi.get(self, "tgt_password_spec")


@pulumi.output_type
class SecretSshkeyKerberosTgtKeyTabFilePathSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPath":
            suggest = "key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeyKerberosTgtKeyTabFilePathSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeyKerberosTgtKeyTabFilePathSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeyKerberosTgtKeyTabFilePathSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_path: Optional[str] = None):
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[str]:
        return pulumi.get(self, "key_path")


@pulumi.output_type
class SecretSshkeyKerberosTgtPasswordSpec(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None):
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")


@pulumi.output_type
class SecretSshkeySsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "sshPasswordCredential":
            suggest = "ssh_password_credential"
        elif key == "sshkeyPathCredential":
            suggest = "sshkey_path_credential"
        elif key == "sshkeyReferenceCredential":
            suggest = "sshkey_reference_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeySsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeySsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeySsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: str,
                 ssh_password_credential: Optional['outputs.SecretSshkeySshSshPasswordCredential'] = None,
                 sshkey_path_credential: Optional['outputs.SecretSshkeySshSshkeyPathCredential'] = None,
                 sshkey_reference_credential: Optional['outputs.SecretSshkeySshSshkeyReferenceCredential'] = None):
        """
        :param str credential_type: This specifies SSH credential type as Password, KeyPath or KeyReference
        :param 'SecretSshkeySshSshPasswordCredentialArgs' ssh_password_credential: SSH credential of type keyReference
        :param 'SecretSshkeySshSshkeyPathCredentialArgs' sshkey_path_credential: SSH credential of type keyPath
        :param 'SecretSshkeySshSshkeyReferenceCredentialArgs' sshkey_reference_credential: SSH credential of type keyReference
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if ssh_password_credential is not None:
            pulumi.set(__self__, "ssh_password_credential", ssh_password_credential)
        if sshkey_path_credential is not None:
            pulumi.set(__self__, "sshkey_path_credential", sshkey_path_credential)
        if sshkey_reference_credential is not None:
            pulumi.set(__self__, "sshkey_reference_credential", sshkey_reference_credential)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        This specifies SSH credential type as Password, KeyPath or KeyReference
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="sshPasswordCredential")
    def ssh_password_credential(self) -> Optional['outputs.SecretSshkeySshSshPasswordCredential']:
        """
        SSH credential of type keyReference
        """
        return pulumi.get(self, "ssh_password_credential")

    @property
    @pulumi.getter(name="sshkeyPathCredential")
    def sshkey_path_credential(self) -> Optional['outputs.SecretSshkeySshSshkeyPathCredential']:
        """
        SSH credential of type keyPath
        """
        return pulumi.get(self, "sshkey_path_credential")

    @property
    @pulumi.getter(name="sshkeyReferenceCredential")
    def sshkey_reference_credential(self) -> Optional['outputs.SecretSshkeySshSshkeyReferenceCredential']:
        """
        SSH credential of type keyReference
        """
        return pulumi.get(self, "sshkey_reference_credential")


@pulumi.output_type
class SecretSshkeySshSshPasswordCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeySshSshPasswordCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeySshSshPasswordCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeySshSshPasswordCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 user_name: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SecretSshkeySshSshkeyPathCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPath":
            suggest = "key_path"
        elif key == "userName":
            suggest = "user_name"
        elif key == "encryptedPassphrase":
            suggest = "encrypted_passphrase"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeySshSshkeyPathCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeySshSshkeyPathCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeySshSshkeyPathCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_path: str,
                 user_name: str,
                 encrypted_passphrase: Optional[str] = None):
        pulumi.set(__self__, "key_path", key_path)
        pulumi.set(__self__, "user_name", user_name)
        if encrypted_passphrase is not None:
            pulumi.set(__self__, "encrypted_passphrase", encrypted_passphrase)

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> str:
        return pulumi.get(self, "key_path")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="encryptedPassphrase")
    def encrypted_passphrase(self) -> Optional[str]:
        return pulumi.get(self, "encrypted_passphrase")


@pulumi.output_type
class SecretSshkeySshSshkeyReferenceCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"
        elif key == "encryptedPassphrase":
            suggest = "encrypted_passphrase"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSshkeySshSshkeyReferenceCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSshkeySshSshkeyReferenceCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSshkeySshSshkeyReferenceCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_name: str,
                 encrypted_passphrase: Optional[str] = None,
                 key: Optional[str] = None):
        pulumi.set(__self__, "user_name", user_name)
        if encrypted_passphrase is not None:
            pulumi.set(__self__, "encrypted_passphrase", encrypted_passphrase)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="encryptedPassphrase")
    def encrypted_passphrase(self) -> Optional[str]:
        return pulumi.get(self, "encrypted_passphrase")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")


@pulumi.output_type
class UsergroupNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupEmail":
            suggest = "group_email"
        elif key == "microsoftTeamsWebhookUrl":
            suggest = "microsoft_teams_webhook_url"
        elif key == "pagerDutyKey":
            suggest = "pager_duty_key"
        elif key == "slackWebhookUrl":
            suggest = "slack_webhook_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsergroupNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsergroupNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsergroupNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_email: Optional[str] = None,
                 microsoft_teams_webhook_url: Optional[str] = None,
                 pager_duty_key: Optional[str] = None,
                 slack_webhook_url: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str group_email: Group email
        :param str microsoft_teams_webhook_url: Url of Microsoft teams webhook
        :param str pager_duty_key: Pager duty key
        :param str slack_webhook_url: Url of slack webhook
        :param str type: Can be one of EMAIL, SLACK, PAGERDUTY, MSTEAMS
        """
        if group_email is not None:
            pulumi.set(__self__, "group_email", group_email)
        if microsoft_teams_webhook_url is not None:
            pulumi.set(__self__, "microsoft_teams_webhook_url", microsoft_teams_webhook_url)
        if pager_duty_key is not None:
            pulumi.set(__self__, "pager_duty_key", pager_duty_key)
        if slack_webhook_url is not None:
            pulumi.set(__self__, "slack_webhook_url", slack_webhook_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupEmail")
    def group_email(self) -> Optional[str]:
        """
        Group email
        """
        return pulumi.get(self, "group_email")

    @property
    @pulumi.getter(name="microsoftTeamsWebhookUrl")
    def microsoft_teams_webhook_url(self) -> Optional[str]:
        """
        Url of Microsoft teams webhook
        """
        return pulumi.get(self, "microsoft_teams_webhook_url")

    @property
    @pulumi.getter(name="pagerDutyKey")
    def pager_duty_key(self) -> Optional[str]:
        """
        Pager duty key
        """
        return pulumi.get(self, "pager_duty_key")

    @property
    @pulumi.getter(name="slackWebhookUrl")
    def slack_webhook_url(self) -> Optional[str]:
        """
        Url of slack webhook
        """
        return pulumi.get(self, "slack_webhook_url")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Can be one of EMAIL, SLACK, PAGERDUTY, MSTEAMS
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VariablesSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedValue":
            suggest = "fixed_value"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VariablesSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VariablesSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VariablesSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_value: str,
                 value_type: str):
        """
        :param str fixed_value: FixedValue of the variable
        :param str value_type: Type of Value of the Variable. For now only FIXED is supported
        """
        pulumi.set(__self__, "fixed_value", fixed_value)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="fixedValue")
    def fixed_value(self) -> str:
        """
        FixedValue of the variable
        """
        return pulumi.get(self, "fixed_value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Type of Value of the Variable. For now only FIXED is supported
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetAppDynamicsConnectorApiTokenResult(dict):
    def __init__(__self__, *,
                 client_id: str,
                 client_secret_ref: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret_ref", client_secret_ref)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretRef")
    def client_secret_ref(self) -> str:
        return pulumi.get(self, "client_secret_ref")


@pulumi.output_type
class GetAppDynamicsConnectorUsernamePasswordResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetArtifactoryConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetAwsCCConnectorCrossAccountAccessResult(dict):
    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsConnectorCrossAccountAccessResult(dict):
    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsConnectorInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetAwsConnectorIrsaResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetAwsConnectorManualResult(dict):
    def __init__(__self__, *,
                 access_key: str,
                 access_key_ref: str,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetAwsKmsConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 assume_roles: Sequence['outputs.GetAwsKmsConnectorCredentialAssumeRoleResult'],
                 inherit_from_delegate: bool,
                 manuals: Sequence['outputs.GetAwsKmsConnectorCredentialManualResult']):
        pulumi.set(__self__, "assume_roles", assume_roles)
        pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        pulumi.set(__self__, "manuals", manuals)

    @property
    @pulumi.getter(name="assumeRoles")
    def assume_roles(self) -> Sequence['outputs.GetAwsKmsConnectorCredentialAssumeRoleResult']:
        return pulumi.get(self, "assume_roles")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> bool:
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manuals(self) -> Sequence['outputs.GetAwsKmsConnectorCredentialManualResult']:
        return pulumi.get(self, "manuals")


@pulumi.output_type
class GetAwsKmsConnectorCredentialAssumeRoleResult(dict):
    def __init__(__self__, *,
                 duration: int,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsKmsConnectorCredentialManualResult(dict):
    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetAwsSecretManagerConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 assume_roles: Sequence['outputs.GetAwsSecretManagerConnectorCredentialAssumeRoleResult'],
                 inherit_from_delegate: bool,
                 manuals: Sequence['outputs.GetAwsSecretManagerConnectorCredentialManualResult']):
        pulumi.set(__self__, "assume_roles", assume_roles)
        pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        pulumi.set(__self__, "manuals", manuals)

    @property
    @pulumi.getter(name="assumeRoles")
    def assume_roles(self) -> Sequence['outputs.GetAwsSecretManagerConnectorCredentialAssumeRoleResult']:
        return pulumi.get(self, "assume_roles")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> bool:
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manuals(self) -> Sequence['outputs.GetAwsSecretManagerConnectorCredentialManualResult']:
        return pulumi.get(self, "manuals")


@pulumi.output_type
class GetAwsSecretManagerConnectorCredentialAssumeRoleResult(dict):
    def __init__(__self__, *,
                 duration: int,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsSecretManagerConnectorCredentialManualResult(dict):
    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetBitbucketConnectorApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetBitbucketConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetBitbucketConnectorCredentialHttpResult'],
                 sshes: Sequence['outputs.GetBitbucketConnectorCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetBitbucketConnectorCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetBitbucketConnectorCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetBitbucketConnectorCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetBitbucketConnectorCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetDockerConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGcpConnectorInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetGcpConnectorManualResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetGitConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGitConnectorCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGitConnectorCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGitConnectorCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGitConnectorCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGitConnectorCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGitConnectorCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetGithubConnectorApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 github_apps: Sequence['outputs.GetGithubConnectorApiAuthenticationGithubAppResult'],
                 token_ref: str):
        pulumi.set(__self__, "github_apps", github_apps)
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="githubApps")
    def github_apps(self) -> Sequence['outputs.GetGithubConnectorApiAuthenticationGithubAppResult']:
        return pulumi.get(self, "github_apps")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GetGithubConnectorApiAuthenticationGithubAppResult(dict):
    def __init__(__self__, *,
                 application_id: str,
                 installation_id: str,
                 private_key_ref: str):
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "private_key_ref", private_key_ref)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter(name="privateKeyRef")
    def private_key_ref(self) -> str:
        return pulumi.get(self, "private_key_ref")


@pulumi.output_type
class GetGithubConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGithubConnectorCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGithubConnectorCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGithubConnectorCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGithubConnectorCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGithubConnectorCredentialHttpResult(dict):
    def __init__(__self__, *,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGithubConnectorCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetGitlabConnectorApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 token_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GetGitlabConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGitlabConnectorCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGitlabConnectorCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGitlabConnectorCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGitlabConnectorCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGitlabConnectorCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGitlabConnectorCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetGitopsAgentMetadataResult(dict):
    def __init__(__self__, *,
                 namespace: str,
                 high_availability: Optional[bool] = None):
        pulumi.set(__self__, "namespace", namespace)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[bool]:
        return pulumi.get(self, "high_availability")


@pulumi.output_type
class GetGitopsClusterQueryResult(dict):
    def __init__(__self__, *,
                 ids: Optional[Sequence['outputs.GetGitopsClusterQueryIdResult']] = None,
                 name: Optional[str] = None,
                 server: Optional[str] = None):
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GetGitopsClusterQueryIdResult']]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        return pulumi.get(self, "server")


@pulumi.output_type
class GetGitopsClusterQueryIdResult(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGitopsClusterRequestResult(dict):
    def __init__(__self__, *,
                 clusters: Optional[Sequence['outputs.GetGitopsClusterRequestClusterResult']] = None,
                 ids: Optional[Sequence['outputs.GetGitopsClusterRequestIdResult']] = None,
                 update_masks: Optional[Sequence['outputs.GetGitopsClusterRequestUpdateMaskResult']] = None,
                 updated_fields: Optional[Sequence[str]] = None,
                 upsert: Optional[bool] = None):
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if updated_fields is not None:
            pulumi.set(__self__, "updated_fields", updated_fields)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterResult']]:
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestIdResult']]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestUpdateMaskResult']]:
        return pulumi.get(self, "update_masks")

    @property
    @pulumi.getter(name="updatedFields")
    def updated_fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "updated_fields")

    @property
    @pulumi.getter
    def upsert(self) -> Optional[bool]:
        return pulumi.get(self, "upsert")


@pulumi.output_type
class GetGitopsClusterRequestClusterResult(dict):
    def __init__(__self__, *,
                 server: str,
                 annotations: Optional[Mapping[str, str]] = None,
                 cluster_resources: Optional[bool] = None,
                 configs: Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigResult']] = None,
                 infos: Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoResult']] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 namespaces: Optional[Sequence[str]] = None,
                 project: Optional[str] = None,
                 refresh_requested_ats: Optional[Sequence['outputs.GetGitopsClusterRequestClusterRefreshRequestedAtResult']] = None,
                 shard: Optional[str] = None):
        pulumi.set(__self__, "server", server)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_resources is not None:
            pulumi.set(__self__, "cluster_resources", cluster_resources)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if refresh_requested_ats is not None:
            pulumi.set(__self__, "refresh_requested_ats", refresh_requested_ats)
        if shard is not None:
            pulumi.set(__self__, "shard", shard)

    @property
    @pulumi.getter
    def server(self) -> str:
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterResources")
    def cluster_resources(self) -> Optional[bool]:
        return pulumi.get(self, "cluster_resources")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigResult']]:
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def infos(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoResult']]:
        return pulumi.get(self, "infos")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="refreshRequestedAts")
    def refresh_requested_ats(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterRefreshRequestedAtResult']]:
        return pulumi.get(self, "refresh_requested_ats")

    @property
    @pulumi.getter
    def shard(self) -> Optional[str]:
        return pulumi.get(self, "shard")


@pulumi.output_type
class GetGitopsClusterRequestClusterConfigResult(dict):
    def __init__(__self__, *,
                 aws_auth_configs: Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigAwsAuthConfigResult']] = None,
                 bearer_token: Optional[str] = None,
                 cluster_connection_type: Optional[str] = None,
                 exec_provider_configs: Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigExecProviderConfigResult']] = None,
                 password: Optional[str] = None,
                 tls_client_configs: Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigTlsClientConfigResult']] = None,
                 username: Optional[str] = None):
        if aws_auth_configs is not None:
            pulumi.set(__self__, "aws_auth_configs", aws_auth_configs)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)
        if cluster_connection_type is not None:
            pulumi.set(__self__, "cluster_connection_type", cluster_connection_type)
        if exec_provider_configs is not None:
            pulumi.set(__self__, "exec_provider_configs", exec_provider_configs)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if tls_client_configs is not None:
            pulumi.set(__self__, "tls_client_configs", tls_client_configs)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="awsAuthConfigs")
    def aws_auth_configs(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigAwsAuthConfigResult']]:
        return pulumi.get(self, "aws_auth_configs")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[str]:
        return pulumi.get(self, "bearer_token")

    @property
    @pulumi.getter(name="clusterConnectionType")
    def cluster_connection_type(self) -> Optional[str]:
        return pulumi.get(self, "cluster_connection_type")

    @property
    @pulumi.getter(name="execProviderConfigs")
    def exec_provider_configs(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigExecProviderConfigResult']]:
        return pulumi.get(self, "exec_provider_configs")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="tlsClientConfigs")
    def tls_client_configs(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterConfigTlsClientConfigResult']]:
        return pulumi.get(self, "tls_client_configs")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetGitopsClusterRequestClusterConfigAwsAuthConfigResult(dict):
    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 role_arn: Optional[str] = None):
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetGitopsClusterRequestClusterConfigExecProviderConfigResult(dict):
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[str] = None,
                 env: Optional[Mapping[str, str]] = None,
                 install_hint: Optional[str] = None):
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if install_hint is not None:
            pulumi.set(__self__, "install_hint", install_hint)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="installHint")
    def install_hint(self) -> Optional[str]:
        return pulumi.get(self, "install_hint")


@pulumi.output_type
class GetGitopsClusterRequestClusterConfigTlsClientConfigResult(dict):
    def __init__(__self__, *,
                 ca_data: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 server_name: Optional[str] = None):
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        return pulumi.get(self, "server_name")


@pulumi.output_type
class GetGitopsClusterRequestClusterInfoResult(dict):
    def __init__(__self__, *,
                 api_versions: Optional[Sequence[str]] = None,
                 applications_count: Optional[str] = None,
                 cache_infos: Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoCacheInfoResult']] = None,
                 connection_states: Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoConnectionStateResult']] = None,
                 server_version: Optional[str] = None):
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if applications_count is not None:
            pulumi.set(__self__, "applications_count", applications_count)
        if cache_infos is not None:
            pulumi.set(__self__, "cache_infos", cache_infos)
        if connection_states is not None:
            pulumi.set(__self__, "connection_states", connection_states)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter(name="applicationsCount")
    def applications_count(self) -> Optional[str]:
        return pulumi.get(self, "applications_count")

    @property
    @pulumi.getter(name="cacheInfos")
    def cache_infos(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoCacheInfoResult']]:
        return pulumi.get(self, "cache_infos")

    @property
    @pulumi.getter(name="connectionStates")
    def connection_states(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoConnectionStateResult']]:
        return pulumi.get(self, "connection_states")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[str]:
        return pulumi.get(self, "server_version")


@pulumi.output_type
class GetGitopsClusterRequestClusterInfoCacheInfoResult(dict):
    def __init__(__self__, *,
                 apis_count: Optional[str] = None,
                 last_cache_sync_time: Optional[str] = None,
                 resources_count: Optional[str] = None):
        if apis_count is not None:
            pulumi.set(__self__, "apis_count", apis_count)
        if last_cache_sync_time is not None:
            pulumi.set(__self__, "last_cache_sync_time", last_cache_sync_time)
        if resources_count is not None:
            pulumi.set(__self__, "resources_count", resources_count)

    @property
    @pulumi.getter(name="apisCount")
    def apis_count(self) -> Optional[str]:
        return pulumi.get(self, "apis_count")

    @property
    @pulumi.getter(name="lastCacheSyncTime")
    def last_cache_sync_time(self) -> Optional[str]:
        return pulumi.get(self, "last_cache_sync_time")

    @property
    @pulumi.getter(name="resourcesCount")
    def resources_count(self) -> Optional[str]:
        return pulumi.get(self, "resources_count")


@pulumi.output_type
class GetGitopsClusterRequestClusterInfoConnectionStateResult(dict):
    def __init__(__self__, *,
                 attempted_ats: Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoConnectionStateAttemptedAtResult']] = None,
                 message: Optional[str] = None,
                 status: Optional[str] = None):
        if attempted_ats is not None:
            pulumi.set(__self__, "attempted_ats", attempted_ats)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="attemptedAts")
    def attempted_ats(self) -> Optional[Sequence['outputs.GetGitopsClusterRequestClusterInfoConnectionStateAttemptedAtResult']]:
        return pulumi.get(self, "attempted_ats")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGitopsClusterRequestClusterInfoConnectionStateAttemptedAtResult(dict):
    def __init__(__self__, *,
                 nanos: Optional[int] = None,
                 seconds: Optional[str] = None):
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[str]:
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetGitopsClusterRequestClusterRefreshRequestedAtResult(dict):
    def __init__(__self__, *,
                 nanos: Optional[int] = None,
                 seconds: Optional[str] = None):
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[str]:
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetGitopsClusterRequestIdResult(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGitopsClusterRequestUpdateMaskResult(dict):
    def __init__(__self__, *,
                 paths: Optional[Sequence[Sequence[Any]]] = None):
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[Sequence[Any]]]:
        return pulumi.get(self, "paths")


@pulumi.output_type
class GetGitopsRepositoryRepoResult(dict):
    def __init__(__self__, *,
                 connection_type: str,
                 project: str,
                 repo: str,
                 type_: str,
                 enable_lfs: Optional[bool] = None,
                 enable_oci: Optional[bool] = None,
                 github_app_enterprise_base_url: Optional[str] = None,
                 github_app_id: Optional[str] = None,
                 github_app_installation_id: Optional[str] = None,
                 github_app_private_key: Optional[str] = None,
                 inherited_creds: Optional[bool] = None,
                 insecure: Optional[bool] = None,
                 insecure_ignore_host_key: Optional[bool] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 proxy: Optional[str] = None,
                 ssh_private_key: Optional[str] = None,
                 tls_client_cert_data: Optional[str] = None,
                 tls_client_cert_key: Optional[str] = None,
                 username: Optional[str] = None):
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo", repo)
        pulumi.set(__self__, "type_", type_)
        if enable_lfs is not None:
            pulumi.set(__self__, "enable_lfs", enable_lfs)
        if enable_oci is not None:
            pulumi.set(__self__, "enable_oci", enable_oci)
        if github_app_enterprise_base_url is not None:
            pulumi.set(__self__, "github_app_enterprise_base_url", github_app_enterprise_base_url)
        if github_app_id is not None:
            pulumi.set(__self__, "github_app_id", github_app_id)
        if github_app_installation_id is not None:
            pulumi.set(__self__, "github_app_installation_id", github_app_installation_id)
        if github_app_private_key is not None:
            pulumi.set(__self__, "github_app_private_key", github_app_private_key)
        if inherited_creds is not None:
            pulumi.set(__self__, "inherited_creds", inherited_creds)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if insecure_ignore_host_key is not None:
            pulumi.set(__self__, "insecure_ignore_host_key", insecure_ignore_host_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if tls_client_cert_data is not None:
            pulumi.set(__self__, "tls_client_cert_data", tls_client_cert_data)
        if tls_client_cert_key is not None:
            pulumi.set(__self__, "tls_client_cert_key", tls_client_cert_key)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def repo(self) -> str:
        return pulumi.get(self, "repo")

    @property
    @pulumi.getter
    def type_(self) -> str:
        return pulumi.get(self, "type_")

    @property
    @pulumi.getter(name="enableLfs")
    def enable_lfs(self) -> Optional[bool]:
        return pulumi.get(self, "enable_lfs")

    @property
    @pulumi.getter(name="enableOci")
    def enable_oci(self) -> Optional[bool]:
        return pulumi.get(self, "enable_oci")

    @property
    @pulumi.getter(name="githubAppEnterpriseBaseUrl")
    def github_app_enterprise_base_url(self) -> Optional[str]:
        return pulumi.get(self, "github_app_enterprise_base_url")

    @property
    @pulumi.getter(name="githubAppId")
    def github_app_id(self) -> Optional[str]:
        return pulumi.get(self, "github_app_id")

    @property
    @pulumi.getter(name="githubAppInstallationId")
    def github_app_installation_id(self) -> Optional[str]:
        return pulumi.get(self, "github_app_installation_id")

    @property
    @pulumi.getter(name="githubAppPrivateKey")
    def github_app_private_key(self) -> Optional[str]:
        return pulumi.get(self, "github_app_private_key")

    @property
    @pulumi.getter(name="inheritedCreds")
    def inherited_creds(self) -> Optional[bool]:
        return pulumi.get(self, "inherited_creds")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="insecureIgnoreHostKey")
    def insecure_ignore_host_key(self) -> Optional[bool]:
        return pulumi.get(self, "insecure_ignore_host_key")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def proxy(self) -> Optional[str]:
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[str]:
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter(name="tlsClientCertData")
    def tls_client_cert_data(self) -> Optional[str]:
        return pulumi.get(self, "tls_client_cert_data")

    @property
    @pulumi.getter(name="tlsClientCertKey")
    def tls_client_cert_key(self) -> Optional[str]:
        return pulumi.get(self, "tls_client_cert_key")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetGitopsRepositoryUpdateMaskResult(dict):
    def __init__(__self__, *,
                 paths: Optional[Sequence[str]] = None):
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "paths")


@pulumi.output_type
class GetHelmConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetKubernetesConnectorClientKeyCertResult(dict):
    def __init__(__self__, *,
                 ca_cert_ref: str,
                 client_cert_ref: str,
                 client_key_algorithm: str,
                 client_key_passphrase_ref: str,
                 client_key_ref: str,
                 master_url: str):
        pulumi.set(__self__, "ca_cert_ref", ca_cert_ref)
        pulumi.set(__self__, "client_cert_ref", client_cert_ref)
        pulumi.set(__self__, "client_key_algorithm", client_key_algorithm)
        pulumi.set(__self__, "client_key_passphrase_ref", client_key_passphrase_ref)
        pulumi.set(__self__, "client_key_ref", client_key_ref)
        pulumi.set(__self__, "master_url", master_url)

    @property
    @pulumi.getter(name="caCertRef")
    def ca_cert_ref(self) -> str:
        return pulumi.get(self, "ca_cert_ref")

    @property
    @pulumi.getter(name="clientCertRef")
    def client_cert_ref(self) -> str:
        return pulumi.get(self, "client_cert_ref")

    @property
    @pulumi.getter(name="clientKeyAlgorithm")
    def client_key_algorithm(self) -> str:
        return pulumi.get(self, "client_key_algorithm")

    @property
    @pulumi.getter(name="clientKeyPassphraseRef")
    def client_key_passphrase_ref(self) -> str:
        return pulumi.get(self, "client_key_passphrase_ref")

    @property
    @pulumi.getter(name="clientKeyRef")
    def client_key_ref(self) -> str:
        return pulumi.get(self, "client_key_ref")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")


@pulumi.output_type
class GetKubernetesConnectorInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: Selectors to use for the delegate.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetKubernetesConnectorOpenidConnectResult(dict):
    def __init__(__self__, *,
                 client_id_ref: str,
                 issuer_url: str,
                 master_url: str,
                 password_ref: str,
                 scopes: Sequence[str],
                 secret_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "client_id_ref", client_id_ref)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "secret_ref", secret_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="clientIdRef")
    def client_id_ref(self) -> str:
        return pulumi.get(self, "client_id_ref")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> str:
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetKubernetesConnectorServiceAccountResult(dict):
    def __init__(__self__, *,
                 master_url: str,
                 service_account_token_ref: str):
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "service_account_token_ref", service_account_token_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="serviceAccountTokenRef")
    def service_account_token_ref(self) -> str:
        return pulumi.get(self, "service_account_token_ref")


@pulumi.output_type
class GetKubernetesConnectorUsernamePasswordResult(dict):
    def __init__(__self__, *,
                 master_url: str,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetNexusConnectorCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetPermissionsPermissionResult(dict):
    def __init__(__self__, *,
                 action: str,
                 allowed_scope_levels: Sequence[str],
                 identifier: str,
                 include_in_all_roles: bool,
                 name: str,
                 resource_type: str,
                 status: str):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "allowed_scope_levels", allowed_scope_levels)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "include_in_all_roles", include_in_all_roles)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="allowedScopeLevels")
    def allowed_scope_levels(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_scope_levels")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="includeInAllRoles")
    def include_in_all_roles(self) -> bool:
        return pulumi.get(self, "include_in_all_roles")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetPrometheusConnectorHeaderResult(dict):
    def __init__(__self__, *,
                 encrypted_value_ref: str,
                 key: str,
                 value: str,
                 value_encrypted: bool):
        pulumi.set(__self__, "encrypted_value_ref", encrypted_value_ref)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_encrypted", value_encrypted)

    @property
    @pulumi.getter(name="encryptedValueRef")
    def encrypted_value_ref(self) -> str:
        return pulumi.get(self, "encrypted_value_ref")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueEncrypted")
    def value_encrypted(self) -> bool:
        return pulumi.get(self, "value_encrypted")


@pulumi.output_type
class GetResourceGroupIncludedScopeResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 filter: str,
                 org_id: str,
                 project_id: str):
        """
        :param str account_id: Account Identifier of the account
        :param str org_id: Unique identifier of the Organization.
        :param str project_id: Unique identifier of the Project.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account Identifier of the account
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def filter(self) -> str:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        Unique identifier of the Organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique identifier of the Project.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetResourceGroupResourceFilterResult(dict):
    def __init__(__self__, *,
                 include_all_resources: bool,
                 resources: Sequence['outputs.GetResourceGroupResourceFilterResourceResult']):
        pulumi.set(__self__, "include_all_resources", include_all_resources)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="includeAllResources")
    def include_all_resources(self) -> bool:
        return pulumi.get(self, "include_all_resources")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetResourceGroupResourceFilterResourceResult']:
        return pulumi.get(self, "resources")


@pulumi.output_type
class GetResourceGroupResourceFilterResourceResult(dict):
    def __init__(__self__, *,
                 attribute_filters: Sequence['outputs.GetResourceGroupResourceFilterResourceAttributeFilterResult'],
                 identifiers: Sequence[str],
                 resource_type: str):
        pulumi.set(__self__, "attribute_filters", attribute_filters)
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="attributeFilters")
    def attribute_filters(self) -> Sequence['outputs.GetResourceGroupResourceFilterResourceAttributeFilterResult']:
        return pulumi.get(self, "attribute_filters")

    @property
    @pulumi.getter
    def identifiers(self) -> Sequence[str]:
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetResourceGroupResourceFilterResourceAttributeFilterResult(dict):
    def __init__(__self__, *,
                 attribute_name: str,
                 attribute_values: Sequence[str]):
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_values", attribute_values)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValues")
    def attribute_values(self) -> Sequence[str]:
        return pulumi.get(self, "attribute_values")


@pulumi.output_type
class GetRoleAssignmentsPrincipalResult(dict):
    def __init__(__self__, *,
                 identifier: str,
                 scope_level: str,
                 type: str):
        """
        :param str identifier: Identifier.
        :param str scope_level: Scope level.
        :param str type: Type.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "scope_level", scope_level)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Identifier.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="scopeLevel")
    def scope_level(self) -> str:
        """
        Scope level.
        """
        return pulumi.get(self, "scope_level")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSecretSshkeyKerberoResult(dict):
    def __init__(__self__, *,
                 principal: str,
                 realm: str,
                 tgt_generation_method: str,
                 tgt_key_tab_file_path_specs: Sequence['outputs.GetSecretSshkeyKerberoTgtKeyTabFilePathSpecResult'],
                 tgt_password_specs: Sequence['outputs.GetSecretSshkeyKerberoTgtPasswordSpecResult']):
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "realm", realm)
        pulumi.set(__self__, "tgt_generation_method", tgt_generation_method)
        pulumi.set(__self__, "tgt_key_tab_file_path_specs", tgt_key_tab_file_path_specs)
        pulumi.set(__self__, "tgt_password_specs", tgt_password_specs)

    @property
    @pulumi.getter
    def principal(self) -> str:
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def realm(self) -> str:
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="tgtGenerationMethod")
    def tgt_generation_method(self) -> str:
        return pulumi.get(self, "tgt_generation_method")

    @property
    @pulumi.getter(name="tgtKeyTabFilePathSpecs")
    def tgt_key_tab_file_path_specs(self) -> Sequence['outputs.GetSecretSshkeyKerberoTgtKeyTabFilePathSpecResult']:
        return pulumi.get(self, "tgt_key_tab_file_path_specs")

    @property
    @pulumi.getter(name="tgtPasswordSpecs")
    def tgt_password_specs(self) -> Sequence['outputs.GetSecretSshkeyKerberoTgtPasswordSpecResult']:
        return pulumi.get(self, "tgt_password_specs")


@pulumi.output_type
class GetSecretSshkeyKerberoTgtKeyTabFilePathSpecResult(dict):
    def __init__(__self__, *,
                 key_path: str):
        pulumi.set(__self__, "key_path", key_path)

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> str:
        return pulumi.get(self, "key_path")


@pulumi.output_type
class GetSecretSshkeyKerberoTgtPasswordSpecResult(dict):
    def __init__(__self__, *,
                 password: str):
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")


@pulumi.output_type
class GetSecretSshkeySshResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 ssh_password_credentials: Sequence['outputs.GetSecretSshkeySshSshPasswordCredentialResult'],
                 sshkey_path_credentials: Sequence['outputs.GetSecretSshkeySshSshkeyPathCredentialResult'],
                 sshkey_reference_credentials: Sequence['outputs.GetSecretSshkeySshSshkeyReferenceCredentialResult']):
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "ssh_password_credentials", ssh_password_credentials)
        pulumi.set(__self__, "sshkey_path_credentials", sshkey_path_credentials)
        pulumi.set(__self__, "sshkey_reference_credentials", sshkey_reference_credentials)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="sshPasswordCredentials")
    def ssh_password_credentials(self) -> Sequence['outputs.GetSecretSshkeySshSshPasswordCredentialResult']:
        return pulumi.get(self, "ssh_password_credentials")

    @property
    @pulumi.getter(name="sshkeyPathCredentials")
    def sshkey_path_credentials(self) -> Sequence['outputs.GetSecretSshkeySshSshkeyPathCredentialResult']:
        return pulumi.get(self, "sshkey_path_credentials")

    @property
    @pulumi.getter(name="sshkeyReferenceCredentials")
    def sshkey_reference_credentials(self) -> Sequence['outputs.GetSecretSshkeySshSshkeyReferenceCredentialResult']:
        return pulumi.get(self, "sshkey_reference_credentials")


@pulumi.output_type
class GetSecretSshkeySshSshPasswordCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 user_name: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetSecretSshkeySshSshkeyPathCredentialResult(dict):
    def __init__(__self__, *,
                 encrypted_passphrase: str,
                 key_path: str,
                 user_name: str):
        pulumi.set(__self__, "encrypted_passphrase", encrypted_passphrase)
        pulumi.set(__self__, "key_path", key_path)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="encryptedPassphrase")
    def encrypted_passphrase(self) -> str:
        return pulumi.get(self, "encrypted_passphrase")

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> str:
        return pulumi.get(self, "key_path")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetSecretSshkeySshSshkeyReferenceCredentialResult(dict):
    def __init__(__self__, *,
                 encrypted_assphrase: str,
                 key: str,
                 user_name: str):
        pulumi.set(__self__, "encrypted_assphrase", encrypted_assphrase)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="encryptedAssphrase")
    def encrypted_assphrase(self) -> str:
        return pulumi.get(self, "encrypted_assphrase")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetUsergroupNotificationConfigResult(dict):
    def __init__(__self__, *,
                 group_email: str,
                 microsoft_teams_webhook_url: str,
                 pager_duty_key: str,
                 slack_webhook_url: str,
                 type: str):
        """
        :param str group_email: Group email
        :param str microsoft_teams_webhook_url: Url of Microsoft teams webhook
        :param str pager_duty_key: Pager duty key
        :param str slack_webhook_url: Url of slack webhook
        :param str type: Can be one of EMAIL, SLACK, PAGERDUTY, MSTEAMS
        """
        pulumi.set(__self__, "group_email", group_email)
        pulumi.set(__self__, "microsoft_teams_webhook_url", microsoft_teams_webhook_url)
        pulumi.set(__self__, "pager_duty_key", pager_duty_key)
        pulumi.set(__self__, "slack_webhook_url", slack_webhook_url)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupEmail")
    def group_email(self) -> str:
        """
        Group email
        """
        return pulumi.get(self, "group_email")

    @property
    @pulumi.getter(name="microsoftTeamsWebhookUrl")
    def microsoft_teams_webhook_url(self) -> str:
        """
        Url of Microsoft teams webhook
        """
        return pulumi.get(self, "microsoft_teams_webhook_url")

    @property
    @pulumi.getter(name="pagerDutyKey")
    def pager_duty_key(self) -> str:
        """
        Pager duty key
        """
        return pulumi.get(self, "pager_duty_key")

    @property
    @pulumi.getter(name="slackWebhookUrl")
    def slack_webhook_url(self) -> str:
        """
        Url of slack webhook
        """
        return pulumi.get(self, "slack_webhook_url")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Can be one of EMAIL, SLACK, PAGERDUTY, MSTEAMS
        """
        return pulumi.get(self, "type")


