# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitOpsRepositoryArgs', 'GitOpsRepository']

@pulumi.input_type
class GitOpsRepositoryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 repos: pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]],
                 agent_id: Optional[pulumi.Input[str]] = None,
                 creds_only: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 query_force_refresh: Optional[pulumi.Input[bool]] = None,
                 query_project: Optional[pulumi.Input[str]] = None,
                 query_repo: Optional[pulumi.Input[str]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]] = None,
                 upsert: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a GitOpsRepository resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]] repos: Repo Details that need to be stored.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[bool] creds_only: Credentials only of the Repo.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[bool] query_force_refresh: Force refresh query for Repo.
        :param pulumi.Input[str] query_project: Project to Query for Repo.
        :param pulumi.Input[str] query_repo: Repo to Query.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]] update_masks: Update mask of the Repository.
        :param pulumi.Input[bool] upsert: Upsert the Repo Details.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repos", repos)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if creds_only is not None:
            pulumi.set(__self__, "creds_only", creds_only)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if query_force_refresh is not None:
            pulumi.set(__self__, "query_force_refresh", query_force_refresh)
        if query_project is not None:
            pulumi.set(__self__, "query_project", query_project)
        if query_repo is not None:
            pulumi.set(__self__, "query_repo", query_repo)
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def repos(self) -> pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]:
        """
        Repo Details that need to be stored.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]):
        pulumi.set(self, "repos", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Credentials only of the Repo.
        """
        return pulumi.get(self, "creds_only")

    @creds_only.setter
    def creds_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "creds_only", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="queryForceRefresh")
    def query_force_refresh(self) -> Optional[pulumi.Input[bool]]:
        """
        Force refresh query for Repo.
        """
        return pulumi.get(self, "query_force_refresh")

    @query_force_refresh.setter
    def query_force_refresh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_force_refresh", value)

    @property
    @pulumi.getter(name="queryProject")
    def query_project(self) -> Optional[pulumi.Input[str]]:
        """
        Project to Query for Repo.
        """
        return pulumi.get(self, "query_project")

    @query_project.setter
    def query_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_project", value)

    @property
    @pulumi.getter(name="queryRepo")
    def query_repo(self) -> Optional[pulumi.Input[str]]:
        """
        Repo to Query.
        """
        return pulumi.get(self, "query_repo")

    @query_repo.setter
    def query_repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_repo", value)

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]:
        """
        Update mask of the Repository.
        """
        return pulumi.get(self, "update_masks")

    @update_masks.setter
    def update_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]):
        pulumi.set(self, "update_masks", value)

    @property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[bool]]:
        """
        Upsert the Repo Details.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.input_type
class _GitOpsRepositoryState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 creds_only: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 query_force_refresh: Optional[pulumi.Input[bool]] = None,
                 query_project: Optional[pulumi.Input[str]] = None,
                 query_repo: Optional[pulumi.Input[str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]] = None,
                 upsert: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering GitOpsRepository resources.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[bool] creds_only: Credentials only of the Repo.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[bool] query_force_refresh: Force refresh query for Repo.
        :param pulumi.Input[str] query_project: Project to Query for Repo.
        :param pulumi.Input[str] query_repo: Repo to Query.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]] repos: Repo Details that need to be stored.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]] update_masks: Update mask of the Repository.
        :param pulumi.Input[bool] upsert: Upsert the Repo Details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if creds_only is not None:
            pulumi.set(__self__, "creds_only", creds_only)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if query_force_refresh is not None:
            pulumi.set(__self__, "query_force_refresh", query_force_refresh)
        if query_project is not None:
            pulumi.set(__self__, "query_project", query_project)
        if query_repo is not None:
            pulumi.set(__self__, "query_repo", query_repo)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Credentials only of the Repo.
        """
        return pulumi.get(self, "creds_only")

    @creds_only.setter
    def creds_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "creds_only", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="queryForceRefresh")
    def query_force_refresh(self) -> Optional[pulumi.Input[bool]]:
        """
        Force refresh query for Repo.
        """
        return pulumi.get(self, "query_force_refresh")

    @query_force_refresh.setter
    def query_force_refresh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_force_refresh", value)

    @property
    @pulumi.getter(name="queryProject")
    def query_project(self) -> Optional[pulumi.Input[str]]:
        """
        Project to Query for Repo.
        """
        return pulumi.get(self, "query_project")

    @query_project.setter
    def query_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_project", value)

    @property
    @pulumi.getter(name="queryRepo")
    def query_repo(self) -> Optional[pulumi.Input[str]]:
        """
        Repo to Query.
        """
        return pulumi.get(self, "query_repo")

    @query_repo.setter
    def query_repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_repo", value)

    @property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]]:
        """
        Repo Details that need to be stored.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]]):
        pulumi.set(self, "repos", value)

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]:
        """
        Update mask of the Repository.
        """
        return pulumi.get(self, "update_masks")

    @update_masks.setter
    def update_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]):
        pulumi.set(self, "update_masks", value)

    @property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[bool]]:
        """
        Upsert the Repo Details.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upsert", value)


class GitOpsRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 creds_only: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 query_force_refresh: Optional[pulumi.Input[bool]] = None,
                 query_project: Optional[pulumi.Input[str]] = None,
                 query_repo: Optional[pulumi.Input[str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryRepoArgs']]]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryUpdateMaskArgs']]]]] = None,
                 upsert: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a GitOpsRepository resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[bool] creds_only: Credentials only of the Repo.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[bool] query_force_refresh: Force refresh query for Repo.
        :param pulumi.Input[str] query_project: Project to Query for Repo.
        :param pulumi.Input[str] query_repo: Repo to Query.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryRepoArgs']]]] repos: Repo Details that need to be stored.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryUpdateMaskArgs']]]] update_masks: Update mask of the Repository.
        :param pulumi.Input[bool] upsert: Upsert the Repo Details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitOpsRepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GitOpsRepository resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GitOpsRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitOpsRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 creds_only: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 query_force_refresh: Optional[pulumi.Input[bool]] = None,
                 query_project: Optional[pulumi.Input[str]] = None,
                 query_repo: Optional[pulumi.Input[str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryRepoArgs']]]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryUpdateMaskArgs']]]]] = None,
                 upsert: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitOpsRepositoryArgs.__new__(GitOpsRepositoryArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["creds_only"] = creds_only
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["query_force_refresh"] = query_force_refresh
            __props__.__dict__["query_project"] = query_project
            __props__.__dict__["query_repo"] = query_repo
            if repos is None and not opts.urn:
                raise TypeError("Missing required property 'repos'")
            __props__.__dict__["repos"] = repos
            __props__.__dict__["update_masks"] = update_masks
            __props__.__dict__["upsert"] = upsert
        super(GitOpsRepository, __self__).__init__(
            'harness:platform/gitOpsRepository:GitOpsRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            agent_id: Optional[pulumi.Input[str]] = None,
            creds_only: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            query_force_refresh: Optional[pulumi.Input[bool]] = None,
            query_project: Optional[pulumi.Input[str]] = None,
            query_repo: Optional[pulumi.Input[str]] = None,
            repos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryRepoArgs']]]]] = None,
            update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryUpdateMaskArgs']]]]] = None,
            upsert: Optional[pulumi.Input[bool]] = None) -> 'GitOpsRepository':
        """
        Get an existing GitOpsRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[bool] creds_only: Credentials only of the Repo.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[bool] query_force_refresh: Force refresh query for Repo.
        :param pulumi.Input[str] query_project: Project to Query for Repo.
        :param pulumi.Input[str] query_repo: Repo to Query.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryRepoArgs']]]] repos: Repo Details that need to be stored.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsRepositoryUpdateMaskArgs']]]] update_masks: Update mask of the Repository.
        :param pulumi.Input[bool] upsert: Upsert the Repo Details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitOpsRepositoryState.__new__(_GitOpsRepositoryState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["creds_only"] = creds_only
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["query_force_refresh"] = query_force_refresh
        __props__.__dict__["query_project"] = query_project
        __props__.__dict__["query_repo"] = query_repo
        __props__.__dict__["repos"] = repos
        __props__.__dict__["update_masks"] = update_masks
        __props__.__dict__["upsert"] = upsert
        return GitOpsRepository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[Optional[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Credentials only of the Repo.
        """
        return pulumi.get(self, "creds_only")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="queryForceRefresh")
    def query_force_refresh(self) -> pulumi.Output[Optional[bool]]:
        """
        Force refresh query for Repo.
        """
        return pulumi.get(self, "query_force_refresh")

    @property
    @pulumi.getter(name="queryProject")
    def query_project(self) -> pulumi.Output[Optional[str]]:
        """
        Project to Query for Repo.
        """
        return pulumi.get(self, "query_project")

    @property
    @pulumi.getter(name="queryRepo")
    def query_repo(self) -> pulumi.Output[Optional[str]]:
        """
        Repo to Query.
        """
        return pulumi.get(self, "query_repo")

    @property
    @pulumi.getter
    def repos(self) -> pulumi.Output[Sequence['outputs.GitOpsRepositoryRepo']]:
        """
        Repo Details that need to be stored.
        """
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> pulumi.Output[Optional[Sequence['outputs.GitOpsRepositoryUpdateMask']]]:
        """
        Update mask of the Repository.
        """
        return pulumi.get(self, "update_masks")

    @property
    @pulumi.getter
    def upsert(self) -> pulumi.Output[Optional[bool]]:
        """
        Upsert the Repo Details.
        """
        return pulumi.get(self, "upsert")

