# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitOpsClusterArgs', 'GitOpsCluster']

@pulumi.input_type
class GitOpsClusterArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 agent_id: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]] = None):
        """
        The set of arguments for constructing a GitOpsCluster resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]] queries: query for cluster resources
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]] requests: Cluster create/Update request.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "project_id", project_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]]:
        """
        query for cluster resources
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]]:
        """
        Cluster create/Update request.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class _GitOpsClusterState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]] = None):
        """
        Input properties used for looking up and filtering GitOpsCluster resources.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]] queries: query for cluster resources
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]] requests: Cluster create/Update request.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]]:
        """
        query for cluster resources
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]]:
        """
        Cluster create/Update request.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsClusterRequestArgs']]]]):
        pulumi.set(self, "requests", value)


class GitOpsCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterQueryArgs']]]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterRequestArgs']]]]] = None,
                 __props__=None):
        """
        Create a GitOpsCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterQueryArgs']]]] queries: query for cluster resources
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterRequestArgs']]]] requests: Cluster create/Update request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitOpsClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GitOpsCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GitOpsClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitOpsClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterQueryArgs']]]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterRequestArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitOpsClusterArgs.__new__(GitOpsClusterArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["agent_id"] = agent_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["queries"] = queries
            __props__.__dict__["requests"] = requests
        super(GitOpsCluster, __self__).__init__(
            'harness:platform/gitOpsCluster:GitOpsCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            agent_id: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterQueryArgs']]]]] = None,
            requests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterRequestArgs']]]]] = None) -> 'GitOpsCluster':
        """
        Get an existing GitOpsCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: account identifier of the cluster.
        :param pulumi.Input[str] agent_id: agent identifier of the cluster.
        :param pulumi.Input[str] identifier: identifier of the cluster.
        :param pulumi.Input[str] org_id: organization identifier of the cluster.
        :param pulumi.Input[str] project_id: project identifier of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterQueryArgs']]]] queries: query for cluster resources
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitOpsClusterRequestArgs']]]] requests: Cluster create/Update request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitOpsClusterState.__new__(_GitOpsClusterState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["queries"] = queries
        __props__.__dict__["requests"] = requests
        return GitOpsCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        account identifier of the cluster.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[Optional[str]]:
        """
        agent identifier of the cluster.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        identifier of the cluster.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        organization identifier of the cluster.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        project identifier of the cluster.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Sequence['outputs.GitOpsClusterQuery']]]:
        """
        query for cluster resources
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter
    def requests(self) -> pulumi.Output[Optional[Sequence['outputs.GitOpsClusterRequest']]]:
        """
        Cluster create/Update request.
        """
        return pulumi.get(self, "requests")

