# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetTriggersResult',
    'AwaitableGetTriggersResult',
    'get_triggers',
    'get_triggers_output',
]

@pulumi.output_type
class GetTriggersResult:
    """
    A collection of values returned by getTriggers.
    """
    def __init__(__self__, description=None, id=None, identifier=None, ignore_error=None, name=None, org_id=None, project_id=None, tags=None, target_id=None, yaml=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if ignore_error and not isinstance(ignore_error, bool):
            raise TypeError("Expected argument 'ignore_error' to be a bool")
        pulumi.set(__self__, "ignore_error", ignore_error)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="ignoreError")
    def ignore_error(self) -> Optional[bool]:
        """
        ignore error default false
        """
        return pulumi.get(self, "ignore_error")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Identifier of the target pipeline
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def yaml(self) -> str:
        """
        trigger yaml
        """
        return pulumi.get(self, "yaml")


class AwaitableGetTriggersResult(GetTriggersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTriggersResult(
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            ignore_error=self.ignore_error,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            target_id=self.target_id,
            yaml=self.yaml)


def get_triggers(identifier: Optional[str] = None,
                 ignore_error: Optional[bool] = None,
                 name: Optional[str] = None,
                 org_id: Optional[str] = None,
                 project_id: Optional[str] = None,
                 target_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTriggersResult:
    """
    Data source for retrieving a Harness trigger.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_triggers(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        target_id="pipeline_id")
    ```


    :param str identifier: Unique identifier of the resource.
    :param bool ignore_error: ignore error default false
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str project_id: Unique identifier of the project.
    :param str target_id: Identifier of the target pipeline
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['ignoreError'] = ignore_error
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getTriggers:getTriggers', __args__, opts=opts, typ=GetTriggersResult).value

    return AwaitableGetTriggersResult(
        description=__ret__.description,
        id=__ret__.id,
        identifier=__ret__.identifier,
        ignore_error=__ret__.ignore_error,
        name=__ret__.name,
        org_id=__ret__.org_id,
        project_id=__ret__.project_id,
        tags=__ret__.tags,
        target_id=__ret__.target_id,
        yaml=__ret__.yaml)


@_utilities.lift_output_func(get_triggers)
def get_triggers_output(identifier: Optional[pulumi.Input[Optional[str]]] = None,
                        ignore_error: Optional[pulumi.Input[Optional[bool]]] = None,
                        name: Optional[pulumi.Input[Optional[str]]] = None,
                        org_id: Optional[pulumi.Input[str]] = None,
                        project_id: Optional[pulumi.Input[str]] = None,
                        target_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTriggersResult]:
    """
    Data source for retrieving a Harness trigger.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_triggers(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        target_id="pipeline_id")
    ```


    :param str identifier: Unique identifier of the resource.
    :param bool ignore_error: ignore error default false
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str project_id: Unique identifier of the project.
    :param str target_id: Identifier of the target pipeline
    """
    ...
