# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 variable_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[str] app_id: The id of the application.
        :param pulumi.Input[str] type: The type of the environment. Valid values are `PROD` and `NON_PROD`
        :param pulumi.Input[str] description: The description of the environment.
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]] variable_overrides: Override for a service variable
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if variable_overrides is not None:
            pulumi.set(__self__, "variable_overrides", variable_overrides)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The id of the application.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the environment. Valid values are `PROD` and `NON_PROD`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="variableOverrides")
    def variable_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]]:
        """
        Override for a service variable
        """
        return pulumi.get(self, "variable_overrides")

    @variable_overrides.setter
    def variable_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]]):
        pulumi.set(self, "variable_overrides", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variable_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[str] app_id: The id of the application.
        :param pulumi.Input[str] description: The description of the environment.
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input[str] type: The type of the environment. Valid values are `PROD` and `NON_PROD`
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]] variable_overrides: Override for a service variable
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if variable_overrides is not None:
            pulumi.set(__self__, "variable_overrides", variable_overrides)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the application.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment. Valid values are `PROD` and `NON_PROD`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="variableOverrides")
    def variable_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]]:
        """
        Override for a service variable
        """
        return pulumi.get(self, "variable_overrides")

    @variable_overrides.setter
    def variable_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableOverrideArgs']]]]):
        pulumi.set(self, "variable_overrides", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variable_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentVariableOverrideArgs']]]]] = None,
                 __props__=None):
        """
        Resource for creating an environment

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        test_application = harness.Application("testApplication")
        test_kubernetes = harness.service.Kubernetes("testKubernetes",
            app_id=test_application.id,
            helm_version="V2",
            description="description",
            variables=[
                harness.service.KubernetesVariableArgs(
                    name="test",
                    value="test_value",
                    type="TEXT",
                ),
                harness.service.KubernetesVariableArgs(
                    name="test2",
                    value="test_value2",
                    type="TEXT",
                ),
            ])
        test_environment = harness.Environment("testEnvironment",
            app_id=test_application.id,
            type="%[2]s",
            variable_overrides=[
                harness.EnvironmentVariableOverrideArgs(
                    service_name=test_kubernetes.name,
                    name="test",
                    value="override",
                    type="TEXT",
                ),
                harness.EnvironmentVariableOverrideArgs(
                    service_name=test_kubernetes.name,
                    name="test2",
                    value="override2",
                    type="TEXT",
                ),
            ])
        ```

        ## Import

        Import using the Harness application id and environment id.

        ```sh
         $ pulumi import harness:index/environment:Environment dev <application_id>/<environment_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The id of the application.
        :param pulumi.Input[str] description: The description of the environment.
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input[str] type: The type of the environment. Valid values are `PROD` and `NON_PROD`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentVariableOverrideArgs']]]] variable_overrides: Override for a service variable
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an environment

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        test_application = harness.Application("testApplication")
        test_kubernetes = harness.service.Kubernetes("testKubernetes",
            app_id=test_application.id,
            helm_version="V2",
            description="description",
            variables=[
                harness.service.KubernetesVariableArgs(
                    name="test",
                    value="test_value",
                    type="TEXT",
                ),
                harness.service.KubernetesVariableArgs(
                    name="test2",
                    value="test_value2",
                    type="TEXT",
                ),
            ])
        test_environment = harness.Environment("testEnvironment",
            app_id=test_application.id,
            type="%[2]s",
            variable_overrides=[
                harness.EnvironmentVariableOverrideArgs(
                    service_name=test_kubernetes.name,
                    name="test",
                    value="override",
                    type="TEXT",
                ),
                harness.EnvironmentVariableOverrideArgs(
                    service_name=test_kubernetes.name,
                    name="test2",
                    value="override2",
                    type="TEXT",
                ),
            ])
        ```

        ## Import

        Import using the Harness application id and environment id.

        ```sh
         $ pulumi import harness:index/environment:Environment dev <application_id>/<environment_id>
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variable_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentVariableOverrideArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["variable_overrides"] = variable_overrides
        super(Environment, __self__).__init__(
            'harness:index/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            variable_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentVariableOverrideArgs']]]]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The id of the application.
        :param pulumi.Input[str] description: The description of the environment.
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input[str] type: The type of the environment. Valid values are `PROD` and `NON_PROD`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentVariableOverrideArgs']]]] variable_overrides: Override for a service variable
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["variable_overrides"] = variable_overrides
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The id of the application.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the environment. Valid values are `PROD` and `NON_PROD`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="variableOverrides")
    def variable_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentVariableOverride']]]:
        """
        Override for a service variable
        """
        return pulumi.get(self, "variable_overrides")

