# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SpotArgs', 'Spot']

@pulumi.input_type
class SpotArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 token_secret_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Spot resource.
        :param pulumi.Input[str] account_id: The Spot account ID
        :param pulumi.Input[str] token_secret_name: The name of the Harness secret containing the spot account token
        :param pulumi.Input[str] name: The name of the cloud provider.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "token_secret_name", token_secret_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The Spot account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="tokenSecretName")
    def token_secret_name(self) -> pulumi.Input[str]:
        """
        The name of the Harness secret containing the spot account token
        """
        return pulumi.get(self, "token_secret_name")

    @token_secret_name.setter
    def token_secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_secret_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpotState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 token_secret_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Spot resources.
        :param pulumi.Input[str] account_id: The Spot account ID
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] token_secret_name: The name of the Harness secret containing the spot account token
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if token_secret_name is not None:
            pulumi.set(__self__, "token_secret_name", token_secret_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Spot account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tokenSecretName")
    def token_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Harness secret containing the spot account token
        """
        return pulumi.get(self, "token_secret_name")

    @token_secret_name.setter
    def token_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_secret_name", value)


class Spot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 token_secret_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating a Spot cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        spot_token = harness.EncryptedText("spotToken",
            secret_manager_id=default.id,
            value="<SPOT_TOKEN>")
        example = harness.cloudprovider.Spot("example",
            account_id="<SPOT_ACCOUNT_ID>",
            token_secret_name=spot_token.name)
        ```

        ## Import

        Import using the Harness Spot cloud provider id.

        ```sh
         $ pulumi import harness:cloudprovider/spot:Spot example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The Spot account ID
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] token_secret_name: The name of the Harness secret containing the spot account token
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Spot cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        spot_token = harness.EncryptedText("spotToken",
            secret_manager_id=default.id,
            value="<SPOT_TOKEN>")
        example = harness.cloudprovider.Spot("example",
            account_id="<SPOT_ACCOUNT_ID>",
            token_secret_name=spot_token.name)
        ```

        ## Import

        Import using the Harness Spot cloud provider id.

        ```sh
         $ pulumi import harness:cloudprovider/spot:Spot example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param SpotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 token_secret_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpotArgs.__new__(SpotArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["name"] = name
            if token_secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'token_secret_name'")
            __props__.__dict__["token_secret_name"] = token_secret_name
        super(Spot, __self__).__init__(
            'harness:cloudprovider/spot:Spot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            token_secret_name: Optional[pulumi.Input[str]] = None) -> 'Spot':
        """
        Get an existing Spot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The Spot account ID
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] token_secret_name: The name of the Harness secret containing the spot account token
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpotState.__new__(_SpotState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["name"] = name
        __props__.__dict__["token_secret_name"] = token_secret_name
        return Spot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The Spot account ID
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tokenSecretName")
    def token_secret_name(self) -> pulumi.Output[str]:
        """
        The name of the Harness secret containing the spot account token
        """
        return pulumi.get(self, "token_secret_name")

