// Copyright (c) 2015-2016, Massachusetts Institute of Technology
// Copyright (c) 2016-2017 Sandia Corporation
// Copyright (c) 2017 NTESS, LLC.
// Copyright (c) 2018-2021, University of Michigan

// This file is part of the Compressed Continuous Computation (C3) Library
// Author: Alex A. Gorodetsky 
// Contact: alex@alexgorodetsky.com

// All rights reserved.

// Redistribution and use in source and binary forms, with or without modification, 
// are permitted provided that the following conditions are met:

// 1. Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer.

// 2. Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution.

// 3. Neither the name of the copyright holder nor the names of its contributors 
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//Code

#include <string.h>

static const double lpolycoeffs[250000] = {
0.999999999999999,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.07100743204636E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.2686086989927E-14,
1.38606032033806E-14,
1.27546627773367E-14,
1.07827700761287E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999999,
  0,
  0,
  0,
  0,
  0,
-1.08742767394865E-14,
-1.22127785315285E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.46022516994693E-14,
  0,
1.2994705138325E-14,
  0,
  0,
  0,
  0,
1.66146393518196E-14,
1.763205467048E-14,
2.20431312092373E-14,
2.1337640855601E-14,
1.62057867125753E-14,
1.61521187050373E-14,
  0,
1.40057236641677E-14,
  0,
1.23663015591524E-14,
  0,
  0,
  0,
0.999999999999998,
  0,
  0,
  0,
-1.06567315735773E-14,
-1.06855713513654E-14,
  0,
-1.07112127327447E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.07372877949929E-14,
  0,
  0,
  0,
1.1536886897201E-14,
  0,
1.54749260281029E-14,
  0,
1.4732572800602E-14,
  0,
1.31821636939478E-14,
  0,
1.02412653010808E-14,
1.47855902868366E-14,
1.70405139651719E-14,
2.32296820668054E-14,
2.22247350731286E-14,
2.27654266965471E-14,
2.42586983487114E-14,
1.57210399212571E-14,
2.04046848861772E-14,
1.40322866173936E-14,
1.62584789381581E-14,
  0,
1.03982577756567E-14,
  0,
  0,
  0,
0.999999999999994,
  0,
-1.00554330487168E-14,
-1.06920223542917E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.16521375881362E-14,
  0,
1.27076084030509E-14,
  0,
1.80141275160639E-14,
  0,
1.49362943888121E-14,
  0,
1.43065897670325E-14,
  0,
1.74146721348967E-14,
1.81770831025885E-14,
1.93157122241328E-14,
2.05779403933404E-14,
2.07647484276596E-14,
2.29226360115575E-14,
2.40963932834903E-14,
2.14912723034422E-14,
2.75742970123893E-14,
2.23280595401665E-14,
2.18954628733448E-14,
  0,
1.36936902789264E-14,
  0,
  0,
  0,
  0,
  0,
0.999999999999989,
-1.09458340828705E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02220749226278E-14,
  0,
1.48819758599705E-14,
  0,
1.88943912599049E-14,
  0,
1.71293101230985E-14,
  0,
1.41657519048266E-14,
  0,
1.82250048386123E-14,
1.72657027563972E-14,
2.61271039525557E-14,
2.35714225915729E-14,
2.2591303827646E-14,
1.97656561257142E-14,
2.21461304156234E-14,
2.11373887143429E-14,
2.68864791541645E-14,
2.76447701536009E-14,
2.85596199467442E-14,
1.78147427365438E-14,
1.89613949541645E-14,
  0,
1.48219110596148E-14,
  0,
  0,
  0,
-1.00659498097899E-14,
-1.09147716906288E-14,
0.999999999999991,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.32997996296624E-14,
  0,
2.08940937468372E-14,
  0,
1.77440527548978E-14,
  0,
1.61836689882566E-14,
  0,
1.79173082620609E-14,
1.55502780790906E-14,
2.66407989418793E-14,
2.24076399796269E-14,
2.91368491833754E-14,
2.25015318877642E-14,
2.37000089692296E-14,
1.77026362319088E-14,
2.4610955634552E-14,
2.69870931157712E-14,
2.75066427968262E-14,
2.28560659981669E-14,
2.53241438236129E-14,
1.69885806811099E-14,
1.98786299920872E-14,
  0,
  0,
  0,
-1.06270244340512E-14,
-1.06920765644003E-14,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
-1.30949938392799E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.91515640152184E-14,
  0,
1.96101815341798E-14,
  0,
1.66689578806611E-14,
  0,
1.97795339135221E-14,
1.54292811166412E-14,
2.61539921664333E-14,
2.05519195412007E-14,
2.94393415894989E-14,
2.11421592039018E-14,
3.00345685821934E-14,
2.02656901676646E-14,
2.59618715414689E-14,
2.33613042105452E-14,
2.50262050666139E-14,
2.20121230271042E-14,
2.40415326535626E-14,
2.18440716903689E-14,
2.60587992156891E-14,
1.30828507749481E-14,
1.62873187159462E-14,
  0,
-1.090132758369E-14,
-1.07185853075176E-14,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
  0,
  0,
-1.07640675886533E-14,
  0,
-1.01107273595136E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.31353261600964E-14,
  0,
1.77512084892362E-14,
  0,
1.83859004410092E-14,
1.14524275479644E-14,
2.01746171851758E-14,
1.65366852156179E-14,
2.78947871745761E-14,
2.03151297867299E-14,
2.875759526344E-14,
1.91402883126246E-14,
3.01657570450642E-14,
1.87569144244337E-14,
3.21387881585533E-14,
2.58042285455895E-14,
2.62071180728851E-14,
1.82406173498961E-14,
2.14082224170298E-14,
2.0865253969049E-14,
2.46328565184362E-14,
1.78802285477619E-14,
2.23360826362429E-14,
1.90104008923608E-14,
  0,
-1.22266563193363E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
-1.05174115944129E-14,
  0,
  0,
-1.00328816435291E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.50261747489111E-14,
  0,
1.17106845054504E-14,
  0,
1.64861613943801E-14,
  0,
2.18306275834301E-14,
1.90112682540988E-14,
2.81669219198699E-14,
2.13104273810716E-14,
3.03977763099761E-14,
1.88332422573767E-14,
2.93807946721847E-14,
1.66761136149995E-14,
3.21340176689944E-14,
2.42037292985664E-14,
3.22472083758019E-14,
2.05885655746307E-14,
2.25147591542685E-14,
1.70263109167124E-14,
2.19112922250631E-14,
1.67962432157109E-14,
2.08255721695361E-14,
2.37141035974719E-14,
3.10324682617491E-14,
  0,
  0,
-1.06985817774352E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999993,
-1.00673592726142E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.18453424152731E-14,
  0,
1.5554398047346E-14,
  0,
1.35345294000055E-14,
  0,
1.03647559285269E-14,
  0,
1.98324429795393E-14,
1.49834571833152E-14,
2.97474718469193E-14,
2.37167056826859E-14,
3.05885958923335E-14,
1.98031695208822E-14,
3.09158081079897E-14,
1.63313373241492E-14,
3.12226373228031E-14,
2.20171103570976E-14,
3.21331503072564E-14,
1.88941744194704E-14,
2.8457921782965E-14,
1.92849208824342E-14,
2.29404169271863E-14,
1.28690461065339E-14,
1.80168380214951E-14,
2.25804618059211E-14,
2.9392720896082E-14,
2.86895073670079E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.00673592726142E-14,
0.999999999999992,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.01305682592701E-14,
  0,
1.7464111753962E-14,
  0,
1.40399844528183E-14,
  0,
1.21872997804751E-14,
  0,
1.36639831394003E-14,
1.35546955604138E-14,
2.77061359965636E-14,
1.96392381524024E-14,
3.21006242420818E-14,
2.21214106060907E-14,
3.1000159037009E-14,
1.72472713194649E-14,
3.26750345530646E-14,
2.16244123302234E-14,
3.11573683520194E-14,
1.667806517891E-14,
2.82597296258347E-14,
1.75874939611909E-14,
2.88213463511822E-14,
1.51322097213802E-14,
1.89911020936906E-14,
1.86001387902923E-14,
2.65317282033273E-14,
2.74743335720862E-14,
3.25065495354604E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.05035338066051E-14,
  0,
  0,
0.999999999999991,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.57805626205265E-14,
  0,
1.59173889346942E-14,
  0,
1.26264016603317E-14,
  0,
1.54325337231587E-14,
1.05622975643538E-14,
2.14973438356081E-14,
1.81300287283026E-14,
2.99816595161762E-14,
1.80296316071304E-14,
3.24323901068624E-14,
1.95377568290578E-14,
3.2721872086916E-14,
2.25021824090677E-14,
3.25479660584493E-14,
1.62361443734049E-14,
2.72340743706634E-14,
1.53145725267922E-14,
2.85498621271918E-14,
1.33953178410584E-14,
2.47970047273505E-14,
2.08077912539073E-14,
2.74619736673198E-14,
2.34280910643703E-14,
2.95648922010727E-14,
2.7970247645781E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.08161092929326E-14,
  0,
  0,
  0,
  0,
0.999999999999996,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.07028101659079E-14,
  0,
1.41956758847872E-14,
  0,
1.45007703761246E-14,
  0,
1.58837786673471E-14,
1.37476835471162E-14,
2.31973728420654E-14,
1.51146456461859E-14,
2.37275477044108E-14,
1.65043759908778E-14,
3.02709246557953E-14,
1.53987066153771E-14,
3.41220107724638E-14,
2.47636113004379E-14,
3.25230294084822E-14,
1.71000366644414E-14,
2.85431400737224E-14,
1.48355720069882E-14,
2.74697799229617E-14,
1.11113375445004E-14,
2.44836702995022E-14,
1.90197250310442E-14,
3.32340491931982E-14,
2.56246846658259E-14,
3.044136123731E-14,
2.38877927855041E-14,
3.27856231746582E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.30801402695169E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.27643121766718E-14,
1.13639566506896E-14,
1.77384149036008E-14,
1.70100478841251E-14,
2.36512198714678E-14,
1.82978632246034E-14,
2.54277935513025E-14,
1.34742477592154E-14,
2.39988150879666E-14,
1.38467796256814E-14,
3.18820490841087E-14,
2.05889992554997E-14,
3.38572486019428E-14,
1.92794998715717E-14,
2.84750521772903E-14,
1.56769128928369E-14,
2.87281049643484E-14,
1.06180255560195E-14,
2.33391864862265E-14,
1.67131933292985E-14,
3.28584815606492E-14,
2.37646274187098E-14,
3.61633466228195E-14,
2.60434035448398E-14,
3.36150378366096E-14,
1.91071117261465E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.01118115616861E-14,
-1.00328816435291E-14,
  0,
  0,
  0,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.59971862145891E-14,
1.87601670309512E-14,
2.54744142447194E-14,
2.15322551455621E-14,
2.5805312747762E-14,
1.66310108046241E-14,
2.56808463383607E-14,
1.08146998301084E-14,
2.55745945254571E-14,
1.90587563092537E-14,
3.16482950957209E-14,
1.50840711449218E-14,
2.97865031251288E-14,
1.78472688017184E-14,
2.86470066418465E-14,
1.14177330784448E-14,
2.45836337398053E-14,
1.62320244051495E-14,
3.16907958208823E-14,
2.14463863335013E-14,
3.57448445842401E-14,
2.41703358716538E-14,
3.92880172839227E-14,
2.12169691538033E-14,
3.10073147713474E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999994,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.09096759404181E-14,
1.58931028060305E-14,
2.37219098531138E-14,
2.32567871211176E-14,
2.7639565983173E-14,
1.98343945434498E-14,
2.60202016183486E-14,
1.39647408220478E-14,
2.72403627432638E-14,
1.59856936715608E-14,
2.52727526406371E-14,
1.35585986882347E-14,
2.75406867450423E-14,
1.365335795811E-14,
2.99463145253531E-14,
1.35874384660228E-14,
2.4456998926059E-14,
1.70133004906425E-14,
3.28868876575683E-14,
2.09359439506951E-14,
3.45353086406153E-14,
2.18319286260371E-14,
3.88300502862649E-14,
1.93256868841196E-14,
3.66312882804642E-14,
1.96166867472147E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999996,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.85825747150981E-14,
2.0384518725769E-14,
2.58473797920544E-14,
2.15671664555162E-14,
2.78113036072947E-14,
1.71655224756595E-14,
2.75907768854111E-14,
1.9110364332664E-14,
2.69385208584438E-14,
1.04755613905549E-14,
2.11861778121047E-14,
1.20843005740889E-14,
2.76619005479262E-14,
  0,
2.57059998287623E-14,
1.91591534304258E-14,
3.27086448204117E-14,
2.16823087262341E-14,
3.57231605407904E-14,
2.12980674763052E-14,
3.75988302991903E-14,
1.69603914246252E-14,
3.61464330689287E-14,
1.77184655836271E-14,
4.6373929002419E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999999,
  0,
  0,
  0,
  0,
  0,
  0,
1.46172136894496E-14,
1.4395385924959E-14,
2.07201877183705E-14,
1.87014032732025E-14,
2.5991145000126E-14,
1.88662020034203E-14,
2.93777589061017E-14,
2.22803546445771E-14,
2.72911034049361E-14,
1.35913415938438E-14,
2.28194199647369E-14,
  0,
2.12546993894058E-14,
  0,
2.34257058195908E-14,
1.49394385751123E-14,
3.3958079403984E-14,
2.38194880486375E-14,
3.552496838366E-14,
2.20071356971108E-14,
3.87233647924923E-14,
1.64169892957755E-14,
3.48735797184307E-14,
1.53488333154428E-14,
4.5846139384853E-14,
1.79565563807049E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
  0,
  0,
1.69224443485883E-14,
1.27792741666521E-14,
1.6643153868956E-14,
1.26242332559867E-14,
2.08895400977127E-14,
1.60184365771698E-14,
2.75435056706907E-14,
2.39964298431872E-14,
2.9056835063046E-14,
1.67775949383442E-14,
2.31321038712817E-14,
1.21343907144578E-14,
2.2886640499431E-14,
  0,
1.70206730654154E-14,
1.3385560021506E-14,
3.16478614148519E-14,
1.96032426402759E-14,
3.67132539647042E-14,
2.41317382743134E-14,
3.85412188275147E-14,
1.7125623835712E-14,
3.5976863849152E-14,
1.47646651849076E-14,
4.4581092289997E-14,
1.55435560256212E-14,
4.81255660322866E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
1.02665272116997E-14,
1.72138778925524E-14,
1.39914121954909E-14,
1.90437943192734E-14,
1.10879187775748E-14,
1.69196254229398E-14,
  0,
2.24490565026159E-14,
2.11347866291289E-14,
2.72407964241328E-14,
1.84804428704499E-14,
2.48768020072454E-14,
1.53006947389844E-14,
2.31928191929409E-14,
  0,
1.86179197059211E-14,
1.03003543194813E-14,
2.52267824685237E-14,
1.80346189371239E-14,
3.43952297199301E-14,
1.98794973538252E-14,
3.97026161946812E-14,
1.92159656242641E-14,
3.57600234146549E-14,
1.54897795978659E-14,
4.56527177172816E-14,
1.49888781941776E-14,
4.68266918296489E-14,
1.65254095130241E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.00000000000001,
1.7129093282664E-14,
1.4733873843209E-14,
1.93100743728358E-14,
1.212051292665E-14,
1.92343970611963E-14,
  0,
1.83438333967167E-14,
1.51361128492011E-14,
2.21146885526213E-14,
1.5631593242027E-14,
2.30557760383387E-14,
1.69842438724199E-14,
2.49500940741054E-14,
1.09638860490424E-14,
1.89188942290031E-14,
1.33738506380432E-14,
2.68244627898984E-14,
1.49836740237497E-14,
2.79602729857942E-14,
1.83295219280399E-14,
3.73720152047063E-14,
1.49368364898983E-14,
3.69175176540004E-14,
1.75688456838241E-14,
4.53794987698153E-14,
1.57018495428041E-14,
4.78640564682831E-14,
1.59464455529168E-14,
4.52138326778595E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.01537701857612E-14,
  0,
1.07101827406808E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.02699966586517E-14,
1.71288764422295E-14,
1.00000000000001,
1.9263453679419E-14,
1.28055118592263E-14,
1.94974245082413E-14,
  0,
2.07529306239795E-14,
1.35308431126191E-14,
1.80532672144906E-14,
  0,
1.78893358460108E-14,
1.41661855856956E-14,
2.30883021035133E-14,
1.26530730337748E-14,
2.06310662997922E-14,
1.65462261947358E-14,
2.71189320999454E-14,
1.8022475872792E-14,
2.9547111285444E-14,
1.52317394808144E-14,
3.09448647262123E-14,
1.33964020432309E-14,
3.4552655875375E-14,
1.32754050807815E-14,
4.65382940517678E-14,
1.77666041600855E-14,
4.75821639034368E-14,
1.66754630936961E-14,
4.62416563373758E-14,
1.47668335892526E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.18386203618037E-14,
  0,
1.57805626205265E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.72236357121047E-14,
1.48067322292E-14,
1.93206995541262E-14,
1.00000000000001,
1.94596942726388E-14,
1.03712611415618E-14,
2.09641332071797E-14,
1.46542934037486E-14,
2.04680022930503E-14,
  0,
1.38686805095656E-14,
  0,
1.79240303155304E-14,
  0,
1.88213160334794E-14,
1.81868409221408E-14,
2.88926868541317E-14,
2.1166228492131E-14,
2.98372437868011E-14,
1.83290882471709E-14,
3.25225957276132E-14,
1.03146657881581E-14,
2.81064234386452E-14,
1.17375727193281E-14,
4.41547839957757E-14,
1.3463188897056E-14,
4.86806775445991E-14,
1.87172326249208E-14,
4.59189977708441E-14,
1.54902132787349E-14,
4.24157237111089E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.74677980413485E-14,
  0,
1.41958927252217E-14,
  0,
  0,
  0,
  0,
  0,
1.68769078573439E-14,
1.40076752280782E-14,
1.93105080537048E-14,
1.28089813061782E-14,
1.94477680487415E-14,
1.00000000000001,
2.10454483701161E-14,
1.54865269913484E-14,
2.07277771335779E-14,
  0,
1.62018835847544E-14,
  0,
1.39064107451681E-14,
  0,
1.3684799821112E-14,
1.52924548024735E-14,
2.70191855000768E-14,
2.28727627116232E-14,
3.15697988584329E-14,
2.14338095883004E-14,
3.28062230159354E-14,
1.33838252980301E-14,
2.969543014264E-14,
  0,
3.769814321819E-14,
1.19231881312576E-14,
4.63188515320567E-14,
1.44081795105944E-14,
4.70548079667399E-14,
1.75298144056146E-14,
4.20748505480795E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.55405202595382E-14,
  0,
1.58952712103755E-14,
  0,
1.27515185910365E-14,
  0,
1.09040380891212E-14,
  0,
1.46428008607202E-14,
1.27781899644797E-14,
1.90583226283847E-14,
1.2119211884043E-14,
1.94688015708877E-14,
1.03365666720423E-14,
2.1051953583151E-14,
1.00000000000001,
2.07451243683376E-14,
1.00032829242203E-14,
1.65011233843604E-14,
  0,
1.63120385254789E-14,
  0,
  0,
  0,
2.18592505207837E-14,
1.99428147606984E-14,
2.96897922913431E-14,
2.31039146147971E-14,
3.45296707893183E-14,
1.64933171287185E-14,
2.99682154092373E-14,
1.17605578053848E-14,
3.92494196865822E-14,
  0,
3.98262152423445E-14,
1.28408568500493E-14,
4.46474454629531E-14,
1.32194602486813E-14,
4.31972166370365E-14,
  0,
4.07326082585424E-14,
  0,
  0,
1.07531171467112E-14,
  0,
1.02079802943855E-14,
  0,
  0,
  0,
1.50270421106491E-14,
  0,
1.40174330476306E-14,
  0,
1.45133471213255E-14,
1.13830386089253E-14,
1.59911146824232E-14,
1.59078479555763E-14,
1.85981872263818E-14,
1.43710997962954E-14,
1.66568148163293E-14,
1.10807630432364E-14,
1.92552137429081E-14,
  0,
2.09678194945662E-14,
1.5486310150914E-14,
2.07381854744337E-14,
1.00000000000001,
1.65197716617271E-14,
  0,
1.64902813626355E-14,
  0,
1.20225010502573E-14,
  0,
1.77900229270112E-14,
1.39541156407574E-14,
2.45688885902595E-14,
2.01713645786583E-14,
3.26661440952503E-14,
1.81508454100143E-14,
3.16842906078474E-14,
1.48765548491081E-14,
3.95308785705595E-14,
1.19821687294408E-14,
4.14182577124222E-14,
  0,
3.81803963445115E-14,
1.16486681411843E-14,
4.08011298358435E-14,
  0,
4.18341576657877E-14,
  0,
  0,
  0,
  0,
1.16537638913949E-14,
  0,
1.32997996296624E-14,
  0,
1.3160479650498E-14,
  0,
1.35210852930667E-14,
  0,
1.26229322133797E-14,
  0,
1.77397159462078E-14,
1.87488913283573E-14,
2.3708032065306E-14,
2.03914576196729E-14,
2.0714766707508E-14,
1.26457004590019E-14,
1.69248295933677E-14,
  0,
2.07600863583179E-14,
1.46822658197987E-14,
2.07273434527089E-14,
1.00024155624823E-14,
1.64091830401336E-14,
1.00000000000001,
1.64837761496006E-14,
  0,
1.2267530741239E-14,
  0,
2.01548847056365E-14,
1.23516648298239E-14,
2.04632318034914E-14,
1.41778949691584E-14,
2.7521821627241E-14,
1.5261663460775E-14,
2.98272691268142E-14,
1.65076285973953E-14,
4.12525916204665E-14,
1.50920942409982E-14,
4.1663287403404E-14,
1.29076437038744E-14,
3.97225655146549E-14,
  0,
3.42902789496335E-14,
  0,
3.94328666941668E-14,
  0,
3.26019593266391E-14,
  0,
  0,
  0,
  0,
1.48924926210436E-14,
  0,
1.91524313769564E-14,
  0,
1.16903015046077E-14,
  0,
1.21803608865712E-14,
  0,
1.59011259021069E-14,
1.70083131606491E-14,
2.54813531386233E-14,
2.32533176741656E-14,
2.58269967912117E-14,
1.87220031144797E-14,
2.08962621511821E-14,
  0,
1.83718058127669E-14,
1.35171821652458E-14,
2.04818800808582E-14,
  0,
1.65202053425961E-14,
  0,
1.64842098304696E-14,
  1,
1.22185248030426E-14,
  0,
2.0417261631378E-14,
1.35707417525666E-14,
2.2814649475178E-14,
1.26005976486265E-14,
2.34625686934553E-14,
  0,
2.46478185084165E-14,
1.36570442454964E-14,
3.93595746273068E-14,
1.66954124136698E-14,
4.33186472803548E-14,
1.60301459606327E-14,
3.99875445256104E-14,
1.16968067176426E-14,
3.58181366511001E-14,
  0,
3.29233168505638E-14,
  0,
3.0219316632385E-14,
  0,
  0,
  0,
  0,
1.27346050371457E-14,
  0,
2.08982137150926E-14,
  0,
1.77587979044436E-14,
  0,
1.03751642693828E-14,
  0,
1.54186559353509E-14,
1.37479003875507E-14,
2.36288853067146E-14,
2.15250994112237E-14,
2.76432522705594E-14,
2.15608780829157E-14,
2.60082753944513E-14,
1.60184365771698E-14,
2.24204335652622E-14,
1.51339444448562E-14,
1.80398231075518E-14,
  0,
1.62122919256102E-14,
  0,
1.65089296400023E-14,
  0,
1.22189584839116E-14,
1.00000000000001,
2.05569068711942E-14,
1.43496325932801E-14,
2.30809295287404E-14,
1.36965092045749E-14,
2.57962054495131E-14,
  0,
2.05508353390282E-14,
  0,
3.41558378802453E-14,
1.37797759314218E-14,
4.14555542671557E-14,
1.7650377687195E-14,
4.1661552679928E-14,
1.48032627822481E-14,
3.60896208750905E-14,
  0,
3.44529092755064E-14,
  0,
2.37301497896247E-14,
  0,
3.28873213384373E-14,
  0,
  0,
1.15438257911049E-14,
  0,
1.88797545305763E-14,
  0,
1.96106152150488E-14,
  0,
1.64861613943801E-14,
  0,
1.36652841820073E-14,
1.05627312452228E-14,
2.32305494285434E-14,
1.83024168737278E-14,
2.58211420994803E-14,
1.98346113838843E-14,
2.78165077777226E-14,
1.88596967903853E-14,
2.7522688988979E-14,
2.11425928847708E-14,
2.21276989786912E-14,
  0,
1.38621752965307E-14,
  0,
1.6306400674182E-14,
  0,
1.22380404421474E-14,
  0,
2.05577742329321E-14,
1.00000000000001,
2.28580175620774E-14,
1.44563180870527E-14,
2.60564139709096E-14,
  0,
2.29915912697276E-14,
  0,
3.01147995429574E-14,
  0,
3.63025581817666E-14,
1.47789766535844E-14,
3.97720051337203E-14,
1.64508164035571E-14,
3.77857467537268E-14,
  0,
3.47235261377588E-14,
  0,
2.52332876815586E-14,
  0,
2.63955524104631E-14,
  0,
  0,
  0,
  0,
1.80105496488947E-14,
  0,
1.77488232444567E-14,
  0,
1.83876351644852E-14,
  0,
1.98428513203952E-14,
1.35278073465361E-14,
2.14867186543177E-14,
1.51222350613933E-14,
2.54043747843768E-14,
1.66255897937617E-14,
2.60210689800866E-14,
1.71494762835067E-14,
2.93883840873921E-14,
2.40126928757745E-14,
2.72405795836983E-14,
1.56246543481231E-14,
1.78815295903689E-14,
  0,
1.39046760216921E-14,
  0,
1.19956128363796E-14,
  0,
2.0415526907902E-14,
1.43353211246033E-14,
2.29074571811427E-14,
1.00000000000001,
2.57988075347271E-14,
  0,
2.31446806164826E-14,
  0,
3.24076702973297E-14,
  0,
3.21977687567365E-14,
  0,
3.45869166640256E-14,
1.35919921151473E-14,
3.58688773127724E-14,
  0,
3.63875596320895E-14,
  0,
2.54943635646931E-14,
  0,
2.79164712180258E-14,
  0,
2.7671875207913E-14,
  0,
  0,
1.54734081450614E-14,
  0,
1.71402605650406E-14,
  0,
1.6680233583255E-14,
1.14665221762067E-14,
2.18297602216921E-14,
1.4999937056337E-14,
2.77065696774326E-14,
1.81445570374139E-14,
2.37147541187754E-14,
1.34720793548704E-14,
2.56682695931598E-14,
1.39647408220478E-14,
2.75912105662801E-14,
2.22708136654592E-14,
2.90661592017294E-14,
1.8472636614808E-14,
2.30418982505309E-14,
1.41319247970451E-14,
1.79244639963994E-14,
  0,
  0,
  0,
2.01262617682829E-14,
1.35325778360951E-14,
2.30939399548102E-14,
1.44975177696072E-14,
2.58135526842729E-14,
1.00000000000001,
2.3409225946569E-14,
  0,
3.28118608672323E-14,
  0,
3.45595947692789E-14,
  0,
3.04682494511876E-14,
  0,
3.06816204387328E-14,
  0,
3.44993131284888E-14,
  0,
2.71887547198535E-14,
  0,
2.81580314620555E-14,
  0,
2.92101412502355E-14,
  0,
  0,
1.45934696618721E-14,
  0,
1.49293554949081E-14,
  0,
1.61801995413047E-14,
  0,
2.01724487808308E-14,
1.90056304028019E-14,
2.97444360808363E-14,
1.96401055141404E-14,
2.99820931970451E-14,
1.65056770334848E-14,
2.39918761940627E-14,
1.08201208409708E-14,
2.72425311476088E-14,
1.91021243961531E-14,
2.72887181601567E-14,
1.67706560444403E-14,
2.48629242194376E-14,
1.69864122767649E-14,
2.30848326565614E-14,
  0,
1.36778609272081E-14,
  0,
1.77848187565832E-14,
1.23941655549853E-14,
2.28293946247238E-14,
1.37216626949765E-14,
2.60217195013901E-14,
  0,
2.34656044595383E-14,
1.00000000000001,
3.22719281853345E-14,
  0,
3.47716647142171E-14,
  0,
3.28621678480356E-14,
  0,
2.66128265258292E-14,
  0,
2.92764944231916E-14,
  0,
2.52436960224145E-14,
  0,
2.98294375311592E-14,
  0,
2.94504004516583E-14,
  0,
3.52977196083071E-14,
1.07100743204636E-14,
  0,
1.47533894823138E-14,
  0,
1.41579456491847E-14,
  0,
1.97704266152732E-14,
1.65395041412664E-14,
2.81669219198699E-14,
2.37045626183541E-14,
3.20971547951299E-14,
1.80157538193226E-14,
3.02763456666577E-14,
1.38675963073931E-14,
2.55748113658916E-14,
1.6003257746755E-14,
2.6929847241064E-14,
1.36017499346996E-14,
2.31247312965088E-14,
1.52937558450805E-14,
2.49401194141186E-14,
1.264223101205E-14,
1.88148108204444E-14,
1.52911537598666E-14,
2.18731283085916E-14,
1.39293958312248E-14,
2.0491421059976E-14,
1.25867198608187E-14,
2.57558731286966E-14,
  0,
2.3187615022513E-14,
  0,
3.22979490374742E-14,
1.00000000000001,
3.45235992571524E-14,
  0,
3.30295686634674E-14,
  0,
2.89880966453104E-14,
  0,
2.52510685971874E-14,
  0,
2.00629443614098E-14,
  0,
2.79398899849514E-14,
  0,
3.11248422868449E-14,
  0,
3.55345093627779E-14,
  0,
  0,
1.30022945535324E-14,
  0,
1.43097339533327E-14,
  0,
1.79214282303164E-14,
1.54310158401172E-14,
2.78880651211066E-14,
2.13204020410585E-14,
3.05859938071196E-14,
2.21196758826148E-14,
3.24293543407794E-14,
1.53746373271479E-14,
3.18944089888751E-14,
1.90589731496882E-14,
2.52666811084712E-14,
1.04946433487907E-14,
2.28057590173636E-14,
1.21413296083617E-14,
2.32075643424867E-14,
1.09625850064354E-14,
2.0645377768469E-14,
1.81799020282369E-14,
2.70391348200505E-14,
1.99432484415674E-14,
2.45623833772246E-14,
1.41570782874467E-14,
2.34469561821715E-14,
  0,
2.2963835694112E-14,
  0,
3.27832379298787E-14,
  0,
3.45097214693446E-14,
1.00000000000001,
3.32598532049033E-14,
  0,
2.92218506336983E-14,
  0,
2.75907768854111E-14,
  0,
1.60210386623838E-14,
  0,
2.27062292579294E-14,
  0,
2.92196822293533E-14,
  0,
3.71833640266939E-14,
  0,
3.29749248739741E-14,
  0,
  0,
1.31843320982927E-14,
  0,
1.82245711577433E-14,
1.55463749512696E-14,
2.61672194329376E-14,
2.0303854084136E-14,
3.0403414161273E-14,
1.98029526804477E-14,
3.1003628483961E-14,
1.95169401473461E-14,
3.41027119737936E-14,
2.05907339789757E-14,
3.16485119361554E-14,
1.35585986882347E-14,
2.11584222364891E-14,
  0,
2.28922783507279E-14,
  0,
1.89293025698589E-14,
1.65358178538799E-14,
2.88788090663239E-14,
2.28584512429464E-14,
2.96832870783081E-14,
2.01843750047281E-14,
2.7521821627241E-14,
  0,
2.05352228277444E-14,
  0,
3.24068029355917E-14,
  0,
3.47681952672652E-14,
  0,
3.3287608780519E-14,
1.00000000000001,
2.91138640973188E-14,
  0,
2.7900858706742E-14,
  0,
1.83368945028128E-14,
  0,
1.86530478563096E-14,
  0,
2.39756131614755E-14,
  0,
3.52656272240015E-14,
  0,
3.46714844334794E-14,
  0,
  0,
  0,
  0,
1.7425297316187E-14,
1.72657027563972E-14,
2.66529420062112E-14,
2.05449806472968E-14,
2.87636667956059E-14,
1.88356275021562E-14,
3.08975935114919E-14,
1.72548607346723E-14,
3.27147163525776E-14,
2.4761009215224E-14,
3.38578991232463E-14,
1.50923110814327E-14,
2.75413372663458E-14,
1.21118393092701E-14,
2.12477604955019E-14,
  0,
1.8624858599825E-14,
1.33946673197549E-14,
2.71128605677795E-14,
2.11627590451791E-14,
3.15767377523368E-14,
2.31039146147971E-14,
3.26713482656782E-14,
1.52764086103208E-14,
2.46486858701545E-14,
  0,
3.01065596064465E-14,
  0,
3.45639315779689E-14,
  0,
3.29996446835068E-14,
  0,
2.91138640973188E-14,
0.999999999999998,
2.80036410726936E-14,
  0,
1.85064637225896E-14,
  0,
2.10434968062057E-14,
  0,
1.98495733738646E-14,
  0,
3.00332675395865E-14,
  0,
3.27151500334466E-14,
  0,
2.46603952536173E-14,
  0,
  0,
1.02309653804422E-14,
1.81845640975786E-14,
2.61294891973352E-14,
2.24132778309238E-14,
2.94265480038636E-14,
1.91372525465416E-14,
2.93812283530537E-14,
1.63248321111142E-14,
3.26863102556585E-14,
2.25130244307925E-14,
3.25206441637027E-14,
1.92729946585368E-14,
2.97867199655633E-14,
1.36570442454964E-14,
2.76558290157602E-14,
  0,
1.70085300010836E-14,
1.02778029142936E-14,
2.68335700881472E-14,
1.80393894266828E-14,
2.98307385737662E-14,
2.14403148013353E-14,
3.45448496197331E-14,
1.81595190273942E-14,
2.98359427441941E-14,
1.36431664576886E-14,
3.41692819871842E-14,
  0,
3.21838909689287E-14,
  0,
3.28101261437563E-14,
  0,
2.92496062093139E-14,
  0,
2.79485636023313E-14,
0.999999999999998,
1.85658780016418E-14,
  0,
2.11935503868776E-14,
  0,
2.22725483889352E-14,
  0,
2.5951029519744E-14,
  0,
2.74689125612237E-14,
  0,
2.27456942170079E-14,
  0,
  0,
  0,
1.47838555633606E-14,
1.92843787813479E-14,
2.35813972515597E-14,
2.91264408425196E-14,
2.11382560760809E-14,
3.01603360342018E-14,
1.66867387962899E-14,
3.12330456636589E-14,
2.16157387128435E-14,
3.25388587602005E-14,
1.71000366644414E-14,
2.84780879433733E-14,
1.78615802703952E-14,
2.99437124401392E-14,
  0,
2.34148637978659E-14,
1.33786211276021E-14,
2.52198435746198E-14,
1.49676278315969E-14,
2.9547544966313E-14,
1.8322149353267E-14,
3.28118608672323E-14,
1.65041591504433E-14,
3.16903621400133E-14,
1.64911487243735E-14,
3.93725850533766E-14,
1.37728370375179E-14,
3.62878130322208E-14,
  0,
3.04821272389955E-14,
  0,
2.90011070713803E-14,
  0,
2.78696336841744E-14,
  0,
1.85650106399038E-14,
0.999999999999994,
2.08821675229398E-14,
  0,
2.25331905912007E-14,
  0,
2.83562236191859E-14,
  0,
2.34473898630405E-14,
-1.34722961953049E-14,
1.74682317222175E-14,
  0,
2.66861185926892E-14,
  0,
1.66125793676919E-14,
1.70392129225649E-14,
2.05691583557432E-14,
2.25926048702529E-14,
2.24911235469083E-14,
3.00306654543725E-14,
1.87558302222612E-14,
3.21253440516145E-14,
2.20153756336217E-14,
3.11551999476745E-14,
1.62257360325491E-14,
2.85437905950259E-14,
1.56756118502299E-14,
2.86431035140255E-14,
1.35876553064573E-14,
2.57033977435484E-14,
1.49385712133743E-14,
3.16469940531139E-14,
1.80120675319362E-14,
2.79498646449383E-14,
1.52239332251725E-14,
3.25056821737224E-14,
1.33725495954362E-14,
2.99617101962024E-14,
1.48548708056584E-14,
4.12569284291564E-14,
1.67084228397396E-14,
4.14824424810334E-14,
1.47885176327023E-14,
3.45869166640256E-14,
  0,
2.65989487380214E-14,
  0,
2.76150630140748E-14,
  0,
1.85051626799826E-14,
  0,
2.08786980759879E-14,
0.999999999999995,
2.26728358310169E-14,
  0,
2.85383695841634E-14,
  0,
2.58061801095E-14,
-1.50582671332167E-14,
1.34159176823356E-14,
-1.02921143829704E-14,
2.14199318004926E-14,
  0,
1.2686086989927E-14,
1.76372588409079E-14,
2.32296820668054E-14,
2.0771904161998E-14,
1.97600182744173E-14,
2.3707164703568E-14,
2.02739301041754E-14,
3.21509312228851E-14,
2.41881167872826E-14,
3.21327166263874E-14,
1.66702589232681E-14,
2.72093545611307E-14,
1.48396919752436E-14,
2.87311407304314E-14,
1.14242382914798E-14,
2.44396516912992E-14,
1.91643576008538E-14,
3.39511405100801E-14,
1.95910995759441E-14,
3.43917602729782E-14,
1.82987305863413E-14,
3.09374921514394E-14,
1.02999206386123E-14,
2.96880575678671E-14,
1.1743644251494E-14,
3.95334806557734E-14,
1.5105972028806E-14,
4.33464028559705E-14,
1.76391019846012E-14,
3.97858829215281E-14,
1.35677059864836E-14,
3.06399870753093E-14,
  0,
2.5209001552895E-14,
  0,
1.8324751438481E-14,
  0,
2.11727337051659E-14,
  0,
2.25596451242094E-14,
  1,
2.84498986868886E-14,
  0,
2.5956667371041E-14,
-1.38149040818103E-14,
1.57009821810661E-14,
-1.18585696817775E-14,
1.735070420672E-14,
-1.473777697103E-14,
2.39053568606984E-14,
1.38606032033806E-14,
2.20378186185921E-14,
2.22264697966046E-14,
2.29347790758894E-14,
2.21686818208111E-14,
1.77043709553848E-14,
2.59616547010344E-14,
2.58037948647205E-14,
3.22407031627669E-14,
1.89015469942433E-14,
2.82491044445443E-14,
1.5332353442421E-14,
2.74632747099268E-14,
1.06379748759933E-14,
2.45838505802398E-14,
1.70163362567255E-14,
3.27216552464815E-14,
2.38264269425414E-14,
3.67028456238483E-14,
1.98621501190654E-14,
3.73685457577544E-14,
1.33959683623619E-14,
2.80925456508374E-14,
  0,
3.92745731769839E-14,
1.19752298355369E-14,
4.16563485095001E-14,
1.60266765136807E-14,
4.16684915738319E-14,
1.64464795948671E-14,
3.58671425892965E-14,
  0,
2.92604482310388E-14,
  0,
1.59937167676372E-14,
  0,
2.10495683383716E-14,
  0,
2.25063023773231E-14,
  0,
2.84355872182118E-14,
0.999999999999993,
2.5951896881482E-14,
-1.31821636939478E-14,
1.60505289614754E-14,
-1.07461782528073E-14,
1.97320458583672E-14,
-1.63233142280728E-14,
1.97957969461093E-14,
-1.44016742975595E-14,
1.27546627773367E-14,
2.1337640855601E-14,
2.2773232952189E-14,
2.40894543895864E-14,
2.11530012256267E-14,
2.46094377515105E-14,
2.33558831996827E-14,
2.6217526413741E-14,
2.05751214676919E-14,
2.84455618781987E-14,
1.75820729503284E-14,
2.85496452867573E-14,
1.11043986505965E-14,
2.33426559331784E-14,
1.62320244051495E-14,
3.29016328071141E-14,
2.16753698323302E-14,
3.552496838366E-14,
2.41438813386452E-14,
3.97039172372882E-14,
1.49455101072782E-14,
3.45595947692789E-14,
1.17271643784722E-14,
3.77011789842729E-14,
  0,
4.14078493715664E-14,
1.29076437038744E-14,
3.99875445256104E-14,
1.48032627822481E-14,
3.77853130728578E-14,
  0,
3.44988794476198E-14,
  0,
2.0044296084043E-14,
  0,
1.86422058345848E-14,
  0,
2.23063754967168E-14,
  0,
2.85253591580936E-14,
  0,
2.59050593476307E-14,
0.999999999999985,
1.59763695328774E-14,
  0,
1.99523557398162E-14,
-1.51215845400898E-14,
2.21337705108571E-14,
-1.60180028963008E-14,
1.96674274088871E-14,
1.07827700761287E-14,
1.62005825421474E-14,
2.42466637045968E-14,
2.15000543410393E-14,
2.68760708133087E-14,
2.69747332110049E-14,
2.50095083531576E-14,
1.82278237642608E-14,
2.25130244307925E-14,
1.92972807872005E-14,
2.88072517229399E-14,
1.33935831175824E-14,
2.44754303629913E-14,
1.67244690318924E-14,
3.16912295017513E-14,
2.09255356098392E-14,
3.57075480295066E-14,
2.20110388249317E-14,
3.85329788910038E-14,
1.92159656242641E-14,
3.68958336105507E-14,
1.32541547182008E-14,
4.41690954644525E-14,
1.19357648764584E-14,
3.98357562214624E-14,
  0,
3.97442495581046E-14,
1.16968067176426E-14,
3.61030649820293E-14,
  0,
3.63884269938275E-14,
  0,
2.52419612989385E-14,
  0,
2.27062292579294E-14,
  0,
1.98500070547336E-14,
  0,
2.83423458313781E-14,
  0,
2.60156479692242E-14,
-1.32307359512751E-14,
1.59750684902704E-14,
0.999999999999989,
1.97862559669915E-14,
-1.43921333184416E-14,
2.24494901834849E-14,
-1.49138514038416E-14,
2.20036662501588E-14,
-1.46323925198644E-14,
  0,
1.61600333808964E-14,
1.5724509368209E-14,
2.75899095236731E-14,
2.76328439297036E-14,
2.74858261151145E-14,
2.20071356971108E-14,
2.14043192892088E-14,
1.701655309716E-14,
2.29488737041317E-14,
1.51363296896356E-14,
2.48004741743024E-14,
1.90310007336381E-14,
3.28474226984898E-14,
2.14498557804532E-14,
3.45439822579952E-14,
2.12902612206634E-14,
3.87303036863962E-14,
1.7125623835712E-14,
3.5752650839882E-14,
1.75827234716319E-14,
4.65348246048158E-14,
1.34840055787677E-14,
4.63158157659738E-14,
1.28703471491409E-14,
3.81877689192844E-14,
  0,
3.5825075545004E-14,
  0,
3.47196230099378E-14,
  0,
2.71683717190108E-14,
  0,
2.79463951979864E-14,
  0,
2.39686742675715E-14,
  0,
2.5950595838875E-14,
  0,
2.57827613425743E-14,
-1.3836154444391E-14,
1.60505289614754E-14,
  0,
1.98552112251615E-14,
0.999999999999985,
2.24733426312795E-14,
-1.398317225898E-14,
2.22556348350444E-14,
-1.34952812813616E-14,
2.32509324293861E-14,
  0,
  0,
2.0416827950509E-14,
2.23189522419176E-14,
2.85561504997922E-14,
2.28560659981669E-14,
2.40313411531412E-14,
2.0865253969049E-14,
2.19052206928971E-14,
1.28688292660994E-14,
1.89980409875945E-14,
2.08173322330252E-14,
3.32370849592811E-14,
2.3781324132166E-14,
3.57344362433842E-14,
2.18267244556092E-14,
3.76022997461423E-14,
1.63935705288498E-14,
3.59950784456498E-14,
1.55001879387218E-14,
4.53821008550293E-14,
1.77557621383606E-14,
4.86806775445991E-14,
1.44077458297254E-14,
4.4649180186429E-14,
1.16486681411843E-14,
3.42764011618257E-14,
  0,
3.44628839354932E-14,
  0,
2.54856899473133E-14,
  0,
2.98363764250631E-14,
  0,
2.92209832719603E-14,
  0,
3.00406401143594E-14,
  0,
2.34265731813288E-14,
-1.50448230262779E-14,
1.57283040758127E-14,
-1.07166879537157E-14,
1.99215643981177E-14,
-1.43921333184416E-14,
2.24529596304368E-14,
0.999999999999984,
2.24195662035243E-14,
-1.27450133780016E-14,
2.34577982038964E-14,
-1.88685872481997E-14,
  0,
1.40100604728577E-14,
1.40340213408696E-14,
2.19011007246417E-14,
1.78303552478276E-14,
2.53310827175168E-14,
2.18473242968864E-14,
2.464846902972E-14,
1.68014473861389E-14,
1.80218253514886E-14,
1.85979703859473E-14,
2.74660936355753E-14,
2.56121079206251E-14,
3.61559740480466E-14,
2.41694685099159E-14,
3.88387239036447E-14,
1.69638608715772E-14,
3.48917943149285E-14,
1.47815787387984E-14,
4.56388399294738E-14,
1.56819002228303E-14,
4.75956080103757E-14,
1.87176663057897E-14,
4.70509048389189E-14,
1.32263991425852E-14,
4.07907214949876E-14,
  0,
3.29046685731971E-14,
  0,
2.52406602563315E-14,
  0,
2.81580314620555E-14,
  0,
3.11304801381418E-14,
  0,
3.52508820744557E-14,
  0,
2.74923313281494E-14,
-1.34584184074971E-14,
1.34241576188465E-14,
-1.18446918939696E-14,
1.97190354322974E-14,
-1.51363296896356E-14,
2.24208672461312E-14,
-1.39723302372552E-14,
2.24707405460656E-14,
0.999999999999986,
2.3338102284054E-14,
-1.80051286380323E-14,
2.16020777654702E-14,
  0,
  0,
1.62563105338132E-14,
  0,
1.89574918263435E-14,
1.69851112341579E-14,
2.60592328965581E-14,
1.7873289653858E-14,
2.08129954243352E-14,
2.25984595619844E-14,
2.65323787246308E-14,
2.34313436708877E-14,
3.0442228599048E-14,
2.60325615231149E-14,
3.92784763048049E-14,
1.93265542458576E-14,
3.61420962602388E-14,
1.5332353442421E-14,
4.45854290986869E-14,
1.49832403428807E-14,
4.78744648091389E-14,
1.6678932540648E-14,
4.59337429203899E-14,
1.75120334899859E-14,
4.31902777431326E-14,
  0,
3.9418121544621E-14,
  0,
2.37062973418301E-14,
  0,
2.7896088217183E-14,
  0,
2.94495330899203E-14,
  0,
3.71846650693008E-14,
  0,
3.27116805864947E-14,
  0,
1.74708338074314E-14,
-1.02791039569006E-14,
1.73446326745541E-14,
-1.63371920158806E-14,
2.2138974681285E-14,
-1.48795906151911E-14,
2.22452264941886E-14,
-1.2716824121517E-14,
2.34525940334684E-14,
0.99999999999998,
2.13379661162527E-14,
-1.2941904492525E-14,
  0,
1.23552426969931E-14,
  0,
1.37129890775967E-14,
  0,
1.98786299920872E-14,
1.30841518175551E-14,
2.23451899344917E-14,
2.37225603744173E-14,
2.93907693321716E-14,
2.74756346146932E-14,
2.95592543497758E-14,
2.39066579033054E-14,
3.36115683896576E-14,
2.12148007494584E-14,
3.66338903656782E-14,
1.77149961366752E-14,
4.58543793213639E-14,
1.55504949195251E-14,
4.6821487659221E-14,
1.59360372120609E-14,
4.62351511243408E-14,
1.55010553004598E-14,
4.20618401220096E-14,
  0,
4.18380607936086E-14,
  0,
3.0221051355861E-14,
  0,
2.63990218574151E-14,
  0,
2.92075391650215E-14,
  0,
3.5524101021922E-14,
  0,
3.46584740074096E-14,
  0,
2.27244438544272E-14,
  0,
2.14407484822043E-14,
-1.46952762458685E-14,
1.98170473086901E-14,
-1.59759358520084E-14,
2.19793801214951E-14,
-1.34740309187809E-14,
2.34582318847654E-14,
-1.80307158093029E-14,
2.13869720544491E-14,
0.999999999999986,
2.32899637075956E-14,
  0,
  0,
1.04032451056502E-14,
  0,
1.48275489109118E-14,
  0,
1.62788619390009E-14,
1.90071482858434E-14,
3.10283482934937E-14,
2.86754127387656E-14,
3.25108863441503E-14,
2.79659108370911E-14,
3.27862736959617E-14,
1.91066780452775E-14,
3.09995085157055E-14,
1.96192888324287E-14,
4.63626532998251E-14,
1.79647963172158E-14,
4.81268670748936E-14,
1.65215063852031E-14,
4.52207715717634E-14,
1.47742061640255E-14,
4.2405749051122E-14,
  0,
4.07434502802673E-14,
  0,
3.26158371144469E-14,
  0,
3.28868876575683E-14,
  0,
2.76701404844371E-14,
  0,
3.52864439057132E-14,
  0,
3.29744911931051E-14,
  0,
2.46499869127614E-14,
  0,
2.66878533161652E-14,
  0,
2.38914790728906E-14,
-1.43912659567036E-14,
1.96535496210792E-14,
-1.4585554986013E-14,
2.3263942855456E-14,
-1.88338927786802E-14,
2.1616389234147E-14,
-1.28868270221627E-14,
2.32890963458576E-14,
0.99999999999999,
  0,
0.999999999999999,
  0,
  0,
  0,
  0,
  0,
-1.08742767394865E-14,
-1.22127785315285E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.46022516994693E-14,
  0,
1.2994705138325E-14,
  0,
  0,
  0,
  0,
1.66146393518196E-14,
1.763205467048E-14,
2.20431312092373E-14,
2.1337640855601E-14,
1.62057867125753E-14,
1.61521187050373E-14,
  0,
1.40057236641677E-14,
  0,
1.23663015591524E-14,
  0,
0.999999999999999,
  0,
0.894427190999913,
  0,
  0,
  0,
-1.47697067250097E-14,
-1.73942349239453E-14,
-1.60193039389078E-14,
-1.59263878127258E-14,
  0,
  0,
  0,
  0,
1.02097150178615E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.11834369889707E-14,
  0,
1.35084001276486E-14,
  0,
1.3459719450104E-14,
  0,
1.39586692898819E-14,
  0,
1.99809786771699E-14,
  0,
2.39034052967879E-14,
  0,
1.60633225471107E-14,
  0,
1.1297386637299E-14,
1.97409363161816E-14,
2.17822721665373E-14,
3.34797294054834E-14,
3.3733866394714E-14,
3.31290984229016E-14,
3.2460579363347E-14,
2.00043974440955E-14,
2.61327418038526E-14,
1.45675572299497E-14,
2.28348156355862E-14,
1.50153327271862E-14,
1.52918042811701E-14,
  0,
0.894427190999913,
  0,
0.878310065653673,
  0,
-1.38939424201845E-14,
-1.63758980334383E-14,
-1.75535584331921E-14,
-1.86137997376656E-14,
-1.15439342113222E-14,
-1.24047907362757E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.52768422911898E-14,
  0,
1.73346580145672E-14,
  0,
1.79971055419559E-14,
  0,
2.33972997226717E-14,
  0,
2.61565942516473E-14,
  0,
2.41855147020686E-14,
1.25047541765788E-14,
2.02917110198042E-14,
2.14656851321715E-14,
2.36497019884263E-14,
3.29144263927494E-14,
3.40196620873812E-14,
3.98366235832004E-14,
4.02594624304697E-14,
3.33470230595712E-14,
3.86511569278047E-14,
2.57936033642991E-14,
3.17404522803821E-14,
1.75523658108023E-14,
2.30731232730985E-14,
1.16727374294134E-14,
  0,
  0,
0.878310065653673,
  0,
0.872871560943955,
-1.69002182040523E-14,
-1.63709107034449E-14,
-1.68925203686277E-14,
-1.22560381982106E-14,
-1.43702324345574E-14,
  0,
-1.02144855074204E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.83659511210355E-14,
  0,
2.11352203099979E-14,
  0,
2.66336432075409E-14,
  0,
2.85550662976197E-14,
  0,
2.5314602844495E-14,
1.07166879537157E-14,
2.74949334133634E-14,
2.38426899751287E-14,
3.18068054533382E-14,
3.35612614088543E-14,
3.46918674343222E-14,
3.76573772165045E-14,
3.88601911066599E-14,
3.84631562710958E-14,
4.47714781914854E-14,
3.79321140470124E-14,
4.2856343474007E-14,
2.79047618345629E-14,
3.08266866894114E-14,
1.35132790374248E-14,
2.20756572744119E-14,
  0,
  0,
  0,
0.872871560943955,
-1.67462614955594E-14,
0.870388279778472,
-1.67069049566981E-14,
-1.06542379085806E-14,
-1.2508332043748E-14,
  0,
-1.19960465172486E-14,
  0,
-1.05202305200613E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.21677841413703E-14,
  0,
2.17582028783081E-14,
  0,
2.92606650714733E-14,
  0,
3.11946649067529E-14,
  0,
2.71037532695306E-14,
  0,
2.80723794904292E-14,
2.16985717588214E-14,
3.83803232251179E-14,
3.53866241864509E-14,
4.21964980318323E-14,
3.75305255623237E-14,
3.87569750598393E-14,
3.5412428198156E-14,
4.24521529041044E-14,
4.22448534487252E-14,
4.80050027507062E-14,
3.93949196181298E-14,
4.11459061266939E-14,
2.33992512865822E-14,
2.92522082945279E-14,
  0,
  0,
  0,
-1.38948097819225E-14,
-1.68726794688712E-14,
0.870388279778472,
-1.73292370037048E-14,
0.869048189253471,
-1.2306778859883E-14,
  0,
  0,
  0,
-1.20686880628051E-14,
  0,
-1.49062619886342E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.53351723680695E-14,
  0,
2.96069592453652E-14,
  0,
3.34849335759113E-14,
1.10029173272519E-14,
2.93877335660886E-14,
1.04373974740835E-14,
2.95085136881035E-14,
2.01746171851758E-14,
3.85694080839993E-14,
3.28747445932365E-14,
4.83246255511549E-14,
3.88981381826969E-14,
4.57416222954254E-14,
3.48258748228414E-14,
4.18675510927002E-14,
3.86951755360077E-14,
4.51652604205321E-14,
4.31620884866479E-14,
4.57303465928316E-14,
3.45058183415237E-14,
3.9120182787622E-14,
1.9374259141447E-14,
2.70538799695963E-14,
  0,
-1.47488900432979E-14,
-1.63754643525693E-14,
-1.63580086975923E-14,
-1.67397562825244E-14,
0.869048189253471,
-1.23709636284941E-14,
0.868243142124454,
  0,
  0,
-1.00008976794408E-14,
  0,
-1.64326018070593E-14,
-1.3649454830289E-14,
-1.66420696667835E-14,
  0,
  0,
  0,
  0,
  0,
1.08691267791672E-14,
  0,
1.10751251919394E-14,
  0,
1.19097440243188E-14,
  0,
2.29948438762451E-14,
  0,
3.35677666218892E-14,
  0,
3.14045664473461E-14,
1.37047491410858E-14,
3.15585231558391E-14,
2.10799259992012E-14,
3.97798113893622E-14,
3.11573683520194E-14,
4.81368417348804E-14,
3.60792125342346E-14,
5.15048073634894E-14,
3.5826376587611E-14,
4.84950621326696E-14,
3.77853130728578E-14,
4.41582534427276E-14,
3.92919204117437E-14,
4.24942199483969E-14,
3.7996081975189E-14,
4.34010466454637E-14,
3.02431690801797E-14,
3.66802942186606E-14,
2.11779378755939E-14,
-1.08742767394865E-14,
-1.73719545693007E-14,
-1.75467279595054E-14,
-1.69200591038088E-14,
-1.0711158522636E-14,
-1.22543034747347E-14,
0.868243142124454,
  0,
0.867721831274621,
  0,
  0,
-1.41247690627067E-14,
-1.41054702640364E-14,
-1.80413409905933E-14,
-1.5030511557601E-14,
-1.04861865718453E-14,
  0,
  0,
  0,
1.12121683465416E-14,
  0,
1.33703811910912E-14,
  0,
1.41043860618639E-14,
  0,
1.94345407822372E-14,
  0,
2.6778926298654E-14,
  0,
3.13160955500713E-14,
1.25017184104959E-14,
3.33921258699466E-14,
2.42631435776186E-14,
4.16151488269456E-14,
3.19102383405934E-14,
4.90588472623621E-14,
3.41558378802453E-14,
5.10594171110323E-14,
3.28309428254681E-14,
5.39650789332935E-14,
3.86132098517677E-14,
5.05238212378245E-14,
3.81287883211012E-14,
4.12547600248114E-14,
3.388218525191E-14,
3.98986399474666E-14,
3.35560572384264E-14,
4.06810002351321E-14,
3.19453664909819E-14,
4.1059169952895E-14,
-1.22127785315285E-14,
-1.59911146824232E-14,
-1.86441573984952E-14,
-1.22846611355643E-14,
-1.2508765724617E-14,
  0,
  0,
0.867721831274621,
-1.02587209560578E-14,
0.867364964374359,
-1.3765898143614E-14,
-1.24182348432145E-14,
-1.57725395244501E-14,
-1.55305455995514E-14,
-1.18223573292164E-14,
-1.21114056284011E-14,
  0,
  0,
  0,
  0,
1.36743914802562E-14,
  0,
1.63135564085204E-14,
  0,
2.15712864237716E-14,
  0,
2.31325375521507E-14,
  0,
2.43954162426618E-14,
  0,
3.31783212015324E-14,
2.29581978428151E-14,
4.32839528108353E-14,
3.49360297635659E-14,
5.07233144375618E-14,
3.47720983950861E-14,
5.17767252683488E-14,
3.07757291873045E-14,
5.32633832872609E-14,
3.53992009316517E-14,
5.57410020918248E-14,
3.87988252636973E-14,
4.74147630880051E-14,
3.25533870693118E-14,
3.84622889093578E-14,
2.92782291466676E-14,
3.69977486147643E-14,
3.50938895998798E-14,
4.48864036217689E-14,
4.13709864977019E-14,
  0,
-1.59602149205074E-14,
-1.15160702154893E-14,
-1.43445368430695E-14,
  0,
  0,
  0,
  0,
0.867364964374359,
-1.36501053515925E-14,
0.867109969524107,
-1.56998979788936E-14,
-1.3796472644878E-14,
  0,
-1.24182348432145E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.65974005372771E-14,
  0,
2.37301497896247E-14,
  0,
2.51864501477073E-14,
  0,
2.07039246857832E-14,
  0,
2.61483543151364E-14,
1.82701076489877E-14,
4.29573911164827E-14,
3.34840662141733E-14,
5.22498710964214E-14,
3.76721223660503E-14,
5.32330256264313E-14,
3.12918094214076E-14,
5.38163263952285E-14,
3.32225566501698E-14,
5.48857834181682E-14,
3.5453844721145E-14,
5.24697472970015E-14,
3.30941871129475E-14,
4.44943561161981E-14,
2.78570569389736E-14,
3.5454712082883E-14,
3.07089423334794E-14,
4.10583025911571E-14,
4.43937421545915E-14,
5.51000217674513E-14,
  0,
  0,
-1.24185601038662E-14,
  0,
-1.1968724622502E-14,
  0,
-1.00280027337529E-14,
  0,
-1.38214092948452E-14,
0.867109969524107,
-1.57770931735746E-14,
0.866921446862997,
  0,
-1.07171216345847E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.07639591684361E-14,
  0,
2.39894909492833E-14,
1.00119565416001E-14,
2.72954402136261E-14,
  0,
2.26741368736239E-14,
  0,
2.2367090818376E-14,
1.4434634043603E-14,
3.58354838858599E-14,
2.87452353586737E-14,
5.17797610344317E-14,
3.61798264958413E-14,
5.46294780245926E-14,
3.40942551968482E-14,
5.51403540882678E-14,
3.36735847539238E-14,
5.52799993280839E-14,
3.31791885632704E-14,
5.14475614887822E-14,
2.96750471417973E-14,
4.94287770436141E-14,
2.83414784696401E-14,
4.13983083924485E-14,
2.92092738884975E-14,
3.94285298854768E-14,
3.99021093944185E-14,
5.11283723692024E-14,
4.91165268179383E-14,
  0,
  0,
  0,
-1.02143770872032E-14,
  0,
-1.21248497353399E-14,
  0,
-1.40944114018771E-14,
-1.23904792675988E-14,
-1.57276535545092E-14,
0.866921446862997,
  0,
0.866778142217527,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.81235235152677E-14,
  0,
2.74147024525995E-14,
1.17154549950094E-14,
2.47679481091279E-14,
  0,
2.43164863245049E-14,
1.46935415223926E-14,
3.19726883857285E-14,
2.48494801124988E-14,
4.45819596517349E-14,
3.13095903370364E-14,
5.40331668297256E-14,
3.25195599615302E-14,
5.64231820987526E-14,
3.64192183355261E-14,
5.65151224429794E-14,
3.35525877914744E-14,
5.17520054588161E-14,
2.73223284275037E-14,
4.83098804016091E-14,
2.48867766672323E-14,
4.62000229739523E-14,
2.9615632862745E-14,
4.52550323604139E-14,
3.83360877764805E-14,
4.9365025955872E-14,
4.45377242030975E-14,
5.66118332767651E-14,
  0,
  0,
  0,
  0,
-1.0507870615295E-14,
  0,
-1.63985578588433E-14,
-1.41124091579403E-14,
-1.57998614191968E-14,
-1.38487311895918E-14,
  0,
0.866778142217527,
  0,
0.866666666666659,
  0,
  0,
  0,
-1.02834407655905E-14,
  0,
  0,
1.03762484715553E-14,
  0,
2.1539627720335E-14,
1.0769163338864E-14,
2.48477453890228E-14,
1.43045297829048E-14,
2.63153214496992E-14,
2.02372840707454E-14,
3.38587664849843E-14,
2.50268555879174E-14,
4.06237543604249E-14,
2.73678649187481E-14,
4.6749930315837E-14,
2.7602919949743E-14,
5.57483746665977E-14,
3.4782940416811E-14,
5.76899639170847E-14,
3.62093167949329E-14,
5.28947545486158E-14,
2.76419512279524E-14,
4.85184808995953E-14,
2.24989298025502E-14,
4.49701040294848E-14,
2.6101950462154E-14,
4.996090346987E-14,
3.86513737682392E-14,
5.51347162369709E-14,
4.28780275174567E-14,
5.47582812426839E-14,
4.07790121115248E-14,
  0,
  0,
  0,
  0,
  0,
-1.48774222108461E-14,
-1.36201813716319E-14,
-1.80417746714623E-14,
-1.55357497699793E-14,
  0,
-1.0767428615388E-14,
  0,
0.86666666666666,
  0,
0.866578244826234,
  0,
  0,
  0,
  0,
  0,
  0,
1.37515866749371E-14,
  0,
1.89596602306885E-14,
1.33473961050345E-14,
2.64120322834849E-14,
2.45762611650324E-14,
3.58389533328118E-14,
3.05762359875672E-14,
4.25063630127287E-14,
2.74958007751014E-14,
4.27696073002082E-14,
2.36742049575245E-14,
4.83797030215172E-14,
2.98472184467879E-14,
5.69409970563317E-14,
3.45422475345192E-14,
5.40253605740837E-14,
3.02665878471053E-14,
4.95523760912775E-14,
2.2734418514414E-14,
4.50858968215062E-14,
2.37019605331401E-14,
4.86832796298131E-14,
3.50717718755611E-14,
5.97560195769731E-14,
4.31612211249099E-14,
6.04065408804644E-14,
3.91058713189452E-14,
5.52661215402761E-14,
  0,
1.02510231206332E-14,
  0,
  0,
  0,
  0,
-1.66696084019646E-14,
-1.50864563897013E-14,
-1.18223573292164E-14,
-1.24748301966182E-14,
  0,
  0,
  0,
0.866578244826234,
  0,
0.866506930318042,
  0,
  0,
1.12869782964431E-14,
  0,
1.24063086193171E-14,
  0,
1.1066234734125E-14,
  0,
2.04640991652294E-14,
2.3635173679315E-14,
3.58948981649121E-14,
3.48948300810115E-14,
4.44353755180149E-14,
3.30430127704062E-14,
4.45854290986869E-14,
2.37696147487032E-14,
4.43755275580937E-14,
2.58586554946483E-14,
4.95536771338845E-14,
2.96030561175442E-14,
5.32096068595056E-14,
2.85314306902595E-14,
5.06066542838024E-14,
2.53685961126848E-14,
4.60790260115029E-14,
2.39521943945498E-14,
4.87257803549745E-14,
3.26297149022547E-14,
5.84103078404841E-14,
3.95235059957866E-14,
6.49840424526982E-14,
3.93196759873593E-14,
6.08710130911572E-14,
3.35768739201381E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.04879212953213E-14,
-1.2117477160567E-14,
  0,
  0,
  0,
  0,
  0,
0.866506930318042,
  0,
0.866448577718204,
1.14392002814601E-14,
  0,
1.46666533085149E-14,
  0,
  0,
  0,
1.26335573946701E-14,
1.58891996782096E-14,
2.99079337684471E-14,
3.38925935927659E-14,
4.44783099240453E-14,
3.73442596290907E-14,
4.64407158562441E-14,
2.92535093371349E-14,
4.6145812865328E-14,
2.59709788397178E-14,
4.5478378007946E-14,
2.55941101645618E-14,
4.5774582041469E-14,
2.3557544803765E-14,
4.97679154831676E-14,
2.35770604428698E-14,
4.70955739684253E-14,
2.65026715851047E-14,
4.96477858824562E-14,
3.28630352097736E-14,
5.84051036700561E-14,
3.70320094034149E-14,
6.35155990302838E-14,
3.56472663887164E-14,
6.53327218713695E-14,
3.37382032034039E-14,
6.70318835160888E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.866448577718204,
1.13598366824341E-14,
0.866400225443959,
1.4887396870833E-14,
  0,
1.20016843685455E-14,
  0,
1.11334552688191E-14,
  0,
2.20275186979535E-14,
2.62160085306995E-14,
3.84770340589036E-14,
3.63663092695088E-14,
4.64957933266064E-14,
3.35313374288937E-14,
4.8019747900252E-14,
3.14227810438439E-14,
4.72421581021454E-14,
2.56361772088542E-14,
4.1658083232976E-14,
1.95468641273067E-14,
4.22843184078037E-14,
1.86005724711613E-14,
4.62034924209043E-14,
2.47163400857175E-14,
5.05875723255667E-14,
3.5377516888202E-14,
5.92724654080445E-14,
3.71872671545148E-14,
6.34770014329433E-14,
3.31410246467989E-14,
6.38616763637412E-14,
3.00276296882895E-14,
7.14536936563537E-14,
3.25603259632157E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.03589012367955E-14,
  0,
  0,
1.16295861829485E-14,
0.866400225443959,
1.48613760186933E-14,
0.866359712001398,
1.21322223101128E-14,
  0,
1.35724764760425E-14,
  0,
2.064060727891E-14,
1.96453096845683E-14,
3.06074610101348E-14,
2.8644187716198E-14,
4.04880122484297E-14,
3.25668311762506E-14,
4.79390832586191E-14,
3.56867313477949E-14,
4.90471378788992E-14,
3.11222402016309E-14,
4.33676532185512E-14,
1.9598905831586E-14,
3.81660848758347E-14,
1.45482584312795E-14,
3.86934408125317E-14,
1.97008208357996E-14,
4.96794445858928E-14,
3.35790423244831E-14,
6.01528375721028E-14,
3.96809321512315E-14,
6.4324847531827E-14,
3.32576848005584E-14,
6.37515214230167E-14,
2.75127143289922E-14,
6.99097897627343E-14,
2.88241652768306E-14,
8.18529272139656E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.1290881424264E-14,
  0,
1.49116829994966E-14,
0.866359712001398,
1.13936637902157E-14,
0.866325429916351,
1.38092662305134E-14,
1.05865836930175E-14,
2.28701606264092E-14,
1.92870892867791E-14,
2.91433543964104E-14,
2.20860656152677E-14,
3.25945867518662E-14,
2.48143519621102E-14,
4.19842112464597E-14,
3.4703576817785E-14,
4.90029024302618E-14,
3.53111637152459E-14,
4.51687298674841E-14,
2.49947632036118E-14,
3.98270826040825E-14,
1.4583386581668E-14,
3.45222982145454E-14,
1.56727929245815E-14,
4.21195196775859E-14,
2.85774008623729E-14,
5.92013417455295E-14,
3.78854933535955E-14,
6.51783314820076E-14,
3.57244615833974E-14,
6.45252080933023E-14,
2.76228692697167E-14,
6.9787058076809E-14,
2.6253305085433E-14,
8.02960128942765E-14,
2.98710708945826E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.12392734008537E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.46805310963227E-14,
  0,
1.21317886292438E-14,
0.866325429916351,
1.43153718046296E-14,
0.866296163648431,
2.32335851946264E-14,
2.09619648028347E-14,
3.14475008533766E-14,
2.16350375115137E-14,
3.11248422868449E-14,
1.8252760414228E-14,
3.39862686604686E-14,
2.69506639227757E-14,
4.29608605634346E-14,
3.4332779674795E-14,
4.51362038023095E-14,
2.92188148676154E-14,
4.16723947016528E-14,
1.99857491667288E-14,
3.62106178375399E-14,
1.56693234776295E-14,
3.79700611230493E-14,
2.45086069494693E-14,
5.16305748154977E-14,
3.28456879750139E-14,
6.41678550572511E-14,
3.3883486294517E-14,
6.53539722339502E-14,
3.00775029882239E-14,
7.04939578932695E-14,
2.64085628365329E-14,
8.00791724597794E-14,
2.72941391710191E-14,
8.08398487039952E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.08654404917807E-14,
  0,
1.36540084794134E-14,
  0,
1.07656938919121E-14,
  0,
1.03771158332933E-14,
  0,
1.24201864071249E-14,
  0,
1.19986486024626E-14,
  0,
1.38088325496444E-14,
0.866296163648431,
2.30900368269893E-14,
0.866270980254385,
3.16951326295722E-14,
2.32201410876876E-14,
3.34467696594398E-14,
1.7799563906129E-14,
3.25841784110104E-14,
2.03912407792384E-14,
3.50344753208276E-14,
2.66666029535845E-14,
3.91058713189452E-14,
2.82187467837147E-14,
4.1510198056649E-14,
2.42462300237278E-14,
3.79670253569664E-14,
2.10842628078911E-14,
3.96007011904675E-14,
2.45263878650981E-14,
4.74321103227648E-14,
2.88189611064027E-14,
5.65832103394115E-14,
2.88232979150926E-14,
6.43460978944077E-14,
2.81658377176974E-14,
7.12563688609613E-14,
2.88198284681407E-14,
8.07453062745545E-14,
2.74042941117436E-14,
8.06342839720919E-14,
2.70946459712818E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.33669117441393E-14,
  0,
1.65952321329321E-14,
  0,
1.81105130891979E-14,
  0,
1.37515866749371E-14,
  0,
  0,
  0,
1.35742111995185E-14,
1.06277833755719E-14,
2.31780740433951E-14,
0.866270980254385,
3.12748958675169E-14,
0.866249154053996,
3.35894506653389E-14,
1.93660192049361E-14,
3.48072265454746E-14,
1.99206970363797E-14,
3.35677666218892E-14,
2.00291172536282E-14,
3.11200717972859E-14,
2.05538711051112E-14,
3.55084885106383E-14,
2.32171053216046E-14,
3.79310298448399E-14,
2.53122175997156E-14,
4.14056809672214E-14,
2.9917041066696E-14,
4.9063617751921E-14,
2.88146242977128E-14,
5.23669649310499E-14,
2.48030762595164E-14,
5.67133146001098E-14,
2.31177924026049E-14,
7.02216063075412E-14,
2.68856117924265E-14,
8.14938394544384E-14,
2.9845917404181E-14,
8.12423045504218E-14,
2.72325564876219E-14,
7.58993562444132E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.10755588728084E-14,
  0,
1.63499856015159E-14,
  0,
2.39756131614755E-14,
  0,
2.15535055081428E-14,
  0,
1.10835819688848E-14,
  0,
1.1147333056627E-14,
  0,
2.28731963924922E-14,
2.09294387376602E-14,
3.16951326295722E-14,
0.866249154053996,
3.35907517079459E-14,
0.866230113727935,
3.51485333893731E-14,
2.18098109017184E-14,
3.5901837058816E-14,
1.96600548341141E-14,
2.96646388009414E-14,
1.39172527668929E-14,
2.75383015002628E-14,
1.54585545752983E-14,
3.18330431459124E-14,
2.42969706854002E-14,
4.13085364525667E-14,
3.4109434027263E-14,
5.0858622868688E-14,
3.42061448610487E-14,
5.39984723602061E-14,
2.47813922160667E-14,
5.24996712769621E-14,
1.90975707470287E-14,
6.25966292688851E-14,
2.18722609468536E-14,
8.04226477080228E-14,
2.7896088217183E-14,
8.19561432607863E-14,
2.96108623731861E-14,
7.65099789079571E-14,
1.90134366584438E-14,
  0,
1.11764980950668E-14,
  0,
  0,
  0,
  0,
  0,
1.41186975305407E-14,
  0,
2.37171393635549E-14,
  0,
2.74225087082414E-14,
1.07904137014447E-14,
1.89600939115575E-14,
  0,
1.26214143303383E-14,
  0,
2.0645377768469E-14,
1.93243858415126E-14,
3.14800269185511E-14,
2.32205747685565E-14,
3.36172062409545E-14,
0.866230113727935,
3.48471251854221E-14,
0.866213404525584,
3.60644673846888E-14,
2.13284251371348E-14,
3.19527390657548E-14,
1.35295420700121E-14,
2.60893737169532E-14,
  0,
2.38645908590129E-14,
1.65106643634783E-14,
3.52226928179711E-14,
3.30690336225459E-14,
5.07571415453434E-14,
3.83183068608517E-14,
5.57687576674404E-14,
3.01720454176646E-14,
5.41068925774546E-14,
1.91097138113605E-14,
5.83474241144799E-14,
1.78468351208494E-14,
7.27421595181355E-14,
2.2809011623881E-14,
8.08641348326589E-14,
2.7674910973996E-14,
7.71795821696841E-14,
2.13856710118421E-14,
7.2030922892985E-14,
  0,
  0,
1.53045978668054E-14,
  0,
1.21682178222393E-14,
  0,
1.19060577369323E-14,
  0,
2.15721537855096E-14,
  0,
2.73067159162199E-14,
1.17310675062932E-14,
2.48468780272848E-14,
1.33391561685237E-14,
2.0492722102583E-14,
1.58952712103755E-14,
2.20413964857613E-14,
1.96375034289265E-14,
2.91828193554888E-14,
2.16363385541207E-14,
3.34996787254571E-14,
1.93573455875562E-14,
3.51485333893731E-14,
0.866213404525584,
3.58953318457811E-14,
0.866198660844067,
3.21435586481122E-14,
1.52256679486484E-14,
2.83688003643867E-14,
  0,
2.24997971642882E-14,
  0,
2.72676846380104E-14,
2.5278390491934E-14,
4.46960177202804E-14,
3.72792074987416E-14,
5.56733478762617E-14,
3.42972178435375E-14,
5.58988619281386E-14,
2.44804176929847E-14,
5.99589822236624E-14,
1.78390288652075E-14,
6.85207099393459E-14,
1.884690320475E-14,
7.31602278758459E-14,
2.2591303827646E-14,
7.61092577850064E-14,
1.94054841640146E-14,
7.26866483669042E-14,
1.37259995036665E-14,
  0,
1.35237957984979E-14,
  0,
1.83711552914634E-14,
  0,
1.53178251333097E-14,
  0,
1.94206629944293E-14,
  0,
2.51847154242313E-14,
  0,
2.47193758518005E-14,
1.42915193568349E-14,
2.64363184121486E-14,
2.36438472966949E-14,
2.99096684919231E-14,
2.6254172447171E-14,
3.06039915631828E-14,
2.21203264039183E-14,
3.11387200746527E-14,
1.78065028000329E-14,
3.48059255028677E-14,
2.17547334313561E-14,
3.60609979377369E-14,
0.866198660844068,
3.28205344846122E-14,
0.866185586048615,
2.87088061656782E-14,
1.01516017814163E-14,
2.4682512977936E-14,
  0,
2.5807047471238E-14,
1.8775779542235E-14,
3.66685848351977E-14,
2.95805047123565E-14,
4.95688559642993E-14,
3.32242913736458E-14,
5.5719318048375E-14,
2.86506929292329E-14,
6.16711542944515E-14,
2.32747848771808E-14,
7.01053798346507E-14,
1.88651178012478E-14,
6.89370435735803E-14,
1.85780210659736E-14,
6.83845341464817E-14,
1.43027950594288E-14,
7.15452003197115E-14,
1.17328022297691E-14,
6.35238389667947E-14,
  0,
  0,
1.73320559293533E-14,
  0,
2.1765141772212E-14,
  0,
2.29813997693062E-14,
  0,
2.31472827016965E-14,
  0,
2.26741368736239E-14,
  0,
2.6329632918376E-14,
2.45753938032944E-14,
3.59139801231478E-14,
3.39168797214295E-14,
3.84839729528075E-14,
2.87027346335123E-14,
3.26240770509578E-14,
1.8252760414228E-14,
3.25828773684034E-14,
1.9893375141633E-14,
3.5902270739685E-14,
2.13835026074971E-14,
3.22545809505748E-14,
0.866185586048615,
2.89017941523806E-14,
0.866173937428245,
2.46864161057569E-14,
1.12457786138886E-14,
2.81159644177631E-14,
1.83455681201927E-14,
3.51437628998141E-14,
2.29998312062385E-14,
4.15440251644306E-14,
2.54622711803876E-14,
4.96573268615741E-14,
2.75396025428698E-14,
6.15184986285655E-14,
2.74008246647917E-14,
7.17811227124443E-14,
2.4230617512444E-14,
7.05052335958634E-14,
1.86092460885412E-14,
6.41179817573168E-14,
1.02981859151363E-14,
6.38456301715884E-14,
  0,
6.23910645369818E-14,
  0,
  0,
1.34772835252983E-14,
  0,
2.11176562348037E-14,
  0,
2.96334137783738E-14,
  0,
2.67724210856191E-14,
  0,
2.06761691101676E-14,
  0,
2.43451092618585E-14,
2.02199368359857E-14,
3.58042588632923E-14,
3.49225856566271E-14,
4.44783099240453E-14,
3.63810544190546E-14,
4.04875785675607E-14,
2.48277960690491E-14,
3.39862686604686E-14,
2.03639188844917E-14,
3.3582078090566E-14,
1.96600548341141E-14,
3.19249834901392E-14,
1.52248005869104E-14,
2.87157450595821E-14,
0.866173937428245,
2.48642252620446E-14,
0.866163514845656,
2.84841594755392E-14,
1.99371769094014E-14,
3.7546354914042E-14,
2.25696197841962E-14,
4.00495608898765E-14,
1.89171595055271E-14,
4.16845377659847E-14,
1.97212038366423E-14,
5.54513032713366E-14,
2.62454988297911E-14,
7.16371406639382E-14,
2.83618614704828E-14,
7.2180109111919E-14,
2.40033687370911E-14,
6.56644877361501E-14,
1.03172678733721E-14,
5.95651999946156E-14,
  0,
5.4676749239313E-14,
  0,
5.67419375374634E-14,
  0,
  0,
1.8022042191923E-14,
  0,
2.92608819119078E-14,
  0,
3.35677666218892E-14,
  0,
2.44032224983037E-14,
  0,
2.23965811174676E-14,
1.46796637345847E-14,
3.38730779536611E-14,
3.05662613275803E-14,
4.44141251554342E-14,
3.73308155221519E-14,
4.64827829005365E-14,
3.25451471328009E-14,
4.1959925117796E-14,
2.69550007314656E-14,
3.50297048312687E-14,
2.00577401909818E-14,
2.96785165887492E-14,
1.35260726230602E-14,
2.8350585767889E-14,
1.01537701857612E-14,
2.46864161057569E-14,
0.866163514845656,
2.81857870376712E-14,
0.866154152079793,
3.74865069541208E-14,
2.43719974757362E-14,
4.23012319616944E-14,
1.85988377476853E-14,
4.01059394028458E-14,
1.31977762052315E-14,
4.74455544297037E-14,
1.8473070295677E-14,
6.5520505687644E-14,
2.72551078928096E-14,
7.20083714877973E-14,
2.80947140551824E-14,
6.73367611669917E-14,
1.56914412019482E-14,
6.10969608239031E-14,
  0,
5.03546856989168E-14,
  0,
4.90267548780565E-14,
  0,
  0,
1.39690776307377E-14,
  0,
2.66407989418793E-14,
  0,
3.34853672567803E-14,
  0,
3.13035188048705E-14,
  0,
2.61613647412062E-14,
1.4437236128817E-14,
3.19735557474665E-14,
2.50233861409654E-14,
4.24911841823139E-14,
3.30191603226115E-14,
4.64689051127287E-14,
3.35486846636535E-14,
4.79607673020688E-14,
3.47174546055928E-14,
4.29617279251726E-14,
2.66648682301085E-14,
3.11087960946921E-14,
1.38938339999672E-14,
2.60624855030755E-14,
  0,
2.46747067222941E-14,
1.12492480608406E-14,
2.8498904625085E-14,
0.866154152079793,
3.75368139349241E-14,
0.866145710154951,
4.25198071196675E-14,
1.99848818049908E-14,
4.23784271563754E-14,
1.28152696787787E-14,
4.59684373899094E-14,
1.19045398538908E-14,
5.74627151417317E-14,
1.94904856143374E-14,
6.58891344262891E-14,
2.70382674583125E-14,
6.71494110315862E-14,
1.98157462660831E-14,
6.27865814895046E-14,
  0,
5.19124673803439E-14,
  0,
4.47367837219659E-14,
  0,
5.24606399987526E-14,
  0,
  0,
2.34094427870035E-14,
  0,
3.11810039593796E-14,
1.10089888594178E-14,
3.1416275830809E-14,
1.24947795165919E-14,
3.31835253719603E-14,
1.82631687550838E-14,
3.58510963971437E-14,
2.48633579003066E-14,
4.06354637438877E-14,
2.74940660516254E-14,
4.45954037586738E-14,
2.9248305166707E-14,
4.79945944098503E-14,
3.568022613476E-14,
4.8993795132013E-14,
3.43184682061182E-14,
3.9119749106753E-14,
2.05105030182118E-14,
2.75907768854111E-14,
  0,
2.24859193764804E-14,
  0,
2.81575977811865E-14,
1.99926880606327E-14,
3.74856395923828E-14,
0.866145710154951,
4.29040483695964E-14,
0.866138072152043,
4.2780883002802E-14,
1.45647383043013E-14,
4.82166390147754E-14,
1.15350437535078E-14,
5.59847307401995E-14,
1.286210721263E-14,
5.7889457116822E-14,
1.92918597763381E-14,
6.09668565632049E-14,
1.87358809022875E-14,
6.25723431402214E-14,
1.20780122014885E-14,
5.36090269398493E-14,
  0,
4.62746160834193E-14,
  0,
4.81559236931162E-14,
  0,
  0,
1.99918206988947E-14,
  0,
2.85459589993708E-14,
  0,
2.93812283530537E-14,
1.36960755237059E-14,
3.33856206569116E-14,
2.29443200550072E-14,
4.29582584782207E-14,
2.8720081868272E-14,
4.4576321800438E-14,
2.73834774300319E-14,
4.2782617726278E-14,
2.37583390461094E-14,
4.61735684409437E-14,
3.14375261933897E-14,
4.90766281779909E-14,
3.5305525863949E-14,
4.51136523971218E-14,
2.82360940184745E-14,
3.55128253193282E-14,
1.54971521726388E-14,
2.3862422454668E-14,
  0,
2.58417419407575E-14,
1.83299556089089E-14,
3.75394160201381E-14,
2.4384140540068E-14,
4.25224092048815E-14,
0.866138072152043,
4.21641888070923E-14,
0.86613113913724,
4.8465571833578E-14,
1.31153768401227E-14,
5.82893108780347E-14,
1.25377139226224E-14,
5.63819824161982E-14,
1.26496035868229E-14,
5.29385563163842E-14,
1.09677891768634E-14,
5.64062685448619E-14,
1.10389128393784E-14,
5.33705024619024E-14,
  0,
4.79503589612129E-14,
  0,
4.96772761815478E-14,
  0,
5.45778700011823E-14,
1.46022516994693E-14,
  0,
2.61539921664333E-14,
  0,
2.71063553547446E-14,
1.04096418984678E-14,
3.15515842619352E-14,
2.42588067689287E-14,
4.32926264282152E-14,
3.3505750257623E-14,
5.17693526935759E-14,
3.13243354865822E-14,
4.67664101888587E-14,
2.36742049575245E-14,
4.43829001328666E-14,
2.59614378605999E-14,
4.72569032516912E-14,
3.11278780529278E-14,
4.517913820834E-14,
2.92326926554232E-14,
4.15492293348585E-14,
2.32171053216046E-14,
3.18330431459124E-14,
1.65106643634783E-14,
2.72629141484515E-14,
1.8775779542235E-14,
3.51454976232901E-14,
2.25782934015761E-14,
4.22752111095548E-14,
1.99848818049908E-14,
4.27947607906098E-14,
0.86613113913724,
4.83987849797529E-14,
0.866124826941175,
5.83812512222615E-14,
1.44294298731751E-14,
5.86622764253697E-14,
1.23095977855314E-14,
5.14492962122581E-14,
  0,
4.84430204283903E-14,
  0,
4.72790209760099E-14,
  0,
4.77127018450041E-14,
  0,
5.12992426315861E-14,
  0,
5.60601912114045E-14,
  0,
  0,
2.39168494037267E-14,
  0,
2.53113502379776E-14,
  0,
2.95228251567803E-14,
2.1093803787009E-14,
4.16077762521727E-14,
3.49152130818542E-14,
5.22411974790415E-14,
3.61832959427932E-14,
5.40539835114373E-14,
2.7602919949743E-14,
4.83727641276133E-14,
2.58590891755173E-14,
4.54579950071032E-14,
2.56188299740945E-14,
4.33676532185512E-14,
2.50147125235856E-14,
4.16481085729892E-14,
2.42397248106929E-14,
3.79344992917918E-14,
2.42978380471381E-14,
3.52339685205649E-14,
2.52922682797418E-14,
3.66954730490754E-14,
2.29660040984569E-14,
4.00634386776844E-14,
1.85667453633798E-14,
4.24339383076067E-14,
1.4511829238284E-14,
4.8465571833578E-14,
0.866124826941175,
5.85018145038418E-14,
0.866119063591549,
5.86995729801032E-14,
1.38734509991245E-14,
5.37339270301196E-14,
  0,
4.69580971329542E-14,
  0,
3.92325061326915E-14,
  0,
4.16134141034696E-14,
  0,
5.11257702839885E-14,
1.10259024133086E-14,
5.77359340891981E-14,
  0,
5.91401927430013E-14,
1.2994705138325E-14,
  0,
2.41820452551167E-14,
1.07108332619843E-14,
2.80654405965253E-14,
2.01793876747347E-14,
3.97798113893622E-14,
3.19106720214624E-14,
5.07285186079898E-14,
3.76755918130023E-14,
5.46294780245926E-14,
3.25065495354604E-14,
5.57835028169862E-14,
2.98264017650762E-14,
4.95471719208496E-14,
2.558196710023E-14,
4.16719610207839E-14,
1.9598905831586E-14,
3.98409603918903E-14,
2.00074332101785E-14,
3.79678927187044E-14,
2.53026766205977E-14,
4.13015975586628E-14,
3.30898503042576E-14,
4.46968850820184E-14,
2.95952498619023E-14,
4.15579029522384E-14,
1.88894039299115E-14,
4.01146130202257E-14,
1.27857793796871E-14,
4.81958223330636E-14,
1.31032337757908E-14,
5.83881901161654E-14,
0.866119063591549,
5.89988127797092E-14,
0.866113787251926,
5.39629105289485E-14,
  0,
4.92219112691039E-14,
  0,
3.77033473886179E-14,
  0,
3.351138810892E-14,
  0,
4.49744408381747E-14,
  0,
5.75130221225351E-14,
  0,
6.07456793200178E-14,
  0,
  0,
1.60737308879666E-14,
1.24978152826749E-14,
2.74795377425141E-14,
2.16981380779524E-14,
3.85997657448289E-14,
3.11456589685566E-14,
4.90614493475761E-14,
3.47920477150598E-14,
5.32187141577545E-14,
3.40942551968482E-14,
5.64023654170409E-14,
3.47703636716101E-14,
5.69271192685239E-14,
2.95896120106054E-14,
4.57468264658534E-14,
1.95433946803547E-14,
3.81530744497649E-14,
1.45738456025502E-14,
3.62262303488237E-14,
2.10842628078911E-14,
4.14126198611253E-14,
3.40955562394551E-14,
5.07632130775093E-14,
3.72800748604796E-14,
4.95532434530155E-14,
2.54692100742915E-14,
4.16845377659847E-14,
1.31943067582796E-14,
4.59545596021016E-14,
1.15124923483201E-14,
5.83240053475542E-14,
1.43444284228522E-14,
5.86995729801032E-14,
0.866113787251926,
5.41129641096205E-14,
0.866108944555755,
4.94214044688412E-14,
  0,
4.00061928029771E-14,
  0,
3.19041668084274E-14,
  0,
3.69400690591881E-14,
  0,
5.13426107184856E-14,
  0,
6.05496555672325E-14,
  0,
4.99435562351103E-14,
  0,
  0,
2.02830374024243E-14,
2.38361847620938E-14,
3.83855273955458E-14,
3.28886223810443E-14,
4.81507195226882E-14,
3.41480316246034E-14,
5.17875672900736E-14,
3.12883399744557E-14,
5.51364509604468E-14,
3.64053405477183E-14,
5.76847597466568E-14,
3.45279360658424E-14,
5.31913922630078E-14,
2.35449680585642E-14,
4.2263068045223E-14,
1.45491257930175E-14,
3.44919405537158E-14,
1.56727929245815E-14,
3.96284567660832E-14,
2.99326535779798E-14,
5.0858622868688E-14,
3.83599402242751E-14,
5.56872256640695E-14,
3.32277608205978E-14,
4.96590615850501E-14,
1.97506941357339E-14,
4.74854530696511E-14,
1.18880599808691E-14,
5.59977411662693E-14,
1.25377139226224E-14,
5.86969708948892E-14,
1.38751857226005E-14,
5.400541125411E-14,
0.866108944555755,
4.91594612239687E-14,
0.866104489251363,
4.00521629750905E-14,
  0,
3.42104816697386E-14,
-1.00761413102113E-14,
3.53952978038308E-14,
  0,
4.323451319177E-14,
  0,
5.43402128849735E-14,
  0,
4.96816129902378E-14,
  0,
  0,
1.12891467007881E-14,
2.14606978021781E-14,
3.17922771442269E-14,
3.53740474412501E-14,
4.83393707007007E-14,
3.60848503855316E-14,
5.10394677910586E-14,
3.07696576551386E-14,
5.38241326508704E-14,
3.36666458600199E-14,
5.65159898047174E-14,
3.62323018809896E-14,
5.39984723602061E-14,
2.85283949241766E-14,
4.97822269518444E-14,
1.85945009389954E-14,
3.86795630247239E-14,
1.56727929245815E-14,
3.80012861456169E-14,
2.45168468859802E-14,
4.90575462197551E-14,
3.42070122227867E-14,
5.57609514117985E-14,
3.42928810348475E-14,
5.57331958361829E-14,
2.75708275654374E-14,
5.54304865896249E-14,
1.84860807217468E-14,
5.74627151417317E-14,
1.28881280647697E-14,
5.63750435222943E-14,
1.22957199977236E-14,
5.37287228596917E-14,
  0,
4.94214044688412E-14,
0.866104489251363,
4.03722194564082E-14,
0.866100381093242,
3.42052774993107E-14,
  0,
3.77553890928972E-14,
  0,
4.18016316006131E-14,
  0,
4.63405355755064E-14,
-1.16261167359966E-14,
4.35146710331402E-14,
  0,
4.44800446475213E-14,
  0,
1.9709711293614E-14,
2.36375589240945E-14,
3.35749223562276E-14,
4.21852223292385E-14,
3.8891199288793E-14,
5.14978684695855E-14,
3.28279070593851E-14,
5.325514335075E-14,
3.32277608205978E-14,
5.52834687750359E-14,
3.35517204297364E-14,
5.28878156547119E-14,
3.02587815914634E-14,
5.06144605394443E-14,
2.35926729541536E-14,
4.62156354852361E-14,
1.96999534740616E-14,
4.21264585714898E-14,
2.45120763964213E-14,
4.74273398332059E-14,
2.88154916594507E-14,
5.40192890419178E-14,
3.0141687756835E-14,
5.58849841403308E-14,
2.86628359935648E-14,
6.15445194807052E-14,
2.62576418941229E-14,
6.55066278998362E-14,
1.94887508908614E-14,
5.78963960107259E-14,
1.26357257990151E-14,
5.14198059131665E-14,
  0,
4.91941556934883E-14,
  0,
4.00521629750905E-14,
0.866100381093242,
3.47456438620775E-14,
0.866096584929808,
3.81604470245378E-14,
  0,
4.39240657734707E-14,
  0,
4.48105094696949E-14,
-1.81226561535297E-14,
3.54950444036994E-14,
-1.53028631433294E-14,
3.82567241774545E-14,
  0,
1.66146393518196E-14,
2.17438914096313E-14,
3.29126916692735E-14,
3.46985894877916E-14,
3.75365970944896E-14,
4.57346834015215E-14,
3.58393870136808E-14,
5.39611758054725E-14,
3.54000682933897E-14,
5.48857834181682E-14,
3.31713823076285E-14,
5.17728221405278E-14,
2.76640689522711E-14,
4.95532434530155E-14,
2.5353850963139E-14,
4.70855993084385E-14,
2.47215442561455E-14,
4.96707709685129E-14,
2.85583189041372E-14,
5.16409831563536E-14,
2.88120222124988E-14,
5.23721691014778E-14,
2.47753206839008E-14,
5.41051578539786E-14,
2.44951628425305E-14,
6.16694195709755E-14,
2.73990899413157E-14,
7.16215281526544E-14,
2.72533731693336E-14,
6.58769913619572E-14,
1.92745125415783E-14,
5.29732507859038E-14,
  0,
4.69286068338626E-14,
  0,
3.99506816517459E-14,
  0,
3.41887976262889E-14,
0.866096584929808,
3.78022266267486E-14,
0.866093069948838,
4.43872369415566E-14,
  0,
4.69624339416441E-14,
-1.85207751912664E-14,
3.39060376997047E-14,
-2.19659360145563E-14,
3.01902600141624E-14,
-1.63601771019373E-14,
4.37835531719166E-14,
1.763205467048E-14,
3.34745252350555E-14,
3.40127231934773E-14,
3.76647497912774E-14,
3.87613118685293E-14,
3.48263085037104E-14,
4.84837864300758E-14,
3.85889237231041E-14,
5.5725389580541E-14,
3.54390995715992E-14,
5.14701128939699E-14,
2.73214610657657E-14,
4.85128430482984E-14,
2.27552351961258E-14,
4.60781586497649E-14,
2.65026715851047E-14,
5.05841028786147E-14,
3.35651645366752E-14,
5.91857292342457E-14,
3.2835279634158E-14,
5.65840777011495E-14,
2.47900658334466E-14,
5.24979365534861E-14,
1.91374693869761E-14,
5.99529106914964E-14,
2.3259172365897E-14,
7.17811227124443E-14,
2.83618614704828E-14,
7.19858200826096E-14,
2.70382674583125E-14,
6.09737954571088E-14,
1.09677891768634E-14,
4.84499593222942E-14,
  0,
3.77033473886179E-14,
  0,
3.42104816697386E-14,
  0,
3.8217692899245E-14,
0.866093069948838,
4.41244263349461E-14,
0.866089809050115,
4.7048302753705E-14,
-1.70167699375945E-14,
3.62149546462298E-14,
-2.23527793496991E-14,
2.87287554856519E-14,
-2.30189131644742E-14,
3.57101501147206E-14,
-1.99172275894277E-14,
2.20431312092373E-14,
3.37249759368996E-14,
3.98470319240563E-14,
3.88758036179437E-14,
3.54228365390119E-14,
4.18467344109885E-14,
3.77675321572291E-14,
5.05307601317284E-14,
3.87944884550073E-14,
5.24671452117875E-14,
2.96750471417973E-14,
4.83072783163951E-14,
2.24919909086463E-14,
4.51188565675498E-14,
2.39422197345629E-14,
4.96469185207182E-14,
3.53514960360624E-14,
6.0135490337343E-14,
3.78785544596916E-14,
6.41852022920109E-14,
2.88163590211887E-14,
5.6698569450564E-14,
1.90767540653169E-14,
5.83474241144799E-14,
1.78442330356354E-14,
7.00915020468429E-14,
2.42167397246362E-14,
7.21939868997268E-14,
2.81137960134181E-14,
6.71615540959181E-14,
1.87341461788115E-14,
5.64054011831239E-14,
  0,
3.92056179188138E-14,
  0,
3.19180445962353E-14,
-1.002063015898E-14,
3.77493175607313E-14,
  0,
4.43889716650325E-14,
0.866089809050115,
4.69312089190765E-14,
0.866086778321459,
3.63866922703515E-14,
-2.07689768161323E-14,
3.07523104203788E-14,
-2.34022870526651E-14,
3.41879302645509E-14,
-2.65811678223926E-14,
3.77172251764257E-14,
2.1337640855601E-14,
3.31147869542248E-14,
4.02360436635441E-14,
3.84700951649997E-14,
4.24590917980083E-14,
3.86886703229727E-14,
4.41474114210028E-14,
3.81357272150051E-14,
4.73913443210794E-14,
3.30833450912227E-14,
4.94144655749373E-14,
2.49002207741711E-14,
4.49805123703406E-14,
2.37019605331401E-14,
4.87153720141187E-14,
3.28604331245597E-14,
5.92759348549965E-14,
3.96774627042795E-14,
6.51575148002959E-14,
3.38618022510673E-14,
6.43460978944077E-14,
2.31247312965088E-14,
6.25966292688851E-14,
1.78355594182555E-14,
6.85224446628219E-14,
1.88408316725841E-14,
7.05121724897673E-14,
2.39964298431872E-14,
6.73575778487034E-14,
1.9823552521725E-14,
6.2600098715837E-14,
1.10380454776404E-14,
4.72651431882021E-14,
  0,
3.34966429593742E-14,
  0,
3.54091755916386E-14,
  0,
4.39318720291126E-14,
  0,
4.70552416476089E-14,
0.866086778321459,
3.60232677021344E-14,
0.866083956599047,
3.11998690771809E-14,
-2.17915963052207E-14,
3.65592972562112E-14,
-2.69593375401556E-14,
3.619760741147E-14,
-2.51560924868777E-14,
1.62057867125753E-14,
3.24536404694431E-14,
3.33645871347654E-14,
4.47645392975815E-14,
4.22448534487252E-14,
4.51544183988073E-14,
3.9266333240473E-14,
4.12538926630734E-14,
3.25603259632157E-14,
4.45095349466129E-14,
2.83375753418191E-14,
4.61861451861445E-14,
2.6106287270844E-14,
4.86832796298131E-14,
3.26370874770276E-14,
5.841204256396E-14,
3.72011449423226E-14,
6.43183423187921E-14,
3.57235942216594E-14,
6.53400944461424E-14,
2.81675724411734E-14,
7.02198715840652E-14,
2.18661894146877E-14,
7.27187407512098E-14,
1.8852107375178E-14,
6.89439824674842E-14,
1.86005724711613E-14,
6.56783655239579E-14,
1.56975127341141E-14,
6.27865814895046E-14,
1.20571955197768E-14,
5.33982580375181E-14,
  0,
4.15995363156618E-14,
  0,
3.69400690591881E-14,
  0,
4.17808149189014E-14,
  0,
4.6969372835548E-14,
-1.70202393845464E-14,
3.63866922703515E-14,
0.866083956599047,
3.10324682617491E-14,
0.86608132509683,
3.66269514717743E-14,
-2.53104828762396E-14,
3.83937673320567E-14,
-2.55108434377149E-14,
3.7175991451921E-14,
1.61521187050373E-14,
2.0008083731482E-14,
3.86719736095165E-14,
3.79338487704883E-14,
4.8015844772431E-14,
4.31759662744557E-14,
4.24877147353619E-14,
3.38752463580061E-14,
3.84670593989167E-14,
2.78566232581046E-14,
4.14013441585315E-14,
2.96121634157931E-14,
4.99695770872499E-14,
3.50678687477401E-14,
5.83860217118204E-14,
3.7025070509511E-14,
6.34752667094673E-14,
3.32472764597025E-14,
6.4546024775014E-14,
3.00766356264859E-14,
7.12563688609613E-14,
2.68856117924265E-14,
8.04295866019267E-14,
2.28202873264749E-14,
7.31671667697498E-14,
1.85866946833535E-14,
6.4097165075605E-14,
1.03172678733721E-14,
6.11030323560691E-14,
  0,
5.36229047276571E-14,
  0,
4.77048955893622E-14,
  0,
4.49631651355809E-14,
  0,
4.32475236178398E-14,
  0,
4.47688761062714E-14,
-1.8477407104367E-14,
3.6200209496684E-14,
-2.07412212405167E-14,
3.12683906544819E-14,
0.86608132509683,
3.61542393245706E-14,
0.866078867093028,
3.86149445752437E-14,
-2.38446415390392E-14,
3.93305180090842E-14,
-2.89074320036775E-14,
  0,
2.61286218355972E-14,
2.5807481152107E-14,
4.28433330479372E-14,
3.94018585120337E-14,
4.57372854867355E-14,
3.79891430812851E-14,
3.98925684153006E-14,
2.92782291466676E-14,
3.54646867428698E-14,
2.91953961006897E-14,
4.52706448716977E-14,
3.86574453004052E-14,
5.97551522152351E-14,
3.95165671018827E-14,
6.35225379241877E-14,
3.31202079650872E-14,
6.37359089117329E-14,
2.76072567584329E-14,
7.05043662341254E-14,
2.88059506803329E-14,
8.14895026457485E-14,
2.78891493232791E-14,
8.08606653857069E-14,
2.2591303827646E-14,
6.83914730403856E-14,
1.02981859151363E-14,
5.95504548450698E-14,
  0,
5.1907263209916E-14,
  0,
4.79382158968811E-14,
  0,
5.11396480717963E-14,
  0,
5.13287329306777E-14,
  0,
4.63682911511221E-14,
-1.81087783657219E-14,
3.38496591867354E-14,
-2.23709939461969E-14,
3.07835354429464E-14,
-2.17907289434827E-14,
3.66130736839665E-14,
0.866078867093028,
3.90529622529279E-14,
0.866076567663807,
3.93912333307433E-14,
-2.73418440666084E-14,
3.88994392253039E-14,
1.40057236641677E-14,
1.45901086351374E-14,
3.17404522803821E-14,
2.79073639197769E-14,
4.11424366797419E-14,
3.45379107258292E-14,
4.33988782411188E-14,
3.35491183445225E-14,
3.70081569556202E-14,
3.07050392056585E-14,
3.94215909915729E-14,
3.83460624364673E-14,
5.51347162369709E-14,
4.31395370814602E-14,
6.49753688353183E-14,
3.56333886009086E-14,
6.38512680228853E-14,
2.75005712646603E-14,
6.97653740333593E-14,
2.64224406243407E-14,
8.07678576797421E-14,
2.98311722546352E-14,
8.19708884103321E-14,
2.76844519531139E-14,
7.61057883380545E-14,
1.43027950594288E-14,
6.38352218307325E-14,
  0,
5.03659614015106E-14,
  0,
4.62746160834193E-14,
  0,
5.131051833418E-14,
1.10302392219985E-14,
5.74922054408233E-14,
  0,
5.4373172631017E-14,
-1.16417292472804E-14,
3.54256554646604E-14,
-2.19355783537267E-14,
2.87287554856519E-14,
-2.33554495188137E-14,
3.6502051381504E-14,
-2.52844620241E-14,
3.85047896345192E-14,
0.866076567663806,
3.9790219730218E-14,
0.866074413456151,
3.89323989713475E-14,
-2.73661301952721E-14,
  0,
2.28241904542958E-14,
1.75662435986101E-14,
3.08249519659354E-14,
2.33931797544162E-14,
3.91305911284778E-14,
3.02579142297255E-14,
4.06810002351321E-14,
3.50860833442379E-14,
4.1065241485061E-14,
3.98791243083618E-14,
4.9364592275003E-14,
4.28728233470288E-14,
6.03917957309186E-14,
3.93144718169314E-14,
6.53500691061293E-14,
3.00224255178616E-14,
6.9932341167922E-14,
2.62481009150051E-14,
8.00869787154213E-14,
2.74042941117436E-14,
8.12353656565179E-14,
2.96334137783738E-14,
7.7186521063588E-14,
1.94124230579185E-14,
7.15495371284014E-14,
  0,
5.46906270271208E-14,
  0,
4.47359163602279E-14,
  0,
4.96807456284998E-14,
  0,
5.77229236631283E-14,
  0,
6.05513902907084E-14,
  0,
4.34895175427386E-14,
-1.53184756546132E-14,
3.01538308211668E-14,
-2.29755450775748E-14,
3.41462969011275E-14,
-2.69593375401556E-14,
3.83928999703187E-14,
-2.38168859634236E-14,
3.93886312455294E-14,
0.866074413456151,
3.95161334210137E-14,
0.866072392493585,
3.86496390447633E-14,
1.23663015591524E-14,
1.5037450451505E-14,
2.30861336991683E-14,
1.35065569839554E-14,
2.92556777414799E-14,
1.93777285883989E-14,
3.66811615803986E-14,
3.19462338527199E-14,
4.48851025791619E-14,
4.43829001328666E-14,
5.11361786248443E-14,
4.45177748831238E-14,
5.47444034548761E-14,
3.90919935311373E-14,
6.08662426015982E-14,
3.37243254155961E-14,
7.14641019972095E-14,
2.88267673620446E-14,
8.02821351064686E-14,
2.73166905762068E-14,
8.06238756312361E-14,
2.72299544024079E-14,
7.65247240575029E-14,
2.13874057353181E-14,
7.26909851755941E-14,
1.17267306976032E-14,
6.23962687074098E-14,
  0,
4.90267548780565E-14,
  0,
4.81611278635441E-14,
  0,
5.60844773400682E-14,
  0,
6.07838432364893E-14,
  0,
4.96816129902378E-14,
  0,
3.82619283478824E-14,
-1.63879326775529E-14,
3.57396404138122E-14,
-2.65941782484624E-14,
3.61915358793041E-14,
-2.54969656499071E-14,
3.93027624334685E-14,
-2.73375072579185E-14,
3.89471441208933E-14,
0.866072392493585,
3.93764881811975E-14,
0.866070494009311,
  0,
1.52950568876875E-14,
1.16670995781165E-14,
2.206351421008E-14,
  0,
2.70295938409326E-14,
2.11922493442707E-14,
4.10838897624277E-14,
4.13709864977019E-14,
5.50995880865823E-14,
4.91321393292221E-14,
5.66135680002411E-14,
4.07751089837038E-14,
5.5272193072442E-14,
3.35690676644962E-14,
6.70440265804206E-14,
3.25594586014777E-14,
8.18546619374416E-14,
2.98840813206525E-14,
8.08459202361611E-14,
2.70911765243298E-14,
7.58794069244395E-14,
1.90212429140857E-14,
7.20031673173693E-14,
1.37268668654045E-14,
6.35446556485064E-14,
  0,
5.67558153252712E-14,
  0,
5.24589052752766E-14,
  0,
5.45709311072784E-14,
  0,
5.91471316369052E-14,
  0,
4.99296784473025E-14,
  0,
4.44522890719057E-14,
  0,
4.37904920658205E-14,
-1.99172275894277E-14,
3.77102862825218E-14,
-2.51422146990699E-14,
3.71794608988729E-14,
-2.89091667271535E-14,
3.89549503765352E-14,
-2.73097516823029E-14,
3.86765272586409E-14,
0.866070494009311,
4.67612060184308E-14,
  0,
  0,
0.999999999999998,
  0,
  0,
  0,
-1.06567315735773E-14,
-1.06855713513654E-14,
  0,
-1.07112127327447E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.07372877949929E-14,
  0,
  0,
  0,
1.1536886897201E-14,
  0,
1.54749260281029E-14,
  0,
1.4732572800602E-14,
  0,
1.31821636939478E-14,
  0,
1.02412653010808E-14,
1.47855902868366E-14,
1.70405139651719E-14,
2.32296820668054E-14,
2.22247350731286E-14,
2.27654266965471E-14,
2.42586983487114E-14,
1.57210399212571E-14,
2.04046848861772E-14,
1.40322866173936E-14,
1.62584789381581E-14,
  0,
1.03982577756567E-14,
  0,
0.894427190999913,
  0,
0.878310065653673,
  0,
-1.38935087393155E-14,
-1.63782832782178E-14,
-1.75539921140611E-14,
-1.86003556307268E-14,
-1.15441510517567E-14,
-1.24165001197385E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.52976589729015E-14,
  0,
1.73383443019537E-14,
  0,
1.80114170106327E-14,
  0,
2.33964323609337E-14,
  0,
2.61713394011931E-14,
  0,
2.41781421272957E-14,
1.25116930704827E-14,
2.02960478284941E-14,
2.14468200143703E-14,
2.36434136158259E-14,
3.29066201371075E-14,
3.40161926404292E-14,
3.98539708179602E-14,
4.02449341213584E-14,
3.33639366134619E-14,
3.86635168325711E-14,
2.57829781830088E-14,
3.17463069721136E-14,
1.75454269168984E-14,
2.30785442839609E-14,
1.16623290885576E-14,
0.999999999999998,
  0,
0.638876564999933,
  0,
0.857142857142842,
-1.57055358301905E-14,
-1.89906684128216E-14,
-2.19215921457017E-14,
-1.7349836844982E-14,
-1.80362452403826E-14,
  0,
-1.0000572418789E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.26968748015432E-14,
  0,
1.95800407137847E-14,
  0,
2.39060073820019E-14,
  0,
2.71967778159299E-14,
  0,
3.07189169934663E-14,
  0,
3.22656398127341E-14,
1.45213702174019E-14,
2.83414784696401E-14,
2.17421566861553E-14,
3.10929667429738E-14,
3.61156417272301E-14,
3.67937017659026E-14,
4.44796109666523E-14,
4.70522058815259E-14,
4.54280710271426E-14,
4.93177547411516E-14,
3.96943762581703E-14,
4.539901440892E-14,
2.62693512775858E-14,
3.49245372205376E-14,
2.1318016796279E-14,
2.5320240695792E-14,
  0,
0.878310065653673,
  0,
0.59628479399993,
-1.60999685805407E-14,
0.849411985729357,
-2.04613886597982E-14,
-1.79232713740096E-14,
-2.05491006155523E-14,
-1.18245257335614E-14,
-1.5105104667068E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02593714773613E-14,
  0,
1.62070877551823E-14,
  0,
2.51844985837968E-14,
  0,
3.20182248769729E-14,
  0,
3.328283829096E-14,
  0,
3.54696740728633E-14,
1.32888491877203E-14,
3.5150268112849E-14,
2.3037561441841E-14,
3.79375350578748E-14,
3.52634588196565E-14,
4.28533077079241E-14,
4.59688710707784E-14,
4.79941607289813E-14,
4.80874021158151E-14,
5.40331668297256E-14,
4.9963939235953E-14,
5.4004977573241E-14,
3.87905853271864E-14,
4.68375338513738E-14,
2.90423067539347E-14,
3.58775509301523E-14,
1.45309111965197E-14,
  0,
  0,
0.857142857142843,
-1.60305796415017E-14,
0.580796877272654,
-2.07917450617545E-14,
0.84569137219913,
-1.88408316725841E-14,
-1.19745793142334E-14,
-1.74170573796761E-14,
  0,
-1.27326534732353E-14,
  0,
-1.24587840044654E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.34887760683267E-14,
  0,
2.13902246609665E-14,
  0,
3.27910441855206E-14,
  0,
3.74440062289594E-14,
  0,
3.72982894569773E-14,
1.30576972845464E-14,
3.75754115322646E-14,
2.14086560978988E-14,
4.40147050750905E-14,
3.59360978474665E-14,
4.88454762748169E-14,
4.42480253826094E-14,
5.31163654726718E-14,
4.85306239639272E-14,
5.38835469299226E-14,
5.15698594938385E-14,
5.75880489128711E-14,
4.81142903296927E-14,
5.43952903553357E-14,
4.08466663270879E-14,
4.6973275963369E-14,
2.1768177538295E-14,
3.12692580162199E-14,
  0,
-1.39007728938711E-14,
-1.57176788945224E-14,
0.849411985729357,
-2.0791961902189E-14,
0.573350763461467,
-1.87896573300428E-14,
0.843607101939139,
-1.54880448743899E-14,
  0,
-1.48373067304641E-14,
  0,
-1.70083131606491E-14,
  0,
-1.28408568500493E-14,
  0,
  0,
  0,
  0,
  0,
1.10586453189176E-14,
  0,
1.03268088524899E-14,
  0,
1.84895501686988E-14,
  0,
2.86203352684034E-14,
  0,
3.77445470711724E-14,
  0,
4.10431237607423E-14,
1.59199910199082E-14,
3.89597208660941E-14,
2.09762762715116E-14,
4.59510901551496E-14,
3.40170600021672E-14,
5.43371771188905E-14,
4.44579269232026E-14,
5.85087533977457E-14,
4.61913493565724E-14,
5.83036223467115E-14,
5.13751367836601E-14,
5.67107125148958E-14,
4.91130573709864E-14,
5.72545483246145E-14,
4.96473522015872E-14,
5.38696691421148E-14,
3.3209112543231E-14,
4.1885332008329E-14,
2.39799499701654E-14,
-1.06567315735773E-14,
-1.64025694068815E-14,
-1.90453122023149E-14,
-2.04612802395809E-14,
0.84569137219913,
-1.87599501905167E-14,
0.569180939727208,
-1.50083938332823E-14,
0.842319572634655,
-1.28228590939861E-14,
  0,
-1.89273510059484E-14,
-1.30687561467058E-14,
-1.73693524840868E-14,
-1.32244475786747E-14,
-1.18746158739302E-14,
  0,
  0,
  0,
1.13541988311372E-14,
  0,
1.40807504545037E-14,
  0,
1.51762283295831E-14,
  0,
2.55234201829158E-14,
  0,
3.33318442291564E-14,
  0,
4.10236081216375E-14,
1.50894921557843E-14,
4.23602125598777E-14,
2.37010931714021E-14,
4.69537603242642E-14,
3.33157980370036E-14,
5.58927903959727E-14,
4.21346985080007E-14,
6.3575880671074E-14,
4.60334895202585E-14,
6.32337064654376E-14,
4.86433809898656E-14,
6.0658075784481E-14,
4.84946284518006E-14,
5.5944398419383E-14,
5.02185099060526E-14,
5.62705264328667E-14,
4.16528790625481E-14,
4.83888103197661E-14,
3.52040445406043E-14,
4.79386495777501E-14,
-1.06855713513654E-14,
-1.75747003755555E-14,
-2.19217005659189E-14,
-1.79245724166166E-14,
-1.87592996692132E-14,
0.843607101939139,
-1.50894921557843E-14,
0.566605460361932,
-1.20099243050564E-14,
0.841467615076606,
-1.69304674446646E-14,
-1.31754416404783E-14,
-1.90839097996554E-14,
-1.83466523223652E-14,
-1.63653812723652E-14,
-1.05115569026815E-14,
  0,
  0,
  0,
  0,
1.43409589759003E-14,
  0,
1.88226170760863E-14,
  0,
2.20912697856956E-14,
  0,
3.00631915195471E-14,
  0,
3.63966669303384E-14,
1.38782214886835E-14,
4.21151828688959E-14,
2.27829907717414E-14,
5.00905740496993E-14,
3.58766835684143E-14,
5.66153027237171E-14,
4.12773114299991E-14,
6.4770671465153E-14,
4.34847470531796E-14,
6.79612616183434E-14,
4.81593931400681E-14,
6.5223000611514E-14,
4.54532245175443E-14,
5.95656336754846E-14,
4.93251273159245E-14,
5.4603023491584E-14,
4.19751039482108E-14,
5.04787184274491E-14,
4.34504862645291E-14,
5.41611026860789E-14,
3.94519486524025E-14,
  0,
-1.86307132915564E-14,
-1.73732556119077E-14,
-2.06054791285215E-14,
-1.19893244637792E-14,
-1.54884785552589E-14,
0.842319572634655,
-1.21222476501259E-14,
0.564901383789412,
-1.70456097153826E-14,
0.840874266114532,
-1.7013951011946E-14,
-1.83173788637081E-14,
-1.806432607665E-14,
-1.5484575427438E-14,
-1.0245710529988E-14,
  0,
  0,
  0,
1.09079412169422E-14,
  0,
1.90325186166795E-14,
  0,
2.56123247610596E-14,
  0,
2.64931306059868E-14,
  0,
3.29671186183322E-14,
  0,
3.73338512882349E-14,
2.14619988447851E-14,
4.97024296719495E-14,
3.47842414594179E-14,
5.95612968667947E-14,
4.36690614225022E-14,
6.52602971662475E-14,
4.2405315370253E-14,
6.89014817423228E-14,
4.54098564306449E-14,
6.96582548587177E-14,
4.47719118723544E-14,
6.38360891924705E-14,
4.60933374801797E-14,
5.79987446958086E-14,
4.08510031357778E-14,
4.85848340725514E-14,
4.35411255661489E-14,
5.60259304227539E-14,
4.75292548374195E-14,
5.85547235698591E-14,
-1.07112127327447E-14,
-1.15515236265296E-14,
-1.80075138828117E-14,
-1.18251762548649E-14,
-1.73893018040605E-14,
  0,
-1.28055118592263E-14,
0.841467615076606,
-1.69898817237168E-14,
0.563714616176405,
-1.69484652007279E-14,
0.84044429432965,
-1.60479268762614E-14,
-1.56875380741273E-14,
-1.19466068981833E-14,
-1.36821977358981E-14,
  0,
  0,
  0,
  0,
1.56142460072672E-14,
  0,
2.57658477886835E-14,
  0,
2.999293521877E-14,
  0,
2.92994795092483E-14,
  0,
3.37607546085916E-14,
1.47963238883442E-14,
4.47510951906427E-14,
3.33843196143047E-14,
5.89216175850282E-14,
4.24755716710301E-14,
6.79655984270333E-14,
4.46400728881802E-14,
6.91560524124224E-14,
4.42107288278759E-14,
7.03230876308858E-14,
4.18541069857614E-14,
6.80046297052428E-14,
4.52433229769511E-14,
6.20740438217471E-14,
3.74613534637191E-14,
5.17853988857286E-14,
4.22808489608517E-14,
5.39472980176647E-14,
4.74672384731534E-14,
6.02230938728798E-14,
5.56525311945499E-14,
  0,
-1.24479419827406E-14,
  0,
-1.51337276044217E-14,
  0,
-1.48659296678177E-14,
  0,
-1.69848943937234E-14,
0.840874266114531,
-1.69484652007279E-14,
0.562854639645239,
-1.533278712329E-14,
0.840122671494809,
  0,
-1.36683199480903E-14,
  0,
-1.05397461591661E-14,
  0,
  0,
  0,
  0,
2.22959671558609E-14,
  0,
3.01009217551496E-14,
  0,
3.27281604595164E-14,
  0,
3.00393390717524E-14,
1.4658847052873E-14,
4.11021043589255E-14,
2.66626998257635E-14,
5.38670670569008E-14,
4.08752892644415E-14,
6.7166758266346E-14,
4.33164788760099E-14,
7.16254312804754E-14,
4.63509439163623E-14,
7.03959460168768E-14,
4.0537451867495E-14,
6.85168068115249E-14,
4.22157968305026E-14,
6.60890613068954E-14,
3.65475878727484E-14,
5.57102107501262E-14,
3.87936210932693E-14,
5.70246974640476E-14,
4.61111183958085E-14,
5.80048162279745E-14,
5.54556400800266E-14,
7.19476561661381E-14,
  0,
  0,
-1.00004639985718E-14,
  0,
-1.26803949285215E-14,
  0,
-1.89555402624331E-14,
-1.31693701083124E-14,
-1.69515009668109E-14,
0.84044429432965,
-1.55006216195908E-14,
0.562211377199933,
  0,
0.839875767210725,
  0,
-1.05870173738865E-14,
  0,
-1.13797860024079E-14,
  0,
  0,
1.47130571614973E-14,
  0,
2.64913958825108E-14,
1.07509487423663E-14,
3.26986701604248E-14,
1.52980926537705E-14,
3.33747786351868E-14,
1.67335763301413E-14,
3.72518856039949E-14,
2.64896611590348E-14,
5.0115293859232E-14,
3.40946888777172E-14,
6.19955475844591E-14,
4.16572158712381E-14,
7.07051604764697E-14,
4.48950772391488E-14,
7.2776420306786E-14,
4.25523331848421E-14,
6.84521883620448E-14,
4.07894204523807E-14,
6.64477153855536E-14,
3.34541422342127E-14,
5.95699704841746E-14,
3.78195738615084E-14,
6.08228745146988E-14,
4.24877147353619E-14,
6.09417030728032E-14,
5.40097480627999E-14,
6.95806259831677E-14,
5.58294729890996E-14,
  0,
  0,
  0,
  0,
  0,
-1.70360687362647E-14,
-1.30425184541316E-14,
-1.91394209508866E-14,
-1.82965621819964E-14,
-1.59924157250302E-14,
0.840122671494809,
  0,
0.561717559565152,
  0,
0.839682074076694,
  0,
-1.12600900825655E-14,
  0,
-1.13884596197877E-14,
1.02188223161104E-14,
  0,
1.88525410560469E-14,
  0,
2.90696286486813E-14,
1.660477311205E-14,
3.33422525700122E-14,
2.26971219596805E-14,
4.05864578056914E-14,
2.84308167286529E-14,
4.62130334000221E-14,
3.3810627908526E-14,
5.811887429652E-14,
3.48163338437235E-14,
6.54229274921203E-14,
4.3234946872639E-14,
7.17412240724968E-14,
4.10426900798733E-14,
7.07329160520853E-14,
4.27405506819856E-14,
6.62473548240783E-14,
3.19171772344973E-14,
5.97985203021345E-14,
3.46511014326367E-14,
6.45638056906428E-14,
4.14052472863524E-14,
6.462105156535E-14,
5.03147870589693E-14,
7.23683266090624E-14,
5.42899059041702E-14,
7.17672449246365E-14,
  0,
  0,
  0,
  0,
-1.24587840044654E-14,
  0,
-1.73760745375562E-14,
-1.83752752597188E-14,
-1.80834080348857E-14,
-1.56832012654373E-14,
  0,
0.839875767210725,
  0,
0.561330168144766,
  0,
0.83952731128995,
  0,
-1.12444775712817E-14,
  0,
  0,
1.44185878514502E-14,
  0,
2.14073550552918E-14,
1.14699916231586E-14,
2.96767818652732E-14,
2.40727576761302E-14,
4.04741344606219E-14,
3.43653057399695E-14,
4.94613031087887E-14,
3.58003557354714E-14,
5.41420207278431E-14,
3.44910731919779E-14,
6.14885746486049E-14,
3.63272779912993E-14,
6.63544739987199E-14,
3.93240127960492E-14,
6.95927690474996E-14,
4.11927436605453E-14,
6.84547904472588E-14,
3.38340466754516E-14,
5.95435159511659E-14,
3.31297489442051E-14,
6.4696512036555E-14,
3.82124887288171E-14,
6.82544298857835E-14,
4.91507876065889E-14,
7.59461937782646E-14,
5.05376990256323E-14,
7.44630052063044E-14,
5.06773442654485E-14,
  0,
  0,
  0,
  0,
  0,
-1.28686124256649E-14,
-1.32246644191092E-14,
-1.6380993783649E-14,
-1.5484575427438E-14,
-1.19201523651746E-14,
-1.36631157776623E-14,
  0,
0.839682074076694,
  0,
0.561020639516066,
  0,
0.839401691844484,
1.04811992418519E-14,
  0,
1.26031997338405E-14,
  0,
1.69387073811755E-14,
  0,
2.19494561415345E-14,
1.88204486717414E-14,
3.67648619881145E-14,
3.56624452191312E-14,
4.93047443150818E-14,
4.17469878111199E-14,
5.7366871669684E-14,
3.64040395051113E-14,
5.74635825034697E-14,
3.59933437221738E-14,
6.2380656196126E-14,
3.24228491277445E-14,
6.41292574599106E-14,
3.94302646089528E-14,
6.72456881845029E-14,
3.22285600984351E-14,
6.16191125901722E-14,
3.49711579139544E-14,
6.4320944404006E-14,
3.66269514717743E-14,
6.82969306109449E-14,
4.59163956856301E-14,
7.95119178831349E-14,
4.93077800811648E-14,
7.79185743704502E-14,
4.68340644044218E-14,
8.38539307435049E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.18757000761027E-14,
-1.05132916261574E-14,
-1.02188223161104E-14,
-1.36752588419942E-14,
  0,
-1.06147729495021E-14,
  0,
0.83952731128995,
  0,
0.560769398746019,
1.08966655143483E-14,
0.839298324809899,
1.48262478683048E-14,
  0,
1.51740599252381E-14,
  0,
1.73710872075628E-14,
1.17588230819088E-14,
2.9018020625271E-14,
3.04834282816024E-14,
4.56201916521071E-14,
4.29621616060416E-14,
5.71825573003615E-14,
4.23224823242752E-14,
6.06012635906428E-14,
3.78507988840759E-14,
5.82771678137028E-14,
3.19683515770386E-14,
6.00830149521947E-14,
3.24714213850719E-14,
6.17205939135168E-14,
3.04227129599433E-14,
6.0358835984875E-14,
3.33370483995843E-14,
6.63349583596151E-14,
3.84709625267377E-14,
6.78485045924049E-14,
4.42666736599762E-14,
7.94572740936417E-14,
4.60031318594289E-14,
8.13906234076178E-14,
4.55642468200068E-14,
8.72496519477295E-14,
4.2110412379337E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.05033169661706E-14,
  0,
-1.12600900825655E-14,
  0,
0.839401691844484,
1.11048323314655E-14,
0.560562663483811,
1.47503537162308E-14,
0.839212243709222,
1.74231289118421E-14,
  0,
1.55838883464376E-14,
  0,
2.45237857798841E-14,
2.34426193734816E-14,
3.78035276693556E-14,
3.7767965838098E-14,
5.33791760792823E-14,
4.35524012687427E-14,
6.03787853048487E-14,
4.36959496363798E-14,
6.13432915574919E-14,
3.38323119519757E-14,
5.594569946199E-14,
3.20377405160777E-14,
5.7591952040692E-14,
2.34152974787349E-14,
5.47678222218018E-14,
3.14401282786037E-14,
6.50087622622308E-14,
3.67856786698262E-14,
6.97688434803112E-14,
4.60334895202585E-14,
7.89594084560363E-14,
4.43013681294957E-14,
8.12822031903693E-14,
4.22058221705157E-14,
9.06262911937183E-14,
4.08154413045203E-14,
9.24035153948566E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.13828217684908E-14,
  0,
-1.12449112521507E-14,
1.04811992418519E-14,
0.839298324809899,
1.47460169075408E-14,
0.560390500503628,
1.73866997188465E-14,
0.839139795294853,
1.77258381584E-14,
  0,
2.27287806631171E-14,
1.83763594618913E-14,
3.33665386986759E-14,
3.06464922883443E-14,
4.562322741819E-14,
3.83859610764148E-14,
5.65719346368176E-14,
4.49276033043233E-14,
6.11290532082087E-14,
3.9715626620751E-14,
5.89988127797092E-14,
3.38288425050237E-14,
5.34346872305136E-14,
2.29842186949547E-14,
5.06200983907412E-14,
2.4461335734749E-14,
5.93951970939699E-14,
3.48809522932036E-14,
6.84027487429795E-14,
4.43169806407795E-14,
8.08112257666416E-14,
4.60118054768088E-14,
8.0702805549393E-14,
4.05014563553685E-14,
9.04736355278324E-14,
3.74075770359639E-14,
9.57159698722343E-14,
4.03765562650982E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.13628724485171E-14,
  0,
  0,
1.48145384848419E-14,
0.839212243709222,
1.73836639527636E-14,
0.560245603153794,
1.79587247850499E-14,
0.839078243550044,
2.47315189161323E-14,
1.8476973423498E-14,
3.15342370271754E-14,
2.56396466558062E-14,
4.11077422102224E-14,
3.1185991289373E-14,
4.88047102731315E-14,
3.97338412172488E-14,
5.73022532202039E-14,
4.09290656921968E-14,
5.87082465974831E-14,
3.96965446625153E-14,
5.64652491430451E-14,
2.47865963864946E-14,
4.64316085579952E-14,
2.39938277579732E-14,
5.52309933898876E-14,
2.78908840467551E-14,
6.27692342547448E-14,
4.24191931580609E-14,
7.93766094520088E-14,
4.42909597886398E-14,
8.25268672843826E-14,
4.2183270765328E-14,
8.97771440522277E-14,
3.56928028799608E-14,
9.54670370534316E-14,
3.69756308904456E-14,
1.03812791696356E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.13359842346394E-14,
  0,
1.09569471551385E-14,
  0,
  0,
  0,
1.02747671482106E-14,
  0,
1.25914903503777E-14,
  0,
1.74127205709862E-14,
0.839139795294853,
1.79856129989275E-14,
0.5601224993078,
2.5131372677345E-14,
0.839025506408603,
3.35937874740289E-14,
2.58595228563863E-14,
3.92069189614208E-14,
2.62723870436687E-14,
4.41981520826751E-14,
3.26032603692461E-14,
4.94743135348585E-14,
3.56719861982491E-14,
5.48944570355481E-14,
4.08553399444678E-14,
5.61651419817011E-14,
3.06022568397069E-14,
4.94552315766228E-14,
2.5804879066893E-14,
5.101301325805E-14,
2.74415906664771E-14,
5.85373763350994E-14,
3.53996346125207E-14,
7.37240130055383E-14,
4.23740903476855E-14,
8.10549544150163E-14,
4.0392168776382E-14,
9.15838585524575E-14,
3.73668110342784E-14,
9.47549330665431E-14,
3.52452442231588E-14,
1.03508347726322E-13,
3.67171570925251E-14,
  0,
  0,
  0,
  0,
  0,
1.10445506906753E-14,
  0,
1.43331527202584E-14,
  0,
1.55804188994857E-14,
  0,
1.4657112329397E-14,
  0,
1.44008069358215E-14,
  0,
1.52026828625917E-14,
  0,
1.77813493096313E-14,
0.839078243550044,
2.51881848711832E-14,
0.560017024776354,
3.36349871565833E-14,
0.838979976657422,
4.12196318744229E-14,
2.61509564003504E-14,
4.25050619701217E-14,
2.75699602036994E-14,
4.49675019442708E-14,
2.85561504997922E-14,
4.711942641622E-14,
3.56494347930614E-14,
5.23071169711287E-14,
3.18182979963666E-14,
4.91334403718291E-14,
3.16083964557734E-14,
5.39880640193502E-14,
2.91901919302617E-14,
5.43072531389299E-14,
3.49408002531248E-14,
6.94904203624169E-14,
3.53553991638833E-14,
7.5316489156485E-14,
3.84692278032617E-14,
9.00347504884103E-14,
3.55384124905989E-14,
9.6484452372092E-14,
3.69131808453105E-14,
1.02720783268229E-13,
3.49789641695963E-14,
1.01283564868382E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.40503927936741E-14,
  0,
1.90342533401555E-14,
  0,
2.22638747715553E-14,
  0,
1.88534084177849E-14,
  0,
1.69265643168437E-14,
  0,
1.56372310933239E-14,
  0,
2.47310852352634E-14,
0.839025506408603,
3.36449618165702E-14,
0.559925965097535,
4.15275452914088E-14,
0.838940397590148,
4.45242800961587E-14,
2.76566963774982E-14,
4.31746652318488E-14,
2.35497385481231E-14,
4.24495508188905E-14,
2.86142637362374E-14,
4.45598419274162E-14,
2.65646879493708E-14,
4.52754153612567E-14,
3.28053556541974E-14,
5.36714769849844E-14,
3.49945766808801E-14,
5.73031205819419E-14,
3.67050140281933E-14,
6.52099901854442E-14,
3.48878911871076E-14,
7.10386610647262E-14,
3.14357914699137E-14,
8.4293683144665E-14,
3.3584246494911E-14,
9.48850373272414E-14,
3.50552920025393E-14,
1.04374842102573E-13,
3.66035327048486E-14,
1.00430080918201E-13,
2.81684398029114E-14,
  0,
  0,
  0,
1.02381211147806E-14,
  0,
1.02955838299224E-14,
  0,
1.88208823526104E-14,
  0,
2.57524036817447E-14,
  0,
2.6477518094703E-14,
  0,
2.14346769500384E-14,
  0,
1.73984091023094E-14,
  0,
2.26958209170736E-14,
1.85077647651966E-14,
3.36002926870638E-14,
0.838979976657422,
4.15379536322646E-14,
0.5598468068357,
4.49848491790306E-14,
0.838905775076016,
4.51106166310389E-14,
2.35488711863852E-14,
4.069054121425E-14,
2.35931066350226E-14,
3.99714983334576E-14,
1.94783425500056E-14,
3.74023728655359E-14,
2.75422046280838E-14,
4.97856963987964E-14,
3.61325552811209E-14,
5.69362265667728E-14,
4.24426119249866E-14,
6.8215398607574E-14,
3.66581764943419E-14,
6.6789455910321E-14,
3.0964814046186E-14,
8.00245286702861E-14,
2.65334629268033E-14,
8.91136123226666E-14,
3.30681662608079E-14,
1.0277195761077E-13,
3.4781205693335E-14,
1.02066792517785E-13,
2.97791305503559E-14,
9.5813114386889E-14,
  0,
  0,
1.26964411206743E-14,
  0,
1.34751151209533E-14,
  0,
1.51909734791289E-14,
  0,
2.56448508262341E-14,
  0,
3.00735998604029E-14,
1.077089806234E-14,
2.90700623295503E-14,
1.14565475162198E-14,
2.19559613545695E-14,
1.17640272523367E-14,
2.44895249912336E-14,
1.83767931427603E-14,
3.16001565192625E-14,
2.58322009616396E-14,
4.11649880849296E-14,
0.838940397590147,
4.48287240661926E-14,
0.559777561714262,
4.53855703019812E-14,
0.838875314341038,
4.24955209910038E-14,
2.3561014250717E-14,
3.81292220019702E-14,
1.44641243426946E-14,
3.28530605497868E-14,
2.04324404617928E-14,
4.19256643291455E-14,
3.08676695315313E-14,
5.30972835144361E-14,
4.3604876653891E-14,
6.78511066776188E-14,
4.23515389424978E-14,
6.97462920751235E-14,
3.27255583743025E-14,
7.56998630446759E-14,
2.60789653760973E-14,
8.48470599335016E-14,
2.60147806074862E-14,
9.69476235401778E-14,
3.2762854929036E-14,
1.00417070492131E-13,
2.79186396223707E-14,
9.74359481986653E-14,
2.36668323827516E-14,
  0,
1.5297008451598E-14,
  0,
1.62153276916932E-14,
  0,
1.84652640400351E-14,
  0,
2.20912697856956E-14,
  0,
2.99859963248661E-14,
  0,
3.27125479482326E-14,
1.66203856233338E-14,
2.96576999070375E-14,
1.8850806332571E-14,
2.90032754757252E-14,
2.34218026917699E-14,
3.33665386986759E-14,
2.56652338270769E-14,
3.92637311552591E-14,
2.61509564003504E-14,
4.45294842665866E-14,
0.838905775076016,
4.53847029402432E-14,
0.559716640175191,
4.31226235275695E-14,
0.838848373827899,
4.02212985139982E-14,
1.44537160018388E-14,
3.10029779626575E-14,
1.53462312302288E-14,
3.7319973500427E-14,
2.3861121412061E-14,
4.51973528048377E-14,
3.83859610764148E-14,
6.39020086845576E-14,
4.35250793739961E-14,
6.94201640616399E-14,
3.84605541858818E-14,
7.86159332077929E-14,
2.78587916624495E-14,
8.05024449879177E-14,
2.56123247610596E-14,
9.26767343423229E-14,
2.57033977435484E-14,
9.4612685741513E-14,
2.58681964737661E-14,
9.57567358739198E-14,
2.18115456251944E-14,
8.57282994592978E-14,
1.07372877949929E-14,
  0,
1.95735355007498E-14,
  0,
2.14023677252984E-14,
  0,
2.5506940309894E-14,
  0,
2.65104778407466E-14,
  0,
3.27316299064684E-14,
1.52911537598666E-14,
3.33847532951737E-14,
2.39998992901391E-14,
3.67804744993983E-14,
3.05215921980739E-14,
3.78139360102114E-14,
3.06048589249208E-14,
4.11003696354495E-14,
2.62446314680531E-14,
4.25328175457373E-14,
2.76272060784066E-14,
4.51184228866808E-14,
0.838875314341038,
4.31226235275695E-14,
0.559662759097007,
4.06003355934992E-14,
0.838824431055767,
3.3282404610091E-14,
1.55075605134947E-14,
3.55566270870966E-14,
1.87844531596149E-14,
4.06098765726171E-14,
3.12250225675825E-14,
5.60333029975268E-14,
3.81691206419177E-14,
6.54623924511988E-14,
3.95733792957209E-14,
7.82898051943093E-14,
3.36120020705266E-14,
8.3400300554537E-14,
2.7450264283857E-14,
8.8336456205429E-14,
2.53208912170955E-14,
9.02646013489772E-14,
1.88243517995623E-14,
8.990117678076E-14,
1.97602351148518E-14,
8.40482197728143E-14,
1.14569811970888E-14,
  0,
1.73105887263381E-14,
  0,
2.51773428494584E-14,
  0,
2.86342130562112E-14,
  0,
3.0069263051713E-14,
  0,
2.93003468709863E-14,
  0,
3.33470230595712E-14,
2.26698000649339E-14,
4.04732670988839E-14,
3.56503021547994E-14,
4.55924360764914E-14,
3.7767965838098E-14,
4.5623661099059E-14,
3.11833892041591E-14,
4.42675410217142E-14,
2.75413372663458E-14,
4.31226235275695E-14,
2.35913719115466E-14,
4.2480775841458E-14,
0.838848373827899,
4.06428363186606E-14,
0.559614873513332,
3.34185804029552E-14,
0.83880305704013,
3.75021194654046E-14,
1.86873086449602E-14,
3.86730578116889E-14,
2.62238147863414E-14,
5.14354184244503E-14,
3.1041141879129E-14,
5.7594554125906E-14,
3.42339004366643E-14,
7.43806058411955E-14,
3.46606424117546E-14,
8.30047836020142E-14,
3.31141364329213E-14,
9.11996173025287E-14,
2.70651556721901E-14,
8.59451398937949E-14,
1.8399344547948E-14,
8.55721743464599E-14,
1.26938390354603E-14,
7.81701092744669E-14,
  0,
8.00158550529062E-14,
  0,
  0,
2.39060073820019E-14,
  0,
3.27806358446647E-14,
  0,
3.33249053352525E-14,
  0,
3.29515061070484E-14,
  0,
3.00254612839446E-14,
1.67205659040714E-14,
4.05829883587394E-14,
3.43791835277774E-14,
4.9290866527274E-14,
4.29899171816572E-14,
5.34086663783739E-14,
3.8372950650345E-14,
4.88038429113935E-14,
3.26067298161981E-14,
4.49952575198864E-14,
2.35497385481231E-14,
4.069054121425E-14,
2.3561014250717E-14,
4.02282374079022E-14,
0.838824431055767,
3.35027144915401E-14,
0.559572125451801,
3.77406439433514E-14,
0.838783896903748,
4.07460523654812E-14,
2.61847835081319E-14,
4.97102359275914E-14,
2.60668223117655E-14,
5.29350868694323E-14,
2.71406161433951E-14,
6.64633278968374E-14,
2.93662663630734E-14,
7.90461446298352E-14,
3.41870629028129E-14,
9.07659364335345E-14,
3.27949473133415E-14,
8.87978926500388E-14,
2.01809055577762E-14,
8.12102121661162E-14,
1.22540866343002E-14,
7.37803915185076E-14,
  0,
7.41099889789432E-14,
  0,
  0,
1.80166211810606E-14,
  0,
3.20028292061236E-14,
  0,
3.77631953485391E-14,
  0,
3.63840901851376E-14,
  0,
3.37781018433514E-14,
1.46328262007334E-14,
3.72657633918028E-14,
2.8424311515618E-14,
4.94478590018499E-14,
4.17456867685129E-14,
5.71691131934227E-14,
4.35654116948125E-14,
5.65771388072456E-14,
3.97373106642007E-14,
4.94968649400462E-14,
2.85882428840978E-14,
4.24365403928206E-14,
2.3634739998446E-14,
3.80771802976909E-14,
1.45187681321879E-14,
3.33023539300648E-14,
0.83880305704013,
3.77415113050894E-14,
0.559533805155591,
4.08770239879175E-14,
0.838766655023202,
5.18586909525887E-14,
2.60512098004817E-14,
5.11899550525996E-14,
2.21706333847216E-14,
6.17656967238922E-14,
2.22400223237607E-14,
7.11687653254245E-14,
2.88779417045859E-14,
8.68098995465694E-14,
3.39103745083946E-14,
8.83659465045206E-14,
2.58577881329103E-14,
8.40404135171724E-14,
1.40339129206524E-14,
6.94158272529499E-14,
  0,
6.97298122021017E-14,
  0,
6.89804116604797E-14,
1.1536886897201E-14,
  0,
2.72037167098338E-14,
  0,
3.74322968454965E-14,
  0,
4.10305470155414E-14,
1.38838593399804E-14,
3.73477290760427E-14,
1.47867829092263E-14,
4.10977675502355E-14,
2.64627729451572E-14,
4.62030587400353E-14,
3.57990546928644E-14,
5.73846525853128E-14,
4.22955941103975E-14,
6.03649075170409E-14,
4.4949287347773E-14,
5.73022532202039E-14,
3.57014764973407E-14,
4.70899361171284E-14,
2.86133963744994E-14,
3.99871108447414E-14,
1.44936146417862E-14,
3.09778244722558E-14,
1.55075605134947E-14,
3.74466083141733E-14,
0.838783896903748,
4.08804934348694E-14,
0.559499321376161,
5.18109860569993E-14,
0.83875108353725,
5.3256878074226E-14,
2.21307347447741E-14,
5.99771968201601E-14,
1.72500902451134E-14,
6.65119001541647E-14,
2.17447587713693E-14,
7.88605292179057E-14,
2.86107942892855E-14,
8.43171019115907E-14,
2.69888278392472E-14,
8.35833138812525E-14,
1.97220711983803E-14,
7.22876619674295E-14,
  0,
6.53617784895921E-14,
  0,
6.46054390540662E-14,
  0,
  0,
2.34129122339555E-14,
  0,
3.32683099818487E-14,
  0,
4.10283786111965E-14,
1.50907931983912E-14,
4.21151828688959E-14,
2.14368453543834E-14,
4.47441562967388E-14,
2.66574956553356E-14,
5.01217990722669E-14,
3.3811061589395E-14,
5.41194693226554E-14,
3.64205193781331E-14,
6.05960594202148E-14,
4.36855412955239E-14,
6.11290532082087E-14,
4.09438108417426E-14,
5.48944570355481E-14,
3.56355570052536E-14,
4.45338210752766E-14,
1.94930876995514E-14,
3.28253049741711E-14,
1.5332353442421E-14,
3.55410145758128E-14,
1.8701186432768E-14,
4.07807468350008E-14,
0.838766655023202,
5.17953735457155E-14,
0.559468178389805,
5.37521416266173E-14,
0.838736973374555,
6.18515655359531E-14,
1.7281315267681E-14,
6.46401335235858E-14,
1.67409489049142E-14,
7.42210112814057E-14,
2.14368453543834E-14,
7.64327837132761E-14,
2.16883802584E-14,
7.95726332047941E-14,
2.08487740960273E-14,
7.18158171819638E-14,
  0,
6.82206027780019E-14,
  0,
6.02434768737226E-14,
  0,
7.26666990469305E-14,
1.54749260281029E-14,
  0,
3.07314937386671E-14,
  0,
3.72926516056804E-14,
1.59273635946811E-14,
4.23706209007335E-14,
2.28042411343221E-14,
4.96868171606657E-14,
3.33860543377806E-14,
5.38714038655908E-14,
3.41254802194157E-14,
5.81214763817339E-14,
3.4480664851122E-14,
5.74687866738977E-14,
3.78369210962681E-14,
6.13606387922516E-14,
3.97589947076504E-14,
5.87238591087669E-14,
4.08640135618477E-14,
5.22932391833208E-14,
2.65377997354932E-14,
3.74171180150817E-14,
2.03951439070593E-14,
3.73165040534751E-14,
1.87566975839992E-14,
3.87337731333481E-14,
2.61275376334247E-14,
5.17806283961697E-14,
0.83875108353725,
5.3700099922338E-14,
0.559439958052934,
6.22531540206417E-14,
0.838724147188486,
6.67547614408015E-14,
1.67782454596477E-14,
7.23527140977787E-14,
1.63948715714568E-14,
7.17689796481125E-14,
1.45447889843275E-14,
7.1728213646427E-14,
1.55058257900187E-14,
6.77695746742479E-14,
1.04447700488564E-14,
6.77340128429904E-14,
  0,
6.30398511169972E-14,
  0,
6.82561646092594E-14,
  0,
  0,
2.61637499859857E-14,
  0,
3.54419184972476E-14,
1.30585646462844E-14,
3.89597208660941E-14,
2.37010931714021E-14,
5.00775636236295E-14,
3.48076602263436E-14,
5.89086071589584E-14,
4.08631462001097E-14,
6.19825371583893E-14,
3.48050581411297E-14,
6.14885746486049E-14,
3.5972960721331E-14,
5.82927803249866E-14,
3.38409855693556E-14,
5.89944759710193E-14,
3.96965446625153E-14,
5.61755503225569E-14,
3.18503903806722E-14,
4.52823542551606E-14,
2.7528326840276E-14,
4.19534199047611E-14,
2.38741318381308E-14,
4.05682432091936E-14,
2.62272842332933E-14,
4.97067664806394E-14,
2.6025188948342E-14,
5.3256878074226E-14,
0.838736973374555,
6.22548887441177E-14,
0.559414305671607,
6.67443530999456E-14,
0.838712453749347,
7.42539710274492E-14,
1.6454719531378E-14,
6.98842025914637E-14,
  0,
6.70314498352198E-14,
  0,
5.99416349889026E-14,
  0,
6.37311384221739E-14,
  0,
6.25957619071471E-14,
  0,
7.11002437481234E-14,
  0,
7.06422767504655E-14,
1.4732572800602E-14,
  0,
3.22795176005419E-14,
1.33012090924867E-14,
3.75736768087886E-14,
2.09632658454417E-14,
4.69624339416441E-14,
3.59100769953269E-14,
5.9533541291179E-14,
4.24582244362703E-14,
6.71806360541538E-14,
4.16572158712381E-14,
6.54337695138452E-14,
3.63064613095876E-14,
6.2381523557864E-14,
3.19961071526542E-14,
5.5949168908942E-14,
3.38357813989276E-14,
5.64505039934993E-14,
3.06196040744666E-14,
4.91481855213749E-14,
3.28114271863633E-14,
4.98004415483422E-14,
3.08650674463173E-14,
4.51834750170299E-14,
3.12310940997484E-14,
5.14224079983805E-14,
2.60668223117655E-14,
5.115959739177E-14,
2.21515514264858E-14,
6.19374343480139E-14,
0.838724147188486,
6.66732294374306E-14,
0.559390918785919,
7.46009157226446E-14,
0.838701763460174,
7.19970957852034E-14,
  0,
6.50157011561348E-14,
  0,
5.52908413498088E-14,
  0,
5.58051868604359E-14,
  0,
5.85885506776407E-14,
1.03155331498961E-14,
7.05971739400901E-14,
  0,
7.34343141850502E-14,
  0,
  0,
2.41855147020686E-14,
1.45179007704499E-14,
3.5156773325884E-14,
2.14173297152787E-14,
4.59471870273287E-14,
3.33157980370036E-14,
5.66369867671668E-14,
4.36560509964323E-14,
6.79569248096534E-14,
4.32991316412501E-14,
7.06990889443038E-14,
4.3228441659604E-14,
6.63549076795888E-14,
3.24020324460328E-14,
6.00847496756707E-14,
3.20481488569335E-14,
5.34208094427058E-14,
2.47727185986868E-14,
4.94500274061949E-14,
3.16057943705594E-14,
5.36862221345302E-14,
3.61464330689287E-14,
5.30643237683925E-14,
3.83590728625371E-14,
5.60480481470726E-14,
3.10515502199848E-14,
5.29836591267596E-14,
2.21654292142937E-14,
5.99754620966841E-14,
1.73368264189122E-14,
6.6714862800854E-14,
0.838712453749347,
7.46009157226446E-14,
0.559369538201562,
7.2104648640714E-14,
0.838691964745978,
6.71390026907304E-14,
  0,
5.32490718185841E-14,
  0,
5.11188313900846E-14,
  0,
5.05984143472915E-14,
  0,
6.65960342427496E-14,
  0,
7.29572652291566E-14,
  0,
6.8737550373843E-14,
1.31821636939478E-14,
1.25286066243735E-14,
2.83180597027144E-14,
2.3036260399234E-14,
4.39999599255447E-14,
3.39953759587175E-14,
5.59097039498635E-14,
4.1284250323903E-14,
6.52542256340816E-14,
4.46257614195034E-14,
7.16323701743793E-14,
4.48950772391488E-14,
7.17590049881256E-14,
3.93205433490973E-14,
6.41431352477184E-14,
3.24714213850719E-14,
5.76058298284998E-14,
2.29850860566927E-14,
4.64290064727813E-14,
2.58135526842729E-14,
5.39950029132541E-14,
3.49668211052645E-14,
5.69084709911571E-14,
4.36144176330089E-14,
6.39098149401995E-14,
3.81951414940573E-14,
5.76223097015216E-14,
2.70712272043561E-14,
6.17639620004162E-14,
1.72500902451134E-14,
6.46644196522494E-14,
1.67782454596477E-14,
7.42262154518336E-14,
0.838701763460174,
7.2104648640714E-14,
0.559349940768273,
6.71121144768527E-14,
0.838682961127209,
5.52821677324289E-14,
  0,
4.91820126291564E-14,
  0,
4.59320081969139E-14,
  0,
5.86223777854222E-14,
  0,
6.89101553597027E-14,
  0,
6.82223375014779E-14,
  0,
  0,
2.02960478284941E-14,
2.17447587713693E-14,
3.7924524631805E-14,
3.59534450822263E-14,
5.43441160127944E-14,
4.21346985080007E-14,
6.4775875635581E-14,
4.240661641286E-14,
6.91473787950425E-14,
4.63244893833537E-14,
7.27898644137248E-14,
4.10583025911571E-14,
6.96144530909493E-14,
3.94059784802891E-14,
6.16937056996392E-14,
2.3414430116997E-14,
5.06495886898328E-14,
2.39634700971436E-14,
5.10268910458578E-14,
2.91901919302617E-14,
5.729097751761E-14,
4.24426119249866E-14,
6.78580455715228E-14,
4.35112015861883E-14,
6.5448514663391E-14,
3.42234920958084E-14,
6.64251639803659E-14,
2.22027257690272E-14,
6.65370536445664E-14,
1.67262037553684E-14,
7.23561835447306E-14,
1.64269639557624E-14,
7.19962284234654E-14,
0.838691964745978,
6.71259922646605E-14,
0.559331933526712,
5.55796728085589E-14,
0.838674668833102,
5.13929176992889E-14,
  0,
4.4052435310693E-14,
  0,
5.39559716350446E-14,
  0,
6.09798669892747E-14,
  0,
6.41630845676922E-14,
  0,
6.38100683403309E-14,
1.02412653010808E-14,
2.14333759074314E-14,
3.10968698707947E-14,
3.52404737335998E-14,
4.88333332104851E-14,
4.44379776032289E-14,
6.36040699275586E-14,
4.34786755210137E-14,
6.88954102101569E-14,
4.42115961896139E-14,
7.04080890812087E-14,
4.2560139440484E-14,
7.07177372216705E-14,
4.11944783840212E-14,
6.72465555462409E-14,
3.03888858521617E-14,
5.47383319227102E-14,
2.4457866287797E-14,
5.52344628368395E-14,
2.74242434317173E-14,
5.4304651053716E-14,
3.6724963348167E-14,
6.81885103936963E-14,
4.23645493685676E-14,
6.94036841886181E-14,
3.95837876365768E-14,
7.43788711177196E-14,
2.93662663630734E-14,
7.11817757514943E-14,
2.17022580462078E-14,
7.42036640466459E-14,
1.64252292322864E-14,
6.98772636975598E-14,
  0,
6.72153305236733E-14,
0.838682961127209,
5.55805401702969E-14,
0.559315348935185,
5.14250100835945E-14,
0.838667014844071,
4.60794596923719E-14,
  0,
5.20330306619243E-14,
  0,
5.62805010928535E-14,
-1.01143052266828E-14,
5.61894281103648E-14,
-1.02791039569006E-14,
5.98132654516803E-14,
-1.30936927966729E-14,
1.47855902868366E-14,
2.363734208366E-14,
3.61156417272301E-14,
4.28394299201162E-14,
4.42332802330636E-14,
5.85156922916497E-14,
4.60092033915949E-14,
6.79642973844263E-14,
4.54206984523697E-14,
7.03543126534534E-14,
4.05513296553028E-14,
6.84443821064029E-14,
4.27405506819856E-14,
6.84426473829269E-14,
3.2238968439291E-14,
6.03466929205432E-14,
3.14522713429355E-14,
5.9387390838328E-14,
2.78839451528512E-14,
5.85581930168111E-14,
3.49156467627232E-14,
6.52039186532782E-14,
3.66581764943419E-14,
6.97645066716213E-14,
3.8447543759812E-14,
7.82863357473573E-14,
3.46554382413267E-14,
7.90444099063592E-14,
2.88640639167781E-14,
7.88865500700453E-14,
2.14090897787678E-14,
7.17689796481125E-14,
  0,
6.50139664326588E-14,
  0,
5.53376788836601E-14,
0.838674668833102,
5.14215406366425E-14,
0.55930004095437,
4.61644611426948E-14,
0.838659935277098,
5.41875572190875E-14,
  0,
5.42768954781003E-14,
-1.5031378919339E-14,
5.1460571914852E-14,
-1.73593778240999E-14,
5.18057818865714E-14,
-1.84435799965854E-14,
5.56438575771701E-14,
1.70405139651719E-14,
3.2910740105363E-14,
3.67876302337367E-14,
4.59823151777172E-14,
5.3105089770078E-14,
4.61982882504763E-14,
6.32423800828175E-14,
4.81546226505092E-14,
6.9637438177006E-14,
4.18471680918575E-14,
6.85228783436909E-14,
4.07824815584767E-14,
6.62360791214844E-14,
3.38201688876438E-14,
6.16173778666962E-14,
3.33379157613223E-14,
6.49827414100912E-14,
3.48930953575355E-14,
6.27432134026051E-14,
3.53996346125207E-14,
6.94765425746091E-14,
3.48982995279634E-14,
6.67764454842512E-14,
3.27116805864947E-14,
7.86376172512426E-14,
3.36172062409545E-14,
8.30134572193941E-14,
3.42113490314766E-14,
8.68029606526655E-14,
2.86264068005693E-14,
7.64189059254683E-14,
1.45170334087119E-14,
6.70245109413159E-14,
  0,
5.32456023716321E-14,
  0,
5.12272516073331E-14,
0.838667014844071,
4.61714000365987E-14,
0.559285881818123,
5.43636316518992E-14,
0.838653374047174,
5.63065219449932E-14,
-1.48388246135056E-14,
4.9586203199059E-14,
-2.23805349253148E-14,
4.7118559054482E-14,
-2.55975796115138E-14,
4.76788747372225E-14,
-1.79630615937398E-14,
2.32296820668054E-14,
3.40144579169532E-14,
4.44761415197004E-14,
4.80063037933132E-14,
4.85549100925908E-14,
5.83179338153883E-14,
4.86286358403198E-14,
6.52368783993218E-14,
4.47788507662583E-14,
6.7986415108745E-14,
4.21967148722668E-14,
6.64459806620776E-14,
3.19189119579733E-14,
5.95279034398821E-14,
3.49642190200505E-14,
6.63210805718073E-14,
3.67787397759223E-14,
6.84027487429795E-14,
4.2412254264157E-14,
7.37101352177305E-14,
3.53215720561018E-14,
7.10429978734162E-14,
3.09474668114262E-14,
7.57198123646496E-14,
2.78596590241875E-14,
8.34263214066766E-14,
3.31280142207291E-14,
9.07919572856741E-14,
3.38930272736349E-14,
8.43587352750141E-14,
2.16606246827844E-14,
7.17004580708114E-14,
  0,
5.52899739880708E-14,
  0,
4.91889515230604E-14,
  0,
4.60239485411407E-14,
0.838659935277098,
5.43835809718729E-14,
0.559272759356352,
5.61876933868888E-14,
0.838647281752124,
5.15238893217251E-14,
-2.23310953062494E-14,
4.52103632309075E-14,
-3.06560332674621E-14,
4.29491511799718E-14,
-2.50979792504324E-14,
5.2208237732998E-14,
2.22247350731286E-14,
3.98420445940628E-14,
4.70383280937181E-14,
4.8094341009719E-14,
5.38835469299226E-14,
5.13716673367082E-14,
6.0657642103612E-14,
4.54471529853784E-14,
6.38490996185404E-14,
4.52441903386891E-14,
6.60881939451574E-14,
3.34489380637848E-14,
5.98123980899423E-14,
3.31176058798732E-14,
6.43140055101021E-14,
3.84631562710958E-14,
6.9780986544643E-14,
4.43204500877314E-14,
7.93904872398166E-14,
4.23740903476855E-14,
7.53026113686772E-14,
3.14262504907958E-14,
8.00384064580939E-14,
2.60919758021672E-14,
8.05302005635333E-14,
2.74294476021453E-14,
9.12134950903365E-14,
3.27949473133415E-14,
8.83485992697608E-14,
2.7000970903579E-14,
7.95379387352746E-14,
1.54772028526651E-14,
5.98817870289814E-14,
  0,
5.11058209640147E-14,
  0,
4.40507005872171E-14,
  0,
5.41684752608518E-14,
0.838653374047174,
5.61417232147754E-14,
0.55926057476464,
5.19766521489551E-14,
0.838641614739164,
4.68323296809459E-14,
-3.07063402482655E-14,
4.10270775685895E-14,
-3.01260752455512E-14,
4.75054023896249E-14,
-2.7523122669848E-14,
2.27654266965471E-14,
4.02505719726554E-14,
4.54350099210465E-14,
5.40383710001535E-14,
5.15559817060307E-14,
5.6697268407957E-14,
4.85006999839666E-14,
5.95482864407249E-14,
4.61028784592976E-14,
6.20666712469742E-14,
3.65436847449274E-14,
5.95760420163405E-14,
3.46441625387328E-14,
6.47103898243628E-14,
3.6647768153486E-14,
6.78519740393568E-14,
4.60265506263546E-14,
8.08112257666416E-14,
4.43013681294957E-14,
8.10436787124225E-14,
3.84796361441175E-14,
8.42659275690494E-14,
2.65195851389954E-14,
8.4814967549196E-14,
2.56019164202037E-14,
8.83780895688524E-14,
2.70720945660941E-14,
8.88117704378466E-14,
2.58577881329103E-14,
8.35824465195145E-14,
2.08348963082194E-14,
6.77964628881256E-14,
  0,
5.58225340951957E-14,
  0,
4.59588964107915E-14,
  0,
5.20451737262562E-14,
  0,
5.6322134456277E-14,
0.838647281752124,
5.1980121595907E-14,
0.559249240737358,
4.71359062892418E-14,
0.838636334320127,
4.29647636912556E-14,
-3.02457711653936E-14,
4.55668489052208E-14,
-3.24228491277445E-14,
5.05897407299116E-14,
2.42586983487114E-14,
3.33739112734488E-14,
4.93058285172543E-14,
4.99552656185731E-14,
5.75776405720152E-14,
4.91065521579515E-14,
5.59283522272302E-14,
4.93238262733176E-14,
5.80126224836164E-14,
3.74860732732518E-14,
5.57097770692572E-14,
3.78195738615084E-14,
6.45794182019266E-14,
3.82246317931489E-14,
6.83056042283248E-14,
4.42684083834521E-14,
7.89524695621324E-14,
4.60274179880926E-14,
8.2502581155719E-14,
4.04060465641898E-14,
9.00451588292661E-14,
3.3585113856649E-14,
8.91006018965967E-14,
2.6027791033556E-14,
9.26663260014671E-14,
2.53208912170955E-14,
8.5939935723367E-14,
2.02086611333918E-14,
8.40326072615305E-14,
1.97151323044764E-14,
7.18453074810554E-14,
1.04586478366642E-14,
6.37380773160778E-14,
  0,
5.05984143472915E-14,
  0,
5.39637778906865E-14,
  0,
5.42179148799171E-14,
-1.48683149125972E-14,
5.14683781704939E-14,
0.838641614739164,
4.71298347570759E-14,
0.559238679898133,
4.36239586121268E-14,
0.838631406108915,
4.7643312905965E-14,
-3.27229562890885E-14,
4.86208295846779E-14,
-3.60111246378025E-14,
1.57210399212571E-14,
3.86791293438549E-14,
3.96874373642664E-14,
5.4001508126289E-14,
4.81320712453215E-14,
5.72545483246145E-14,
5.02258824808255E-14,
5.46264422585097E-14,
4.08644472427167E-14,
5.17845315239907E-14,
3.87949221358763E-14,
6.08124661738429E-14,
4.1434737585444E-14,
6.82552972475214E-14,
4.59163956856301E-14,
7.94676824344975E-14,
4.43031028529717E-14,
8.06767846972534E-14,
4.22006180000878E-14,
9.15933995315754E-14,
3.55384124905989E-14,
9.48919762211453E-14,
3.30959218364235E-14,
9.69710423071035E-14,
2.57033977435484E-14,
9.0281081221999E-14,
1.84201612296597E-14,
8.12102121661162E-14,
1.40330455589144E-14,
7.22867946056915E-14,
  0,
6.77348802047284E-14,
  0,
5.85911527628546E-14,
  0,
5.86223777854222E-14,
  0,
5.62796337311156E-14,
-1.50175011315312E-14,
4.95254878773999E-14,
-2.23874738192187E-14,
4.68635547035134E-14,
0.838636334320127,
4.36230912503888E-14,
0.559228823474719,
4.78020401040169E-14,
0.838626799459827,
5.07779582270551E-14,
-3.61932706027801E-14,
4.77430595058337E-14,
2.04046848861772E-14,
2.5802710662548E-14,
4.53903407915401E-14,
3.87897179654484E-14,
5.43883514614318E-14,
4.96542910954911E-14,
5.62692253902597E-14,
4.19490830960711E-14,
4.86004465838352E-14,
4.22804152799827E-14,
5.70385752518554E-14,
4.25050619701217E-14,
6.46436029705377E-14,
4.91776758204665E-14,
7.95119178831349E-14,
4.59892540716211E-14,
8.1299550425129E-14,
4.04962521849406E-14,
8.97684704348478E-14,
3.73668110342784E-14,
9.64948607129479E-14,
3.50457510234214E-14,
1.02799713186386E-13,
3.27888757811756E-14,
9.4612685741513E-14,
1.88139434587065E-14,
8.55513576647482E-14,
1.22601581664661E-14,
6.94149598912119E-14,
  0,
6.8213663884098E-14,
  0,
6.25818841193393E-14,
1.03155331498961E-14,
6.65951668810116E-14,
  0,
6.0959917669301E-14,
-1.01281830144906E-14,
5.14883274904676E-14,
-2.23814022870528E-14,
4.52025569752657E-14,
-3.07028708013135E-14,
4.29933866286092E-14,
0.838631406108915,
4.76918851632924E-14,
0.559219610175705,
5.10659223240673E-14,
0.8386224869897,
4.95419677504216E-14,
-3.34472033403088E-14,
1.40322866173936E-14,
3.17567153129694E-14,
2.62919026827735E-14,
4.68557484478715E-14,
4.08570746679437E-14,
5.38844142916606E-14,
4.16663231694869E-14,
5.04717795335452E-14,
4.35376561191969E-14,
5.39672473376385E-14,
4.61171899279744E-14,
6.09356315406373E-14,
5.03095828885414E-14,
7.59461937782646E-14,
4.93043106342128E-14,
8.13906234076178E-14,
4.21988832766118E-14,
9.04771049747843E-14,
3.56711188365111E-14,
9.47479941726392E-14,
3.68854252696948E-14,
1.04387852528642E-13,
3.4782073055073E-14,
1.00429213556463E-13,
2.5878604814622E-14,
8.99150545685679E-14,
1.27007779293642E-14,
7.37708505393897E-14,
  0,
6.53227472113826E-14,
  0,
6.30467900109011E-14,
  0,
7.05806940670684E-14,
  0,
6.89014817423228E-14,
  0,
5.6173815599081E-14,
-1.73663167180038E-14,
4.70621805415128E-14,
-3.06352165857504E-14,
4.10288122920655E-14,
-3.0219750313254E-14,
4.7641578182489E-14,
0.838626799459827,
5.11734751795778E-14,
0.55921098523473,
4.99045249569008E-14,
0.838618444169745,
5.09228076372992E-14,
1.62584789381581E-14,
1.75694962051276E-14,
3.49254045822756E-14,
2.90301636896029E-14,
4.6968939154679E-14,
3.32264597779908E-14,
4.83827387876001E-14,
4.34504862645291E-14,
5.6025063061016E-14,
4.74668047922844E-14,
5.80130561644854E-14,
5.4001941807158E-14,
7.23735307794904E-14,
5.05368316638943E-14,
7.79307174347821E-14,
4.5546899585247E-14,
9.06349648110982E-14,
3.7395433971632E-14,
9.54618328830037E-14,
3.5227029626661E-14,
1.02720783268229E-13,
3.66174104926564E-14,
1.02075466135165E-13,
2.79247111545367E-14,
9.57428580861119E-14,
1.97541635826859E-14,
7.81718439979429E-14,
  0,
6.97306795638397E-14,
  0,
6.02391400650326E-14,
  0,
7.10915701307435E-14,
  0,
7.29737451021784E-14,
  0,
6.41700234615961E-14,
-1.02773692334246E-14,
5.18109860569993E-14,
-2.56201310167015E-14,
4.29508859034478E-14,
-3.01191363516473E-14,
4.5552971117413E-14,
-3.26405569239796E-14,
5.07640804392473E-14,
0.8386224869897,
4.99045249569008E-14,
0.559202899594195,
5.13703662941012E-14,
0.838614648975746,
  0,
2.30850494969959E-14,
2.13321114245213E-14,
3.58901276753532E-14,
2.17889942200067E-14,
4.18783931144251E-14,
3.51979730084384E-14,
5.41827867295286E-14,
4.75426989443584E-14,
6.0210517127679E-14,
5.54651810591444E-14,
6.95875648770716E-14,
5.42916406276461E-14,
7.44595357593525E-14,
4.68436053835397E-14,
8.72409783303496E-14,
4.0836257986232E-14,
9.5741123362636E-14,
3.69756308904456E-14,
1.03494469938514E-13,
3.49650863817885E-14,
1.00444826067747E-13,
2.97938756999017E-14,
9.74238051343335E-14,
2.18054740930285E-14,
8.40837816040718E-14,
  0,
7.4120397319799E-14,
  0,
6.46054390540662E-14,
  0,
6.82717771205432E-14,
  0,
7.34134975033385E-14,
  0,
6.82240722249539E-14,
  0,
5.98158675368943E-14,
-1.84331716557296E-14,
4.76823441841745E-14,
-2.50684889513408E-14,
4.75062697513629E-14,
-3.24497373416222E-14,
4.86208295846779E-14,
-3.61637803036885E-14,
4.96408469885523E-14,
0.838618444169745,
5.13287329306777E-14,
0.559195309205659,
5.64270852265736E-14,
1.03982577756567E-14,
1.1665581695075E-14,
2.53033271419012E-14,
1.45374164095546E-14,
3.12709927396959E-14,
2.39998992901391E-14,
4.79390832586191E-14,
3.94523823332715E-14,
5.85551572507281E-14,
5.56590364075848E-14,
7.19285742079023E-14,
5.58381466064795E-14,
7.17594386689946E-14,
5.06547928602608E-14,
8.38521960200289E-14,
4.2108677655861E-14,
9.24017806713806E-14,
4.03965055850719E-14,
1.03829271569378E-13,
3.67128202838352E-14,
1.01276625974478E-13,
2.81623682707455E-14,
9.58347984303387E-14,
2.36720365531795E-14,
8.57439119705816E-14,
1.14708589848966E-14,
8.00089161590023E-14,
  0,
6.89934220865496E-14,
  0,
7.26389434713148E-14,
  0,
7.06301336861337E-14,
  0,
6.87297441182011E-14,
  0,
6.38308850220426E-14,
-1.31075705844808E-14,
5.56577353649779E-14,
-1.79630615937398E-14,
5.21666043695745E-14,
-2.75161837759441E-14,
5.06174963055273E-14,
-3.60007162969467E-14,
4.77395900588817E-14,
-3.34472033403088E-14,
5.09800535120064E-14,
0.838614648975746,
5.64322893970015E-14,
0.559188174428326,
  0,
  0,
  0,
0.999999999999994,
  0,
-1.00554330487168E-14,
-1.06920223542917E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.16521375881362E-14,
  0,
1.27076084030509E-14,
  0,
1.80141275160639E-14,
  0,
1.49362943888121E-14,
  0,
1.43065897670325E-14,
  0,
1.74146721348967E-14,
1.81770831025885E-14,
1.93157122241328E-14,
2.05779403933404E-14,
2.07647484276596E-14,
2.29226360115575E-14,
2.40963932834903E-14,
2.14912723034422E-14,
2.75742970123893E-14,
2.23280595401665E-14,
2.18954628733448E-14,
  0,
1.36936902789264E-14,
  0,
  0,
  0,
0.878310065653673,
  0,
0.872871560943955,
-1.6790171683545E-14,
-1.6363104447803E-14,
-1.68996761029661E-14,
-1.22773969810086E-14,
-1.43704492749919E-14,
  0,
-1.02283632952282E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.83728900149394E-14,
  0,
2.11343529482599E-14,
  0,
2.66407989418793E-14,
  0,
2.85498621271918E-14,
  0,
2.5314602844495E-14,
1.07203742411022E-14,
2.74749840933897E-14,
2.38494120285981E-14,
3.17933613463994E-14,
3.35734044731861E-14,
3.46988063282261E-14,
3.76595456208495E-14,
3.8855420617101E-14,
3.8442773270253E-14,
4.47719118723544E-14,
3.79323308874469E-14,
4.28491877396686E-14,
2.78993408237005E-14,
3.08273372107148E-14,
1.35132790374248E-14,
2.20758741148463E-14,
  0,
0.878310065653673,
  0,
0.59628479399993,
-1.60717793240561E-14,
0.849411985729357,
-2.04440414250384E-14,
-1.79166577407575E-14,
-2.05070335712598E-14,
-1.18249594144304E-14,
-1.50784332936249E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02658766903962E-14,
  0,
1.62350601712324E-14,
  0,
2.51784270516309E-14,
  0,
3.20017450039511E-14,
  0,
3.32691773435867E-14,
  0,
3.54488573911516E-14,
1.32908007516308E-14,
3.5155038602408E-14,
2.30297551861991E-14,
3.79310298448399E-14,
3.52677956283465E-14,
4.28498382609721E-14,
4.59771110072893E-14,
4.79967628141953E-14,
4.80657180723654E-14,
5.40218911271317E-14,
4.99535308950971E-14,
5.39902324236952E-14,
3.87979579019593E-14,
4.68384012131118E-14,
2.90501130095766E-14,
3.58801530153663E-14,
1.45248396643538E-14,
0.999999999999994,
  0,
0.59628479399993,
-1.6271489364228E-14,
0.545454545454528,
-1.94947140028101E-14,
0.840454842765479,
-2.36026476141404E-14,
-1.67296732023203E-14,
-2.04749411869543E-14,
  0,
-1.22803243268743E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.6566392355144E-14,
  0,
2.20995097222065E-14,
  0,
3.49394992105179E-14,
  0,
3.72770390943966E-14,
  0,
3.87025481107806E-14,
1.32068835034804E-14,
4.38342938335889E-14,
2.48928481993982E-14,
4.40415932889682E-14,
3.32507459066544E-14,
4.72464949108353E-14,
4.59454523038527E-14,
5.4227455859035E-14,
5.44143723135715E-14,
6.10184645866152E-14,
5.75216957399149E-14,
6.09351978597683E-14,
4.88641245521837E-14,
5.58177636056367E-14,
3.84800698249865E-14,
5.01777439043671E-14,
2.91845540789648E-14,
3.39268543814164E-14,
  0,
0.872871560943955,
-1.60717793240561E-14,
0.545454545454528,
-1.95904490546406E-14,
0.525971891352156,
-2.22610558459069E-14,
0.83599831423911,
-2.33246581771152E-14,
-1.20936247127723E-14,
-1.74344046144359E-14,
  0,
-1.40846535823247E-14,
  0,
-1.02821397229835E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.41115417962023E-14,
  0,
2.20513711457482E-14,
  0,
3.12341298658314E-14,
  0,
3.94398055880707E-14,
  0,
4.19438789256432E-14,
1.47932881222612E-14,
4.6224309102616E-14,
2.44435548191202E-14,
5.19024927203571E-14,
3.45014815328337E-14,
5.24146698266392E-14,
4.3085326972836E-14,
5.75589922946484E-14,
5.32729242663788E-14,
6.60305143895812E-14,
6.26577782714133E-14,
6.66237898183653E-14,
5.52695909872281E-14,
6.15020187555437E-14,
4.76346392885851E-14,
5.8037775974018E-14,
3.7919754142246E-14,
4.73492772767869E-14,
2.83302027670462E-14,
-1.00554330487168E-14,
-1.68161925356847E-14,
0.849411985729357,
-1.9501652896714E-14,
0.525971891352156,
-2.16929339075245E-14,
0.516247292013478,
-2.11564706725786E-14,
0.833437219948181,
-1.9712313378828E-14,
-1.16425966090183E-14,
-1.8999558870636E-14,
  0,
-1.43526683593631E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.23533995532998E-14,
  0,
1.93655855240671E-14,
  0,
3.08728737019592E-14,
  0,
3.52881786291892E-14,
  0,
4.35779884400134E-14,
1.34870413448507E-14,
4.89326461294848E-14,
2.57641130652075E-14,
5.3625506812871E-14,
3.36623090513299E-14,
5.95829809102444E-14,
4.38754935161434E-14,
6.21239171216814E-14,
4.98268960813508E-14,
6.86109155600967E-14,
6.07890474069173E-14,
7.08049070763384E-14,
5.9686630637934E-14,
6.6418225086462E-14,
5.34134368679329E-14,
6.29986514344427E-14,
4.65500034352306E-14,
5.45427418507938E-14,
3.6648201834355E-14,
5.0863827039116E-14,
-1.06920223542917E-14,
-1.64255544929381E-14,
-2.04436077441694E-14,
0.840454842765479,
-2.24254208952557E-14,
0.516247292013478,
-2.13581322766609E-14,
0.510646834705225,
-1.79773730624166E-14,
0.831822968539406,
-2.10116212623346E-14,
-1.28352189987524E-14,
-1.92901250528621E-14,
-1.19166829182227E-14,
-1.18607380861224E-14,
  0,
  0,
  0,
  0,
  0,
1.40248056224035E-14,
  0,
1.75415237890775E-14,
  0,
2.7971982369257E-14,
  0,
3.4628983708318E-14,
  0,
3.91505404484516E-14,
1.27207272493379E-14,
5.02319540129914E-14,
2.43156189627669E-14,
5.59240154185403E-14,
3.47482459472914E-14,
6.09282589658644E-14,
4.27006520420381E-14,
6.87978320146332E-14,
5.02089689269347E-14,
7.26150910235202E-14,
5.68295410730002E-14,
7.27907317754628E-14,
5.73265393488676E-14,
7.0007801639127E-14,
5.73581980523041E-14,
6.73692872321663E-14,
5.19033600820951E-14,
5.89936086092813E-14,
4.4949721028642E-14,
5.76184065737007E-14,
4.11346304241E-14,
  0,
-1.69186496409846E-14,
-1.79228376931406E-14,
-2.36035149758784E-14,
0.83599831423911,
-2.12180533559758E-14,
0.510646834705225,
-1.78344752160831E-14,
0.507111865102914,
-1.94304208139817E-14,
0.830737329102076,
-2.13093431788991E-14,
-1.66967134562768E-14,
-1.66923766475868E-14,
-1.3016497601992E-14,
-1.12553195930065E-14,
  0,
  0,
  0,
1.05878847356244E-14,
  0,
1.90806571931379E-14,
  0,
2.59649073075519E-14,
  0,
3.16062280514284E-14,
  0,
3.83052964347819E-14,
  0,
4.55122051157275E-14,
2.33914450309403E-14,
5.69236498215719E-14,
3.31128353903143E-14,
6.28355874277009E-14,
4.35870957382622E-14,
6.97189701803769E-14,
4.87873630383717E-14,
7.8909968836971E-14,
5.691584356593E-14,
7.63889819455077E-14,
5.30235577667071E-14,
7.15803284701E-14,
5.46455242167454E-14,
7.05694183644745E-14,
5.55393404877425E-14,
6.30159986692025E-14,
5.00068736419834E-14,
6.17435789995735E-14,
4.91941556934883E-14,
6.34197555582361E-14,
  0,
-1.23112240887902E-14,
-2.0565146807705E-14,
-1.66745957319581E-14,
-2.32973362823685E-14,
0.833437219948181,
-1.80452441184142E-14,
0.507111865102914,
-1.9111665375271E-14,
0.504732140241031,
-1.89891505297801E-14,
0.829971059101254,
-1.88811639934006E-14,
-1.76833374332386E-14,
-1.59360372120609E-14,
-1.1595325394298E-14,
  0,
  0,
  0,
  0,
1.5631159561158E-14,
  0,
2.75304952446209E-14,
  0,
2.94942022194267E-14,
  0,
3.50748076416441E-14,
  0,
4.44557585188576E-14,
2.03660872888367E-14,
5.20256580871514E-14,
3.20503172612785E-14,
6.35992994379997E-14,
4.17968611110542E-14,
7.14094582077163E-14,
4.94456905975049E-14,
7.95344692883226E-14,
5.5273494115049E-14,
8.23716095332827E-14,
5.28722031434281E-14,
7.48424759666744E-14,
5.0112691774018E-14,
7.18366338636756E-14,
5.26028873237827E-14,
6.58995427671449E-14,
5.340172748447E-14,
6.54701987068407E-14,
5.40210237653937E-14,
6.72829847392364E-14,
5.17823631196457E-14,
  0,
-1.44008069358215E-14,
-1.18247425739959E-14,
-2.0534138625572E-14,
-1.21213802883879E-14,
-1.96984355910201E-14,
0.831822968539406,
-1.94568753469904E-14,
0.504732140241031,
-1.90060640836709E-14,
0.503051291621874,
-1.64100504018716E-14,
0.829409536066531,
-1.79370407416002E-14,
-1.61355304117983E-14,
  0,
-1.07145195493707E-14,
  0,
  0,
1.0622145524275E-14,
  0,
2.38836728172487E-14,
  0,
3.08568275098065E-14,
  0,
3.28435195706689E-14,
  0,
4.11328957006241E-14,
1.75493300447194E-14,
5.07987749087668E-14,
2.89174066636644E-14,
5.84831662264751E-14,
4.0614213381307E-14,
7.19034207175007E-14,
4.75218822626466E-14,
8.09222480691041E-14,
5.57700587100474E-14,
8.27029417171943E-14,
5.09887271293863E-14,
8.05475477982931E-14,
4.97813595901064E-14,
7.48489811797093E-14,
4.78627554256761E-14,
6.69308358736131E-14,
5.0266214801642E-14,
6.81529485624388E-14,
5.72328642811648E-14,
7.08053407572073E-14,
5.64522387169752E-14,
7.27942012224148E-14,
  0,
  0,
-1.50782164531904E-14,
  0,
-1.74001438257854E-14,
-1.16356577151144E-14,
-2.10664818922623E-14,
0.830737329102076,
-1.90446616810114E-14,
0.503051291621874,
-1.64113514444786E-14,
0.501818924441715,
-1.55864904316516E-14,
0.828985507246359,
-1.04308922610485E-14,
-1.51788304147971E-14,
  0,
  0,
  0,
  0,
1.88161118630514E-14,
  0,
2.72217144658971E-14,
  0,
3.41315517515817E-14,
1.08997012804313E-14,
3.87277016011822E-14,
1.92415527955347E-14,
4.73410373402761E-14,
2.60386330552809E-14,
5.7142658660414E-14,
3.73785204177413E-14,
6.66081773070815E-14,
4.62191049321881E-14,
8.12154163365442E-14,
5.36879568580062E-14,
8.38955641069283E-14,
5.1383376720171E-14,
8.06733152503014E-14,
4.7796835933589E-14,
8.03567282159356E-14,
4.74559627705595E-14,
6.97454247133855E-14,
4.54306731123566E-14,
6.89864831926457E-14,
5.39446959324508E-14,
7.33137509034698E-14,
5.95192298225022E-14,
7.60815022093908E-14,
6.00257690774875E-14,
  0,
-1.02001740387436E-14,
  0,
-1.22523519108242E-14,
  0,
-1.90381564679765E-14,
-1.28200401683376E-14,
-2.13344966693008E-14,
0.829971059101254,
-1.64100504018716E-14,
0.501818924441715,
-1.54607229796433E-14,
0.50088794707639,
  0,
0.828657323515795,
  0,
-1.24050075767101E-14,
  0,
  0,
1.49394385751123E-14,
  0,
2.21081833395864E-14,
  0,
3.04517695781659E-14,
1.3760260292317E-14,
3.99953507812523E-14,
2.14520241847982E-14,
4.4874260557437E-14,
2.76389154618695E-14,
5.35669598955568E-14,
3.440390333731E-14,
6.51336623525012E-14,
4.2855476112269E-14,
7.57952728358546E-14,
5.22611467990153E-14,
8.4066434369312E-14,
4.91794105439425E-14,
8.17141493358875E-14,
4.80327583263218E-14,
8.03220337464161E-14,
4.5327457065536E-14,
7.50987813602499E-14,
4.49371442834412E-14,
7.16952539003834E-14,
4.90146118137247E-14,
7.39937625060527E-14,
5.61131002774218E-14,
7.83990927732958E-14,
6.29999524770497E-14,
8.42069469708662E-14,
  0,
  0,
  0,
  0,
-1.41104575940298E-14,
  0,
-1.93172301071742E-14,
-1.6750489884032E-14,
-1.88525410560469E-14,
0.829409536066531,
-1.55934293255555E-14,
0.500887947076391,
  0,
0.500167182298014,
  0,
0.828398039489368,
  0,
-1.19145145138777E-14,
1.03155331498961E-14,
  0,
1.82896232880925E-14,
  0,
2.5358621452698E-14,
1.08810530030645E-14,
3.62865119896139E-14,
2.42167397246362E-14,
4.61028784592976E-14,
2.98086208494475E-14,
5.10286257693338E-14,
3.59547461248333E-14,
6.14872736059979E-14,
3.97971586241219E-14,
7.42340217074755E-14,
4.88142512522494E-14,
7.84910331175226E-14,
4.7719640738908E-14,
8.17245576767434E-14,
4.57316476354386E-14,
8.1229294124352E-14,
4.5475775922732E-14,
7.49235742891763E-14,
4.27670052149942E-14,
7.68603930501044E-14,
4.84274079171065E-14,
7.65117136314331E-14,
5.10919431762069E-14,
7.89507348386564E-14,
5.94923416086246E-14,
8.63736165923612E-14,
6.35672070536941E-14,
  0,
  0,
  0,
  0,
  0,
-1.43515841571906E-14,
-1.19431374512313E-14,
-1.66932440093248E-14,
-1.76790006245486E-14,
-1.79292344859583E-14,
0.828985507246359,
  0,
0.500167182298014,
  0,
0.499597599026475,
  0,
0.828189580500137,
  0,
  0,
1.35729101569115E-14,
  0,
2.13305935414798E-14,
  0,
3.10992551155742E-14,
2.13665890536063E-14,
4.23211812816682E-14,
3.26206076040059E-14,
5.21535939435047E-14,
3.81214157463283E-14,
5.88444223903473E-14,
4.13115722186497E-14,
7.0460998147226E-14,
4.57325149971766E-14,
7.68048818988731E-14,
4.42276423817667E-14,
7.60468077398713E-14,
4.42259076582907E-14,
8.11295475244833E-14,
4.31234908893074E-14,
7.56989956829379E-14,
4.28251184514394E-14,
7.65654900591883E-14,
4.61722673983367E-14,
8.15771061812853E-14,
5.04058600414581E-14,
8.13437858737664E-14,
5.43870504188249E-14,
8.67812766092158E-14,
5.99936766931819E-14,
9.72399244458799E-14,
  0,
  0,
  0,
  0,
-1.03064258516472E-14,
  0,
-1.18603044052534E-14,
-1.30190996872059E-14,
-1.59499149998688E-14,
-1.60865244736019E-14,
-1.04343617080005E-14,
0.828657323515795,
  0,
0.499597599026475,
  0,
0.49913957690152,
1.05276030948342E-14,
0.82801944722203,
1.121932408088E-14,
  0,
1.6750923564901E-14,
  0,
2.707382928957E-14,
1.71416700278648E-14,
3.70337441268909E-14,
2.97591812303821E-14,
4.83085793590021E-14,
4.08189107514723E-14,
5.99425023506406E-14,
4.34166591567475E-14,
6.78120753994094E-14,
4.7193152163949E-14,
7.29676735700124E-14,
4.10678435702749E-14,
7.43034106465146E-14,
4.07078884490097E-14,
7.53364384764588E-14,
4.15648418461423E-14,
7.54995024832006E-14,
4.04476799276132E-14,
7.72481037469852E-14,
4.62485952312797E-14,
8.11651093557408E-14,
4.81429132670463E-14,
8.63007582063702E-14,
5.3630710983299E-14,
8.90771831296711E-14,
5.47929757122034E-14,
9.75400316072239E-14,
5.73751116061949E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.12431765286747E-14,
-1.16039990116779E-14,
  0,
-1.51901061173909E-14,
  0,
0.828398039489368,
  0,
0.49913957690152,
1.12136862295831E-14,
0.498765704069467,
1.39198548521069E-14,
0.827878767874979,
1.46835668624057E-14,
  0,
2.23306616253804E-14,
1.19348975147204E-14,
3.29701543844152E-14,
2.54223725404401E-14,
4.31018068458577E-14,
3.79349329726608E-14,
5.60003432514833E-14,
4.60491020315423E-14,
6.87852552694324E-14,
4.92748203351212E-14,
7.02918626083182E-14,
4.24764390327681E-14,
7.03890071229729E-14,
3.75029868271426E-14,
7.3521917720587E-14,
3.79765663360843E-14,
6.96734336891325E-14,
3.87849474758895E-14,
7.69375882447854E-14,
4.3754930234563E-14,
8.1754915337573E-14,
4.80882694775531E-14,
8.58141682713587E-14,
5.1236792586451E-14,
9.39161942659084E-14,
5.4000207083682E-14,
9.97379262512865E-14,
5.20954807070595E-14,
1.05608230493992E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07145195493707E-14,
  0,
-1.24327631523258E-14,
  0,
0.828189580500137,
1.05284704565722E-14,
0.498765704069467,
1.36639831394003E-14,
0.498456516645347,
1.62200981812521E-14,
0.827761101976404,
2.02802184767759E-14,
  0,
2.82404308271644E-14,
2.01713645786583E-14,
3.89306642478715E-14,
3.3661441689592E-14,
5.07692846096752E-14,
4.32232374891761E-14,
6.48986073215063E-14,
5.18855791664663E-14,
7.11982556245161E-14,
4.44800446475213E-14,
6.7616919008362E-14,
3.88508669679766E-14,
6.95641461101459E-14,
3.47742667994311E-14,
6.77799830151038E-14,
3.52140192005912E-14,
7.10508041290581E-14,
4.21251575288828E-14,
8.14045011954256E-14,
4.55885329486705E-14,
8.63311158671998E-14,
5.11743425413158E-14,
9.33593480301198E-14,
5.15802678346944E-14,
1.04505813725009E-13,
5.12515377359968E-14,
1.0772632785816E-13,
4.82548029312468E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.19205860460436E-14,
  0,
0.82801944722203,
1.39194211712379E-14,
0.498456516645347,
1.70193720228085E-14,
0.498197880285941,
2.25583440816024E-14,
0.827661681057511,
2.61683036351101E-14,
1.57009821810661E-14,
3.42460435009961E-14,
2.84702816877314E-14,
4.67187052932694E-14,
3.8891632969662E-14,
5.95643326328776E-14,
4.90380305806504E-14,
6.72639027810007E-14,
4.71766722909273E-14,
6.85259141097738E-14,
4.08935038609393E-14,
6.671659752433E-14,
3.61169427698371E-14,
6.3799659999475E-14,
3.19709536622526E-14,
6.90784235368724E-14,
3.84839729528075E-14,
7.54040926920219E-14,
4.38789629630953E-14,
8.58809551251838E-14,
4.86312379255338E-14,
9.37860900052101E-14,
5.14293468922844E-14,
1.0382406739895E-13,
4.88021081879175E-14,
1.12387529838109E-13,
4.73501446385249E-14,
1.10200043534903E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.03584675559265E-14,
  0,
1.11989410800373E-14,
0.827878767874979,
1.62131592873482E-14,
0.498197880285941,
2.25366600381527E-14,
0.497979327268461,
2.83132892131555E-14,
0.827576912726422,
3.22996837609502E-14,
2.4010307630995E-14,
4.18458670492505E-14,
3.380455637636E-14,
5.55180901251617E-14,
4.46743336768307E-14,
6.19018725167564E-14,
4.42102951470069E-14,
6.45828876488785E-14,
4.3528548820948E-14,
6.75969696883882E-14,
3.81248851932803E-14,
6.09113454119736E-14,
3.32763330779251E-14,
6.50911616273397E-14,
3.52062129449493E-14,
7.34369162702642E-14,
4.02282374079022E-14,
7.98736077278761E-14,
4.69208005782207E-14,
9.33081736875785E-14,
4.88593540626248E-14,
1.04219584351473E-13,
4.86390441811757E-14,
1.11656343892985E-13,
4.48868373026379E-14,
1.14773641979315E-13,
4.56345031207839E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.05605628408778E-14,
  0,
1.0622145524275E-14,
  0,
1.49533163629201E-14,
  0,
1.35278073465361E-14,
  0,
1.46766279685018E-14,
0.827761101976404,
2.25435989320566E-14,
0.497979327268461,
2.87643173169094E-14,
0.497792969806215,
3.43926276347162E-14,
0.827504048487979,
3.97867502832661E-14,
2.9096516862559E-14,
5.05897407299116E-14,
3.9495316739302E-14,
5.78634362646824E-14,
3.99142524587504E-14,
5.91861629151147E-14,
4.06549793829925E-14,
6.36062383319036E-14,
4.07208988750796E-14,
6.1783043958652E-14,
3.52331011588269E-14,
6.21802956346507E-14,
3.65315416805956E-14,
6.93490403991248E-14,
3.69660899113278E-14,
7.78465833461972E-14,
4.32431868091498E-14,
8.72496519477295E-14,
4.7117691692744E-14,
1.03680085350444E-13,
4.60586430106602E-14,
1.11931297563928E-13,
4.47185691254681E-14,
1.13924494837825E-13,
4.31972166370365E-14,
1.19930974873395E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.40104941537267E-14,
  0,
1.56138123263982E-14,
  0,
1.88048361604576E-14,
  0,
1.82904906498305E-14,
  0,
1.6750923564901E-14,
  0,
2.02446566455183E-14,
0.827661681057511,
2.83132892131555E-14,
0.497792969806215,
3.43414532921749E-14,
0.49763277188551,
4.21702603392582E-14,
0.827440956235112,
4.85514406456389E-14,
3.47890119489769E-14,
5.30261598519211E-14,
3.470140841344E-14,
5.50210918492944E-14,
3.63216401400024E-14,
5.81834927460001E-14,
3.78195738615084E-14,
5.774374034484E-14,
3.78681461188357E-14,
6.30337795848313E-14,
3.84874423997594E-14,
6.64685320672653E-14,
3.82827450295942E-14,
7.37656463689618E-14,
3.99558858221738E-14,
8.5189667820007E-14,
4.34175265184855E-14,
9.75643177358876E-14,
4.42935618738538E-14,
1.11354502008165E-13,
4.20895956976253E-14,
1.1417256029489E-13,
4.29769067555874E-14,
1.19058408964978E-13,
3.63997026964213E-14,
  0,
  0,
  0,
  0,
  0,
1.234038912723E-14,
  0,
1.90815245548759E-14,
  0,
2.39387502876109E-14,
  0,
2.21168569569663E-14,
  0,
2.13028379658642E-14,
  0,
2.23133143906207E-14,
  0,
2.61145272073549E-14,
0.827576912726422,
3.43926276347162E-14,
0.49763277188551,
4.2106942932385E-14,
0.497494050375342,
5.05975469855535E-14,
0.827385961300297,
5.12064349256214E-14,
3.01330141394551E-14,
5.01257022000878E-14,
3.10255293678452E-14,
5.41589342817339E-14,
3.34732241924485E-14,
5.23756385484297E-14,
3.48696765906098E-14,
5.89962106944952E-14,
4.10192713129476E-14,
6.72769132070705E-14,
4.02317068548541E-14,
7.08417699502029E-14,
4.12439180030866E-14,
8.10419439889465E-14,
4.01163477437017E-14,
9.54557613508378E-14,
4.05491612509579E-14,
1.05194498944972E-13,
4.02742075800155E-14,
1.1353851886442E-13,
4.0312371496487E-14,
1.19250095909074E-13,
3.61733212828064E-14,
1.17092967266696E-13,
  0,
  0,
1.02346516678287E-14,
  0,
1.40963629657875E-14,
  0,
1.74756042969904E-14,
  0,
2.75330973298349E-14,
  0,
2.72078366780892E-14,
  0,
2.5358621452698E-14,
  0,
2.70720945660941E-14,
1.19071419391048E-14,
2.82369613802125E-14,
1.57322072036337E-14,
3.22441726097189E-14,
0.827504048487979,
4.21980159148738E-14,
0.497494050375342,
5.09557673833427E-14,
0.497373126372988,
5.33071850550293E-14,
0.827337733405535,
4.80518402845576E-14,
2.66228011858161E-14,
4.92999738255229E-14,
2.83358406183432E-14,
4.82964362946703E-14,
3.06222061596806E-14,
5.36098943015872E-14,
3.814223242804E-14,
6.32280686141407E-14,
4.27956281523478E-14,
7.16284670465583E-14,
4.31763999553247E-14,
7.8087709909358E-14,
4.14260639680641E-14,
9.13184458606331E-14,
3.72722686048377E-14,
1.03017420982621E-13,
3.65263375101677E-14,
1.07339484523017E-13,
3.85073917197332E-14,
1.18545798177827E-13,
3.34940408741602E-14,
1.17236081953465E-13,
3.1786205612061E-14,
  0,
  0,
  0,
1.65397209817009E-14,
  0,
1.94024483979316E-14,
  0,
2.59380190936742E-14,
  0,
3.08299392959288E-14,
  0,
3.04196771938603E-14,
1.09092422595491E-14,
3.10996887964432E-14,
1.71460068365548E-14,
3.29718891078912E-14,
2.01991201542739E-14,
3.4253849756638E-14,
2.39565312032397E-14,
3.98257815614755E-14,
0.827440956235112,
5.05984143472915E-14,
0.497373126372988,
5.34650448913432E-14,
0.497267077163142,
5.01820807130571E-14,
0.827295204949531,
4.72434591447524E-14,
2.35896371880706E-14,
4.34262001358654E-14,
2.53746676448507E-14,
4.94838545139764E-14,
3.38019542911461E-14,
5.78651709881584E-14,
3.97815461128381E-14,
6.75787550918905E-14,
4.57550664023643E-14,
7.8912570922185E-14,
4.338109732549E-14,
8.83520687167128E-14,
3.85715764883443E-14,
9.8876636045464E-14,
3.32182198414799E-14,
1.0516500864588E-13,
3.47378376064356E-14,
1.1232681451645E-13,
3.1637019393127E-14,
1.16508365455292E-13,
2.90713633721573E-14,
1.0572966113731E-13,
  0,
  0,
1.62211823834246E-14,
  0,
2.20513711457482E-14,
  0,
2.79854264761958E-14,
  0,
2.94942022194267E-14,
  0,
3.41263475811537E-14,
1.37533213984131E-14,
3.62708994783301E-14,
2.13639869683924E-14,
3.70094579982272E-14,
2.54223725404401E-14,
3.89549503765352E-14,
2.84303830477839E-14,
4.19273990526214E-14,
2.91251397999126E-14,
4.86069517968701E-14,
0.827385961300297,
5.3251673903798E-14,
0.497267077163142,
5.02488675668822E-14,
0.497173556892204,
4.92227786308419E-14,
0.82725751107386,
4.15249432061948E-14,
2.08140796265077E-14,
4.46058120995296E-14,
2.85448747971984E-14,
5.3550046341666E-14,
3.54317269968263E-14,
6.21057025251837E-14,
4.27331781072127E-14,
7.47579081972205E-14,
4.58019039362156E-14,
8.91370310895923E-14,
4.05153341431763E-14,
9.58825033259281E-14,
3.45869166640256E-14,
1.01010345920916E-13,
3.14219136821059E-14,
1.10128919872388E-13,
2.79117007284668E-14,
1.10204380343593E-13,
2.72386280197878E-14,
1.04986332127854E-13,
2.0721271920543E-14,
  0,
1.8362698514518E-14,
  0,
2.21203264039183E-14,
  0,
3.08728737019592E-14,
  0,
3.16053606896904E-14,
  0,
3.28270396976471E-14,
1.08927623865274E-14,
3.99693299291126E-14,
2.42392911298239E-14,
4.22899562591006E-14,
2.97609159538581E-14,
4.30966026754298E-14,
3.36718500304478E-14,
4.67429914219331E-14,
3.37698619068405E-14,
5.05888733681736E-14,
3.47890119489769E-14,
5.12055675638834E-14,
0.827337733405535,
5.01786112661051E-14,
0.497173556892204,
4.93910468080117E-14,
0.49709066501199,
4.29725699468975E-14,
0.827223945112055,
4.23697535389955E-14,
2.39626027354056E-14,
4.87977713792276E-14,
3.02050051637082E-14,
5.79839995462628E-14,
3.82818776678562E-14,
6.94218987851158E-14,
4.28415983244612E-14,
8.49624190446541E-14,
4.29699678616835E-14,
9.66232302501702E-14,
3.6496847211076E-14,
9.79659062205762E-14,
3.27697938229399E-14,
1.05960379359615E-13,
2.46001136128271E-14,
1.08022098210814E-13,
2.34751454386561E-14,
9.86866838248446E-14,
1.88607809925578E-14,
9.87517359551937E-14,
1.16521375881362E-14,
  0,
2.5168018710775E-14,
  0,
3.12358645893074E-14,
  0,
3.46259479422351E-14,
  0,
3.50626645773122E-14,
  0,
3.87623960707018E-14,
2.14173297152787E-14,
4.60968069271317E-14,
3.26327506683377E-14,
4.83380696580937E-14,
3.79071773970452E-14,
5.07692846096752E-14,
3.89089802044218E-14,
5.54703852295724E-14,
3.95577667844371E-14,
5.30244251284451E-14,
3.01642391620227E-14,
4.81082187975268E-14,
0.827295204949531,
4.92227786308419E-14,
0.49709066501199,
4.37306441058993E-14,
0.497016848471872,
4.4653516995119E-14,
0.827193925065405,
4.67560018480029E-14,
2.55403337368065E-14,
5.30547827892747E-14,
3.31184732416112E-14,
6.52524909106056E-14,
3.844841112155E-14,
7.95865109926019E-14,
3.99307323317721E-14,
9.25171397825331E-14,
3.89584198234871E-14,
9.86892859100585E-14,
3.47352355212216E-14,
1.02885581998446E-13,
2.59167687310935E-14,
1.03818863228522E-13,
2.01878444516801E-14,
9.6413328709577E-14,
1.50868900705703E-14,
9.24538223756599E-14,
1.03033900855642E-14,
  0,
2.11311003417425E-14,
  0,
3.49182488479372E-14,
  0,
3.53168015665428E-14,
  0,
3.82901176043671E-14,
  0,
4.11328957006241E-14,
1.92311444546789E-14,
4.48465049818214E-14,
2.98363764250631E-14,
5.21535939435047E-14,
4.08189107514723E-14,
5.60280988270989E-14,
4.3233645830032E-14,
5.95495874833318E-14,
4.47150996785162E-14,
5.78391501360187E-14,
3.46745201995624E-14,
5.01257022000878E-14,
2.66228011858161E-14,
4.71532535240016E-14,
0.82725751107386,
4.30003255225131E-14,
0.497016848471872,
4.45901995882458E-14,
0.496950828107559,
4.90206833458906E-14,
0.82716696809061,
5.11249029222505E-14,
2.84633427938275E-14,
6.0284242875408E-14,
3.32988844831128E-14,
7.53633266903364E-14,
3.55488208314547E-14,
8.70050559376168E-14,
3.59625523804752E-14,
9.45146738651204E-14,
3.72124206449165E-14,
1.03572532494933E-13,
2.78293013633579E-14,
1.00758811016899E-13,
2.14984280377806E-14,
9.21979506629533E-14,
1.17553536349568E-14,
9.01969471334141E-14,
  0,
8.91665213886839E-14,
1.27076084030509E-14,
  0,
3.20305847817393E-14,
  0,
3.94541170567475E-14,
  0,
3.91800307475432E-14,
  0,
4.44644321362375E-14,
1.75632078325272E-14,
4.73497109576559E-14,
2.76527932496773E-14,
5.10702591327572E-14,
3.80901907237607E-14,
5.99624516706143E-14,
4.6077724968896E-14,
6.48699843841527E-14,
4.90302243250085E-14,
6.19157503045642E-14,
3.99576205456498E-14,
5.50566536805519E-14,
3.10342029852251E-14,
4.92722182499072E-14,
2.35688205063589E-14,
4.14815751192954E-14,
0.827223945112055,
4.47159670402542E-14,
0.496950828107559,
4.93841079141077E-14,
0.496891542614171,
5.23253315676264E-14,
0.827142670881851,
5.83760470518335E-14,
2.86931936543944E-14,
7.03196181839338E-14,
3.02960781461969E-14,
8.28694751708881E-14,
3.15997228383935E-14,
8.91214185783085E-14,
3.41341538367956E-14,
9.94282781108247E-14,
3.03116906574807E-14,
1.01398056617796E-13,
2.34057564996171E-14,
8.90771831296711E-14,
1.30962948818869E-14,
8.59329968294631E-14,
  0,
8.68801558473464E-14,
  0,
  0,
2.66351610905824E-14,
  0,
3.72896158395974E-14,
  0,
4.35927335895592E-14,
1.27189925258619E-14,
4.55061335835616E-14,
2.03591483949328E-14,
5.08031117174568E-14,
2.60490413961367E-14,
5.3554816831225E-14,
3.59382662518115E-14,
5.88279425173255E-14,
4.34175265184855E-14,
6.87852552694324E-14,
5.19168041890339E-14,
6.72508923549309E-14,
4.42102951470069E-14,
5.92243268315862E-14,
3.62904151174348E-14,
5.41285766209043E-14,
2.83072176809895E-14,
4.34279348593414E-14,
2.08166817117217E-14,
4.23393958781659E-14,
0.827193925065405,
4.89113957669041E-14,
0.496891542614171,
5.37287228596917E-14,
0.496838105458392,
6.0512359012499E-14,
0.827120694439532,
6.83333598039404E-14,
2.56079879523696E-14,
7.80235251407468E-14,
2.63053467897123E-14,
8.48696113386893E-14,
2.97253541226006E-14,
9.38893060520307E-14,
2.72594447014995E-14,
9.72286487432861E-14,
2.59202381780455E-14,
8.97754093287517E-14,
1.49819393002737E-14,
8.28651383621981E-14,
  0,
8.25893173295178E-14,
  0,
8.62756047159685E-14,
1.80141275160639E-14,
  0,
3.32683099818487E-14,
  0,
4.1957756713451E-14,
1.34688267483529E-14,
5.02384592260263E-14,
2.3412261712652E-14,
5.19918309793699E-14,
2.89312844514722E-14,
5.71391892134621E-14,
3.44177811251178E-14,
6.14690590095002E-14,
4.13167763890776E-14,
6.78146774846233E-14,
4.92644119942653E-14,
7.1201725071468E-14,
4.71914174404731E-14,
6.45664077758568E-14,
4.05994682317612E-14,
5.82112483216157E-14,
3.34714894689725E-14,
4.82773543364345E-14,
2.53607898570429E-14,
4.45919343117218E-14,
2.39660721823576E-14,
4.67560018480029E-14,
0.82716696809061,
5.23244642058884E-14,
0.496838105458392,
6.0735270979162E-14,
0.496789771421539,
7.02641070327026E-14,
0.827100752138749,
7.58490492636099E-14,
2.16441448097626E-14,
7.99230473469414E-14,
2.45021017364344E-14,
8.96444377063155E-14,
2.28584512429464E-14,
9.17122280896798E-14,
2.28731963924922E-14,
8.55730417081979E-14,
1.74799411056803E-14,
8.35078534100475E-14,
  0,
7.95119178831349E-14,
  0,
8.19708884103321E-14,
  0,
  0,
2.85576683828337E-14,
  0,
3.87294363246582E-14,
1.47937218031302E-14,
4.89538964920655E-14,
2.43156189627669E-14,
5.68997973737773E-14,
3.20589908786584E-14,
5.8488370396903E-14,
3.73837245881692E-14,
6.51414686081431E-14,
3.98145058588817E-14,
7.0455793976798E-14,
4.7194886887425E-14,
7.02779848205104E-14,
4.44887182649012E-14,
6.8515505768918E-14,
4.35415592470179E-14,
6.36201161197114E-14,
3.77779404980849E-14,
5.24112003796873E-14,
3.06438902031303E-14,
4.94734461731205E-14,
2.85171192215827E-14,
4.87977713792276E-14,
2.55507420776624E-14,
5.11665362856739E-14,
0.827142670881851,
6.05201652681409E-14,
0.496789771421539,
7.04046196342567E-14,
0.496745910388126,
7.77737249602062E-14,
0.827082600304547,
7.78275013879615E-14,
2.00343214240561E-14,
8.4671852862428E-14,
1.7574483535121E-14,
8.75029215752221E-14,
1.84921522539128E-14,
8.00999891414911E-14,
1.44476444696728E-14,
7.92959448103758E-14,
  0,
8.01398877814385E-14,
  0,
7.88553250474777E-14,
  0,
8.57803411635771E-14,
1.49362943888121E-14,
  0,
3.54367143268197E-14,
1.32068835034804E-14,
4.62381868904238E-14,
2.57779908530154E-14,
5.59378932063481E-14,
3.31527340302618E-14,
6.36140445875455E-14,
4.06298258925908E-14,
6.66029731366535E-14,
4.28433330479372E-14,
7.42444300483314E-14,
4.57394538910805E-14,
7.29676735700124E-14,
4.24764390327681E-14,
6.7618653731838E-14,
4.08787587113935E-14,
6.76108474761961E-14,
4.07208988750796E-14,
5.77602202178618E-14,
3.48974321662254E-14,
5.36376498772029E-14,
3.37741987155304E-14,
5.35830060877096E-14,
3.01841884819964E-14,
5.30443744484188E-14,
2.84581386233995E-14,
5.83777817753095E-14,
0.827120694439532,
7.02641070327026E-14,
0.496745910388126,
7.83722045594182E-14,
0.496705986639473,
7.97608507019376E-14,
0.827066030709275,
8.26855944824345E-14,
1.31327240748824E-14,
8.2495642261815E-14,
1.32767061233885E-14,
7.57926707506407E-14,
1.01082336945169E-14,
7.38020755619573E-14,
  0,
7.59635410130244E-14,
1.14162151954034E-14,
7.94884991162093E-14,
  0,
8.26057972025396E-14,
  0,
  0,
2.53241438236129E-14,
1.32908007516308E-14,
4.3832992790982E-14,
2.44435548191202E-14,
5.36402519624168E-14,
3.47387049681736E-14,
6.2829515895535E-14,
4.17968611110542E-14,
7.18895429296929E-14,
4.62052271443802E-14,
7.58091506236624E-14,
4.88081797200834E-14,
7.68014124519212E-14,
4.10539657824671E-14,
7.03751293351651E-14,
3.88543364149285E-14,
6.67304753121378E-14,
3.80953948941887E-14,
6.17691661708442E-14,
3.78629419484078E-14,
5.89814655449494E-14,
3.8143967151516E-14,
5.78322112421148E-14,
3.54265228263984E-14,
5.79909384401667E-14,
3.30638294521179E-14,
6.02564872997924E-14,
2.87009999100363E-14,
6.83333598039404E-14,
0.827100752138749,
7.76627026577437E-14,
0.496705986639473,
7.99664154338409E-14,
0.49666954236883,
8.44905742591884E-14,
0.827050864556478,
8.03636671098396E-14,
  0,
7.09874867221849E-14,
  0,
6.94938898093689E-14,
  0,
7.045492661506E-14,
  0,
7.52592432817778E-14,
  0,
8.32424407182231E-14,
  0,
7.72056030218238E-14,
1.43065897670325E-14,
1.07208079219712E-14,
3.5155038602408E-14,
2.48924145185292E-14,
5.18573899099817E-14,
3.3656237519164E-14,
6.09213200719605E-14,
4.35909988660832E-14,
7.14111929311922E-14,
4.75028003044109E-14,
8.12015385487364E-14,
5.22611467990153E-14,
7.84988393731645E-14,
4.4200754167889E-14,
7.43042780082526E-14,
3.75064562740945E-14,
6.9560676663194E-14,
3.61169427698371E-14,
6.09113454119736E-14,
3.52435094996828E-14,
6.30624025221849E-14,
4.10340164624934E-14,
6.3200313038525E-14,
3.97780766658862E-14,
6.21351928242753E-14,
3.83243783930176E-14,
6.52177964410861E-14,
3.32988844831128E-14,
7.03317612482657E-14,
2.56062532288936E-14,
7.58490492636099E-14,
0.827082600304547,
7.9733095126322E-14,
0.49666954236883,
8.47082820554235E-14,
0.496636184461755,
8.25572249452122E-14,
0.827036947623868,
6.86811718608737E-14,
  0,
6.45421216471931E-14,
  0,
6.61727617146113E-14,
  0,
6.9780986544643E-14,
  0,
7.90166543307436E-14,
  0,
7.77797964923721E-14,
  0,
  0,
2.74723820081757E-14,
2.30236836540332E-14,
4.40819256097846E-14,
3.44928079154538E-14,
5.95968586980522E-14,
4.2705422531597E-14,
6.97241743508048E-14,
4.94508947679329E-14,
8.09009977065234E-14,
5.36740790701984E-14,
8.40525565815042E-14,
4.77109671215281E-14,
7.60710938685349E-14,
4.06948780229399E-14,
7.35011010388753E-14,
3.47846751402869E-14,
6.38152725107588E-14,
3.32615879283793E-14,
6.21959081459345E-14,
3.85082590814712E-14,
6.72769132070705E-14,
4.27956281523478E-14,
6.76047759440301E-14,
4.27340454689507E-14,
6.93924084860242E-14,
3.844841112155E-14,
7.53772044781442E-14,
3.0290873975769E-14,
7.79957695651312E-14,
2.16684309384263E-14,
7.77442346611146E-14,
0.827066030709275,
8.44905742591884E-14,
0.496636184461756,
8.28989654699797E-14,
0.49660557382262,
7.08417699502029E-14,
0.827024146316798,
6.24118812186936E-14,
  0,
6.12374734254573E-14,
  0,
6.54892806650764E-14,
  0,
7.34898253362815E-14,
  0,
7.35175809118971E-14,
  0,
7.988054662178E-14,
1.74146721348967E-14,
2.38173196442926E-14,
3.7924958312674E-14,
3.32576848005584E-14,
5.24198739970672E-14,
4.38789629630953E-14,
6.8811709802441E-14,
4.87873630383717E-14,
7.95336019265847E-14,
5.57735281569993E-14,
8.39033703625702E-14,
4.91785431822045E-14,
8.17262924002193E-14,
4.42198361261248E-14,
7.53537857112185E-14,
3.79791684212982E-14,
6.77756462064139E-14,
3.19553411509688E-14,
6.50582018812962E-14,
3.64899083171721E-14,
6.64546542794575E-14,
4.02074207261904E-14,
7.16284670465583E-14,
4.57273108267486E-14,
7.47995415606439E-14,
4.28762927939808E-14,
7.95761026517461E-14,
3.56078014296379E-14,
8.28391175100585E-14,
2.63027447044983E-14,
7.99351904112733E-14,
2.00360561475321E-14,
8.26300833312033E-14,
0.827050864556478,
8.26352875016312E-14,
0.49660557382262,
7.11592243463066E-14,
0.496577416701491,
6.46357967148958E-14,
0.827012344442267,
5.91401927430013E-14,
  0,
6.05644007167783E-14,
  0,
6.92449569905662E-14,
  0,
6.80150380460987E-14,
  0,
7.55923101891653E-14,
-1.22870463803437E-14,
1.81770831025885E-14,
3.17937950272684E-14,
3.52612904153116E-14,
4.72456275490973E-14,
4.30926995476089E-14,
6.21187129512535E-14,
5.02094026078037E-14,
7.88900195169973E-14,
5.52960455202367E-14,
8.27185542284781E-14,
5.1385111443647E-14,
8.17158840593635E-14,
4.57394538910805E-14,
8.11156697366755E-14,
4.15518314200725E-14,
6.96673621569666E-14,
3.52036108597353E-14,
6.90645457490646E-14,
3.5227029626661E-14,
6.93837348686444E-14,
3.82697346035243E-14,
7.08148817363252E-14,
4.32058902544163E-14,
7.88978257726392E-14,
4.58322615970452E-14,
8.4969357938558E-14,
3.99775698656235E-14,
8.7060567088848E-14,
3.15771714332058E-14,
8.48401210395977E-14,
2.44812850547227E-14,
8.467098550069E-14,
1.3091090711459E-14,
8.03966268558831E-14,
0.827036947623868,
7.08417699502029E-14,
0.496577416701491,
6.47433495704064E-14,
0.496551457604018,
6.1329413769684E-14,
0.827001440556802,
5.85226311855536E-14,
-1.15376458387217E-14,
6.43391590005038E-14,
-1.35533945178068E-14,
6.36903724204885E-14,
  0,
6.99804797443804E-14,
-1.53436291450149E-14,
7.25322579775423E-14,
1.93157122241328E-14,
3.35699350262342E-14,
4.28324910262123E-14,
4.5924201941272E-14,
5.75364408894607E-14,
4.98060793996391E-14,
7.26220299174241E-14,
5.69609463763054E-14,
8.23690074480687E-14,
5.10303604928097E-14,
8.06837235911573E-14,
4.80292888793699E-14,
8.12362330182559E-14,
4.31460422944951E-14,
7.55203191649123E-14,
3.88074988810772E-14,
7.10438652351542E-14,
3.84692278032617E-14,
7.34230384824563E-14,
3.69660899113278E-14,
7.37699831776517E-14,
4.12456527265626E-14,
7.8087709909358E-14,
4.33368618768526E-14,
8.91725929208498E-14,
4.29890498199192E-14,
9.24512202904459E-14,
3.59313273579076E-14,
8.90936630026928E-14,
2.9695863823509E-14,
8.96721932819311E-14,
1.75883613229288E-14,
8.24782950270553E-14,
  0,
6.8736683012105E-14,
0.827024146316798,
6.4623653650564E-14,
0.496551457604018,
6.13658429626796E-14,
0.496527473462309,
6.06511368905771E-14,
0.826991345774382,
6.22765727875674E-14,
-1.81486770056694E-14,
5.87724313660942E-14,
-1.33712485528292E-14,
6.57304072282372E-14,
-1.97741129026596E-14,
6.69499178318489E-14,
-2.19321089067748E-14,
2.05779403933404E-14,
3.46847116999838E-14,
4.59684373899094E-14,
5.4224420092952E-14,
5.32711895429028E-14,
6.86178544540006E-14,
5.68156632851924E-14,
7.63829104133418E-14,
5.28652642495242E-14,
8.05406089043892E-14,
4.77708150814493E-14,
8.03150948525122E-14,
4.54688370288281E-14,
7.5695526235986E-14,
4.04390063102333E-14,
7.69558028412831E-14,
4.20765852715554E-14,
7.54145010328777E-14,
4.02542582600418E-14,
7.78674000279089E-14,
3.99350691404621E-14,
8.10540870532783E-14,
4.14139209037323E-14,
8.83624770575686E-14,
4.05023237171065E-14,
9.66214955266942E-14,
3.89844406756268E-14,
9.44973266303606E-14,
3.41410927306995E-14,
9.39153269041704E-14,
2.28515123490425E-14,
8.74751659996065E-14,
1.32767061233885E-14,
7.09718742109011E-14,
  0,
6.23563700674623E-14,
0.827012344442267,
6.13276790462081E-14,
0.496527473462309,
6.09807343510127E-14,
0.496505268816737,
6.40633379678235E-14,
0.826981981945479,
5.67809688156728E-14,
-1.80844922370582E-14,
6.06945049774765E-14,
-2.49435888610705E-14,
6.26668855696622E-14,
-2.62827953845246E-14,
6.17492168508704E-14,
2.07647484276596E-14,
3.76595456208495E-14,
4.79967628141953E-14,
5.44083007814056E-14,
6.6044392177389E-14,
6.07825421938823E-14,
7.27915991372008E-14,
5.30235577667071E-14,
7.48424759666744E-14,
4.97709512492506E-14,
8.03341768107479E-14,
4.5327457065536E-14,
7.49183701187484E-14,
4.28164448340596E-14,
7.72255523417975E-14,
4.37688080223708E-14,
8.13975623015217E-14,
4.39101879856629E-14,
7.98857507922079E-14,
4.32431868091498E-14,
8.5190535181745E-14,
4.01441033193173E-14,
9.13184458606331E-14,
3.85707091266063E-14,
9.58833706876661E-14,
3.64951124876001E-14,
9.86823470161546E-14,
3.72262984327243E-14,
9.94126655995409E-14,
2.72594447014995E-14,
9.1698350301872E-14,
1.84921522539128E-14,
7.57996096445446E-14,
  0,
6.4549060541097E-14,
  0,
5.91401927430013E-14,
0.827001440556802,
6.06823619131447E-14,
0.496505268816737,
6.46722259078913E-14,
0.496484671813191,
5.88418203051333E-14,
0.826973280136955,
5.89268217554562E-14,
-2.95909130532124E-14,
5.76986375344646E-14,
-3.15528853045421E-14,
5.74228165017843E-14,
-2.45827663780673E-14,
2.29226360115575E-14,
3.88721173305573E-14,
4.80622486254134E-14,
6.10236687570431E-14,
6.26612477183652E-14,
7.07944987354825E-14,
5.73187330932257E-14,
7.15898694492179E-14,
5.0112691774018E-14,
7.48507159031853E-14,
4.74550954088215E-14,
7.50658216142064E-14,
4.27548621506624E-14,
7.65776331235202E-14,
4.62347174434719E-14,
8.17670584019048E-14,
4.55954718425744E-14,
8.58913634660396E-14,
4.69346783660285E-14,
8.7284346417249E-14,
4.34105876245816E-14,
9.54288731369601E-14,
3.72861463926455E-14,
9.88896464715339E-14,
3.45799777701217E-14,
9.79520284327684E-14,
3.47421744151255E-14,
1.03572532494933E-13,
3.03116906574807E-14,
9.72269140198101E-14,
2.28697269455402E-14,
8.00921828858492E-14,
1.00622635224035E-14,
6.94687363189672E-14,
  0,
6.12652290010729E-14,
  0,
5.85261006325055E-14,
0.826991345774382,
6.40945629903911E-14,
0.496484671813191,
5.87932480478059E-14,
0.496465530861577,
6.05175631829269E-14,
0.826965179357338,
5.5721052771851E-14,
-3.60943913646494E-14,
5.25308962995297E-14,
-2.98580604685128E-14,
6.29496454962464E-14,
2.40963932834903E-14,
3.84670593989167E-14,
5.40201564036558E-14,
5.75008790582032E-14,
6.66237898183653E-14,
5.96766559779471E-14,
6.99900207234982E-14,
5.46316464289376E-14,
7.18331644167236E-14,
4.78618880639381E-14,
6.97514962455514E-14,
4.49432158156071E-14,
7.68499847092485E-14,
4.61722673983367E-14,
8.11789871435487E-14,
4.81056167123128E-14,
8.6317238079392E-14,
4.86312379255338E-14,
9.33151125814824E-14,
4.71359062892418E-14,
9.75504399480798E-14,
4.0542222357054E-14,
1.03045176558236E-13,
3.32026073301961E-14,
1.01006876473964E-13,
3.27836716107477E-14,
1.02885581998446E-13,
2.78431791511657E-14,
1.0143968998122E-13,
2.59046256667617E-14,
8.55730417081979E-14,
1.44745326835505E-14,
7.37881977741495E-14,
  0,
6.62057214606548E-14,
  0,
6.05713396106822E-14,
-1.15411152856737E-14,
6.22765727875674E-14,
0.826981981945479,
5.88539633694651E-14,
0.496465530861577,
6.12305345315534E-14,
0.496447711833613,
5.72580177715665E-14,
0.826957625483291,
5.04683100865932E-14,
-3.43943623581922E-14,
5.78235376247349E-14,
-3.70363462121048E-14,
2.14912723034422E-14,
4.47580340845466E-14,
4.99847559176647E-14,
6.09477746049691E-14,
5.52834687750359E-14,
6.63839642978115E-14,
5.73629685418631E-14,
7.0603245472256E-14,
5.25959484298788E-14,
6.69247643414472E-14,
4.54436835384264E-14,
7.16605594308639E-14,
4.84274079171065E-14,
8.15719020108574E-14,
4.81368417348804E-14,
8.58124335478827E-14,
5.11778119882678E-14,
9.38017025164939E-14,
4.8844608913079E-14,
1.03666207562636E-13,
4.4279684086046E-14,
1.05174549624998E-13,
3.65272048719056E-14,
1.0517801907195E-13,
3.14461998107696E-14,
1.05946501571808E-13,
2.59254423484734E-14,
1.00758811016899E-13,
2.33771335622635E-14,
8.97754093287517E-14,
1.74747369352524E-14,
7.9282067022568E-14,
  0,
7.04271710394444E-14,
  0,
6.54892806650764E-14,
  0,
6.43460978944077E-14,
-1.81521464526213E-14,
5.67428048992014E-14,
0.826973280136955,
6.04620520316956E-14,
0.496447711833613,
5.79709891201929E-14,
0.49643109570275,
5.29212090816245E-14,
0.826950570351639,
5.58598306499292E-14,
-4.17200995972422E-14,
5.89459037136919E-14,
2.75742970123893E-14,
3.79414381856957E-14,
5.39867629767432E-14,
4.88918801277993E-14,
6.15241364798624E-14,
5.34134368679329E-14,
6.73697209130353E-14,
5.55384731260045E-14,
6.59004101288829E-14,
5.02731536955459E-14,
6.90159734917373E-14,
4.90076729198208E-14,
7.64995705671012E-14,
5.04171357440519E-14,
8.62730026307545E-14,
5.12645481620666E-14,
9.334200079536E-14,
5.14345510627123E-14,
1.04209176010617E-13,
4.60438978611144E-14,
1.11354502008165E-13,
4.02603297922077E-14,
1.07360301204729E-13,
3.47196230099378E-14,
1.10128919872388E-13,
2.4605317783255E-14,
1.03818863228522E-13,
2.14845502499728E-14,
8.90893261940029E-14,
1.49663267889899E-14,
8.35078534100475E-14,
  0,
7.59349180756708E-14,
  0,
6.97879254385469E-14,
  0,
6.92432222670902E-14,
-1.3539516729999E-14,
5.87724313660942E-14,
-1.80896964074861E-14,
5.89528426075958E-14,
0.826965179357338,
5.72285274724749E-14,
0.49643109570275,
5.30374355545149E-14,
0.496415576548055,
5.78131292838791E-14,
0.826943970988464,
5.6919746693751E-14,
-3.8965358717391E-14,
2.23280595401665E-14,
4.28368278349023E-14,
3.87840801141515E-14,
5.58064879030429E-14,
4.76277003946812E-14,
6.29986514344427E-14,
5.18894822942872E-14,
6.30298764570103E-14,
5.33965233140421E-14,
6.81460096685349E-14,
5.39446959324508E-14,
7.40093750173365E-14,
5.1083269558827E-14,
8.13342448946486E-14,
5.36359151537269E-14,
9.39300720537162E-14,
5.15455733651748E-14,
1.03837945186758E-13,
4.86390441811757E-14,
1.11938236457831E-13,
4.20930651445772E-14,
1.13528977885302E-13,
3.85073917197332E-14,
1.1233982494252E-13,
2.79117007284668E-14,
1.08035975998622E-13,
2.01878444516801E-14,
9.21832055134075E-14,
1.30945601584109E-14,
8.28434543187484E-14,
  0,
8.01433572283905E-14,
1.1443970771019E-14,
7.52592432817778E-14,
  0,
7.35037031240893E-14,
  0,
6.37042502082963E-14,
-1.33643096589253E-14,
6.06945049774765E-14,
-2.95926477766884E-14,
5.5724522218803E-14,
0.826957625483291,
5.29212090816245E-14,
0.496415576548055,
5.81756864903582E-14,
0.496401059859392,
5.8340485220576E-14,
0.82693778895219,
5.79900710784287E-14,
2.18954628733448E-14,
2.78941366532726E-14,
4.68453401070157E-14,
3.85008865066983E-14,
5.80577252939918E-14,
4.65500034352306E-14,
5.9010522163172E-14,
5.00207514297912E-14,
6.54736681537926E-14,
5.72250580255229E-14,
7.33189550738977E-14,
5.61295801504436E-14,
7.89646126264643E-14,
5.4378376801445E-14,
8.90927956409548E-14,
5.39724515080664E-14,
1.04491935937201E-13,
4.88159859757253E-14,
1.11655476531247E-13,
4.46977524437564E-14,
1.14169090847938E-13,
4.0311504134749E-14,
1.18561410689111E-13,
3.16430909252929E-14,
1.102182581314E-13,
2.34751454386561E-14,
9.6413328709577E-14,
1.17805071253585E-14,
8.59303947442491E-14,
  0,
7.95188567770388E-14,
  0,
7.94989074570651E-14,
  0,
7.90166543307436E-14,
  0,
6.80133033226227E-14,
  0,
6.57304072282372E-14,
-2.49314457967387E-14,
5.76986375344646E-14,
-3.61533719628326E-14,
5.04787184274491E-14,
0.826950570351639,
5.7814864007355E-14,
0.496401059859392,
5.92841747915074E-14,
0.496387461093047,
5.96554056153664E-14,
0.826931989771602,
  0,
3.08340592641843E-14,
2.90579192652185E-14,
5.0184682798271E-14,
3.791801941877E-14,
5.45427418507938E-14,
4.49609967312359E-14,
6.17435789995735E-14,
5.40296973827736E-14,
7.07905956076615E-14,
5.95166277372883E-14,
7.84129705611036E-14,
5.94958110555766E-14,
8.67795418857398E-14,
5.47825673713476E-14,
9.97622123799502E-14,
5.12445988420929E-14,
1.12401407625917E-13,
4.48868373026379E-14,
1.13953117775178E-13,
4.29630289677796E-14,
1.19250095909074E-13,
3.34957755976362E-14,
1.16493620305747E-13,
2.72594447014995E-14,
9.86736733987748E-14,
1.5105972028806E-14,
9.01830693456063E-14,
  0,
8.2573704818234E-14,
  0,
7.88414472596699E-14,
  0,
8.32285629304153E-14,
  0,
7.35193156353731E-14,
  0,
7.00516034068954E-14,
-1.97619698383278E-14,
6.26425994409985E-14,
-3.15372727932584E-14,
5.25447740873375E-14,
-3.43874234642882E-14,
5.58216667334577E-14,
0.826943970988464,
5.8343954667528E-14,
0.496387461093047,
5.97959182169205E-14,
0.496374704436196,
6.64607258116234E-14,
1.36936902789264E-14,
1.35171821652458E-14,
3.58697446745104E-14,
2.91888908876548E-14,
4.73700939584987E-14,
3.66620796221628E-14,
5.76201412971766E-14,
4.92054313960821E-14,
6.72907909948783E-14,
5.64461671848093E-14,
7.60780327624389E-14,
6.30034219240017E-14,
8.6386627018431E-14,
5.99936766931819E-14,
9.75617156506736E-14,
5.20885418131556E-14,
1.0772632785816E-13,
4.73692265967607E-14,
1.14766703085412E-13,
4.32006860839884E-14,
1.19072286752786E-13,
3.61394941750248E-14,
1.17236949315203E-13,
2.90730980956333E-14,
1.04959443913977E-13,
1.88685872481997E-14,
9.24815779512755E-14,
  0,
8.68818905708224E-14,
  0,
8.19865009216159E-14,
  0,
8.26266138842513E-14,
  0,
7.7786735386276E-14,
  0,
7.55923101891653E-14,
-1.53592416562987E-14,
6.69689997900846E-14,
-2.62793259375727E-14,
5.74106734374524E-14,
-2.98285701694212E-14,
5.78391501360187E-14,
-4.17166301502903E-14,
5.69492369928426E-14,
0.82693778895219,
5.96640792327463E-14,
0.496374704436196,
6.68961414040936E-14,
0.496362721746575,
  0,
2.20687183805079E-14,
1.45361153669477E-14,
3.39255533388094E-14,
2.83388763844261E-14,
5.08785721886618E-14,
4.11346304241E-14,
6.34206229199741E-14,
5.17988429926675E-14,
7.27863949667729E-14,
6.00361774183433E-14,
8.42138858647701E-14,
6.35828195649779E-14,
9.72399244458799E-14,
5.73733768827189E-14,
1.05606495770516E-13,
4.82600071016748E-14,
1.10211319237496E-13,
4.56466461851157E-14,
1.19943985299464E-13,
3.64135804842292E-14,
1.17094701990172E-13,
3.1787072973799E-14,
1.05735732669476E-13,
2.0715200388377E-14,
9.87794915308093E-14,
1.02895122977564E-14,
8.91856033469196E-14,
  0,
8.62651963751127E-14,
  0,
8.57803411635771E-14,
  0,
7.72056030218238E-14,
  0,
7.9882281345256E-14,
-1.23009241681515E-14,
7.25322579775423E-14,
-2.18870060963994E-14,
6.17492168508704E-14,
-2.45827663780673E-14,
6.29635232840542E-14,
-3.70641017877205E-14,
5.89736592893075E-14,
-3.8968828164343E-14,
5.80178266540443E-14,
0.826931989771602,
6.64589910881475E-14,
0.496362721746575,
6.30311774996173E-14,
  0,
  0,
  0,
  0,
0.999999999999989,
-1.09458340828705E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02220749226278E-14,
  0,
1.48819758599705E-14,
  0,
1.88943912599049E-14,
  0,
1.71293101230985E-14,
  0,
1.41657519048266E-14,
  0,
1.82250048386123E-14,
1.72657027563972E-14,
2.61271039525557E-14,
2.35714225915729E-14,
2.2591303827646E-14,
1.97656561257142E-14,
2.21461304156234E-14,
2.11373887143429E-14,
2.68864791541645E-14,
2.76447701536009E-14,
2.85596199467442E-14,
1.78147427365438E-14,
1.89613949541645E-14,
  0,
1.48219110596148E-14,
  0,
  0,
  0,
0.872871560943955,
-1.67601392833672E-14,
0.870388279778472,
-1.67051702332222E-14,
-1.0659225238574E-14,
-1.2508765724617E-14,
  0,
-1.19514858079595E-14,
  0,
-1.04933423061837E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.21682178222393E-14,
  0,
2.17729480278539E-14,
  0,
2.92606650714733E-14,
  0,
3.1188159693718E-14,
  0,
2.71054879930066E-14,
  0,
2.80684763626082E-14,
2.16838266092756E-14,
3.83872621190218E-14,
3.53694937921256E-14,
4.21999674787843E-14,
3.75511254036009E-14,
3.87539392937564E-14,
3.5416331325977E-14,
4.24779569158096E-14,
4.22435524061182E-14,
4.80134595276516E-14,
3.93901491285709E-14,
4.11467734884319E-14,
2.34009860100581E-14,
2.9243100996279E-14,
  0,
  0,
  0,
0.857142857142842,
-1.61316272839773E-14,
0.580796877272654,
-2.07354749690025E-14,
0.84569137219913,
-1.88161118630514E-14,
-1.19999496450696E-14,
-1.74170573796761E-14,
  0,
-1.27018621315367E-14,
  0,
-1.24540135149065E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.34842224192022E-14,
  0,
2.14121255448507E-14,
  0,
3.27702275038089E-14,
  0,
3.74353326115795E-14,
  0,
3.73065293934882E-14,
1.30438194967386E-14,
3.75663042340157E-14,
2.14121255448507E-14,
4.40034293724967E-14,
3.59525777204883E-14,
4.88476446791619E-14,
4.42371833608846E-14,
5.3108125536161E-14,
4.85384302195691E-14,
5.38822458873156E-14,
5.15811351964324E-14,
5.75620280607314E-14,
4.81286017983695E-14,
5.43974587596807E-14,
4.08536052209918E-14,
4.69637349842511E-14,
2.17820553261028E-14,
3.12779316335998E-14,
  0,
0.872871560943955,
-1.60991012188028E-14,
0.545454545454527,
-1.95343958023231E-14,
0.525971891352156,
-2.23703434248934E-14,
0.83599831423911,
-2.32405240885303E-14,
-1.21484853427001E-14,
-1.73999269853509E-14,
  0,
-1.41111081153333E-14,
  0,
-1.03075100538197E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.40837862205867E-14,
  0,
2.20366259962024E-14,
  0,
3.12406350788663E-14,
  0,
3.94393719072017E-14,
  0,
4.19438789256432E-14,
1.47863492283573E-14,
4.62364521669478E-14,
2.44383506486923E-14,
5.18734361021345E-14,
3.45001804902267E-14,
5.24489306152898E-14,
4.30887964197879E-14,
5.75867478702641E-14,
5.32616485637849E-14,
6.6047427943472E-14,
6.26582119522823E-14,
6.6644172819208E-14,
5.527739724287E-14,
6.14968145851158E-14,
4.76285677564192E-14,
5.80473169531359E-14,
3.79344992917918E-14,
4.7348843595918E-14,
2.83163249792384E-14,
0.999999999999989,
-1.67433341496936E-14,
0.580796877272654,
-1.94788846510918E-14,
0.485514485514467,
-1.99488862928643E-14,
0.50427290565928,
-2.53783539322372E-14,
0.831066127746857,
-2.30434161335724E-14,
-1.16443313324943E-14,
-1.84875986047883E-14,
  0,
-1.17640272523367E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.31756584809128E-14,
  0,
2.22686452611143E-14,
  0,
3.13742087865165E-14,
  0,
3.71772924945279E-14,
  0,
4.30922658667399E-14,
1.21595442048594E-14,
4.99743475768089E-14,
2.57693172356355E-14,
5.95070867581704E-14,
3.68940988870747E-14,
5.91883313194597E-14,
4.08206454749482E-14,
6.00014829488238E-14,
5.10780653883991E-14,
6.92141656488676E-14,
6.61901089493711E-14,
7.7412902477203E-14,
6.51011362873266E-14,
6.91998541801908E-14,
5.36801506023643E-14,
6.39037434080336E-14,
4.37245725737334E-14,
5.73222025401776E-14,
4.38017677684144E-14,
5.31957290716978E-14,
-1.09458340828705E-14,
0.870388279778472,
-2.08048639080416E-14,
0.525971891352156,
-1.99042171633579E-14,
0.461538461538443,
-2.38069113034367E-14,
0.493166751957507,
-2.51599956146986E-14,
0.828179398818821,
-2.35482206650817E-14,
  0,
-1.60127987258729E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
2.11402076399914E-14,
  0,
3.12597170371021E-14,
  0,
3.68628738645072E-14,
  0,
4.03488006894825E-14,
1.0920951643012E-14,
5.05762966229728E-14,
2.28935793933349E-14,
6.25584653524136E-14,
3.77978898180586E-14,
6.61324293937948E-14,
4.2707590935942E-14,
6.60387543260921E-14,
4.82240115895483E-14,
7.08161827789322E-14,
6.3200313038525E-14,
7.9658068335986E-14,
6.78172795698373E-14,
7.90665276306779E-14,
6.27935203834085E-14,
7.07663094789979E-14,
4.91911199274053E-14,
6.24209885169424E-14,
4.91486192022439E-14,
6.24751986255667E-14,
4.50329877554889E-14,
  0,
-1.67259869149339E-14,
0.84569137219913,
-2.24538269921748E-14,
0.50427290565928,
-2.37754694404346E-14,
0.449197860962549,
-2.3259172365897E-14,
0.486641753359994,
-2.6403358666105E-14,
0.826332327885253,
-2.07867577317611E-14,
-1.13234074894386E-14,
-1.34323975553574E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.70952661748824E-14,
  0,
2.98897191719494E-14,
  0,
3.64677905928534E-14,
  0,
3.97047845990262E-14,
  0,
4.74642027070704E-14,
2.15123058255884E-14,
6.27358408278322E-14,
3.47248271803657E-14,
6.86555846896031E-14,
4.32913253856082E-14,
7.24329450585426E-14,
4.97778901431545E-14,
7.63295676664555E-14,
5.99186499028459E-14,
8.06377534190439E-14,
6.43009950840323E-14,
8.06498964833757E-14,
6.49610573666415E-14,
8.00253960320241E-14,
5.78495584768746E-14,
6.87757142903145E-14,
5.41676078991138E-14,
6.70409908143377E-14,
5.00025368332935E-14,
6.55335161137138E-14,
  0,
-1.071376060785E-14,
-1.87597333500822E-14,
0.83599831423911,
-2.53805223365822E-14,
0.493166751957507,
-2.3258305004159E-14,
0.441923401675706,
-2.40228843761958E-14,
0.482456099532277,
-2.31767730007881E-14,
0.825074431946707,
-1.81968155821277E-14,
-1.0992508986396E-14,
-1.11824612070155E-14,
  0,
  0,
  0,
  0,
  0,
1.50205368976142E-14,
  0,
2.57805929382293E-14,
  0,
3.48965648044874E-14,
  0,
3.91119428511111E-14,
  0,
4.65500034352306E-14,
1.88724903760207E-14,
5.93010883453982E-14,
3.31631423711176E-14,
6.84127234029663E-14,
4.00048917603701E-14,
7.45631854870421E-14,
5.0113992816625E-14,
8.22874754446978E-14,
6.11533393368724E-14,
8.57413098853677E-14,
6.05886868454419E-14,
8.11729156113827E-14,
6.10570621839557E-14,
8.11390885036012E-14,
5.96606097857943E-14,
7.7562956057875E-14,
6.24908111368505E-14,
7.29945617838901E-14,
5.47227194114264E-14,
6.96864441152023E-14,
5.27269200523151E-14,
  0,
-1.2507898362879E-14,
-1.19990822833316E-14,
-2.32977699632375E-14,
0.831066127746857,
-2.51608629764366E-14,
0.486641753359994,
-2.40254864614098E-14,
0.437246963562738,
-2.07668084117874E-14,
0.479600515134732,
-2.03777966722996E-14,
0.824177123979284,
-1.57486870766554E-14,
-1.32840786981614E-14,
  0,
  0,
  0,
  0,
1.00934885449711E-14,
  0,
2.3561881612455E-14,
  0,
3.06837888430778E-14,
  0,
3.73884950777281E-14,
  0,
4.5775449403207E-14,
1.97515614974719E-14,
5.81752528094892E-14,
3.0438759152096E-14,
6.47320738678125E-14,
3.829749017914E-14,
7.40093750173365E-14,
4.65938052029991E-14,
8.40482197728143E-14,
6.12296671698154E-14,
9.13132416902052E-14,
6.16017653554124E-14,
8.58896287425637E-14,
5.70845454239688E-14,
8.13151629364128E-14,
5.54851303791182E-14,
7.83487857924925E-14,
6.39896122200945E-14,
8.14712880492507E-14,
6.27631627225789E-14,
7.53537857112185E-14,
5.71756184064576E-14,
7.64457941393459E-14,
  0,
  0,
-1.73893018040605E-14,
-1.20936247127723E-14,
-2.29879049823412E-14,
0.828179398818821,
-2.6399889219153E-14,
0.482456099532277,
-2.07386191553027E-14,
0.434051881622198,
-1.82913580115684E-14,
0.477560898658058,
-1.75671109603481E-14,
0.823513595914334,
-1.41800633735034E-14,
-1.31153768401227E-14,
  0,
  0,
  0,
  0,
1.86278943659079E-14,
  0,
2.83826781521945E-14,
  0,
3.30057162156727E-14,
1.0173285824866E-14,
4.38919733891652E-14,
1.87527944561783E-14,
5.72554156863525E-14,
3.12215531206306E-14,
6.342669445214E-14,
3.54256554646604E-14,
7.00767568972971E-14,
4.47038239759223E-14,
8.32927476990264E-14,
5.75355735277228E-14,
9.27877566447854E-14,
6.14673242860242E-14,
9.12256381546683E-14,
5.78313438803768E-14,
8.57361057149397E-14,
5.13252634837258E-14,
7.823342668134E-14,
5.96475993597245E-14,
8.19353265790745E-14,
6.40694094999894E-14,
8.35815791577765E-14,
6.50313136674185E-14,
8.18355799792059E-14,
5.50601231275039E-14,
  0,
-1.19818434687891E-14,
  0,
-1.73999269853509E-14,
-1.16417292472804E-14,
-2.35482206650817E-14,
0.826332327885253,
-2.32179726833426E-14,
0.479600515134732,
-1.82913580115684E-14,
0.431767398034713,
-1.62912218437672E-14,
0.476051232703976,
-1.64217597853344E-14,
0.823008605159556,
  0,
-1.24622534514174E-14,
  0,
  0,
1.74170573796761E-14,
  0,
2.33294286666741E-14,
  0,
3.0667742650925E-14,
  0,
3.94640917167344E-14,
2.05911676598447E-14,
5.52283913046736E-14,
3.01564329063808E-14,
6.23190735127288E-14,
3.61047997055053E-14,
6.85918336018609E-14,
4.17790801954254E-14,
7.91164009306122E-14,
5.55180901251617E-14,
9.17599329852692E-14,
5.76205749780456E-14,
9.24833126747515E-14,
5.75685332737663E-14,
9.08153760525998E-14,
5.19766521489551E-14,
8.24123755349682E-14,
5.53975268435813E-14,
8.16386888646825E-14,
5.95296381633581E-14,
8.38140321035574E-14,
6.61883742258951E-14,
8.98213795008651E-14,
6.27978571920984E-14,
8.35252006448073E-14,
  0,
  0,
-1.27016452911022E-14,
  0,
-1.85166552230109E-14,
  0,
-2.07733136248223E-14,
0.825074431946707,
-2.0266774369837E-14,
0.477560898658058,
-1.6228338117763E-14,
0.430075187969907,
-1.40148309624166E-14,
0.474901434241775,
  0,
0.822615085441342,
  0,
  0,
1.33235436572399E-14,
  0,
2.2066116295294E-14,
  0,
2.55559462480903E-14,
  0,
3.7025937871249E-14,
1.95590071916385E-14,
5.06721400950205E-14,
3.18928911058336E-14,
6.01931698929192E-14,
3.49390655296489E-14,
6.73410979756817E-14,
4.23246507286201E-14,
7.74944344805739E-14,
5.24398233170409E-14,
8.74586861265847E-14,
5.54755894000003E-14,
9.12395159424761E-14,
5.35968838755174E-14,
9.19316706093909E-14,
5.15256240452011E-14,
8.73138367163406E-14,
5.59014640133526E-14,
8.56623799672107E-14,
5.51511961099926E-14,
8.33144317424761E-14,
6.15054882024957E-14,
8.98890337164282E-14,
6.38395586394225E-14,
9.13297215632269E-14,
6.65197064098066E-14,
  0,
-1.04939928274872E-14,
  0,
-1.4136261605735E-14,
  0,
-1.60110640023969E-14,
-1.13359842346394E-14,
-1.81898766882238E-14,
0.824177123979284,
-1.75879276420599E-14,
0.476051232703976,
-1.40078920685127E-14,
0.428785607196384,
  0,
0.4740049305501,
  0,
0.822302312523379,
  0,
  0,
1.80905637692241E-14,
  0,
2.42618425350116E-14,
  0,
3.18738091475979E-14,
1.81313297709096E-14,
4.81455153522603E-14,
3.08381792324397E-14,
5.55970200433187E-14,
3.66269514717743E-14,
6.51301929055492E-14,
4.10938644224146E-14,
7.61656362979757E-14,
5.29073312938166E-14,
8.56857987341364E-14,
5.23522197815041E-14,
8.67769398005258E-14,
5.13582232297694E-14,
9.05404223816575E-14,
4.74724426435813E-14,
8.82436484994642E-14,
5.53584955653719E-14,
9.04016445035793E-14,
5.55918158728907E-14,
8.71698546678346E-14,
5.70056155058118E-14,
8.92454513068408E-14,
5.90369766961807E-14,
9.12100256433845E-14,
6.74260994260045E-14,
1.07957913442203E-13,
  0,
  0,
-1.24245232158149E-14,
  0,
-1.17605578053848E-14,
  0,
-1.34588520883661E-14,
-1.09638860490424E-14,
-1.57582280557733E-14,
0.823513595914334,
-1.64191577001205E-14,
0.474901434241775,
  0,
0.4277796585578,
  0,
0.473292058786036,
  0,
0.822049510330789,
1.31275199044545E-14,
  0,
2.01626909612784E-14,
  0,
3.05415415180477E-14,
1.63176763767758E-14,
4.29517532651857E-14,
2.94451962812303E-14,
5.30044758084713E-14,
3.55132590001972E-14,
6.04447047969359E-14,
4.27661378532562E-14,
7.38393721166908E-14,
5.16609324763273E-14,
8.42615907603594E-14,
5.26731436245598E-14,
8.49311940220865E-14,
4.81463827139983E-14,
8.59199864033933E-14,
4.52181694865494E-14,
8.67526536718621E-14,
5.12437314803549E-14,
9.11657901947471E-14,
5.49863973797748E-14,
9.1771208687863E-14,
5.73777136914089E-14,
9.29369428637195E-14,
5.44781234013136E-14,
9.04085833974833E-14,
6.25905577367192E-14,
1.0768295977126E-13,
6.91061791124881E-14,
  0,
  0,
  0,
-1.03404697998632E-14,
  0,
  0,
  0,
-1.12119515061071E-14,
-1.32285675469301E-14,
-1.41830991395864E-14,
0.823008605159556,
  0,
0.4740049305501,
  0,
0.426979472140749,
  0,
0.472715661298871,
1.10857503732298E-14,
0.821842206717152,
1.51935755643429E-14,
  0,
2.6401623942629E-14,
1.40209024945825E-14,
4.15622397609283E-14,
2.7524857393324E-14,
4.77447942293097E-14,
3.40925204733722E-14,
5.77897105169534E-14,
4.16220877208495E-14,
6.91001075803221E-14,
5.32482044568461E-14,
8.18668050017735E-14,
5.13486822506515E-14,
8.33794838728252E-14,
4.84898579622417E-14,
8.39450037259937E-14,
4.19516851812851E-14,
8.20428794345851E-14,
4.8918334660808E-14,
8.95750487672764E-14,
5.07502026514395E-14,
9.24390772261141E-14,
5.67263250261796E-14,
9.74307440282374E-14,
5.47574138809459E-14,
9.39847158432094E-14,
5.79319578419835E-14,
1.06773964669848E-13,
6.41231859277447E-14,
1.17012302625064E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.31153768401227E-14,
  0,
0.822615085441342,
  0,
0.473292058786036,
  0,
0.426332288401243,
1.33374214450477E-14,
0.472242860272771,
1.30190996872059E-14,
0.821670061884342,
2.13570480744885E-14,
  0,
3.73139019682611E-14,
2.52896661945279E-14,
4.63032390207729E-14,
3.21869267350117E-14,
5.24484969344208E-14,
4.01579811071251E-14,
6.63358257213531E-14,
5.20711945783958E-14,
7.69922320342786E-14,
5.29186069964105E-14,
8.08866862378466E-14,
4.71393757361938E-14,
8.2353394936785E-14,
4.22249041287515E-14,
7.99794258599107E-14,
4.55867982251945E-14,
8.4742109163205E-14,
4.83675599571853E-14,
9.07511912839887E-14,
5.24606399987526E-14,
9.79893249875019E-14,
5.39984723602061E-14,
9.83978523660944E-14,
5.81505329999565E-14,
1.102616262183E-13,
5.94004012643978E-14,
1.15979274795119E-13,
6.24474430499511E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.241368119409E-14,
  0,
0.822302312523379,
  0,
0.472715661298871,
1.33547686798074E-14,
0.425801297881377,
1.56836349463063E-14,
0.471850148753609,
1.92103277729672E-14,
0.821525524653432,
3.25312693449931E-14,
2.05443301259933E-14,
4.21789339566381E-14,
2.98849486823904E-14,
5.10346973014997E-14,
3.82385095809568E-14,
6.10501232900518E-14,
5.05411684725843E-14,
7.42106029405498E-14,
5.17294540536284E-14,
7.59991028442819E-14,
4.86503198837696E-14,
7.98241681088108E-14,
4.08284517305901E-14,
7.8310621876021E-14,
4.58348636822592E-14,
8.26170729051334E-14,
4.50368908833099E-14,
8.58462606556643E-14,
4.99869243220097E-14,
9.62042945307218E-14,
4.96911539693556E-14,
9.88532172785384E-14,
5.73187330932257E-14,
1.14503892478801E-13,
5.95539242920218E-14,
1.19358516126322E-13,
5.7668279873635E-14,
1.21236354289067E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.822049510330789,
1.11551393122689E-14,
0.472242860272771,
1.56237869863851E-14,
0.425360167295645,
2.15322551455621E-14,
0.471520349199964,
3.04617442381527E-14,
0.821402973644018,
3.72774727752656E-14,
2.53382384518552E-14,
4.68028393818543E-14,
3.59512766778813E-14,
5.95799451441614E-14,
4.87708831653499E-14,
6.89214310622965E-14,
5.02358571408124E-14,
7.31706362167017E-14,
4.73831043845685E-14,
7.48142867101897E-14,
4.22830173651967E-14,
7.57371595994094E-14,
4.43820327711286E-14,
8.08892883230605E-14,
4.52415882534751E-14,
8.36266819681519E-14,
4.66198260551387E-14,
9.12412506659521E-14,
4.7197488972639E-14,
9.69970631592432E-14,
5.29498320189781E-14,
1.14921093474774E-13,
5.86804910218675E-14,
1.23502770510431E-13,
5.77914452404293E-14,
1.24491562891738E-13,
5.25395699169096E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.32758387616505E-14,
  0,
1.31205810105506E-14,
0.821842206717152,
1.30217017724199E-14,
0.471850148753609,
2.16406753628107E-14,
0.424989644501844,
3.24410637242423E-14,
0.471240667511765,
3.52409074144688E-14,
0.821298152718582,
4.17617329606657E-14,
3.14010970003942E-14,
5.52665552211451E-14,
4.63786994919779E-14,
6.7392272318223E-14,
4.83137835294301E-14,
6.78216163785272E-14,
4.59120588769402E-14,
7.20317902547229E-14,
4.10513636972532E-14,
7.07003899869107E-14,
4.58426699379011E-14,
7.82551107247897E-14,
4.37818184484406E-14,
8.18494577670137E-14,
4.67985025731643E-14,
8.89861101471823E-14,
4.37826858101786E-14,
9.19498852058886E-14,
5.04474934048815E-14,
1.12923559392186E-13,
5.42690892224584E-14,
1.23799408224823E-13,
5.69084709911571E-14,
1.28577704039401E-13,
5.26228366437564E-14,
1.23925175676831E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.00666003310934E-14,
  0,
1.73823629101566E-14,
  0,
1.80563029805736E-14,
  0,
1.53089346754953E-14,
0.821670061884342,
1.91366020252381E-14,
0.471520349199964,
3.24254512129585E-14,
0.424675384403137,
3.74231895472477E-14,
0.471001412662876,
3.94753674193282E-14,
0.821207790590474,
5.00736604958085E-14,
4.17409162789539E-14,
6.32133234645949E-14,
4.59641005812195E-14,
6.63184784865933E-14,
4.39388109230165E-14,
6.65405230915184E-14,
3.95430216348913E-14,
6.79196282549199E-14,
4.45754544387E-14,
7.32304841766229E-14,
4.52190368482874E-14,
7.9207473913101E-14,
4.53031709368723E-14,
8.71585789652407E-14,
4.39431477317065E-14,
8.96661217497652E-14,
4.70101388372335E-14,
1.07929290504849E-13,
5.17459339266502E-14,
1.21793200524856E-13,
5.24415580405169E-14,
1.28766788898282E-13,
5.17190457127725E-14,
1.27919376480268E-13,
4.44783099240453E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.49910465985226E-14,
  0,
1.85949346198644E-14,
  0,
2.2065682614425E-14,
  0,
2.01618235995404E-14,
  0,
2.14125592257197E-14,
0.821525524653432,
3.04617442381527E-14,
0.471240667511765,
3.7397168695108E-14,
0.424406517429793,
4.18267850910148E-14,
0.470795133333837,
4.82773543364345E-14,
0.82112933885621,
5.82988518571526E-14,
4.12664694082743E-14,
6.20215684365988E-14,
4.15717807400462E-14,
6.51128456707895E-14,
3.75758452131336E-14,
6.24257590065014E-14,
4.30220095659628E-14,
7.0384670314283E-14,
4.39457498169205E-14,
7.41308056606549E-14,
4.67187052932694E-14,
8.44584818748828E-14,
4.24634286066983E-14,
8.77596606496667E-14,
4.71879479935211E-14,
1.05542311001905E-13,
4.82964362946703E-14,
1.16635000269039E-13,
4.99149332977566E-14,
1.26658232513233E-13,
4.72243771865166E-14,
1.28045143932276E-13,
4.35545696730877E-14,
1.33341254704433E-13,
  0,
  0,
  0,
  0,
1.31765258426508E-14,
  0,
1.71178175800701E-14,
  0,
2.35358607603153E-14,
  0,
2.33146835171283E-14,
  0,
2.4235821682872E-14,
  0,
2.63773378139653E-14,
  0,
3.25087179398054E-14,
0.821402973644018,
3.51021295363907E-14,
0.471001412662876,
4.18337239849187E-14,
0.42417468364539,
5.03893801684363E-14,
0.470616022933552,
5.59647814202258E-14,
0.821060788032121,
5.6621374255883E-14,
3.70294073182009E-14,
6.08263439616508E-14,
3.53302456734816E-14,
6.09182843058775E-14,
4.10374859094453E-14,
6.4994017112685E-14,
4.24191931580609E-14,
7.12867265217909E-14,
4.54462856236404E-14,
7.93948240485065E-14,
4.39006470065451E-14,
8.50795128792825E-14,
4.56778712076833E-14,
1.0366013603047E-13,
4.83996523414909E-14,
1.14261898553902E-13,
4.64081897910695E-14,
1.21522583662603E-13,
4.46890788263765E-14,
1.25898423630755E-13,
3.90087268042905E-14,
1.3342018462259E-13,
3.93313853708221E-14,
  0,
  0,
  0,
1.40950619231806E-14,
  0,
2.1164060087786E-14,
  0,
2.57537047243517E-14,
  0,
2.83822444713255E-14,
  0,
2.55559462480903E-14,
  0,
3.05233269215499E-14,
1.40191677711066E-14,
3.72852790309075E-14,
2.05408606790414E-14,
3.72722686048377E-14,
0.821298152718582,
3.95525626140092E-14,
0.470795133333837,
5.03893801684363E-14,
0.423973366757102,
5.79571113323851E-14,
0.470459501542617,
5.44729192308857E-14,
0.821000536086887,
5.57566146031085E-14,
3.06707784170079E-14,
5.66144353619791E-14,
3.88127030515051E-14,
6.33113353409875E-14,
4.05188035901283E-14,
6.57546933569009E-14,
4.38555441961697E-14,
7.65073768227431E-14,
4.25380217161653E-14,
7.99447313903912E-14,
4.70517722006569E-14,
1.00903660427143E-13,
4.69025859817229E-14,
1.12314671452118E-13,
4.65035995822483E-14,
1.19061011050192E-13,
4.11519776588598E-14,
1.20693385841086E-13,
3.64543464859146E-14,
1.31224024702004E-13,
3.47907466724529E-14,
1.24662433154121E-13,
  0,
  0,
1.34967991644031E-14,
  0,
2.22560685159134E-14,
  0,
2.98914538954254E-14,
  0,
3.06950645456716E-14,
  0,
3.0668610012663E-14,
  0,
3.18746765093358E-14,
1.6304665950706E-14,
4.15362189087887E-14,
2.52480328311044E-14,
4.21997506383498E-14,
2.53252280257854E-14,
4.1732242661574E-14,
0.821207790590474,
4.82643439103647E-14,
0.470616022933553,
5.7964050226289E-14,
0.423797425947159,
5.69240835024409E-14,
0.470321917003293,
5.36549971119626E-14,
0.820947292991977,
5.16184317511659E-14,
3.38990988058008E-14,
5.9085548953508E-14,
3.81378956193501E-14,
6.42342082302072E-14,
4.18901024978879E-14,
7.10221811917044E-14,
4.09524844591225E-14,
7.70512126324618E-14,
4.57099635919889E-14,
9.57437254478499E-14,
4.83302634024518E-14,
1.09598961850477E-13,
4.50160742015981E-14,
1.17102508245814E-13,
4.12283054918028E-14,
1.18224006973033E-13,
3.2910306424494E-14,
1.25954802143724E-13,
3.22008045228195E-14,
1.22469742680487E-13,
2.8270788487994E-14,
  0,
1.21604115665974E-14,
  0,
2.20192787614426E-14,
  0,
3.13013504005255E-14,
  0,
3.4929524550531E-14,
  0,
3.30334717912883E-14,
  0,
3.70467545529607E-14,
1.81243908770057E-14,
4.29630289677796E-14,
2.75265921168E-14,
4.62945654033931E-14,
2.98571931067748E-14,
4.68011046583783E-14,
3.13967601917042E-14,
5.00762625810225E-14,
0.82112933885621,
5.59613119732738E-14,
0.470459501542617,
5.69232161407029E-14,
0.423642760998449,
5.57037055370913E-14,
0.470200327805787,
4.90900722849297E-14,
0.820900010419969,
5.40565855966513E-14,
3.34203151264312E-14,
5.99546454149724E-14,
3.95308785705595E-14,
6.94201640616399E-14,
3.89367357800374E-14,
7.16050482796327E-14,
4.40715172689288E-14,
9.28111754117111E-14,
4.69511582390503E-14,
1.04416475465996E-13,
4.63908425563098E-14,
1.14333022216417E-13,
3.97052182798951E-14,
1.16255963189538E-13,
3.29953078748169E-14,
1.23448994082676E-13,
2.86715096109447E-14,
1.17154549950094E-13,
2.56357435279853E-14,
1.16648010695108E-13,
1.02220749226278E-14,
  0,
2.14129929065887E-14,
  0,
3.13559941900188E-14,
  0,
3.64695253163294E-14,
  0,
3.73780867368723E-14,
1.0175020548342E-14,
3.94640917167344E-14,
1.95538030212106E-14,
4.81489847992123E-14,
2.94174407056147E-14,
4.77673456344974E-14,
3.21903961819636E-14,
5.10346973014997E-14,
3.59998489352087E-14,
5.52596163272412E-14,
4.17400489172159E-14,
5.82849740693447E-14,
0.821060788032121,
5.44599088048159E-14,
0.470321917003293,
5.57314611127069E-14,
0.423506068972631,
5.18144555039513E-14,
0.470092343114877,
5.17866999283356E-14,
0.820857829282191,
5.50315001901502E-14,
3.4782940416811E-14,
6.51345297142392E-14,
3.66000632578967E-14,
6.98651206332279E-14,
4.20488296959398E-14,
8.73285818658864E-14,
4.52797521699466E-14,
1.01424077469936E-13,
4.50603096502356E-14,
1.09158342087579E-13,
4.11450387649559E-14,
1.13443109073241E-13,
3.14557407898874E-14,
1.21432378041852E-13,
2.87721235725513E-14,
1.14635731462975E-13,
2.21125201482764E-14,
1.11329348517764E-13,
1.92467569659627E-14,
  0,
2.17720806661159E-14,
  0,
3.12306604188795E-14,
  0,
3.68628738645072E-14,
  0,
3.9115412298063E-14,
  0,
4.39214636882568E-14,
2.05564731903252E-14,
5.06721400950205E-14,
3.08390465941777E-14,
5.29958021910915E-14,
3.41116024316079E-14,
5.24276802527091E-14,
3.82662651565724E-14,
5.95782104206855E-14,
4.63361987668165E-14,
6.32480179341144E-14,
4.12638673230603E-14,
5.66291805115249E-14,
0.821000536086887,
5.35431074477621E-14,
0.470200327805787,
5.18153228656892E-14,
0.423384664870762,
5.39759209550184E-14,
0.46999600334943,
5.26766130715117E-14,
0.820820040106237,
6.00170954601076E-14,
3.1862533445004E-14,
6.56185175640367E-14,
3.97086877268471E-14,
8.5641563285499E-14,
4.33125757481889E-14,
9.58929116667839E-14,
4.34010466454637E-14,
1.06168546176733E-13,
3.97832808363141E-14,
1.08230265027931E-13,
3.28678056993326E-14,
1.18627330181198E-13,
2.7226484955456E-14,
1.12588757761323E-13,
2.22200730037869E-14,
1.08728998027274E-13,
1.56905738402102E-14,
1.05958644636139E-13,
1.48819758599705E-14,
  0,
3.27841052916167E-14,
  0,
3.71391285780565E-14,
  0,
3.96943762581703E-14,
  0,
4.57806535736349E-14,
1.87527944561783E-14,
5.52561468802892E-14,
3.19223814049252E-14,
5.56108978311265E-14,
3.5530606234957E-14,
5.77758327291455E-14,
4.01302255315095E-14,
6.10223677144361E-14,
4.87162393758567E-14,
6.74191605321006E-14,
4.5998795050739E-14,
6.20224357983368E-14,
3.70294073182009E-14,
5.58260035421476E-14,
0.820947292991977,
4.90449694745543E-14,
0.470092343114877,
5.39906661045642E-14,
0.423276347719531,
5.51503287482547E-14,
0.469909689961742,
5.82190545772576E-14,
0.820786052778533,
6.08428238346725E-14,
3.49867704252382E-14,
8.13221018303167E-14,
4.09602907147644E-14,
9.4242322279392E-14,
4.14095840950424E-14,
1.00613961606655E-13,
3.81673859184417E-14,
1.05219652435373E-13,
3.15303338993544E-14,
1.13407547241984E-13,
2.86680401639927E-14,
1.09733402919865E-13,
2.06640260458357E-14,
1.06688963219526E-13,
1.57946572487688E-14,
1.03361763592602E-13,
1.18238752122579E-14,
  0,
2.92606650714733E-14,
  0,
3.94393719072017E-14,
  0,
4.03305860929848E-14,
  0,
4.65526055204446E-14,
1.97394184331401E-14,
5.72484767924486E-14,
3.0146024565525E-14,
6.01931698929192E-14,
3.66416966213201E-14,
6.04559804995297E-14,
4.16281592530154E-14,
6.63358257213531E-14,
5.05368316638943E-14,
6.89275025944625E-14,
4.82860279538144E-14,
6.63080701457375E-14,
4.15908626982819E-14,
6.08350175790306E-14,
3.06152672657767E-14,
5.16184317511659E-14,
0.820900010419969,
5.17919040987636E-14,
0.46999600334943,
5.51520634717306E-14,
0.423179299376596,
6.02183233833209E-14,
0.46983205652245,
5.82329323650654E-14,
0.820755373201918,
7.65325303131448E-14,
3.61802601767103E-14,
8.99098503981399E-14,
3.89783691434609E-14,
9.90336285200399E-14,
3.61308205576449E-14,
9.96772109296273E-14,
2.98962243849843E-14,
1.10335351966029E-13,
2.72924044475431E-14,
1.04492803298939E-13,
2.20552742735691E-14,
1.03816261143308E-13,
1.41744255222065E-14,
1.0128876903881E-13,
1.18793863634892E-14,
1.04657602029157E-13,
1.88943912599049E-14,
  0,
3.74283937176756E-14,
  0,
4.3078821759801E-14,
1.0922686366488E-14,
4.74676721540224E-14,
1.88750924612346E-14,
5.81752528094892E-14,
3.12024711623948E-14,
6.23364207474886E-14,
3.49546780409327E-14,
6.51414686081431E-14,
4.27609336828283E-14,
6.90766888133965E-14,
5.20859397279416E-14,
7.42036640466459E-14,
5.02375918642883E-14,
6.78216163785272E-14,
4.39405456464925E-14,
6.51093762238375E-14,
3.53458581847654E-14,
5.66430582993327E-14,
3.38956293588488E-14,
5.40479119792714E-14,
0.820857829282191,
5.26766130715117E-14,
0.469909689961742,
6.02755692580281E-14,
0.423092007216278,
6.08237418764368E-14,
0.469761975542134,
7.45627518061731E-14,
0.820727585117053,
8.51567080739635E-14,
3.41636441358872E-14,
9.45181433120723E-14,
3.37013403295394E-14,
9.7906058260655E-14,
2.78353728955238E-14,
1.04751277096859E-13,
2.56634991036009E-14,
1.0143101636384E-13,
2.06917816214514E-14,
9.85461712232905E-14,
1.56090418368393E-14,
9.84125975156402E-14,
1.031813523511E-14,
1.02534300494561E-13,
  0,
  0,
3.11950985876219E-14,
  0,
4.195819039432E-14,
1.21669167796323E-14,
5.05884396873046E-14,
2.14906217821387E-14,
5.93010883453982E-14,
3.04682494511876E-14,
6.34128166643322E-14,
3.60926566411734E-14,
6.73619146573934E-14,
4.1133763062362E-14,
7.3823759605407E-14,
5.32117752638506E-14,
7.6961007011711E-14,
5.16947595841089E-14,
7.31576257906319E-14,
4.58825685778486E-14,
6.65951668810116E-14,
3.75758452131336E-14,
6.09165495824016E-14,
3.88066315193392E-14,
5.90439155900846E-14,
3.34203151264312E-14,
5.50696641066217E-14,
0.820820040106237,
5.81635434260264E-14,
0.46983205652245,
6.08757835807161E-14,
0.423013204458372,
7.59878271416881E-14,
0.469698497048046,
8.2498244347029E-14,
0.820702335820809,
8.94761695291457E-14,
2.90011070713803E-14,
9.36039440402325E-14,
2.54761489681954E-14,
1.03106759241633E-13,
2.36165254019483E-14,
9.58018386842951E-14,
1.90923665766007E-14,
9.55329565455187E-14,
1.42594269725294E-14,
9.31355687017188E-14,
1.16955056750356E-14,
9.9626903948824E-14,
  0,
9.75816649706474E-14,
1.71293101230985E-14,
  0,
3.72926516056804E-14,
1.47863492283573E-14,
4.99695770872499E-14,
2.29048550959288E-14,
6.27289019339283E-14,
3.31635760519866E-14,
6.47338085912885E-14,
3.54430026994201E-14,
6.85554044088654E-14,
4.23411306016419E-14,
7.61699731066656E-14,
5.16591977528513E-14,
8.18858869600092E-14,
5.28908514207949E-14,
7.60008375677579E-14,
4.74143294071361E-14,
7.2029188169509E-14,
3.95534299757472E-14,
6.24118812186936E-14,
4.10730477407029E-14,
6.33685812156948E-14,
3.81326914489222E-14,
5.99268898393568E-14,
3.47551848411953E-14,
6.00708718878629E-14,
0.820786052778533,
5.82173198537816E-14,
0.469761975542134,
7.59600715660724E-14,
0.422941823679207,
8.48505293804536E-14,
0.469640816034261,
8.72626623737993E-14,
0.820679324854205,
8.83199763324072E-14,
2.06310662997922E-14,
9.8726582464792E-14,
2.11532180660612E-14,
9.41191569125976E-14,
1.69603914246252E-14,
8.98742885668824E-14,
1.25698063069279E-14,
9.00356178501482E-14,
1.03857894506731E-14,
9.43446709644746E-14,
  0,
9.46447781258186E-14,
  0,
  0,
2.70939954499783E-14,
1.30455542202146E-14,
4.62295132730439E-14,
2.57849297469193E-14,
6.26139765036449E-14,
3.47248271803657E-14,
6.84075192325384E-14,
3.83009596260919E-14,
7.00784916207731E-14,
4.17669371310936E-14,
7.7489230310146E-14,
5.28969229529608E-14,
8.42477129725516E-14,
5.13564885062934E-14,
8.08953598552264E-14,
4.8617360137726E-14,
7.48290318597356E-14,
4.10583025911571E-14,
6.7912689361016E-14,
4.30272137363907E-14,
6.49662615370694E-14,
4.04771702267048E-14,
6.42342082302072E-14,
3.95352153792494E-14,
6.51067741386235E-14,
3.18382473163403E-14,
6.08393543877206E-14,
0.820755373201918,
7.45627518061731E-14,
0.469698497048046,
8.48522641039295E-14,
0.422876960275528,
8.9679132175835E-14,
0.46958824667524,
8.67569904805521E-14,
0.820658294973941,
9.38190497512537E-14,
1.65353841730109E-14,
8.96973467723328E-14,
1.46549439250521E-14,
8.81551776021894E-14,
1.06026298851702E-14,
8.44272568523152E-14,
  0,
9.12325770485722E-14,
  0,
8.93469326301854E-14,
  0,
9.06566488545479E-14,
1.41657519048266E-14,
  0,
3.75663042340157E-14,
2.4459601011273E-14,
5.95070867581704E-14,
3.78052623928316E-14,
6.86876770739087E-14,
3.99966518238593E-14,
7.39954972295287E-14,
4.4724640657634E-14,
7.91059925897564E-14,
5.24398233170409E-14,
8.56831966489224E-14,
5.2659265836752E-14,
8.33803512345632E-14,
4.71333042040278E-14,
7.98172292149069E-14,
4.22830173651967E-14,
7.06986552634348E-14,
4.45615766508922E-14,
7.03864050377589E-14,
4.24035806467771E-14,
6.58110718698701E-14,
4.188489832746E-14,
6.94184293381639E-14,
3.65697055970671E-14,
6.56202522875127E-14,
3.49867704252382E-14,
7.64969684818873E-14,
0.820727585117053,
8.25034485174569E-14,
0.469640816034261,
8.97433169444461E-14,
0.422817843515969,
8.84986528504328E-14,
0.46954020174157,
9.16315634480469E-14,
0.820639024894946,
8.46284847755285E-14,
  0,
8.37246938445446E-14,
  0,
8.2727227845858E-14,
  0,
8.56693188611146E-14,
  0,
8.62331039908071E-14,
  0,
8.53258436128712E-14,
  0,
  0,
2.80589353834904E-14,
2.14121255448507E-14,
5.18669308890995E-14,
3.69045072279306E-14,
6.6117684244249E-14,
4.33190809612238E-14,
7.45323941453435E-14,
4.65799274151912E-14,
8.32806046346946E-14,
5.54833956556422E-14,
8.74708291909165E-14,
5.23209947589365E-14,
8.49277245751345E-14,
4.84907253239797E-14,
8.2346456042881E-14,
4.08215128366862E-14,
7.57380269611474E-14,
4.58704255135167E-14,
7.3227014729671E-14,
4.39127900708769E-14,
7.1281522351363E-14,
4.38416664083618E-14,
7.10221811917044E-14,
3.89384705035134E-14,
6.99084887201273E-14,
3.96809321512315E-14,
8.13221018303167E-14,
3.62270977105617E-14,
8.50977274757803E-14,
0.820702335820809,
8.73216429719825E-14,
0.46958824667524,
8.85472251077601E-14,
0.422763813429639,
9.34061855639712E-14,
0.469496176051033,
8.23091594881475E-14,
0.82062132341737,
7.90496140767871E-14,
  0,
7.82672537891216E-14,
  0,
8.39293912147099E-14,
  0,
8.06438249512098E-14,
  0,
8.22154844204448E-14,
  0,
8.66754584771812E-14,
1.82250048386123E-14,
2.16938012692625E-14,
4.40077661811866E-14,
3.45040836180477E-14,
5.92152195333373E-14,
4.2705856212466E-14,
7.24372818672325E-14,
5.01053191992451E-14,
8.40499544962903E-14,
5.75355735277228E-14,
9.17599329852692E-14,
5.54755894000003E-14,
8.67830113326917E-14,
4.81463827139983E-14,
8.39597488755395E-14,
4.22387819165593E-14,
7.82898051943093E-14,
4.43967779206744E-14,
7.82637843421696E-14,
4.52207715717634E-14,
7.41585612362705E-14,
4.54462856236404E-14,
7.65490101861666E-14,
4.09299330539348E-14,
7.16059156413706E-14,
4.20609727602717E-14,
8.5641563285499E-14,
4.09325351391487E-14,
8.99341365268036E-14,
3.41497663480794E-14,
8.9528211233425E-14,
0.820679324854205,
8.67535210336001E-14,
0.46954020174157,
9.34061855639712E-14,
0.422714302223261,
8.4592055582533E-14,
0.469455733074755,
7.66366137217034E-14,
0.820605024644002,
7.30908389368068E-14,
  0,
7.95630922256763E-14,
  0,
7.88466514300978E-14,
  0,
7.65255914192409E-14,
  0,
8.3547752049995E-14,
  0,
1.72657027563972E-14,
3.83915989277117E-14,
3.59491082735364E-14,
5.24480632535518E-14,
4.08067676871404E-14,
6.60526321138999E-14,
4.97709512492506E-14,
8.22857407212219E-14,
6.12409428724092E-14,
9.28137774969251E-14,
5.76214423397836E-14,
9.12395159424761E-14,
5.13547537828174E-14,
8.59225884886072E-14,
4.19360726700013E-14,
7.99924362859805E-14,
4.58409352144251E-14,
8.08892883230605E-14,
4.37904920658205E-14,
7.92213517009088E-14,
4.67187052932694E-14,
7.94121712832663E-14,
4.25102661405496E-14,
7.70512126324618E-14,
4.40992728445444E-14,
8.73147040780786E-14,
4.33438007707565E-14,
9.4245791726344E-14,
3.89462767591553E-14,
9.45138065033824E-14,
2.89716167722887E-14,
8.83928347183982E-14,
0.820658294973941,
9.16610537471385E-14,
0.469496176051033,
8.4592055582533E-14,
0.422668819239553,
7.85985859730332E-14,
0.469418494028738,
7.14914238919562E-14,
0.820589984062469,
7.41177952345851E-14,
  0,
7.43866773733615E-14,
-1.06251812903579E-14,
7.48654610527311E-14,
  0,
7.79029618591665E-14,
-1.11039649697275E-14,
8.70085253845687E-14,
2.61271039525557E-14,
3.53751316434225E-14,
4.88337668913541E-14,
4.30892301006569E-14,
5.99810999479811E-14,
4.81979907374086E-14,
7.63169909212547E-14,
6.11620129542523E-14,
9.1328854201489E-14,
6.14621201155963E-14,
9.24781085043236E-14,
5.35986185989934E-14,
9.05543001694653E-14,
4.52060264222176E-14,
8.20368079024192E-14,
4.55876655869325E-14,
8.25979909468977E-14,
4.52624049351869E-14,
8.18425188731098E-14,
4.52892931490645E-14,
8.44532777044549E-14,
4.38572789196456E-14,
7.9959476539937E-14,
4.57229740180587E-14,
9.28293900082089E-14,
4.53075077455622E-14,
9.59258714128275E-14,
4.14095840950424E-14,
9.9025822264398E-14,
3.37273611816791E-14,
9.36108829341364E-14,
2.07004552388312E-14,
9.38468053268693E-14,
0.820639024894946,
8.24340595784179E-14,
0.469455733074755,
7.86280762721248E-14,
0.422626938705548,
7.34690086545697E-14,
0.469384128936864,
7.24715426558831E-14,
0.8205760753179,
6.92501611609941E-14,
-1.52620971416439E-14,
7.04401814655142E-14,
-1.15515236265296E-14,
7.61231355728142E-14,
-1.30763455619132E-14,
8.13637351937402E-14,
-2.07368844318268E-14,
2.35714225915729E-14,
4.22025695639983E-14,
4.42406528078365E-14,
5.75793752954912E-14,
5.10346973014997E-14,
7.08057744380763E-14,
5.98891596037543E-14,
8.57473814175336E-14,
6.15956938232465E-14,
9.12152298138125E-14,
5.75789416146222E-14,
9.19021803102993E-14,
4.74793815374852E-14,
8.6764796736194E-14,
4.89339471720918E-14,
8.47559869510128E-14,
4.50230130955021E-14,
8.36379576707458E-14,
4.67846247853565E-14,
8.71793956469524E-14,
4.2481643203196E-14,
8.51020642844702E-14,
4.70378944128491E-14,
9.57827567260594E-14,
4.69667707503341E-14,
1.01420608022984E-13,
4.33975771985118E-14,
1.00638247735318E-13,
3.61169427698371E-14,
9.79025888137031E-14,
2.54622711803876E-14,
9.87543380404077E-14,
1.65180369382512E-14,
8.4666648692E-14,
0.82062132341737,
7.66088581460878E-14,
0.469418494028738,
7.3521050358849E-14,
0.422588289694232,
7.46121914252384E-14,
0.469352349268151,
6.74200278938386E-14,
0.82056318754031,
6.537131946871E-14,
-1.60912949631609E-14,
7.17655102011605E-14,
-1.5407813913626E-14,
7.95735005665321E-14,
-2.28029400917151E-14,
7.73044822599545E-14,
2.2591303827646E-14,
3.75428854670901E-14,
5.31272074943967E-14,
5.32724905855098E-14,
6.92063593932257E-14,
6.3200313038525E-14,
8.06360186955679E-14,
6.05990951862978E-14,
8.58774856782318E-14,
5.78556300090405E-14,
9.08136413291238E-14,
5.15256240452011E-14,
8.82358422438223E-14,
5.12229147986432E-14,
8.95750487672764E-14,
4.83684273189233E-14,
8.58254439739525E-14,
4.66163566081867E-14,
8.89982532115141E-14,
4.39431477317065E-14,
8.77527217557628E-14,
4.56761364842073E-14,
1.00912334044523E-13,
4.83129161676921E-14,
1.0444509840335E-13,
4.50152068398602E-14,
1.06132116983737E-13,
3.81639164714898E-14,
9.96737414826754E-14,
2.78319034485719E-14,
1.03127575923345E-13,
2.11532180660612E-14,
8.96695911967171E-14,
  0,
7.90183890542195E-14,
0.820605024644003,
7.15105058501919E-14,
0.469384128936864,
7.46121914252384E-14,
0.422552547853742,
6.93715918043125E-14,
0.469322901838909,
6.36157793110215E-14,
0.820551223120274,
6.65387883680424E-14,
-2.02754479872169E-14,
7.51117917863198E-14,
-2.51500209547117E-14,
7.55090434623185E-14,
-2.79984369022657E-14,
1.97656561257142E-14,
3.87574087407083E-14,
4.85592469012808E-14,
6.60300807087122E-14,
6.61779658850392E-14,
7.9658935697724E-14,
6.42784436788446E-14,
8.11659767174788E-14,
5.70845454239688E-14,
8.57326362679878E-14,
5.1980121595907E-14,
8.73138367163406E-14,
5.535068930973E-14,
9.1177933259079E-14,
5.07484679279635E-14,
9.07442523900848E-14,
4.99730465342019E-14,
9.12707409650437E-14,
4.37982983214624E-14,
8.96661217497652E-14,
4.71679986735474E-14,
1.03646258242662E-13,
4.68921776408671E-14,
1.09598094488739E-13,
4.64064550675936E-14,
1.09154872640627E-13,
3.97971586241219E-14,
1.05217917711897E-13,
2.98927549380323E-14,
1.04785971566379E-13,
2.36165254019483E-14,
9.41191569125976E-14,
1.46341272433403E-14,
8.37229591210686E-14,
  0,
7.3146350088038E-14,
0.820589984062469,
7.23605203534206E-14,
0.469352349268151,
6.93629181869326E-14,
0.422519428556961,
6.51839693333045E-14,
0.469295563737255,
6.41917075050458E-14,
0.820540095848849,
7.01019103876988E-14,
-2.99638786005474E-14,
7.10768249811977E-14,
-3.04339886625371E-14,
7.11670306019485E-14,
2.21461304156234E-14,
3.54267396668329E-14,
5.38753069934117E-14,
6.26547425053303E-14,
7.74059635832991E-14,
6.78103406759334E-14,
8.06351513338299E-14,
6.10709399717635E-14,
8.13116934894609E-14,
5.13339371011057E-14,
8.24184470671341E-14,
5.59031987368286E-14,
9.04033792270553E-14,
5.4972519591967E-14,
9.24538223756599E-14,
5.2431149699661E-14,
9.61973556368179E-14,
4.72460612299663E-14,
9.19498852058886E-14,
4.70170777311374E-14,
1.05514555426289E-13,
4.84117954058227E-14,
1.12314671452118E-13,
4.50143394781222E-14,
1.14350369451177E-13,
4.11311609771481E-14,
1.08230265027931E-13,
3.15303338993544E-14,
1.10335351966029E-13,
2.56322740810333E-14,
9.5812247025151E-14,
1.69586567011493E-14,
8.81499734317615E-14,
  0,
7.82776621299774E-14,
  0,
7.41039174467772E-14,
0.8205760753179,
6.74234973407906E-14,
0.469322901838909,
6.51232540116453E-14,
0.422488681199215,
6.64676647055273E-14,
0.469270138078471,
6.7992486640911E-14,
0.820529729355197,
6.60166366017734E-14,
-3.51801920928096E-14,
6.6788588548583E-14,
-3.35165922793479E-14,
2.11373887143429E-14,
4.24740537879886E-14,
5.15741963025285E-14,
6.66372339253041E-14,
6.51288918629422E-14,
7.9060022417643E-14,
6.49679962605454E-14,
8.11390885036012E-14,
5.5499008166926E-14,
7.82282225109121E-14,
5.53689039062277E-14,
8.56615126054727E-14,
5.56022242137466E-14,
9.17850864756709E-14,
5.67471417078913E-14,
9.80049374987857E-14,
4.96772761815478E-14,
9.69970631592432E-14,
5.04474934048815E-14,
1.07919749525731E-13,
4.82825585068625E-14,
1.1427577634171E-13,
4.65035995822483E-14,
1.17101640884076E-13,
3.97399127494147E-14,
1.13484742436665E-13,
3.28816834871404E-14,
1.13421425029792E-13,
2.72924044475431E-14,
1.01432751087316E-13,
1.90646110009851E-14,
8.98725538434064E-14,
1.06026298851702E-14,
8.26769208650546E-14,
  0,
7.95752352900081E-14,
  0,
6.93854695921203E-14,
0.82056318754031,
6.35498598189344E-14,
0.469295563737255,
6.64676647055273E-14,
0.422460084429128,
6.98364976958743E-14,
0.469246450439353,
6.39349684306012E-14,
0.820520055788566,
6.15757445032727E-14,
-3.81968762175333E-14,
7.02042590727814E-14,
2.68864791541645E-14,
4.22509249808911E-14,
5.75624617416004E-14,
5.52917087115468E-14,
6.91998541801908E-14,
6.28060971286093E-14,
8.00236613085481E-14,
5.96597424240564E-14,
7.83349080046847E-14,
5.96623445092703E-14,
8.16378215029445E-14,
5.51789516856083E-14,
8.71854671791183E-14,
5.73881220322647E-14,
9.74324787517133E-14,
5.4000207083682E-14,
9.88462783846344E-14,
5.29229438051004E-14,
1.12950447606064E-13,
5.17459339266502E-14,
1.1665581695075E-13,
4.64064550675936E-14,
1.19076623561476E-13,
4.12508568969905E-14,
1.16238615954778E-13,
3.14557407898874E-14,
1.18623860734246E-13,
2.86680401639927E-14,
1.04491068575463E-13,
2.06917816214514E-14,
9.55052009699031E-14,
1.25698063069279E-14,
8.44099096175555E-14,
  0,
8.39120439799501E-14,
  0,
7.43606565212218E-14,
-1.53176082928752E-14,
6.53123388705268E-14,
0.820551223120274,
6.41882380580938E-14,
0.469270138078471,
6.98347629723983E-14,
0.422433442142116,
6.56991822056696E-14,
0.469224345850041,
5.92789706210795E-14,
0.820511014701868,
6.48769232780566E-14,
-3.93730187342456E-14,
2.76447701536009E-14,
4.80052195911407E-14,
4.81390101392254E-14,
6.15106923729236E-14,
5.36745127510674E-14,
7.07732483729018E-14,
5.78643036264204E-14,
7.75750991222068E-14,
6.40182351574481E-14,
8.19344592173366E-14,
5.95539242920218E-14,
8.33005539546683E-14,
5.70333710814275E-14,
9.29291366080776E-14,
5.47574138809459E-14,
9.83787704078587E-14,
5.73360803279854E-14,
1.14902011516538E-13,
5.42690892224584E-14,
1.2177845537531E-13,
4.99149332977566E-14,
1.21536461450411E-13,
4.11658554466676E-14,
1.18216200717391E-13,
3.29953078748169E-14,
1.21444521106184E-13,
2.72126071676482E-14,
1.09747280707673E-13,
2.20257839744775E-14,
9.85444364998145E-14,
1.42177936091059E-14,
9.00373525736242E-14,
  0,
8.56537063498308E-14,
  0,
7.88744070057135E-14,
-1.061997711993E-14,
7.04106911664226E-14,
-1.6153745008296E-14,
6.657001339061E-14,
0.820540095848849,
6.79959560878629E-14,
0.469246450439353,
6.57408155690931E-14,
0.422408580100093,
6.1707583487447E-14,
0.469203686245829,
6.27241314443694E-14,
0.820502552102414,
6.79786088531031E-14,
2.85596199467442E-14,
3.94081468846341E-14,
5.43801115249209E-14,
4.76268330329432E-14,
6.39002739610817E-14,
4.91911199274053E-14,
6.87748469285765E-14,
6.24890764133745E-14,
8.14851658370586E-14,
6.40893588199631E-14,
8.38140321035574E-14,
6.15193659903035E-14,
8.92506554772687E-14,
5.44772560395756E-14,
9.39847158432094E-14,
5.81505329999565E-14,
1.14496953584897E-13,
5.86735521279635E-14,
1.23820224906535E-13,
5.24554358283247E-14,
1.26682518641896E-13,
4.46934156350665E-14,
1.20693385841086E-13,
3.2908571701018E-14,
1.23455932976579E-13,
2.87443679969357E-14,
1.12588757761323E-13,
2.06761691101676E-14,
1.03814526419832E-13,
1.56159807307432E-14,
9.31459770425747E-14,
1.03615033220095E-14,
9.12742104119957E-14,
  0,
8.06559680155416E-14,
  0,
7.48654610527311E-14,
-1.15792792021452E-14,
7.18140824584879E-14,
-2.02979993924046E-14,
7.01071145581267E-14,
0.820529729355197,
6.39922143053084E-14,
0.469224345850041,
6.16676848474995E-14,
0.422385343067916,
6.47103898243628E-14,
0.469184348300314,
6.62091909076068E-14,
0.820494619641731,
1.78147427365438E-14,
4.11519776588598E-14,
4.08536052209918E-14,
5.80507864000879E-14,
4.3752328149349E-14,
6.24270600491084E-14,
5.41736794312797E-14,
7.29945617838901E-14,
6.27770405103867E-14,
8.35737729021346E-14,
6.61814353319912E-14,
8.9906380951188E-14,
5.90421808666086E-14,
9.03929708861995E-14,
5.79423661828393E-14,
1.102616262183E-13,
5.95469853981179E-14,
1.23523587192143E-13,
5.68997973737773E-14,
1.2878066668609E-13,
4.72278466334686E-14,
1.25903627801183E-13,
3.64690916354604E-14,
1.25967812569794E-13,
2.86715096109447E-14,
1.14663487038591E-13,
2.22200730037869E-14,
1.0668722849605E-13,
1.41865685865383E-14,
9.84108627921643E-14,
1.16885667811317E-14,
9.43307931766668E-14,
  0,
8.62747373542305E-14,
  0,
7.65013052905772E-14,
  0,
7.61231355728142E-14,
-1.54216917014338E-14,
7.50823014872282E-14,
-2.99222452371239E-14,
6.60305143895812E-14,
0.820520055788566,
5.92477455985119E-14,
0.469203686245829,
6.4699981483507E-14,
0.42236359237824,
6.76854405856631E-14,
0.469166221575945,
7.21644966006352E-14,
1.89613949541645E-14,
2.34009860100581E-14,
4.6968071792941E-14,
3.79310298448399E-14,
5.73274067106055E-14,
4.91278025205322E-14,
6.70357866439097E-14,
5.47227194114264E-14,
7.53555204346945E-14,
6.50139664326588E-14,
8.98118385217472E-14,
6.38178745959728E-14,
9.12030867494806E-14,
6.25896903749812E-14,
1.06780903563752E-13,
5.93657067948783E-14,
1.19358516126322E-13,
5.77810368995735E-14,
1.28581173486353E-13,
5.17164436275586E-14,
1.28059021720084E-13,
3.90295434860022E-14,
1.31239637213287E-13,
3.21504975420162E-14,
1.17154549950094E-13,
2.21211937656562E-14,
1.08716854962942E-13,
1.58085350365766E-14,
1.01300912103142E-13,
1.03094616177302E-14,
9.96425164601078E-14,
  0,
8.93434631832335E-14,
  0,
8.22172191439208E-14,
  0,
7.79445952225899E-14,
-1.3088488626245E-14,
7.95526838848204E-14,
-2.51083875912883E-14,
7.10802944281497E-14,
-3.52079476684253E-14,
6.15826833971767E-14,
0.820511014701868,
6.25437202028678E-14,
0.469184348300314,
6.77131961612787E-14,
0.422343203852974,
7.41594285980085E-14,
0.469149206939908,
  0,
2.92526419753969E-14,
2.17764174748059E-14,
4.73635887454638E-14,
4.38087066623183E-14,
6.24821375194706E-14,
5.00129451741493E-14,
6.96881788386783E-14,
5.71678121508157E-14,
8.18164980209701E-14,
6.28013266390504E-14,
9.13297215632269E-14,
6.74460487459783E-14,
1.0768295977126E-13,
6.41283900981726E-14,
1.15993152582927E-13,
5.7668279873635E-14,
1.24509777488235E-13,
5.26367144315643E-14,
1.2789682507508E-13,
4.3533752991376E-14,
1.33414980452162E-13,
3.48193696098065E-14,
1.22445456551823E-13,
2.56305393575573E-14,
1.11336287411667E-13,
1.56923085636862E-14,
1.03379110827362E-13,
1.18759169165372E-14,
1.02562056070177E-13,
  0,
9.46482475727706E-14,
  0,
8.52911491433517E-14,
  0,
8.35685687317067E-14,
-1.10605968828281E-14,
8.13620004702642E-14,
-2.27960011978112E-14,
7.55125129092704E-14,
-3.04305192155852E-14,
6.67833843781551E-14,
-3.81951414940573E-14,
6.49428427701437E-14,
0.820502552102414,
6.62421506536504E-14,
0.469166221575945,
7.41733063858163E-14,
0.422324066022869,
7.16007114709427E-14,
1.48219110596148E-14,
  0,
3.12892073361937E-14,
2.83254322774873E-14,
5.32018006038637E-14,
4.50512023519867E-14,
6.5521373049382E-14,
5.27069707323413E-14,
7.64761518001755E-14,
5.50740009153117E-14,
8.35113228569995E-14,
6.65439925384703E-14,
1.07957046080465E-13,
6.9111383282916E-14,
1.17017506795491E-13,
6.24439736029991E-14,
1.21232884842115E-13,
5.25447740873375E-14,
1.23923440953355E-13,
4.44774425623073E-14,
1.33327376916625E-13,
3.93530694142719E-14,
1.24670239409763E-13,
2.8269053764518E-14,
1.16649745418584E-13,
1.92467569659627E-14,
1.05958644636139E-13,
1.18551002348255E-14,
1.04635050623969E-13,
  0,
9.75851344175993E-14,
  0,
9.06462405136921E-14,
  0,
8.66737237537052E-14,
  0,
8.69946475967609E-14,
-2.07368844318268E-14,
7.73287683886181E-14,
-2.80261924778813E-14,
7.11392750263329E-14,
-3.3509653385444E-14,
7.01973201788775E-14,
-3.93175075830143E-14,
6.79786088531031E-14,
0.820494619641731,
7.22772536265737E-14,
0.469149206939908,
7.16249975996064E-14,
0.42230607859734,
  0,
  0,
  0,
-1.00659498097899E-14,
-1.09147716906288E-14,
0.999999999999991,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.32997996296624E-14,
  0,
2.08940937468372E-14,
  0,
1.77440527548978E-14,
  0,
1.61836689882566E-14,
  0,
1.79173082620609E-14,
1.55502780790906E-14,
2.66407989418793E-14,
2.24076399796269E-14,
2.91368491833754E-14,
2.25015318877642E-14,
2.37000089692296E-14,
1.77026362319088E-14,
2.4610955634552E-14,
2.69870931157712E-14,
2.75066427968262E-14,
2.28560659981669E-14,
2.53241438236129E-14,
1.69885806811099E-14,
1.98786299920872E-14,
  0,
  0,
  0,
-1.38943761010535E-14,
-1.68450323134728E-14,
0.870388279778472,
-1.73458252969438E-14,
0.869048189253471,
-1.23106819877039E-14,
  0,
  0,
  0,
-1.20938415532068E-14,
  0,
-1.488436110475E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.53317029211175E-14,
  0,
2.96069592453652E-14,
  0,
3.34814641289594E-14,
1.09864374542301E-14,
2.93981419069445E-14,
1.04235196862756E-14,
2.95119831350554E-14,
2.01687624934443E-14,
3.85787322226827E-14,
3.28886223810443E-14,
4.83020741459672E-14,
3.88977045018279E-14,
4.57463927849844E-14,
3.48128643967716E-14,
4.18502038579405E-14,
3.86882366421037E-14,
4.51448774196894E-14,
4.31685936996828E-14,
4.57303465928316E-14,
3.45019152137027E-14,
3.91353616180368E-14,
1.93842338014338E-14,
2.70439053096094E-14,
  0,
-1.39219148362346E-14,
-1.57036926864973E-14,
0.849411985729357,
-2.07909861202338E-14,
0.573350763461467,
-1.87634196374686E-14,
0.843607101939139,
-1.54971521726388E-14,
  0,
-1.48381740922021E-14,
  0,
-1.70382371406097E-14,
  0,
-1.28688292660994E-14,
  0,
  0,
  0,
  0,
  0,
1.10577779571797E-14,
  0,
1.02955838299224E-14,
  0,
1.84895501686988E-14,
  0,
2.86203352684034E-14,
  0,
3.77306692833645E-14,
  0,
4.10301133346724E-14,
1.59147868494802E-14,
3.8971863930426E-14,
2.09706384202146E-14,
4.59593300916605E-14,
3.39953759587175E-14,
5.43345750336766E-14,
4.44470849014778E-14,
5.85313048029334E-14,
4.62086965913322E-14,
5.83040560275805E-14,
5.1385545124516E-14,
5.67107125148958E-14,
4.91061184770825E-14,
5.72675587506843E-14,
4.96581942233121E-14,
5.38722712273287E-14,
3.32017399684581E-14,
4.18510712196785E-14,
2.39964298431872E-14,
-1.00659498097899E-14,
-1.68163009559019E-14,
0.849411985729357,
-1.94969908273723E-14,
0.525971891352156,
-2.169271706709E-14,
0.516247292013478,
-2.120330820643E-14,
0.833437219948181,
-1.96589706319417E-14,
-1.16451986942323E-14,
-1.90628762775091E-14,
  0,
-1.43524515189286E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.23577363619898E-14,
  0,
1.93933410996827E-14,
  0,
3.08733073828282E-14,
  0,
3.5304658502211E-14,
  0,
4.360531033476E-14,
1.34831382170297E-14,
4.89361155764367E-14,
2.57563068095656E-14,
5.3627675217216E-14,
3.36488649443911E-14,
5.95825472293754E-14,
4.38898049848202E-14,
6.21234834408124E-14,
4.98268960813508E-14,
6.86143850070486E-14,
6.07899147686553E-14,
7.08014376293864E-14,
5.9687064318803E-14,
6.63974084047503E-14,
5.3406497974029E-14,
6.30055903283466E-14,
4.65491360734926E-14,
5.45566196386016E-14,
3.6652972323914E-14,
5.0863827039116E-14,
-1.09147716906288E-14,
0.870388279778472,
-2.07909861202338E-14,
0.525971891352156,
-1.99458505267813E-14,
0.461538461538443,
-2.38064776225677E-14,
0.493166751957507,
-2.51337579221245E-14,
0.828179398818821,
-2.35488711863852E-14,
  0,
-1.60019567041481E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
2.11154878304587E-14,
  0,
3.12722937823029E-14,
  0,
3.68277457141186E-14,
  0,
4.03310197738538E-14,
1.09135790682391E-14,
5.05684903673309E-14,
2.2890543627252E-14,
6.25706084167454E-14,
3.78256453936743E-14,
6.6115515839904E-14,
4.27002183611691E-14,
6.60396216878301E-14,
4.82378893773561E-14,
7.08070754806833E-14,
6.3200313038525E-14,
7.96498283994751E-14,
6.78211826976582E-14,
7.90660939498089E-14,
6.28117349799062E-14,
7.07511306485831E-14,
4.91980588213092E-14,
6.24331315812743E-14,
4.91460171170299E-14,
6.24682597316628E-14,
4.50394929685238E-14,
0.999999999999991,
-1.73324896102223E-14,
0.573350763461467,
-2.17070285357668E-14,
0.461538461538443,
-2.22547674733065E-14,
0.435058977431533,
-2.75536971711121E-14,
0.481143547642906,
-2.85771840219384E-14,
0.825060067965361,
-2.01249607256759E-14,
  0,
-1.06472990146766E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.79166577407575E-14,
  0,
3.26982364795558E-14,
  0,
3.68689453966731E-14,
  0,
4.14130535419943E-14,
  0,
4.67295473149942E-14,
2.00963377883223E-14,
6.35307778606986E-14,
3.45652326205759E-14,
7.4273486666554E-14,
4.64077561102005E-14,
7.17551018603046E-14,
4.64784460918466E-14,
7.39347819078695E-14,
6.09399683493272E-14,
8.09352584951739E-14,
6.940715363557E-14,
8.69209218490319E-14,
7.01435437511222E-14,
8.25329388165486E-14,
5.79024675428919E-14,
6.94036841886181E-14,
5.11240355605125E-14,
6.95823607066437E-14,
5.69648495041264E-14,
6.7616051646624E-14,
  0,
0.869048189253471,
-1.87629859565996E-14,
0.516247292013478,
-2.38583024864125E-14,
0.435058977431533,
-2.60143469266172E-14,
0.421137950100819,
-3.11660419693993E-14,
0.473975125035577,
-2.53612235379119E-14,
0.823040973693117,
-1.49914802793916E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02526494238919E-14,
  0,
2.92543766988729E-14,
  0,
3.7998684060403E-14,
  0,
4.10691446128819E-14,
  0,
4.74347124079788E-14,
1.69972542984898E-14,
5.92590213011057E-14,
3.156242628366E-14,
7.46668352147317E-14,
4.28116743445006E-14,
7.93184962155635E-14,
4.97917679309623E-14,
7.9055685608953E-14,
5.87732987278322E-14,
8.34055047249649E-14,
6.65622071349681E-14,
8.74638902970126E-14,
7.11436118350228E-14,
8.9679132175835E-14,
6.47060530156729E-14,
8.04955060940138E-14,
5.94073401583017E-14,
7.59592042043344E-14,
5.8567733995929E-14,
7.41308056606549E-14,
5.6318665009325E-14,
  0,
-1.23658678782834E-14,
0.843607101939139,
-2.12601204002683E-14,
0.493166751957507,
-2.75528298093741E-14,
0.421137950100819,
-2.91784825467989E-14,
0.412791146261775,
-2.72481689989057E-14,
0.469319537472725,
-1.97194691131664E-14,
0.821652244094977,
-1.26136080746964E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
2.14828155264968E-14,
  0,
3.43791835277774E-14,
  0,
4.2037987674215E-14,
1.19526784303492E-14,
4.68765651295833E-14,
1.83008989906863E-14,
5.96614771475323E-14,
2.83228301922733E-14,
6.99934901704502E-14,
3.9564705678341E-14,
7.92725260434501E-14,
4.59406818142938E-14,
8.616718449872E-14,
6.17943196612458E-14,
8.80406858527749E-14,
6.40425212861118E-14,
8.94822410613116E-14,
6.78823317001864E-14,
8.97355106888043E-14,
6.53392270844044E-14,
8.71551095182888E-14,
6.58466337011276E-14,
8.66459681780896E-14,
6.64529195559815E-14,
8.00809071832553E-14,
5.75494513155306E-14,
7.79610750956117E-14,
  0,
  0,
-1.5483274384831E-14,
0.833437219948181,
-2.51619471786091E-14,
0.481143547642906,
-3.11786187146001E-14,
0.412791146261775,
-2.56249015062604E-14,
0.407350101284771,
-2.20505037840102E-14,
0.466109855115491,
-1.73827965910256E-14,
0.820653100894044,
  0,
  0,
  0,
  0,
  0,
  0,
1.78845653564519E-14,
  0,
2.64532319660393E-14,
  0,
3.82038151114372E-14,
1.11672823766007E-14,
4.75930059251617E-14,
2.09554595897998E-14,
5.88782494981288E-14,
2.95301977315532E-14,
7.01461458363362E-14,
3.61672497506405E-14,
7.42869307734928E-14,
4.25258786518334E-14,
8.57274320975598E-14,
5.76804229379668E-14,
9.47870254508487E-14,
6.6788588548583E-14,
9.37748143026162E-14,
6.50512629873923E-14,
9.13401299040828E-14,
6.18029932786257E-14,
8.67830113326917E-14,
6.62057214606548E-14,
9.29109220115798E-14,
7.26163920661271E-14,
9.03912361627235E-14,
6.51700915454967E-14,
8.35659666464927E-14,
5.54712525913104E-14,
  0,
  0,
  0,
-1.97146986236074E-14,
0.828179398818821,
-2.85633062341306E-14,
0.473975125035577,
-2.73041138310059E-14,
0.407350101284771,
-2.01561857482435E-14,
0.403589226881235,
-1.9523011679512E-14,
0.463796611961337,
-1.46111421572837E-14,
0.819908750057632,
  0,
-1.01442292066434E-14,
  0,
  0,
1.67812812257306E-14,
  0,
2.28172515603919E-14,
  0,
3.01772495880925E-14,
  0,
4.36742655929301E-14,
2.0118455512641E-14,
5.94689228416989E-14,
3.20949863907849E-14,
6.91547513698154E-14,
3.73000241804533E-14,
7.42062661318599E-14,
3.90121962512424E-14,
8.04738220505641E-14,
5.41077599391926E-14,
9.40645131231044E-14,
6.25038215629203E-14,
1.00178546014185E-13,
6.75666120275586E-14,
9.53065751319038E-14,
5.8716052853125E-14,
8.80944622805302E-14,
6.24708618168768E-14,
9.22595333463505E-14,
7.27126692190438E-14,
9.63448071322759E-14,
7.10863659603156E-14,
9.35909336141627E-14,
6.28915322598012E-14,
8.64534138722561E-14,
  0,
  0,
-1.48657128273832E-14,
-1.17163223567474E-14,
-2.35497385481231E-14,
0.825060067965361,
-2.53616572187809E-14,
0.469319537472725,
-2.19386141198097E-14,
0.403589226881235,
-1.77891555652732E-14,
0.400873679843421,
-1.65882932390282E-14,
0.462071035628456,
-1.31136421166467E-14,
0.819338537352137,
  0,
  0,
1.54390389361936E-14,
  0,
2.16328691071688E-14,
  0,
2.64319816034586E-14,
  0,
3.54915749567475E-14,
1.87133294970998E-14,
5.53801796088216E-14,
3.12206857588926E-14,
6.95389926197443E-14,
3.97737398571962E-14,
7.29694082934884E-14,
3.99871108447414E-14,
8.01633065483642E-14,
5.04509628518335E-14,
8.85767154068517E-14,
5.87646251104523E-14,
9.91914883563538E-14,
6.30962296299664E-14,
1.01510813643735E-13,
6.10640010778596E-14,
9.18154441365004E-14,
5.92243268315862E-14,
9.32968979849846E-14,
6.88156129302619E-14,
9.54019849230825E-14,
7.10022318717307E-14,
9.92825613388426E-14,
6.86742329669698E-14,
9.62181723185296E-14,
6.09122127737116E-14,
  0,
-1.20973110001588E-14,
  0,
-1.90138703393128E-14,
  0,
-2.02225389211996E-14,
0.823040973693117,
-1.97212038366423E-14,
0.466109855115491,
-1.9523011679512E-14,
0.400873679843421,
-1.41748592030755E-14,
0.398845181276695,
-1.51437022644085E-14,
0.460747831424128,
  0,
0.81889162268085,
1.11594761209588E-14,
  0,
2.02095284951298E-14,
  0,
2.51916543181352E-14,
  0,
3.17393680782097E-14,
1.35230368569772E-14,
4.70795277762726E-14,
2.97123436965308E-14,
6.53452986165703E-14,
3.88005599871732E-14,
7.32547703052866E-14,
4.23688861772575E-14,
7.88492535153118E-14,
5.13365391863196E-14,
8.8108340068338E-14,
5.49699175067531E-14,
9.35449634420493E-14,
5.92260615550622E-14,
1.00306048189669E-13,
5.64583102491412E-14,
9.77880970642886E-14,
6.14291603695527E-14,
9.68348665142393E-14,
6.54832091329105E-14,
9.6265009852381E-14,
6.69689997900846E-14,
9.81688688672655E-14,
6.84287695951191E-14,
1.01691224885236E-13,
6.65552682410642E-14,
1.06264823329649E-13,
  0,
  0,
-1.70486454814656E-14,
  0,
-1.60605036214623E-14,
  0,
-1.50474251114918E-14,
0.821652244094977,
-1.73819292292876E-14,
0.463796611961337,
-1.65050265121813E-14,
0.398845181276695,
-1.32632620164497E-14,
0.397288029431201,
  0,
0.459709931706213,
  0,
0.818534584512866,
1.58839955077816E-14,
  0,
2.37960692817119E-14,
  0,
3.04704178555326E-14,
1.31067032227428E-14,
4.3229309021342E-14,
2.4456131564321E-14,
5.70385752518554E-14,
3.72549213700779E-14,
6.8957860255292E-14,
4.13167763890776E-14,
7.89680820734162E-14,
5.36081595781113E-14,
8.66320903902817E-14,
5.57045728988292E-14,
9.2897044223772E-14,
5.53428830540881E-14,
9.44773773103869E-14,
5.24814566804643E-14,
9.64488905408345E-14,
5.67584174104852E-14,
1.0264272071181E-13,
6.75839592623184E-14,
9.96355775662039E-14,
6.35316452224366E-14,
9.88271964263987E-14,
6.42871172962245E-14,
1.0039191700173E-13,
6.62265381423666E-14,
1.11543586867047E-13,
7.12650424783412E-14,
  0,
-1.48902157964814E-14,
  0,
-1.43524515189286E-14,
  0,
-1.06451306103317E-14,
  0,
-1.26699865876656E-14,
0.820653100894044,
-1.46024685399038E-14,
0.462071035628456,
-1.5110742518365E-14,
0.397288029431201,
  0,
0.396065602663699,
  0,
0.458880237300692,
1.12531511886615E-14,
0.81824467719433,
1.9593701661158E-14,
  0,
2.89776883044546E-14,
1.33512992328555E-14,
4.19100518178617E-14,
2.40666861439642E-14,
5.31371821543836E-14,
3.1937993916209E-14,
6.06025646332498E-14,
3.97641988780784E-14,
7.4568823338339E-14,
5.25144164265079E-14,
8.66520397102555E-14,
5.79527745236952E-14,
9.13201805841091E-14,
5.60549870409766E-14,
9.37045580018392E-14,
4.85618489864947E-14,
9.050052374171E-14,
5.27104401792933E-14,
1.0115519533116E-13,
6.27666321695308E-14,
1.05283837203984E-13,
6.55170362406921E-14,
1.0203036332479E-13,
6.07534855756597E-14,
1.00872435404575E-13,
6.19703940940575E-14,
1.10091623317654E-13,
7.08443720354168E-14,
1.26470015016089E-13,
  0,
  0,
-1.28775028834793E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.819908750057632,
-1.31136421166467E-14,
0.460747831424128,
  0,
0.396065602663699,
  0,
0.395087744724236,
  0,
0.458206199370175,
1.43869291480136E-14,
0.818005963084478,
2.49895590331839E-14,
1.16252493742586E-14,
4.04424757571853E-14,
2.41629632968809E-14,
5.17320561388424E-14,
3.15485484958522E-14,
5.65684651898657E-14,
3.44368630833536E-14,
6.61285262659739E-14,
5.0863827039116E-14,
8.21330850553359E-14,
5.67792340921969E-14,
9.12655367946158E-14,
5.81999726190219E-14,
9.20166720597138E-14,
4.92479321212436E-14,
8.96296925567697E-14,
4.87544032923282E-14,
9.50732548243849E-14,
5.86440618288719E-14,
1.0368615688261E-13,
6.0656341061005E-14,
1.0754071244623E-13,
6.26642834844482E-14,
1.03959375830076E-13,
5.83630366257637E-14,
1.10469793035417E-13,
6.65145022393787E-14,
1.24839374948671E-13,
7.34360489085262E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.819338537352137,
  0,
0.459709931706213,
  0,
0.395087744724236,
1.12314671452118E-14,
0.394292909086673,
1.24223548114699E-14,
0.457650952912595,
1.99068192485718E-14,
0.817806993651533,
3.59842364239249E-14,
2.25323232294627E-14,
5.00736604958085E-14,
3.17324291843057E-14,
5.5201503090796E-14,
3.4032672513451E-14,
6.20857532052099E-14,
4.55347565209152E-14,
7.36450830873814E-14,
5.51008891291893E-14,
8.67144897553906E-14,
5.6994339803218E-14,
9.19290685241769E-14,
5.13243961219878E-14,
8.78498662704175E-14,
4.92782897820732E-14,
9.40627783996284E-14,
5.46195033646057E-14,
9.7457632242115E-14,
5.64409630143814E-14,
1.05836346631083E-13,
5.77012396196785E-14,
1.0935176375515E-13,
6.01740879346835E-14,
1.13402343071556E-13,
6.27943877451465E-14,
1.25056215383168E-13,
6.89830137456937E-14,
1.31238769851549E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.01997403578746E-14,
  0,
0.81889162268085,
  0,
0.458880237300692,
  0,
0.394292909086673,
1.44502465548868E-14,
0.393637862174603,
1.78216816304477E-14,
0.457187989999148,
3.12458392492942E-14,
0.817639366337327,
4.5777617807552E-14,
2.98329069781111E-14,
5.36471908563207E-14,
3.40968572820621E-14,
6.0583482675014E-14,
4.50750547997814E-14,
6.95433294284342E-14,
4.97006949484735E-14,
7.81388842518993E-14,
5.5202370452534E-14,
8.72678665442272E-14,
5.0037231302813E-14,
8.75896577490209E-14,
5.1383376720171E-14,
9.21884096838355E-14,
5.51364509604468E-14,
9.63985835600312E-14,
5.23652302075739E-14,
9.95427698602391E-14,
5.35023414460767E-14,
1.07525967296684E-13,
5.51555329186826E-14,
1.18706260099355E-13,
6.45698772228087E-14,
1.27910702862888E-13,
6.52464193784397E-14,
1.31355863686178E-13,
6.61424040537817E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.11568740357448E-14,
0.818534584512866,
1.11377920775091E-14,
0.458206199370175,
1.24284263436358E-14,
0.393637862174603,
1.96422739184854E-14,
0.393091483186099,
2.91407523111964E-14,
0.456797838982335,
4.10374859094453E-14,
0.81749679721979,
4.936155650892E-14,
3.2389889381701E-14,
5.90230989083729E-14,
4.51583215266282E-14,
6.81173867311813E-14,
4.92106355665101E-14,
7.39425881635114E-14,
4.98507485291455E-14,
7.85838408234873E-14,
4.83059772737882E-14,
8.2951007174259E-14,
5.00866709218784E-14,
9.19403442267708E-14,
5.71565364482218E-14,
9.44279376913215E-14,
5.28379423547776E-14,
9.83805051313347E-14,
4.93485460828502E-14,
1.01156062692898E-13,
5.09167361051333E-14,
1.16777247594069E-13,
5.95010152260045E-14,
1.33130485802102E-13,
6.69481831083729E-14,
1.34081981628675E-13,
6.22904505753752E-14,
1.33545084712861E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.54763354909271E-14,
  0,
1.59369045737989E-14,
0.81824467719433,
1.43938680419176E-14,
0.457650952912595,
1.7873723334727E-14,
0.393091483186099,
3.11278780529278E-14,
0.392630891445301,
3.91544435762725E-14,
0.456465927468725,
4.42475917017404E-14,
0.817374508322892,
5.47357298374962E-14,
4.34817112870967E-14,
6.65014918133089E-14,
4.93936488932256E-14,
7.24273072072457E-14,
4.93511481680642E-14,
7.44387190776408E-14,
4.28511393035791E-14,
7.42088682170738E-14,
4.82365883347491E-14,
8.71854671791183E-14,
5.58433507769074E-14,
9.4094870783934E-14,
5.48120576704392E-14,
9.63612870052977E-14,
4.97943700161763E-14,
9.99669097501155E-14,
4.67325830810772E-14,
1.10339688774719E-13,
5.52153808786038E-14,
1.31119941293445E-13,
6.18238099603374E-14,
1.39182068648047E-13,
6.39844080496665E-14,
1.36137628947708E-13,
5.07614783540333E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.67674034379228E-14,
  0,
2.02060590481778E-14,
  0,
1.95832933203022E-14,
0.818005963084478,
1.98998803546679E-14,
0.457187989999148,
2.91398849494584E-14,
0.392630891445301,
4.04684966093249E-14,
0.392238950251277,
4.23836313268033E-14,
0.456181168621402,
4.99817201515818E-14,
0.817268812823782,
6.21109066956116E-14,
4.77855602309951E-14,
7.08374331415129E-14,
4.93979857019156E-14,
7.28687943318818E-14,
4.23749577094235E-14,
7.00672159181792E-14,
4.28355267922953E-14,
7.85274623105181E-14,
5.40288300210356E-14,
8.93521368006134E-14,
5.35092803399806E-14,
9.60446999709319E-14,
5.17528728205541E-14,
9.78999867284891E-14,
4.71775396526652E-14,
1.0906726910509E-13,
5.10294931310717E-14,
1.24590442129868E-13,
5.74904707173474E-14,
1.37074379624735E-13,
5.88348814112294E-14,
1.41142306175901E-13,
5.24181392735912E-14,
1.35762928676897E-13,
  0,
  0,
1.1032190785909E-14,
  0,
  0,
  0,
1.02105823795995E-14,
  0,
1.79136219746745E-14,
  0,
2.16346038306447E-14,
  0,
2.37978040051878E-14,
  0,
2.49618034575683E-14,
0.817806993651533,
3.11495620963775E-14,
0.456797838982335,
3.90980650633033E-14,
0.392238950251277,
4.41209568879941E-14,
0.391902613368878,
4.75791281373539E-14,
0.455935003053882,
5.70203606553576E-14,
0.817176828114029,
6.68467017850283E-14,
4.7644180267703E-14,
7.1206929241896E-14,
4.24885820970999E-14,
6.84617293411627E-14,
4.2333324346E-14,
7.43051453699906E-14,
4.85844003916824E-14,
8.06403555042579E-14,
5.16513914972094E-14,
9.12048214729566E-14,
5.04032579562441E-14,
9.74758468386128E-14,
4.91134910518554E-14,
1.06959580081778E-13,
5.14354184244503E-14,
1.23272919649864E-13,
5.32933072672215E-14,
1.30477226245596E-13,
5.45015421682393E-14,
1.38970432383978E-13,
4.72226424630406E-14,
1.40706890583431E-13,
4.69034533434609E-14,
  0,
  0,
  0,
1.23802877671775E-14,
  0,
1.79175251024954E-14,
  0,
2.14767439943309E-14,
  0,
2.27886286230383E-14,
  0,
2.51985932120391E-14,
  0,
2.90331994556858E-14,
1.16269840977345E-14,
3.60657684272958E-14,
0.817639366337327,
4.11242220832442E-14,
0.456465927468725,
4.23281201755721E-14,
0.391902613368878,
4.96599289467881E-14,
0.391611803093356,
5.49621112511112E-14,
0.455720735431046,
6.14629874773343E-14,
0.81709627345181,
6.69629282579187E-14,
4.0838860071446E-14,
6.67460878234216E-14,
4.23879681354933E-14,
7.27464963268254E-14,
4.81090861592648E-14,
7.64206406489443E-14,
4.62451257843277E-14,
8.2423651237562E-14,
4.85488385604249E-14,
9.26585197458252E-14,
4.77118344832661E-14,
1.06541511724068E-13,
5.33635635679985E-14,
1.21117525730963E-13,
5.37087735397179E-14,
1.29132815551714E-13,
5.02844293981397E-14,
1.32348992876175E-13,
4.28511393035791E-14,
1.38446545894233E-13,
4.16975481920545E-14,
1.39362479889549E-13,
  0,
  0,
1.03129310646821E-14,
  0,
2.11428097252053E-14,
  0,
2.9241366272803E-14,
  0,
2.6399455538284E-14,
  0,
2.6404226027843E-14,
  0,
3.0442662279917E-14,
1.33400235302616E-14,
4.04390063102333E-14,
2.25600788050784E-14,
4.58331289587832E-14,
0.81749679721979,
4.42475917017404E-14,
0.456181168621402,
4.76207615007773E-14,
0.391611803093356,
5.69093383528951E-14,
0.391358632637101,
5.91566726160231E-14,
0.455533066265067,
6.17544210212984E-14,
0.817025324782698,
6.25055562863963E-14,
4.068620440556E-14,
7.08894748457922E-14,
4.80535750080335E-14,
7.48585221588272E-14,
4.57186372093688E-14,
7.82108752761523E-14,
4.30757859937181E-14,
8.38972988304043E-14,
4.57975671275257E-14,
1.01663469309621E-13,
5.19757847872171E-14,
1.20618792731619E-13,
5.56100304693885E-14,
1.26945329248507E-13,
5.05793323890558E-14,
1.30956009924965E-13,
3.8594127893532E-14,
1.31748778553487E-13,
3.72896158395974E-14,
1.37093461582971E-13,
3.54178492090185E-14,
  0,
  0,
  0,
1.94163261857394E-14,
  0,
3.27142826717086E-14,
  0,
3.43661731017075E-14,
  0,
3.01772495880925E-14,
  0,
3.1709877779118E-14,
1.31353261600964E-14,
4.1883163603984E-14,
2.41707695525228E-14,
5.011182441228E-14,
2.98892854910804E-14,
4.936589331761E-14,
0.817374508322892,
4.99357499794684E-14,
0.455935003053882,
5.49135389937838E-14,
0.391358632637101,
6.14751305416661E-14,
0.391136856840398,
5.97291313630954E-14,
0.455367755753812,
5.76023603815479E-14,
0.816962508941322,
6.65335841976145E-14,
4.65495697543616E-14,
7.30804305959509E-14,
4.58357310439972E-14,
7.66331442747514E-14,
4.25215418431435E-14,
7.96446242290472E-14,
4.03531374981725E-14,
9.28623497542524E-14,
5.00710584105946E-14,
1.15752893381504E-13,
5.41962308364674E-14,
1.26437055270046E-13,
5.24667115309185E-14,
1.28723420811383E-13,
3.89376031417754E-14,
1.30348856708373E-13,
3.30343391530263E-14,
1.30338448367517E-13,
3.09873654513737E-14,
1.34168717802474E-13,
  0,
  0,
1.84895501686988E-14,
  0,
3.12870389318487E-14,
  0,
3.80255722742806E-14,
  0,
3.82055498349132E-14,
  0,
3.54950444036994E-14,
1.34900771109336E-14,
4.32275742978661E-14,
2.40883701874139E-14,
5.1758076990982E-14,
3.1716816673022E-14,
5.36055574928973E-14,
3.2388154658225E-14,
5.4675881877575E-14,
0.817268812823782,
5.69665842276024E-14,
0.455720735431046,
5.91011614647918E-14,
0.391136856840398,
6.16208473136481E-14,
0.390941477493085,
5.54859977408562E-14,
0.455221378652922,
6.18264120455514E-14,
0.816906625452895,
6.8813878206786E-14,
4.39396782847545E-14,
7.48940839900847E-14,
4.25007251614318E-14,
7.80243925024848E-14,
3.97520558137465E-14,
8.85671744277339E-14,
4.45754544387E-14,
1.06904068930547E-13,
5.22758919485611E-14,
1.21512175321747E-13,
5.10459730040935E-14,
1.28209942662494E-13,
4.08111044958304E-14,
1.28088512019175E-13,
3.34055699768854E-14,
1.28884750094649E-13,
2.67303540413266E-14,
1.27398092075737E-13,
2.65152483303055E-14,
  0,
1.53210777398272E-14,
  0,
3.08628990419724E-14,
  0,
3.68481287149613E-14,
  0,
4.20223751629312E-14,
1.11985073991683E-14,
4.36725308694541E-14,
1.8699451709292E-14,
4.71107527988401E-14,
2.44197023713255E-14,
5.31371821543836E-14,
3.15797735184198E-14,
5.52049725377479E-14,
3.40691017064465E-14,
5.9016160014469E-14,
4.34947217131665E-14,
6.21100393338736E-14,
0.817176828114029,
6.14187520286968E-14,
0.455533066265067,
5.96658139562223E-14,
0.390941477493085,
5.75069505903691E-14,
0.390768455344716,
5.93067261966951E-14,
0.455091142995383,
6.3430163899092E-14,
0.816856687983904,
7.05277850010511E-14,
4.084146215666E-14,
7.61803814475215E-14,
3.97806787511001E-14,
8.70050559376168E-14,
4.40186082029115E-14,
1.02608893604028E-13,
4.68097782757582E-14,
1.12666820317742E-13,
4.92193091838899E-14,
1.23307614119383E-13,
3.93973048629093E-14,
1.27488297696488E-13,
3.52756018839884E-14,
1.26615731788071E-13,
2.70686251191421E-14,
1.25864596522973E-13,
2.22478285794026E-14,
1.22495763532626E-13,
1.32997996296624E-14,
  0,
2.86324783327352E-14,
  0,
3.68277457141186E-14,
  0,
4.10864918476417E-14,
1.19717603885849E-14,
4.75947406486377E-14,
2.0120190236117E-14,
5.53663018210138E-14,
2.97054048026268E-14,
5.70116870379778E-14,
3.19223814049252E-14,
5.65858124246255E-14,
3.39771613622197E-14,
6.05973604628218E-14,
4.51643930587942E-14,
6.65249105802346E-14,
4.7792499124899E-14,
6.68709879136919E-14,
0.81709627345181,
6.17552883830363E-14,
0.455367755753812,
5.53992615670573E-14,
0.390768455344716,
6.16269188458141E-14,
0.390614497001062,
6.18706474941888E-14,
0.454974754295626,
6.52559603575575E-14,
0.816811879983381,
7.2027453446033E-14,
3.81023337880926E-14,
8.50899212201384E-14,
4.39648317751562E-14,
1.00971314642706E-13,
4.62060945061182E-14,
1.08349093586035E-13,
4.37341135528513E-14,
1.14406747964146E-13,
3.75064562740945E-14,
1.22547805236906E-13,
3.38288425050237E-14,
1.25953067420248E-13,
2.89386570262451E-14,
1.23548740682544E-13,
2.2586099657218E-14,
1.20918899892963E-13,
2.05634120842291E-14,
  0,
2.96143318201381E-14,
  0,
3.53141994813289E-14,
  0,
4.14286660532781E-14,
  0,
4.68752640869763E-14,
2.09623984837037E-14,
5.94411672660833E-14,
3.12310940997484E-14,
6.53470333400463E-14,
3.72236963475103E-14,
6.05886868454419E-14,
3.44368630833536E-14,
6.20857532052099E-14,
4.502821726593E-14,
6.8060140856474E-14,
4.93927815314876E-14,
7.08374331415129E-14,
4.77005587806723E-14,
6.68805288928098E-14,
0.817025324782698,
5.7595421487644E-14,
0.455221378652922,
5.93483595601185E-14,
0.390614497001062,
6.32202623584988E-14,
0.390476895206482,
6.33815916417646E-14,
0.45487031262149,
6.70435928995516E-14,
0.816771520707917,
8.08467875978991E-14,
4.24660306919122E-14,
9.91290383112187E-14,
4.62910959564411E-14,
1.06664677090862E-13,
4.31408381240672E-14,
1.10005754505593E-13,
3.20264648134838E-14,
1.13652143252096E-13,
3.19275855753531E-14,
1.21009105513714E-13,
2.74988365411843E-14,
1.22908627719909E-13,
2.44474579469411E-14,
1.18582227370823E-13,
2.08947442681406E-14,
1.20197254926957E-13,
2.08940937468372E-14,
  0,
3.77389092198754E-14,
  0,
4.03453312425306E-14,
  0,
4.74537943662146E-14,
1.82891896072235E-14,
5.88522286459892E-14,
3.21227419664005E-14,
6.95424620666962E-14,
3.87866821993654E-14,
6.895872761703E-14,
3.96887384068734E-14,
6.61267915424979E-14,
4.55217460948454E-14,
6.95728197275258E-14,
4.92366564186497E-14,
7.24273072072457E-14,
4.94344148949111E-14,
7.12251438383937E-14,
4.07911551758566E-14,
6.24916784985885E-14,
0.816962508941322,
6.17761050647481E-14,
0.455091142995383,
6.18706474941888E-14,
0.390476895206482,
6.51518769489989E-14,
0.390353407727887,
6.47580947199522E-14,
0.454776233729486,
7.60069090999238E-14,
0.816735038937406,
9.47523309813292E-14,
4.44401460075738E-14,
1.0489352442189E-13,
4.30697144615522E-14,
1.08310929669564E-13,
3.13967601917042E-14,
1.09297987327395E-13,
2.64840233077379E-14,
1.1205099348377E-13,
2.56357435279853E-14,
1.17891807427384E-13,
2.30041680149284E-14,
1.17935175514283E-13,
2.27630414517677E-14,
1.17785989295349E-13,
  0,
  0,
3.34927398315532E-14,
  0,
4.3602274568677E-14,
1.09244210899639E-14,
4.67382209323741E-14,
1.69677639993981E-14,
5.96779570205541E-14,
2.95163199437454E-14,
6.91252610707238E-14,
3.9791087091956E-14,
7.32565050287626E-14,
4.13176437508156E-14,
7.4569690700077E-14,
5.08508166130461E-14,
7.3673706024735E-14,
4.97215116301852E-14,
7.3972078462603E-14,
4.9365025955872E-14,
7.29000193544493E-14,
4.25128682257636E-14,
6.66879745869764E-14,
4.07018169168438E-14,
6.64815424933352E-14,
0.816906625452895,
6.34318986225679E-14,
0.454974754295626,
6.33694485774328E-14,
0.390353407727887,
6.66645558200507E-14,
0.390242164515518,
7.34690086545697E-14,
0.454691188030739,
8.98118385217472E-14,
0.816701952450738,
1.00556715731948E-13,
4.1433870223706E-14,
1.06551920064923E-13,
3.1412372702988E-14,
1.07578876362702E-13,
2.59028909432857E-14,
1.07707245899924E-13,
2.01470784499946E-14,
1.08984002378243E-13,
2.11289319373975E-14,
1.12902742710475E-13,
2.13266904136589E-14,
1.17123324927526E-13,
1.12687636999453E-14,
1.1476757044715E-13,
1.77440527548978E-14,
1.099511107161E-14,
4.10431237607423E-14,
1.34757656422568E-14,
5.0565020920379E-14,
2.00876641709424E-14,
5.92893789619353E-14,
2.8350585767889E-14,
7.01409416659082E-14,
3.73139019682611E-14,
7.29850208047722E-14,
4.23680188155195E-14,
7.89776230525341E-14,
5.25109469795559E-14,
8.21677795248554E-14,
5.50661946596698E-14,
7.81232717406155E-14,
4.98724325725952E-14,
7.44135655872391E-14,
4.23602125598777E-14,
6.84617293411627E-14,
4.23636820068296E-14,
7.08903422075302E-14,
4.64940586031304E-14,
6.8813878206786E-14,
0.816856687983904,
6.52143269941341E-14,
0.45487031262149,
6.46869710574371E-14,
0.390242164515518,
7.54309809058995E-14,
0.390141595827091,
8.73277145041484E-14,
0.454614052916922,
9.51443784868999E-14,
0.816671851860366,
1.02355623976536E-13,
2.97158131434827E-14,
1.05727926413834E-13,
2.58872784320019E-14,
1.05979461317851E-13,
1.94948224230274E-14,
1.04610764495305E-13,
1.56142460072672E-14,
1.03916875104915E-13,
1.93942084614207E-14,
1.12083953229813E-13,
  0,
1.14071946333283E-13,
  0,
  0,
2.93946724599925E-14,
1.59494813189998E-14,
4.89595343433624E-14,
2.28922783507279E-14,
6.35173337537598E-14,
3.1565895730612E-14,
7.00004290643541E-14,
3.61967400497321E-14,
7.41923883440521E-14,
4.00009886325492E-14,
7.88275694718621E-14,
5.3629843621561E-14,
8.66520397102555E-14,
5.67497437931053E-14,
8.66936730736789E-14,
5.52127787933898E-14,
7.85734324826315E-14,
4.28762927939808E-14,
7.00706853651312E-14,
4.23402632399039E-14,
7.27473636885634E-14,
4.80553097315095E-14,
7.31029820011386E-14,
4.39674338603702E-14,
7.05555405766667E-14,
0.816811879983381,
6.70505317934555E-14,
0.454776233729486,
7.34447225259061E-14,
0.390141595827091,
8.93746882058011E-14,
0.3900503760662,
9.2899646308986E-14,
0.4545438752002,
9.68079783003617E-14,
0.816644387777254,
1.0130611627357E-13,
2.41057174221737E-14,
1.0412157247508E-13,
1.95503335742586E-14,
1.02910735488848E-13,
1.50105622376273E-14,
9.95002691350777E-14,
1.39263600651418E-14,
1.03120637029441E-13,
  0,
1.08945838461771E-13,
  0,
1.0130611627357E-13,
1.61836689882566E-14,
1.04022693236949E-14,
3.897012920695E-14,
2.57840623851813E-14,
6.25827514810773E-14,
3.45652326205759E-14,
7.46807130025395E-14,
3.95976654243846E-14,
7.42904002204448E-14,
3.90208698686223E-14,
8.01528982075084E-14,
5.131051833418E-14,
8.66546417954694E-14,
5.79388967358874E-14,
9.12664041563538E-14,
5.69821967388862E-14,
8.72626623737993E-14,
4.83372022963557E-14,
7.42366237926895E-14,
4.28147101105836E-14,
7.43415745629861E-14,
4.81229639470726E-14,
7.48307665832115E-14,
4.57385865293425E-14,
7.49062270544165E-14,
4.084146215666E-14,
7.19754117417537E-14,
0.816771520707917,
7.60069090999238E-14,
0.454691188030739,
8.73832256553797E-14,
0.3900503760662,
9.51114187408564E-14,
0.389967379521892,
9.47245754057136E-14,
0.454479841283494,
9.60880680578313E-14,
0.816619260543347,
9.99599708562116E-14,
1.77600989470506E-14,
1.01038968858269E-13,
1.50452567071468E-14,
9.77065650609177E-14,
1.32307359512751E-14,
9.87179088474122E-14,
  0,
9.99755833674953E-14,
  0,
9.6188682019438E-14,
  0,
  0,
2.95319324550292E-14,
2.09775773141185E-14,
5.3628108898085E-14,
3.78117676058665E-14,
7.4273920347423E-14,
4.28151437914526E-14,
7.92439031060965E-14,
4.25120008640256E-14,
8.04842303914199E-14,
5.04336156170737E-14,
8.81222178561458E-14,
5.57045728988292E-14,
9.13201805841091E-14,
5.81999726190219E-14,
9.19021803102993E-14,
5.00302924089091E-14,
8.29579460681629E-14,
4.82556702929848E-14,
7.85066456288064E-14,
4.85575121778048E-14,
7.64258448193722E-14,
4.57203719328447E-14,
7.66288074660615E-14,
4.25319501839994E-14,
7.61161966789103E-14,
3.81387629810881E-14,
8.08190320222835E-14,
0.816735038937406,
8.98395940973629E-14,
0.454614052916922,
9.2899646308986E-14,
0.389967379521892,
9.66778740396634E-14,
0.389891645207837,
9.39699706936636E-14,
0.454421253292207,
9.47037587240018E-14,
0.816596211960012,
9.65703211841529E-14,
1.33660443824013E-14,
9.59787804788448E-14,
1.32845123790304E-14,
9.693808256106E-14,
  0,
9.55433648863746E-14,
  0,
8.71941407964982E-14,
  0,
9.90700577130355E-14,
1.79173082620609E-14,
2.01661604082304E-14,
4.59315745160449E-14,
3.36475639017841E-14,
6.61363325216158E-14,
4.63999498545586E-14,
7.93115573216596E-14,
4.59137936004161E-14,
8.57274320975598E-14,
5.4078269640101E-14,
8.85697765129478E-14,
5.49577744424212E-14,
9.29256671611256E-14,
5.59934043575794E-14,
9.20036616336439E-14,
5.13278655689398E-14,
8.7582718855117E-14,
5.00727931340705E-14,
8.71854671791183E-14,
5.40322994679876E-14,
8.06629069094456E-14,
4.62668098277774E-14,
7.82247530639602E-14,
4.24764390327681E-14,
7.79975042886072E-14,
3.97824134745761E-14,
8.51523712652735E-14,
4.2410519540681E-14,
9.47488615343772E-14,
0.816701952450738,
9.5213767425939E-14,
0.4545438752002,
9.47176365118096E-14,
0.389891645207837,
9.59527596267051E-14,
0.389822348721294,
9.23965765009527E-14,
0.454367509841752,
9.14615605474012E-14,
0.816575018580505,
9.14841119525889E-14,
1.15046860926782E-14,
9.5068050653957E-14,
  0,
9.37253746835509E-14,
  0,
8.27792695501373E-14,
-1.07379383162964E-14,
8.99922497632488E-14,
-1.00440489259057E-14,
1.55502780790906E-14,
3.85822016696347E-14,
3.40005801291454E-14,
5.95691031224366E-14,
4.26915447437892E-14,
7.1732550455117E-14,
4.97752880579405E-14,
8.61376941996284E-14,
5.77064437901065E-14,
9.40645131231044E-14,
5.87576862165484E-14,
9.35449634420493E-14,
5.53316073514942E-14,
9.37114968957431E-14,
4.92062987578201E-14,
8.78359884826097E-14,
5.13486822506515E-14,
9.19273338007009E-14,
5.58520243942873E-14,
8.93538715240894E-14,
5.16375137094016E-14,
8.2423651237562E-14,
4.30757859937181E-14,
7.96498283994751E-14,
3.97537905372225E-14,
8.69321975516257E-14,
4.39648317751562E-14,
9.91290383112187E-14,
4.44193293258621E-14,
1.00556715731948E-13,
0.816671851860366,
9.68079783003617E-14,
0.454479841283494,
9.39699706936636E-14,
0.389822348721294,
9.42822209193395E-14,
0.389758779562559,
8.94822410613116E-14,
0.454318090438458,
8.63701471454092E-14,
0.816555486236845,
9.05872599155089E-14,
  0,
9.19160580981071E-14,
  0,
8.1001177987261E-14,
-1.14058068545475E-14,
8.56155424333593E-14,
-1.56489404767868E-14,
9.27643378778598E-14,
2.66407989418793E-14,
3.28834182106164E-14,
5.43206972458687E-14,
4.38976112404621E-14,
6.60396216878301E-14,
4.65062016674622E-14,
7.90869106315206E-14,
6.1778707149962E-14,
9.47861580891107E-14,
6.25038215629203E-14,
9.91940904415678E-14,
5.9239071981132E-14,
9.4466968969531E-14,
4.85687878803986E-14,
8.96348967271976E-14,
4.9291300208143E-14,
9.21944812160014E-14,
5.71582711716978E-14,
9.41191569125976E-14,
5.3481524764365E-14,
9.12048214729566E-14,
4.85661857951847E-14,
8.38972988304043E-14,
4.03531374981725E-14,
8.85671744277339E-14,
4.40186082029115E-14,
1.00974784089658E-13,
4.62390542521618E-14,
1.04916075827077E-13,
4.14147882654703E-14,
1.0228450031402E-13,
0.816644387777254,
9.60880680578313E-14,
0.454421253292207,
9.24781085043236E-14,
0.38975877956256,
9.11215547461097E-14,
0.389700322735306,
8.41375580318271E-14,
0.454272542748962,
8.55461534943203E-14,
0.816537445547838,
8.7438736806611E-14,
  0,
7.91484933149178E-14,
-1.13051928929409E-14,
8.37819397192519E-14,
-1.62526242464267E-14,
8.82870165863636E-14,
-1.76837711141076E-14,
2.24076399796269E-14,
4.83116151250851E-14,
4.44336407945389E-14,
6.21013657164937E-14,
4.824049146257E-14,
7.39087610557299E-14,
5.87585535782864E-14,
8.80424205762509E-14,
6.67625676964434E-14,
1.00180280737661E-13,
6.30996990769184E-14,
1.00307782913145E-13,
5.24779872335124E-14,
9.0502258465186E-14,
4.87552706540662E-14,
9.40775235491742E-14,
5.5126042619591E-14,
9.44348765852254E-14,
5.47981798826314E-14,
9.60724555465475E-14,
5.03902475301743E-14,
9.26567850223492E-14,
4.58261900648793E-14,
9.28545434986106E-14,
4.45529030335123E-14,
1.02622771391836E-13,
4.62095639530702E-14,
1.06692432666478E-13,
4.30402241624606E-14,
1.06550185341447E-13,
2.97192825904347E-14,
1.01333871849185E-13,
0.816619260543347,
9.4766208769137E-14,
0.454367509841752,
8.95099966369273E-14,
0.389700322735306,
8.601626355631E-14,
0.389646443727519,
8.35078534100475E-14,
0.454230472150036,
8.22328316552046E-14,
0.816520748212081,
7.47787248789322E-14,
-1.32012456521835E-14,
8.18060896801143E-14,
-1.62578284168546E-14,
8.64690263835399E-14,
-1.82822507133196E-14,
9.07364461344429E-14,
2.91368491833754E-14,
3.889683714009E-14,
5.85313048029334E-14,
4.9812584612674E-14,
7.08122796511113E-14,
6.09260905615194E-14,
8.3396831107585E-14,
6.40624706060855E-14,
9.37618038765464E-14,
6.75735509214626E-14,
1.01510813643735E-13,
5.64791269308529E-14,
9.64488905408345E-14,
5.27225832436251E-14,
9.50749895478609E-14,
5.46090950237499E-14,
9.63951141130792E-14,
5.28370749930396E-14,
9.63612870052977E-14,
5.17389950327463E-14,
9.74801836473027E-14,
4.77135692067421E-14,
1.01656530415717E-13,
5.0041568111503E-14,
1.06905803654023E-13,
4.68479421922297E-14,
1.0833868524518E-13,
4.31096131014996E-14,
1.0833868524518E-13,
3.13950254682283E-14,
1.05783437565066E-13,
2.41126563160776E-14,
9.98732346824127E-14,
0.816596211960012,
9.15725828498637E-14,
0.454318090438458,
8.4069903816264E-14,
0.389646443727519,
8.52495157799282E-14,
0.389596676180599,
8.00488147989498E-14,
0.454191533103175,
6.97931296089749E-14,
0.81650526393269,
7.75941810804426E-14,
-1.79283671242203E-14,
8.46215458816246E-14,
-1.82267395620883E-14,
8.88455975456282E-14,
-2.65620858641569E-14,
2.25015318877642E-14,
4.57659084240891E-14,
4.62121660382842E-14,
6.86070124322757E-14,
6.31716901011714E-14,
8.09075029195583E-14,
6.65535335175882E-14,
8.94813736995737E-14,
6.50668754986761E-14,
9.53100445788557E-14,
6.10796135891434E-14,
9.77880970642886E-14,
5.67367333670354E-14,
1.01156930054636E-13,
5.8642327105396E-14,
9.7458499603853E-14,
5.23721691014778E-14,
9.83770356843827E-14,
4.97856963987964E-14,
9.78999867284891E-14,
4.91134910518554E-14,
1.06539777000592E-13,
5.19497639350774E-14,
1.15749423934552E-13,
5.23331378232683E-14,
1.1266335087079E-13,
4.37479913406591E-14,
1.10002285058641E-13,
3.13690046160886E-14,
1.07547651340134E-13,
2.58525839624824E-14,
1.04107694687272E-13,
1.77878545226662E-14,
9.65946073128165E-14,
0.816575018580505,
8.64117805088327E-14,
0.454272542748962,
8.3323972721594E-14,
0.389596676180599,
8.21686468865934E-14,
0.38955061170996,
6.75345196432531E-14,
0.454155421998181,
7.20951076615961E-14,
0.816490877853628,
8.00141203294302E-14,
-2.00256478066763E-14,
8.70276073428045E-14,
-2.65221872242094E-14,
8.57664633757693E-14,
2.37000089692296E-14,
3.48198032906755E-14,
5.83109949214844E-14,
6.07751696191094E-14,
7.96480936759991E-14,
6.940715363557E-14,
8.74638902970126E-14,
6.78823317001864E-14,
9.13401299040828E-14,
5.87386042583127E-14,
9.18154441365004E-14,
6.14430381573605E-14,
1.02614097774456E-13,
6.2752754381723E-14,
1.03670544371326E-13,
5.64409630143814E-14,
9.95427698602391E-14,
4.93364030185184E-14,
9.99547666857836E-14,
4.71636618648574E-14,
1.06946569655708E-13,
5.33479510567147E-14,
1.2060144549686E-13,
5.4152862749568E-14,
1.21527787833031E-13,
4.92366564186497E-14,
1.14378992388531E-13,
3.20264648134838E-14,
1.09294517880443E-13,
2.58751353676701E-14,
1.05951705742235E-13,
1.95780891498742E-14,
1.01011213282654E-13,
1.33365540833097E-14,
9.14841119525889E-14,
0.816555486236845,
8.55461534943203E-14,
0.454230472150036,
8.00488147989498E-14,
0.38955061170996,
6.93802654216924E-14,
0.389507891458017,
7.02701785648685E-14,
0.454121871186402,
7.49313805448182E-14,
0.816477488412477,
8.26595736302949E-14,
-2.827252321147E-14,
8.39259217677579E-14,
-3.65211333397397E-14,
1.77026362319088E-14,
4.18463007301195E-14,
5.1385545124516E-14,
7.08049070763384E-14,
6.78211826976582E-14,
8.6913982955128E-14,
7.1128866685477E-14,
8.97355106888043E-14,
6.18134016194816E-14,
8.80892581101023E-14,
5.9238204619394E-14,
9.68227234499075E-14,
6.75856939857944E-14,
1.05259551075321E-13,
6.0657208422743E-14,
1.05820734119799E-13,
5.34849942113169E-14,
1.01169940480705E-13,
4.6746460868885E-14,
1.09060330211186E-13,
5.14284795305464E-14,
1.21115791007487E-13,
5.56100304693885E-14,
1.26421442758762E-13,
5.10286257693338E-14,
1.23307614119383E-13,
3.75064562740945E-14,
1.13666021039904E-13,
2.6480553860786E-14,
1.07703776452972E-13,
1.94740057413156E-14,
1.02867367401949E-13,
1.50400525367189E-14,
9.59805152023208E-14,
1.14994819222503E-14,
9.05595043398932E-14,
0.816537445547838,
8.22276274847766E-14,
0.454191533103175,
6.7537989090205E-14,
0.389507891458017,
7.19008186322867E-14,
0.389468199050383,
7.27248122833757E-14,
0.454090643982638,
7.71986641279199E-14,
0.816465005534011,
7.93913546015546E-14,
-3.84310638867902E-14,
7.75022407362158E-14,
2.4610955634552E-14,
3.87021144299116E-14,
5.6696834727088E-14,
5.96974726596589E-14,
7.90383383741933E-14,
7.01513500067641E-14,
8.9678264814097E-14,
6.53392270844044E-14,
8.67760724387878E-14,
6.2456116667331E-14,
9.33029695171506E-14,
6.54962195589803E-14,
9.96216997783961E-14,
6.55170362406921E-14,
1.07526834658422E-13,
5.77029743431545E-14,
1.07512089508877E-13,
5.0937552786845E-14,
1.10325810986911E-13,
5.10173500667399E-14,
1.2326598075596E-13,
5.37365291153336E-14,
1.26959207036315E-13,
5.24788545952504E-14,
1.2818565653383E-13,
3.94042437568132E-14,
1.22547805236906E-13,
3.19275855753531E-14,
1.12078749059386E-13,
2.0121057597855E-14,
1.04624642283113E-13,
1.5036583089767E-14,
9.77343206365333E-14,
1.32619609738427E-14,
9.51513173808038E-14,
  0,
8.74942479578422E-14,
0.816520748212081,
6.97948643324509E-14,
0.454155421998181,
7.02771174587724E-14,
0.389468199050383,
7.44612704828285E-14,
0.389431254694813,
7.53338363912448E-14,
0.45406153045984,
7.41316730223929E-14,
0.816453349104106,
7.31897181749375E-14,
-3.5228764350137E-14,
2.69870931157712E-14,
4.51379385257855E-14,
4.90996132640475E-14,
6.64117198734271E-14,
6.27909182981945E-14,
8.25268672843826E-14,
6.47034509304589E-14,
8.71681199443586E-14,
6.6195313119799E-14,
9.22465229202807E-14,
6.8814745568524E-14,
9.6265009852381E-14,
6.35195021581048E-14,
1.02040771665646E-13,
6.26660182079242E-14,
1.09358702649054E-13,
5.51416551308748E-14,
1.16785053849711E-13,
5.51824211325602E-14,
1.24597381023772E-13,
5.32828989263656E-14,
1.29115468316954E-13,
5.06018837942435E-14,
1.28723420811383E-13,
4.08492684123019E-14,
1.27516053272103E-13,
3.38427202928315E-14,
1.21022983301522E-13,
2.56340088045093E-14,
1.08984002378243E-13,
1.56177154542192E-14,
9.95002691350777E-14,
1.32550220799388E-14,
9.693808256106E-14,
  0,
9.19160580981071E-14,
  0,
7.47717859850283E-14,
0.81650526393269,
7.20985771085481E-14,
0.454121871186402,
7.27664456467991E-14,
0.389431254694813,
7.72472363852472E-14,
0.389396810215576,
7.19008186322867E-14,
0.454034343896034,
6.75987044118642E-14,
0.816442447675262,
7.85742998443695E-14,
2.75066427968262E-14,
4.31620884866479E-14,
5.72675587506843E-14,
5.34134368679329E-14,
7.08005702676484E-14,
5.79094064367958E-14,
8.05033123496557E-14,
6.58553073185075E-14,
9.29265345228636E-14,
7.27187407512098E-14,
9.54228016047942E-14,
6.69759386839885E-14,
9.8806379744687E-14,
6.07508834904458E-14,
1.03945498042268E-13,
6.01844962755393E-14,
1.18707994822831E-13,
5.95027499494805E-14,
1.31126880187349E-13,
5.75026137816792E-14,
1.30484165139499E-13,
5.02427960347163E-14,
1.30942132137157E-13,
3.89046433957319E-14,
1.28081573125272E-13,
3.52790713309403E-14,
1.2597388410196E-13,
2.75127143289922E-14,
1.17897011597812E-13,
2.11133194261137E-14,
1.03937691786626E-13,
1.39280947886178E-14,
9.87022963361284E-14,
  0,
9.37548649826425E-14,
  0,
7.91745141670575E-14,
-1.31197136488126E-14,
7.75803032926348E-14,
0.816490877853628,
7.49244416509143E-14,
0.454090643982638,
7.52644474522057E-14,
0.389396810215576,
7.38176880732411E-14,
0.389364644857495,
6.6042657453913E-14,
0.454008917760185,
7.35193156353731E-14,
0.816432237364348,
2.28560659981669E-14,
4.57325149971766E-14,
4.9665133117216E-14,
6.30047229666086E-14,
4.91980588213092E-14,
6.93759286130025E-14,
5.9385656114852E-14,
8.66615806893734E-14,
7.26181267896031E-14,
9.63300619827301E-14,
7.10022318717307E-14,
9.81688688672655E-14,
6.42853825727485E-14,
1.00876772213265E-13,
5.83665060727157E-14,
1.1340928196546E-13,
6.45698772228087E-14,
1.33133955249054E-13,
6.18342183011933E-14,
1.37060501836928E-13,
5.44789907630516E-14,
1.32354197046602E-13,
3.8594127893532E-14,
1.30347121984897E-13,
3.34125088707893E-14,
1.26615731788071E-13,
2.89664126018607E-14,
1.22922505507717E-13,
2.29902902271206E-14,
1.12890599646143E-13,
1.93664528858051E-14,
1.03134514817249E-13,
  0,
9.55711204619902E-14,
  0,
8.1001177987261E-14,
-1.13034581694649E-14,
8.18060896801143E-14,
-1.79283671242203E-14,
7.99985078181464E-14,
0.816477488412477,
7.72021335748718E-14,
0.45406153045984,
7.18869408444789E-14,
0.389364644857495,
6.76819711387111E-14,
0.389334561726082,
7.09987624247788E-14,
0.453985103145495,
8.17089451654596E-14,
2.53241438236129E-14,
3.45123235545586E-14,
5.38757406742807E-14,
4.65508707969686E-14,
6.2453948262986E-14,
5.1158730030032E-14,
7.59730819921423E-14,
6.64598584498854E-14,
9.03912361627235E-14,
7.10924374924815E-14,
9.92808266153666E-14,
6.84487189150929E-14,
1.00376304490446E-13,
6.19686593705815E-14,
1.10466323588465E-13,
6.27943877451465E-14,
1.27917641756792E-13,
6.69620608961807E-14,
1.39166456136763E-13,
5.88348814112294E-14,
1.38987779618738E-13,
4.28632823679109E-14,
1.31757452170866E-13,
3.30326044295504E-14,
1.28877811200745E-13,
2.70894418008538E-14,
1.23548740682544E-13,
2.4456131564321E-14,
1.17919563002999E-13,
2.12972001145673E-14,
1.12070075442006E-13,
  0,
9.99565014092596E-14,
  0,
8.28139640196568E-14,
-1.13537651502682E-14,
8.38062258479155E-14,
-1.62578284168546E-14,
8.4593790306009E-14,
-2.00551381057679E-14,
8.25901846912558E-14,
0.816465005534011,
7.40761618711616E-14,
0.454034343896034,
6.6044392177389E-14,
0.389334561726082,
7.27976706693667E-14,
0.389306384755812,
7.92976795338518E-14,
0.453962766575833,
1.69885806811099E-14,
3.91488057249756E-14,
3.32034746919341E-14,
5.45531501916496E-14,
4.91546907344098E-14,
6.95684829188359E-14,
5.85764076133088E-14,
8.00809071832553E-14,
6.51735609924486E-14,
9.35970051463286E-14,
6.86768350521838E-14,
1.01690357523498E-13,
6.62091909076068E-14,
1.10090755955916E-13,
6.65179716863307E-14,
1.2507703206488E-13,
6.5218663802824E-14,
1.34081981628675E-13,
6.39844080496665E-14,
1.41154449240233E-13,
4.72226424630406E-14,
1.38453484788137E-13,
3.72896158395974E-14,
1.30336713644041E-13,
2.67511707230383E-14,
1.25887147928161E-13,
2.26069163389298E-14,
1.1859610515863E-13,
2.27855928569554E-14,
1.17111181863194E-13,
  0,
1.08966655143483E-13,
  0,
8.7209753307782E-14,
-1.07119174641568E-14,
8.56033993690275E-14,
-1.62248686708111E-14,
8.64707611070159E-14,
-1.82232701151364E-14,
8.70345462367084E-14,
-2.83245649157493E-14,
7.93844157076506E-14,
0.816453349104106,
6.75449279841089E-14,
0.454008917760185,
7.10022318717307E-14,
0.389306384755812,
8.11243433540554E-14,
0.389279956118894,
7.63451801777393E-14,
1.98786299920872E-14,
1.9374692822316E-14,
4.18775257526871E-14,
3.6653406004783E-14,
6.24960153072784E-14,
5.69544411632705E-14,
7.40978459146113E-14,
5.75511860390066E-14,
8.35841812429905E-14,
6.28941343450151E-14,
9.62303153828614E-14,
6.65639418584441E-14,
1.11540984781833E-13,
7.08443720354168E-14,
1.24843711757361E-13,
6.89726054048379E-14,
1.31362802580082E-13,
6.23156040657769E-14,
1.36151506735516E-13,
5.24233434440191E-14,
1.40706890583431E-13,
4.16854051277227E-14,
1.37081318518639E-13,
3.09908348983257E-14,
1.27385949011405E-13,
2.22218077272629E-14,
1.20925838786867E-13,
2.09051526089965E-14,
1.17796397636205E-13,
1.12548859121375E-14,
1.14047660204619E-13,
  0,
9.62129681481017E-14,
  0,
9.00061275510566E-14,
-1.5635062688979E-14,
8.8260995734224E-14,
-1.82805159898436E-14,
8.88386586517242E-14,
-2.65187177772575E-14,
8.39016356390943E-14,
-3.84015735876986E-14,
7.31775751106056E-14,
0.816442447675262,
7.35765615100803E-14,
0.453985103145495,
7.93271698329434E-14,
0.389279956118894,
7.79116354765463E-14,
0.389255134002679,
  0,
2.70434716287404E-14,
2.39998992901391E-14,
5.08772711460548E-14,
4.50386256067858E-14,
6.76091127527201E-14,
5.62917767954474E-14,
7.79688813512536E-14,
5.54721199530483E-14,
8.64386687227103E-14,
6.09399683493272E-14,
1.06257884435745E-13,
7.12849917983149E-14,
1.26461341398709E-13,
7.34256405676703E-14,
1.31250912915881E-13,
6.61528123946376E-14,
1.33542482627647E-13,
5.07805603122691E-14,
1.35768132847325E-13,
4.69103922373648E-14,
1.39376357677357E-13,
3.54317269968263E-14,
1.34166983078998E-13,
2.65221872242094E-14,
1.22488824638722E-13,
2.0570350978133E-14,
1.20218071608669E-13,
  0,
1.14764101000198E-13,
  0,
1.01326932955281E-13,
  0,
9.90700577130355E-14,
-1.00666003310934E-14,
9.27782156656676E-14,
-1.76560155384919E-14,
9.07364461344429E-14,
-2.65586164172049E-14,
8.57387078001537E-14,
-3.65419500214514E-14,
7.74467295849846E-14,
-3.52565199257526E-14,
7.85742998443695E-14,
0.816432237364348,
8.16256784386127E-14,
0.453962766575833,
7.6287934303032E-14,
0.389255134002679,
7.38593214366645E-14,
  0,
  0,
-1.06270244340512E-14,
-1.06920765644003E-14,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
-1.30949938392799E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.91515640152184E-14,
  0,
1.96101815341798E-14,
  0,
1.66689578806611E-14,
  0,
1.97795339135221E-14,
1.54292811166412E-14,
2.61539921664333E-14,
2.05519195412007E-14,
2.94393415894989E-14,
2.11421592039018E-14,
3.00345685821934E-14,
2.02656901676646E-14,
2.59618715414689E-14,
2.33613042105452E-14,
2.50262050666139E-14,
2.20121230271042E-14,
2.40415326535626E-14,
2.18440716903689E-14,
2.60587992156891E-14,
1.30828507749481E-14,
1.62873187159462E-14,
  0,
-1.47202671059443E-14,
-1.63752475121348E-14,
-1.63159416532999E-14,
-1.66770893969548E-14,
0.869048189253471,
-1.23700962667561E-14,
0.868243142124454,
  0,
  0,
  0,
  0,
-1.64354207327078E-14,
-1.3648587468551E-14,
-1.66346970920106E-14,
  0,
  0,
  0,
  0,
  0,
1.08619710448288E-14,
  0,
1.10820640858433E-14,
  0,
1.19227544503886E-14,
  0,
2.29883386632102E-14,
  0,
3.35883664631664E-14,
  0,
3.14071685325601E-14,
1.36952081619679E-14,
3.156242628366E-14,
2.109337010614E-14,
3.97967249432529E-14,
3.11434905642116E-14,
4.81307702027145E-14,
3.60870187898765E-14,
5.14978684695855E-14,
3.58324481197769E-14,
4.84941947709316E-14,
3.7774037370264E-14,
4.41482787827407E-14,
3.9267200602211E-14,
4.2483811607541E-14,
3.79856736343331E-14,
4.33932403898218E-14,
3.02609499958084E-14,
3.6653406004783E-14,
2.11736010669039E-14,
-1.06270244340512E-14,
-1.64062556942679E-14,
-1.9051058473829E-14,
-2.04592202554532E-14,
0.84569137219913,
-1.87603838713857E-14,
0.569180939727208,
-1.50073096311099E-14,
0.842319572634655,
-1.28324000731039E-14,
  0,
-1.90143040201818E-14,
-1.30726592745267E-14,
-1.73689188032178E-14,
-1.32218454934607E-14,
-1.18754832356682E-14,
  0,
  0,
  0,
1.13541988311372E-14,
  0,
1.40764136458138E-14,
  0,
1.518186618088E-14,
  0,
2.55199507359638E-14,
  0,
3.33257726969904E-14,
  0,
4.10231744407685E-14,
1.50842879853563E-14,
4.23740903476855E-14,
2.37032615757471E-14,
4.69537603242642E-14,
3.33058233770167E-14,
5.5875443161213E-14,
4.21468415723325E-14,
6.3576314351943E-14,
4.60261169454856E-14,
6.32393443167345E-14,
4.86277684785819E-14,
6.06784587853237E-14,
4.85063378352635E-14,
5.59409289724311E-14,
5.02211119912666E-14,
5.62774653267706E-14,
4.1660251637321E-14,
4.83866419154211E-14,
3.51910341145345E-14,
4.79239044282043E-14,
-1.06920765644003E-14,
-1.63149658713446E-14,
-2.04579192128462E-14,
0.840454842765479,
-2.24252040548212E-14,
0.516247292013478,
-2.12308469416111E-14,
0.510646834705225,
-1.79834445945826E-14,
0.831822968539406,
-2.10679997753038E-14,
-1.29265088216757E-14,
-1.93185311497812E-14,
-1.19279586208165E-14,
-1.18347172339828E-14,
  0,
  0,
  0,
  0,
  0,
1.40213361754515E-14,
  0,
1.75384880229945E-14,
  0,
2.80053757961696E-14,
  0,
3.46411267726499E-14,
  0,
3.91713571301633E-14,
1.26851654180804E-14,
5.02328213747294E-14,
2.43147516010289E-14,
5.59305206315752E-14,
3.47465112238154E-14,
6.09282589658644E-14,
4.2707590935942E-14,
6.87843879076944E-14,
5.02120046930177E-14,
7.26168257469961E-14,
5.68191327321443E-14,
7.28115484571745E-14,
5.73252383062606E-14,
7.00216794269348E-14,
5.73477897114483E-14,
6.73554094443585E-14,
5.18968548690601E-14,
5.90217978657659E-14,
4.4952756794725E-14,
5.76218760206526E-14,
4.1135064104969E-14,
  0,
-1.67123259675606E-14,
0.84569137219913,
-2.24529596304368E-14,
0.50427290565928,
-2.37772041639106E-14,
0.449197860962549,
-2.32589555254625E-14,
0.486641753359994,
-2.64308974012861E-14,
0.826332327885253,
-2.0720404558805E-14,
-1.13498620224473E-14,
-1.34844392596367E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.71234554313671E-14,
  0,
2.98858160441284E-14,
  0,
3.64721274015434E-14,
  0,
3.97082540459781E-14,
  0,
4.74490238766556E-14,
2.15049332508155E-14,
6.27488512539021E-14,
3.47105157116889E-14,
6.86573194130791E-14,
4.32848201725733E-14,
7.24260061646387E-14,
4.97778901431545E-14,
7.63161235595167E-14,
5.9911711008942E-14,
8.06533659303277E-14,
6.42853825727485E-14,
8.06516312068517E-14,
6.49697309840214E-14,
8.00375390963559E-14,
5.78495584768746E-14,
6.87835205459564E-14,
5.41606690052099E-14,
6.70548686021455E-14,
4.99973326628655E-14,
6.5521373049382E-14,
  0,
0.869048189253471,
-1.87864047235253E-14,
0.516247292013478,
-2.38333658364454E-14,
0.435058977431533,
-2.59761830101457E-14,
0.421137950100819,
-3.12050732476088E-14,
0.473975125035577,
-2.53031103014667E-14,
0.823040973693117,
-1.50192358550072E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.02235928056693E-14,
  0,
2.92890711683924E-14,
  0,
3.80112608056038E-14,
  0,
4.10825887198207E-14,
  0,
4.7420400939302E-14,
1.69972542984898E-14,
5.92798379828174E-14,
3.1560257879315E-14,
7.46828814068845E-14,
4.28116743445006E-14,
7.93046184277557E-14,
4.97778901431545E-14,
7.90400730976693E-14,
5.878717651564E-14,
8.3396831107585E-14,
6.65830238166798E-14,
8.74621555735366E-14,
7.11505507289267E-14,
8.96921426019048E-14,
6.4698246760031E-14,
8.05041797113937E-14,
5.94212179461096E-14,
7.59505305869546E-14,
5.85607951020251E-14,
7.41099889789432E-14,
5.63169302858491E-14,
0.999999999999995,
-1.23700962667561E-14,
0.569180939727208,
-2.12327985055216E-14,
0.449197860962549,
-2.60349467678944E-14,
0.405916270809318,
-3.358468017578E-14,
0.406160137620627,
-3.04960050268033E-14,
0.466338299284759,
-1.93204827136917E-14,
0.82089110243639,
-1.01229788440627E-14,
  0,
  0,
  0,
  0,
-1.23026588916275E-14,
  0,
  0,
2.21914500664333E-14,
  0,
3.70688722772794E-14,
1.08979665569553E-14,
4.22444197678562E-14,
1.24249568966839E-14,
4.84395509814384E-14,
1.77930586930941E-14,
5.88496265607752E-14,
2.68439784290031E-14,
7.06951858164828E-14,
3.93296506473462E-14,
8.46787917563319E-14,
4.8915732575594E-14,
8.52963533137796E-14,
5.83647713492397E-14,
8.54446721709756E-14,
6.49766698779253E-14,
8.9528211233425E-14,
7.28367019475762E-14,
9.57567358739198E-14,
7.02979341404841E-14,
8.94648938265519E-14,
6.57321419517132E-14,
8.70909247496776E-14,
6.33295499374853E-14,
8.24323248549419E-14,
6.44319667064686E-14,
7.98762098130901E-14,
  0,
0.868243142124454,
-1.50057917480684E-14,
0.510646834705225,
-2.3261774451111E-14,
0.421137950100819,
-3.3582078090566E-14,
0.390304106547417,
-3.27515792264421E-14,
0.397064394625028,
-2.41490855090731E-14,
0.461330300895665,
-1.37585255688411E-14,
0.819400604425264,
  0,
  0,
  0,
-1.07852095310168E-14,
  0,
-1.09500082612346E-14,
1.31001980097079E-14,
  0,
2.98081871685785E-14,
  0,
4.10834560815587E-14,
1.53228124633031E-14,
4.94257412775312E-14,
2.08747949481669E-14,
5.95521895685458E-14,
2.75378678193938E-14,
6.9857314377586E-14,
3.44576797650653E-14,
8.0255246892591E-14,
4.51366374831785E-14,
9.01769978134404E-14,
5.71643427038637E-14,
9.1174463812127E-14,
6.41769623555E-14,
9.10894623618042E-14,
7.08140143745872E-14,
9.72945682353732E-14,
7.16180587057025E-14,
9.499345754449E-14,
7.0977945743067E-14,
9.54861190116674E-14,
6.93022028652734E-14,
9.30661797626797E-14,
6.88060719511441E-14,
8.76781286462958E-14,
5.88981988181025E-14,
  0,
  0,
0.842319572634655,
-1.80337515753859E-14,
0.486641753359994,
-3.12059406093468E-14,
0.406160137620627,
-3.26978027986868E-14,
0.380801050040177,
-2.66418831440518E-14,
0.391070714786782,
-1.89084858881472E-14,
0.457848503080682,
-1.13077949781548E-14,
0.81832070140422,
  0,
-1.00791770762942E-14,
  0,
  0,
1.32836450172924E-14,
  0,
2.05460648494693E-14,
  0,
3.36978708825875E-14,
1.1295651913823E-14,
4.80232173472039E-14,
2.36876490644633E-14,
6.02512831293645E-14,
3.05502151354275E-14,
7.03274244395757E-14,
3.5006719745212E-14,
7.91606363792496E-14,
4.00963984237279E-14,
8.53726811467226E-14,
5.32013669229947E-14,
9.57298476600421E-14,
6.27449481260811E-14,
9.64350127530267E-14,
6.97384858194816E-14,
9.84429551764698E-14,
6.92336812879724E-14,
9.60776597169755E-14,
7.20101062112732E-14,
1.00666003310934E-13,
7.42184091961917E-14,
1.01072795966051E-13,
7.44595357593525E-14,
9.7910395069345E-14,
6.30008198387877E-14,
8.75436875769076E-14,
  0,
  0,
-1.28321832326694E-14,
0.831822968539406,
-2.64586529769018E-14,
0.473975125035577,
-3.05029439207072E-14,
0.397064394625028,
-2.66136938875672E-14,
0.374529032745403,
-2.09645668880487E-14,
0.386889377682501,
-1.5933435126847E-14,
0.455320627801176,
  0,
0.817511184004236,
  0,
  0,
1.20290062632922E-14,
  0,
2.07724462630843E-14,
  0,
2.43468439853345E-14,
  0,
4.04598229919451E-14,
1.96127836193938E-14,
5.87342674496227E-14,
3.32615879283793E-14,
7.08044733954694E-14,
3.79401371430887E-14,
7.93280371946814E-14,
4.05248751222942E-14,
8.39623509607534E-14,
4.79833187072565E-14,
9.05725147659631E-14,
5.85686013576669E-14,
1.00606155351013E-13,
6.80297831956445E-14,
1.03489265768086E-13,
6.78649844654267E-14,
9.68912450272086E-14,
6.93646529104086E-14,
1.01385046191727E-13,
7.49973000369053E-14,
1.05871908462341E-13,
7.91276766332061E-14,
1.05590015897494E-13,
6.84148918073113E-14,
9.74697753064468E-14,
6.09928774153445E-14,
  0,
-1.00000303177028E-14,
  0,
-2.10142233475485E-14,
0.826332327885253,
-2.53013755779907E-14,
0.466338299284759,
-2.41469171047282E-14,
0.391070714786782,
-2.09506891002409E-14,
0.370148576222067,
-1.80159706597571E-14,
0.383846026371474,
-1.29436392160009E-14,
0.453422708564643,
  0,
0.81688762388229,
1.08793182795885E-14,
  0,
1.94974245082413E-14,
  0,
2.44465905852032E-14,
  0,
3.10498154965089E-14,
1.40139636006786E-14,
5.10268910458578E-14,
2.91086599268908E-14,
6.91911805628109E-14,
4.05153341431763E-14,
7.96463589525231E-14,
4.33455354942325E-14,
8.39614835990155E-14,
4.8246129313867E-14,
8.89687629124225E-14,
5.31848870499729E-14,
9.52207063198429E-14,
6.3725066890008E-14,
1.07404536653366E-13,
6.60548005182449E-14,
1.01701633226092E-13,
6.78779948914965E-14,
1.01915871575375E-13,
7.22243445605564E-14,
1.06334212268688E-13,
7.97053395507064E-14,
1.10098562211558E-13,
7.29026214396633E-14,
1.04853625781942E-13,
6.62551610797202E-14,
1.08622312533502E-13,
  0,
  0,
-1.89863316041317E-14,
-1.29191362469028E-14,
-2.0721705601412E-14,
0.823040973693117,
-1.94661994856737E-14,
0.461330300895665,
-1.89119553350992E-14,
0.386889377682501,
-1.81334981752546E-14,
0.36695764022015,
-1.51896724365219E-14,
0.38155677961536,
  0,
0.451958989794882,
  0,
0.816396484427775,
1.81391360265515E-14,
  0,
2.3187181341644E-14,
  0,
3.11452252876876E-14,
  0,
4.15214737592429E-14,
2.34413183308746E-14,
6.13675776861555E-14,
3.62522512009633E-14,
7.78309708349134E-14,
4.58331289587832E-14,
8.41176087118534E-14,
5.09739819798405E-14,
8.87926884796109E-14,
5.33600941210466E-14,
9.34261348839449E-14,
5.82450754293973E-14,
1.01793573570319E-13,
6.15930917380325E-14,
1.05409604655993E-13,
6.58622462124114E-14,
1.06491204743264E-13,
7.0529519724527E-14,
1.06640390962198E-13,
7.67745242380435E-14,
1.10315402646055E-13,
7.33163529886838E-14,
1.09130586511963E-13,
7.0609317004422E-14,
1.15779781595382E-13,
6.5223867973252E-14,
  0,
-1.64052799123127E-14,
-1.30657203806228E-14,
-1.93480214488728E-14,
-1.13251422129146E-14,
-1.50469914306228E-14,
0.82089110243639,
-1.37550561218891E-14,
0.457848503080682,
-1.58436631869652E-14,
0.383846026371474,
-1.52451835877532E-14,
0.364555860433759,
-1.24475083018716E-14,
0.379788684871356,
  0,
0.450805000959554,
1.39775344076831E-14,
0.816002375554015,
2.19208332041809E-14,
  0,
2.97539770599542E-14,
1.14890735813944E-14,
4.15518314200725E-14,
1.9219868752085E-14,
5.17736895022658E-14,
3.05337352624058E-14,
6.99093560818653E-14,
4.15665765696183E-14,
8.21773205039733E-14,
5.3402594846208E-14,
8.87866169474449E-14,
5.59743223993436E-14,
9.31034763174132E-14,
5.83326789649341E-14,
9.98697652354608E-14,
5.59769244845576E-14,
9.96399143748938E-14,
6.12791067888807E-14,
1.1007167399768E-13,
6.84469841916169E-14,
1.11019700377302E-13,
7.50051062925472E-14,
1.10435965927635E-13,
7.02146674136372E-14,
1.09154872640627E-13,
7.09241693153118E-14,
1.19848575508286E-13,
6.9485216191989E-14,
1.23993697254132E-13,
-1.30949938392799E-14,
-1.36457685429026E-14,
-1.73689188032178E-14,
-1.19453058555763E-14,
-1.34844392596367E-14,
  0,
-1.01503007388093E-14,
0.819400604425264,
-1.13190706807487E-14,
0.455320627801176,
-1.2940169769049E-14,
0.38155677961536,
-1.24440388549196E-14,
0.362699939689734,
  0,
0.378393122162479,
  0,
0.449878280140181,
1.74010111875234E-14,
0.815681087093769,
2.81849196759332E-14,
1.21959733978549E-14,
4.0087724806348E-14,
2.08071407326038E-14,
5.16739429023971E-14,
2.63773378139653E-14,
6.02356706180807E-14,
3.58411217371568E-14,
7.41516223423666E-14,
4.90562451771481E-14,
8.67752050770498E-14,
5.83708428814056E-14,
9.30028623558066E-14,
6.07855779599653E-14,
9.93762364065454E-14,
5.60480481470726E-14,
9.75192149255122E-14,
5.564819438586E-14,
1.0410422524032E-13,
6.37536898273616E-14,
1.14425829922382E-13,
7.27907317754628E-14,
1.14685171082041E-13,
6.83550438473901E-14,
1.09110637191989E-13,
6.77166656082306E-14,
1.1968724622502E-13,
6.96977198177962E-14,
1.27860395882085E-13,
7.51404147236734E-14,
  0,
-1.66631031889297E-14,
-1.32513357925523E-14,
-1.1890228385214E-14,
  0,
  0,
  0,
  0,
0.81832070140422,
  0,
0.453422708564643,
-1.00019818816133E-14,
0.379788684871356,
  0,
0.361234485387961,
  0,
0.377271366210101,
1.27354723988837E-14,
0.449122314319854,
2.43208231331948E-14,
0.815415573525731,
3.84301965250522E-14,
2.16640941297364E-14,
5.01560598609174E-14,
2.7969813964912E-14,
6.00890864843606E-14,
3.15789061566818E-14,
6.44423750473244E-14,
4.33013000455951E-14,
7.86471582303605E-14,
5.39091341011932E-14,
9.08873670768529E-14,
6.31040358856083E-14,
9.91619980572622E-14,
5.84497727995625E-14,
9.69276742202041E-14,
5.56065610224366E-14,
1.01911534766685E-13,
5.80464495913979E-14,
1.08336083159966E-13,
6.80453957069282E-14,
1.17881399086528E-13,
6.60730151147426E-14,
1.13188104722273E-13,
6.57520912716869E-14,
1.19515508600898E-13,
6.64286334273179E-14,
1.27554217188575E-13,
7.52366918765901E-14,
1.39776211438569E-13,
  0,
  0,
-1.18477276600526E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.817511184004236,
  0,
0.451958989794882,
  0,
0.378393122162479,
  0,
0.36005618091559,
1.01915004213637E-14,
0.376355611046883,
1.92875229676481E-14,
0.448497255790403,
3.41532357950314E-14,
0.815193535651868,
4.85809309447305E-14,
2.87391638265078E-14,
5.85850812306887E-14,
3.31627086902486E-14,
6.43408937239798E-14,
3.90035226338625E-14,
6.88156129302619E-14,
4.81056167123128E-14,
8.2727227845858E-14,
5.8638857658444E-14,
9.69294089436801E-14,
6.07422098730659E-14,
9.66171587180042E-14,
5.80065509514505E-14,
1.01184685630251E-13,
5.79267536715555E-14,
1.05994206467397E-13,
6.22557561058557E-14,
1.11705783512051E-13,
6.12739026184528E-14,
1.16272443062559E-13,
6.33763874713367E-14,
1.23466341317435E-13,
6.43200770422681E-14,
1.27239364877685E-13,
7.18956144618588E-14,
1.39281815247916E-13,
7.65785004852582E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.00787433954252E-14,
  0,
0.81688762388229,
  0,
0.450805000959554,
  0,
0.377271366210101,
1.01949698683157E-14,
0.359094015133419,
1.68207461848091E-14,
0.375597960670688,
2.91962634624277E-14,
0.447974316949199,
4.45164738405168E-14,
0.815005908958123,
5.67644889426511E-14,
3.40933878351102E-14,
6.26920390600638E-14,
4.0536150824888E-14,
6.8662089902638E-14,
4.38451358553138E-14,
7.28427734797421E-14,
5.27937069061402E-14,
8.87259016257858E-14,
5.61616725347491E-14,
9.43221195592869E-14,
6.01558733381857E-14,
1.0080998535944E-13,
6.02478136824125E-14,
1.05204907285827E-13,
6.20224357983368E-14,
1.09291915795229E-13,
5.53853837792495E-14,
1.10011826037759E-13,
5.85399784203133E-14,
1.26446596249163E-13,
6.19001377932804E-14,
1.31060093333524E-13,
6.97376184577436E-14,
1.38855940634564E-13,
7.31723709401777E-14,
1.42575187767058E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07314331032615E-14,
  0,
  0,
1.08801856413265E-14,
0.816396484427775,
1.39757996842071E-14,
0.449878280140181,
1.27354723988837E-14,
0.376355611046883,
1.6757428777936E-14,
0.358297797804972,
2.71935252094124E-14,
0.374963761560963,
3.92420471118093E-14,
0.44753225927082,
5.26956950297475E-14,
0.814845888162092,
6.09972142240345E-14,
4.12456527265626E-14,
6.68787941693338E-14,
4.53621515350555E-14,
7.25426663183981E-14,
4.8466439195316E-14,
7.87972118110325E-14,
5.02774905042358E-14,
8.59780996398385E-14,
5.56325818745762E-14,
9.84238732182341E-14,
6.24318305386673E-14,
1.04711378456912E-13,
6.42897193814385E-14,
1.08417615163336E-13,
5.51720127917044E-14,
1.07473925592405E-13,
5.26141630263766E-14,
1.20090569433184E-13,
5.69821967388862E-14,
1.33964020432309E-13,
6.72586986105728E-14,
1.42564779426202E-13,
7.09432512735475E-14,
1.42004463743461E-13,
6.39141517488895E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.23286797437672E-14,
  0,
  0,
1.19977812407246E-14,
  0,
1.81139825361498E-14,
0.816002375554015,
1.74495834448507E-14,
0.449122314319854,
1.94011473553246E-14,
0.375597960670688,
2.71596981016309E-14,
0.357631197250925,
3.7475231251527E-14,
0.374427415529464,
4.79390832586191E-14,
0.447155123619689,
5.64522387169752E-14,
0.814708280141501,
6.54190243642994E-14,
4.61800736539786E-14,
7.10646819168659E-14,
5.00164146211013E-14,
7.84424608601952E-14,
4.59727741985994E-14,
7.60381341224914E-14,
4.96833477137137E-14,
9.0127558194375E-14,
5.78391501360187E-14,
1.0230184754878E-13,
6.64312355125318E-14,
1.07880718247522E-13,
5.74167449696183E-14,
1.06505082531072E-13,
5.23366072702203E-14,
1.17477208516625E-13,
5.10719938562332E-14,
1.27491767143439E-13,
6.22644297232355E-14,
1.45329928646909E-13,
6.84226980629532E-14,
1.45595341338733E-13,
6.16607459535956E-14,
1.44368891841218E-13,
  0,
  0,
1.13511630650542E-14,
  0,
  0,
  0,
  0,
-1.09790648794572E-14,
1.32979564859692E-14,
  0,
1.94644647621978E-14,
  0,
2.19217005659189E-14,
0.815681087093769,
2.42835265784613E-14,
0.448497255790403,
2.91815183128818E-14,
0.374963761560963,
3.73624742255885E-14,
0.357067364282294,
4.57680768284341E-14,
0.373969667067663,
5.16010845164061E-14,
0.446830722338809,
6.13146686201382E-14,
0.814589064187194,
6.93438362286969E-14,
5.07397943105836E-14,
7.69341187978334E-14,
4.73961148106383E-14,
7.57276186202915E-14,
4.53101098307762E-14,
8.00652946719715E-14,
5.18630277612786E-14,
9.39526234589039E-14,
6.18359530246693E-14,
1.05399196315137E-13,
5.94775964590788E-14,
1.05938695316166E-13,
5.4603890853322E-14,
1.16472803624035E-13,
5.07805603122691E-14,
1.24825497160863E-13,
5.63160629241111E-14,
1.38798694759856E-13,
6.342669445214E-14,
1.48282428003021E-13,
5.90551912926784E-14,
1.47867829092263E-13,
5.28726368242971E-14,
  0,
1.0879101439154E-14,
  0,
1.40213361754515E-14,
  0,
1.02231591248003E-14,
  0,
1.30845854984241E-14,
  0,
2.08088754560798E-14,
  0,
2.3186313979906E-14,
  0,
2.81840523141952E-14,
0.815415573525732,
3.41549705185074E-14,
0.447974316949199,
3.93530694142719E-14,
0.374427415529464,
4.57689441901721E-14,
0.356586095090044,
4.96911539693556E-14,
0.373575797791596,
5.64062685448619E-14,
0.446549613127306,
6.51293255438112E-14,
0.814485086693892,
7.51855175340488E-14,
4.8165464672234E-14,
7.40969785528733E-14,
4.68045741053302E-14,
7.97625854254136E-14,
4.75192801774327E-14,
8.39397995555657E-14,
5.59162091628984E-14,
9.69797159244834E-14,
5.48406806077928E-14,
1.03453703936829E-13,
5.66248437028349E-14,
1.1580666980926E-13,
5.29888632971875E-14,
1.23765581117041E-13,
5.60263641036229E-14,
1.36082117796477E-13,
5.74054692670245E-14,
1.4169047879431E-13,
5.40401057236295E-14,
1.50435219836709E-13,
5.02254487999565E-14,
1.40715564200811E-13,
  0,
  0,
1.40295761119624E-14,
  0,
1.71516446878517E-14,
  0,
2.2213567790752E-14,
  0,
2.05616773607531E-14,
  0,
2.4459601011273E-14,
  0,
2.97487728895263E-14,
1.22445456551823E-14,
3.85065243579952E-14,
0.815193535651867,
4.44895856266392E-14,
0.44753225927082,
4.78063769127068E-14,
0.373969667067663,
4.96833477137137E-14,
0.356171941669506,
5.36090269398493E-14,
0.373234395807981,
5.99346960949987E-14,
0.446304385803444,
7.1055140937748E-14,
0.81439384511192,
7.2249498050958E-14,
4.7573056605188E-14,
7.81007203354278E-14,
4.90362958571744E-14,
8.35694360934447E-14,
5.15048073634894E-14,
8.69564836802894E-14,
4.89001200643102E-14,
9.50697853774329E-14,
5.19723153402651E-14,
1.13251422129146E-13,
5.49855300180369E-14,
1.23047405597987E-13,
5.81739517668822E-14,
1.34992711453563E-13,
5.70793412535409E-14,
1.38852471187612E-13,
4.80362277732738E-14,
1.4377735113591E-13,
4.51531173562003E-14,
1.43248260475737E-13,
4.26811364029334E-14,
  0,
1.10887861393127E-14,
  0,
1.75098650856409E-14,
  0,
2.92678208058117E-14,
  0,
2.98099218920544E-14,
  0,
2.43199557714568E-14,
  0,
3.11313474998798E-14,
1.151682915701E-14,
4.00313462933788E-14,
2.16398080010727E-14,
4.86078191586081E-14,
0.815005908958123,
5.26852866888916E-14,
0.447155123619689,
5.1605421325096E-14,
0.373575797791596,
5.35604546825219E-14,
0.355812923224455,
5.72345990046408E-14,
0.372936499138575,
6.60166366017734E-14,
0.446089157085829,
6.81971840110762E-14,
0.814313332428199,
7.62280863431108E-14,
4.97787575048925E-14,
8.19570106225243E-14,
5.30539154275367E-14,
8.65921917503343E-14,
4.44713710301414E-14,
8.49615516829161E-14,
4.59701721133854E-14,
1.04836278547182E-13,
5.02809599511878E-14,
1.2044185093707E-13,
6.02538852145784E-14,
1.34199942825042E-13,
5.93015220262672E-14,
1.37768269015126E-13,
4.76407108207511E-14,
1.4094454769964E-13,
3.91336268945608E-14,
1.36486308366379E-13,
3.7619213300033E-14,
1.47742929001993E-13,
  0,
  0,
1.52187290547445E-14,
  0,
2.9914872662351E-14,
  0,
3.7098362576371E-14,
  0,
3.37039424147534E-14,
  0,
3.10229272826312E-14,
  0,
4.15388209940026E-14,
2.08357636699574E-14,
5.0186417521747E-14,
2.8721816591748E-14,
5.67584174104852E-14,
0.814845888162092,
5.63533594788446E-14,
0.446830722338809,
5.64210136944077E-14,
0.373234395807981,
5.71244440639163E-14,
0.355499628826652,
6.36218508431874E-14,
0.372674988233673,
6.30389837552592E-14,
0.445899206599405,
7.19467888044001E-14,
0.814241923478251,
8.02335628491413E-14,
5.37703562231151E-14,
8.48470599335016E-14,
4.59719068368614E-14,
8.45590958364895E-14,
4.15778522722121E-14,
9.47401879169973E-14,
4.43325931520633E-14,
1.11964257309971E-13,
5.55475804242533E-14,
1.3160479650498E-13,
6.12669637245489E-14,
1.37015399026552E-13,
4.97935026544383E-14,
1.39777078800307E-13,
3.87970905402213E-14,
1.33585850714546E-13,
3.156676309235E-14,
1.40928935188356E-13,
3.3433325552501E-14,
  0,
1.19077924604083E-14,
  0,
2.7976752858816E-14,
  0,
3.80390163812194E-14,
1.09248547708329E-14,
4.10817213580827E-14,
1.13251422129146E-14,
4.04320674163294E-14,
1.39948816424429E-14,
4.15162695888149E-14,
1.92372159868448E-14,
5.16574630293754E-14,
2.79437931127724E-14,
5.85555909315971E-14,
3.40933878351102E-14,
6.09677239249429E-14,
0.814708280141501,
6.13172707053522E-14,
0.446549613127306,
5.99589822236624E-14,
0.372936499138575,
6.35923605440958E-14,
0.355224580757925,
6.05635333550403E-14,
0.37244414783286,
6.69048150214735E-14,
0.445730710580689,
7.58308346671122E-14,
0.814178290666449,
8.33430546798297E-14,
4.66432448220644E-14,
8.28503932126523E-14,
4.3010733863369E-14,
9.42995681540992E-14,
3.98743538188029E-14,
1.0186643195631E-13,
4.94864565991904E-14,
1.23101182025742E-13,
5.66005575741713E-14,
1.34376884619591E-13,
5.17814957579077E-14,
1.38994718512642E-13,
4.08943712226773E-14,
1.32404504027406E-13,
3.1192062821539E-14,
1.3805970255909E-13,
2.73565892161542E-14,
1.38954819872694E-13,
  0,
  0,
2.55416347794135E-14,
  0,
3.64539128050456E-14,
  0,
4.22444197678562E-14,
1.53089346754953E-14,
4.80110742828721E-14,
1.96249266837256E-14,
5.10442382806175E-14,
2.34274405430668E-14,
5.17407297562222E-14,
2.63426433444458E-14,
6.00890864843606E-14,
3.31939337128162E-14,
6.26573445905443E-14,
4.12734083021782E-14,
6.5445912578177E-14,
0.814589064187194,
6.5143203331619E-14,
0.446304385803444,
6.59611254505421E-14,
0.372674988233673,
6.06745556575028E-14,
0.354981775166155,
6.47086551008869E-14,
0.372239346126216,
7.07663094789979E-14,
0.445580544330695,
7.8912570922185E-14,
0.814121340684948,
8.08138278518555E-14,
4.36733982311921E-14,
9.25700488485504E-14,
4.14165229889463E-14,
1.01406730235176E-13,
4.51513826327243E-14,
1.12918355221758E-13,
5.06018837942435E-14,
1.25812554818694E-13,
4.70717215206307E-14,
1.36319774912685E-13,
4.28632823679109E-14,
1.31573571482413E-13,
3.33309768674184E-14,
1.36788150251199E-13,
2.70061750740069E-14,
1.3599017745225E-13,
2.767751305921E-14,
  0,
2.300134908928E-14,
  0,
3.46406930917809E-14,
  0,
4.10548331442051E-14,
1.24501103870855E-14,
4.93875773610597E-14,
2.36893837879393E-14,
5.87342674496227E-14,
2.91225377146986E-14,
6.13606387922516E-14,
3.0589246413637E-14,
6.02200581067969E-14,
3.15962533914416E-14,
6.43131381483641E-14,
4.05639064005037E-14,
6.69056823832115E-14,
4.62034924209043E-14,
6.93022028652734E-14,
0.814485086693892,
7.10074360421586E-14,
0.446089157085829,
6.30381163935212E-14,
0.37244414783286,
6.477197250776E-14,
0.354766345591736,
6.82032555432421E-14,
0.372056796547043,
7.37344213463942E-14,
0.44544613379654,
7.66851859790307E-14,
0.814070166440999,
9.0724303070111E-14,
4.21173512732409E-14,
9.96598636948676E-14,
4.66588573333482E-14,
1.12519368822284E-13,
4.6150583354887E-14,
1.15673096101609E-13,
4.11060074867464E-14,
1.27739832600504E-13,
3.81812637062495E-14,
1.28844851454701E-13,
3.52981532891761E-14,
1.35906910725403E-13,
2.91173335442707E-14,
1.34732502932167E-13,
2.72906697240671E-14,
1.35728234207377E-13,
1.91515640152184E-14,
  0,
3.33049560152787E-14,
  0,
3.97052182798951E-14,
  0,
4.84256731936306E-14,
2.09016831620445E-14,
6.02217928302728E-14,
3.32546490344754E-14,
6.91738333280512E-14,
3.63077623521946E-14,
6.99093560818653E-14,
3.58411217371568E-14,
6.44284972595166E-14,
3.89757670582469E-14,
6.86707635200179E-14,
4.53335285977019E-14,
7.10091707656346E-14,
5.08022443557188E-14,
7.52141404714024E-14,
0.81439384511192,
6.81971840110762E-14,
0.445899206599405,
6.69568567257528E-14,
0.372239346126215,
6.82605014179494E-14,
0.354574313081754,
7.15538739370913E-14,
0.371893378673084,
7.15972420239908E-14,
0.445325342760473,
8.63042276533221E-14,
0.814024010142987,
9.80916736725845E-14,
4.69936589642117E-14,
1.10746481429835E-13,
4.7642445544227E-14,
1.15112780418869E-13,
3.66668501117218E-14,
1.17603843330372E-13,
3.22051413315094E-14,
1.2026490914252E-13,
3.0591848498851E-14,
1.33200742102879E-13,
3.10741016251725E-14,
1.33818303660327E-13,
2.94347879403745E-14,
1.34404640195207E-13,
1.80567366614426E-14,
  0,
3.35675497814547E-14,
  0,
3.91683213640803E-14,
  0,
4.74368808123238E-14,
1.77843850757142E-14,
5.95547916537598E-14,
3.05363373476197E-14,
7.08044733954694E-14,
4.04910480145126E-14,
7.78309708349134E-14,
4.15665765696183E-14,
7.41177952345851E-14,
4.33004326838571E-14,
6.88303580798078E-14,
4.38477379405278E-14,
7.25140433810445E-14,
5.00025368332935E-14,
7.69445271386893E-14,
4.8170668842662E-14,
7.23067439256653E-14,
0.814313332428199,
7.1953727698304E-14,
0.445730710580689,
7.07784525433297E-14,
0.372056796547043,
7.15261183614757E-14,
0.354402398263282,
6.9336897334793E-14,
0.371746502005869,
8.16586381846562E-14,
0.445216386172203,
9.34079202874472E-14,
0.813982234672765,
1.08994410719099E-13,
4.82617418251508E-14,
1.13372852772464E-13,
3.7993913570844E-14,
1.17041792924155E-13,
2.77434325512971E-14,
1.10066469827252E-13,
2.46903192335779E-14,
1.24553145575135E-13,
2.63643273878955E-14,
1.3100978635272E-13,
3.13811476804204E-14,
1.33457481177324E-13,
2.01730993021343E-14,
1.29344451815783E-13,
1.96101815341798E-14,
  0,
4.10439911224803E-14,
1.26994768867572E-14,
4.74598658983805E-14,
1.69989890219657E-14,
5.88478918372992E-14,
2.75543476924156E-14,
7.03135466517679E-14,
3.7924524631805E-14,
7.9655032569903E-14,
4.58626192578748E-14,
8.21911982917811E-14,
4.90744597736459E-14,
7.86549644860024E-14,
4.81203618618586E-14,
7.28288956919343E-14,
4.8468173918792E-14,
7.84702164358109E-14,
4.74342787271098E-14,
7.40935091059214E-14,
4.7571321881712E-14,
7.61743099153556E-14,
0.814241923478251,
7.58082832619245E-14,
0.445580544330695,
7.37344213463942E-14,
0.371893378673084,
6.93681223573606E-14,
0.354247878376151,
7.92248211478608E-14,
0.371614001256457,
8.80077261067314E-14,
0.445117762906001,
1.04293310099202E-13,
0.813944301179396,
1.11660680701675E-13,
3.85438209127287E-14,
1.15232476338711E-13,
2.92318252936852E-14,
1.09546052784459E-13,
2.02147326655577E-14,
1.14365114600723E-13,
2.04228994826749E-14,
1.22410762082303E-13,
2.66661692727155E-14,
1.30624677741054E-13,
2.21177243187043E-14,
1.2831923024148E-13,
  0,
  0,
3.14297199377478E-14,
1.51042373053301E-14,
5.02254487999565E-14,
2.15053669316845E-14,
5.92989199410532E-14,
2.68465805142171E-14,
6.98781310592977E-14,
3.49997808513081E-14,
7.93280371946814E-14,
4.33490049411844E-14,
8.41098024562115E-14,
5.33982580375181E-14,
8.67578578422901E-14,
5.39429612089748E-14,
8.26855944824345E-14,
5.2805849970472E-14,
7.87842013849627E-14,
4.5926804026486E-14,
7.56989956829379E-14,
4.68323296809459E-14,
7.80781689302401E-14,
4.98082478039841E-14,
8.01919294857178E-14,
0.814178290666449,
7.88952236874252E-14,
0.445446133796539,
7.15972420239908E-14,
0.371746502005869,
7.91033905045424E-14,
0.354108477350283,
8.60405496849737E-14,
0.371494055057359,
9.93875121091392E-14,
0.445028203110038,
1.07152134387611E-13,
0.813909751392234,
1.13331219409041E-13,
2.97383645486704E-14,
1.07830411266718E-13,
2.16771045558062E-14,
1.13891535091781E-13,
1.59507823616067E-14,
1.12208853320084E-13,
2.06380051936961E-14,
1.21961468702025E-13,
1.73472347597681E-14,
1.25524590721682E-13,
  0,
1.17595169712992E-13,
1.66689578806611E-14,
1.37064838645617E-14,
4.23610799216156E-14,
2.43381703679546E-14,
6.2751019658247E-14,
3.15680641349569E-14,
7.06951858164828E-14,
3.44585471268033E-14,
7.91623711027256E-14,
4.05248751222942E-14,
8.39753613868233E-14,
5.09765840650545E-14,
8.87770759683271E-14,
5.83899248396413E-14,
9.09133879289925E-14,
5.86596743401557E-14,
8.87137585614539E-14,
5.02809599511878E-14,
7.60546139955132E-14,
4.52858237021125E-14,
7.9804218788837E-14,
4.90241527928426E-14,
8.19587453460002E-14,
5.37373964770715E-14,
8.32944824225024E-14,
0.814121340684948,
7.66817165320788E-14,
0.445325342760473,
8.17106798889355E-14,
0.371614001256457,
8.60960608362049E-14,
0.353982280458859,
9.70439006930945E-14,
0.371385122283904,
1.01972250088345E-13,
0.44494662663008,
1.08531239551013E-13,
0.813878193548037,
1.05887520973624E-13,
2.22079299394551E-14,
1.11953848969115E-13,
1.74218278692351E-14,
1.11655476531247E-13,
1.62248686708111E-14,
1.11801193303229E-13,
1.13554998737442E-14,
1.16831891383562E-13,
  0,
1.1471552874287E-13,
  0,
  0,
3.15585231558391E-14,
2.37310171513627E-14,
5.59374595254791E-14,
3.47122504351649E-14,
7.46967591946923E-14,
3.93227117534423E-14,
8.02777982977787E-14,
4.00859900828721E-14,
8.39571467903255E-14,
4.82530682077709E-14,
8.87736065213751E-14,
5.59656487819638E-14,
9.30028623558066E-14,
6.31118421412502E-14,
9.69311436671561E-14,
5.61634072582251E-14,
8.60032531302402E-14,
4.96833477137137E-14,
8.01555002927223E-14,
4.75140760070047E-14,
8.35694360934447E-14,
5.29984042763054E-14,
8.48470599335016E-14,
4.66467142690163E-14,
8.08138278518555E-14,
0.814070166440999,
8.63076971002741E-14,
0.445216386172203,
8.81256873030978E-14,
0.371494055057359,
9.70473701400465E-14,
0.35386766744916,
9.94863913472699E-14,
0.371285891747561,
1.04137184986364E-13,
0.44487210991766,
1.01451833045552E-13,
0.813849291110351,
1.09945039183934E-13,
1.79717352111197E-14,
1.09995346164737E-13,
1.76959141784394E-14,
1.11253020684821E-13,
  0,
1.06597022875299E-13,
  0,
1.06071401662078E-13,
  0,
1.0887298007578E-13,
1.97795339135221E-14,
2.10855638504981E-14,
4.69606992181681E-14,
3.47434754577325E-14,
6.86538499661271E-14,
4.28121080253696E-14,
8.47082820554235E-14,
4.51357701214405E-14,
8.5344925571107E-14,
4.79867881542084E-14,
8.89757018063264E-14,
5.33600941210466E-14,
9.30974047852473E-14,
6.07578223843497E-14,
9.91481202694544E-14,
6.06875660835726E-14,
9.4315180665383E-14,
5.56672763440957E-14,
9.00703123196678E-14,
5.18283332917591E-14,
8.39137787034261E-14,
5.1460571914852E-14,
8.65921917503343E-14,
4.59528248786256E-14,
8.28781487882679E-14,
4.37132968711396E-14,
9.0726037793587E-14,
0.814024010142987,
9.34304716926349E-14,
0.445117762906001,
9.93372051283359E-14,
0.371385122283904,
9.95072080289816E-14,
0.353763259707437,
1.01514283090687E-13,
0.371195242139411,
9.63673585374636E-14,
0.444803859496132,
1.05748743095546E-13,
0.813822753664245,
1.08066333659451E-13,
1.81625547934772E-14,
1.09363906819482E-13,
  0,
1.06069666938602E-13,
  0,
9.58053081312471E-14,
  0,
1.0019762797242E-13,
  0,
1.54292811166412E-14,
3.97628978354714E-14,
3.33197011648245E-14,
6.09269579232574E-14,
4.3305636854285E-14,
7.93037510660177E-14,
4.89018547877862E-14,
9.01769978134404E-14,
5.31840196882349E-14,
9.05586369781552E-14,
5.32057037316847E-14,
9.34348085013248E-14,
5.83196685388643E-14,
9.93623586187375E-14,
5.84506401613005E-14,
9.65894031423886E-14,
6.01558733381857E-14,
9.84247405799721E-14,
5.78669057116343E-14,
9.39560929058558E-14,
5.59110049924705E-14,
8.69582184037654E-14,
4.44713710301414E-14,
8.4590320859057E-14,
4.30246116511768E-14,
9.2599539147642E-14,
4.2110412379337E-14,
9.80916736725845E-14,
0.813982234672765,
1.04321065674817E-13,
0.445028203110038,
1.01975719535297E-13,
0.371285891747561,
1.01507344196783E-13,
0.353667878183386,
9.39942568223273E-14,
0.371112209900067,
1.00596614371895E-13,
0.444741190537575,
1.03380845550838E-13,
0.813798329518924,
1.07525099934946E-13,
  0,
1.04126776645508E-13,
  0,
9.5217236872891E-14,
-1.17302001445552E-14,
8.9907248312926E-14,
-1.53557722093467E-14,
1.04324535121769E-13,
2.61539921664333E-14,
3.11434905642116E-14,
5.58945251194487E-14,
4.27149635107149E-14,
7.24242714411627E-14,
4.97553387379668E-14,
8.53076290163735E-14,
5.71626079803877E-14,
9.57281129365661E-14,
5.85746728898329E-14,
9.52484618954585E-14,
5.82311976415895E-14,
9.98619589798189E-14,
5.60272314653609E-14,
9.69285415819421E-14,
5.79926731636426E-14,
1.00789168677728E-13,
6.24058096865276E-14,
1.0231052116616E-13,
6.18394224716212E-14,
9.69519603488678E-14,
4.89001200643102E-14,
8.49476738951083E-14,
4.15691786548322E-14,
9.43568140288065E-14,
4.14130535419943E-14,
9.96876192704832E-14,
4.69936589642117E-14,
1.08987471825195E-13,
0.813944301179396,
1.07148664940659E-13,
0.44494662663008,
1.04126776645508E-13,
0.371195242139411,
9.40636457613664E-14,
0.353580509636396,
9.80153458396416E-14,
0.371035963269736,
9.83189224479375E-14,
0.444683509453611,
1.02983593874839E-13,
0.813775799661001,
1.02248071121025E-13,
  0,
9.34148591813511E-14,
-1.03025227238263E-14,
8.9230706157295E-14,
-1.97706434557077E-14,
9.4016808227515E-14,
-1.81937798160448E-14,
2.05519195412007E-14,
4.81368417348804E-14,
4.21503110192845E-14,
6.87852552694324E-14,
4.97648797170847E-14,
7.90539508854771E-14,
5.83508935614319E-14,
9.1172729088651E-14,
6.2751019658247E-14,
1.00633910926629E-13,
6.37137911874142E-14,
1.01792706208581E-13,
5.60081495071252E-14,
9.7535694798534E-14,
5.55631929355371E-14,
1.01187287715465E-13,
6.02191907450589E-14,
1.04739134032528E-13,
6.64260313421039E-14,
1.05399196315137E-13,
5.48823139712162E-14,
9.50177436731536E-14,
4.59562943255776E-14,
9.47401879169973E-14,
3.98743538188029E-14,
1.01427546916888E-13,
4.66623267803001E-14,
1.10694439725556E-13,
4.82842932303384E-14,
1.11710987682478E-13,
0.813909751392234,
1.08576342361388E-13,
0.44487210991766,
9.62546015115251E-14,
0.371112209900067,
9.80153458396416E-14,
0.353500279371154,
9.61002111221632E-14,
0.37096578119393,
9.80188152865935E-14,
0.444630299661574,
9.81124903542963E-14,
0.813754972783333,
9.13904368848861E-14,
  0,
8.73311839511004E-14,
-1.83516396523586E-14,
9.34547578212985E-14,
-2.26745705544928E-14,
9.56786733175008E-14,
2.94393415894989E-14,
3.60965597689944E-14,
6.35698091389081E-14,
5.02037647565068E-14,
7.63048478569228E-14,
5.87611556635004E-14,
8.54351311918577E-14,
6.41786970789759E-14,
9.64367474765027E-14,
6.80453957069282E-14,
1.07387189418606E-13,
6.15809486737007E-14,
9.96164956079681E-14,
5.5649929109336E-14,
1.01912402128423E-13,
5.79137432454857E-14,
1.05220519797111E-13,
6.43105360631502E-14,
1.07866840459714E-13,
5.94498408834632E-14,
1.03413805296881E-13,
5.1984458404597E-14,
1.04824135482851E-13,
4.43239195346834E-14,
1.01934086171873E-13,
4.51236270571087E-14,
1.12526307716188E-13,
4.76146899686114E-14,
1.13371118048988E-13,
3.85143306136371E-14,
1.1338326111332E-13,
0.813878193548037,
1.01451833045552E-13,
0.444803859496132,
1.00652125523126E-13,
0.371035963269736,
9.60464346944079E-14,
0.353426429072542,
9.53091772171177E-14,
0.370901036071878,
9.31789367886182E-14,
0.444581109879959,
8.66355598372337E-14,
0.813735681175771,
8.54299270214298E-14,
-1.76091780046406E-14,
9.15326842099162E-14,
-2.11393402782534E-14,
9.51010104000005E-14,
-2.32713154302289E-14,
2.11421592039018E-14,
5.14909295756816E-14,
4.60330558393895E-14,
7.2623330960031E-14,
5.99030373915621E-14,
8.34176477892967E-14,
6.49610573666415E-14,
9.1097268617446E-14,
6.97185364995079E-14,
1.03475387980279E-13,
6.60548005182449E-14,
1.05393992144709E-13,
6.12791067888807E-14,
1.0413024609246E-13,
5.80620621026817E-14,
1.05997675914349E-13,
6.2008558010529E-14,
1.08415880439861E-13,
5.74306227574262E-14,
1.05938695316166E-13,
5.66439256610707E-14,
1.13308668003853E-13,
5.02809599511878E-14,
1.11959053139543E-13,
4.95298246860898E-14,
1.12942641350422E-13,
4.61332361201272E-14,
1.15137066547533E-13,
3.80355469342675E-14,
1.15229006891759E-13,
2.97522423364782E-14,
1.05887520973624E-13,
0.813849291110351,
1.05877112632768E-13,
0.444741190537575,
9.83189224479375E-14,
0.37096578119393,
9.52085632555111E-14,
0.353358298676567,
9.05074626356139E-14,
0.370841179566775,
8.19656842399041E-14,
0.444535544451342,
8.12058753574263E-14,
0.813717777310868,
8.95152008073552E-14,
-2.04888189747621E-14,
9.32084270877098E-14,
-2.19407825241547E-14,
9.85218850946268E-14,
3.00345685821934E-14,
3.58554332058336E-14,
6.32410790402105E-14,
5.68186990512753E-14,
8.06655089946595E-14,
6.65760849227759E-14,
8.95143334456172E-14,
7.0832228971085E-14,
9.84498940703737E-14,
6.78858011471384E-14,
1.01713776290424E-13,
6.58761240002192E-14,
1.10060398295087E-13,
6.37207300813181E-14,
1.08320470648682E-13,
6.22566234675936E-14,
1.09260690772661E-13,
5.51702780682284E-14,
1.06531103383212E-13,
5.46108297472259E-14,
1.15792792021452E-13,
5.49681827832771E-14,
1.20485219023969E-13,
5.55302331894936E-14,
1.23102916749218E-13,
5.05845365594837E-14,
1.15634932185138E-13,
3.66772584525776E-14,
1.17024445689395E-13,
2.92144780589254E-14,
1.07823472372814E-13,
2.21524187882238E-14,
1.09889528032703E-13,
0.813822753664245,
1.03377376103886E-13,
0.444683509453611,
9.80725917143488E-14,
0.370901036071878,
9.05074626356139E-14,
0.353295311457536,
7.94971727335891E-14,
0.370785730871212,
7.56079227004491E-14,
0.444493255300489,
8.47117515023754E-14,
0.813701130993353,
9.15066633577766E-14,
-2.13370987545147E-14,
9.64697072225462E-14,
-3.48124307159026E-14,
2.02656901676646E-14,
4.84803169831238E-14,
4.86208295846779E-14,
7.28046095632706E-14,
6.42975256370804E-14,
8.74977174047942E-14,
7.28228241597684E-14,
9.72806904475654E-14,
6.92406201818763E-14,
9.68895103037326E-14,
6.78537087628328E-14,
1.06489470019788E-13,
6.84513210003068E-14,
1.14410217411098E-13,
6.80436609834523E-14,
1.11705783512051E-13,
5.53715059914417E-14,
1.07487803380213E-13,
5.23227294824125E-14,
1.16479742517939E-13,
5.29767202328557E-14,
1.23059548662319E-13,
6.02295990859147E-14,
1.31610000675408E-13,
5.66283131497869E-14,
1.25809085371742E-13,
4.11060074867464E-14,
1.17603843330372E-13,
2.77399631043451E-14,
1.09573808360075E-13,
2.16771045558062E-14,
1.11981604544731E-13,
1.79717352111197E-14,
1.0803684336036E-13,
0.813798329518924,
1.03000941109599E-13,
0.444630299661574,
9.31789367886182E-14,
0.370841179566775,
7.94815602223053E-14,
0.353236961694531,
7.3448191972858E-14,
0.370734266953333,
8.01234079084168E-14,
0.444453935219034,
8.691311559339E-14,
0.813685626969083,
9.45875322511114E-14,
-3.41532357950314E-14,
9.14841119525889E-14,
2.59618715414689E-14,
3.77944203711067E-14,
6.06715198914198E-14,
5.73287077532125E-14,
8.06724478885634E-14,
7.11366729411189E-14,
9.57975018756052E-14,
7.15989767474667E-14,
9.60793944404514E-14,
6.93663876338846E-14,
1.01921943107541E-13,
7.05451322358108E-14,
1.11021435100778E-13,
7.27803234346069E-14,
1.17868388660458E-13,
6.12452796810992E-14,
1.10001417696903E-13,
5.26141630263766E-14,
1.17463330728818E-13,
5.07805603122691E-14,
1.23751703329233E-13,
5.81843601077381E-14,
1.34227698400657E-13,
6.12652290010729E-14,
1.34373415172639E-13,
4.70855993084385E-14,
1.27739832600504E-13,
3.22190191193172E-14,
1.10090755955916E-13,
2.02112632186058E-14,
1.13888065644829E-13,
1.74062153579513E-14,
1.09951978077838E-13,
1.82475562438E-14,
1.07533773552326E-13,
0.813775799661001,
9.81055514603923E-14,
0.444581109879959,
8.20107870502795E-14,
0.370785730871212,
7.33423738408234E-14,
0.353182804418927,
7.76618352960057E-14,
0.370686414410258,
8.17644563166908E-14,
0.444417312231848,
9.01206193004711E-14,
0.81367116291075,
8.9532548042115E-14,
-3.7921055184853E-14,
2.33613042105452E-14,
4.41586871235966E-14,
4.85098072822154E-14,
7.00008627452231E-14,
6.49766698779253E-14,
8.96721932819311E-14,
7.03178834604579E-14,
9.499345754449E-14,
7.19875548060855E-14,
1.01388515638678E-13,
7.22026605171067E-14,
1.0663952360046E-13,
7.49842896108355E-14,
1.14657415506425E-13,
6.60799540086465E-14,
1.16288055573843E-13,
5.85191617386016E-14,
1.20104447220992E-13,
5.10581160684254E-14,
1.24844579119099E-13,
5.60263641036229E-14,
1.34978833665755E-13,
5.92876442384593E-14,
1.37013664303076E-13,
5.18127207804753E-14,
1.36319774912685E-13,
3.81951414940573E-14,
1.2026490914252E-13,
2.47041970213857E-14,
1.14326950684251E-13,
1.59091489981833E-14,
1.11653741807771E-13,
1.77097919662472E-14,
1.09396866565525E-13,
  0,
1.02246336397549E-13,
0.813754972783333,
8.65765792390505E-14,
0.444535544451342,
7.56669032986323E-14,
0.370734266953333,
7.76063241447744E-14,
0.353132446850746,
7.95353366500606E-14,
0.37064184263249,
8.50899212201384E-14,
0.444383144850341,
8.52564546738321E-14,
0.813657647713907,
8.51662490530813E-14,
2.50262050666139E-14,
3.92880172839227E-14,
5.59409289724311E-14,
5.73621011801251E-14,
8.00236613085481E-14,
6.47181960800047E-14,
8.94484139535301E-14,
7.09770783813291E-14,
1.00638247735318E-13,
7.49877590577874E-14,
1.06334212268688E-13,
7.67537075563318E-14,
1.10429027033732E-13,
6.83446355065342E-14,
1.13202849871819E-13,
6.33902652591445E-14,
1.26425779567452E-13,
5.69769925684582E-14,
1.27472685185204E-13,
5.63299407119189E-14,
1.36064770561717E-13,
5.70914843178727E-14,
1.3778388152641E-13,
4.97882984840103E-14,
1.3899124906569E-13,
4.28632823679109E-14,
1.28889954265077E-13,
3.06057262866588E-14,
1.24551410851659E-13,
2.03951439070593E-14,
1.12212322767036E-13,
1.61832353073876E-14,
1.11263429025676E-13,
  0,
1.04102490516844E-13,
  0,
9.13921716083621E-14,
0.813735681175771,
8.10879141610599E-14,
0.444493255300489,
8.0178919059648E-14,
0.370686414410258,
7.95301324796327E-14,
0.353085541212644,
8.27862084440412E-14,
0.370600258043443,
7.98701382809242E-14,
0.44435121805642,
8.06004568643104E-14,
0.813645000049659,
2.20121230271042E-14,
4.24877147353619E-14,
5.02176425443146E-14,
6.73692872321663E-14,
5.78504258386126E-14,
8.05041797113937E-14,
6.57546933569009E-14,
9.55069356933791E-14,
7.42244807283576E-14,
1.05864102206699E-13,
7.97044721889684E-14,
1.10315402646055E-13,
7.0235484095349E-14,
1.09121912894583E-13,
6.57590301655908E-14,
1.23445524635724E-13,
6.19036072402324E-14,
1.33957081538405E-13,
6.22713686171394E-14,
1.38784816972048E-13,
5.74054692670245E-14,
1.38866348975419E-13,
4.76268330329432E-14,
1.39744119054264E-13,
4.0915187904389E-14,
1.31589183993697E-13,
3.52842755013683E-14,
1.33172986527264E-13,
2.63625926644195E-14,
1.22409027358827E-13,
2.06102496180804E-14,
1.11761294663282E-13,
  0,
1.06041911362986E-13,
  0,
9.34148591813511E-14,
  0,
8.54837034491851E-14,
0.813717777310868,
8.47152209493274E-14,
0.444453935219034,
8.17367007410752E-14,
0.37064184263249,
8.27567181449496E-14,
0.353041778673771,
7.75421393761633E-14,
0.370561399224881,
7.53060808156292E-14,
0.444321339891054,
9.08838976299009E-14,
2.40415326535626E-14,
3.79878420386781E-14,
5.62705264328667E-14,
5.18812423577764E-14,
6.87731122051005E-14,
5.94073401583017E-14,
8.70969962818435E-14,
6.93022028652734E-14,
1.01072795966051E-13,
7.91476259531798E-14,
1.10105501105462E-13,
7.33371696703955E-14,
1.09153137917151E-13,
6.77279413108245E-14,
1.19529386388706E-13,
6.43200770422681E-14,
1.3105315443962E-13,
6.7241351375813E-14,
1.45326459199957E-13,
6.34197555582361E-14,
1.4167313155955E-13,
4.802061526199E-14,
1.40930669911832E-13,
3.88092336045531E-14,
1.32418381815214E-13,
3.33517935491301E-14,
1.35906910725403E-13,
3.10723669016966E-14,
1.3103580720486E-13,
2.66817817839993E-14,
1.22013510406305E-13,
1.13867248963118E-14,
1.06583145087491E-13,
  0,
9.52710133006462E-14,
-1.03302782994419E-14,
8.7360674250192E-14,
-1.76091780046406E-14,
8.95152008073552E-14,
0.813701130993353,
8.69269933811978E-14,
0.444417312231848,
8.511941151923E-14,
0.370600258043443,
7.75438740996393E-14,
0.353000884224714,
7.30665528081431E-14,
0.370525032775587,
8.59971815980742E-14,
0.444293338545629,
2.18440716903689E-14,
4.33915056663459E-14,
4.16706599781769E-14,
5.90096548014341E-14,
5.41814856869216E-14,
7.59644083747624E-14,
6.3352968704411E-14,
9.30731186565836E-14,
7.44595357593525E-14,
1.05589148535756E-13,
7.29008867161873E-14,
1.09130586511963E-13,
7.09224345918358E-14,
1.19701124012828E-13,
6.64321028742698E-14,
1.27232425983781E-13,
6.97584351394553E-14,
1.42550901638394E-13,
6.84279022333811E-14,
1.48310183578637E-13,
5.40574529583893E-14,
1.43775616412434E-13,
3.91353616180368E-14,
1.33591054884974E-13,
3.1192062821539E-14,
1.36808966932911E-13,
2.91173335442707E-14,
1.33826977277707E-13,
3.14036990856081E-14,
1.30636820805385E-13,
1.73472347597681E-14,
1.16818013595754E-13,
  0,
9.57862261730114E-14,
-1.17371390384591E-14,
8.92584617329106E-14,
-1.83551090993106E-14,
9.15292147629643E-14,
-2.04888189747621E-14,
9.14910508464928E-14,
0.813685626969083,
9.01379665352309E-14,
0.444383144850341,
7.99776911364347E-14,
0.370561399224881,
7.31741056636537E-14,
0.352962612323139,
8.31348878627125E-14,
0.370490949779892,
8.48054265700782E-14,
2.60587992156891E-14,
3.02674552088433E-14,
4.8395315532801E-14,
4.49631651355809E-14,
6.70479297082416E-14,
5.85816117837368E-14,
8.2427120684514E-14,
6.87921941633363E-14,
9.79121297928209E-14,
6.84140244455733E-14,
1.04870105654964E-13,
7.05945718548762E-14,
1.1985551440219E-13,
6.96682295187045E-14,
1.27571564423334E-13,
7.1878267227099E-14,
1.38838593399804E-13,
7.09467207204995E-14,
1.45598810785685E-13,
5.90534565692025E-14,
1.50449097624517E-13,
4.51808729318159E-14,
1.36496716707235E-13,
3.15789061566818E-14,
1.38045824771282E-13,
2.69940320096751E-14,
1.34732502932167E-13,
2.94347879403745E-14,
1.33473093688607E-13,
2.20917034665646E-14,
1.25526325445158E-13,
  0,
1.06067932215126E-13,
  0,
8.98777580138344E-14,
-1.98001337547993E-14,
9.34547578212985E-14,
-2.11480138956333E-14,
9.32465910041813E-14,
-2.13613848831784E-14,
9.45875322511114E-14,
0.81367116291075,
8.52564546738321E-14,
0.44435121805642,
7.52783252400135E-14,
0.370525032775587,
8.31348878627125E-14,
0.35292674318046,
8.24305901314659E-14,
0.370458962785385,
1.30828507749481E-14,
3.66629469839008E-14,
3.51932025188795E-14,
5.76223097015216E-14,
4.99938632159136E-14,
7.41169278728471E-14,
6.44180889186607E-14,
8.76729244758678E-14,
6.30103608179056E-14,
9.74480912629971E-14,
6.62603652501481E-14,
1.15778046871906E-13,
6.94739404893951E-14,
1.27853456988181E-13,
7.52349571531141E-14,
1.3930610137658E-13,
7.31584931523699E-14,
1.41995790126082E-13,
6.16815626353073E-14,
1.47874767986167E-13,
5.02393265877643E-14,
1.43263872987021E-13,
3.76348258113168E-14,
1.40946282423116E-13,
2.73583239396302E-14,
1.36012728857438E-13,
2.73045475118749E-14,
1.34401170748255E-13,
2.02112632186058E-14,
1.28353924711E-13,
  0,
1.14736345424582E-13,
  0,
1.00211505760228E-13,
-1.53557722093467E-14,
9.40480332500826E-14,
-2.26867136188247E-14,
9.50784589948128E-14,
-2.19199658424429E-14,
9.64905239042579E-14,
-3.41497663480794E-14,
8.9532548042115E-14,
0.813657647713907,
8.06073957582143E-14,
0.444321339891054,
8.60544274727815E-14,
0.370490949779892,
8.24878360061732E-14,
0.352893079583776,
7.75837727395867E-14,
1.62873187159462E-14,
2.11939840677466E-14,
4.79247717899423E-14,
4.11333293814931E-14,
6.55265772198099E-14,
5.63134608388971E-14,
7.98562604931163E-14,
5.88921272859366E-14,
8.7582718855117E-14,
6.10058878414144E-14,
1.08598026404838E-13,
6.52412152080117E-14,
1.23972013210683E-13,
7.51386800001974E-14,
1.39765803097713E-13,
7.65750310383062E-14,
1.42564779426202E-13,
6.39193559193174E-14,
1.44367157117742E-13,
5.28709021008211E-14,
1.40701686413003E-13,
4.26811364029334E-14,
1.47744663725469E-13,
3.34454686168328E-14,
1.3895655459617E-13,
2.767751305921E-14,
1.35742111995185E-13,
1.80671450022984E-14,
1.29328839304499E-13,
  0,
1.1759170026604E-13,
  0,
1.0887298007578E-13,
  0,
1.04336678186101E-13,
-1.82250048386123E-14,
9.57203066809242E-14,
-2.32713154302289E-14,
9.84733128372994E-14,
-3.48124307159026E-14,
9.14841119525889E-14,
-3.7921055184853E-14,
8.51662490530813E-14,
0.813645000049659,
9.09012448646607E-14,
0.444293338545629,
8.48626724447854E-14,
0.370458962785385,
7.76080588682504E-14,
0.352861444166513,
  0,
-1.090132758369E-14,
-1.07185853075176E-14,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
  0,
  0,
-1.07640675886533E-14,
  0,
-1.01107273595136E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.31353261600964E-14,
  0,
1.77512084892362E-14,
  0,
1.83859004410092E-14,
1.14524275479644E-14,
2.01746171851758E-14,
1.65366852156179E-14,
2.78947871745761E-14,
2.03151297867299E-14,
2.875759526344E-14,
1.91402883126246E-14,
3.01657570450642E-14,
1.87569144244337E-14,
3.21387881585533E-14,
2.58042285455895E-14,
2.62071180728851E-14,
1.82406173498961E-14,
2.14082224170298E-14,
2.0865253969049E-14,
2.46328565184362E-14,
1.78802285477619E-14,
2.23360826362429E-14,
1.90104008923608E-14,
-1.090132758369E-14,
-1.73932049318815E-14,
-1.75466195392882E-14,
-1.69062897362182E-14,
-1.07173384750192E-14,
-1.22955031572891E-14,
0.868243142124454,
  0,
0.867721831274621,
  0,
  0,
-1.41507899148463E-14,
-1.41156617644578E-14,
-1.80690965662089E-14,
-1.50302947171665E-14,
-1.04991969979151E-14,
  0,
  0,
  0,
1.12394902412882E-14,
  0,
1.3354551839373E-14,
  0,
1.41356110844315E-14,
  0,
1.94382270696236E-14,
  0,
2.6778492617785E-14,
  0,
3.13260702100582E-14,
1.24809017287841E-14,
3.33986310829815E-14,
2.42648783010946E-14,
4.16134141034696E-14,
3.18924574249646E-14,
4.90449694745543E-14,
3.41692819871842E-14,
5.10386004293206E-14,
3.2831810187206E-14,
5.39585737202586E-14,
3.86001994256979E-14,
5.05307601317284E-14,
3.81218494271973E-14,
4.12339433430997E-14,
3.38622359319363E-14,
3.98817263935758E-14,
3.35525877914744E-14,
4.06931432994639E-14,
3.19549074700998E-14,
4.10665425276679E-14,
-1.07185853075176E-14,
-1.76053832970369E-14,
-2.19217005659189E-14,
-1.78690612653853E-14,
-1.87042221988509E-14,
0.843607101939139,
-1.49806382576667E-14,
0.566605460361932,
-1.20146947946154E-14,
0.841467615076606,
-1.69304674446646E-14,
-1.31437829370418E-14,
-1.91385535891486E-14,
-1.83431828754133E-14,
-1.63740548897451E-14,
-1.05130747857229E-14,
  0,
  0,
  0,
  0,
1.43210096559265E-14,
  0,
1.88091729691475E-14,
  0,
2.20982086795996E-14,
  0,
3.0066660966499E-14,
  0,
3.63840901851376E-14,
1.38712825947795E-14,
4.21021724428261E-14,
2.27894959847763E-14,
5.00975129436032E-14,
3.58970665692571E-14,
5.6620940575014E-14,
4.12660357274053E-14,
6.47685030608081E-14,
4.34717366271098E-14,
6.79590932139984E-14,
4.81416122244394E-14,
6.52342763141078E-14,
4.54532245175443E-14,
5.95586947815807E-14,
4.93338009333044E-14,
5.46177686411298E-14,
4.1961226160403E-14,
5.04795857891871E-14,
4.34366084767213E-14,
5.41676078991138E-14,
3.94380708645947E-14,
  0,
-1.69199506835915E-14,
-1.79198019270577E-14,
-2.35965760819745E-14,
0.83599831423911,
-2.12874422950149E-14,
0.510646834705225,
-1.78349088969521E-14,
0.507111865102914,
-1.94017978766281E-14,
0.830737329102076,
-2.13232209667069E-14,
-1.67500562031631E-14,
-1.66897745623729E-14,
-1.30459879010836E-14,
-1.12275640173909E-14,
  0,
  0,
  0,
1.05896194591004E-14,
  0,
1.90663457244611E-14,
  0,
2.59649073075519E-14,
  0,
3.16209732009742E-14,
  0,
3.8294888093926E-14,
  0,
4.55291186696183E-14,
2.33914450309403E-14,
5.69080373102882E-14,
3.31163048372662E-14,
6.28429600024738E-14,
4.35792894826204E-14,
6.9710730243866E-14,
4.88155522948563E-14,
7.88956573682942E-14,
5.69522727589256E-14,
7.63816093707348E-14,
5.30192209580171E-14,
7.15907368109558E-14,
5.46489936636974E-14,
7.05885003227102E-14,
5.55332689555765E-14,
6.30159986692025E-14,
5.00211851106602E-14,
6.17531199786914E-14,
4.92071661195581E-14,
6.34345007077819E-14,
  0,
-1.0679716659634E-14,
-1.87597333500822E-14,
0.83599831423911,
-2.52582243315258E-14,
0.493166751957507,
-2.3262641812849E-14,
0.441923401675706,
-2.40306906318377E-14,
0.482456099532277,
-2.31763393199191E-14,
0.825074431946707,
-1.81890093264858E-14,
-1.09647534107804E-14,
-1.11824612070155E-14,
  0,
  0,
  0,
  0,
  0,
1.50214042593522E-14,
  0,
2.57680161930285E-14,
  0,
3.49022026557844E-14,
  0,
3.91041365954692E-14,
  0,
4.65382940517678E-14,
1.88815976742696E-14,
5.92733327697825E-14,
3.31700812650215E-14,
6.84266011907742E-14,
4.00048917603701E-14,
7.45753285513739E-14,
5.00949108583892E-14,
8.2271862933414E-14,
6.11333900168987E-14,
8.57204932036559E-14,
6.05886868454419E-14,
8.11781197818107E-14,
6.10570621839557E-14,
8.11390885036012E-14,
5.96502014449385E-14,
7.75777012074208E-14,
6.24760659873047E-14,
7.2997163869104E-14,
5.47079742618806E-14,
6.97003219030101E-14,
5.27130422645072E-14,
  0,
-1.2323800833991E-14,
0.843607101939139,
-2.12323648246526E-14,
0.493166751957507,
-2.73808753448179E-14,
0.421137950100819,
-2.91793499085369E-14,
0.412791146261775,
-2.72464342754297E-14,
0.469319537472725,
-1.97194691131664E-14,
0.821652244094977,
-1.26669508215826E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
2.14711061430339E-14,
  0,
3.43635710164936E-14,
  0,
4.20228088438002E-14,
1.1966556218157E-14,
4.68648557461204E-14,
1.83000316289483E-14,
5.96606097857943E-14,
2.8344514235723E-14,
6.99865512765463E-14,
3.95820529131008E-14,
7.92655871495462E-14,
4.59545596021016E-14,
8.61533067109121E-14,
6.17873807673419E-14,
8.80406858527749E-14,
6.40780831173693E-14,
8.94622917413379E-14,
6.78927400410423E-14,
8.97172960923065E-14,
6.53374923609285E-14,
8.71698546678346E-14,
6.58483684246036E-14,
8.66537744337315E-14,
6.64546542794575E-14,
8.00895808006352E-14,
5.75355735277228E-14,
7.79749528834195E-14,
  0,
0.868243142124454,
-1.51185487740069E-14,
0.510646834705225,
-2.3299721527148E-14,
0.421137950100819,
-3.35287353436797E-14,
0.390304106547417,
-3.27233899699575E-14,
0.397064394625028,
-2.41486518282041E-14,
0.461330300895665,
-1.37671991862209E-14,
0.819400604425264,
  0,
  0,
  0,
-1.07591886788772E-14,
  0,
-1.09777638368502E-14,
1.30980296053629E-14,
  0,
2.98081871685785E-14,
  0,
4.10973338693665E-14,
1.53089346754953E-14,
4.94014551488675E-14,
2.08878053742367E-14,
5.9538311780738E-14,
2.75361330959178E-14,
6.98390997810883E-14,
3.44594144885413E-14,
8.02595837012809E-14,
4.51427090153445E-14,
9.01761304517024E-14,
5.71504649160559E-14,
9.11926784086248E-14,
6.41847686111419E-14,
9.10842581913762E-14,
7.07992692250414E-14,
9.72746189153995E-14,
7.16067830031086E-14,
9.50073353322978E-14,
7.0977945743067E-14,
9.54947926290473E-14,
6.92874577157276E-14,
9.3045363080968E-14,
6.87991330572402E-14,
8.76781286462958E-14,
5.88964640946266E-14,
0.999999999999997,
  0,
0.566605460361932,
-1.76679417623893E-14,
0.441923401675706,
-2.92409325919341E-14,
0.390304106547417,
-3.72835443074315E-14,
0.373558655002243,
-2.94924674959507E-14,
0.387419510175028,
-1.82753118194157E-14,
0.456050612464657,
  0,
0.817829365003636,
  0,
  0,
  0,
-1.31158105209916E-14,
  0,
  0,
2.1243423686812E-14,
  0,
3.63467936304041E-14,
1.49645920655139E-14,
4.82487313990809E-14,
2.41083195073877E-14,
6.18420245568352E-14,
3.00193897517786E-14,
6.93880716773343E-14,
3.35018471298021E-14,
7.96879923159466E-14,
3.98153732206197E-14,
9.06297606406703E-14,
5.61157023626357E-14,
9.47028913622638E-14,
5.9239071981132E-14,
9.37080274487911E-14,
7.0534723894955E-14,
9.83371370444353E-14,
7.40796313181136E-14,
1.01979188982249E-13,
7.6887281263982E-14,
1.02833540294167E-13,
7.40137118260265E-14,
1.01352086445683E-13,
7.12234091149178E-14,
1.00136045289023E-13,
6.97688434803112E-14,
8.93304527571637E-14,
  0,
0.867721831274621,
-1.19990822833316E-14,
0.507111865102913,
-2.40315579935757E-14,
0.412791146261775,
-3.27238236508265E-14,
0.373558655002243,
-3.34944745550292E-14,
0.363248405391263,
-2.32890963458576E-14,
0.381009331574224,
-1.21807945674401E-14,
0.452354695060273,
  0,
0.816684318697262,
  0,
-1.08537311083179E-14,
  0,
  0,
1.59802726606983E-14,
  0,
2.7674043612258E-14,
  0,
4.32761465551934E-14,
2.36798428088214E-14,
6.0435163817818E-14,
3.31210753268252E-14,
7.13439723964981E-14,
3.58419890988948E-14,
7.88908868787352E-14,
3.86817314290688E-14,
8.97034183044987E-14,
5.0487392044829E-14,
9.47696782160889E-14,
5.7892926563774E-14,
9.68019067681958E-14,
6.5296726359243E-14,
1.00583603945825E-13,
7.34759475484736E-14,
1.02606291518814E-13,
7.90235932246475E-14,
1.09353498478626E-13,
7.95925825247679E-14,
1.08210315707957E-13,
7.56304741056368E-14,
1.07992607911722E-13,
7.18669915245052E-14,
1.0130177946488E-13,
6.42368103154212E-14,
  0,
  0,
0.841467615076606,
-1.94024483979316E-14,
0.482456099532277,
-2.7301945426661E-14,
0.397064394625028,
-2.94356553021125E-14,
0.363248405391263,
-2.77260853165373E-14,
0.356377212108753,
-1.7128225920926E-14,
0.376503821482069,
  0,
0.449654968168671,
  0,
0.815821477053102,
  0,
  0,
1.60357838119296E-14,
  0,
2.21940521516473E-14,
  0,
3.45019152137027E-14,
1.54347021275036E-14,
5.53532913949439E-14,
3.25815763257964E-14,
6.97879254385469E-14,
3.88378565419067E-14,
8.05969874173584E-14,
4.09082490104851E-14,
8.86877377093143E-14,
4.92210439073659E-14,
9.3566647485499E-14,
5.21570633904567E-14,
9.65555760346071E-14,
6.37380773160778E-14,
1.03351355251746E-13,
6.7989884555697E-14,
1.04477190787655E-13,
7.81172002084496E-14,
1.09618043808712E-13,
8.14938394544384E-14,
1.14412819496312E-13,
8.0929186963008E-14,
1.14489147329255E-13,
7.60311952285875E-14,
1.08845224500165E-13,
6.61302609894499E-14,
1.09418550608975E-13,
  0,
  0,
-1.69302506042301E-14,
0.830737329102076,
-2.32327178328884E-14,
0.469319537472725,
-2.41195952099815E-14,
0.387419510175028,
-2.33437401353509E-14,
0.356377212108753,
-2.15829958072344E-14,
0.351538093988781,
-1.46952762458685E-14,
0.373202849064463,
  0,
0.447616972799634,
  0,
0.81515371346584,
1.4437236128817E-14,
  0,
2.21307347447741E-14,
  0,
2.89386570262451E-14,
1.09565134742695E-14,
4.63431376607204E-14,
2.43303641123127E-14,
6.45672751375947E-14,
3.82385095809568E-14,
7.88535903240017E-14,
4.38260538970781E-14,
9.01440380673968E-14,
5.13721010175772E-14,
9.22465229202807E-14,
5.07007630323741E-14,
9.50585096748391E-14,
5.78816508611801E-14,
1.02837009741119E-13,
6.63210805718073E-14,
1.07020295403437E-13,
7.24463891654814E-14,
1.11208785236183E-13,
8.0402698388049E-14,
1.14384196558959E-13,
8.26751861415786E-14,
1.20401084935384E-13,
8.1154701014885E-14,
1.15044258841568E-13,
7.01088492816027E-14,
1.16613316225589E-13,
6.50347831143705E-14,
  0,
-1.41516572765843E-14,
-1.31435660966073E-14,
-2.13227872858379E-14,
0.825074431946707,
-1.97207701557733E-14,
0.461330300895665,
-1.82701076489877E-14,
0.381009331574224,
-1.71212870270221E-14,
0.351538093988781,
-1.87267736040386E-14,
0.347987455075766,
-1.02162202308964E-14,
0.370705297905708,
  0,
0.446037545682645,
1.32125213547774E-14,
0.814625522289951,
2.10820944035461E-14,
  0,
2.89360549410311E-14,
  0,
4.07000821933678E-14,
1.97220711983803E-14,
5.54148740783411E-14,
2.99222452371239E-14,
7.34117627798625E-14,
4.31295624214734E-14,
8.8260128372486E-14,
5.42326600294629E-14,
9.35649127620231E-14,
5.27139096262452E-14,
9.35883315289487E-14,
5.6321267094539E-14,
1.01156930054636E-13,
6.03206720684035E-14,
1.06295180990479E-13,
7.06656955173912E-14,
1.13489079245355E-13,
7.45601497209591E-14,
1.15714729465033E-13,
8.14053685571636E-14,
1.20088834709708E-13,
8.26630430772468E-14,
1.20673436521113E-13,
7.50415354855427E-14,
1.22593775409019E-13,
6.88737261667072E-14,
1.25824697883026E-13,
-1.07640675886533E-14,
-1.41115417962023E-14,
-1.91316146952447E-14,
-1.67249027127614E-14,
-1.81361002604685E-14,
0.821652244094977,
-1.37789085696838E-14,
0.456050612464657,
-1.21799272057022E-14,
0.376503821482069,
-1.46397650946373E-14,
0.347987455075766,
-1.41605477343987E-14,
0.345297955355882,
  0,
0.368766282325613,
  0,
0.444786857841308,
1.91990520703733E-14,
0.814200048945812,
2.74459274751671E-14,
1.09487072186276E-14,
4.0615080743045E-14,
1.74365730187809E-14,
4.97492672058009E-14,
2.52289508728687E-14,
6.43018624457703E-14,
3.47187556481998E-14,
8.27497792510457E-14,
5.34164726340158E-14,
9.15335515716542E-14,
5.54617116121925E-14,
9.47427900022113E-14,
5.82251261094235E-14,
9.95089427524576E-14,
5.86457965523479E-14,
1.0443208797728E-13,
6.45004882837696E-14,
1.12583553590895E-13,
7.25912385757255E-14,
1.17768642060589E-13,
7.54249093737336E-14,
1.21212935522141E-13,
8.12848052755832E-14,
1.20147815307892E-13,
7.6443192054132E-14,
1.27964479290643E-13,
7.37144720264205E-14,
1.31572704120675E-13,
6.8738417735581E-14,
  0,
-1.80818901518442E-14,
-1.83136925763216E-14,
-1.66932440093248E-14,
-1.10202645620117E-14,
-1.26647824172377E-14,
0.819400604425264,
  0,
0.452354695060273,
  0,
0.373202849064463,
-1.02110160604685E-14,
0.345297955355882,
  0,
0.343208060732594,
  0,
0.36722868407724,
1.5182299861749E-14,
0.443778490025566,
2.57762561295394E-14,
0.81385197558937,
3.91691887258183E-14,
1.98530428208166E-14,
4.95853358373211E-14,
2.303365831402E-14,
5.85781423367848E-14,
3.00618904769401E-14,
7.34785496336876E-14,
4.49666345825328E-14,
8.5941670446843E-14,
5.45518491490427E-14,
9.25873960833101E-14,
6.08783856659301E-14,
1.00478653175529E-13,
6.04594499464817E-14,
1.02617567221408E-13,
6.27735710634347E-14,
1.10579080614404E-13,
6.63991431282263E-14,
1.16741685762811E-13,
7.33892113746748E-14,
1.23088171599672E-13,
7.52202120035683E-14,
1.21086300708395E-13,
7.49227069274383E-14,
1.27276661432418E-13,
7.50319945064248E-14,
1.3674911897299E-13,
7.3521050358849E-14,
1.36679730033951E-13,
-1.01107273595136E-14,
-1.503094523847E-14,
-1.64104840827406E-14,
-1.30477226245596E-14,
-1.11547056313999E-14,
  0,
  0,
0.817829365003636,
  0,
0.449654968168671,
  0,
0.370705297905708,
  0,
0.343208060732594,
  0,
0.341549642247267,
1.02860428508045E-14,
0.365987581520815,
2.16805740027581E-14,
0.442952953483213,
3.78126349676045E-14,
0.813563406287824,
4.81784750983039E-14,
2.528012521541E-14,
5.83092601980084E-14,
2.77850659147205E-14,
6.76837058621871E-14,
4.02707381330636E-14,
7.65654900591883E-14,
4.61132868001535E-14,
8.68497981865168E-14,
5.99789315436361E-14,
9.82564724028023E-14,
6.30077587326916E-14,
1.03532633854986E-13,
6.45117639863635E-14,
1.0860149585179E-13,
6.45559994350009E-14,
1.14555066821342E-13,
6.70444602612896E-14,
1.21879936698654E-13,
7.30917062985448E-14,
1.22838371419132E-13,
6.87574996938167E-14,
1.28063358528774E-13,
7.33952829068407E-14,
1.35894767661071E-13,
7.47266831746529E-14,
1.4166445794217E-13,
7.78925535183106E-14,
  0,
-1.0472525624472E-14,
-1.04991969979151E-14,
-1.12275640173909E-14,
  0,
  0,
  0,
  0,
0.816684318697262,
  0,
0.447616972799634,
  0,
0.368766282325613,
  0,
0.341549642247267,
  0,
0.340210246534238,
1.66897745623729E-14,
0.364970558847638,
3.37377695225349E-14,
0.442268127097388,
4.68843713852252E-14,
0.813321380138789,
5.68217348173583E-14,
2.99664806857614E-14,
6.73705882747733E-14,
3.80407511046954E-14,
7.06466135591555E-14,
4.13150416656016E-14,
7.74311170737008E-14,
5.13668968471492E-14,
9.24581591843499E-14,
6.20007517548871E-14,
1.0114652171378E-13,
6.70271130265299E-14,
1.09436765205473E-13,
6.62386812066984E-14,
1.1248207226755E-13,
6.51718262689727E-14,
1.19632602435527E-13,
6.66801683313345E-14,
1.21500032257416E-13,
6.65717481140859E-14,
1.29693131234454E-13,
6.71199207324946E-14,
1.36543554241086E-13,
7.3002368039532E-14,
1.40663522496531E-13,
7.90079807133637E-14,
1.50412668431521E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.815821477053102,
  0,
0.446037545682645,
  0,
0.36722868407724,
1.03779831950312E-14,
0.340210246534238,
1.27354723988837E-14,
0.339112157727228,
2.85136497746308E-14,
0.364126230020177,
4.22691395773889E-14,
0.441693461741773,
5.52335954751015E-14,
0.813116311495751,
6.56913759500277E-14,
4.01718588949329E-14,
7.02580355005367E-14,
3.9118014383277E-14,
7.15200468293098E-14,
4.6673602482894E-14,
8.29371293864511E-14,
5.34346872305136E-14,
9.52658091302183E-14,
6.59515844714242E-14,
1.06963916890468E-13,
6.87184684156072E-14,
1.13175961657941E-13,
6.67625676964434E-14,
1.17448585579272E-13,
6.47207981652187E-14,
1.19097440243188E-13,
6.01064337191204E-14,
1.28216881556398E-13,
6.48960052362924E-14,
1.38045824771282E-13,
6.66723620756926E-14,
1.41178735368896E-13,
7.72264197035355E-14,
1.49215709233097E-13,
7.40310590607862E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07578876362702E-14,
  0,
-1.08554658317939E-14,
  0,
0.81515371346584,
1.32099192695634E-14,
0.444786857841308,
1.5181432500011E-14,
0.365987581520815,
1.67721739274818E-14,
0.339112157727228,
2.42514341941558E-14,
0.33820016874774,
3.72644623491958E-14,
0.363417258311836,
5.06157615820513E-14,
0.441206336622344,
6.4397272236949E-14,
0.812940980128549,
6.87228052242972E-14,
4.11285588919341E-14,
7.11887146453982E-14,
4.43317257903253E-14,
7.69271799039295E-14,
4.86000129029662E-14,
8.56927376280403E-14,
5.73126615610597E-14,
1.0098692715399E-13,
6.76177863701E-14,
1.10584284784832E-13,
6.91686291576232E-14,
1.18060075604554E-13,
6.62976618048816E-14,
1.16850973341798E-13,
5.80872155930834E-14,
1.25731022815323E-13,
5.83977310952832E-14,
1.36474165302047E-13,
6.43287506596479E-14,
1.42571718320106E-13,
7.08148817363252E-14,
1.49616430356048E-13,
7.21939868997268E-14,
1.52650461715531E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.31223157340266E-14,
  0,
  0,
1.43808576158477E-14,
0.814625522289951,
1.91704291330197E-14,
0.443778490025566,
2.16814413644961E-14,
0.364970558847638,
2.85136497746308E-14,
0.33820016874774,
3.31262794972531E-14,
0.337434129770942,
4.57333823589146E-14,
0.36281595424742,
6.00734739730768E-14,
0.440789695484648,
6.67486899086356E-14,
0.812789859198183,
6.95971058561895E-14,
4.64324759197332E-14,
7.65715615913543E-14,
4.63283925111746E-14,
7.97365645732739E-14,
5.24753851482984E-14,
9.14502848448073E-14,
5.89667203954036E-14,
1.04627244368327E-13,
6.80948353259936E-14,
1.15449316773208E-13,
6.86083134748827E-14,
1.17445983494058E-13,
5.9615506975419E-14,
1.2339088084623E-13,
5.63698393518663E-14,
1.3391197872803E-13,
5.77923126021673E-14,
1.40890771271884E-13,
6.84521883620448E-14,
1.50929616027362E-13,
6.56939780352417E-14,
1.52931486918639E-13,
6.56766308004819E-14,
  0,
1.12351534325983E-14,
  0,
1.05956909912663E-14,
  0,
  0,
-1.09521766655796E-14,
  0,
  0,
1.6008028236314E-14,
  0,
2.10508693809786E-14,
0.814200048945812,
2.57623783417316E-14,
0.442952953483213,
3.37238917347271E-14,
0.364126230020177,
3.72635949874578E-14,
0.337434129770942,
4.16567821903691E-14,
0.336784241948475,
5.47721590304917E-14,
0.362301412293591,
6.27388765939152E-14,
0.440430470809526,
6.79968234496009E-14,
0.812658657142177,
7.47396936007227E-14,
4.83424064667837E-14,
7.92170148922189E-14,
5.01534577757035E-14,
8.53310477832991E-14,
5.40652592140312E-14,
9.50368256313894E-14,
5.93622373479263E-14,
1.09407274906381E-13,
6.74703348746419E-14,
1.14710324572442E-13,
6.19903434140312E-14,
1.23841908949984E-13,
5.78617015412064E-14,
1.31450406115619E-13,
5.57609514117985E-14,
1.38212358224976E-13,
6.18689127707128E-14,
1.49161932805342E-13,
6.32653651688742E-14,
1.54114568329256E-13,
5.91436621899533E-14,
1.4852008511923E-13,
  0,
  0,
1.43179738898436E-14,
  0,
1.50214042593522E-14,
  0,
1.30837181366861E-14,
  0,
1.59186899773012E-14,
  0,
2.21342041917261E-14,
  0,
2.74459274751671E-14,
0.81385197558937,
3.78126349676045E-14,
0.442268127097389,
4.22700069391269E-14,
0.363417258311836,
4.57672094666961E-14,
0.336784241948475,
5.07215797140859E-14,
0.336227992224048,
5.78356806890667E-14,
0.361857597738784,
6.38560385124443E-14,
0.440118507967341,
7.31159924272085E-14,
0.812543998668402,
7.75993852508705E-14,
5.250921225608E-14,
8.49043058082088E-14,
5.17927714605015E-14,
8.89201906550952E-14,
5.45345019142829E-14,
9.96806803765793E-14,
5.8789778600854E-14,
1.08638792406524E-13,
6.07656286399916E-14,
1.21128801433557E-13,
6.01758226581595E-14,
1.31901434219373E-13,
5.72337316429028E-14,
1.35754255059517E-13,
5.97837751525887E-14,
1.46417600266346E-13,
5.66994368123019E-14,
1.52279230891672E-13,
5.67341312818215E-14,
1.49618165079524E-13,
4.83432738285217E-14,
  0,
1.33586718076284E-14,
  0,
1.90628762775091E-14,
  0,
2.14728408665099E-14,
  0,
2.12590361980958E-14,
  0,
2.21897153429573E-14,
  0,
2.89794230279306E-14,
1.09504419421036E-14,
3.92246998770496E-14,
0.813563406287824,
4.68895755556531E-14,
0.441693461741773,
5.07024977558501E-14,
0.36281595424742,
5.47305256670683E-14,
0.336227992224048,
5.36974978371241E-14,
0.335748103019889,
5.84402318204447E-14,
0.361472037995131,
6.90003609804535E-14,
0.439845815064696,
7.56105247856631E-14,
0.812443198370452,
8.32164198660834E-14,
5.39620431672105E-14,
8.84639583809133E-14,
5.20868070896796E-14,
9.3642107956704E-14,
5.38857153342676E-14,
9.89590354105729E-14,
5.20295612149724E-14,
1.1503471786245E-13,
5.89233523085042E-14,
1.29120672487382E-13,
5.95270360781441E-14,
1.36130690053804E-13,
6.12513512132651E-14,
1.43914394290512E-13,
5.45535838725186E-14,
1.4945163162583E-13,
5.00762625810225E-14,
1.47703030362045E-13,
4.58973137273944E-14,
1.48263346044786E-13,
  0,
  0,
1.88195813100034E-14,
  0,
2.57389595748059E-14,
  0,
2.97956104233776E-14,
  0,
2.76497574835943E-14,
  0,
2.89386570262451E-14,
  0,
4.06428363186606E-14,
1.98382976712708E-14,
4.81750056513519E-14,
0.813321380138789,
5.52266565811976E-14,
0.441206336622344,
6.00726066113388E-14,
0.362301412293591,
5.77246583866042E-14,
0.335748103019889,
5.43454170554014E-14,
0.335331128313738,
6.36123098640695E-14,
0.361134908528107,
7.17099990499293E-14,
0.439606029974722,
8.13706740876441E-14,
0.812354097322088,
8.68853600177744E-14,
5.43974587596807E-14,
9.31858756825221E-14,
5.15230219599871E-14,
9.28129101351871E-14,
4.71289673953379E-14,
1.05290776097888E-13,
5.01734070956772E-14,
1.22965873594616E-13,
5.82398712589693E-14,
1.33329111640101E-13,
6.35186347963668E-14,
1.44271747326563E-13,
5.6024629380147E-14,
1.46906792286572E-13,
4.79755124516146E-14,
1.44819919944972E-13,
3.92342408561674E-14,
1.46310047410836E-13,
4.0465894524111E-14,
  0,
1.41078555088159E-14,
  0,
2.59774840527527E-14,
  0,
3.43518616330307E-14,
  0,
3.63337832043342E-14,
  0,
3.45036499371787E-14,
1.09018696847762E-14,
4.06983474698919E-14,
1.74374403805189E-14,
4.9586203199059E-14,
2.5282727300624E-14,
5.68807154155415E-14,
0.813116311495751,
6.4399874322163E-14,
0.440789695484648,
6.28039287242643E-14,
0.361857597738784,
5.84402318204447E-14,
0.335331128313738,
5.95920882084933E-14,
0.334966472217123,
6.61718943528733E-14,
0.360838382456224,
7.73461156233779E-14,
0.439394035242501,
8.51471670948456E-14,
0.812274943310632,
9.12065561964326E-14,
5.36046901311593E-14,
9.24052501183326E-14,
4.48391324070485E-14,
9.91828147389739E-14,
4.52745479995187E-14,
1.1326703464043E-13,
4.94847218757144E-14,
1.27132679383912E-13,
6.22574908293316E-14,
1.41383432739062E-13,
5.82520143233012E-14,
1.472225119592E-13,
4.936155650892E-14,
1.4223344724229E-13,
3.70814490224802E-14,
1.43407855035527E-13,
3.38132299937399E-14,
1.51743201337595E-13,
  0,
  0,
2.21120864674074E-14,
  0,
3.48926616766665E-14,
  0,
4.10409553563973E-14,
1.49628573420379E-14,
4.3305636854285E-14,
1.54971521726388E-14,
4.63466071076724E-14,
1.97515614974719E-14,
4.97457977588489E-14,
2.30241173349022E-14,
5.83387504971E-14,
2.99231125988619E-14,
6.56774981622199E-14,
0.812940980128549,
6.67443530999456E-14,
0.440430470809526,
6.38577732359202E-14,
0.361472037995131,
6.36123098640695E-14,
0.334966472217123,
6.19816697966513E-14,
0.334645690125456,
7.21228632372117E-14,
0.360576159988876,
8.07149486137249E-14,
0.439205675577077,
8.97944912869875E-14,
0.812204301827684,
9.03496027993E-14,
4.67854921470945E-14,
9.86086212684256E-14,
4.2934406030426E-14,
1.07022030126913E-13,
4.46014752908397E-14,
1.17366186214163E-13,
5.35006067226007E-14,
1.35152306013353E-13,
5.69752578449823E-14,
1.44318584860414E-13,
5.15681247703625E-14,
1.42486716869783E-13,
3.85143306136371E-14,
1.4075893228771E-13,
3.16344173079131E-14,
1.48809783939718E-13,
3.44203832103318E-14,
  0,
1.94412628357066E-14,
  0,
3.16070954131664E-14,
  0,
4.2036686631608E-14,
1.53384249745869E-14,
4.82487313990809E-14,
2.36815775322974E-14,
5.5351556671468E-14,
2.43303641123127E-14,
5.54183435252931E-14,
2.52237467024408E-14,
5.85503867611692E-14,
2.78162909372881E-14,
6.7387935509533E-14,
4.01024699558938E-14,
6.87158663303933E-14,
0.812789859198183,
6.79959560878629E-14,
0.440118507967341,
6.89977588952395E-14,
0.361134908528107,
6.61710269911353E-14,
0.334645690125456,
6.78537087628328E-14,
0.334361982766349,
7.59062951383171E-14,
0.360343122816443,
8.55721743464599E-14,
0.439037547724807,
8.9152643600876E-14,
0.812140989075967,
9.66848129335673E-14,
4.51270965040607E-14,
1.06472122785028E-13,
4.21693929775202E-14,
1.11093426125031E-13,
4.8542767028259E-14,
1.25449997612215E-13,
4.82183737382513E-14,
1.38071845623422E-13,
5.03173891441833E-14,
1.39553299471906E-13,
4.07382461098393E-14,
1.40954956040495E-13,
3.3060360005166E-14,
1.46094941699815E-13,
3.22571830357887E-14,
1.51439624729299E-13,
1.31353261600964E-14,
  0,
3.00562526256432E-14,
  0,
3.91110754893731E-14,
1.19839034529168E-14,
4.94023225106055E-14,
2.4156891764715E-14,
6.04091429656783E-14,
3.25833110492724E-14,
6.45811529254026E-14,
2.98875507676044E-14,
6.43027298075083E-14,
3.00462779656563E-14,
6.76524808396195E-14,
3.80268733168876E-14,
7.02649743944406E-14,
4.11623859997157E-14,
6.95927690474996E-14,
0.812658657142177,
7.30856347663789E-14,
0.439845815064696,
7.16414774726282E-14,
0.360838382456224,
7.20708215329324E-14,
0.334361982766349,
7.13908099303495E-14,
0.334109824378092,
8.02656552334469E-14,
0.360135076782683,
8.47360376310391E-14,
0.438886842202514,
9.49674366923503E-14,
0.812084020959195,
1.04865768846274E-13,
4.40775888010947E-14,
1.10658010532561E-13,
4.61627264192188E-14,
1.19118256924899E-13,
4.32692076612895E-14,
1.28279331601533E-13,
4.15761175487361E-14,
1.33306560234914E-13,
3.94111826507171E-14,
1.37998987237431E-13,
3.52565199257526E-14,
1.46242393195273E-13,
3.3655370157426E-14,
1.48729986659824E-13,
2.50181819705375E-14,
  0,
2.67581096169422E-14,
  0,
3.82875155191531E-14,
  0,
4.68492432348366E-14,
2.08773970333809E-14,
6.18272794072894E-14,
3.30707683460219E-14,
6.97671087568352E-14,
3.82454484748607E-14,
7.33857419277228E-14,
3.47256945421037E-14,
7.34716107397837E-14,
4.02846159208714E-14,
7.06188579835398E-14,
3.91058713189452E-14,
7.11462139202368E-14,
4.64316085579952E-14,
7.47396936007227E-14,
0.812543998668402,
7.55836365717855E-14,
0.439606029974722,
7.73461156233779E-14,
0.360576159988876,
7.59062951383171E-14,
0.334109824378092,
7.58802742861775E-14,
0.333884685720292,
7.9282067022568E-14,
0.359948557886841,
9.12742104119957E-14,
0.438751222711317,
1.02912470212324E-13,
0.812032573825972,
1.08680425769947E-13,
4.81229639470726E-14,
1.18436510598841E-13,
4.08544725827298E-14,
1.22027388194113E-13,
3.66599112178179E-14,
1.23486290637409E-13,
3.06404207561783E-14,
1.31715818807443E-13,
3.39433342544382E-14,
1.43260403540069E-13,
3.58844898240562E-14,
1.48870499261378E-13,
2.64475941147424E-14,
1.44115622213725E-13,
1.77512084892362E-14,
  0,
3.63992690155523E-14,
  0,
4.65664833082524E-14,
1.82887559263545E-14,
5.95678020798296E-14,
3.00219918369926E-14,
7.13457071199741E-14,
3.88239787540989E-14,
7.88570597709537E-14,
4.31295624214734E-14,
8.27645244005915E-14,
4.49605630503669E-14,
7.65785004852582E-14,
4.13575423907631E-14,
7.14879544450042E-14,
4.43031028529717E-14,
7.65021726523152E-14,
4.8394448171063E-14,
7.76601005725297E-14,
0.812443198370452,
8.13706740876441E-14,
0.439394035242501,
8.07201527841528E-14,
0.360343122816443,
8.02032051883117E-14,
0.333884685720292,
7.51204654036997E-14,
0.333682825154845,
8.5341456124155E-14,
0.35978068435075,
9.86676018666088E-14,
0.438628733282495,
1.07020295403437E-13,
0.811985953961208,
1.16946383132976E-13,
4.28875684965746E-14,
1.2145492944704E-13,
3.42503803096861E-14,
1.17270776422984E-13,
2.57901339173472E-14,
1.21930243679458E-13,
2.51517556781877E-14,
1.36972030939653E-13,
3.45331402362703E-14,
1.4582085539061E-13,
2.86316109709972E-14,
1.4422144034576E-13,
1.3390330511065E-14,
  0,
3.13260702100582E-14,
1.38920992764913E-14,
4.54978936470507E-14,
1.88785619081866E-14,
5.96970389787899E-14,
2.75205205846341E-14,
6.93750612512645E-14,
3.58489279927987E-14,
8.05848443530266E-14,
4.38451358553138E-14,
8.8261863095962E-14,
5.34173399957538E-14,
8.58904961043017E-14,
4.60794596923719E-14,
7.74597400110544E-14,
4.66874802707018E-14,
7.69566702030211E-14,
4.63283925111746E-14,
7.92343621269787E-14,
5.2505742809128E-14,
8.31869295669918E-14,
0.812354097322088,
8.51506365417976E-14,
0.439205675577077,
8.56259507742152E-14,
0.360135076782683,
7.9283801746044E-14,
0.333682825154845,
8.14123074510675E-14,
0.333501129267633,
9.34842481203901E-14,
0.359629042622036,
1.02856959061093E-13,
0.438517726076124,
1.15128392930153E-13,
0.81194357365923,
1.19494691919186E-13,
3.64135804842292E-14,
1.16701787122864E-13,
2.33996849674512E-14,
1.15605441886046E-13,
2.03049382863085E-14,
1.27122271043056E-13,
2.57016630200724E-14,
1.39476971638963E-13,
2.73166905762068E-14,
1.4117700064542E-13,
1.56021029429354E-14,
1.31481631138186E-13,
1.83859004410092E-14,
1.25017184104959E-14,
4.21013050810881E-14,
2.34152974787349E-14,
5.92876442384593E-14,
2.83358406183432E-14,
6.985557965411E-14,
3.34879693419943E-14,
7.88856827083073E-14,
4.09082490104851E-14,
9.01579158552046E-14,
5.42040370921093E-14,
9.15222758690604E-14,
5.45483797020907E-14,
8.68489308247788E-14,
5.13634274001973E-14,
8.29353946629752E-14,
4.86286358403198E-14,
7.96767166133527E-14,
5.0110957050542E-14,
8.48765502325932E-14,
5.40140848714898E-14,
8.68662780595386E-14,
0.812274943310632,
8.97944912869875E-14,
0.439037547724807,
8.47221598432313E-14,
0.359948557886841,
8.53258436128712E-14,
0.333501129267633,
8.92445839451028E-14,
0.333336990005177,
9.72659452980196E-14,
0.359491598672871,
1.1008902123244E-13,
0.438416804728881,
1.17662823928555E-13,
0.811904932299745,
1.14777978788005E-13,
2.55143128846669E-14,
1.14963594199935E-13,
1.80029602336873E-14,
1.20783591461837E-13,
2.08496414577652E-14,
1.29601190890227E-13,
1.84886828069608E-14,
1.34729033485215E-13,
1.42507533551495E-14,
1.28359128881428E-13,
  0,
1.14524275479644E-14,
3.33994984447195E-14,
2.27695466648026E-14,
5.68967616076943E-14,
3.31861274571743E-14,
7.00012964260921E-14,
3.44490061476854E-14,
7.97027374654924E-14,
3.86817314290688E-14,
8.86842682623623E-14,
5.13668968471492E-14,
9.3567514847237E-14,
5.54660484208824E-14,
9.25648446781224E-14,
5.99771968201601E-14,
9.24859147599655E-14,
5.34294830600857E-14,
8.57100848628001E-14,
5.24918650213202E-14,
8.5341456124155E-14,
5.17927714605015E-14,
8.84448764226775E-14,
5.43714379075411E-14,
9.11458408747734E-14,
0.812204301827684,
8.9152643600876E-14,
0.438886842202514,
9.12186992607644E-14,
0.35978068435075,
9.35519023359532E-14,
0.333336990005177,
9.33610827535958E-14,
0.333188209041396,
1.05268224692701E-13,
0.359366628358791,
1.13334688855993E-13,
0.438324779527683,
1.13192441530963E-13,
0.811869601262446,
1.13128256762351E-13,
1.99892186136807E-14,
1.2014000905225E-13,
1.83950077392581E-14,
1.23229551562964E-13,
1.35863542638504E-14,
1.24837640225195E-13,
  0,
1.21912896444698E-13,
  0,
1.24518451105615E-13,
2.01746171851758E-14,
2.42505668324178E-14,
5.00975129436032E-14,
3.31163048372662E-14,
6.84075192325384E-14,
3.95820529131008E-14,
8.02630531482329E-14,
3.98344551788554E-14,
8.97051530279747E-14,
4.92505342064575E-14,
9.22361145794248E-14,
5.27364610314329E-14,
9.47410552787353E-14,
6.08783856659301E-14,
9.82573397645403E-14,
6.20233031600748E-14,
9.52744827475982E-14,
5.73100594758458E-14,
9.14225292691917E-14,
5.40583203201273E-14,
8.89427420602829E-14,
5.21006848774874E-14,
9.31858756825221E-14,
5.35769345555437E-14,
9.03270513941123E-14,
0.812140989075967,
9.49709061393023E-14,
0.438751222711317,
9.8726582464792E-14,
0.359629042622036,
9.73214564492508E-14,
0.333188209041396,
1.01091010562548E-13,
0.33305292267053,
1.08142661492394E-13,
0.359252662284103,
1.08387257502507E-13,
0.438240631662026,
1.11124651147598E-13,
0.811837211813171,
1.18224874334771E-13,
2.0497492592142E-14,
1.22608520558565E-13,
1.12271303365219E-14,
1.18434775875365E-13,
  0,
1.11988543438635E-13,
  0,
1.18098239521025E-13,
  0,
1.65366852156179E-14,
4.16142814652076E-14,
3.58831887814492E-14,
6.28399242363908E-14,
4.0015300101226E-14,
7.92525767234764E-14,
4.51687298674841E-14,
9.06427710667401E-14,
5.0487392044829E-14,
9.35874641672108E-14,
5.07007630323741E-14,
9.35744537411409E-14,
5.81982378955459E-14,
1.00464775387721E-13,
6.30086260944296E-14,
1.01119633499902E-13,
6.5972401153136E-14,
1.0098692715399E-13,
5.89441689902159E-14,
9.50298867374855E-14,
5.45501144255667E-14,
9.36681288088437E-14,
5.15247566834631E-14,
9.23306570088656E-14,
4.68410032983257E-14,
9.66830782100914E-14,
0.812084020959195,
1.02884714636708E-13,
0.438628733282495,
1.02967981363555E-13,
0.359491598672871,
1.05268224692701E-13,
0.33305292267053,
1.03830138931116E-13,
0.332929542328343,
1.03059921707782E-13,
0.359148441811505,
1.06881517525359E-13,
0.438163484507541,
1.16285453488629E-13,
0.811807445309199,
1.20467871789209E-13,
1.3241144292131E-14,
1.17864051851768E-13,
  0,
1.0564812913394E-13,
  0,
1.08160008727154E-13,
-1.1296519275561E-14,
1.1353418205573E-13,
2.78947871745761E-14,
3.18967942336545E-14,
5.6620940575014E-14,
4.35641106522056E-14,
7.45579813166142E-14,
4.59363450056038E-14,
9.01900082395102E-14,
5.6099222489614E-14,
9.47991685151806E-14,
5.21813495191203E-14,
9.50723874626469E-14,
5.63299407119189E-14,
9.94889934324839E-14,
6.04533784143158E-14,
1.03533501216724E-13,
6.70305824734818E-14,
1.0695003910266E-13,
6.75908981562223E-14,
1.04627244368327E-13,
5.93657067948783E-14,
9.96893539939592E-14,
5.38666333760318E-14,
9.28406657108027E-14,
4.48634185357122E-14,
9.86381115675172E-14,
4.51565868031523E-14,
1.04928218891409E-13,
0.812032573825972,
1.07072337107716E-13,
0.438517726076124,
1.10116776808056E-13,
0.359366628358791,
1.08142661492394E-13,
0.332929542328343,
9.86641324196569E-14,
0.332816707123334,
1.01489996962023E-13,
0.359052883707807,
1.11846296113605E-13,
0.43809258039951,
1.19163359735275E-13,
0.811780025228596,
1.1594024351691E-13,
  0,
1.05099956515531E-13,
-1.14040721310715E-14,
1.01710306843472E-13,
-1.62647673107585E-14,
1.03618502667047E-13,
-1.73853986762396E-14,
2.03151297867299E-14,
4.90727250501699E-14,
4.12816482386891E-14,
6.97319806064467E-14,
5.01087886461971E-14,
8.61394289231043E-14,
5.71617406186498E-14,
9.47167691500717E-14,
5.79085390750578E-14,
9.65685864606769E-14,
5.78677730733723E-14,
1.01156930054636E-13,
5.86483986375619E-14,
1.026036894336E-13,
6.45265091359093E-14,
1.09436765205473E-13,
6.87254073095112E-14,
1.10613775083923E-13,
6.81035089433735E-14,
1.09410744353333E-13,
5.87481452374305E-14,
9.89729131983808E-14,
4.71567229709535E-14,
9.9181080015498E-14,
4.29777741173254E-14,
1.065102867015E-13,
4.41330999523259E-14,
1.08708181345563E-13,
0.811985953961208,
1.15072881778921E-13,
0.438416804728881,
1.13334688855993E-13,
0.359252662284104,
1.03170944010245E-13,
0.332816707123334,
9.72971703205872E-14,
0.332713245677889,
1.06796516075036E-13,
0.358965051536543,
1.14415421581526E-13,
0.43802726172603,
1.14632262016023E-13,
0.811754710644572,
1.03127575923345E-13,
  0,
1.01122235585116E-13,
-1.85702148103317E-14,
9.72052299763604E-14,
-2.23588508818651E-14,
1.06789577181132E-13,
2.875759526344E-14,
3.41441284967825E-14,
6.4770237784284E-14,
4.87886640809787E-14,
8.2271862933414E-14,
6.17735029795341E-14,
9.12169645372884E-14,
5.92251941933242E-14,
9.67906310656019E-14,
6.37797106795013E-14,
1.02839611826333E-13,
6.03059269188577E-14,
1.04435557424232E-13,
6.27770405103867E-14,
1.08648333385641E-13,
6.62412832919124E-14,
1.13175094296203E-13,
6.9182506945431E-14,
1.15444112602781E-13,
6.74425792990263E-14,
1.08666547982139E-13,
5.20330306619243E-14,
1.05304653885696E-13,
4.52606702117109E-14,
1.07049785702529E-13,
4.21555151897124E-14,
1.1067535776732E-13,
4.8168066757448E-14,
1.16941178962549E-13,
0.81194357365923,
1.17674966992887E-13,
0.438324779527683,
1.08276235200044E-13,
0.359148441811505,
1.01502140026355E-13,
0.332713245677889,
1.02555117176273E-13,
0.332618145244818,
1.09542583337507E-13,
0.358884132361882,
1.09809730752808E-13,
0.437966955444454,
1.01474384450739E-13,
0.811731290852314,
9.91099563529829E-14,
-1.66359981346176E-14,
9.65477697789652E-14,
-2.46313386353947E-14,
1.00310384998359E-13,
-2.36824448940354E-14,
1.91402883126246E-14,
5.10464066849625E-14,
4.34721703079788E-14,
7.88978257726392E-14,
6.11498698899204E-14,
8.80424205762509E-14,
6.41804318024519E-14,
9.36820065966515E-14,
6.52845832949112E-14,
1.03339212187414E-13,
6.63106722309514E-14,
1.06296915713955E-13,
6.44840084107479E-14,
1.1058081533788E-13,
6.45846223723545E-14,
1.12496817417096E-13,
6.67590982494914E-14,
1.18073953392361E-13,
6.86291301565944E-14,
1.14731141254154E-13,
6.07881800451793E-14,
1.15005227563358E-13,
5.02028973947688E-14,
1.13230605447434E-13,
4.46327003134073E-14,
1.1112812059455E-13,
4.61696653131227E-14,
1.18464266174456E-13,
4.29691004999455E-14,
1.1949295719571E-13,
0.811904932299745,
1.13225401277006E-13,
0.438240631662026,
1.06926620335734E-13,
0.359052883707807,
1.06852027226267E-13,
0.332618145244818,
1.04994138383496E-13,
0.332530526552773,
1.04390454613856E-13,
0.358809417663703,
9.72139035937403E-14,
0.437911160329051,
9.74654384977569E-14,
0.811709580920909,
9.4762739322185E-14,
-2.25843649337421E-14,
9.95974136497324E-14,
-2.60833021847873E-14,
1.02976654980935E-13,
3.01657570450642E-14,
3.28309428254681E-14,
6.79452154261906E-14,
5.69657168658644E-14,
8.57048806923721E-14,
6.40919609051771E-14,
9.10755845739963E-14,
7.05477343210248E-14,
1.00563654625851E-13,
6.80037623435048E-14,
1.07020295403437E-13,
7.06778385817231E-14,
1.1261130916651E-13,
6.63904695108464E-14,
1.14556801544818E-13,
6.51752957159246E-14,
1.17448585579272E-13,
6.63098048692135E-14,
1.17445983494058E-13,
6.2004221201839E-14,
1.21134005603984E-13,
5.89250870319802E-14,
1.22993629170232E-13,
4.95072732809021E-14,
1.17367920937639E-13,
4.85115420056914E-14,
1.19121726371851E-13,
4.083712534797E-14,
1.21427173871425E-13,
3.63268443104303E-14,
1.14777978788005E-13,
0.811869601262446,
1.11218326215301E-13,
0.438163484507541,
1.11818540537989E-13,
0.358965051536543,
1.09530440273176E-13,
0.332530526552773,
1.00452632323389E-13,
0.332449623194976,
9.16766662584223E-14,
0.358740287613961,
9.29065852028899E-14,
0.437859436411723,
9.29794435888809E-14,
0.811689417992375,
9.77759539999568E-14,
-2.3937449245004E-14,
1.02199498863698E-13,
-3.13811476804204E-14,
1.87569144244337E-14,
5.39676810185075E-14,
4.81606941826751E-14,
7.63881145837697E-14,
6.06008299097738E-14,
8.94900473169535E-14,
7.07905956076615E-14,
9.83362696826973E-14,
7.34759475484736E-14,
1.04491068575463E-13,
7.24585322298132E-14,
1.13489079245355E-13,
7.25938406609394E-14,
1.16729542698479E-13,
6.70427255378137E-14,
1.19605714221649E-13,
6.47173287182667E-14,
1.16833626107038E-13,
5.96189764223709E-14,
1.23855786737792E-13,
6.01897004459673E-14,
1.29131080828238E-13,
5.82416059824453E-14,
1.2712920993696E-13,
5.35162192338845E-14,
1.25446528165263E-13,
4.32657382143375E-14,
1.22037796534968E-13,
3.42191552871185E-14,
1.1671219546372E-13,
2.54588017334356E-14,
1.13128256762351E-13,
0.811837211813171,
1.1639300634414E-13,
0.43809258039951,
1.14415421581526E-13,
0.358884132361882,
1.04399128231236E-13,
0.332449623194976,
8.7209753307782E-14,
0.332374764645193,
8.77041494984354E-14,
0.358676198053123,
8.83026290976474E-14,
0.437811396194305,
9.58764317937622E-14,
0.81167065818745,
1.0023232244194E-13,
-2.92682544866807E-14,
1.03533501216724E-13,
3.21387881585533E-14,
3.86140772135057E-14,
6.52412152080117E-14,
5.30339661075629E-14,
8.11763850583347E-14,
6.78936074027803E-14,
9.72815578093034E-14,
7.40865702120175E-14,
1.02613230412718E-13,
7.81362821666853E-14,
1.11198376895327E-13,
7.45584149974832E-14,
1.17757366357996E-13,
7.33874766511988E-14,
1.21864324187371E-13,
6.66801683313345E-14,
1.19090501349284E-13,
5.81010933808912E-14,
1.23411697527942E-13,
5.78478237533986E-14,
1.31903168942848E-13,
5.94975457790525E-14,
1.33325642193149E-13,
6.22488172119517E-14,
1.35154040736829E-13,
4.82149042912994E-14,
1.28251576025917E-13,
3.66599112178179E-14,
1.17225673612609E-13,
2.33996849674512E-14,
1.14963594199935E-13,
1.99892186136807E-14,
1.18280385486003E-13,
0.811807445309199,
1.19163359735275E-13,
0.43802726172603,
1.09754219601577E-13,
0.358809417663703,
9.16523801297586E-14,
0.332374764645193,
8.35668340082307E-14,
0.332305362188,
8.29024349169316E-14,
0.358616669648546,
9.18085052425965E-14,
0.437766697300038,
9.86953574422245E-14,
0.811653174006813,
1.01816124975507E-13,
-3.60336760429902E-14,
2.58042285455895E-14,
5.05164486630516E-14,
4.54601634114482E-14,
7.15907368109558E-14,
6.10778788656674E-14,
8.97242349862104E-14,
7.16128545352746E-14,
1.01980923705725E-13,
7.90149196072676E-14,
1.09633656319996E-13,
8.03879532385032E-14,
1.15702586400701E-13,
7.54405218850174E-14,
1.2308470215272E-13,
7.30925736602828E-14,
1.21477480852228E-13,
6.01029642721684E-14,
1.25731022815323E-13,
5.63837171396742E-14,
1.31478161691234E-13,
5.72337316429028E-14,
1.36128955330328E-13,
6.35186347963668E-14,
1.41381698015586E-13,
5.69787272919342E-14,
1.38044090047806E-13,
4.15483619731205E-14,
1.23458535061793E-13,
2.57727866825874E-14,
1.15615850226902E-13,
1.79335712946482E-14,
1.20138274328774E-13,
2.0495757868666E-14,
1.20525117663917E-13,
0.811780025228596,
1.14632262016023E-13,
0.437966955444455,
9.71358410373213E-14,
0.358740287613961,
8.75965966429249E-14,
0.332305362188,
7.89403264978006E-14,
0.332240897204565,
8.6090856665777E-14,
0.358561278826031,
9.39040512015765E-14,
0.437725036300526,
9.98263971485613E-14,
0.811636852139002,
9.8508007306819E-14,
2.62071180728851E-14,
3.81218494271973E-14,
5.95448169937729E-14,
5.46385853228415E-14,
8.11182718218895E-14,
6.53314208287625E-14,
9.49787123949442E-14,
7.69080979456938E-14,
1.09344824861246E-13,
8.14929720927005E-14,
1.14376390303317E-13,
8.14045011954256E-14,
1.21199057734334E-13,
7.52063342157605E-14,
1.22838371419132E-13,
6.65613397732301E-14,
1.2820300376859E-13,
5.83560977318598E-14,
1.33898100940222E-13,
5.57800333700342E-14,
1.35782010635133E-13,
6.12513512132651E-14,
1.44257869538755E-13,
5.82433407059213E-14,
1.44315115413463E-13,
5.03243280380872E-14,
1.33251049083682E-13,
3.06265429683705E-14,
1.21957999255073E-13,
2.02789174341689E-14,
1.20839102613068E-13,
1.83655174401665E-14,
1.2263627613418E-13,
1.32498179095109E-14,
1.15938508793434E-13,
0.811754710644572,
1.01502140026355E-13,
0.437911160329051,
9.29152588202697E-14,
0.358676198053123,
8.29267210455953E-14,
0.332240897204565,
8.2052420413703E-14,
0.332180911372991,
8.87016154971221E-14,
0.358509650150123,
9.5062846483529E-14,
0.437686143507761,
9.67646102134623E-14,
0.811621591603705,
1.82406173498961E-14,
4.12478211309075E-14,
4.93377040611254E-14,
7.05924034505312E-14,
5.96571403388424E-14,
8.7134292836577E-14,
7.09623332317832E-14,
1.02823999315049E-13,
7.96064603125757E-14,
1.14392870176339E-13,
8.26535020981289E-14,
1.20081895815805E-13,
8.12726622112514E-14,
1.21089770155347E-13,
6.87592344172927E-14,
1.29679253446646E-13,
6.49098830241002E-14,
1.36462022237716E-13,
5.78009862195472E-14,
1.38226236012784E-13,
5.97525501300211E-14,
1.43888373438372E-13,
5.59986085280073E-14,
1.47203430000964E-13,
5.15646553234106E-14,
1.39567177259714E-13,
3.94215909915729E-14,
1.31729696595251E-13,
2.51361431669039E-14,
1.27122271043056E-13,
2.08253553291016E-14,
1.23233021009916E-13,
1.12479470182336E-14,
1.17877929639576E-13,
  0,
1.0309982034773E-13,
0.811731290852314,
9.74654384977569E-14,
0.437859436411723,
8.83060985445994E-14,
0.358616669648546,
8.61186122413926E-14,
0.332180911372991,
8.46978737145676E-14,
0.332124998433193,
9.00373525736242E-14,
0.358461449894175,
9.21589193847439E-14,
0.437649778562222,
9.73335995135827E-14,
2.14082224170298E-14,
3.38765474006131E-14,
5.4603890853322E-14,
5.55332689555765E-14,
7.75907116334906E-14,
6.58483684246036E-14,
9.55025988846891E-14,
7.39980993147427E-14,
1.08226795580979E-13,
8.092831960127E-14,
1.20396748126694E-13,
8.26630430772468E-14,
1.20130468073132E-13,
7.49270437361282E-14,
1.2805641963487E-13,
6.71407374142063E-14,
1.38014599748715E-13,
6.43495673413597E-14,
1.4088383237798E-13,
6.18602391533329E-14,
1.46445355841962E-13,
5.45535838725186E-14,
1.4692067007438E-13,
4.93355356567804E-14,
1.42493655763687E-13,
4.07399808333153E-14,
1.38012865025239E-13,
3.39433342544382E-14,
1.36949479534465E-13,
2.57138060844042E-14,
1.29615068678035E-13,
1.35880889873263E-14,
1.18460796727504E-13,
  0,
1.05101691239007E-13,
  0,
9.91082216295069E-14,
0.811709580920909,
9.29516880132653E-14,
0.437811396194305,
9.17790149435049E-14,
0.358561278826031,
8.86998807736461E-14,
0.332124998433193,
8.60214677267379E-14,
0.332072797236821,
8.67951543970236E-14,
0.358416380592122,
9.27626031543838E-14,
0.437615726680748,
2.0865253969049E-14,
3.98873642448727E-14,
4.19473483725952E-14,
6.30142639457265E-14,
6.24760659873047E-14,
8.66537744337315E-14,
6.92883250774656E-14,
1.01355555892635E-13,
7.56304741056368E-14,
1.14495218861421E-13,
8.1154701014885E-14,
1.20663028180257E-13,
7.64622740123677E-14,
1.27260181559397E-13,
7.33952829068407E-14,
1.36543554241086E-13,
6.66723620756926E-14,
1.42568248873154E-13,
6.8434841127285E-14,
1.49168871699246E-13,
5.66682117897344E-14,
1.4944295800845E-13,
4.79616346638068E-14,
1.42231712518814E-13,
3.85143306136371E-14,
1.40982711616111E-13,
3.52842755013683E-14,
1.432725466044E-13,
3.45314055127943E-14,
1.39502992491103E-13,
1.85025605947686E-14,
1.24854987459955E-13,
  0,
1.05662006921747E-13,
-1.13780512789319E-14,
1.01122235585116E-13,
-1.6606507835526E-14,
9.4762739322185E-14,
0.811689417992375,
9.57654094912996E-14,
0.437766697300038,
9.39595623528078E-14,
0.358509650150123,
8.99957192102008E-14,
0.332072797236822,
8.2652634736391E-14,
0.332023985857653,
8.75584327264534E-14,
0.358374176404084,
9.42683431315317E-14,
2.46328565184362E-14,
3.35456488975705E-14,
5.04691774483312E-14,
5.00263892810882E-14,
7.29902249752001E-14,
6.64477153855536E-14,
9.30627103157278E-14,
7.12303480088217E-14,
1.07964852336107E-13,
7.60233889729456E-14,
1.15042524118092E-13,
7.50580153585645E-14,
1.27948866779359E-13,
7.5016381995141E-14,
1.35891298214119E-13,
7.29815513578203E-14,
1.41178735368896E-13,
7.0832228971085E-14,
1.50941759091694E-13,
6.32584262749702E-14,
1.52282700338624E-13,
5.00606500697387E-14,
1.44835532456256E-13,
3.70797142990043E-14,
1.40786687863326E-13,
3.30464822173582E-14,
1.46270148770888E-13,
3.58792856536283E-14,
1.4582952900799E-13,
2.73253641935867E-14,
1.34729033485215E-13,
  0,
1.11997217056015E-13,
  0,
1.0172418463128E-13,
-1.85840925981395E-14,
9.65443003320132E-14,
-2.25323232294627E-14,
9.77898317877646E-14,
0.81167065818745,
9.86953574422245E-14,
0.437725036300526,
9.51148881878083E-14,
0.358461449894175,
8.68107669083074E-14,
0.332023985857653,
8.31452962035684E-14,
0.331978276581251,
8.87501877544494E-14,
0.358334599159568,
1.78802285477619E-14,
4.06927096185949E-14,
4.34366084767213E-14,
6.17392421908836E-14,
5.47166478792604E-14,
8.00757030128274E-14,
6.88008677807161E-14,
1.00108289713408E-13,
7.18826040357889E-14,
1.08844357138427E-13,
7.00906346851049E-14,
1.22592908047281E-13,
7.37179414733724E-14,
1.36768200931225E-13,
7.47162748337971E-14,
1.40653114155675E-13,
7.72437669382953E-14,
1.49640716484711E-13,
6.56835696943858E-14,
1.54119772499683E-13,
5.67202534940137E-14,
1.47696091468141E-13,
3.92377103031194E-14,
1.43406120312051E-13,
3.16344173079131E-14,
1.46096676423291E-13,
3.3655370157426E-14,
1.48898254836993E-13,
2.86333456944732E-14,
1.41168327028041E-13,
1.42247325030098E-14,
1.21912896444698E-13,
  0,
1.0816174345063E-13,
-1.62456853525228E-14,
9.72104341467883E-14,
-2.46382775292986E-14,
9.95956789262564E-14,
-2.39062242224364E-14,
1.00180280737661E-13,
0.811653174006813,
9.98125193607535E-14,
0.437686143507761,
9.21571846612679E-14,
0.358416380592122,
8.75601674499293E-14,
0.331978276581251,
8.45521569425856E-14,
0.33193541162677,
8.58861592956117E-14,
2.23360826362429E-14,
3.19523053848858E-14,
5.41645721330308E-14,
4.91802779056805E-14,
6.9707260796914E-14,
5.75286346338189E-14,
8.76694550289159E-14,
6.97636393098833E-14,
1.01339076019613E-13,
6.6116383201642E-14,
1.16632398183825E-13,
6.88928081249429E-14,
1.31561428418081E-13,
7.35071725710412E-14,
1.41680070453454E-13,
7.90183890542195E-14,
1.49229587020905E-13,
7.2178374388443E-14,
1.52931486918639E-13,
5.91540705308091E-14,
1.4961122618562E-13,
4.58921095569664E-14,
1.46311782134312E-13,
3.38166994406919E-14,
1.48797640875387E-13,
3.22589177592647E-14,
1.48747333894583E-13,
2.64649413495022E-14,
1.44224909792712E-13,
1.55812862612237E-14,
1.28320964964956E-13,
  0,
1.18091300627121E-13,
-1.13242748511766E-14,
1.03618502667047E-13,
-2.23206869653936E-14,
1.00353753085258E-13,
-2.60989146960711E-14,
1.02182151628938E-13,
-2.92682544866807E-14,
1.01819594422459E-13,
0.811636852139002,
9.67524671491304E-14,
0.437649778562222,
9.28337268168988E-14,
0.358374176404084,
8.87501877544494E-14,
0.33193541162677,
8.18511924904897E-14,
0.331895159481053,
1.90104008923608E-14,
4.10695782937509E-14,
3.94493465671886E-14,
6.34457764103757E-14,
5.26974297532234E-14,
7.79749528834195E-14,
5.88973314563646E-14,
8.93313201189017E-14,
6.42376776771592E-14,
1.09403805459429E-13,
6.50417220082744E-14,
1.25848984011689E-13,
6.8734080926891E-14,
1.36677995310475E-13,
7.79029618591665E-14,
1.50409198984569E-13,
7.40345285077382E-14,
1.52634849204247E-13,
6.56887738648138E-14,
1.48525289289658E-13,
4.83432738285217E-14,
1.48285897449973E-13,
4.04815070353948E-14,
1.51729323549787E-13,
3.4408240146E-14,
1.51467380304915E-13,
2.5059815333961E-14,
1.44132969448485E-13,
1.34163513632046E-14,
1.3148857003209E-13,
  0,
1.2449069553E-13,
  0,
1.1353418205573E-13,
-1.73663167180038E-14,
1.06779168840276E-13,
-2.36824448940354E-14,
1.02990532768743E-13,
-3.13811476804204E-14,
1.03533501216724E-13,
-3.61030649820293E-14,
9.84524961555877E-14,
0.811621591603705,
9.72850272562553E-14,
0.437615726680748,
9.42683431315317E-14,
0.358334599159568,
8.58844245721357E-14,
0.331895159481053,
7.79914327564413E-14,
  0,
-1.22266563193363E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
-1.05174115944129E-14,
  0,
  0,
-1.00328816435291E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.50261747489111E-14,
  0,
1.17106845054504E-14,
  0,
1.64861613943801E-14,
  0,
2.18306275834301E-14,
1.90112682540988E-14,
2.81669219198699E-14,
2.13104273810716E-14,
3.03977763099761E-14,
1.88332422573767E-14,
2.93807946721847E-14,
1.66761136149995E-14,
3.21340176689944E-14,
2.42037292985664E-14,
3.22472083758019E-14,
2.05885655746307E-14,
2.25147591542685E-14,
1.70263109167124E-14,
2.19112922250631E-14,
1.67962432157109E-14,
2.08255721695361E-14,
2.37141035974719E-14,
3.10324682617491E-14,
-1.22266563193363E-14,
-1.59918736239439E-14,
-1.86131492163621E-14,
-1.22706749275392E-14,
-1.25082236235308E-14,
  0,
  0,
0.867721831274621,
-1.02519989025884E-14,
0.867364964374359,
-1.37815106548977E-14,
-1.24598682066379E-14,
-1.57723226840156E-14,
-1.55294613973789E-14,
-1.18397045639762E-14,
-1.21109719475321E-14,
  0,
  0,
  0,
  0,
1.36941239597954E-14,
  0,
1.63352404519701E-14,
  0,
2.15712864237716E-14,
  0,
2.31342722756267E-14,
  0,
2.44144982008976E-14,
  0,
3.31783212015324E-14,
2.2958631523684E-14,
4.32982642795121E-14,
3.49299582314E-14,
5.07302533314657E-14,
3.478337409768E-14,
5.17875672900736E-14,
3.07818007194705E-14,
5.32638169681299E-14,
3.53931293994858E-14,
5.57418694535627E-14,
3.87780085819855E-14,
4.74286408758129E-14,
3.25529533884428E-14,
3.84614215476198E-14,
2.92738923379776E-14,
3.70185652964761E-14,
3.5077843407727E-14,
4.4878597366127E-14,
4.13675170507499E-14,
  0,
-1.8588646247264E-14,
-1.73460421373783E-14,
-2.05772898720369E-14,
-1.20140442733119E-14,
-1.5485876470045E-14,
0.842319572634655,
-1.20535092323903E-14,
0.564901383789412,
-1.70737989718672E-14,
0.840874266114532,
-1.70037595115247E-14,
-1.8322583034136E-14,
-1.81146330574533E-14,
-1.5486310150914E-14,
-1.01928014639707E-14,
  0,
  0,
  0,
1.09638860490424E-14,
  0,
1.90047630410639E-14,
  0,
2.55928091219548E-14,
  0,
2.65087431172706E-14,
  0,
3.29766595974501E-14,
  0,
3.73633415873265E-14,
2.14507231421912E-14,
4.97019959910805E-14,
3.48011550133087E-14,
5.9534408652917E-14,
4.36664593372882E-14,
6.52381794419288E-14,
4.23840650076723E-14,
6.8887603954515E-14,
4.54055196219549E-14,
6.96439433900409E-14,
4.47723455532234E-14,
6.38256808516147E-14,
4.60946385227867E-14,
5.80173929731753E-14,
4.08505694549088E-14,
4.85956760942763E-14,
4.35445950131008E-14,
5.60341703592648E-14,
4.75431326252274E-14,
5.85555909315971E-14,
  0,
-1.22566887195141E-14,
-2.05482332538143E-14,
-1.67301068831893E-14,
-2.33242244962462E-14,
0.833437219948181,
-1.80452441184142E-14,
0.507111865102913,
-1.91038591196291E-14,
0.504732140241031,
-1.8848637928226E-14,
0.829971059101254,
-1.8849938970833E-14,
-1.77349454566489E-14,
-1.59225931051221E-14,
-1.15979274795119E-14,
  0,
  0,
  0,
  0,
1.56133786455293E-14,
  0,
2.7526158435931E-14,
  0,
2.95002737515926E-14,
  0,
3.50617972155742E-14,
  0,
4.44722383918794E-14,
2.03582810331948E-14,
5.20048414054397E-14,
3.20676644960383E-14,
6.36127435449385E-14,
4.17977284727922E-14,
7.14072898033713E-14,
4.94526294914088E-14,
7.95318672031087E-14,
5.52578816037652E-14,
8.23594664689509E-14,
5.28652642495242E-14,
7.48424759666744E-14,
5.00970792627342E-14,
7.18505116514834E-14,
5.2580335918595E-14,
6.5893471234979E-14,
5.34086663783739E-14,
6.54615250894608E-14,
5.40227584888697E-14,
6.73107403148521E-14,
5.17910367370256E-14,
  0,
-1.24532545733858E-14,
-1.20140442733119E-14,
-2.33242244962462E-14,
0.831066127746857,
-2.52445633841525E-14,
0.486641753359994,
-2.40304737914032E-14,
0.437246963562738,
-2.0794997668272E-14,
0.479600515134732,
-2.03786640340375E-14,
0.824177123979284,
-1.57903204400789E-14,
-1.32771398042575E-14,
  0,
  0,
  0,
  0,
1.0096524311054E-14,
  0,
2.35349933985773E-14,
  0,
3.06720794596149E-14,
  0,
3.73659436725404E-14,
  0,
4.5777184126683E-14,
1.97285764114152E-14,
5.81752528094892E-14,
3.0438759152096E-14,
6.47181960800047E-14,
3.82732040504763E-14,
7.40215180816683E-14,
4.65938052029991E-14,
8.40846489658098E-14,
6.12253303611254E-14,
9.13193132223711E-14,
6.15878875676046E-14,
8.58774856782318E-14,
5.70958211265626E-14,
8.13151629364128E-14,
5.54912019112841E-14,
7.83192954934009E-14,
6.40069594548542E-14,
8.14782269431547E-14,
6.27701016164828E-14,
7.53537857112185E-14,
5.71608732569118E-14,
7.64614066506297E-14,
  0,
  0,
-1.55396528978002E-14,
0.833437219948181,
-2.52174583298403E-14,
0.481143547642906,
-3.11794860763381E-14,
0.412791146261775,
-2.57350564469849E-14,
0.407350101284771,
-2.1992390547565E-14,
0.466109855115491,
-1.73272854397943E-14,
0.820653100894044,
  0,
  0,
  0,
  0,
  0,
  0,
1.79123209320675E-14,
  0,
2.64640739877642E-14,
  0,
3.81743248123456E-14,
1.11672823766007E-14,
4.75791281373539E-14,
2.09528575045859E-14,
5.88756474129148E-14,
2.95024421559376E-14,
7.01366048572183E-14,
3.61950053262561E-14,
7.42938696673967E-14,
4.25111335022876E-14,
8.57551876731755E-14,
5.77047090666305E-14,
9.4768810854351E-14,
6.6792057995535E-14,
9.37730795791403E-14,
6.50460588169643E-14,
9.13080375197772E-14,
6.18168710664335E-14,
8.67899502265956E-14,
6.61892415876331E-14,
9.29247997993876E-14,
7.26163920661271E-14,
9.03999097801034E-14,
6.51718262689727E-14,
8.3545149964781E-14,
5.54781914852143E-14,
  0,
  0,
0.842319572634655,
-1.80471956823247E-14,
0.486641753359994,
-3.10784384338625E-14,
0.406160137620627,
-3.26978027986868E-14,
0.380801050040177,
-2.66444852292658E-14,
0.391070714786782,
-1.89665991245924E-14,
0.457848503080682,
-1.12661616147314E-14,
0.81832070140422,
  0,
-1.0023232244194E-14,
  0,
  0,
1.32840786981614E-14,
  0,
2.05512690198972E-14,
  0,
3.3729095905155E-14,
1.13468262563643E-14,
4.80405645819637E-14,
2.36607608505857E-14,
6.02530178528404E-14,
3.05346026241438E-14,
7.03300265247897E-14,
3.49867704252382E-14,
7.91632384644636E-14,
4.00946637002519E-14,
8.5343190847631E-14,
5.32143773490645E-14,
9.57020920844265E-14,
6.27371418704392E-14,
9.64471558173585E-14,
6.97254753934118E-14,
9.84420878147318E-14,
6.92406201818763E-14,
9.60655166526436E-14,
7.19858200826096E-14,
1.00666003310934E-13,
7.42184091961917E-14,
1.01092745286024E-13,
7.44664746532564E-14,
9.7910395069345E-14,
6.30008198387877E-14,
8.75636368968813E-14,
  0,
0.867721831274621,
-1.20103579859254E-14,
0.507111865102913,
-2.40332927170517E-14,
0.412791146261775,
-3.27767327168438E-14,
0.373558655002243,
-3.35439141740945E-14,
0.363248405391263,
-2.33849398179053E-14,
0.381009331574224,
-1.21283191822918E-14,
0.452354695060273,
  0,
0.816684318697262,
  0,
-1.08741141091606E-14,
  0,
  0,
1.59247615094671E-14,
  0,
2.7672308888782E-14,
  0,
4.32761465551934E-14,
2.37058636609611E-14,
6.04048061569884E-14,
3.31306163059431E-14,
7.13717279721138E-14,
3.58454585458468E-14,
7.8906499390019E-14,
3.86947418551387E-14,
8.97120919218786E-14,
5.0489994130043E-14,
9.4768810854351E-14,
5.7891191840298E-14,
9.68019067681958E-14,
6.52828485714352E-14,
1.00569726158017E-13,
7.34612023989278E-14,
1.026036894336E-13,
7.90279300333374E-14,
1.0935610056384E-13,
7.95995214186718E-14,
1.08208580984481E-13,
7.56235352117329E-14,
1.07992607911722E-13,
7.18834713975269E-14,
1.01323463508329E-13,
6.42368103154212E-14,
0.999999999999997,
-1.02589377964923E-14,
0.564901383789412,
-1.91611049943363E-14,
0.437246963562738,
-2.56804126574917E-14,
0.380801050040177,
-3.34910051080772E-14,
0.355627839562135,
-3.05740675832222E-14,
0.352344492792924,
-1.6526710555631E-14,
0.374276019884784,
  0,
0.448487071131021,
  0,
0.815485955148288,
  0,
-1.0998146837693E-14,
1.0397932515005E-14,
  0,
2.28029400917151E-14,
  0,
3.71239497476417E-14,
1.91339999400242E-14,
5.54521706330746E-14,
3.30022467687208E-14,
7.12520320522714E-14,
3.829315337045E-14,
7.95682963961042E-14,
3.93504673290579E-14,
8.91717255591118E-14,
4.88923138086683E-14,
9.87933693186172E-14,
5.49699175067531E-14,
9.54809148412394E-14,
6.02478136824125E-14,
1.00502939304192E-13,
6.8734948288629E-14,
1.04307187887009E-13,
8.28885571291238E-14,
1.15414622303689E-13,
8.62643290133747E-14,
1.16469334177083E-13,
8.06542332920657E-14,
1.14701650955062E-13,
7.2703128239926E-14,
1.10970260758236E-13,
7.28332325006242E-14,
1.11044853867703E-13,
  0,
0.867364964374359,
-1.70735821314327E-14,
0.504732140241031,
-2.08227532438876E-14,
0.407350101284771,
-2.66965269335451E-14,
0.363248405391263,
-3.05736339023532E-14,
0.344470887732739,
-2.36603271697167E-14,
0.345021032718462,
-1.0997713156824E-14,
0.369514170246202,
  0,
0.445647454720562,
  0,
0.814578919378522,
1.06087014173362E-14,
  0,
1.73160097372005E-14,
  0,
3.22415705245049E-14,
1.19730614311919E-14,
4.91030827109995E-14,
2.83670656409107E-14,
6.60860255408124E-14,
3.80528941690272E-14,
7.92517093617384E-14,
4.17079565329104E-14,
8.95984675342021E-14,
4.94283433627452E-14,
9.78644248972316E-14,
5.31675398152132E-14,
9.918021265376E-14,
5.71166378082744E-14,
9.88592888107043E-14,
6.34587868364456E-14,
1.03923813998819E-13,
7.78812778157167E-14,
1.16731277421955E-13,
8.98977073338081E-14,
1.22144482028741E-13,
8.70978636435815E-14,
1.2253306008736E-13,
7.75187206092376E-14,
1.17262102805604E-13,
7.34100280563865E-14,
1.20307409867682E-13,
6.81434075833209E-14,
  0,
-1.3835720763522E-14,
0.840874266114531,
-1.91001728322426E-14,
0.479600515134732,
-2.19351446728577E-14,
0.391070714786782,
-2.32856268989057E-14,
0.352344492792924,
-2.35909382306776E-14,
0.336968799433662,
-1.78719886112511E-14,
0.339828173682782,
  0,
0.366006144277868,
  0,
0.443493939383353,
  0,
0.813874113778782,
1.73671840797418E-14,
  0,
2.66089233980082E-14,
  0,
4.40975381210684E-14,
2.12304132607422E-14,
5.96050986345631E-14,
3.3286741418781E-14,
7.39191693965857E-14,
4.13748896255228E-14,
8.90372844897236E-14,
5.16609324763273E-14,
9.8060448650017E-14,
5.35734651085917E-14,
9.79719777527421E-14,
5.51390530456608E-14,
1.02252407929715E-13,
6.02243949154868E-14,
1.01973984811821E-13,
7.24186335898658E-14,
1.16046929010682E-13,
8.46527709041922E-14,
1.2312373343093E-13,
9.04909827625922E-14,
1.27895090351604E-13,
8.37272959297586E-14,
1.24789935329606E-13,
7.80174536085809E-14,
1.26322563520631E-13,
6.85467307914855E-14,
1.26424044843976E-13,
-1.05174115944129E-14,
-1.24191022049525E-14,
-1.70035426710902E-14,
0.829971059101254,
-2.03782303531685E-14,
0.466109855115491,
-1.89913189341251E-14,
0.381009331574224,
-1.65856911538143E-14,
0.345021032718462,
-1.7875024377334E-14,
0.331644736769799,
-1.3834419720915E-14,
0.335995023288569,
  0,
0.363338805170475,
  0,
0.441817988598883,
1.61832353073876E-14,
0.813314567390802,
2.66089233980082E-14,
  0,
3.83972367790086E-14,
1.8473937657415E-14,
5.4526695658641E-14,
2.60347299274599E-14,
6.73332917200398E-14,
3.65428173831894E-14,
8.35616298378028E-14,
5.12818953968264E-14,
9.73379363222726E-14,
5.57080423457812E-14,
9.79598346884103E-14,
5.54348233983148E-14,
1.00875037489789E-13,
5.81583392555984E-14,
1.05177151710212E-13,
6.90923013246802E-14,
1.13912351773493E-13,
7.89767556907961E-14,
1.22178309136523E-13,
8.50621656445227E-14,
1.28605459615017E-13,
8.69287281046738E-14,
1.29887420263763E-13,
8.40534239432422E-14,
1.33565901394572E-13,
7.30127763803878E-14,
1.3211393784518E-13,
6.83515744004382E-14,
  0,
-1.58011624618037E-14,
-1.83156441402321E-14,
-1.89115216542302E-14,
0.824177123979284,
-1.73238159928424E-14,
0.457848503080682,
-1.21699525457153E-14,
0.374276019884784,
-1.10259024133086E-14,
0.339828173682782,
-1.3834419720915E-14,
0.32771219048399,
  0,
0.333075997265837,
  0,
0.361258750123492,
1.44190215323192E-14,
0.440485811459652,
2.49175680089309E-14,
0.81286231764853,
3.83365214573494E-14,
1.70766178975157E-14,
4.8689351161979E-14,
2.34231037343768E-14,
6.21057025251837E-14,
2.92205495910913E-14,
7.68187596866809E-14,
4.63986488119517E-14,
9.16870745992782E-14,
5.5197166282106E-14,
9.7081197247828E-14,
5.74262859487362E-14,
1.00697228333502E-13,
5.83222706240782E-14,
1.03641921433972E-13,
6.68527733171942E-14,
1.16905617131291E-13,
7.55289927822922E-14,
1.198511775935E-13,
7.92725260434501E-14,
1.27444929609588E-13,
8.13992970249977E-14,
1.30360999772705E-13,
8.71195476870312E-14,
1.38418790318617E-13,
7.89195098160889E-14,
1.39121353326388E-13,
7.26814441964763E-14,
1.38179398478933E-13,
  0,
-1.55439897064902E-14,
-1.81128983339773E-14,
-1.77106593279852E-14,
-1.57903204400789E-14,
0.820653100894044,
-1.12796057216702E-14,
0.452354695060273,
  0,
0.369514170246202,
  0,
0.335995023288569,
  0,
0.324715964742422,
  0,
0.330796910359612,
1.00362426702638E-14,
0.359602670713217,
2.38767339233448E-14,
0.439408012588455,
3.72315026031522E-14,
0.812491196216809,
4.8618227499464E-14,
2.18713935851156E-14,
5.62154489625044E-14,
2.66444852292658E-14,
7.15191794675718E-14,
3.90642379555217E-14,
8.49181835960167E-14,
5.02133057356247E-14,
9.1398243140528E-14,
5.68373473286421E-14,
9.96563942479156E-14,
6.02486810441505E-14,
1.03278496865755E-13,
6.69872143865824E-14,
1.15201251316144E-13,
7.32018612392693E-14,
1.22651021283726E-13,
7.56738421925363E-14,
1.24926978484208E-13,
7.54899615040827E-14,
1.29009650184919E-13,
8.14417977501591E-14,
1.38725836373865E-13,
8.18702744487254E-14,
1.43746126113342E-13,
7.85309317574701E-14,
1.44960432546526E-13,
7.12867265217909E-14,
-1.00328816435291E-14,
-1.18125995096641E-14,
-1.54880448743899E-14,
-1.58983069764584E-14,
-1.33361204024407E-14,
  0,
0.81832070140422,
  0,
0.448487071131021,
  0,
0.366006144277868,
  0,
0.333075997265837,
  0,
0.322375669501036,
  0,
0.328980599731439,
1.9374259141447E-14,
0.358261049790113,
3.5678925092153E-14,
0.438522831088767,
4.71428451831457E-14,
0.812182645480835,
5.60818752548542E-14,
2.50389986522492E-14,
6.55560675189015E-14,
3.64083763138012E-14,
7.95370713735366E-14,
4.28060364932037E-14,
8.44315936610052E-14,
5.18630277612786E-14,
9.38589483912011E-14,
5.95929555702313E-14,
1.0219863150196E-13,
6.87921941633363E-14,
1.14713794019394E-13,
7.32660460078804E-14,
1.20803540781811E-13,
7.33120161799938E-14,
1.27591513743308E-13,
7.17984699472041E-14,
1.26312155179775E-13,
7.55177170796983E-14,
1.37176728309818E-13,
7.60832369328668E-14,
1.43860617862757E-13,
8.13377143416005E-14,
1.49429080220642E-13,
7.7042539015082E-14,
1.46847811688389E-13,
  0,
-1.21051172558007E-14,
-1.01928014639707E-14,
-1.16013969264639E-14,
  0,
  0,
  0,
0.816684318697262,
  0,
0.445647454720562,
  0,
0.363338805170475,
  0,
0.330796910359612,
  0,
0.320509979588327,
1.24527124722995E-14,
0.327508003156811,
3.10255293678452E-14,
0.357157997341188,
4.54246015801907E-14,
0.437786386131618,
5.42925079893841E-14,
0.811923183470066,
6.54268306199413E-14,
3.46346215596149E-14,
7.34100280563865E-14,
4.02603297922077E-14,
7.89516022003944E-14,
4.44392786458359E-14,
8.68107669083074E-14,
5.44694497839338E-14,
9.62407237237173E-14,
6.80904985173036E-14,
1.13469129925381E-13,
7.50068410160232E-14,
1.20228479949525E-13,
7.32053306862213E-14,
1.25604388001577E-13,
6.93178153765572E-14,
1.28870872306841E-13,
7.17412240724968E-14,
1.34331781809216E-13,
7.00463992364675E-14,
1.42202222219723E-13,
7.54604712049911E-14,
1.49345813493795E-13,
7.97972798949331E-14,
1.51132578674051E-13,
7.50458722942327E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.815485955148288,
  0,
0.443493939383353,
  0,
0.361258750123492,
1.00778760336873E-14,
0.328980599731439,
1.24318957905878E-14,
0.31899695057376,
2.41664327438329E-14,
0.326296470041122,
4.10131997807817E-14,
0.356239458942884,
5.28240645669698E-14,
0.43716674820195,
6.36227182049254E-14,
0.811702809668153,
7.33788030338189E-14,
3.85550966153225E-14,
7.29147645039951E-14,
4.16533127434171E-14,
8.13221018303167E-14,
4.69953936876877E-14,
8.91422352600202E-14,
6.29487781345084E-14,
1.07470456145453E-13,
7.42470321335453E-14,
1.1890662066083E-13,
7.49678097378137E-14,
1.24946927804181E-13,
6.91911805628109E-14,
1.26801347200001E-13,
6.91703638810992E-14,
1.36784680804247E-13,
6.62161298015107E-14,
1.39227171458423E-13,
6.93525098460768E-14,
1.47545170525731E-13,
7.38142186262891E-14,
1.50929616027362E-13,
7.77433672993766E-14,
1.59970994784153E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.08758488326366E-14,
  0,
0.814578919378522,
  0,
0.441817988598883,
1.44207562557952E-14,
0.359602670713217,
1.94852814439095E-14,
0.327508003156811,
2.41725042759988E-14,
0.31775188197501,
3.43076261843933E-14,
0.325287043120977,
4.86329726490098E-14,
0.355466019584946,
6.2227133168502E-14,
0.436640201138821,
7.14688724867685E-14,
0.811513970206581,
7.26675664086684E-14,
3.99845087595274E-14,
7.52774578782756E-14,
4.43265216198974E-14,
8.35321395387112E-14,
5.54408949304808E-14,
1.00265282187983E-13,
6.90315860030211E-14,
1.12769169002824E-13,
7.4124734128489E-14,
1.23467208679173E-13,
7.08356984180369E-14,
1.26031129976667E-13,
6.89812790222177E-14,
1.3459719450104E-13,
6.36348612692572E-14,
1.41581191215323E-13,
6.54407084077491E-14,
1.44485118314108E-13,
6.7612582199672E-14,
1.48997134075124E-13,
7.16822434743136E-14,
1.5962751953591E-13,
7.54899615040827E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.09721259855533E-14,
1.06121708642881E-14,
0.813874113778782,
1.61927762865055E-14,
0.440485811459652,
2.39461228623838E-14,
0.358261049790113,
3.10558870286748E-14,
0.326296470041122,
3.43154324400352E-14,
0.316714324809382,
4.12361117474447E-14,
0.324436678367385,
5.77905778786914E-14,
0.354808350843284,
6.99067539966514E-14,
0.436188810381527,
7.07923303311375E-14,
0.811350867466097,
7.49894937812634E-14,
4.24903168205759E-14,
7.75404046526873E-14,
5.27113075410313E-14,
9.47193712352856E-14,
6.148206943557E-14,
1.05570066577521E-13,
6.88823997840871E-14,
1.17324552850739E-13,
7.00342561721357E-14,
1.24462939954384E-13,
7.05824287905443E-14,
1.3373503693348E-13,
6.33833263652406E-14,
1.39261865927942E-13,
6.28663787693995E-14,
1.46698625469455E-13,
6.3653943227493E-14,
1.45853815136654E-13,
6.54337695138452E-14,
1.57590954175113E-13,
6.9408020997308E-14,
1.56270829609895E-13,
  0,
  0,
1.09088085786802E-14,
  0,
1.00921875023641E-14,
  0,
1.32957880816242E-14,
  0,
1.03710443011273E-14,
  0,
1.73134076519865E-14,
0.813314567390802,
2.48976186889571E-14,
0.439408012588455,
3.57387730520742E-14,
0.357157997341188,
4.09429434800046E-14,
0.325287043120977,
4.12898881752E-14,
0.315840127708129,
5.09618389155087E-14,
0.323713312723886,
6.54311674286312E-14,
0.354244240160305,
6.95650134718839E-14,
0.435798797431083,
7.28696616936197E-14,
0.81120898826297,
7.71587654879724E-14,
5.09280118077271E-14,
8.86044709824674E-14,
5.87481452374305E-14,
9.98923166406485E-14,
6.13380873870639E-14,
1.10064735103776E-13,
6.4772839869498E-14,
1.18233547952151E-13,
6.97150670525559E-14,
1.32180724699005E-13,
6.49567205579515E-14,
1.38328584697867E-13,
6.2606170248003E-14,
1.44358483500362E-13,
6.10518580135277E-14,
1.47985790288629E-13,
6.14230888373868E-14,
1.54298449017709E-13,
6.30849539273726E-14,
1.54126711393587E-13,
6.09234884763055E-14,
  0,
1.36730904376492E-14,
  0,
1.55856230699136E-14,
  0,
1.78980094633907E-14,
  0,
1.59160878920872E-14,
  0,
1.7352438930196E-14,
  0,
2.65803004606546E-14,
0.81286231764853,
3.72236963475103E-14,
0.438522831088767,
4.54540918792823E-14,
0.356239458942884,
4.85774614977785E-14,
0.324436678367385,
5.09627062772466E-14,
0.315096391143676,
5.86206430619463E-14,
0.323092640146989,
6.48092690624935E-14,
0.3537565998976,
7.17013254325494E-14,
0.435459427101372,
7.5543737931838E-14,
0.811084774506056,
8.80667067049146E-14,
5.71730163212436E-14,
9.3721905236599E-14,
5.85833465072128E-14,
1.04336678186101E-13,
5.71591385334358E-14,
1.1097719965214E-13,
6.44553854733942E-14,
1.25862861799497E-13,
6.40841546495352E-14,
1.36684066842641E-13,
6.41882380580938E-14,
1.43328057755632E-13,
6.07361383409E-14,
1.45520748229266E-13,
5.87706966426182E-14,
1.56404403317545E-13,
5.90760079743902E-14,
1.50778695084952E-13,
5.46489936636974E-14,
1.55564797155172E-13,
  0,
  0,
1.90338196592865E-14,
  0,
2.3563182655062E-14,
  0,
2.05599426372771E-14,
  0,
2.28324303908067E-14,
  0,
2.67086699978769E-14,
  0,
3.83868284381528E-14,
0.812491196216809,
4.70908034788664E-14,
0.437786386131618,
5.28249319287077E-14,
0.355466019584946,
5.77897105169534E-14,
0.323713312723886,
5.86752868514395E-14,
0.314458167379021,
5.77515466004819E-14,
0.322555947634766,
6.71225228177086E-14,
0.353332101386125,
7.3670236577783E-14,
0.435162229636938,
8.70553629184201E-14,
0.810975388926026,
9.32517951746092E-14,
5.67948466034807E-14,
9.81437153768638E-14,
5.42933753511221E-14,
1.05275163586604E-13,
5.6770560474817E-14,
1.18563145412587E-13,
5.87412063435266E-14,
1.30378347007465E-13,
6.32324054228306E-14,
1.41610681514415E-13,
6.23182061509908E-14,
1.44467771079348E-13,
5.84445686291346E-14,
1.53871707042619E-13,
5.63733087988183E-14,
1.52758014571042E-13,
5.05880060064356E-14,
1.52097084926694E-13,
4.59597637725295E-14,
  0,
1.63350236115356E-14,
  0,
2.74905966046735E-14,
  0,
2.64358847312796E-14,
  0,
2.76601658244502E-14,
  0,
3.22424378862429E-14,
  0,
3.83972367790086E-14,
1.69655955950532E-14,
4.84993989413596E-14,
0.812182645480835,
5.42916406276461E-14,
0.43716674820195,
6.22583581910696E-14,
0.354808350843284,
6.55048931763602E-14,
0.323092640146989,
5.77029743431545E-14,
0.3139062443121,
6.00222996305355E-14,
0.322088628582285,
6.94930224476309E-14,
0.352960218161945,
8.4590320859057E-14,
0.434900446666364,
9.11163505756818E-14,
0.810878545591901,
9.76267677810227E-14,
5.26037546855207E-14,
9.89729131983808E-14,
5.39880640193502E-14,
1.12831619047959E-13,
5.10962799848969E-14,
1.22939852742476E-13,
5.78651709881584E-14,
1.35265063039292E-13,
6.13363526635879E-14,
1.4271223092166E-13,
6.00127586514176E-14,
1.52778831252753E-13,
5.60402418914308E-14,
1.50192358550072E-13,
4.78488776378683E-14,
1.54024362708505E-13,
4.18918372213639E-14,
1.516634040577E-13,
  0,
  0,
2.56123247610596E-14,
  0,
3.06733805022219E-14,
  0,
3.36753194773998E-14,
  0,
3.71040004276679E-14,
1.20025517302835E-14,
4.4126161058422E-14,
1.84583251461312E-14,
4.87179740993327E-14,
2.19000165224692E-14,
5.60844773400682E-14,
0.811923183470066,
6.36097077788556E-14,
0.436640201138821,
6.99258359548871E-14,
0.354244240160305,
6.48387593615851E-14,
0.322555947634766,
6.00301058861774E-14,
0.313425622311243,
6.23719825787461E-14,
0.321679140253483,
8.03645344715775E-14,
0.352632543331374,
9.02437846672655E-14,
0.434668629916756,
9.56804080409768E-14,
0.810792385415738,
9.84351489208279E-14,
5.21284404531031E-14,
1.06532838106688E-13,
4.82825585068625E-14,
1.17218734718705E-13,
5.01959585008649E-14,
1.27895957713342E-13,
5.59743223993436E-14,
1.36338856870921E-13,
5.89840676301634E-14,
1.50966045220358E-13,
5.75459818685786E-14,
1.49052645226355E-13,
4.75158107304807E-14,
1.51418808047588E-13,
3.91631171936524E-14,
1.53524762347423E-13,
4.1288153451724E-14,
  0,
2.15842968498414E-14,
  0,
2.94785897081429E-14,
  0,
3.81743248123456E-14,
1.13459588946263E-14,
4.33021674073331E-14,
1.91357346635002E-14,
4.9137777180519E-14,
2.12200049198863E-14,
5.45423081699248E-14,
2.34265731813288E-14,
5.61989690894826E-14,
2.50962445269565E-14,
6.54250958964653E-14,
0.811702809668153,
7.14116266120612E-14,
0.436188810381527,
6.95676155570979E-14,
0.3537565998976,
6.71051755829488E-14,
0.322088628582285,
6.23980034308858E-14,
0.313004445663128,
7.34898253362815E-14,
0.32131825918272,
8.53882936580064E-14,
0.352342294394677,
9.40445638031306E-14,
0.43446234614595,
9.6856550557689E-14,
0.81071538343205,
1.05988134935231E-13,
4.66588573333482E-14,
1.10871381520106E-13,
4.73839717463065E-14,
1.22079429898392E-13,
4.83536821693775E-14,
1.28886484818125E-13,
5.3700099922338E-14,
1.44557976700099E-13,
5.65728019985556E-14,
1.47248532811339E-13,
4.8993795132013E-14,
1.50258278042159E-13,
3.87832127524135E-14,
1.50893186834367E-13,
3.85368820188248E-14,
1.63622587701084E-13,
1.50261747489111E-14,
  0,
2.64887937972969E-14,
  0,
3.73676783960164E-14,
1.11811601644085E-14,
4.80422993054397E-14,
2.37058636609611E-14,
5.54556400800266E-14,
2.83688003643867E-14,
5.96328542101787E-14,
2.60659549500275E-14,
6.20935594608518E-14,
2.66097907597462E-14,
6.55595369658535E-14,
3.46797243699903E-14,
7.3371864139915E-14,
0.811513970206581,
7.07914629693995E-14,
0.435798797431083,
7.17152032203572E-14,
0.353332101386125,
6.94930224476309E-14,
0.321679140253484,
7.34898253362815E-14,
0.312633239125806,
7.83227649403528E-14,
0.320998540553087,
8.97702051583238E-14,
0.352083948644752,
9.52241757667949E-14,
0.434277957184388,
1.04626377006589E-13,
0.810646278867938,
1.10349229753837E-13,
4.55000620513957E-14,
1.15711260018081E-13,
4.54688370288281E-14,
1.2308903896141E-13,
4.59424165377698E-14,
1.37126421329015E-13,
5.12142411812633E-14,
1.40791892033754E-13,
4.79703082811866E-14,
1.48388246135056E-13,
4.02906874530373E-14,
1.49680615124659E-13,
3.81639164714898E-14,
1.6093376631332E-13,
3.16673770539566E-14,
  0,
2.31559563190764E-14,
  0,
3.51029968981287E-14,
  0,
4.75825975843058E-14,
2.3706731022699E-14,
6.04221533917482E-14,
3.30039814921967E-14,
6.60877602642884E-14,
3.33283747822044E-14,
6.72916583566163E-14,
2.92352947406371E-14,
7.15452003197115E-14,
3.64396013363688E-14,
7.34377836320022E-14,
3.85550966153225E-14,
7.26181267896031E-14,
0.811350867466097,
7.28696616936197E-14,
0.435459427101372,
7.3677175471687E-14,
0.352960218161945,
8.03627997481016E-14,
0.32131825918272,
7.83314385577327E-14,
0.312304353453016,
8.27879431675171E-14,
0.320713919806676,
9.06670571954038E-14,
0.351852971045607,
1.0276328399339E-13,
0.434112453907406,
1.08720324409894E-13,
0.810584021791451,
1.15076351225873E-13,
4.36872760189999E-14,
1.1671219546372E-13,
4.30627755676483E-14,
1.31278668491497E-13,
4.35207425653061E-14,
1.33292682447106E-13,
4.25805224413267E-14,
1.41848338630624E-13,
3.92307714092155E-14,
1.47775888748036E-13,
3.96904731303493E-14,
1.59655275111525E-13,
3.13134934648573E-14,
1.59251084541623E-13,
1.17106845054504E-14,
  0,
3.29766595974501E-14,
  0,
4.58088428301195E-14,
2.09268366524462E-14,
6.0284242875408E-14,
3.31297489442051E-14,
7.12260112001317E-14,
3.80667719568351E-14,
7.39191693965857E-14,
3.6572307682281E-14,
7.6811820792777E-14,
3.90850546372334E-14,
7.94815602223053E-14,
4.02603297922077E-14,
7.29095603335672E-14,
3.99836413977894E-14,
7.49608708439098E-14,
0.81120898826297,
7.54613385667291E-14,
0.435162229636938,
8.46735875859039E-14,
0.352632543331374,
8.53466602945829E-14,
0.320998540553087,
8.28313112544166E-14,
0.312011556684276,
8.38912272982384E-14,
0.320459415086694,
9.79702430292662E-14,
0.351645608607763,
1.07094888512904E-13,
0.433963329474605,
1.13501222309687E-13,
0.810527731975134,
1.16467599453607E-13,
4.11875394901173E-14,
1.24924376398994E-13,
4.07434502802673E-14,
1.2743105182178E-13,
3.5006719745212E-14,
1.34401170748255E-13,
3.38305772284997E-14,
1.4119434788018E-13,
3.86340265334795E-14,
1.57726262606239E-13,
3.27689264612019E-14,
1.57922286359025E-13,
2.02823868811208E-14,
  0,
2.44040898600417E-14,
  0,
4.44414470501808E-14,
1.97394184331401E-14,
5.88782494981288E-14,
3.05502151354275E-14,
7.13743300573277E-14,
3.829315337045E-14,
7.92517093617384E-14,
4.13506034968592E-14,
8.35616298378028E-14,
4.63995161736896E-14,
8.49190509577546E-14,
4.28051691314657E-14,
7.89802251377481E-14,
4.16489759347272E-14,
7.52783252400135E-14,
4.25250112900954E-14,
7.71761127227322E-14,
0.811084774506056,
8.70709754297039E-14,
0.434900446666364,
9.02437846672655E-14,
0.352342294394677,
8.975459264704E-14,
0.320713919806676,
8.38929620217144E-14,
0.31174972880454,
9.11163505756818E-14,
0.320230902244115,
1.02445829597286E-13,
0.351458733242403,
1.11721396023334E-13,
0.433828481527237,
1.14684303720303E-13,
0.81047666686728,
1.24312019011974E-13,
3.87918863697934E-14,
1.2103686108933E-13,
3.21166704342346E-14,
1.28471885907366E-13,
2.61162619308308E-14,
1.33721159145672E-13,
3.32511795875234E-14,
1.51130843950575E-13,
3.17055409704281E-14,
1.55955109937267E-13,
2.17464934948453E-14,
1.457133025351E-13,
1.64861613943801E-14,
  0,
3.73355860117108E-14,
2.03795313957755E-14,
5.81860948312141E-14,
2.95319324550292E-14,
7.03317612482657E-14,
3.58203050554451E-14,
7.95960519717198E-14,
4.17096912563863E-14,
8.90286108723437E-14,
5.1311385695918E-14,
9.16810030671122E-14,
5.02107036504107E-14,
8.44671554922627E-14,
4.44123904319582E-14,
8.13151629364128E-14,
4.43837674946046E-14,
7.75404046526873E-14,
5.09314812546791E-14,
8.80632372579626E-14,
0.810975388926026,
9.10903297235421E-14,
0.434668629916756,
9.39665012467117E-14,
0.352083948644752,
9.06601183014999E-14,
0.320459415086694,
9.11198200226337E-14,
0.311514630815805,
9.528662581193E-14,
0.320024942787465,
1.07002948168677E-13,
0.351289720408081,
1.1279692457844E-13,
0.433706135993604,
1.22643215028084E-13,
0.810430196428342,
1.20268378589472E-13,
3.0293476060983E-14,
1.22160961901763E-13,
2.3411828031783E-14,
1.2778493541088E-13,
2.5507373990763E-14,
1.43531020402321E-13,
2.6324428747948E-14,
1.49364895452031E-13,
2.06674954927877E-14,
1.43669798280399E-13,
1.45924938799169E-14,
  0,
3.31939337128162E-14,
2.14498557804532E-14,
5.20044077245707E-14,
3.04600095146768E-14,
7.01279312398384E-14,
3.49720252756924E-14,
7.8906499390019E-14,
3.9341793711678E-14,
8.95845897463943E-14,
5.16644019232793E-14,
9.73578856422463E-14,
5.51928294734161E-14,
9.13670181179604E-14,
5.1832670100449E-14,
8.68142363552593E-14,
4.70196798163514E-14,
8.35607624760648E-14,
5.26930929445335E-14,
8.85767154068517E-14,
5.7145260745628E-14,
9.31997534703299E-14,
0.810878545591901,
9.56804080409768E-14,
0.43446234614595,
9.51929507442273E-14,
0.351852971045607,
9.78800374085154E-14,
0.320230902244115,
9.54011175613445E-14,
0.311302728113588,
1.00320793339215E-13,
0.319838650948619,
1.07905004376185E-13,
0.351136354493186,
1.2070032473499E-13,
0.433594787193692,
1.18292528550334E-13,
0.810387783194705,
1.21576360090359E-13,
2.16562878740945E-14,
1.21392479401905E-13,
2.28254914969028E-14,
1.37634695307476E-13,
1.85979703859473E-14,
1.41740785775113E-13,
1.53384249745869E-14,
1.37022337920456E-13,
1.34545152796761E-14,
1.37905312169728E-13,
2.18306275834301E-14,
2.29577641619461E-14,
4.96855161180587E-14,
3.20702665812522E-14,
6.47346759530265E-14,
3.61958726879941E-14,
7.91493606766558E-14,
3.86956092168766E-14,
8.91335616426403E-14,
4.94248739157932E-14,
9.8055244479589E-14,
5.57384000066108E-14,
9.7085534056518E-14,
5.68633681807817E-14,
9.38641525616291E-14,
5.44694497839338E-14,
8.91422352600202E-14,
5.54443643774327E-14,
9.4693350383146E-14,
5.87585535782864E-14,
9.3721905236599E-14,
5.68035202208605E-14,
9.768401365573E-14,
0.810792385415738,
9.69536950723437E-14,
0.434277957184388,
1.02759814546438E-13,
0.351645608607763,
1.02442360150334E-13,
0.320024942787465,
1.00282629422743E-13,
0.311111053994837,
1.01141317543352E-13,
0.319669589985384,
1.16563009244786E-13,
0.350996754384718,
1.16804135807946E-13,
0.433493150362717,
1.19635204520741E-13,
0.810348966360387,
1.20972676320719E-13,
2.08288247760535E-14,
1.31165911465558E-13,
1.57582280557733E-14,
1.35782010635133E-13,
  0,
1.29389554626158E-13,
  0,
1.31205810105506E-13,
  0,
1.90112682540988E-14,
4.32839528108353E-14,
3.47872772255009E-14,
6.35988657571307E-14,
3.83096332434718E-14,
7.43077474552045E-14,
4.00703775715883E-14,
8.97450516679221E-14,
4.89113957669041E-14,
9.78661596207075E-14,
5.36046901311593E-14,
9.79476916240785E-14,
5.7445367906972E-14,
9.96702720357234E-14,
5.9614639613681E-14,
9.62008250837698E-14,
6.29349003467006E-14,
1.00269618996673E-13,
6.14890083294739E-14,
9.98923166406485E-14,
5.85226311855536E-14,
9.81714709524795E-14,
5.26731436245598E-14,
9.84212711330201E-14,
0.81071538343205,
1.04633315900493E-13,
0.434112453907406,
1.07153869111087E-13,
0.351458733242403,
1.07009887062581E-13,
0.319838650948619,
1.01207237035439E-13,
0.310937103167888,
1.09091555233753E-13,
0.319515690571475,
1.12319875622546E-13,
0.350869314430973,
1.17839765723105E-13,
0.433400123725735,
1.19045398538908E-13,
0.810313348973984,
1.30426919264792E-13,
1.40078920685127E-14,
1.29321900410595E-13,
  0,
1.23441187827034E-13,
  0,
1.23630272685915E-13,
  0,
1.28723420811383E-13,
2.81669219198699E-14,
3.49152130818542E-14,
5.95482864407249E-14,
4.1812039941469E-14,
7.39902930591008E-14,
4.25120008640256E-14,
8.53761505936745E-14,
5.0487392044829E-14,
9.87517359551937E-14,
5.31675398152132E-14,
9.79442221771265E-14,
5.54348233983148E-14,
1.00677279013528E-13,
6.02486810441505E-14,
1.02171743288082E-13,
6.8063610303426E-14,
1.07421883888126E-13,
6.90038304274054E-14,
1.05568331854045E-13,
6.13380873870639E-14,
1.04338412909577E-13,
5.42794975633143E-14,
9.89746479218567E-14,
5.21509918582908E-14,
1.05988134935231E-13,
0.810646278867938,
1.0872205913337E-13,
0.433963329474605,
1.11601700103492E-13,
0.351289720408081,
1.07965719697845E-13,
0.319669589985384,
1.0919216919536E-13,
0.31077874793232,
1.05363634483879E-13,
0.319375186039052,
1.1340928196546E-13,
0.350752657252634,
1.1712159020405E-13,
0.433314757981787,
1.28388619180519E-13,
0.810280587570906,
1.28980159885828E-13,
  0,
1.17007098454636E-13,
  0,
1.17628129459035E-13,
-1.30572636036774E-14,
1.21047269430186E-13,
-1.05089548174675E-14,
2.13104273810716E-14,
5.07033651175881E-14,
4.36456426555765E-14,
7.14094582077163E-14,
4.65625801804315E-14,
8.57612592053414E-14,
5.32004995612567E-14,
9.47835560038968E-14,
5.49543049954693E-14,
9.91489876311924E-14,
5.51668086212764E-14,
1.00862894425457E-13,
5.82953824102006E-14,
1.03258547545781E-13,
6.87791837372664E-14,
1.13444843796717E-13,
7.42123376640258E-14,
1.12769169002824E-13,
6.88823997840871E-14,
1.10095960126344E-13,
5.71348524047721E-14,
1.05290776097888E-13,
5.4001941807158E-14,
1.06494674190216E-13,
4.65773253299773E-14,
1.1043423120416E-13,
0.810584021791451,
1.13411016688936E-13,
0.433828481527237,
1.1279692457844E-13,
0.351136354493186,
1.16510967540506E-13,
0.319515690571475,
1.0529424554484E-13,
0.310634171658801,
1.06194567028872E-13,
0.319246560598557,
1.12717127298545E-13,
0.35064559575228,
1.26730223537486E-13,
0.433236231583107,
1.27087576573537E-13,
0.810250383723996,
1.16471068900559E-13,
  0,
1.1117148868145E-13,
-1.58120044835286E-14,
1.15102372078013E-13,
-1.82458215203241E-14,
1.15485745966204E-13,
3.03977763099761E-14,
3.47937824385358E-14,
6.52537919532126E-14,
4.94565326192298E-14,
8.40898531362377E-14,
5.77029743431545E-14,
9.57203066809242E-14,
5.78877223933461E-14,
9.54687717769076E-14,
5.71018926587286E-14,
1.02280163505331E-13,
5.81305836799828E-14,
1.0363411517833E-13,
6.6938642129255E-14,
1.1472853916894E-13,
7.50068410160232E-14,
1.18878865085215E-13,
7.41264688519649E-14,
1.17347104255927E-13,
6.47485537408343E-14,
1.11004955227756E-13,
5.67428048992014E-14,
1.12831619047959E-13,
4.82947015711943E-14,
1.10886994031389E-13,
4.55243481800593E-14,
1.15076351225873E-13,
0.810527731975134,
1.14621853675168E-13,
0.433706135993604,
1.2070032473499E-13,
0.350996754384718,
1.12368447879874E-13,
0.319375186039052,
1.06222322604488E-13,
0.310501815592966,
1.05634251346132E-13,
0.319128507637879,
1.22624133069849E-13,
0.350547102322857,
1.25233157177718E-13,
0.43316383058134,
1.1443103409281E-13,
0.810222477116024,
1.10429027033732E-13,
-1.76230557924484E-14,
1.08612771554384E-13,
-2.10716860626903E-14,
1.09481868015848E-13,
-2.28237567734269E-14,
1.88332422573767E-14,
5.17866999283356E-14,
4.23962080720042E-14,
7.95327345648467E-14,
6.12253303611254E-14,
9.47826886421588E-14,
6.27336724234873E-14,
9.6788028980388E-14,
6.02608241084823E-14,
9.88627582576562E-14,
6.0213119212893E-14,
1.05162406560666E-13,
6.68562427641461E-14,
1.1518997561355E-13,
7.32643112844045E-14,
1.20272715398162E-13,
7.49660750143377E-14,
1.23481086466981E-13,
7.00290520017077E-14,
1.18219670164343E-13,
6.44553854733942E-14,
1.18566614859539E-13,
5.11379133483203E-14,
1.17260368082128E-13,
4.73839717463065E-14,
1.15718198911985E-13,
4.37462566171831E-14,
1.16443313324943E-13,
0.81047666686728,
1.22624133069849E-13,
0.433594787193692,
1.16807605254898E-13,
0.350869314430973,
1.13407547241984E-13,
0.319246560598557,
1.05634251346132E-13,
0.3103803360094,
1.15272374978659E-13,
0.31901989591306,
1.20497362088301E-13,
0.350456283732971,
1.12623452230842E-13,
0.433096932098565,
1.08893796757492E-13,
0.810196639827821,
1.07544181893182E-13,
-2.28636554133743E-14,
1.02966246640079E-13,
-2.56236004636534E-14,
1.13483875074927E-13,
2.93807946721847E-14,
3.07878722516364E-14,
6.88741598475762E-14,
5.52808666898219E-14,
9.13097722432532E-14,
6.67799149312032E-14,
9.64480231790965E-14,
6.53123388705268E-14,
1.00504674027668E-13,
6.34466437721137E-14,
1.0199133204658E-13,
6.90662804725406E-14,
1.16923831727789E-13,
7.32035959627453E-14,
1.20839102613068E-13,
7.32330862618369E-14,
1.24950397251133E-13,
7.08703928875565E-14,
1.2445600106048E-13,
6.97289448403637E-14,
1.25878474310781E-13,
5.87550841313345E-14,
1.22969343041568E-13,
5.01803459895811E-14,
1.22098511856628E-13,
4.55035314983476E-14,
1.16719134357623E-13,
4.11875394901173E-14,
1.24324162076306E-13,
0.810430196428342,
1.18292528550334E-13,
0.433493150362717,
1.17784254571873E-13,
0.350752657252634,
1.12675493935122E-13,
0.319128507637879,
1.15329620853366E-13,
0.310268569470297,
1.13317341621233E-13,
0.318919741964328,
1.08158274003678E-13,
0.350372360520421,
1.06659472920434E-13,
0.433034990694735,
1.06819067480224E-13,
0.810172671603626,
1.0231919478354E-13,
-2.73375072579185E-14,
1.06923150888782E-13,
-3.17471743338515E-14,
1.66761136149995E-14,
5.32733579472477E-14,
4.54055196219549E-14,
8.23737779376277E-14,
6.15930917380325E-14,
9.37453240035246E-14,
6.96942503708442E-14,
1.00561919902376E-13,
6.87427545442709E-14,
1.03902997317107E-13,
7.24116946959619E-14,
1.13910617050017E-13,
7.54942983127727E-14,
1.22677042135866E-13,
7.33154856269458E-14,
1.25607857448529E-13,
6.91946500097629E-14,
1.26029395253191E-13,
7.05963065783521E-14,
1.32139091335581E-13,
6.40616032443475E-14,
1.30393959518749E-13,
5.78651709881584E-14,
1.27890753542914E-13,
4.83415391050457E-14,
1.23099447302266E-13,
4.31009394841197E-14,
1.24920906952042E-13,
3.87918863697934E-14,
1.20209397991289E-13,
0.810387783194705,
1.1970459345978E-13,
0.433400123725735,
1.17131998544906E-13,
0.35064559575228,
1.22596377494233E-13,
0.31901989591306,
1.13313872174281E-13,
0.310165504478351,
1.00941824343614E-13,
0.318827187477639,
1.02086741837759E-13,
0.350294649989922,
1.0428116703487E-13,
0.432977527064266,
1.00324262786167E-13,
0.810150395906541,
1.06305589331335E-13,
-3.35408784080116E-14,
1.0755805968099E-13,
3.21340176689944E-14,
3.53918283568788E-14,
6.96387392196129E-14,
5.28726368242971E-14,
8.58896287425637E-14,
6.50668754986761E-14,
9.84351489208279E-14,
7.34672739310938E-14,
1.04310657333961E-13,
7.78882167096207E-14,
1.16066010968918E-13,
7.89906334786039E-14,
1.19867657466521E-13,
7.56339435525888E-14,
1.27574166508548E-13,
6.93108764826533E-14,
1.26763183283529E-13,
6.89778095752658E-14,
1.33759323062144E-13,
6.49567205579515E-14,
1.36684066842641E-13,
6.32289359758786E-14,
1.35280675550575E-13,
5.59708529523917E-14,
1.28888219541601E-13,
4.59111915152022E-14,
1.31296015726257E-13,
4.06983474698919E-14,
1.2100216661981E-13,
3.0290006614031E-14,
1.21513910045223E-13,
0.810348966360387,
1.19045398538908E-13,
0.433314757981787,
1.26757979113101E-13,
0.350547102322857,
1.20471341236161E-13,
0.318919741964328,
1.00872435404575E-13,
0.310070258209935,
9.50871326121927E-14,
0.318741480601275,
9.97379262512865E-14,
0.350222552110506,
9.88618908959182E-14,
0.432924118616575,
1.04553518620598E-13,
0.810129656616646,
1.06671615984766E-13,
-3.22207538427932E-14,
2.42037292985664E-14,
5.57557472413706E-14,
4.47723455532234E-14,
7.48563537544822E-14,
5.70975558500386E-14,
9.1322782669323E-14,
6.92111298827847E-14,
1.02617567221408E-13,
8.28677404474121E-14,
1.16722603804575E-13,
8.46562403511442E-14,
1.22188717477378E-13,
7.92612503408563E-14,
1.24911365972924E-13,
7.18123477350119E-14,
1.28843116731225E-13,
6.91495471993875E-14,
1.34611072288848E-13,
6.33902652591445E-14,
1.38356340273482E-13,
6.41899727815698E-14,
1.41608946790939E-13,
6.1332883216636E-14,
1.36330183253541E-13,
5.37157124336218E-14,
1.37109074094255E-13,
4.34929869896905E-14,
1.27434521268732E-13,
3.20993231994748E-14,
1.22174839689571E-13,
2.16840434497101E-14,
1.20972676320719E-13,
0.810313348973984,
1.28386884457043E-13,
0.433236231583107,
1.25233157177718E-13,
0.350456283732971,
1.08102762852447E-13,
0.318827187477639,
9.50923367826206E-14,
0.309982057311554,
9.25544363372666E-14,
0.318661960445326,
9.40636457613664E-14,
0.35015553775943,
1.02324398953968E-13,
0.432874391589348,
1.04610764495305E-13,
0.810110315254517,
1.1021392132271E-13,
3.22472083758019E-14,
3.87801769863305E-14,
6.38291502985666E-14,
5.00970792627342E-14,
8.13221018303167E-14,
6.18029932786257E-14,
9.60577103970017E-14,
7.90261953098614E-14,
1.15416357027165E-13,
8.98994420572841E-14,
1.23122866069192E-13,
8.50708392619026E-14,
1.27446664333064E-13,
7.55003698449386E-14,
1.26286134327636E-13,
7.16839781977896E-14,
1.36760394675584E-13,
6.36348612692572E-14,
1.39261865927942E-13,
6.25645368845795E-14,
1.4334193554344E-13,
6.23442270031305E-14,
1.4271223092166E-13,
5.89823329066874E-14,
1.44589201722667E-13,
5.12142411812633E-14,
1.33278804659298E-13,
3.5006719745212E-14,
1.28499641482982E-13,
2.33806030092154E-14,
1.21392479401905E-13,
2.08270900525775E-14,
1.30418245647412E-13,
0.810280587570906,
1.27130944660436E-13,
0.43316383058134,
1.1261998278389E-13,
0.350372360520421,
1.02107558519471E-13,
0.318741480601275,
9.24000459479046E-14,
0.309900221966584,
8.68038280144035E-14,
0.318588044157575,
9.79216707719388E-14,
0.350093138875909,
1.03131045370297E-13,
0.432828014415274,
1.08335215798228E-13,
0.810092248636455,
2.05885655746307E-14,
4.74156304497431E-14,
4.61119857575465E-14,
7.18505116514834E-14,
5.55120185929958E-14,
8.67908175883336E-14,
7.19988305086794E-14,
1.09369978351648E-13,
8.62834109716104E-14,
1.22133206326147E-13,
9.04684313574045E-14,
1.28618470041086E-13,
8.13923581310938E-14,
1.28995772397111E-13,
7.55107781857944E-14,
1.34335251256168E-13,
6.62022520137029E-14,
1.41581191215323E-13,
6.28594398754956E-14,
1.44377565458598E-13,
6.07430772348039E-14,
1.44467771079348E-13,
6.00127586514176E-14,
1.50992066072497E-13,
5.65762714455076E-14,
1.40771075352042E-13,
4.25944002291345E-14,
1.34415048536063E-13,
2.61301397186386E-14,
1.27845650732539E-13,
2.27977359212872E-14,
1.31219687893314E-13,
1.40356476441283E-14,
1.28877811200745E-13,
0.810250383723997,
1.14359910430295E-13,
0.433096932098565,
1.06656003473482E-13,
0.350294649989922,
9.98246624250854E-14,
0.318661960445326,
8.68038280144035E-14,
0.309824152609417,
9.08162434143378E-14,
0.318519216096845,
9.88219922559708E-14,
0.350034940177301,
1.06374978270374E-13,
0.432784692119099,
1.10023101740353E-13,
2.25147591542685E-14,
3.25538207501808E-14,
5.79900710784287E-14,
5.2581203280333E-14,
7.83192954934009E-14,
6.62022520137029E-14,
1.00647788714436E-13,
7.95899804395539E-14,
1.16462395283179E-13,
8.70848532175117E-14,
1.27880345202058E-13,
8.69287281046738E-14,
1.30362734496181E-13,
8.1452206091015E-14,
1.37166319968962E-13,
7.00325214486597E-14,
1.39227171458423E-13,
6.54285653434172E-14,
1.46693421299027E-13,
6.10518580135277E-14,
1.45531156570122E-13,
5.84567116934664E-14,
1.52808321551845E-13,
5.75407776981507E-14,
1.47245063364387E-13,
4.7942552705571E-14,
1.41879563653191E-13,
3.38305772284997E-14,
1.33747179997812E-13,
2.55351295663786E-14,
1.37652042542236E-13,
1.57547586088214E-14,
1.29280267047172E-13,
  0,
1.16436374431039E-13,
0.810222477116024,
1.0888165369316E-13,
0.433034990694735,
1.04225655883639E-13,
0.350222552110506,
9.39942568223273E-14,
0.318588044157575,
9.08665503951411E-14,
0.309753318795049,
9.15188064221084E-14,
0.318455018722722,
1.01937555618825E-13,
0.349980572160091,
1.08508688145825E-13,
0.432744161565805,
1.70263109167124E-14,
3.84653246754407E-14,
4.08575083488127E-14,
6.59212268105946E-14,
6.40078268165922E-14,
9.29317386932915E-14,
7.42392258779034E-14,
1.08210315707957E-13,
8.06498964833757E-14,
1.22532192725622E-13,
8.37229591210686E-14,
1.29894359157667E-13,
8.71299560278871E-14,
1.3870675441563E-13,
7.6069359145059E-14,
1.42209161113627E-13,
6.93698570808365E-14,
1.44478179420204E-13,
6.37025154848203E-14,
1.47984055565153E-13,
5.87568188548104E-14,
1.53871707042619E-13,
5.60402418914308E-14,
1.49040502162023E-13,
4.90007340259169E-14,
1.48414266987196E-13,
3.92307714092155E-14,
1.41208225667988E-13,
3.32355670762396E-14,
1.43584796830076E-13,
1.85979703859473E-14,
1.35742111995185E-13,
  0,
1.17012302625064E-13,
  0,
1.10484538184963E-13,
0.810196639827821,
1.06872843907979E-13,
0.432977527064266,
9.8879238130678E-14,
0.350155537759429,
9.78661596207075E-14,
0.318519216096845,
9.15170716986324E-14,
0.309687249832634,
9.47974337917046E-14,
0.318395044896959,
1.03807587525928E-13,
0.349929705162518,
9.96199650549201E-14,
2.19112922250631E-14,
2.92786628275366E-14,
4.85817983064685E-14,
5.33861149731862E-14,
8.14712880492507E-14,
7.26163920661271E-14,
1.0109014320081E-13,
7.5616596317829E-14,
1.14691242614207E-13,
7.75178532474996E-14,
1.24776057541798E-13,
8.40638322840981E-14,
1.38403177807334E-13,
8.18650702782975E-14,
1.43860617862757E-13,
7.54465934171833E-14,
1.47545170525731E-13,
6.76299294344318E-14,
1.45843406795798E-13,
6.1409211049579E-14,
1.56400933870593E-13,
5.63785129692462E-14,
1.50220114125688E-13,
4.75140760070047E-14,
1.50258278042159E-13,
4.02768096652295E-14,
1.47775888748036E-13,
3.86322918100035E-14,
1.51129109227099E-13,
2.63226940244721E-14,
1.4169915241169E-13,
  0,
1.23482821190457E-13,
  0,
1.11197509533589E-13,
-1.76230557924484E-14,
1.07545916616658E-13,
0.810172671603626,
1.00296507210551E-13,
0.432924118616575,
1.02294908654876E-13,
0.350093138875909,
9.87959714038311E-14,
0.318455018722722,
9.47991685151806E-14,
0.309625526869958,
9.68825714098287E-14,
0.318338931351601,
9.50784589948128E-14,
0.34988204430824,
1.67962432157109E-14,
3.70116264025722E-14,
4.35445950131008E-14,
6.54563209190329E-14,
6.27839794042906E-14,
9.03929708861995E-14,
7.44656072915184E-14,
1.07992607911722E-13,
7.27170060277338E-14,
1.17261235443866E-13,
7.80018410972971E-14,
1.3357544237369E-13,
7.89247139865168E-14,
1.43753065007246E-13,
8.13550615763603E-14,
1.49359691281603E-13,
7.38142186262891E-14,
1.49014481309884E-13,
6.5445912578177E-14,
1.54284571229901E-13,
5.90933552091499E-14,
1.52742402059758E-13,
4.78575512552482E-14,
1.51417073324112E-13,
3.87832127524135E-14,
1.49680615124659E-13,
3.96765953425415E-14,
1.57707180648003E-13,
3.17280923756158E-14,
1.49345813493795E-13,
1.53106693989713E-14,
1.2937567683835E-13,
  0,
1.17567414137376E-13,
-1.58120044835286E-14,
1.08609302107432E-13,
-2.28532470725185E-14,
1.02329603124396E-13,
0.810150395906541,
1.0456566168493E-13,
0.432874391589348,
1.03127575923345E-13,
0.350034940177301,
1.01906330596258E-13,
0.318395044896959,
9.68652241750689E-14,
0.309567776177163,
8.79903788719716E-14,
0.318286353125548,
9.46274308910589E-14,
2.08255721695361E-14,
3.5077409726858E-14,
5.60289661888369E-14,
5.40296973827736E-14,
7.53485815407906E-14,
6.51787651628766E-14,
9.78774353233014E-14,
7.18973491853347E-14,
1.10989342716472E-13,
7.33918134598888E-14,
1.26327767691059E-13,
7.30119090186498E-14,
1.3912482277334E-13,
7.85153192461863E-14,
1.49418671879786E-13,
7.9807688235789E-14,
1.50933085474314E-13,
7.16718351334578E-14,
1.57566668046449E-13,
6.30901580978005E-14,
1.50764817297144E-13,
5.05880060064356E-14,
1.54027832155457E-13,
3.91336268945608E-14,
1.50920942409982E-13,
3.81656511949657E-14,
1.59658744558477E-13,
3.27828042490097E-14,
1.55929089085127E-13,
2.06518829815039E-14,
1.37024072643932E-13,
  0,
1.23626803238963E-13,
-1.30694066680093E-14,
1.15107576248441E-13,
-2.10595429983584E-14,
1.02959307746175E-13,
-2.73461808752984E-14,
1.06315997672191E-13,
0.810129656616646,
1.04669745093489E-13,
0.432828014415274,
1.06361100482566E-13,
0.349980572160091,
1.03807587525928E-13,
0.318338931351601,
8.80181344475872E-14,
0.309513663425962,
8.77891509487583E-14,
0.318237018808664,
2.37141035974719E-14,
4.48725258339611E-14,
4.75210149009087E-14,
6.72942604418303E-14,
5.71539343630079E-14,
8.35624971995408E-14,
6.30094934561676E-14,
1.01318259337901E-13,
7.28184873510784E-14,
1.20306542505944E-13,
6.85623433027693E-14,
1.32126080909512E-13,
7.26814441964763E-14,
1.44988188122142E-13,
7.70685598672216E-14,
1.51136048121003E-13,
7.77572450871844E-14,
1.59646601494146E-13,
6.94010821034041E-14,
1.54119772499683E-13,
5.46212380880817E-14,
1.52078002968459E-13,
4.18935719448399E-14,
1.53555987369991E-13,
3.8517800060589E-14,
1.60935501036796E-13,
3.12753295483859E-14,
1.57943103040736E-13,
2.17499629417972E-14,
1.43669798280399E-13,
1.34718625144359E-14,
1.31181523976842E-13,
  0,
1.21047269430186E-13,
-1.82458215203241E-14,
1.094853374628E-13,
-2.56218657401774E-14,
1.06900599483595E-13,
-3.35304700671557E-14,
1.06734066029901E-13,
0.810110315254517,
1.08336950521704E-13,
0.432784692119099,
1.08529504827537E-13,
0.349929705162518,
9.52189715963669E-14,
0.318286353125548,
8.78186412478499E-14,
0.309462888799014,
8.57439119705816E-14,
3.10324682617491E-14,
4.13670833698809E-14,
5.85547235698591E-14,
5.17901693752876E-14,
7.64596719271537E-14,
5.54851303791182E-14,
8.75497591090735E-14,
6.42307387832552E-14,
1.11049190676393E-13,
6.81286624337751E-14,
1.26417105950072E-13,
6.8365452188246E-14,
1.38182867925885E-13,
7.12971348626468E-14,
1.46830464453629E-13,
7.50701584228963E-14,
1.59953647549393E-13,
7.54882267806067E-14,
1.56269094886419E-13,
6.09495093284451E-14,
1.55530102685653E-13,
4.59753762838133E-14,
1.51679016568984E-13,
4.13002965160558E-14,
1.63582689061137E-13,
3.16673770539566E-14,
1.59223328966007E-13,
2.02858563280728E-14,
1.45711567811624E-13,
1.45924938799169E-14,
1.37898373275824E-13,
  0,
1.28719951364431E-13,
-1.05089548174675E-14,
1.15484011242728E-13,
-2.28064095386671E-14,
1.13483875074927E-13,
-3.17471743338515E-14,
1.07564998574894E-13,
-3.22207538427932E-14,
1.1021392132271E-13,
0.810092248636455,
1.0991207943789E-13,
0.432744161565805,
9.96442511835838E-14,
0.34988204430824,
9.46569211901505E-14,
0.318237018808664,
8.57681980992453E-14,
0.309415182794384,
  0,
  0,
-1.06985817774352E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999993,
-1.00673592726142E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.18453424152731E-14,
  0,
1.5554398047346E-14,
  0,
1.35345294000055E-14,
  0,
1.03647559285269E-14,
  0,
1.98324429795393E-14,
1.49834571833152E-14,
2.97474718469193E-14,
2.37167056826859E-14,
3.05885958923335E-14,
1.98031695208822E-14,
3.09158081079897E-14,
1.63313373241492E-14,
3.12226373228031E-14,
2.20171103570976E-14,
3.21331503072564E-14,
1.88941744194704E-14,
2.8457921782965E-14,
1.92849208824342E-14,
2.29404169271863E-14,
1.28690461065339E-14,
1.80168380214951E-14,
2.25804618059211E-14,
2.9392720896082E-14,
2.86895073670079E-14,
  0,
-1.59268214935948E-14,
-1.15579204193472E-14,
-1.4398855371911E-14,
  0,
  0,
  0,
  0,
0.867364964374359,
-1.36362275637847E-14,
0.867109969524107,
-1.56996811384591E-14,
-1.38224934970177E-14,
  0,
-1.24594345257689E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.66104109633469E-14,
  0,
2.37310171513627E-14,
  0,
2.52202772554888E-14,
  0,
2.07269097718399E-14,
  0,
2.61735078055381E-14,
1.82701076489877E-14,
4.29443806904128E-14,
3.35191943645619E-14,
5.22559426285873E-14,
3.76773265364783E-14,
5.32343266690383E-14,
3.12857378892417E-14,
5.38267347360843E-14,
3.32225566501698E-14,
5.48805792477403E-14,
3.5454712082883E-14,
5.24537011048487E-14,
3.30963555172925E-14,
4.4503897095316E-14,
2.78674652798294E-14,
3.54720593176427E-14,
3.07033044821825E-14,
4.106567516593E-14,
4.43993800058884E-14,
5.51047922570103E-14,
-1.06985817774352E-14,
-1.15577035789127E-14,
-1.79780235837201E-14,
-1.18125995096641E-14,
-1.73893018040605E-14,
  0,
-1.27640953362373E-14,
0.841467615076606,
-1.69963869367518E-14,
0.563714616176406,
-1.70048437136971E-14,
0.84044429432965,
-1.60609373023313E-14,
-1.57178957349569E-14,
-1.1893264151297E-14,
-1.36787282889461E-14,
  0,
  0,
  0,
  0,
1.55990671768524E-14,
  0,
2.57619446608626E-14,
  0,
3.00068130065778E-14,
  0,
2.9316826744008E-14,
  0,
3.37737650346615E-14,
1.47807113770604E-14,
4.47450236584768E-14,
3.33994984447195E-14,
5.88921272859366E-14,
4.24612602023533E-14,
6.79708025974612E-14,
4.46418076116561E-14,
6.91525829654704E-14,
4.42089941043999E-14,
7.03369654186936E-14,
4.18601785179273E-14,
6.80050633861118E-14,
4.5248527147379E-14,
6.20948605034588E-14,
3.74539808889462E-14,
5.17784599918247E-14,
4.22882215356246E-14,
5.39607421246036E-14,
4.74602995792495E-14,
6.0210517127679E-14,
5.56603374501918E-14,
  0,
-1.43987469516937E-14,
-1.17557873158258E-14,
-2.05072504116943E-14,
-1.21491358640036E-14,
-1.96986524314546E-14,
0.831822968539406,
-1.94570921874249E-14,
0.504732140241031,
-1.89778748271863E-14,
0.503051291621874,
-1.6306834355051E-14,
0.829409536066531,
-1.79175251024954E-14,
-1.6079151898829E-14,
  0,
-1.07123511450258E-14,
  0,
  0,
1.06516358233666E-14,
  0,
2.3861988773799E-14,
  0,
3.08360108280947E-14,
  0,
3.28678056993326E-14,
  0,
4.11211863171612E-14,
1.75666772794791E-14,
5.08000759513738E-14,
2.89321518132102E-14,
5.85044165890558E-14,
4.06211522752109E-14,
7.18917113340378E-14,
4.75010655809349E-14,
8.09218143882351E-14,
5.57444715387767E-14,
8.27098806110982E-14,
5.10182174284779E-14,
8.05484151600311E-14,
4.97674818022986E-14,
7.48481138179713E-14,
4.78410713822264E-14,
6.69291011501372E-14,
5.02748884190218E-14,
6.81598874563427E-14,
5.72398031750687E-14,
7.07914629693995E-14,
5.64513713552373E-14,
7.2775119264179E-14,
  0,
  0,
-1.73893018040605E-14,
-1.21213802883879E-14,
-2.30434161335724E-14,
0.828179398818821,
-2.64068281130569E-14,
0.482456099532277,
-2.0794130306534E-14,
0.434051881622198,
-1.82909243306995E-14,
0.477560898658058,
-1.75926981316188E-14,
0.823513595914334,
-1.41774612882895E-14,
-1.31153768401227E-14,
  0,
  0,
  0,
  0,
1.862702700417E-14,
  0,
2.83722698113387E-14,
  0,
3.30313033869434E-14,
1.01611427605341E-14,
4.39214636882568E-14,
1.87566975839992E-14,
5.72458747072346E-14,
3.12328288232244E-14,
6.34327659843059E-14,
3.54395332524682E-14,
7.00915020468429E-14,
4.47046913376603E-14,
8.32580532295069E-14,
5.75286346338189E-14,
9.28172469438771E-14,
6.14517117747404E-14,
9.12239034311924E-14,
5.78677730733723E-14,
8.57499835027475E-14,
5.13365391863196E-14,
7.81917933179166E-14,
5.96337215719167E-14,
8.19353265790745E-14,
6.40806852025833E-14,
8.35833138812525E-14,
6.50157011561348E-14,
8.18199674679221E-14,
5.50687967448837E-14,
  0,
  0,
  0,
-1.9671764217577E-14,
0.828179398818821,
-2.86819179518005E-14,
0.473975125035577,
-2.7301945426661E-14,
0.407350101284771,
-2.00768221492176E-14,
0.403589226881235,
-1.9523445360381E-14,
0.463796611961337,
-1.45200691747949E-14,
0.819908750057632,
  0,
-1.01346882275255E-14,
  0,
  0,
1.67817149065996E-14,
  0,
2.27613067282917E-14,
  0,
3.01685759707127E-14,
  0,
4.36699287842401E-14,
2.0116720789165E-14,
5.94663207564849E-14,
3.21045273699028E-14,
6.91287305176758E-14,
3.73017589039293E-14,
7.41906536205761E-14,
3.9046890720762E-14,
8.04885672001099E-14,
5.40930147896468E-14,
9.40541047822485E-14,
6.24604534760209E-14,
1.00187219631565E-13,
6.7537989090205E-14,
9.52996362379999E-14,
5.87229917470289E-14,
8.80979317274821E-14,
6.24838722429466E-14,
9.22586659846125E-14,
7.27265470068517E-14,
9.63430724087999E-14,
7.10742228959838E-14,
9.35978725080666E-14,
6.28932669832771E-14,
8.64482097018282E-14,
  0,
  0,
-1.27562890805955E-14,
0.831822968539406,
-2.64066112726224E-14,
0.473975125035577,
-3.04123046190874E-14,
0.397064394625028,
-2.66145612493052E-14,
0.374529032745403,
-2.09641332071797E-14,
0.386889377682501,
-1.59434097868338E-14,
0.455320627801176,
  0,
0.817511184004236,
  0,
  0,
1.20480882215279E-14,
  0,
2.07707115396083E-14,
  0,
2.43728648374741E-14,
  0,
4.0464159800635E-14,
1.96110488959178E-14,
5.87307980026708E-14,
3.32546490344754E-14,
7.08027386719934E-14,
3.79262593552809E-14,
7.93280371946814E-14,
4.05309466544601E-14,
8.39823002807272E-14,
4.79833187072565E-14,
9.05716474042251E-14,
5.85547235698591E-14,
1.00615696330131E-13,
6.80584061329981E-14,
1.03491000491562E-13,
6.78910053175663E-14,
9.68947144741605E-14,
6.93741938895265E-14,
1.01385046191727E-13,
7.49973000369053E-14,
1.05865836930175E-13,
7.913461552711E-14,
1.05576138109686E-13,
6.84010140195035E-14,
9.7455897518639E-14,
6.09980815857725E-14,
  0,
  0,
0.841467615076606,
-1.94302039735472E-14,
0.482456099532277,
-2.72533731693336E-14,
0.397064394625028,
-2.94616761542521E-14,
0.363248405391263,
-2.77390957426071E-14,
0.356377212108753,
-1.7127792240057E-14,
0.376503821482069,
  0,
0.449654968168671,
  0,
0.815821477053102,
  0,
  0,
1.60357838119296E-14,
  0,
2.21940521516473E-14,
  0,
3.44741596380871E-14,
1.54641924265952E-14,
5.53550261184199E-14,
3.25789742405824E-14,
6.9780986544643E-14,
3.88352544566928E-14,
8.05683644800048E-14,
4.09368719478387E-14,
8.86599821336986E-14,
4.92193091838899E-14,
9.35571065063812E-14,
5.21709411782645E-14,
9.65954746745545E-14,
6.37684349769074E-14,
1.03346151081318E-13,
6.80063644287188E-14,
1.04487599128511E-13,
7.81310779962574E-14,
1.09618043808712E-13,
8.14929720927005E-14,
1.1440501324067E-13,
8.09482689212437E-14,
1.14509964010967E-13,
7.60277257816355E-14,
1.08840020329737E-13,
6.61025054138342E-14,
1.09412479076809E-13,
  0,
0.867364964374359,
-1.70449591940791E-14,
0.504732140241031,
-2.08236206056256E-14,
0.407350101284771,
-2.66670366344535E-14,
0.363248405391263,
-3.051465330417E-14,
0.344470887732739,
-2.36611945314547E-14,
0.345021032718462,
-1.10553927124002E-14,
0.369514170246202,
  0,
0.445647454720562,
  0,
0.814578919378522,
1.06156403112401E-14,
  0,
1.7349836844982E-14,
  0,
3.22433052479809E-14,
1.1968724622502E-14,
4.9137777180519E-14,
2.83774739817666E-14,
6.60834234555985E-14,
3.80442205516474E-14,
7.92352294887166E-14,
4.17122933416003E-14,
8.95828550229183E-14,
4.94179350218893E-14,
9.78505471094238E-14,
5.31684071769511E-14,
9.91680695894281E-14,
5.71096989143705E-14,
9.88350026820406E-14,
6.34570521129696E-14,
1.03939426510102E-13,
7.78795430922408E-14,
1.16736481592383E-13,
8.98985746955461E-14,
1.22150553560907E-13,
8.70978636435815E-14,
1.22519182299552E-13,
7.75204553327136E-14,
1.17262102805604E-13,
7.34221711207184E-14,
1.20307409867682E-13,
6.81425402215829E-14,
0.999999999999993,
-1.36301560316188E-14,
0.563714616176405,
-1.90346870210245E-14,
0.434051881622198,
-2.01045777248332E-14,
0.374529032745403,
-2.77967752981834E-14,
0.344470887732739,
-2.64194048582578E-14,
0.332690388225365,
-1.72383808616505E-14,
0.337345558719678,
  0,
0.364545640705427,
  0,
0.442692375651926,
1.0243542125643E-14,
0.813634844594192,
1.16061674160228E-14,
  0,
2.73305683640146E-14,
  0,
4.66883476324398E-14,
2.47796574925907E-14,
5.97161209370256E-14,
3.37741987155304E-14,
7.53693982225023E-14,
4.08457989653499E-14,
8.79487455085481E-14,
5.01074876035901E-14,
9.84542308790637E-14,
5.32256530516584E-14,
1.03120637029441E-13,
5.79857342697387E-14,
1.01086673753858E-13,
5.65684651898657E-14,
9.9026689626136E-14,
7.31125229802565E-14,
1.15790189936238E-13,
8.93391263745436E-14,
1.28874341753793E-13,
9.51903486590133E-14,
1.29877879284646E-13,
8.33586671911135E-14,
1.24881008312094E-13,
7.4647753256496E-14,
1.28351322625786E-13,
7.52028647688086E-14,
1.28006112654067E-13,
-1.00673592726142E-14,
0.867109969524107,
-1.70046268732627E-14,
0.503051291621874,
-1.81807693899749E-14,
0.403589226881235,
-2.09528575045859E-14,
0.356377212108753,
-2.36048160184854E-14,
0.332690388225365,
-2.02594017950641E-14,
0.324712024464899,
  0,
0.33187235457397,
  0,
0.360868316187502,
  0,
0.440442414157476,
1.21404622466237E-14,
0.812898687954002,
2.1615521872409E-14,
  0,
4.15683112930942E-14,
1.96240593219876E-14,
5.72441399837587E-14,
3.00549515830362E-14,
6.88164802919999E-14,
3.63762839294957E-14,
8.38504612965529E-14,
4.90709903266939E-14,
9.66128219093143E-14,
5.37330596683816E-14,
1.03467581724637E-13,
5.78113945604031E-14,
1.04821533397637E-13,
5.73083247523698E-14,
1.0109014320081E-13,
6.61432714155197E-14,
1.10631989680421E-13,
8.43734804245599E-14,
1.27592381105046E-13,
9.44348765852254E-14,
1.36258192229288E-13,
9.12681388798298E-14,
1.31884086984613E-13,
8.03411157046519E-14,
1.35632824416199E-13,
7.62610460891544E-14,
1.3564496748053E-13,
7.13352987791183E-14,
  0,
-1.5782080503568E-14,
0.84044429432965,
-1.63619118254132E-14,
0.477560898658058,
-1.95108686151801E-14,
0.386889377682501,
-1.71798339443363E-14,
0.345021032718462,
-1.72383808616505E-14,
0.324712024464899,
-1.29167510021233E-14,
0.319014250344191,
  0,
0.327811823167887,
  0,
0.358060439026486,
1.07587549980082E-14,
0.438685055582809,
2.20223145275256E-14,
0.812312369658877,
3.5678925092153E-14,
1.77358128183869E-14,
5.2057316790588E-14,
2.48169540473242E-14,
6.61450061389957E-14,
3.26292812213858E-14,
7.71587654879724E-14,
4.46058120995296E-14,
9.2369688287075E-14,
5.26072241324727E-14,
1.01437955257744E-13,
5.81869621929521E-14,
1.04932555700099E-13,
5.70732697213749E-14,
1.04553518620598E-13,
6.67070565452121E-14,
1.12414418051987E-13,
7.7189123148802E-14,
1.2223121820254E-13,
8.9229838795557E-14,
1.346579098227E-13,
9.03140409680425E-14,
1.38003324046121E-13,
8.80181344475872E-14,
1.42367020949941E-13,
8.17748646575467E-14,
1.42651515600001E-13,
7.225296749791E-14,
1.38526343174128E-13,
  0,
-1.38270471461421E-14,
-1.60193039389078E-14,
0.829409536066531,
-1.75887950037978E-14,
0.463796611961337,
-1.60522636849514E-14,
0.376503821482069,
-1.10259024133086E-14,
0.337345558719678,
  0,
0.319014250344191,
  0,
0.314782221918911,
  0,
0.324705571405495,
  0,
0.355862375323376,
2.02927952219767E-14,
0.437283525876042,
3.59287252726936E-14,
0.811837076252144,
4.64151286849734E-14,
2.27170712796543E-14,
6.08150682590569E-14,
2.74424580282151E-14,
7.44126982255011E-14,
4.08241149219002E-14,
8.55071222161108E-14,
4.80553097315095E-14,
9.7011808308789E-14,
5.69457675458906E-14,
1.02781498589888E-13,
5.73057226671558E-14,
1.04506681086747E-13,
6.62976618048816E-14,
1.15756362828456E-13,
7.7640151252556E-14,
1.23749101244019E-13,
8.19214487912667E-14,
1.29061691889198E-13,
8.49797662794138E-14,
1.36184466481559E-13,
8.69200544872939E-14,
1.48192222382271E-13,
8.93417284597575E-14,
1.49087339695875E-13,
7.76583658490537E-14,
1.45232784132254E-13,
7.07767178198537E-14,
  0,
  0,
-1.5709222117577E-14,
-1.7952219572015E-14,
0.823513595914334,
-1.45456563460655E-14,
0.455320627801176,
  0,
0.369514170246202,
  0,
0.33187235457397,
  0,
0.314782221918911,
  0,
0.311541842568846,
  0,
0.322270339139647,
1.87150642205758E-14,
0.354106206981381,
3.44273221042357E-14,
0.436146154698005,
4.59120588769402E-14,
0.811445977538164,
5.50106835084385E-14,
2.53738002831128E-14,
6.89769422135278E-14,
3.55227999793151E-14,
8.272202367543E-14,
4.42102951470069E-14,
9.00824553839996E-14,
5.23652302075739E-14,
9.81567258029337E-14,
5.59890675488894E-14,
1.02127507839445E-13,
6.65361862828284E-14,
1.15505695286178E-13,
7.71535613175445E-14,
1.26903695885083E-13,
8.22519136134403E-14,
1.30454674840408E-13,
7.75837727395867E-14,
1.30371408113561E-13,
8.15025130718183E-14,
1.46176473703186E-13,
8.8108340068338E-14,
1.54747742397987E-13,
8.51072684548981E-14,
1.51437890005823E-13,
7.60815022093908E-14,
1.48018750034673E-13,
  0,
-1.2487840622688E-14,
-1.19505100260042E-14,
-1.60860907927329E-14,
-1.41774612882895E-14,
0.819908750057632,
  0,
0.449654968168671,
  0,
0.364545640705427,
  0,
0.327811823167887,
  0,
0.311541842568846,
  0,
0.308999618948279,
1.24960805591989E-14,
0.320322358686556,
3.31470961789648E-14,
0.352678940037468,
4.4875561600044E-14,
0.43520942057703,
5.48918549503341E-14,
0.811119994765026,
6.29947483066218E-14,
3.35417457697496E-14,
7.71188668480249E-14,
3.88612753088324E-14,
8.70839858557737E-14,
4.84829190683378E-14,
9.11796679825549E-14,
5.13035794402761E-14,
9.74238051343335E-14,
6.51258560968593E-14,
1.13020703906841E-13,
7.72732572373869E-14,
1.26553281742936E-13,
8.16968021011277E-14,
1.33464420071228E-13,
7.77988784506078E-14,
1.31573571482413E-13,
7.39859562504108E-14,
1.4017259575283E-13,
8.25780416269239E-14,
1.52503010220073E-13,
8.37611230375401E-14,
1.56907473125578E-13,
8.34315255771045E-14,
1.54048648837168E-13,
6.83151452074426E-14,
  0,
  0,
-1.36787282889461E-14,
  0,
-1.31171115635986E-14,
  0,
0.817511184004236,
  0,
0.445647454720562,
  0,
0.360868316187502,
  0,
0.324705571405495,
  0,
0.308999618948279,
  0,
0.306964860840936,
2.65629532258949E-14,
0.318737653189131,
4.29968560755611E-14,
0.351502018334164,
5.32377961159902E-14,
0.434428062334089,
6.2677293910518E-14,
0.81084523107771,
7.13916772920875E-14,
3.67744029672323E-14,
8.14721554109887E-14,
4.31425728475432E-14,
8.8110942153552E-14,
4.73900432784724E-14,
9.03695521192738E-14,
6.03449581970672E-14,
1.08227662942717E-13,
7.58525187105619E-14,
1.23888746483836E-13,
8.16950673776518E-14,
1.32919716899771E-13,
7.71396835297367E-14,
1.34434130494299E-13,
7.41576938745325E-14,
1.41249859031412E-13,
7.49816875256215E-14,
1.46414130819394E-13,
7.80903119945719E-14,
1.5450488111135E-13,
8.20211953911354E-14,
1.59310065139806E-13,
7.55836365717855E-14,
1.55991539130262E-13,
  0,
  0,
  0,
-1.07132185067638E-14,
  0,
-1.01290503762286E-14,
  0,
0.815821477053102,
  0,
0.442692375651926,
  0,
0.358060439026487,
  0,
0.322270339139647,
1.24978152826749E-14,
0.306964860840936,
2.36807101705594E-14,
0.305308761676111,
3.65254701484297E-14,
0.317429846133262,
5.14874601287296E-14,
0.350519313226927,
6.11177775056149E-14,
0.433769055520558,
7.10256506386564E-14,
0.810611352333152,
7.54630732902051E-14,
4.10322817390174E-14,
8.25572249452122E-14,
4.20236762055382E-14,
8.72028144138781E-14,
5.64496366317613E-14,
1.01032029964365E-13,
7.09710068491631E-14,
1.18995091558105E-13,
8.01980010178838E-14,
1.30213548277247E-13,
7.71084585071691E-14,
1.33828712001183E-13,
7.34169669502904E-14,
1.44020212422546E-13,
7.50892403811321E-14,
1.47342207879042E-13,
7.04228342307545E-14,
1.48240794639598E-13,
7.62775259621762E-14,
1.56812063334399E-13,
7.40987132763493E-14,
1.6111070810787E-13,
7.63365065603594E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.814578919378522,
1.02131844648135E-14,
0.440442414157476,
1.07596223597461E-14,
0.355862375323376,
1.87350135405495E-14,
0.320322358686556,
2.6554279608515E-14,
0.305308761676111,
3.39485384248661E-14,
0.303941486569901,
4.5247659785641E-14,
0.31633710968712,
5.9684895914458E-14,
0.349689775267695,
6.94305724024957E-14,
0.433207806250343,
7.50415354855427E-14,
0.810410533906026,
7.61916571501153E-14,
3.99940497386453E-14,
8.16621076316082E-14,
5.09592368302947E-14,
9.78418734920439E-14,
6.69724692370366E-14,
1.11743947428522E-13,
7.53390405616727E-14,
1.25186319643866E-13,
7.55472073787899E-14,
1.30994173841437E-13,
7.33406391173475E-14,
1.4328989383916E-13,
7.42756550708989E-14,
1.49928680581723E-13,
7.05182440219332E-14,
1.49094278589779E-13,
6.851463840718E-14,
1.50443893454089E-13,
6.82370826510237E-14,
1.58468724253957E-13,
7.47561734737445E-14,
1.63159416532999E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.19908423468207E-14,
  0,
1.0697172314611E-14,
0.813634844594192,
1.21447990553136E-14,
0.438685055582809,
2.02398861559594E-14,
0.354106206981381,
3.30655641755939E-14,
0.318737653189131,
3.65254701484297E-14,
0.303941486569901,
4.27010857229071E-14,
0.302798675512211,
5.33410121628108E-14,
0.315414156866684,
6.75345196432531E-14,
0.348982773364084,
7.37136046646825E-14,
0.432725669592423,
7.62610460891544E-14,
0.81023675658358,
7.54309809058995E-14,
4.87925672087997E-14,
9.21780013429796E-14,
6.15323764163733E-14,
1.08526035380585E-13,
7.12502973287954E-14,
1.17831092105725E-13,
7.05737551731644E-14,
1.25963475761104E-13,
7.1725611561213E-14,
1.40358211164759E-13,
7.41681022153884E-14,
1.49191423104433E-13,
6.96612906248006E-14,
1.51618301247325E-13,
6.85285161949878E-14,
1.51146456461859E-13,
6.04724603725515E-14,
1.51975654283376E-13,
6.88910734014669E-14,
1.60416818717479E-13,
7.05633468323086E-14,
  0,
  0,
  0,
1.06377580355588E-14,
  0,
1.68064347161323E-14,
  0,
1.6007160874576E-14,
  0,
1.16616785672541E-14,
0.812898687954002,
2.20778256787568E-14,
0.437283525876042,
3.43648720591005E-14,
0.352678940037468,
4.3010733863369E-14,
0.317429846133262,
4.52190368482874E-14,
0.302798675512211,
5.06929567767322E-14,
0.301833151302527,
6.1179360189012E-14,
0.314627150051719,
7.2024851360819E-14,
0.348375045991218,
7.46026504461206E-14,
0.432308287073719,
7.53720003077163E-14,
0.810085324411334,
8.59104454242754E-14,
5.94680554799609E-14,
1.02836142379381E-13,
6.5746019739521E-14,
1.1470685512549E-13,
6.65179716863307E-14,
1.18538859283923E-13,
6.67122607156401E-14,
1.35282410274051E-13,
7.24906246141188E-14,
1.46167800085806E-13,
6.95277169171504E-14,
1.50695428358105E-13,
6.76698280743793E-14,
1.53533435964803E-13,
6.03683769639929E-14,
1.52615767246012E-13,
6.10726746952395E-14,
1.5380231810358E-13,
6.46756953548433E-14,
1.62840227413419E-13,
  0,
  0,
1.55726126438438E-14,
  0,
1.86062103224582E-14,
  0,
2.07707115396083E-14,
  0,
1.72934583320128E-14,
  0,
2.1617256595885E-14,
0.812312369658877,
3.59304599961696E-14,
0.436146154698005,
4.4875561600044E-14,
0.351502018334164,
5.14553677444241E-14,
0.31633710968712,
5.32846336498416E-14,
0.301833151302527,
5.88288098790635E-14,
0.301009641182497,
6.58527052332936E-14,
0.313950363461763,
7.28852742049035E-14,
0.347848652921533,
7.35835004039842E-14,
0.431944446177945,
8.55374798769404E-14,
0.809952527462121,
9.65113405859697E-14,
6.35567987128383E-14,
1.08827877265405E-13,
6.10275718848641E-14,
1.15258497190851E-13,
6.2600966077575E-14,
1.27791874304783E-13,
6.74495181929302E-14,
1.40977507445683E-13,
6.78328920811211E-14,
1.47664866445574E-13,
6.74963557267816E-14,
1.52619236692964E-13,
5.94958110555766E-14,
1.54936827256869E-13,
6.10032857562004E-14,
1.54334878210705E-13,
5.68017854973846E-14,
1.56137255902244E-13,
5.83890574779033E-14,
  0,
1.66212529850718E-14,
  0,
2.38897443494146E-14,
  0,
2.27630414517677E-14,
  0,
2.2216603556835E-14,
  0,
2.72663835954035E-14,
  0,
3.56251486643977E-14,
0.811837076252144,
4.59814478159792E-14,
0.43520942057703,
5.32291224986103E-14,
0.350519313226927,
5.96328542101787E-14,
0.315414156866684,
6.118022755075E-14,
0.301009641182497,
6.28073981712163E-14,
0.300301313264593,
6.65535335175882E-14,
0.31336393675631,
7.15573433840433E-14,
0.347389566587486,
8.36553049055055E-14,
0.43162528137922,
9.6110619463019E-14,
0.809835401486574,
1.02830938208953E-13,
5.88279425173255E-14,
1.09457581887185E-13,
5.71001579352526E-14,
1.24506308041283E-13,
6.33989388765244E-14,
1.33436664495612E-13,
6.2828214852928E-14,
1.42389572355128E-13,
6.57893878264204E-14,
1.49500203883157E-13,
5.93032567497431E-14,
1.5394456542861E-13,
6.00856170374087E-14,
1.56622978475518E-13,
5.66994368123019E-14,
1.5660910068771E-13,
5.04631059161653E-14,
1.58468724253957E-13,
1.18453424152731E-14,
  0,
2.57723530017184E-14,
  0,
2.83423458313781E-14,
  0,
2.43320988357887E-14,
  0,
3.22467746949329E-14,
  0,
4.15683112930942E-14,
1.76803016671556E-14,
4.64428842605891E-14,
0.811445977538164,
5.47773632009196E-14,
0.434428062334089,
6.10622663543836E-14,
0.349689775267695,
6.75961023266503E-14,
0.314627150051719,
6.57971940820623E-14,
0.300301313264593,
6.36695557387768E-14,
0.299687443194474,
6.5669691906578E-14,
0.312852327626634,
8.22900775299118E-14,
0.346986683121783,
9.47731476630409E-14,
0.431343703905087,
1.02060720985619E-13,
0.809731553700695,
1.03382580274314E-13,
5.50219592110324E-14,
1.1861345239339E-13,
5.78651709881584E-14,
1.30111199592164E-13,
5.86908993627233E-14,
1.34845259958105E-13,
6.07916494921312E-14,
1.44228379239664E-13,
5.75754721676702E-14,
1.50778695084952E-13,
5.98739807733395E-14,
1.55547449920412E-13,
5.57696250291784E-14,
1.58853832865624E-13,
5.03676961249866E-14,
1.58852098142148E-13,
4.66189586934007E-14,
  0,
2.37509664713365E-14,
  0,
3.08451181263436E-14,
  0,
3.01711780559266E-14,
  0,
3.45027825754407E-14,
1.20034190920215E-14,
4.66762045681079E-14,
1.96249266837256E-14,
5.20278264914964E-14,
2.27179386413923E-14,
5.49837952945609E-14,
0.811119994765026,
6.27154578269895E-14,
0.433769055520558,
6.9488685638941E-14,
0.348982773364084,
7.19771464652297E-14,
0.313950363461763,
6.65066959837368E-14,
0.299687443194474,
6.25853535662912E-14,
0.299151805579457,
7.5843845093182E-14,
0.312403223848342,
9.27955629004273E-14,
0.346631115158288,
1.00868965957623E-13,
0.431093987895348,
1.03377376103886E-13,
0.809639034579242,
1.12397938178965E-13,
5.55822748937729E-14,
1.24268650925075E-13,
5.30981508761741E-14,
1.31408772752195E-13,
5.65415769759881E-14,
1.36642433479217E-13,
5.2510079617818E-14,
1.45447889843275E-13,
5.8113236445223E-14,
1.52329537872475E-13,
5.54903345495461E-14,
1.57714119541907E-13,
4.93927815314876E-14,
1.61046523339259E-13,
4.65009974970343E-14,
1.6305533312444E-13,
1.5554398047346E-14,
  0,
3.00068130065778E-14,
  0,
3.30451811747512E-14,
  0,
4.04563535449931E-14,
1.54624577031193E-14,
4.9137777180519E-14,
2.47796574925907E-14,
5.71990371733833E-14,
2.48186887708002E-14,
6.08185377060089E-14,
2.54058926674183E-14,
6.29409718788665E-14,
0.81084523107771,
7.1129734047215E-14,
0.433207806250343,
7.36537567047613E-14,
0.348375045991218,
7.29373159091828E-14,
0.31336393675631,
6.57807142090405E-14,
0.299151805579457,
7.30839000429029E-14,
0.298681542242117,
8.66563765189454E-14,
0.312006764305077,
9.88549520020143E-14,
0.346315677714905,
1.01000804941798E-13,
0.430871465508288,
1.12009360120346E-13,
0.809556242198583,
1.17870990745672E-13,
5.09748493415785E-14,
1.25540203232966E-13,
5.09019909555875E-14,
1.33225028231543E-13,
4.82738848894826E-14,
1.37865413529781E-13,
5.30200883197551E-14,
1.47007406248179E-13,
5.37833666491849E-14,
1.54452839407071E-13,
4.91256341161872E-14,
1.59853033587787E-13,
4.55607773730549E-14,
1.6514220546604E-13,
3.84223902694103E-14,
  0,
2.51782102111964E-14,
  0,
3.28678056993326E-14,
1.01455302492504E-14,
4.36907454659519E-14,
1.96127836193938E-14,
5.53550261184199E-14,
2.83688003643867E-14,
5.97733668117328E-14,
3.0068829370844E-14,
6.61554144798515E-14,
2.74580705394989E-14,
6.89977588952395E-14,
3.35348068758456E-14,
7.13951467390395E-14,
0.810611352333152,
7.49790854404075E-14,
0.432725669592423,
7.46009157226446E-14,
0.347848652921533,
7.15538739370913E-14,
0.312852327626634,
7.58369061992781E-14,
0.298681542242117,
8.3771531378396E-14,
0.29826635137611,
9.25665794015984E-14,
0.311654972048079,
9.9399655173471E-14,
0.34603450884515,
1.10352699200789E-13,
0.430672299207463,
1.17362716767211E-13,
0.809481849965544,
1.19239687568218E-13,
4.87231782697606E-14,
1.2733217258365E-13,
4.27470558950205E-14,
1.34399436024779E-13,
4.88688950417426E-14,
1.3938329657126E-13,
4.86676671185293E-14,
1.49069992461115E-13,
4.73683592350227E-14,
1.56541446472147E-13,
4.52970994047064E-14,
1.63933103203284E-13,
3.74839048689068E-14,
1.70910161023663E-13,
1.35345294000055E-14,
  0,
2.93133572970561E-14,
  0,
4.39249331352087E-14,
2.00924346605014E-14,
5.87368695348367E-14,
3.2608464539674E-14,
6.60574026034588E-14,
3.37759334390064E-14,
6.88442358676156E-14,
3.26362201152897E-14,
7.43719322238157E-14,
3.55210652558391E-14,
7.71223362949769E-14,
3.68160363306558E-14,
7.53659287755504E-14,
0.810410533906026,
7.62428314926566E-14,
0.432308287073719,
7.36095212561239E-14,
0.347389566587486,
8.227793446558E-14,
0.312403223848342,
8.66529070719935E-14,
0.29826635137611,
8.9679999537573E-14,
0.297897897082142,
9.30679144861557E-14,
0.31134133554661,
1.08267561582664E-13,
0.345782785931309,
1.15874324024823E-13,
0.430493309565004,
1.19146012500515E-13,
0.809414751385624,
1.21097576410989E-13,
4.05266098457702E-14,
1.28463212289986E-13,
4.32622687673856E-14,
1.35867012085455E-13,
4.4428002943242E-14,
1.4139731052687E-13,
4.22387819165593E-14,
1.51155130079239E-13,
4.34721703079788E-14,
1.606319244285E-13,
3.71577768554232E-14,
1.6962646565144E-13,
2.68153554916495E-14,
  0,
2.07065267709972E-14,
  0,
4.11311609771481E-14,
1.87536618179163E-14,
5.9464586033009E-14,
3.32719962692352E-14,
6.97506288838134E-14,
3.80823844681188E-14,
7.53416426468867E-14,
3.63971006112074E-14,
7.71605002114484E-14,
4.08171760279963E-14,
8.27289625693339E-14,
3.88612753088324E-14,
8.14721554109887E-14,
4.09975872694979E-14,
7.62306884283248E-14,
0.81023675658358,
7.54830226101788E-14,
0.431944446177945,
8.37125507802128E-14,
0.346986683121783,
9.27886240065234E-14,
0.312006764305077,
9.25665794015984E-14,
0.297897897082142,
9.02593971785492E-14,
0.297569373025014,
1.02147457159418E-13,
0.311060495228477,
1.13813472535362E-13,
0.345556510882585,
1.17215265271753E-13,
0.430331843557465,
1.20813081760929E-13,
0.809354017406618,
1.22107185474007E-13,
4.10053935251398E-14,
1.29923849456759E-13,
3.89289295243955E-14,
1.37907046893204E-13,
3.80234038699356E-14,
1.4344081478157E-13,
3.83165721373757E-14,
1.55112034327942E-13,
3.53710116751671E-14,
1.66212529850718E-13,
2.65031052659737E-14,
1.60383858971436E-13,
1.03647559285269E-14,
  0,
3.37889438650762E-14,
1.75636415133962E-14,
5.72328642811648E-14,
3.20793738795011E-14,
7.08356984180369E-14,
3.88378565419067E-14,
7.92386989356686E-14,
4.08527378592538E-14,
8.38678085313127E-14,
4.46058120995296E-14,
8.55079895778488E-14,
4.42111625087449E-14,
8.70969962818435E-14,
4.31295624214734E-14,
8.25442145191424E-14,
3.99636920778157E-14,
7.54379197998034E-14,
0.810085324411334,
8.55565618351761E-14,
0.43162528137922,
9.47731476630409E-14,
0.346631115158288,
9.8804645021211E-14,
0.311654972048079,
9.31164867434831E-14,
0.297569373025014,
9.9179345292022E-14,
0.297275175657239,
1.07811329308483E-13,
0.310808005956951,
1.15235945785663E-13,
0.345352345663112,
1.18722739972377E-13,
0.430185672774355,
1.21543400344315E-13,
0.809298863153363,
1.23385676675802E-13,
3.66182778543944E-14,
1.31948271753224E-13,
3.25173915571852E-14,
1.39869019144534E-13,
3.41202760489878E-14,
1.4738210651899E-13,
3.02414343567037E-14,
1.60720395325775E-13,
2.47111359152896E-14,
1.56921350913386E-13,
2.14047529700778E-14,
  0,
2.61735078055381E-14,
1.47807113770604E-14,
5.0783162397483E-14,
3.12302267380105E-14,
6.91790374984791E-14,
3.79141162909491E-14,
8.05796401825987E-14,
4.17469878111199E-14,
8.79504802320241E-14,
4.9062316709314E-14,
9.2371423010551E-14,
4.80561770932475E-14,
9.00590366170739E-14,
4.84837864300758E-14,
8.80849213014123E-14,
4.20167373116342E-14,
8.16499645672764E-14,
4.8764811633184E-14,
8.60388149614977E-14,
0.80995252746212,
9.60499041413598E-14,
0.431343703905087,
1.00927946555807E-13,
0.346315677714905,
9.93701648743794E-14,
0.31134133554661,
1.02149191882894E-13,
0.297275175657239,
1.04770359055095E-13,
0.297010656504504,
1.08715120239467E-13,
0.310580155026515,
1.16986281772924E-13,
0.345167485047983,
1.200064353446E-13,
0.430052913984173,
1.22792401247018E-13,
0.809248621752147,
1.25528060168634E-13,
3.03992941930176E-14,
1.33880753705462E-13,
2.86420193118531E-14,
1.43841535904521E-13,
2.59913618405605E-14,
1.52941895259495E-13,
1.95555377446865E-14,
1.51286969063413E-13,
1.96405391950094E-14,
1.51646056822941E-13,
1.98324429795393E-14,
1.82579645846559E-14,
4.47406868497868E-14,
2.89317181323412E-14,
6.342669445214E-14,
3.73000241804533E-14,
7.93688031963669E-14,
4.09091163722231E-14,
8.95724466820624E-14,
5.00936098157823E-14,
9.6633638591026E-14,
5.25994178768308E-14,
9.69805832862214E-14,
5.23478829728141E-14,
9.1178800620817E-14,
4.73796349376165E-14,
8.71819977321664E-14,
5.09037256790634E-14,
9.21328985326042E-14,
5.94663207564849E-14,
9.65113405859697E-14,
0.809835401486574,
1.02062455709095E-13,
0.431093987895348,
1.00945293790566E-13,
0.34603450884515,
1.08378583885127E-13,
0.311060495228477,
1.07767961221583E-13,
0.297010656504504,
1.06248343456627E-13,
0.296771932282298,
1.10586886870045E-13,
0.310373821260426,
1.17945583855139E-13,
0.344999557237194,
1.2133002935677E-13,
0.429931966592216,
1.25023255637124E-13,
0.809202723561746,
1.27536869953815E-13,
2.63591232174676E-14,
1.37802963484646E-13,
2.04333078235308E-14,
1.49370099622459E-13,
1.52829138233557E-14,
1.43524081508417E-13,
1.45231049408778E-14,
1.46027287484252E-13,
  0,
1.49834571833152E-14,
4.29495848608408E-14,
3.33934269125535E-14,
5.85009471421039E-14,
3.54412679759442E-14,
7.41915209823141E-14,
4.05170688666523E-14,
8.86816661771483E-14,
4.94179350218893E-14,
9.84577003260156E-14,
5.37278554979537E-14,
1.0142667955515E-13,
5.6991737718004E-14,
9.81827466550733E-14,
5.12827627585644E-14,
9.03417965436581E-14,
5.64496366317613E-14,
9.78453429389958E-14,
6.15341111398493E-14,
1.02832672932429E-13,
6.35567987128383E-14,
1.02841346549809E-13,
0.809731553700695,
1.03372171933458E-13,
0.430871465508288,
1.1040821035202E-13,
0.345782785931309,
1.13813472535362E-13,
0.310808005956951,
1.08723793856846E-13,
0.296771932282298,
1.07728062581636E-13,
0.296555737844675,
1.11461187501938E-13,
0.310186364889308,
1.19128665265755E-13,
0.344846545539741,
1.23076895897078E-13,
0.429821462989183,
1.27361662882741E-13,
0.809160679566042,
1.3147989641471E-13,
1.81191867065778E-14,
1.43312445244348E-13,
  0,
1.39856876080202E-13,
1.0172418463128E-14,
1.3819327626674E-13,
  0,
1.41603742620511E-13,
2.97474718469193E-14,
3.3504882895885E-14,
5.89025356267925E-14,
4.0614213381307E-14,
7.00654811947032E-14,
3.90191351451463E-14,
8.39614835990155E-14,
4.92557383768855E-14,
9.78557512798517E-14,
5.32273877751344E-14,
1.03443295595973E-13,
5.82025747042358E-14,
1.02814458335931E-13,
5.59751897610816E-14,
9.74316113899754E-14,
6.03553665379231E-14,
1.01000804941798E-13,
6.69776734074645E-14,
1.08498279804969E-13,
6.57876531029444E-14,
1.08836550882785E-13,
5.87724313660942E-14,
1.03410335849929E-13,
0.809639034579242,
1.12014564290774E-13,
0.430672299207463,
1.15850037896159E-13,
0.345556510882585,
1.15294926383847E-13,
0.310580155026515,
1.10614642445661E-13,
0.296555737844675,
1.08817468924549E-13,
0.29635931122237,
1.12975601096466E-13,
0.310015540727529,
1.21423704424473E-13,
0.344706726152898,
1.25158564068251E-13,
0.429720228828772,
1.30714883361804E-13,
0.80912206799804,
1.36932132299705E-13,
  0,
1.33882488428938E-13,
  0,
1.3451566249767E-13,
  0,
1.33748914721288E-13,
  0,
2.37167056826859E-14,
5.22637488842292E-14,
4.24473824145455E-14,
7.1878267227099E-14,
4.47150996785162E-14,
8.04894345618479E-14,
4.79989312185403E-14,
9.35545044211672E-14,
5.31684071769511E-14,
1.03134514817249E-13,
5.78044556664992E-14,
1.04960311275715E-13,
5.7292712241086E-14,
1.02127507839445E-13,
6.51275908203353E-14,
1.08229397666193E-13,
7.09640679552592E-14,
1.11750886322426E-13,
7.12485626053194E-14,
1.1470685512549E-13,
6.1031041331816E-14,
1.0951135831494E-13,
5.49681827832771E-14,
1.12503756311E-13,
0.809556242198583,
1.17416493194966E-13,
0.430493309565004,
1.17243020847368E-13,
0.345352345663112,
1.16986281772924E-13,
0.310373821260426,
1.11405676350707E-13,
0.29635931122237,
1.09903405820511E-13,
0.296180302957689,
1.15020840074642E-13,
0.309859429158154,
1.2327465437334E-13,
0.344578618349794,
1.29207408661181E-13,
0.429627251019535,
1.36553962581942E-13,
0.809086523493488,
1.27495236590391E-13,
  0,
1.28489233142126E-13,
  0,
1.30102525974785E-13,
-1.22766380394879E-14,
1.30265589981526E-13,
3.05885958923335E-14,
3.76781938982163E-14,
6.79777414913652E-14,
4.75171117730877E-14,
8.32649921234108E-14,
5.40921474279088E-14,
9.05577696164173E-14,
5.21509918582908E-14,
9.91628654190002E-14,
5.79614481410751E-14,
1.04814594503733E-13,
5.70888822326587E-14,
1.04528365130196E-13,
6.65578703262781E-14,
1.13035449056387E-13,
7.58559881575138E-14,
1.18988152664201E-13,
7.53390405616727E-14,
1.17844969893532E-13,
6.65075633454748E-14,
1.15287987489943E-13,
5.70949537648247E-14,
1.18599574605582E-13,
5.56134999163405E-14,
1.17817214317917E-13,
0.809481849965544,
1.19034990198053E-13,
0.430331843557465,
1.18733148313233E-13,
0.345167485047983,
1.1800109500637E-13,
0.310186364889308,
1.12961723308658E-13,
0.296180302957689,
1.12267833918267E-13,
0.296016704017647,
1.16920362280837E-13,
0.309716380855414,
1.26964411206743E-13,
0.34446094431544,
1.34250249805845E-13,
0.429541651758875,
1.27032065422306E-13,
0.809053728239713,
1.22128002155719E-13,
  0,
1.24055279937529E-13,
-1.78711212495131E-14,
1.26523791443844E-13,
-1.59559865320347E-14,
1.98031695208822E-14,
5.32265204133964E-14,
4.46435423351321E-14,
8.09222480691041E-14,
5.75268999103429E-14,
9.40801256343882E-14,
5.85954895715446E-14,
9.65503718641791E-14,
5.71044947439425E-14,
1.01085806392121E-13,
5.73222025401776E-14,
1.04525763044983E-13,
6.63176111248553E-14,
1.15505695286178E-13,
7.72732572373869E-14,
1.23916502059451E-13,
8.0177184336172E-14,
1.25188054367342E-13,
7.05546732149287E-14,
1.18556206518683E-13,
6.2600966077575E-14,
1.24534063616899E-13,
5.78374154125427E-14,
1.24266916201599E-13,
5.08933173382076E-14,
1.19236218121266E-13,
0.809414751385624,
1.20702059458466E-13,
0.430185672774355,
1.19950924193368E-13,
0.344999557237194,
1.19128665265755E-13,
0.310015540727529,
1.15076351225873E-13,
0.296016704017647,
1.14130926931466E-13,
0.295866788042661,
1.20563281580388E-13,
0.30958497219514,
1.32675120889658E-13,
0.344352596545565,
1.25092644576164E-13,
0.429462667335315,
1.21324825186342E-13,
0.809023404709509,
1.17593434989516E-13,
-1.99441158033054E-14,
1.20599710773384E-13,
-2.15574086359638E-14,
1.21897283933414E-13,
3.09158081079897E-14,
3.12787989953378E-14,
6.91473787950425E-14,
5.57722271143923E-14,
9.28155122204011E-14,
6.24604534760209E-14,
1.00633043564891E-13,
6.37649655299555E-14,
9.88202575324948E-14,
5.65996902124333E-14,
1.01106623073832E-13,
6.6720066971282E-14,
1.157459544876E-13,
7.71700411905663E-14,
1.26570628977696E-13,
8.17106798889355E-14,
1.30232630235483E-13,
7.55333295909821E-14,
1.25958271590676E-13,
6.67122607156401E-14,
1.27791874304783E-13,
6.34579194747076E-14,
1.30097321804357E-13,
5.30703953005585E-14,
1.2551244765735E-13,
4.87301171636645E-14,
1.21090637517085E-13,
0.809354017406618,
1.2164921847635E-13,
0.430052913984173,
1.21300539057678E-13,
0.344846545539741,
1.21423704424473E-13,
0.309859429158154,
1.17036588753727E-13,
0.295866788042661,
1.17749560102354E-13,
0.295729064751576,
1.26100518915706E-13,
0.309463969047069,
1.23139345942214E-13,
0.344252611217939,
1.19557141964322E-13,
0.429389630720551,
1.16968934538164E-13,
0.808995309662763,
1.14139600548846E-13,
-2.36269337428041E-14,
1.15804935085784E-13,
-3.06837888430778E-14,
1.63313373241492E-14,
5.38102548630626E-14,
4.41955499974611E-14,
8.27107479728362E-14,
6.14543138599544E-14,
1.0018895435504E-13,
6.80592734947361E-14,
1.03334008016986E-13,
6.34449090486378E-14,
9.9028424349612E-14,
6.6118985286856E-14,
1.12430030563271E-13,
7.7637549167342E-14,
1.26903695885083E-13,
8.17037409950316E-14,
1.32933594687579E-13,
7.71327446358328E-14,
1.30994173841437E-13,
7.1725611561213E-14,
1.35310165849667E-13,
6.74443140225023E-14,
1.3345054228342E-13,
5.86648785105837E-14,
1.31420915816527E-13,
5.09141340199193E-14,
1.27366867053169E-13,
4.05647737622417E-14,
1.22134941049623E-13,
0.809298863153363,
1.22790666523542E-13,
0.429931966592216,
1.23082100067506E-13,
0.344706726152898,
1.232920016081E-13,
0.309716380855414,
1.20563281580388E-13,
0.295729064751576,
1.22991894446756E-13,
0.295602242098094,
1.16623724566445E-13,
0.309352297189638,
1.17671497545935E-13,
0.344160146313676,
1.15088494290205E-13,
0.429321957193843,
1.13289586045617E-13,
0.808969229168276,
1.0938645822467E-13,
-3.29736238313671E-14,
1.17619455841655E-13,
3.12226373228031E-14,
3.32138830327899E-14,
7.03577821004053E-14,
5.10303604928097E-14,
9.12082909199086E-14,
6.75588057719168E-14,
1.03491000491562E-13,
6.80124359608847E-14,
1.03933354977936E-13,
7.30986451924487E-14,
1.10652806362133E-13,
7.71943273192299E-14,
1.23749101244019E-13,
8.22415052725844E-14,
1.33454011730372E-13,
7.71431529766886E-14,
1.33818303660327E-13,
7.33389043938715E-14,
1.40372088952567E-13,
7.2476746826311E-14,
1.40982711616111E-13,
6.28438273642118E-14,
1.34845259958105E-13,
5.65641283811757E-14,
1.33226762955019E-13,
4.27435864480685E-14,
1.28456273396083E-13,
4.09741685025722E-14,
1.23385676675802E-13,
0.809248621752147,
1.25037133424932E-13,
0.429821462989183,
1.25044072318836E-13,
0.344578618349794,
1.26964411206743E-13,
0.30958497219514,
1.26157764790413E-13,
0.295602242098094,
1.13953985136916E-13,
0.295485195343299,
1.11301592942148E-13,
0.309249017993965,
1.13298259662997E-13,
0.344074463541357,
1.11620782061728E-13,
0.429259132407755,
1.0848960618759E-13,
0.808944974451605,
1.11284245707388E-13,
-3.27272930977784E-14,
2.20171103570976E-14,
5.48749413964433E-14,
4.18757910292111E-14,
8.05631603095769E-14,
5.78868550316081E-14,
9.53273918136155E-14,
6.78910053175663E-14,
1.04476323425917E-13,
7.78899514330966E-14,
1.15769373254526E-13,
8.43561331898002E-14,
1.2223121820254E-13,
8.19257855999567E-14,
1.30447735946504E-13,
7.77850006628E-14,
1.34435865217775E-13,
7.34273752911463E-14,
1.43282954945256E-13,
7.41576938745325E-14,
1.46195555661421E-13,
6.78190142933133E-14,
1.42413858483792E-13,
6.0807262003415E-14,
1.36625086244457E-13,
4.82617418251508E-14,
1.34382088790019E-13,
4.32275742978661E-14,
1.29920380009807E-13,
3.66113389604905E-14,
1.25496835146066E-13,
0.809202723561746,
1.27347785094933E-13,
0.429720228828772,
1.29203939214229E-13,
0.34446094431544,
1.32633487526235E-13,
0.309463969047069,
1.16674031547248E-13,
0.295485195343299,
1.0844623810069E-13,
0.295376941632156,
1.06848557779315E-13,
0.309153308328064,
1.09781975177192E-13,
0.34399491332459,
1.06940498123542E-13,
0.429200702431274,
1.10604234104805E-13,
0.808922378415518,
1.14106640802802E-13,
3.21331503072564E-14,
3.54651204237388E-14,
6.80189411739196E-14,
4.97622776318707E-14,
8.57413098853677E-14,
5.87307980026708E-14,
9.68860408567807E-14,
7.81310779962574E-14,
1.16729542698479E-13,
8.93582083327793E-14,
1.27595850551998E-13,
8.92419818598889E-14,
1.29066028697888E-13,
7.75560171639711E-14,
1.31559693694605E-13,
7.41299382989169E-14,
1.44020212422546E-13,
7.42756550708989E-14,
1.49139381400154E-13,
6.9486083553727E-14,
1.47668335892526E-13,
6.57876531029444E-14,
1.44217970898808E-13,
5.2506610170866E-14,
1.37881026041065E-13,
4.88654255947907E-14,
1.35867012085455E-13,
3.89046433957319E-14,
1.31944802306272E-13,
3.03715386174019E-14,
1.27592381105046E-13,
0.809160679566042,
1.30798150088651E-13,
0.429627251019535,
1.34201677548518E-13,
0.344352596545565,
1.23111590366598E-13,
0.309352297189638,
1.11263429025676E-13,
0.295376941632156,
1.04083408558608E-13,
0.295276618979199,
1.03287170483135E-13,
0.309064443862001,
1.04813727141995E-13,
0.343920922272036,
1.08796652242837E-13,
0.429146265403529,
1.13653877975572E-13,
0.808901292710857,
1.88941744194704E-14,
5.24558695091937E-14,
4.52346493595712E-14,
7.48481138179713E-14,
5.13365391863196E-14,
8.80979317274821E-14,
6.93733265277885E-14,
1.09630186873044E-13,
8.98864316312142E-14,
1.28876076477269E-13,
9.44478870112953E-14,
1.34652705652272E-13,
8.49936440672217E-14,
1.30374877560513E-13,
7.40015687616946E-14,
1.41248124307936E-13,
7.50788320402762E-14,
1.49942558369531E-13,
6.96474128369928E-14,
1.50716245039817E-13,
6.74824779389738E-14,
1.49498469159681E-13,
5.7589349955478E-14,
1.45418399544184E-13,
5.30409050014669E-14,
1.3938329657126E-13,
4.4428002943242E-14,
1.37948680256628E-13,
3.25173915571852E-14,
1.33887692599366E-13,
2.6331367641852E-14,
1.31533672842465E-13,
0.80912206799804,
1.36597330668842E-13,
0.429541651758875,
1.25092644576164E-13,
0.344252611217939,
1.17614251671228E-13,
0.309249017993965,
1.0683814943846E-13,
0.295276618979199,
1.00463040664245E-13,
0.29518346880809,
9.85860698632379E-14,
0.30898178513,
1.06832945268032E-13,
0.343851982670403,
1.11488943077553E-13,
0.429095464506141,
1.21447990553136E-13,
2.8457921782965E-14,
3.30885492616506E-14,
6.2080982715651E-14,
4.78480102761303E-14,
7.82126099996283E-14,
6.24847396046846E-14,
1.01370301042181E-13,
8.14929720927005E-14,
1.22148818837431E-13,
9.51929507442273E-14,
1.36236508185839E-13,
9.03131736063045E-14,
1.36156710905944E-13,
8.14886352840105E-14,
1.40179534646734E-13,
7.49712791847656E-14,
1.47342207879042E-13,
7.04904884463176E-14,
1.51597484565613E-13,
6.76785016917592E-14,
1.52640053374675E-13,
5.93310123253588E-14,
1.50778695084952E-13,
5.80976239339392E-14,
1.47014345142082E-13,
4.86676671185293E-14,
1.41425066102485E-13,
3.80789150211669E-14,
1.39855141356726E-13,
2.86264068005693E-14,
1.37844596848069E-13,
1.81313297709096E-14,
1.3690437672409E-13,
0.809086523493488,
1.27044208486637E-13,
0.429462667335315,
1.19626530903361E-13,
0.344160146313676,
1.13272238810858E-13,
0.309153308328064,
1.03353089975222E-13,
0.29518346880809,
9.57862261730114E-14,
0.295096821372605,
1.00522021262428E-13,
0.308904765839909,
1.09376049883814E-13,
0.343787643634448,
1.19879800530853E-13,
0.429047982020856,
1.92849208824342E-14,
4.45247137770277E-14,
3.7475231251527E-14,
6.69291011501372E-14,
5.96337215719167E-14,
9.22595333463505E-14,
7.49920958664774E-14,
1.14423227837168E-13,
8.71048025374854E-14,
1.29878746646384E-13,
9.1253393730284E-14,
1.37968629576601E-13,
8.69200544872939E-14,
1.46173004256234E-13,
8.25658985625921E-14,
1.46403722478539E-13,
7.04297731246584E-14,
1.49109891101062E-13,
6.85510676001755E-14,
1.53561191540419E-13,
5.95200971842402E-14,
1.53956708492942E-13,
5.98757154968155E-14,
1.52320864255096E-13,
5.3776427755281E-14,
1.49097748036731E-13,
4.22144957878956E-14,
1.43413059205955E-13,
3.41168066020359E-14,
1.43813780328905E-13,
2.04506550582906E-14,
1.43308975797396E-13,
  0,
1.27550747741623E-13,
0.809053728239713,
1.21324825186342E-13,
0.429389630720551,
1.15144005441437E-13,
0.344074463541357,
1.09792383518048E-13,
0.309064443862001,
9.85305587120067E-14,
0.295096821372605,
9.7756872041721E-14,
0.295016083526818,
1.02985328598315E-13,
0.308832883024033,
1.17773846231017E-13,
0.343727503621298,
1.12609574443034E-13,
2.29404169271863E-14,
2.78644295137465E-14,
5.17992766735365E-14,
5.02540717373101E-14,
8.19570106225243E-14,
7.27334859007556E-14,
1.05858898036271E-13,
8.09395953038639E-14,
1.22535662172574E-13,
8.33716776171833E-14,
1.31900566857635E-13,
8.80042566597794E-14,
1.48181814041415E-13,
8.81308914735257E-14,
1.52509949113977E-13,
7.81111286762837E-14,
1.4824426408655E-13,
6.851463840718E-14,
1.51139517567955E-13,
6.03666422405169E-14,
1.54950705044676E-13,
6.00856170374087E-14,
1.55575205496028E-13,
5.54885998260701E-14,
1.54480594982687E-13,
4.73735634054506E-14,
1.51141252291431E-13,
3.83026943495679E-14,
1.47380371795514E-13,
2.60173826927002E-14,
1.49370099622459E-13,
  0,
1.33866875917654E-13,
  0,
1.22115859091387E-13,
0.809023404709509,
1.16967199814688E-13,
0.429321957193843,
1.11620782061728E-13,
0.34399491332459,
1.0486750356975E-13,
0.30898178513,
1.00520286538952E-13,
0.295016083526818,
1.00242730782796E-13,
0.294940728420411,
1.11284245707388E-13,
0.308765688706517,
1.1055045767705E-13,
0.343671204073291,
1.28690461065339E-14,
3.54612172959179E-14,
4.22743437478168E-14,
6.81512138389628E-14,
6.40945629903911E-14,
9.63430724087999E-14,
7.91424217827519E-14,
1.14499555670111E-13,
7.75204553327136E-14,
1.24873202056452E-13,
8.03411157046519E-14,
1.42370490396893E-13,
8.93382590128056E-14,
1.54739068780607E-13,
8.37611230375401E-14,
1.54518758899158E-13,
7.62567092804645E-14,
1.50447362901041E-13,
6.04447047969359E-14,
1.52643522821627E-13,
6.09859385214406E-14,
1.56614304858138E-13,
5.57418694535627E-14,
1.57726262606239E-13,
4.9139511903995E-14,
1.56555324259955E-13,
4.34721703079788E-14,
1.55138055180082E-13,
3.02396996332277E-14,
1.52933221642115E-13,
1.52967916111635E-14,
1.39874223314962E-13,
  0,
1.2846147756651E-13,
  0,
1.17510168262669E-13,
0.808995309662763,
1.1340060834808E-13,
0.429259132407755,
1.06938763400066E-13,
0.343920922272036,
1.06805189692416E-13,
0.308904765839909,
1.03013084173931E-13,
0.294940728420411,
1.08678691046471E-13,
0.294870286779708,
1.04286371205298E-13,
0.308702782825475,
1.00313854445311E-13,
1.80168380214951E-14,
3.07033044821825E-14,
5.39711504654594E-14,
5.72276601107369E-14,
8.35694360934447E-14,
7.10933048542195E-14,
1.05582209641852E-13,
7.60346646755394E-14,
1.17262102805604E-13,
7.4646885894758E-14,
1.35651906374434E-13,
8.17922118923065E-14,
1.49111625824538E-13,
8.50899212201384E-14,
1.56890125890818E-13,
8.20073176033276E-14,
1.56825941122207E-13,
6.82440215449276E-14,
1.519739195599E-13,
6.10726746952395E-14,
1.54338347657657E-13,
5.6697702088826E-14,
1.588555675891E-13,
4.93910468080117E-14,
1.59873850269499E-13,
4.52554660412829E-14,
1.60618046640693E-13,
3.53501949934554E-14,
1.60701313367539E-13,
1.9598905831586E-14,
1.43510203720609E-13,
1.02001740387436E-14,
1.34510458327242E-13,
  0,
1.24034463255818E-13,
-2.00030964014886E-14,
1.14136131101894E-13,
0.808969229168275,
1.08503483975397E-13,
0.429200702431274,
1.08810530030645E-13,
0.343851982670403,
1.09400336012477E-13,
0.308832883024033,
1.11285980430864E-13,
0.294870286779708,
1.01340810743089E-13,
0.294804339500896,
9.37010885548872E-14,
0.308643807197978,
2.25804618059211E-14,
4.1065241485061E-14,
4.74533606853456E-14,
7.08053407572073E-14,
6.50313136674185E-14,
9.35839947202588E-14,
6.84027487429795E-14,
1.08840020329737E-13,
7.34134975033385E-14,
1.28353924711E-13,
7.62497703865606E-14,
1.42663658664333E-13,
7.76687741899096E-14,
1.51450033070155E-13,
8.34349950240565E-14,
1.59327412374566E-13,
7.41021827233013E-14,
1.58458315913101E-13,
6.88945428484189E-14,
1.537936444862E-13,
5.68017854973846E-14,
1.5660910068771E-13,
5.03850433597464E-14,
1.61044788615783E-13,
4.55746551608627E-14,
1.63962593502376E-13,
3.71334907267595E-14,
1.6619865206291E-13,
2.47406262143812E-14,
1.51312989915553E-13,
1.44814715774544E-14,
1.38221031842356E-13,
  0,
1.3012160793302E-13,
-1.78936726547008E-14,
1.20570220474292E-13,
-2.36130559549963E-14,
1.09419417970713E-13,
0.808944974451605,
1.10690970278604E-13,
0.429146265403529,
1.11377920775091E-13,
0.343787643634448,
1.17862317128292E-13,
0.308765688706517,
1.04288105928774E-13,
0.294804339500896,
9.09394087811322E-14,
0.294742511333951,
9.42891598132434E-14,
2.9392720896082E-14,
4.43768286007007E-14,
6.02248285963558E-14,
5.64522387169752E-14,
8.1826906361826E-14,
6.28793891954693E-14,
9.74437544543072E-14,
6.61042401373102E-14,
1.2029960361204E-13,
7.51950585131667E-14,
1.35660579991814E-13,
7.22616411152899E-14,
1.4525186609049E-13,
7.60884411032947E-14,
1.54074669689308E-13,
7.55940449126413E-14,
1.6111070810787E-13,
7.47613776441725E-14,
1.60389063141864E-13,
6.46756953548433E-14,
1.56144194796148E-13,
5.04648406396413E-14,
1.58853832865624E-13,
4.65044669439862E-14,
1.65206390234651E-13,
3.75012521036666E-14,
1.69622996204488E-13,
2.64961663720698E-14,
1.56883186996915E-13,
1.96127836193938E-14,
1.46030756931204E-13,
  0,
1.33721159145672E-13,
-1.226276025168E-14,
1.2655154701946E-13,
-2.15261836133962E-14,
1.1580666980926E-13,
-3.29545418731314E-14,
1.1128771515434E-13,
0.808922378415518,
1.13657347422524E-13,
0.429095464506141,
1.19909290829945E-13,
0.343727503621298,
1.10552192400526E-13,
0.308702782825475,
9.37028232783632E-14,
0.294742511333951,
9.12186992607644E-14,
0.294684465477176,
2.86895073670079E-14,
5.51073943422242E-14,
5.56629395354058E-14,
7.2775986625917E-14,
5.50601231275039E-14,
8.64395360844483E-14,
6.10076225648903E-14,
1.09420285332451E-13,
6.81468770302729E-14,
1.28005245292329E-13,
7.13352987791183E-14,
1.38543690408888E-13,
7.07888608841856E-14,
1.48015280587721E-13,
6.83255535482985E-14,
1.55981130789407E-13,
7.63330371134074E-14,
1.6317155959733E-13,
7.05685510027365E-14,
1.62838492689943E-13,
5.83890574779033E-14,
1.58456581189625E-13,
4.66068156290689E-14,
1.63051863677488E-13,
3.84102472050785E-14,
1.70896283235855E-13,
2.68153554916495E-14,
1.60366511736676E-13,
2.14168960344097E-14,
1.51646056822941E-13,
  0,
1.41617620408319E-13,
  0,
1.30251712193719E-13,
-1.5929965679895E-14,
1.21886875592558E-13,
-3.07115444186934E-14,
1.17605578053848E-13,
-3.26648430526433E-14,
1.14037251863763E-13,
0.808901292710857,
1.21475746128752E-13,
0.429047982020856,
1.12567941079611E-13,
0.343671204073291,
1.00313854445311E-13,
0.308643807197978,
9.43412015175227E-14,
0.294684465477176,
9.5066315930481E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.00673592726142E-14,
0.999999999999992,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.01305682592701E-14,
  0,
1.7464111753962E-14,
  0,
1.40399844528183E-14,
  0,
1.21872997804751E-14,
  0,
1.36639831394003E-14,
1.35546955604138E-14,
2.77061359965636E-14,
1.96392381524024E-14,
3.21006242420818E-14,
2.21214106060907E-14,
3.1000159037009E-14,
1.72472713194649E-14,
3.26750345530646E-14,
2.16244123302234E-14,
3.11573683520194E-14,
1.667806517891E-14,
2.82597296258347E-14,
1.75874939611909E-14,
2.88213463511822E-14,
1.51322097213802E-14,
1.89911020936906E-14,
1.86001387902923E-14,
2.65317282033273E-14,
2.74743335720862E-14,
3.25065495354604E-14,
  0,
  0,
-1.24169338006075E-14,
  0,
-1.19479079407903E-14,
  0,
  0,
  0,
-1.38218429757142E-14,
0.867109969524107,
-1.56656371902431E-14,
0.866921446862997,
  0,
-1.0769597019733E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.07995209996936E-14,
  0,
2.39686742675715E-14,
1.0026268010277E-14,
2.72958738944951E-14,
  0,
2.26862799379557E-14,
  0,
2.2362754009686E-14,
1.44311645966511E-14,
3.58207387363141E-14,
2.87365617412938E-14,
5.1760679076196E-14,
3.62097504758019E-14,
5.46247075350337E-14,
3.40873163029443E-14,
5.51503287482547E-14,
3.36770542008757E-14,
5.52895403072018E-14,
3.31735507119735E-14,
5.14657760852799E-14,
2.96759145035352E-14,
4.94144655749373E-14,
2.83332385331292E-14,
4.13978747115795E-14,
2.92001665902486E-14,
3.9418121544621E-14,
3.98873642448727E-14,
5.11058209640147E-14,
4.91139247327244E-14,
  0,
-1.2416716960173E-14,
  0,
-1.50515450797473E-14,
  0,
-1.48657128273832E-14,
  0,
-1.69985553410967E-14,
0.840874266114531,
-1.69484652007279E-14,
0.562854639645239,
-1.5333654485028E-14,
0.840122671494809,
  0,
-1.36934734384919E-14,
  0,
-1.05328072652622E-14,
  0,
  0,
  0,
  0,
2.22499969837475E-14,
  0,
3.01009217551496E-14,
  0,
3.27294615021234E-14,
  0,
3.00462779656563E-14,
1.46445355841962E-14,
4.10977675502355E-14,
2.66791796987853E-14,
5.3853189269093E-14,
4.08891670522493E-14,
6.71567836063591E-14,
4.330346844994E-14,
7.16354059404622E-14,
4.63348977242095E-14,
7.04215331881475E-14,
4.05443907613989E-14,
6.8515939449787E-14,
4.22092916174677E-14,
6.61007706903582E-14,
3.65519246814383E-14,
5.57149812396851E-14,
3.87801769863305E-14,
5.70459478266283E-14,
4.61041795019046E-14,
5.80126224836164E-14,
5.54625789739305E-14,
7.19337783783303E-14,
  0,
  0,
-1.50454735475813E-14,
  0,
-1.7427899401401E-14,
-1.16434639707563E-14,
-2.10118381027691E-14,
0.830737329102076,
-1.90429269575354E-14,
0.503051291621874,
-1.64109177636096E-14,
0.501818924441715,
-1.55942966872935E-14,
0.828985507246359,
-1.04135450262888E-14,
-1.51792640956661E-14,
  0,
  0,
  0,
  0,
1.88178465865274E-14,
  0,
2.7228653359801E-14,
  0,
3.41900986688959E-14,
1.08884255778374E-14,
3.8746349878549E-14,
1.92549969024736E-14,
4.73583845750358E-14,
2.60663886308965E-14,
5.71387555325931E-14,
3.73438259482217E-14,
6.66081773070815E-14,
4.62052271443802E-14,
8.12119468895922E-14,
5.36888242197442E-14,
8.39007682773563E-14,
5.1383376720171E-14,
8.06915298467992E-14,
4.77794886988292E-14,
8.03393809811759E-14,
4.74576974940355E-14,
6.97376184577436E-14,
4.54228668567147E-14,
6.90020957039295E-14,
5.39446959324508E-14,
7.33198224356357E-14,
5.95331076103101E-14,
7.60728285920109E-14,
6.00387795035573E-14,
  0,
-1.19623278296843E-14,
  0,
-1.74001438257854E-14,
-1.16386934811974E-14,
-2.35488711863852E-14,
0.826332327885253,
-2.32032275337968E-14,
0.479600515134732,
-1.82913580115684E-14,
0.431767398034713,
-1.62912218437672E-14,
0.476051232703976,
-1.63658149532342E-14,
0.823008605159556,
  0,
-1.24748301966182E-14,
  0,
  0,
1.74474150405057E-14,
  0,
2.32734838345738E-14,
  0,
3.06486606926892E-14,
  0,
3.94623569932584E-14,
2.05772898720369E-14,
5.52283913046736E-14,
3.0144289842049E-14,
6.23208082362048E-14,
3.60909219176975E-14,
6.8584894707957E-14,
4.17652024076176E-14,
7.90990536958525E-14,
5.55180901251617E-14,
9.17616677087452E-14,
5.76379222128054E-14,
9.24755064191096E-14,
5.75720027207183E-14,
9.08431316282154E-14,
5.19766521489551E-14,
8.2426253322776E-14,
5.53827816940355E-14,
8.16135353742808E-14,
5.95417812276899E-14,
8.38088279331295E-14,
6.61814353319912E-14,
8.9830053118245E-14,
6.28117349799062E-14,
8.35546909438989E-14,
  0,
  0,
-1.48657128273832E-14,
-1.17132865906644E-14,
-2.35638331763655E-14,
0.825060067965361,
-2.53599224953049E-14,
0.469319537472725,
-2.1992824228434E-14,
0.403589226881235,
-1.77353791375179E-14,
0.400873679843421,
-1.6531914726059E-14,
0.462071035628456,
-1.31149431592537E-14,
0.819338537352137,
  0,
  0,
1.54759018100581E-14,
  0,
2.16450121715006E-14,
  0,
2.64285121565067E-14,
  0,
3.54802992541536E-14,
1.86855739214842E-14,
5.53949247583674E-14,
3.12042058858708E-14,
6.95329210875784E-14,
3.97858829215281E-14,
7.29711430169644E-14,
3.99706309717196E-14,
8.01650412718402E-14,
5.04370850640257E-14,
8.85914605563975E-14,
5.87654924721903E-14,
9.92062335058996E-14,
6.31135768647262E-14,
1.01524691431543E-13,
6.10570621839557E-14,
9.18067705191206E-14,
5.92590213011057E-14,
9.33029695171506E-14,
6.88355622502357E-14,
9.54002501996065E-14,
7.10022318717307E-14,
9.92825613388426E-14,
6.866555934959E-14,
9.62051618924598E-14,
6.09087433267597E-14,
  0,
-1.00280027337529E-14,
  0,
-2.10124886240726E-14,
0.826332327885253,
-2.53625245805189E-14,
0.466338299284759,
-2.41373761256103E-14,
0.391070714786782,
-2.09663016115247E-14,
0.370148576222067,
-1.80788543857613E-14,
0.383846026371474,
-1.29991503672322E-14,
0.453422708564643,
  0,
0.81688762388229,
1.08238071283573E-14,
  0,
1.95043634021452E-14,
  0,
2.44257739034914E-14,
  0,
3.10298661765351E-14,
1.39801364928971E-14,
5.10789327501371E-14,
2.90774349043232E-14,
6.91668944341473E-14,
4.05005889936305E-14,
7.96385526968812E-14,
4.33498723029224E-14,
8.39606162372775E-14,
4.8245261952129E-14,
8.89774365298024E-14,
5.32135099873265E-14,
9.52484618954585E-14,
6.36964439526544E-14,
1.07404536653366E-13,
6.60487289860789E-14,
1.01686020714808E-13,
6.78675865506406E-14,
1.01910667404947E-13,
7.22208751136044E-14,
1.06361967844304E-13,
7.97114110828723E-14,
1.101063684672E-13,
7.28956825457594E-14,
1.0486750356975E-13,
6.62829166553358E-14,
1.08620577810026E-13,
  0,
  0,
-1.69434778707345E-14,
0.830737329102076,
-2.32058296190107E-14,
0.469319537472725,
-2.41321719551824E-14,
0.387419510175028,
-2.32691470258839E-14,
0.356377212108753,
-2.15769242750685E-14,
0.351538093988781,
-1.46883373519646E-14,
0.373202849064463,
  0,
0.447616972799634,
  0,
0.81515371346584,
1.45430542608516E-14,
  0,
2.21272652978222E-14,
  0,
2.89664126018607E-14,
1.09148801108461E-14,
4.63431376607204E-14,
2.43442419001205E-14,
6.45403869237171E-14,
3.82385095809568E-14,
7.88171611310062E-14,
4.38503400257417E-14,
9.01587832169426E-14,
5.13721010175772E-14,
9.22604007080885E-14,
5.07259165227758E-14,
9.50723874626469E-14,
5.78747119672762E-14,
1.02837009741119E-13,
6.63210805718073E-14,
1.07002080806939E-13,
7.2474144741097E-14,
1.11193172724899E-13,
8.03888206002412E-14,
1.14383329197221E-13,
8.26326854164172E-14,
1.20379400891935E-13,
8.1151231567933E-14,
1.15044258841568E-13,
7.00871652381529E-14,
1.16620255119493E-13,
6.50555997960822E-14,
  0,
-1.3835720763522E-14,
0.840874266114531,
-1.90455290427494E-14,
0.479600515134732,
-2.19936915901719E-14,
0.391070714786782,
-2.33289949858051E-14,
0.352344492792924,
-2.36663987018826E-14,
0.336968799433662,
-1.7873289653858E-14,
0.339828173682782,
  0,
0.366006144277868,
  0,
0.443493939383353,
  0,
0.813874113778782,
1.72561617772793E-14,
  0,
2.66106581214842E-14,
  0,
4.41174874410422E-14,
2.12026576851265E-14,
5.96050986345631E-14,
3.32798025248771E-14,
7.39174346731097E-14,
4.13748896255228E-14,
8.90459581071035E-14,
5.16609324763273E-14,
9.8058713926541E-14,
5.35864755346616E-14,
9.79633041353623E-14,
5.51511961099926E-14,
1.02255877376667E-13,
6.02243949154868E-14,
1.01987862599628E-13,
7.24195009516038E-14,
1.16045194287206E-13,
8.46111375407688E-14,
1.23122866069192E-13,
9.04779723365223E-14,
1.27887284095962E-13,
8.37290306532346E-14,
1.24790802691344E-13,
7.80191883320569E-14,
1.26328635052797E-13,
6.85744863671012E-14,
1.2640929969443E-13,
-1.00673592726142E-14,
0.867109969524107,
-1.70037595115247E-14,
0.503051291621874,
-1.82358468603372E-14,
0.403589226881235,
-2.09940571871403E-14,
0.356377212108753,
-2.36104538697823E-14,
0.332690388225365,
-2.02264420490206E-14,
0.324712024464899,
  0,
0.33187235457397,
  0,
0.360868316187502,
  0,
0.440442414157476,
1.20728080310606E-14,
0.812898687954003,
2.1615521872409E-14,
  0,
4.15622397609283E-14,
1.96457433654373E-14,
5.72372010898548E-14,
3.01252078838132E-14,
6.87852552694324E-14,
3.63927638025174E-14,
8.38504612965529E-14,
4.90302243250085E-14,
9.65902705041266E-14,
5.37304575831676E-14,
1.03473653256803E-13,
5.78018535812852E-14,
1.04815461865471E-13,
5.73065900288938E-14,
1.01091010562548E-13,
6.61467408624716E-14,
1.10638061212587E-13,
8.4372613062822E-14,
1.2760365680764E-13,
9.44513564582472E-14,
1.36237375547577E-13,
9.12386485807382E-14,
1.31870209196805E-13,
8.03419830663898E-14,
1.35625885522295E-13,
7.62619134508924E-14,
1.356579779066E-13,
7.13491765669261E-14,
0.999999999999992,
-1.58620946238974E-14,
0.562854639645239,
-1.63918358053738E-14,
0.431767398034713,
-1.77319096905659E-14,
0.370148576222067,
-2.15886336585314E-14,
0.336968799433662,
-2.02264420490206E-14,
0.320263922111687,
-1.21595442048594E-14,
0.316362342148597,
  0,
0.326172415368014,
  0,
0.357050607389247,
1.18082627009741E-14,
0.438111070166102,
1.59880789163402E-14,
0.812135760814598,
3.66867994316955E-14,
1.51155130079239E-14,
5.45744005542304E-14,
2.84746184964213E-14,
6.62586305266721E-14,
3.30031141304588E-14,
7.85291970339941E-14,
4.39917199890338E-14,
9.12230360694544E-14,
5.1012145896312E-14,
1.0175454229211E-13,
5.78053230282372E-14,
1.10052592039445E-13,
5.98488272829378E-14,
1.03367835124768E-13,
6.30658719691368E-14,
1.09427224226355E-13,
7.78006131740838E-14,
1.21864324187371E-13,
9.39049185633145E-14,
1.40330455589144E-13,
9.50177436731536E-14,
1.3988810110277E-13,
8.76260869420165E-14,
1.4237569456732E-13,
7.84199094550075E-14,
1.44592671169619E-13,
7.88605292179057E-14,
1.40025144257372E-13,
  0,
0.866921446862997,
-1.54442431066215E-14,
0.501818924441716,
-1.62907881628982E-14,
0.400873679843421,
-1.81625547934772E-14,
0.351538093988781,
-1.78871674416659E-14,
0.324712024464899,
-1.22731685925359E-14,
0.311791331579635,
  0,
0.31036813019475,
  0,
0.321925516664871,
1.00527225432856E-14,
0.354124932661828,
1.62135929682172E-14,
0.436284394622795,
3.10454786878189E-14,
0.811526400882391,
4.92774224203352E-14,
2.37544359182884E-14,
6.3497818114655E-14,
3.13160955500713E-14,
7.58230284114703E-14,
4.05925293378573E-14,
8.56675841376386E-14,
4.57810872545039E-14,
9.62016924455078E-14,
5.50002751675827E-14,
1.08110569108089E-13,
5.96909674466239E-14,
1.08353430394725E-13,
6.54875459416004E-14,
1.11504555588837E-13,
7.4648620618234E-14,
1.20436646766642E-13,
8.72010796904021E-14,
1.34349996405714E-13,
9.42700778550076E-14,
1.43680206621255E-13,
9.1175331173865E-14,
1.50076132077182E-13,
8.55166631952287E-14,
1.51025025818541E-13,
8.08155625753315E-14,
1.48646719932977E-13,
7.37222782820623E-14,
  0,
  0,
0.840122671494809,
-1.56029703046734E-14,
0.476051232703976,
-1.65006897034914E-14,
0.383846026371474,
-1.46848679050127E-14,
0.339828173682782,
  0,
0.316362342148597,
  0,
0.305704899197428,
  0,
0.305894998476223,
  0,
0.318664009767438,
1.44086131914634E-14,
0.351827004769081,
3.07505756969029E-14,
0.43482333130513,
4.36517141877424E-14,
0.811031132439902,
5.82719636432749E-14,
2.677632421344E-14,
7.29711430169644E-14,
3.88005599871732E-14,
8.29232515986433E-14,
4.23636820068296E-14,
9.0578586298129E-14,
4.96686025641679E-14,
1.02366899679129E-13,
5.669596736535E-14,
1.06226659413178E-13,
6.51874387802565E-14,
1.16331423660743E-13,
7.69115673926457E-14,
1.22251167522514E-13,
8.3847859211339E-14,
1.32654304207946E-13,
8.73745520379998E-14,
1.37452549342498E-13,
9.03270513941123E-14,
1.5364272354379E-13,
8.89028434203354E-14,
1.58489540935669E-13,
8.78741523990811E-14,
1.5483274384831E-13,
7.55784324013575E-14,
1.48207834893554E-13,
  0,
-1.07442266888969E-14,
  0,
0.828985507246359,
-1.63935705288498E-14,
0.462071035628456,
-1.2942338173394E-14,
0.373202849064463,
  0,
0.33187235457397,
  0,
0.31036813019475,
  0,
0.30116063718233,
  0,
0.302455514878912,
1.13199380424867E-14,
0.316097955212206,
2.93523885752656E-14,
0.349985409101039,
4.35242120122581E-14,
0.433634445827701,
5.22359933086136E-14,
0.810622603950345,
6.75241113023972E-14,
3.4256451841852E-14,
7.98762098130901E-14,
4.05647737622417E-14,
8.76234848568025E-14,
4.61922167183104E-14,
9.66050156536724E-14,
5.13642947619353E-14,
1.00331201680071E-13,
6.21377949094892E-14,
1.14063272715903E-13,
7.65568164418085E-14,
1.26908900055511E-13,
8.60197330032619E-14,
1.34331781809216E-13,
8.39293912147099E-14,
1.35535679901544E-13,
8.33517282972096E-14,
1.4716179663754E-13,
8.79539496789761E-14,
1.61766433581789E-13,
9.11319630869656E-14,
1.62038785167518E-13,
8.24462026427497E-14,
1.54137119734443E-13,
6.77357475664664E-14,
  0,
  0,
-1.36344928403087E-14,
-1.04482394958083E-14,
0.823008605159556,
-1.31149431592537E-14,
0.453422708564643,
  0,
0.366006144277868,
  0,
0.326172415368014,
  0,
0.305894998476223,
  0,
0.297665051016871,
  0,
0.299746753126025,
2.58256957486047E-14,
0.314038642908484,
4.19291337760974E-14,
0.348484477158565,
5.19601722759333E-14,
0.43265283475681,
6.18428919185732E-14,
0.810281321675695,
7.46651004912557E-14,
3.59183169318378E-14,
8.46033312851269E-14,
4.44080536232683E-14,
9.35770558263549E-14,
4.78055095509688E-14,
9.44973266303606E-14,
5.67219882174896E-14,
1.08031639189932E-13,
7.33926808216268E-14,
1.24502838594331E-13,
8.55530923882242E-14,
1.38817776718092E-13,
8.59538135111748E-14,
1.37041419878692E-13,
7.97816673836493E-14,
1.4510961876546E-13,
8.08485223213751E-14,
1.5509989126361E-13,
9.00304136797203E-14,
1.65126592954756E-13,
8.56103382629314E-14,
1.61131524789582E-13,
7.45341288688195E-14,
1.5693696342467E-13,
  0,
  0,
  0,
-1.52104891182336E-14,
  0,
0.819338537352137,
  0,
0.447616972799634,
  0,
0.360868316187502,
  0,
0.321925516664871,
  0,
0.302455514878912,
  0,
0.294911211184092,
2.37639768974063E-14,
0.297571158947787,
3.86305570865275E-14,
0.312358363191178,
5.06955588619462E-14,
0.347243575613077,
6.18428919185732E-14,
0.431832141311507,
6.86967843721575E-14,
0.809993055087066,
7.91250745479921E-14,
3.9643635596498E-14,
9.05152688912558E-14,
4.60803270541099E-14,
9.13730896501264E-14,
5.30738647475104E-14,
1.02046843197812E-13,
6.79421796601076E-14,
1.18351509148518E-13,
8.23681400863308E-14,
1.36285080443166E-13,
8.54750298318052E-14,
1.4137996329211E-13,
8.17262924002193E-14,
1.46434947501106E-13,
7.72056030218238E-14,
1.52922813301259E-13,
8.28642710004601E-14,
1.58323007481975E-13,
8.44133790645074E-14,
1.64063207463983E-13,
7.76028546978225E-14,
1.63764835026114E-13,
6.94635321485393E-14,
  0,
  0,
-1.04877044548868E-14,
  0,
-1.24271253010289E-14,
  0,
0.81688762388229,
  0,
0.443493939383353,
  0,
0.357050607389246,
1.00527225432856E-14,
0.318664009767438,
1.12089157400241E-14,
0.299746753126025,
2.37570380035024E-14,
0.292698824003426,
3.63997026964213E-14,
0.295794814566557,
4.70630479032508E-14,
0.31096787127609,
5.99390329036886E-14,
0.346204941044028,
6.86083134748827E-14,
0.431138463130618,
7.32408925174788E-14,
0.809747199266645,
8.51090031783741E-14,
4.13141743038636E-14,
8.81586470491413E-14,
5.11986286699795E-14,
9.88497478315864E-14,
6.42697700614647E-14,
1.12252221406983E-13,
7.67857999406374E-14,
1.2998803422537E-13,
8.21322176935979E-14,
1.38777878078145E-13,
8.11763850583347E-14,
1.5066767278249E-13,
7.91554322088217E-14,
1.54166610033535E-13,
7.91398196975379E-14,
1.55962048831171E-13,
7.71570307644964E-14,
1.57131252453979E-13,
7.63018120908399E-14,
1.66533453693773E-13,
7.24247051220317E-14,
1.58916282910759E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.08524300657109E-14,
0.81515371346584,
  0,
0.440442414157476,
1.18646412139434E-14,
0.354124932661828,
1.43825923393237E-14,
0.316097955212206,
2.5881206899836E-14,
0.297571158947787,
3.63849575468755E-14,
0.290892041139216,
4.50845957788992E-14,
0.294324004988271,
5.6394992842268E-14,
0.309803102414209,
6.67027197365222E-14,
0.345326222206773,
7.26710358556204E-14,
0.430546496011273,
7.90287973950754E-14,
0.809535707993234,
8.24704887714134E-14,
4.63882404710958E-14,
9.57220414044002E-14,
6.2304328363183E-14,
1.08996145442575E-13,
7.30665528081431E-14,
1.23840174226508E-13,
7.65273261427168E-14,
1.3241144292131E-13,
7.78075520679877E-14,
1.47918136073066E-13,
7.84216441784835E-14,
1.58253618542936E-13,
8.09664835177415E-14,
1.57063598238416E-13,
7.33701294164391E-14,
1.54615903413813E-13,
6.89379109353183E-14,
1.59436699953552E-13,
7.10993763863854E-14,
1.61549593147292E-13,
7.12294806470837E-14,
  0,
  0,
  0,
  0,
  0,
1.54190896162198E-14,
  0,
1.4434634043603E-14,
0.813874113778782,
1.21005636066762E-14,
0.438111070166102,
1.62161950534312E-14,
0.351827004769081,
2.93107552118421E-14,
0.314038642908484,
3.86331591717415E-14,
0.295794814566557,
4.50160742015981E-14,
0.289395752875235,
5.4374039992755E-14,
0.293091375681759,
6.31777616333373E-14,
0.308817002277937,
7.11661632402105E-14,
0.344575740418694,
7.85933818026052E-14,
0.43003701521627,
7.65533469948565E-14,
0.809352379289016,
8.97910218400355E-14,
5.74852665469194E-14,
1.05753947265974E-13,
7.10473346821061E-14,
1.20511239876109E-13,
7.27404247946595E-14,
1.26176846748649E-13,
7.21107201728799E-14,
1.41508332829332E-13,
7.5092709828084E-14,
1.5542775400057E-13,
8.02500427221631E-14,
1.61122851172202E-13,
7.51568945966952E-14,
1.55644594435067E-13,
6.50937637125537E-14,
1.56895330061246E-13,
6.372853633696E-14,
1.54350490721988E-13,
6.98295588019704E-14,
1.69374930747423E-13,
  0,
  0,
  0,
  0,
1.74430782318158E-14,
  0,
1.94956897847653E-14,
  0,
1.72570291390173E-14,
0.812898687954003,
1.60158344919559E-14,
0.436284394622795,
3.07167485891213E-14,
0.349985409101039,
4.18502038579405E-14,
0.312358363191178,
4.7048302753705E-14,
0.294324004988271,
5.42890385424322E-14,
0.288141575394497,
6.12062484028897E-14,
0.292047405022382,
6.75891634327463E-14,
0.307974320732448,
7.69748847995189E-14,
0.343929383094463,
7.6294873196936E-14,
0.429595185157486,
8.46007291999129E-14,
0.809192365373048,
1.00176811290709E-13,
6.62317423127945E-14,
1.17236081953465E-13,
7.08235553537051E-14,
1.22799340140922E-13,
6.83723910821499E-14,
1.35147101842925E-13,
6.93195501000332E-14,
1.48917336795229E-13,
7.68309027510128E-14,
1.5813565734657E-13,
7.44595357593525E-14,
1.59532109744731E-13,
6.68753247223819E-14,
1.57814733503514E-13,
5.98462251977239E-14,
1.51666873504652E-13,
6.24084117717416E-14,
1.62075214360513E-13,
6.7836361528073E-14,
  0,
1.07604897214841E-14,
  0,
1.87866215639598E-14,
  0,
2.16658288532123E-14,
  0,
2.21532861499618E-14,
  0,
2.16120524254571E-14,
0.812135760814598,
3.10446113260809E-14,
0.43482333130513,
4.35164057566162E-14,
0.348484477158565,
5.06417824341909E-14,
0.31096787127609,
5.6394992842268E-14,
0.293091375681759,
6.12504838515271E-14,
0.287079213293161,
6.55777515623512E-14,
0.291154961475847,
7.32573723905006E-14,
0.307248191370839,
7.44352496306888E-14,
0.343368512614843,
8.33881574902051E-14,
0.42920939777521,
9.42128319803004E-14,
0.809051829349251,
1.11521902823597E-13,
6.60617394121488E-14,
1.19420098809719E-13,
6.62907229109777E-14,
1.31752248000438E-13,
6.55499959867356E-14,
1.42571718320106E-13,
7.10785597046737E-14,
1.51573198436949E-13,
7.10057013186827E-14,
1.56517160343483E-13,
6.61120463929521E-14,
1.61613777915903E-13,
6.15427847572292E-14,
1.52523826901785E-13,
5.85122228446977E-14,
1.59277105393762E-13,
6.03718464109448E-14,
1.65416291775244E-13,
1.01305682592701E-14,
  0,
2.22443591324506E-14,
  0,
2.32747848771808E-14,
  0,
2.44197023713255E-14,
  0,
2.66696387196674E-14,
  0,
3.66755237291017E-14,
0.811526400882391,
4.36413058468865E-14,
0.433634445827701,
5.20746640253478E-14,
0.347243575613077,
5.99399002654266E-14,
0.309803102414209,
6.31768942715993E-14,
0.292047405022383,
6.55699453067093E-14,
0.286170943807942,
7.10161096595385E-14,
0.29038572277547,
7.06899816460549E-14,
0.306617824163297,
8.16950673776518E-14,
0.342878525413901,
9.36629246384157E-14,
0.428870457363302,
1.05410472017731E-13,
0.808927700126658,
1.13993883776864E-13,
6.14612527538583E-14,
1.28419844203087E-13,
6.34770014329433E-14,
1.39069311622109E-13,
6.71962485654376E-14,
1.45180742427975E-13,
6.52689707836274E-14,
1.49850618025305E-13,
6.26668855696622E-14,
1.585450520869E-13,
6.07916494921312E-14,
1.56244808757755E-13,
6.02400074267706E-14,
1.60075078192712E-13,
5.64426977378574E-14,
1.62552263316407E-13,
5.8937230096312E-14,
  0,
2.39617353736676E-14,
  0,
2.71896220815915E-14,
  0,
2.6400756580891E-14,
  0,
2.89612084314328E-14,
  0,
4.15908626982819E-14,
1.5184901946963E-14,
4.92774224203352E-14,
0.811031132439902,
5.22342585851376E-14,
0.43265283475681,
6.17865134056039E-14,
0.346204941044028,
6.6640269691387E-14,
0.308817002277937,
6.76394704135497E-14,
0.291154961475847,
7.10785597046737E-14,
0.285387986369344,
6.8589231516647E-14,
0.289717757457441,
7.83557246863964E-14,
0.306066912597891,
9.19628956319585E-14,
0.342447838423599,
1.04973321701785E-13,
0.428570997767909,
1.07530304105374E-13,
0.808817494495008,
1.22750767883595E-13,
5.85555909315971E-14,
1.35594660499727E-13,
6.51301929055492E-14,
1.41541292575376E-13,
6.13484957279198E-14,
1.43416528652907E-13,
5.68486230312359E-14,
1.51836876405298E-13,
5.73117941993218E-14,
1.53127510671425E-13,
5.93500942835945E-14,
1.63776978090446E-13,
5.81461961912666E-14,
1.63242683259845E-13,
5.49664480598011E-14,
1.69437380792559E-13,
1.7464111753962E-14,
1.00401457980848E-14,
3.00753345838789E-14,
  0,
3.06508290970342E-14,
  0,
3.10055800478715E-14,
1.09018696847762E-14,
4.4128763143636E-14,
1.96197225132977E-14,
5.45891457037762E-14,
2.37943345582359E-14,
5.82728310050129E-14,
0.810622603950345,
6.18732495794028E-14,
0.431832141311507,
6.86091808366207E-14,
0.345326222206773,
7.12008577097301E-14,
0.307974320732448,
7.32591071139765E-14,
0.29038572277547,
6.86534162852581E-14,
0.284708049646356,
7.61040536145785E-14,
0.289133853490584,
8.83165068854552E-14,
0.305582511394628,
1.03316660782227E-13,
0.342067162927338,
1.07355097034301E-13,
0.428305058716807,
1.16849238618322E-13,
0.808719185981232,
1.29713947916166E-13,
6.02677630023862E-14,
1.3818460264936E-13,
5.92789706210795E-14,
1.39811773269827E-13,
5.29697813389518E-14,
1.45354214775573E-13,
5.15264914069391E-14,
1.46398518308111E-13,
5.58580959264532E-14,
1.60605903576361E-13,
5.72805691767542E-14,
1.66916827581964E-13,
5.66525992784506E-14,
1.70094840989954E-13,
4.36282954208167E-14,
  0,
2.73084506396959E-14,
  0,
3.41649451784942E-14,
  0,
3.55219326175771E-14,
1.39792691311591E-14,
4.63431376607204E-14,
2.12304132607422E-14,
5.72441399837587E-14,
2.84503323677576E-14,
6.34926139442271E-14,
2.6779793660392E-14,
6.74521202781442E-14,
0.810281321675695,
6.86395384974503E-14,
0.431138463130618,
7.26155247043891E-14,
0.344575740418694,
7.69488639473792E-14,
0.307248191370839,
7.06448788356795E-14,
0.28971775745744,
7.60953799971986E-14,
0.284113635740449,
8.61082039005368E-14,
0.288620339539809,
9.95419024985011E-14,
0.305154231278395,
1.0532894001436E-13,
0.341728975701389,
1.1581534342664E-13,
0.428067773169789,
1.22925974954669E-13,
0.808631106850881,
1.32508587435964E-13,
5.43367434380215E-14,
1.36380490234345E-13,
5.09089298494914E-14,
1.41777214968108E-13,
4.76233635859913E-14,
1.39910652507957E-13,
5.00762625810225E-14,
1.53797113933152E-13,
5.37295902214296E-14,
1.63665955787984E-13,
5.58112583926018E-14,
1.73694392202606E-13,
4.53057730220863E-14,
1.69897082513693E-13,
1.40399844528183E-14,
  0,
3.27337983108134E-14,
1.09092422595491E-14,
3.94623569932584E-14,
1.8699451709292E-14,
5.10459730040935E-14,
2.43286293888367E-14,
5.96345889336547E-14,
3.00991870316736E-14,
6.62447527388643E-14,
3.13334427848311E-14,
7.30162458273398E-14,
3.4256451841852E-14,
7.46720393851596E-14,
0.809993055087066,
7.32617091991905E-14,
0.430546496011273,
7.85777692913214E-14,
0.343929383094463,
7.44491274184966E-14,
0.306617824163297,
7.83713371976802E-14,
0.289133853490584,
8.60526927493055E-14,
0.283590843837958,
9.73891106648139E-14,
0.288166238508552,
1.0158193730625E-13,
0.304773651754386,
1.1411184497323E-13,
0.341427128092285,
1.23193122369969E-13,
0.427855133437136,
1.2608143695747E-13,
0.808551873956791,
1.30607330506294E-13,
4.59025178978223E-14,
1.38207154054548E-13,
4.54480203471164E-14,
1.36264263761454E-13,
4.61575222487909E-14,
1.47241593917435E-13,
4.79113276830034E-14,
1.56862370315203E-13,
5.21960946686661E-14,
1.70368927299158E-13,
4.44366765606219E-14,
1.73458469809873E-13,
3.34645505750686E-14,
  0,
2.26802084057898E-14,
  0,
3.874591619768E-14,
2.06119843415564E-14,
5.53810469705596E-14,
2.91025883947249E-14,
6.45559994350009E-14,
3.33231706117765E-14,
6.88008677807161E-14,
3.30031141304588E-14,
7.57952728358546E-14,
3.88569385001425E-14,
7.99022306652297E-14,
3.59495419544054E-14,
7.91528301236077E-14,
0.809747199266645,
7.90010418194598E-14,
0.43003701521627,
7.6294873196936E-14,
0.343368512614843,
8.16968021011277E-14,
0.306066912597891,
8.82870165863636E-14,
0.288620339539809,
9.74463565395212E-14,
0.283128510862958,
9.99599708562116E-14,
0.2877626497698,
1.1039953673464E-13,
0.304433886530433,
1.21394214125381E-13,
0.341156553145767,
1.25576632425961E-13,
0.427663814040764,
1.24017116021058E-13,
0.808480331987412,
1.32728897317413E-13,
4.03947708615959E-14,
1.32676855613134E-13,
4.40238123733394E-14,
1.43629899640452E-13,
4.40359554376712E-14,
1.50291237788203E-13,
4.63882404710958E-14,
1.63542790421189E-13,
4.08093697723544E-14,
1.70093106266478E-13,
3.25902499431763E-14,
1.71560682327154E-13,
1.21872997804751E-14,
  0,
3.00254612839446E-14,
1.92662726050674E-14,
5.52361975603155E-14,
3.12128795032507E-14,
6.9184241668907E-14,
3.82671325183104E-14,
7.39261082904896E-14,
3.64343971659409E-14,
7.84945025644745E-14,
4.05942640613333E-14,
8.28954960230277E-14,
4.05855904439534E-14,
8.46033312851269E-14,
3.9643635596498E-14,
8.51055337314222E-14,
0.809535707993234,
7.65533469948565E-14,
0.429595185157486,
8.33881574902051E-14,
0.342878525413901,
9.19906512075741E-14,
0.305582511394628,
9.95488413924051E-14,
0.288166238508552,
9.99617055796875E-14,
0.282717584141817,
1.08343889415607E-13,
0.287402291666501,
1.17706192015454E-13,
0.304129257594765,
1.24001503509774E-13,
0.340913043491924,
1.24185384198228E-13,
0.427491036022848,
1.25975618825436E-13,
0.808415509573957,
1.26832572222568E-13,
3.91735255345083E-14,
1.39997388681756E-13,
4.19143886265516E-14,
1.46591072613944E-13,
4.23879681354933E-14,
1.56931759254242E-13,
3.50205975330198E-14,
1.63207988790326E-13,
2.9021923753092E-14,
1.68179706272475E-13,
2.78735368119953E-14,
  0,
2.23766317974938E-14,
1.46458366268032E-14,
4.73345321272411E-14,
3.01304120542412E-14,
6.95424620666962E-14,
4.04936500997266E-14,
7.88483861535738E-14,
4.13922368602826E-14,
8.38227057209373E-14,
4.3981311648178E-14,
8.56953397132543E-14,
4.2336793792952E-14,
8.75965966429249E-14,
4.44054515380543E-14,
9.0502258465186E-14,
4.13124395803877E-14,
8.25242651991687E-14,
0.809352379289016,
8.46111375407688E-14,
0.42920939777521,
9.36091482106605E-14,
0.342447838423599,
1.03372171933458E-13,
0.305154231278395,
1.01649591521813E-13,
0.2877626497698,
1.08415013078123E-13,
0.282350656712687,
1.15579421033907E-13,
0.287079158183496,
1.20344706422415E-13,
0.303855047797909,
1.21872997804751E-13,
0.340693080994853,
1.25498569869542E-13,
0.427334461916659,
1.20145213222678E-13,
0.808356585013247,
1.33910244004554E-13,
3.69027725044546E-14,
1.42953357484821E-13,
4.0389566691168E-14,
1.53136184288805E-13,
3.10289988147971E-14,
1.56529303407815E-13,
2.318457925643E-14,
1.61213056792953E-13,
2.4308680068863E-14,
1.65900279625042E-13,
1.36639831394003E-14,
1.44207562557952E-14,
4.11116453380433E-14,
2.60390667361499E-14,
6.23346860240126E-14,
3.978935236848E-14,
7.96350832499293E-14,
4.38407990466239E-14,
8.89973858497761E-14,
4.90874701997157E-14,
9.12004846642667E-14,
4.58105775535955E-14,
9.05863925537709E-14,
4.61826757391925E-14,
9.3640373233228E-14,
4.60256832646166E-14,
8.81170136857179E-14,
4.63622196189561E-14,
8.9902044142498E-14,
0.809192365373048,
9.41816069577328E-14,
0.428870457363302,
1.04947300849645E-13,
0.342067162927339,
1.05365369207355E-13,
0.304773651754386,
1.10392597840736E-13,
0.287402291666501,
1.1563840163209E-13,
0.282021618528962,
1.18068749221933E-13,
0.286788258168301,
1.18089565903645E-13,
0.303607310931216,
1.2341690169837E-13,
0.340493704751291,
1.19869392189997E-13,
0.427192113667378,
1.27720750642268E-13,
0.808302859259421,
1.36977235110081E-13,
3.52461115848968E-14,
1.49486326095349E-13,
2.8947330643625E-14,
1.52766688188422E-13,
1.91791027503996E-14,
1.54489268600067E-13,
1.85129689356245E-14,
1.58876384270812E-13,
1.54286305953377E-14,
1.35546955604138E-14,
3.58363512475979E-14,
2.66635671875015E-14,
5.71235767021783E-14,
3.60909219176975E-14,
7.29832860812962E-14,
4.33481375794464E-14,
9.01865387925582E-14,
5.16661366467552E-14,
9.66041482919344E-14,
5.09913292146003E-14,
9.62147028715776E-14,
4.96920213310936E-14,
9.66015462067205E-14,
4.78107137213968E-14,
9.13661507562225E-14,
5.11986286699795E-14,
9.57220414044002E-14,
5.75321040807708E-14,
1.00119565416001E-13,
0.809051829349251,
1.05420880358587E-13,
0.428570997767909,
1.07355097034301E-13,
0.341728975701389,
1.14122253314086E-13,
0.304433886530433,
1.17671497545935E-13,
0.287079158183496,
1.18030585305462E-13,
0.281725391476789,
1.1634963825724E-13,
0.286525415050449,
1.20119192370538E-13,
0.303382724444042,
1.18129464543593E-13,
0.34031240782974,
1.27209007216855E-13,
0.42706230791644,
1.30331509473613E-13,
0.80825373446599,
1.43586531553552E-13,
2.39547964797637E-14,
1.49035297991595E-13,
1.70766178975157E-14,
1.50665938059014E-13,
1.4436368767079E-14,
1.5213351411969E-13,
  0,
1.55014889813287E-13,
2.77061359965636E-14,
2.87435006351977E-14,
5.3854056630831E-14,
3.73681120768854E-14,
6.8586629431433E-14,
3.99853761212654E-14,
8.39606162372775E-14,
5.13729683793152E-14,
9.80621833734929E-14,
5.36992325606001E-14,
1.01784032591201E-13,
5.50306328284123E-14,
1.02385114275627E-13,
5.13261308454638E-14,
9.44869182895047E-14,
5.31154981109339E-14,
9.8808114468163E-14,
6.22939200223271E-14,
1.05762620883354E-13,
6.62282728658425E-14,
1.11521902823597E-13,
0.808927700126658,
1.0753203882885E-13,
0.428305058716807,
1.1581534342664E-13,
0.341427128092285,
1.21362989102813E-13,
0.304129257594765,
1.20313481399847E-13,
0.286788258168301,
1.1634963825724E-13,
0.281457725831645,
1.18124260373165E-13,
0.286287111452443,
1.14424095198906E-13,
0.303178474145743,
1.25418772589647E-13,
0.340147055779745,
1.30102525974785E-13,
0.426943604554453,
1.37327649252228E-13,
0.808208696805581,
1.43175402089746E-13,
1.2115308756222E-14,
1.47075060463742E-13,
1.23841908949984E-14,
1.48343143324681E-13,
  0,
1.4825293770393E-13,
  0,
1.96392381524024E-14,
5.17680516509689E-14,
4.08787587113935E-14,
6.66220550948893E-14,
4.17808149189014E-14,
8.0178919059648E-14,
4.8245261952129E-14,
9.22621354315645E-14,
5.35743324703297E-14,
1.03447632404663E-13,
5.78226702629969E-14,
1.0814005940718E-13,
5.66734159601623E-14,
1.00358957255686E-13,
5.67150493235857E-14,
1.02060720985619E-13,
6.42593617206089E-14,
1.08990941272147E-13,
7.105427357601E-14,
1.172985319986E-13,
6.60773519234326E-14,
1.13993883776864E-13,
0.808817494495009,
1.16849238618322E-13,
0.428067773169789,
1.23193122369969E-13,
0.341156553145766,
1.24004972956726E-13,
0.303855047797909,
1.18075688115837E-13,
0.286525415050449,
1.18134668714021E-13,
0.281215042313384,
1.12266099194791E-13,
0.286070367493961,
1.21494828086988E-13,
0.302992163155816,
1.28331373305812E-13,
0.339995821795094,
1.36597330668842E-13,
0.426834765507676,
1.36782946080771E-13,
0.808167302615397,
1.41204756221036E-13,
  0,
1.44644712873898E-13,
  0,
1.44365422394266E-13,
  0,
1.42851008799738E-13,
3.21006242420818E-14,
3.61871990706142E-14,
6.71567836063591E-14,
4.62052271443802E-14,
7.90851759080446E-14,
5.04379524257637E-14,
8.89583545715666E-14,
5.07241817992998E-14,
9.79494263475544E-14,
5.78087924751891E-14,
1.10017897569925E-13,
5.96909674466239E-14,
1.06220587881012E-13,
6.2158611591201E-14,
1.08005618337792E-13,
6.79283018722998E-14,
1.12217526937464E-13,
7.30387972325275E-14,
1.20509505152633E-13,
7.08235553537051E-14,
1.19449589108811E-13,
6.1483804159046E-14,
1.22808013758302E-13,
0.808719185981232,
1.2292944440162E-13,
0.427855133437136,
1.25633878300668E-13,
0.340913043491924,
1.21895549209938E-13,
0.303607310931216,
1.20179907692197E-13,
0.286287111452443,
1.12255690853935E-13,
0.280994308371221,
1.19595305880793E-13,
0.285872644652143,
1.24634677578506E-13,
0.302821739417949,
1.34737707102595E-13,
0.339857134734309,
1.36264263761454E-13,
0.426734721485706,
1.34822708552917E-13,
0.808129167149118,
1.38545425132364E-13,
  0,
1.40661787773055E-13,
  0,
1.38875022592799E-13,
-1.32654304207946E-14,
2.21214106060907E-14,
5.46620040897672E-14,
4.330346844994E-14,
8.12110795278542E-14,
5.55180901251617E-14,
8.85715112364238E-14,
5.31857544117109E-14,
9.50593770365771E-14,
5.51546655569446E-14,
1.04825870206326E-13,
5.98488272829378E-14,
1.08341287330393E-13,
6.51883061419944E-14,
1.14051129651571E-13,
7.34221711207184E-14,
1.1835497859547E-13,
7.67719221528296E-14,
1.23812418650893E-13,
7.27126692190438E-14,
1.22788931800066E-13,
6.62785798466459E-14,
1.28421578926563E-13,
5.85555909315971E-14,
1.29713947916166E-13,
0.808631106850881,
1.26084906404422E-13,
0.427663814040764,
1.24129873046996E-13,
0.340693080994853,
1.23510576766073E-13,
0.303382724444042,
1.14372053494627E-13,
0.286070367493961,
1.19539794729562E-13,
0.280792940436205,
1.22507906596958E-13,
0.285691769196131,
1.31257851809785E-13,
0.302665437556121,
1.34331781809216E-13,
0.339729637152549,
1.34239841464989E-13,
0.426642544972417,
1.32250113638044E-13,
0.808093955387171,
1.34703012633075E-13,
-1.06095687790742E-14,
1.35256389421912E-13,
-1.54338347657657E-14,
1.36271202655358E-13,
3.1000159037009E-14,
3.40864489412063E-14,
7.16371406639382E-14,
5.36862221345302E-14,
9.17599329852692E-14,
5.87516146843825E-14,
9.52198389581049E-14,
5.78712425203243E-14,
1.02271489887951E-13,
5.73187330932257E-14,
1.0335395733696E-13,
6.54875459416004E-14,
1.16314943787721E-13,
7.65498775479045E-14,
1.24502838594331E-13,
8.23681400863308E-14,
1.30015789800986E-13,
7.6516917801861E-14,
1.26171642578221E-13,
6.83758605291018E-14,
1.31724492424823E-13,
6.34770014329433E-14,
1.35594660499727E-13,
6.02382727032946E-14,
1.32482566583825E-13,
0.808551873956791,
1.24072627172289E-13,
0.427491036022848,
1.25515917104302E-13,
0.340493704751291,
1.18129464543593E-13,
0.303178474145742,
1.2148095029918E-13,
0.285872644652143,
1.22480151021342E-13,
0.280608726066024,
1.28902097329409E-13,
0.285525870750612,
1.30451205393456E-13,
0.302521731905547,
1.32126948271249E-13,
0.339612151191178,
1.31809493875146E-13,
0.426557428150058,
1.28095450913079E-13,
0.808061374484156,
1.29212612831608E-13,
-2.04055522479152E-14,
1.32496444371633E-13,
-2.3784793579118E-14,
1.72472713194649E-14,
5.51537981952066E-14,
4.63487755120173E-14,
8.39025030008322E-14,
5.76379222128054E-14,
9.92201112937074E-14,
6.37103217404622E-14,
1.02837009741119E-13,
6.01957719781332E-14,
1.01080602221693E-13,
6.30719435013027E-14,
1.11488943077553E-13,
7.69011590517898E-14,
1.26926247290271E-13,
8.55600312821281E-14,
1.3627467210231E-13,
8.21322176935979E-14,
1.32439198496925E-13,
7.2103781278976E-14,
1.35188735206349E-13,
6.55499959867356E-14,
1.39017269917829E-13,
6.51024373299336E-14,
1.38212358224976E-13,
5.43089878624059E-14,
1.30628147188006E-13,
0.808480331987412,
1.2598255771934E-13,
0.427334461916659,
1.19905821382993E-13,
0.34031240782974,
1.2547775318783E-13,
0.302992163155816,
1.24688454006261E-13,
0.285691769196131,
1.28929852905024E-13,
0.280439761466859,
1.28494437312554E-13,
0.285373332651959,
1.28353924711E-13,
0.302389298319748,
1.29613333954559E-13,
0.339503650680906,
1.27745036770932E-13,
0.42647866474893,
1.22780258182686E-13,
0.808031167526985,
1.26541138678604E-13,
-2.88484514054943E-14,
1.25845514564737E-13,
3.26750345530646E-14,
3.36822583713037E-14,
7.04150279751126E-14,
5.13929176992889E-14,
9.24572918226119E-14,
6.31014338003943E-14,
1.07405404015104E-13,
6.63228152952833E-14,
1.01989597323104E-13,
6.6120720010332E-14,
1.09458449248923E-13,
7.46503553417099E-14,
1.22247698075562E-13,
8.60232024502139E-14,
1.38833389229376E-13,
8.54490089796656E-14,
1.38767469737289E-13,
7.77936742801799E-14,
1.4148751614762E-13,
6.93195501000332E-14,
1.42580391937486E-13,
6.72361472053851E-14,
1.41600273173559E-13,
5.92633581097957E-14,
1.36371816616965E-13,
4.59580290490536E-14,
1.32739305658269E-13,
0.808415509573957,
1.20143478499202E-13,
0.427192113667377,
1.27202068322951E-13,
0.340147055779745,
1.28331373305812E-13,
0.302821739417949,
1.31271729597593E-13,
0.285525870750612,
1.2849617203603E-13,
0.280284401002698,
1.26518587273416E-13,
0.285232751569008,
1.26169907854745E-13,
0.302266982921362,
1.25854188182117E-13,
0.339403238192962,
1.22219942499946E-13,
0.42640563504152,
1.20133070158346E-13,
0.808003108349127,
1.1982081993267E-13,
-3.14678838542193E-14,
2.16244123302234E-14,
5.52843361367739E-14,
4.05235740796872E-14,
8.06767846972534E-14,
5.75772068911462E-14,
1.01531630325447E-13,
6.60487289860789E-14,
1.07001213445201E-13,
7.24273072072457E-14,
1.10638061212587E-13,
7.78214298557955E-14,
1.2039848285017E-13,
8.3847859211339E-14,
1.34352598490928E-13,
8.59885079806944E-14,
1.41411188314677E-13,
8.1152098929671E-14,
1.47945891648682E-13,
7.5092709828084E-14,
1.48889581219613E-13,
7.10976416629094E-14,
1.45154721575835E-13,
6.13623735157276E-14,
1.39832589951538E-13,
5.08690312095439E-14,
1.38203684607596E-13,
4.04086486494037E-14,
1.26801347200001E-13,
0.808356585013247,
1.27727689536172E-13,
0.42706230791644,
1.30088648186977E-13,
0.339995821795094,
1.34734237655643E-13,
0.302665437556121,
1.30395694242225E-13,
0.285373332651959,
1.26487362250849E-13,
0.28014121612351,
1.24027524361914E-13,
0.285102904456506,
1.21848711676087E-13,
0.302153776385275,
1.20316950846799E-13,
0.339310126056347,
1.1951030443047E-13,
0.426337793371339,
1.13634796017337E-13,
0.807976997200813,
1.23808949203941E-13,
3.11573683520194E-14,
3.31588055624277E-14,
6.84968574915512E-14,
4.77846928692571E-14,
9.08344580108356E-14,
6.10709399717635E-14,
1.01686020714808E-13,
7.24559301445993E-14,
1.16038255393303E-13,
8.4372613062822E-14,
1.21841772782183E-13,
8.71733241147865E-14,
1.32662977825326E-13,
8.3922452320806E-14,
1.370552976665E-13,
8.17609868697389E-14,
1.50678081123345E-13,
7.83904191559159E-14,
1.55431223447522E-13,
7.68517194327245E-14,
1.51573198436949E-13,
6.52793791244832E-14,
1.43473774527614E-13,
5.29697813389518E-14,
1.41808439990676E-13,
4.54445509001644E-14,
1.32694202847894E-13,
3.9114544936325E-14,
1.33854732853322E-13,
0.808302859259421,
1.30262120534574E-13,
0.426943604554453,
1.36597330668842E-13,
0.339857134734309,
1.34255453976273E-13,
0.302521731905547,
1.28411170585707E-13,
0.285232751569008,
1.24027524361914E-13,
0.280008961748973,
1.19902351936041E-13,
0.284982721352565,
1.16665357929868E-13,
0.30204879265834,
1.17629864182511E-13,
0.339223620574075,
1.1297386637299E-13,
0.426274657736936,
1.17019241518967E-13,
0.807952657116859,
1.667806517891E-14,
5.14727149791838E-14,
4.22231694052755E-14,
8.03255031933681E-14,
5.19783868724311E-14,
9.18215156686664E-14,
6.78727907210686E-14,
1.11179294937092E-13,
8.46250153285766E-14,
1.2759498319026E-13,
9.39222657980743E-14,
1.34318771383146E-13,
8.73658784206199E-14,
1.35535679901544E-13,
7.97781979366974E-14,
1.46462703076722E-13,
7.91554322088217E-14,
1.58270965777696E-13,
8.0256981616067E-14,
1.58149535134378E-13,
7.09935582543508E-14,
1.49862761089636E-13,
5.68555619251399E-14,
1.45359418946001E-13,
4.76112205216594E-14,
1.36260794314502E-13,
4.4051567948955E-14,
1.399869803409E-13,
3.68993030575027E-14,
1.37032746261312E-13,
0.80825373446599,
1.37327649252228E-13,
0.426834765507676,
1.36262529037978E-13,
0.339729637152549,
1.32133887165153E-13,
0.302389298319748,
1.2614215227913E-13,
0.285102904456506,
1.19928372788181E-13,
0.279886548594771,
1.14385931282435E-13,
0.28487126286402,
1.14052864375047E-13,
0.30195125125915,
1.10958117693905E-13,
0.339143108834669,
1.16621989842969E-13,
0.42621580105162,
1.24832436054767E-13,
2.82597296258347E-14,
2.96746134609283E-14,
6.60868929025504E-14,
4.74472891531796E-14,
8.24054366410643E-14,
5.92520824072018E-14,
1.01908932681471E-13,
8.0407902558477E-14,
1.23114192451812E-13,
9.44392133939154E-14,
1.40343466015214E-13,
9.42527306202479E-14,
1.37428263213835E-13,
8.33378505094018E-14,
1.45111353488936E-13,
7.72038682983478E-14,
1.54142323904871E-13,
8.09873001994532E-14,
1.61095095596586E-13,
7.44387190776408E-14,
1.56517160343483E-13,
6.27033147626577E-14,
1.51878509768721E-13,
5.14970011078475E-14,
1.39924530295765E-13,
4.61575222487909E-14,
1.4364377742826E-13,
4.19698997777829E-14,
1.4298805195434E-13,
3.52981532891761E-14,
1.43572653765744E-13,
0.808208696805581,
1.36781211357295E-13,
0.426734721485706,
1.34255453976273E-13,
0.339612151191178,
1.29665375658838E-13,
0.302266982921362,
1.21866058910847E-13,
0.284982721352565,
1.14384196558959E-13,
0.279773020266276,
1.11835887772749E-13,
0.284767701435619,
1.06796516075036E-13,
0.30186046248344,
1.14743284318486E-13,
0.339068047640865,
1.24535798340375E-13,
0.42616084377672,
1.75874939611909E-14,
4.94292107244831E-14,
3.65623330222942E-14,
6.97376184577436E-14,
5.53689039062277E-14,
9.32899590910807E-14,
7.22191403901284E-14,
1.14376390303317E-13,
9.04727681660944E-14,
1.36236508185839E-13,
9.49891207358E-14,
1.43694084409063E-13,
9.03201125002084E-14,
1.4716179663754E-13,
8.08624001091829E-14,
1.52926282748211E-13,
7.91398196975379E-14,
1.57077476026224E-13,
7.51915890662147E-14,
1.59540783362111E-13,
6.61328630746638E-14,
1.585450520869E-13,
5.73117941993218E-14,
1.46410661372443E-13,
5.00970792627342E-14,
1.47262410599147E-13,
4.40498332254791E-14,
1.4661882818956E-13,
4.0389566691168E-14,
1.49491530265777E-13,
2.39547964797637E-14,
1.4317366736627E-13,
0.808167302615397,
1.34886893321529E-13,
0.426642544972417,
1.3180775915167E-13,
0.339503650680906,
1.25850718735165E-13,
0.302153776385275,
1.1666882737682E-13,
0.28487126286402,
1.1185670445446E-13,
0.279667534200596,
1.04654132582205E-13,
0.284671305691025,
1.10885259307913E-13,
0.301775814980832,
1.22457599616155E-13,
0.338997954174607,
1.23706600518858E-13,
2.88213463511822E-14,
2.83401774270331E-14,
5.57054402605672E-14,
4.54306731123566E-14,
8.16274131620887E-14,
6.8808674036358E-14,
1.0633334490695E-13,
8.26404916720591E-14,
1.27894222989866E-13,
9.1253393730284E-14,
1.39887233741032E-13,
9.11614533860572E-14,
1.53646192990742E-13,
8.79747663606878E-14,
1.55115503774894E-13,
8.28503932126523E-14,
1.55962048831171E-13,
7.33441085642994E-14,
1.5559602217774E-13,
6.68753247223819E-14,
1.61613777915903E-13,
6.0807262003415E-14,
1.53157000970516E-13,
5.58563612029772E-14,
1.53804052827056E-13,
4.79252054708112E-14,
1.50294707235155E-13,
4.23879681354933E-14,
1.53134449565329E-13,
2.89612084314328E-14,
1.49066523014163E-13,
1.2115308756222E-14,
1.41142306175901E-13,
0.808129167149118,
1.32250113638044E-13,
0.426557428150058,
1.27774527070024E-13,
0.339403238192962,
1.20310011952895E-13,
0.30204879265834,
1.13990414329912E-13,
0.284767701435619,
1.04657602029157E-13,
0.279569345733062,
1.08829611988881E-13,
0.284581427281329,
1.18721005248901E-13,
0.301696765276944,
1.2163187124159E-13,
0.338932398092997,
1.51322097213802E-14,
4.14087167333044E-14,
3.87940547741383E-14,
6.90090345978334E-14,
5.95495874833318E-14,
9.54210668813182E-14,
7.97053395507064E-14,
1.20381135615411E-13,
8.37446431645184E-14,
1.31868474473329E-13,
8.76286890272304E-14,
1.50090009864989E-13,
8.8934068442903E-14,
1.61766433581789E-13,
9.00442914675281E-14,
1.58316068588071E-13,
7.7188255787064E-14,
1.54602025626005E-13,
6.51076415003615E-14,
1.57812998780038E-13,
6.15705403328448E-14,
1.56217053182139E-13,
5.93500942835945E-14,
1.60611107746789E-13,
5.37295902214296E-14,
1.56867574485631E-13,
4.63882404710958E-14,
1.5694563704205E-13,
3.1041141879129E-14,
1.52723320101522E-13,
1.70627401097079E-14,
1.47049039611602E-13,
  0,
1.38606140454023E-13,
0.808093955387171,
1.28150962064311E-13,
0.42647866474893,
1.2221820777647E-13,
0.339310126056347,
1.17661089205079E-13,
0.30195125125915,
1.06768760499421E-13,
0.284671305691025,
1.08772366114174E-13,
0.279477794714388,
1.16479742517939E-13,
0.284497489791138,
1.17857112957864E-13,
0.301622828899364,
1.1278825096106E-13,
1.89911020936906E-14,
2.91871561641788E-14,
5.70320700388205E-14,
5.39429612089748E-14,
8.38227057209373E-14,
7.10022318717307E-14,
1.10107235828938E-13,
8.11408232270772E-14,
1.2476651656268E-13,
8.03263705551061E-14,
1.4237569456732E-13,
8.55478882177962E-14,
1.58486071488717E-13,
9.11128811287298E-14,
1.65140470742564E-13,
8.43995012766996E-14,
1.57082680196652E-13,
6.89413803822703E-14,
1.56891860614294E-13,
5.98462251977239E-14,
1.52520357454833E-13,
6.02174560215829E-14,
1.63790855878254E-13,
5.73048553054178E-14,
1.63693711363599E-13,
5.21822168808583E-14,
1.63528912633382E-13,
3.500325029826E-14,
1.56513690896531E-13,
1.91981847086353E-14,
1.50686754740725E-13,
1.23876603419504E-14,
1.44644712873898E-13,
  0,
1.34729033485215E-13,
0.808061374484156,
1.22837504057394E-13,
0.42640563504152,
1.19635204520741E-13,
0.339223620574075,
1.10873116243582E-13,
0.30186046248344,
1.10914749607005E-13,
0.284581427281329,
1.16479742517939E-13,
0.279392294220962,
1.15459725114064E-13,
0.284418979341315,
1.08718589686418E-13,
0.301553572832151,
1.86001387902923E-14,
3.9418121544621E-14,
4.60903017140968E-14,
7.33146182652078E-14,
6.61744964380873E-14,
9.92947044031744E-14,
7.29008867161873E-14,
1.15037319947664E-13,
7.80330661198647E-14,
1.35625018160557E-13,
7.84042969437238E-14,
1.51063189735012E-13,
8.78776218460331E-14,
1.62021437932758E-13,
8.56207466037873E-14,
1.64070146357886E-13,
7.63018120908399E-14,
1.59426291612697E-13,
6.36990460378684E-14,
1.5168075129246E-13,
5.85191617386016E-14,
1.60073343469236E-13,
5.81409920208387E-14,
1.66908153964584E-13,
5.5797380604794E-14,
1.70368927299158E-13,
4.08232475601622E-14,
1.63202784619898E-13,
2.31654972981943E-14,
1.54497942217446E-13,
1.44641243426946E-14,
1.48343143324681E-13,
  0,
1.40682604454767E-13,
-1.06373243546898E-14,
1.29209143384656E-13,
0.808031167526985,
1.20129600711394E-13,
0.426337793371339,
1.12902742710475E-13,
0.339143108834669,
1.14743284318486E-13,
0.301775814980832,
1.18686310779381E-13,
0.284497489791138,
1.15456255667112E-13,
0.279312320991252,
1.06751413264661E-13,
0.284345436597435,
9.92886328710085E-14,
2.65317282033273E-14,
3.98869305640037E-14,
5.80074183131885E-14,
5.95296381633581E-14,
8.98248489478171E-14,
6.86724982434939E-14,
1.0484148271761E-13,
7.00871652381529E-14,
1.26330369776273E-13,
7.62601787274164E-14,
1.44596140616571E-13,
8.08294403631393E-14,
1.54829274401358E-13,
8.24583457070815E-14,
1.6112805534263E-13,
7.75785685691588E-14,
1.66536923140725E-13,
7.11063152802893E-14,
1.5435396016894E-13,
6.24101464952176E-14,
1.59277105393762E-13,
5.64426977378574E-14,
1.63246152706797E-13,
5.66369867671668E-14,
1.73694392202606E-13,
4.44384112840979E-14,
1.70110453501238E-13,
2.89941681774764E-14,
1.61199179005145E-13,
1.85320508938602E-14,
1.52135248843166E-13,
  0,
1.44361952947314E-13,
  0,
1.35275471380147E-13,
-2.04003480774873E-14,
1.26610527617643E-13,
0.808003108349127,
1.13700715509424E-13,
0.426274657736936,
1.16597703714305E-13,
0.339068047640865,
1.22526988555194E-13,
0.301696765276944,
1.17870990745672E-13,
0.284418979341315,
1.06806924415892E-13,
0.279237407292397,
9.70647173748063E-14,
0.284276449947968,
2.74743335720862E-14,
5.11205661135605E-14,
5.54513032713366E-14,
7.6066757059845E-14,
6.28047960860023E-14,
9.62051618924598E-14,
6.62846513788118E-14,
1.16608112055161E-13,
6.85580064940794E-14,
1.35659712630076E-13,
7.88796111761414E-14,
1.48664067167736E-13,
7.55853712952614E-14,
1.54150997522251E-13,
7.45323941453435E-14,
1.63761365579163E-13,
7.24524606976473E-14,
1.6155479731772E-13,
6.98434365897782E-14,
1.62078683807465E-13,
6.0357968623137E-14,
1.62567875827691E-13,
5.49543049954693E-14,
1.70098310436906E-13,
4.53075077455622E-14,
1.73446326745541E-13,
3.25798416023204E-14,
1.68193584060283E-13,
2.4312149515815E-14,
1.58904139846427E-13,
  0,
1.4827028493869E-13,
  0,
1.38875022592799E-13,
-1.540607919015E-14,
1.325276693942E-13,
-2.88467166820183E-14,
1.1980347269791E-13,
0.807976997200813,
1.17026180412871E-13,
0.42621580105162,
1.2448202191262E-13,
0.338997954174607,
1.21624932347686E-13,
0.301622828899364,
1.0872205913337E-13,
0.284345436597435,
9.71202285260375E-14,
0.279167133976983,
1.03032166132166E-13,
3.25065495354604E-14,
4.91065521579515E-14,
7.19415846339722E-14,
6.00474531209372E-14,
8.35321395387112E-14,
6.09451725197552E-14,
1.08621445171764E-13,
6.50356504761085E-14,
1.26389350374456E-13,
7.13483092051881E-14,
1.40035552598228E-13,
7.37535033046299E-14,
1.48202630723127E-13,
6.77392170134183E-14,
1.5693696342467E-13,
6.94739404893951E-14,
1.58912813463807E-13,
7.12277459236077E-14,
1.69387073811755E-13,
6.78207490167893E-14,
1.65374658411821E-13,
5.8938964819788E-14,
1.69439115516035E-13,
4.36265606973407E-14,
1.69912695024976E-13,
3.34784283628764E-14,
1.7158843790277E-13,
2.79117007284668E-14,
1.65884667113758E-13,
1.54286305953377E-14,
1.55035706494999E-13,
  0,
1.42844069905834E-13,
-1.32654304207946E-14,
1.36267733208406E-13,
-2.37674463443582E-14,
1.25845514564737E-13,
-3.14678838542193E-14,
1.23808949203941E-13,
0.807952657116859,
1.24832436054767E-13,
0.42616084377672,
1.23651089367627E-13,
0.338932398092997,
1.12729270362877E-13,
0.301553572832151,
9.93476134691917E-14,
0.284276449947968,
1.02969716087031E-13,
0.279101124534544,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.05035338066051E-14,
  0,
  0,
0.999999999999991,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.57805626205265E-14,
  0,
1.59173889346942E-14,
  0,
1.26264016603317E-14,
  0,
1.54325337231587E-14,
1.05622975643538E-14,
2.14973438356081E-14,
1.81300287283026E-14,
2.99816595161762E-14,
1.80296316071304E-14,
3.24323901068624E-14,
1.95377568290578E-14,
3.2721872086916E-14,
2.25021824090677E-14,
3.25479660584493E-14,
1.62361443734049E-14,
2.72340743706634E-14,
1.53145725267922E-14,
2.85498621271918E-14,
1.33953178410584E-14,
2.47970047273505E-14,
2.08077912539073E-14,
2.74619736673198E-14,
2.34280910643703E-14,
2.95648922010727E-14,
2.7970247645781E-14,
  0,
  0,
  0,
-1.01572396327132E-14,
  0,
-1.20973110001588E-14,
  0,
-1.40967966466565E-14,
-1.23627236919832E-14,
-1.57283040758127E-14,
0.866921446862997,
  0,
0.866778142217527,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.81087783657219E-14,
  0,
2.74138350908615E-14,
1.17310675062932E-14,
2.47345546822153E-14,
  0,
2.43381703679546E-14,
1.46761942876328E-14,
3.19588105979207E-14,
2.48772356881144E-14,
4.45901995882458E-14,
3.13234681248442E-14,
5.40418404471055E-14,
3.25108863441503E-14,
5.64223147370146E-14,
3.64088099946702E-14,
5.65133877195034E-14,
3.35595266853783E-14,
5.17537401822921E-14,
2.73067159162199E-14,
4.83033751885742E-14,
2.48698631133415E-14,
4.61965535270004E-14,
2.9615632862745E-14,
4.52650070204008E-14,
3.83313172869215E-14,
4.93736995732519E-14,
4.45125707126959E-14,
5.66053280637302E-14,
  0,
  0,
-1.00008976794408E-14,
  0,
-1.27387250054012E-14,
  0,
-1.89449150811427E-14,
-1.31713216722229E-14,
-1.70035426710902E-14,
0.84044429432965,
-1.54455441492285E-14,
0.562211377199933,
  0,
0.839875767210725,
  0,
-1.06156403112401E-14,
  0,
-1.13537651502682E-14,
  0,
  0,
1.47399453753749E-14,
  0,
2.64948653294628E-14,
1.07518161041043E-14,
3.27017059265078E-14,
1.52712044398928E-14,
3.3360900847379E-14,
1.67335763301413E-14,
3.72748706900516E-14,
2.6476650732965E-14,
5.0112691774018E-14,
3.4109434027263E-14,
6.19968486270661E-14,
4.16749967868668E-14,
7.07199056260155E-14,
4.49176286443365E-14,
7.2774251902441E-14,
4.2558838397877E-14,
6.84586935750797E-14,
4.07824815584767E-14,
6.64459806620776E-14,
3.34472033403088E-14,
5.95821135485064E-14,
3.78126349676045E-14,
6.08159356207949E-14,
4.25033272466457E-14,
6.09486419667071E-14,
5.400107444542E-14,
6.95754218127398E-14,
5.58372792447415E-14,
  0,
-1.01851036285461E-14,
  0,
-1.22842274546953E-14,
  0,
-1.90140871797473E-14,
-1.28831407347763E-14,
-2.13496754997156E-14,
0.829971059101254,
-1.63536718889024E-14,
0.501818924441715,
-1.55240403865164E-14,
0.50088794707639,
  0,
0.828657323515795,
  0,
-1.24392683653607E-14,
  0,
  0,
1.49303312768634E-14,
  0,
2.21229284891322E-14,
  0,
3.04526369399039E-14,
1.37585255688411E-14,
4.00248410803439E-14,
2.14368453543834E-14,
4.48638522165812E-14,
2.76319765679656E-14,
5.3553082107749E-14,
3.44195158485938E-14,
6.51128456707895E-14,
4.2855476112269E-14,
7.57996096445446E-14,
5.22732898633471E-14,
8.40525565815042E-14,
4.91603285857067E-14,
8.17419049115031E-14,
4.8022349985466E-14,
8.03376462576999E-14,
4.53396001298678E-14,
7.50588827203025E-14,
4.49154602399915E-14,
7.1651885813484E-14,
4.90198159841526E-14,
7.40033034851706E-14,
5.61339169591335E-14,
7.83921538793919E-14,
6.29852073275039E-14,
8.42069469708662E-14,
  0,
  0,
-1.27317861114973E-14,
  0,
-1.85151373399695E-14,
  0,
-2.0721271920543E-14,
0.825074431946707,
-2.0266774369837E-14,
0.477560898658058,
-1.61520102848201E-14,
0.430075187969907,
-1.40048563024298E-14,
0.474901434241775,
  0,
0.822615085441342,
  0,
  0,
1.32680325060086E-14,
  0,
2.2063947890949E-14,
  0,
2.55559462480903E-14,
  0,
3.69981822956333E-14,
1.95728849794463E-14,
5.06599970306887E-14,
3.19206466814492E-14,
6.02209254685349E-14,
3.49408002531248E-14,
6.73653841043453E-14,
4.23081708555983E-14,
7.74753525223382E-14,
5.24441601257308E-14,
8.74604208500607E-14,
5.54669157826204E-14,
9.12239034311924E-14,
5.35873428963995E-14,
9.19108539276792E-14,
5.15429712799609E-14,
8.73199082485066E-14,
5.59058008220426E-14,
8.56589105202588E-14,
5.51633391743245E-14,
8.33152991042141E-14,
6.15124270963996E-14,
8.98942378868561E-14,
6.38464975333264E-14,
9.1327986839751E-14,
6.65327168358765E-14,
  0,
-1.20949257553793E-14,
  0,
-1.89863316041317E-14,
  0,
-2.0341367479304E-14,
0.823040973693117,
-1.97199027940353E-14,
0.466109855115491,
-1.95095675725732E-14,
0.400873679843421,
-1.42446818229836E-14,
0.398845181276695,
-1.51267887105178E-14,
0.460747831424128,
  0,
0.81889162268085,
1.12110841443691E-14,
  0,
2.02051916864399E-14,
  0,
2.51899195946592E-14,
  0,
3.16873263739303E-14,
1.34874750257197E-14,
4.7121161139696E-14,
2.96845881209151E-14,
6.53296861052866E-14,
3.87892842845794E-14,
7.32408925174788E-14,
4.2330722260786E-14,
7.88483861535738E-14,
5.13660294854112E-14,
8.81170136857179E-14,
5.49707848684911E-14,
9.35172078664337E-14,
5.92121837672543E-14,
1.00319925977477E-13,
5.6473055398687E-14,
9.77880970642886E-14,
6.14291603695527E-14,
9.68201213646935E-14,
6.54823417711725E-14,
9.62572035967391E-14,
6.69620608961807E-14,
9.81549910794577E-14,
6.84504536385688E-14,
1.01675612373953E-13,
6.65457272619463E-14,
1.06289976820051E-13,
  0,
  0,
-1.89440477194047E-14,
-1.28985364056255E-14,
-2.0717368792722E-14,
0.823040973693117,
-1.93846674823028E-14,
0.461330300895665,
-1.89397109107148E-14,
0.386889377682501,
-1.81152835787568E-14,
0.36695764022015,
-1.51181150931379E-14,
0.38155677961536,
-1.00817791615082E-14,
0.451958989794882,
  0,
0.816396484427775,
1.81356665795995E-14,
  0,
2.31308028286747E-14,
  0,
3.11521641815915E-14,
  0,
4.15431578026926E-14,
2.34413183308746E-14,
6.13372200253259E-14,
3.62479143922734E-14,
7.78309708349134E-14,
4.58660887048268E-14,
8.41176087118534E-14,
5.09739819798405E-14,
8.8782280138755E-14,
5.33470836949768E-14,
9.34270022456829E-14,
5.82294629181135E-14,
1.01821329145935E-13,
6.15939590997705E-14,
1.05409604655993E-13,
6.58657156593634E-14,
1.06489470019788E-13,
7.05442648740728E-14,
1.0665253402653E-13,
7.67606464502357E-14,
1.10301524858247E-13,
7.33206897973737E-14,
1.09116708724155E-13,
7.05954392166142E-14,
1.15769373254526E-13,
6.52282047819419E-14,
  0,
-1.41208659348857E-14,
-1.3199294088273E-14,
-2.13245220093139E-14,
0.825074431946707,
-1.97199027940353E-14,
0.461330300895665,
-1.82610003507389E-14,
0.381009331574224,
-1.71785329017293E-14,
0.351538093988781,
-1.870031907103E-14,
0.347987455075766,
-1.02231591248003E-14,
0.370705297905708,
  0,
0.446037545682645,
1.33434929772136E-14,
0.814625522289951,
2.10768902331182E-14,
  0,
2.89924334540004E-14,
  0,
4.06688571708003E-14,
1.97212038366423E-14,
5.54183435252931E-14,
2.99291841310279E-14,
7.34265079294083E-14,
4.31295624214734E-14,
8.82679346281279E-14,
5.42057718155853E-14,
9.35345551011935E-14,
5.27000318384374E-14,
9.35883315289487E-14,
5.63169302858491E-14,
1.01143052266828E-13,
6.03119984510236E-14,
1.06315997672191E-13,
7.06622260704393E-14,
1.13478670904499E-13,
7.45618844444351E-14,
1.15686973889417E-13,
8.1380215066762E-14,
1.20074956921901E-13,
8.26647778007228E-14,
1.20664762903733E-13,
7.50432702090187E-14,
1.22578162897735E-13,
6.88771956136591E-14,
1.25846381926475E-13,
-1.05035338066051E-14,
-1.24182348432145E-14,
-1.7017420458898E-14,
0.829971059101254,
-2.0267641731575E-14,
0.466109855115491,
-1.89921862958631E-14,
0.381009331574224,
-1.65869921964212E-14,
0.345021032718462,
-1.78472688017184E-14,
0.331644736769799,
-1.38309502739631E-14,
0.335995023288569,
  0,
0.363338805170475,
  0,
0.441817988598883,
1.61285915178944E-14,
0.813314567390802,
2.64961663720698E-14,
  0,
3.84362680572181E-14,
1.8472202933939E-14,
5.45414408081868E-14,
2.60347299274599E-14,
6.72899236331403E-14,
3.65671035118531E-14,
8.35408131560911E-14,
5.12801606733504E-14,
9.73561509187704E-14,
5.5720185410113E-14,
9.79580999649343E-14,
5.54356907600528E-14,
1.00843812467222E-13,
5.81652781495023E-14,
1.05163273922404E-13,
6.90645457490646E-14,
1.13912351773493E-13,
7.89906334786039E-14,
1.22190452200854E-13,
8.50673698149507E-14,
1.28602857529803E-13,
8.69287281046738E-14,
1.29887420263763E-13,
8.4069036454526E-14,
1.33551156245026E-13,
7.3000633316056E-14,
1.321052642278E-13,
6.8365452188246E-14,
  0,
-1.5782947865306E-14,
0.84044429432965,
-1.6382728507125E-14,
0.477560898658058,
-1.9523445360381E-14,
0.386889377682501,
-1.71802676252053E-14,
0.345021032718462,
-1.72448860746854E-14,
0.324712024464899,
-1.28334842752764E-14,
0.319014250344191,
  0,
0.327811823167887,
  0,
0.358060439026487,
1.07544181893182E-14,
0.438685055582809,
2.21307347447741E-14,
0.812312369658877,
3.56216792174457E-14,
1.77158634984131E-14,
5.205644942885E-14,
2.48169540473242E-14,
6.61293936277119E-14,
3.26214749657439E-14,
7.71526939558065E-14,
4.46300982281933E-14,
9.23558104992672E-14,
5.2579468556857E-14,
1.0141800593777E-13,
5.81730844051442E-14,
1.04932555700099E-13,
5.7071534997899E-14,
1.04553518620598E-13,
6.672093433302E-14,
1.12427428478057E-13,
7.71735106375182E-14,
1.22214738329518E-13,
8.92159610077492E-14,
1.34667450801818E-13,
9.02828159454749E-14,
1.38004191407859E-13,
8.79903788719716E-14,
1.42354010523871E-13,
8.17887424453545E-14,
1.42665393387809E-13,
7.22321508161983E-14,
1.3851246538632E-13,
  0,
0.866921446862997,
-1.53895993171282E-14,
0.501818924441715,
-1.6229205479501E-14,
0.400873679843421,
-1.8100104748342E-14,
0.351538093988781,
-1.7873289653858E-14,
0.324712024464899,
-1.23260776585532E-14,
0.311791331579635,
  0,
0.31036813019475,
  0,
0.321925516664871,
1.01203767588487E-14,
0.354124932661828,
1.62378790968809E-14,
0.436284394622795,
3.10446113260809E-14,
0.811526400882391,
4.93103821663787E-14,
2.37952019199739E-14,
6.34960833911791E-14,
3.13022177622635E-14,
7.58004770062826E-14,
4.05665084857176E-14,
8.56641146906867E-14,
4.57802198927659E-14,
9.6189549381176E-14,
5.4974254315443E-14,
1.08096691320281E-13,
5.96632118710083E-14,
1.08377716523389E-13,
6.54840764946485E-14,
1.11494147247981E-13,
7.46330081069502E-14,
1.20434044681428E-13,
8.7211488031258E-14,
1.34346526958762E-13,
9.42492611732959E-14,
1.43709696920347E-13,
9.1178800620817E-14,
1.50084805694561E-13,
8.55288062595605E-14,
1.51031964712445E-13,
8.08225014692354E-14,
1.48643250486025E-13,
7.37361560698702E-14,
0.999999999999991,
  0,
0.562211377199933,
-1.55097289178396E-14,
0.430075187969907,
-1.42321050777827E-14,
0.36695764022015,
-1.86951149006021E-14,
0.331644736769799,
-1.28334842752764E-14,
0.311791331579635,
  0,
0.302933083543112,
  0,
0.304133738653958,
  0,
0.317523637421859,
1.58683829964978E-14,
0.351099463896184,
2.50173146087995E-14,
0.434398197645027,
4.42866229799499E-14,
0.81089706662653,
6.06233813149615E-14,
3.03142927426947E-14,
7.29624693995845E-14,
3.91700560875563E-14,
8.42598560368835E-14,
4.17114259798623E-14,
8.93712187588491E-14,
4.80396972202257E-14,
1.02719048544753E-13,
5.62961136041373E-14,
1.11294654048244E-13,
6.79352407662037E-14,
1.15040789394616E-13,
7.32799237956883E-14,
1.19229279227362E-13,
8.44775638331186E-14,
1.3225184836152E-13,
9.20201415066657E-14,
1.43052236722951E-13,
9.4915394988071E-14,
1.5544510123533E-13,
8.84674278278652E-14,
1.58440968678342E-13,
8.44099096175555E-14,
1.56737470224932E-13,
8.21686468865934E-14,
1.49678880401183E-13,
  0,
0.866778142217527,
  0,
0.500887947076391,
-1.40078920685127E-14,
0.398845181276695,
-1.5184901946963E-14,
0.347987455075766,
-1.38309502739631E-14,
0.319014250344191,
  0,
0.302933083543112,
  0,
0.296538279133769,
  0,
0.299462744837997,
1.23625068515487E-14,
0.314131689778163,
2.5206399467681E-14,
0.348716208643079,
3.87120890898984E-14,
0.43288563773001,
5.52682899446211E-14,
0.81038436946331,
7.04167626985885E-14,
3.80494247220753E-14,
8.13186323833648E-14,
4.02759423034915E-14,
8.7734507159265E-14,
4.39483519021344E-14,
9.5816583833841E-14,
4.92860960377151E-14,
1.05689762497363E-13,
6.44146194717088E-14,
1.17844969893532E-13,
7.55975143595933E-14,
1.2264494975156E-13,
8.30047836020142E-14,
1.30877947368546E-13,
8.91266227487364E-14,
1.40719033647763E-13,
9.25561710607425E-14,
1.54586413114721E-13,
9.20843262752769E-14,
1.63598301572421E-13,
8.72600602885854E-14,
1.63910551798097E-13,
8.56086035394554E-14,
1.57433094338799E-13,
7.06414093887275E-14,
  0,
  0,
0.839875767210725,
  0,
0.474901434241775,
-1.51241866253038E-14,
0.38155677961536,
-1.02248938482763E-14,
0.335995023288569,
  0,
0.31036813019475,
  0,
0.296538279133769,
  0,
0.291742717215662,
1.32255317808472E-14,
0.29585802419157,
2.16467468949766E-14,
0.311454713779304,
3.83252457547556E-14,
0.346801057784456,
5.00337618558611E-14,
0.431651895079695,
6.47338085912885E-14,
0.809960542669755,
7.82516412778378E-14,
3.91102081276351E-14,
8.48236411665759E-14,
4.2411386902419E-14,
9.40541047822485E-14,
4.51565868031523E-14,
9.86155601623295E-14,
5.73898567557407E-14,
1.12078749059386E-13,
7.20153103817012E-14,
1.25188054367342E-13,
8.52044129695528E-14,
1.34059430223488E-13,
8.75410854916936E-14,
1.39157782519383E-13,
8.94909146786915E-14,
1.52038104328511E-13,
8.96331620037216E-14,
1.62482874377368E-13,
9.07746100509144E-14,
1.68724409443932E-13,
8.83234457793591E-14,
1.64332089602759E-13,
7.39634048452231E-14,
1.56987270405473E-13,
  0,
  0,
  0,
0.828657323515795,
  0,
0.460747831424128,
-1.00267016911459E-14,
0.370705297905708,
  0,
0.327811823167887,
  0,
0.304133738653958,
  0,
0.291742717215662,
1.40096267919887E-14,
0.288039162343556,
2.24525259495678E-14,
0.293009675735401,
3.50258017034477E-14,
0.309300230146703,
4.94075266810334E-14,
0.345236255728317,
5.8935495372836E-14,
0.430630968858888,
7.33788030338189E-14,
0.809605758724921,
8.16933326541758E-14,
4.12656020465363E-14,
9.10096650819092E-14,
4.36144176330089E-14,
9.6710833785707E-14,
5.31137633874579E-14,
1.04825870206326E-13,
6.48422288085371E-14,
1.19270912590785E-13,
8.152332975353E-14,
1.36465491684667E-13,
8.97164287305685E-14,
1.42190079155391E-13,
8.78151718008979E-14,
1.50268686383015E-13,
8.64863736182997E-14,
1.59728133497516E-13,
8.81517081552374E-14,
1.67393876537858E-13,
9.1700952387086E-14,
1.69019312434848E-13,
7.65533469948565E-14,
1.63672894681888E-13,
6.88182150154759E-14,
  0,
  0,
-1.06156403112401E-14,
  0,
0.822615085441342,
  0,
0.451958989794882,
  0,
0.363338805170475,
  0,
0.321925516664871,
  0,
0.299462744837997,
1.3166551182664E-14,
0.288039162343556,
2.30770264009195E-14,
0.285110984907833,
3.56234139409217E-14,
0.290714990400163,
4.61991556122143E-14,
0.307537644741315,
5.88088605590897E-14,
0.34393952957692,
6.73280875496118E-14,
0.429775623452425,
7.6139615445836E-14,
0.809305516266406,
8.78394579295616E-14,
4.24608265214843E-14,
9.35536370594292E-14,
5.15212872365112E-14,
1.02863897954997E-13,
6.05661354402542E-14,
1.11922623946548E-13,
7.43242273282263E-14,
1.3047549152212E-13,
8.58410564852363E-14,
1.44452158568065E-13,
8.9902044142498E-14,
1.53153531523564E-13,
8.46753223093799E-14,
1.57731466776667E-13,
8.49147141490647E-14,
1.64514235567736E-13,
8.89878448706583E-14,
1.67456326582993E-13,
7.9807688235789E-14,
1.68158889590764E-13,
7.13006043095987E-14,
1.59663948728905E-13,
  0,
  0,
  0,
-1.24401357270987E-14,
  0,
0.81889162268085,
  0,
0.446037545682645,
  0,
0.358060439026486,
1.01342545466565E-14,
0.317523637421859,
1.24041402149722E-14,
0.29585802419157,
2.24525259495678E-14,
0.285110984907833,
3.63138338843605E-14,
0.28275083898052,
4.66779392915839E-14,
0.288836157532161,
5.53411483306121E-14,
0.306075469625288,
6.68562427641461E-14,
0.342851811991283,
7.0305740396126E-14,
0.429051245736874,
8.23612011924268E-14,
0.80904898875008,
9.03773583749157E-14,
5.02341224173364E-14,
9.9552310839357E-14,
5.89823329066874E-14,
1.09891262756179E-13,
6.99423158279089E-14,
1.22984955552852E-13,
7.85916470791292E-14,
1.38326849974391E-13,
8.60006510450262E-14,
1.5527683305816E-13,
8.66702543067532E-14,
1.60496615997374E-13,
8.30325391776299E-14,
1.62429097949612E-13,
8.57092175010621E-14,
1.64462193863457E-13,
7.7035600121178E-14,
1.66481411989494E-13,
7.45115774636318E-14,
1.64002492142323E-13,
6.4250688103229E-14,
  0,
  0,
-1.13450915328883E-14,
  0,
  0,
1.12093494208931E-14,
0.816396484427775,
1.33486971476415E-14,
0.441817988598883,
1.08107967022875E-14,
0.354124932661828,
1.58623114643319E-14,
0.314131689778163,
2.16389406393347E-14,
0.293009675735401,
3.56503021547994E-14,
0.28275083898052,
4.74472891531796E-14,
0.280817625247612,
5.59656487819638E-14,
0.287276468896016,
6.32237318054507E-14,
0.304847871402936,
7.01183902607205E-14,
0.341929703415488,
7.64856927792934E-14,
0.428431951518394,
8.43648068071801E-14,
0.808827947175337,
9.64610336051663E-14,
5.75824110615741E-14,
1.06522429765832E-13,
6.82266743101678E-14,
1.20875531806064E-13,
7.41056521702532E-14,
1.30780802853891E-13,
7.86454235068845E-14,
1.49037032715071E-13,
8.26960028232904E-14,
1.6257654944507E-13,
8.49806336411518E-14,
1.65024244269674E-13,
8.37090813332608E-14,
1.62288585348058E-13,
7.36390115552155E-14,
1.6333115415712E-13,
7.16596920691259E-14,
1.62182767216024E-13,
6.74252320642665E-14,
1.64885466391596E-13,
  0,
  0,
  0,
  0,
1.32754050807815E-14,
  0,
1.8026379000613E-14,
0.81462552228995,
1.60748150901391E-14,
0.438685055582809,
1.63185437385138E-14,
0.351099463896184,
2.51396126138559E-14,
0.311454713779304,
3.50830475781549E-14,
0.290714990400163,
4.66224281403527E-14,
0.280817625247612,
5.6767958389603E-14,
0.279212245766554,
6.39306316219113E-14,
0.285966232864133,
6.64052146603922E-14,
0.303806384311046,
7.59045604148412E-14,
0.341140674112146,
7.90062459898877E-14,
0.427898038902169,
9.12846187528515E-14,
0.808636037732733,
1.0308247311297E-13,
6.69499178318489E-14,
1.17413023748014E-13,
7.24888898906428E-14,
1.28636684637584E-13,
7.40709577007337E-14,
1.41515271723236E-13,
7.52956724747733E-14,
1.56204910117808E-13,
8.1006382157689E-14,
1.6695325677496E-13,
8.56016646455515E-14,
1.64784852429989E-13,
7.1652753175222E-14,
1.61029176104499E-13,
6.82041229049801E-14,
1.58911078740331E-13,
6.44918146663898E-14,
1.62977270568021E-13,
6.83827994230057E-14,
  0,
  0,
  0,
1.49333670429463E-14,
  0,
2.02476924116013E-14,
  0,
2.10760228713802E-14,
0.813314567390801,
2.21307347447741E-14,
0.436284394622795,
2.5058947972223E-14,
0.348716208643079,
3.82697346035243E-14,
0.309300230146703,
4.61852778244065E-14,
0.288836157532161,
5.58953924811867E-14,
0.279212245766554,
6.46193168418741E-14,
0.277863235966416,
6.72586986105728E-14,
0.284854078553969,
7.22963355848094E-14,
0.302914619735473,
7.83522552394444E-14,
0.34045991447274,
8.49216530429686E-14,
0.427434276790014,
9.7529623266368E-14,
0.808468285672418,
1.14025108799432E-13,
7.10941722159575E-14,
1.25172441856058E-13,
7.24177662281278E-14,
1.39152578348956E-13,
7.07767178198537E-14,
1.4854610597137E-13,
7.35279892527529E-14,
1.60491411826946E-13,
8.15753714578094E-14,
1.66582025951101E-13,
7.34776822719496E-14,
1.63395338925731E-13,
6.61727617146113E-14,
1.56494608938296E-13,
6.10154288205322E-14,
1.59568538937727E-13,
6.54181570025614E-14,
1.71692521311329E-13,
  0,
  0,
1.47512210779688E-14,
  0,
2.2063947890949E-14,
  0,
2.31446806164826E-14,
  0,
2.65317282033273E-14,
0.812312369658877,
3.10498154965089E-14,
0.434398197645027,
3.86305570865275E-14,
0.346801057784456,
4.94352822566491E-14,
0.307537644741315,
5.53090559463065E-14,
0.287276468896016,
6.39297642601733E-14,
0.277863235966416,
6.80393241747623E-14,
0.276717885643536,
7.29711430169644E-14,
0.2839013939158,
7.47873984963121E-14,
0.302144784116402,
8.44151137879834E-14,
0.33986821141284,
9.18067705191206E-14,
0.427028727013766,
1.08411543631171E-13,
0.80832074725954,
1.21845242229135E-13,
7.11878472836602E-14,
1.35724764760425E-13,
6.91599555402433E-14,
1.46200759831849E-13,
6.89795442987418E-14,
1.52865567426552E-13,
7.41334077458689E-14,
1.60095894874424E-13,
6.9484348830251E-14,
1.65204655511175E-13,
6.7992486640911E-14,
1.58867710653432E-13,
5.89996801414472E-14,
1.57119109389647E-13,
6.19591183914636E-14,
1.68164093761192E-13,
6.82995326961588E-14,
  0,
1.81473759630624E-14,
  0,
2.21194590421803E-14,
  0,
2.51933890416112E-14,
  0,
2.89959029009523E-14,
  0,
3.56555063252273E-14,
0.811526400882391,
4.43993800058884E-14,
0.43288563773001,
4.99782507046298E-14,
0.345236255728317,
5.88418203051333E-14,
0.306075469625288,
6.32827124036339E-14,
0.285966232864133,
6.731594448528E-14,
0.276717885643536,
7.37847283271975E-14,
0.275736554823143,
7.54535323110872E-14,
0.283078658936645,
8.08728084500387E-14,
0.301475325800544,
9.1324517392799E-14,
0.33935048275612,
1.02551647729321E-13,
0.426671916574875,
1.15856976790063E-13,
0.808190260981137,
1.32369809557886E-13,
6.77843198237937E-14,
1.42661923940857E-13,
6.72153305236733E-14,
1.50452567071468E-13,
6.95242474701985E-14,
1.52305251743812E-13,
6.19487100506078E-14,
1.58628318813747E-13,
6.39766017940246E-14,
1.60482738209566E-13,
6.07465466817558E-14,
1.59336085991946E-13,
5.98514293681518E-14,
1.65634866933217E-13,
6.4699981483507E-14,
1.76058820300362E-13,
1.57805626205265E-14,
  0,
2.64671097538471E-14,
  0,
2.55399000559375E-14,
  0,
3.10905814981943E-14,
  0,
3.84137166520304E-14,
1.76603523471819E-14,
4.93381377419944E-14,
0.81089706662653,
5.52682899446211E-14,
0.431651895079695,
5.89667203954036E-14,
0.34393952957692,
6.68284871885305E-14,
0.304847871402936,
6.64052146603922E-14,
0.284854078553969,
7.29711430169644E-14,
0.275736554823143,
7.62254842578969E-14,
0.274888923391179,
8.1450471367539E-14,
0.282362964029733,
8.75619021734053E-14,
0.30088930767439,
1.02281030867069E-13,
0.338894744674253,
1.10059530933349E-13,
0.426356245001658,
1.27205537769903E-13,
0.808074266684019,
1.39296560397462E-13,
6.56558141187702E-14,
1.46721176874642E-13,
6.77600336951301E-14,
1.49906129176536E-13,
5.73222025401776E-14,
1.50811654830996E-13,
5.64999436125646E-14,
1.5393589181123E-13,
5.67011715357779E-14,
1.60999685805407E-13,
6.16191125901722E-14,
1.67817149065996E-13,
6.25940271836711E-14,
1.73425510063829E-13,
5.57765639230823E-14,
  0,
2.74147024525995E-14,
1.07505150614973E-14,
3.04357233860131E-14,
  0,
3.17029388852141E-14,
  0,
4.06974801081539E-14,
1.85060300417206E-14,
5.2058184152326E-14,
2.37969366434498E-14,
6.06285854853894E-14,
0.81038436946331,
6.4845698255489E-14,
0.430630968858888,
6.72829847392364E-14,
0.342851811991283,
7.01331354102663E-14,
0.303806384311046,
7.22980703082854E-14,
0.2839013939158,
7.54760837162749E-14,
0.274888923391179,
8.23351803402872E-14,
0.274151451113763,
8.8182933177805E-14,
0.281736291574694,
9.83258613418414E-14,
0.300373258552832,
1.09533909720128E-13,
0.338491370769743,
1.20341236975463E-13,
0.426075552916205,
1.33596259055402E-13,
0.807970672089349,
1.43276016051352E-13,
6.6266436782314E-14,
1.46211168172705E-13,
5.55683971059651E-14,
1.48310183578637E-13,
5.18179249509032E-14,
1.46046369442487E-13,
4.92193091838899E-14,
1.54293244847281E-13,
5.75078179521071E-14,
1.69418298834323E-13,
6.43790576404513E-14,
1.75533199087141E-13,
5.36480582180587E-14,
1.75968614679611E-13,
1.59173889346942E-14,
1.1744077932363E-14,
3.27017059265078E-14,
1.37689339096969E-14,
3.7025937871249E-14,
1.35152306013353E-14,
4.1513667503601E-14,
1.9748959412258E-14,
5.4527563020379E-14,
2.48169540473242E-14,
6.35481250954584E-14,
3.02605163149394E-14,
7.04063543577327E-14,
0.809960542669755,
7.33545169051553E-14,
0.429775623452425,
7.03334959717417E-14,
0.341929703415488,
7.59513979486925E-14,
0.302914619735473,
7.48498485414473E-14,
0.283078658936645,
8.15059825187703E-14,
0.274151451113763,
8.89566198480907E-14,
0.27350561763439,
9.91238341407907E-14,
0.281184301587374,
1.05793845905922E-13,
0.299916347643294,
1.19897147765613E-13,
0.338132551629662,
1.27346050371457E-13,
0.425824803212997,
1.37518468834585E-13,
0.807877752913633,
1.42684475346044E-13,
5.39568389967826E-14,
1.44627365639138E-13,
5.0036363941075E-14,
1.43480713421518E-13,
4.45147391170408E-14,
1.46408926648967E-13,
4.99513624907522E-14,
1.62687571747533E-13,
6.02521504911024E-14,
1.77075368257285E-13,
5.5422680333983E-14,
1.78013853657788E-13,
3.86166792987197E-14,
  0,
2.47271821074424E-14,
1.52729391633688E-14,
3.99936160577763E-14,
1.95173738282151E-14,
4.71072833518882E-14,
2.34569308421584E-14,
5.54304865896249E-14,
2.60399340978879E-14,
6.61398019685677E-14,
3.13577289134948E-14,
7.29659388465365E-14,
3.80043219116999E-14,
7.83349080046847E-14,
0.809605758724921,
7.61292071049802E-14,
0.429051245736874,
7.64787538853895E-14,
0.341140674112146,
7.84077663906757E-14,
0.302144784116402,
8.08433181509471E-14,
0.282362964029733,
8.8181198454329E-14,
0.273505617634391,
9.96563942479156E-14,
0.272936678075073,
1.06636921515246E-13,
0.280695458030115,
1.16351372980716E-13,
0.299509781494177,
1.26884613926848E-13,
0.337811894734057,
1.31235300404597E-13,
0.425599842233575,
1.37089992136019E-13,
0.807794077197339,
1.41286288224407E-13,
4.84178669379887E-14,
1.397198329256E-13,
4.26672586151255E-14,
1.43843270627997E-13,
4.52641396586628E-14,
1.54747742397987E-13,
5.26766130715117E-14,
1.70304742530547E-13,
5.12541398212107E-14,
1.79503981123652E-13,
4.03305860929848E-14,
1.70271782784504E-13,
1.26264016603317E-14,
  0,
3.33678397412829E-14,
2.14372790352524E-14,
5.06773442654485E-14,
2.96880575678671E-14,
6.13658429626796E-14,
2.99239799605999E-14,
6.73072708679001E-14,
3.26370874770276E-14,
7.57727214306669E-14,
3.91700560875563E-14,
8.12917441694871E-14,
3.91067386806832E-14,
8.16829243133199E-14,
0.809305516266406,
8.23612011924268E-14,
0.428431951518394,
7.89385917743246E-14,
0.34045991447274,
8.4441134640123E-14,
0.301475325800544,
8.75636368968813E-14,
0.281736291574694,
9.91203646938388E-14,
0.272936678075073,
1.07348158140397E-13,
0.27243276725093,
1.16916892833885E-13,
0.280260389978205,
1.23151489006545E-13,
0.29914635696815,
1.31152033677751E-13,
0.337524124271873,
1.30654168040145E-13,
0.425397218639875,
1.35131489331641E-13,
0.807718447316692,
1.36113342819044E-13,
4.1215295065733E-14,
1.40139636006786E-13,
4.35103342244503E-14,
1.5214218773707E-13,
4.80327583263218E-14,
1.62316340923674E-13,
4.36577857199083E-14,
1.72698660927395E-13,
3.61967400497321E-14,
1.71663031012237E-13,
3.44498735094234E-14,
  0,
2.43386040488236E-14,
1.67196985423335E-14,
4.48226525340267E-14,
3.19241161284012E-14,
6.53348902757145E-14,
3.62826088617929E-14,
7.34134975033385E-14,
3.65428173831894E-14,
7.71526939558065E-14,
4.05456918040059E-14,
8.42355699082198E-14,
4.02690034095876E-14,
8.4816702272672E-14,
4.12933576221519E-14,
8.77839467783303E-14,
0.80904898875008,
8.43613373602281E-14,
0.427898038902169,
8.49841030881038E-14,
0.33986821141284,
9.12707409650437E-14,
0.30088930767439,
9.83258613418414E-14,
0.281184301587374,
1.06581410364015E-13,
0.27243276725093,
1.17700987845026E-13,
0.271984244375667,
1.23574761534684E-13,
0.279871417663068,
1.27309621178462E-13,
0.29882012544398,
1.29968952267134E-13,
0.33726485315017,
1.29469351906053E-13,
0.425214044485164,
1.30076505122645E-13,
0.807649855078893,
1.3655049313499E-13,
4.21156165497649E-14,
1.48365694729868E-13,
4.61991556122143E-14,
1.59683030687141E-13,
3.90035226338625E-14,
1.64640870381483E-13,
2.86333456944732E-14,
1.64776178812609E-13,
3.03090885722668E-14,
1.7682730280022E-13,
1.54325337231587E-14,
1.46796637345847E-14,
3.72622939448508E-14,
2.76324102488346E-14,
6.02035782337751E-14,
3.87849474758895E-14,
7.78327055583894E-14,
4.31460422944951E-14,
8.35130575804754E-14,
4.46023426525777E-14,
8.56988091602062E-14,
4.16975481920545E-14,
8.77631300966186E-14,
4.2412254264157E-14,
9.1024410231455E-14,
4.24625612449603E-14,
9.03669500340598E-14,
0.808827947175337,
9.1402579949218E-14,
0.427434276790014,
9.18692205642557E-14,
0.33935048275612,
1.02253275291453E-13,
0.300373258552832,
1.05812927864157E-13,
0.280695458030115,
1.16916892833885E-13,
0.271984244375667,
1.24539267787327E-13,
0.271583206687521,
1.27956673035001E-13,
0.279522196168466,
1.26610527617643E-13,
0.298526137501832,
1.28518723441218E-13,
0.337030407889997,
1.23888746483836E-13,
0.425047887539982,
1.30704475020949E-13,
0.807587446612258,
1.44856349137967E-13,
4.47020892524463E-14,
1.55913476573843E-13,
3.71976754953707E-14,
1.61993682357142E-13,
2.39756131614755E-14,
1.5664379515723E-13,
2.27162039179163E-14,
1.69865857491125E-13,
2.18054740930285E-14,
1.05622975643538E-14,
3.20013113230821E-14,
2.64627729451572E-14,
5.35639241294739E-14,
3.49381981679109E-14,
7.32703828165704E-14,
4.58626192578748E-14,
8.82523221168441E-14,
5.12870995672543E-14,
9.23575452227432E-14,
4.58131796388095E-14,
8.94007090579407E-14,
4.39422803699685E-14,
9.39933894605893E-14,
4.36144176330089E-14,
9.35276162072896E-14,
5.02965724624715E-14,
9.64072571774111E-14,
0.808636037732733,
9.753309271332E-14,
0.427028727013766,
1.02536035218037E-13,
0.338894744674253,
1.09499215250608E-13,
0.299916347643294,
1.164103535789E-13,
0.280260389978205,
1.23632007409391E-13,
0.271583206687521,
1.28593316550685E-13,
0.271223123671013,
1.27302682284558E-13,
0.279207444334081,
1.25049276489264E-13,
0.298260246641526,
1.2370139634843E-13,
0.336817692754207,
1.24534063616899E-13,
0.424896687039977,
1.39268804821846E-13,
0.807530494668966,
1.52492601879217E-13,
3.57457119459781E-14,
1.58036778108439E-13,
2.21021118074205E-14,
1.53994872409413E-13,
1.80532672144906E-14,
1.61700514089702E-13,
1.41570782874467E-14,
1.68962066560141E-13,
2.14973438356081E-14,
2.48633579003066E-14,
5.00840688366644E-14,
3.44464040624715E-14,
6.73515063165375E-14,
4.23289875373101E-14,
8.41366906700891E-14,
5.42057718155853E-14,
9.73474773013905E-14,
5.2579468556857E-14,
9.62207744037435E-14,
4.80527076462955E-14,
9.5813981748627E-14,
4.51114839927769E-14,
9.67489977021785E-14,
5.15247566834631E-14,
9.96008830966844E-14,
5.76101666371898E-14,
1.03160535669389E-13,
0.808468285672418,
1.08356032479939E-13,
0.426671916574875,
1.10061265656825E-13,
0.338491370769743,
1.19841636614382E-13,
0.299509781494177,
1.23151489006545E-13,
0.279871417663068,
1.2792718273591E-13,
0.271223123671013,
1.28050348102704E-13,
0.270898558655205,
1.25465610123499E-13,
0.278922736207418,
1.19793064357054E-13,
0.298018956841798,
1.23980686828062E-13,
0.336624083315779,
1.32779204298217E-13,
0.42475868717511,
1.46620562913036E-13,
0.807478376594263,
1.54565596433009E-13,
2.0492288421714E-14,
1.50129908504937E-13,
1.61693575195798E-14,
1.58956181550707E-13,
  0,
1.60763763412675E-13,
  0,
1.81300287283026E-14,
4.4574587076962E-14,
3.4110301389001E-14,
6.51180498412174E-14,
4.22968951530045E-14,
7.88214979396962E-14,
5.09601041920327E-14,
9.35493002507393E-14,
5.57375326448728E-14,
1.01407597596914E-13,
5.49673154215391E-14,
1.02721650629967E-13,
4.9290432846405E-14,
9.85982129275698E-14,
5.31449884100255E-14,
1.02891653530612E-13,
5.89684551188796E-14,
1.06539777000592E-13,
6.70019595361282E-14,
1.14035517140287E-13,
0.80832074725954,
1.15858711513539E-13,
0.426356245001658,
1.20336032805035E-13,
0.338132551629662,
1.26940125078079E-13,
0.29914635696815,
1.27340846201029E-13,
0.279522196168466,
1.27281865602846E-13,
0.270898558655205,
1.2612480504437E-13,
0.270604954578012,
1.20514709323061E-13,
0.278664338981741,
1.20218071608669E-13,
0.297799303052883,
1.32078376013922E-13,
0.336447342354824,
1.40578521046208E-13,
0.424632384152016,
1.48438553115859E-13,
0.807430556667666,
1.46677808787743E-13,
1.46740258832878E-14,
1.55238669141688E-13,
  0,
1.58040247555391E-13,
  0,
1.55942966872935E-13,
2.99816595161762E-14,
3.1337779593521E-14,
6.19899097331622E-14,
4.28415983244612E-14,
7.75117817153337E-14,
5.13382739097956E-14,
8.8782280138755E-14,
5.27433999253368E-14,
9.79633041353623E-14,
5.81765538520962E-14,
1.08114038555041E-13,
5.6323869179753E-14,
1.05696701391267E-13,
5.73759789679329E-14,
1.04805053524615E-13,
6.05938910158699E-14,
1.09922487778746E-13,
6.8211061798884E-14,
1.17503229368765E-13,
7.11149888976692E-14,
1.21912896444698E-13,
0.808190260981137,
1.27233293345519E-13,
0.426075552916205,
1.27358193435789E-13,
0.337811894734057,
1.31158972571654E-13,
0.29882012544398,
1.2658624148898E-13,
0.279207444334081,
1.25479487911306E-13,
0.270604954578012,
1.21264109864683E-13,
0.270338467456212,
1.2070899835237E-13,
0.278429085877925,
1.28222085726826E-13,
0.297598756690635,
1.39565442536238E-13,
0.336285552858202,
1.42238651412718E-13,
0.424516483736852,
1.40580255769684E-13,
0.807386571846737,
1.51264417658226E-13,
  0,
1.54130180840539E-13,
  0,
1.53143123182709E-13,
  0,
1.80296316071304E-14,
5.40539835114373E-14,
4.1661118999059E-14,
7.57961401975926E-14,
5.2433751784875E-14,
8.81040032596481E-14,
5.33488184184527E-14,
9.35996072315426E-14,
5.54079351844372E-14,
1.04918677912291E-13,
5.96770896588161E-14,
1.11294654048244E-13,
6.44085479395429E-14,
1.12078749059386E-13,
6.48561065963449E-14,
1.11950379522163E-13,
6.9935376934005E-14,
1.2086859291216E-13,
7.25149107427825E-14,
1.25165502962155E-13,
7.12173375827518E-14,
1.32395830410026E-13,
0.808074266684019,
1.33587585438022E-13,
0.425824803212997,
1.31233565681121E-13,
0.337524124271873,
1.2999670784275E-13,
0.298526137501832,
1.2507703206488E-13,
0.278922736207418,
1.20459198171829E-13,
0.270338467456212,
1.21531257279983E-13,
0.270095835728165,
1.28869137583365E-13,
0.278214275570743,
1.35782010635133E-13,
0.297415150297249,
1.41836195566292E-13,
0.33613706423903,
1.34390762407399E-13,
0.424409866960427,
1.45950959651309E-13,
0.80734602018044,
1.50457771241896E-13,
  0,
1.49243464808713E-13,
  0,
1.48582535164365E-13,
3.24323901068624E-14,
3.25291009406481E-14,
7.07337834138233E-14,
5.22576773520633E-14,
8.7436134721397E-14,
5.49577744424212E-14,
9.34270022456829E-14,
5.63464205849407E-14,
1.00862894425457E-13,
5.70611266570431E-14,
1.08356899841677E-13,
6.79595268948674E-14,
1.17839765723105E-13,
7.2029188169509E-14,
1.19300402889877E-13,
7.43034106465146E-14,
1.22978016658948E-13,
7.41073868937292E-14,
1.28636684637584E-13,
7.24628690385032E-14,
1.35761193953421E-13,
6.77721767594619E-14,
1.39296560397462E-13,
0.807970672089349,
1.37549693857153E-13,
0.425599842233575,
1.3071661808528E-13,
0.33726485315017,
1.2848749841865E-13,
0.298260246641526,
1.19793064357054E-13,
0.278664338981741,
1.20722876140178E-13,
0.270095835728164,
1.29707009022262E-13,
0.269874276854897,
1.36380490234345E-13,
0.27801759197621,
1.38195010990216E-13,
0.297246617029203,
1.33624014631017E-13,
0.336000448862126,
1.39326050696553E-13,
0.424311562231423,
1.44556241976623E-13,
0.807308551332976,
1.45612688573493E-13,
  0,
1.44601344786999E-13,
-2.12191375581483E-14,
1.95377568290578E-14,
5.64240494604906E-14,
4.49124244739085E-14,
8.40499544962903E-14,
5.54634463356685E-14,
9.35414939950974E-14,
5.82251261094235E-14,
1.0112917447902E-13,
5.81323184034588E-14,
1.0455265125886E-13,
6.54840764946485E-14,
1.15040789394616E-13,
7.5614861594353E-14,
1.25188054367342E-13,
8.15510853291457E-14,
1.30447735946504E-13,
7.86332804425527E-14,
1.30810293152983E-13,
7.40935091059214E-14,
1.39156047795908E-13,
6.91599555402433E-14,
1.42648046153049E-13,
6.56558141187702E-14,
1.43218770176645E-13,
0.807877752913633,
1.37086522689067E-13,
0.425397218639875,
1.29413840754822E-13,
0.337030407889997,
1.23645885197199E-13,
0.298018956841798,
1.20218071608669E-13,
0.278429085877925,
1.28896893158981E-13,
0.269874276854897,
1.37077849071687E-13,
0.269671404835782,
1.38687672457394E-13,
0.277837039798534,
1.29864868858576E-13,
0.297091541712781,
1.38692876627822E-13,
0.335874466667863,
1.382106235015E-13,
0.424220722518534,
1.39614014793565E-13,
0.807273858787743,
1.41006997744775E-13,
-2.26936525127286E-14,
1.40019940086944E-13,
3.2721872086916E-14,
3.64105447181462E-14,
7.2775986625917E-14,
4.91898188847983E-14,
9.12742104119957E-14,
5.92260615550622E-14,
1.01821329145935E-13,
6.03119984510236E-14,
1.05162406560666E-13,
6.67105259921641E-14,
1.11496749333195E-13,
7.32790564339503E-14,
1.22620663622897E-13,
8.52078824165048E-14,
1.36475900025523E-13,
8.58306481443805E-14,
1.38332054144819E-13,
7.86037901434611E-14,
1.41510067552808E-13,
7.08044733954694E-14,
1.46200759831849E-13,
6.72639027810007E-14,
1.46693421299027E-13,
6.62386812066984E-14,
1.42684475346044E-13,
0.807794077197339,
1.3507597818041E-13,
0.425214044485164,
1.2387833814298E-13,
0.336817692754207,
1.23921706229879E-13,
0.297799303052883,
1.28222085726826E-13,
0.278214275570743,
1.36350999935253E-13,
0.269671404835782,
1.39348602101741E-13,
0.269485163916497,
1.30338448367517E-13,
0.277670892378038,
1.35056896222174E-13,
0.296948520995639,
1.37664185606567E-13,
0.335758036207359,
1.33379418620905E-13,
0.424136606570248,
1.35081182350838E-13,
0.807241673397917,
1.36255590144074E-13,
-2.45879705484953E-14,
2.25021824090677E-14,
5.65073161873375E-14,
4.25662109726499E-14,
8.17236903150054E-14,
5.35916797050895E-14,
1.00309517636621E-13,
6.15870202058666E-14,
1.06289976820051E-13,
6.90662804725406E-14,
1.12430897925009E-13,
7.46364775539021E-14,
1.19232748674314E-13,
8.29752933029226E-14,
1.34049021882632E-13,
8.97164287305685E-14,
1.44438280780257E-13,
8.60041204919781E-14,
1.49043971608975E-13,
7.5316489156485E-14,
1.48566922653082E-13,
6.89674012344099E-14,
1.50447362901041E-13,
6.77478906307982E-14,
1.46235454301369E-13,
5.39620431672105E-14,
1.41341799375638E-13,
0.807718447316692,
1.30076505122645E-13,
0.425047887539982,
1.24530594169947E-13,
0.336624083315779,
1.32029803756595E-13,
0.297598756690635,
1.35736907824757E-13,
0.278017591976211,
1.38632161306163E-13,
0.269485163916497,
1.30968152989297E-13,
0.269313774938753,
1.3534312559571E-13,
0.277517649216227,
1.33780139743855E-13,
0.296816330704072,
1.32612670844523E-13,
0.33565021078867,
1.28745972216571E-13,
0.424058563372412,
1.30470287351692E-13,
0.807211758023082,
1.31429589433907E-13,
3.25479660584493E-14,
3.35525877914744E-14,
6.84586935750797E-14,
4.80136763680861E-14,
9.19091192042032E-14,
5.64591776108792E-14,
1.05409604655993E-13,
7.06761038582471E-14,
1.13899341347423E-13,
7.71804495314221E-14,
1.20427105787524E-13,
8.44324610227432E-14,
1.30877947368546E-13,
8.75341465977897E-14,
1.42190079155391E-13,
8.98638802260265E-14,
1.55328874762439E-13,
8.272202367543E-14,
1.56218787905615E-13,
7.35557448283686E-14,
1.52867302150028E-13,
6.95277169171504E-14,
1.49920006964344E-13,
5.55770707233449E-14,
1.44603079510475E-13,
4.8469908642268E-14,
1.36137628947708E-13,
0.807649855078893,
1.30815497323411E-13,
0.424896687039977,
1.32834715449448E-13,
0.336447342354824,
1.39506461938055E-13,
0.297415150297249,
1.38195010990216E-13,
0.277837039798534,
1.30409572030032E-13,
0.269313774938753,
1.36193140098939E-13,
0.269155691637467,
1.34279740104937E-13,
0.277376001170088,
1.28853525072081E-13,
0.296693898947963,
1.27902896607246E-13,
0.335550158724394,
1.23998034062822E-13,
0.423986019218251,
1.24806415202627E-13,
0.807183903046824,
1.62361443734049E-14,
5.17515717779471E-14,
4.07911551758566E-14,
8.03437177898658E-14,
5.15533796208167E-14,
9.7829730427712E-14,
6.58761240002192E-14,
1.13488211883617E-13,
7.89941029255559E-14,
1.2220086054171E-13,
8.71733241147865E-14,
1.32237970573712E-13,
8.91457047069721E-14,
1.39178599201095E-13,
8.78290495887057E-14,
1.53153531523564E-13,
8.66494376250415E-14,
1.62600835573734E-13,
8.10133210515929E-14,
1.60484472933042E-13,
7.4119529958061E-14,
1.52315660084668E-13,
5.73239372636536E-14,
1.48317122472541E-13,
5.00242208767432E-14,
1.39716363478648E-13,
4.11979478309732E-14,
1.36543554241086E-13,
0.807587446612258,
1.3929309095051E-13,
0.42475868717511,
1.40495254319362E-13,
0.336285552858202,
1.41888237270571E-13,
0.297246617029203,
1.29850991070768E-13,
0.277670892378038,
1.35393432576514E-13,
0.269155691637467,
1.34971894771851E-13,
0.26900956482306,
1.29420779648726E-13,
0.277244801766206,
1.24169771686944E-13,
0.29658028384056,
1.23241694627296E-13,
0.335457146890823,
1.18984683217249E-13,
0.423918466898636,
1.34090655246055E-13,
2.72340743706634E-14,
2.7299777022316E-14,
6.64459806620776E-14,
4.5327457065536E-14,
8.73181735250306E-14,
6.14439055190985E-14,
1.06491204743264E-13,
7.45549455505312E-14,
1.22176574413047E-13,
8.92350429659849E-14,
1.34336118617906E-13,
9.20201415066657E-14,
1.40713829477335E-13,
8.94909146786915E-14,
1.50268686383015E-13,
8.46475667337643E-14,
1.60517432679086E-13,
8.49841030881038E-14,
1.66942848434104E-13,
8.15476158821937E-14,
1.60083751810092E-13,
6.19469753271318E-14,
1.50832471512707E-13,
5.18161902274272E-14,
1.43482448144994E-13,
4.26915447437892E-14,
1.40167391582402E-13,
4.20635748454856E-14,
1.44821654668448E-13,
0.807530494668966,
1.46676074064267E-13,
0.424632384152016,
1.42183140261487E-13,
0.33613706423903,
1.33624014631017E-13,
0.297091541712782,
1.35001385070943E-13,
0.277517649216227,
1.34227698400657E-13,
0.26900956482306,
1.30100791251309E-13,
0.268874212857035,
1.24594778938558E-13,
0.277123043430271,
1.19503365536566E-13,
0.296474654946247,
1.184538578336E-13,
0.335370526976415,
1.27939325800241E-13,
0.423855456622949,
1.53145725267922E-14,
4.83016404650982E-14,
3.3433325552501E-14,
7.50658216142064E-14,
5.59266175037543E-14,
9.68409380464053E-14,
7.05425301505969E-14,
1.15688708612893E-13,
8.50639003679987E-14,
1.34669185525293E-13,
9.42353833854881E-14,
1.43027950594288E-13,
9.25318849320789E-14,
1.52058921010223E-13,
8.64881083417757E-14,
1.57757487628807E-13,
8.30290697306779E-14,
1.65058938739193E-13,
8.55877868577437E-14,
1.66588964845005E-13,
6.94704710424432E-14,
1.58623114643319E-13,
5.6472188036949E-14,
1.46042899995535E-13,
4.45147391170408E-14,
1.43871026203612E-13,
4.34687008610268E-14,
1.48351816942061E-13,
4.46951503585424E-14,
1.52430151834082E-13,
0.807478376594263,
1.48436818392383E-13,
0.424516483736852,
1.34392497130875E-13,
0.336000448862126,
1.38665121052206E-13,
0.296948520995639,
1.33776670296903E-13,
0.277376001170088,
1.29438126883485E-13,
0.268874212857035,
1.2548642680521E-13,
0.2687485971832,
1.19990822833316E-13,
0.277009837688736,
1.14679099549875E-13,
0.296376277757294,
1.27335642030602E-13,
0.335289723926591,
1.2639195245967E-13,
2.85498621271918E-14,
2.48828735394113E-14,
5.95682357606986E-14,
4.49189296869434E-14,
8.56450327324509E-14,
6.54693313451027E-14,
1.06658605558696E-13,
8.14079706423776E-14,
1.28608061700231E-13,
9.02854180306889E-14,
1.43687145515159E-13,
9.49275380524028E-14,
1.54551718645202E-13,
8.96192842159138E-14,
1.59742011285324E-13,
8.49459391716323E-14,
1.62429097949612E-13,
8.37229591210686E-14,
1.64770974642181E-13,
7.34863558893295E-14,
1.65211594405079E-13,
6.39766017940246E-14,
1.5393589181123E-13,
4.91828799908944E-14,
1.4641586554287E-13,
4.52780174464706E-14,
1.52114432161454E-13,
4.61991556122143E-14,
1.55885720998228E-13,
3.56954049651748E-14,
1.54565596433009E-13,
0.807430556667666,
1.40580255769684E-13,
0.424409866960427,
1.39338193760885E-13,
0.335874466667863,
1.37664185606567E-13,
0.296816330704072,
1.28858729242509E-13,
0.277244801766206,
1.24660698430645E-13,
0.2687485971832,
1.2043317731969E-13,
0.268631801945058,
1.15289722213419E-13,
0.27690439859884,
1.2383497005608E-13,
0.296284500645395,
1.25871535416877E-13,
0.335214226191321,
1.33953178410584E-14,
4.61818083774546E-14,
3.78204412232463E-14,
7.16588247073879E-14,
5.51564002804206E-14,
9.62450605324072E-14,
7.67597790884977E-14,
1.20079293730591E-13,
8.69495447863855E-14,
1.38005058769597E-13,
9.11649228330091E-14,
1.55458979023138E-13,
9.2070448487469E-14,
1.62462057695656E-13,
8.81395650909056E-14,
1.64486479992121E-13,
8.57092175010621E-14,
1.62290320071534E-13,
7.16701004099818E-14,
1.63423094501347E-13,
6.80063644287188E-14,
1.60519167402562E-13,
5.67167840470617E-14,
1.54303653188137E-13,
4.996524027856E-14,
1.54747742397987E-13,
4.8022349985466E-14,
1.59738541838372E-13,
3.72236963475103E-14,
1.58036778108439E-13,
2.05547384668492E-14,
1.46677808787743E-13,
0.807386571846737,
1.45895448500077E-13,
0.424311562231423,
1.382106235015E-13,
0.335758036207359,
1.32612670844523E-13,
0.296693898947963,
1.24166302239992E-13,
0.277123043430271,
1.19935311682084E-13,
0.268631801945058,
1.15987081050761E-13,
0.268523016924749,
1.24227017561651E-13,
0.276806028817104,
1.2207596045144E-13,
0.296198743845433,
1.2342557531575E-13,
2.47970047273505E-14,
2.96125970966621E-14,
6.0808996726891E-14,
4.89989993024409E-14,
8.33144317424761E-14,
6.69481831083729E-14,
1.10295453326081E-13,
8.26907986528624E-14,
1.29883083455073E-13,
8.80033892980414E-14,
1.50086540418037E-13,
8.8481305615673E-14,
1.63601771019373E-13,
9.07711406039624E-14,
1.67407754325666E-13,
8.89809059767543E-14,
1.6443096884089E-13,
7.36494198960713E-14,
1.61015298316691E-13,
6.61849047789431E-14,
1.58839955077816E-13,
6.07604244695636E-14,
1.60999685805407E-13,
5.75268999103429E-14,
1.62673693959725E-13,
5.26956950297475E-14,
1.62316340923674E-13,
3.89757670582469E-14,
1.61964192058051E-13,
2.20864992961367E-14,
1.50129908504937E-13,
1.46757606067638E-14,
1.51234927359134E-13,
0.80734602018044,
1.44668999002562E-13,
0.424220722518534,
1.3343319504866E-13,
0.33565021078867,
1.2787514103163E-13,
0.29658028384056,
1.1950163081309E-13,
0.277009837688736,
1.1522033327438E-13,
0.268523016924749,
1.24841109672147E-13,
0.26842152319703,
1.22724747031455E-13,
0.27671410783506,
1.19917964447325E-13,
0.296118490116469,
2.08077912539073E-14,
4.52624049351869E-14,
4.24998577996938E-14,
7.39946298677907E-14,
6.15263048842074E-14,
9.81688688672655E-14,
7.33033425626139E-14,
1.20661293456781E-13,
8.40655670075741E-14,
1.42352275800395E-13,
8.55288062595605E-14,
1.58486071488717E-13,
8.72461825007775E-14,
1.68724409443932E-13,
9.17113607279418E-14,
1.67484082158609E-13,
7.70286612272741E-14,
1.63324215263216E-13,
6.82180006927879E-14,
1.56515425620007E-13,
5.89684551188796E-14,
1.5933435126847E-13,
6.15913570145565E-14,
1.69414829387371E-13,
6.02660282789103E-14,
1.70304742530547E-13,
4.36855412955239E-14,
1.64639135658007E-13,
2.39600006501917E-14,
1.53965382110322E-13,
1.61693575195798E-14,
1.55217852459977E-13,
  0,
1.50457771241896E-13,
0.807308551332976,
1.39669525944797E-13,
0.424136606570248,
1.28745972216571E-13,
0.335550158724394,
1.23184448752589E-13,
0.296474654946247,
1.14686038443779E-13,
0.27690439859884,
1.24227017561651E-13,
0.26842152319703,
1.232486335212E-13,
0.268326681013678,
1.20285725824232E-13,
0.276628082004101,
1.11525372270549E-13,
2.74619736673198E-14,
3.83347867338735E-14,
6.09347641788993E-14,
5.61356516826095E-14,
8.99098503981399E-14,
6.84487189150929E-14,
1.09122780256321E-13,
7.50571479968265E-14,
1.33544217351123E-13,
8.17748646575467E-14,
1.51038903606349E-13,
8.44133790645074E-14,
1.63896674010289E-13,
8.83234457793591E-14,
1.69015842987896E-13,
7.9807688235789E-14,
1.66481411989494E-13,
7.16596920691259E-14,
1.58895466229048E-13,
6.10431843961479E-14,
1.57126048283551E-13,
5.98496946446758E-14,
1.67792862937333E-13,
6.43773229169753E-14,
1.77061490469477E-13,
5.12541398212107E-14,
1.72726416503011E-13,
2.86003859484296E-14,
1.56666346562417E-13,
1.80810227901063E-14,
1.58942303762899E-13,
  0,
1.54097221094496E-13,
  0,
1.45584932997878E-13,
0.807273858787743,
1.35133224055117E-13,
0.424058563372412,
1.23970278487207E-13,
0.335457146890823,
1.18426102257985E-13,
0.296376277757293,
1.2388701176036E-13,
0.276806028817104,
1.22669235880224E-13,
0.268326681013678,
1.21094106964037E-13,
0.268237919529414,
1.12115178252381E-13,
0.276547456044149,
2.34280910643703E-14,
4.93836742332388E-14,
5.4002809168896E-14,
7.8385214985488E-14,
6.38326197455186E-14,
1.0168949016176E-13,
7.05971739400901E-14,
1.22571224003831E-13,
7.30127763803878E-14,
1.42670597558237E-13,
8.08155625753315E-14,
1.56735735501456E-13,
8.55912563046957E-14,
1.64358110454899E-13,
7.65290608661928E-14,
1.68162359037716E-13,
7.45011691227759E-14,
1.62182767216024E-13,
6.45056924541976E-14,
1.5958415144901E-13,
6.19591183914636E-14,
1.65634866933217E-13,
6.25974966306231E-14,
1.75559219939281E-13,
5.5422680333983E-14,
1.79519593634936E-13,
3.61863317088762E-14,
1.64803934388225E-13,
2.27162039179163E-14,
1.6167102379061E-13,
  0,
1.58095758706622E-13,
  0,
1.49189688380957E-13,
  0,
1.41039957490818E-13,
0.807241673397917,
1.30468552628216E-13,
0.423986019218251,
1.19043663815432E-13,
0.335370526976415,
1.27349519818409E-13,
0.296284500645395,
1.22082899345344E-13,
0.27671410783506,
1.20230214673001E-13,
0.268237919529414,
1.12562736909183E-13,
0.268154728055291,
1.08160008727154E-13,
2.95648922010727E-14,
4.45203769683378E-14,
6.95771565362158E-14,
6.29730642631721E-14,
9.1327986839751E-14,
6.65422578149943E-14,
1.15772842701478E-13,
6.88789303371351E-14,
1.32121744100822E-13,
7.22442938805301E-14,
1.48657128273832E-13,
8.21825246744012E-14,
1.57450441573559E-13,
7.39495270574153E-14,
1.63691976640123E-13,
7.13110126504546E-14,
1.64002492142323E-13,
6.74269667877425E-14,
1.62977270568021E-13,
6.54355042373211E-14,
1.68191849336807E-13,
6.4701716206983E-14,
1.73441122575113E-13,
5.36515276650107E-14,
1.78031200892548E-13,
4.03461986042686E-14,
1.71652622671381E-13,
3.03299052539785E-14,
1.69845040809413E-13,
1.41570782874467E-14,
1.60781110647434E-13,
  0,
1.53170878758324E-13,
  0,
1.4465685593823E-13,
-2.26901830657766E-14,
1.3625732486755E-13,
0.807211758023082,
1.24848048566051E-13,
0.423918466898636,
1.27887284095962E-13,
0.335289723926591,
1.25916638227253E-13,
0.296198743845433,
1.19917964447325E-13,
0.276628082004101,
1.12115178252381E-13,
0.268154728055291,
1.08867775905352E-13,
0.268076648584514,
2.7970247645781E-14,
5.66083638298132E-14,
5.58390139682174E-14,
8.42130185030321E-14,
6.65223084950206E-14,
1.06277833755719E-13,
6.52429499314877E-14,
1.25861127076021E-13,
6.8366319549984E-14,
1.3851246538632E-13,
7.37257477290143E-14,
1.49689288742039E-13,
7.06500830061074E-14,
1.56987270405473E-13,
6.88008677807161E-14,
1.59657009835001E-13,
6.42576269971329E-14,
1.64894140008975E-13,
6.83949424873376E-14,
1.71690786587853E-13,
6.82578993327354E-14,
1.76060555023838E-13,
5.57921764343661E-14,
1.75966879956135E-13,
3.86045362343879E-14,
1.70313416147927E-13,
3.44637512972312E-14,
1.76820363906316E-13,
2.18037393695525E-14,
1.68969005454045E-13,
  0,
1.55956844660743E-13,
  0,
1.48582535164365E-13,
-2.12208722816243E-14,
1.40023409533896E-13,
-2.45879705484953E-14,
1.31485100585138E-13,
0.807183903046824,
1.34146166397286E-13,
0.423855456622949,
1.2639195245967E-13,
0.335214226191321,
1.23432514209654E-13,
0.296118490116469,
1.1158088342178E-13,
0.276547456044149,
1.08156539280202E-13,
0.268076648584514,
1.14425829922382E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.08161092929326E-14,
  0,
  0,
  0,
  0,
0.999999999999996,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.07028101659079E-14,
  0,
1.41956758847872E-14,
  0,
1.45007703761246E-14,
  0,
1.58837786673471E-14,
1.37476835471162E-14,
2.31973728420654E-14,
1.51146456461859E-14,
2.37275477044108E-14,
1.65043759908778E-14,
3.02709246557953E-14,
1.53987066153771E-14,
3.41220107724638E-14,
2.47636113004379E-14,
3.25230294084822E-14,
1.71000366644414E-14,
2.85431400737224E-14,
1.48355720069882E-14,
2.74697799229617E-14,
1.11113375445004E-14,
2.44836702995022E-14,
1.90197250310442E-14,
3.32340491931982E-14,
2.56246846658259E-14,
3.044136123731E-14,
2.38877927855041E-14,
3.27856231746582E-14,
  0,
  0,
  0,
  0,
-1.04933423061837E-14,
  0,
-1.63983410184088E-14,
-1.40922429975321E-14,
-1.58141728878736E-14,
-1.38261797844041E-14,
  0,
0.866778142217527,
  0,
0.866666666666659,
  0,
  0,
  0,
-1.02708640203897E-14,
  0,
  0,
1.03762484715553E-14,
  0,
2.15326888264311E-14,
1.07856432118858E-14,
2.48416738568569E-14,
1.43184075707126E-14,
2.6330066599245E-14,
2.02095284951298E-14,
3.38869557414689E-14,
2.50233861409654E-14,
4.06254890839008E-14,
2.73817427065559E-14,
4.67781195723216E-14,
2.76167977375508E-14,
5.57622524544055E-14,
3.4779470969859E-14,
5.76982038535956E-14,
3.62301334766446E-14,
5.29112344216376E-14,
2.76497574835943E-14,
4.85124093674294E-14,
2.25028329303711E-14,
4.49692366677468E-14,
2.60915421212982E-14,
4.99769496620228E-14,
3.86518074491082E-14,
5.51416551308748E-14,
4.28780275174567E-14,
5.4750041306173E-14,
4.07898541332496E-14,
  0,
  0,
  0,
  0,
  0,
-1.70360687362647E-14,
-1.30388321667452E-14,
-1.90767540653169E-14,
-1.8324317757612E-14,
-1.59924157250302E-14,
0.840122671494809,
  0,
0.561717559565152,
  0,
0.839682074076694,
  0,
-1.12592227208275E-14,
  0,
-1.13745818319799E-14,
1.0246144210857E-14,
  0,
1.88525410560469E-14,
  0,
2.90743991382403E-14,
1.66477075180804E-14,
3.335613035782E-14,
2.26841115336107E-14,
4.05725800178836E-14,
2.84425261121157E-14,
4.61922167183104E-14,
3.38331793137137E-14,
5.81401246591007E-14,
3.47963845237498E-14,
6.54224938112513E-14,
4.32358142343769E-14,
7.17694133289815E-14,
4.10734814215719E-14,
7.07450591164172E-14,
4.27409843628546E-14,
6.62551610797202E-14,
3.19275855753531E-14,
5.98106633664663E-14,
3.46441625387328E-14,
6.45655404141188E-14,
4.14199924358982E-14,
6.46175821183981E-14,
5.03087155268034E-14,
7.23856738438222E-14,
5.42951100745981E-14,
7.17637754776845E-14,
  0,
  0,
  0,
  0,
-1.41128428388093E-14,
  0,
-1.93467204062658E-14,
-1.67231679892854E-14,
-1.88802966316626E-14,
0.829409536066531,
-1.55899598786036E-14,
0.50088794707639,
  0,
0.500167182298014,
  0,
0.828398039489368,
  0,
-1.19474742599213E-14,
1.03315793420489E-14,
  0,
1.83104399698042E-14,
  0,
2.53308658770823E-14,
1.08918950247894E-14,
3.62860783087449E-14,
2.42271480654921E-14,
4.60981079697387E-14,
2.98120902963994E-14,
5.10442382806175E-14,
3.59599502952612E-14,
6.14890083294739E-14,
3.97988933475979E-14,
7.42210112814057E-14,
4.88159859757253E-14,
7.84736858827628E-14,
4.77092323980521E-14,
8.17098125271976E-14,
4.57385865293425E-14,
8.12214878687101E-14,
4.5474041199256E-14,
7.49149006717964E-14,
4.27704746619462E-14,
7.68586583266284E-14,
4.84169995762507E-14,
7.6514315716647E-14,
5.10763306649231E-14,
7.89646126264643E-14,
5.95148930138123E-14,
8.63840249332171E-14,
6.35663396919561E-14,
  0,
-1.0507870615295E-14,
  0,
-1.41128428388093E-14,
  0,
-1.60123650450039E-14,
-1.12999887225129E-14,
-1.81907440499618E-14,
0.824177123979284,
-1.75879276420599E-14,
0.476051232703976,
-1.40065910259057E-14,
0.428785607196384,
  0,
0.4740049305501,
  0,
0.822302312523379,
  0,
  0,
1.80662776405605E-14,
  0,
2.4234086959396E-14,
  0,
3.18512577424102E-14,
1.81452075587174E-14,
4.81368417348804E-14,
3.08399139559157E-14,
5.55892137876768E-14,
3.66330230039402E-14,
6.51197845646934E-14,
4.11216199980302E-14,
7.61795140857835E-14,
5.28934535060088E-14,
8.57118195862761E-14,
5.23357399084823E-14,
8.67665314596699E-14,
5.13703662941012E-14,
9.05187383382078E-14,
4.74594322175115E-14,
8.82436484994642E-14,
5.53576282036339E-14,
9.03747562897017E-14,
5.56030915754846E-14,
8.71689873060966E-14,
5.70316363579515E-14,
8.92506554772687E-14,
5.90456503135606E-14,
9.12169645372884E-14,
6.74443140225023E-14,
1.07964852336107E-13,
  0,
  0,
-1.70638243118804E-14,
  0,
-1.59997882998031E-14,
  0,
-1.50192358550072E-14,
0.821652244094977,
-1.73784597823357E-14,
0.463796611961337,
-1.65041591504433E-14,
0.398845181276695,
-1.33747179997812E-14,
0.397288029431201,
  0,
0.459709931706213,
  0,
0.818534584512866,
1.6002824065886E-14,
  0,
2.38203554103755E-14,
  0,
3.04105698956114E-14,
1.31318567131444E-14,
4.31911451048705E-14,
2.4454396840845E-14,
5.70246974640476E-14,
3.72236963475103E-14,
6.89569928935541E-14,
4.13401951560033E-14,
7.89680820734162E-14,
5.36116290250632E-14,
8.66234167729019E-14,
5.57011034518773E-14,
9.2892707415082E-14,
5.5345485139302E-14,
9.44765099486489E-14,
5.24745177865604E-14,
9.64523599877865E-14,
5.67237229409656E-14,
1.02640985988334E-13,
6.75830919005804E-14,
9.96173629697061E-14,
6.35177674346288E-14,
9.88141860003289E-14,
6.42576269971329E-14,
1.00391049639992E-13,
6.62265381423666E-14,
1.11547923675737E-13,
7.12650424783412E-14,
  0,
-1.64018104653607E-14,
-1.30370974432692E-14,
-1.93473709275693E-14,
-1.13520304267922E-14,
-1.5032679961946E-14,
0.82089110243639,
-1.37541887601511E-14,
0.457848503080682,
-1.58909344016855E-14,
0.383846026371474,
-1.51879377130459E-14,
0.364555860433759,
-1.24475083018716E-14,
0.379788684871356,
  0,
0.450805000959554,
1.39705955137792E-14,
0.816002375554015,
2.19078227781111E-14,
  0,
2.97383645486704E-14,
1.14873388579184E-14,
4.15240758444568E-14,
1.92918597763381E-14,
5.17702200553138E-14,
3.05337352624058E-14,
6.98972130175335E-14,
4.15761175487361E-14,
8.21920656535191E-14,
5.34329525070376E-14,
8.87900863943969E-14,
5.60012106132213E-14,
9.31138846582691E-14,
5.83300768797201E-14,
9.98428770215831E-14,
5.60124863158151E-14,
9.9631240757514E-14,
6.12947193001645E-14,
1.10066469827252E-13,
6.8440045297713E-14,
1.11022302462516E-13,
7.49877590577874E-14,
1.10456782609347E-13,
7.02224736692791E-14,
1.09167883066696E-13,
7.08964137396961E-14,
1.19876331083901E-13,
6.94730731276572E-14,
1.2399890142456E-13,
-1.08161092929326E-14,
-1.41041692214294E-14,
-1.90752361822755E-14,
-1.6751790926639E-14,
-1.81395697074205E-14,
0.821652244094977,
-1.38608742539237E-14,
0.456050612464657,
-1.2117910841436E-14,
0.376503821482069,
-1.4659280733742E-14,
0.347987455075766,
-1.41644508622196E-14,
0.345297955355882,
  0,
0.368766282325613,
  0,
0.444786857841308,
1.92528284981286E-14,
0.814200048945812,
2.74181718995514E-14,
1.09495745803656E-14,
4.06506425743025E-14,
1.74096848049032E-14,
4.97744206962025E-14,
2.52003279355151E-14,
6.43478326178837E-14,
3.47369702446976E-14,
8.27454424423557E-14,
5.34164726340158E-14,
9.15057959960386E-14,
5.54599768887165E-14,
9.47566677900191E-14,
5.82112483216157E-14,
9.95046059437676E-14,
5.86752868514395E-14,
1.0439739350776E-13,
6.45004882837696E-14,
1.12583553590895E-13,
7.25947080226774E-14,
1.17787724018825E-13,
7.54249093737336E-14,
1.21194720925644E-13,
8.12709274877754E-14,
1.20136539605298E-13,
7.64509983097739E-14,
1.27978357078451E-13,
7.36997268768746E-14,
1.31572704120675E-13,
6.8738417735581E-14,
  0,
-1.57985603765898E-14,
-1.83087052463282E-14,
-1.89652980819854E-14,
0.824177123979284,
-1.73793271440736E-14,
0.457848503080682,
-1.21786261630952E-14,
0.374276019884784,
-1.10280708176536E-14,
0.339828173682782,
-1.37719696757799E-14,
0.32771219048399,
  0,
0.333075997265837,
  0,
0.361258750123492,
1.43782555306338E-14,
0.440485811459652,
2.49219048176208E-14,
0.81286231764853,
3.83521339686332E-14,
1.70176372993325E-14,
4.86529219689835E-14,
2.34239710961148E-14,
6.21195803129915E-14,
2.9244835719755E-14,
7.68196270484189E-14,
4.64281391110433E-14,
9.169921766361E-14,
5.51919621116781E-14,
9.70794625243521E-14,
5.74202144165703E-14,
1.00724983909117E-13,
5.82945150484626E-14,
1.03633247816592E-13,
6.6868385828478E-14,
1.16891739343483E-13,
7.55298601440302E-14,
1.19866790104783E-13,
7.92968121721138E-14,
1.27458807397396E-13,
8.13854192371899E-14,
1.30350591431849E-13,
8.71230171339832E-14,
1.38432668106425E-13,
7.89195098160889E-14,
1.3912482277334E-13,
7.26797094730003E-14,
1.38151642903317E-13,
  0,
-1.38270471461421E-14,
-1.60461921527855E-14,
0.829409536066531,
-1.75879276420599E-14,
0.463796611961337,
-1.59846094693883E-14,
0.376503821482069,
-1.10827146071468E-14,
0.337345558719678,
  0,
0.319014250344191,
  0,
0.314782221918911,
  0,
0.324705571405495,
  0,
0.355862375323376,
2.02390187942214E-14,
0.437283525876042,
3.59703586361171E-14,
0.811837076252144,
4.64194654936634E-14,
2.27734497926235E-14,
6.08003231095111E-14,
2.74702136038307E-14,
7.43606565212218E-14,
4.08232475601622E-14,
8.55123263865387E-14,
4.80440340289157E-14,
9.70144103940029E-14,
5.69778599301962E-14,
1.02781498589888E-13,
5.7293579602824E-14,
1.04518824151079E-13,
6.6342764615257E-14,
1.15739882955435E-13,
7.763841652908E-14,
1.23765581117041E-13,
8.19214487912667E-14,
1.29058222442247E-13,
8.49797662794138E-14,
1.36184466481559E-13,
8.69200544872939E-14,
1.48181814041415E-13,
8.93382590128056E-14,
1.49111625824538E-13,
7.76722436368615E-14,
1.45274417495678E-13,
7.07836567137576E-14,
  0,
  0,
0.840122671494809,
-1.56003682194594E-14,
0.476051232703976,
-1.65024244269674E-14,
0.383846026371474,
-1.46844342241437E-14,
0.339828173682782,
  0,
0.316362342148597,
  0,
0.305704899197428,
  0,
0.305894998476223,
  0,
0.318664009767438,
1.43531020402321E-14,
0.351827004769081,
3.0737565270833E-14,
0.43482333130513,
4.36499794642664E-14,
0.811031132439902,
5.82164524920437E-14,
2.6775456851702E-14,
7.29416527178728E-14,
3.88283155627889E-14,
8.29267210455953E-14,
4.23775597946374E-14,
9.0574249489439E-14,
4.96529900528841E-14,
1.02394655254745E-13,
5.66890284714461E-14,
1.06223189966226E-13,
6.51969797593743E-14,
1.16338362554647E-13,
7.68976896048379E-14,
1.22247698075562E-13,
8.3847859211339E-14,
1.32657773654898E-13,
8.73745520379998E-14,
1.37452549342498E-13,
9.03235819471604E-14,
1.5363404992641E-13,
8.8930598995951E-14,
1.58496479829573E-13,
8.78741523990811E-14,
1.54846621636118E-13,
7.55576157196458E-14,
1.48207834893554E-13,
  0,
0.866778142217527,
  0,
0.50088794707639,
-1.39779680885521E-14,
0.398845181276695,
-1.51953102878188E-14,
0.347987455075766,
-1.37893169105396E-14,
0.319014250344191,
  0,
0.302933083543112,
  0,
0.296538279133769,
  0,
0.299462744837997,
1.23902624271643E-14,
0.314131689778163,
2.52289508728687E-14,
0.348716208643079,
3.87077522812085E-14,
0.43288563773001,
5.51468593013027E-14,
0.81038436946331,
7.04167626985885E-14,
3.80468226368613E-14,
8.13325101711726E-14,
4.03019631556312E-14,
8.77778752461644E-14,
4.39735053925361E-14,
9.58209206425309E-14,
4.92860960377151E-14,
1.05707109732123E-13,
6.44354361534205E-14,
1.17827622658773E-13,
7.5614861594353E-14,
1.22651888645464E-13,
8.29735585794467E-14,
1.30874477921594E-13,
8.9154378324352E-14,
1.40722503094715E-13,
9.2524946038175E-14,
1.54551718645202E-13,
9.20877957222288E-14,
1.63610444636753E-13,
8.72427130538256E-14,
1.63882796222481E-13,
8.56016646455515E-14,
1.57433094338799E-13,
7.06414093887275E-14,
0.999999999999996,
  0,
0.561717559565152,
  0,
0.428785607196384,
-1.33747179997812E-14,
0.364555860433759,
-1.41471036274599E-14,
0.32771219048399,
  0,
0.305704899197428,
  0,
0.293677783693386,
1.1291315105133E-14,
0.289893362931038,
1.35542618795448E-14,
0.294626917013928,
2.33294286666741E-14,
0.31062894935204,
3.29059696158041E-14,
0.346259432905461,
5.03746350188905E-14,
0.431328226929016,
6.78068712289814E-14,
0.809856374378842,
7.84355219662913E-14,
3.96297578086902E-14,
8.616718449872E-14,
4.17296405763601E-14,
9.28406657108027E-14,
4.3453955711481E-14,
9.89226062175774E-14,
5.69318897580828E-14,
1.17059140158915E-13,
7.47579081972205E-14,
1.23940788188115E-13,
8.15510853291457E-14,
1.31008051629244E-13,
8.80996664509581E-14,
1.38715428033009E-13,
9.41174221891217E-14,
1.57551055535166E-13,
9.423885283244E-14,
1.64259231216768E-13,
9.0276744413309E-14,
1.68700123315269E-13,
8.48574682743575E-14,
1.66231611808954E-13,
8.05310679252713E-14,
1.58413213102726E-13,
  0,
0.866666666666659,
  0,
0.500167182298014,
  0,
0.397288029431201,
-1.24462072592646E-14,
0.345297955355882,
  0,
0.314782221918911,
  0,
0.296538279133769,
1.12427428478057E-14,
0.286965148637542,
1.69508504455074E-14,
0.284891445695914,
2.36833122557734E-14,
0.290883175321252,
3.06803193961258E-14,
0.307856987257106,
4.44982592440191E-14,
0.34428046292068,
6.21256518451574E-14,
0.430055178517695,
7.54266440972096E-14,
0.809419046495733,
8.30819787966952E-14,
4.10765171876548E-14,
9.08969080559707E-14,
4.13072354099597E-14,
9.58313289833868E-14,
5.09991354702422E-14,
1.10142797660195E-13,
6.70973693273069E-14,
1.22951995806808E-13,
8.05466804365551E-14,
1.32107866313014E-13,
8.66355598372337E-14,
1.38668590499158E-13,
9.29568921836932E-14,
1.55377447019767E-13,
9.56491830184092E-14,
1.67064279077422E-13,
9.22786153045863E-14,
1.69100844438219E-13,
8.77822120548544E-14,
1.70774852592537E-13,
7.96741145281388E-14,
1.6690988868806E-13,
7.17204073907851E-14,
  0,
  0,
0.839682074076694,
  0,
0.4740049305501,
  0,
0.379788684871356,
  0,
0.333075997265837,
  0,
0.305894998476223,
  0,
0.289893362931038,
1.69335032107476E-14,
0.281910206994882,
2.73921510474118E-14,
0.281015257397317,
3.12857378892417E-14,
0.287916349412354,
4.25839918882787E-14,
0.305620403204274,
5.63880539483641E-14,
0.342659893737278,
7.01825750293317E-14,
0.428999611070099,
8.00574884163296E-14,
0.809052287353909,
8.78238454182778E-14,
4.04207917137356E-14,
9.39734401406156E-14,
4.88220575078913E-14,
1.06933559229638E-13,
6.11628803159903E-14,
1.1590554904739E-13,
7.28462429266941E-14,
1.31032337757908E-13,
8.54646214909494E-14,
1.39619218963993E-13,
9.13488035214627E-14,
1.55122442668798E-13,
9.43845696044221E-14,
1.64633931487579E-13,
9.364384268018E-14,
1.71685582417425E-13,
8.96747953671451E-14,
1.70983019409654E-13,
8.24861012826972E-14,
1.71238023760623E-13,
7.07264108390504E-14,
1.59615376471578E-13,
  0,
  0,
  0,
0.828398039489368,
  0,
0.459709931706213,
  0,
0.368766282325613,
  0,
0.324705571405495,
  0,
0.299462744837997,
1.35542618795448E-14,
0.284891445695914,
2.73643954717961E-14,
0.277991647581968,
3.49408002531248E-14,
0.277940969625986,
4.32683402995515E-14,
0.285519782568366,
5.40973515983367E-14,
0.303786341287835,
6.4250688103229E-14,
0.341314143304492,
7.48064804545479E-14,
0.428113577233339,
8.49875725350557E-14,
0.808741373903882,
9.08613462247132E-14,
4.79564304933788E-14,
1.04938627232265E-13,
5.89511078841198E-14,
1.12613043889986E-13,
6.67781802077272E-14,
1.23770785287469E-13,
7.77312242350447E-14,
1.38399708360382E-13,
9.01501095995627E-14,
1.55939497425983E-13,
9.26082127650218E-14,
1.64172495042969E-13,
9.2219634706403E-14,
1.69086966650411E-13,
9.08891018003288E-14,
1.73380407253454E-13,
8.42451108873377E-14,
1.71291800188378E-13,
7.34655392076178E-14,
1.63764835026114E-13,
6.36279223753533E-14,
  0,
  0,
-1.12557532738755E-14,
  0,
0.822302312523379,
  0,
0.450805000959554,
  0,
0.361258750123492,
  0,
0.318664009767438,
1.23902624271643E-14,
0.294626917013928,
2.36278011045421E-14,
0.281015257397317,
3.4926922465317E-14,
0.274882923781057,
4.68063088288062E-14,
0.275455925258226,
5.4903130652928E-14,
0.28355264563295,
6.22054491250523E-14,
0.30226153564662,
6.89847484691697E-14,
0.340183093211855,
7.96793186985667E-14,
0.42736188335606,
8.73693478675719E-14,
0.808475296787326,
1.01576733135822E-13,
5.81201753391269E-14,
1.10519232654482E-13,
6.44779368785819E-14,
1.20453994001402E-13,
7.15434655962355E-14,
1.31013255799672E-13,
8.22519136134403E-14,
1.54626311754669E-13,
9.14112535665978E-14,
1.6482301634646E-13,
9.04484820374307E-14,
1.68521446797243E-13,
8.94354035274603E-14,
1.70693320589166E-13,
8.54091103397181E-14,
1.73578165729715E-13,
7.51412820854114E-14,
1.63606975189801E-13,
6.62421506536504E-14,
1.65496089055139E-13,
  0,
-1.02916807021014E-14,
  0,
-1.1964821494681E-14,
  0,
0.818534584512866,
1.39731975989932E-14,
0.444786857841308,
1.43192749324506E-14,
0.355862375323376,
1.43539694019701E-14,
0.314131689778163,
2.32478966633032E-14,
0.290883175321252,
3.12857378892417E-14,
0.277940969625986,
4.67638081036448E-14,
0.27236948751649,
5.8262422664157E-14,
0.273415017105245,
6.27683668930068E-14,
0.281915882903758,
6.64607258116234E-14,
0.300978737138386,
7.34655392076178E-14,
0.339222491459085,
8.22102802500169E-14,
0.426718167800698,
9.85322934354826E-14,
0.80824567515255,
1.07020295403437E-13,
6.3497818114655E-14,
1.18176302077444E-13,
6.92501611609941E-14,
1.27592381105046E-13,
7.60398688459674E-14,
1.471791438723E-13,
8.34193825127727E-14,
1.63417890330919E-13,
8.91387658130682E-14,
1.6907482358608E-13,
8.75965966429249E-14,
1.6994565477102E-13,
8.38582675521948E-14,
1.70655156672694E-13,
7.62358925987527E-14,
1.65749358682632E-13,
6.78745254445445E-14,
1.65260166662407E-13,
6.13606387922516E-14,
  0,
  0,
-1.13424894476744E-14,
1.03593349176645E-14,
  0,
1.59421087442269E-14,
0.816002375554015,
1.92398180720588E-14,
0.440485811459652,
2.02459576881253E-14,
0.351827004769081,
2.52107362763709E-14,
0.31062894935204,
3.06525638205102E-14,
0.287916349412353,
4.33264535359967E-14,
0.275455925258226,
5.82771678137028E-14,
0.270304879156318,
6.61571492033275E-14,
0.271716065823307,
6.7392272318223E-14,
0.280537950676502,
7.11878472836602E-14,
0.299888339873646,
7.61023188911025E-14,
0.338399110663084,
9.33923077761634E-14,
0.426162333021363,
1.0439739350776E-13,
0.808046028210886,
1.14885531643516E-13,
6.82769812909712E-14,
1.25231422454242E-13,
7.38038102854333E-14,
1.43562245424889E-13,
7.72680530669589E-14,
1.55916946020795E-13,
8.11243433540554E-14,
1.67489286329037E-13,
8.6240042884711E-14,
1.70405356492154E-13,
8.19344592173366E-14,
1.69883204725885E-13,
7.46052525313345E-14,
1.62805532943899E-13,
6.8884134507563E-14,
1.6722907780764E-13,
6.29218899206307E-14,
1.66968869286244E-13,
  0,
  0,
1.02053782091716E-14,
  0,
1.80853595987962E-14,
  0,
2.19607318441284E-14,
0.814200048945812,
2.48126172386343E-14,
0.437283525876042,
3.0741034717785E-14,
0.348716208643079,
3.28521931880488E-14,
0.307856987257106,
4.25883286969686E-14,
0.285519782568366,
5.48207312878191E-14,
0.273415017105245,
6.61398019685677E-14,
0.26858592920938,
7.07871261607096E-14,
0.270285199923843,
7.18886755679549E-14,
0.27936599849849,
7.37691158159137E-14,
0.298953027858643,
8.66338251137577E-14,
0.337687565556663,
9.86086212684256E-14,
0.425678817754558,
1.12064871271578E-13,
0.80787127436887,
1.21676974051965E-13,
7.27109344955679E-14,
1.4124638958446E-13,
7.47995415606439E-14,
1.52320864255096E-13,
7.48810735640149E-14,
1.5992936142073E-13,
7.81683745509909E-14,
1.68757369189976E-13,
8.05813749060746E-14,
1.70214536909796E-13,
7.26640969617165E-14,
1.61858373926016E-13,
6.72639027810007E-14,
1.64153413084733E-13,
6.39818059644526E-14,
1.68882269280246E-13,
6.8736683012105E-14,
  0,
1.03758147906863E-14,
  0,
1.8247989924669E-14,
  0,
2.37787220469521E-14,
  0,
2.74181718995514E-14,
0.81286231764853,
3.59304599961696E-14,
0.43482333130513,
3.87060175577325E-14,
0.346259432905461,
4.44904529883772E-14,
0.305620403204274,
5.40973515983367E-14,
0.28355264563295,
6.27128557417755E-14,
0.271716065823307,
7.07853914372336E-14,
0.267138026626042,
7.52748557930616E-14,
0.269067803243008,
7.4568823338339E-14,
0.278360219293801,
8.45608305599654E-14,
0.298144246419434,
9.23896376070488E-14,
0.337068164487874,
1.06125178089833E-13,
0.425255406531269,
1.18675902438525E-13,
0.807717379468084,
1.37865413529781E-13,
7.3750033857678E-14,
1.49876638877444E-13,
7.24576648680753E-14,
1.5615633786048E-13,
7.19060228027146E-14,
1.61091626149634E-13,
7.25426663183981E-14,
1.68476343986868E-13,
7.13006043095987E-14,
1.62054397678801E-13,
6.53227472113826E-14,
1.63142069298239E-13,
6.22678991701875E-14,
1.65695582254877E-13,
6.97133323290799E-14,
1.82145964977565E-13,
1.07028101659079E-14,
  0,
1.88399643108461E-14,
  0,
2.42496994706798E-14,
  0,
2.97609159538581E-14,
1.09790648794572E-14,
3.84076451198645E-14,
0.811837076252144,
4.36005398452011E-14,
0.43288563773001,
5.03208585911352E-14,
0.344280462920679,
5.63811150544602E-14,
0.303786341287835,
6.22071838485283E-14,
0.281915882903758,
6.74044153825548E-14,
0.270285199923843,
7.53234280503889E-14,
0.265905993155128,
7.8161435657087E-14,
0.268022708346353,
8.53119658250634E-14,
0.277490118370093,
9.02160290916498E-14,
0.297439814166363,
9.99790528144473E-14,
0.336525424688196,
1.12909681604378E-13,
0.42488239205388,
1.34517397221146E-13,
0.807581105052999,
1.46120962551954E-13,
7.12971348626468E-14,
1.53797113933152E-13,
6.9408020997308E-14,
1.57306459525053E-13,
6.61883742258951E-14,
1.60758559242247E-13,
6.32653651688742E-14,
1.60272836668973E-13,
6.38499669802783E-14,
1.63308602751933E-13,
6.02642935554343E-14,
1.64614849529343E-13,
6.80133033226227E-14,
1.78832643138449E-13,
6.50764164777939E-14,
  0,
2.15600107211777E-14,
  0,
2.53308658770823E-14,
  0,
3.04374581094891E-14,
1.14604506440408E-14,
4.06731939794902E-14,
1.70228414697604E-14,
4.64203328554014E-14,
0.811031132439902,
5.52578816037652E-14,
0.431328226929016,
6.21247844834194E-14,
0.342659893737278,
6.42775763171066E-14,
0.30226153564662,
6.64815424933352E-14,
0.280537950676502,
7.1874797780147E-14,
0.269067803243008,
7.8161435657087E-14,
0.264848227576489,
8.87449835840215E-14,
0.26711835792524,
9.06757308127837E-14,
0.276731984167221,
9.77325859130573E-14,
0.296822269090484,
1.06746209094233E-13,
0.33604702487731,
1.29000976567539E-13,
0.424551974778311,
1.43282954945256E-13,
0.807459825166117,
1.50221848849164E-13,
6.82804507379231E-14,
1.54872642488257E-13,
6.36574126744449E-14,
1.56968188447237E-13,
5.69440328224147E-14,
1.52593215840824E-13,
5.5800850051746E-14,
1.61464591696969E-13,
5.88175341764696E-14,
1.64736280172662E-13,
6.59992893670136E-14,
1.77705072879064E-13,
6.33815916417646E-14,
1.82331580389494E-13,
1.41956758847872E-14,
1.07865105736238E-14,
2.9097817905166E-14,
1.08801856413265E-14,
3.18798806797638E-14,
1.31058358610048E-14,
4.15258105679328E-14,
1.74105521666412E-14,
4.86633303098394E-14,
2.28306956673308E-14,
5.82173198537816E-14,
0.81038436946331,
6.78354941663351E-14,
0.430055178517695,
7.02988015022221E-14,
0.341314143304492,
6.88615831023753E-14,
0.300978737138386,
7.12745834574591E-14,
0.27936599849849,
7.46278039365222E-14,
0.268022708346353,
8.88091683526326E-14,
0.263932833237252,
9.39873179284234E-14,
0.266330200085857,
9.82009612515711E-14,
0.276067133923093,
1.04527497768458E-13,
0.29627769952717,
1.22695256732364E-13,
0.335623052721033,
1.37364078445223E-13,
0.424257825301551,
1.46833933900581E-13,
0.807351390981609,
1.51146456461859E-13,
6.2456984029069E-14,
1.54341817104608E-13,
5.43922545892528E-14,
1.48664067167736E-13,
4.94673746409546E-14,
1.53686091630689E-13,
5.06938241384702E-14,
1.62845431583847E-13,
6.4470997984678E-14,
1.77725889560776E-13,
6.12981887471165E-14,
1.8115196842583E-13,
5.07510700131775E-14,
  0,
2.48542506020577E-14,
1.66199519424648E-14,
3.62895477556968E-14,
1.81486770056694E-14,
4.3232778468294E-14,
1.92909924146001E-14,
4.97709512492506E-14,
2.34274405430668E-14,
6.0883589836358E-14,
2.67650485108462E-14,
7.04184974220645E-14,
0.809856374378842,
7.54249093737336E-14,
0.428999611070099,
7.47370915155088E-14,
0.340183093211855,
7.3448191972858E-14,
0.299888339873646,
7.38298311375729E-14,
0.278360219293801,
8.53084963781114E-14,
0.26711835792524,
9.39578276293318E-14,
0.263134989537203,
1.01583672029726E-13,
0.265638880106233,
1.05361899760403E-13,
0.275480671978012,
1.20344706422415E-13,
0.295794902731318,
1.31382751900055E-13,
0.335245455194899,
1.41249859031412E-13,
0.423994760591971,
1.47904258285259E-13,
0.807254029405934,
1.50671142229442E-13,
5.3330603821955E-14,
1.46096676423291E-13,
4.69485561538363E-14,
1.49725717935034E-13,
4.43950431971984E-14,
1.55004481472432E-13,
5.63472879466786E-14,
1.75803815949394E-13,
5.98045918343004E-14,
1.81158907319734E-13,
4.86451157133416E-14,
1.76091780046406E-13,
1.45007703761246E-14,
1.43032287402978E-14,
3.3356997719558E-14,
2.42722508758675E-14,
4.81489847992123E-14,
2.44197023713255E-14,
5.17719547787898E-14,
2.52020626589911E-14,
6.20935594608518E-14,
2.74719483273067E-14,
7.2927774930065E-14,
3.80502920838133E-14,
7.84389914132433E-14,
0.809419046495733,
8.00748356510894E-14,
0.428113577233339,
7.96723798046628E-14,
0.339222491459085,
7.61699731066656E-14,
0.298953027858643,
8.46024639233889E-14,
0.277490118370093,
9.07034863883993E-14,
0.266330200085857,
1.01583672029726E-13,
0.262435126642423,
1.08753284155938E-13,
0.265028959582234,
1.20932777680771E-13,
0.274960594967205,
1.28765054174806E-13,
0.295364769345851,
1.34956282260568E-13,
0.334907631167869,
1.42141506898064E-13,
0.423758501173542,
1.47567721930919E-13,
0.807166266169749,
1.42486716869783E-13,
4.57515969554123E-14,
1.47167000807968E-13,
4.18363260701327E-14,
1.50990331349021E-13,
4.99721791724639E-14,
1.67929906091935E-13,
5.16149623042139E-14,
1.79115403065033E-13,
4.71168243310061E-14,
1.76017186936939E-13,
3.9569042487031E-14,
  0,
2.63422096635768E-14,
2.26702337458029E-14,
4.6070786074992E-14,
3.08572611906754E-14,
5.70420446988074E-14,
3.05346026241438E-14,
6.43044645309843E-14,
2.9246570443231E-14,
7.43762690325056E-14,
3.88283155627889E-14,
8.12631212321335E-14,
3.95751140191969E-14,
8.30785093497433E-14,
0.809052287353909,
8.50014503228635E-14,
0.42736188335606,
8.22085455265409E-14,
0.338399110663084,
8.66407640076616E-14,
0.298144246419434,
9.01691915577985E-14,
0.276731984167221,
9.82547376793264E-14,
0.265638880106233,
1.08810530030645E-13,
0.261817632226798,
1.24544471957755E-13,
0.264487992747751,
1.29512719992952E-13,
0.27449713651969,
1.32635222249711E-13,
0.294979826485892,
1.35861807915028E-13,
0.334604125336328,
1.41683539900406E-13,
0.423545486759995,
1.38833389229376E-13,
0.80708686682764,
1.43596939894408E-13,
4.05508959744338E-14,
1.48341408601205E-13,
4.7418666215826E-14,
1.63868918434673E-13,
4.52242410187154E-14,
1.71166900098108E-13,
3.89410725887274E-14,
1.73909497913627E-13,
3.80459552751233E-14,
1.75226153031893E-13,
1.58837786673471E-14,
2.0196084388191E-14,
4.06003355934992E-14,
2.98381111485391E-14,
5.55900811494148E-14,
3.72254310709863E-14,
6.99110908053413E-14,
3.47352355212216E-14,
7.67866673023754E-14,
4.08093697723544E-14,
8.29267210455953E-14,
4.02481867278759E-14,
8.61324900292004E-14,
4.10279449303275E-14,
8.78516009938934E-14,
0.808741373903882,
8.73797562084278E-14,
0.426718167800698,
9.33905730526874E-14,
0.337687565556663,
9.24729043338957E-14,
0.297439814166363,
9.77187081252495E-14,
0.276067133923093,
1.05316796950028E-13,
0.265028959582234,
1.24534063616899E-13,
0.261269918629994,
1.32756652893029E-13,
0.264005849595372,
1.33238906019351E-13,
0.274082280337449,
1.33547686798074E-13,
0.294633894040766,
1.35476699303361E-13,
0.334330395476859,
1.33245844913255E-13,
0.42335273468008,
1.40080655408603E-13,
0.80701479102058,
1.4468287679037E-13,
4.61956861652624E-14,
1.61304997137179E-13,
4.27331781072127E-14,
1.67161423592077E-13,
3.25902499431763E-14,
1.65919361583278E-13,
2.99569397066435E-14,
1.73057748686922E-13,
2.8348851044413E-14,
1.37476835471162E-14,
3.38730779536611E-14,
2.84373219416878E-14,
5.10268910458578E-14,
3.66338903656782E-14,
6.89405130205323E-14,
4.15639744844043E-14,
8.27497792510457E-14,
4.64316085579952E-14,
8.55400819621543E-14,
4.23810292415894E-14,
8.77778752461644E-14,
4.17860190893293E-14,
9.08292538404076E-14,
4.03670152859803E-14,
9.08630809481892E-14,
0.808475296787326,
9.84507614321117E-14,
0.426162333021363,
9.86329073970893E-14,
0.337068164487874,
1.00008543113539E-13,
0.296822269090484,
1.0454831445017E-13,
0.275480671978013,
1.20950124915531E-13,
0.264487992747751,
1.32787877915597E-13,
0.260781739119795,
1.36831518338099E-13,
0.263574212628889,
1.34111471927767E-13,
0.273709393596575,
1.32850327960732E-13,
0.294321823001214,
1.26860327798184E-13,
0.334082633470579,
1.34333516532692E-13,
0.423177730030186,
1.41341799375638E-13,
0.806949156677073,
1.57429624891847E-13,
4.14963202688412E-14,
1.64491684162549E-13,
2.9995103623115E-14,
1.61851435032112E-13,
2.34447877778265E-14,
1.65015570652294E-13,
2.01384048326148E-14,
1.79592452020927E-13,
2.31973728420654E-14,
2.50363965670353E-14,
4.62130334000221E-14,
3.59573482100473E-14,
6.51726936307107E-14,
4.13159090273396E-14,
8.21747184187593E-14,
5.34147379105399E-14,
9.17061565575139E-14,
4.80544423697715E-14,
9.05690453190111E-14,
4.3976974839488E-14,
9.28068386030212E-14,
4.13332562620994E-14,
9.39266026067642E-14,
4.80414319437017E-14,
1.01625305393149E-13,
0.80824567515255,
1.04286371205298E-13,
0.425678817754558,
1.06177219794112E-13,
0.336525424688196,
1.06808659139368E-13,
0.29627769952717,
1.2043317731969E-13,
0.274960594967205,
1.29568231144184E-13,
0.264005849595372,
1.36890498936282E-13,
0.26034467944808,
1.37679798117851E-13,
0.263186197771348,
1.33913713451506E-13,
0.273372947609622,
1.24367530163205E-13,
0.294039294024709,
1.28036470314896E-13,
0.333857626260574,
1.35410779811274E-13,
0.423018339626935,
1.54489268600067E-13,
0.806889211743026,
1.60781110647434E-13,
2.86767137813726E-14,
1.59037713554078E-13,
2.09363776315641E-14,
1.60900806567277E-13,
1.36973765663129E-14,
1.71473946153355E-13,
1.37424793766883E-14,
1.51146456461859E-14,
4.06254890839008E-14,
3.38184341641679E-14,
6.14733958181901E-14,
4.1135497785838E-14,
7.89594084560363E-14,
5.34312177835616E-14,
9.15196737838464E-14,
5.52075746229619E-14,
9.70144103940029E-14,
4.96842150754517E-14,
9.58191859190549E-14,
4.34270674976034E-14,
9.5813981748627E-14,
4.88515478069829E-14,
1.04959443913977E-13,
5.80958892104633E-14,
1.07049785702529E-13,
0.808046028210886,
1.12063136548102E-13,
0.425255406531269,
1.12902742710475E-13,
0.33604702487731,
1.22695256732364E-13,
0.295794902731318,
1.2882403477299E-13,
0.27449713651969,
1.33238906019351E-13,
0.263574212628889,
1.37672859223947E-13,
0.259951774777442,
1.37116012988159E-13,
0.26283606536831,
1.25198462708198E-13,
0.273068302631237,
1.25493365699114E-13,
0.293782660791502,
1.29207408661181E-13,
0.333652646808942,
1.4825293770393E-13,
0.422872744005902,
1.56648999327658E-13,
0.80683431167241,
1.55349691444151E-13,
1.95711502559703E-14,
1.58071472577959E-13,
1.11317205453432E-14,
1.67374794579622E-13,
  0,
1.69565750329781E-13,
2.37275477044108E-14,
2.73990899413157E-14,
5.81201753391269E-14,
3.98179753058336E-14,
7.61812488092595E-14,
5.3626374174609E-14,
8.88039641822047E-14,
5.54747220382623E-14,
9.7082931971304E-14,
5.69396960137247E-14,
1.02368634402605E-13,
4.93164536985446E-14,
9.8953831240145E-14,
5.09852576824343E-14,
1.06933559229638E-13,
5.89094745206964E-14,
1.10498415972771E-13,
6.34457764103757E-14,
1.149011441548E-13,
0.80787127436887,
1.18675902438525E-13,
0.42488239205388,
1.28947200139784E-13,
0.335623052721033,
1.31396629687863E-13,
0.295364769345851,
1.32631752802759E-13,
0.274082280337449,
1.34135758056431E-13,
0.263186197771348,
1.37136829669871E-13,
0.259597217602654,
1.28428517820467E-13,
0.26251899745394,
1.2593051601506E-13,
0.272791540399281,
1.26494301144753E-13,
0.293548827047746,
1.41801501096772E-13,
0.333465367831511,
1.51415338600636E-13,
0.422739383240477,
1.51968715389472E-13,
0.806783901366788,
1.5440600187322E-13,
  0,
1.64559338378112E-13,
  0,
1.65407618157865E-13,
  0,
1.65043759908778E-14,
4.67841911044875E-14,
3.48033234176537E-14,
7.42140723875018E-14,
5.28969229529608E-14,
8.66511723485175E-14,
5.59873328254135E-14,
9.47306469378795E-14,
5.74219491400463E-14,
1.02797111101172E-13,
5.66682117897344E-14,
1.05668945815651E-13,
5.69145425233231E-14,
1.10128919872388E-13,
6.11646150394662E-14,
1.12602635549131E-13,
6.45056924541976E-14,
1.18164159013112E-13,
6.8290859078779E-14,
1.21676974051965E-13,
0.807717379468084,
1.34434130494299E-13,
0.424551974778311,
1.37364078445223E-13,
0.335245455194899,
1.34928526684952E-13,
0.294979826485892,
1.33523400669411E-13,
0.273709393596575,
1.33927591239313E-13,
0.26283606536831,
1.28449334502179E-13,
0.259276132608704,
1.29356594880115E-13,
0.262230924354827,
1.27189925258619E-13,
0.272539332606123,
1.39376357677357E-13,
0.293335149252723,
1.45055842337705E-13,
0.333293792997873,
1.45777487303711E-13,
0.422616913442355,
1.50804715937092E-13,
0.806737500580545,
1.60635393875452E-13,
  0,
1.62599100850258E-13,
  0,
1.61426427780498E-13,
3.02709246557953E-14,
2.76324102488346E-14,
6.54363715990591E-14,
4.88168533374633E-14,
8.56944723515163E-14,
5.57019708136153E-14,
9.31017415939372E-14,
5.81947684485939E-14,
1.00683350545694E-13,
5.73213351784396E-14,
1.06216251072322E-13,
6.44354361534205E-14,
1.17038323477203E-13,
6.7090430433403E-14,
1.15935039346482E-13,
6.67504246321116E-14,
1.20412360637978E-13,
6.92293444792824E-14,
1.25257443306381E-13,
7.27109344955679E-14,
1.37894903828872E-13,
0.807581105052999,
1.432725466044E-13,
0.424257825301551,
1.41256797925315E-13,
0.334907631167869,
1.35920788513211E-13,
0.294633894040766,
1.32760122339981E-13,
0.273372947609622,
1.25259178029857E-13,
0.26251899745394,
1.29346186539259E-13,
0.258984401376508,
1.30555288802015E-13,
0.261968388447238,
1.39950551147905E-13,
0.272308836698804,
1.4253528912711E-13,
0.293139358877436,
1.39489114703295E-13,
0.33313620164583,
1.44939615864814E-13,
0.422504171589148,
1.57205845563446E-13,
0.806694692047824,
1.58756688350969E-13,
  0,
1.58515561787809E-13,
-1.2562867413024E-14,
1.53987066153771E-14,
5.57631198161435E-14,
4.32358142343769E-14,
7.84971046496885E-14,
5.23322704615303E-14,
9.2897044223772E-14,
5.83161990919123E-14,
9.94855239855319E-14,
5.83101275597464E-14,
1.04501476916319E-13,
6.51969797593743E-14,
1.17824153211821E-13,
7.46971928755613E-14,
1.22965873594616E-13,
7.28184873510784E-14,
1.23774254734421E-13,
7.15434655962355E-14,
1.27649626979753E-13,
7.38038102854333E-14,
1.41249859031412E-13,
7.37864630506735E-14,
1.46136575063238E-13,
0.807459825166117,
1.46771483855446E-13,
0.423994760591971,
1.42129363833732E-13,
0.334604125336328,
1.35407310364322E-13,
0.294321823001214,
1.24370999610157E-13,
0.273068302631237,
1.2594786324982E-13,
0.262230924354827,
1.30610799953246E-13,
0.258718524631833,
1.43404385588575E-13,
0.261728436185799,
1.43047032552523E-13,
0.272097612668441,
1.37017133750028E-13,
0.292959499922668,
1.3837889167867E-13,
0.332991104042456,
1.51339010767693E-13,
0.422400146895856,
1.55365303955435E-13,
0.806655111762898,
1.54791110484886E-13,
-1.37181932480246E-14,
1.51875040321769E-13,
3.41220107724638E-14,
3.4779470969859E-14,
7.17711480524574E-14,
4.7719640738908E-14,
8.6763062012718E-14,
5.53316073514942E-14,
9.98558874476529E-14,
5.86579396166798E-14,
1.03628043646165E-13,
6.63141416779034E-14,
1.16352240342454E-13,
7.56009838065452E-14,
1.23963339593303E-13,
8.0553619330459E-14,
1.31032337757908E-13,
7.77312242350447E-14,
1.31020194693576E-13,
7.6069359145059E-14,
1.43569184318793E-13,
7.48030110075959E-14,
1.4990439445306E-13,
7.1352646013878E-14,
1.50221848849164E-13,
0.807351390981609,
1.47781092918464E-13,
0.423758501173542,
1.41697417688214E-13,
0.334330395476859,
1.26867266692088E-13,
0.294039294024709,
1.25430915653979E-13,
0.272791540399281,
1.27252375303755E-13,
0.261968388447238,
1.43376630012959E-13,
0.25847551306627,
1.46462703076722E-13,
0.261508531853926,
1.37652042542236E-13,
0.271903556105326,
1.36019667751341E-13,
0.29279387832398,
1.44913595012675E-13,
0.332857204941237,
1.49101217483683E-13,
0.422303957367315,
1.50856757641371E-13,
0.806618440976593,
1.48134976507563E-13,
-2.19858853345301E-14,
2.47636113004379E-14,
5.76964691301196E-14,
4.10682772511439E-14,
8.17254250384813E-14,
5.13738357410531E-14,
9.44973266303606E-14,
5.59986085280073E-14,
1.04393924060808E-13,
6.68605795728361E-14,
1.15739882955435E-13,
7.69002916900519E-14,
1.2263627613418E-13,
8.15684325639054E-14,
1.32126948271249E-13,
8.54611520439974E-14,
1.38401443083858E-13,
8.22501788899643E-14,
1.471791438723E-13,
7.7262848896531E-14,
1.52348619830711E-13,
7.24576648680753E-14,
1.53797113933152E-13,
6.82804507379231E-14,
1.51146456461859E-13,
0.807254029405934,
1.47567721930919E-13,
0.423545486759995,
1.33287478276678E-13,
0.334082633470579,
1.28003510568853E-13,
0.293782660791502,
1.26470015016089E-13,
0.272539332606123,
1.39955755318333E-13,
0.261728436185799,
1.46490458652337E-13,
0.258252800113823,
1.40882097654504E-13,
0.261306488153791,
1.3660253483927E-13,
0.271724843965436,
1.42205691666675E-13,
0.292641020714176,
1.42826722671074E-13,
0.33273337371342,
1.45378500904236E-13,
0.422214830481594,
1.44415729375069E-13,
0.806584399569252,
1.45009004803853E-13,
3.25230294084822E-14,
3.62310008383826E-14,
7.07454927972861E-14,
4.57446580615084E-14,
9.05473612755614E-14,
5.24623747222286E-14,
9.95974136497324E-14,
6.44605896438222E-14,
1.16921229642575E-13,
7.7640151252556E-14,
1.22268514757273E-13,
8.29770280263986E-14,
1.31004582182292E-13,
8.66216820494259E-14,
1.39626157857897E-13,
9.01518443230387E-14,
1.54622842307717E-13,
8.34540769822922E-14,
1.55944701596411E-13,
7.4867195776207E-14,
1.56185828159572E-13,
6.94184293381639E-14,
1.54874377211733E-13,
6.24274937299774E-14,
1.50690224187677E-13,
0.807166266169749,
1.38847267017184E-13,
0.42335273468008,
1.34359537384832E-13,
0.333857626260574,
1.29228225342892E-13,
0.293548827047746,
1.39431868828588E-13,
0.272308836698804,
1.43116421491563E-13,
0.261508531853926,
1.40885567101456E-13,
0.258048171750398,
1.40000858128708E-13,
0.261120409960629,
1.42883968545782E-13,
0.271559890348772,
1.40222902733633E-13,
0.292499640606333,
1.38833389229376E-13,
0.332618619725574,
1.38337258315246E-13,
0.422132087188918,
1.41803235820248E-13,
0.806552740534775,
1.71000366644414E-14,
5.28956219103538E-14,
4.27409843628546E-14,
8.12483760825877E-14,
4.74837183461752E-14,
9.64662377755943E-14,
6.12773720654047E-14,
1.1262431959258E-13,
7.55099108240564E-14,
1.23772520010945E-13,
8.3847859211339E-14,
1.30864069580738E-13,
8.80788497692464E-14,
1.3863736547659E-13,
9.13141090519431E-14,
1.55946436319887E-13,
9.13730896501264E-14,
1.63431768118727E-13,
8.1152098929671E-14,
1.59970994784153E-13,
7.1880001950575E-14,
1.57323806759813E-13,
6.36851682500605E-14,
1.54364368509796E-13,
5.32768273941997E-14,
1.42469369635023E-13,
0.80708686682764,
1.40104941537267E-13,
0.423177730030186,
1.35379554788706E-13,
0.333652646808942,
1.41773745521157E-13,
0.293335149252723,
1.42531819680158E-13,
0.272097612668441,
1.3762428696662E-13,
0.261306488153791,
1.39966163659189E-13,
0.25785970960248,
1.4629963906998E-13,
0.260948648448888,
1.40949751870068E-13,
0.271407310221102,
1.36279876272738E-13,
0.292368610502271,
1.32033273203547E-13,
0.332512071931026,
1.3564496748053E-13,
0.422055128588099,
1.42174466644107E-13,
2.85431400737224E-14,
2.76562626966292E-14,
6.62360791214844E-14,
4.54809800931599E-14,
8.82401790525122E-14,
5.67237229409656E-14,
1.10042183698589E-13,
7.26042490017953E-14,
1.19839034529168E-13,
8.19214487912667E-14,
1.32685529230514E-13,
8.9154378324352E-14,
1.3868940718087E-13,
9.29534227367412E-14,
1.5510856488099E-13,
9.26446419580174E-14,
1.64819546899508E-13,
8.91318269191643E-14,
1.67499694669893E-13,
7.81891912327026E-14,
1.61091626149634E-13,
6.61849047789431E-14,
1.56971657894189E-13,
5.43853156953489E-14,
1.46042899995535E-13,
4.57481275084604E-14,
1.43565714871841E-13,
0.80701479102058,
1.41390371632966E-13,
0.423018339626935,
1.48239059916122E-13,
0.333465367831511,
1.45028086762089E-13,
0.293139358877436,
1.36996317068316E-13,
0.271903556105326,
1.36548758411514E-13,
0.261120409960629,
1.46244127918749E-13,
0.257685744542867,
1.44325523754318E-13,
0.260789763449843,
1.36914785064945E-13,
0.271265889481588,
1.29445065777389E-13,
0.292246938763384,
1.29389554626158E-13,
0.332412961866806,
1.36161915076372E-13,
0.421983424778094,
1.48355720069882E-14,
4.85020010265735E-14,
3.19414633631609E-14,
7.49166353952724E-14,
5.53437504158261E-14,
1.02641853350072E-13,
6.84313716803331E-14,
1.1775996844321E-13,
7.92621177025943E-14,
1.2906516133615E-13,
8.73780214849518E-14,
1.40708625306907E-13,
9.41226263595496E-14,
1.55377447019767E-13,
9.43533445818545E-14,
1.64158617255161E-13,
9.04415431435268E-14,
1.69071354139128E-13,
8.62504512255668E-14,
1.68799002553399E-13,
7.25600135531579E-14,
1.60758559242247E-13,
5.69440328224147E-14,
1.48646719932977E-13,
4.69797811764039E-14,
1.47108020209785E-13,
4.05786515500495E-14,
1.44738387941601E-13,
0.806949156677073,
1.54489268600067E-13,
0.422872744005902,
1.51415338600636E-13,
0.333293792997873,
1.39485645256343E-13,
0.292959499922668,
1.36054362220861E-13,
0.271724843965436,
1.42883968545782E-13,
0.260948648448888,
1.44240522303996E-13,
0.257524818610114,
1.39832589951538E-13,
0.260642492387017,
1.30107730145212E-13,
0.271134560132864,
1.26825633328664E-13,
0.292133750332425,
1.2971221319269E-13,
0.332320609418938,
1.3594680936535E-13,
2.74697799229617E-14,
2.24876540999563E-14,
5.98176022603703E-14,
4.27531274271864E-14,
9.03886340775095E-14,
6.75692141127726E-14,
1.11021435100778E-13,
7.54301135441615E-14,
1.27446664333064E-13,
8.50075218550295E-14,
1.3743867155469E-13,
9.25284154851269E-14,
1.57564933322973E-13,
9.56561219123131E-14,
1.64635666211055E-13,
9.22040221951193E-14,
1.68517977350291E-13,
8.7582718855117E-14,
1.70377600916538E-13,
8.0553619330459E-14,
1.68476343986868E-13,
6.32809776801579E-14,
1.52593215840824E-13,
4.94517621296708E-14,
1.49767351298458E-13,
4.1808570494517E-14,
1.48341408601205E-13,
4.61956861652624E-14,
1.57394930422328E-13,
0.806889211743026,
1.56572671494715E-13,
0.422739383240477,
1.45768813686331E-13,
0.33313620164583,
1.38384095849098E-13,
0.29279387832398,
1.42188344431915E-13,
0.271559890348772,
1.40842199014557E-13,
0.260789763449843,
1.39770139906403E-13,
0.257375653580107,
1.33670852164869E-13,
0.260505724501886,
1.27387683734881E-13,
0.271012379578757,
1.27307886454986E-13,
0.292028270587419,
1.29247307301128E-13,
0.332234410850476,
1.11113375445004E-14,
4.49735734764367E-14,
3.46441625387328E-14,
7.68482499857726E-14,
5.56169693632924E-14,
9.9625169225348E-14,
7.49868916960494E-14,
1.21194720925644E-13,
8.13940928545698E-14,
1.36156710905944E-13,
9.03010305419727E-14,
1.54549983921726E-13,
9.42249750446322E-14,
1.67064279077422E-13,
9.36230259984683E-14,
1.69076558309555E-13,
8.94631591030759E-14,
1.69959532558828E-13,
8.19413981112405E-14,
1.70209332739368E-13,
7.12867265217909E-14,
1.60272836668973E-13,
5.57730944761303E-14,
1.53654866608122E-13,
4.43811654093906E-14,
1.50990331349021E-13,
4.74325440036338E-14,
1.61304997137179E-13,
4.14963202688412E-14,
1.60786314817862E-13,
0.80683431167241,
1.51966980665996E-13,
0.422616913442355,
1.4494135058829E-13,
0.332991104042456,
1.44911860289199E-13,
0.292641020714176,
1.40219433286681E-13,
0.271407310221102,
1.36890498936282E-13,
0.260642492387017,
1.33677791058773E-13,
0.257237124888155,
1.3074263893742E-13,
0.260378479360189,
1.27717281195316E-13,
0.270898513280393,
1.2683604166952E-13,
0.291929811756892,
1.2637460522491E-13,
2.44836702995022E-14,
2.6104552547368E-14,
6.45724793080227E-14,
4.84204690232026E-14,
8.71828650939044E-14,
6.3501287561607E-14,
1.10442037459801E-13,
8.12717948495134E-14,
1.30364469219657E-13,
8.69200544872939E-14,
1.5362537630903E-13,
9.20877957222288E-14,
1.64259231216768E-13,
9.22439208350667E-14,
1.71701194928708E-13,
9.08925712472808E-14,
1.7066556501355E-13,
8.38600022756708E-14,
1.69895347790217E-13,
7.26640969617165E-14,
1.62075214360513E-13,
6.38534364272303E-14,
1.61452448632637E-13,
5.06834157976144E-14,
1.54969787002912E-13,
4.99583013846561E-14,
1.63872387881625E-13,
4.27609336828283E-14,
1.64489949439073E-13,
2.86073248423335E-14,
1.55478060981373E-13,
0.806783901366788,
1.50770021467572E-13,
0.422504171589148,
1.51276560722557E-13,
0.332857204941237,
1.42772946243319E-13,
0.292499640606333,
1.36328448530065E-13,
0.271265889481588,
1.30128546826924E-13,
0.260505724501886,
1.30773863959988E-13,
0.257108239880743,
1.31117339208231E-13,
0.260259888841868,
1.27595850551998E-13,
0.270792220159652,
1.23484555913933E-13,
0.291837761440468,
1.90197250310442E-14,
4.9963505555084E-14,
4.14199924358982E-14,
7.65073768227431E-14,
5.70307689962135E-14,
9.88141860003289E-14,
7.02372188188249E-14,
1.2014868266963E-13,
8.71152108783413E-14,
1.48200895999651E-13,
8.89201906550952E-14,
1.63582689061137E-13,
9.03079694358766E-14,
1.69097374991267E-13,
8.9681734261049E-14,
1.73387346147358E-13,
8.54056408927661E-14,
1.70662095566598E-13,
7.46191303191424E-14,
1.61870516990348E-13,
6.53366249991905E-14,
1.63280847176317E-13,
5.88175341764696E-14,
1.62809002390851E-13,
5.63611657344865E-14,
1.67926436644983E-13,
4.52242410187154E-14,
1.67133668016461E-13,
3.00072466874468E-14,
1.5904985661841E-13,
1.95572724681625E-14,
1.54383450468032E-13,
0.806737500580545,
1.57223192798206E-13,
0.422400146895856,
1.49087339695875E-13,
0.33273337371342,
1.38833389229376E-13,
0.292368610502271,
1.29452004671293E-13,
0.271134560132864,
1.27387683734881E-13,
0.260378479360189,
1.31113869761279E-13,
0.256988119591139,
1.30655902763621E-13,
0.260149181981403,
1.23890481207312E-13,
0.270692840261626,
1.21853915846515E-13,
3.32340491931982E-14,
3.86596137047501E-14,
6.46383988001098E-14,
5.10607181536393E-14,
8.92575943711726E-14,
6.42715047849407E-14,
1.09167883066696E-13,
7.64544677567258E-14,
1.38408381977762E-13,
8.93313201189017E-14,
1.58496479829573E-13,
8.72635297355373E-14,
1.68700123315269E-13,
8.77509870322868E-14,
1.70979549962702E-13,
8.42728664629533E-14,
1.73564287941907E-13,
7.62844648560801E-14,
1.62750021792668E-13,
6.72916583566163E-14,
1.63166355426902E-13,
6.02920491310499E-14,
1.64736280172662E-13,
6.44970188368177E-14,
1.75817693737201E-13,
5.16427178798295E-14,
1.71166900098108E-13,
3.25312693449931E-14,
1.61875721160776E-13,
2.0941581801992E-14,
1.58099228153574E-13,
  0,
1.60607638299837E-13,
0.806694692047824,
1.55335813656343E-13,
0.422303957367315,
1.45380235627712E-13,
0.332618619725574,
1.32102662142586E-13,
0.292246938763384,
1.26822163881712E-13,
0.271012379578757,
1.27665239491037E-13,
0.260259888841868,
1.30659372210573E-13,
0.256875983398457,
1.27606258892854E-13,
0.260045672152323,
1.226276025168E-13,
0.270599784283708,
2.56246846658259E-14,
5.51347162369709E-14,
5.03156544207073E-14,
7.89594084560363E-14,
5.90491197605125E-14,
1.00389314916516E-13,
7.0908556804028E-14,
1.27992234866259E-13,
7.89403264978006E-14,
1.49118564718442E-13,
8.78568051643214E-14,
1.63884530945957E-13,
8.48817544030211E-14,
1.70771383145585E-13,
8.24895707296491E-14,
1.71298739082282E-13,
7.51412820854114E-14,
1.6576323647044E-13,
6.89084206362267E-14,
1.64181168660349E-13,
6.22609602762836E-14,
1.64640870381483E-13,
6.60287796661052E-14,
1.77751910412915E-13,
5.98184696221082E-14,
1.79101525277225E-13,
3.89549503765352E-14,
1.65912422689374E-13,
2.34482572247785E-14,
1.60914684355085E-13,
1.11594761209588E-14,
1.64531582802496E-13,
  0,
1.58723728604926E-13,
0.806655111762898,
1.50877574323083E-13,
0.422214830481594,
1.38264399929255E-13,
0.332512071931026,
1.29344451815783E-13,
0.292133750332425,
1.27290539220226E-13,
0.270898513280393,
1.27592381105046E-13,
0.260149181981403,
1.2761666723371E-13,
0.256771136058294,
1.25739696432703E-13,
0.259948746189122,
1.19806942144862E-13,
3.044136123731E-14,
4.28671854957319E-14,
7.23665918855865E-14,
5.95079541199084E-14,
9.12100256433845E-14,
6.62057214606548E-14,
1.19864188019569E-13,
7.37136046646825E-14,
1.39119618602912E-13,
7.76670394664336E-14,
1.54853560530022E-13,
8.55860521342677E-14,
1.66235081255905E-13,
7.96723798046628E-14,
1.71255370995382E-13,
7.34551308667619E-14,
1.63613914083705E-13,
6.7839830975025E-14,
1.67222138913736E-13,
6.39609892827409E-14,
1.65695582254877E-13,
6.80133033226227E-14,
1.776807867504E-13,
6.12739026184528E-14,
1.81158907319734E-13,
4.71445799066217E-14,
1.73923375701435E-13,
2.99014285554122E-14,
1.65045060951385E-13,
1.36956418428369E-14,
1.67374794579622E-13,
  0,
1.62595631403306E-13,
  0,
1.54782436867507E-13,
0.806618440976593,
1.44415729375069E-13,
0.422132087188918,
1.35606803564059E-13,
0.332412961866806,
1.29774663237825E-13,
0.292028270587419,
1.26849919457328E-13,
0.270792220159652,
1.23945992358543E-13,
0.260045672152323,
1.25767452008319E-13,
0.256672956693485,
1.23196591816921E-13,
0.259857855117662,
2.38877927855041E-14,
5.4750908667911E-14,
5.4302048968502E-14,
8.63779534010511E-14,
6.74443140225023E-14,
1.11568740357448E-13,
6.94748078511331E-14,
1.31574438844151E-13,
7.26901178138561E-14,
1.45246661920062E-13,
7.55923101891653E-14,
1.57450441573559E-13,
8.05328026487473E-14,
1.66923766475868E-13,
7.07385539033822E-14,
1.63768304473066E-13,
6.62560284414582E-14,
1.65220268022459E-13,
6.29357677084386E-14,
1.68892677621102E-13,
6.97272101168878E-14,
1.78848255649733E-13,
6.33833263652406E-14,
1.81158907319734E-13,
4.8619094861202E-14,
1.76005043872607E-13,
3.8070241403787E-14,
1.73092443156442E-13,
2.01835076429902E-14,
1.71473946153355E-13,
  0,
1.65400679263961E-13,
  0,
1.58515561787809E-13,
-1.37181932480246E-14,
1.48141915401467E-13,
0.806584399569252,
1.41813644161104E-13,
0.422055128588099,
1.36161915076372E-13,
0.332320609418938,
1.2925077674808E-13,
0.291929811756892,
1.23484555913933E-13,
0.270692840261626,
1.22544335789954E-13,
0.259948746189122,
1.23224347392537E-13,
0.256580889412337,
1.19147747223991E-13,
3.27856231746582E-14,
4.07824815584767E-14,
7.17533671368287E-14,
6.35680744154321E-14,
1.07942300930919E-13,
7.1280654989625E-14,
1.24006707680202E-13,
6.87254073095112E-14,
1.38156847073745E-13,
7.07905956076615E-14,
1.48197426552699E-13,
7.06448788356795E-14,
1.58397600591442E-13,
7.17204073907851E-14,
1.59611907024626E-13,
6.36383307162092E-14,
1.65496089055139E-13,
6.13727818565835E-14,
1.669792776271E-13,
6.87627038642447E-14,
1.82118209401949E-13,
6.50642734134621E-14,
1.82361070688586E-13,
5.07354575018937E-14,
1.76079636982074E-13,
3.95967980626466E-14,
1.75240030819701E-13,
2.83731371730767E-14,
1.79618472873067E-13,
1.37494182705922E-14,
1.69614322587108E-13,
  0,
1.61464591696969E-13,
-1.2562867413024E-14,
1.51899326450433E-13,
-2.20379270388094E-14,
1.45009004803853E-13,
0.806552740534775,
1.4228548894657E-13,
0.421983424778094,
1.3594680936535E-13,
0.332234410850476,
1.26388483012718E-13,
0.291837761440468,
1.21850446399563E-13,
0.270599784283708,
1.19862453296093E-13,
0.259857855117662,
1.19144277777039E-13,
0.256494435284096,
  0,
  0,
  0,
  0,
  0,
  0,
-1.30801402695169E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.27643121766718E-14,
1.13639566506896E-14,
1.77384149036008E-14,
1.70100478841251E-14,
2.36512198714678E-14,
1.82978632246034E-14,
2.54277935513025E-14,
1.34742477592154E-14,
2.39988150879666E-14,
1.38467796256814E-14,
3.18820490841087E-14,
2.05889992554997E-14,
3.38572486019428E-14,
1.92794998715717E-14,
2.84750521772903E-14,
1.56769128928369E-14,
2.87281049643484E-14,
1.06180255560195E-14,
2.33391864862265E-14,
1.67131933292985E-14,
3.28584815606492E-14,
2.37646274187098E-14,
3.61633466228195E-14,
2.60434035448398E-14,
3.36150378366096E-14,
1.91071117261465E-14,
  0,
  0,
  0,
  0,
  0,
-1.48759043278046E-14,
-1.36039183390446E-14,
-1.81254750791782E-14,
-1.555700013256E-14,
  0,
-1.0772199104947E-14,
  0,
0.86666666666666,
  0,
0.866578244826234,
  0,
  0,
  0,
  0,
  0,
  0,
1.3765464462745E-14,
  0,
1.89748390611033E-14,
1.33395898493927E-14,
2.64094301982709E-14,
2.45615160154866E-14,
3.5825075545004E-14,
3.05632255614974E-14,
4.24998577996938E-14,
2.74754177742587E-14,
4.27904239819199E-14,
2.36676997444896E-14,
4.83814377449931E-14,
2.98472184467879E-14,
5.69340581624278E-14,
3.45426812153882E-14,
5.39976049984681E-14,
3.02600826340704E-14,
4.95623507512644E-14,
2.2735285876152E-14,
4.5098473566707E-14,
2.36776744044764E-14,
4.86867490767651E-14,
3.5076976045989E-14,
5.9762958470877E-14,
4.31516801457921E-14,
6.04212860300102E-14,
3.90997997867792E-14,
5.52804330089529E-14,
  0,
  0,
  0,
  0,
-1.24271253010289E-14,
  0,
-1.73693524840868E-14,
-1.83152104593631E-14,
-1.80799385879338E-14,
-1.56814665419613E-14,
  0,
0.839875767210725,
  0,
0.561330168144766,
  0,
0.83952731128995,
  0,
-1.12453449330197E-14,
  0,
  0,
1.44198888940572E-14,
  0,
2.14351106309074E-14,
1.14630527292547E-14,
2.96629040774654E-14,
2.40662524630952E-14,
4.04567872258621E-14,
3.43809182512533E-14,
4.94604357470507E-14,
3.58081619911133E-14,
5.41428880895811E-14,
3.44945426389298E-14,
6.14885746486049E-14,
3.63068949904566E-14,
6.63705201908726E-14,
3.93101350082414E-14,
6.95849627918577E-14,
4.11875394901173E-14,
6.84573925324727E-14,
3.38245056963338E-14,
5.95305055250961E-14,
3.31418920085369E-14,
6.4697379398293E-14,
3.82107540053411E-14,
6.82605014179494E-14,
4.91594612239687E-14,
7.59722146304043E-14,
5.05359643021563E-14,
7.44560663124005E-14,
5.06634664776406E-14,
  0,
  0,
  0,
  0,
  0,
-1.43524515189286E-14,
-1.19257902164716E-14,
-1.66598505824123E-14,
-1.76915773697495E-14,
-1.79084178042466E-14,
0.828985507246359,
  0,
0.500167182298014,
  0,
0.499597599026475,
  0,
0.828189580500137,
  0,
  0,
1.35707417525666E-14,
  0,
2.13305935414798E-14,
  0,
3.10996887964432E-14,
2.13383997971217E-14,
4.22656701304369E-14,
3.25928520283902E-14,
5.21570633904567E-14,
3.81144768524244E-14,
5.88565654546791E-14,
4.1290755536938E-14,
7.04748759350338E-14,
4.57550664023643E-14,
7.68074839840871E-14,
4.42207034878628E-14,
7.60355320372774E-14,
4.42276423817667E-14,
8.11156697366755E-14,
4.31330318684253E-14,
7.57041998533659E-14,
4.28303226218674E-14,
7.65654900591883E-14,
4.61896146330965E-14,
8.15606263082636E-14,
5.04058600414581E-14,
8.13507247676704E-14,
5.43835809718729E-14,
8.67769398005258E-14,
5.9986737799278E-14,
9.72624758510676E-14,
  0,
  0,
-1.24271253010289E-14,
  0,
-1.17605578053848E-14,
  0,
-1.346145417358E-14,
-1.09638860490424E-14,
-1.57894530783409E-14,
0.823513595914334,
-1.64742351704827E-14,
0.474901434241775,
  0,
0.4277796585578,
  0,
0.473292058786036,
  0,
0.822049510330789,
1.31808626513408E-14,
  0,
2.01349353856628E-14,
  0,
3.05224595598119E-14,
1.63332888880596E-14,
4.2935273392164E-14,
2.94781560272739E-14,
5.30044758084713E-14,
3.55358104053849E-14,
6.04603173082197E-14,
4.27661378532562E-14,
7.3825494328883E-14,
5.16505241354714E-14,
8.42589886751455E-14,
5.26601331984899E-14,
8.49311940220865E-14,
4.81515868844262E-14,
8.59243232120832E-14,
4.52155674013355E-14,
8.67700009066219E-14,
5.1238527309927E-14,
9.11553818538913E-14,
5.49872647415128E-14,
9.17859538374088E-14,
5.73898567557407E-14,
9.29404123106714E-14,
5.44850622952175E-14,
9.04051139505313E-14,
6.26113744184309E-14,
1.0768295977126E-13,
6.90992402185842E-14,
  0,
-1.48906494773504E-14,
  0,
-1.43524515189286E-14,
  0,
-1.06477326955456E-14,
  0,
-1.26699865876656E-14,
0.820653100894044,
-1.45183344513189E-14,
0.462071035628456,
-1.51246203061728E-14,
0.397288029431201,
  0,
0.396065602663699,
  0,
0.458880237300692,
1.1142996247937E-14,
0.81824467719433,
1.9595436384634E-14,
  0,
2.90366689026378E-14,
1.3313135316384E-14,
4.18692858161762E-14,
2.40927069961039E-14,
5.31198349196238E-14,
3.19284529370911E-14,
6.06025646332498E-14,
3.97615967928644E-14,
7.45809664026709E-14,
5.25161511499839E-14,
8.66511723485175E-14,
5.79388967358874E-14,
9.13201805841091E-14,
5.60289661888369E-14,
9.37340483009308E-14,
4.85783288595165E-14,
9.05213404234217E-14,
5.27035012853894E-14,
1.01151725884208E-13,
6.27492849347711E-14,
1.05297714991792E-13,
6.5520505687644E-14,
1.02013883451768E-13,
6.07508834904458E-14,
1.00863761787195E-13,
6.19773329879614E-14,
1.10096827488082E-13,
7.08452393971548E-14,
1.26454402504805E-13,
-1.30801402695169E-14,
-1.36386128085642E-14,
-1.73684851223488E-14,
-1.19409690468864E-14,
-1.34575510457591E-14,
  0,
-1.01099684179928E-14,
0.819400604425264,
-1.13056265738098E-14,
0.455320627801176,
-1.2940169769049E-14,
0.38155677961536,
-1.24388346844917E-14,
0.362699939689734,
  0,
0.378393122162479,
  0,
0.449878280140181,
1.73376937806502E-14,
0.815681087093769,
2.81710418881254E-14,
1.22514845490862E-14,
4.00582345072564E-14,
2.0868723416001E-14,
5.16990963927988E-14,
2.63634600261575E-14,
6.02295990859147E-14,
3.58428564606328E-14,
7.41498876188906E-14,
4.90813986675498E-14,
8.67760724387878E-14,
5.83639039875017E-14,
9.30019949940686E-14,
6.07864453217033E-14,
9.93649607039515E-14,
5.60506502322866E-14,
9.75235517342021E-14,
5.56351839597902E-14,
1.04118103028128E-13,
6.37519551038856E-14,
1.14410217411098E-13,
7.27803234346069E-14,
1.14686038443779E-13,
6.83515744004382E-14,
1.09106300383299E-13,
6.77426864603703E-14,
1.19682042054592E-13,
6.97020566264861E-14,
1.27867334775988E-13,
7.51265369358656E-14,
  0,
-1.81235235152677E-14,
-1.83553259397451E-14,
-1.66884735197659E-14,
-1.09651870916494E-14,
-1.26196796068623E-14,
0.819400604425264,
  0,
0.452354695060273,
  0,
0.373202849064463,
-1.02179549543724E-14,
0.345297955355882,
  0,
0.343208060732594,
  0,
0.36722868407724,
1.52386783747183E-14,
0.443778490025566,
2.57779908530154E-14,
0.81385197558937,
3.91830665136261E-14,
1.98530428208166E-14,
4.9591407369487E-14,
2.29928923123346E-14,
5.85746728898329E-14,
3.00367369865384E-14,
7.34880906128055E-14,
4.49648998590568E-14,
8.5938200999891E-14,
5.45761352777063E-14,
9.25865287215721E-14,
6.08783856659301E-14,
1.00468244834673E-13,
6.04898076073113E-14,
1.02633179732692E-13,
6.27770405103867E-14,
1.10565202826596E-13,
6.63852653404184E-14,
1.16727807975003E-13,
7.33883440129368E-14,
1.23109855643122E-13,
7.52271508974722E-14,
1.21098443772727E-13,
7.4944390970888E-14,
1.27255844750707E-13,
7.50285250594729E-14,
1.36734373823444E-13,
7.35011010388753E-14,
1.36677995310475E-13,
  0,
-1.55292445569444E-14,
-1.80782038644578E-14,
-1.76924447314875E-14,
-1.57911878018169E-14,
0.820653100894044,
-1.13307800642115E-14,
0.452354695060273,
  0,
0.369514170246202,
  0,
0.335995023288569,
  0,
0.324715964742422,
  0,
0.330796910359612,
1.00379773937398E-14,
0.359602670713217,
2.38802033702967E-14,
0.439408012588455,
3.71534400467333E-14,
0.812491196216809,
4.8618227499464E-14,
2.18731283085916E-14,
5.61981017277446E-14,
2.65889740780345E-14,
7.150703640324E-14,
3.90347476564301E-14,
8.4890428020401E-14,
5.02401939495023E-14,
9.13939063318381E-14,
5.6844286222546E-14,
9.96364449279419E-14,
6.02235275537488E-14,
1.03264619077947E-13,
6.69724692370366E-14,
1.15189108251812E-13,
7.31914528984134E-14,
1.22651021283726E-13,
7.56556275960385E-14,
1.24926978484208E-13,
7.54986351214626E-14,
1.29035671037059E-13,
8.14417977501591E-14,
1.38729305820817E-13,
8.18824175130572E-14,
1.43753065007246E-13,
7.85309317574701E-14,
1.44960432546526E-13,
7.12728487339831E-14,
  0,
  0,
-1.5708788436708E-14,
-1.79435459546351E-14,
0.823513595914334,
-1.45460900269345E-14,
0.455320627801176,
  0,
0.369514170246202,
  0,
0.33187235457397,
  0,
0.314782221918911,
  0,
0.311541842568846,
  0,
0.322270339139647,
1.87410850727154E-14,
0.354106206981381,
3.44863027024189E-14,
0.436146154698005,
4.59684373899094E-14,
0.811445977538164,
5.50323675518882E-14,
2.54223725404401E-14,
6.89491866379122E-14,
3.5526269426267E-14,
8.27072785258842E-14,
4.42111625087449E-14,
9.01214866622091E-14,
5.23392093554342E-14,
9.81957570811431E-14,
5.60029453366973E-14,
1.02156998138536E-13,
6.6567411305396E-14,
1.15510032094868E-13,
7.71804495314221E-14,
1.26910634778987E-13,
8.22831386360079E-14,
1.30452940116932E-13,
7.75698949517789E-14,
1.30362734496181E-13,
8.15042477952943E-14,
1.46176473703186E-13,
8.81343609204777E-14,
1.54730395163227E-13,
8.51003295609942E-14,
1.51472584475343E-13,
7.60971147206746E-14,
1.48020484758149E-13,
  0,
-1.08272765753092E-14,
  0,
0.828985507246359,
-1.63640802297582E-14,
0.462071035628456,
-1.29978493246252E-14,
0.373202849064463,
  0,
0.33187235457397,
  0,
0.31036813019475,
  0,
0.30116063718233,
  0,
0.302455514878912,
1.12670289764694E-14,
0.316097955212206,
2.94122365351868E-14,
0.349985409101039,
4.35354877148519E-14,
0.433634445827701,
5.22264523294957E-14,
0.810622603950345,
6.74954883650436E-14,
3.4256451841852E-14,
7.99299862408454E-14,
4.05673758474556E-14,
8.75957292811869E-14,
4.61609916957428E-14,
9.66015462067205E-14,
5.13755704645291E-14,
1.00355487808734E-13,
6.21386622712272E-14,
1.14080619950663E-13,
7.6588041464376E-14,
1.26895022267703E-13,
8.60578969197334E-14,
1.34375149896115E-13,
8.39397995555657E-14,
1.35504454878976E-13,
8.33499935737336E-14,
1.47184348042728E-13,
8.79522149555001E-14,
1.61742147453126E-13,
9.11180852991578E-14,
1.6202490737971E-13,
8.24496720897017E-14,
1.54130180840539E-13,
6.77149308847547E-14,
  0,
  0,
0.839875767210725,
  0,
0.474901434241775,
-1.5181432500011E-14,
0.38155677961536,
-1.02144855074204E-14,
0.335995023288569,
  0,
0.31036813019475,
  0,
0.296538279133769,
  0,
0.291742717215662,
1.32220623338952E-14,
0.29585802419157,
2.16554205123565E-14,
0.311454713779304,
3.83078985199958E-14,
0.346801057784456,
4.99851895985337E-14,
0.431651895079695,
6.47945239129477E-14,
0.809960542669755,
7.82724579595495E-14,
3.90824525520195E-14,
8.48262432517899E-14,
4.24426119249866E-14,
9.40098693336111E-14,
4.51565868031523E-14,
9.86103559919016E-14,
5.74002650965966E-14,
1.12096096294145E-13,
7.20465354042688E-14,
1.25162033515203E-13,
8.52148213104087E-14,
1.34059430223488E-13,
8.75410854916936E-14,
1.39180333924571E-13,
8.95099966369273E-14,
1.52034634881559E-13,
8.96088758750579E-14,
1.62453384078276E-13,
9.07746100509144E-14,
1.68724409443932E-13,
8.83060985445994E-14,
1.64349436837519E-13,
7.39321798226555E-14,
1.56973392617665E-13,
  0,
0.86666666666666,
  0,
0.500167182298014,
  0,
0.397288029431201,
-1.249131006964E-14,
0.345297955355882,
  0,
0.314782221918911,
  0,
0.296538279133769,
1.12141199104521E-14,
0.286965148637542,
1.70072289584766E-14,
0.284891445695914,
2.37396907687426E-14,
0.290883175321252,
3.06811867578638E-14,
0.307856987257106,
4.45572398422023E-14,
0.344280462920679,
6.2153407420773E-14,
0.430055178517695,
7.53112849860571E-14,
0.809419046495733,
8.30542232210796E-14,
4.09377393095767E-14,
9.09290004402763E-14,
4.12794798343441E-14,
9.58660234529063E-14,
5.09817882354824E-14,
1.10156675448003E-13,
6.71008387742589E-14,
1.22983220829376E-13,
8.05605582243629E-14,
1.32139091335581E-13,
8.6614743155522E-14,
1.3865471271135E-13,
9.29430143958854E-14,
1.55377447019767E-13,
9.56353052306014E-14,
1.67067748524374E-13,
9.2299431986298E-14,
1.69097374991267E-13,
8.77856815018063E-14,
1.70760974804729E-13,
7.96775839750907E-14,
1.66937644263676E-13,
7.17065296029773E-14,
0.999999999999995,
  0,
0.561330168144766,
  0,
0.4277796585578,
  0,
0.362699939689734,
  0,
0.324715964742422,
  0,
0.30116063718233,
  0,
0.286965148637542,
1.96882440905988E-14,
0.27999456517243,
2.74025593882676E-14,
0.279717424655282,
3.29293883827297E-14,
0.28702114920129,
3.67050140281933E-14,
0.305002989835876,
5.67384680905114E-14,
0.34224574414287,
7.28679269701438E-14,
0.428747492318228,
8.01416225049145E-14,
0.808969743632086,
8.93660145884212E-14,
3.98552718605671E-14,
9.25735182955023E-14,
4.71723354822373E-14,
1.07245809455314E-13,
6.07118522122363E-14,
1.20889409593872E-13,
7.55576157196458E-14,
1.29774663237825E-13,
8.18407841496338E-14,
1.36467226408143E-13,
9.19542220145786E-14,
1.54636720095525E-13,
9.89468923462411E-14,
1.70094840989954E-13,
9.81610626116236E-14,
1.73479286491585E-13,
8.91699908356358E-14,
1.70908426300187E-13,
7.90530835237391E-14,
1.73059483410398E-13,
7.73148906008103E-14,
1.60966726059364E-13,
  0,
0.866578244826234,
  0,
0.499597599026475,
  0,
0.396065602663699,
  0,
0.343208060732594,
  0,
0.311541842568846,
  0,
0.291742717215662,
1.70072289584766E-14,
0.27999456517243,
3.01867905672104E-14,
0.274726578640893,
3.65792465761849E-14,
0.275695875616057,
3.88439280740727E-14,
0.283952722083614,
4.87821588679438E-14,
0.302695025747667,
6.73098729531141E-14,
0.340576178305805,
7.73478503468539E-14,
0.427661241693388,
8.66320903902817E-14,
0.808592313833832,
9.07746100509144E-14,
4.55920023956224E-14,
1.03967182085718E-13,
5.67462743461533E-14,
1.17848439340484E-13,
6.90645457490646E-14,
1.27477889355632E-13,
7.67441665772139E-14,
1.33948407921025E-13,
8.70536281949441E-14,
1.52317394808144E-13,
9.77707498295288E-14,
1.69194519505922E-13,
1.01349484360469E-13,
1.76327702439139E-13,
9.49969269914419E-14,
1.75005843150444E-13,
8.03090233203463E-14,
1.72971012513123E-13,
7.65811025704721E-14,
1.66876928942017E-13,
6.65544008793262E-14,
  0,
  0,
0.83952731128995,
  0,
0.473292058786036,
  0,
0.378393122162478,
  0,
0.330796910359612,
  0,
0.302455514878912,
1.3166551182664E-14,
0.284891445695914,
2.73713343657001E-14,
0.274726578640893,
3.93062318804205E-14,
0.270629557597826,
4.26048085699904E-14,
0.27249750863986,
5.12610787151146E-14,
0.281468164118274,
5.97881119612786E-14,
0.300798442896321,
7.19493908896141E-14,
0.339187127200045,
8.30585600297695E-14,
0.42674789782023,
8.77110883923393E-14,
0.808271851178868,
1.02003475110912E-13,
5.52596163272412E-14,
1.14517770266609E-13,
6.5072947030842E-14,
1.24187118921704E-13,
7.00602770242753E-14,
1.31636021527548E-13,
8.18511924904897E-14,
1.49658063719471E-13,
9.27955629004273E-14,
1.66739885787415E-13,
1.00105687628194E-13,
1.75240030819701E-13,
9.8058713926541E-14,
1.77755379859867E-13,
8.60075899389301E-14,
1.76950468167014E-13,
7.77745923219442E-14,
1.66601107909337E-13,
6.56835696943858E-14,
1.65329555601446E-13,
  0,
  0,
  0,
0.828189580500137,
  0,
0.458880237300692,
  0,
0.36722868407724,
1.00527225432856E-14,
0.322270339139647,
1.12670289764694E-14,
0.29585802419157,
2.37431602156946E-14,
0.279717424655282,
3.65618993414252E-14,
0.270629557597826,
4.50039311372663E-14,
0.267369572640479,
5.46420547697934E-14,
0.269905585321782,
6.16902362526872E-14,
0.27942427027263,
6.40373171156838E-14,
0.299218549705503,
7.77208158941889E-14,
0.338017617087195,
8.48800196795452E-14,
0.42597178905309,
9.89468923462411E-14,
0.807997194422627,
1.12554063291803E-13,
6.33434277252931E-14,
1.20932777680771E-13,
6.6042657453913E-14,
1.28324434411908E-13,
7.51603640436471E-14,
1.47186082766204E-13,
8.75601674499293E-14,
1.63931368479808E-13,
9.50160089496777E-14,
1.7261019003012E-13,
9.67663449369383E-14,
1.76471684487645E-13,
8.90607032566493E-14,
1.79451939419373E-13,
8.34176477892967E-14,
1.70441785685149E-13,
6.67799149312032E-14,
1.64880262221168E-13,
6.07586897460877E-14,
  0,
  0,
-1.12436102095437E-14,
  0,
0.822049510330789,
1.11256490131773E-14,
0.449878280140181,
1.51796977765351E-14,
0.359602670713217,
1.86812371127942E-14,
0.316097955212206,
2.16493489801906E-14,
0.290883175321252,
3.29285210209918E-14,
0.275695875616057,
4.25891960587066E-14,
0.267369572640479,
5.7217251769881E-14,
0.264726638639975,
6.51033046916716E-14,
0.267771882256098,
6.59160226401667E-14,
0.277720118246792,
6.97011892647481E-14,
0.297886951524249,
7.90964516106385E-14,
0.337022696697345,
9.5888574858094E-14,
0.42530615778275,
1.09388192948146E-13,
0.807759835713069,
1.18899681766926E-13,
6.44154868334468E-14,
1.24778659627012E-13,
7.1134070855905E-14,
1.43749595560294E-13,
8.07912764466678E-14,
1.61351834671031E-13,
8.96990814958087E-14,
1.6966116012096E-13,
9.16176856602391E-14,
1.73718678331269E-13,
8.76087397072567E-14,
1.78147427365438E-13,
8.63423915697936E-14,
1.72875602721945E-13,
7.2325825883901E-14,
1.68505834285959E-13,
6.17509515743464E-14,
1.67461530753421E-13,
  0,
  0,
  0,
  0,
1.31847657791617E-14,
0.81824467719433,
1.73914702084055E-14,
0.443778490025567,
2.38767339233448E-14,
0.354106206981381,
2.94061650030208E-14,
0.311454713779304,
3.06855235665537E-14,
0.28702114920129,
3.88595405853565E-14,
0.27249750863986,
5.46351158758895E-14,
0.264726638639975,
6.78476372306669E-14,
0.26255019738235,
6.9409755720784E-14,
0.265991798176442,
7.17221421142611E-14,
0.276282677760019,
7.11930514540882E-14,
0.296753112285647,
9.00703123196678E-14,
0.336168562098127,
1.06081810002934E-13,
0.4247305761149,
1.15385132004597E-13,
0.807553187405399,
1.22445456551823E-13,
6.93854695921203E-14,
1.40176065199782E-13,
7.67181457250743E-14,
1.57849427973034E-13,
8.28868224056478E-14,
1.66958460945388E-13,
8.62452470551389E-14,
1.70693320589166E-13,
8.24444679192737E-14,
1.75266051671841E-13,
8.48418557630737E-14,
1.71383740532605E-13,
7.52384266000661E-14,
1.70823424849864E-13,
6.7243086099289E-14,
1.71005570814842E-13,
6.16486028892638E-14,
  0,
  0,
  0,
1.35152306013353E-14,
  0,
1.9595436384634E-14,
0.815681087093769,
2.57753887678014E-14,
0.439408012588455,
3.45695694292658E-14,
0.349985409101039,
3.83564707773232E-14,
0.307856987257106,
3.6649502876962E-14,
0.283952722083614,
5.1233323139499E-14,
0.269905585321782,
6.51007026064576E-14,
0.26255019738235,
7.20153103817012E-14,
0.26073392966398,
7.51863848957868E-14,
0.2644895508765,
7.31567584288939E-14,
0.275057900434205,
8.23022205942436E-14,
0.295778953556871,
1.00397121172158E-13,
0.335429348996079,
1.12470796564956E-13,
0.424229205385208,
1.19423568256671E-13,
0.807372077475408,
1.37853270465449E-13,
7.4946993056102E-14,
1.54123241946635E-13,
7.88102222371023E-14,
1.63494218163862E-13,
7.94243143475981E-14,
1.67900415792843E-13,
7.70199876098943E-14,
1.72140079968131E-13,
7.96810534220427E-14,
1.68403485600876E-13,
7.37188088351104E-14,
1.69237887592821E-13,
7.01192576224585E-14,
1.73180914053717E-13,
6.71528804785382E-14,
1.77281800350926E-13,
  0,
  0,
1.4432899320127E-14,
  0,
2.01349353856628E-14,
  0,
2.81701745263874E-14,
0.81385197558937,
3.71282865563316E-14,
0.436146154698005,
4.35406918852799E-14,
0.346801057784456,
4.45589745656783E-14,
0.305002989835876,
4.88376700191751E-14,
0.281468164118274,
6.16373271866699E-14,
0.267771882256097,
6.92969986948455E-14,
0.26073392966398,
7.80417397372446E-14,
0.259200764185968,
7.63226287725516E-14,
0.26320899721312,
8.41913344595824E-14,
0.274005003852978,
9.23306570088656E-14,
0.294935290443303,
1.0678610773418E-13,
0.334784964943633,
1.16280249318201E-13,
0.423789595776149,
1.34503519433338E-13,
0.807212394818267,
1.51590545671709E-13,
7.70581515263657E-14,
1.59617111195054E-13,
7.52575085583018E-14,
1.64259231216768E-13,
7.01886465614976E-14,
1.69255234827581E-13,
7.42513689422353E-14,
1.65119654060852E-13,
6.84799439376604E-14,
1.6618130482815E-13,
6.85666801114593E-14,
1.71503436452447E-13,
6.99718061270005E-14,
1.7938428520381E-13,
6.54927501120284E-14,
  0,
1.37663318244829E-14,
  0,
2.13583491170954E-14,
  0,
2.90384036261138E-14,
1.22462803786583E-14,
3.91709234492943E-14,
0.812491196216809,
4.60230811794027E-14,
0.433634445827701,
4.99314131707784E-14,
0.344280462920679,
5.66829569392802E-14,
0.302695025747667,
5.97672952795669E-14,
0.27942427027263,
6.59194920871187E-14,
0.265991798176442,
7.51603640436471E-14,
0.259200764185968,
7.93184962155635E-14,
0.257893573880733,
8.75254729804098E-14,
0.262107735602249,
9.42371181089641E-14,
0.273092691883468,
9.86415810144692E-14,
0.294199416650178,
1.1069270500208E-13,
0.334219589667079,
1.31493774202518E-13,
0.423401840898947,
1.48117629272804E-13,
0.807070835172373,
1.57124313560075E-13,
7.33198224356357E-14,
1.60448043740047E-13,
6.59264309810226E-14,
1.65575886335034E-13,
6.73315569965638E-14,
1.62191440833404E-13,
6.30710761395648E-14,
1.62859309371655E-13,
6.32428137636865E-14,
1.68356648067025E-13,
6.83723910821499E-14,
1.77613132534837E-13,
6.82388173744997E-14,
1.8821055824958E-13,
  0,
  0,
2.13795994796762E-14,
  0,
3.05207248363359E-14,
1.33747179997812E-14,
4.00608365924704E-14,
1.98755942260043E-14,
4.85956760942763E-14,
0.811445977538164,
5.22264523294957E-14,
0.431651895079695,
6.22089185720043E-14,
0.34224574414287,
6.7313342400066E-14,
0.300798442896321,
6.40373171156838E-14,
0.277720118246792,
7.16648962395539E-14,
0.2644895508765,
7.63781399237828E-14,
0.257893573880733,
9.02247027090297E-14,
0.256769194835462,
9.76510539096864E-14,
0.261153201246059,
1.0054283794414E-13,
0.272296588960609,
1.02490932407662E-13,
0.293553429939501,
1.25710206133611E-13,
0.333720615983044,
1.45191150768831E-13,
0.423057971184093,
1.53774562527964E-13,
0.806944716032763,
1.57930959976404E-13,
6.41518088650983E-14,
1.61690105748846E-13,
6.31421998020798E-14,
1.58510357617381E-13,
5.61634072582251E-14,
1.59927626697254E-13,
5.7814864007355E-14,
1.64923630308067E-13,
6.31092400560362E-14,
1.74372669081713E-13,
6.66862398635004E-14,
1.86326648554669E-13,
5.99260224776188E-14,
  0,
1.89887168489111E-14,
1.14721600275036E-14,
3.10949183068843E-14,
1.63636465488892E-14,
4.19031129239578E-14,
2.0870458139477E-14,
4.96200303068406E-14,
2.1914761672015E-14,
5.5047980063172E-14,
0.810622603950345,
6.46887057809131E-14,
0.430055178517695,
7.28687943318818E-14,
0.340576178305805,
7.19667381243738E-14,
0.299218549705503,
6.97289448403637E-14,
0.276282677760019,
7.31966570688414E-14,
0.26320899721312,
8.75220035334578E-14,
0.256769194835462,
1.00393651725206E-13,
0.255794463713751,
1.03942895957054E-13,
0.26032001241015,
1.04312392057437E-13,
0.271597458053123,
1.17643741970319E-13,
0.292983047078234,
1.39641770369181E-13,
0.333277888027735,
1.50466444859276E-13,
0.422751511312938,
1.54355694892416E-13,
0.806831839763879,
1.59065469129693E-13,
6.13779860270114E-14,
1.54607229796433E-13,
5.18751708256104E-14,
1.56059193345826E-13,
5.0936685425107E-14,
1.61967661505003E-13,
5.75997582963339E-14,
1.70965672174894E-13,
6.13519651748717E-14,
1.83020265609457E-13,
5.83075254745324E-14,
1.82263926173931E-13,
1.27643121766718E-14,
1.33530339563315E-14,
2.96767818652732E-14,
2.13644206492614E-14,
4.29179261574042E-14,
2.40927069961039E-14,
5.1683483881515E-14,
2.29790145245268E-14,
5.62154489625044E-14,
2.54709447977675E-14,
6.75128355998034E-14,
0.809960542669755,
7.54292461824235E-14,
0.428747492318228,
7.7410300391989E-14,
0.339187127200045,
7.76583658490537E-14,
0.297886951524249,
7.1130601408953E-14,
0.275057900434205,
8.41878650126304E-14,
0.262107735602249,
9.77065650609177E-14,
0.255794463713751,
1.0692835505921E-13,
0.254943523224521,
1.07767961221583E-13,
0.259588125320213,
1.19432241874051E-13,
0.270979937661904,
1.3150591726685E-13,
0.292476749859001,
1.44625630915662E-13,
0.332883144272328,
1.5127135655213E-13,
0.422477152452775,
1.55144994073986E-13,
0.806730390963154,
1.52076268244983E-13,
5.0041568111503E-14,
1.52161269695306E-13,
4.66623267803001E-14,
1.58125249005714E-13,
5.07250491610378E-14,
1.67836231024232E-13,
5.57696250291784E-14,
1.79566431168787E-13,
5.29454952102881E-14,
1.78849990373209E-13,
5.16513914972094E-14,
1.13639566506896E-14,
2.64280784756377E-14,
2.40463031431215E-14,
4.22830173651967E-14,
2.94451962812303E-14,
5.30920793440082E-14,
2.63790725374413E-14,
5.85486520376932E-14,
2.66496893996937E-14,
6.89457171909602E-14,
3.4256451841852E-14,
7.81995995735585E-14,
0.809419046495733,
8.0252644807377E-14,
0.427661241693388,
8.31175406279527E-14,
0.338017617087195,
7.91103293984463E-14,
0.296753112285647,
8.23004858707677E-14,
0.274005003852978,
9.42908945367193E-14,
0.261153201246059,
1.03887384805823E-13,
0.254943523224521,
1.10505354866675E-13,
0.254195947683945,
1.22991894446756E-13,
0.258941525211412,
1.33542482627647E-13,
0.270431630441342,
1.36694475183496E-13,
0.29202515963596,
1.4526921332525E-13,
0.332529604210487,
1.52414539322798E-13,
0.422230506198907,
1.48318857196017E-13,
0.806638858540652,
1.49614695632572E-13,
4.47541309567256E-14,
1.54098955817972E-13,
4.64888544327025E-14,
1.64023308824035E-13,
4.88272616783192E-14,
1.76454337252885E-13,
4.74342787271098E-14,
1.75328501716976E-13,
4.63205862555327E-14,
1.80836248753202E-13,
1.77384149036008E-14,
2.45753938032944E-14,
4.0463726119766E-14,
3.26336180300757E-14,
5.29767202328557E-14,
3.19145751492833E-14,
6.02573546615304E-14,
3.00835745203898E-14,
7.15365267023316E-14,
3.5528004149743E-14,
7.9957741816461E-14,
3.91102081276351E-14,
8.30559579445556E-14,
0.808969743632086,
8.66424987311376E-14,
0.42674789782023,
8.48522641039295E-14,
0.337022696697345,
9.00095969980086E-14,
0.295778953556871,
9.23254528384376E-14,
0.273092691883468,
1.00572328243231E-13,
0.26032001241015,
1.07788777903295E-13,
0.254195947683945,
1.25564489361629E-13,
0.253535412634546,
1.36503655601139E-13,
0.25836728097413,
1.38463893128993E-13,
0.269942434879783,
1.37251321419285E-13,
0.291620572484327,
1.46537296186189E-13,
0.332211657527344,
1.44889308884011E-13,
0.422007917561265,
1.46100145870243E-13,
0.806555975885913,
1.51861162533962E-13,
4.46101489082196E-14,
1.59891197504258E-13,
4.45164738405168E-14,
1.72506106621562E-13,
4.04919153762506E-14,
1.72120998009895E-13,
4.07486544506952E-14,
1.77259248945738E-13,
3.34489380637848E-14,
1.70100478841251E-14,
3.58463259075847E-14,
3.43531626756377E-14,
5.21561960287187E-14,
3.55392798523368E-14,
6.05904215689179E-14,
3.58497953545367E-14,
7.35028357623513E-14,
3.90867893607094E-14,
8.27489118893077E-14,
4.05465591657439E-14,
8.47742015475106E-14,
4.0986311566904E-14,
8.92758089676704E-14,
0.808592313833832,
8.77388439679549E-14,
0.42597178905309,
9.5885105411142E-14,
0.336168562098127,
1.00404060066062E-13,
0.294935290443303,
9.86415810144692E-14,
0.272296588960609,
1.04305453163533E-13,
0.259588125320213,
1.2296413887114E-13,
0.253535412634546,
1.39579320324046E-13,
0.252948733606142,
1.42217834731007E-13,
0.257854851373344,
1.39313907632221E-13,
0.269504048057905,
1.38420525042093E-13,
0.291256609130806,
1.39372888230405E-13,
0.331924627475737,
1.42465900188071E-13,
0.421806321215209,
1.48036097269433E-13,
0.806480674441317,
1.57441767956179E-13,
4.26204210812742E-14,
1.68538794032003E-13,
3.61811275384483E-14,
1.68240421594135E-13,
3.37490452251288E-14,
1.73961539617906E-13,
2.78926187702311E-14,
1.77798747946767E-13,
2.36512198714678E-14,
3.05701644554013E-14,
4.9441787469684E-14,
3.81110074054725E-14,
6.04299596473901E-14,
3.97668009632923E-14,
7.41533570658426E-14,
4.49683693060088E-14,
8.48800196795452E-14,
4.42111625087449E-14,
8.75991987281388E-14,
4.24703675006022E-14,
9.0874356650783E-14,
3.98223121145236E-14,
9.07867531152462E-14,
0.808271851178868,
9.89711784749048E-14,
0.42530615778275,
1.06054054427318E-13,
0.335429348996079,
1.06850292502791E-13,
0.294199416650178,
1.02490932407662E-13,
0.271597458053123,
1.19411425192339E-13,
0.258941525211411,
1.3655916675237E-13,
0.252948733606142,
1.44504200272344E-13,
0.252425160405092,
1.42528350233206E-13,
0.257395568492614,
1.40264536097057E-13,
0.269109590799409,
1.31302954620161E-13,
0.290927948121192,
1.36841926678954E-13,
0.331664588727361,
1.44219705622284E-13,
0.421623129858223,
1.53649662437694E-13,
0.806412047330306,
1.6593150464761E-13,
3.43006872904894E-14,
1.6407708525179E-13,
2.94278490464706E-14,
1.69961267282304E-13,
2.09901540593194E-14,
1.74487160831127E-13,
2.03188160741163E-14,
1.82978632246034E-14,
4.2485112650148E-14,
3.58012230972093E-14,
5.88574328164171E-14,
4.2780883002802E-14,
7.45913747435267E-14,
4.91091542431654E-14,
8.5939935723367E-14,
5.02679495251179E-14,
9.00954658100694E-14,
4.61991556122143E-14,
9.39578276293318E-14,
4.12812145578201E-14,
9.26481114049693E-14,
4.56006760130023E-14,
1.02005209834388E-13,
0.807997194422627,
1.09389927671621E-13,
0.4247305761149,
1.12491613246668E-13,
0.334784964943633,
1.10696174449032E-13,
0.293553429939501,
1.17619455841655E-13,
0.270979937661904,
1.33571972926738E-13,
0.258367280974129,
1.42191813878867E-13,
0.252425160405092,
1.45227579961826E-13,
0.25195585149036,
1.43707962196871E-13,
0.256982248069005,
1.3298910583881E-13,
0.268753321687196,
1.28654031872344E-13,
0.290630120179913,
1.38708489139105E-13,
0.331428225717511,
1.50294707235155E-13,
0.42145614667165,
1.62050928231849E-13,
0.806349320608692,
1.61454183356113E-13,
2.75612865863195E-14,
1.65799665663435E-13,
1.66290592407137E-14,
1.70518113518092E-13,
1.33053290607421E-14,
1.80010520378637E-13,
2.54277935513025E-14,
2.74892955620665E-14,
5.41480922600091E-14,
4.13185111125536E-14,
7.38393721166908E-14,
5.25126817030319E-14,
8.67396432457923E-14,
5.45761352777063E-14,
9.13869674379342E-14,
5.2353087143242E-14,
9.66084851006244E-14,
4.51418416536065E-14,
9.58521456650985E-14,
4.71515188005256E-14,
1.03993202937858E-13,
5.52353301985775E-14,
1.12540185503995E-13,
0.807759835713069,
1.15499623754012E-13,
0.424229205385208,
1.16280249318201E-13,
0.334219589667079,
1.25684185281472E-13,
0.292983047078234,
1.3150591726685E-13,
0.270431630441342,
1.38436137553377E-13,
0.257854851373344,
1.42538758574062E-13,
0.25195585149036,
1.46398518308111E-13,
0.251533477340151,
1.36404776363008E-13,
0.256608892027409,
1.30388755348321E-13,
0.268430416477336,
1.30506716544687E-13,
0.290359348116455,
1.44228379239664E-13,
0.331212721439283,
1.58852098142148E-13,
0.421303496075707,
1.58031573938011E-13,
0.806291830353606,
1.63164620703427E-13,
1.47815787387984E-14,
1.66325286876656E-13,
  0,
1.75859327100625E-13,
  0,
1.34742477592154E-14,
4.278175036454E-14,
3.45014815328337E-14,
7.04696717646058E-14,
5.16548609441614E-14,
8.66529070719935E-14,
5.83708428814056E-14,
9.25596405076945E-14,
5.68685723512097E-14,
9.81853487402873E-14,
5.13408759950096E-14,
9.86398462909932E-14,
5.09869924059103E-14,
1.07228462220554E-13,
5.67740299217689E-14,
1.14517770266609E-13,
6.33434277252931E-14,
1.18892742873022E-13,
0.807553187405399,
1.19444384938383E-13,
0.423789595776149,
1.31502447819898E-13,
0.333720615983044,
1.39636566198753E-13,
0.292476749859001,
1.36694475183496E-13,
0.269942434879782,
1.39372888230405E-13,
0.257395568492614,
1.4376000390115E-13,
0.251533477340151,
1.39005126853498E-13,
0.251151917577244,
1.33696873017008E-13,
0.256270458912032,
1.32401034580454E-13,
0.268136796237264,
1.36246916526694E-13,
0.290112421022797,
1.52797913210989E-13,
0.331015669378656,
1.54312326805517E-13,
0.421163568505916,
1.58839955077816E-13,
0.806239004264482,
1.63513300122098E-13,
  0,
1.71715072716516E-13,
  0,
1.74863595825414E-13,
2.39988150879666E-14,
2.36729039149175E-14,
6.14920440955569E-14,
4.57411886145564E-14,
8.42763359099052E-14,
5.79388967358874E-14,
9.30089338879725E-14,
6.088705928331E-14,
9.96572616096536E-14,
5.60064147836492E-14,
1.00362426702638E-13,
5.74037345435485E-14,
1.10163614341907E-13,
6.0656341061005E-14,
1.17877929639576E-13,
6.50833553716978E-14,
1.20873797082588E-13,
6.44380382386345E-14,
1.22452395445727E-13,
0.807372077475408,
1.34661379269652E-13,
0.423401840898947,
1.45246661920062E-13,
0.333277888027735,
1.44714101812937E-13,
0.29202515963596,
1.37195810268054E-13,
0.269504048057905,
1.40295761119624E-13,
0.256982248069005,
1.3646028751424E-13,
0.251151917577244,
1.36574779263654E-13,
0.250806027162694,
1.35646702204006E-13,
0.25596268493579,
1.38012865025239E-13,
0.267868992199621,
1.4467420317299E-13,
0.289886594560446,
1.48450696180191E-13,
0.330835003209719,
1.55637655541163E-13,
0.421034976036069,
1.59759358520084E-13,
0.80619034678186,
1.68781655318639E-13,
  0,
1.70530256582424E-13,
  0,
1.38467796256814E-14,
4.8393580809325E-14,
3.63068949904566E-14,
7.68040145371351E-14,
5.26878887741056E-14,
9.13210479458471E-14,
6.07743022573715E-14,
1.00466510111197E-13,
6.02512831293645E-14,
1.0216393703244E-13,
6.21039678017077E-14,
1.12082218506337E-13,
6.70956346038309E-14,
1.2086859291216E-13,
6.90662804725406E-14,
1.24216609220795E-13,
6.6042657453913E-14,
1.24820292990435E-13,
6.93906737625483E-14,
1.37860209359353E-13,
0.807212394818267,
1.48126302890184E-13,
0.423057971184093,
1.50462975412324E-13,
0.332883144272328,
1.45281356389582E-13,
0.291620572484327,
1.38448280617709E-13,
0.269109590799409,
1.32933594687579E-13,
0.256608892027409,
1.33696873017008E-13,
0.250806027162694,
1.38177663755457E-13,
0.250491454096385,
1.41348738269542E-13,
0.25568194319429,
1.46280557111744E-13,
0.267624038573258,
1.40269740267485E-13,
0.289679511291402,
1.5001194730857E-13,
0.330668940245169,
1.56206644841284E-13,
0.420916516464129,
1.65287922238022E-13,
0.806145426970857,
1.68014907542258E-13,
  0,
1.64583624506776E-13,
3.18820490841087E-14,
2.98480858085259E-14,
6.63705201908726E-14,
4.42267750200287E-14,
8.49277245751345E-14,
5.59986085280073E-14,
9.93510829161437E-14,
6.04767971812414E-14,
1.03273292695327E-13,
6.65639418584441E-14,
1.14080619950663E-13,
7.20500048512207E-14,
1.2299883334066E-13,
7.55645546135497E-14,
1.27477889355632E-13,
7.00776242590351E-14,
1.28317495518004E-13,
7.11063152802893E-14,
1.40203820775398E-13,
7.49539319500059E-14,
1.51606158182993E-13,
0.807070835172373,
1.5380231810358E-13,
0.422751511312938,
1.51273091275606E-13,
0.332529604210487,
1.46551173973997E-13,
0.291256609130806,
1.31282137938449E-13,
0.268753321687196,
1.30388755348321E-13,
0.256270458912032,
1.35646702204006E-13,
0.250491454096385,
1.44148581959769E-13,
0.250204495963412,
1.49862761089636E-13,
0.255425131955799,
1.41693948241262E-13,
0.267399386849277,
1.41546496745804E-13,
0.289489136548052,
1.50263482212587E-13,
0.330515935631164,
1.61710922430558E-13,
0.42080714405408,
1.63796060048682E-13,
0.80610386859401,
1.61700514089702E-13,
-1.33226762955019E-14,
2.05889992554997E-14,
5.69557422058775E-14,
3.92979919439096E-14,
7.60606855276791E-14,
4.81342396496665E-14,
9.37618038765464E-14,
5.6018557847981E-14,
1.02619301944884E-13,
6.69672650666087E-14,
1.15508297371392E-13,
7.6588041464376E-14,
1.25162033515203E-13,
8.05952526938825E-14,
1.29774663237825E-13,
7.67042679372665E-14,
1.31636021527548E-13,
7.51395473619354E-14,
1.43779085859386E-13,
7.67441665772139E-14,
1.54168344757011E-13,
7.70442737385579E-14,
1.57068802408844E-13,
0.806944716032763,
1.5435396016894E-13,
0.422477152452775,
1.52411069875846E-13,
0.332211657527344,
1.39317377079173E-13,
0.290927948121192,
1.28709543023575E-13,
0.268430416477336,
1.32401034580454E-13,
0.25596268493579,
1.41404249420773E-13,
0.250204495963413,
1.52463111580126E-13,
0.249941986083232,
1.45416664820708E-13,
0.25518958531745,
1.43629899640452E-13,
0.267192836782591,
1.42084261023356E-13,
0.289313706451387,
1.55566531878648E-13,
0.330374645001163,
1.60475799315662E-13,
0.420705945552062,
1.57908408571217E-13,
0.806065341930076,
1.56992474575901E-13,
3.38572486019428E-14,
3.45478853858161E-14,
6.95901669622856E-14,
4.42207034878628E-14,
8.59121801477514E-14,
4.85644510717087E-14,
9.7530490628106E-14,
6.27735710634347E-14,
1.15205588124834E-13,
7.71700411905663E-14,
1.26900226438131E-13,
8.52408421625483E-14,
1.32142560782533E-13,
8.18147632974942E-14,
1.33955346814929E-13,
8.18425188731098E-14,
1.471791438723E-13,
8.08190320222835E-14,
1.57844223802606E-13,
7.8837977812718E-14,
1.59672622346285E-13,
7.33059446478279E-14,
1.57917082188597E-13,
0.806831839763879,
1.55200505225217E-13,
0.422230506198907,
1.44903186671819E-13,
0.331924627475737,
1.36836722508527E-13,
0.290630120179913,
1.30477226245596E-13,
0.268136796237264,
1.38096131752086E-13,
0.25568194319429,
1.49866230536588E-13,
0.249941986083232,
1.4795976943649E-13,
0.249701202435836,
1.46899853392668E-13,
0.254973001220856,
1.43912659567036E-13,
0.267002480418924,
1.47552109419635E-13,
0.28915168550142,
1.54615903413813E-13,
0.33024389383918,
1.5450488111135E-13,
0.420612120411218,
1.53325269147686E-13,
0.806029556994419,
1.92794998715717E-14,
5.4002809168896E-14,
4.12022846396631E-14,
8.11139350131995E-14,
4.52068937839556E-14,
9.04953195712821E-14,
5.56421228536941E-14,
1.10582550061356E-13,
7.32070654096972E-14,
1.26886348650324E-13,
8.60474885788776E-14,
1.34049021882632E-13,
8.661127370857E-14,
1.36481104195951E-13,
8.7060567088848E-14,
1.49658063719471E-13,
8.75636368968813E-14,
1.61344895777127E-13,
8.29007001934556E-14,
1.6350809595167E-13,
7.5247100217446E-14,
1.60442839569619E-13,
6.41535435885743E-14,
1.59063734406217E-13,
0.806730390963154,
1.48332734983825E-13,
0.422007917561265,
1.42521411339303E-13,
0.331664588727361,
1.38705019692154E-13,
0.290359348116455,
1.36245181803218E-13,
0.267868992199621,
1.46349946050783E-13,
0.255425131955799,
1.45388909245092E-13,
0.249701202435836,
1.49635512314283E-13,
0.249479794270161,
1.47267614769575E-13,
0.254773383053909,
1.49220913403525E-13,
0.266826656407083,
1.46275352941316E-13,
0.289001731765775,
1.48190487658795E-13,
0.330122652201695,
1.49717044317654E-13,
0.420524964397106,
1.55667145840255E-13,
2.84750521772903E-14,
3.02704909749263E-14,
6.84504536385688E-14,
4.31451749327572E-14,
8.67457147779582E-14,
5.26965623914855E-14,
1.04114633581176E-13,
6.63635812969687E-14,
1.22651888645464E-13,
8.22831386360079E-14,
1.34354333214404E-13,
8.75480243855975E-14,
1.38647773817446E-13,
9.18883025224915E-14,
1.52320864255096E-13,
9.28129101351871E-14,
1.63889735116385E-13,
8.9679999537573E-14,
1.66958460945388E-13,
7.94520699232137E-14,
1.64283517345432E-13,
6.59299004279745E-14,
1.61717861324462E-13,
6.13172707053522E-14,
1.52079737691935E-13,
0.806638858540652,
1.46120962551954E-13,
0.421806321215209,
1.44219705622284E-13,
0.331428225717511,
1.44228379239664E-13,
0.290112421022797,
1.44559711423575E-13,
0.267624038573258,
1.41693948241262E-13,
0.25518958531745,
1.46958833990851E-13,
0.249479794270161,
1.4991306807044E-13,
0.249275722554231,
1.52700768696334E-13,
0.254588991968466,
1.48089873697188E-13,
0.266663912480011,
1.40033817874752E-13,
0.288862668141068,
1.4376000390115E-13,
0.330010013747366,
1.52225454463917E-13,
0.420443855925508,
1.56769128928369E-14,
4.95619170703954E-14,
3.38210362493818E-14,
7.57172102794357E-14,
5.1235057862975E-14,
1.01179481459823E-13,
6.37415467630298E-14,
1.16709593378506E-13,
7.56729748307983E-14,
1.30452940116932E-13,
8.39259217677579E-14,
1.39166456136763E-13,
9.29308713315535E-14,
1.54650597883332E-13,
9.77672803825769E-14,
1.66741620510891E-13,
9.50090700557737E-14,
1.69657690674008E-13,
8.62521859490428E-14,
1.67886538005035E-13,
7.0160890985882E-14,
1.65600172463698E-13,
6.3130056737748E-14,
1.5465580205376E-13,
5.00433028349789E-14,
1.4961122618562E-13,
0.806555975885913,
1.48032627822481E-13,
0.421623129858223,
1.50291237788203E-13,
0.331212721439283,
1.52797913210989E-13,
0.289886594560446,
1.40266270820533E-13,
0.267399386849277,
1.43685410791683E-13,
0.254973001220856,
1.47262410599147E-13,
0.249275722554231,
1.55198770501741E-13,
0.249087211344928,
1.5153850396743E-13,
0.254418307711951,
1.42198752772771E-13,
0.266512974468143,
1.35544353518924E-13,
0.288733458499447,
1.46216372343133E-13,
0.329905178251244,
1.43267342433973E-13,
2.87281049643484E-14,
2.27491636639598E-14,
5.95443833129039E-14,
4.28251184514394E-14,
9.11657901947471E-14,
6.27362745087012E-14,
1.14396339623291E-13,
7.33952829068407E-14,
1.24906161802496E-13,
7.75768338456828E-14,
1.35539149348496E-13,
8.95065271899753E-14,
1.55382651190195E-13,
9.89434228992891E-14,
1.6919105005897E-13,
1.00077932052578E-13,
1.7261019003012E-13,
9.15933995315754E-14,
1.70644748331839E-13,
7.70061098220864E-14,
1.69244826486725E-13,
6.731594448528E-14,
1.58510357617381E-13,
5.18456805265188E-14,
1.52218515570013E-13,
4.4806172661005E-14,
1.51819529170538E-13,
0.806480674441317,
1.53535170688279E-13,
0.42145614667165,
1.58796586990917E-13,
0.331015669378656,
1.48450696180191E-13,
0.289679511291402,
1.41574252321419E-13,
0.267192836782591,
1.43857148415805E-13,
0.254773383053909,
1.52704238143286E-13,
0.249087211344928,
1.54209978120434E-13,
0.248912707835109,
1.45342071711241E-13,
0.254259996269599,
1.3743867155469E-13,
0.2663727205701,
1.37771738462078E-13,
0.288613187789042,
1.37216626949765E-13,
0.329807436953708,
1.06180255560195E-14,
4.5098907247576E-14,
3.31141364329213E-14,
7.65793678469961E-14,
5.50011425293206E-14,
1.05297714991792E-13,
7.2779456072869E-14,
1.23104651472694E-13,
7.55038392918905E-14,
1.30362734496181E-13,
8.33482588502577E-14,
1.52034634881559E-13,
9.56353052306014E-14,
1.70077493755194E-13,
1.01351219083945E-13,
1.75238296096225E-13,
9.67385893613226E-14,
1.73739495012981E-13,
8.24722234948894E-14,
1.72126202180323E-13,
7.42513689422353E-14,
1.62213992238591E-13,
5.61634072582251E-14,
1.56112969773581E-13,
4.66345712046845E-14,
1.54098955817972E-13,
4.46101489082196E-14,
1.57455645743987E-13,
0.806412047330305,
1.62075214360513E-13,
0.421303496075707,
1.54197835056102E-13,
0.330835003209719,
1.49998069520763E-13,
0.289489136548052,
1.42112016598972E-13,
0.267002480418924,
1.49203566168765E-13,
0.254588991968466,
1.51625240141229E-13,
0.248912707835109,
1.47919870796542E-13,
0.248750849343296,
1.40523009894977E-13,
0.254112882989823,
1.39454420233776E-13,
0.266242159880518,
1.29139754445617E-13,
0.288501045352923,
1.35183531035921E-13,
2.33391864862265E-14,
2.36785417662144E-14,
6.4697379398293E-14,
4.61792062922406E-14,
9.17998316252167E-14,
6.55144341554781E-14,
1.14657415506425E-13,
7.52202120035683E-14,
1.29000976567539E-13,
8.15198603065781E-14,
1.47175674425348E-13,
8.96088758750579E-14,
1.67053870736567E-13,
9.81610626116236E-14,
1.76320763545235E-13,
9.80760611613007E-14,
1.76471684487645E-13,
8.76087397072567E-14,
1.75252173884033E-13,
7.96931964863745E-14,
1.6513353184866E-13,
6.30710761395648E-14,
1.59927626697254E-13,
5.0934950701631E-14,
1.58132187899618E-13,
4.64888544327025E-14,
1.59905075292066E-13,
4.2634298869082E-14,
1.65903749071994E-13,
0.806349320608692,
1.57948307211164E-13,
0.421163568505916,
1.55637655541163E-13,
0.330668940245169,
1.50317258640342E-13,
0.289313706451387,
1.47552109419635E-13,
0.266826656407083,
1.48166201530131E-13,
0.254418307711951,
1.45345541158193E-13,
0.248750849343296,
1.43367956395579E-13,
0.248600435893604,
1.43107747874183E-13,
0.253975930150886,
1.30652433316669E-13,
0.266120414384655,
1.27235028068995E-13,
0.288396310882379,
1.67131933292985E-14,
4.86737386506952E-14,
3.8217692899245E-14,
8.15372075413379E-14,
5.73967956496446E-14,
1.02039904303908E-13,
6.83507070387002E-14,
1.21095841687513E-13,
8.14417977501591E-14,
1.46185147320566E-13,
8.79504802320241E-14,
1.62439506290468E-13,
9.22612680698265E-14,
1.73458469809873E-13,
9.4986518650586E-14,
1.77734563178156E-13,
8.90468254688415E-14,
1.78135284301106E-13,
8.48609377213094E-14,
1.68403485600876E-13,
6.84938217254683E-14,
1.62861044095131E-13,
5.78460890299226E-14,
1.61964192058051E-13,
5.06625991159027E-14,
1.64023308824035E-13,
4.45234127344207E-14,
1.68538794032003E-13,
3.43110956313453E-14,
1.61454183356113E-13,
0.806291830353606,
1.59003019084558E-13,
0.421034976036069,
1.56206644841284E-13,
0.330515935631164,
1.55566531878648E-13,
0.28915168550142,
1.46275352941316E-13,
0.26666391248001,
1.42195283325819E-13,
0.254259996269599,
1.40550765470593E-13,
0.248600435893604,
1.45595341338733E-13,
0.248460407324401,
1.3406289967044E-13,
0.253848218145345,
1.28799748644326E-13,
0.266006703791696,
1.24518451105615E-13,
3.28584815606492E-14,
3.50735065990371E-14,
6.82535625240455E-14,
5.04336156170737E-14,
9.29638310775971E-14,
6.07508834904458E-14,
1.09107167745037E-13,
7.49322479065562E-14,
1.38724101650389E-13,
8.81343609204777E-14,
1.61762964134837E-13,
9.07746100509144E-14,
1.69086966650411E-13,
8.91786644530157E-14,
1.75040537619964E-13,
8.60318760675938E-14,
1.79486633888892E-13,
8.63527999106495E-14,
1.71383740532605E-13,
7.37153393881584E-14,
1.6618130482815E-13,
6.32150581880708E-14,
1.64951385883683E-13,
5.75754721676702E-14,
1.6785010881204E-13,
4.88532825304588E-14,
1.72547739984985E-13,
3.61394941750248E-14,
1.64075350528314E-13,
2.75578171393676E-14,
1.63164620703427E-13,
0.806239004264482,
1.59813134947839E-13,
0.420916516464129,
1.61724800218366E-13,
0.330374645001163,
1.54615903413813E-13,
0.289001731765775,
1.40033817874752E-13,
0.266512974468143,
1.37424793766883E-13,
0.254112882989823,
1.43159789578462E-13,
0.248460407324401,
1.36786415527723E-13,
0.248329824086482,
1.32310828959703E-13,
0.253728929627619,
1.26253174581592E-13,
0.265900332704196,
2.37646274187098E-14,
5.97746678543398E-14,
4.91733390117766E-14,
8.13351122563866E-14,
5.44920011891215E-14,
1.00870700681099E-13,
6.77418190986323E-14,
1.27262783644611E-13,
8.18789480661053E-14,
1.54742538227559E-13,
9.11319630869656E-14,
1.687556344665E-13,
8.77822120548544E-14,
1.70903222129759E-13,
8.03367788959619E-14,
1.76908834803591E-13,
8.34176477892967E-14,
1.72882541615849E-13,
7.52661821756817E-14,
1.69237887592821E-13,
6.85493328766995E-14,
1.68367056407881E-13,
6.30814844804206E-14,
1.70991693027034E-13,
5.5797380604794E-14,
1.76454337252885E-13,
4.05474265274819E-14,
1.68236952147183E-13,
2.94261143229946E-14,
1.65830890686003E-13,
1.47746398448945E-14,
1.63506361228194E-13,
0.80619034678186,
1.65287922238022E-13,
0.42080714405408,
1.60420288164431E-13,
0.33024389383918,
1.48273754385642E-13,
0.288862668141068,
1.35499250708548E-13,
0.2663727205701,
1.39461359127679E-13,
0.253975930150886,
1.34049021882632E-13,
0.248329824086482,
1.34718625144359E-13,
0.248207851063517,
1.29920380009807E-13,
0.253617336100692,
1.30308958068426E-13,
3.61633466228195E-14,
4.31378023579843E-14,
7.59513979486925E-14,
5.4378376801445E-14,
9.04068486740073E-14,
6.19617204766776E-14,
1.1967423579895E-13,
7.50285250594729E-14,
1.43753065007246E-13,
8.51003295609942E-14,
1.62035315720566E-13,
8.83095679915513E-14,
1.70760974804729E-13,
7.90357362889793E-14,
1.72967543066171E-13,
7.78023478975598E-14,
1.70455663472957E-13,
7.23188869899971E-14,
1.7083383319072E-13,
7.01053798346507E-14,
1.71510375346351E-13,
6.83845341464817E-14,
1.74360526017381E-13,
6.13641082392036E-14,
1.79566431168787E-13,
4.74065231514942E-14,
1.7214875358551E-13,
3.37421063312249E-14,
1.69942185324068E-13,
1.66446717519975E-14,
1.66325286876656E-13,
  0,
1.6877298170126E-13,
0.806145426970857,
1.63768304473066E-13,
0.420705945552062,
1.54487533876591E-13,
0.330122652201695,
1.43718370537727E-13,
0.288733458499447,
1.37799494037694E-13,
0.266242159880518,
1.30621208294102E-13,
0.253848218145345,
1.32283073384087E-13,
0.248207851063517,
1.32508587435964E-13,
0.248093743880641,
1.33667382717917E-13,
0.253512786520481,
2.60434035448398E-14,
6.04204186682722E-14,
5.05359643021563E-14,
8.67769398005258E-14,
6.25905577367192E-14,
1.10103766381986E-13,
6.96760357743464E-14,
1.36748251611252E-13,
7.8534401204422E-14,
1.51456971964059E-13,
8.24514068131776E-14,
1.64349436837519E-13,
7.97088089976583E-14,
1.73057748686922E-13,
7.66123275930397E-14,
1.66601107909337E-13,
6.68007316129149E-14,
1.68533589861575E-13,
6.72500249931929E-14,
1.73196526565E-13,
6.99718061270005E-14,
1.7759925474703E-13,
6.66758315226446E-14,
1.83032408673789E-13,
5.29316174224803E-14,
1.75330236440452E-13,
4.0762532238503E-14,
1.73989295193522E-13,
2.09363776315641E-14,
1.70493827389429E-13,
  0,
1.71715072716516E-13,
  0,
1.68070418693489E-13,
0.80610386859401,
1.5795004193464E-13,
0.420612120411218,
1.49717044317654E-13,
0.330010013747366,
1.46219841790085E-13,
0.288613187789042,
1.2912587665781E-13,
0.266120414384655,
1.28862198689461E-13,
0.253728929627619,
1.29892624434191E-13,
0.248093743880641,
1.36037014986101E-13,
0.247986837271477,
1.30794680641699E-13,
3.36150378366096E-14,
3.91050039572072E-14,
7.44578010358765E-14,
5.99806662671121E-14,
1.07696837559068E-13,
7.08452393971548E-14,
1.2787080422294E-13,
7.34958968684474E-14,
1.44962167270002E-13,
7.60606855276791E-14,
1.54144058628347E-13,
7.39391187165594E-14,
1.66932440093248E-13,
7.73148906008103E-14,
1.66899480347205E-13,
6.5669691906578E-14,
1.64894140008975E-13,
6.17665640856302E-14,
1.70991693027034E-13,
6.71702277132979E-14,
1.79370407416002E-13,
6.82422868214516E-14,
1.86342261065953E-13,
5.82832393458688E-14,
1.78865602884493E-13,
4.63223209790087E-14,
1.77248840604882E-13,
2.78648631946155E-14,
1.74532263641503E-13,
1.33053290607421E-14,
1.75890552123192E-13,
  0,
1.70571889945847E-13,
  0,
1.61700514089702E-13,
0.806065341930076,
1.53273227443407E-13,
0.420524964397106,
1.52263618380388E-13,
0.329905178251244,
1.37209688055862E-13,
0.288501045352923,
1.27238497515947E-13,
0.266006703791696,
1.26253174581592E-13,
0.253617336100692,
1.33615341013638E-13,
0.247986837271477,
1.3361881046059E-13,
0.247886535155959,
1.91071117261465E-14,
5.52656878594071E-14,
5.06704053715445E-14,
9.72390570841419E-14,
6.90975054951082E-14,
1.26461341398709E-13,
7.51551598732192E-14,
1.36678862672213E-13,
7.13023390330747E-14,
1.48004872246865E-13,
6.77426864603703E-14,
1.56962984276809E-13,
7.17152032203572E-14,
1.60952848271556E-13,
6.65231758567586E-14,
1.65312208366686E-13,
6.0734403617424E-14,
1.67470204370801E-13,
6.16954404231151E-14,
1.7728006562745E-13,
6.54788723242206E-14,
1.8818453739744E-13,
5.99416349889026E-14,
1.82260456726979E-13,
5.16687387319692E-14,
1.80836248753202E-13,
3.34628158515926E-14,
1.77774461818103E-13,
2.03292244149722E-14,
1.80017459272541E-13,
  0,
1.74863595825414E-13,
  0,
1.64569746718968E-13,
-1.33781874467331E-14,
1.57023699598469E-13,
0.806029556994419,
1.55667145840255E-13,
0.420443855925508,
1.43350609160819E-13,
0.329807436953708,
1.35239042187152E-13,
0.288396310882379,
1.24525389999519E-13,
0.265900332704196,
1.30392224795273E-13,
0.253512786520481,
1.3077733340694E-13,
0.247886535155959,
1.23914767335975E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.01118115616861E-14,
-1.00328816435291E-14,
  0,
  0,
  0,
  0,
  0,
0.999999999999995,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.59971862145891E-14,
1.87601670309512E-14,
2.54744142447194E-14,
2.15322551455621E-14,
2.5805312747762E-14,
1.66310108046241E-14,
2.56808463383607E-14,
1.08146998301084E-14,
2.55745945254571E-14,
1.90587563092537E-14,
3.16482950957209E-14,
1.50840711449218E-14,
2.97865031251288E-14,
1.78472688017184E-14,
2.86470066418465E-14,
1.14177330784448E-14,
2.45836337398053E-14,
1.62320244051495E-14,
3.16907958208823E-14,
2.14463863335013E-14,
3.57448445842401E-14,
2.41703358716538E-14,
3.92880172839227E-14,
2.12169691538033E-14,
3.10073147713474E-14,
  0,
1.02302064389215E-14,
  0,
  0,
  0,
  0,
-1.66696084019646E-14,
-1.50389683345464E-14,
-1.18002396048977E-14,
-1.25043204957098E-14,
  0,
  0,
  0,
0.866578244826234,
  0,
0.866506930318042,
  0,
  0,
1.13177696381417E-14,
  0,
1.24305947479808E-14,
  0,
1.10558263932692E-14,
  0,
2.0492722102583E-14,
2.36230306149832E-14,
3.58823214197113E-14,
3.49087078688193E-14,
4.44002473676264E-14,
3.30326044295504E-14,
4.46071131421366E-14,
2.37730841956552E-14,
4.43920074311155E-14,
2.58725332824561E-14,
4.95645191556093E-14,
2.95753005419286E-14,
5.32057037316847E-14,
2.85296959667836E-14,
5.06153279011823E-14,
2.53616572187809E-14,
4.60816280967169E-14,
2.39448218197769E-14,
4.87114688862977E-14,
3.26513989457045E-14,
5.83890574779033E-14,
3.95096282079788E-14,
6.49619247283795E-14,
3.93287832856082E-14,
6.08718804528952E-14,
3.35599603662473E-14,
  0,
  0,
  0,
  0,
  0,
-1.28703471491409E-14,
-1.32246644191092E-14,
-1.63833790284285E-14,
-1.55166678117435E-14,
-1.19513773877422E-14,
-1.36700546715662E-14,
  0,
0.839682074076694,
  0,
0.561020639516066,
  0,
0.839401691844484,
1.05505881808909E-14,
  0,
1.25741431156179E-14,
  0,
1.69400084237825E-14,
  0,
2.19733085893292E-14,
1.88148108204444E-14,
3.67657293498524E-14,
3.56277507496117E-14,
4.92769887394662E-14,
4.17205332781112E-14,
5.73460549879723E-14,
3.64044731859803E-14,
5.74757255678016E-14,
3.59556134865713E-14,
6.23693804935321E-14,
3.24228491277445E-14,
6.41414005242424E-14,
3.93999069481232E-14,
6.7242218737551E-14,
3.2233764268863E-14,
6.16156431432202E-14,
3.49659537435265E-14,
6.4320944404006E-14,
3.66564417708659E-14,
6.83047368665868E-14,
4.59163956856301E-14,
7.95119178831349E-14,
4.93069127194268E-14,
7.79255132643542E-14,
4.68427380218017E-14,
8.38400529556971E-14,
  0,
  0,
  0,
  0,
-1.0320303639455E-14,
  0,
-1.18620391287294E-14,
-1.30451205393456E-14,
-1.59256288712051E-14,
-1.607871821796E-14,
-1.04447700488564E-14,
0.828657323515795,
  0,
0.499597599026475,
  0,
0.49913957690152,
1.05154600305024E-14,
0.82801944722203,
1.12470796564956E-14,
  0,
1.66416359859145E-14,
  0,
2.70543136504653E-14,
1.71139144522492E-14,
3.70354788503668E-14,
2.97609159538581E-14,
4.83241918702859E-14,
4.07902878141186E-14,
5.99164814985009E-14,
4.34444147323632E-14,
6.7839830975025E-14,
4.7194886887425E-14,
7.29659388465365E-14,
4.10487616120392E-14,
7.42808592413269E-14,
4.07018169168438E-14,
7.53503162642666E-14,
4.15353515470507E-14,
7.54838899719168E-14,
4.04285979693775E-14,
7.72186134478936E-14,
4.62607382956115E-14,
8.11625072705269E-14,
4.81220965853346E-14,
8.631376863244E-14,
5.36376498772029E-14,
8.90901935557409E-14,
5.47981798826314E-14,
9.75382968837479E-14,
5.73621011801251E-14,
  0,
  0,
  0,
-1.02925480638394E-14,
  0,
  0,
  0,
-1.12093494208931E-14,
-1.32563231225458E-14,
-1.41796296926344E-14,
0.823008605159556,
  0,
0.4740049305501,
  0,
0.426979472140749,
  0,
0.472715661298871,
1.11529709079239E-14,
0.821842206717152,
1.52785770146657E-14,
  0,
2.63981544956771E-14,
1.40243719415345E-14,
4.15310147383607E-14,
2.7523122669848E-14,
4.77343858884538E-14,
3.40925204733722E-14,
5.77740980056696E-14,
4.16064752095657E-14,
6.90740867281825E-14,
5.32178467960165E-14,
8.18789480661053E-14,
5.13426107184856E-14,
8.3394229022371E-14,
4.84863885152897E-14,
8.39467384494696E-14,
4.19169907117656E-14,
8.20463488815371E-14,
4.89244061929739E-14,
8.95767834907524E-14,
5.07606109922953E-14,
9.24520876521839E-14,
5.67263250261796E-14,
9.74437544543072E-14,
5.4753944433994E-14,
9.39899200136374E-14,
5.79310904802455E-14,
1.06754015349875E-13,
6.41414005242424E-14,
1.17019241518967E-13,
  0,
  0,
-1.28425915735253E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.819908750057632,
-1.31830310556857E-14,
0.460747831424128,
  0,
0.396065602663699,
  0,
0.395087744724236,
  0,
0.458206199370175,
1.43895312332276E-14,
0.818005963084478,
2.49600687340923E-14,
1.16235146507826E-14,
4.0392168776382E-14,
2.41352077212653E-14,
5.175894435272E-14,
3.15832429653717E-14,
5.65736693602936E-14,
3.44247200190217E-14,
6.6122454733808E-14,
5.08499492513081E-14,
8.21417586727158E-14,
5.67748972835069E-14,
9.12958944554454E-14,
5.81991052572839E-14,
9.20262130388316E-14,
4.92227786308419E-14,
8.96288251950317E-14,
4.87526685688522E-14,
9.50732548243849E-14,
5.86579396166798E-14,
1.03659268668732E-13,
6.0658075784481E-14,
1.07525967296684E-13,
6.26478036114264E-14,
1.03951569574434E-13,
5.83665060727157E-14,
1.10479334014535E-13,
6.65075633454748E-14,
1.24838507586933E-13,
7.34325794615742E-14,
  0,
-1.66696084019646E-14,
-1.32793082086025E-14,
-1.18624728095984E-14,
  0,
  0,
  0,
  0,
0.81832070140422,
  0,
0.453422708564643,
-1.00037166050893E-14,
0.379788684871356,
  0,
0.361234485387961,
  0,
0.377271366210101,
1.28178717639926E-14,
0.449122314319854,
2.43607217731423E-14,
0.815415573525731,
3.85099938049471E-14,
2.16675635766883E-14,
5.01560598609174E-14,
2.7971548688388E-14,
6.00951580165265E-14,
3.15858450505857E-14,
6.44536507499183E-14,
4.32995653221191E-14,
7.86211373782209E-14,
5.39152056333592E-14,
9.09151226524685E-14,
6.31040358856083E-14,
9.92036314206857E-14,
5.84332929265408E-14,
9.69146637941343E-14,
5.55605908503232E-14,
1.01914136851899E-13,
5.80655315496337E-14,
1.08306592860874E-13,
6.80375894512864E-14,
1.17896144236074E-13,
6.60782192851705E-14,
1.13188972084011E-13,
6.57659690594947E-14,
1.19528519026968E-13,
6.64277660655799E-14,
1.27557686635527E-13,
7.52332224296381E-14,
1.39760598927285E-13,
-1.01118115616861E-14,
-1.5031378919339E-14,
-1.63541055697713E-14,
-1.30477226245596E-14,
-1.11594761209588E-14,
  0,
  0,
0.817829365003636,
  0,
0.449654968168671,
  0,
0.370705297905708,
  0,
0.343208060732594,
  0,
0.341549642247267,
1.02851754890665E-14,
0.365987581520815,
2.16727677471162E-14,
0.442952953483213,
3.77883488389408E-14,
0.813563406287824,
4.82322515260591E-14,
2.52532370015324E-14,
5.82806372606548E-14,
2.78102194051222E-14,
6.76828385004491E-14,
4.02698707713256E-14,
7.65403365687867E-14,
4.61054805445116E-14,
8.68740843151805E-14,
5.99902072462299E-14,
9.82625439349682E-14,
6.30268406909273E-14,
1.03501408832418E-13,
6.45421216471931E-14,
1.08628384065668E-13,
6.45828876488785E-14,
1.1455593418308E-13,
6.70435928995516E-14,
1.21876467251703E-13,
7.31185945124224E-14,
1.22840973504346E-13,
6.87713774816245E-14,
1.2806075644356E-13,
7.33892113746748E-14,
1.35889563490643E-13,
7.47162748337971E-14,
1.41676601006502E-13,
7.78890840713586E-14,
-1.00328816435291E-14,
-1.18123826692296E-14,
-1.54871775126519E-14,
-1.59264962329431E-14,
-1.32849460598994E-14,
  0,
0.81832070140422,
  0,
0.448487071131021,
  0,
0.366006144277868,
  0,
0.333075997265837,
  0,
0.322375669501036,
  0,
0.328980599731439,
1.94011473553246E-14,
0.358261049790113,
3.56173424087558E-14,
0.438522831088767,
4.70613131797748E-14,
0.812182645480835,
5.60280988270989E-14,
2.51153264851922E-14,
6.55560675189015E-14,
3.64101110372772E-14,
7.95032442657551E-14,
4.28207816427495E-14,
8.44038380853895E-14,
5.18612930378026E-14,
9.38277233686335E-14,
5.96077007197771E-14,
1.02173478011558E-13,
6.87895920781223E-14,
1.14721600275036E-13,
7.32408925174788E-14,
1.20831296357427E-13,
7.32903321365441E-14,
1.27601922084164E-13,
7.18158171819638E-14,
1.26310420456299E-13,
7.55107781857944E-14,
1.37168054692438E-13,
7.61005841676266E-14,
1.43845005351473E-13,
8.13724088111201E-14,
1.4942561077369E-13,
7.70512126324618E-14,
1.46835668624057E-13,
  0,
-1.24739628348802E-14,
-1.19492089833972E-14,
-1.60860907927329E-14,
-1.42073852682501E-14,
0.819908750057632,
  0,
0.449654968168671,
  0,
0.364545640705427,
  0,
0.327811823167887,
  0,
0.311541842568846,
  0,
0.308999618948279,
1.25012847296269E-14,
0.320322358686556,
3.30048488539347E-14,
0.352678940037468,
4.48573470035463E-14,
0.43520942057703,
5.48918549503341E-14,
0.811119994765025,
6.29982177535737E-14,
3.35582256427713E-14,
7.70668251437456E-14,
3.88447954358107E-14,
8.70805164088218E-14,
4.84837864300758E-14,
9.1177933259079E-14,
5.130618152549E-14,
9.74099273465256E-14,
6.51015699681956E-14,
1.13020703906841E-13,
7.73010128130025E-14,
1.26558485913364E-13,
8.16863937602719E-14,
1.33464420071228E-13,
7.77815312158481E-14,
1.31583979823269E-13,
7.39998340382186E-14,
1.40176065199782E-13,
8.25797763503999E-14,
1.52523826901785E-13,
8.37559188671122E-14,
1.56888391167342E-13,
8.34488728118643E-14,
1.54062526624976E-13,
6.83151452074426E-14,
  0,
  0,
-1.36557432028894E-14,
-1.04482394958083E-14,
0.823008605159556,
-1.31153768401227E-14,
0.453422708564643,
  0,
0.366006144277868,
  0,
0.326172415368014,
  0,
0.305894998476223,
  0,
0.297665051016871,
  0,
0.299746753126025,
2.58569207711723E-14,
0.314038642908484,
4.18467344109885E-14,
0.348484477158565,
5.19749174254791E-14,
0.43265283475681,
6.18984030698044E-14,
0.810281321675695,
7.4647753256496E-14,
3.59183169318378E-14,
8.46024639233889E-14,
4.44323397519319E-14,
9.35414939950974E-14,
4.77716824431873E-14,
9.44591627138891E-14,
5.67150493235857E-14,
1.08035108636884E-13,
7.33926808216268E-14,
1.24461205230908E-13,
8.55270715360845E-14,
1.38828185058948E-13,
8.59850385337424E-14,
1.37043154602168E-13,
7.97990146184091E-14,
1.4511829238284E-13,
8.08450528744231E-14,
1.55115503774894E-13,
9.00304136797203E-14,
1.65140470742564E-13,
8.56086035394554E-14,
1.61154076194769E-13,
7.45323941453435E-14,
1.5695431065943E-13,
  0,
  0,
  0,
0.828657323515795,
  0,
0.460747831424128,
  0,
0.370705297905708,
  0,
0.327811823167887,
  0,
0.304133738653958,
  0,
0.291742717215662,
1.40443212615082E-14,
0.288039162343556,
2.24273724591662E-14,
0.293009675735401,
3.50847823016309E-14,
0.309300230146703,
4.94517621296708E-14,
0.345236255728317,
5.89936086092813E-14,
0.430630968858888,
7.33814051190329E-14,
0.809605758724921,
8.17002715480797E-14,
4.12378464709207E-14,
9.1023542869717E-14,
4.36421732086245E-14,
9.67247115735148E-14,
5.31207022813618E-14,
1.04794645183759E-13,
6.48422288085371E-14,
1.19274382037737E-13,
8.152332975353E-14,
1.36507125048091E-13,
8.96852037080009E-14,
1.42177936091059E-13,
8.7811702353946E-14,
1.50258278042159E-13,
8.64811694478718E-14,
1.597437460088E-13,
8.81534428787134E-14,
1.67407754325666E-13,
9.1697482940134E-14,
1.69033190222656E-13,
7.6515183078385E-14,
1.63664221064508E-13,
6.88251539093798E-14,
  0,
  0,
0.839682074076694,
  0,
0.4740049305501,
  0,
0.379788684871356,
  0,
0.333075997265837,
  0,
0.305894998476223,
  0,
0.289893362931038,
1.69898817237168E-14,
0.281910206994882,
2.73661301952721E-14,
0.281015257397317,
3.12874726127177E-14,
0.287916349412354,
4.25510321422351E-14,
0.305620403204274,
5.63915233953161E-14,
0.342659893737278,
7.01721666884758E-14,
0.428999611070099,
8.01858579535519E-14,
0.809052287353909,
8.78238454182778E-14,
4.04207917137356E-14,
9.40116040570871E-14,
4.88463436365549E-14,
1.06902334207071E-13,
6.11299205699467E-14,
1.15919426835198E-13,
7.28566512675499E-14,
1.31042746098764E-13,
8.54646214909494E-14,
1.39622688410945E-13,
9.13522729684146E-14,
1.55092952369706E-13,
9.43325279001428E-14,
1.64616584252819E-13,
9.36160871045644E-14,
1.71708133822612E-13,
8.96505092384814E-14,
1.70996897197462E-13,
8.25051832409329E-14,
1.71257105718858E-13,
7.07506969677141E-14,
1.59587620895962E-13,
  0,
0.866578244826234,
  0,
0.499597599026475,
  0,
0.396065602663699,
  0,
0.343208060732594,
  0,
0.311541842568846,
  0,
0.291742717215662,
1.70089636819526E-14,
0.27999456517243,
3.01078606490535E-14,
0.274726578640893,
3.65506236388313E-14,
0.275695875616057,
3.88552037766665E-14,
0.283952722083614,
4.87856283148957E-14,
0.302695025747667,
6.73098729531141E-14,
0.340576178305805,
7.74484643084605E-14,
0.427661241693388,
8.66320903902817E-14,
0.808592313833832,
9.08197128612898E-14,
4.56197579712381E-14,
1.03991468214382E-13,
5.67584174104852E-14,
1.17838030999629E-13,
6.90645457490646E-14,
1.2747441990868E-13,
7.67285540659302E-14,
1.34003919072256E-13,
8.70432198540882E-14,
1.52327803148999E-13,
9.77724845530048E-14,
1.69194519505922E-13,
1.01351219083945E-13,
1.7633984550347E-13,
9.50021311618698E-14,
1.75019720938252E-13,
8.03367788959619E-14,
1.72957134725316E-13,
7.66105928695637E-14,
1.66880398388969E-13,
6.65387883680424E-14,
0.999999999999995,
  0,
0.561020639516066,
  0,
0.426979472140749,
  0,
0.361234485387961,
  0,
0.322375669501036,
  0,
0.297665051016871,
1.40304434737004E-14,
0.281910206994882,
3.01356162246691E-14,
0.272759563488397,
3.92116894509797E-14,
0.26928078000423,
4.39891179038199E-14,
0.271550505698249,
4.54428161766884E-14,
0.280796403340974,
6.0063932993959E-14,
0.300324575772915,
7.42912675821827E-14,
0.338863322020912,
8.33846880432532E-14,
0.426547683006025,
8.89496809541868E-14,
0.808205334958438,
1.00742331143877E-13,
5.35786692790197E-14,
1.14845633003569E-13,
6.45577341584769E-14,
1.29254246195032E-13,
7.28011401163187E-14,
1.30284671939762E-13,
7.81267411875675E-14,
1.46513010057525E-13,
9.33021021554126E-14,
1.66238550702857E-13,
1.04678418710868E-13,
1.80711348662932E-13,
1.02605424157076E-13,
1.79448469972421E-13,
8.55409493238923E-14,
1.76813425012412E-13,
7.43207578812743E-14,
1.68406955047828E-13,
7.22737841796217E-14,
1.66686109359659E-13,
  0,
0.866506930318042,
  0,
0.49913957690152,
  0,
0.395087744724236,
  0,
0.341549642247267,
  0,
0.308999618948279,
  0,
0.288039162343556,
2.73661301952721E-14,
0.274726578640893,
3.92116894509797E-14,
0.267273020544669,
4.64975280500823E-14,
0.265033423717073,
5.03243280380872E-14,
0.268245637656274,
5.65623936576998E-14,
0.278235237034342,
6.71303290733505E-14,
0.298372958590031,
8.01823885066E-14,
0.337435826637575,
8.60075899389301E-14,
0.425609927317424,
9.92296522728253E-14,
0.807876292865122,
1.11324144347336E-13,
6.12947193001645E-14,
1.26126539767846E-13,
6.83376966126303E-14,
1.31875413367233E-13,
7.4195857791004E-14,
1.42705292027756E-13,
8.43942971062717E-14,
1.60267632498545E-13,
1.00067523711722E-13,
1.77576703341842E-13,
1.05797315352874E-13,
1.83693338318136E-13,
9.3118221466959E-14,
1.81042680846843E-13,
7.94607435405936E-14,
1.72048139623904E-13,
6.99267033166251E-14,
1.67971539455358E-13,
6.36019015232137E-14,
  0,
  0,
0.839401691844484,
1.05145926687644E-14,
0.472715661298871,
  0,
0.377271366210101,
1.03415540020357E-14,
0.328980599731439,
1.25012847296269E-14,
0.299746753126025,
2.24551280347818E-14,
0.281015257397317,
3.65228680632157E-14,
0.26928078000423,
4.65044669439862E-14,
0.262992738815516,
5.31207022813618E-14,
0.261644959342123,
6.14118131347929E-14,
0.265561344040425,
6.32462832106384E-14,
0.27612412376483,
7.28792026727376E-14,
0.296744327457143,
8.29822321968265E-14,
0.336232016369999,
9.56231621662695E-14,
0.42481190648177,
1.09667483427778E-13,
0.807593899275311,
1.223604551015E-13,
6.49636594518554E-14,
1.28659236042772E-13,
6.956241138667E-14,
1.44268277879611E-13,
8.03159622142502E-14,
1.56303789355938E-13,
9.10781866592103E-14,
1.71477415600307E-13,
1.01234992611055E-13,
1.80366138691213E-13,
9.62285806593854E-14,
1.85114076844961E-13,
8.6911380869914E-14,
1.76175046773253E-13,
7.49851569725735E-14,
1.7145486419512E-13,
6.11524719751344E-14,
1.6722040419026E-13,
  0,
  0,
1.05384451165591E-14,
0.82801944722203,
1.11529709079239E-14,
0.458206199370175,
1.28196064874686E-14,
0.365987581520815,
1.94583932300318E-14,
0.320322358686556,
2.58300325572947E-14,
0.293009675735401,
3.13239018057132E-14,
0.275695875616057,
4.3905851176973E-14,
0.265033423717073,
5.31397842395975E-14,
0.259577248701038,
6.40720115852034E-14,
0.258891211739607,
6.80844269851377E-14,
0.263346940991771,
6.91564860932914E-14,
0.274360639242004,
7.55073087388425E-14,
0.295369351977911,
9.24139237357124E-14,
0.335206361747439,
1.06289976820051E-13,
0.42412653221918,
1.20733284481034E-13,
0.807349539459807,
1.25333771139324E-13,
6.62820492935978E-14,
1.40819647609369E-13,
7.58629270514177E-14,
1.57701976477576E-13,
8.69720961915732E-14,
1.67386937643954E-13,
9.20964693396087E-14,
1.74112460560316E-13,
9.15188064221084E-14,
1.81696671597287E-13,
8.99679636345851E-14,
1.80062562082917E-13,
8.23230372759554E-14,
1.75439524019438E-13,
6.611725056338E-14,
1.70526787135472E-13,
6.10084899266283E-14,
  0,
1.12319008260808E-14,
  0,
1.12401407625917E-14,
0.821842206717152,
1.44060111062494E-14,
0.449122314319854,
2.17291462600855E-14,
0.358261049790113,
3.31158711563972E-14,
0.314038642908484,
3.50318732356136E-14,
0.287916349412354,
3.8820509307147E-14,
0.271550505698249,
5.03251953998252E-14,
0.261644959342123,
6.4100634522557E-14,
0.256801021442205,
7.10612124699139E-14,
0.256618428611851,
7.39772826330309E-14,
0.261495896417164,
7.1729081008165E-14,
0.272870546772145,
8.51974740756489E-14,
0.294196730450799,
1.03160535669389E-13,
0.334324578831601,
1.17173631908329E-13,
0.423533099038172,
1.23113325090074E-13,
0.807136535329921,
1.37610409178812E-13,
7.22130688579625E-14,
1.54232529525622E-13,
8.22449747195364E-14,
1.68726144167408E-13,
8.78897649103649E-14,
1.69923103365832E-13,
8.23542622985229E-14,
1.75299011417884E-13,
8.52286990982165E-14,
1.76528930362352E-13,
8.53570686354388E-14,
1.79262854560491E-13,
7.34880906128055E-14,
1.74381342699093E-13,
6.59628601740181E-14,
1.77640888110453E-13,
  0,
  0,
1.2491743750509E-14,
  0,
1.52751075677138E-14,
0.818005963084478,
2.42176070863742E-14,
0.442952953483213,
3.56190771322318E-14,
0.352678940037468,
4.18502038579405E-14,
0.309300230146703,
4.25380217161653E-14,
0.283952722083614,
4.54506224323303E-14,
0.268245637656274,
6.14022721556751E-14,
0.258891211739607,
7.10161096595385E-14,
0.254509324412512,
7.65689595061403E-14,
0.254717810640862,
7.67996777284452E-14,
0.25993089113244,
8.15614936700015E-14,
0.271598818109285,
9.5590202420226E-14,
0.293187752428238,
1.14444911880618E-13,
0.333560401961405,
1.1997174087508E-13,
0.423015533807655,
1.35266797762768E-13,
0.806949637906882,
1.50504608775748E-13,
7.8756445809347E-14,
1.65105776273045E-13,
8.32632573999348E-14,
1.71239758484099E-13,
7.81336800814714E-14,
1.71057612519121E-13,
7.60849716563428E-14,
1.70051472903054E-13,
8.05449457130791E-14,
1.75547076874949E-13,
7.64544677567258E-14,
1.78105794002015E-13,
7.32556376670246E-14,
1.81361869966423E-13,
5.83821185839994E-14,
  0,
1.24444725357886E-14,
  0,
1.66346970920106E-14,
  0,
2.49461909462845E-14,
0.815415573525731,
3.77154904529498E-14,
0.438522831088767,
4.48105094696949E-14,
0.348484477158565,
4.94500274061949E-14,
0.305620403204274,
4.87769546975159E-14,
0.280796403340974,
5.65103519534205E-14,
0.265561344040425,
6.80844269851377E-14,
0.256618428611851,
7.66140623165157E-14,
0.25259263235131,
7.91918614018172E-14,
0.253110330731196,
8.63181054411299E-14,
0.258594543458363,
9.17252385157497E-14,
0.270503867160065,
1.06617839557011E-13,
0.292312707154142,
1.16353107704192E-13,
0.332893400862314,
1.31917046730656E-13,
0.422561187549681,
1.48409062816768E-13,
0.80678467027483,
1.61507959783869E-13,
7.96793186985667E-14,
1.67477143264705E-13,
7.3448191972858E-14,
1.72218142524549E-13,
7.1807143564584E-14,
1.65659153061881E-13,
7.13144820974065E-14,
1.68988087412281E-13,
7.16145892587505E-14,
1.7429634124877E-13,
7.614221753105E-14,
1.84930196156508E-13,
6.56315279901065E-14,
1.8323884076743E-13,
  0,
  0,
1.69408757855205E-14,
  0,
2.63981544956771E-14,
1.16131063099267E-14,
3.85047896345192E-14,
0.813563406287824,
4.71480493535736E-14,
0.43520942057703,
5.1983591042859E-14,
0.345236255728317,
5.63533594788446E-14,
0.302695025747667,
6.00674024409109E-14,
0.278235237034342,
6.32497526575904E-14,
0.263346940991771,
7.39616701217471E-14,
0.254717810640862,
7.92473725530485E-14,
0.250971370269471,
8.89375378898549E-14,
0.25173729886463,
9.64575641582144E-14,
0.257443443049036,
1.02815325697669E-13,
0.26955373287978,
1.08807060583693E-13,
0.291548447651643,
1.2837127194576E-13,
0.332307469190313,
1.44896247777915E-13,
0.422159983811724,
1.59382923525797E-13,
0.80663827162182,
1.63841162859057E-13,
6.97254753934118E-14,
1.68469405092964E-13,
6.71442068611583E-14,
1.66689578806611E-13,
6.71390026907304E-14,
1.64594032847631E-13,
6.23615742378902E-14,
1.67693983699202E-13,
7.13144820974065E-14,
1.81087783657219E-13,
6.85562717706034E-14,
1.866926752081E-13,
6.02573546615304E-14,
  0,
1.10215656046186E-14,
  0,
2.70681914382731E-14,
1.40217698563205E-14,
4.03991076702859E-14,
2.1689247620138E-14,
4.82270473556312E-14,
0.812182645480835,
5.48927223120721E-14,
0.43265283475681,
5.893809745805E-14,
0.342659893737278,
6.73645167426073E-14,
0.300324575772915,
6.71580846489661E-14,
0.27612412376483,
6.91183221768199E-14,
0.261495896417164,
7.67823304936854E-14,
0.253110330731196,
8.89167212081432E-14,
0.249586427745327,
9.93684301509035E-14,
0.250554287576397,
1.07710715346876E-13,
0.256444195693344,
1.05146794049382E-13,
0.268723485293086,
1.20731549757558E-13,
0.290876699962826,
1.41674866283026E-13,
0.331789756160628,
1.55741738949722E-13,
0.421803807089895,
1.61629390427187E-13,
0.806507710631611,
1.64764035748277E-13,
6.36591473979209E-14,
1.63145538745191E-13,
6.23442270031305E-14,
1.65638336380169E-13,
5.81340531269348E-14,
1.63124722063479E-13,
6.2004221201839E-14,
1.74369199634761E-13,
6.36556779509689E-14,
1.82758322364585E-13,
6.31699553776954E-14,
1.87938206663851E-13,
  0,
  0,
2.19845842919231E-14,
1.71165165374632E-14,
4.15310147383607E-14,
2.41707695525228E-14,
5.0185550160009E-14,
2.5281859938886E-14,
5.60463134235967E-14,
0.811119994765026,
6.18992704315424E-14,
0.430630968858888,
7.02988015022221E-14,
0.340576178305805,
7.4272185623947E-14,
0.298372958590031,
7.2853181820598E-14,
0.274360639242004,
7.1729081008165E-14,
0.25993089113244,
8.62643290133747E-14,
0.25173729886463,
9.92868981475326E-14,
0.248393050017044,
1.10413414522448E-13,
0.249527101539594,
1.09842690498851E-13,
0.255570731921804,
1.17347104255927E-13,
0.267993421819216,
1.33964020432309E-13,
0.29028286541914,
1.52327803148999E-13,
0.331329897391818,
1.58021165597155E-13,
0.421486056258074,
1.62786450985664E-13,
0.806390747358941,
1.59209451178199E-13,
5.86666132340596E-14,
1.61757759964409E-13,
5.33774413558064E-14,
1.64196781171633E-13,
5.77784348143595E-14,
1.69792999105134E-13,
5.43384781614975E-14,
1.75987696637847E-13,
5.82589532172051E-14,
1.83944873222153E-13,
6.08211397912228E-14,
  0,
2.05048651669149E-14,
1.88286886082523E-14,
3.70302746799389E-14,
2.7521387946372E-14,
5.175894435272E-14,
2.79290479632266E-14,
5.83083928362704E-14,
2.50355292052973E-14,
6.29843399657659E-14,
0.810281321675695,
7.3370996778177E-14,
0.428999611070099,
7.73790753694215E-14,
0.338863322020912,
8.0178919059648E-14,
0.296744327457143,
7.55281254205542E-14,
0.272870546772145,
8.15944534160451E-14,
0.258594543458363,
9.64263391356468E-14,
0.250554287576397,
1.10453313162395E-13,
0.247356783642342,
1.12689371722929E-13,
0.248629032888098,
1.22077695174916E-13,
0.254802433340246,
1.301736496373E-13,
0.267347787498848,
1.44904921395295E-13,
0.289755156653472,
1.54711313204992E-13,
0.330919452001655,
1.58675156347599E-13,
0.421201313556169,
1.56805124440496E-13,
0.806285529580527,
1.57974328063304E-13,
4.97865637605344E-14,
1.60371715907104E-13,
5.30114147023752E-14,
1.70780056762965E-13,
5.0036363941075E-14,
1.71366393297845E-13,
4.88966506173583E-14,
1.77082307151188E-13,
5.58372792447415E-14,
1.86812371127942E-13,
1.59971862145891E-14,
2.36009128906645E-14,
3.67466473916167E-14,
2.97539770599542E-14,
4.77291817180259E-14,
3.15485484958522E-14,
6.01194441451902E-14,
2.77824638295066E-14,
6.55612716893295E-14,
3.35877159418629E-14,
7.46685699382077E-14,
0.809605758724921,
8.00123856059543E-14,
0.427661241693388,
8.33881574902051E-14,
0.337435826637575,
8.29683544090187E-14,
0.295369351977911,
8.51679837765573E-14,
0.271598818109285,
9.17113607279418E-14,
0.257443443049036,
1.07767961221583E-13,
0.249527101539594,
1.12633860571698E-13,
0.246450714837793,
1.24627738684602E-13,
0.247838949121216,
1.34978833665755E-13,
0.254122801737251,
1.40925465741404E-13,
0.26677385047698,
1.47097611868929E-13,
0.289283964164355,
1.55287241399016E-13,
0.330551484514822,
1.5329751357207E-13,
0.420945095881628,
1.55655002775923E-13,
0.80619051404161,
1.56296850462034E-13,
4.94135982131994E-14,
1.66916827581964E-13,
4.52398535299992E-14,
1.7232569538006E-13,
4.45459641396084E-14,
1.72412431553859E-13,
4.65322225196019E-14,
1.79928988375266E-13,
4.54688370288281E-14,
1.87601670309512E-14,
3.58701783553794E-14,
3.56381590904675E-14,
4.8316385614644E-14,
3.40925204733722E-14,
5.65736693602936E-14,
3.15398748784723E-14,
6.76654912656893E-14,
3.6427458272037E-14,
7.70963154428372E-14,
3.59183169318378E-14,
8.16586381846562E-14,
0.809052287353909,
8.6614743155522E-14,
0.426547683006025,
8.59937121511223E-14,
0.336232016369999,
9.24191279061404E-14,
0.294196730450799,
9.56595913592651E-14,
0.270503867160065,
1.02794509015958E-13,
0.256444195693344,
1.09896466926607E-13,
0.248629032888098,
1.24575696980322E-13,
0.245653545111879,
1.3774918705689E-13,
0.247139934048973,
1.45871162371414E-13,
0.253518496677608,
1.4313897289675E-13,
0.26626122329115,
1.47668335892526E-13,
0.288861385074855,
1.49746534616746E-13,
0.330220250145952,
1.52019022370276E-13,
0.42071366559964,
1.53994872409413E-13,
0.806104405933574,
1.63015434484493E-13,
4.15448925261686E-14,
1.68339300832265E-13,
3.97754745806722E-14,
1.73309283590939E-13,
4.22301082991794E-14,
1.75191458562374E-13,
3.60319413195143E-14,
1.83193737957055E-13,
2.54744142447194E-14,
3.48952637618805E-14,
4.9290866527274E-14,
4.08310538158041E-14,
5.77784348143595E-14,
3.44333936364016E-14,
6.44258951743026E-14,
4.02672686861116E-14,
7.94997748188031E-14,
3.88586732236185E-14,
8.46440972868123E-14,
4.12690714934882E-14,
8.78169065243739E-14,
0.808592313833832,
8.89219253785711E-14,
0.425609927317424,
9.56162232723656E-14,
0.335206361747439,
1.03160535669389E-13,
0.293187752428238,
1.06619574280487E-13,
0.26955373287978,
1.05132916261574E-13,
0.255570731921804,
1.22095042409676E-13,
0.247838949121216,
1.37681532841327E-13,
0.244948223202212,
1.48383041964628E-13,
0.246518304448608,
1.47905993008735E-13,
0.252978628330951,
1.44124295831105E-13,
0.265801357337524,
1.42191813878867E-13,
0.288480867885567,
1.48294571067353E-13,
0.329920954996718,
1.50572262991311E-13,
0.420503884996739,
1.60286714456781E-13,
0.806026111894307,
1.64469132757361E-13,
3.61603108567365E-14,
1.69281255679721E-13,
3.740063814206E-14,
1.76005043872607E-13,
3.17228882051879E-14,
1.78430187292022E-13,
2.53339016431653E-14,
2.15322551455621E-14,
4.44071862615303E-14,
4.17018850007445E-14,
5.99589822236624E-14,
4.16168835504216E-14,
6.60990359668823E-14,
4.32475236178398E-14,
7.65724289530922E-14,
4.28207816427495E-14,
8.70943941966296E-14,
4.44080536232683E-14,
9.09957872941014E-14,
4.04780375884428E-14,
9.08422642664775E-14,
0.808205334958438,
9.92313869963013E-14,
0.42481190648177,
1.06286507373099E-13,
0.334324578831601,
1.14517770266609E-13,
0.292312707154143,
1.08878184246208E-13,
0.268723485293086,
1.17333226468119E-13,
0.254802433340246,
1.34994446177039E-13,
0.247139934048973,
1.48358755835964E-13,
0.244320955024998,
1.50665938059014E-13,
0.245962887124029,
1.48618964357361E-13,
0.25249423030104,
1.38309502739631E-13,
0.265387161351775,
1.41105876982905E-13,
0.288136941425743,
1.46853015858817E-13,
0.329649571290566,
1.57020230151517E-13,
0.420313103145815,
1.61409080545738E-13,
0.80595470315778,
1.65145674912992E-13,
3.37768008007444E-14,
1.71971811790961E-13,
2.69870931157712E-14,
1.79200404515356E-13,
2.10335221462188E-14,
1.77972220294365E-13,
2.5805312747762E-14,
3.30317370678124E-14,
5.73460549879723E-14,
4.34418126471492E-14,
6.90471985143049E-14,
5.08378061869763E-14,
7.86211373782209E-14,
4.61037458210356E-14,
8.44038380853895E-14,
4.84872558770277E-14,
9.35623106768091E-14,
4.36421732086245E-14,
9.40324207387988E-14,
4.55902676721465E-14,
1.00714575568261E-13,
0.807876292865122,
1.0965360563997E-13,
0.42412653221918,
1.17284654210792E-13,
0.333560401961405,
1.16346168810288E-13,
0.291548447651643,
1.20870327635636E-13,
0.267993421819216,
1.30192731595535E-13,
0.25412280173725,
1.45843406795798E-13,
0.246518304448608,
1.50613896354734E-13,
0.243760475676108,
1.51460441411011E-13,
0.245464479716795,
1.43015807529956E-13,
0.252057861474091,
1.36911315617994E-13,
0.265012710021123,
1.39216763117567E-13,
0.287825005756977,
1.53266288549503E-13,
0.329402693552313,
1.58470458977433E-13,
0.420139067123619,
1.62340627052338E-13,
0.80588938640362,
1.6797500890231E-13,
2.31741709155742E-14,
1.74967679233973E-13,
1.61815005839117E-14,
1.78679987472563E-13,
1.49463774690162E-14,
1.66310108046241E-14,
4.4575888119569E-14,
3.64044731859803E-14,
6.78042691437675E-14,
5.32187141577545E-14,
8.21382892257638E-14,
5.39420938472368E-14,
8.68602065273727E-14,
5.18630277612786E-14,
9.11501776834633E-14,
4.77786213370912E-14,
9.67229768500388E-14,
4.88376700191751E-14,
1.03974120979622E-13,
5.3556117873832E-14,
1.11386594392471E-13,
0.807593899275311,
1.20707263628894E-13,
0.423533099038172,
1.19970006151604E-13,
0.332893400862314,
1.28353924711E-13,
0.290876699962826,
1.33964020432309E-13,
0.267347787498848,
1.40866485143221E-13,
0.253518496677608,
1.47892115220927E-13,
0.245962887124029,
1.51443094176251E-13,
0.243257506382149,
1.45531156570122E-13,
0.245015443295157,
1.41659253771742E-13,
0.251663301714693,
1.35320574190523E-13,
0.264673018989718,
1.45793099814995E-13,
0.287541169230563,
1.54700904864136E-13,
0.329177425601346,
1.59341290162374E-13,
0.419979851723018,
1.65693847531401E-13,
0.805829480507479,
1.71140879245968E-13,
1.23564353193828E-14,
1.74586040069258E-13,
1.00718045015213E-14,
1.85060300417206E-13,
2.56808463383607E-14,
2.37574716843714E-14,
5.74635825034697E-14,
4.71653965883334E-14,
8.18789480661053E-14,
5.67349986435595E-14,
9.08873670768529E-14,
5.99771968201601E-14,
9.38589483912011E-14,
5.12923037376822E-14,
9.44556932669371E-14,
5.3177948156069E-14,
1.06952641187874E-13,
5.67653563043891E-14,
1.14814407981001E-13,
6.12947193001645E-14,
1.22308413397221E-13,
0.807349539459807,
1.23121998707454E-13,
0.423015533807655,
1.31861535579425E-13,
0.332307469190313,
1.41732112157733E-13,
0.29028286541914,
1.44904921395295E-13,
0.26677385047698,
1.43079992298567E-13,
0.252978628330951,
1.48667536614688E-13,
0.245464479716795,
1.45503400994507E-13,
0.242804344112431,
1.4438103490555E-13,
0.244609390845041,
1.39914121954909E-13,
0.251305316746855,
1.41742520498589E-13,
0.26436386937784,
1.46771483855446E-13,
0.287282120323139,
1.5570357503325E-13,
0.32897129098116,
1.62063071296181E-13,
0.419833803351713,
1.68231747976755E-13,
0.805774397855582,
1.70297803636643E-13,
  0,
1.80865739052294E-13,
  0,
1.08146998301084E-14,
4.44019820911024E-14,
3.5972960721331E-14,
7.29798166343443E-14,
5.13634274001973E-14,
9.1323650031061E-14,
6.31317914612239E-14,
9.82868300636319E-14,
5.95955576554452E-14,
9.74133967934776E-14,
5.67046409827299E-14,
1.04798114630711E-13,
6.11368594638506E-14,
1.17838030999629E-13,
6.45022230072456E-14,
1.2613347866175E-13,
6.49671288988074E-14,
1.25347648927132E-13,
0.807136535329921,
1.35280675550575E-13,
0.422561187549681,
1.44868492202299E-13,
0.331789756160628,
1.52300047573384E-13,
0.289755156653472,
1.47055978505506E-13,
0.26626122329115,
1.44131234725009E-13,
0.25249423030104,
1.43029685317764E-13,
0.245015443295157,
1.44384504352502E-13,
0.242394547751051,
1.42502329381067E-13,
0.244240946493057,
1.46356884944687E-13,
0.250979474668241,
1.43079992298567E-13,
0.264081669647444,
1.4777415402456E-13,
0.28704502595561,
1.58130453176142E-13,
0.328782161390263,
1.64640870381483E-13,
0.419699494913373,
1.67955926944074E-13,
0.805723629220057,
1.76452602529409E-13,
  0,
1.77746706242488E-13,
2.55745945254571E-14,
2.58586554946483E-14,
6.23555027057243E-14,
4.10487616120392E-14,
8.33664734467554E-14,
5.81730844051442E-14,
9.91914883563538E-14,
6.30103608179056E-14,
1.02173478011558E-13,
6.51293255438112E-14,
1.08055925318595E-13,
6.48422288085371E-14,
1.15921161558674E-13,
6.90576068551607E-14,
1.29228225342892E-13,
6.83394313361063E-14,
1.28617602679348E-13,
6.62820492935978E-14,
1.3760693973186E-13,
0.806949637906881,
1.48357021112488E-13,
0.422159983811724,
1.55743473673198E-13,
0.331329897391818,
1.54714782651943E-13,
0.289283964164356,
1.47685683127285E-13,
0.265801357337524,
1.38264399929255E-13,
0.252057861474091,
1.41791092755916E-13,
0.244609390845041,
1.42495390487163E-13,
0.242022695497213,
1.48978052116888E-13,
0.243905557539589,
1.47491394097976E-13,
0.250682001435461,
1.43763473348102E-13,
0.263823345932029,
1.50549711586123E-13,
0.286827450176147,
1.61148872024341E-13,
0.328608199066353,
1.63920960138952E-13,
0.419575689263865,
1.74180114775879E-13,
0.805676731434855,
1.73434183681209E-13,
  0,
1.90587563092537E-14,
4.95584476234434E-14,
3.24089713399367E-14,
7.42973391143487E-14,
4.85002663030976E-14,
9.20036616336439E-14,
5.84471707143486E-14,
1.0353089913151E-13,
6.88017351424541E-14,
1.13024173353793E-13,
7.33649252460111E-14,
1.19263973696881E-13,
7.28080790102226E-14,
1.2747441990868E-13,
7.28167526276025E-14,
1.319066383898E-13,
6.95277169171504E-14,
1.4079362675723E-13,
7.22408244335782E-14,
1.50563589373931E-13,
0.80678467027483,
1.59315269310234E-13,
0.421803807089895,
1.5799341002154E-13,
0.330919452001655,
1.55290710845968E-13,
0.288861385074855,
1.42177936091059E-13,
0.265387161351775,
1.3686968225457E-13,
0.251663301714693,
1.39917591401861E-13,
0.244240946493057,
1.49075196631543E-13,
0.241684195453552,
1.50334605875102E-13,
0.243599346366948,
1.48344878048157E-13,
0.25040966607048,
1.46438416948058E-13,
0.263586254272056,
1.53370371958061E-13,
0.286627288643884,
1.60527841019942E-13,
0.328447810077916,
1.70401887045202E-13,
0.419461309416782,
1.71210268185007E-13,
0.805633317290993,
1.69683711526147E-13,
3.16482950957209E-14,
2.95891783297364E-14,
6.41223185660067E-14,
4.07122252576997E-14,
8.39588815138015E-14,
4.91950230552263E-14,
9.69406846462739E-14,
6.45525299880489E-14,
1.14704253040276E-13,
7.72732572373869E-14,
1.24488960806524E-13,
8.152332975353E-14,
1.31068766950904E-13,
7.67285540659302E-14,
1.30300284451046E-13,
7.41542244275806E-14,
1.44261338985707E-13,
7.58091506236624E-14,
1.54230794802146E-13,
7.88050180666744E-14,
1.61535715359484E-13,
0.80663827162182,
1.61629390427187E-13,
0.421486056258074,
1.58676891071075E-13,
0.330551484514822,
1.49829801343593E-13,
0.288480867885567,
1.41085060301194E-13,
0.265012710021123,
1.3536914644785E-13,
0.251305316746855,
1.46280557111744E-13,
0.243905557539589,
1.50362361450718E-13,
0.241375136380077,
1.5096951466731E-13,
0.243318992769202,
1.51011148030733E-13,
0.250159688753005,
1.49127238335822E-13,
0.263368109860218,
1.52811790998797E-13,
0.286442715475894,
1.67046931842663E-13,
0.328299606210107,
1.67251629212828E-13,
0.419355414101021,
1.66693048253563E-13,
0.805593047202749,
1.50840711449218E-14,
5.32057037316847E-14,
3.94276625237389E-14,
7.53641940520744E-14,
4.19464810108572E-14,
8.96288251950317E-14,
5.55605908503232E-14,
1.08628384065668E-13,
7.32565050287626E-14,
1.26548077572508E-13,
8.55565618351761E-14,
1.36505390324615E-13,
8.54958465135169E-14,
1.33977898220117E-13,
7.81267411875675E-14,
1.42707026751232E-13,
8.03229011081541E-14,
1.57684629242816E-13,
8.22675261247241E-14,
1.65078020697429E-13,
7.97070742741823E-14,
1.63799529495634E-13,
0.806507710631611,
1.62730939834432E-13,
0.421201313556169,
1.53186491269608E-13,
0.330220250145952,
1.48357021112488E-13,
0.288136941425743,
1.39180333924571E-13,
0.264673018989718,
1.41721703816877E-13,
0.250979474668241,
1.47494863544928E-13,
0.243599346366948,
1.51025025818541E-13,
0.241092169095209,
1.5366007077855E-13,
0.243061639715436,
1.53908136235614E-13,
0.249929666693581,
1.48731721383299E-13,
0.263166929605613,
1.58768831415301E-13,
0.286272139844074,
1.63733610003547E-13,
0.328162373672544,
1.63227070748562E-13,
0.419257177592155,
1.67723473998294E-13,
2.97865031251288E-14,
2.85453084780674E-14,
6.72283409497432E-14,
4.15379536322646E-14,
8.2050685690227E-14,
4.87561380158041E-14,
1.01907197957996E-13,
6.45846223723545E-14,
1.20807010228763E-13,
8.16898632072238E-14,
1.38817776718092E-13,
8.96886731549529E-14,
1.39646974539609E-13,
8.70189337254246E-14,
1.46547704527045E-13,
8.43960318297476E-14,
1.5630725880289E-13,
8.70137295549966E-14,
1.68698388591793E-13,
8.32077462487035E-14,
1.67506633563796E-13,
6.97133323290799E-14,
1.64710259320522E-13,
0.806390747358941,
1.56879717549963E-13,
0.420945095881628,
1.52060655733699E-13,
0.329920954996718,
1.46851281135341E-13,
0.287825005756977,
1.4573064976986E-13,
0.26436386937784,
1.43079992298567E-13,
0.250682001435461,
1.48344878048157E-13,
0.243318992769202,
1.53689561077641E-13,
0.240832411486507,
1.56537977025195E-13,
0.242824817324802,
1.53481394260524E-13,
0.24971751393617,
1.55004481472432E-13,
0.262980985208484,
1.55774698695765E-13,
0.286114170317583,
1.59445373570932E-13,
0.328035047259709,
1.63671159958412E-13,
0.419165872979246,
1.78472688017184E-14,
5.05997153898985E-14,
3.22476420566709E-14,
7.55099108240564E-14,
4.89365492573057E-14,
9.50732548243849E-14,
5.804124542097E-14,
1.1455593418308E-13,
7.33050772860899E-14,
1.3345054228342E-13,
8.59850385337424E-14,
1.42153649962395E-13,
9.13522729684146E-14,
1.52345150383759E-13,
9.33090410493165E-14,
1.60274571392449E-13,
9.10365532957869E-14,
1.67385202920478E-13,
8.78897649103649E-14,
1.71225880696291E-13,
7.34239058441943E-14,
1.68498895392055E-13,
6.36591473979209E-14,
1.5914873585654E-13,
0.806285529580527,
1.55679288904587E-13,
0.42071366559964,
1.50523690733984E-13,
0.329649571290566,
1.53262819102551E-13,
0.287541169230563,
1.46826995006677E-13,
0.264081669647444,
1.43815515052381E-13,
0.25040966607048,
1.51052781394156E-13,
0.243061639715436,
1.56645529880706E-13,
0.240593371872118,
1.56100826709249E-13,
0.242606381113025,
1.59660479281953E-13,
0.249521412158257,
1.51722384655884E-13,
0.262808764589963,
1.51632179035133E-13,
0.285967585400841,
1.60073343469236E-13,
0.327916688898164,
1.56711449372793E-13,
2.86470066418465E-14,
2.5352116239663E-14,
6.16243167606001E-14,
4.04155875433077E-14,
8.95733140438004E-14,
5.86301840410641E-14,
1.08320470648682E-13,
6.70540012404075E-14,
1.27574166508548E-13,
7.7788470109752E-14,
1.37039685155216E-13,
8.7811702353946E-14,
1.55098156540134E-13,
9.7758606765197E-14,
1.66235081255905E-13,
1.00069258435198E-13,
1.71484354494211E-13,
9.2075652657897E-14,
1.69888408896313E-13,
7.81891912327026E-14,
1.72218142524549E-13,
6.71372679672544E-14,
1.63161151256475E-13,
5.86319187645401E-14,
1.58031573938011E-13,
0.80619051404161,
1.54046914113692E-13,
0.420503884996739,
1.57013291257613E-13,
0.329402693552313,
1.5467314928852E-13,
0.287282120323139,
1.47704765085521E-13,
0.263823345932029,
1.46521683674905E-13,
0.250159688753005,
1.53856094531335E-13,
0.242824817324802,
1.56100826709249E-13,
0.24037288674393,
1.62155011640408E-13,
0.242404461509483,
1.5629858518551E-13,
0.249339770216857,
1.4796844305387E-13,
0.262648940008777,
1.52079737691935E-13,
0.285831309059618,
1.52988732793347E-13,
0.327806469744629,
1.14177330784448E-14,
4.60955058845247E-14,
3.49659537435265E-14,
7.72255523417975E-14,
5.07918360148629E-14,
1.03674881180016E-13,
6.80323852808584E-14,
1.21876467251703E-13,
7.17950005002521E-14,
1.31594388164125E-13,
7.97469729141298E-14,
1.50254808595207E-13,
9.43394667940467E-14,
1.69194519505922E-13,
1.04674949263917E-13,
1.77576703341842E-13,
1.01234992611055E-13,
1.74115930007268E-13,
8.23785484271866E-14,
1.71085368094737E-13,
7.18227560758677E-14,
1.66729477446559E-13,
6.23234103214187E-14,
1.61754290517457E-13,
4.97900332074863E-14,
1.56234400416899E-13,
0.806104405933574,
1.60359572842772E-13,
0.420313103145815,
1.58470458977433E-13,
0.329177425601346,
1.55675819457635E-13,
0.28704502595561,
1.50492465711416E-13,
0.263586254272056,
1.49134177229726E-13,
0.249929666693581,
1.53536905411755E-13,
0.242606381113025,
1.62168889428216E-13,
0.240169069869448,
1.59098428875737E-13,
0.242217422339702,
1.52274026721244E-13,
0.249171190697218,
1.47885176327023E-13,
0.262500341564562,
1.45265743878298E-13,
0.285704390287354,
1.42531819680158E-13,
2.45836337398053E-14,
2.3932678755445E-14,
6.43486999796217E-14,
4.62433910608517E-14,
9.24520876521839E-14,
6.0658075784481E-14,
1.17895276874336E-13,
7.30891042133308E-14,
1.26313889903251E-13,
7.39894256973628E-14,
1.45116557659364E-13,
8.64846388948237E-14,
1.64606175911963E-13,
1.01347749636993E-13,
1.80726961174216E-13,
1.05795580629398E-13,
1.80338383115597E-13,
9.15257453160123E-14,
1.75312889205692E-13,
7.60710938685349E-14,
1.65673030849689E-13,
6.71407374142063E-14,
1.65610580804554E-13,
5.33895844201382E-14,
1.60392532588816E-13,
4.94135982131994E-14,
1.63015434484493E-13,
0.806026111894307,
1.61443775015258E-13,
0.420139067123619,
1.59313534586758E-13,
0.32897129098116,
1.58121779558762E-13,
0.286827450176147,
1.53370371958061E-13,
0.263368109860218,
1.48780293640627E-13,
0.24971751393617,
1.59608437577674E-13,
0.242404461509483,
1.59098428875737E-13,
0.239980270429932,
1.5496631755596E-13,
0.242043826487993,
1.52693829802431E-13,
0.249014442104585,
1.41102407535953E-13,
0.262361935066461,
1.34746380719974E-13,
0.28558598596292,
1.62320244051495E-14,
4.87201425036776E-14,
3.6652972323914E-14,
8.11590378235749E-14,
5.67540806017952E-14,
1.0754071244623E-13,
6.60626067738868E-14,
1.22861790186057E-13,
7.55073087388425E-14,
1.40174330476306E-13,
8.08450528744231E-14,
1.597437460088E-13,
9.36299648923722E-14,
1.7633984550347E-13,
1.02660935308307E-13,
1.83696807765088E-13,
9.62008250837698E-14,
1.81696671597287E-13,
8.52286990982165E-14,
1.70080963202146E-13,
7.135611546083E-14,
1.64566277272016E-13,
5.81618087025504E-14,
1.64179433936873E-13,
5.29767202328557E-14,
1.66986216521003E-13,
4.14893813749373E-14,
1.6441362160613E-13,
0.80595470315778,
1.62344096499289E-13,
0.419979851723018,
1.62059601849229E-13,
0.328782161390263,
1.61159280365197E-13,
0.286627288643884,
1.52794443764037E-13,
0.263166929605613,
1.5500101202548E-13,
0.249521412158257,
1.56288176844654E-13,
0.242217422339702,
1.5496631755596E-13,
0.239805038396026,
1.55458979023138E-13,
0.241882407347498,
1.45720241429004E-13,
0.248868435630741,
1.30669780551429E-13,
0.262232803459625,
1.33414113090424E-13,
3.16907958208823E-14,
3.26513989457045E-14,
6.8290859078779E-14,
4.81299028409765E-14,
9.74368155604033E-14,
6.26590793140203E-14,
1.13183767913583E-13,
6.87557649703407E-14,
1.37181932480246E-13,
8.25953888616837E-14,
1.5514325935051E-13,
8.81534428787134E-14,
1.71694256034804E-13,
9.49986617149179E-14,
1.79465817207181E-13,
9.30939353382954E-14,
1.85127954632769E-13,
8.99714330815371E-14,
1.76527195638876E-13,
8.05171901374635E-14,
1.68967270730569E-13,
6.23563700674623E-14,
1.63154212362571E-13,
5.7818333454307E-14,
1.70766178975157E-13,
4.52398535299992E-14,
1.68332361938361E-13,
3.61603108567365E-14,
1.65169961041656E-13,
0.80588938640362,
1.65697316978353E-13,
0.419833803351713,
1.64578420336348E-13,
0.328608199066353,
1.60534779913846E-13,
0.286442715475894,
1.58800056437869E-13,
0.262980985208484,
1.51750140231499E-13,
0.249339770216857,
1.52329537872475E-13,
0.242043826487993,
1.55399998424954E-13,
0.239642095737435,
1.48370898900296E-13,
0.241732044962979,
1.35214756058488E-13,
0.248732205650428,
1.29531801951188E-13,
0.262112131167338,
2.14463863335013E-14,
5.83894911587723E-14,
4.59163956856301E-14,
8.62998908446322E-14,
5.47418013696621E-14,
1.03951569574434E-13,
6.5746887101259E-14,
1.28050348102704E-13,
7.60901758267707E-14,
1.52508214390501E-13,
9.00200053388645E-14,
1.67407754325666E-13,
8.9681734261049E-14,
1.75000638980016E-13,
8.55409493238923E-14,
1.81080844763315E-13,
8.69287281046738E-14,
1.80066031529869E-13,
8.53570686354388E-14,
1.75571363003613E-13,
7.16284670465583E-14,
1.67693983699202E-13,
6.20458545652625E-14,
1.6977738659385E-13,
5.00641195166907E-14,
1.7234304261482E-13,
3.97754745806722E-14,
1.69281255679721E-13,
3.38149647172159E-14,
1.67971539455358E-13,
0.805829480507479,
1.68236952147183E-13,
0.419699494913373,
1.64045860229223E-13,
0.328447810077916,
1.6706080963047E-13,
0.286272139844075,
1.55771229248813E-13,
0.262808764589963,
1.4791640134959E-13,
0.249171190697218,
1.52679952014623E-13,
0.241882407347498,
1.48422940604576E-13,
0.239490312363524,
1.38066641452994E-13,
0.241591746000482,
1.34212085889374E-13,
0.248604893275302,
1.32612670844523E-13,
3.57448445842401E-14,
3.95178681444897E-14,
7.95119178831349E-14,
5.36359151537269E-14,
9.4017675589253E-14,
5.83526282849078E-14,
1.19516375962636E-13,
7.33822724807709E-14,
1.43862352586233E-13,
8.37819397192519E-14,
1.65140470742564E-13,
9.17148301748938E-14,
1.70979549962702E-13,
8.03176969377262E-14,
1.76816894459364E-13,
7.9432987964978E-14,
1.76175046773253E-13,
8.23091594881475E-14,
1.79262854560491E-13,
7.64267121811102E-14,
1.74265116226202E-13,
7.13509112904021E-14,
1.74396955210376E-13,
5.43228656502137E-14,
1.71366393297845E-13,
4.45459641396084E-14,
1.73309283590939E-13,
3.73416575438767E-14,
1.72025588218716E-13,
2.31776403625261E-14,
1.71106184776448E-13,
0.805774397855582,
1.67955926944074E-13,
0.419575689263865,
1.70342906447019E-13,
0.328299606210107,
1.6379259060173E-13,
0.286114170317583,
1.51687690186364E-13,
0.262648940008777,
1.47867829092263E-13,
0.249014442104585,
1.45775752580235E-13,
0.241732044962979,
1.38070110899946E-13,
0.239348685922146,
1.36703148800876E-13,
0.241460626854583,
1.3718887137415E-13,
0.248485732426809,
2.41703358716538E-14,
6.49827414100912E-14,
4.93069127194268E-14,
8.90901935557409E-14,
5.79310904802455E-14,
1.10453313162395E-13,
6.6419959809938E-14,
1.35896502384547E-13,
8.13585310233123E-14,
1.5690226895515E-13,
8.56190118803113E-14,
1.6904880273394E-13,
8.25086526878849E-14,
1.72967543066171E-13,
7.43415745629861E-14,
1.72062017411712E-13,
7.49712791847656E-14,
1.75467279595054E-13,
7.34568655902379E-14,
1.78105794002015E-13,
7.61491564249539E-14,
1.81115539232835E-13,
6.36574126744449E-14,
1.75984227190895E-13,
4.88827728295504E-14,
1.72412431553859E-13,
4.22023527235638E-14,
1.7605535085341E-13,
2.69818889453433E-14,
1.74993700086112E-13,
1.23841908949984E-14,
1.70311681424451E-13,
0.805723629220057,
1.74006642428282E-13,
0.419461309416782,
1.67248159765876E-13,
0.328162373672543,
1.59344759609326E-13,
0.285967585400841,
1.52062390457175E-13,
0.262500341564562,
1.41081590854242E-13,
0.248868435630741,
1.35152306013353E-13,
0.241591746000482,
1.36703148800876E-13,
0.239216324761983,
1.39780548247259E-13,
0.241337899340996,
1.41085060301194E-13,
3.92880172839227E-14,
3.93005940291236E-14,
7.79168396469743E-14,
5.47981798826314E-14,
1.06754015349875E-13,
6.65145022393787E-14,
1.27561156082479E-13,
7.47162748337971E-14,
1.49418671879786E-13,
8.34662200466241E-14,
1.61155810918245E-13,
7.65429386540006E-14,
1.71274452953618E-13,
7.66088581460878E-14,
1.68400016153925E-13,
6.9933642210529E-14,
1.71482619770735E-13,
6.61241894572839E-14,
1.74367464911285E-13,
7.3222677920981E-14,
1.84930196156508E-13,
6.85423939827956E-14,
1.82765261258488E-13,
5.82554837702531E-14,
1.77110062726804E-13,
4.65894683943091E-14,
1.75212275244085E-13,
3.16951326295722E-14,
1.79146628087601E-13,
1.61867047543396E-14,
1.74613795644873E-13,
  0,
1.76449133082457E-13,
0.805676731434855,
1.71224145972815E-13,
0.419355414101021,
1.6317155959733E-13,
0.328035047259709,
1.60042118446668E-13,
0.285831309059618,
1.45272682772202E-13,
0.262361935066461,
1.30683658339237E-13,
0.248732205650428,
1.34212085889374E-13,
0.241460626854584,
1.39808303822875E-13,
0.239092433501754,
1.44016742975595E-13,
0.241222858529965,
2.12169691538033E-14,
6.08796867085371E-14,
4.68453401070157E-14,
9.75669198211015E-14,
6.41275227364346E-14,
1.24866263162549E-13,
7.5241896047018E-14,
1.41687009347358E-13,
7.7040804291606E-14,
1.5405211828412E-13,
7.45358635922955E-14,
1.6368503774622E-13,
7.07524316911901E-14,
1.66880398388969E-13,
7.23188869899971E-14,
1.68006233924878E-13,
6.11385941873266E-14,
1.70551073264136E-13,
6.59628601740181E-14,
1.81354931072519E-13,
6.56592835657221E-14,
1.86696144655052E-13,
6.31456692490318E-14,
1.83948342669105E-13,
5.58806473316409E-14,
1.79930723098742E-13,
3.60839830237936E-14,
1.7844406507983E-13,
2.09953582297473E-14,
1.78721620835987E-13,
1.00475183728577E-14,
1.8084145292363E-13,
  0,
1.73448061469017E-13,
0.805633317290993,
1.6665141489014E-13,
0.419257177592155,
1.6366769051146E-13,
0.327916688898164,
1.52947099429923E-13,
0.285704390287354,
1.34805361318158E-13,
0.262232803459625,
1.29524863057284E-13,
0.248604893275302,
1.37143768563774E-13,
0.241337899340996,
1.43964701271315E-13,
0.238976300758138,
1.35717825866521E-13,
3.10073147713474E-14,
3.35660318984132E-14,
8.38417876791731E-14,
5.73768463296709E-14,
1.17024445689395E-13,
7.34325794615742E-14,
1.39777078800307E-13,
7.78890840713586E-14,
1.46847811688389E-13,
6.83272882717745E-14,
1.56943902318574E-13,
6.8811276121572E-14,
1.59603233407246E-13,
6.65214411332826E-14,
1.66665292677948E-13,
6.35984320762617E-14,
1.67185709720741E-13,
6.10223677144361E-14,
1.77588846406174E-13,
5.83786491370475E-14,
1.83211085191815E-13,
6.0286844960622E-14,
1.87927798322995E-13,
6.08194050677469E-14,
1.86800228063611E-13,
4.54410814532125E-14,
1.83235371320478E-13,
2.53269627492614E-14,
1.77970485570889E-13,
1.49394385751123E-14,
1.85046422629398E-13,
  0,
1.77739767348584E-13,
  0,
1.69624730927964E-13,
0.805593047202749,
1.6780674072514E-13,
0.419165872979246,
1.56725327160601E-13,
0.327806469744629,
1.42531819680158E-13,
0.28558598596292,
1.33427990878232E-13,
0.262112131167338,
1.32550220799388E-13,
0.248485732426809,
1.41085060301194E-13,
0.241222858529965,
1.35710886972618E-13,
0.238867288669475,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999994,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.09096759404181E-14,
1.58931028060305E-14,
2.37219098531138E-14,
2.32567871211176E-14,
2.7639565983173E-14,
1.98343945434498E-14,
2.60202016183486E-14,
1.39647408220478E-14,
2.72403627432638E-14,
1.59856936715608E-14,
2.52727526406371E-14,
1.35585986882347E-14,
2.75406867450423E-14,
1.365335795811E-14,
2.99463145253531E-14,
1.35874384660228E-14,
2.4456998926059E-14,
1.70133004906425E-14,
3.28868876575683E-14,
2.09359439506951E-14,
3.45353086406153E-14,
2.18319286260371E-14,
3.88300502862649E-14,
1.93256868841196E-14,
3.66312882804642E-14,
1.96166867472147E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.04885718166248E-14,
-1.21382938422787E-14,
  0,
  0,
  0,
  0,
  0,
0.866506930318042,
  0,
0.866448577718203,
1.15497889030536E-14,
  0,
1.46042032633797E-14,
  0,
  0,
  0,
1.26214143303383E-14,
1.58957048912445E-14,
2.99079337684471E-14,
3.39203491683815E-14,
4.44618300510236E-14,
3.73442596290907E-14,
4.64532926014449E-14,
2.9243968358017E-14,
4.6145812865328E-14,
2.59345496467223E-14,
4.5477510646208E-14,
2.55915080793478E-14,
4.5771112594517E-14,
2.3558845846372E-14,
4.97627113127397E-14,
2.35718562724418E-14,
4.70786604145346E-14,
2.64931306059868E-14,
4.96412806694213E-14,
3.28695404228085E-14,
5.83907922013793E-14,
3.70133611260481E-14,
6.35307778606986E-14,
3.56446643035024E-14,
6.53479007017843E-14,
3.37165191599542E-14,
6.70622411769184E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.18754832356682E-14,
-1.05130747857229E-14,
-1.02196896778484E-14,
-1.36800293315531E-14,
  0,
-1.05596954791398E-14,
  0,
0.83952731128995,
  0,
0.560769398746019,
1.11187101192733E-14,
0.839298324809899,
1.48557381673964E-14,
  0,
1.51324265618147E-14,
  0,
1.73979754214404E-14,
1.17479810601839E-14,
2.90015407522493E-14,
3.0513352261563E-14,
4.56050128216923E-14,
4.29625952869106E-14,
5.71530670012699E-14,
4.2336793792952E-14,
6.06034319949877E-14,
3.78213085849843E-14,
5.82771678137028E-14,
3.19787599178945E-14,
6.0062198270483E-14,
3.24488699798842E-14,
6.16902362526872E-14,
3.04088351721354E-14,
6.03432234735912E-14,
3.33361810378463E-14,
6.6347101423947E-14,
3.84674930797857E-14,
6.78571782097848E-14,
4.42736125538801E-14,
7.94468657527858E-14,
4.59918561568351E-14,
8.13958275780458E-14,
4.55573079261029E-14,
8.72288352660178E-14,
4.21017387619571E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.12553195930065E-14,
-1.16044326925469E-14,
  0,
-1.52070196712817E-14,
  0,
0.828398039489368,
  0,
0.49913957690152,
1.12076146974172E-14,
0.498765704069467,
1.39042423408231E-14,
0.827878767874979,
1.4659280733742E-14,
  0,
2.23120133480137E-14,
1.18568349583015E-14,
3.2984032172223E-14,
2.54483933925798E-14,
4.31312971449493E-14,
3.79366676961368E-14,
5.6025496741885E-14,
4.6075122883682E-14,
6.87973983337642E-14,
4.92626772707894E-14,
7.02641070327026E-14,
4.24885820970999E-14,
7.03994154638288E-14,
3.75342118497102E-14,
7.3520182997111E-14,
3.79644232717524E-14,
6.96517496456828E-14,
3.88092336045531E-14,
7.6965343820401E-14,
4.37670732988948E-14,
8.17176187828395E-14,
4.8090004201029E-14,
8.58176377183106E-14,
5.12636808003286E-14,
9.3939613032834E-14,
5.39845945723982E-14,
9.97596102947362E-14,
5.20868070896796E-14,
1.056221082818E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.31162442018606E-14,
  0,
0.822615085441342,
  0,
0.473292058786036,
  0,
0.426332288401243,
1.33408908919996E-14,
0.472242860272771,
1.3013895516778E-14,
0.821670061884342,
2.14264370135275E-14,
  0,
3.73191061386891E-14,
2.52627779806502E-14,
4.62598709338735E-14,
3.21886614584876E-14,
5.24450274874688E-14,
4.01510422132212E-14,
6.63219479335453E-14,
5.2055582067112E-14,
7.70043750986105E-14,
5.29186069964105E-14,
8.08866862378466E-14,
4.71324368422898E-14,
8.23395171489771E-14,
4.22396492782973E-14,
7.99716196042688E-14,
4.55885329486705E-14,
8.4742976524943E-14,
4.83831724684691E-14,
9.07225683466351E-14,
5.24589052752766E-14,
9.79901923492399E-14,
5.4004543892372E-14,
9.83848419400246E-14,
5.81401246591007E-14,
1.10263360941776E-13,
5.93587679009744E-14,
1.15980142156857E-13,
6.2457851390807E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.819338537352137,
  0,
0.459709931706213,
  0,
0.395087744724236,
1.12297324217359E-14,
0.394292909086673,
1.2418885364518E-14,
0.457650952912595,
1.99614630380651E-14,
0.817806993651533,
3.60423496603701E-14,
2.25331905912007E-14,
5.01551924991794E-14,
3.17463069721136E-14,
5.51720127917044E-14,
3.40005801291454E-14,
6.21256518451574E-14,
4.55330217974392E-14,
7.36988595151367E-14,
5.50757356387876E-14,
8.67205612875566E-14,
5.6996074526694E-14,
9.19013129485613E-14,
5.13243961219878E-14,
8.78437947382515E-14,
4.93051779959508E-14,
9.40887992517681E-14,
5.46351158758895E-14,
9.74732447533988E-14,
5.64496366317613E-14,
1.05828540375441E-13,
5.77003722579406E-14,
1.09345692222984E-13,
6.01931698929192E-14,
1.13418822944578E-13,
6.27943877451465E-14,
1.250683584475E-13,
6.89899526395976E-14,
1.31250045554143E-13,
  0,
  0,
-1.18737485121923E-14,
  0,
  0,
  0,
  0,
  0,
  0,
0.817511184004236,
  0,
0.451958989794882,
  0,
0.378393122162478,
  0,
0.36005618091559,
1.01637448457481E-14,
0.376355611046883,
1.93499730127833E-14,
0.448497255790403,
3.40413461308309E-14,
0.815193535651868,
4.85705226038746E-14,
2.87365617412938E-14,
5.85824791454748E-14,
3.31488309024408E-14,
6.43105360631502E-14,
3.89740323347709E-14,
6.8808674036358E-14,
4.81203618618586E-14,
8.27003396319803E-14,
5.86319187645401E-14,
9.69268068584661E-14,
6.07378730643759E-14,
9.66180260797422E-14,
5.80074183131885E-14,
1.01183818268513E-13,
5.79258863098175E-14,
1.05981196041327E-13,
6.22566234675936E-14,
1.11704048788575E-13,
6.1260024830645E-14,
1.16299331276437E-13,
6.33893978974065E-14,
1.2344292255051E-13,
6.43443631709317E-14,
1.27226354451615E-13,
7.1881736674051E-14,
1.39280947886178E-13,
7.6588908826114E-14,
  0,
-1.04590815175332E-14,
-1.0469923539258E-14,
-1.12587890399585E-14,
  0,
  0,
  0,
  0,
0.816684318697262,
  0,
0.447616972799634,
  0,
0.368766282325613,
  0,
0.341549642247267,
  0,
0.340210246534238,
1.66923766475868E-14,
0.364970558847638,
3.36822583713037E-14,
0.442268127097388,
4.69147290460548E-14,
0.813321380138789,
5.68217348173583E-14,
2.99794911118312E-14,
6.73966091269129E-14,
3.80624351481451E-14,
7.06318684096097E-14,
4.13245826447195E-14,
7.74554032023644E-14,
5.13686315706252E-14,
9.24659654399917E-14,
6.20007517548871E-14,
1.01132643925972E-13,
6.70470623465036E-14,
1.09409876991595E-13,
6.62594978884101E-14,
1.1250809311969E-13,
6.51874387802565E-14,
1.19646480223334E-13,
6.66914440339283E-14,
1.21499164895678E-13,
6.65856259018938E-14,
1.29682722893598E-13,
6.71476763081102E-14,
1.36538350070659E-13,
7.299889859258E-14,
1.40649644708724E-13,
7.90218585011715E-14,
1.50381443408953E-13,
  0,
-1.21382938422787E-14,
-1.02058118900406E-14,
-1.16053000542848E-14,
  0,
  0,
  0,
0.816684318697262,
  0,
0.445647454720562,
  0,
0.363338805170475,
  0,
0.330796910359612,
  0,
0.320509979588327,
1.24214874497319E-14,
0.327508003156811,
3.10845099660284E-14,
0.357157997341188,
4.54809800931599E-14,
0.437786386131618,
5.42907732659081E-14,
0.811923183470066,
6.54242285347273E-14,
3.46840611786803E-14,
7.34273752911463E-14,
4.02291047696401E-14,
7.89767556907961E-14,
4.44184619641241E-14,
8.68107669083074E-14,
5.44972053595494E-14,
9.62094987011497E-14,
6.80878964320897E-14,
1.13469129925381E-13,
7.49790854404075E-14,
1.20214602161717E-13,
7.31914528984134E-14,
1.25607857448529E-13,
6.93212848235092E-14,
1.28860463965985E-13,
7.1732550455117E-14,
1.34349129043976E-13,
7.00186436608519E-14,
1.42202222219723E-13,
7.54639406519431E-14,
1.49356221834651E-13,
7.97868715540773E-14,
1.51115231439292E-13,
7.50528111881366E-14,
  0,
  0,
-1.36778609272081E-14,
  0,
-1.31162442018606E-14,
  0,
0.817511184004236,
  0,
0.445647454720562,
  0,
0.360868316187502,
  0,
0.324705571405495,
  0,
0.308999618948279,
  0,
0.306964860840936,
2.65881067162965E-14,
0.318737653189131,
4.29847130112293E-14,
0.351502018334164,
5.32438676481561E-14,
0.434428062334089,
6.27917856599325E-14,
0.81084523107771,
7.13396355878082E-14,
3.67744029672323E-14,
8.1453940814491E-14,
4.31295624214734E-14,
8.80840539396743E-14,
4.73909106402104E-14,
9.03409291819202E-14,
6.03198047066655E-14,
1.08227662942717E-13,
7.58039464532345E-14,
1.23862725631696E-13,
8.17210882297914E-14,
1.32933594687579E-13,
7.71431529766886E-14,
1.34432395770823E-13,
7.41368771928208E-14,
1.41265471542695E-13,
7.49799528021455E-14,
1.46400253031587E-13,
7.80937814415239E-14,
1.54506615834826E-13,
8.19899703685678E-14,
1.59330881821518E-13,
7.55853712952614E-14,
1.55989804406786E-13,
  0,
  0,
  0,
-1.52174280121375E-14,
  0,
0.819338537352137,
  0,
0.447616972799634,
  0,
0.360868316187502,
  0,
0.321925516664871,
  0,
0.302455514878912,
  0,
0.294911211184092,
2.37622421739303E-14,
0.297571158947787,
3.86600473856191E-14,
0.312358363191178,
5.06955588619462E-14,
0.347243575613077,
6.17882481290799E-14,
0.431832141311507,
6.86690287965419E-14,
0.809993055087066,
7.90799717376167E-14,
3.96158800208823E-14,
9.04849112304262E-14,
4.60248159028787E-14,
9.1400845225742E-14,
5.30599869597026E-14,
1.02074598773427E-13,
6.79387102131557E-14,
1.18323753572902E-13,
8.23785484271866E-14,
1.36278141549262E-13,
8.54594173205214E-14,
1.41411188314677E-13,
8.1754047975835E-14,
1.46445355841962E-13,
7.71986641279199E-14,
1.52924548024735E-13,
8.28555973830802E-14,
1.58312599141119E-13,
8.44133790645074E-14,
1.64066676910934E-13,
7.75785685691588E-14,
1.63764835026114E-13,
6.94461849137795E-14,
  0,
  0,
-1.06147729495021E-14,
  0,
0.822615085441342,
  0,
0.451958989794882,
  0,
0.363338805170475,
  0,
0.321925516664871,
  0,
0.299462744837997,
1.32185928869433E-14,
0.288039162343556,
2.31290681051988E-14,
0.285110984907833,
3.5678057730415E-14,
0.290714990400163,
4.61974208887383E-14,
0.307537644741315,
5.88192688999456E-14,
0.34393952957692,
6.73862007860571E-14,
0.429775623452425,
7.60841042946048E-14,
0.809305516266406,
8.78394579295616E-14,
4.24590917980083E-14,
9.35241467603376E-14,
5.15820025581704E-14,
1.02863897954997E-13,
6.05661354402542E-14,
1.11948644798687E-13,
7.43519829038419E-14,
1.30447735946504E-13,
8.58445259321883E-14,
1.44424402992449E-13,
8.990551358945E-14,
1.53139653735757E-13,
8.46475667337643E-14,
1.57729732053191E-13,
8.49147141490647E-14,
1.64512500844261E-13,
8.89739670828504E-14,
1.67478877988181E-13,
7.97938104479812E-14,
1.6816062431424E-13,
7.13006043095987E-14,
1.59657009835001E-13,
  0,
  0,
  0,
0.828398039489368,
  0,
0.459709931706213,
  0,
0.368766282325613,
  0,
0.324705571405495,
  0,
0.299462744837997,
1.36080383073001E-14,
0.284891445695914,
2.73643954717961E-14,
0.277991647581968,
3.49963114043561E-14,
0.277940969625986,
4.32267069361281E-14,
0.285519782568366,
5.41251071739524E-14,
0.303786341287835,
6.42541575501809E-14,
0.341314143304492,
7.48099499014998E-14,
0.428113577233339,
8.49841030881038E-14,
0.808741373903882,
9.08301212021456E-14,
4.79598999403308E-14,
1.04942096679217E-13,
5.88921272859366E-14,
1.12581818867419E-13,
6.67989968894389E-14,
1.23808949203941E-13,
7.77069381063811E-14,
1.3837889167867E-13,
9.01466401526108E-14,
1.55929089085127E-13,
9.26359683406375E-14,
1.64165556149065E-13,
9.22040221951193E-14,
1.69086966650411E-13,
9.08891018003288E-14,
1.7338214197693E-13,
8.42728664629533E-14,
1.7128659601795E-13,
7.34672739310938E-14,
1.63744018344403E-13,
6.36383307162092E-14,
  0,
  0,
0.83952731128995,
  0,
0.473292058786036,
  0,
0.378393122162478,
  0,
0.330796910359612,
  0,
0.302455514878912,
1.32220623338952E-14,
0.284891445695914,
2.73149558527308E-14,
0.274726578640893,
3.93617430316517E-14,
0.270629557597826,
4.26464419334138E-14,
0.27249750863986,
5.12714870559705E-14,
0.281468164118274,
5.97048452344318E-14,
0.300798442896321,
7.19493908896141E-14,
0.339187127200045,
8.32528490590789E-14,
0.42674789782023,
8.76382300063483E-14,
0.808271851178868,
1.02062455709095E-13,
5.53342094367082E-14,
1.14503892478801E-13,
6.50451914552264E-14,
1.24214874497319E-13,
7.00602770242753E-14,
1.31629082633644E-13,
8.18130285740182E-14,
1.49665002613375E-13,
9.27886240065234E-14,
1.66739885787415E-13,
1.00102218181242E-13,
1.75243500266653E-13,
9.80968778430125E-14,
1.77758849306819E-13,
8.60336107910697E-14,
1.76955672337442E-13,
7.78075520679877E-14,
1.66613250973668E-13,
6.56801002474339E-14,
1.6530180002583E-13,
  0,
0.866506930318042,
  0,
0.49913957690152,
  0,
0.395087744724236,
  0,
0.341549642247267,
  0,
0.308999618948279,
  0,
0.288039162343556,
2.73643954717961E-14,
0.274726578640893,
3.92090873657658E-14,
0.267273020544669,
4.65573760100035E-14,
0.265033423717073,
5.04769837039731E-14,
0.268245637656274,
5.65623936576998E-14,
0.278235237034342,
6.70991040507829E-14,
0.298372958590031,
8.02344302108793E-14,
0.337435826637575,
8.60613663666854E-14,
0.425609927317424,
9.91203646938388E-14,
0.807876292865122,
1.1143863609675E-13,
6.12981887471165E-14,
1.2609878419223E-13,
6.83342271656784E-14,
1.31920516177608E-13,
7.41715716623403E-14,
1.42682740622568E-13,
8.44220526818873E-14,
1.60274571392449E-13,
1.00097014010814E-13,
1.77561090830558E-13,
1.05795580629398E-13,
1.83667317465996E-13,
9.31303645312909E-14,
1.81044415570319E-13,
7.94711518814495E-14,
1.72035996559572E-13,
6.99197644227212E-14,
1.6797500890231E-13,
6.36157793110215E-14,
0.999999999999994,
  0,
0.560769398746019,
1.10931229480027E-14,
0.426332288401243,
1.12522838269236E-14,
0.36005618091559,
  0,
0.320509979588327,
  0,
0.294911211184092,
2.30735569539675E-14,
0.277991647581968,
3.93027624334685E-14,
0.26727302054467,
4.65721211595493E-14,
0.261603977555733,
5.42855690954802E-14,
0.26065790976244,
5.56178367250304E-14,
0.264848534591391,
6.39852754114045E-14,
0.275606905743462,
7.55333295909821E-14,
0.296372623334906,
8.27116153345742E-14,
0.335974037068278,
9.71479841016532E-14,
0.424650260740901,
1.0817041706801E-13,
0.807539514016532,
1.22844442951298E-13,
6.447446743163E-14,
1.33591054884974E-13,
7.22807230735256E-14,
1.4286315186407E-13,
7.65203872488129E-14,
1.53179552375704E-13,
9.15448272742481E-14,
1.70948324940134E-13,
1.05748743095546E-13,
1.85816639852732E-13,
1.00764882549065E-13,
1.86791554446231E-13,
8.64482097018282E-14,
1.75980757743943E-13,
7.15209141910478E-14,
1.73224282140616E-13,
6.77548295247021E-14,
1.68545732925907E-13,
  0,
0.866448577718204,
1.10076878168108E-14,
0.498765704069467,
1.32975228051002E-14,
0.394292909086673,
1.01949698683157E-14,
0.340210246534238,
1.24362325992777E-14,
0.306964860840936,
2.37379560452666E-14,
0.285110984907833,
3.49720252756924E-14,
0.270629557597826,
4.65625801804315E-14,
0.261603977555733,
5.46914943888588E-14,
0.257169281683215,
5.96796917440301E-14,
0.257159105426093,
6.30225038822374E-14,
0.262083744288899,
7.21835785588709E-14,
0.273436543181386,
7.7939391052162E-14,
0.294700645700197,
9.37704774939263E-14,
0.334739501928254,
1.06232730945344E-13,
0.423832498782926,
1.19591836433841E-13,
0.807250119446026,
1.30159771849492E-13,
6.83671869117219E-14,
1.44271747326563E-13,
7.46399470008541E-14,
1.53209042674796E-13,
8.37472452497323E-14,
1.63686772469696E-13,
9.71063507382297E-14,
1.79037340508614E-13,
1.00624369947511E-13,
1.88793425337508E-13,
9.40029304397072E-14,
1.8160473125306E-13,
7.84112358376277E-14,
1.77002509871294E-13,
6.9258834778374E-14,
1.73586839347095E-13,
6.38412933628985E-14,
  0,
1.16053000542848E-14,
0.839298324809899,
1.37793422505528E-14,
0.472242860272771,
1.24050075767101E-14,
0.376355611046883,
1.66889072006349E-14,
0.327508003156811,
2.65820351841306E-14,
0.297571158947787,
3.5678057730415E-14,
0.277940969625986,
4.26377683160339E-14,
0.265033423717073,
5.4228323220773E-14,
0.257169281683215,
5.95747409737335E-14,
0.253621704775727,
6.71303290733505E-14,
0.254309551144675,
7.10872333220536E-14,
0.259798614517737,
7.48116846249758E-14,
0.271620503748716,
8.89826407002303E-14,
0.293286924301554,
1.03092881453826E-13,
0.333686210157977,
1.17718335079786E-13,
0.423129275258224,
1.27056351550969E-13,
0.80699940396042,
1.41081590854242E-13,
7.07871261607096E-14,
1.54615903413813E-13,
8.1752313252359E-14,
1.6362432242456E-13,
8.92827478615743E-14,
1.71699460205232E-13,
9.19490178441507E-14,
1.81901368967452E-13,
9.38103761338738E-14,
1.83474763160163E-13,
8.58913634660396E-14,
1.82477297161476E-13,
7.60728285920109E-14,
1.77240166987502E-13,
6.53036652531469E-14,
1.77323433714349E-13,
  0,
  0,
1.48548708056584E-14,
0.827878767874979,
1.30182323254679E-14,
0.457650952912595,
1.93447688423554E-14,
0.364970558847638,
3.10862446895044E-14,
0.318737653189131,
3.86366286186934E-14,
0.290714990400163,
4.32848201725733E-14,
0.27249750863986,
5.04917288535189E-14,
0.26065790976244,
5.95617305476637E-14,
0.253621704775728,
6.71112471151147E-14,
0.250731435264671,
7.52765905165376E-14,
0.251952966011277,
7.39928951443147E-14,
0.257885055063418,
8.55548271117001E-14,
0.270083562170474,
9.79147318780349E-14,
0.292079522193202,
1.14326950684251E-13,
0.332779475472074,
1.24998969508461E-13,
0.422519650013744,
1.37511529940681E-13,
0.806780612503494,
1.51196763442663E-13,
7.77537756402324E-14,
1.6499128452363E-13,
8.71854671791183E-14,
1.71584968455818E-13,
8.3918982873854E-14,
1.74358791293905E-13,
8.50847170497104E-14,
1.76410969165985E-13,
8.56502369028789E-14,
1.84182530338362E-13,
8.35095881335235E-14,
1.82569237505703E-13,
7.20534742981727E-14,
1.80825840412346E-13,
5.76552694475652E-14,
  0,
1.46267546685674E-14,
  0,
1.47273686301741E-14,
0.821670061884342,
1.99033498016199E-14,
0.448497255790403,
3.37906785885522E-14,
0.357157997341188,
4.30263463746527E-14,
0.312358363191178,
4.61835431009305E-14,
0.285519782568366,
5.11674036474119E-14,
0.268245637656274,
5.56733478762617E-14,
0.257159105426093,
6.71285943498745E-14,
0.250731435264671,
7.54275114589475E-14,
0.248340480842514,
7.80781689302401E-14,
0.249978569154934,
8.47169556728034E-14,
0.256264496369248,
9.47800865569448E-14,
0.268769881442566,
1.09405540182905E-13,
0.291039201120309,
1.21468807234848E-13,
0.331992693776391,
1.35322308913999E-13,
0.421987350634723,
1.47454964904981E-13,
0.806588430277071,
1.61426427780498E-13,
8.31574392679002E-14,
1.72686517863063E-13,
8.19431328347164E-14,
1.74096848049032E-13,
7.70928459958853E-14,
1.68835431746395E-13,
7.69089653074317E-14,
1.77082307151188E-13,
8.31903990139438E-14,
1.84172121997506E-13,
7.94971727335891E-14,
1.86012663605517E-13,
6.43842618108792E-14,
1.83476497883639E-13,
  0,
  0,
1.52169943312686E-14,
  0,
2.14264370135275E-14,
0.817806993651533,
3.41246128576778E-14,
0.442268127097388,
4.55113377539895E-14,
0.351502018334164,
5.07007630323741E-14,
0.307537644741315,
5.41251071739524E-14,
0.281468164118274,
5.65068825064685E-14,
0.264848534591391,
6.29531149431983E-14,
0.254309551144675,
7.52609780052538E-14,
0.248340480842514,
7.78769410070268E-14,
0.246336787803849,
8.86565126867467E-14,
0.248305757403928,
9.39786443110435E-14,
0.254878541543898,
1.06043646086462E-13,
0.267637207651043,
1.16497089752698E-13,
0.290135808487614,
1.32177255252053E-13,
0.331305148354566,
1.45180742427975E-13,
0.421519558002028,
1.57738405670571E-13,
0.806418623809552,
1.69142477801643E-13,
7.76548964021018E-14,
1.75337175334356E-13,
7.5018116718617E-14,
1.68516242626815E-13,
6.88164802919999E-14,
1.69395747429135E-13,
7.43745343090296E-14,
1.7695220289049E-13,
7.9131146080158E-14,
1.87547893881757E-13,
7.18158171819638E-14,
1.88540155710015E-13,
5.30825383648903E-14,
  0,
  0,
  0,
2.23120133480137E-14,
  0,
3.60440843838461E-14,
0.815193535651867,
4.69164637695307E-14,
0.437786386131618,
5.32360613925142E-14,
0.347243575613077,
5.88210036234216E-14,
0.303786341287835,
5.96770896588161E-14,
0.278235237034342,
6.39609892827409E-14,
0.262083744288899,
7.10907027690055E-14,
0.251952966011277,
7.80764342067641E-14,
0.246336787803849,
8.885774060996E-14,
0.24463878843926,
9.77429942539132E-14,
0.246874571165472,
1.05094752345103E-13,
0.253682947533753,
1.13162951231871E-13,
0.266653023747164,
1.27049412657065E-13,
0.289345824931538,
1.42014872084317E-13,
0.330700489038719,
1.55792045930525E-13,
0.421106049680966,
1.6484036358122E-13,
0.80626778347429,
1.71652622671381E-13,
7.08599845467006E-14,
1.69557076712401E-13,
6.68007316129149E-14,
1.68991556859233E-13,
6.63497035091609E-14,
1.69196254229398E-13,
7.03378327804316E-14,
1.80213483025327E-13,
7.13908099303495E-14,
1.9000426232374E-13,
6.04620520316956E-14,
1.82822507133196E-13,
  0,
  0,
1.73840976336326E-14,
1.19036724921529E-14,
3.72904832013354E-14,
2.2587834380694E-14,
4.861996222294E-14,
0.813321380138789,
5.43809788866589E-14,
0.434428062334089,
6.17882481290799E-14,
0.34393952957692,
6.42541575501809E-14,
0.300798442896321,
6.71025734977349E-14,
0.275606905743462,
7.21835785588709E-14,
0.259798614517737,
7.39911604208388E-14,
0.249978569154934,
8.86287571111311E-14,
0.24463878843926,
9.78054442990484E-14,
0.243185780277025,
1.08970124590435E-13,
0.245639548962545,
1.1201629901425E-13,
0.252643630955543,
1.23819357544797E-13,
0.265791933413096,
1.3685233501981E-13,
0.288650660698684,
1.52145657184022E-13,
0.330165656399363,
1.63275643005889E-13,
0.42073858433172,
1.68086031204773E-13,
0.80613313564323,
1.65714664213112E-13,
6.25974966306231E-14,
1.70023717327439E-13,
6.42107894632815E-14,
1.68663694122273E-13,
6.22592255528076E-14,
1.7234304261482E-13,
6.25159646272522E-14,
1.82614340316078E-13,
6.00908212078366E-14,
1.84154774762746E-13,
6.11281858464707E-14,
  0,
1.25927913929846E-14,
1.17501494645289E-14,
3.29241842123018E-14,
2.52358897667726E-14,
5.01040181566381E-14,
2.87400311882458E-14,
5.68234695408343E-14,
0.811923183470066,
6.26824980809459E-14,
0.431832141311507,
6.72231367793152E-14,
0.341314143304492,
7.19493908896141E-14,
0.298372958590031,
7.55367990379341E-14,
0.273436543181386,
7.4796072113692E-14,
0.257885055063418,
8.48661418917374E-14,
0.248305757403928,
9.77794234469087E-14,
0.243185780277025,
1.08860837011449E-13,
0.241931721463978,
1.16271575700821E-13,
0.244565645097482,
1.22577295535997E-13,
0.251733947370549,
1.33556360415454E-13,
0.265033840301956,
1.4706291739941E-13,
0.288035447793058,
1.5975241962618E-13,
0.329690106635812,
1.65903749071994E-13,
0.420410451884982,
1.62104704659605E-13,
0.806012403549148,
1.66347838281844E-13,
6.0135924018212E-14,
1.69697589313955E-13,
6.01168420599762E-14,
1.71838238083311E-13,
5.44998074447633E-14,
1.74662367902201E-13,
5.11552605830801E-14,
1.76639952664814E-13,
6.06355243792933E-14,
1.9234960846326E-13,
1.09096759404181E-14,
1.58796586990917E-14,
2.90154185400571E-14,
2.54189030934882E-14,
4.62720139982054E-14,
3.17463069721136E-14,
5.86093673593524E-14,
2.99760216648792E-14,
6.54276979816792E-14,
0.81084523107771,
6.86447426678782E-14,
0.429775623452425,
7.48099499014998E-14,
0.339187127200045,
8.01823885066E-14,
0.296372623334906,
7.79185743704502E-14,
0.271620503748716,
8.5490642343089E-14,
0.256264496369248,
9.39855832049474E-14,
0.246874571165472,
1.09025635741666E-13,
0.241931721463978,
1.16174431186167E-13,
0.240841107110636,
1.26608792894167E-13,
0.243625446288882,
1.32668181995754E-13,
0.250932795214039,
1.43709696920347E-13,
0.26436265493242,
1.54478860259211E-13,
0.287488167944028,
1.6188266005468E-13,
0.329265243870204,
1.59811400224363E-13,
0.420116139875281,
1.6227470756025E-13,
0.805903702803282,
1.65945382435417E-13,
5.61217738948017E-14,
1.72762845696006E-13,
5.21960946686661E-14,
1.74091643878604E-13,
4.30211422042248E-14,
1.68741756678692E-13,
5.18179249509032E-14,
1.84781009937574E-13,
5.45501144255667E-14,
1.58931028060305E-14,
2.99361230249318E-14,
3.04934029415893E-14,
4.31278276979974E-14,
3.21869267350117E-14,
5.51720127917044E-14,
3.31783212015324E-14,
6.73723229982492E-14,
3.46892653491082E-14,
7.13344314173803E-14,
0.809993055087066,
7.61604321275478E-14,
0.428113577233339,
8.31903990139438E-14,
0.337435826637575,
8.26595736302949E-14,
0.294700645700197,
8.89479462307108E-14,
0.270083562170474,
9.47228406822376E-14,
0.254878541543898,
1.05093017621627E-13,
0.245639548962545,
1.16257697913014E-13,
0.240841107110636,
1.26692059621014E-13,
0.239886156490494,
1.36722230759112E-13,
0.242797230302349,
1.42599473895721E-13,
0.250223267570444,
1.51241866253038E-13,
0.2637653596585,
1.56845023080443E-13,
0.28699901272363,
1.56184093436096E-13,
0.328883998154922,
1.60361307566248E-13,
0.419851082553175,
1.62160215810836E-13,
0.80580546195245,
1.68878799833294E-13,
4.82929668477183E-14,
1.75052680684296E-13,
4.0986311566904E-14,
1.68094704822153E-13,
4.36369690381966E-14,
1.76829037523696E-13,
4.56041454599543E-14,
1.89093532498852E-13,
2.37219098531138E-14,
3.39186144449055E-14,
4.56362378442599E-14,
3.79288614404949E-14,
5.24450274874688E-14,
3.39936412352415E-14,
6.43035971692463E-14,
3.8067639318573E-14,
7.34846211658535E-14,
3.67761376907083E-14,
7.90383383741933E-14,
0.809305516266406,
8.49997155993876E-14,
0.42674789782023,
8.60440191319256E-14,
0.335974037068278,
9.37704774939263E-14,
0.293286924301554,
9.79182013249869E-14,
0.268769881442566,
1.06178954517588E-13,
0.253682947533753,
1.12045789313342E-13,
0.244565645097482,
1.26553281742936E-13,
0.239886156490494,
1.36482838919427E-13,
0.239044850327014,
1.46783626919778E-13,
0.242063584441728,
1.5018021548574E-13,
0.249591676206019,
1.53686091630689E-13,
0.263231321589735,
1.50957371602978E-13,
0.286559907098329,
1.56581345112095E-13,
0.32854050756708,
1.59591090342914E-13,
0.419611469896335,
1.64784852429989E-13,
0.805716361383525,
1.70906691576711E-13,
3.68090974367519E-14,
1.69041863840036E-13,
4.1437339670658E-14,
1.76220149583628E-13,
3.74804354219549E-14,
1.80966353013901E-13,
3.72792074987416E-14,
2.32567871211176E-14,
4.44631310936305E-14,
4.29834119686223E-14,
5.6024629380147E-14,
4.01588484688631E-14,
6.20996309930177E-14,
3.89740323347709E-14,
7.06578892617493E-14,
4.01961450235966E-14,
8.14955741779144E-14,
3.95950633391706E-14,
8.78949690807929E-14,
0.808741373903882,
8.77006800514835E-14,
0.425609927317424,
9.72034952528844E-14,
0.334739501928254,
1.03033900855642E-13,
0.292079522193202,
1.09412479076809E-13,
0.267637207651043,
1.13192441530963E-13,
0.252643630955543,
1.22618928899421E-13,
0.243625446288882,
1.36749986334728E-13,
0.239044850327014,
1.46653522659079E-13,
0.238299533565909,
1.5424640731343E-13,
0.241410404774532,
1.52456172686222E-13,
0.249026833679864,
1.47470577416264E-13,
0.262751780339988,
1.5122798846523E-13,
0.286164149946392,
1.56123378114437E-13,
0.328229875783013,
1.6262859114935E-13,
0.419394100570162,
1.67562144715028E-13,
0.805635285845074,
1.65006897034914E-13,
3.72393088587941E-14,
1.76905365356639E-13,
3.53224394178397E-14,
1.80291545581746E-13,
2.91502932903143E-14,
1.83207615744863E-13,
2.7639565983173E-14,
3.73373207351868E-14,
5.71274798299992E-14,
4.60898680332278E-14,
6.63184784865933E-14,
4.55616447347928E-14,
6.88173476537379E-14,
4.13150416656016E-14,
7.89802251377481E-14,
4.3157317997089E-14,
9.05161362529938E-14,
4.24313362223927E-14,
9.08596115012372E-14,
0.808271851178868,
9.91203646938388E-14,
0.424650260740901,
1.06230996221868E-13,
0.333686210157977,
1.14326950684251E-13,
0.291039201120309,
1.16542192563074E-13,
0.266653023747164,
1.23874868696028E-13,
0.251733947370549,
1.32702876465274E-13,
0.242797230302349,
1.46811382495393E-13,
0.238299533565909,
1.54409471320172E-13,
0.237635902860453,
1.56555324259955E-13,
0.240826159513568,
1.4646790724715E-13,
0.248519517625143,
1.47899054114831E-13,
0.262319461074592,
1.50436954560185E-13,
0.285806139540864,
1.59088020534881E-13,
0.32794798514379,
1.64722402384854E-13,
0.419196267547713,
1.60729068943155E-13,
0.805561287195139,
1.7305427923997E-13,
3.11625725224474E-14,
1.8099237386604E-13,
2.70061750740069E-14,
1.82465154097144E-13,
1.99944227841087E-14,
1.98343945434498E-14,
4.64749766448946E-14,
4.23506715807598E-14,
6.87939288868122E-14,
5.20737966636098E-14,
7.36953900681847E-14,
4.81342396496665E-14,
7.74285149884868E-14,
4.44045841763163E-14,
8.80805844927224E-14,
4.60837965010619E-14,
9.3496391184722E-14,
4.7946022152523E-14,
1.02057251538668E-13,
0.807876292865122,
1.08061129489023E-13,
0.423832498782926,
1.17680171163315E-13,
0.332779475472074,
1.21527787833031E-13,
0.290135808487614,
1.27037269592734E-13,
0.265791933413096,
1.33559829862406E-13,
0.250932795214039,
1.42540493297538E-13,
0.242063584441728,
1.54249876760382E-13,
0.237635902860453,
1.56529303407815E-13,
0.237042261072604,
1.50532364351363E-13,
0.240301338990645,
1.46833933900581E-13,
0.248062065723239,
1.47269349493051E-13,
0.261928278695608,
1.53523027623947E-13,
0.285481161596332,
1.60914684355085E-13,
0.327691351031155,
1.58538113192996E-13,
0.41901566828386,
1.69086966650411E-13,
0.805493554912185,
1.77021591829529E-13,
2.26485497023532E-14,
1.83107001783256E-13,
1.78052017574259E-14,
1.82864140496619E-13,
2.60202016183486E-14,
2.92751933805846E-14,
6.05895542071799E-14,
4.9291300208143E-14,
7.70052424603485E-14,
5.50740009153117E-14,
8.27055438024082E-14,
5.1382509358433E-14,
8.68159710787353E-14,
4.73909106402104E-14,
9.13765590970783E-14,
5.15525122590788E-14,
1.04933423061837E-13,
5.53168622019484E-14,
1.11445574990654E-13,
0.807539514016532,
1.19584897539937E-13,
0.423129275258224,
1.2493478473985E-13,
0.331992693776391,
1.32177255252053E-13,
0.289345824931538,
1.36855804466762E-13,
0.265033840301956,
1.43765208071578E-13,
0.250223267570444,
1.50152459910124E-13,
0.241410404774532,
1.56539711748671E-13,
0.237042261072604,
1.50521956010508E-13,
0.236508960451245,
1.50485526817512E-13,
0.23982803958327,
1.4645056001239E-13,
0.247648065829469,
1.50360626727242E-13,
0.261573109217318,
1.55642859711591E-13,
0.285185223959563,
1.54921214745585E-13,
0.327457007353427,
1.66455391137355E-13,
0.418850333549444,
1.72521719132845E-13,
0.805431392559009,
1.78874276501872E-13,
1.36279876272738E-14,
1.83457415925403E-13,
  0,
1.39647408220478E-14,
4.61440781418521E-14,
3.78490641606E-14,
7.0231147286659E-14,
5.29186069964105E-14,
8.67084182232247E-14,
5.86319187645401E-14,
9.24399445878521E-14,
5.44972053595494E-14,
9.0351337522776E-14,
5.30599869597026E-14,
1.02867367401949E-13,
5.89285564789321E-14,
1.14548995289177E-13,
6.13016581940684E-14,
1.22802809587874E-13,
0.807250119446026,
1.27111862702201E-13,
0.422519650013744,
1.35398636746942E-13,
0.331305148354566,
1.42016606807793E-13,
0.288650660698684,
1.47099346592405E-13,
0.26436265493242,
1.51214110677422E-13,
0.249591676206019,
1.5245270323927E-13,
0.240826159513568,
1.505080782227E-13,
0.236508960451245,
1.50610426907782E-13,
0.236027981303634,
1.50126439057985E-13,
0.239399645225709,
1.49361426005079E-13,
0.247272116309112,
1.52268822550816E-13,
0.261249611290914,
1.49541837246581E-13,
0.284914926474007,
1.62534916081647E-13,
0.327242415709616,
1.70356784234826E-13,
0.418698570587905,
1.75165437710234E-13,
0.805374198853786,
1.79550818657503E-13,
  0,
1.87894838576952E-13,
2.72403627432638E-14,
2.5955800009303E-14,
5.82910456015107E-14,
4.24747043092921E-14,
8.08866862378466E-14,
5.6996074526694E-14,
9.69268068584661E-14,
6.20233031600748E-14,
9.62164375950536E-14,
6.03475602822812E-14,
1.02078068220379E-13,
6.05661354402542E-14,
1.12616513336938E-13,
6.51007026064576E-14,
1.26128274491322E-13,
6.45126313481015E-14,
1.30177119084252E-13,
0.80699940396042,
1.37518468834585E-13,
0.421987350634723,
1.45250131367014E-13,
0.330700489038719,
1.52145657184022E-13,
0.288035447793059,
1.54485799153115E-13,
0.2637653596585,
1.53693030524593E-13,
0.249026833679864,
1.46502601716669E-13,
0.240301338990645,
1.50541037968743E-13,
0.236027981303634,
1.50199297443976E-13,
0.235592609402692,
1.52981793899443E-13,
0.239010580966125,
1.51385848301544E-13,
0.246929638819217,
1.46115758381526E-13,
0.260954085585687,
1.57270030332057E-13,
0.284667357648998,
1.66727742723083E-13,
0.327045392753308,
1.72587638624933E-13,
0.418558917366589,
1.75161968263282E-13,
0.805321452337844,
1.83689868871184E-13,
  0,
1.59856936715608E-14,
4.54809800931599E-14,
3.19648821300866E-14,
7.0382935590807E-14,
4.71324368422898E-14,
9.18752920964216E-14,
6.07135869357123E-14,
1.0112050086164E-13,
6.8060140856474E-14,
1.08199907367101E-13,
6.79040157436361E-14,
1.11976400374303E-13,
6.67712413138233E-14,
1.24214874497319E-13,
6.83082063135387E-14,
1.33577177097166E-13,
6.83255535482985E-14,
1.41067713066434E-13,
0.806780612503494,
1.47496598268404E-13,
0.421519558002028,
1.55760820907958E-13,
0.330165656399363,
1.59728133497516E-13,
0.287488167944028,
1.5692828980729E-13,
0.263231321589735,
1.47526088567496E-13,
0.248519517625143,
1.46833933900581E-13,
0.23982803958327,
1.50126439057985E-13,
0.235592609402692,
1.53054652285434E-13,
0.235197186310703,
1.55058257900187E-13,
0.238656120369042,
1.45095740977652E-13,
0.246616730710275,
1.540607919015E-13,
0.260683363046965,
1.61346630500603E-13,
0.284440011955618,
1.68469405092964E-13,
0.326864051673185,
1.72886011062801E-13,
0.418430105496536,
1.79051218296422E-13,
0.805272698873975,
1.82746179300253E-13,
2.52727526406371E-14,
2.55863039089199E-14,
6.00830149521947E-14,
3.75081909975705E-14,
8.2353394936785E-14,
5.13148551428699E-14,
9.66041482919344E-14,
6.70418581760757E-14,
1.13462191031477E-13,
7.58004770062826E-14,
1.18351509148518E-13,
7.43068800934665E-14,
1.23788132522229E-13,
7.00550728538474E-14,
1.31880617537661E-13,
7.225296749791E-14,
1.44327258477794E-13,
7.07888608841856E-14,
1.51141252291431E-13,
0.806588430277071,
1.57755752905331E-13,
0.421106049680966,
1.63275643005889E-13,
0.329690106635812,
1.61884394778156E-13,
0.28699901272363,
1.50985127178593E-13,
0.262751780339988,
1.47867829092263E-13,
0.24806206572324,
1.4645056001239E-13,
0.239399645225709,
1.52981793899443E-13,
0.235197186310703,
1.55358365061531E-13,
0.234836914212858,
1.48993664628172E-13,
0.238332233614817,
1.52773627082325E-13,
0.246330047670888,
1.57953511381592E-13,
0.260434715395082,
1.63320745816264E-13,
0.284230723138755,
1.68698388591793E-13,
0.32669675471644,
1.77059755746001E-13,
0.418311029979403,
1.78596720745716E-13,
0.805227541389062,
1.35585986882347E-14,
4.57633063388752E-14,
3.2464482491168E-14,
7.35071725710412E-14,
4.22240367670135E-14,
8.78264475034918E-14,
5.79918058019047E-14,
1.09406407544643E-13,
7.49790854404075E-14,
1.2386099090822E-13,
8.23369150637632E-14,
1.30419980370888E-13,
7.7715611723761E-14,
1.31615204845836E-13,
7.41455508102007E-14,
1.42904785227493E-13,
7.46677025764697E-14,
1.54645393712904E-13,
7.77780617688961E-14,
1.6142989722745E-13,
0.806418623809552,
1.6484036358122E-13,
0.42073858433172,
1.65902014348518E-13,
0.329265243870204,
1.56125112837913E-13,
0.286559907098329,
1.51283499616461E-13,
0.262319461074592,
1.4721383834182E-13,
0.247648065829469,
1.49361426005079E-13,
0.239010580966125,
1.55086013475803E-13,
0.234836914212858,
1.48912132624801E-13,
0.234507701959981,
1.56770429970976E-13,
0.238035466678467,
1.56690632691081E-13,
0.246066709680902,
1.59823543288695E-13,
0.260205782908418,
1.63705854427931E-13,
0.284037610070481,
1.73111525114678E-13,
0.326542074419098,
1.76095249493358E-13,
0.418200724371527,
1.79672249300822E-13,
2.75406867450423E-14,
2.35640500168E-14,
6.17110529343989E-14,
3.79783010595602E-14,
7.99698848807928E-14,
4.9291300208143E-14,
1.01156062692898E-13,
6.62317423127945E-14,
1.20244959822546E-13,
8.17106798889355E-14,
1.3630936657183E-13,
8.58427912087123E-14,
1.38368483337814E-13,
8.18459883200617E-14,
1.42672332281712E-13,
7.65967150817559E-14,
1.5320730795132E-13,
8.17557826993109E-14,
1.64984345629726E-13,
8.31574392679002E-14,
1.69142477801643E-13,
0.80626778347429,
1.68086031204773E-13,
0.420410451884982,
1.59839155799979E-13,
0.328883998154922,
1.56532772854767E-13,
0.286164149946392,
1.50402260090665E-13,
0.261928278695608,
1.50372769791574E-13,
0.247272116309112,
1.51385848301544E-13,
0.238656120369042,
1.48971113222984E-13,
0.234507701959981,
1.56787777205736E-13,
0.234206042588788,
1.60618046640693E-13,
0.237762844471706,
1.58775770309205E-13,
0.245824225089134,
1.60135793514371E-13,
0.259994515751032,
1.67622860036687E-13,
0.283859032500952,
1.71987424302245E-13,
0.326398761752297,
1.77032000170385E-13,
0.418098340276682,
1.365335795811E-14,
4.97670481214296E-14,
3.04097025338734E-14,
6.96708316039185E-14,
4.55685836286968E-14,
9.40489006118206E-14,
5.79076717133198E-14,
1.12509827843166E-13,
7.31949223453654E-14,
1.32933594687579E-13,
8.54628867674734E-14,
1.44455628015017E-13,
9.01518443230387E-14,
1.49626838696904E-13,
8.44029707236515E-14,
1.53179552375704E-13,
8.37403063558284E-14,
1.63610444636753E-13,
8.71993449669262E-14,
1.72728151226487E-13,
7.77260200646168E-14,
1.71621397648813E-13,
0.80613313564323,
1.62101235212653E-13,
0.420116139875281,
1.60333551990632E-13,
0.32854050756708,
1.56123378114437E-13,
0.285806139540864,
1.53521292900471E-13,
0.261573109217318,
1.52296578126432E-13,
0.246929638819217,
1.45054107614229E-13,
0.238332233614817,
1.56714918819745E-13,
0.234206042588788,
1.60704782814491E-13,
0.233928915117434,
1.6258522306245E-13,
0.237511792626069,
1.58893731505572E-13,
0.24560042890239,
1.64313007644523E-13,
0.259799125997299,
1.66859581707257E-13,
0.283693554677746,
1.72979686130503E-13,
0.326265719800219,
1.68146746526432E-13,
2.99463145253531E-14,
2.35909382306776E-14,
6.03432234735912E-14,
3.87944884550073E-14,
8.4746445971895E-14,
5.46073603002739E-14,
1.05995073829135E-13,
6.51848366950425E-14,
1.25600918554625E-13,
7.71431529766886E-14,
1.41411188314677E-13,
8.99297997181137E-14,
1.55936027979031E-13,
9.27851545595715E-14,
1.60271101945497E-13,
9.1551766168152E-14,
1.63672894681888E-13,
8.92810131380983E-14,
1.71612724031434E-13,
8.19431328347164E-14,
1.75325032270024E-13,
7.08634539936526E-14,
1.65659153061881E-13,
0.806012403549148,
1.62264299219395E-13,
0.419851082553175,
1.59670887622809E-13,
0.328229875783013,
1.59004753808034E-13,
0.285481161596332,
1.55642859711591E-13,
0.261249611290914,
1.46053308336391E-13,
0.246616730710275,
1.52829138233557E-13,
0.238035466678467,
1.60621516087645E-13,
0.233928915117435,
1.62703184258817E-13,
0.233673705228636,
1.62772573197856E-13,
0.237280073897744,
1.63286051346745E-13,
0.245393432303972,
1.63053598400964E-13,
0.259618048166321,
1.67938579709315E-13,
0.283539915263774,
1.64288721515859E-13,
0.326141981891246,
1.35874384660228E-14,
4.70777930527966E-14,
3.33448546552262E-14,
7.69505986708552E-14,
4.83797030215172E-14,
9.74871225412066E-14,
6.22392762328339E-14,
1.19600510051221E-13,
6.93247542704611E-14,
1.34432395770823E-13,
8.17471090819311E-14,
1.53111898160141E-13,
9.26272947232576E-14,
1.66743355234367E-13,
1.00093544563862E-13,
1.70977815239226E-13,
9.71132896321336E-14,
1.7169599075828E-13,
8.39293912147099E-14,
1.74138481412456E-13,
7.49626055673858E-14,
1.69553607265449E-13,
6.2600966077575E-14,
1.66347838281844E-13,
0.805903702803282,
1.62125521341316E-13,
0.419611469896335,
1.62625121702398E-13,
0.32794798514379,
1.61036114998403E-13,
0.285185223959562,
1.49527959458773E-13,
0.260954085585687,
1.53998341856365E-13,
0.246330047670888,
1.56690632691081E-13,
0.237762844471706,
1.6260257029721E-13,
0.233673705228636,
1.6292175941679E-13,
0.233438140770513,
1.67196118061597E-13,
0.237065736130159,
1.62061336572705E-13,
0.245201581109966,
1.63962593502376E-13,
0.259449906572571,
1.58865975929956E-13,
0.283397002329622,
1.55896129339084E-13,
2.4456998926059E-14,
2.64931306059868E-14,
6.63262847422352E-14,
4.37705427458468E-14,
9.0726037793587E-14,
5.64574428874032E-14,
1.11716191852906E-13,
6.66636884583127E-14,
1.28825769496466E-13,
7.41472855336767E-14,
1.46462703076722E-13,
8.4671852862428E-14,
1.64165556149065E-13,
1.00088340393434E-13,
1.77561090830558E-13,
1.05748743095546E-13,
1.7906509608423E-13,
9.19455483971987E-14,
1.74376138528665E-13,
7.70650904202697E-14,
1.68478078710343E-13,
6.68128746772467E-14,
1.70023717327439E-13,
6.00786781435048E-14,
1.65919361583278E-13,
0.80580546195245,
1.64784852429989E-13,
0.419394100570162,
1.64687707915334E-13,
0.327691351031155,
1.54921214745585E-13,
0.284914926474007,
1.57270030332057E-13,
0.260683363046965,
1.57953511381592E-13,
0.246066709680902,
1.58775770309205E-13,
0.237511792626069,
1.62835023242991E-13,
0.233438140770513,
1.669359095402E-13,
0.233220238972154,
1.65974872734509E-13,
0.236867069418627,
1.63154212362571E-13,
0.24502342138791,
1.55344487273723E-13,
0.259293488171259,
1.50438689283661E-13,
0.283263832459084,
1.70133004906425E-14,
4.96417143502903E-14,
3.84813708675935E-14,
8.17453743584551E-14,
5.24450274874688E-14,
1.05814662587633E-13,
6.12452796810992E-14,
1.21483552384394E-13,
7.17394893490209E-14,
1.41265471542695E-13,
7.72108071922517E-14,
1.57743609840999E-13,
9.22040221951193E-14,
1.75219214137989E-13,
1.05797315352874E-13,
1.85827048193588E-13,
1.00617431053607E-13,
1.81873613391836E-13,
8.50847170497104E-14,
1.68821553958587E-13,
6.88164802919999E-14,
1.68967270730569E-13,
6.41830338876659E-14,
1.69723610166095E-13,
5.6094018319186E-14,
1.68878799833294E-13,
0.805716361383525,
1.67562144715028E-13,
0.419196267547713,
1.58590154897276E-13,
0.327457007353427,
1.62547059145979E-13,
0.284667357648998,
1.61346630500603E-13,
0.260434715395082,
1.59823543288695E-13,
0.245824225089134,
1.58886792611668E-13,
0.237280073897744,
1.67203056955501E-13,
0.233220238972154,
1.66058139461356E-13,
0.233018262987712,
1.66866520601161E-13,
0.236682570651395,
1.54317530975945E-13,
0.244857670851741,
1.46899853392668E-13,
0.259147719860033,
1.40731176712094E-13,
3.28868876575683E-14,
3.28617341671666E-14,
6.78571782097848E-14,
4.81038819888369E-14,
9.80040701370477E-14,
5.76882291936087E-14,
1.16270708339083E-13,
6.65856259018938E-14,
1.34363006831784E-13,
7.49816875256215E-14,
1.52922813301259E-13,
8.49285919368725E-14,
1.690661499687E-13,
9.80968778430125E-14,
1.8370895082942E-13,
1.00768351996017E-13,
1.88793425337508E-13,
9.37826205582581E-14,
1.76397091378178E-13,
7.69159042013356E-14,
1.69381869641327E-13,
6.63219479335453E-14,
1.68691449697889E-13,
6.01012295486925E-14,
1.72797540165526E-13,
4.83623557867574E-14,
1.70962202727942E-13,
0.805635285845074,
1.60673557791924E-13,
0.41901566828386,
1.66399879986123E-13,
0.327242415709616,
1.66727742723083E-13,
0.284440011955618,
1.63386665308352E-13,
0.260205782908418,
1.60191304665602E-13,
0.24560042890239,
1.63292990240649E-13,
0.237065736130159,
1.65974872734509E-13,
0.233018262987712,
1.66883867835921E-13,
0.232830685919372,
1.58019430873679E-13,
0.236510914001244,
1.45661260830821E-13,
0.244703194943312,
1.37133360222919E-13,
0.259011649415447,
2.09359439506951E-14,
5.83977310952832E-14,
4.42597347660723E-14,
8.58115661861447E-14,
5.40114827862759E-14,
1.0936043737253E-13,
6.33876631739305E-14,
1.29665375658838E-13,
7.00463992364675E-14,
1.46401987755063E-13,
8.28538626596043E-14,
1.64512500844261E-13,
9.0875224012521E-14,
1.77731093731204E-13,
9.3119956190435E-14,
1.86791554446231E-13,
9.40029304397072E-14,
1.83464354819307E-13,
8.56485021794029E-14,
1.77026795999957E-13,
7.43398398395101E-14,
1.69163294483354E-13,
6.22609602762836E-14,
1.71800074166839E-13,
5.22169113503779E-14,
1.75038802896488E-13,
3.68160363306558E-14,
1.64951385883683E-13,
0.805561287195139,
1.69100844438219E-13,
0.418850333549443,
1.7038107036349E-13,
0.327045392753308,
1.68524916244195E-13,
0.284230723138754,
1.636503432767E-13,
0.259994515751032,
1.64313007644523E-13,
0.245393432303973,
1.62068275466609E-13,
0.236867069418627,
1.66838765025545E-13,
0.232830685919372,
1.58095758706622E-13,
0.232656160874443,
1.49678880401183E-13,
0.236350926246393,
1.35929462130591E-13,
0.244558986737948,
1.41567313427515E-13,
3.45353086406153E-14,
3.70285399564629E-14,
7.94538046466897E-14,
5.12636808003286E-14,
9.83831072165486E-14,
6.01792921051114E-14,
1.23445524635724E-13,
6.71407374142063E-14,
1.42205691666675E-13,
7.81198022936636E-14,
1.58347293610639E-13,
8.89600892950426E-14,
1.73385611423882E-13,
8.60284066206418E-14,
1.81058293358127E-13,
8.64759652774438E-14,
1.81625547934772E-13,
8.58948329129916E-14,
1.84168652550554E-13,
8.31886642904678E-14,
1.7695220289049E-13,
7.03239549926238E-14,
1.72384675978243E-13,
5.444950046396E-14,
1.74091643878604E-13,
4.0984576843428E-14,
1.69041863840036E-13,
3.72670644344097E-14,
1.73120198732057E-13,
0.805493554912185,
1.72577230284077E-13,
0.418698570587905,
1.72587638624933E-13,
0.326864051673185,
1.68687980250937E-13,
0.284037610070481,
1.67674901740966E-13,
0.259799125997299,
1.63025842825348E-13,
0.245201581109966,
1.63181967938186E-13,
0.236682570651395,
1.58019430873679E-13,
0.232656160874443,
1.49422141326738E-13,
0.232493495920171,
1.39655648156989E-13,
0.236201566032847,
1.40394640357755E-13,
0.244424149987018,
2.18319286260371E-14,
6.35355483502575E-14,
4.5998795050739E-14,
9.39222657980743E-14,
5.81470635530046E-14,
1.13432700732385E-13,
6.43443631709317E-14,
1.36531411176755E-13,
7.5467410098895E-14,
1.54518758899158E-13,
8.44133790645074E-14,
1.67458061306469E-13,
8.42451108873377E-14,
1.7695220289049E-13,
7.94815602223053E-14,
1.75994635531751E-13,
7.84181747315316E-14,
1.82477297161476E-13,
8.35373437091391E-14,
1.84199877573121E-13,
7.91137988453983E-14,
1.80213483025327E-13,
6.25020868394444E-14,
1.74686654030864E-13,
4.30488977798404E-14,
1.68094704822153E-13,
4.14650952462736E-14,
1.76874140334071E-13,
3.1188593374587E-14,
1.77080572427712E-13,
0.805431392559009,
1.75155029369378E-13,
0.418558917366589,
1.72941522214032E-13,
0.32669675471644,
1.73139280690293E-13,
0.283859032500952,
1.66817948343834E-13,
0.259618048166321,
1.63973001843232E-13,
0.24502342138791,
1.54324469869849E-13,
0.236510914001244,
1.49623369249952E-13,
0.232493495920171,
1.39794426035067E-13,
0.232341633036372,
1.44193684770144E-13,
0.236061906370892,
1.43496325932801E-13,
3.88300502862649E-14,
3.56481337504544E-14,
8.13888886841418E-14,
5.39845945723982E-14,
1.10263360941776E-13,
6.27839794042906E-14,
1.27231558622043E-13,
7.299889859258E-14,
1.49356221834651E-13,
8.20038481563756E-14,
1.64066676910934E-13,
7.98389132583566E-14,
1.71290065464902E-13,
7.78075520679877E-14,
1.72060282688236E-13,
7.150703640324E-14,
1.77030265446909E-13,
7.60728285920109E-14,
1.82567502782227E-13,
7.94971727335891E-14,
1.87547893881757E-13,
7.13873404833976E-14,
1.82616075039554E-13,
5.11656689239359E-14,
1.687556344665E-13,
4.36369690381966E-14,
1.76192394008012E-13,
3.53155005239358E-14,
1.81014925271228E-13,
2.2662427490161E-14,
1.78874276501872E-13,
0.805374198853786,
1.75234826649273E-13,
0.418430105496536,
1.77059755746001E-13,
0.326542074419098,
1.71980485408341E-13,
0.283693554677746,
1.67910824133699E-13,
0.259449906572571,
1.55316731698107E-13,
0.244857670851741,
1.45654321936917E-13,
0.236350926246393,
1.3960360645271E-13,
0.232341633036372,
1.44273482050039E-13,
0.232199630348841,
1.47337003708614E-13,
0.235931119798707,
1.93256868841196E-14,
6.53435638930944E-14,
4.55659815434828E-14,
9.97526714008323E-14,
5.93761151357342E-14,
1.250683584475E-13,
7.18990839088107E-14,
1.40649644708724E-13,
7.97834021071253E-14,
1.5933435126847E-13,
7.76063241447744E-14,
1.68158889590764E-13,
7.34707433780457E-14,
1.66595903738909E-13,
6.9933642210529E-14,
1.73245098822328E-13,
6.92935292478936E-14,
1.77247105881406E-13,
7.20534742981727E-14,
1.86019602499421E-13,
7.17603060307326E-14,
1.89976506748124E-13,
6.00942906547886E-14,
1.76636483217862E-13,
5.18040471630954E-14,
1.76834241694124E-13,
3.75185993384264E-14,
1.80291545581746E-13,
2.69784194983913E-14,
1.83110471230208E-13,
1.36279876272738E-14,
1.79550818657503E-13,
0.805321452337844,
1.79106729447653E-13,
0.418311029979403,
1.76126474515925E-13,
0.326398761752297,
1.73003972259167E-13,
0.283539915263774,
1.5887291482386E-13,
0.259293488171259,
1.46899853392668E-13,
0.244703194943312,
1.35867012085455E-13,
0.236201566032847,
1.44162459747577E-13,
0.232199630348841,
1.47389045412893E-13,
0.232066647068636,
1.45463502354559E-13,
3.66312882804642E-14,
3.37139170747403E-14,
8.72271005425418E-14,
5.20737966636098E-14,
1.15980142156857E-13,
6.89830137456937E-14,
1.39303499291366E-13,
7.90253279481234E-14,
1.51130843950575E-13,
7.55558809961698E-14,
1.63761365579163E-13,
7.13040737565507E-14,
1.63742283620927E-13,
6.56801002474339E-14,
1.68004499201402E-13,
6.77478906307982E-14,
1.73586839347095E-13,
6.5298461082719E-14,
1.80798084836731E-13,
6.4401609045639E-14,
1.88540155710015E-13,
6.04637867551716E-14,
1.8414436642189E-13,
6.06702188488129E-14,
1.84796622448857E-13,
4.56197579712381E-14,
1.80962883566949E-13,
2.91780488659299E-14,
1.82496379119712E-13,
1.77635683940025E-14,
1.83519865970538E-13,
  0,
1.837176244468E-13,
0.805272698873975,
1.78610598533524E-13,
0.418200724371526,
1.77035469617337E-13,
0.326265719800219,
1.64267904834148E-13,
0.283397002329622,
1.50459505965372E-13,
0.259147719860033,
1.37081318518639E-13,
0.244558986737948,
1.40370354229091E-13,
0.236061906370892,
1.47340473155566E-13,
0.232066647068636,
1.45609219126541E-13,
0.23194193067395,
1.96166867472147E-14,
6.70405571334687E-14,
4.2108677655861E-14,
1.05610832579206E-13,
6.24405041560472E-14,
1.31265658065427E-13,
7.6591510911328E-14,
1.50410933708045E-13,
7.50718931463723E-14,
1.55974191895503E-13,
6.94670015954912E-14,
1.59660479281953E-13,
6.36400654396851E-14,
1.65312208366686E-13,
6.35984320762617E-14,
1.68542263478955E-13,
6.38517017037543E-14,
1.77319964267397E-13,
5.7667412511897E-14,
1.83488640947971E-13,
5.31241717283137E-14,
1.82839854367955E-13,
6.11455330812305E-14,
1.92347873739784E-13,
5.45379713612348E-14,
1.89093532498852E-13,
3.72930852865494E-14,
1.8323884076743E-13,
1.99909533371567E-14,
1.82871079390523E-13,
  0,
1.8790871636476E-13,
  0,
1.82746179300253E-13,
0.805227541389062,
1.79734699345957E-13,
0.418098340276682,
1.68174502102048E-13,
0.326141981891246,
1.55896129339084E-13,
0.283263832459084,
1.40731176712094E-13,
0.259011649415447,
1.41574252321419E-13,
0.244424149987018,
1.43468570357186E-13,
0.235931119798707,
1.45432277331992E-13,
0.23194193067395,
1.36772537739915E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999996,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.85825747150981E-14,
2.0384518725769E-14,
2.58473797920544E-14,
2.15671664555162E-14,
2.78113036072947E-14,
1.71655224756595E-14,
2.75907768854111E-14,
1.9110364332664E-14,
2.69385208584438E-14,
1.04755613905549E-14,
2.11861778121047E-14,
1.20843005740889E-14,
2.76619005479262E-14,
  0,
2.57059998287623E-14,
1.91591534304258E-14,
3.27086448204117E-14,
2.16823087262341E-14,
3.57231605407904E-14,
2.12980674763052E-14,
3.75988302991903E-14,
1.69603914246252E-14,
3.61464330689287E-14,
1.77184655836271E-14,
4.6373929002419E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.866448577718203,
1.1515094433534E-14,
0.866400225443959,
1.48891315943089E-14,
  0,
1.20016843685455E-14,
  0,
1.11338889496881E-14,
  0,
2.20283860596915E-14,
2.61921560829048E-14,
3.84605541858818E-14,
3.63840901851376E-14,
4.64875533900955E-14,
3.35304700671557E-14,
4.79937270481123E-14,
3.1417576873416E-14,
4.72352192082415E-14,
2.56361772088542E-14,
4.1658083232976E-14,
1.95308179351539E-14,
4.22908236208386E-14,
1.85953683007334E-14,
4.62082629104632E-14,
2.47193758518005E-14,
5.05862712829597E-14,
3.53926957186168E-14,
5.92798379828174E-14,
3.72002775805846E-14,
6.34887108164062E-14,
3.31249784546461E-14,
6.38547374698373E-14,
3.00350022630624E-14,
7.14588978267816E-14,
3.25468818562769E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.05189294774544E-14,
  0,
-1.12600900825655E-14,
  0,
0.839401691844484,
1.1147333056627E-14,
0.560562663483811,
1.48054311865931E-14,
0.839212243709222,
1.74335372526979E-14,
  0,
1.55882251551276E-14,
  0,
2.44938617999235E-14,
2.34291752665428E-14,
3.78178391380324E-14,
3.77367408155305E-14,
5.33965233140421E-14,
4.35801568443583E-14,
6.03857241987527E-14,
4.36959496363798E-14,
6.13623735157276E-14,
3.38461897397835E-14,
5.59335563976582E-14,
3.20533530273615E-14,
5.7593686764168E-14,
2.34265731813288E-14,
5.47747611157057E-14,
3.14262504907958E-14,
6.50209053265627E-14,
3.67657293498524E-14,
6.97948643324509E-14,
4.60265506263546E-14,
7.89368570508486E-14,
4.43169806407795E-14,
8.12839379138453E-14,
4.22023527235638E-14,
9.06280259171943E-14,
4.08024308784505E-14,
9.23939744157387E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07396730397724E-14,
  0,
-1.2419752726256E-14,
  0,
0.828189580500137,
1.05124242644195E-14,
0.498765704069467,
1.36501053515925E-14,
0.498456516645347,
1.62205318621211E-14,
0.827761101976404,
2.03912407792384E-14,
  0,
2.82421655506404E-14,
2.02234062829376E-14,
3.89948490164826E-14,
3.36891972652076E-14,
5.07675498861992E-14,
4.32232374891761E-14,
6.48691170224147E-14,
5.190986529513E-14,
7.11947861775641E-14,
4.4506065499661E-14,
6.76030412205542E-14,
3.88508669679766E-14,
6.95494009606001E-14,
3.47881445872389E-14,
6.77452885455843E-14,
3.51862636249756E-14,
7.10360589795123E-14,
4.2113014464551E-14,
8.14175116214955E-14,
4.56024107364783E-14,
8.63181054411299E-14,
5.1158730030032E-14,
9.33853688822595E-14,
5.15828699199083E-14,
1.04485864405035E-13,
5.12671502472806E-14,
1.0773933828423E-13,
4.82530682077709E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.24119464706141E-14,
  0,
0.822302312523379,
  0,
0.472715661298871,
1.33378551259167E-14,
0.425801297881376,
1.56810328610923E-14,
0.471850148753609,
1.92129298581811E-14,
0.821525524653432,
3.25833110492724E-14,
2.05460648494693E-14,
4.21771992331621E-14,
2.98780097884865E-14,
5.100867644936E-14,
3.82523873687646E-14,
6.10501232900518E-14,
5.05706587716759E-14,
7.42418279631174E-14,
5.1680881796301E-14,
7.59713472686663E-14,
4.86225643081539E-14,
7.98363111731426E-14,
4.08423295183979E-14,
7.83244996638288E-14,
4.58270574266173E-14,
8.25884499677798E-14,
4.50082679459562E-14,
8.58401891234983E-14,
4.99860569602717E-14,
9.61982229985558E-14,
4.96928886928316E-14,
9.88306658733507E-14,
5.73300087958195E-14,
1.14517770266609E-13,
5.95599958241877E-14,
1.19354179317632E-13,
5.76743514058009E-14,
1.21222476501259E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.01507344196783E-14,
  0,
0.81889162268085,
  0,
0.458880237300692,
  0,
0.394292909086673,
1.43930006801796E-14,
0.393637862174603,
1.78164774600198E-14,
0.457187989999148,
3.12198183971546E-14,
0.817639366337327,
4.5776750445814E-14,
2.9917041066696E-14,
5.36203026424431E-14,
3.40977246438001E-14,
6.0586084760228E-14,
4.50481665859037E-14,
6.95251148319365E-14,
4.96989602249975E-14,
7.81258738258295E-14,
5.52084419846999E-14,
8.72557234798954E-14,
5.00337618558611E-14,
8.75766473229511E-14,
5.13556211445554E-14,
9.21736645342897E-14,
5.5122573172639E-14,
9.6408991900887E-14,
5.23877816127616E-14,
9.95271573489553E-14,
5.34849942113169E-14,
1.0754071244623E-13,
5.51537981952066E-14,
1.18695851758499E-13,
6.45716119462847E-14,
1.2791417230984E-13,
6.52169290793481E-14,
1.31362802580082E-13,
6.61285262659739E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.00787433954252E-14,
  0,
0.81688762388229,
  0,
0.450805000959554,
  0,
0.377271366210101,
1.01897656978878E-14,
0.359094015133419,
1.68138072909052E-14,
0.375597960670688,
2.91936613772137E-14,
0.447974316949199,
4.45156064787788E-14,
0.815005908958123,
5.67861729861008E-14,
3.40959899203241E-14,
6.26877022513739E-14,
4.05613043152897E-14,
6.8659487817424E-14,
4.38572789196456E-14,
7.28436408414801E-14,
5.27937069061402E-14,
8.87293710727377E-14,
5.61634072582251E-14,
9.43429362409987E-14,
6.01584754233997E-14,
1.00784831869039E-13,
6.02434768737226E-14,
1.05175416986736E-13,
6.20380483096206E-14,
1.09277170645683E-13,
5.53671691827518E-14,
1.10017897569925E-13,
5.85217638238156E-14,
1.26430116376142E-13,
6.18853926437346E-14,
1.31076573206546E-13,
6.97523636072894E-14,
1.38868083698895E-13,
7.31706362167017E-14,
1.42573453043582E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.815821477053102,
  0,
0.446037545682645,
  0,
0.36722868407724,
1.03779831950312E-14,
0.340210246534238,
1.26209806494693E-14,
0.339112157727228,
2.85032414337749E-14,
0.364126230020177,
4.22856194504106E-14,
0.441693461741773,
5.52396670072675E-14,
0.813116311495751,
6.5746019739521E-14,
4.01701241714569E-14,
7.02927299700562E-14,
3.91128102128491E-14,
7.15243836379997E-14,
4.66458469072784E-14,
8.2947537727307E-14,
5.34546365504873E-14,
9.52588702363144E-14,
6.59541865566382E-14,
1.06965651613944E-13,
6.87306114799391E-14,
1.13189839445749E-13,
6.67590982494914E-14,
1.17447718217534E-13,
6.47372780382405E-14,
1.19107848584044E-13,
6.01081684425964E-14,
1.2822035100335E-13,
6.49064135771482E-14,
1.3805970255909E-13,
6.66636884583127E-14,
1.41164857581089E-13,
7.72298891504875E-14,
1.49219178680049E-13,
7.40171812729784E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.0023665925063E-14,
  0,
0.815485955148288,
  0,
0.443493939383353,
  0,
0.361258750123492,
1.01038968858269E-14,
0.328980599731439,
1.24076096619241E-14,
0.31899695057376,
2.41239320186715E-14,
0.326296470041122,
4.0985444205166E-14,
0.356239458942884,
5.27702881392145E-14,
0.43716674820195,
6.36027688849516E-14,
0.811702809668153,
7.33796703955569E-14,
3.85550966153225E-14,
7.29503263352527E-14,
4.16706599781769E-14,
8.13221018303167E-14,
4.70058020285435E-14,
8.91517762391381E-14,
6.29479107727704E-14,
1.07470456145453E-13,
7.42192765579297E-14,
1.18878865085215E-13,
7.49504625030539E-14,
1.24960805591989E-13,
6.91929152862869E-14,
1.26801347200001E-13,
6.91426083054836E-14,
1.36805497485959E-13,
6.62195992484627E-14,
1.39227171458423E-13,
6.93525098460768E-14,
1.47545170525731E-13,
7.38142186262891E-14,
1.50929616027362E-13,
7.77572450871844E-14,
1.59936300314634E-13,
  0,
  0,
  0,
-1.07409740823794E-14,
  0,
-1.01229788440627E-14,
  0,
0.815821477053102,
  0,
0.442692375651926,
  0,
0.358060439026487,
  0,
0.322270339139647,
1.25533264339062E-14,
0.306964860840936,
2.36807101705594E-14,
0.305308761676111,
3.65289395953816E-14,
0.317429846133262,
5.1530828215629E-14,
0.350519313226927,
6.11724212951081E-14,
0.433769055520558,
7.11366729411189E-14,
0.810611352333152,
7.5397153798118E-14,
4.10210060364236E-14,
8.25823784356139E-14,
4.20002574386125E-14,
8.72036817756161E-14,
5.64305546735255E-14,
1.01011213282654E-13,
7.09987624247788E-14,
1.18998561005057E-13,
8.02431038282592E-14,
1.30239569129387E-13,
7.71015196132652E-14,
1.33821773107279E-13,
7.34134975033385E-14,
1.43985517953027E-13,
7.50823014872282E-14,
1.47316187026902E-13,
7.04662023176539E-14,
1.48240794639598E-13,
7.62757912387002E-14,
1.56806859163972E-13,
7.40831007650655E-14,
1.61122851172202E-13,
7.63330371134074E-14,
  0,
  0,
-1.05184957965854E-14,
  0,
-1.24475083018716E-14,
  0,
0.81688762388229,
  0,
0.443493939383353,
  0,
0.357050607389246,
1.00804781189012E-14,
0.318664009767438,
1.12071810165482E-14,
0.299746753126025,
2.37891303878079E-14,
0.292698824003426,
3.64534791241766E-14,
0.295794814566557,
4.7045700668491E-14,
0.31096787127609,
5.99945440549199E-14,
0.346204941044028,
6.86083134748827E-14,
0.431138463130618,
7.32513008583346E-14,
0.809747199266645,
8.51124726253261E-14,
4.13055006864838E-14,
8.81517081552374E-14,
5.12003633934555E-14,
9.88219922559708E-14,
6.42593617206089E-14,
1.12224465831368E-13,
7.67857999406374E-14,
1.30019259247938E-13,
8.21703816100694E-14,
1.38774408631193E-13,
8.11867933991905E-14,
1.50681550570297E-13,
7.91554322088217E-14,
1.54140589181395E-13,
7.91415544210139E-14,
1.55975926618979E-13,
7.71830516166361E-14,
1.57100027431412E-13,
7.63018120908399E-14,
1.66564678716341E-13,
7.24368481863635E-14,
1.58912813463807E-13,
  0,
  0,
  0,
-1.24331968331948E-14,
  0,
0.81889162268085,
  0,
0.446037545682645,
  0,
0.358060439026486,
1.01368566318705E-14,
0.317523637421859,
1.24041402149722E-14,
0.295858024191571,
2.24958940364672E-14,
0.285110984907833,
3.62930172026488E-14,
0.28275083898052,
4.66519184394443E-14,
0.288836157532161,
5.53125253932585E-14,
0.306075469625288,
6.68328239972205E-14,
0.342851811991283,
7.0304873034388E-14,
0.429051245736874,
8.23646706393788E-14,
0.80904898875008,
9.03773583749157E-14,
5.02306529703844E-14,
9.95245552637414E-14,
5.89753940127835E-14,
1.09894732203131E-13,
6.98989477410095E-14,
1.22988424999804E-13,
7.85916470791292E-14,
1.38354605550006E-13,
8.60006510450262E-14,
1.55275098334684E-13,
8.66529070719935E-14,
1.60517432679086E-13,
8.30013141550623E-14,
1.62432567396564E-13,
8.56814619254465E-14,
1.64462193863457E-13,
7.70251917803222E-14,
1.66469268925162E-13,
7.45150469105837E-14,
1.63999022695371E-13,
6.42610964440848E-14,
  0,
  0,
-1.12600900825655E-14,
  0,
0.822302312523379,
  0,
0.450805000959554,
  0,
0.361258750123492,
  0,
0.318664009767438,
1.23486290637409E-14,
0.294626917013928,
2.37379560452666E-14,
0.281015257397317,
3.49867704252382E-14,
0.274882923781057,
4.67785532531906E-14,
0.275455925258226,
5.48484868634347E-14,
0.28355264563295,
6.22045817633143E-14,
0.30226153564662,
6.89014817423228E-14,
0.340183093211855,
7.96949312098505E-14,
0.42736188335606,
8.73832256553797E-14,
0.808475296787326,
1.01632244287053E-13,
5.8116705892175E-14,
1.10491477078867E-13,
6.45056924541976E-14,
1.20453994001402E-13,
7.16059156413706E-14,
1.31023664140528E-13,
8.22449747195364E-14,
1.54622842307717E-13,
9.13782938205543E-14,
1.6482301634646E-13,
9.04415431435268E-14,
1.68521446797243E-13,
8.94718327204558E-14,
1.70675973354406E-13,
8.53761505936745E-14,
1.735504101541E-13,
7.51378126384594E-14,
1.63605240466325E-13,
6.62490895475543E-14,
1.65485680714283E-13,
  0,
  0,
  0,
0.828189580500137,
  0,
0.458880237300692,
  0,
0.36722868407724,
1.01177746736347E-14,
0.322270339139647,
1.12696310616833E-14,
0.29585802419157,
2.37448949391705E-14,
0.279717424655282,
3.65592972562112E-14,
0.270629557597826,
4.50420950537378E-14,
0.267369572640479,
5.46429221315314E-14,
0.269905585321782,
6.16902362526872E-14,
0.27942427027263,
6.40668074147754E-14,
0.299218549705503,
7.77208158941889E-14,
0.338017617087195,
8.4821039081362E-14,
0.42597178905309,
9.89746479218567E-14,
0.807997194422627,
1.12547124397899E-13,
6.3353836066149E-14,
1.20873797082588E-13,
6.60565352417208E-14,
1.28352189987524E-13,
7.51603640436471E-14,
1.4719649110706E-13,
8.75445549386455E-14,
1.63912286521573E-13,
9.50142742262017E-14,
1.72624067817928E-13,
9.67403240847986E-14,
1.76475153934597E-13,
8.90624379801253E-14,
1.79471021377609E-13,
8.34141783423448E-14,
1.70429642620817E-13,
6.67764454842512E-14,
1.64864649709884E-13,
6.07517508521838E-14,
  0,
  0,
0.839401691844484,
1.05124242644195E-14,
0.472715661298871,
  0,
0.377271366210101,
1.02860428508045E-14,
0.328980599731439,
1.25264382200285E-14,
0.299746753126025,
2.24820162486594E-14,
0.281015257397317,
3.65523583623073E-14,
0.26928078000423,
4.65053343057242E-14,
0.262992738815516,
5.31727439856411E-14,
0.261644959342123,
6.1404874240889E-14,
0.265561344040425,
6.32462832106384E-14,
0.27612412376483,
7.29069582483532E-14,
0.296744327457143,
8.29718238559707E-14,
0.336232016369999,
9.56231621662695E-14,
0.42481190648177,
1.09605033382643E-13,
0.80759389927531,
1.22367393995404E-13,
6.49619247283795E-14,
1.28628011020204E-13,
6.956241138667E-14,
1.44294298731751E-13,
8.03090233203463E-14,
1.5628991156813E-13,
9.10625741479265E-14,
1.71467007259452E-13,
1.01219380099771E-13,
1.80376547032068E-13,
9.62372542767653E-14,
1.85138362973625E-13,
8.69252586577218E-14,
1.76180250943681E-13,
7.49626055673858E-14,
1.71453129471644E-13,
6.11542066986104E-14,
1.67192648614645E-13,
  0,
0.866448577718204,
1.10363107541644E-14,
0.498765704069467,
1.33361204024407E-14,
0.394292909086673,
1.02010414004816E-14,
0.340210246534238,
1.24301610671118E-14,
0.306964860840936,
2.37318845131007E-14,
0.285110984907833,
3.50145260008539E-14,
0.270629557597826,
4.65053343057242E-14,
0.261603977555733,
5.46359832376275E-14,
0.257169281683215,
5.96276500397508E-14,
0.257159105426093,
6.30225038822374E-14,
0.262083744288899,
7.22148035814385E-14,
0.273436543181386,
7.79602077338737E-14,
0.294700645700197,
9.37704774939263E-14,
0.334739501928254,
1.06263955967911E-13,
0.423832498782926,
1.19560611411273E-13,
0.807250119446026,
1.30215283000723E-13,
6.84070855516694E-14,
1.44327258477794E-13,
7.46416817243301E-14,
1.53209042674796E-13,
8.37784702722999E-14,
1.63683303022744E-13,
9.71184938025615E-14,
1.7906509608423E-13,
1.00591410201467E-13,
1.88793425337508E-13,
9.40063998866592E-14,
1.8157003678354E-13,
7.84129705611036E-14,
1.77005979318245E-13,
6.92484264375182E-14,
1.73574696282763E-13,
6.38464975333264E-14,
0.999999999999996,
1.15033850500712E-14,
0.560562663483811,
1.369000399154E-14,
0.425801297881376,
1.43956027653935E-14,
0.359094015133419,
1.26773591624385E-14,
0.31899695057376,
2.36251990193281E-14,
0.292698824003426,
3.64040395051113E-14,
0.274882923781057,
4.50420950537378E-14,
0.262992738815516,
5.46637388132432E-14,
0.255748457320785,
6.11342573786366E-14,
0.252602880835114,
6.1329413769684E-14,
0.253564665193103,
7.18609199923392E-14,
0.25924830230579,
7.70477431855099E-14,
0.271213657007672,
8.86773293684584E-14,
0.292989933911384,
1.04366168485193E-13,
0.333477333262964,
1.16219533996542E-13,
0.422996888294401,
1.2713788355434E-13,
0.806954369254954,
1.45891979053125E-13,
7.3371864139915E-14,
1.53191695440036E-13,
7.80469439076725E-14,
1.60505289614754E-13,
8.97910218400355E-14,
1.71147818139872E-13,
9.64679724990702E-14,
1.87303297871644E-13,
9.82998404897018E-14,
1.85150506037957E-13,
8.53501297415349E-14,
1.82288212302595E-13,
7.25756260644417E-14,
1.78976625186955E-13,
7.18192866289158E-14,
1.7862100687438E-13,
  0,
0.866400225443959,
1.47785429727154E-14,
0.498456516645347,
1.56255217098611E-14,
0.393637862174603,
1.67591635014119E-14,
0.339112157727228,
2.41811778933787E-14,
0.305308761676111,
3.64560812093906E-14,
0.28275083898052,
4.68357991278978E-14,
0.267369572640479,
5.32004995612567E-14,
0.257169281683215,
6.11542066986104E-14,
0.251155892430624,
6.28525009815917E-14,
0.248941826829423,
7.01817076675937E-14,
0.250631567003075,
7.68586583266284E-14,
0.256900773001076,
8.78169065243739E-14,
0.2693508172564,
9.91619980572622E-14,
0.291541450490725,
1.14117049143658E-13,
0.332399095494798,
1.23876603419504E-13,
0.422277473882041,
1.4271223092166E-13,
0.806697866522624,
1.5494029670382E-13,
7.67337582363581E-14,
1.60357838119296E-13,
8.40317398997925E-14,
1.67822353236424E-13,
8.89861101471823E-14,
1.79261119837015E-13,
9.41312999769295E-14,
1.83502518735779E-13,
8.96175494924378E-14,
1.85631024440802E-13,
7.95179894153009E-14,
1.84120080293226E-13,
7.5172507107979E-14,
1.83819973131882E-13,
6.04932770542632E-14,
  0,
1.49403059368503E-14,
0.839212243709222,
1.62135929682172E-14,
0.471850148753609,
1.7877192781679E-14,
0.375597960670688,
2.85301296476526E-14,
0.326296470041122,
3.65220007014777E-14,
0.295794814566557,
4.66840108237498E-14,
0.275455925258226,
5.46290443437236E-14,
0.261644959342123,
5.96328542101787E-14,
0.252602880835114,
6.29236246441067E-14,
0.247473175301724,
7.15556086605673E-14,
0.245952941653093,
7.51794460018829E-14,
0.248201501254826,
8.76729244758678E-14,
0.254931795392591,
9.85895393101899E-14,
0.267771981528827,
1.09219924770976E-13,
0.290302727593518,
1.21536461450411E-13,
0.331469762969296,
1.39428399381636E-13,
0.421653115923148,
1.50967779943834E-13,
0.806473790361038,
1.61676227961038E-13,
8.2645695842487E-14,
1.67494490499465E-13,
8.31505003739963E-14,
1.75914838251856E-13,
8.66320903902817E-14,
1.7534411422826E-13,
8.53501297415349E-14,
1.83951812116057E-13,
8.37160202271647E-14,
1.87384829875015E-13,
8.20402773493711E-14,
1.88848936488739E-13,
6.37025154848203E-14,
1.83089654548496E-13,
  0,
  0,
1.74066490388203E-14,
0.827761101976404,
1.92077256877532E-14,
0.457187989999148,
2.91268745233886E-14,
0.364126230020177,
4.10279449303275E-14,
0.317429846133262,
4.7049170115443E-14,
0.288836157532161,
5.47660874983258E-14,
0.269905585321782,
6.14655895625482E-14,
0.257159105426093,
6.12686984480248E-14,
0.248941826829423,
7.15000975093361E-14,
0.244466130241101,
7.64700802680096E-14,
0.243475646527323,
8.61168775179166E-14,
0.246162084124298,
9.78141179164282E-14,
0.253261772633364,
1.08191233749722E-13,
0.26642063989064,
1.16415557749328E-13,
0.289234083188496,
1.36999786515268E-13,
0.330662444551266,
1.47843542963599E-13,
0.421107371740543,
1.58461785360053E-13,
0.806276769408064,
1.68962066560141E-13,
8.16707812489881E-14,
1.75574832450565E-13,
8.07357652954366E-14,
1.7176537969732E-13,
7.78752062835508E-14,
1.75668507518267E-13,
7.94121712832663E-14,
1.85570309119143E-13,
8.61758581160998E-14,
1.91954091510738E-13,
7.05911024079242E-14,
1.87955553898611E-13,
5.23817100805957E-14,
  0,
1.20003833259386E-14,
  0,
2.0273279582872E-14,
0.821525524653432,
3.11495620963775E-14,
0.447974316949199,
4.22682722156509E-14,
0.356239458942884,
5.14770517878738E-14,
0.31096787127609,
5.53107906697825E-14,
0.28355264563295,
6.1633857739718E-14,
0.265561344040425,
6.29635232840542E-14,
0.253564665193103,
7.01817076675937E-14,
0.245952941653093,
7.64700802680096E-14,
0.241973448151382,
8.72565908416334E-14,
0.241395863745195,
9.64697072225462E-14,
0.244431427605317,
1.07715919517304E-13,
0.251831467984415,
1.15888201812631E-13,
0.265253979303917,
1.32107866313014E-13,
0.288304991078933,
1.45614423296969E-13,
0.329956179316327,
1.54661006224188E-13,
0.420627276153743,
1.65397209817009E-13,
0.806102521371949,
1.77044143234717E-13,
7.9280332299092E-14,
1.71498232282019E-13,
7.19094922496666E-14,
1.71950995109249E-13,
7.18244907993437E-14,
1.77184655836271E-13,
8.18425188731098E-14,
1.89997323429836E-13,
7.4719744280749E-14,
1.90972238023335E-13,
5.91592747012371E-14,
1.82969958628654E-13,
  0,
  0,
1.55895261977346E-14,
  0,
3.25824436875344E-14,
0.817639366337327,
4.44609626892856E-14,
0.441693461741773,
5.27182464349352E-14,
0.350519313226927,
5.99902072462299E-14,
0.306075469625288,
6.22080512102663E-14,
0.27942427027263,
6.32532221045423E-14,
0.262083744288899,
7.18643894392912E-14,
0.250631567003075,
7.51638334905991E-14,
0.243475646527323,
8.7358939526716E-14,
0.239880505171227,
9.76285025044987E-14,
0.23963041727539,
1.06172015623685E-13,
0.24294852962592,
1.15093698460633E-13,
0.250595945064796,
1.31134686442991E-13,
0.264239014493212,
1.4044841678551E-13,
0.287491615350007,
1.5276321874147E-13,
0.329334408206986,
1.61749086347029E-13,
0.420202480840614,
1.73267650227515E-13,
0.805947594310598,
1.72414166277335E-13,
7.03465063978115E-14,
1.71567621221058E-13,
6.59264309810226E-14,
1.73432448957733E-13,
7.41611633214845E-14,
1.81575240953968E-13,
7.02563007770607E-14,
1.88944346279918E-13,
6.32948554679658E-14,
1.85884294068295E-13,
5.39152056333592E-14,
  0,
1.11343226305571E-14,
  0,
2.82369613802125E-14,
2.05443301259933E-14,
4.5775883084076E-14,
0.815005908958123,
5.52275239429356E-14,
0.43716674820195,
6.11750233803221E-14,
0.346204941044028,
6.68605795728361E-14,
0.30226153564662,
6.40928282669151E-14,
0.27612412376483,
7.22703147326698E-14,
0.25924830230579,
7.68100860693011E-14,
0.248201501254826,
8.61255511352965E-14,
0.241395863745195,
9.76215636105948E-14,
0.238103709315708,
1.07396730397724E-13,
0.238117309817904,
1.13473466734071E-13,
0.241667073894999,
1.30473756798644E-13,
0.249520543193177,
1.39607075899661E-13,
0.263349954266853,
1.4731271757995E-13,
0.286775096459986,
1.59370780461465E-13,
0.328783892220746,
1.696004447993E-13,
0.419824635485032,
1.68963801283617E-13,
0.805809177771613,
1.72702130374347E-13,
6.45351827532892E-14,
1.7292070553232E-13,
6.83671869117219E-14,
1.77734563178156E-13,
6.26720897400901E-14,
1.80392159543352E-13,
5.88869231155087E-14,
1.83776605044983E-13,
5.79848669080008E-14,
1.87129825524046E-13,
  0,
  0,
2.45172805668492E-14,
2.02260083681516E-14,
4.21806686801141E-14,
2.9921377875386E-14,
5.67879077095768E-14,
0.813116311495751,
6.36227182049254E-14,
0.433769055520558,
6.87202031390832E-14,
0.342851811991283,
6.89309720414144E-14,
0.299218549705503,
7.28635901614538E-14,
0.273436543181386,
7.71327446358328E-14,
0.256900773001076,
8.76139438776846E-14,
0.246162084124298,
9.65009322451138E-14,
0.23963041727539,
1.07481731848047E-13,
0.236580741439546,
1.14736345424582E-13,
0.236809445204497,
1.28704338853147E-13,
0.24055130725287,
1.39071046345585E-13,
0.248578133556478,
1.46228515407465E-13,
0.262566367139688,
1.53980994621605E-13,
0.286140335239303,
1.6712152495213E-13,
0.328293932467625,
1.65414557051768E-13,
0.419486935291517,
1.68661959398797E-13,
0.805684962820754,
1.73935518765767E-13,
6.68770594458579E-14,
1.77144757196324E-13,
5.67931118800047E-14,
1.76587910960535E-13,
5.12125064577873E-14,
1.75160233539806E-13,
5.36393846006789E-14,
1.8489029751656E-13,
5.48519563103866E-14,
  0,
2.20539732309621E-14,
2.34430530543506E-14,
3.89965837399586E-14,
2.991964315191E-14,
5.36064248546353E-14,
3.40664996212325E-14,
6.56870391413378E-14,
0.811702809668153,
7.11366729411189E-14,
0.431138463130618,
7.0304873034388E-14,
0.340183093211855,
7.76254061030102E-14,
0.296744327457143,
7.79567382869217E-14,
0.271213657007671,
8.78169065243739E-14,
0.254931795392591,
9.78748332380874E-14,
0.244431427605317,
1.06168546176733E-13,
0.238117309817904,
1.14774509341053E-13,
0.235264252861981,
1.30203139936391E-13,
0.235670451487046,
1.37325914528752E-13,
0.23957322606088,
1.45796569261947E-13,
0.247747205375233,
1.53174348205276E-13,
0.26187187753487,
1.61964192058051E-13,
0.28557511434471,
1.62802063496947E-13,
0.327855798543592,
1.65145674912992E-13,
0.419183785135207,
1.69709732378287E-13,
0.80557303686987,
1.78254980220949E-13,
5.5200635729058E-14,
1.75989431361323E-13,
4.53179160864181E-14,
1.71246697378002E-13,
4.58764970456826E-14,
1.76265252394003E-13,
5.03867780832223E-14,
1.94472909997856E-13,
1.85825747150981E-14,
2.62016970620227E-14,
3.78195738615084E-14,
3.36787889243517E-14,
5.10208195136919E-14,
3.40422134925689E-14,
6.26564772288063E-14,
4.01874714062167E-14,
7.33293634147536E-14,
0.810611352333152,
7.33415064790854E-14,
0.429051245736874,
7.96324811647153E-14,
0.338017617087195,
8.29752933029226E-14,
0.294700645700197,
8.86218182172271E-14,
0.2693508172564,
9.85340281589586E-14,
0.253261772633364,
1.07771430668535E-13,
0.24294852962592,
1.1341795558284E-13,
0.236809445204497,
1.30203139936391E-13,
0.234117671063085,
1.38701550245202E-13,
0.234671828551628,
1.44047967998162E-13,
0.238710611787784,
1.52617501969488E-13,
0.247010503848587,
1.60893867673373E-13,
0.261253222270858,
1.57760957075759E-13,
0.285069453125901,
1.62859309371655E-13,
0.327462303336001,
1.66588964845005E-13,
0.418910546872236,
1.74396955210376E-13,
0.805471803660704,
1.76754444414229E-13,
4.37150315946155E-14,
1.70688116418738E-13,
3.99819066743134E-14,
1.72348246785248E-13,
4.27036878081211E-14,
1.85658780016418E-13,
4.63691585128601E-14,
2.0384518725769E-14,
3.84553500154539E-14,
3.7767965838098E-14,
5.07545394601294E-14,
3.82801429443802E-14,
6.0586084760228E-14,
4.0536150824888E-14,
7.02944646935322E-14,
3.85863216378901E-14,
7.54561343963012E-14,
0.809747199266645,
8.23646706393788E-14,
0.42736188335606,
8.4821039081362E-14,
0.336232016369999,
9.37843552817341E-14,
0.292989933911384,
9.90926091182232E-14,
0.267771981528827,
1.08260622688761E-13,
0.251831467984415,
1.15038187309402E-13,
0.241667073894999,
1.28702604129671E-13,
0.235670451487046,
1.38760530843385E-13,
0.23311233484811,
1.45387174521616E-13,
0.233790955509665,
1.51101353651484E-13,
0.237945631708672,
1.60496615997374E-13,
0.246354043299691,
1.5675134801274E-13,
0.260699556690348,
1.57597893069017E-13,
0.284615126913016,
1.6408575886917E-13,
0.327107482486503,
1.70625666373603E-13,
0.418663346855991,
1.73082034815586E-13,
0.80537992169052,
1.71633540713145E-13,
3.84102472050785E-14,
1.71631805989669E-13,
3.66980751342894E-14,
1.81740039684186E-13,
3.86357612569554E-14,
1.88970367132058E-13,
2.58473797920544E-14,
3.63710797590677E-14,
5.33965233140421E-14,
4.32154312335342E-14,
6.09954795005585E-14,
4.50707179910914E-14,
6.86872433930397E-14,
3.90963303398273E-14,
7.29399179943968E-14,
4.10210060364236E-14,
8.50847170497104E-14,
0.80904898875008,
8.74040423370914E-14,
0.42597178905309,
9.56509177418852E-14,
0.334739501928254,
1.0439739350776E-13,
0.291541450490725,
1.092181900475E-13,
0.26642063989064,
1.15862180960491E-13,
0.250595945064796,
1.30473756798644E-13,
0.24055130725287,
1.37377956233031E-13,
0.234671828551628,
1.45333398093861E-13,
0.232225492671819,
1.5230178229686E-13,
0.2330096705747,
1.58661278559791E-13,
0.237263824230623,
1.56074805857109E-13,
0.245766380631191,
1.56570936771239E-13,
0.260201936927323,
1.58519031234761E-13,
0.284205304046915,
1.68155420143812E-13,
0.326786349790277,
1.69440850239511E-13,
0.418438927651403,
1.678674560468E-13,
0.805296256331841,
1.72568556666697E-13,
3.51628448580499E-14,
1.81091253104171E-13,
3.25885152197003E-14,
1.84886828069608E-13,
3.19778925561565E-14,
2.15671664555162E-14,
4.64875533900955E-14,
4.35827589295723E-14,
6.48803927250086E-14,
5.05437705577982E-14,
6.955807457798E-14,
4.38451358553138E-14,
7.15408635110215E-14,
4.16741294251288E-14,
8.25268672843826E-14,
4.12950923456279E-14,
9.03773583749157E-14,
0.808475296787326,
9.89677090279528E-14,
0.42481190648177,
1.06265690691387E-13,
0.333477333262964,
1.14132661654942E-13,
0.290302727593518,
1.16335760469433E-13,
0.265253979303917,
1.31164176742082E-13,
0.249520543193177,
1.39043290769969E-13,
0.23957322606088,
1.44008069358215E-13,
0.233790955509665,
1.52289639232528E-13,
0.231438875809966,
1.5993803503811E-13,
0.232313240795333,
1.54272428165569E-13,
0.236653351300926,
1.5603143777021E-13,
0.245238072664091,
1.5753197357693E-13,
0.259752928496162,
1.62710123152721E-13,
0.283834268492636,
1.66869990048113E-13,
0.326494708453792,
1.63681568299268E-13,
0.41823453261066,
1.68639407993609E-13,
0.805219842241568,
1.82045351015958E-13,
3.1186858651111E-14,
1.84092324717611E-13,
2.58890131554779E-14,
1.88047494242838E-13,
2.78113036072947E-14,
3.35434804932255E-14,
6.03718464109448E-14,
5.19488965733395E-14,
7.42080008553359E-14,
4.96451837972423E-14,
7.28956825457594E-14,
4.667100039768E-14,
8.13498574059324E-14,
4.1962093522141E-14,
8.81343609204777E-14,
5.02063668417208E-14,
1.01569794241918E-13,
0.807997194422627,
1.09613707000022E-13,
0.423832498782926,
1.16164022845311E-13,
0.332399095494798,
1.21536461450411E-13,
0.289234083188496,
1.32128682994725E-13,
0.264239014493212,
1.39608810623137E-13,
0.248578133556478,
1.45801773432375E-13,
0.238710611787784,
1.51045842500253E-13,
0.2330096705747,
1.60000485083245E-13,
0.230737663064541,
1.55597756901216E-13,
0.23168960263897,
1.54026097431981E-13,
0.236104439635747,
1.57060128791464E-13,
0.244761265498605,
1.6186531281992E-13,
0.259346306826651,
1.61298058243275E-13,
0.283497205511037,
1.61318874924987E-13,
0.326229003960681,
1.65010366481866E-13,
0.418047815168682,
1.78083242596827E-13,
0.805149853585407,
1.84723764062866E-13,
2.43381703679546E-14,
1.87183601951801E-13,
1.2191636589165E-14,
1.71655224756595E-14,
4.80110742828721E-14,
4.3682071848572E-14,
7.11817757514943E-14,
5.17372603092703E-14,
7.81224043788775E-14,
5.27859006504983E-14,
8.29197821516914E-14,
4.69988631346396E-14,
8.71898039878083E-14,
5.11760772647918E-14,
9.9550576115881E-14,
5.80820114226555E-14,
1.12488143799716E-13,
0.807593899275311,
1.19564080858225E-13,
0.422996888294401,
1.23932114570735E-13,
0.331469762969296,
1.36998051791792E-13,
0.288304991078933,
1.40444947338558E-13,
0.263349954266853,
1.46256270983081E-13,
0.247747205375233,
1.52669543673767E-13,
0.237945631708672,
1.58647400771983E-13,
0.232313240795333,
1.55649798605495E-13,
0.230109717530408,
1.55361834508483E-13,
0.231128794150346,
1.55184892713933E-13,
0.235608957617696,
1.61079483085302E-13,
0.244329380067895,
1.60288449180257E-13,
0.258976825631798,
1.55915211297319E-13,
0.283190034372724,
1.62009294868426E-13,
0.325986208290343,
1.73916436807531E-13,
0.417876766934779,
1.81289011580432E-13,
0.805085580258257,
1.87853205213528E-13,
1.05158937113714E-14,
1.85587656353903E-13,
2.75907768854111E-14,
3.14297199377478E-14,
6.13641082392036E-14,
4.4506065499661E-14,
7.60034396529718E-14,
5.52101767081759E-14,
8.87016154971221E-14,
5.34424934861555E-14,
8.915524568609E-14,
5.64374935674294E-14,
9.88636256193942E-14,
5.90083537588271E-14,
1.10555661847478E-13,
6.3350366619197E-14,
1.22363924548452E-13,
0.807250119446026,
1.27124005766532E-13,
0.422277473882041,
1.39489114703295E-13,
0.330662444551266,
1.456699344482E-13,
0.287491615350007,
1.47258941152195E-13,
0.262566367139688,
1.53188225993084E-13,
0.247010503848587,
1.6038212424796E-13,
0.237263824230623,
1.54227325355194E-13,
0.23168960263897,
1.55361834508483E-13,
0.229545015822775,
1.56496343661772E-13,
0.230622524818547,
1.59382923525797E-13,
0.23516009111287,
1.59703847368853E-13,
0.243936868725146,
1.54445900513167E-13,
0.258640035939723,
1.56433893616637E-13,
0.282909276569151,
1.71220676525863E-13,
0.325763728013762,
1.7693485565573E-13,
0.417719660219168,
1.83981302415148E-13,
0.805026408747682,
1.86128890078407E-13,
  0,
1.9110364332664E-14,
4.72209077395647E-14,
3.38531286336874E-14,
6.75891634327463E-14,
4.86537893307215E-14,
8.72557234798954E-14,
5.6170346152129E-14,
9.52692785771703E-14,
6.29375024319145E-14,
1.01014682729605E-13,
6.42628311675608E-14,
1.09870446074467E-13,
6.44952841133417E-14,
1.20873797082588E-13,
6.49775372396633E-14,
1.30260385811098E-13,
0.806954369254954,
1.4267753645214E-13,
0.421653115923148,
1.47732520661137E-13,
0.329956179316327,
1.52818729892701E-13,
0.286775096459986,
1.53980994621605E-13,
0.26187187753487,
1.60921623248989E-13,
0.246354043299691,
1.56133786455293E-13,
0.236653351300926,
1.53998341856365E-13,
0.231128794150346,
1.56461649192252E-13,
0.229035215670058,
1.60583352171173E-13,
0.230163845891822,
1.5779044737485E-13,
0.234752092382459,
1.5406946551888E-13,
0.243579024931996,
1.55490204045705E-13,
0.258332143397617,
1.65686908637497E-13,
0.282651951092274,
1.74277259290534E-13,
0.325559330752888,
1.79991438420402E-13,
0.417575001747649,
1.8236800958249E-13,
0.804971806624052,
1.92634103113321E-13,
2.69385208584438E-14,
2.56257688679984E-14,
5.59335563976582E-14,
3.88690815644743E-14,
7.98154944914309E-14,
5.0034629217599E-14,
9.43238542827629E-14,
6.59802074087779E-14,
1.07456578357645E-13,
7.09640679552592E-14,
1.12273038088695E-13,
6.99128255288173E-14,
1.20426238425786E-13,
6.60565352417208E-14,
1.28657501319296E-13,
6.83533091239141E-14,
1.45905856840933E-13,
0.806697866522625,
1.50966045220358E-13,
0.421107371740544,
1.54761620185795E-13,
0.329334408206986,
1.59358637397133E-13,
0.286140335239303,
1.61960722611099E-13,
0.261253222270858,
1.56766960524024E-13,
0.245766380631191,
1.56012355811974E-13,
0.236104439635747,
1.55191831607837E-13,
0.230622524818548,
1.60600699405933E-13,
0.228573324447342,
1.59008223254986E-13,
0.229746894944706,
1.52225454463917E-13,
0.234380083669896,
1.54702639587612E-13,
0.243251833093096,
1.64798730217797E-13,
0.258049894790041,
1.68760838636928E-13,
0.282415490557247,
1.77292208691782E-13,
0.3253710858924,
1.78326103883464E-13,
0.417441495122662,
1.88116883181877E-13,
0.804921309886243,
1.04755613905549E-14,
4.16450728069062E-14,
3.20602919212654E-14,
6.95485335988622E-14,
4.08076350488784E-14,
8.75991987281388E-14,
6.01445976355919E-14,
1.06966518975682E-13,
7.42123376640258E-14,
1.18984683217249E-13,
7.67996777284452E-14,
1.23009241681515E-13,
7.15920378535628E-14,
1.2834525109362E-13,
6.95363905345303E-14,
1.44299502902179E-13,
7.3371864139915E-14,
1.5494029670382E-13,
0.806473790361038,
1.58465254807005E-13,
0.420627276153743,
1.61750821070505E-13,
0.328783892220746,
1.67093769376514E-13,
0.28557511434471,
1.57762691799235E-13,
0.260699556690348,
1.56543181195623E-13,
0.24523807266409,
1.57028903768897E-13,
0.235608957617696,
1.59389862419701E-13,
0.230163845891822,
1.59035978830602E-13,
0.228153442335831,
1.53559456816943E-13,
0.22936669600657,
1.53078938414097E-13,
0.23403990214778,
1.6398687963104E-13,
0.242951849058977,
1.67813679619044E-13,
0.257790487073854,
1.71869463105878E-13,
0.282197673519938,
1.75557485215805E-13,
0.325197316447207,
1.84574577843932E-13,
0.417318010176597,
1.92561244727329E-13,
2.11861778121047E-14,
1.95325526586299E-14,
5.76301159571635E-14,
3.47716647142171E-14,
7.83227649403528E-14,
5.13417433567476E-14,
1.00807383274226E-13,
6.87028559043235E-14,
1.18882334532167E-13,
8.01997357413597E-14,
1.30019259247938E-13,
7.86194026547449E-14,
1.31061828057E-13,
7.51256695741276E-14,
1.44254400091803E-13,
7.46416817243301E-14,
1.53184756546132E-13,
7.67927388345413E-14,
1.61667554343659E-13,
0.806276769408064,
1.65424965392624E-13,
0.420202480840614,
1.696004447993E-13,
0.328293932467625,
1.62805532943899E-13,
0.285069453125901,
1.57653404220248E-13,
0.260201936927323,
1.57580545834257E-13,
0.244761265498605,
1.6112805534263E-13,
0.23516009111287,
1.57755752905331E-13,
0.229746894944706,
1.53559456816943E-13,
0.227770561329938,
1.54310592082041E-13,
0.229019001734116,
1.62377056245333E-13,
0.233727976477001,
1.669359095402E-13,
0.242676104283054,
1.70606584415367E-13,
0.257551493923806,
1.70120861842094E-13,
0.28199656948378,
1.81736570237234E-13,
0.325036559731021,
1.88432602854505E-13,
0.417203557797195,
1.20843005740889E-14,
4.22838847269347E-14,
2.34161648404729E-14,
6.776437050382E-14,
4.58392004909491E-14,
9.21736645342897E-14,
6.0208782404203E-14,
1.13172492210989E-13,
7.49660750143377E-14,
1.30222221894627E-13,
8.21478302048817E-14,
1.38325115250915E-13,
8.2276199742104E-14,
1.47217307788772E-13,
8.02916760855865E-14,
1.53242002420839E-13,
7.80452091841966E-14,
1.60340490884536E-13,
8.27185542284781E-14,
1.68989822135757E-13,
0.806102521371949,
1.73253772439708E-13,
0.419824635485032,
1.65636601656693E-13,
0.327855798543592,
1.62873187159462E-13,
0.284615126913016,
1.58519031234761E-13,
0.259752928496162,
1.61842761414732E-13,
0.244329380067895,
1.5973507239142E-13,
0.234752092382459,
1.52230658634345E-13,
0.22936669600657,
1.54282836506425E-13,
0.227420406509542,
1.63570545996805E-13,
0.228700167729037,
1.65145674912992E-13,
0.233441227760112,
1.70103514607334E-13,
0.242422028386155,
1.68795533106447E-13,
0.25733080600978,
1.76220149583628E-13,
0.281810493927286,
1.85816639852732E-13,
0.324887535020034,
1.80310627539981E-13,
2.76619005479262E-14,
1.85866946833535E-14,
5.47756284774437E-14,
3.52010087745214E-14,
8.25936541382077E-14,
5.51104301083072E-14,
1.0517801907195E-13,
6.67590982494914E-14,
1.24936519463326E-13,
7.70772334846015E-14,
1.38750122502529E-13,
8.60041204919781E-14,
1.54610699243385E-13,
8.75757799612131E-14,
1.56326340761126E-13,
8.37507146966843E-14,
1.60484472933042E-13,
8.40317398997925E-14,
1.6752224607508E-13,
8.15875145221412E-14,
1.77045877958193E-13,
0.805947594310598,
1.68965536007093E-13,
0.419486935291517,
1.6515087908342E-13,
0.327462303336001,
1.64099636656978E-13,
0.284205304046915,
1.62651142554537E-13,
0.259346306826651,
1.60225999135122E-13,
0.243936868725146,
1.54041709943264E-13,
0.234380083669896,
1.53078938414097E-13,
0.229019001734116,
1.63574015443757E-13,
0.227099309629905,
1.6647447309559E-13,
0.22840705166847,
1.67959396391026E-13,
0.233176989486996,
1.68174502102048E-13,
0.242187386164976,
1.75245234990129E-13,
0.257126582126182,
1.80227360813134E-13,
0.281637971303208,
1.77333842055205E-13,
0.324749116814724,
  0,
4.6225610145223E-14,
3.14262504907958E-14,
7.10490694055821E-14,
4.50065332224803E-14,
9.64228696886948E-14,
6.19929454992452E-14,
1.17463330728818E-13,
6.92085277975707E-14,
1.33849528682894E-13,
8.11798545052866E-14,
1.55327140038963E-13,
9.13852327144582E-14,
1.63888000392909E-13,
9.10868602765902E-14,
1.63683303022744E-13,
8.97771440522277E-14,
1.67862251876372E-13,
8.31782559496119E-14,
1.75519321299333E-13,
7.92612503408563E-14,
1.72431513512095E-13,
0.805809177771613,
1.6876430808388E-13,
0.419183785135208,
1.6652651479987E-13,
0.327107482486503,
1.68096439545629E-13,
0.283834268492636,
1.61291119349372E-13,
0.258976825631798,
1.54459778300975E-13,
0.243579024931996,
1.54754681291891E-13,
0.23403990214778,
1.62377056245333E-13,
0.228700167729037,
1.66467534201686E-13,
0.226804107659914,
1.69302072361432E-13,
0.228136931758868,
1.66311409088848E-13,
0.232932942389792,
1.74433384403372E-13,
0.241970226022279,
1.79127546129365E-13,
0.256937208960613,
1.71689051864377E-13,
0.281477704422727,
1.66998359585335E-13,
2.57059998287623E-14,
2.47189421709315E-14,
6.4994884474423E-14,
4.20982693150052E-14,
8.58505974643542E-14,
5.2360026037146E-14,
1.09280640092635E-13,
6.47312065060746E-14,
1.26773591624385E-13,
7.34273752911463E-14,
1.50681550570297E-13,
8.66529070719935E-14,
1.64855976092504E-13,
9.50316214609614E-14,
1.71477415600307E-13,
9.71271674199414E-14,
1.71140879245968E-13,
8.89826407002303E-14,
1.75925246592712E-13,
8.0708009719821E-14,
1.71498232282019E-13,
7.03673230795232E-14,
1.72677844245683E-13,
0.805684962820754,
1.69766978252994E-13,
0.418910546872236,
1.70733219229113E-13,
0.326786349790277,
1.66835295578593E-13,
0.283497205511037,
1.55929089085127E-13,
0.258640035939722,
1.55490204045705E-13,
0.243251833093096,
1.64042390782271E-13,
0.233727976477001,
1.65201186064223E-13,
0.22840705166847,
1.6919105005897E-13,
0.226532060751059,
1.67536123862888E-13,
0.227887440362976,
1.72497433004182E-13,
0.232707061092318,
1.78291409413944E-13,
0.241768837494764,
1.70759240081253E-13,
0.256761267787026,
1.61488877825633E-13,
0.281328548987096,
1.91591534304258E-14,
5.05897407299116E-14,
3.67796071376603E-14,
8.13880213224039E-14,
4.99860569602717E-14,
9.9549708754143E-14,
5.53671691827518E-14,
1.19121726371851E-13,
6.91564860932914E-14,
1.44009804081691E-13,
7.9131146080158E-14,
1.60513963232134E-13,
9.04432778670028E-14,
1.72648353946592E-13,
1.01191624524155E-13,
1.79051218296422E-13,
9.64540947112624E-14,
1.79281936518727E-13,
8.66459681780896E-14,
1.71793135272935E-13,
7.18852061210029E-14,
1.71564151774106E-13,
6.45351827532892E-14,
1.73890415955391E-13,
0.80557303686987,
1.74407363551232E-13,
0.418663346855991,
1.69444319686463E-13,
0.326494708453792,
1.61402141651834E-13,
0.283190034372724,
1.56461649192252E-13,
0.258332143397617,
1.64767505195229E-13,
0.242951849058977,
1.66942848434104E-13,
0.233441227760112,
1.67973274178834E-13,
0.228136931758868,
1.67671432294014E-13,
0.226280785465085,
1.73829700633732E-13,
0.227656509632929,
1.76532399809304E-13,
0.232497570157676,
1.70134739629901E-13,
0.241581716076572,
1.60253754710737E-13,
0.256597506744747,
1.53904666788662E-13,
3.27086448204117E-14,
3.5377516888202E-14,
6.97948643324509E-14,
4.56162885242861E-14,
9.62051618924598E-14,
5.3478055317413E-14,
1.09989274632571E-13,
6.00942906547886E-14,
1.36763864122535E-13,
7.50857709341801E-14,
1.54152732245727E-13,
8.30186613898221E-14,
1.68521446797243E-13,
9.67542018726064E-14,
1.80376547032068E-13,
1.00575797690183E-13,
1.8729635897774E-13,
9.41312999769295E-14,
1.75316358652644E-13,
7.78752062835508E-14,
1.71950995109249E-13,
6.59142879166907E-14,
1.72948461107936E-13,
6.68753247223819E-14,
1.78254980220949E-13,
0.805471803660704,
1.73193057118048E-13,
0.418438927651403,
1.63681568299268E-13,
0.326229003960681,
1.61988478186714E-13,
0.282909276569151,
1.65679969743593E-13,
0.258049894790041,
1.67817149065996E-13,
0.242676104283054,
1.70034125668295E-13,
0.233176989486996,
1.66318347982752E-13,
0.227887440362976,
1.73812353398972E-13,
0.226048200076418,
1.77656500621737E-13,
0.227442326712288,
1.68011438095306E-13,
0.232302907675176,
1.59466190252644E-13,
0.241407533930874,
1.52593215840824E-13,
0.256444817650713,
2.16823087262341E-14,
5.92772358976035E-14,
4.60265506263546E-14,
8.63285137819858E-14,
4.96790109050238E-14,
1.0754938606361E-13,
5.85130902064357E-14,
1.2822035100335E-13,
6.6191843672847E-14,
1.47331799538186E-13,
7.91190030158262E-14,
1.62458588248704E-13,
8.94648938265519E-14,
1.76447398358981E-13,
9.62372542767653E-14,
1.88769139208844E-13,
9.83137182775096E-14,
1.83502518735779E-13,
8.53778853171505E-14,
1.75671976965219E-13,
7.18106130115359E-14,
1.73474082321157E-13,
6.83671869117219E-14,
1.77141287749372E-13,
5.52353301985775E-14,
1.76768322202037E-13,
0.80537992169052,
1.67895211622415E-13,
0.41823453261066,
1.65013835928818E-13,
0.325986208290343,
1.71217207078911E-13,
0.282651951092274,
1.68771246977784E-13,
0.257790487073854,
1.70616992756223E-13,
0.242422028386155,
1.68139807632528E-13,
0.232932942389792,
1.7247661632247E-13,
0.227656509632929,
1.77656500621737E-13,
0.225832479498988,
1.69433911345607E-13,
0.227243296616054,
1.57828611291322E-13,
0.232121694934071,
1.51934020919953E-13,
0.241245115382111,
1.48065587568524E-13,
3.57231605407904E-14,
3.72011449423226E-14,
7.89368570508486E-14,
5.11908224143376E-14,
9.88514825550624E-14,
5.51555329186826E-14,
1.2643965735526E-13,
6.48890663423884E-14,
1.39227171458423E-13,
7.04297731246584E-14,
1.55974191895503E-13,
8.57092175010621E-14,
1.7066556501355E-13,
8.90485601923174E-14,
1.85126219909293E-13,
9.39890526518994E-14,
1.85136628250149E-13,
8.96192842159138E-14,
1.83915382923061E-13,
7.94121712832663E-14,
1.77177716942367E-13,
7.41628980449605E-14,
1.77764053477247E-13,
5.67774993687209E-14,
1.75989431361323E-13,
4.37150315946155E-14,
1.7157109066801E-13,
0.805296256331841,
1.68691449697889E-13,
0.418047815168682,
1.73919906254483E-13,
0.325763728013762,
1.74298075972246E-13,
0.282415490557247,
1.71834768636359E-13,
0.257551493923806,
1.6885451370463E-13,
0.242187386164976,
1.7453746781193E-13,
0.232707061092318,
1.765254609154E-13,
0.227442326712288,
1.69406155769991E-13,
0.225632017936048,
1.58952712103755E-13,
0.227058011310633,
1.49984191732955E-13,
0.231952711040848,
1.47545170525731E-13,
0.241093416311678,
2.12980674763052E-14,
6.34822056033713E-14,
4.42961639590678E-14,
9.33714910944516E-14,
5.73395497749374E-14,
1.18723607334115E-13,
6.18992704315424E-14,
1.3804235532433E-13,
6.93698570808365E-14,
1.48239059916122E-13,
7.71570307644964E-14,
1.64448316075649E-13,
8.53900283814824E-14,
1.7948316444194E-13,
8.69391364455296E-14,
1.81590853465252E-13,
8.53813547641025E-14,
1.8566224946337E-13,
8.37437758027804E-14,
1.85552961884383E-13,
8.18147632974942E-14,
1.81547485378353E-13,
6.26443341644745E-14,
1.76570563725775E-13,
4.53179160864181E-14,
1.70672503907454E-13,
3.83824916294628E-14,
1.72554678878889E-13,
0.805219842241569,
1.78079773149875E-13,
0.417876766934779,
1.77021591829529E-13,
0.325559330752888,
1.77316494820445E-13,
0.282197673519938,
1.70120861842094E-13,
0.25733080600978,
1.75269521118793E-13,
0.241970226022279,
1.78339981671272E-13,
0.232497570157676,
1.68011438095306E-13,
0.227243296616054,
1.5898046767937E-13,
0.225445397766731,
1.51250539870418E-13,
0.226885223830229,
1.45758405345475E-13,
0.231794871574204,
1.52069329351079E-13,
3.75988302991903E-14,
3.31223763694322E-14,
8.12908768077492E-14,
5.15724615790525E-14,
1.14531648054417E-13,
6.45716119462847E-14,
1.31073971121332E-13,
6.66845051400244E-14,
1.47548639972683E-13,
7.6287934303032E-14,
1.57100027431412E-13,
7.70598862498417E-14,
1.73536532366292E-13,
8.34228519597247E-14,
1.76162903708921E-13,
7.84129705611036E-14,
1.82288212302595E-13,
7.95249283092048E-14,
1.87336257617687E-13,
8.61897359039077E-14,
1.89990384535932E-13,
7.02961994170082E-14,
1.80419915118968E-13,
5.1238527309927E-14,
1.71218941802387E-13,
3.99957844621213E-14,
1.71687317140901E-13,
3.51593754110979E-14,
1.82041881569006E-13,
0.805149853585407,
1.8133758383776E-13,
0.417719660219168,
1.79991438420402E-13,
0.3253710858924,
1.75498504617622E-13,
0.28199656948378,
1.76251374606196E-13,
0.257126582126182,
1.79141423917173E-13,
0.241768837494764,
1.70131270182949E-13,
0.232302907675176,
1.57776569587043E-13,
0.227058011310633,
1.51198498166139E-13,
0.225271363499216,
1.46941486756091E-13,
0.226723826507473,
1.50303380852534E-13,
0.231647210555613,
1.69603914246252E-14,
6.38547374698373E-14,
4.22092916174677E-14,
1.04468517170275E-13,
5.95461180363799E-14,
1.27917641756792E-13,
6.97436899899095E-14,
1.41164857581089E-13,
7.38280964140969E-14,
1.56819002228303E-13,
7.62844648560801E-14,
1.66484881436446E-13,
7.5169037661027E-14,
1.70429642620817E-13,
7.49591361204338E-14,
1.77026795999957E-13,
7.26033816400573E-14,
1.84113141399322E-13,
8.20107870502795E-14,
1.9194021372293E-13,
7.46989275990373E-14,
1.88966897685106E-13,
5.8862636986845E-14,
1.75172376604138E-13,
4.58626192578748E-14,
1.72376002360863E-13,
3.66980751342894E-14,
1.81070436422459E-13,
3.11764503102552E-14,
1.84782744661049E-13,
0.805085580258257,
1.83981302415148E-13,
0.417575001747649,
1.78211612134049E-13,
0.325197316447207,
1.81785142494562E-13,
0.281810493927286,
1.8022042191923E-13,
0.256937208960613,
1.70759240081253E-13,
0.241581716076572,
1.59466190252644E-13,
0.232121694934071,
1.50032763990282E-13,
0.226885223830229,
1.46934547862188E-13,
0.225108799863049,
1.51365031619832E-13,
0.226572832583108,
1.47677009509906E-13,
3.61464330689287E-14,
3.00380380291454E-14,
9.06419037050021E-14,
5.12602113533767E-14,
1.19357648764584E-13,
6.52308068671559E-14,
1.38843797570232E-13,
7.72576447261031E-14,
1.50946963262122E-13,
7.40778965946376E-14,
1.66568148163293E-13,
7.45150469105837E-14,
1.63619118254132E-13,
6.67747107607752E-14,
1.71480885047259E-13,
6.92692431192299E-14,
1.78976625186955E-13,
7.51794460018829E-14,
1.88841997594835E-13,
7.0606714919208E-14,
1.90944482447719E-13,
6.32948554679658E-14,
1.83780074491935E-13,
5.36515276650107E-14,
1.76251374606196E-13,
4.27314433837367E-14,
1.81753917471994E-13,
3.26301485831237E-14,
1.84092324717611E-13,
2.43971509661378E-14,
1.8785667466048E-13,
0.805026408747682,
1.82364540135538E-13,
0.417441495122662,
1.84494780564037E-13,
0.325036559731021,
1.85816639852732E-13,
0.281637971303208,
1.71744563015608E-13,
0.256761267787026,
1.60316204755873E-13,
0.241407533930874,
1.5194789870776E-13,
0.231952711040848,
1.45744527557667E-13,
0.226723826507473,
1.51365031619832E-13,
0.224956713301145,
1.48683149125972E-13,
0.226431360604715,
1.77184655836271E-14,
7.14606325502576E-14,
4.08293190923281E-14,
1.07719388964256E-13,
5.76465958301853E-14,
1.31348924792274E-13,
7.31602278758459E-14,
1.49239995361761E-13,
7.77503061932805E-14,
1.61112442831346E-13,
7.24541954211233E-14,
1.64009431036227E-13,
6.6266436782314E-14,
1.64864649709884E-13,
6.11698192098942E-14,
1.73581635176667E-13,
7.17915310533002E-14,
1.83835585643166E-13,
6.37163932726281E-14,
1.87965962239467E-13,
5.91870302768527E-14,
1.85872151003963E-13,
5.80143572070924E-14,
1.84949278114743E-13,
5.03902475301743E-14,
1.85703882826793E-13,
3.86600473856191E-14,
1.84921522539128E-13,
2.58647270268142E-14,
1.87197479739609E-13,
1.05332409461312E-14,
1.86132359525359E-13,
0.804971806624052,
1.88172394333108E-13,
0.417318010176597,
1.88446480642313E-13,
0.324887535020034,
1.77340780949109E-13,
0.281477704422727,
1.61454183356113E-13,
0.256597506744747,
1.52593215840824E-13,
0.241245115382111,
1.47600681676963E-13,
0.231794871574204,
1.5031378919339E-13,
0.226572832583108,
1.48658862997308E-13,
0.224814216268034,
1.46674339340791E-13,
4.6373929002419E-14,
3.25533870693118E-14,
9.23887702453108E-14,
4.82548029312468E-14,
1.21213802883879E-13,
6.61250568190219E-14,
1.4258733083139E-13,
7.40189159964544E-14,
1.59950178102441E-13,
7.63313023899315E-14,
1.58930160698567E-13,
6.42610964440848E-14,
1.65494354331663E-13,
6.07482814052318E-14,
1.67185709720741E-13,
6.38707836619901E-14,
1.7862100687438E-13,
6.04898076073113E-14,
1.83100062889352E-13,
5.23799753571197E-14,
1.82969958628654E-13,
5.39325528681189E-14,
1.87117682459714E-13,
5.48346090756269E-14,
1.94460766933524E-13,
4.63691585128601E-14,
1.8895648934425E-13,
3.1936259192733E-14,
1.88044024795886E-13,
1.21985754830689E-14,
1.85580717459999E-13,
  0,
1.92641042007224E-13,
0.804921309886243,
1.92488386341338E-13,
0.417203557797195,
1.80199605237519E-13,
0.324749116814724,
1.6697060400972E-13,
0.281328548987096,
1.53932422364278E-13,
0.256444817650713,
1.48121098719756E-13,
0.241093416311678,
1.52069329351079E-13,
0.231647210555613,
1.47677009509906E-13,
0.226431360604715,
1.46639644871271E-13,
0.224680513855626,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999999,
  0,
  0,
  0,
  0,
  0,
  0,
1.46172136894496E-14,
1.4395385924959E-14,
2.07201877183705E-14,
1.87014032732025E-14,
2.5991145000126E-14,
1.88662020034203E-14,
2.93777589061017E-14,
2.22803546445771E-14,
2.72911034049361E-14,
1.35913415938438E-14,
2.28194199647369E-14,
  0,
2.12546993894058E-14,
  0,
2.34257058195908E-14,
1.49394385751123E-14,
3.3958079403984E-14,
2.38194880486375E-14,
3.552496838366E-14,
2.20071356971108E-14,
3.87233647924923E-14,
1.64169892957755E-14,
3.48735797184307E-14,
1.53488333154428E-14,
4.5846139384853E-14,
1.79565563807049E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.0320737320324E-14,
  0,
  0,
1.16061674160228E-14,
0.866400225443959,
1.48600749760863E-14,
0.866359712001398,
1.21322223101128E-14,
  0,
1.35464556239029E-14,
  0,
2.06557861093248E-14,
1.96652590045421E-14,
3.06074610101348E-14,
2.86719432918137E-14,
4.04728334180149E-14,
3.25655301336436E-14,
4.79672725151037E-14,
3.56823945391049E-14,
4.90584135814931E-14,
3.10888467747183E-14,
4.3384133091573E-14,
1.959717110811E-14,
3.81591459819308E-14,
1.45630035808253E-14,
3.86865019186278E-14,
1.97216375175113E-14,
4.96681688832989E-14,
3.35716697497102E-14,
6.01441639547229E-14,
3.96978457051222E-14,
6.43144391909711E-14,
3.32446743744885E-14,
6.37489193378027E-14,
2.75127143289922E-14,
6.99210654653282E-14,
2.88311041707345E-14,
8.18451209583237E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.13455252137573E-14,
  0,
-1.12995550416439E-14,
1.05423482443801E-14,
0.839298324809899,
1.47733388022875E-14,
0.560390500503628,
1.73580767814929E-14,
0.839139795294853,
1.77817829905003E-14,
  0,
2.27218417692132E-14,
1.83759257810223E-14,
3.33665386986759E-14,
3.06482270118202E-14,
4.56509829938057E-14,
3.84007062259606E-14,
5.65693325516037E-14,
4.49145928782535E-14,
6.10995629091171E-14,
3.96878710451354E-14,
5.89988127797092E-14,
3.38305772284997E-14,
5.34225441661818E-14,
2.30145763557843E-14,
5.06209657524792E-14,
2.44526621173691E-14,
5.93804519444241E-14,
3.48766154845137E-14,
6.8364584826508E-14,
4.43169806407795E-14,
8.08320424483533E-14,
4.60282853498306E-14,
8.06845909528953E-14,
4.04875785675607E-14,
9.04831765069503E-14,
3.73936992481561E-14,
9.57246434896142E-14,
4.03696173711943E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.19613520477291E-14,
  0,
0.82801944722203,
1.39211558947139E-14,
0.498456516645347,
1.70193720228085E-14,
0.498197880285941,
2.25444662937946E-14,
0.827661681057511,
2.61145272073549E-14,
1.57027169045421E-14,
3.42321657131883E-14,
2.84668122407794E-14,
4.67178379315314E-14,
3.8889898246186E-14,
5.95764756972095E-14,
4.90241527928426E-14,
6.72465555462409E-14,
4.71653965883334E-14,
6.85571391323414E-14,
4.08943712226773E-14,
6.67322100356138E-14,
3.61030649820293E-14,
6.37762412325493E-14,
3.19570758744447E-14,
6.91061791124881E-14,
3.84700951649997E-14,
7.54092968624498E-14,
4.3904983815235E-14,
8.58965676364676E-14,
4.86477177985556E-14,
9.38008351547559E-14,
5.14189385514285E-14,
1.03825802122426E-13,
4.88038429113935E-14,
1.1237451941204E-13,
4.7343205744621E-14,
1.10203512981855E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.822049510330789,
1.11551393122689E-14,
0.472242860272771,
1.56185828159572E-14,
0.425360167295645,
2.15895010202694E-14,
0.471520349199964,
3.04600095146768E-14,
0.821402973644017,
3.72792074987416E-14,
2.54457913073658E-14,
4.67733490827626E-14,
3.59521440396193E-14,
5.95487201215938E-14,
4.87570053775421E-14,
6.89283699562004E-14,
5.026274535469E-14,
7.31845140045095E-14,
4.7348409915049E-14,
7.48151540719277E-14,
4.22691395773889E-14,
7.57527721106932E-14,
4.4356879280727E-14,
8.0930921686484E-14,
4.52372514447852E-14,
8.36544375437676E-14,
4.66120197994968E-14,
9.12325770485722E-14,
4.72026931430669E-14,
9.69979305209812E-14,
5.2956770912882E-14,
1.14920226113036E-13,
5.86735521279635E-14,
1.23519250383453E-13,
5.77767000908835E-14,
1.24506308041283E-13,
5.25256921291017E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.1216288314797E-14,
0.818534584512866,
1.11256490131773E-14,
0.458206199370175,
1.24223548114699E-14,
0.393637862174603,
1.96405391950094E-14,
0.393091483186099,
2.91407523111964E-14,
0.456797838982335,
4.10288122920655E-14,
0.81749679721979,
4.93338009333044E-14,
3.24315227451244E-14,
5.90491197605125E-14,
4.51869444639819E-14,
6.80844269851377E-14,
4.92652793560033E-14,
7.39503944191533E-14,
4.98394728265517E-14,
7.85760345678455E-14,
4.83389370198317E-14,
8.28937612995517E-14,
5.00875382836163E-14,
9.19429463119847E-14,
5.71600058951738E-14,
9.44236008826316E-14,
5.28405444399915E-14,
9.83883113869766E-14,
4.93320662098284E-14,
1.01132643925972E-13,
5.09123992964433E-14,
1.16777247594069E-13,
5.94906068851486E-14,
1.33123546908198E-13,
6.69603261727048E-14,
1.34068103840868E-13,
6.23147367040389E-14,
1.33545084712861E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07166879537157E-14,
  0,
  0,
1.08255418518333E-14,
0.816396484427775,
1.39740649607312E-14,
0.449878280140181,
1.26816959711284E-14,
0.376355611046883,
1.68146746526432E-14,
0.358297797804972,
2.71345446112292E-14,
0.374963761560963,
3.94077132037651E-14,
0.44753225927082,
5.27581450748826E-14,
0.814845888162092,
6.09972142240345E-14,
4.12525916204665E-14,
6.69299685118752E-14,
4.53153140012041E-14,
7.24836857202149E-14,
4.84829190683378E-14,
7.87998138962465E-14,
5.03069808033274E-14,
8.60075899389301E-14,
5.56395207684801E-14,
9.84394857295179E-14,
6.24205548360734E-14,
1.04718317350816E-13,
6.43183423187921E-14,
1.08404604737267E-13,
5.51416551308748E-14,
1.07488670741951E-13,
5.26141630263766E-14,
1.20090569433184E-13,
5.69830641006241E-14,
1.33970959326213E-13,
6.72621680575247E-14,
1.42566514149678E-13,
7.09328429326916E-14,
1.41994055402606E-13,
6.39176211958414E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.07288310180476E-14,
  0,
-1.08758488326366E-14,
  0,
0.81515371346584,
1.32602262503667E-14,
0.444786857841308,
1.52924548024735E-14,
0.365987581520815,
1.66923766475868E-14,
0.339112157727228,
2.41395445299553E-14,
0.33820016874774,
3.72609929022438E-14,
0.363417258311836,
5.06582623072127E-14,
0.441206336622344,
6.43894659813071E-14,
0.812940980128549,
6.88052045894061E-14,
4.11554471058118E-14,
7.11878472836602E-14,
4.43447362163951E-14,
7.69185062865496E-14,
4.86295032020578E-14,
8.56762577550185E-14,
5.73126615610597E-14,
1.00961773663588E-13,
6.76047759440301E-14,
1.10617244530875E-13,
6.91799048602171E-14,
1.18073953392361E-13,
6.62803145701218E-14,
1.16875259470461E-13,
5.80837461461314E-14,
1.25727553368371E-13,
5.83959963718073E-14,
1.36453348620336E-13,
6.43530367883116E-14,
1.4256130997925E-13,
7.08148817363252E-14,
1.49630308143855E-13,
7.21731702180151E-14,
1.52650461715531E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.08810530030645E-14,
  0,
0.814578919378522,
  0,
0.441817988598883,
1.4360040934136E-14,
0.359602670713217,
1.94583932300318E-14,
0.327508003156811,
2.41673001055709E-14,
0.31775188197501,
3.43414532921749E-14,
0.325287043120977,
4.85505732839009E-14,
0.355466019584946,
6.22548887441177E-14,
0.436640201138821,
7.13856057599216E-14,
0.811513970206581,
7.27178733894718E-14,
3.98995073092046E-14,
7.52922030278214E-14,
4.43126438320895E-14,
8.35807117960385E-14,
5.54443643774327E-14,
1.00251404400176E-13,
6.90038304274054E-14,
1.12741413427209E-13,
7.40969785528733E-14,
1.23467208679173E-13,
7.08079428424213E-14,
1.26006843848003E-13,
6.8963931787458E-14,
1.34591990330613E-13,
6.36296570988293E-14,
1.41593334279655E-13,
6.54580556425088E-14,
1.44492057208012E-13,
6.76264599874798E-14,
1.49017950756836E-13,
7.16943865386455E-14,
1.59641397323718E-13,
7.54899615040827E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.814578919378522,
1.01862962509358E-14,
0.440442414157476,
1.07587549980082E-14,
0.355862375323376,
1.87055232414579E-14,
0.320322358686556,
2.6555146970253E-14,
0.305308761676111,
3.3960681489198E-14,
0.303941486569901,
4.52441903386891E-14,
0.31633710968712,
5.96354562953927E-14,
0.349689775267695,
6.94288376790198E-14,
0.433207806250343,
7.50519438263986E-14,
0.810410533906026,
7.6215075917041E-14,
3.99836413977894E-14,
8.16464951203244E-14,
5.0934950701631E-14,
9.78141179164282E-14,
6.70036942596042E-14,
1.11676293212959E-13,
7.53112849860571E-14,
1.25205401602102E-13,
7.55350643144581E-14,
1.31011521076196E-13,
7.33267613295396E-14,
1.43282954945256E-13,
7.42565731126632E-14,
1.49958170880815E-13,
7.04904884463176E-14,
1.49096013313255E-13,
6.851463840718E-14,
1.50433485113233E-13,
6.82457562684036E-14,
1.58458315913101E-13,
7.47700512615523E-14,
1.63173294320806E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.08506953422349E-14,
0.81515371346584,
  0,
0.440442414157476,
1.17536189114809E-14,
0.354124932661828,
1.43478978698042E-14,
0.316097955212206,
2.58265631103427E-14,
0.297571158947787,
3.63806207381856E-14,
0.290892041139216,
4.5029084627668E-14,
0.294324004988271,
5.63351448823468E-14,
0.309803102414209,
6.66368002444351E-14,
0.345326222206773,
7.25600135531579E-14,
0.430546496011273,
7.90114501603156E-14,
0.809535707993234,
8.25207957522167E-14,
4.63847710241438E-14,
9.57185719574483E-14,
6.2307797810135E-14,
1.08971859313911E-13,
7.30145111038638E-14,
1.23840174226508E-13,
7.6518652525337E-14,
1.32427055432593E-13,
7.78075520679877E-14,
1.47944156925206E-13,
7.84476650306232E-14,
1.58274435224648E-13,
8.09803613055493E-14,
1.57063598238416E-13,
7.3371864139915E-14,
1.54617638137289E-13,
6.89379109353183E-14,
1.59429761059648E-13,
7.11201930680971E-14,
1.61549593147292E-13,
7.12121334123239E-14,
  0,
  0,
-1.13312137450805E-14,
  0,
  0,
1.12132525487141E-14,
0.816396484427775,
1.32654304207946E-14,
0.441817988598883,
1.07032438467769E-14,
0.354124932661828,
1.58761892521397E-14,
0.314131689778163,
2.16467468949766E-14,
0.293009675735401,
3.56242813026597E-14,
0.28275083898052,
4.74871877931271E-14,
0.280817625247612,
5.58979945664007E-14,
0.287276468896016,
6.33104679792496E-14,
0.304847871402936,
7.01218597076725E-14,
0.341929703415488,
7.64579372036778E-14,
0.428431951518394,
8.4295417868141E-14,
0.808827947175337,
9.64592988816904E-14,
5.76552694475652E-14,
1.06503347807596E-13,
6.82301437571198E-14,
1.20865123465208E-13,
7.40796313181136E-14,
1.30758251448704E-13,
7.86384846129806E-14,
1.49037032715071E-13,
8.26960028232904E-14,
1.62595631403306E-13,
8.49823683646278E-14,
1.65081490144381E-13,
8.37142855036888E-14,
1.62302463135866E-13,
7.36355421082635E-14,
1.63317276369312E-13,
7.16614267926019E-14,
1.62194910280355E-13,
6.74217626173146E-14,
1.64888935838547E-13,
  0,
-1.03480592150706E-14,
  0,
-1.1964821494681E-14,
  0,
0.818534584512866,
1.39627892581373E-14,
0.444786857841308,
1.43340200819964E-14,
0.355862375323376,
1.43478978698042E-14,
0.314131689778163,
2.32426924928752E-14,
0.290883175321252,
3.1266655931006E-14,
0.277940969625986,
4.67620733801688E-14,
0.27236948751649,
5.8262422664157E-14,
0.273415017105245,
6.27093862948236E-14,
0.281915882903758,
6.64780730463832E-14,
0.300978737138386,
7.34586003137139E-14,
0.339222491459085,
8.22657914012481E-14,
0.426718167800698,
9.85114767537709E-14,
0.80824567515255,
1.07034173191245E-13,
6.34457764103757E-14,
1.1820405765306E-13,
6.92258750323305E-14,
1.27606258892854E-13,
7.60745633154869E-14,
1.47208634171392E-13,
8.34454033649124E-14,
1.63402277819635E-13,
8.91457047069721E-14,
1.69073088862604E-13,
8.75792494081651E-14,
1.69982083964015E-13,
8.38409203174351E-14,
1.70653421949218E-13,
7.62601787274164E-14,
1.65752828129584E-13,
6.78779948914965E-14,
1.65256697215455E-13,
6.13606387922516E-14,
  0,
  0,
-1.13134328294517E-14,
  0,
0.822049510330789,
1.11299858218672E-14,
0.449878280140181,
1.52352089277663E-14,
0.359602670713217,
1.87228704762177E-14,
0.316097955212206,
2.16224607663129E-14,
0.290883175321252,
3.29276536592538E-14,
0.275695875616057,
4.25865939734926E-14,
0.267369572640479,
5.72424052602827E-14,
0.264726638639975,
6.51241213733833E-14,
0.267771882256097,
6.59784726853019E-14,
0.277720118246792,
6.96994545412721E-14,
0.297886951524249,
7.90947168871625E-14,
0.337022696697345,
9.5888574858094E-14,
0.42530615778275,
1.0936043737253E-13,
0.807759835713069,
1.18851109509599E-13,
6.44189562803987E-14,
1.2474916932792E-13,
7.11167236211452E-14,
1.4375133028377E-13,
8.08172972988075E-14,
1.61365712458839E-13,
8.96990814958087E-14,
1.69659425397484E-13,
9.16159509367631E-14,
1.73737760289505E-13,
8.7586188302069E-14,
1.78138753748058E-13,
8.63285137819858E-14,
1.72880806892373E-13,
7.2329295330853E-14,
1.68533589861575E-13,
6.17648293621542E-14,
1.67471939094277E-13,
  0,
  0,
1.05250010096203E-14,
0.82801944722203,
1.10996281610376E-14,
0.458206199370175,
1.27640953362373E-14,
0.365987581520815,
1.94583932300318E-14,
0.320322358686556,
2.58265631103427E-14,
0.293009675735401,
3.13221670822372E-14,
0.275695875616057,
4.39596276047283E-14,
0.265033423717073,
5.31649377299992E-14,
0.259577248701038,
6.41283900981726E-14,
0.258891211739607,
6.81017742198975E-14,
0.263346940991771,
6.91564860932914E-14,
0.274360639242004,
7.5467410098895E-14,
0.295369351977911,
9.24677001634677E-14,
0.335206361747439,
1.06220587881012E-13,
0.42412653221918,
1.20538995451724E-13,
0.807349539459807,
1.25290403052425E-13,
6.62300075893185E-14,
1.40791892033754E-13,
7.57900686654267E-14,
1.57703711201052E-13,
8.70033212141408E-14,
1.67366120962242E-13,
9.21207554682724E-14,
1.74133277242028E-13,
9.15309494864402E-14,
1.81689732703383E-13,
8.99610247406812E-14,
1.80085113488104E-13,
8.23265067229073E-14,
1.75455136530722E-13,
6.61033727755722E-14,
1.7054066492328E-13,
6.10032857562004E-14,
  0,
1.16087695012368E-14,
0.839298324809899,
1.38899308721463E-14,
0.472242860272771,
1.23477617020029E-14,
0.376355611046883,
1.67340100110103E-14,
0.327508003156811,
2.65829025458686E-14,
0.297571158947787,
3.56242813026597E-14,
0.277940969625986,
4.2555368950925E-14,
0.265033423717073,
5.43228656502137E-14,
0.257169281683214,
5.95157603755503E-14,
0.253621704775728,
6.70991040507829E-14,
0.254309551144675,
7.11392750263329E-14,
0.259798614517737,
7.48255624127836E-14,
0.271620503748716,
8.89444767837588E-14,
0.293286924301554,
1.03089412006874E-13,
0.333686210157977,
1.17664558652031E-13,
0.423129275258224,
1.27059820997921E-13,
0.80699940396042,
1.41116285323761E-13,
7.07663094789979E-14,
1.54654067330284E-13,
8.17887424453545E-14,
1.63627791871512E-13,
8.92619311798626E-14,
1.71669969906141E-13,
9.18917719694434E-14,
1.81911777308308E-13,
9.38103761338738E-14,
1.83473028436687E-13,
8.58584037199961E-14,
1.82475562438E-13,
7.60554813572512E-14,
1.77202003071031E-13,
6.53106041470508E-14,
1.77344250396061E-13,
  0,
0.866400225443959,
1.47768082492394E-14,
0.498456516645347,
1.56237869863851E-14,
0.393637862174603,
1.67661023953158E-14,
0.339112157727228,
2.41811778933787E-14,
0.305308761676111,
3.64396013363688E-14,
0.28275083898052,
4.67794206149286E-14,
0.267369572640479,
5.31996321995187E-14,
0.257169281683214,
6.10674705248115E-14,
0.251155892430624,
6.28629093224475E-14,
0.248941826829423,
7.01782382206417E-14,
0.250631567003075,
7.69245778187155E-14,
0.256900773001076,
8.77891509487583E-14,
0.2693508172564,
9.91481202694544E-14,
0.291541450490725,
1.14117049143658E-13,
0.332399095494799,
1.23907828442071E-13,
0.422277473882041,
1.42899581057065E-13,
0.806697866522625,
1.5495764393858E-13,
7.67632485354497E-14,
1.60387328418388E-13,
8.40612301988841E-14,
1.678240879599E-13,
8.89826407002303E-14,
1.79259385113539E-13,
9.41295652534535E-14,
1.83500784012303E-13,
8.9607141151582E-14,
1.8562755499385E-13,
7.94971727335891E-14,
1.84120080293226E-13,
7.51464862558393E-14,
1.83832116196214E-13,
6.05140937359749E-14,
0.999999999999999,
1.48600749760863E-14,
0.560390500503628,
1.69603914246252E-14,
0.425360167295645,
1.95156391047391E-14,
0.358297797804972,
2.41915862342346E-14,
0.31775188197501,
3.39355279987963E-14,
0.290892041139216,
4.74273398332059E-14,
0.27236948751649,
5.71227093404403E-14,
0.259577248701038,
5.95426485894279E-14,
0.251155892430624,
6.39887448583565E-14,
0.246428625171477,
6.58639809358874E-14,
0.245182362211513,
7.58074159001865E-14,
0.247625084073766,
8.99627594641572E-14,
0.254497869210602,
9.84403530912559E-14,
0.26744610211733,
1.10337086689505E-13,
0.290061653511562,
1.20379400891935E-13,
0.331298262160661,
1.39653913433513E-13,
0.421543327222769,
1.56477261703536E-13,
0.806436079117871,
1.60354368672344E-13,
7.88744070057135E-14,
1.64398009094846E-13,
8.36795910341692E-14,
1.75330236440452E-13,
9.10937991704941E-14,
1.80739104238548E-13,
8.98361246504109E-14,
1.85608473035614E-13,
8.31210100749047E-14,
1.8717145888747E-13,
7.85430748218019E-14,
1.90545496048244E-13,
7.02389535423009E-14,
1.84434065242378E-13,
  0,
0.866359712001398,
1.73984091023094E-14,
0.498197880285941,
2.15313877838241E-14,
0.393091483186099,
2.71380140581812E-14,
0.33820016874774,
3.43726783147424E-14,
0.303941486569901,
4.49779102851267E-14,
0.280817625247612,
5.8264157387633E-14,
0.264726638639975,
6.40737463086793E-14,
0.253621704775728,
6.28906648980632E-14,
0.246428625171477,
6.68493038702422E-14,
0.242629783707767,
7.1505301679764E-14,
0.242107447743732,
8.8934068442903E-14,
0.245130146157253,
1.00456101770341E-13,
0.252479495955585,
1.09495745803656E-13,
0.265829635227219,
1.16523110604838E-13,
0.288794618863735,
1.35943339918398E-13,
0.330348396586721,
1.52903731343024E-13,
0.420905525221452,
1.61669289067135E-13,
0.806207164282628,
1.64273109004576E-13,
7.85552178861337E-14,
1.71850381147642E-13,
8.57525855879615E-14,
1.76634748494386E-13,
8.67882155031197E-14,
1.82659443126454E-13,
8.33673408084934E-14,
1.86945944835593E-13,
8.21027273945063E-14,
1.93478913446121E-13,
7.36355421082635E-14,
1.90928869936435E-13,
5.52162482403418E-14,
  0,
1.21304875866368E-14,
0.839139795294853,
2.25245169738209E-14,
0.471520349199964,
2.90861085217031E-14,
0.374963761560963,
3.72618602639818E-14,
0.325287043120977,
4.52164347630735E-14,
0.294324004988271,
5.59257501420163E-14,
0.273415017105245,
6.51310602672872E-14,
0.258891211739607,
6.71823707776298E-14,
0.248941826829423,
6.58900017880271E-14,
0.242629783707767,
7.2476746826311E-14,
0.239521753624819,
8.4742976524943E-14,
0.239554424345688,
9.91290383112187E-14,
0.243033058706465,
1.11601700103492E-13,
0.250765204957823,
1.15473602901872E-13,
0.264444342640221,
1.31972557881888E-13,
0.287700289064327,
1.49286832895612E-13,
0.32952236285798,
1.58539847916472E-13,
0.42034747902393,
1.65541191865515E-13,
0.806005701826774,
1.71369862744797E-13,
8.04287192401887E-14,
1.73038666728687E-13,
8.1450471367539E-14,
1.78477024825874E-13,
8.02326954874033E-14,
1.83979567691672E-13,
8.23213025524794E-14,
1.93173602114349E-13,
7.72212155331076E-14,
1.93706162221474E-13,
5.84827325456061E-14,
1.82583115293511E-13,
  0,
  0,
1.77826503522382E-14,
0.827661681057511,
3.04600095146768E-14,
0.456797838982335,
3.93938354159573E-14,
0.363417258311836,
4.84603676631501E-14,
0.31633710968712,
5.6395860204006E-14,
0.287276468896016,
6.27128557417755E-14,
0.267771882256098,
6.81850409467444E-14,
0.254309551144675,
7.01730340502138E-14,
0.245182362211513,
7.14480558050568E-14,
0.239521753624819,
8.58878940190877E-14,
0.236940588686387,
9.48061074090845E-14,
0.237407573546298,
1.10444639545015E-13,
0.241250875740221,
1.17525780773953E-13,
0.249295058999633,
1.31176319806414E-13,
0.263246939995837,
1.45484319036271E-13,
0.286747820167857,
1.54919480022109E-13,
0.328798990783523,
1.62271238113298E-13,
0.419856097484852,
1.72665701181351E-13,
0.805827367137784,
1.72958869448792E-13,
7.60780327624389E-14,
1.74974618127877E-13,
7.48932166283467E-14,
1.79667045130394E-13,
7.92178822539569E-14,
1.90066712368875E-13,
7.73270336651422E-14,
1.93284624416812E-13,
6.20562629061183E-14,
1.85238976935231E-13,
5.31363147926456E-14,
  0,
1.35191337291563E-14,
  0,
2.61075883134509E-14,
0.821402973644018,
4.10045261634018E-14,
0.44753225927082,
5.07033651175881E-14,
0.355466019584946,
5.96267826780128E-14,
0.309803102414209,
6.33104679792496E-14,
0.281915882903758,
6.59229615340706E-14,
0.263346940991771,
7.10907027690055E-14,
0.250631567003075,
7.57831297715228E-14,
0.242107447743732,
8.48262432517899E-14,
0.236940588686387,
9.62042945307218E-14,
0.234769604181037,
1.05762620883354E-13,
0.235582405840549,
1.16412088302376E-13,
0.239721731103644,
1.32898900218059E-13,
0.248023539984709,
1.44478179420204E-13,
0.262204045181249,
1.50957371602978E-13,
0.285913105694656,
1.58649135495459E-13,
0.328161541483811,
1.69491157220314E-13,
0.419420923253798,
1.73671840797418E-13,
0.805668671445587,
1.74707470712576E-13,
6.96647600717526E-14,
1.75847184036293E-13,
7.38072797323852E-14,
1.8562755499385E-13,
7.41438160867247E-14,
1.90182938841765E-13,
6.2153407420773E-14,
1.84685600146395E-13,
5.67011715357779E-14,
1.87200949186561E-13,
  0,
  0,
2.27218417692132E-14,
1.57859836313889E-14,
3.72792074987416E-14,
0.81749679721979,
5.26965623914855E-14,
0.441206336622344,
6.22566234675936E-14,
0.349689775267695,
6.67061891834742E-14,
0.304847871402936,
6.63948063195363E-14,
0.277720118246792,
6.91252610707238E-14,
0.259798614517737,
7.68066166223491E-14,
0.247625084073766,
8.89878448706583E-14,
0.239554424345688,
9.47505962578532E-14,
0.234769604181037,
1.07320402564781E-13,
0.232923572091279,
1.11822009984941E-13,
0.234015859107852,
1.31854596685521E-13,
0.238398595572794,
1.46558112867901E-13,
0.246915500153903,
1.49713574870702E-13,
0.26128953062921,
1.54511820005254E-13,
0.285177054428185,
1.65362515347489E-13,
0.32759662070303,
1.70528521858948E-13,
0.419033511253649,
1.75789938161586E-13,
0.80552677212829,
1.75387482315159E-13,
6.85805578992671E-14,
1.81875348115312E-13,
6.87037232660614E-14,
1.85657045292942E-13,
5.89823329066874E-14,
1.81439932522842E-13,
5.67774993687209E-14,
1.86548693159594E-13,
4.76077510747075E-14,
  0,
2.06549187475868E-14,
1.83802625897123E-14,
3.42139511166906E-14,
2.54457913073658E-14,
4.94214044688412E-14,
0.814845888162092,
6.44042111308529E-14,
0.436640201138821,
6.9486083553727E-14,
0.345326222206773,
7.01322680485283E-14,
0.300978737138386,
6.97011892647481E-14,
0.274360639242004,
7.47665818146004E-14,
0.256900773001076,
8.99749025284891E-14,
0.245130146157253,
9.91880189094019E-14,
0.237407573546298,
1.05760886159878E-13,
0.232923572091279,
1.13208054042246E-13,
0.231338856968556,
1.27436255992208E-13,
0.23265996448268,
1.45340336987765E-13,
0.237245122505725,
1.51628709588181E-13,
0.24594339986301,
1.53406801151057E-13,
0.260482677992702,
1.61639798768043E-13,
0.284524367806931,
1.66719069105703E-13,
0.327093394918083,
1.72127936903799E-13,
0.418686974006389,
1.77014652935625E-13,
0.805399332050591,
1.8126819489872E-13,
6.33902652591445E-14,
1.8177299943023E-13,
5.34485650183214E-14,
1.76855058375835E-13,
5.35734651085917E-14,
1.83287413024757E-13,
4.76372413737991E-14,
1.8911608390404E-13,
1.46172136894496E-14,
1.96357687054505E-14,
3.33665386986759E-14,
2.84303830477839E-14,
4.67733490827626E-14,
3.24176449573166E-14,
6.09824690744887E-14,
0.812940980128549,
7.14445863581048E-14,
0.433207806250343,
7.26189941513411E-14,
0.341929703415488,
7.3521050358849E-14,
0.297886951524249,
7.5470879545847E-14,
0.271620503748716,
8.7733639797527E-14,
0.254497869210602,
1.00561919902376E-13,
0.243033058706465,
1.10392597840736E-13,
0.235582405840549,
1.11849765560557E-13,
0.231338856968556,
1.28716481917479E-13,
0.229967038726221,
1.40720768371239E-13,
0.231477627919699,
1.50377973962001E-13,
0.236232810301348,
1.55547449920412E-13,
0.245085379525638,
1.60682231409304E-13,
0.259766865700765,
1.62578284168546E-13,
0.283942656067094,
1.68283789681034E-13,
0.326643016491587,
1.72918970808844E-13,
0.418375643977592,
1.82159842765373E-13,
0.805284413818144,
1.81261256004817E-13,
4.80414319437017E-14,
1.73003972259167E-13,
4.80553097315095E-14,
1.78693865260371E-13,
4.44661668597135E-14,
1.85719495338077E-13,
4.66258975873046E-14,
1.4395385924959E-14,
3.05727665406152E-14,
3.06360839474884E-14,
4.67143684845794E-14,
3.59712259978551E-14,
5.90421808666086E-14,
4.12751430256542E-14,
6.87479587146989E-14,
0.811513970206581,
7.50484743794466E-14,
0.430546496011273,
7.63712010298789E-14,
0.339222491459085,
7.90877779932586E-14,
0.295369351977911,
8.89652934654706E-14,
0.2693508172564,
9.84056586217363E-14,
0.252479495955585,
1.11573944527876E-13,
0.241250875740221,
1.164103535789E-13,
0.234015859107852,
1.27462276844348E-13,
0.229967038726221,
1.42027015148649E-13,
0.228770663866248,
1.46008205526016E-13,
0.230439746743287,
1.54366103233272E-13,
0.235339019643337,
1.62462057695656E-13,
0.244323886421538,
1.61381324970122E-13,
0.259128618548372,
1.64214128406392E-13,
0.283421788804847,
1.69047068010464E-13,
0.326238195833364,
1.78792744498502E-13,
0.418094819389495,
1.82321172048638E-13,
0.805180399282345,
1.72330899550488E-13,
4.26395030395099E-14,
1.74575631728402E-13,
3.88994392253039E-14,
1.81108600338931E-13,
4.33576785585643E-14,
1.9428555986245E-13,
2.07201877183705E-14,
2.864765716315E-14,
4.562322741819E-14,
3.89297968861335E-14,
5.95209645459782E-14,
4.5180005570078E-14,
6.68770594458579E-14,
4.11606512762397E-14,
7.26640969617165E-14,
0.810410533906026,
7.89975723725078E-14,
0.428431951518394,
8.22675261247241E-14,
0.337022696697345,
9.25336196555548E-14,
0.293286924301554,
9.92036314206857E-14,
0.26744610211733,
1.09507888867988E-13,
0.250765204957823,
1.17522311327001E-13,
0.239721731103644,
1.31939598135844E-13,
0.23265996448268,
1.40665257220007E-13,
0.228770663866248,
1.47352616219898E-13,
0.227720340243502,
1.49586940056956E-13,
0.229523193428485,
1.61134994236534E-13,
0.23454555995323,
1.63400543096159E-13,
0.2436446790259,
1.62807267667375E-13,
0.258556908274124,
1.64979141459298E-13,
0.282953410749965,
1.7490869863579E-13,
0.325872878679722,
1.78440595632878E-13,
0.41784057048921,
1.73562553218432E-13,
0.805085927563956,
1.74190523116735E-13,
3.36709826687098E-14,
1.7696955012525E-13,
3.77857467537268E-14,
1.89598337030361E-13,
4.09498823739085E-14,
1.87014032732025E-14,
4.05005889936305E-14,
3.8372950650345E-14,
5.95756083354715E-14,
4.87717505270879E-14,
6.81156520077053E-14,
4.53361306829159E-14,
7.12130007740619E-14,
3.99793045890995E-14,
7.6215075917041E-14,
0.809535707993234,
8.4295417868141E-14,
0.426718167800698,
9.59510249032292E-14,
0.335206361747439,
1.03089412006874E-13,
0.291541450490725,
1.1039086311726E-13,
0.265829635227219,
1.15501358477488E-13,
0.249295058999633,
1.32871144642444E-13,
0.238398595572794,
1.4536809256338E-13,
0.231477627919699,
1.46077594465055E-13,
0.227720340243502,
1.50773490914524E-13,
0.226792704933355,
1.5663512153985E-13,
0.228709377284162,
1.62267768666347E-13,
0.233837663522845,
1.64764035748277E-13,
0.243036093418102,
1.63823815624298E-13,
0.258042631323202,
1.70547603817184E-13,
0.282530575908548,
1.74775124928139E-13,
0.325541999679216,
1.69525851689833E-13,
0.417609590217641,
1.75373604527351E-13,
0.804999846834092,
1.76390152484274E-13,
3.26023930075081E-14,
1.85462756263632E-13,
3.54022366977347E-14,
1.93581262131204E-13,
2.5991145000126E-14,
3.25516523458358E-14,
5.65719346368176E-14,
4.90111423667727E-14,
6.89014817423228E-14,
4.92253807160559E-14,
7.25201149132104E-14,
4.43195827259935E-14,
7.52124057479264E-14,
3.9942008034366E-14,
8.25554902217362E-14,
0.808827947175337,
9.84577003260156E-14,
0.42530615778275,
1.06260486520959E-13,
0.333686210157977,
1.14122253314086E-13,
0.290061653511562,
1.16495355029222E-13,
0.264444342640221,
1.3117805452989E-13,
0.248023539984709,
1.46558112867901E-13,
0.237245122505725,
1.50388382302857E-13,
0.230439746743287,
1.49586940056956E-13,
0.226792704933355,
1.58000348915444E-13,
0.225968974112396,
1.57703711201052E-13,
0.227983199994766,
1.63501157057766E-13,
0.233203229036927,
1.65487415437759E-13,
0.242488494938915,
1.6944952385689E-13,
0.257578213755474,
1.70507705177236E-13,
0.282147467789113,
1.65634866933217E-13,
0.325241292136414,
1.7139414887346E-13,
0.417399077905673,
1.76997305700866E-13,
0.804921176436756,
1.84668252911635E-13,
3.0069696732582E-14,
1.89490784174851E-13,
2.41057174221737E-14,
1.88662020034203E-14,
4.79664051533657E-14,
4.49354095599652E-14,
6.72613006957867E-14,
5.02696842485939E-14,
7.39798847182449E-14,
4.84863885152897E-14,
7.69228430952396E-14,
4.43265216198974E-14,
8.16187395447088E-14,
4.63361987668165E-14,
9.64315433060747E-14,
0.80824567515255,
1.09318804009106E-13,
0.42412653221918,
1.17664558652031E-13,
0.332399095494798,
1.20381135615411E-13,
0.288794618863735,
1.31993374563599E-13,
0.263246939995837,
1.44472975249776E-13,
0.246915500153903,
1.51635648482085E-13,
0.236232810301348,
1.54314061528993E-13,
0.229523193428485,
1.56666346562417E-13,
0.225968974112396,
1.58904139846427E-13,
0.22523388972625,
1.58954446827231E-13,
0.227332285014516,
1.64526378632068E-13,
0.2326322556826,
1.71352515510037E-13,
0.241993862934448,
1.69269112615389E-13,
0.257157308752189,
1.61225199857284E-13,
0.281799183089174,
1.67366120962242E-13,
0.324967139607735,
1.73493164279392E-13,
0.417206647826586,
1.85639698058182E-13,
0.804849076869714,
1.88685872481997E-13,
1.87870552448288E-14,
1.90649579456803E-13,
2.93777589061017E-14,
3.56719861982491E-14,
6.11186448673529E-14,
4.71584576944295E-14,
7.31992591540553E-14,
4.98307992091718E-14,
7.87703235971549E-14,
4.86017476264422E-14,
8.35703034551827E-14,
5.09071951260154E-14,
9.57255108513522E-14,
5.76396569362814E-14,
1.0707060238424E-13,
0.807759835713069,
1.20769713674029E-13,
0.423129275258224,
1.23828031162176E-13,
0.331298262160661,
1.3600752468701E-13,
0.287700289064327,
1.45484319036271E-13,
0.262204045181249,
1.49661533166423E-13,
0.245943399863009,
1.55519694344797E-13,
0.235339019643337,
1.61190505387765E-13,
0.228709377284162,
1.5767422090196E-13,
0.22523388972625,
1.60255489434213E-13,
0.224574942128842,
1.59868646099071E-13,
0.226746400816858,
1.70020247880487E-13,
0.232116414295301,
1.71090572265165E-13,
0.241545472531374,
1.60132324067419E-13,
0.25677456247711,
1.62973801121069E-13,
0.281481562750033,
1.69381869641327E-13,
0.324716459049874,
1.81545750654877E-13,
0.417030256657191,
1.89352006296772E-13,
0.804782825797281,
1.90011201217644E-13,
1.12305997834738E-14,
2.22803546445771E-14,
4.90601483049691E-14,
3.97104224503231E-14,
6.85692821966732E-14,
4.73666245115467E-14,
7.85699630356795E-14,
5.02792252277118E-14,
8.56918702663023E-14,
5.54478338243847E-14,
9.78245262572841E-14,
6.23147367040389E-14,
1.06508551978024E-13,
6.35203695198427E-14,
1.1888927342607E-13,
0.807349539459807,
1.27059820997921E-13,
0.422277473882041,
1.39605341176186E-13,
0.330348396586721,
1.49293771789516E-13,
0.286747820167857,
1.50972984114262E-13,
0.26128953062921,
1.53412005321485E-13,
0.245085379525638,
1.62462057695656E-13,
0.23454555995323,
1.62253890878539E-13,
0.227983199994766,
1.59011692701938E-13,
0.224574942128842,
1.61249485985948E-13,
0.223981788131895,
1.6547874182038E-13,
0.226217023605616,
1.69713201825239E-13,
0.231648718493726,
1.61877455884252E-13,
0.241137648111249,
1.6169704464275E-13,
0.256425431021859,
1.64954855330635E-13,
0.281191058774426,
1.77774461818103E-13,
0.324486608009784,
1.85646636952086E-13,
0.416868145467437,
1.90191612459145E-13,
0.804721798736123,
1.90063242921923E-13,
2.72911034049361E-14,
3.10923162216703E-14,
5.90057516736131E-14,
4.08666156470616E-14,
7.48151540719277E-14,
4.83111814442161E-14,
8.6014528832834E-14,
5.73230699019156E-14,
1.00299976657503E-13,
6.69794081309405E-14,
1.09003084336479E-13,
6.82301437571198E-14,
1.18158954842684E-13,
6.44328340682065E-14,
1.25299076669805E-13,
0.80699940396042,
1.42785089307651E-13,
0.421543327222769,
1.52889853555216E-13,
0.32952236285798,
1.54931623086441E-13,
0.285913105694656,
1.54428553278407E-13,
0.260482677992702,
1.60690905026684E-13,
0.244323886421538,
1.63407481990063E-13,
0.233837663522845,
1.63535851527286E-13,
0.227332285014516,
1.59840890523455E-13,
0.223981788131895,
1.66928970646296E-13,
0.223445809671881,
1.65298330578878E-13,
0.225737001835999,
1.60576413277269E-13,
0.231223269753289,
1.63303398581505E-13,
0.240765570419233,
1.63705854427931E-13,
0.256106035963991,
1.73354386401314E-13,
0.28092462833032,
1.81792081388465E-13,
0.324275310314393,
1.86704818272432E-13,
0.416718792976143,
1.90701621161082E-13,
0.804665453392787,
1.35913415938438E-14,
4.3382398368097E-14,
3.38375161224036E-14,
6.67053218217362E-14,
4.22899562591006E-14,
8.28946286612897E-14,
5.56707457910477E-14,
1.00946161152304E-13,
6.90038304274054E-14,
1.11697109894671E-13,
7.30145111038638E-14,
1.20879001253016E-13,
6.92466917140422E-14,
1.24735291540112E-13,
6.62594978884101E-14,
1.4106077417253E-13,
0.806697866522624,
1.56477261703536E-13,
0.420905525221452,
1.58525970128665E-13,
0.328798990783523,
1.58659543836315E-13,
0.285177054428185,
1.61603369575047E-13,
0.259766865700765,
1.61445509738734E-13,
0.2436446790259,
1.64764035748277E-13,
0.233203229036927,
1.64526378632068E-13,
0.226746400816858,
1.65464864032572E-13,
0.223445809671881,
1.66471003648638E-13,
0.222959775155925,
1.5604878500497E-13,
0.225300296056132,
1.6212378661784E-13,
0.23083505782688,
1.65648744721025E-13,
0.240425124248796,
1.72001302090052E-13,
0.255813049417112,
1.7728873924483E-13,
0.280679648877249,
1.8277740432282E-13,
0.324080596125813,
1.8696849624078E-13,
0.416580877618309,
2.02397126836118E-13,
2.28194199647369E-14,
1.95841606820402E-14,
5.34225441661818E-14,
3.61100038759332E-14,
7.57250165350776E-14,
5.00615174314767E-14,
9.84256079417101E-14,
6.75917655179603E-14,
1.12772638449776E-13,
7.52939377512973E-14,
1.23840174226508E-13,
7.41108563406812E-14,
1.2760799361633E-13,
7.1130601408953E-14,
1.4079362675723E-13,
7.07801872668057E-14,
1.5495764393858E-13,
0.806436079117871,
1.61724800218366E-13,
0.42034747902393,
1.62288585348058E-13,
0.328161541483811,
1.65390270923105E-13,
0.284524367806931,
1.62552263316407E-13,
0.259128618548372,
1.62807267667375E-13,
0.243036093418102,
1.65480476543856E-13,
0.2326322556826,
1.70075759031718E-13,
0.226217023605616,
1.65242819427647E-13,
0.222959775155925,
1.57311663695481E-13,
0.222517576788814,
1.57696772307148E-13,
0.224901775155301,
1.6421933257682E-13,
0.230479803064124,
1.73795006164212E-13,
0.240112777143455,
1.75859327100625E-13,
0.255543601825677,
1.78003445316932E-13,
0.280453849636067,
1.82787812663676E-13,
0.323900753246646,
1.98507876802978E-13,
0.416453246559658,
  0,
3.81730237697386E-14,
2.30163110792603E-14,
6.3797925275999E-14,
4.43811654093906E-14,
9.19533546528406E-14,
6.24196874743355E-14,
1.10613775083923E-13,
7.4121264681537E-14,
1.25203666878626E-13,
7.6518652525337E-14,
1.30786007024319E-13,
7.6069359145059E-14,
1.43744391389866E-13,
7.58195589645183E-14,
1.54654067330284E-13,
7.67632485354497E-14,
1.60441104846143E-13,
0.806207164282628,
1.65544661312467E-13,
0.419856097484852,
1.69546668371545E-13,
0.32759662070303,
1.66717334382227E-13,
0.283942656067094,
1.64182903383825E-13,
0.258556908274124,
1.63768304473066E-13,
0.242488494938915,
1.71352515510037E-13,
0.232116414295301,
1.69740957400855E-13,
0.225737001835999,
1.5604878500497E-13,
0.222517576788814,
1.588555675891E-13,
0.222114024813792,
1.59729868220992E-13,
0.224537055330365,
1.7245926908771E-13,
0.230153830777729,
1.77809156287623E-13,
0.239825482037613,
1.76782199989844E-13,
0.255295207458485,
1.78530801253629E-13,
0.280245255871609,
1.9414331253742E-13,
0.323734287305665,
1.93216970201249E-13,
2.12546993894058E-14,
1.45543299634454E-14,
5.06539254985228E-14,
3.19414633631609E-14,
8.09049008343443E-14,
5.7146128107366E-14,
1.04732195138624E-13,
6.91625576254573E-14,
1.23470678126125E-13,
7.5545472655314E-14,
1.32428790156069E-13,
7.86384846129806E-14,
1.47201695277488E-13,
8.08225014692354E-14,
1.57686363966292E-13,
8.17592521462629E-14,
1.60399471482719E-13,
7.8912570922185E-14,
1.64267904834148E-13,
0.806005701826774,
1.72651823393544E-13,
0.419420923253798,
1.70528521858948E-13,
0.327093394918083,
1.68353178620073E-13,
0.283421788804847,
1.64986080353202E-13,
0.258042631323202,
1.69498096114218E-13,
0.241993862934448,
1.7114434869292E-13,
0.231648718493726,
1.60548657701653E-13,
0.225300296056132,
1.577002417541E-13,
0.222114024813792,
1.61162749812149E-13,
0.221744684864297,
1.68032254777017E-13,
0.224202371738874,
1.76327702439139E-13,
0.229853970357746,
1.7863835410914E-13,
0.239560598538938,
1.77195064177127E-13,
0.25506570378964,
1.89858545551758E-13,
0.280052143299509,
1.88925264321682E-13,
0.323579889005161,
  0,
3.86943081742697E-14,
2.44526621173691E-14,
6.90723520047065E-14,
4.52554660412829E-14,
9.44270703295835E-14,
6.4325281212696E-14,
1.18077422839313E-13,
7.08356984180369E-14,
1.31014990523148E-13,
7.78110215149397E-14,
1.49068257737639E-13,
8.34558117057682E-14,
1.61313670754559E-13,
8.70328115132324E-14,
1.63643404382796E-13,
8.4068169092788E-14,
1.64439642458269E-13,
7.85552178861337E-14,
1.71383740532605E-13,
0.805827367137784,
1.73749903353837E-13,
0.419033511253649,
1.72112324392515E-13,
0.326643016491587,
1.69047068010464E-13,
0.282953410749965,
1.70603114968415E-13,
0.257578213755474,
1.69293398744053E-13,
0.241545472531374,
1.61884394778156E-13,
0.231223269753289,
1.62075214360513E-13,
0.224901775155301,
1.59729868220992E-13,
0.221744684864297,
1.69139008354691E-13,
0.221405748309291,
1.71963138173581E-13,
0.223894475403237,
1.77292208691782E-13,
0.229577473667275,
1.78870807054921E-13,
0.239315828847824,
1.88325049998994E-13,
0.254853201861631,
1.84359472132911E-13,
0.279873000551305,
1.7920734340926E-13,
2.34257058195908E-14,
1.97199027940353E-14,
5.94012686261358E-14,
3.8443206951122E-14,
8.36527028202916E-14,
5.28405444399915E-14,
1.08401135290315E-13,
6.62924576344537E-14,
1.26034599423619E-13,
7.3299005753924E-14,
1.47958034713014E-13,
8.26960028232904E-14,
1.63416155607443E-13,
8.96956120488568E-14,
1.67376529303098E-13,
8.92688700737665E-14,
1.67817149065996E-13,
8.36743868637413E-14,
1.71850381147642E-13,
8.04148414523809E-14,
1.7291203191494E-13,
0.805668671445587,
1.75817693737201E-13,
0.418686974006389,
1.72906827744512E-13,
0.326238195833364,
1.74919106976645E-13,
0.282530575908548,
1.70507705177236E-13,
0.257157308752189,
1.60104568491803E-13,
0.241137648111249,
1.633831958614E-13,
0.23083505782688,
1.64191577001205E-13,
0.224537055330365,
1.68035724223969E-13,
0.221405748309291,
1.73066422304302E-13,
0.221093928091257,
1.72729885949963E-13,
0.22361054979503,
1.77524661637563E-13,
0.229321948585131,
1.89934873384701E-13,
0.239089165259075,
1.8291965164785E-13,
0.254656045396265,
1.74527059471075E-13,
0.279706498097764,
1.49394385751123E-14,
4.96794445858928E-14,
3.48783502079897E-14,
7.54162357563537E-14,
4.66293670342566E-14,
9.84021891747844E-14,
5.51381856839228E-14,
1.1684576917137E-13,
6.89674012344099E-14,
1.43282954945256E-13,
7.84095011141517E-14,
1.62567875827691E-13,
8.91352963661163E-14,
1.69642078162724E-13,
9.21068776804645E-14,
1.7170466437566E-13,
8.89410073368069E-14,
1.75267786395317E-13,
8.58011578452889E-14,
1.73052544516494E-13,
7.61057883380545E-14,
1.74704001265624E-13,
0.80552677212829,
1.77007714041721E-13,
0.418375643977592,
1.7878927505155E-13,
0.325872878679722,
1.74799411056803E-13,
0.282147467789113,
1.61166219259101E-13,
0.25677456247711,
1.6169704464275E-13,
0.240765570419233,
1.65697316978353E-13,
0.230479803064124,
1.72487024663326E-13,
0.224202371738874,
1.71900688128446E-13,
0.221093928091257,
1.73850517315444E-13,
0.220806374436004,
1.7295540000184E-13,
0.223348142884449,
1.88661586353334E-13,
0.22908530453972,
1.84813969683617E-13,
0.23887884689489,
1.73170505712861E-13,
0.254472776921431,
1.65169961041656E-13,
3.3958079403984E-14,
3.35786086436141E-14,
6.83992792960275E-14,
4.38945754743791E-14,
9.12464548363801E-14,
4.93329335715664E-14,
1.07473058230667E-13,
5.80837461461314E-14,
1.34598929224516E-13,
7.42669814535191E-14,
1.58274435224648E-13,
8.49788989176758E-14,
1.69083497203459E-13,
9.15847259141955E-14,
1.74115930007268E-13,
9.19056497572512E-14,
1.79259385113539E-13,
9.11215547461097E-14,
1.76572298449251E-13,
8.13949602163078E-14,
1.74976352851353E-13,
6.95797586214297E-14,
1.75401360102967E-13,
0.805399332050591,
1.82163312212325E-13,
0.418094819389495,
1.78440595632878E-13,
0.325541999679216,
1.65631397486266E-13,
0.281799183089174,
1.62973801121069E-13,
0.256425431021859,
1.63678098852316E-13,
0.240425124248796,
1.73767250588597E-13,
0.230153830777729,
1.76313824651331E-13,
0.223894475403237,
1.7277845820729E-13,
0.220806374436004,
1.74048275791705E-13,
0.220540606180735,
1.84172121997506E-13,
0.223105111436551,
1.83408843668076E-13,
0.228865707604324,
1.74915637529693E-13,
0.238683323845543,
1.63691976640123E-13,
0.254302109560742,
2.38194880486375E-14,
6.01632459129586E-14,
4.43308584285873E-14,
8.58861592956117E-14,
4.72165709308747E-14,
1.0114652171378E-13,
5.26132956646386E-14,
1.25717145027515E-13,
6.36331265457812E-14,
1.49961640327767E-13,
8.09664835177415E-14,
1.65019040099246E-13,
8.75965966429249E-14,
1.73723882501697E-13,
9.15326842099162E-14,
1.81896164797024E-13,
9.41295652534535E-14,
1.80752982026355E-13,
8.67882155031197E-14,
1.78477024825874E-13,
7.48793388405389E-14,
1.75843714589341E-13,
6.84972911724202E-14,
1.81264725451769E-13,
0.805284413818144,
1.82321172048638E-13,
0.41784057048921,
1.69553607265449E-13,
0.325241292136414,
1.67359182068338E-13,
0.281481562750033,
1.64979141459298E-13,
0.256106035963991,
1.72060282688236E-13,
0.240112777143455,
1.77809156287623E-13,
0.229853970357746,
1.7725404477531E-13,
0.22361054979503,
1.72934583320128E-13,
0.220540606180735,
1.85230303317852E-13,
0.220294454471957,
1.7890550152444E-13,
0.222879575075464,
1.73583369900143E-13,
0.228661543268097,
1.65180369382512E-13,
0.238501227292331,
1.6153745008296E-13,
3.552496838366E-14,
3.96831005555764E-14,
8.08251035544494E-14,
4.86442483516036E-14,
9.7011808308789E-14,
5.09063277642774E-14,
1.20088834709708E-13,
5.83682407961916E-14,
1.41565578704039E-13,
7.04922231697935E-14,
1.57075741302748E-13,
8.36865299280731E-14,
1.69975145070111E-13,
8.76139438776846E-14,
1.81696671597287E-13,
9.37999677930179E-14,
1.83500784012303E-13,
8.98638802260265E-14,
1.8268719870207E-13,
8.03020844264424E-14,
1.79680922918202E-13,
7.38072797323852E-14,
1.81875348115312E-13,
6.33867958121925E-14,
1.81295950474336E-13,
0.805180399282345,
1.73645819945278E-13,
0.417609590217641,
1.7139414887346E-13,
0.324967139607735,
1.69326358490096E-13,
0.281191058774426,
1.73271119674467E-13,
0.255813049417112,
1.75855857653673E-13,
0.239825482037613,
1.78666109684755E-13,
0.229577473667275,
1.77528131084514E-13,
0.223348142884449,
1.84185999785313E-13,
0.220294454471957,
1.7997062173869E-13,
0.220066016330933,
1.68951658219285E-13,
0.222669878192223,
1.63764835026114E-13,
0.228471385408163,
1.6317155959733E-13,
0.238331344490678,
2.20071356971108E-14,
6.43135718292331E-14,
4.60421631376384E-14,
9.38112434956118E-14,
5.29428931250742E-14,
1.1680240108447E-13,
5.69709210362923E-14,
1.36455083343812E-13,
6.54719334303167E-14,
1.49094278589779E-13,
7.33562516286312E-14,
1.6227470756025E-13,
8.38582675521948E-14,
1.78131814854154E-13,
8.99644941876332E-14,
1.83445272861071E-13,
8.95932633637742E-14,
1.85637963334706E-13,
8.33864227667291E-14,
1.8399344547948E-13,
7.91970655722452E-14,
1.85637963334706E-13,
6.87054579895374E-14,
1.81771264706754E-13,
4.80136763680861E-14,
1.72386410701719E-13,
0.805085927563956,
1.75387482315159E-13,
0.417399077905673,
1.73548675430624E-13,
0.324716459049874,
1.77739767348584E-13,
0.28092462833032,
1.77260983669214E-13,
0.255543601825677,
1.76782199989844E-13,
0.239560598538938,
1.78870807054921E-13,
0.229321948585131,
1.88668525247238E-13,
0.223105111436551,
1.78933257100056E-13,
0.220066016330933,
1.70127800735997E-13,
0.219853616143737,
1.5917475670868E-13,
0.222474558190959,
1.61669289067135E-13,
0.228293970301454,
1.58702911923214E-13,
3.87233647924923E-14,
3.32598532049033E-14,
8.0705407634607E-14,
5.14258774453324E-14,
1.1492282819825E-13,
5.94906068851486E-14,
1.33970959326213E-13,
6.43634451291675E-14,
1.4448858776106E-13,
6.85267814715118E-14,
1.54619372860765E-13,
7.36355421082635E-14,
1.70667299737026E-13,
8.63267790585098E-14,
1.8011286906372E-13,
8.59000370834195E-14,
1.8566224946337E-13,
8.31903990139438E-14,
1.86945944835593E-13,
8.23178331055274E-14,
1.90066712368875E-13,
7.41438160867247E-14,
1.85698678656365E-13,
5.34190747192298E-14,
1.73003972259167E-13,
4.26169516343222E-14,
1.74218278692351E-13,
0.804999846834092,
1.76993836253914E-13,
0.417206647826586,
1.81545750654877E-13,
0.324486608009784,
1.81788611941514E-13,
0.280679648877249,
1.78006914763884E-13,
0.255295207458485,
1.77108328003328E-13,
0.239315828847824,
1.89990384535932E-13,
0.22908530453972,
1.83349863069893E-13,
0.222879575075464,
1.68948188772333E-13,
0.219853616143737,
1.60486207656518E-13,
0.219655773555913,
1.57325541483289E-13,
0.222292318887608,
1.57457380467463E-13,
0.228128174755611,
1.64169892957755E-14,
6.37363425926019E-14,
4.04945174614646E-14,
1.03844884080662E-13,
5.86874299157714E-14,
1.33130485802102E-13,
6.72604333340487E-14,
1.42571718320106E-13,
6.76438072222396E-14,
1.50433485113233E-13,
6.89656665109339E-14,
1.63351970838832E-13,
7.62567092804645E-14,
1.72861724934137E-13,
8.23195678290034E-14,
1.82475562438E-13,
7.9511050521397E-14,
1.87157581099662E-13,
8.21790552274493E-14,
1.93145846538734E-13,
7.73235642181902E-14,
1.9015518326615E-13,
5.9010088482303E-14,
1.76851588928884E-13,
4.80414319437017E-14,
1.74575631728402E-13,
3.36154715174786E-14,
1.76442194188553E-13,
0.804921176436756,
1.85639698058182E-13,
0.417030256657191,
1.8565357584599E-13,
0.324275310314393,
1.8277740432282E-13,
0.280453849636067,
1.78530801253629E-13,
0.25506570378964,
1.88325049998994E-13,
0.239089165259075,
1.84810500236665E-13,
0.228865707604324,
1.73590308794047E-13,
0.222669878192223,
1.59188634496488E-13,
0.219655773555913,
1.5844617284877E-13,
0.21947117657411,
1.52679952014623E-13,
0.222122008120778,
1.56295115738558E-13,
3.48735797184307E-14,
2.74918976472804E-14,
9.04554209313346E-14,
4.88038429113935E-14,
1.23494964254789E-13,
6.6941244214469E-14,
1.4257865721401E-13,
7.08426373119408E-14,
1.49004072969028E-13,
6.82578993327354E-14,
1.59454047188312E-13,
7.16596920691259E-14,
1.65749358682632E-13,
7.23397036717088E-14,
1.75465544871578E-13,
7.60624202511551E-14,
1.84120080293226E-13,
7.85777692913214E-14,
1.93475443999169E-13,
7.72212155331076E-14,
1.93284624416812E-13,
6.21776935494367E-14,
1.81455545034126E-13,
5.3556117873832E-14,
1.78693865260371E-13,
3.88994392253039E-14,
1.76941794549634E-13,
3.26232096892198E-14,
1.84657844570779E-13,
0.804849076869715,
1.89296495145541E-13,
0.416868145467437,
1.86631959886441E-13,
0.324080596125813,
1.82787812663676E-13,
0.280245255871609,
1.89830789976142E-13,
0.254853201861631,
1.8291965164785E-13,
0.23887884689489,
1.74887881954078E-13,
0.228661543268097,
1.63702384980979E-13,
0.222474558190959,
1.57190233052162E-13,
0.21947117657411,
1.53963647386846E-13,
0.219298658924879,
1.51642587375989E-13,
0.221962598824488,
1.53488333154428E-14,
6.99275706783631E-14,
3.74093117594398E-14,
1.12367580518136E-13,
5.77801695378355E-14,
1.34081981628675E-13,
7.09363123796436E-14,
1.49630308143855E-13,
7.17013254325494E-14,
1.58473928424385E-13,
7.10941722159575E-14,
1.62181032492548E-13,
6.78849337854004E-14,
1.68559610713714E-13,
6.61241894572839E-14,
1.7723669754055E-13,
7.51811807253588E-14,
1.90552434942148E-13,
7.36355421082635E-14,
1.93730448350138E-13,
6.20285073305027E-14,
1.84657844570779E-13,
5.67566826870092E-14,
1.83285678301282E-13,
4.44661668597135E-14,
1.81112069785883E-13,
3.7771868965919E-14,
1.85462756263632E-13,
3.00731661795339E-14,
1.88626891883814E-13,
0.804782825797281,
1.90191612459145E-13,
0.416718792976143,
1.8702053794506E-13,
0.323900753246646,
1.94139843090468E-13,
0.280052143299509,
1.84356002685959E-13,
0.254656045396265,
1.73177444606765E-13,
0.238683323845543,
1.65180369382512E-13,
0.228471385408163,
1.61683166854942E-13,
0.222292318887608,
1.52738932612806E-13,
0.219298658924879,
1.52874241043932E-13,
0.219137180912678,
1.48582535164365E-13,
4.5846139384853E-14,
2.88189611064027E-14,
9.57333171069941E-14,
4.73518793620009E-14,
1.24499369147379E-13,
6.22869811284232E-14,
1.41997524849558E-13,
7.21488840893514E-14,
1.5963619315329E-13,
7.47579081972205E-14,
1.61566940382052E-13,
6.74113542764587E-14,
1.65248023598075E-13,
6.17648293621542E-14,
1.70551073264136E-13,
6.53106041470508E-14,
1.83845993984022E-13,
7.02563007770607E-14,
1.90928869936435E-13,
5.85243659090295E-14,
1.85238976935231E-13,
5.66751506836383E-14,
1.86579918182161E-13,
4.76684663963667E-14,
1.85747250913693E-13,
4.33715563463721E-14,
1.89605275924265E-13,
3.53883589099269E-14,
1.89522009197418E-13,
1.88564441838679E-14,
1.89962628960316E-13,
0.804721798736123,
1.90680804479371E-13,
0.416580877618309,
1.98563387954209E-13,
0.323734287305665,
1.88869753170451E-13,
0.279873000551305,
1.74520120577171E-13,
0.254472776921431,
1.6368503774622E-13,
0.238501227292331,
1.63175029044282E-13,
0.228293970301454,
1.57433094338799E-13,
0.222122008120778,
1.51673812398556E-13,
0.219137180912678,
1.49793372150597E-13,
0.218985813168319,
1.79565563807049E-14,
8.18442535965858E-14,
4.03817604355261E-14,
1.10193972002737E-13,
5.25361004699576E-14,
1.33527737478101E-13,
6.39158864723655E-14,
1.52659135332911E-13,
7.54951656745106E-14,
1.63157681809523E-13,
7.12294806470837E-14,
1.64895874732451E-13,
6.13779860270114E-14,
1.67468469647325E-13,
6.10102246501043E-14,
1.77337311502157E-13,
6.04863381603593E-14,
1.84414983284142E-13,
5.52145135168658E-14,
1.82579645846559E-13,
5.31363147926456E-14,
1.87204418633513E-13,
4.76233635859913E-14,
1.89100471392756E-13,
4.66293670342566E-14,
1.94271682074643E-13,
4.09360045861007E-14,
1.93612487153771E-13,
2.41022479752218E-14,
1.90677335032419E-13,
1.12444775712817E-14,
1.90007731770692E-13,
0.804665453392787,
2.02397126836118E-13,
0.416453246559658,
1.93203092413441E-13,
0.323579889005161,
1.79262854560491E-13,
0.279706498097764,
1.65197716617271E-13,
0.254302109560742,
1.61509694507345E-13,
0.238331344490678,
1.58751484180542E-13,
0.228128174755611,
1.56267360162943E-13,
0.221962598824488,
1.48575596270462E-13,
0.218985813168319,
1.44440015503733E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
0.999999999999997,
  0,
  0,
  0,
  0,
1.69224443485883E-14,
1.27792741666521E-14,
1.6643153868956E-14,
1.26242332559867E-14,
2.08895400977127E-14,
1.60184365771698E-14,
2.75435056706907E-14,
2.39964298431872E-14,
2.9056835063046E-14,
1.67775949383442E-14,
2.31321038712817E-14,
1.21343907144578E-14,
2.2886640499431E-14,
  0,
1.70206730654154E-14,
1.3385560021506E-14,
3.16478614148519E-14,
1.96032426402759E-14,
3.67132539647042E-14,
2.41317382743134E-14,
3.85412188275147E-14,
1.7125623835712E-14,
3.5976863849152E-14,
1.47646651849076E-14,
4.4581092289997E-14,
1.55435560256212E-14,
4.81255660322866E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.12358039539018E-14,
  0,
1.49116829994966E-14,
0.866359712001398,
1.12548859121375E-14,
0.866325429916351,
1.36982439280509E-14,
1.06134719068951E-14,
2.28779668820511E-14,
1.93144111815258E-14,
2.91489922477073E-14,
2.20843308917917E-14,
3.25781068788444E-14,
2.4832566558608E-14,
4.19846449273287E-14,
3.46901327108462E-14,
4.8989458323323E-14,
3.53102963535079E-14,
4.51682961866151E-14,
2.50177482896685E-14,
3.98205773910476E-14,
1.46046369442487E-14,
3.45131909162966E-14,
1.56706245202365E-14,
4.21060755706471E-14,
2.85760998197659E-14,
5.92013417455295E-14,
3.78880954388094E-14,
6.51566474385579E-14,
3.57274973494803E-14,
6.45108966246255E-14,
2.76280734401446E-14,
6.97766497359531E-14,
2.62628460645509E-14,
8.02873392768966E-14,
2.98693361711067E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.13403210433294E-14,
  0,
  0,
1.48414266987196E-14,
0.839212243709222,
1.73051677154756E-14,
0.560245603153794,
1.79673984024298E-14,
0.839078243550044,
2.47839943012806E-14,
1.84960553817337E-14,
3.15875797740617E-14,
2.56396466558062E-14,
4.10695782937509E-14,
3.11998690771809E-14,
4.88324658487471E-14,
3.97650662398163E-14,
5.73213351784396E-14,
4.09308004156728E-14,
5.87325327261468E-14,
3.97321064937728E-14,
5.6466983866521E-14,
2.47891984717086E-14,
4.6450690516231E-14,
2.40163791631609E-14,
5.52483406246473E-14,
2.78926187702311E-14,
6.2751887019985E-14,
4.2410519540681E-14,
7.93913546015546E-14,
4.42857556182119E-14,
8.25121221348368E-14,
4.21910770209699E-14,
8.97623989026819E-14,
3.56962723269127E-14,
9.54809148412394E-14,
3.69539468469959E-14,
1.03816261143308E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.03597685985335E-14,
  0,
1.12540185503995E-14,
0.827878767874979,
1.62170624151692E-14,
0.498197880285941,
2.24186988417863E-14,
0.497979327268461,
2.83705350878627E-14,
0.827576912726422,
3.2315296272234E-14,
2.39539291180257E-14,
4.18423976022986E-14,
3.37802702476964E-14,
5.55120185929958E-14,
4.46838746559486E-14,
6.19036072402324E-14,
4.42250402965527E-14,
6.45898265427824E-14,
4.35268140974721E-14,
6.75891634327463E-14,
3.80997317028786E-14,
6.09391009875893E-14,
3.32780678014011E-14,
6.50894269038638E-14,
3.51940698806175E-14,
7.34265079294083E-14,
4.02507888130899E-14,
7.98736077278761E-14,
4.69450867068844E-14,
9.33298577310282E-14,
4.88732318504326E-14,
1.04205706563665E-13,
4.86407789046517E-14,
1.11635527211273E-13,
4.49024498139217E-14,
1.14773641979315E-13,
4.56457788233777E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.32749713999125E-14,
  0,
1.31210146914196E-14,
0.821842206717152,
1.30199670489439E-14,
0.471850148753609,
2.15296530603482E-14,
0.424989644501844,
3.24532067885741E-14,
0.471240667511765,
3.52400400527308E-14,
0.821298152718582,
4.1813774664945E-14,
3.14279852142718E-14,
5.52682899446211E-14,
4.63665564276461E-14,
6.74174258086246E-14,
4.83051099120502E-14,
6.78493719541429E-14,
4.58843033013245E-14,
7.20569437451246E-14,
4.10227407598995E-14,
7.07281455625264E-14,
4.58591498109229E-14,
7.82724579595495E-14,
4.37774816397507E-14,
8.18928258539131E-14,
4.68002372966403E-14,
8.90277435106057E-14,
4.38017677684144E-14,
9.19507525676266E-14,
5.04552996605234E-14,
1.12920957306972E-13,
5.42552114346506E-14,
1.23813286012631E-13,
5.69067362676812E-14,
1.28589847103733E-13,
5.26436533254682E-14,
1.23939920826377E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.54693965970232E-14,
  0,
1.59386392972749E-14,
0.81824467719433,
1.43903985949656E-14,
0.457650952912595,
1.78390288652075E-14,
0.393091483186099,
3.11417558407356E-14,
0.392630891445301,
3.91024018719932E-14,
0.456465927468725,
4.43057049381856E-14,
0.817374508322892,
5.47339951140202E-14,
4.34886501810006E-14,
6.65032265367849E-14,
4.94214044688412E-14,
7.23978169081541E-14,
4.93372703802564E-14,
7.44404538011167E-14,
4.28485372183651E-14,
7.42652467300431E-14,
4.82218431852033E-14,
8.71941407964982E-14,
5.58589632881912E-14,
9.41087485717418E-14,
5.48137923939152E-14,
9.63777668783194E-14,
4.98073804422461E-14,
9.99434909831898E-14,
4.67204400167454E-14,
1.10346627668623E-13,
5.5200635729058E-14,
1.31117339208231E-13,
6.18238099603374E-14,
1.39164721413287E-13,
6.39705302618587E-14,
1.36168853970275E-13,
5.07658151627233E-14,
  0,
  0,
  0,
  0,
  0,
  0,
-1.22939852742476E-14,
  0,
  0,
1.20255368163402E-14,
  0,
1.81079110039839E-14,
0.816002375554015,
1.74478487213747E-14,
0.449122314319854,
1.92901250528621E-14,
0.375597960670688,
2.7152759207727E-14,
0.357631197250925,
3.74197201002957E-14,
0.374427415529464,
4.78731637665319E-14,
0.447155123619689,
5.63403490527747E-14,
0.814708280141501,
6.5447647301653E-14,
4.61809410157166E-14,
7.10178443830145E-14,
5.00025368332935E-14,
7.84866963088326E-14,
4.5922467217796E-14,
7.6064154974631E-14,
4.96980928632595E-14,
9.0127558194375E-14,
5.78478237533986E-14,
1.02317460060064E-13,
6.6417357724724E-14,
1.07880718247522E-13,
5.74150102461424E-14,
1.06517225595404E-13,
5.23331378232683E-14,
1.17477208516625E-13,
5.1084136920565E-14,
1.27477889355632E-13,
6.22644297232355E-14,
1.45343806434717E-13,
6.84261675099052E-14,
1.45623096914349E-13,
6.16780931883554E-14,
1.44351544606458E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.31136421166467E-14,
  0,
  0,
1.43808576158477E-14,
0.814625522289951,
1.91704291330197E-14,
0.443778490025567,
2.16736351088542E-14,
0.364970558847638,
2.85847734371458E-14,
0.33820016874774,
3.30707683460219E-14,
0.337434129770942,
4.57351170823905E-14,
0.36281595424742,
6.00717392496009E-14,
0.440789695484648,
6.6719199609544E-14,
0.812789859198183,
6.95398599814823E-14,
4.6447221069279E-14,
7.65854393791621E-14,
4.63275251494366E-14,
7.97365645732739E-14,
5.24710483396085E-14,
9.14650299943531E-14,
5.89762613745215E-14,
1.04614233942257E-13,
6.80809575381858E-14,
1.15445847326257E-13,
6.86499468383062E-14,
1.17433840429726E-13,
5.96207111458469E-14,
1.23377003058422E-13,
5.63837171396742E-14,
1.33901570387174E-13,
5.77888431552154E-14,
1.40885567101456E-13,
6.84799439376604E-14,
1.50919207686506E-13,
6.57217336108573E-14,
1.52934956365591E-13,
6.567316135353E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
-1.10267697750466E-14,
1.06676820155194E-14,
0.813874113778782,
1.62482874377368E-14,
0.440485811459652,
2.38749991998688E-14,
0.358261049790113,
3.10923162216703E-14,
0.326296470041122,
3.42512476714241E-14,
0.316714324809382,
4.12968270691039E-14,
0.324436678367385,
5.77888431552154E-14,
0.354808350843284,
6.99206317844592E-14,
0.436188810381527,
7.09033526336E-14,
0.811350867466097,
7.49929632282154E-14,
4.24937862675279E-14,
7.75404046526873E-14,
5.26410512402542E-14,
9.47332490230934E-14,
6.14612527538583E-14,
1.05597822153136E-13,
6.88754608901831E-14,
1.17352308426355E-13,
7.000650059652E-14,
1.24459470507432E-13,
7.0603245472256E-14,
1.33745445274336E-13,
6.33625096835289E-14,
1.39251457587086E-13,
6.28663787693995E-14,
1.46724646321594E-13,
6.36574126744449E-14,
1.45843406795798E-13,
6.54355042373211E-14,
1.57604831962921E-13,
6.94218987851158E-14,
1.56258686545563E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.20012506876765E-14,
  0,
1.0696304952873E-14,
0.813634844594192,
1.20745427545366E-14,
0.438685055582809,
2.02398861559594E-14,
0.354106206981381,
3.31150037946593E-14,
0.318737653189131,
3.65315416805956E-14,
0.303941486569901,
4.26533808273177E-14,
0.302798675512211,
5.33410121628108E-14,
0.315414156866684,
6.75345196432531E-14,
0.348982773364084,
7.37127373029445E-14,
0.432725669592424,
7.6218545363993E-14,
0.81023675658358,
7.54066947772358E-14,
4.88029755496555E-14,
9.21814707899316E-14,
6.15341111398493E-14,
1.08498279804969E-13,
7.12485626053194E-14,
1.17831092105725E-13,
7.05737551731644E-14,
1.25946128526344E-13,
7.17221421142611E-14,
1.40373823676043E-13,
7.41438160867247E-14,
1.4916713697577E-13,
6.96786378595604E-14,
1.51595749842137E-13,
6.85389245358436E-14,
1.51160334249667E-13,
6.04447047969359E-14,
1.51979123730328E-13,
6.88945428484189E-14,
1.60402940929671E-13,
7.05529384914527E-14,
  0,
  0,
  0,
  0,
  0,
1.5481539661355E-14,
  0,
1.44901451948343E-14,
0.813874113778782,
1.211617611796E-14,
0.438111070166102,
1.62413485438329E-14,
0.351827004769081,
2.93688684482873E-14,
0.314038642908484,
3.86938744934007E-14,
0.295794814566557,
4.50464318624277E-14,
0.289395752875235,
5.42907732659081E-14,
0.293091375681759,
6.31196483968921E-14,
0.308817002277937,
7.11592243463066E-14,
0.344575740418694,
7.8534401204422E-14,
0.43003701521627,
7.65602858887604E-14,
0.809352379289016,
8.98205121391271E-14,
5.75373082511987E-14,
1.05726191690358E-13,
7.10768249811977E-14,
1.20511239876109E-13,
7.27178733894718E-14,
1.26176846748649E-13,
7.20968423850721E-14,
1.41480577253716E-13,
7.51065876158918E-14,
1.55429488724046E-13,
8.02500427221631E-14,
1.61067340020971E-13,
7.5170772384503E-14,
1.55602961071644E-13,
6.51093762238375E-14,
1.56857166144775E-13,
6.372853633696E-14,
1.54347021275036E-13,
6.98174157376386E-14,
1.69371461300472E-13,
  0,
  0,
  0,
  0,
1.32758387616505E-14,
  0,
1.81113804509359E-14,
0.814625522289951,
1.61303262413703E-14,
0.438685055582809,
1.63462993141295E-14,
0.351099463896184,
2.51534904016637E-14,
0.311454713779304,
3.51134052389845E-14,
0.290714990400163,
4.66232955020907E-14,
0.280817625247612,
5.67566826870092E-14,
0.279212245766554,
6.39314989836492E-14,
0.285966232864133,
6.64260313421039E-14,
0.303806384311046,
7.59028256913652E-14,
0.341140674112146,
7.89212445395648E-14,
0.427898038902169,
9.14216619074537E-14,
0.808636037732733,
1.03068595325162E-13,
6.70019595361282E-14,
1.17428636259298E-13,
7.25339927010182E-14,
1.2865576659582E-13,
7.40952438293974E-14,
1.4148751614762E-13,
7.53147544330091E-14,
1.56260421269039E-13,
8.1002912710737E-14,
1.66963665115816E-13,
8.56051340925035E-14,
1.64772709365657E-13,
7.1651018451746E-14,
1.61029176104499E-13,
6.82041229049801E-14,
1.5887291482386E-13,
6.44779368785819E-14,
1.62970331674117E-13,
6.84001466577655E-14,
  0,
  0,
-1.13333821494255E-14,
1.03597685985335E-14,
  0,
1.59698643198425E-14,
0.816002375554015,
1.92398180720588E-14,
0.440485811459652,
2.02459576881253E-14,
0.351827004769081,
2.51534904016637E-14,
0.31062894935204,
3.06803193961258E-14,
0.287916349412354,
4.32440541708878E-14,
0.275455925258226,
5.83092601980084E-14,
0.270304879156318,
6.62412832919124E-14,
0.271716065823307,
6.73818639773671E-14,
0.280537950676502,
7.12416237114155E-14,
0.299888339873646,
7.6213341193565E-14,
0.338399110663084,
9.3420063351779E-14,
0.426162333021363,
1.0428984065225E-13,
0.808046028210886,
1.14885531643516E-13,
6.83047368665868E-14,
1.25257443306381E-13,
7.37812588802456E-14,
1.43529285678845E-13,
7.72767266843388E-14,
1.55904802956464E-13,
8.11590378235749E-14,
1.67503164116845E-13,
8.6238308161235E-14,
1.70377600916538E-13,
8.19674189633801E-14,
1.69893613066741E-13,
7.45931094670027E-14,
1.62781246815236E-13,
6.8887603954515E-14,
1.6722907780764E-13,
6.29340329849626E-14,
1.66967134562768E-13,
  0,
  0,
  0,
  0,
1.30655035401883E-14,
0.81824467719433,
1.74209605074971E-14,
0.443778490025567,
2.38836728172487E-14,
0.354106206981382,
2.93584601074315E-14,
0.311454713779304,
3.06994013543616E-14,
0.28702114920129,
3.88447954358107E-14,
0.27249750863986,
5.46290443437236E-14,
0.264726638639975,
6.78441677837149E-14,
0.26255019738235,
6.9408020997308E-14,
0.265991798176442,
7.17360199020689E-14,
0.276282677760019,
7.10959069394335E-14,
0.296753112285647,
9.00703123196678E-14,
0.336168562098127,
1.06067932215126E-13,
0.4247305761149,
1.15444112602781E-13,
0.807553187405399,
1.22448925998775E-13,
6.93924084860242E-14,
1.40162187411974E-13,
7.67354929598341E-14,
1.57840754355654E-13,
8.28937612995517E-14,
1.66989685967955E-13,
8.62122873090954E-14,
1.70669034460502E-13,
8.24895707296491E-14,
1.75272990565745E-13,
8.48696113386893E-14,
1.71413230831696E-13,
7.5241896047018E-14,
1.7082515957334E-13,
6.72257388645292E-14,
1.70988223580082E-13,
6.16659501240235E-14,
  0,
1.12336355495568E-14,
  0,
1.12436102095437E-14,
0.821842206717152,
1.43903985949656E-14,
0.449122314319854,
2.1616389234147E-14,
0.358261049790113,
3.31453614554889E-14,
0.314038642908484,
3.50509551938494E-14,
0.287916349412353,
3.88239787540989E-14,
0.271550505698249,
5.03251953998252E-14,
0.261644959342123,
6.4101501884295E-14,
0.256801021442205,
7.09900888073989E-14,
0.256618428611851,
7.39529965043673E-14,
0.261495896417164,
7.17238768377371E-14,
0.272870546772145,
8.51974740756489E-14,
0.294196730450799,
1.03118902305965E-13,
0.334324578831601,
1.17171897184853E-13,
0.423533099038172,
1.23120263983978E-13,
0.807136535329921,
1.37608674455336E-13,
7.22182730283905E-14,
1.54262019824714E-13,
8.22866080829598E-14,
1.6872961361436E-13,
8.78620093347493E-14,
1.69933511706688E-13,
8.23334456168112E-14,
1.75328501716976E-13,
8.52495157799282E-14,
1.76548012320588E-13,
8.5337986677203E-14,
1.79252446219635E-13,
7.34742128249977E-14,
1.74381342699093E-13,
6.59628601740181E-14,
1.77637418663501E-13,
  0,
  0,
1.48969378499508E-14,
0.827878767874979,
1.30182323254679E-14,
0.457650952912595,
1.94002799935866E-14,
0.364970558847638,
3.10871120512424E-14,
0.318737653189131,
3.86904050464487E-14,
0.290714990400163,
4.32995653221191E-14,
0.27249750863986,
5.03807065510564E-14,
0.26065790976244,
5.96215785075849E-14,
0.253621704775728,
6.71390026907304E-14,
0.250731435264671,
7.52748557930616E-14,
0.251952966011277,
7.39963645912667E-14,
0.257885055063418,
8.55461534943203E-14,
0.270083562170474,
9.79182013249869E-14,
0.292079522193202,
1.14330420131203E-13,
0.332779475472074,
1.24941723633754E-13,
0.422519650013744,
1.37547959133677E-13,
0.806780612503494,
1.51099618928008E-13,
7.77971437271319E-14,
1.64963528948014E-13,
8.72236310955898E-14,
1.71586703179294E-13,
8.38999009156183E-14,
1.74405628827756E-13,
8.50864517731864E-14,
1.76386683037322E-13,
8.56051340925035E-14,
1.84199877573121E-13,
8.35356089856631E-14,
1.8262648338041E-13,
7.20812298737883E-14,
1.80829309859298E-13,
5.76396569362814E-14,
  0,
1.49403059368503E-14,
0.839212243709222,
1.62153276916932E-14,
0.471850148753609,
1.78641823556092E-14,
0.375597960670688,
2.85578852232682E-14,
0.326296470041122,
3.65315416805956E-14,
0.295794814566557,
4.66510510777063E-14,
0.275455925258226,
5.46290443437236E-14,
0.261644959342123,
5.96215785075849E-14,
0.252602880835114,
6.28715829398274E-14,
0.247473175301724,
7.14723419337204E-14,
0.245952941653093,
7.51204654036997E-14,
0.248201501254826,
8.76416994533002E-14,
0.254931795392591,
9.85895393101899E-14,
0.267771981528827,
1.0919216919536E-13,
0.290302727593518,
1.21564217026027E-13,
0.331469762969296,
1.39473502192011E-13,
0.421653115923148,
1.50988596625545E-13,
0.806473790361038,
1.61676227961038E-13,
8.26422263955351E-14,
1.67487551605561E-13,
8.31053975636209E-14,
1.7591310352838E-13,
8.66182126024739E-14,
1.75323297546548E-13,
8.53744158701986E-14,
1.83951812116057E-13,
8.37125507802128E-14,
1.87384829875015E-13,
8.20316037319913E-14,
1.88835058700931E-13,
6.37302710604359E-14,
1.83101797612828E-13,
  0,
0.866359712001398,
1.73485358023751E-14,
0.498197880285941,
2.15296530603482E-14,
0.393091483186099,
2.71397487816571E-14,
0.33820016874774,
3.42737990766118E-14,
0.303941486569901,
4.50195436485501E-14,
0.280817625247612,
5.82710962815369E-14,
0.264726638639975,
6.40737463086793E-14,
0.253621704775728,
6.28698482163514E-14,
0.246428625171477,
6.68423649763383E-14,
0.242629783707767,
7.14532599754847E-14,
0.242107447743733,
8.8934068442903E-14,
0.245130146157253,
1.00435285088629E-13,
0.252479495955585,
1.09516562485368E-13,
0.265829635227219,
1.16471068900559E-13,
0.288794618863735,
1.36010994133962E-13,
0.330348396586721,
1.52900261896072E-13,
0.420905525221452,
1.6167102379061E-13,
0.806207164282628,
1.64273109004576E-13,
7.85673609504656E-14,
1.71820890848551E-13,
8.58063620157168E-14,
1.76608727642247E-13,
8.67916849500716E-14,
1.82633422274314E-13,
8.33794838728252E-14,
1.86939005941689E-13,
8.21096662884102E-14,
1.93470239828741E-13,
7.36181948735037E-14,
1.90920196319055E-13,
5.52197176872937E-14,
0.999999999999997,
1.13476936181023E-14,
0.560245603153794,
2.25297211442488E-14,
0.424989644501844,
3.1115734988596E-14,
0.357631197250925,
3.3134953114633E-14,
0.316714324809382,
4.26811364029334E-14,
0.289395752875235,
5.67757646452449E-14,
0.270304879156318,
6.78302899959071E-14,
0.256801021442205,
6.71580846489661E-14,
0.247473175301724,
6.68354260824344E-14,
0.241564060103153,
6.67417510147317E-14,
0.238730194784899,
8.51332893070378E-14,
0.238956921324462,
1.01543773389778E-13,
0.242577594306135,
1.11497616694933E-13,
0.250416880921296,
1.16894341428697E-13,
0.264179229044382,
1.30931723796301E-13,
0.287501903410218,
1.49680615124659E-13,
0.329379817171594,
1.63513300122098E-13,
0.420255421512166,
1.64462193863457E-13,
0.805973807966012,
1.68252564658466E-13,
8.09352584951739E-14,
1.72497433004182E-13,
8.5863607890424E-14,
1.83922321816965E-13,
8.47221598432313E-14,
1.85575513289571E-13,
8.17575174227869E-14,
1.92948088062472E-13,
7.37101352177305E-14,
1.95458232932211E-13,
6.50833553716978E-14,
1.83852932877926E-13,
  0,
0.866325429916351,
1.79608931893949E-14,
0.497979327268461,
3.24480026181462E-14,
0.392630891445301,
3.7475231251527E-14,
0.337434129770942,
4.12976944308419E-14,
0.302798675512212,
5.43497538640914E-14,
0.279212245766554,
6.62013846519649E-14,
0.26255019738235,
7.09970277013028E-14,
0.250731435264671,
7.14740766571964E-14,
0.242629783707767,
6.66688926287407E-14,
0.23764680507446,
8.09456668360298E-14,
0.235534044203614,
9.79563652414583E-14,
0.236337010391821,
1.12727535639401E-13,
0.240429069147597,
1.18734883036709E-13,
0.248662790757856,
1.3091090711459E-13,
0.262763213156286,
1.44377565458598E-13,
0.286384204273408,
1.59927626697254E-13,
0.328536679007412,
1.65539457142039E-13,
0.419686089867887,
1.67903885239795E-13,
0.80576825889295,
1.6904880273394E-13,
8.12527128912777E-14,
1.79708678493817E-13,
8.38773495104306E-14,
1.86732573848047E-13,
8.31314184157605E-14,
1.91447552255752E-13,
7.33146182652078E-14,
1.94759139371392E-13,
6.51111109473135E-14,
1.88189741567868E-13,
5.59691182289157E-14,
  0,
1.36969428854439E-14,
0.839078243550044,
2.83115544896795E-14,
0.471240667511765,
3.91570456614865E-14,
0.374427415529464,
4.57177698476308E-14,
0.324436678367385,
5.32889704585315E-14,
0.293091375681759,
6.3874253108942E-14,
0.271716065823307,
6.94357765729237E-14,
0.256618428611851,
7.5316489156485E-14,
0.245952941653093,
7.14532599754847E-14,
0.238730194784899,
8.09474015595057E-14,
0.234435742400711,
9.33159799432204E-14,
0.232875259985668,
1.08951042632199E-13,
0.234130651786542,
1.19720205971063E-13,
0.238600745768499,
1.32798286256453E-13,
0.247156699695766,
1.44455628015017E-13,
0.261537903409587,
1.54435492172311E-13,
0.285410405800606,
1.62139399129124E-13,
0.32779763172175,
1.69404421046515E-13,
0.419184330041138,
1.68479813433819E-13,
0.805586155617856,
1.76043207789078E-13,
7.90426751828832E-14,
1.82276069238263E-13,
8.21807899509253E-14,
1.92453691871819E-13,
7.46035178078586E-14,
1.93258603564672E-13,
6.46566133966076E-14,
1.87381360428063E-13,
5.60124863158151E-14,
1.86744716912379E-13,
  0,
1.06147729495021E-14,
2.46742730414251E-14,
0.827576912726422,
3.51298851120063E-14,
0.456465927468725,
4.79226033855973E-14,
0.36281595424742,
5.77090458753204E-14,
0.315414156866684,
6.31144442264642E-14,
0.285966232864133,
6.73541084017515E-14,
0.265991798176442,
7.39460576104634E-14,
0.251952966011277,
7.51308737445555E-14,
0.242107447743732,
8.51593101591774E-14,
0.235534044203614,
9.33350619014561E-14,
0.231764243536898,
1.04636785347445E-13,
0.230635483645516,
1.1596626436905E-13,
0.232252272324725,
1.34026470477444E-13,
0.237030035827607,
1.46497397546241E-13,
0.24585259818953,
1.54907336957777E-13,
0.26046957938467,
1.56891860614294E-13,
0.284556169076941,
1.66200386786386E-13,
0.327145780938663,
1.7023882303846E-13,
0.418739589869886,
1.75907899357952E-13,
0.805423977197634,
1.78579373510956E-13,
7.74311170737008E-14,
1.88083923435833E-13,
7.35661531692244E-14,
1.941519861548E-13,
6.5968064344446E-14,
1.8577847593626E-13,
5.54885998260701E-14,
1.85788884277116E-13,
4.68097782757582E-14,
  0,
2.28571502003394E-14,
1.84891164878298E-14,
3.2315296272234E-14,
0.821298152718582,
4.43464709398711E-14,
0.447155123619689,
6.00752086965528E-14,
0.354808350843284,
6.75908981562223E-14,
0.308817002277937,
6.63982757664883E-14,
0.280537950676502,
7.1727346284689E-14,
0.261495896417164,
7.39391187165594E-14,
0.248201501254826,
8.89548851246147E-14,
0.238956921324462,
9.79234054954148E-14,
0.232875259985668,
1.04595151984022E-13,
0.229513530208404,
1.11546188952261E-13,
0.228728148940368,
1.30282937216286E-13,
0.230637925791864,
1.47389045412893E-13,
0.235669310845049,
1.56272564333371E-13,
0.244714924848619,
1.5694563704205E-13,
0.259531825387675,
1.60592025788553E-13,
0.283802202986518,
1.66510902288586E-13,
0.326567597604378,
1.77068429363381E-13,
0.41834334155967,
1.78024261998644E-13,
0.805278852806867,
1.84229367872213E-13,
6.87991330572402E-14,
1.89624357882501E-13,
6.49150871945281E-14,
1.86585122352589E-13,
5.68815827772795E-14,
1.84071508035899E-13,
4.63414029372444E-14,
1.89117818627516E-13,
1.69224443485883E-14,
1.92701757328884E-14,
3.15433443254243E-14,
2.39990319284011E-14,
4.18198461971109E-14,
0.817374508322892,
5.63143282006351E-14,
0.440789695484648,
6.9933642210529E-14,
0.348982773364084,
7.1202592433206E-14,
0.303806384311046,
7.12433584348915E-14,
0.276282677760019,
7.17047948795013E-14,
0.257885055063418,
8.76972106045315E-14,
0.245130146157253,
1.01571528965394E-13,
0.236337010391821,
1.08954512079151E-13,
0.230635483645516,
1.11546188952261E-13,
0.227596713912159,
1.25708471410135E-13,
0.227088536499349,
1.43560510701413E-13,
0.229238914415693,
1.5779044737485E-13,
0.234481722641751,
1.58852098142148E-13,
0.243715789437618,
1.60585086894649E-13,
0.258703676252211,
1.60855703756901E-13,
0.283133036209494,
1.73274589121419E-13,
0.326052130850828,
1.79252446219635E-13,
0.417988625198996,
1.83545886822678E-13,
0.805148420502338,
1.85910314920434E-13,
5.99936766931819E-14,
1.82116474678473E-13,
5.5793911157842E-14,
1.84862541940944E-13,
4.75765260521399E-14,
1.87350135405495E-13,
3.93469978821059E-14,
1.27792741666521E-14,
2.91906256111307E-14,
2.56674022314218E-14,
4.18406628788226E-14,
3.14089032560361E-14,
5.47617506896358E-14,
0.814708280141501,
6.6715730162592E-14,
0.436188810381527,
7.36572261517132E-14,
0.344575740418694,
7.59028256913652E-14,
0.299888339873646,
7.11913167306122E-14,
0.272870546772145,
8.55461534943203E-14,
0.254931795392591,
1.0049079623986E-13,
0.242577594306135,
1.12753556491541E-13,
0.234130651786542,
1.1593156989953E-13,
0.228728148940368,
1.25760513114415E-13,
0.22594882408136,
1.39154313072432E-13,
0.225667338410944,
1.53821400061815E-13,
0.228017537635961,
1.59880789163402E-13,
0.233438346663097,
1.62562671657263E-13,
0.2428330333308,
1.61108973384394E-13,
0.257968297851423,
1.67758168467813E-13,
0.282536129005644,
1.75791672885062E-13,
0.325590430488028,
1.84885093346132E-13,
0.4176697096032,
1.85349999237694E-13,
0.805030720998163,
1.77958342506557E-13,
5.1007809087622E-14,
1.80275933070462E-13,
4.66293670342566E-14,
1.87988513644655E-13,
4.06029376787131E-14,
1.88793425337508E-13,
1.6643153868956E-14,
2.21073159778484E-14,
4.10574352294191E-14,
3.37490452251288E-14,
5.52665552211451E-14,
4.35094668627123E-14,
6.5449382025129E-14,
0.812789859198183,
7.09102915275039E-14,
0.432725669592424,
7.86384846129806E-14,
0.341140674112146,
7.61959939588053E-14,
0.296753112285647,
8.51731879469853E-14,
0.270083562170474,
9.85270892650547E-14,
0.252479495955585,
1.1141261524461E-13,
0.240429069147597,
1.19775717122295E-13,
0.232252272324725,
1.30270794151954E-13,
0.227088536499349,
1.39154313072432E-13,
0.224520354363904,
1.49522755288345E-13,
0.224426366822575,
1.55927354361651E-13,
0.226944183979934,
1.63724936386167E-13,
0.232516184477169,
1.63018903931444E-13,
0.242048847277836,
1.67938579709315E-13,
0.257312031040435,
1.70254435549744E-13,
0.282001220226265,
1.81550954825305E-13,
0.325175116970675,
1.86571244564782E-13,
0.417381836877202,
1.77720685390348E-13,
0.80492411676842,
1.76258313500099E-13,
4.16749967868668E-14,
1.83460885372355E-13,
3.9569042487031E-14,
1.89438742470571E-13,
4.11025380397945E-14,
1.26242332559867E-14,
3.25798416023204E-14,
3.12206857588926E-14,
5.54504359095986E-14,
4.63388008520305E-14,
6.65032265367849E-14,
4.61826757391925E-14,
6.95259821936745E-14,
0.811350867466097,
7.62220148109449E-14,
0.43003701521627,
7.88796111761414E-14,
0.338399110663084,
9.0052965084908E-14,
0.294196730450799,
9.79737124762181E-14,
0.267771981528827,
1.09518297208844E-13,
0.250416880921296,
1.18776516400132E-13,
0.238600745768499,
1.3402820520092E-13,
0.230637925791864,
1.43557041254461E-13,
0.225667338410944,
1.49524490011821E-13,
0.223272958272604,
1.51583606777805E-13,
0.223335616895817,
1.59939769761586E-13,
0.225995295984784,
1.64193311724681E-13,
0.231696738714581,
1.69655955950532E-13,
0.24134876853833,
1.70297803636643E-13,
0.256723687665973,
1.75691058923455E-13,
0.281519840175609,
1.82721893171589E-13,
0.324800056856257,
1.78825704244545E-13,
0.417121027636773,
1.75640751942652E-13,
0.804827229731901,
1.79252446219635E-13,
3.46910000725842E-14,
1.8474805019153E-13,
4.00339483785928E-14,
1.98903393755501E-13,
2.08895400977127E-14,
2.48191224516692E-14,
4.88324658487471E-14,
4.47107628698262E-14,
6.74182931703626E-14,
4.93953836167016E-14,
7.10733555342458E-14,
4.64203328554014E-14,
7.50033715690712E-14,
0.81023675658358,
7.65464081009526E-14,
0.427898038902169,
9.3420063351779E-14,
0.336168562098127,
1.03146657881581E-13,
0.292079522193202,
1.09223394217928E-13,
0.265829635227219,
1.16948117856452E-13,
0.248662790757856,
1.32744509828697E-13,
0.237030035827607,
1.47444556564125E-13,
0.229238914415693,
1.53807522274008E-13,
0.224426366822575,
1.51587076224757E-13,
0.222176502804215,
1.55413876212762E-13,
0.222371210550307,
1.60137528237847E-13,
0.225151917268285,
1.70941386046231E-13,
0.230964978107785,
1.71980485408341E-13,
0.240720941511028,
1.75488096276766E-13,
0.256194024605304,
1.77033734893861E-13,
0.281084942349449,
1.74898290294934E-13,
0.324460114871494,
1.76796077777652E-13,
0.416883930796832,
1.78676518025611E-13,
0.80473889274646,
1.80713083386408E-13,
3.51003948129147E-14,
1.94119026408757E-13,
3.31436267320129E-14,
1.60184365771698E-14,
4.19707671395209E-14,
3.97737398571962E-14,
6.1928760730634E-14,
4.83328654876658E-14,
7.24368481863635E-14,
4.99921284924376E-14,
7.6518652525337E-14,
4.25250112900954E-14,
7.54066947772358E-14,
0.809352379289016,
9.14494174830693E-14,
0.426162333021363,
1.06144260048069E-13,
0.334324578831601,
1.14276643703448E-13,
0.290302727593518,
1.16413823025852E-13,
0.264179229044382,
1.3092825434935E-13,
0.247156699695766,
1.46528622568809E-13,
0.235669310845049,
1.57762691799235E-13,
0.228017537635961,
1.55977661342455E-13,
0.223335616895817,
1.55417345659714E-13,
0.221207005337435,
1.55606430518596E-13,
0.221513927788777,
1.66814478896882E-13,
0.224398636611393,
1.73146219584197E-13,
0.230308573758576,
1.77562825554034E-13,
0.24015556470876,
1.7712914468504E-13,
0.255715345616833,
1.69357583512664E-13,
0.280690621664533,
1.73049075069542E-13,
0.324150962382364,
1.79693065982534E-13,
0.416667706523814,
1.80581244402234E-13,
0.804658111487934,
1.90198551353049E-13,
2.82100731663348E-14,
1.96172939004313E-13,
2.75435056706907E-14,
3.47378376064356E-14,
5.72797018150162E-14,
4.42215708496008E-14,
6.78224837402652E-14,
4.93320662098284E-14,
7.84971046496885E-14,
4.63466071076724E-14,
7.75542824404951E-14,
4.87995061027036E-14,
8.99350038885416E-14,
0.808636037732733,
1.04282901758346E-13,
0.4247305761149,
1.17173631908329E-13,
0.332779475472074,
1.21529522556507E-13,
0.288794618863735,
1.30931723796301E-13,
0.262763213156286,
1.44490322484536E-13,
0.24585259818953,
1.56352361613266E-13,
0.234481722641751,
1.59835686353027E-13,
0.226944183979934,
1.59898136398162E-13,
0.222371210550307,
1.55609899965548E-13,
0.220345159862095,
1.62484609100844E-13,
0.220748138913173,
1.69059211074796E-13,
0.22372280826961,
1.78563760999673E-13,
0.229717327406231,
1.78787540328074E-13,
0.239644471679893,
1.68955127666237E-13,
0.255281196320147,
1.67286323682347E-13,
0.280331896478013,
1.75907899357952E-13,
0.323868927917158,
1.80789411219351E-13,
0.416469934156993,
1.89372822978484E-13,
0.804584034223365,
1.91933274829026E-13,
2.33250918579841E-14,
2.39964298431872E-14,
4.90172138989386E-14,
4.09169226278649E-14,
6.46158473949221E-14,
4.58990484508703E-14,
7.4423106566357E-14,
4.59554269638396E-14,
7.96949312098505E-14,
5.26688068158698E-14,
9.21537152143159E-14,
5.75442471451026E-14,
1.03108493965109E-13,
0.808046028210886,
1.15464929284492E-13,
0.423533099038172,
1.24948662527657E-13,
0.331469762969296,
1.36054362220861E-13,
0.287501903410218,
1.44375830735122E-13,
0.261537903409587,
1.54900398063873E-13,
0.244714924848619,
1.58935364868995E-13,
0.233438346663097,
1.63717997492263E-13,
0.225995295984784,
1.60012628147577E-13,
0.221513927788777,
1.62508895229507E-13,
0.219575265350667,
1.64748423236993E-13,
0.220061015782788,
1.74651959561345E-13,
0.223113967954207,
1.7978500632676E-13,
0.229182737831888,
1.71068020859977E-13,
0.239180809641063,
1.67085095759134E-13,
0.254886127956868,
1.70148617417709E-13,
0.280004538243182,
1.771464919198E-13,
0.323610879407234,
1.90104876285346E-13,
0.416288539132336,
1.91169996499596E-13,
0.804515927646108,
1.95062715979688E-13,
2.9056835063046E-14,
3.53085616300319E-14,
5.8711716044435E-14,
4.35250793739961E-14,
7.20612805538146E-14,
4.28363941540333E-14,
7.60572160807271E-14,
5.24719157013465E-14,
9.47367184700454E-14,
6.15237027989934E-14,
1.05677619433031E-13,
6.69533872788008E-14,
1.14944512241699E-13,
0.807553187405399,
1.23144550112642E-13,
0.422519650013744,
1.39372888230405E-13,
0.330348396586721,
1.49675410954231E-13,
0.286384204273408,
1.54435492172311E-13,
0.26046957938467,
1.57004617640233E-13,
0.243715789437618,
1.62548793869455E-13,
0.232516184477169,
1.64217597853344E-13,
0.225151917268285,
1.66752028851747E-13,
0.220748138913173,
1.64755362130897E-13,
0.218884434080312,
1.70179842440277E-13,
0.219441940811206,
1.75899225740572E-13,
0.22256338967697,
1.71852115871118E-13,
0.228697668115878,
1.6890655540891E-13,
0.238758790351614,
1.70127800735997E-13,
0.254525512580629,
1.714635378125E-13,
0.279704937147343,
1.86468895879699E-13,
0.32337413060603,
1.92176136115663E-13,
0.416121734512874,
1.94434746081384E-13,
0.804453157408992,
1.67775949383442E-14,
4.51847760596369E-14,
3.97043509181572E-14,
6.7616919008362E-14,
4.10504963355152E-14,
7.42374911544275E-14,
4.97119706510674E-14,
9.14407438656895E-14,
6.14681916477622E-14,
1.08501749251921E-13,
7.1052538852534E-14,
1.17473739069673E-13,
6.82839201848751E-14,
1.22476681574391E-13,
0.807136535329921,
1.37520203558061E-13,
0.421653115923148,
1.52908935513452E-13,
0.329379817171594,
1.59969260060677E-13,
0.285410405800606,
1.56808593887448E-13,
0.259531825387676,
1.60585086894649E-13,
0.2428330333308,
1.62991148355829E-13,
0.231696738714581,
1.70917099917567E-13,
0.224398636611393,
1.69086966650411E-13,
0.220061015782788,
1.70127800735997E-13,
0.218261998362646,
1.71328229381373E-13,
0.218882058367807,
1.68039193670921E-13,
0.222063745498988,
1.69756569912138E-13,
0.228256087518651,
1.71484354494211E-13,
0.238373495058784,
1.71140879245968E-13,
0.254195397140426,
1.80515324910147E-13,
0.279429995216493,
1.88005860879414E-13,
0.323156366121297,
1.95159860494343E-13,
0.415967973850491,
1.99635447062363E-13,
2.31321038712817E-14,
2.50160135661925E-14,
5.6466983866521E-14,
3.80867212768088E-14,
7.07142677747186E-14,
4.82365883347491E-14,
9.01015373422354E-14,
5.89467710754299E-14,
1.05597822153136E-13,
7.12555014992233E-14,
1.20504300982205E-13,
7.25617482766339E-14,
1.25231422454242E-13,
6.93854695921203E-14,
1.37610409178812E-13,
0.806780612503494,
1.50974718837737E-13,
0.420905525221452,
1.63511565398622E-13,
0.328536679007412,
1.62253890878539E-13,
0.284556169076941,
1.60621516087645E-13,
0.258703676252211,
1.61049992786211E-13,
0.242048847277836,
1.69657690674008E-13,
0.230964978107785,
1.73134076519865E-13,
0.22372280826961,
1.74658898455249E-13,
0.219441940811206,
1.71321290487469E-13,
0.217699060176815,
1.63345031944928E-13,
0.218373930244528,
1.65766705917392E-13,
0.221608841462306,
1.72615394200548E-13,
0.22785286925666,
1.7295540000184E-13,
0.238020720372018,
1.80300219199125E-13,
0.253892387286068,
1.82260456726979E-13,
0.27917704059196,
1.90947951894671E-13,
0.322955580907457,
2.00409133732649E-13,
0.415825912914326,
1.21343907144578E-14,
3.98361899023314E-14,
2.47891984717086E-14,
6.09052738798077E-14,
4.58591498109229E-14,
8.71993449669262E-14,
5.78755793290142E-14,
1.04608162410091E-13,
6.89101553597027E-14,
1.17872725469148E-13,
7.27178733894718E-14,
1.28624541573252E-13,
7.37118699412065E-14,
1.40177799923258E-13,
7.22200077518664E-14,
1.51148191185335E-13,
0.806473790361038,
1.61726534941842E-13,
0.420255421512165,
1.65598437740222E-13,
0.32779763172175,
1.66231611808954E-13,
0.283802202986518,
1.60793253711766E-13,
0.257968297851423,
1.67942049156267E-13,
0.24134876853833,
1.71994363196148E-13,
0.230308573758576,
1.78501310954537E-13,
0.223113967954207,
1.75847184036293E-13,
0.218882058367807,
1.63372787520544E-13,
0.217188145244019,
1.61516633401249E-13,
0.217911268189876,
1.68674102463129E-13,
0.221193410613788,
1.73805414505068E-13,
0.227483630617667,
1.82128617742805E-13,
0.237696855442335,
1.82055759356814E-13,
0.253613554107769,
1.85296222809939E-13,
0.278943758274615,
1.96471311442181E-13,
0.322770031087544,
2.02796113235593E-13,
2.2886640499431E-14,
1.46037695825108E-14,
4.64264043875673E-14,
3.32719962692352E-14,
7.82551107247897E-14,
5.58277382656236E-14,
1.02326133677444E-13,
6.8067079750378E-14,
1.17348838979403E-13,
7.05858982374963E-14,
1.26149091173033E-13,
7.40952438293974E-14,
1.43624695470024E-13,
7.67146762781223E-14,
1.54235998972574E-13,
7.77416325759006E-14,
1.61662350173231E-13,
0.806207164282628,
1.64424029946986E-13,
0.419686089867887,
1.69376665470899E-13,
0.327145780938663,
1.66510902288586E-13,
0.283133036209494,
1.67761637914765E-13,
0.257312031040435,
1.70297803636643E-13,
0.240720941511028,
1.77559356107082E-13,
0.229717327406231,
1.79757250751145E-13,
0.22256338967697,
1.68046132564825E-13,
0.218373930244528,
1.61447244462209E-13,
0.21672293445603,
1.64181168660349E-13,
0.217488724215289,
1.6981208106337E-13,
0.220812949296113,
1.83027204503361E-13,
0.22714460548088,
1.83759257810223E-13,
0.237398783316909,
1.85320508938602E-13,
0.253356358731234,
1.90802235122689E-13,
0.278728133785883,
1.98403793394419E-13,
0.322598193722219,
  0,
3.45062520223927E-14,
2.40233180570648E-14,
6.51015699681956E-14,
4.37774816397507E-14,
9.4094870783934E-14,
6.64312355125318E-14,
1.15442377879305E-13,
7.00203783843278E-14,
1.2592184239768E-13,
7.20742909798844E-14,
1.41499659211952E-13,
7.72420322148193E-14,
1.57873714101697E-13,
8.22900775299118E-14,
1.64961794224538E-13,
8.26543694598669E-14,
1.64269639557624E-13,
0.805973807966012,
1.67890007451987E-13,
0.419184330041138,
1.70211067462844E-13,
0.326567597604378,
1.73302344697035E-13,
0.282536129005644,
1.70226679974128E-13,
0.256723687665973,
1.7549503517067E-13,
0.24015556470876,
1.7875458058203E-13,
0.229182737831888,
1.71911096469302E-13,
0.222063745498988,
1.65770175364344E-13,
0.217911268189876,
1.6423667981158E-13,
0.216298053296795,
1.65378127858773E-13,
0.217101724696496,
1.78926318206152E-13,
0.220463586568646,
1.84838255812281E-13,
0.226832541876924,
1.86579918182161E-13,
0.237123801129779,
1.90639171115947E-13,
0.253118590930887,
1.9249185578829E-13,
0.27852840703986,
1.91666127413725E-13,
1.70206730654154E-14,
1.56541446472147E-14,
5.52214524107697E-14,
3.52226928179711E-14,
8.18694070869874E-14,
5.48016493295833E-14,
1.07853830033644E-13,
6.86256607096425E-14,
1.24462939954384E-13,
7.17394893490209E-14,
1.41484046700668E-13,
7.5318223879961E-14,
1.55890925168656E-13,
8.28972307465037E-14,
1.68731348337836E-13,
8.7211488031258E-14,
1.67550001650696E-13,
7.85673609504656E-14,
1.68252564658466E-13,
0.80576825889295,
1.68481548157295E-13,
0.418739589869886,
1.77016387659101E-13,
0.326052130850828,
1.75854122930197E-13,
0.282001220226265,
1.75729222839927E-13,
0.256194024605304,
1.77127409961564E-13,
0.239644471679893,
1.71061081966073E-13,
0.228697668115877,
1.69756569912138E-13,
0.221608841462306,
1.6872961361436E-13,
0.217488724215289,
1.65353841730109E-13,
0.215908905230451,
1.74516651130219E-13,
0.216746338017881,
1.80803289007159E-13,
0.220141979239281,
1.87690141206787E-13,
0.226544619068818,
1.91954091510738E-13,
0.236869555091137,
1.9249185578829E-13,
0.252898318834269,
1.85948478836906E-13,
0.278343034347106,
1.3385560021506E-14,
4.21268922523588E-14,
2.78787409824233E-14,
7.34395183554781E-14,
4.67828900618805E-14,
9.63638890905116E-14,
5.74046019052865E-14,
1.17404350130634E-13,
7.05980413018281E-14,
1.40387701463851E-13,
7.5092709828084E-14,
1.56239604587327E-13,
8.11243433540554E-14,
1.66951522051484E-13,
8.79244593798845E-14,
1.71572825391486E-13,
8.3098458669717E-14,
1.71848646424166E-13,
8.09352584951739E-14,
1.69021047158324E-13,
0.805586155617856,
1.75841979865865E-13,
0.41834334155967,
1.79217751750116E-13,
0.325590430488028,
1.81575240953968E-13,
0.281519840175609,
1.77026795999957E-13,
0.255715345616833,
1.69003699923564E-13,
0.239180809641063,
1.68851044257678E-13,
0.228256087518651,
1.72629271988356E-13,
0.221193410613788,
1.69756569912138E-13,
0.217101724696496,
1.74565223387546E-13,
0.215551538766615,
1.76140352303733E-13,
0.216419168153672,
1.83537213205298E-13,
0.219845226870545,
1.92890842187765E-13,
0.226278379977877,
1.94025351341054E-13,
0.236633987193163,
1.85480103498392E-13,
0.252693847465983,
1.76841180588028E-13,
3.16478614148519E-14,
2.85526810528403E-14,
6.27674995312688E-14,
4.02239005992122E-14,
8.90121309993219E-14,
4.97935026544383E-14,
1.06499878360644E-13,
5.9615506975419E-14,
1.3373503693348E-13,
7.41646327684364E-14,
1.55391324807574E-13,
8.09890349229292E-14,
1.67501429393369E-13,
8.62296345438551E-14,
1.69916164471928E-13,
8.39016356390943E-14,
1.7591310352838E-13,
8.58028925687648E-14,
1.72480085769422E-13,
8.11972017400464E-14,
1.76070963364694E-13,
0.805423977197634,
1.78081507873351E-13,
0.417988625198996,
1.84860807217468E-13,
0.325175116970675,
1.82718423724637E-13,
0.281084942349449,
1.69364522406568E-13,
0.255281196320147,
1.67126729122558E-13,
0.238758790351614,
1.71484354494211E-13,
0.22785286925666,
1.73805414505068E-13,
0.220812949296113,
1.78950604334815E-13,
0.216746338017881,
1.76181985667156E-13,
0.215222540568466,
1.7922469064402E-13,
0.216117268482323,
1.88862814276547E-13,
0.219570802492833,
1.94910060313802E-13,
0.226031675764885,
1.87280746466456E-13,
0.236415291259675,
1.76580972066631E-13,
0.252503684384719,
1.96032426402759E-14,
5.92152195333373E-14,
4.24243973284888E-14,
7.9878811898304E-14,
4.37705427458468E-14,
9.99521646005697E-14,
5.23366072702203E-14,
1.2339088084623E-13,
6.33555707896249E-14,
1.49174075869674E-13,
8.02292260404514E-14,
1.66960195668864E-13,
8.62435123316629E-14,
1.70679442801358E-13,
8.23577317454749E-14,
1.74405628827756E-13,
8.65904570268583E-14,
1.76574033172727E-13,
8.5943405170319E-14,
1.79736434069433E-13,
7.90183890542195E-14,
1.78546413764913E-13,
0.805278852806867,
1.83486906224495E-13,
0.4176697096032,
1.86578183458685E-13,
0.324800056856257,
1.74929515317501E-13,
0.280690621664533,
1.67314079257963E-13,
0.254886127956868,
1.70100045160382E-13,
0.238373495058784,
1.72979686130503E-13,
0.227483630617667,
1.82999448927745E-13,
0.220463586568646,
1.80775533431543E-13,
0.216419168153672,
1.79266324007443E-13,
0.214918948878286,
1.84331716557296E-13,
0.215838071515178,
1.91027749174566E-13,
0.219316495764246,
1.88092597053213E-13,
0.225802620109612,
1.78131814854154E-13,
0.236211876497997,
1.72480085769422E-13,
3.67132539647042E-14,
3.78946006518444E-14,
7.93774768137467E-14,
4.69312089190765E-14,
9.19368747798188E-14,
4.67343178045532E-14,
1.17503229368765E-13,
5.63871865866261E-14,
1.39254927034038E-13,
6.96543517308967E-14,
1.61065605297495E-13,
8.56328896681191E-14,
1.70394948151298E-13,
8.24479373662257E-14,
1.75302480864836E-13,
8.50829823262345E-14,
1.75316358652644E-13,
8.68194405256872E-14,
1.83866810665734E-13,
8.38495939348149E-14,
1.82276069238263E-13,
7.74744851606002E-14,
1.84229367872213E-13,
0.805148420502338,
1.8534306034379E-13,
0.417381836877202,
1.78881215395776E-13,
0.324460114871494,
1.72986625024407E-13,
0.280331896478013,
1.7023882303846E-13,
0.254525512580629,
1.71078429200833E-13,
0.238020720372018,
1.82135556636709E-13,
0.22714460548088,
1.84824378024473E-13,
0.220141979239281,
1.83488640947971E-13,
0.216117268482323,
1.84307430428632E-13,
0.21463818292472,
1.86517468137026E-13,
0.215579331238523,
1.84106202505419E-13,
0.21908036606453,
1.7903040161471E-13,
0.225589551280678,
1.74114195283792E-13,
0.236022337112807,
2.41317382743134E-14,
6.5149708544654E-14,
4.42857556182119E-14,
9.33090410493165E-14,
5.04691774483312E-14,
1.10327545710387E-13,
5.1082402197089E-14,
1.33887692599366E-13,
6.28733176633034E-14,
1.51597484565613E-13,
7.5169037661027E-14,
1.64784852429989E-13,
8.19674189633801E-14,
1.75272990565745E-13,
8.52425768860243E-14,
1.76379744143418E-13,
8.53605380823907E-14,
1.8266117784993E-13,
8.47637932066547E-14,
1.86723900230668E-13,
8.21669121631174E-14,
1.88070045648026E-13,
6.8813010845048E-14,
1.85922457984766E-13,
0.805030720998163,
1.77665174239117E-13,
0.417121027636773,
1.76851588928884E-13,
0.324150962382364,
1.75966879956135E-13,
0.280004538243182,
1.71432312789932E-13,
0.254195397140426,
1.80314096986933E-13,
0.237696855442335,
1.83703746658992E-13,
0.226832541876924,
1.87683202312883E-13,
0.219845226870545,
1.88848936488739E-13,
0.215838071515178,
1.86545223712642E-13,
0.214377984997762,
1.79505715847128E-13,
0.215339075524865,
1.74811554121135E-13,
0.218860703571265,
1.74957270893117E-13,
0.225391000502912,
1.71768849144271E-13,
3.85412188275147E-14,
3.57283647112183E-14,
8.25129894965748E-14,
4.88732318504326E-14,
1.12976468458204E-13,
5.51876253029882E-14,
1.27486562973012E-13,
5.7818333454307E-14,
1.46696890745979E-13,
6.85545370471274E-14,
1.55615104135975E-13,
7.1651018451746E-14,
1.69897082513693E-13,
8.48418557630737E-14,
1.76549747044064E-13,
8.5639828562023E-14,
1.83924056540441E-13,
8.33812185963012E-14,
1.85539084096575E-13,
8.31036628401449E-14,
1.92446752977915E-13,
7.35887045744121E-14,
1.89653848181592E-13,
6.00179628218456E-14,
1.78006914763884E-13,
0.80492411676842,
1.75713610328643E-13,
0.416883930796832,
1.79772863262428E-13,
0.323868927917158,
1.77097919662472E-13,
0.279704937147343,
1.80515324910147E-13,
0.253892387286068,
1.82055759356814E-13,
0.237398783316909,
1.86579918182161E-13,
0.226544619068818,
1.9282839214263E-13,
0.219570802492833,
1.91027749174566E-13,
0.215579331238523,
1.79484899165416E-13,
0.214136372637008,
1.70436581514721E-13,
0.215115566636529,
1.70852915148956E-13,
0.218655996790589,
1.72643149776164E-13,
0.225205665445947,
1.7125623835712E-14,
6.45325806680752E-14,
4.2184138127066E-14,
1.04184889881953E-13,
5.42395989233668E-14,
1.31131216996039E-13,
6.22522866589037E-14,
1.40871689313649E-13,
6.36470043335891E-14,
1.51158599526191E-13,
6.50972331595057E-14,
1.61015298316691E-13,
7.46139261487144E-14,
1.7141149610822E-13,
8.5337986677203E-14,
1.84206816467025E-13,
8.37472452497323E-14,
1.86963292070352E-13,
8.17713952105947E-14,
1.91471838384416E-13,
7.46035178078586E-14,
1.94179741730416E-13,
6.48873316189125E-14,
1.82001982929059E-13,
5.1007809087622E-14,
1.76317294098283E-13,
0.8048272297319,
1.78690395813419E-13,
0.416667706523814,
1.80785941772399E-13,
0.323610879407234,
1.86468895879699E-13,
0.279429995216493,
1.82246578939171E-13,
0.253613554107769,
1.8520948663614E-13,
0.237123801129779,
1.9192286648817E-13,
0.226278379977877,
1.94916999207706E-13,
0.219316495764246,
1.84106202505419E-13,
0.215339075524865,
1.70405356492154E-13,
0.213911598948124,
1.66339164664464E-13,
0.214907268273957,
1.68597774630186E-13,
0.218464905338339,
1.62859309371655E-13,
3.5976863849152E-14,
2.76358796957865E-14,
8.97762766904897E-14,
4.86390441811757E-14,
1.23813286012631E-13,
6.18238099603374E-14,
1.45355949499049E-13,
6.84764744907085E-14,
1.45843406795798E-13,
6.04568478612677E-14,
1.56871043932583E-13,
6.82180006927879E-14,
1.62777777368284E-13,
7.52245488122583E-14,
1.79248976772683E-13,
8.35078534100475E-14,
1.87357074299399E-13,
8.21443607579297E-14,
1.9296196585028E-13,
7.33284960530156E-14,
1.93227378542105E-13,
6.60079629843935E-14,
1.86599000140397E-13,
5.58459528621214E-14,
1.80275933070462E-13,
4.16888745746746E-14,
1.79252446219635E-13,
0.80473889274646,
1.80688797257744E-13,
0.416469934156993,
1.90097937391442E-13,
0.32337413060603,
1.8803361645503E-13,
0.27917704059196,
1.85292753362987E-13,
0.253356358731234,
1.90639171115947E-13,
0.236869555091137,
1.9405310691667E-13,
0.226031675764885,
1.88120352628829E-13,
0.21908036606453,
1.74870534719318E-13,
0.215115566636529,
1.66342634111416E-13,
0.213702119493424,
1.64073615804838E-13,
0.214712817948665,
1.5871332026407E-13,
0.218286237016118,
1.47646651849076E-14,
6.97731802890011E-14,
3.5675455645201E-14,
1.11607771635658E-13,
5.68928584798734E-14,
1.39175129754143E-13,
6.83966772108136E-14,
1.50933085474314E-13,
6.5449382025129E-14,
1.5196524594252E-13,
6.36973113143924E-14,
1.58891996782096E-13,
6.89118900831787E-14,
1.70821690126388E-13,
7.34707433780457E-14,
1.82598727804795E-13,
8.20316037319913E-14,
1.93511873192165E-13,
7.36806449186389E-14,
1.94786894947008E-13,
6.46704911844154E-14,
1.858044967884E-13,
5.69128077998471E-14,
1.84888562793084E-13,
4.66293670342566E-14,
1.8343312979674E-13,
3.46354889213529E-14,
1.8073390006812E-13,
0.804658111487934,
1.8938323131934E-13,
0.416288539132336,
1.92120624964431E-13,
0.323156366121297,
1.90941013000767E-13,
0.278943758274614,
1.90712029501938E-13,
0.253118590930887,
1.92512672470002E-13,
0.236633987193163,
1.87221765868273E-13,
0.225802620109612,
1.79044279402518E-13,
0.218860703571265,
1.70845976255052E-13,
0.214907268273957,
1.6409443248655E-13,
0.213506564531332,
1.54244672589954E-13,
0.214531003712516,
1.56881452273439E-13,
4.4581092289997E-14,
2.62342231271973E-14,
9.54826495647154E-14,
4.48920414730658E-14,
1.28572499868973E-13,
6.39844080496665E-14,
1.45609219126541E-13,
6.56939780352417E-14,
1.57608301409873E-13,
6.89205637005585E-14,
1.54348755998512E-13,
6.44918146663898E-14,
1.67249894489352E-13,
6.72240041410532E-14,
1.74388281592996E-13,
7.20742909798844E-14,
1.88855875382643E-13,
7.36320726613116E-14,
1.95499866295634E-13,
6.51596832046408E-14,
1.87422993791486E-13,
5.54885998260701E-14,
1.84106202505419E-13,
4.7573056605188E-14,
1.8801626922027E-13,
3.95447563583673E-14,
1.84758458532386E-13,
3.51003948129147E-14,
1.90202020800001E-13,
0.804584034223365,
1.91173465946548E-13,
0.416121734512874,
1.95104349343111E-13,
0.322955580907457,
1.96443555866566E-13,
0.278728133785883,
1.9249185578829E-13,
0.252898318834269,
1.854939812862E-13,
0.236415291259675,
1.78131814854154E-13,
0.225589551280678,
1.74957270893117E-13,
0.218655996790589,
1.68597774630186E-13,
0.214712817948665,
1.54272428165569E-13,
0.213323715632215,
1.52360762895043E-13,
0.214360744470034,
1.55435560256212E-14,
8.02882066386346E-14,
3.69773656139216E-14,
1.14774509341053E-13,
5.26158977498525E-14,
1.36154976182468E-13,
6.16850320822593E-14,
1.52938425812543E-13,
6.93941432095002E-14,
1.60376920077532E-13,
6.98243546315425E-14,
1.62980740014973E-13,
6.29288288145347E-14,
1.7100210136789E-13,
6.59784726853019E-14,
1.80822370965394E-13,
6.37302710604359E-14,
1.90965299129431E-13,
6.50833553716978E-14,
1.88196680461772E-13,
5.59986085280073E-14,
1.85820109299684E-13,
4.63448723841964E-14,
1.87353604852447E-13,
4.06064071256651E-14,
1.89442211917523E-13,
4.00443567194486E-14,
1.94105148620949E-13,
2.81615009090075E-14,
1.91919397041218E-13,
0.804515927646108,
1.94386173824057E-13,
0.415967973850491,
2.00436889308264E-13,
0.322770031087544,
1.98445426757843E-13,
0.27852840703986,
1.85945009389954E-13,
0.252693847465983,
1.76587910960535E-13,
0.236211876497997,
1.74103786942936E-13,
0.225391000502912,
1.72684783139587E-13,
0.21846490533834,
1.58723728604926E-13,
0.214531003712516,
1.52391987917611E-13,
0.213152485893917,
1.46414130819394E-13,
4.81255660322866E-14,
2.98684688093687E-14,
1.0382840420764E-13,
4.56613913346615E-14,
1.23908695803809E-13,
5.07675498861992E-14,
1.44335932095174E-13,
6.56610182891981E-14,
1.56263890715991E-13,
7.05442648740728E-14,
1.69388808535231E-13,
6.84001466577655E-14,
1.66975808180148E-13,
6.1704114040495E-14,
1.77616601981789E-13,
5.76361874893294E-14,
1.83098328165876E-13,
5.52283913046736E-14,
1.83835585643166E-13,
5.59673835054397E-14,
1.86758594700187E-13,
4.68132477227101E-14,
1.89149043650083E-13,
3.93574062229618E-14,
1.8879689478446E-13,
4.11302936154101E-14,
1.98847882604269E-13,
3.31124017094453E-14,
1.96169469557361E-13,
2.33250918579841E-14,
1.95014143722361E-13,
0.804453157408992,
1.99746469364825E-13,
0.415825912914326,
2.02695499273986E-13,
0.322598193722219,
1.91693882989341E-13,
0.278343034347106,
1.76868936163643E-13,
0.252503684384719,
1.72452330193806E-13,
0.236022337112807,
1.71796604719887E-13,
0.225205665445947,
1.62880126053366E-13,
0.218286237016119,
1.56857166144775E-13,
0.214360744470033,
1.46351680774259E-13,
0.21299190313293,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
1.02665272116997E-14,
1.72138778925524E-14,
1.39914121954909E-14,
1.90437943192734E-14,
1.10879187775748E-14,
1.69196254229398E-14,
  0,
2.24490565026159E-14,
2.11347866291289E-14,
2.72407964241328E-14,
1.84804428704499E-14,
2.48768020072454E-14,
1.53006947389844E-14,
2.31928191929409E-14,
  0,
1.86179197059211E-14,
1.03003543194813E-14,
2.52267824685237E-14,
1.80346189371239E-14,
3.43952297199301E-14,
1.98794973538252E-14,
3.97026161946812E-14,
1.92159656242641E-14,
3.57600234146549E-14,
1.54897795978659E-14,
4.56527177172816E-14,
1.49888781941776E-14,
4.68266918296489E-14,
1.65254095130241E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.12345029112948E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.46840005432747E-14,
  0,
1.21300539057678E-14,
0.866325429916351,
1.40863883058007E-14,
0.866296163648431,
2.32305494285434E-14,
2.09979603149613E-14,
3.15030120046078E-14,
2.16367722349897E-14,
3.1113566584251E-14,
1.8253627775966E-14,
3.40005801291454E-14,
2.69788531792603E-14,
4.29990244799061E-14,
3.42902789496335E-14,
4.51357701214405E-14,
2.92040697180695E-14,
4.16732620633908E-14,
1.99848818049908E-14,
3.62114851992779E-14,
1.56662877115465E-14,
3.79492444413376E-14,
2.44873565868886E-14,
5.16435852415675E-14,
3.28526268689178E-14,
6.41691560998581E-14,
3.38500928676044E-14,
6.53539722339502E-14,
3.00827071586518E-14,
7.05095704045533E-14,
2.64068281130569E-14,
8.00826419067313E-14,
2.72932718092811E-14,
8.08589306622309E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.13498620224473E-14,
  0,
1.09244210899639E-14,
  0,
  0,
  0,
1.01906330596258E-14,
  0,
1.25910566695087E-14,
  0,
1.74530528918027E-14,
0.839139795294853,
1.80688797257744E-14,
0.5601224993078,
2.51040507825984E-14,
0.839025506408603,
3.36089663044437E-14,
2.58295988764257E-14,
3.92624301126521E-14,
2.62463661915291E-14,
4.4206825700055E-14,
3.25685658997266E-14,
4.94881913226664E-14,
3.56719861982491E-14,
5.49100695468319E-14,
4.08570746679437E-14,
5.62067753451245E-14,
3.06161346275147E-14,
4.94292107244831E-14,
2.5804011705155E-14,
5.10234215989058E-14,
2.7451999007333E-14,
5.85356416116234E-14,
3.54169818472805E-14,
7.37101352177305E-14,
4.23671514537816E-14,
8.10480155211124E-14,
4.04025771172378E-14,
9.15786543820296E-14,
3.73685457577544E-14,
9.47349837465694E-14,
3.52331011588269E-14,
1.03494469938514E-13,
3.67180244542631E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.05878847356244E-14,
  0,
1.06442632485937E-14,
  0,
1.49511479585751E-14,
  0,
1.35165316439423E-14,
  0,
1.46488723928861E-14,
0.827761101976404,
2.25297211442488E-14,
0.497979327268461,
2.87695214873374E-14,
0.497792969806215,
3.43648720591005E-14,
0.827504048487979,
3.98561392223051E-14,
2.91234050764366E-14,
5.05854039212217E-14,
3.95022556332059E-14,
5.78564973707785E-14,
3.99454774813179E-14,
5.92295310020141E-14,
4.0611611296093E-14,
6.35836869267159E-14,
4.07495218124332E-14,
6.18003911934117E-14,
3.52573872874906E-14,
6.21716220172708E-14,
3.65315416805956E-14,
6.93611834634567E-14,
3.69660899113278E-14,
7.78526548783631E-14,
4.32431868091498E-14,
8.72617950120613E-14,
4.7121161139696E-14,
1.03680952712182E-13,
4.60395610524245E-14,
1.11939103819569E-13,
4.472637538111E-14,
1.1395225041344E-13,
4.31894103813946E-14,
1.19931842235133E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.00514215006786E-14,
  0,
1.74747369352524E-14,
  0,
1.80545682570976E-14,
  0,
1.5333220804159E-14,
0.821670061884342,
1.91400714721901E-14,
0.471520349199964,
3.23716747852032E-14,
0.424675384403137,
3.74197201002957E-14,
0.471001412662876,
3.94771021428042E-14,
0.821207790590474,
5.00459049201929E-14,
4.17122933416003E-14,
6.32133234645949E-14,
4.59328755586519E-14,
6.63063354222615E-14,
4.39110553474009E-14,
6.65197064098066E-14,
3.95282764853455E-14,
6.79014136584222E-14,
4.45754544387E-14,
7.32114022183872E-14,
4.52008222517897E-14,
7.9209208636577E-14,
4.5324854980322E-14,
8.71863345408563E-14,
4.39388109230165E-14,
8.96374988124116E-14,
4.70283534337312E-14,
1.07894596035329E-13,
5.17468012883882E-14,
1.21794067886594E-13,
5.24537011048487E-14,
1.28769390983496E-13,
5.17103720953926E-14,
1.27921978565482E-13,
4.44652994979755E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.67817149065996E-14,
  0,
2.01757013873483E-14,
  0,
1.959283429942E-14,
0.818005963084478,
1.99597283145891E-14,
0.457187989999148,
2.90696286486813E-14,
0.392630891445301,
4.04719660562769E-14,
0.392238950251277,
4.23775597946374E-14,
0.456181168621402,
4.99201374681846E-14,
0.817268812823782,
6.20675386087122E-14,
4.77994380188029E-14,
7.08365657797749E-14,
4.93832405523698E-14,
7.285231445886E-14,
4.23480694955458E-14,
7.00784916207731E-14,
4.28363941540333E-14,
7.84979720114265E-14,
5.40539835114373E-14,
8.93625451414692E-14,
5.35066782547666E-14,
9.60429652474559E-14,
5.17537401822921E-14,
9.79008540902271E-14,
4.71888153552591E-14,
1.0907594272247E-13,
5.10372993867136E-14,
1.24606054641152E-13,
5.74896033556094E-14,
1.37072644901259E-13,
5.88452897520853E-14,
1.41161388134137E-13,
5.24181392735912E-14,
1.35771602294277E-13,
  0,
  0,
1.13377189581154E-14,
  0,
  0,
  0,
  0,
-1.10072541359418E-14,
1.32649967399256E-14,
  0,
1.94792099117436E-14,
  0,
2.19494561415345E-14,
0.815681087093769,
2.43312314740507E-14,
0.448497255790403,
2.90704960104193E-14,
0.374963761560963,
3.73485964377807E-14,
0.357067364282294,
4.57143004006788E-14,
0.373969667067663,
5.15455733651748E-14,
0.446830722338809,
6.13198727905662E-14,
0.814589064187194,
6.93273563556751E-14,
5.07779582270551E-14,
7.68803423700781E-14,
4.7418666215826E-14,
7.57206797263876E-14,
4.53378654063918E-14,
8.00930502475872E-14,
5.18500173352088E-14,
9.39491540119519E-14,
6.1855902344643E-14,
1.05388787974281E-13,
5.94888721616726E-14,
1.05966450891781E-13,
5.46073603002739E-14,
1.16471068900559E-13,
5.07770908653171E-14,
1.24839374948671E-13,
5.63299407119189E-14,
1.38798694759856E-13,
6.342669445214E-14,
1.48275489109118E-13,
5.90534565692025E-14,
1.47878237433119E-13,
5.28726368242971E-14,
  0,
1.12379723582468E-14,
  0,
1.06078340555982E-14,
  0,
  0,
-1.09760291133743E-14,
  0,
  0,
1.59698643198425E-14,
  0,
2.10768902331182E-14,
0.814200048945812,
2.5658294933173E-14,
0.442952953483213,
3.37776681624824E-14,
0.364126230020177,
3.71985428571087E-14,
0.337434129770942,
4.16437717642992E-14,
0.336784241948475,
5.47721590304917E-14,
0.362301412293591,
6.27414786791292E-14,
0.440430470809526,
6.7987282470483E-14,
0.812658657142177,
7.47405609624607E-14,
4.83979176180149E-14,
7.92447704678345E-14,
5.01491209670135E-14,
8.53189047189673E-14,
5.40617897670792E-14,
9.50090700557737E-14,
5.93587679009744E-14,
1.09412479076809E-13,
6.74581918103101E-14,
1.1472420236025E-13,
6.19886086905552E-14,
1.23867929802124E-13,
5.78478237533986E-14,
1.31450406115619E-13,
5.57349305596588E-14,
1.38226236012784E-13,
6.1858504429857E-14,
1.49148055017534E-13,
6.32566915514943E-14,
1.54114568329256E-13,
5.91575399777611E-14,
1.48539167077466E-13,
  0,
  0,
1.09053391317282E-14,
  0,
1.00644319267484E-14,
  0,
1.32715019529606E-14,
  0,
1.03710443011273E-14,
  0,
1.73090708432966E-14,
0.813314567390802,
2.49487930314984E-14,
0.439408012588455,
3.5675455645201E-14,
0.357157997341188,
4.09715664173582E-14,
0.325287043120977,
4.13558076672871E-14,
0.315840127708129,
5.09028583173254E-14,
0.323713312723886,
6.5448514663391E-14,
0.354244240160305,
6.95667481953599E-14,
0.435798797431083,
7.28696616936197E-14,
0.81120898826297,
7.72142766392037E-14,
5.09869924059103E-14,
8.85767154068517E-14,
5.87498799609065E-14,
9.98923166406485E-14,
6.12964540236405E-14,
1.10064735103776E-13,
6.47867176573058E-14,
1.18250895186911E-13,
6.97393531812196E-14,
1.32152969123389E-13,
6.49567205579515E-14,
1.38340727762198E-13,
6.25888230132432E-14,
1.44351544606458E-13,
6.10518580135277E-14,
1.47961504159966E-13,
6.14508444130024E-14,
1.54326204593325E-13,
6.30988317151804E-14,
1.54138854457919E-13,
6.09356315406373E-14,
  0,
  0,
  0,
1.06113035025501E-14,
  0,
1.67817149065996E-14,
  0,
1.60002219806721E-14,
  0,
1.16434639707563E-14,
0.812898687954003,
2.21307347447741E-14,
0.437283525876042,
3.4477629085039E-14,
0.352678940037468,
4.30393568007226E-14,
0.317429846133262,
4.52467924239031E-14,
0.302798675512211,
5.06530581367848E-14,
0.301833151302527,
6.12088504881036E-14,
0.314627150051719,
7.19702075713258E-14,
0.348375045991218,
7.46017830843826E-14,
0.432308287073719,
7.54795531632269E-14,
0.810085324411334,
8.59676912989826E-14,
5.94507082452012E-14,
1.02815325697669E-13,
6.5742550292569E-14,
1.14692977337683E-13,
6.64867466637631E-14,
1.18511103708308E-13,
6.67261385034479E-14,
1.35258124145388E-13,
7.25010329549747E-14,
1.46162595915378E-13,
6.95155738528186E-14,
1.50709306145913E-13,
6.7688910032615E-14,
1.53531701241327E-13,
6.03683769639929E-14,
1.52643522821627E-13,
6.10709399717635E-14,
1.53791909762724E-13,
6.46618175670355E-14,
1.62840227413419E-13,
  0,
  0,
  0,
  0,
1.74452466361608E-14,
  0,
1.9519975913429E-14,
  0,
1.73108055667726E-14,
0.812898687954003,
1.6008895598052E-14,
0.436284394622795,
3.06586353526761E-14,
0.349985409101039,
4.19048476474337E-14,
0.312358363191178,
4.70717215206307E-14,
0.294324004988271,
5.42890385424322E-14,
0.288141575394497,
6.11507372516584E-14,
0.292047405022383,
6.7543193260633E-14,
0.307974320732448,
7.70009056516585E-14,
0.343929383094463,
7.62098717466131E-14,
0.429595185157486,
8.47117515023754E-14,
0.809192365373048,
1.00155994608997E-13,
6.6266436782314E-14,
1.17260368082128E-13,
7.08478414823688E-14,
1.22780258182686E-13,
6.83706563586739E-14,
1.35176592142017E-13,
6.93403667817449E-14,
1.48924275689133E-13,
7.68378416449167E-14,
1.58116575388334E-13,
7.44335149072128E-14,
1.59566804214251E-13,
6.68805288928098E-14,
1.57811264056562E-13,
5.98410210272959E-14,
1.51668608228128E-13,
6.24153506656455E-14,
1.62089092148321E-13,
6.78086059524574E-14,
  0,
  0,
  0,
1.49242597446975E-14,
  0,
2.02025896012259E-14,
  0,
2.11029110852579E-14,
0.813314567390801,
2.21307347447741E-14,
0.436284394622795,
2.5056345887009E-14,
0.348716208643079,
3.829749017914E-14,
0.309300230146703,
4.61844104626685E-14,
0.288836157532161,
5.58659021820951E-14,
0.279212245766554,
6.45672751375947E-14,
0.277863235966416,
6.72482902697169E-14,
0.284854078553969,
7.22616411152899E-14,
0.302914619735473,
7.83904191559159E-14,
0.34045991447274,
8.49771641941999E-14,
0.427434276790014,
9.75122760316083E-14,
0.808468285672418,
1.14032047693335E-13,
7.10993763863854E-14,
1.25162033515203E-13,
7.24420523567915E-14,
1.39206354776711E-13,
7.07801872668057E-14,
1.48551310141798E-13,
7.35349281466569E-14,
1.6053304519037E-13,
8.16065964803769E-14,
1.66582025951101E-13,
7.34950295067094E-14,
1.63409216713539E-13,
6.6197047843275E-14,
1.56503282555676E-13,
6.09894079683926E-14,
1.59545987532539E-13,
6.54250958964653E-14,
1.71690786587853E-13,
  0,
  0,
1.02045108474336E-14,
  0,
1.8028113724089E-14,
  0,
2.19485887797966E-14,
0.814200048945812,
2.48377707290359E-14,
0.437283525876042,
3.07141465039074E-14,
0.348716208643079,
3.29311231062057E-14,
0.307856987257106,
4.25675120152569E-14,
0.285519782568366,
5.49039980146659E-14,
0.273415017105245,
6.61398019685677E-14,
0.26858592920938,
7.07871261607096E-14,
0.270285199923843,
7.18956144618588E-14,
0.27936599849849,
7.36910532594948E-14,
0.298953027858643,
8.66320903902817E-14,
0.337687565556663,
9.86086212684256E-14,
0.425678817754558,
1.1205099348377E-13,
0.80787127436887,
1.2161452400683E-13,
7.27248122833757E-14,
1.41274145160075E-13,
7.48498485414473E-14,
1.52320864255096E-13,
7.48533179883992E-14,
1.59953647549393E-13,
7.81891912327026E-14,
1.68757369189976E-13,
8.05813749060746E-14,
1.70252700826268E-13,
7.26658316851925E-14,
1.61846230861684E-13,
6.72916583566163E-14,
1.64174229766445E-13,
6.3952315665361E-14,
1.68882269280246E-13,
6.87297441182011E-14,
  0,
  0,
  0,
1.34887760683267E-14,
  0,
1.9595436384634E-14,
0.815681087093769,
2.5656560209697E-14,
0.439408012588455,
3.45643652588379E-14,
0.349985409101039,
3.83009596260919E-14,
0.307856987257106,
3.66208799396084E-14,
0.283952722083614,
5.11778119882678E-14,
0.269905585321782,
6.5072947030842E-14,
0.26255019738235,
7.20708215329324E-14,
0.26073392966398,
7.51343431915075E-14,
0.264489550876501,
7.31567584288939E-14,
0.275057900434205,
8.22484441664884E-14,
0.295778953556871,
1.00317323892263E-13,
0.335429348996079,
1.12420489584153E-13,
0.424229205385208,
1.19423568256671E-13,
0.807372077475408,
1.37894903828872E-13,
7.50025042073332E-14,
1.54100690541448E-13,
7.88050180666744E-14,
1.63489013993434E-13,
7.94520699232137E-14,
1.67884803281559E-13,
7.70130487159904E-14,
1.72108854945563E-13,
7.97105437211343E-14,
1.68413893941732E-13,
7.37188088351104E-14,
1.69258704274533E-13,
7.01279312398384E-14,
1.73180914053717E-13,
6.71580846489661E-14,
1.77266187839642E-13,
  0,
  0,
1.25598316469411E-14,
  0,
1.52499540773121E-14,
0.818005963084478,
2.43329661975267E-14,
0.442952953483213,
3.57309667964323E-14,
0.352678940037468,
4.18979087535298E-14,
0.309300230146703,
4.26230231664881E-14,
0.283952722083614,
4.54471529853784E-14,
0.268245637656274,
6.14508444130024E-14,
0.258891211739607,
7.09900888073989E-14,
0.254509324412512,
7.6513448354909E-14,
0.254717810640862,
7.67962082814933E-14,
0.25993089113244,
8.15441464352418E-14,
0.271598818109285,
9.56318357836494E-14,
0.293187752428238,
1.1444838132757E-13,
0.333560401961405,
1.19992557556792E-13,
0.423015533807655,
1.35263328315816E-13,
0.806949637906881,
1.50560119926979E-13,
7.87876708319146E-14,
1.65078020697429E-13,
8.3245910165175E-14,
1.71239758484099E-13,
7.81475578692792E-14,
1.71083633371261E-13,
7.60572160807271E-14,
1.70075759031718E-13,
8.05293332017953E-14,
1.75574832450565E-13,
7.64267121811102E-14,
1.78107528725491E-13,
7.32400251557408E-14,
1.81363604689899E-13,
5.83526282849078E-14,
  0,
1.46683880319909E-14,
  0,
1.47286696727811E-14,
0.821670061884342,
1.98998803546679E-14,
0.448497255790403,
3.37221570112511E-14,
0.357157997341187,
4.29699678616835E-14,
0.312358363191178,
4.61844104626685E-14,
0.285519782568366,
5.12853648437783E-14,
0.268245637656274,
5.56247756189343E-14,
0.257159105426093,
6.70730831986432E-14,
0.250731435264671,
7.53754697546682E-14,
0.248340480842514,
7.80712300363362E-14,
0.249978569154934,
8.47759362709866E-14,
0.256264496369248,
9.47714129395649E-14,
0.268769881442566,
1.09398601289001E-13,
0.291039201120309,
1.21555543408647E-13,
0.331992693776391,
1.35443739557317E-13,
0.421987350634723,
1.47423739882413E-13,
0.806588430277071,
1.61455918079589E-13,
8.3173051779184E-14,
1.72686517863063E-13,
8.19708884103321E-14,
1.74147155029836E-13,
7.70945807193613E-14,
1.68819819235111E-13,
7.68621277735804E-14,
1.77047612681669E-13,
8.3171317055708E-14,
1.84180795614886E-13,
7.94832949457813E-14,
1.86017867775945E-13,
6.43859965343552E-14,
1.83505988182731E-13,
  0,
  0,
1.74565223387546E-14,
0.827761101976404,
1.92146645816571E-14,
0.457187989999148,
2.91051904799389E-14,
0.364126230020177,
4.09793726730001E-14,
0.317429846133262,
4.69919242407357E-14,
0.288836157532161,
5.48484868634347E-14,
0.269905585321782,
6.15202333520415E-14,
0.257159105426093,
6.12686984480248E-14,
0.248941826829423,
7.15243836379997E-14,
0.244466130241101,
7.64700802680096E-14,
0.243475646527323,
8.61793275630518E-14,
0.246162084124298,
9.77620762121489E-14,
0.253261772633364,
1.08260622688761E-13,
0.26642063989064,
1.1639300634414E-13,
0.289234083188496,
1.36999786515268E-13,
0.330662444551266,
1.47834869346219E-13,
0.421107371740544,
1.5843749923139E-13,
0.806276769408064,
1.68922167920194E-13,
8.16673118020361E-14,
1.75540137981045E-13,
8.0704540272869E-14,
1.71793135272935E-13,
7.78196951323196E-14,
1.75659833900887E-13,
7.93844157076506E-14,
1.85537349373099E-13,
8.61845317334797E-14,
1.91950622063786E-13,
7.05963065783521E-14,
1.87957288622087E-13,
5.24112003796873E-14,
  0,
1.20749764354056E-14,
0.839139795294853,
2.25227822503449E-14,
0.471520349199964,
2.91095272886288E-14,
0.374963761560963,
3.72609929022438E-14,
0.325287043120977,
4.52407208917371E-14,
0.294324004988271,
5.58945251194487E-14,
0.273415017105245,
6.50928963508157E-14,
0.258891211739607,
6.71268596263985E-14,
0.248941826829423,
6.59073490227868E-14,
0.242629783707767,
7.25114412958305E-14,
0.239521753624819,
8.47794057179385E-14,
0.239554424345688,
9.91325077581706E-14,
0.243033058706465,
1.11490677801029E-13,
0.250765204957823,
1.15435438985401E-13,
0.264444342640221,
1.31960414817556E-13,
0.287700289064327,
1.4928336344866E-13,
0.32952236285798,
1.58519031234761E-13,
0.42034747902393,
1.65541191865515E-13,
0.806005701826774,
1.71366393297845E-13,
8.04096372819529E-14,
1.7308030009211E-13,
8.14105727275916E-14,
1.78477024825874E-13,
8.02396343813072E-14,
1.83989976032528E-13,
8.23126289350995E-14,
1.93149315985686E-13,
7.72316238739634E-14,
1.93718305285806E-13,
5.84705894812743E-14,
1.82570972229179E-13,
  0,
0.866325429916351,
1.79569900615739E-14,
0.497979327268461,
3.2386419934749E-14,
0.392630891445301,
3.72393088587941E-14,
0.337434129770942,
4.13453993264312E-14,
0.302798675512212,
5.42864364572182E-14,
0.279212245766554,
6.6197047843275E-14,
0.26255019738235,
7.09900888073989E-14,
0.250731435264671,
7.15243836379997E-14,
0.242629783707767,
6.66706273522166E-14,
0.23764680507446,
8.08884209613225E-14,
0.235534044203614,
9.79268749423667E-14,
0.236337010391821,
1.12731005086353E-13,
0.240429069147597,
1.18748760824516E-13,
0.248662790757856,
1.30924784902398E-13,
0.262763213156286,
1.44280420943943E-13,
0.286384204273408,
1.59879054439926E-13,
0.328536679007412,
1.65454455691716E-13,
0.419686089867887,
1.67922967198031E-13,
0.80576825889295,
1.69017577711372E-13,
8.1224957315662E-14,
1.79734699345957E-13,
8.38600022756708E-14,
1.86716961336764E-13,
8.3171317055708E-14,
1.91445817532276E-13,
7.33111488182558E-14,
1.94792099117436E-13,
6.51232540116453E-14,
1.88203619355676E-13,
5.59552404411079E-14,
  1,
1.41922064378353E-14,
0.5601224993078,
2.8647223482281E-14,
0.424675384403137,
4.0465894524111E-14,
0.357067364282294,
4.15579029522384E-14,
0.315840127708129,
5.06946915002082E-14,
0.288141575394497,
6.4546458455883E-14,
0.26858592920938,
7.20916382146441E-14,
0.254509324412512,
7.53060808156292E-14,
0.244466130241101,
7.25097065723546E-14,
0.23764680507446,
7.52019974070706E-14,
0.233626785520911,
9.39005817546246E-14,
0.23226041034805,
1.11417819415038E-13,
0.233657660704148,
1.19817350485718E-13,
0.238234438065672,
1.34142696950335E-13,
0.246872772087227,
1.43234382687929E-13,
0.261319297635499,
1.54796314655314E-13,
0.285245178555538,
1.66923766475868E-13,
0.327677866606682,
1.68197053507235E-13,
0.419106380142358,
1.65582825228938E-13,
0.805558941248454,
1.75373604527351E-13,
8.35737729021346E-14,
1.87762999592778E-13,
8.66633154128493E-14,
1.94106883344425E-13,
7.40432021251181E-14,
1.93052171471031E-13,
6.11715539333701E-14,
1.89109145010136E-13,
6.25350465854879E-14,
1.87962492792515E-13,
  0,
0.866296163648431,
2.50199166940135E-14,
0.497792969806215,
3.74197201002957E-14,
0.392238950251277,
4.5699555251133E-14,
0.336784241948475,
5.08777048269238E-14,
0.301833151302527,
6.11576761455623E-14,
0.277863235966416,
7.08426373119408E-14,
0.26073392966398,
7.65412039305247E-14,
0.248340480842514,
7.64492635862979E-14,
0.239521753624819,
8.09005640256544E-14,
0.233626785520911,
8.83737527601625E-14,
0.230325799373445,
1.07580611086178E-13,
0.229533046149056,
1.1830293689119E-13,
0.231398199448144,
1.35251185251484E-13,
0.236364604538073,
1.46209433449229E-13,
0.245334125349902,
1.53722520823685E-13,
0.260068570855249,
1.61952048993719E-13,
0.284251862753047,
1.69477279432506E-13,
0.326924419449755,
1.65202920787699E-13,
0.418595054718875,
1.71392414149985E-13,
0.805373355269897,
1.834071089446E-13,
8.64360666374964E-14,
1.95041899297976E-13,
7.7564690781351E-14,
1.95508539913014E-13,
6.19938128609832E-14,
1.87197479739609E-13,
5.85000797803659E-14,
1.88765669761892E-13,
4.9590540007749E-14,
1.02665272116997E-14,
2.32288147050674E-14,
0.839025506408603,
3.43544637182447E-14,
0.471001412662876,
4.24365403928206E-14,
0.373969667067663,
5.47756284774437E-14,
0.323713312723886,
6.1179360189012E-14,
0.292047405022382,
6.72517597166689E-14,
0.270285199923843,
7.52314877061622E-14,
0.254717810640862,
7.80261272259608E-14,
0.243475646527323,
8.47863446118424E-14,
0.235534044203614,
9.39127248189564E-14,
0.230325799373445,
1.01625305393149E-13,
0.22757505165907,
1.14472667456234E-13,
0.227232218614474,
1.33750649444764E-13,
0.229472151286186,
1.4731271757995E-13,
0.234756372125436,
1.56690632691081E-13,
0.244000423197057,
1.60758559242247E-13,
0.25897702242731,
1.64248822875912E-13,
0.283379717326592,
1.66826621961214E-13,
0.326259308130901,
1.71865993658926E-13,
0.418141478669773,
1.80204809407947E-13,
0.805207951807285,
1.90817847633973E-13,
7.71379488062607E-14,
1.96384575268382E-13,
6.53609111278541E-14,
1.89626092605977E-13,
5.92997873027912E-14,
1.86836657256606E-13,
4.562322741819E-14,
1.8861995298991E-13,
1.72138778925524E-14,
2.09832151654155E-14,
3.35950885166358E-14,
0.827504048487979,
3.9488377845398E-14,
0.456181168621402,
5.15464407269128E-14,
0.362301412293591,
6.55074952615742E-14,
0.314627150051719,
6.75848266240564E-14,
0.284854078553969,
7.19233700374744E-14,
0.2644895508765,
7.68031471753972E-14,
0.249978569154934,
8.61099386240127E-14,
0.239554424345688,
9.78713637911355E-14,
0.23226041034805,
1.07636122237409E-13,
0.22757505165907,
1.08760223049842E-13,
0.225254060893135,
1.29864868858576E-13,
0.225270255480031,
1.45952694374785E-13,
0.227814829749705,
1.5780779460961E-13,
0.2333616051098,
1.63502891781242E-13,
0.242835750897917,
1.62956453886309E-13,
0.258017988601921,
1.61533980636008E-13,
0.282609277907327,
1.72977951407027E-13,
0.32566888609103,
1.79967152291738E-13,
0.417737051733316,
1.86904311472169E-13,
0.8050598352249,
1.91851742825655E-13,
6.51371317994531E-14,
1.90436208469258E-13,
6.27466828495571E-14,
1.89173329778747E-13,
4.63552807250522E-14,
1.8652440703093E-13,
3.85559639770605E-14,
1.39914121954909E-14,
3.1491736302014E-14,
2.58269967912117E-14,
3.98032301562878E-14,
0.821207790590474,
4.99513624907522E-14,
0.446830722338809,
6.27423460408671E-14,
0.354244240160305,
7.19702075713258E-14,
0.307974320732448,
7.22373549866262E-14,
0.27936599849849,
7.31584931523699E-14,
0.25993089113244,
8.48036918466022E-14,
0.246162084124298,
9.91359772051226E-14,
0.236337010391821,
1.11423023585466E-13,
0.229533046149056,
1.14470932732758E-13,
0.225254060893135,
1.24098648024429E-13,
0.223274578406544,
1.42112016598972E-13,
0.223581536073637,
1.56168480924812E-13,
0.226376923408339,
1.64635666211055E-13,
0.232143028674402,
1.65971403287557E-13,
0.241811917361628,
1.60021301764957E-13,
0.257170290824441,
1.675569405446E-13,
0.281924922860613,
1.80775533431543E-13,
0.325142099798238,
1.86956353176448E-13,
0.417374750324032,
1.88279947188619E-13,
0.804926621686291,
1.85936335772574E-13,
6.24431062412611E-14,
1.89851606657854E-13,
4.98212582300539E-14,
1.88862814276547E-13,
3.92602617083071E-14,
1.88800364231412E-13,
1.90437943192734E-14,
2.1690114981876E-14,
3.92624301126521E-14,
2.91112620121048E-14,
4.99817201515818E-14,
0.817268812823782,
6.13190054288282E-14,
0.440430470809526,
6.95667481953599E-14,
0.348375045991218,
7.70911112724093E-14,
0.302914619735473,
7.36875838125428E-14,
0.275057900434205,
8.15476158821937E-14,
0.256264496369248,
9.78037095755724E-14,
0.243033058706464,
1.1280559819582E-13,
0.233657660704148,
1.18330692466806E-13,
0.227232218614475,
1.29948135585423E-13,
0.223274578406544,
1.36281610996214E-13,
0.221570532900025,
1.5227576144472E-13,
0.222116009990463,
1.63175029044282E-13,
0.225120218437046,
1.67111116611274E-13,
0.231071356778512,
1.62883595500318E-13,
0.24090650623605,
1.66458860584306E-13,
0.256416910468875,
1.75488096276766E-13,
0.281313981470102,
1.87945145557755E-13,
0.324669909030278,
1.88018003943746E-13,
0.417048787123275,
1.82180659447084E-13,
0.804806332527042,
1.85462756263632E-13,
4.92834939525011E-14,
1.89518539750466E-13,
4.27019530846451E-14,
1.90986115811143E-13,
3.38618022510673E-14,
1.10879187775748E-14,
3.11070613712161E-14,
2.62203453393894E-14,
5.05854039212217E-14,
4.17313752998361E-14,
6.20675386087122E-14,
0.814589064187193,
6.7985547747007E-14,
0.435798797431083,
7.45983136374306E-14,
0.343929383094463,
7.84008274967718E-14,
0.298953027858643,
8.22137496969688E-14,
0.271598818109285,
9.4764474045661E-14,
0.253261772633364,
1.11594761209588E-13,
0.240429069147597,
1.19843371337858E-13,
0.231398199448144,
1.3371768969872E-13,
0.225270255480031,
1.4208252629988E-13,
0.221570532900025,
1.46663930999935E-13,
0.22009151698899,
1.59209451178199E-13,
0.220834871893277,
1.65523844630755E-13,
0.224014670680826,
1.64108310274358E-13,
0.230123282694008,
1.69270847338865E-13,
0.240101486274965,
1.74105521666412E-13,
0.255744028125508,
1.82451276309337E-13,
0.280766078004452,
1.88729240568897E-13,
0.324244855009775,
1.81795550835417E-13,
0.416754354592954,
1.81934328713496E-13,
0.804697313018408,
1.84616211207356E-13,
4.23688861772575E-14,
1.91617555156398E-13,
3.72341046883662E-14,
1.93421667571414E-13,
1.69196254229398E-14,
1.82258722003503E-14,
4.42276423817667E-14,
3.95222049531796E-14,
6.32202623584988E-14,
4.78063769127068E-14,
6.93646529104086E-14,
0.812658657142177,
7.27621088381092E-14,
0.432308287073719,
7.62653828978443E-14,
0.34045991447274,
8.66338251137577E-14,
0.295778953556871,
9.56353052306014E-14,
0.268769881442566,
1.08191233749722E-13,
0.250765204957823,
1.18691514949809E-13,
0.238234438065672,
1.35193939376776E-13,
0.229472151286186,
1.45982184673876E-13,
0.223581536073637,
1.52254944763008E-13,
0.22009151698899,
1.53722520823685E-13,
0.218798439215865,
1.61586022340288E-13,
0.219707599113254,
1.6246032297218E-13,
0.223036355360475,
1.70211067462844E-13,
0.229280044561329,
1.7697822374263E-13,
0.239382202558495,
1.81231765705725E-13,
0.255140315828267,
1.83344658899465E-13,
0.280272642152141,
1.82805159898436E-13,
0.323860734335983,
1.80831044582774E-13,
0.416487429314763,
1.81254317110913E-13,
0.804598169765316,
1.86916454536501E-13,
3.69183850157384E-14,
1.93914329038591E-13,
3.31783212015324E-14,
  0,
3.39867023413376E-14,
3.25963214753422E-14,
5.78556300090405E-14,
4.60031318594289E-14,
7.08539130145347E-14,
5.07987749087668E-14,
7.47665818146004E-14,
0.81120898826297,
7.54795531632269E-14,
0.429595185157486,
8.49216530429686E-14,
0.337687565556663,
1.00296507210551E-13,
0.293187752428238,
1.09315334562154E-13,
0.26642063989064,
1.15433704261925E-13,
0.248662790757856,
1.34087185799103E-13,
0.236364604538073,
1.47314452303426E-13,
0.227814829749705,
1.56168480924812E-13,
0.222116009990463,
1.59167817814776E-13,
0.218798439215865,
1.55941232149459E-13,
0.217660545176761,
1.58605767408559E-13,
0.218709876064193,
1.68731348337836E-13,
0.222166002294815,
1.77927117483989E-13,
0.228526382982409,
1.83930995434345E-13,
0.238736632349958,
1.81809428623225E-13,
0.254596407996585,
1.77240166987502E-13,
0.279826538747941,
1.82003717652535E-13,
0.323512349772584,
1.80737369515072E-13,
0.416244621033623,
1.83263126896094E-13,
0.804507721957031,
1.89306903486397E-13,
3.27550486733941E-14,
2.01196698190742E-13,
2.24490565026159E-14,
2.69545670505966E-14,
4.94907934078803E-14,
3.99567531839118E-14,
6.63002638900956E-14,
4.94162002984133E-14,
7.68612604118424E-14,
4.84031217884429E-14,
7.71622349349244E-14,
0.810085324411334,
8.47186903962793E-14,
0.427434276790014,
9.86103559919016E-14,
0.335429348996079,
1.14391135452863E-13,
0.291039201120309,
1.1638433272676E-13,
0.264444342640221,
1.30980296053629E-13,
0.246872772087228,
1.46185147320566E-13,
0.234756372125436,
1.5780779460961E-13,
0.226376923408339,
1.63126456786955E-13,
0.220834871893277,
1.61586022340288E-13,
0.217660545176761,
1.52735463165854E-13,
0.216653329824134,
1.64743219066565E-13,
0.217822110622399,
1.76424846953793E-13,
0.221387930646393,
1.84781009937574E-13,
0.227849771319595,
1.8492499198608E-13,
0.238154828187346,
1.75862796547577E-13,
0.254104500732163,
1.7638321359037E-13,
0.279421784324453,
1.81361869966423E-13,
0.32319531764149,
1.82524134695328E-13,
0.416023054978265,
1.85230303317852E-13,
0.804424963038377,
1.96443555866566E-13,
3.23421844861116E-14,
2.11347866291289E-14,
4.29981571181681E-14,
3.56719861982491E-14,
5.92442761515599E-14,
4.39318720291126E-14,
7.28696616936197E-14,
4.75088718365768E-14,
7.92465051913105E-14,
5.09869924059103E-14,
8.59954468745983E-14,
0.809192365373048,
9.75990122054071E-14,
0.425678817754558,
1.12415285413725E-13,
0.333560401961405,
1.21527787833031E-13,
0.289234083188496,
1.32019395415739E-13,
0.262763213156286,
1.43310710520872E-13,
0.245334125349902,
1.56629917369422E-13,
0.2333616051098,
1.64639135658007E-13,
0.225120218437046,
1.65463129309096E-13,
0.219707599113254,
1.58607502132035E-13,
0.216653329824134,
1.59105367769641E-13,
0.215757044808458,
1.72410696830383E-13,
0.217028354643767,
1.83349863069893E-13,
0.220689261797139,
1.85840925981395E-13,
0.227239839136685,
1.78527331806677E-13,
0.237628495620634,
1.75127273793763E-13,
0.253658044679908,
1.75803815949394E-13,
0.27905332772495,
1.83245779661334E-13,
0.32290591743578,
1.84876419728752E-13,
0.415820279244742,
1.92162258327855E-13,
0.80434903030525,
2.00381378157033E-13,
2.72407964241328E-14,
3.43041567374414E-14,
5.49100695468319E-14,
4.06523772977785E-14,
6.65335841976145E-14,
4.2332456984262E-14,
7.5692056789034E-14,
5.01629987548213E-14,
8.85420209373322E-14,
5.94229526695855E-14,
1.0021497520718E-13,
0.808468285672418,
1.12045789313342E-13,
0.424229205385208,
1.200064353446E-13,
0.331992693776391,
1.36968561492701E-13,
0.287700289064327,
1.44289094561323E-13,
0.261319297635499,
1.53778031974916E-13,
0.244000423197057,
1.63547994591617E-13,
0.232143028674402,
1.67055605460042E-13,
0.224014670680826,
1.62432567396564E-13,
0.218709876064193,
1.64741484343089E-13,
0.215757044808458,
1.66875194218541E-13,
0.21495561215979,
1.79365203245574E-13,
0.216315505963042,
1.84203347020073E-13,
0.220059329351934,
1.79661840959966E-13,
0.226687934667774,
1.7773282845468E-13,
0.237150669215946,
1.74426445509468E-13,
0.253251507020265,
1.7773282845468E-13,
0.278716878573997,
1.857611287015E-13,
0.322640973287743,
1.91915927594266E-13,
0.41563419126068,
1.96443555866566E-13,
0.804279180587048,
1.84804428704499E-14,
4.51218923336327E-14,
4.08501357740398E-14,
6.36114425023315E-14,
3.95464910818433E-14,
7.00524707686334E-14,
4.53378654063918E-14,
8.53345172302511E-14,
5.87498799609065E-14,
1.02843081273285E-13,
6.62594978884101E-14,
1.14033782416811E-13,
0.80787127436887,
1.19489487748758E-13,
0.423015533807655,
1.35388228406086E-13,
0.330662444551266,
1.49290302342564E-13,
0.286384204273408,
1.54928153639489E-13,
0.260068570855249,
1.60706517537967E-13,
0.242835750897917,
1.65964464393653E-13,
0.231071356778512,
1.64108310274358E-13,
0.223036355360475,
1.68734817784788E-13,
0.217822110622399,
1.72393349595623E-13,
0.21495561215979,
1.73560818494956E-13,
0.214235821054612,
1.80060827359441E-13,
0.215672709990886,
1.77902831355325E-13,
0.219489231136841,
1.78669579131707E-13,
0.226186788842582,
1.76962611231346E-13,
0.236715461246601,
1.76306885757427E-13,
0.252880185175237,
1.79731229899005E-13,
0.278408771912415,
1.92512672470002E-13,
0.322397759729149,
1.95718441453607E-13,
0.415462978921447,
2.04215117038942E-13,
2.48768020072454E-14,
2.92305242510782E-14,
5.61824892164609E-14,
4.07356440246254E-14,
6.78840664236624E-14,
4.28363941540333E-14,
8.00930502475872E-14,
5.40444425323194E-14,
9.98957860876004E-14,
6.5746019739521E-14,
1.17239551400417E-13,
7.11028458333374E-14,
1.21680443498917E-13,
0.807372077475408,
1.35320574190523E-13,
0.421987350634723,
1.47741194278517E-13,
0.32952236285798,
1.59892932227734E-13,
0.285245178555538,
1.61995417080618E-13,
0.25897702242731,
1.62956453886309E-13,
0.241811917361628,
1.62894003841174E-13,
0.230123282694008,
1.70273517507979E-13,
0.222166002294815,
1.76404030272082E-13,
0.217028354643767,
1.79365203245574E-13,
0.214235821054612,
1.74481956660699E-13,
0.213586725363478,
1.7395113127705E-13,
0.215090905148607,
1.77101389109424E-13,
0.218971484988313,
1.77882014673614E-13,
0.225730254495548,
1.78849990373209E-13,
0.236317864814099,
1.78513454018869E-13,
0.252540059640552,
1.86774207211471E-13,
0.278125860449566,
1.96599680979404E-13,
0.322173926159728,
2.03878580684602E-13,
0.415305073112824,
1.53006947389844E-14,
4.16715273399149E-14,
3.06161346275147E-14,
6.178391132039E-14,
4.45893322265078E-14,
7.84988393731645E-14,
5.18743034638725E-14,
9.50108047792497E-14,
6.12964540236405E-14,
1.1470685512549E-13,
7.08409025884649E-14,
1.25162033515203E-13,
7.26710358556204E-14,
1.37832453783737E-13,
0.806949637906881,
1.47479251033644E-13,
0.421107371740544,
1.58519031234761E-13,
0.328536679007412,
1.66993155414907E-13,
0.284251862753047,
1.64300864580191E-13,
0.258017988601921,
1.60012628147577E-13,
0.24090650623605,
1.69336766830952E-13,
0.229280044561329,
1.77927117483989E-13,
0.221387930646393,
1.83349863069893E-13,
0.216315505963042,
1.80060827359441E-13,
0.213586725363478,
1.68247360488039E-13,
0.212999185920361,
1.73087238986014E-13,
0.214562473485055,
1.7634851912085E-13,
0.218499761427233,
1.79928988375266E-13,
0.225313101919315,
1.81098191998075E-13,
0.235953598190448,
1.8547663405144E-13,
0.252227676731304,
1.90829990698305E-13,
0.277865428112502,
2.04686961824407E-13,
0.321967435855508,
2.00017086227078E-13,
2.31928191929409E-14,
2.00074332101785E-14,
4.94569663000988E-14,
3.5230499073613E-14,
7.31905855366755E-14,
5.40314321062496E-14,
9.39352762241441E-14,
5.9310195643647E-14,
1.10061265656825E-13,
6.64971550046189E-14,
1.22752502607071E-13,
7.24108273342239E-14,
1.41241185414032E-13,
7.49886264195254E-14,
1.50589610226071E-13,
0.806588430277071,
1.5843749923139E-13,
0.42034747902393,
1.65454455691716E-13,
0.327677866606682,
1.6946687109165E-13,
0.283379717326592,
1.61533980636008E-13,
0.257170290824441,
1.66460595307782E-13,
0.240101486274965,
1.76964345954822E-13,
0.228526382982409,
1.84760193255862E-13,
0.220689261797139,
1.84203347020073E-13,
0.215672709990886,
1.73923375701435E-13,
0.212999185920361,
1.6711285133475E-13,
0.212465518642365,
1.72414166277335E-13,
0.214080969239683,
1.78107528725491E-13,
0.218068673985261,
1.81982900970823E-13,
0.224930857121251,
1.88214027696532E-13,
0.235618980704569,
1.8920628952479E-13,
0.251940054419867,
1.98941557671972E-13,
0.277625120167139,
2.00849753495547E-13,
0.321776516373611,
  0,
3.62175567314438E-14,
2.57936033642991E-14,
6.21794282729127E-14,
4.52129653161215E-14,
8.93764229292771E-14,
6.18645759620229E-14,
1.09381254054242E-13,
6.47797787634019E-14,
1.18580492647347E-13,
6.83567785708661E-14,
1.3915084362548E-13,
7.48394402005914E-14,
1.54072934965832E-13,
7.88171611310062E-14,
1.61428162503974E-13,
0.806276769408064,
1.65626193315838E-13,
0.419686089867887,
1.68200522954187E-13,
0.326924419449755,
1.66826621961214E-13,
0.282609277907327,
1.67525715522032E-13,
0.256416910468875,
1.74098582772508E-13,
0.239382202558495,
1.83903239858729E-13,
0.227849771319595,
1.8581317040578E-13,
0.220059329351934,
1.77902831355325E-13,
0.215090905148607,
1.73142750137245E-13,
0.212465518642364,
1.66620189867572E-13,
0.211979221106016,
1.74176645328927E-13,
0.213640905875525,
1.80282871964366E-13,
0.217673613249035,
1.88894039299115E-13,
0.22457967278074,
1.91874294230843E-13,
0.235310833000562,
1.97203364749043E-13,
0.251674606160948,
1.94802507458292E-13,
0.277402886343562,
2.01345884409676E-13,
1.86179197059211E-14,
1.56749613289264E-14,
5.10164827050019E-14,
3.65228680632157E-14,
7.9209208636577E-14,
5.3478922679151E-14,
1.05374910186473E-13,
6.7468600151166E-14,
1.18252629910387E-13,
6.67226690564959E-14,
1.35150571289877E-13,
7.08200859067531E-14,
1.52348619830711E-13,
7.8831038918814E-14,
1.65064142909621E-13,
8.31435614800924E-14,
1.68989822135757E-13,
0.806005701826774,
1.67926436644983E-13,
0.419106380142358,
1.65411087604816E-13,
0.326259308130901,
1.72922440255796E-13,
0.281924922860613,
1.75377073974303E-13,
0.255744028125508,
1.81238704599629E-13,
0.238736632349958,
1.84945808667791E-13,
0.227239839136685,
1.79658371513014E-13,
0.219489231136841,
1.77101389109424E-13,
0.214562473485055,
1.72417635724287E-13,
0.211979221106016,
1.68375730025261E-13,
0.211534757987126,
1.76220149583628E-13,
0.213237587465596,
1.87284215913408E-13,
0.217310614399328,
1.92745125415783E-13,
0.224256224488703,
1.99926880606327E-13,
0.235026396295025,
1.93421667571414E-13,
0.251429078844498,
1.95343741182796E-13,
0.277196934246116,
1.03003543194813E-14,
3.79743979317393E-14,
2.74459274751671E-14,
6.93750612512645E-14,
4.53161813629421E-14,
9.60308221831241E-14,
5.94836679912447E-14,
1.1474154959501E-13,
6.97150670525559E-14,
1.35272001933195E-13,
6.93299584408891E-14,
1.4855477958875E-13,
7.48550527118752E-14,
1.63475136205626E-13,
8.3247644888651E-14,
1.72702130374347E-13,
8.16464951203244E-14,
1.71324759934421E-13,
0.80576825889295,
1.65582825228938E-13,
0.418595054718875,
1.71944056215345E-13,
0.32566888609103,
1.80718287556836E-13,
0.281313981470102,
1.82423520733721E-13,
0.255140315828267,
1.81837184198841E-13,
0.238154828187346,
1.78610598533524E-13,
0.226687934667774,
1.78690395813419E-13,
0.218971484988313,
1.76327702439139E-13,
0.214080969239683,
1.74176645328927E-13,
0.211534757987126,
1.70610053862319E-13,
0.211127391160408,
1.83249249108286E-13,
0.212866974072426,
1.91121424242269E-13,
0.216976250658801,
2.00846284048595E-13,
0.223957626708023,
1.95957833293292E-13,
0.234763266568309,
1.93848409546504E-13,
0.251201501931991,
1.89358945190676E-13,
2.52267824685237E-14,
2.44890913103646E-14,
5.85356416116234E-14,
3.69643551878518E-14,
8.71776609234765E-14,
5.17398623944842E-14,
1.05935225869214E-13,
6.20146295426949E-14,
1.32154703846865E-13,
7.25079718488786E-14,
1.48917336795229E-13,
7.35522753814166E-14,
1.59939769761586E-13,
7.94486004762618E-14,
1.71264044612762E-13,
8.19708884103321E-14,
1.75519321299333E-13,
8.03957594941451E-14,
1.69017577711372E-13,
0.805558941248454,
1.7140282249084E-13,
0.418141478669773,
1.79967152291738E-13,
0.325142099798238,
1.87946880281231E-13,
0.280766078004451,
1.83341189452513E-13,
0.254596407996585,
1.75918307698808E-13,
0.237628495620634,
1.77760584030295E-13,
0.226186788842582,
1.77902831355325E-13,
0.218499761427233,
1.78107528725491E-13,
0.213640905875525,
1.76195863454964E-13,
0.211127391160408,
1.77548947766226E-13,
0.210753044032598,
1.87030946285915E-13,
0.212525573429773,
1.99010946611011E-13,
0.216667546958398,
1.96724581069674E-13,
0.22368136424433,
1.96623967108067E-13,
0.234519340585545,
1.87867083001336E-13,
0.250990145509843,
1.80346189371239E-14,
5.16409831563536E-14,
3.53996346125207E-14,
7.7858726410529E-14,
4.39440150934445E-14,
9.79008540902271E-14,
5.45900130655141E-14,
1.2385231729084E-13,
6.49740677927113E-14,
1.46162595915378E-13,
7.68274333040608E-14,
1.60505289614754E-13,
7.82048037439864E-14,
1.67874394940704E-13,
7.81857217857507E-14,
1.74135011965504E-13,
8.0704540272869E-14,
1.73104586220774E-13,
8.12596517851816E-14,
1.75373604527351E-13,
0.805373355269897,
1.80197870514043E-13,
0.417737051733316,
1.86949414282545E-13,
0.324669909030278,
1.88722301674993E-13,
0.280272642152141,
1.7728873924483E-13,
0.254104500732163,
1.75203601626706E-13,
0.237150669215946,
1.76990366806962E-13,
0.225730254495548,
1.79949805056978E-13,
0.218068673985261,
1.80282871964366E-13,
0.213237587465596,
1.83245779661334E-13,
0.210753044032598,
1.81472892268886E-13,
0.210408192367815,
1.95017613169313E-13,
0.212210353156146,
1.95021082616265E-13,
0.216381909512321,
1.97265814794179E-13,
0.223425236009932,
1.90403248723214E-13,
0.234292771356534,
1.84324777663392E-13,
3.43952297199301E-14,
3.2835279634158E-14,
7.36962574299227E-14,
4.3232778468294E-14,
8.96479071532674E-14,
4.71766722909273E-14,
1.16474538347511E-13,
5.78617015412064E-14,
1.38347666656102E-13,
6.94947571711069E-14,
1.58165147645661E-13,
8.15753714578094E-14,
1.68793798382971E-13,
7.69818236934228E-14,
1.71080163924309E-13,
7.70668251437456E-14,
1.71779257485127E-13,
8.1448736644063E-14,
1.79703474323389E-13,
8.36292840533659E-14,
1.83367210304652E-13,
0.805207951807285,
1.86911250366073E-13,
0.417374750324032,
1.88021473390698E-13,
0.324244855009775,
1.82721893171589E-13,
0.279826538747941,
1.76376274696466E-13,
0.253658044679908,
1.74426445509468E-13,
0.236715461246601,
1.78836112585401E-13,
0.225313101919315,
1.81955145395207E-13,
0.217673613249035,
1.87256460337792E-13,
0.212866974072426,
1.87058701861531E-13,
0.210408192367815,
1.8925833122907E-13,
0.210089775796107,
1.91031218621518E-13,
0.211918669127824,
1.95697624771896E-13,
0.21611706800682,
1.91090199219701E-13,
0.22318730860138,
1.86992782369444E-13,
0.234081931177913,
1.98794973538252E-14,
6.41891054198318E-14,
4.23879681354933E-14,
8.72479172242535E-14,
4.70075367520195E-14,
1.0907594272247E-13,
5.07753561418411E-14,
1.31464283903426E-13,
6.25957619071471E-14,
1.50712775592865E-13,
7.44317801837369E-14,
1.66585495398053E-13,
8.05848443530266E-14,
1.72108854945563E-13,
7.60450730163953E-14,
1.68804206723827E-13,
7.78335729201274E-14,
1.78477024825874E-13,
8.38877578512864E-14,
1.87721366229354E-13,
8.64083110618807E-14,
1.90807439293117E-13,
0.8050598352249,
1.88333723616374E-13,
0.417048787123276,
1.81740039684186E-13,
0.323860734335983,
1.82059228803766E-13,
0.279421784324453,
1.75803815949394E-13,
0.253251507020265,
1.76275660734859E-13,
0.236317864814099,
1.81157172596258E-13,
0.224930857121251,
1.8892179487473E-13,
0.217310614399328,
1.91145710370932E-13,
0.212525573429773,
1.95010674275409E-13,
0.210089775796107,
1.8535173396117E-13,
0.209795125602865,
1.91510002300888E-13,
0.211648206667999,
1.89456089705331E-13,
0.215871027862441,
1.87547893881757E-13,
0.222965877764235,
1.82780873769772E-13,
3.97026161946812E-14,
3.38492255058664E-14,
8.1075771096728E-14,
4.71003444579843E-14,
1.07894596035329E-13,
5.10034722789321E-14,
1.24809884649579E-13,
5.5721052771851E-14,
1.44351544606458E-13,
6.76767669682832E-14,
1.59544252809063E-13,
7.34932947832334E-14,
1.7023882303846E-13,
7.96827881455187E-14,
1.70075759031718E-13,
7.68690666674843E-14,
1.75659833900887E-13,
8.02951455325385E-14,
1.86703083548956E-13,
8.67222960110325E-14,
1.95041899297976E-13,
7.71101932306451E-14,
1.91851742825655E-13,
0.804926621686291,
1.82256987280027E-13,
0.416754354592954,
1.80831044582774E-13,
0.323512349772584,
1.81389625542039E-13,
0.27905332772495,
1.77788339605911E-13,
0.252880185175237,
1.78513454018869E-13,
0.235953598190448,
1.88238313825195E-13,
0.22457967278074,
1.92745125415783E-13,
0.216976250658801,
1.98986660482348E-13,
0.212210353156146,
1.91058974197134E-13,
0.209795125602865,
1.85750720360645E-13,
0.209521905432312,
1.85320508938602E-13,
0.211396931973491,
1.85917253814338E-13,
0.215642030595174,
1.83349863069893E-13,
0.222759436237109,
1.92159656242641E-14,
6.53609111278541E-14,
4.04034444789758E-14,
1.03667074924374E-13,
5.17329235005803E-14,
1.24638147025458E-13,
5.63299407119189E-14,
1.38238379077116E-13,
6.10449191196238E-14,
1.53526497070899E-13,
6.68718552754299E-14,
1.63409216713539E-13,
7.26658316851925E-14,
1.68400016153925E-13,
8.05605582243629E-14,
1.77054551575573E-13,
7.93844157076506E-14,
1.83991710756004E-13,
8.31956031843717E-14,
1.94106883344425E-13,
7.75924463569666E-14,
1.9638110582143E-13,
6.50833553716978E-14,
1.85884294068295E-13,
0.804806332527042,
1.8190657313788E-13,
0.416487429314763,
1.80737369515072E-13,
0.32319531764149,
1.83301290812565E-13,
0.278716878573997,
1.79731229899005E-13,
0.252540059640552,
1.85448878475825E-13,
0.235618980704569,
1.91818783079611E-13,
0.224256224488703,
2.00804650685171E-13,
0.216667546958398,
1.95021082616265E-13,
0.211918669127824,
1.91565513452119E-13,
0.209521905432312,
1.79641024278254E-13,
0.209268062308051,
1.81861470327505E-13,
0.211163051774223,
1.81819836964081E-13,
0.215428520730332,
1.75692793646931E-13,
3.57600234146549E-14,
3.0064492562154E-14,
9.15786543820296E-14,
4.60464999463284E-14,
1.2179580261007E-13,
5.74826644617055E-14,
1.38800429483332E-13,
6.18446266420491E-14,
1.47990994459057E-13,
6.03943978161325E-14,
1.57802590439182E-13,
6.6197047843275E-14,
1.6183929196778E-13,
7.37136046646825E-14,
1.75574832450565E-13,
8.31782559496119E-14,
1.85530410479195E-13,
8.23230372759554E-14,
1.91473573107892E-13,
7.40813660415895E-14,
1.95480784337398E-13,
6.53886667034698E-14,
1.90436208469258E-13,
6.24812701577326E-14,
1.85407245112401E-13,
0.804697313018408,
1.81420850564606E-13,
0.416244621033623,
1.82437398521529E-13,
0.32290591743578,
1.857611287015E-13,
0.278408771912415,
1.86881760066981E-13,
0.252227676731304,
1.89209758971742E-13,
0.235310833000562,
1.99923411159375E-13,
0.223957626708023,
1.96724581069674E-13,
0.216381909512321,
1.95694155324944E-13,
0.211648206667999,
1.8531703949165E-13,
0.209268062308051,
1.76181985667156E-13,
0.209031785951284,
1.7759058112965E-13,
0.210944979655229,
1.73902559019723E-13,
0.215229118049781,
1.54897795978659E-14,
7.04930905315315E-14,
3.73685457577544E-14,
1.1192175658481E-13,
5.24537011048487E-14,
1.37086522689067E-13,
6.34423069634238E-14,
1.49137646676678E-13,
6.14265582843387E-14,
1.52614032522536E-13,
5.98410210272959E-14,
1.56524099237387E-13,
6.72604333340487E-14,
1.69253500104105E-13,
7.64197732872063E-14,
1.84208551190501E-13,
8.61706539456719E-14,
1.93142377091782E-13,
7.33319654999676E-14,
1.93052171471031E-13,
6.19868739670792E-14,
1.89622623159025E-13,
6.27744384251727E-14,
1.89820381635286E-13,
4.92696161646933E-14,
1.84671722358587E-13,
0.804598169765316,
1.83259657449142E-13,
0.416023054978265,
1.848729502818E-13,
0.322640973287743,
1.92540428045618E-13,
0.278125860449566,
1.90774479547073E-13,
0.251940054419867,
1.97231120324659E-13,
0.235026396295025,
1.95957833293292E-13,
0.22368136424433,
1.97234589771611E-13,
0.21611706800682,
1.89435273023619E-13,
0.211396931973491,
1.81916981478736E-13,
0.209031785951284,
1.72060282688236E-13,
0.208811474814812,
1.69864122767649E-13,
0.210741307802509,
1.63601771019373E-13,
4.56527177172816E-14,
2.64068281130569E-14,
9.47349837465694E-14,
4.47055586993983E-14,
1.28779799324352E-13,
5.88470244755612E-14,
1.48308448855161E-13,
6.32705693393021E-14,
1.54326204593325E-13,
6.10692052482875E-14,
1.51679016568984E-13,
6.10223677144361E-14,
1.64143004743877E-13,
7.01105840050786E-14,
1.78090181490731E-13,
7.9511050521397E-14,
1.91950622063786E-13,
7.72177460861556E-14,
1.94788629670484E-13,
6.11993095089858E-14,
1.87225235315225E-13,
5.92945831323632E-14,
1.89176799225699E-13,
4.98212582300539E-14,
1.89504661962658E-13,
4.23966417528732E-14,
1.86916454536501E-13,
0.804507721957031,
1.8519213940138E-13,
0.415820279244742,
1.91860416443035E-13,
0.322397759729149,
1.96630906001971E-13,
0.277865428112502,
1.98886046520741E-13,
0.251674606160948,
1.93331461950663E-13,
0.234763266568309,
1.96651722683683E-13,
0.223425236009932,
1.91076321431893E-13,
0.215871027862441,
1.85854803769203E-13,
0.211163051774222,
1.77621806152217E-13,
0.208811474814812,
1.63993818524943E-13,
0.208605707584816,
1.59379454078845E-13,
0.210550783188985,
1.49888781941776E-14,
8.00817745449933E-14,
3.52209580944951E-14,
1.1395225041344E-13,
5.17138415423446E-14,
1.41154449240233E-13,
5.90499871222505E-14,
1.54114568329256E-13,
6.30745455865167E-14,
1.537936444862E-13,
6.23997381543617E-14,
1.5960149868377E-13,
6.39384378775532E-14,
1.73191322394572E-13,
7.32469640496447E-14,
1.86017867775945E-13,
7.06171232600639E-14,
1.93752999755326E-13,
6.51163151177414E-14,
1.89105675563184E-13,
5.85139575681737E-14,
1.8680890168099E-13,
4.63865057476198E-14,
1.88873222617403E-13,
4.27019530846451E-14,
1.9163837183811E-13,
3.69322628035462E-14,
1.89306903486397E-13,
0.804424963038377,
1.92158788880903E-13,
0.41563419126068,
1.95773952604839E-13,
0.322173926159728,
2.04683492377455E-13,
0.277625120167139,
1.94833732480859E-13,
0.251429078844498,
1.93844940099552E-13,
0.234519340585545,
1.9046569876835E-13,
0.22318730860138,
1.87658916184219E-13,
0.215642030595174,
1.81792081388465E-13,
0.210944979655229,
1.69867592214601E-13,
0.208605707584816,
1.53682622183737E-13,
0.208413219159128,
1.54619372860765E-13,
4.68266918296489E-14,
2.72880676388532E-14,
1.03499674108942E-13,
4.31911451048705E-14,
1.27908100777674E-13,
5.24042614857834E-14,
1.47871298539215E-13,
5.91471316369052E-14,
1.54133650287491E-13,
6.46600828435595E-14,
1.62106439383081E-13,
6.54632598129368E-14,
1.68892677621102E-13,
6.71580846489661E-14,
1.81367074136851E-13,
6.43859965343552E-14,
1.87957288622087E-13,
5.85226311855536E-14,
1.88203619355676E-13,
6.25558632671996E-14,
1.88793425337508E-13,
4.56405746529498E-14,
1.86500120902267E-13,
3.92498533674512E-14,
1.91013871386758E-13,
3.72792074987416E-14,
1.93949023508111E-13,
3.27064764160667E-14,
1.96478250336085E-13,
0.80434903030525,
1.96422739184854E-13,
0.415462978921447,
2.03885519578506E-13,
0.321967435855508,
2.00863631283354E-13,
0.277402886343562,
1.95288230031565E-13,
0.251201501931991,
1.87825449637913E-13,
0.234292771356534,
1.86999721263348E-13,
0.222965877764235,
1.83353332516845E-13,
0.215428520730332,
1.73961539617906E-13,
0.210741307802509,
1.59382923525797E-13,
0.208413219159128,
1.48846213132714E-13,
0.208232880310022,
1.65254095130241E-14,
8.08650021943969E-14,
3.67301675185949E-14,
1.19942250575988E-13,
4.44635647744995E-14,
1.35782010635133E-13,
5.28709021008211E-14,
1.48540901800942E-13,
6.09269579232574E-14,
1.62824614902135E-13,
6.7836361528073E-14,
1.71697725481756E-13,
6.87332135651531E-14,
1.7726271839269E-13,
5.83491588379559E-14,
1.83474763160163E-13,
5.23765059101677E-14,
1.82557094441371E-13,
5.59795265697716E-14,
1.87960758069039E-13,
4.96182955833646E-14,
1.88623422436862E-13,
3.85871889996281E-14,
1.88783016996652E-13,
3.3879149485827E-14,
1.93407789783606E-13,
3.31921989893402E-14,
2.01203637084646E-13,
3.2310959463544E-14,
2.00381378157033E-13,
0.804279180587048,
2.04270628190173E-13,
0.415305073112824,
2.00017086227078E-13,
0.321776516373611,
2.01366701091388E-13,
0.277196934246116,
1.89358945190676E-13,
0.250990145509843,
1.84324777663392E-13,
0.234081931177913,
1.82808629345388E-13,
0.222759436237109,
1.75713610328643E-13,
0.215229118049781,
1.63601771019373E-13,
0.210550783188985,
1.54650597883332E-13,
0.208232880310022,
1.50060519565898E-13,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.00000000000001,
1.7129093282664E-14,
1.4733873843209E-14,
1.93100743728358E-14,
1.212051292665E-14,
1.92343970611963E-14,
  0,
1.83438333967167E-14,
1.51361128492011E-14,
2.21146885526213E-14,
1.5631593242027E-14,
2.30557760383387E-14,
1.69842438724199E-14,
2.49500940741054E-14,
1.09638860490424E-14,
1.89188942290031E-14,
1.33738506380432E-14,
2.68244627898984E-14,
1.49836740237497E-14,
2.79602729857942E-14,
1.83295219280399E-14,
3.73720152047063E-14,
1.49368364898983E-14,
3.69175176540004E-14,
1.75688456838241E-14,
4.53794987698153E-14,
1.57018495428041E-14,
4.78640564682831E-14,
1.59464455529168E-14,
4.52138326778595E-14,
  0,
  0,
  0,
  0,
  0,
  0,
1.08608868426563E-14,
  0,
1.36739577993872E-14,
  0,
1.07778369562439E-14,
  0,
1.03753811098173E-14,
  0,
1.24227884923389E-14,
  0,
1.20259704972092E-14,
  0,
1.36978102471819E-14,
0.866296163648431,
2.30909041887273E-14,
0.866270980254385,
3.16951326295722E-14,
2.32201410876876E-14,
3.34467696594398E-14,
1.77865534800592E-14,
3.25833110492724E-14,
2.03699904166577E-14,
3.50279701077927E-14,
2.66518578040387E-14,
3.91028355528622E-14,
2.82465023593303E-14,
4.15340505044437E-14,
2.4234954321134E-14,
3.79674590378354E-14,
2.10977069148299E-14,
3.95872570835287E-14,
2.4533326759002E-14,
4.7420834620171E-14,
2.88206958298787E-14,
5.65901492333154E-14,
2.88371757029005E-14,
6.43391590005038E-14,
2.81554293768416E-14,
7.12633077548652E-14,
2.88232979150926E-14,
8.07626535093142E-14,
2.73930184091498E-14,
8.06212735460221E-14,
2.70946459712818E-14,
  0,
  0,
  0,
  0,
  0,
1.10298055411295E-14,
  0,
1.43218770176645E-14,
  0,
1.55873577933896E-14,
  0,
1.46809647771917E-14,
  0,
1.44064447871184E-14,
  0,
1.52018155008538E-14,
  0,
1.77804819478933E-14,
0.839078243550044,
2.51118570382403E-14,
0.560017024776354,
3.36453954974392E-14,
0.838979976657422,
4.11615186379777E-14,
2.61440175064465E-14,
4.25362869926893E-14,
2.75786338210793E-14,
4.49831144555546E-14,
2.85596199467442E-14,
4.7117691692744E-14,
3.56650473043452E-14,
5.23244642058884E-14,
3.18287063372225E-14,
4.91360424570431E-14,
3.15971207531796E-14,
5.4003676530634E-14,
2.91763141424539E-14,
5.43055184154539E-14,
3.49364634444349E-14,
6.94921550858929E-14,
3.53276435882677E-14,
7.53138870712711E-14,
3.84813708675935E-14,
9.00416893823142E-14,
3.5527136788005E-14,
9.64939933512099E-14,
3.69201197392144E-14,
1.02720783268229E-13,
3.49919745956662E-14,
1.01282697506644E-13,
  0,
  0,
  0,
  0,
  0,
  0,
1.3983605939849E-14,
  0,
1.56003682194594E-14,
  0,
1.88048361604576E-14,
  0,
1.82757455002847E-14,
  0,
1.66394675815695E-14,
  0,
2.02750143063479E-14,
0.827661681057511,
2.83167586601074E-14,
0.497792969806215,
3.4254717118376E-14,
0.49763277188551,
4.22543944278431E-14,
0.827440956235112,
4.85783288595165E-14,
3.48436557384701E-14,
5.30244251284451E-14,
3.47300313507937E-14,
5.5050582148386E-14,
3.63311811191203E-14,
5.82398712589693E-14,
3.78117676058665E-14,
5.77576181326478E-14,
3.78568704162419E-14,
6.30268406909273E-14,
3.85117285284231E-14,
6.64754709611692E-14,
3.82471831983366E-14,
7.37621769220098E-14,
3.99558858221738E-14,
8.51740553087232E-14,
4.34027813689397E-14,
9.75625830124116E-14,
4.4278816724308E-14,
1.11365777710759E-13,
4.20739831863415E-14,
1.14160417230558E-13,
4.29630289677796E-14,
1.19071419391048E-13,
3.64075089520632E-14,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
1.50292105149941E-14,
  0,
1.86062103224582E-14,
  0,
2.20357586344644E-14,
  0,
2.01349353856628E-14,
  0,
2.14836828882348E-14,
0.821525524653432,
3.04600095146768E-14,
0.471240667511765,
3.74249242707236E-14,
0.424406517429793,
4.17469878111199E-14,
0.470795133333837,
4.82478640373429E-14,
0.82112933885621,
5.82390038972314E-14,
4.13063680482217E-14,
6.20215684365988E-14,
4.15735154635222E-14,
6.51111109473135E-14,
3.75689063192297E-14,
6.2453514582117E-14,
4.30237442894388E-14,
7.04132932516366E-14,
4.39414130082305E-14,
7.41446834484627E-14,
4.67317157193392E-14,
8.44341957462191E-14,
4.24668980536502E-14,
8.77579259261907E-14,
4.71853459083071E-14,
1.05528433214097E-13,
4.82816911451245E-14,
1.16653214865536E-13,
4.99036575951628E-14,
1.26662569321923E-13,
4.72417244212764E-14,
1.28029531420992E-13,
4.35441613322318E-14,
1.33336917895743E-13,
  0,
  0,
1.10298055411295E-14,
  0,
  0,
  0,
1.02105823795995E-14,
  0,
1.79001778677357E-14,
  0,
2.15964399141733E-14,
  0,
2.37925998347599E-14,
  0,
2.49461909462845E-14,
0.817806993651533,
3.11495620963775E-14,
0.456797838982335,
3.90971977015653E-14,
0.392238950251277,
4.41244263349461E-14,
0.391902613368878,
4.75869343929958E-14,
0.455935003053882,
5.70203606553576E-14,
0.817176828114029,
6.68449670615523E-14,
4.76988240571963E-14,
7.11522854524027E-14,
4.2483377926672E-14,
6.84539230855208E-14,
4.23463347720698E-14,
7.43112169021565E-14,
4.85531753691149E-14,
8.06767846972534E-14,
5.16375137094016E-14,
9.12178318990264E-14,
5.03755023806285E-14,
9.74680405829709E-14,
4.91256341161872E-14,
1.06959580081778E-13,
5.14345510627123E-14,
1.2325297032989E-13,
5.32846336498416E-14,
1.30463348457788E-13,
5.44737865926237E-14,
1.3899992268307E-13,
4.72157035691367E-14,
1.40712094753859E-13,
4.69208005782207E-14,
  0,
1.0881703524368E-14,
  0,
1.40074583876437E-14,
  0,
1.02253275291453E-14,
  0,
1.30841518175551E-14,
  0,
2.08279574143155E-14,
  0,
2.31325375521507E-14,
  0,
2.81831849524572E-14,
0.815415573525731,
3.42139511166906E-14,
0.447974316949198,
3.93504673290579E-14,
0.374427415529464,
4.56579218877096E-14,
0.356586095090044,
4.9741460950159E-14,
0.373575797791596,
5.64062685448619E-14,
0.446549613127306,
6.51301929055492E-14,
0.814485086693892,
7.51820480870968E-14,
4.816719939571E-14,
7.40987132763493E-14,
4.6825390787042E-14,
7.98267701940247E-14,
4.75505052000003E-14,
8.39111766182121E-14,
5.5874575799475E-14,
9.69519603488678E-14,
5.48536910338626E-14,
1.03436356702069E-13,
5.66144353619791E-14,
1.1580666980926E-13,
5.29905980206635E-14,
1.23751703329233E-13,
5.59968738045313E-14,
1.36102934478188E-13,
5.74054692670245E-14,
1.41662723218694E-13,
5.40539835114373E-14,
1.5045603651842E-13,
5.02375918642883E-14,
1.40705155859955E-13,
  0,
  0,
1.43214433367955E-14,
  0,
1.50235726636971E-14,
  0,
1.3089355987983E-14,
  0,
1.59811400224363E-14,
  0,
2.21558882351758E-14,
  0,
2.74173045378134E-14,
0.81385197558937,
3.78152370528184E-14,
0.442268127097388,
4.22674048539129E-14,
0.363417258311836,
4.57672094666961E-14,
0.336784241948475,
5.0784029759221E-14,
0.336227992224048,
5.77177194927003E-14,
0.361857597738784,
6.38577732359202E-14,
0.440118507967341,
7.30075722099599E-14,
0.812543998668402,
7.76548964021018E-14,
5.250487544739E-14,
8.49147141490647E-14,
5.18500173352088E-14,
8.89271295489991E-14,
5.45414408081868E-14,
9.97223137400027E-14,
5.88036563886618E-14,
1.0861450627786E-13,
6.07725675338955E-14,
1.21163495903076E-13,
6.01879657224913E-14,
1.31887556431565E-13,
5.72406705368067E-14,
1.35782010635133E-13,
5.97698973647809E-14,
1.46440151671534E-13,
5.66682117897344E-14,
1.52265353103864E-13,
5.67202534940137E-14,
1.49625103973428E-13,
4.83450085519976E-14,
  0,
1.3687835587195E-14,
  0,
1.56116439220533E-14,
  0,
1.78984431442597E-14,
  0,
1.59204247007771E-14,
  0,
1.73455000362921E-14,
  0,
2.6556014331991E-14,
0.81286231764853,
3.7251451923126E-14,
0.438522831088767,
4.54922557957538E-14,
0.356239458942884,
4.84915926857177E-14,
0.324436678367385,
5.09115319347053E-14,
0.315096391143676,
5.86718174044876E-14,
0.323092640146989,
6.47823808486159E-14,
0.3537565998976,
7.16423448343662E-14,
0.435459427101372,
7.55714935074536E-14,
0.811084774506056,
8.80909928335782E-14,
5.71175051700124E-14,
9.3716701066171E-14,
5.85833465072128E-14,
1.04383515719952E-13,
5.71608732569118E-14,
1.10991077439948E-13,
6.44588549203462E-14,
1.25848984011689E-13,
6.40789504791073E-14,
1.36684066842641E-13,
6.41882380580938E-14,
1.4332458830868E-13,
6.07690980869435E-14,
1.45505135717983E-13,
5.87464105139546E-14,
1.56390525529737E-13,
5.90829468682941E-14,
1.50744000615433E-13,
5.46333811524136E-14,
1.55537041579557E-13,
  0,
  0,
1.5560035898643E-14,
  0,
1.86062103224582E-14,
  0,
2.08036712856519E-14,
  0,
1.73186118224145E-14,
  0,
2.1616389234147E-14,
0.812312369658877,
3.59165822083618E-14,
0.436146154698005,
4.48209178105508E-14,
0.351502018334164,
5.15152157043453E-14,
0.31633710968712,
5.32933072672215E-14,
0.301833151302527,
5.87750334513082E-14,
0.301009641182497,
6.57971940820623E-14,
0.313950363461763,
7.29364485474449E-14,
0.347848652921533,
7.35279892527529E-14,
0.431944446177945,
8.55478882177962E-14,
0.80995252746212,
9.65668517372009E-14,
6.36071056936416E-14,
1.08817468924549E-13,
6.10275718848641E-14,
1.15258497190851E-13,
6.25974966306231E-14,
1.27802282645639E-13,
6.74408445755503E-14,
1.40980976892635E-13,
6.78016670585535E-14,
1.47652723381242E-13,
6.74963557267816E-14,
1.52615767246012E-13,
5.95027499494805E-14,
1.54950705044676E-13,
6.09876732449166E-14,
1.54322735146373E-13,
5.68069896678125E-14,
1.56135521178768E-13,
5.83890574779033E-14,
  0,
1.07613570832221E-14,
  0,
1.87805500317939E-14,
  0,
2.16259302132649E-14,
  0,
2.21255305743462E-14,
  0,
2.1616389234147E-14,
0.812135760814598,
3.11044592860021E-14,
0.43482333130513,
4.35146710331402E-14,
0.348484477158565,
5.06730074567585E-14,
0.31096787127609,
5.63516247553686E-14,
0.293091375681759,
6.1181094912488E-14,
0.287079213293161,
6.55742821153993E-14,
0.291154961475847,
7.32643112844045E-14,
0.307248191370839,
7.44647399297804E-14,
0.343368512614843,
8.3398565831061E-14,
0.42920939777521,
9.41521166586412E-14,
0.809051829349251,
1.11521902823597E-13,
6.60686783060527E-14,
1.19458262726191E-13,
6.63236826570213E-14,
1.31707145190063E-13,
6.552224041112E-14,
1.42549166914918E-13,
7.11115194507173E-14,
1.51557585925666E-13,
7.10022318717307E-14,
1.56517160343483E-13,
6.61085769460001E-14,
1.61648472385423E-13,
6.15427847572292E-14,
1.52511683837453E-13,
5.848967143951E-14,
1.59277105393762E-13,
6.03701116874689E-14,
1.65405883434389E-13,
  0,
  0,
1.46952762458685E-14,
  0,
2.2063947890949E-14,
  0,
2.31741709155742E-14,
  0,
2.65213198624714E-14,
0.812312369658877,
3.1042876602605E-14,
0.434398197645027,
3.85594334240125E-14,
0.346801057784456,
4.95081406426401E-14,
0.307537644741315,
5.53021170524026E-14,
0.287276468896016,
6.39323663453872E-14,
0.277863235966416,
6.79560574479154E-14,
0.276717885643536,
7.29347138239689E-14,
0.2839013939158,
7.48220929658316E-14,
0.302144784116402,
8.43873582123678E-14,
0.33986821141284,
9.18119746895485E-14,
0.427028727013766,
1.08345624139083E-13,
0.80832074725954,
1.21852181123039E-13,
7.12190723062278E-14,
1.35726499483901E-13,
6.91738333280512E-14,
1.46228515407465E-13,
6.89812790222177E-14,
1.52865567426552E-13,
7.4124734128489E-14,
1.60073343469236E-13,
6.94912877241549E-14,
1.65206390234651E-13,
6.80219769400026E-14,
1.58852098142148E-13,
5.89858023536394E-14,
1.57108701048791E-13,
6.1933097539324E-14,
1.68190114613331E-13,
6.8287389631827E-14,
  0,
1.03797179185072E-14,
  0,
1.82601329890009E-14,
  0,
2.37960692817119E-14,
  0,
2.74173045378134E-14,
0.81286231764853,
3.59226537405277E-14,
0.43482333130513,
3.86982113020906E-14,
0.346259432905461,
4.44887182649012E-14,
0.305620403204274,
5.41112293861445E-14,
0.28355264563295,
6.27648974460548E-14,
0.271716065823307,
7.07836567137576E-14,
0.267138026626042,
7.52644474522057E-14,
0.269067803243008,
7.46243344895703E-14,
0.278360219293801,
8.45573611130135E-14,
0.298144246419434,
9.23931070540007E-14,
0.337068164487874,
1.06185893411492E-13,
0.425255406531269,
1.18675902438525E-13,
0.807717379468084,
1.37868882976733E-13,
7.37309518994422E-14,
1.49867965260064E-13,
7.24437870802674E-14,
1.56204910117808E-13,
7.19060228027146E-14,
1.61088156702682E-13,
7.25391968714462E-14,
1.68474609263392E-13,
7.12867265217909E-14,
1.62052662955325E-13,
6.53140735940028E-14,
1.63169824873854E-13,
6.22713686171394E-14,
1.65702521148781E-13,
6.9711597605604E-14,
1.82116474678473E-13,
  0,
  0,
1.44064447871184E-14,
  0,
2.01418742795667E-14,
  0,
2.81701745263874E-14,
0.81385197558937,
3.71352254502355E-14,
0.436146154698005,
4.35216099270441E-14,
0.346801057784456,
4.44956571588051E-14,
0.305002989835876,
4.87838935914198E-14,
0.281468164118274,
6.15783465884867E-14,
0.267771882256098,
6.93837348686444E-14,
0.26073392966398,
7.8010514714677E-14,
0.259200764185968,
7.63295676664555E-14,
0.26320899721312,
8.41982733534863E-14,
0.274005003852978,
9.23237181149617E-14,
0.294935290443303,
1.06817332756748E-13,
0.334784964943633,
1.16280249318201E-13,
0.423789595776149,
1.34541683349809E-13,
0.807212394818267,
1.51562790096094E-13,
7.70581515263657E-14,
1.59617111195054E-13,
7.52765905165376E-14,
1.64276578451528E-13,
7.01886465614976E-14,
1.69269112615389E-13,
7.42825939648029E-14,
1.65147409636468E-13,
6.84764744907085E-14,
1.66177835381198E-13,
6.85389245358436E-14,
1.71513844793303E-13,
6.99856839148083E-14,
1.79382550480334E-13,
6.54684639833647E-14,
  0,
1.24353652375397E-14,
  0,
1.66915092858488E-14,
  0,
2.49461909462845E-14,
0.815415573525731,
3.77562564546352E-14,
0.438522831088767,
4.48720921530921E-14,
0.348484477158565,
4.9438751703601E-14,
0.305620403204274,
4.87179740993327E-14,
0.280796403340974,
5.65103519534205E-14,
0.265561344040425,
6.81468770302729E-14,
0.256618428611851,
7.65412039305247E-14,
0.252592632351309,
7.91883919548653E-14,
0.253110330731196,
8.62730026307545E-14,
0.258594543458363,
9.17634024322211E-14,
0.270503867160065,
1.06619574280487E-13,
0.292312707154143,
1.16353107704192E-13,
0.332893400862313,
1.31861535579425E-13,
0.422561187549681,
1.4840385864634E-13,
0.80678467027483,
1.61520102848201E-13,
7.96793186985667E-14,
1.67480612711657E-13,
7.3449926696334E-14,
1.72232020312357E-13,
7.17932657767761E-14,
1.65647009997549E-13,
7.13387682260702E-14,
1.68979413794901E-13,
7.16492837282701E-14,
1.74282463460962E-13,
7.61751772770936E-14,
1.84928461433032E-13,
6.56263238196786E-14,
1.83242310214382E-13,
  0,
  0,
1.51879377130459E-14,
  0,
2.14004161613879E-14,
0.817806993651533,
3.4181858732385E-14,
0.442268127097389,
4.55148072009415E-14,
0.351502018334164,
5.06712727332825E-14,
0.307537644741315,
5.41112293861445E-14,
0.281468164118274,
5.65103519534205E-14,
0.264848534591391,
6.29496454962464E-14,
0.254309551144675,
7.52054668540225E-14,
0.248340480842514,
7.78700021131229E-14,
0.246336787803849,
8.86634515806506E-14,
0.248305757403928,
9.39855832049474E-14,
0.254878541543898,
1.06067932215126E-13,
0.267637207651043,
1.16514436987458E-13,
0.290135808487614,
1.32180724699005E-13,
0.331305148354566,
1.45165129916691E-13,
0.421519558002028,
1.57740140394047E-13,
0.806418623809552,
1.69093905544315E-13,
7.7710407553333E-14,
1.7535278784564E-13,
7.49348499917701E-14,
1.68523181520719E-13,
6.88338275267597E-14,
1.69392277982183E-13,
7.44022898846453E-14,
1.76946998720062E-13,
7.91259419097301E-14,
1.87549628605232E-13,
7.18140824584879E-14,
1.8852107375178E-13,
5.31085592170299E-14,
  0,
1.20021180494145E-14,
  0,
2.03287907341032E-14,
0.821525524653432,
3.1261451760578E-14,
0.447974316949198,
4.22682722156509E-14,
0.356239458942884,
5.15152157043453E-14,
0.31096787127609,
5.53021170524026E-14,
0.28355264563295,
6.1633857739718E-14,
0.265561344040425,
6.30190344352854E-14,
0.253564665193103,
7.01817076675937E-14,
0.245952941653093,
7.64683455445336E-14,
0.241973448151382,
8.73190408867686E-14,
0.241395863745195,
9.64697072225462E-14,
0.244431427605317,
1.07766226498107E-13,
0.251831467984415,
1.15886467089155E-13,
0.265253979303917,
1.32106131589538E-13,
0.288304991078933,
1.4568728168296E-13,
0.329956179316327,
1.54700904864136E-13,
0.420627276153743,
1.65449251521288E-13,
0.806102521371949,
1.77068429363381E-13,
7.93167614920876E-14,
1.71512110069827E-13,
7.19199005905224E-14,
1.71963138173581E-13,
7.18331644167236E-14,
1.77158634984131E-13,
8.18529272139656E-14,
1.90032017899355E-13,
7.46919887051334E-14,
1.90972238023335E-13,
5.91835608299007E-14,
1.82961285011274E-13,
  0,
  0,
1.77822166713693E-14,
0.827661681057511,
3.04947039841963E-14,
0.456797838982335,
3.93383242647261E-14,
0.363417258311836,
4.84603676631501E-14,
0.31633710968712,
5.63533594788446E-14,
0.287276468896016,
6.27059168478716E-14,
0.267771882256098,
6.82023881815041E-14,
0.254309551144675,
7.01747687736898E-14,
0.245182362211513,
7.13977488242534E-14,
0.239521753624819,
8.59052412538475E-14,
0.236940588686387,
9.47367184700454E-14,
0.237407573546298,
1.10389128393784E-13,
0.241250875740221,
1.17532719667857E-13,
0.249295058999633,
1.31179789253366E-13,
0.263246939995837,
1.45484319036271E-13,
0.286747820167857,
1.54919480022109E-13,
0.328798990783523,
1.62272972836774E-13,
0.419856097484852,
1.72663966457876E-13,
0.805827367137784,
1.72910297191464E-13,
7.60606855276791E-14,
1.74913902806217E-13,
7.49105638631065E-14,
1.7966877985387E-13,
7.92439031060965E-14,
1.90082324880159E-13,
7.73148906008103E-14,
1.93282889693336E-13,
6.20458545652625E-14,
1.85235507488279E-13,
5.31519273039294E-14,
  0,
1.38079651879064E-14,
0.839078243550044,
2.83098197662035E-14,
0.471240667511765,
3.90980650633033E-14,
0.374427415529464,
4.57611379345302E-14,
0.324436678367385,
5.32863683733176E-14,
0.293091375681759,
6.38811920028459E-14,
0.271716065823307,
6.93767959747404E-14,
0.256618428611851,
7.52644474522057E-14,
0.245952941653093,
7.14480558050568E-14,
0.238730194784899,
8.09161765369382E-14,
0.234435742400711,
9.33107757727925E-14,
0.232875259985668,
1.08871245352304E-13,
0.234130651786542,
1.19744492099727E-13,
0.238600745768499,
1.32796551532977E-13,
0.247156699695766,
1.44483383590632E-13,
0.261537903409587,
1.54409471320172E-13,
0.285410405800606,
1.62200114450783E-13,
0.32779763172175,
1.69456462750794E-13,
0.419184330041138,
1.68452057858204E-13,
0.805586155617856,
1.75991166084799E-13,
7.90201237776955E-14,
1.82269130344359E-13,
8.21807899509253E-14,
1.92443283530963E-13,
7.46017830843826E-14,
1.93241256329912E-13,
6.46704911844154E-14,
1.87409116003678E-13,
5.59899349106274E-14,
1.86729104401095E-13,
  0,
0.866296163648431,
2.50845351434936E-14,
0.497792969806215,
3.74231895472477E-14,
0.392238950251277,
4.57099635919889E-14,
0.336784241948475,
5.085775550695E-14,
0.301833151302527,
6.11568087838243E-14,
0.277863235966416,
7.08252900771811E-14,
0.26073392966398,
7.65481428244286E-14,
0.248340480842514,
7.64527330332498E-14,
0.239521753624819,
8.0926584877794E-14,
0.233626785520911,
8.83425277375949E-14,
0.230325799373445,
1.07580611086178E-13,
0.229533046149056,
1.18275181315575E-13,
0.231398199448144,
1.35233838016724E-13,
0.236364604538073,
1.46195555661421E-13,
0.245334125349902,
1.53694765248069E-13,
0.260068570855249,
1.61893068395536E-13,
0.284251862753047,
1.69515443348978E-13,
0.326924419449755,
1.65246288874599E-13,
0.418595054718875,
1.71456598918596E-13,
0.805373355269897,
1.83412313115028E-13,
8.64395360844483E-14,
1.9503149095712E-13,
7.75803032926348E-14,
1.95473845443495E-13,
6.19920781375072E-14,
1.87228704762177E-13,
5.85139575681737E-14,
1.88763935038416E-13,
4.95957441781769E-14,
1.00000000000001,
2.30896031461203E-14,
0.560017024776354,
3.42477782244721E-14,
0.424406517429793,
4.41513145488237E-14,
0.356586095090044,
5.0714640820182E-14,
0.315096391143676,
5.87646251104523E-14,
0.287079213293161,
6.79543227244395E-14,
0.267138026626042,
7.80035758207731E-14,
0.25259263235131,
7.78075520679877E-14,
0.241973448151382,
8.58497301026162E-14,
0.234435742400711,
8.83720180366865E-14,
0.229502226886249,
1.02237662780169E-13,
0.226945719096924,
1.16892606705221E-13,
0.226744712162606,
1.33826977277707E-13,
0.229091112084479,
1.48587739334793E-13,
0.234457270357098,
1.55346221997199E-13,
0.243765888693579,
1.60696109197112E-13,
0.258794624590431,
1.68949923495809E-13,
0.283240640252049,
1.64887201115071E-13,
0.326157712418489,
1.68618591311898E-13,
0.418074893559358,
1.79587247850499E-13,
0.805184544259158,
1.9579476928655E-13,
8.17818035514506E-14,
1.97921540268098E-13,
6.47485537408343E-14,
1.89339863232441E-13,
5.58806473316409E-14,
1.88519339028304E-13,
5.21128279418193E-14,
1.89865484445662E-13,
1.7129093282664E-14,
0.866270980254385,
3.36323850713693E-14,
0.49763277188551,
4.17200995972422E-14,
0.391902613368878,
4.97284505240891E-14,
0.336227992224048,
5.86752868514395E-14,
0.301009641182497,
6.55656084980194E-14,
0.276717885643536,
7.52679168991577E-14,
0.259200764185968,
7.91918614018172E-14,
0.246336787803849,
8.73693478675719E-14,
0.236940588686387,
9.32413868337534E-14,
0.230325799373445,
1.02263683632309E-13,
0.226109732771155,
1.11700579341623E-13,
0.224124935799489,
1.32276134490183E-13,
0.224389385286787,
1.47130571614973E-13,
0.227122157279545,
1.57596158345541E-13,
0.232815031293391,
1.62710123152721E-13,
0.242405205135111,
1.68053071458729E-13,
0.25768180444465,
1.64816077452556E-13,
0.282352024824522,
1.6810858260996E-13,
0.325480363498886,
1.75885347952764E-13,
0.417613139122167,
1.91841334484799E-13,
0.805016148622167,
1.98643185234104E-13,
6.88945428484189E-14,
1.91631432944206E-13,
5.87203896618149E-14,
1.90566312729956E-13,
4.93875773610597E-14,
1.89469967493139E-13,
4.13974410307105E-14,
1.4733873843209E-14,
3.17007704808692E-14,
0.838979976657422,
4.23047014086464E-14,
0.470795133333837,
4.757218924345E-14,
0.373575797791595,
5.77194542161763E-14,
0.323092640146989,
6.57954593585863E-14,
0.291154961475847,
7.29347138239689E-14,
0.269067803243008,
7.63764052003069E-14,
0.253110330731196,
8.86894724327902E-14,
0.241395863745195,
9.47367184700454E-14,
0.232875259985668,
1.07591019427034E-13,
0.226945719096924,
1.11672823766007E-13,
0.223278304990484,
1.27177782194288E-13,
0.22174156678763,
1.4555370797531E-13,
0.222378470802816,
1.55934293255555E-13,
0.225426024067155,
1.6488373166812E-13,
0.23138931955141,
1.69537994754165E-13,
0.241215856466445,
1.63511565398622E-13,
0.256703232100725,
1.67648880888827E-13,
0.281566401315083,
1.7514115158157E-13,
0.324878623315048,
1.882018846322E-13,
0.417201127439328,
1.94493726679568E-13,
0.804865250827688,
1.92356547357164E-13,
6.30294427761413E-14,
1.92925536657285E-13,
5.2208237732998E-14,
1.91454491149656E-13,
3.86080056813398E-14,
1.88234844378243E-13,
1.93100743728358E-14,
2.31923855120719E-14,
4.11571818292877E-14,
0.827440956235112,
4.82634765486267E-14,
0.455935003053882,
5.64374935674294E-14,
0.361857597738784,
6.47832482103539E-14,
0.313950363461763,
7.32660460078804E-14,
0.2839013939158,
7.46815803642775E-14,
0.26320899721312,
8.62816762481344E-14,
0.248305757403928,
9.64436863704066E-14,
0.237407573546298,
1.0888165369316E-13,
0.229533046149056,
1.16923831727789E-13,
0.224124935799489,
1.27151761342148E-13,
0.220885732261924,
1.40313108354384E