# AUTOGENERATED! DO NOT EDIT! File to edit: 09_utils.ipynb (unless otherwise specified).

__all__ = ['checkIsListOfStr', 'checkUnique', 'checkNoRepeated', 'checkValidArray', 'checkValidDict', 'checkDictArray']

# Cell
def checkIsListOfStr(l):
    "Make sure that l is a list containing only strings"
    if not isinstance(l, list):
        raise Exception(str(l) + ' must be a list of strings')
    for i in l:
        if not isinstance(i, str):
            raise Exception(str(i) + ' must be a string')

# Cell
def checkUnique(l):
    "Make sure that l does not contain repeated elements"
    for i, item1 in enumerate(l):
        for j, item2 in enumerate(l):
            if i != j and item1 == item2:
                raise Exception('Repeated item ' + str(item1))

# Cell
def checkNoRepeated(l1, l2):
    "Make sure there are no repeated elements in both lists"
    for i in l1:
        if i in l2:
            raise Exception('Repeated item ' + str(i))

# Cell
import numpy as np

def checkValidArray(a):
    "Make sure an array is a numpy array with only 1 dimension"
    if not isinstance(a, np.ndarray):
        raise Exception('Values must be numpy arrays !')
    if not a.ndim == 1:
        raise Exception('Arrays must have only one dimension !')

# Cell
def checkValidDict(d):
    "Make sure d is a dict with valid arrays (numpy arrays with only 1 dimension)"
    if not isinstance(d, dict):
        raise Exception('Values must be a dictionary !')
    for k in d:
        checkValidArray(d[k])

# Cell
def checkDictArray(d, a):
    "Make sure that every key in a d is in a"
    for k in d.keys():
        if not k in a:
            raise Exception(k + ' is not present in ' + str(a))