import unittest
import validator

class TestIsDecimal(unittest.TestCase):

    def test_valid_decimale(self) -> bool:
        self.assertTrue(validator.is_decimal('123'))
        self.assertTrue(validator.is_decimal('00123'))
        self.assertTrue(validator.is_decimal('-00123'))
        self.assertTrue(validator.is_decimal('0'))
        self.assertTrue(validator.is_decimal('-0'))
        self.assertTrue(validator.is_decimal('+123'))
        self.assertTrue(validator.is_decimal('0.01'))
        self.assertTrue(validator.is_decimal('.1'))
        self.assertTrue(validator.is_decimal('1.0'))
        self.assertTrue(validator.is_decimal('-.25'))
        self.assertTrue(validator.is_decimal('-0'))
        self.assertTrue(validator.is_decimal('0.0000000000001'))
        print('OK - test_valid_decimale')

    def test_invalid_decimale(self):
        self.assertFalse(validator.is_decimal('0,01'))
        self.assertFalse(validator.is_decimal(',1'))
        self.assertFalse(validator.is_decimal('1,0'))
        self.assertFalse(validator.is_decimal('-,25'))
        self.assertFalse(validator.is_decimal('0,0000000000001'))
        self.assertFalse(validator.is_decimal('0٫01'))
        self.assertFalse(validator.is_decimal('٫1'))
        self.assertFalse(validator.is_decimal('1٫0'))
        self.assertFalse(validator.is_decimal('-٫25'))
        self.assertFalse(validator.is_decimal('0٫0000000000001'))
        self.assertFalse(validator.is_decimal('....'))
        self.assertFalse(validator.is_decimal(' '))
        self.assertFalse(validator.is_decimal('-'))
        self.assertFalse(validator.is_decimal('+'))
        self.assertFalse(validator.is_decimal('.'))
        self.assertFalse(validator.is_decimal('0.1a'))
        self.assertFalse(validator.is_decimal('a'))
        self.assertFalse(validator.is_decimal('\n'))
        print('OK - test_invalid_decimale')

    def test_valid_decimale_locale_en_au(self) -> bool:
        self.assertTrue(validator.is_decimal('123', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('00123', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('-00123', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('0', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('-0', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('+123', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('0.01', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('.1', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('1.0', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('-.25', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('-0', { "locale": "en-AU" }))
        self.assertTrue(validator.is_decimal('0.0000000000001', { "locale": "en-AU" }))
        print('OK - test_valid_decimale_locale_en_au')

    def test_invalid_decimale_locale_en_au(self):
        self.assertFalse(validator.is_decimal('0,01', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal(',1', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('1,0', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('-,25', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('0,0000000000001', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('0٫01', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('٫1', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('1٫0', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('-٫25', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('0٫0000000000001', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('....', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal(' ', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('-', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('+', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('.', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('0.1a', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('a', { "locale": "en-AU" }))
        self.assertFalse(validator.is_decimal('\n', { "locale": "en-AU" }))
        print('OK - test_invalid_decimale_locale_en_au')

    def test_valid_decimale_locale_ar(self) -> bool:
        self.assertTrue(validator.is_decimal('123', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('00123', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('-00123', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('0٫01', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('٫1', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('1٫0', { "locale": "ar" }))
        self.assertTrue(validator.is_decimal('-٫25', { "locale": "ar" }))
        print('OK - test_valid_decimale_locale_ar')

    def test_invalid_decimale_locale_ar(self):
        self.assertFalse(validator.is_decimal('0.01', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('.1', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('1.0', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('-.25', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('0.0000000000001', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('0.01', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('.1', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('1.0', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('-.25', { "locale": "ar" }))
        self.assertFalse(validator.is_decimal('0.0000000000001', { "locale": "ar" }))
        print('OK - test_invalid_decimale_locale_ar')

    def test_valid_decimale_locale_force_decimal(self) -> bool:
        self.assertTrue(validator.is_decimal('0.01', { "force_decimal": True }))
        self.assertTrue(validator.is_decimal('.1', { "force_decimal": True }))
        self.assertTrue(validator.is_decimal('1.0', { "force_decimal": True }))
        self.assertTrue(validator.is_decimal('-.25', { "force_decimal": True }))
        self.assertTrue(validator.is_decimal('0.0000000000001', { "force_decimal": True }))
        print('OK - test_valid_decimale_locale_force_decimal')

    def test_invalid_decimale_locale_force_decimal(self):
        self.assertFalse(validator.is_decimal('-0', { "force_decimal": True }))
        self.assertFalse(validator.is_decimal('123', { "force_decimal": True }))
        self.assertFalse(validator.is_decimal('00123', { "force_decimal": True }))
        self.assertFalse(validator.is_decimal('0', { "force_decimal": True }))
        self.assertFalse(validator.is_decimal('+123', { "force_decimal": True }))
        print('OK - test_invalid_decimale_locale_force_decimal')

    def test_valid_decimale_locale_decimal_digits_2_3(self) -> bool:
        self.assertTrue(validator.is_decimal('123', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('00123', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('-00123', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('0', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('-0', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('+123', { "decimal_digits": "2,3" }))
        self.assertTrue(validator.is_decimal('-.255', { "decimal_digits": "2,3" }))
        print('OK - test_valid_decimale_locale_decimal_digits_2_3')

    def test_invalid_decimale_locale_decimal_digits_2_3(self):
        self.assertFalse(validator.is_decimal('0.0000000000001', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('0.0', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('.1', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('1.0', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('-.2564', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('0.0', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('٫1', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('1٫0', { "decimal_digits": "2,3" }))
        self.assertFalse(validator.is_decimal('-٫25', { "decimal_digits": "2,3" }))
        print('OK - test_valid_decimale_locale_decimal_digits_2_3')
