import { CommonActionProps, IStage, ActionBindOptions, ActionConfig } from '@aws-cdk/aws-codepipeline';
import { Action } from '@aws-cdk/aws-codepipeline-actions';
import { Construct } from '@aws-cdk/core';
import { ChannelTypes } from './channel-types';
export interface SlackApprovalActionProps extends CommonActionProps {
    readonly slackBotToken: string;
    readonly slackSigningSecret: string;
    readonly slackChannel?: string;
    readonly slackChannelId?: string;
    readonly slackChannelTypes?: ChannelTypes[];
    readonly slackBotName?: string;
    readonly slackBotIcon?: string;
    readonly additionalInformation?: string;
    readonly externalEntityLink?: string;
}
export declare class SlackApprovalAction extends Action {
    private props;
    constructor(props: SlackApprovalActionProps);
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    protected bound(scope: Construct, stage: IStage, options: ActionBindOptions): ActionConfig;
}
