"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
__exportStar(require("./policy"), exports);
/**
 * (experimental) Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @experimental
 */
class AwsExternalDns extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'external-dns';
        this.deploymentName = 'external-dns';
        this.namespace = (_c = options.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.image = (_d = options.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/external-dns/external-dns:v0.7.6';
        new cdk8s.ApiObject(this, 'external-dns-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRole',
            metadata: {
                name: 'external-dns',
            },
            rules: [
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'services',
                        'endpoints',
                        'pods',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        'extensions',
                        'networking.k8s.io',
                    ],
                    resources: [
                        'ingresses',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'nodes',
                    ],
                    verbs: [
                        'list',
                        'watch',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-cluster-role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRoleBinding',
            metadata: {
                name: 'external-dns-viewer',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'external-dns',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-deploy', {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                name: this.deploymentName,
                namespace: this.namespace,
            },
            spec: {
                strategy: {
                    type: 'Recreate',
                },
                selector: {
                    matchLabels: {
                        app: this.deploymentName,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: this.deploymentName,
                        },
                    },
                    spec: {
                        serviceAccountName: this.serviceAccountName,
                        containers: [
                            {
                                name: this.deploymentName,
                                image: this.image,
                                args: this.argsFunc(options.args),
                            },
                        ],
                        securityContext: {
                            fsGroup: 65534,
                        },
                    },
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--source=service', '--source=ingress', '--provider=aws', '--registry=txt'];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
}
exports.AwsExternalDns = AwsExternalDns;
_a = JSII_RTTI_SYMBOL_1;
AwsExternalDns[_a] = { fqn: "@opencdk8s/cdk8s-external-dns-route53.AwsExternalDns", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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