"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const index_1 = require("./index");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack', { env });
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'defaultVpc', {
    isDefault: true,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: stack.node.tryGetContext('GITLAB_TOKEN') ?? 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    dockerVolumes: [
        {
            hostPath: '/tmp/cahce',
            containerPath: '/tmp/cahce',
        },
    ],
});
//runner.expireAfter(Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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