# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openeo_pg_parser_networkx']

package_data = \
{'': ['*']}

install_requires = \
['networkx[default]>=2.8.6,<3.0.0',
 'pydantic>=1.9.1,<2.0.0',
 'pyproj>=3.4.0,<4.0.0',
 'shapely==1.8.4']

setup_kwargs = {
    'name': 'openeo-pg-parser-networkx',
    'version': '2022.11.0',
    'description': 'Parse OpenEO process graphs from JSON to traversible Python objects.',
    'long_description': "# OpenEO Process Graph Parser (Python & networkx)\nPython package to parse OpenEO process graphs from raw JSON into fully traversible [`networkx`](https://github.com/networkx/networkx) graph objects.\nThis package is an evolution of the [openeo-pg-parser-python](https://github.com/Open-EO/openeo-pg-parser-python) package.\n\n## Installation\nThis package can be installed with pip:\n\n```\npip install openeo-pg-parser-networkx\n```\n\nCurrently Python versions 3.9 and 3.10 are supported.\n\n## Development environment\n`openeo-pg-parser-networkx` requires poetry `>1.2`, see their [docs](https://python-poetry.org/docs/#installation) for installation instructions.\n\nTo setup the python venv and install this project into it run:\n```\npoetry install\n```\n\nTo add a new core dependency run:\n```\npoetry add some_new_dependency\n```\n\nTo add a new development dependency run:\n```\npoetry add some_new_dependency --group dev\n```\n\nTo run the test suite run:\n```\npoetry run python -m pytest\n```\n\nNote that you can also use the virtual environment that's generated by poetry as the kernel for the ipynb notebooks.\n\n### Pre-commit hooks\nThis repo makes use of [pre-commit](https://pre-commit.com/) hooks to enforce linting & a few sanity checks.\nIn a fresh development setup, install the hooks using `poetry run pre-commit install`.\nThese will then automatically be checked against your changes before making the commit.\n",
    'author': 'Lukas Weidenholzer',
    'author_email': 'lukas.weidenholzer@eodc.eu',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Open-EO/openeo-pg-parser-networkx',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.11',
}


setup(**setup_kwargs)
