/**
 * Credentials for the Datadog API.
 *
 * @stability stable
 */
export interface DatadogCredentials {
    /**
     * Datadog API key.
     *
     * @stability stable
     */
    readonly apiKey: string;
    /**
     * Datadog application key.
     *
     * @stability stable
     */
    readonly applicationKey: string;
    /**
     * Datadog API URL (defaults to https://api.datadoghq.com) Use https://api.datadoghq.eu for EU accounts.
     *
     * @stability stable
     */
    readonly apiURL?: string;
}
