# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class ActivateMediaWorkflowRequest(TeaModel):
    def __init__(
        self,
        media_workflow_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.media_workflow_id = media_workflow_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ActivateMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        media_workflow_id: str = None,
        name: str = None,
        state: str = None,
        topology: str = None,
    ):
        self.creation_time = creation_time
        self.media_workflow_id = media_workflow_id
        self.name = name
        self.state = state
        self.topology = topology

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class ActivateMediaWorkflowResponseBody(TeaModel):
    def __init__(
        self,
        media_workflow: ActivateMediaWorkflowResponseBodyMediaWorkflow = None,
        request_id: str = None,
    ):
        self.media_workflow = media_workflow
        self.request_id = request_id

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = ActivateMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateMediaWorkflowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActivateMediaWorkflowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActivateMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddAsrPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddAsrPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddAsrPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddAsrPipelineResponseBodyPipelineNotifyConfig = None,
        priority: int = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddAsrPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddAsrPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddAsrPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddAsrPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAsrPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddAsrPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddAsrPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        parent_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.cate_name = cate_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.parent_id = parent_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddCategoryResponseBodyCategory(TeaModel):
    def __init__(
        self,
        cate_id: str = None,
        cate_name: str = None,
        level: str = None,
        parent_id: str = None,
    ):
        self.cate_id = cate_id
        self.cate_name = cate_name
        self.level = level
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class AddCategoryResponseBody(TeaModel):
    def __init__(
        self,
        category: AddCategoryResponseBodyCategory = None,
        request_id: str = None,
    ):
        self.category = category
        self.request_id = request_id

    def validate(self):
        if self.category:
            self.category.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = AddCategoryResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCensorPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddCensorPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddCensorPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddCensorPipelineResponseBodyPipelineNotifyConfig = None,
        priority: int = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddCensorPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddCensorPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddCensorPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddCensorPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCensorPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCensorPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCensorPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCoverPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        role: str = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AddCoverPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddCoverPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddCoverPipelineResponseBodyPipelineNotifyConfig = None,
        priority: str = None,
        role: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.role = role
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.role is not None:
            result['Role'] = self.role
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddCoverPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddCoverPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddCoverPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddCoverPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCoverPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCoverPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCoverPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMCTemplateRequest(TeaModel):
    def __init__(
        self,
        abuse: str = None,
        ad: str = None,
        contraband: str = None,
        live: str = None,
        logo: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        politics: str = None,
        porn: str = None,
        qrcode: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        terrorism: str = None,
        spam: str = None,
    ):
        self.abuse = abuse
        self.ad = ad
        self.contraband = contraband
        self.live = live
        self.logo = logo
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.politics = politics
        self.porn = porn
        self.qrcode = qrcode
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.terrorism = terrorism
        self.spam = spam

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.live is not None:
            result['Live'] = self.live
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.spam is not None:
            result['spam'] = self.spam
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('spam') is not None:
            self.spam = m.get('spam')
        return self


class AddMCTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        abuse: str = None,
        ad: str = None,
        contraband: str = None,
        live: str = None,
        logo: str = None,
        name: str = None,
        politics: str = None,
        porn: str = None,
        qrcode: str = None,
        spam: str = None,
        template_id: str = None,
        terrorism: str = None,
    ):
        self.abuse = abuse
        self.ad = ad
        self.contraband = contraband
        self.live = live
        self.logo = logo
        self.name = name
        self.politics = politics
        self.porn = porn
        self.qrcode = qrcode
        self.spam = spam
        self.template_id = template_id
        self.terrorism = terrorism

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.live is not None:
            result['Live'] = self.live
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.name is not None:
            result['Name'] = self.name
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.spam is not None:
            result['Spam'] = self.spam
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Spam') is not None:
            self.spam = m.get('Spam')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        return self


class AddMCTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: AddMCTemplateResponseBodyTemplate = None,
    ):
        self.request_id = request_id
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddMCTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddMCTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddMCTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddMCTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cover_url: str = None,
        description: str = None,
        file_url: str = None,
        input_unbind: bool = None,
        media_workflow_id: str = None,
        media_workflow_user_data: str = None,
        override_params: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        tags: str = None,
        title: str = None,
    ):
        self.cate_id = cate_id
        self.cover_url = cover_url
        self.description = description
        self.file_url = file_url
        self.input_unbind = input_unbind
        self.media_workflow_id = media_workflow_id
        self.media_workflow_user_data = media_workflow_user_data
        self.override_params = override_params
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.tags = tags
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.input_unbind is not None:
            result['InputUnbind'] = self.input_unbind
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_user_data is not None:
            result['MediaWorkflowUserData'] = self.media_workflow_user_data
        if self.override_params is not None:
            result['OverrideParams'] = self.override_params
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('InputUnbind') is not None:
            self.input_unbind = m.get('InputUnbind')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowUserData') is not None:
            self.media_workflow_user_data = m.get('MediaWorkflowUserData')
        if m.get('OverrideParams') is not None:
            self.override_params = m.get('OverrideParams')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class AddMediaResponseBodyMediaFile(TeaModel):
    def __init__(
        self,
        state: str = None,
        url: str = None,
    ):
        self.state = state
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class AddMediaResponseBodyMediaRunIdList(TeaModel):
    def __init__(
        self,
        run_id: List[str] = None,
    ):
        self.run_id = run_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class AddMediaResponseBodyMediaTags(TeaModel):
    def __init__(
        self,
        tag: List[str] = None,
    ):
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class AddMediaResponseBodyMedia(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        cate_id: int = None,
        censor_state: str = None,
        cover_url: str = None,
        creation_time: str = None,
        description: str = None,
        duration: str = None,
        file: AddMediaResponseBodyMediaFile = None,
        format: str = None,
        fps: str = None,
        height: str = None,
        media_id: str = None,
        publish_state: str = None,
        run_id_list: AddMediaResponseBodyMediaRunIdList = None,
        size: str = None,
        tags: AddMediaResponseBodyMediaTags = None,
        title: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.cate_id = cate_id
        self.censor_state = censor_state
        self.cover_url = cover_url
        self.creation_time = creation_time
        self.description = description
        self.duration = duration
        self.file = file
        self.format = format
        self.fps = fps
        self.height = height
        self.media_id = media_id
        self.publish_state = publish_state
        self.run_id_list = run_id_list
        self.size = size
        self.tags = tags
        self.title = title
        self.width = width

    def validate(self):
        if self.file:
            self.file.validate()
        if self.run_id_list:
            self.run_id_list.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.size is not None:
            result['Size'] = self.size
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('File') is not None:
            temp_model = AddMediaResponseBodyMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('RunIdList') is not None:
            temp_model = AddMediaResponseBodyMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Tags') is not None:
            temp_model = AddMediaResponseBodyMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddMediaResponseBody(TeaModel):
    def __init__(
        self,
        media: AddMediaResponseBodyMedia = None,
        request_id: str = None,
    ):
        self.media = media
        self.request_id = request_id

    def validate(self):
        if self.media:
            self.media.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            temp_model = AddMediaResponseBodyMedia()
            self.media = temp_model.from_map(m['Media'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddMediaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaTagRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        tag: str = None,
    ):
        self.media_id = media_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class AddMediaTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddMediaTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddMediaTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaWorkflowRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        topology: str = None,
        trigger_mode: str = None,
    ):
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.topology = topology
        self.trigger_mode = trigger_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.topology is not None:
            result['Topology'] = self.topology
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        return self


class AddMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        media_workflow_id: str = None,
        name: str = None,
        state: str = None,
        topology: str = None,
        trigger_mode: str = None,
    ):
        self.creation_time = creation_time
        self.media_workflow_id = media_workflow_id
        self.name = name
        self.state = state
        self.topology = topology
        self.trigger_mode = trigger_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        return self


class AddMediaWorkflowResponseBody(TeaModel):
    def __init__(
        self,
        media_workflow: AddMediaWorkflowResponseBodyMediaWorkflow = None,
        request_id: str = None,
    ):
        self.media_workflow = media_workflow
        self.request_id = request_id

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = AddMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaWorkflowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddMediaWorkflowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        role: str = None,
        speed: str = None,
        speed_level: int = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.role = role
        self.speed = speed
        self.speed_level = speed_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role is not None:
            result['Role'] = self.role
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        return self


class AddPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        mq_tag: str = None,
        mq_topic: str = None,
        queue_name: str = None,
        topic: str = None,
    ):
        self.mq_tag = mq_tag
        self.mq_topic = mq_topic
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mq_tag is not None:
            result['MqTag'] = self.mq_tag
        if self.mq_topic is not None:
            result['MqTopic'] = self.mq_topic
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MqTag') is not None:
            self.mq_tag = m.get('MqTag')
        if m.get('MqTopic') is not None:
            self.mq_topic = m.get('MqTopic')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddPipelineResponseBodyPipelineNotifyConfig = None,
        quota_allocate: int = None,
        role: str = None,
        speed: str = None,
        speed_level: int = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.quota_allocate = quota_allocate
        self.role = role
        self.speed = speed
        self.speed_level = speed_level
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.quota_allocate is not None:
            result['QuotaAllocate'] = self.quota_allocate
        if self.role is not None:
            result['Role'] = self.role
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('QuotaAllocate') is not None:
            self.quota_allocate = m.get('QuotaAllocate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPornPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddPornPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddPornPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddPornPipelineResponseBodyPipelineNotifyConfig = None,
        priority: int = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddPornPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddPornPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddPornPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddPornPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPornPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddPornPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPornPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSmarttagTemplateRequest(TeaModel):
    def __init__(
        self,
        analyse_types: str = None,
        face_category_ids: str = None,
        industry: str = None,
        is_default: bool = None,
        keyword_config: str = None,
        knowledge_config: str = None,
        label_type: str = None,
        label_version: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scene: str = None,
        template_name: str = None,
    ):
        self.analyse_types = analyse_types
        self.face_category_ids = face_category_ids
        self.industry = industry
        self.is_default = is_default
        self.keyword_config = keyword_config
        self.knowledge_config = knowledge_config
        self.label_type = label_type
        self.label_version = label_version
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.scene = scene
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analyse_types is not None:
            result['AnalyseTypes'] = self.analyse_types
        if self.face_category_ids is not None:
            result['FaceCategoryIds'] = self.face_category_ids
        if self.industry is not None:
            result['Industry'] = self.industry
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.keyword_config is not None:
            result['KeywordConfig'] = self.keyword_config
        if self.knowledge_config is not None:
            result['KnowledgeConfig'] = self.knowledge_config
        if self.label_type is not None:
            result['LabelType'] = self.label_type
        if self.label_version is not None:
            result['LabelVersion'] = self.label_version
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalyseTypes') is not None:
            self.analyse_types = m.get('AnalyseTypes')
        if m.get('FaceCategoryIds') is not None:
            self.face_category_ids = m.get('FaceCategoryIds')
        if m.get('Industry') is not None:
            self.industry = m.get('Industry')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('KeywordConfig') is not None:
            self.keyword_config = m.get('KeywordConfig')
        if m.get('KnowledgeConfig') is not None:
            self.knowledge_config = m.get('KnowledgeConfig')
        if m.get('LabelType') is not None:
            self.label_type = m.get('LabelType')
        if m.get('LabelVersion') is not None:
            self.label_version = m.get('LabelVersion')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class AddSmarttagTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddSmarttagTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddSmarttagTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSmarttagTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTemplateRequest(TeaModel):
    def __init__(
        self,
        audio: str = None,
        container: str = None,
        mux_config: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        trans_config: str = None,
        video: str = None,
    ):
        self.audio = audio
        self.container = container
        self.mux_config = mux_config
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.trans_config = trans_config
        self.video = video

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio
        if self.container is not None:
            result['Container'] = self.container
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config
        if self.video is not None:
            result['Video'] = self.video
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            self.audio = m.get('Audio')
        if m.get('Container') is not None:
            self.container = m.get('Container')
        if m.get('MuxConfig') is not None:
            self.mux_config = m.get('MuxConfig')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransConfig') is not None:
            self.trans_config = m.get('TransConfig')
        if m.get('Video') is not None:
            self.video = m.get('Video')
        return self


class AddTemplateResponseBodyTemplateAudioVolume(TeaModel):
    def __init__(
        self,
        level: str = None,
        method: str = None,
    ):
        self.level = level
        self.method = method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class AddTemplateResponseBodyTemplateAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        qscale: str = None,
        remove: str = None,
        samplerate: str = None,
        volume: AddTemplateResponseBodyTemplateAudioVolume = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.qscale = qscale
        self.remove = remove
        self.samplerate = samplerate
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = AddTemplateResponseBodyTemplateAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class AddTemplateResponseBodyTemplateContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class AddTemplateResponseBodyTemplateMuxConfigGif(TeaModel):
    def __init__(
        self,
        dither_mode: str = None,
        final_delay: str = None,
        is_custom_palette: str = None,
        loop: str = None,
    ):
        self.dither_mode = dither_mode
        self.final_delay = final_delay
        self.is_custom_palette = is_custom_palette
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class AddTemplateResponseBodyTemplateMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class AddTemplateResponseBodyTemplateMuxConfigWebp(TeaModel):
    def __init__(
        self,
        loop: str = None,
    ):
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class AddTemplateResponseBodyTemplateMuxConfig(TeaModel):
    def __init__(
        self,
        gif: AddTemplateResponseBodyTemplateMuxConfigGif = None,
        segment: AddTemplateResponseBodyTemplateMuxConfigSegment = None,
        webp: AddTemplateResponseBodyTemplateMuxConfigWebp = None,
    ):
        self.gif = gif
        self.segment = segment
        self.webp = webp

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()
        if self.webp:
            self.webp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        if m.get('Webp') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        return self


class AddTemplateResponseBodyTemplateTransConfig(TeaModel):
    def __init__(
        self,
        adj_dar_method: str = None,
        is_check_audio_bitrate: str = None,
        is_check_audio_bitrate_fail: str = None,
        is_check_reso: str = None,
        is_check_reso_fail: str = None,
        is_check_video_bitrate: str = None,
        is_check_video_bitrate_fail: str = None,
        trans_mode: str = None,
    ):
        self.adj_dar_method = adj_dar_method
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail
        self.is_check_reso = is_check_reso
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class AddTemplateResponseBodyTemplateVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class AddTemplateResponseBodyTemplateVideo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        bitrate_bnd: AddTemplateResponseBodyTemplateVideoBitrateBnd = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        degrain: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        long_short_mode: str = None,
        max_fps: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        qscale: str = None,
        remove: str = None,
        reso_priority: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.bitrate_bnd = bitrate_bnd
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.crop = crop
        self.degrain = degrain
        self.fps = fps
        self.gop = gop
        self.height = height
        self.long_short_mode = long_short_mode
        self.max_fps = max_fps
        self.maxrate = maxrate
        self.pad = pad
        self.pix_fmt = pix_fmt
        self.preset = preset
        self.profile = profile
        self.qscale = qscale
        self.remove = remove
        self.reso_priority = reso_priority
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = AddTemplateResponseBodyTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        audio: AddTemplateResponseBodyTemplateAudio = None,
        container: AddTemplateResponseBodyTemplateContainer = None,
        id: str = None,
        mux_config: AddTemplateResponseBodyTemplateMuxConfig = None,
        name: str = None,
        state: str = None,
        trans_config: AddTemplateResponseBodyTemplateTransConfig = None,
        video: AddTemplateResponseBodyTemplateVideo = None,
    ):
        self.audio = audio
        self.container = container
        self.id = id
        self.mux_config = mux_config
        self.name = name
        self.state = state
        self.trans_config = trans_config
        self.video = video

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = AddTemplateResponseBodyTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = AddTemplateResponseBodyTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MuxConfig') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TransConfig') is not None:
            temp_model = AddTemplateResponseBodyTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Video') is not None:
            temp_model = AddTemplateResponseBodyTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class AddTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: AddTemplateResponseBodyTemplate = None,
    ):
        self.request_id = request_id
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTerrorismPipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        notify_config: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.name = name
        self.notify_config = notify_config
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddTerrorismPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddTerrorismPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: AddTerrorismPipelineResponseBodyPipelineNotifyConfig = None,
        priority: int = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddTerrorismPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddTerrorismPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: AddTerrorismPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        self.pipeline = pipeline
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddTerrorismPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTerrorismPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddTerrorismPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddTerrorismPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWaterMarkTemplateRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.config = config
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        height: str = None,
        width: str = None,
    ):
        self.dx = dx
        self.dy = dy
        self.height = height
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplate(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        height: str = None,
        id: str = None,
        name: str = None,
        ratio_refer: AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer = None,
        refer_pos: str = None,
        state: str = None,
        timeline: AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline = None,
        type: str = None,
        width: str = None,
    ):
        self.dx = dx
        self.dy = dy
        self.height = height
        self.id = id
        self.name = name
        self.ratio_refer = ratio_refer
        self.refer_pos = refer_pos
        self.state = state
        self.timeline = timeline
        self.type = type
        self.width = width

    def validate(self):
        if self.ratio_refer:
            self.ratio_refer.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.ratio_refer is not None:
            result['RatioRefer'] = self.ratio_refer.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.state is not None:
            result['State'] = self.state
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RatioRefer') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer()
            self.ratio_refer = temp_model.from_map(m['RatioRefer'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Timeline') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddWaterMarkTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        water_mark_template: AddWaterMarkTemplateResponseBodyWaterMarkTemplate = None,
    ):
        self.request_id = request_id
        self.water_mark_template = water_mark_template

    def validate(self):
        if self.water_mark_template:
            self.water_mark_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.water_mark_template is not None:
            result['WaterMarkTemplate'] = self.water_mark_template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WaterMarkTemplate') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplate()
            self.water_mark_template = temp_model.from_map(m['WaterMarkTemplate'])
        return self


class AddWaterMarkTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddWaterMarkTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddWaterMarkTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindInputBucketRequest(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class BindInputBucketResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindInputBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindInputBucketResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindInputBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindOutputBucketRequest(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class BindOutputBucketResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindOutputBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindOutputBucketResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindOutputBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_id = job_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        request_id: str = None,
    ):
        self.job_id = job_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CategoryTreeRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CategoryTreeResponseBody(TeaModel):
    def __init__(
        self,
        category_tree: str = None,
        request_id: str = None,
    ):
        self.category_tree = category_tree
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_tree is not None:
            result['CategoryTree'] = self.category_tree
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryTree') is not None:
            self.category_tree = m.get('CategoryTree')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CategoryTreeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CategoryTreeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CategoryTreeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckResourceRequest(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        level: int = None,
        message: str = None,
        pk: str = None,
        prompt: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
        url: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.level = level
        self.message = message
        self.pk = pk
        self.prompt = prompt
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CheckResourceResponseBody(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        level: int = None,
        message: str = None,
        pk: str = None,
        prompt: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
        url: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.level = level
        self.message = message
        self.pk = pk
        self.prompt = prompt
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CheckResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFpShotDBRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        description: str = None,
        model_id: int = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.config = config
        self.description = description
        self.model_id = model_id
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.description is not None:
            result['Description'] = self.description
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateFpShotDBResponseBodyFpShotDB(TeaModel):
    def __init__(
        self,
        config: str = None,
        description: str = None,
        fp_dbid: str = None,
        model_id: int = None,
        name: str = None,
        state: str = None,
    ):
        self.config = config
        self.description = description
        self.fp_dbid = fp_dbid
        self.model_id = model_id
        self.name = name
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.description is not None:
            result['Description'] = self.description
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class CreateFpShotDBResponseBody(TeaModel):
    def __init__(
        self,
        fp_shot_db: CreateFpShotDBResponseBodyFpShotDB = None,
        request_id: str = None,
    ):
        self.fp_shot_db = fp_shot_db
        self.request_id = request_id

    def validate(self):
        if self.fp_shot_db:
            self.fp_shot_db.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_db is not None:
            result['FpShotDB'] = self.fp_shot_db.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotDB') is not None:
            temp_model = CreateFpShotDBResponseBodyFpShotDB()
            self.fp_shot_db = temp_model.from_map(m['FpShotDB'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFpShotDBResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFpShotDBResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFpShotDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInferenceServerRequest(TeaModel):
    def __init__(
        self,
        function_name: str = None,
        model_path: str = None,
        model_type: str = None,
        pipeline_id: str = None,
        test_id: str = None,
        user_data: str = None,
    ):
        self.function_name = function_name
        self.model_path = model_path
        self.model_type = model_type
        self.pipeline_id = pipeline_id
        self.test_id = test_id
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.model_path is not None:
            result['ModelPath'] = self.model_path
        if self.model_type is not None:
            result['ModelType'] = self.model_type
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.test_id is not None:
            result['TestId'] = self.test_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('ModelPath') is not None:
            self.model_path = m.get('ModelPath')
        if m.get('ModelType') is not None:
            self.model_type = m.get('ModelType')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('TestId') is not None:
            self.test_id = m.get('TestId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateInferenceServerResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInferenceServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateInferenceServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInferenceServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMcuTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateMcuTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateMcuTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMcuTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMcuTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSessionRequest(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
        media_id: str = None,
        owner_account: str = None,
        owner_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
        session_time: int = None,
    ):
        self.end_user_id = end_user_id
        self.media_id = media_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.session_time = session_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.session_time is not None:
            result['SessionTime'] = self.session_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SessionTime') is not None:
            self.session_time = m.get('SessionTime')
        return self


class CreateSessionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        session_id: str = None,
        ticket: str = None,
    ):
        self.request_id = request_id
        self.session_id = session_id
        self.ticket = ticket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.ticket is not None:
            result['Ticket'] = self.ticket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Ticket') is not None:
            self.ticket = m.get('Ticket')
        return self


class CreateSessionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSessionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSessionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateMediaWorkflowRequest(TeaModel):
    def __init__(
        self,
        media_workflow_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.media_workflow_id = media_workflow_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeactivateMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        media_workflow_id: str = None,
        name: str = None,
        state: str = None,
        topology: str = None,
    ):
        self.creation_time = creation_time
        self.media_workflow_id = media_workflow_id
        self.name = name
        self.state = state
        self.topology = topology

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class DeactivateMediaWorkflowResponseBody(TeaModel):
    def __init__(
        self,
        media_workflow: DeactivateMediaWorkflowResponseBodyMediaWorkflow = None,
        request_id: str = None,
    ):
        self.media_workflow = media_workflow
        self.request_id = request_id

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = DeactivateMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateMediaWorkflowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeactivateMediaWorkflowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeactivateMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecryptKeyRequest(TeaModel):
    def __init__(
        self,
        ciphertext_blob: str = None,
        owner_account: str = None,
        owner_id: str = None,
        rand: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
    ):
        self.ciphertext_blob = ciphertext_blob
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.rand = rand
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphertext_blob is not None:
            result['CiphertextBlob'] = self.ciphertext_blob
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.rand is not None:
            result['Rand'] = self.rand
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CiphertextBlob') is not None:
            self.ciphertext_blob = m.get('CiphertextBlob')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Rand') is not None:
            self.rand = m.get('Rand')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DecryptKeyResponseBody(TeaModel):
    def __init__(
        self,
        plaintext: str = None,
        rand: str = None,
        request_id: str = None,
    ):
        self.plaintext = plaintext
        self.rand = rand
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        if self.rand is not None:
            result['Rand'] = self.rand
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        if m.get('Rand') is not None:
            self.rand = m.get('Rand')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DecryptKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DecryptKeyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DecryptKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.cate_id = cate_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMCTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMCTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMCTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMCTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMCTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMcuJobRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMcuJobResponseBodyDeletedJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class DeleteMcuJobResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class DeleteMcuJobResponseBody(TeaModel):
    def __init__(
        self,
        deleted_job_ids: DeleteMcuJobResponseBodyDeletedJobIds = None,
        non_exist_job_ids: DeleteMcuJobResponseBodyNonExistJobIds = None,
        request_id: str = None,
    ):
        self.deleted_job_ids = deleted_job_ids
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id

    def validate(self):
        if self.deleted_job_ids:
            self.deleted_job_ids.validate()
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deleted_job_ids is not None:
            result['DeletedJobIds'] = self.deleted_job_ids.to_map()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeletedJobIds') is not None:
            temp_model = DeleteMcuJobResponseBodyDeletedJobIds()
            self.deleted_job_ids = temp_model.from_map(m['DeletedJobIds'])
        if m.get('NonExistJobIds') is not None:
            temp_model = DeleteMcuJobResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMcuJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMcuJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMcuJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMcuTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMcuTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMcuTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMcuTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMcuTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaRequest(TeaModel):
    def __init__(
        self,
        media_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.media_ids = media_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMediaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMediaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaTagRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        tag: str = None,
    ):
        self.media_id = media_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DeleteMediaTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMediaTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMediaTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaWorkflowRequest(TeaModel):
    def __init__(
        self,
        media_workflow_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.media_workflow_id = media_workflow_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        media_workflow_id: str = None,
        name: str = None,
        state: str = None,
        topology: str = None,
    ):
        self.creation_time = creation_time
        self.media_workflow_id = media_workflow_id
        self.name = name
        self.state = state
        self.topology = topology

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class DeleteMediaWorkflowResponseBody(TeaModel):
    def __init__(
        self,
        media_workflow: DeleteMediaWorkflowResponseBodyMediaWorkflow = None,
        request_id: str = None,
    ):
        self.media_workflow = media_workflow
        self.request_id = request_id

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = DeleteMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaWorkflowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMediaWorkflowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_id = pipeline_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        request_id: str = None,
    ):
        self.pipeline_id = pipeline_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmarttagTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteSmarttagTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmarttagTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSmarttagTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSmarttagTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaterMarkTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        water_mark_template_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.water_mark_template_id = water_mark_template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        return self


class DeleteWaterMarkTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        water_mark_template_id: str = None,
    ):
        self.request_id = request_id
        self.water_mark_template_id = water_mark_template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        return self


class DeleteWaterMarkTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteWaterMarkTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteWaterMarkTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMtsUserResourcePackageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeMtsUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        curr_capacity: str = None,
        display_name: str = None,
        init_capacity: str = None,
        instance_id: str = None,
        status: str = None,
    ):
        self.commodity_code = commodity_code
        self.curr_capacity = curr_capacity
        self.display_name = display_name
        self.init_capacity = init_capacity
        self.instance_id = instance_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.curr_capacity is not None:
            result['CurrCapacity'] = self.curr_capacity
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.init_capacity is not None:
            result['InitCapacity'] = self.init_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CurrCapacity') is not None:
            self.curr_capacity = m.get('CurrCapacity')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InitCapacity') is not None:
            self.init_capacity = m.get('InitCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeMtsUserResourcePackageResponseBodyResourcePackageInfos(TeaModel):
    def __init__(
        self,
        resource_package_info: List[DescribeMtsUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo] = None,
    ):
        self.resource_package_info = resource_package_info

    def validate(self):
        if self.resource_package_info:
            for k in self.resource_package_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourcePackageInfo'] = []
        if self.resource_package_info is not None:
            for k in self.resource_package_info:
                result['ResourcePackageInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource_package_info = []
        if m.get('ResourcePackageInfo') is not None:
            for k in m.get('ResourcePackageInfo'):
                temp_model = DescribeMtsUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo()
                self.resource_package_info.append(temp_model.from_map(k))
        return self


class DescribeMtsUserResourcePackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_package_infos: DescribeMtsUserResourcePackageResponseBodyResourcePackageInfos = None,
    ):
        self.request_id = request_id
        self.resource_package_infos = resource_package_infos

    def validate(self):
        if self.resource_package_infos:
            self.resource_package_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_package_infos is not None:
            result['ResourcePackageInfos'] = self.resource_package_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourcePackageInfos') is not None:
            temp_model = DescribeMtsUserResourcePackageResponseBodyResourcePackageInfos()
            self.resource_package_infos = temp_model.from_map(m['ResourcePackageInfos'])
        return self


class DescribeMtsUserResourcePackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMtsUserResourcePackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMtsUserResourcePackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetectImageSyncRequest(TeaModel):
    def __init__(
        self,
        image: str = None,
    ):
        # 图片url链接
        self.image = image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['Image'] = self.image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Image') is not None:
            self.image = m.get('Image')
        return self


class DetectImageSyncResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        result: str = None,
        status: str = None,
    ):
        # 返回信息
        self.message = message
        # Id of the request
        self.request_id = request_id
        # 返回结果
        self.result = result
        # 请求状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DetectImageSyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DetectImageSyncResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DetectImageSyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobInfoRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['jobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('jobId') is not None:
            self.job_id = m.get('jobId')
        return self


class GetJobInfoResponseBodyMtsTransferJob(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        extend: str = None,
        finished_time: str = None,
        job_id: str = None,
        job_type: str = None,
        modified_time: str = None,
        request_json: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.extend = extend
        self.finished_time = finished_time
        self.job_id = job_id
        self.job_type = job_type
        self.modified_time = modified_time
        self.request_json = request_json
        self.state = state
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.finished_time is not None:
            result['FinishedTime'] = self.finished_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.request_json is not None:
            result['RequestJson'] = self.request_json
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('FinishedTime') is not None:
            self.finished_time = m.get('FinishedTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('RequestJson') is not None:
            self.request_json = m.get('RequestJson')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetJobInfoResponseBody(TeaModel):
    def __init__(
        self,
        mts_transfer_job: GetJobInfoResponseBodyMtsTransferJob = None,
        request_id: str = None,
    ):
        self.mts_transfer_job = mts_transfer_job
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.mts_transfer_job:
            self.mts_transfer_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mts_transfer_job is not None:
            result['MtsTransferJob'] = self.mts_transfer_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MtsTransferJob') is not None:
            temp_model = GetJobInfoResponseBodyMtsTransferJob()
            self.mts_transfer_job = temp_model.from_map(m['MtsTransferJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetJobInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetJobInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLicenseRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        header: str = None,
        license_url: str = None,
        media_id: str = None,
        owner_account: str = None,
        owner_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
        type: str = None,
    ):
        self.data = data
        self.header = header
        self.license_url = license_url
        self.media_id = media_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.header is not None:
            result['Header'] = self.header
        if self.license_url is not None:
            result['LicenseUrl'] = self.license_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Header') is not None:
            self.header = m.get('Header')
        if m.get('LicenseUrl') is not None:
            self.license_url = m.get('LicenseUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLicenseResponseBody(TeaModel):
    def __init__(
        self,
        license: str = None,
        request_id: str = None,
    ):
        self.license = license
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.license is not None:
            result['License'] = self.license
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('License') is not None:
            self.license = m.get('License')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLicenseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetLicenseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLicenseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPackageRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        owner_account: str = None,
        owner_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
    ):
        self.data = data
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetPackageResponseBody(TeaModel):
    def __init__(
        self,
        cert_package: str = None,
        request_id: str = None,
    ):
        self.cert_package = cert_package
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_package is not None:
            result['CertPackage'] = self.cert_package
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertPackage') is not None:
            self.cert_package = m.get('CertPackage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImAuditRequest(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        contents: str = None,
        images: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scenes: str = None,
    ):
        self.biz_type = biz_type
        self.contents = contents
        self.images = images
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.scenes = scenes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.contents is not None:
            result['Contents'] = self.contents
        if self.images is not None:
            result['Images'] = self.images
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scenes is not None:
            result['Scenes'] = self.scenes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Contents') is not None:
            self.contents = m.get('Contents')
        if m.get('Images') is not None:
            self.images = m.get('Images')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scenes') is not None:
            self.scenes = m.get('Scenes')
        return self


class ImAuditResponseBodyImageResultsResultResults(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: float = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class ImAuditResponseBodyImageResultsResult(TeaModel):
    def __init__(
        self,
        code: int = None,
        data_id: str = None,
        extras: Dict[str, Any] = None,
        msg: str = None,
        results: List[ImAuditResponseBodyImageResultsResultResults] = None,
        task_id: str = None,
        url: str = None,
    ):
        self.code = code
        self.data_id = data_id
        self.extras = extras
        self.msg = msg
        self.results = results
        self.task_id = task_id
        self.url = url

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.extras is not None:
            result['extras'] = self.extras
        if self.msg is not None:
            result['msg'] = self.msg
        result['results'] = []
        if self.results is not None:
            for k in self.results:
                result['results'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['taskId'] = self.task_id
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('extras') is not None:
            self.extras = m.get('extras')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        self.results = []
        if m.get('results') is not None:
            for k in m.get('results'):
                temp_model = ImAuditResponseBodyImageResultsResultResults()
                self.results.append(temp_model.from_map(k))
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class ImAuditResponseBodyImageResults(TeaModel):
    def __init__(
        self,
        result: List[ImAuditResponseBodyImageResultsResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ImAuditResponseBodyImageResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class ImAuditResponseBodyTextResultsResultResultsDetails(TeaModel):
    def __init__(
        self,
        label: str = None,
    ):
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class ImAuditResponseBodyTextResultsResultResults(TeaModel):
    def __init__(
        self,
        details: List[ImAuditResponseBodyTextResultsResultResultsDetails] = None,
        label: str = None,
        rate: float = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.details = details
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['details'] = []
        if self.details is not None:
            for k in self.details:
                result['details'].append(k.to_map() if k else None)
        if self.label is not None:
            result['label'] = self.label
        if self.rate is not None:
            result['rate'] = self.rate
        if self.scene is not None:
            result['scene'] = self.scene
        if self.suggestion is not None:
            result['suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.details = []
        if m.get('details') is not None:
            for k in m.get('details'):
                temp_model = ImAuditResponseBodyTextResultsResultResultsDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('label') is not None:
            self.label = m.get('label')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('suggestion') is not None:
            self.suggestion = m.get('suggestion')
        return self


class ImAuditResponseBodyTextResultsResult(TeaModel):
    def __init__(
        self,
        code: int = None,
        content: str = None,
        data_id: str = None,
        msg: str = None,
        results: List[ImAuditResponseBodyTextResultsResultResults] = None,
        task_id: str = None,
    ):
        self.code = code
        self.content = content
        self.data_id = data_id
        self.msg = msg
        self.results = results
        self.task_id = task_id

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.content is not None:
            result['content'] = self.content
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.msg is not None:
            result['msg'] = self.msg
        result['results'] = []
        if self.results is not None:
            for k in self.results:
                result['results'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        self.results = []
        if m.get('results') is not None:
            for k in m.get('results'):
                temp_model = ImAuditResponseBodyTextResultsResultResults()
                self.results.append(temp_model.from_map(k))
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class ImAuditResponseBodyTextResults(TeaModel):
    def __init__(
        self,
        result: List[ImAuditResponseBodyTextResultsResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ImAuditResponseBodyTextResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class ImAuditResponseBody(TeaModel):
    def __init__(
        self,
        image_quota_exceed: bool = None,
        image_results: ImAuditResponseBodyImageResults = None,
        request_id: str = None,
        text_quota_exceed: bool = None,
        text_results: ImAuditResponseBodyTextResults = None,
    ):
        self.image_quota_exceed = image_quota_exceed
        self.image_results = image_results
        self.request_id = request_id
        self.text_quota_exceed = text_quota_exceed
        self.text_results = text_results

    def validate(self):
        if self.image_results:
            self.image_results.validate()
        if self.text_results:
            self.text_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_quota_exceed is not None:
            result['ImageQuotaExceed'] = self.image_quota_exceed
        if self.image_results is not None:
            result['ImageResults'] = self.image_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.text_quota_exceed is not None:
            result['TextQuotaExceed'] = self.text_quota_exceed
        if self.text_results is not None:
            result['TextResults'] = self.text_results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageQuotaExceed') is not None:
            self.image_quota_exceed = m.get('ImageQuotaExceed')
        if m.get('ImageResults') is not None:
            temp_model = ImAuditResponseBodyImageResults()
            self.image_results = temp_model.from_map(m['ImageResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TextQuotaExceed') is not None:
            self.text_quota_exceed = m.get('TextQuotaExceed')
        if m.get('TextResults') is not None:
            temp_model = ImAuditResponseBodyTextResults()
            self.text_results = temp_model.from_map(m['TextResults'])
        return self


class ImAuditResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImAuditResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportFpShotJobRequest(TeaModel):
    def __init__(
        self,
        fp_dbid: str = None,
        fp_import_config: str = None,
        input: str = None,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        user_data: str = None,
    ):
        self.fp_dbid = fp_dbid
        self.fp_import_config = fp_import_config
        self.input = input
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_id = pipeline_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.fp_import_config is not None:
            result['FpImportConfig'] = self.fp_import_config
        if self.input is not None:
            result['Input'] = self.input
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('FpImportConfig') is not None:
            self.fp_import_config = m.get('FpImportConfig')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ImportFpShotJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        request_id: str = None,
    ):
        self.job_id = job_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportFpShotJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportFpShotJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportFpShotJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllCategoryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListAllCategoryResponseBodyCategoryListCategory(TeaModel):
    def __init__(
        self,
        cate_id: str = None,
        cate_name: str = None,
        level: str = None,
        parent_id: str = None,
    ):
        self.cate_id = cate_id
        self.cate_name = cate_name
        self.level = level
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ListAllCategoryResponseBodyCategoryList(TeaModel):
    def __init__(
        self,
        category: List[ListAllCategoryResponseBodyCategoryListCategory] = None,
    ):
        self.category = category

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = ListAllCategoryResponseBodyCategoryListCategory()
                self.category.append(temp_model.from_map(k))
        return self


class ListAllCategoryResponseBody(TeaModel):
    def __init__(
        self,
        category_list: ListAllCategoryResponseBodyCategoryList = None,
        request_id: str = None,
    ):
        self.category_list = category_list
        self.request_id = request_id

    def validate(self):
        if self.category_list:
            self.category_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_list is not None:
            result['CategoryList'] = self.category_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryList') is not None:
            temp_model = ListAllCategoryResponseBodyCategoryList()
            self.category_list = temp_model.from_map(m['CategoryList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAllCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAllCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAllCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllMediaBucketRequest(TeaModel):
    def __init__(
        self,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListAllMediaBucketResponseBodyMediaBucketListMediaBucket(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        type: str = None,
    ):
        self.bucket = bucket
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAllMediaBucketResponseBodyMediaBucketList(TeaModel):
    def __init__(
        self,
        media_bucket: List[ListAllMediaBucketResponseBodyMediaBucketListMediaBucket] = None,
    ):
        self.media_bucket = media_bucket

    def validate(self):
        if self.media_bucket:
            for k in self.media_bucket:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaBucket'] = []
        if self.media_bucket is not None:
            for k in self.media_bucket:
                result['MediaBucket'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_bucket = []
        if m.get('MediaBucket') is not None:
            for k in m.get('MediaBucket'):
                temp_model = ListAllMediaBucketResponseBodyMediaBucketListMediaBucket()
                self.media_bucket.append(temp_model.from_map(k))
        return self


class ListAllMediaBucketResponseBody(TeaModel):
    def __init__(
        self,
        media_bucket_list: ListAllMediaBucketResponseBodyMediaBucketList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.media_bucket_list = media_bucket_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.media_bucket_list:
            self.media_bucket_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_bucket_list is not None:
            result['MediaBucketList'] = self.media_bucket_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaBucketList') is not None:
            temp_model = ListAllMediaBucketResponseBodyMediaBucketList()
            self.media_bucket_list = temp_model.from_map(m['MediaBucketList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAllMediaBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAllMediaBucketResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAllMediaBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAsrPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        state: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue_name: str = None,
        topic: str = None,
    ):
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListAsrPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAsrPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListAsrPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListAsrPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListAsrPipelineResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pipeline_list: ListAsrPipelineResponseBodyPipelineList = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.pipeline_list = pipeline_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PipelineList') is not None:
            temp_model = ListAsrPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAsrPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAsrPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAsrPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCensorPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        state: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListCensorPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCensorPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListCensorPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListCensorPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListCensorPipelineResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pipeline_list: ListCensorPipelineResponseBodyPipelineList = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.pipeline_list = pipeline_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PipelineList') is not None:
            temp_model = ListCensorPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCensorPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCensorPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCensorPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCoverPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        state: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCoverPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        extend_config: str = None,
        name: str = None,
        notify_config: str = None,
        pipeline_id: str = None,
        priority: str = None,
        role: str = None,
        state: str = None,
        user_id: int = None,
        quota_num: int = None,
        quota_used: int = None,
    ):
        self.extend_config = extend_config
        self.name = name
        self.notify_config = notify_config
        self.pipeline_id = pipeline_id
        self.priority = priority
        self.role = role
        self.state = state
        self.user_id = user_id
        self.quota_num = quota_num
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_config is not None:
            result['ExtendConfig'] = self.extend_config
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.role is not None:
            result['Role'] = self.role
        if self.state is not None:
            result['State'] = self.state
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.quota_num is not None:
            result['quotaNum'] = self.quota_num
        if self.quota_used is not None:
            result['quotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtendConfig') is not None:
            self.extend_config = m.get('ExtendConfig')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('quotaNum') is not None:
            self.quota_num = m.get('quotaNum')
        if m.get('quotaUsed') is not None:
            self.quota_used = m.get('quotaUsed')
        return self


class ListCoverPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListCoverPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListCoverPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListCoverPipelineResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pipeline_list: ListCoverPipelineResponseBodyPipelineList = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.pipeline_list = pipeline_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PipelineList') is not None:
            temp_model = ListCoverPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCoverPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCoverPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCoverPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomPersonsRequest(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        person_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.category_id = category_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.person_id = person_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace(TeaModel):
    def __init__(
        self,
        face_id: str = None,
        image_url: str = None,
    ):
        self.face_id = face_id
        self.image_url = image_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_id is not None:
            result['FaceId'] = self.face_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FaceId') is not None:
            self.face_id = m.get('FaceId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces(TeaModel):
    def __init__(
        self,
        face: List[ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace] = None,
    ):
        self.face = face

    def validate(self):
        if self.face:
            for k in self.face:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Face'] = []
        if self.face is not None:
            for k in self.face:
                result['Face'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.face = []
        if m.get('Face') is not None:
            for k in m.get('Face'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace()
                self.face.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson(TeaModel):
    def __init__(
        self,
        faces: ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces = None,
        person_description: str = None,
        person_id: str = None,
        person_name: str = None,
    ):
        self.faces = faces
        self.person_description = person_description
        self.person_id = person_id
        self.person_name = person_name

    def validate(self):
        if self.faces:
            self.faces.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.faces is not None:
            result['Faces'] = self.faces.to_map()
        if self.person_description is not None:
            result['PersonDescription'] = self.person_description
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Faces') is not None:
            temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces()
            self.faces = temp_model.from_map(m['Faces'])
        if m.get('PersonDescription') is not None:
            self.person_description = m.get('PersonDescription')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersons(TeaModel):
    def __init__(
        self,
        person: List[ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson] = None,
    ):
        self.person = person

    def validate(self):
        if self.person:
            for k in self.person:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Person'] = []
        if self.person is not None:
            for k in self.person:
                result['Person'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.person = []
        if m.get('Person') is not None:
            for k in m.get('Person'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson()
                self.person.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBodyCategoriesCategory(TeaModel):
    def __init__(
        self,
        category_description: str = None,
        category_id: str = None,
        category_name: str = None,
        persons: ListCustomPersonsResponseBodyCategoriesCategoryPersons = None,
    ):
        self.category_description = category_description
        self.category_id = category_id
        self.category_name = category_name
        self.persons = persons

    def validate(self):
        if self.persons:
            self.persons.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_description is not None:
            result['CategoryDescription'] = self.category_description
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.persons is not None:
            result['Persons'] = self.persons.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryDescription') is not None:
            self.category_description = m.get('CategoryDescription')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('Persons') is not None:
            temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersons()
            self.persons = temp_model.from_map(m['Persons'])
        return self


class ListCustomPersonsResponseBodyCategories(TeaModel):
    def __init__(
        self,
        category: List[ListCustomPersonsResponseBodyCategoriesCategory] = None,
    ):
        self.category = category

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBody(TeaModel):
    def __init__(
        self,
        categories: ListCustomPersonsResponseBodyCategories = None,
        request_id: str = None,
    ):
        self.categories = categories
        self.request_id = request_id

    def validate(self):
        if self.categories:
            self.categories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['Categories'] = self.categories.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            temp_model = ListCustomPersonsResponseBodyCategories()
            self.categories = temp_model.from_map(m['Categories'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCustomPersonsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCustomPersonsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCustomPersonsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotDBRequest(TeaModel):
    def __init__(
        self,
        fp_dbids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.fp_dbids = fp_dbids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbids is not None:
            result['FpDBIds'] = self.fp_dbids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpDBIds') is not None:
            self.fp_dbids = m.get('FpDBIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListFpShotDBResponseBodyFpShotDBListFpShotDB(TeaModel):
    def __init__(
        self,
        description: str = None,
        fp_dbid: str = None,
        model_id: int = None,
        name: str = None,
        status: str = None,
    ):
        self.description = description
        self.fp_dbid = fp_dbid
        self.model_id = model_id
        self.name = name
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListFpShotDBResponseBodyFpShotDBList(TeaModel):
    def __init__(
        self,
        fp_shot_db: List[ListFpShotDBResponseBodyFpShotDBListFpShotDB] = None,
    ):
        self.fp_shot_db = fp_shot_db

    def validate(self):
        if self.fp_shot_db:
            for k in self.fp_shot_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotDB'] = []
        if self.fp_shot_db is not None:
            for k in self.fp_shot_db:
                result['FpShotDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_db = []
        if m.get('FpShotDB') is not None:
            for k in m.get('FpShotDB'):
                temp_model = ListFpShotDBResponseBodyFpShotDBListFpShotDB()
                self.fp_shot_db.append(temp_model.from_map(k))
        return self


class ListFpShotDBResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class ListFpShotDBResponseBody(TeaModel):
    def __init__(
        self,
        fp_shot_dblist: ListFpShotDBResponseBodyFpShotDBList = None,
        non_exist_ids: ListFpShotDBResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.fp_shot_dblist = fp_shot_dblist
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.fp_shot_dblist:
            self.fp_shot_dblist.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_dblist is not None:
            result['FpShotDBList'] = self.fp_shot_dblist.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotDBList') is not None:
            temp_model = ListFpShotDBResponseBodyFpShotDBList()
            self.fp_shot_dblist = temp_model.from_map(m['FpShotDBList'])
        if m.get('NonExistIds') is not None:
            temp_model = ListFpShotDBResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotDBResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFpShotDBResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFpShotDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotFilesRequest(TeaModel):
    def __init__(
        self,
        fp_dbid: str = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.fp_dbid = fp_dbid
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListFpShotFilesResponseBodyFpShotFileListFpShotFile(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        input_file: ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile = None,
        primary_key: str = None,
    ):
        self.file_id = file_id
        self.input_file = input_file
        self.primary_key = primary_key

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('InputFile') is not None:
            temp_model = ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        return self


class ListFpShotFilesResponseBodyFpShotFileList(TeaModel):
    def __init__(
        self,
        fp_shot_file: List[ListFpShotFilesResponseBodyFpShotFileListFpShotFile] = None,
    ):
        self.fp_shot_file = fp_shot_file

    def validate(self):
        if self.fp_shot_file:
            for k in self.fp_shot_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotFile'] = []
        if self.fp_shot_file is not None:
            for k in self.fp_shot_file:
                result['FpShotFile'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_file = []
        if m.get('FpShotFile') is not None:
            for k in m.get('FpShotFile'):
                temp_model = ListFpShotFilesResponseBodyFpShotFileListFpShotFile()
                self.fp_shot_file.append(temp_model.from_map(k))
        return self


class ListFpShotFilesResponseBody(TeaModel):
    def __init__(
        self,
        fp_shot_file_list: ListFpShotFilesResponseBodyFpShotFileList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.fp_shot_file_list = fp_shot_file_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.fp_shot_file_list:
            self.fp_shot_file_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_file_list is not None:
            result['FpShotFileList'] = self.fp_shot_file_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotFileList') is not None:
            temp_model = ListFpShotFilesResponseBodyFpShotFileList()
            self.fp_shot_file_list = temp_model.from_map(m['FpShotFileList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFpShotFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFpShotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotImportJobRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListFpShotImportJobResponseBodyFpShotImportJobList(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_time: str = None,
        finish_time: str = None,
        fp_dbid: str = None,
        fp_import_config: str = None,
        id: str = None,
        input: str = None,
        message: str = None,
        pipeline_id: str = None,
        status: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.create_time = create_time
        self.finish_time = finish_time
        self.fp_dbid = fp_dbid
        self.fp_import_config = fp_import_config
        self.id = id
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.status = status
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.fp_import_config is not None:
            result['FpImportConfig'] = self.fp_import_config
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('FpImportConfig') is not None:
            self.fp_import_config = m.get('FpImportConfig')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListFpShotImportJobResponseBody(TeaModel):
    def __init__(
        self,
        fp_shot_import_job_list: List[ListFpShotImportJobResponseBodyFpShotImportJobList] = None,
        non_exist_ids: List[str] = None,
        request_id: str = None,
    ):
        self.fp_shot_import_job_list = fp_shot_import_job_list
        self.non_exist_ids = non_exist_ids
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.fp_shot_import_job_list:
            for k in self.fp_shot_import_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotImportJobList'] = []
        if self.fp_shot_import_job_list is not None:
            for k in self.fp_shot_import_job_list:
                result['FpShotImportJobList'].append(k.to_map() if k else None)
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_import_job_list = []
        if m.get('FpShotImportJobList') is not None:
            for k in m.get('FpShotImportJobList'):
                temp_model = ListFpShotImportJobResponseBodyFpShotImportJobList()
                self.fp_shot_import_job_list.append(temp_model.from_map(k))
        if m.get('NonExistIds') is not None:
            self.non_exist_ids = m.get('NonExistIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotImportJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFpShotImportJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFpShotImportJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotNotaryRequest(TeaModel):
    def __init__(
        self,
        end_of_created_time_range: str = None,
        fp_dbid: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_of_created_time_range: str = None,
    ):
        self.end_of_created_time_range = end_of_created_time_range
        self.fp_dbid = fp_dbid
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_of_created_time_range = start_of_created_time_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_created_time_range is not None:
            result['EndOfCreatedTimeRange'] = self.end_of_created_time_range
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_created_time_range is not None:
            result['StartOfCreatedTimeRange'] = self.start_of_created_time_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfCreatedTimeRange') is not None:
            self.end_of_created_time_range = m.get('EndOfCreatedTimeRange')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfCreatedTimeRange') is not None:
            self.start_of_created_time_range = m.get('StartOfCreatedTimeRange')
        return self


class ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        detail: str = None,
        finish_time: str = None,
        fp_dbid: str = None,
        job_id: str = None,
        transaction_id: str = None,
        tx_hash: str = None,
    ):
        self.creation_time = creation_time
        self.detail = detail
        self.finish_time = finish_time
        self.fp_dbid = fp_dbid
        self.job_id = job_id
        self.transaction_id = transaction_id
        self.tx_hash = tx_hash

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.transaction_id is not None:
            result['TransactionId'] = self.transaction_id
        if self.tx_hash is not None:
            result['TxHash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TransactionId') is not None:
            self.transaction_id = m.get('TransactionId')
        if m.get('TxHash') is not None:
            self.tx_hash = m.get('TxHash')
        return self


class ListFpShotNotaryResponseBodyFpShotNotaryList(TeaModel):
    def __init__(
        self,
        fp_shot_notary: List[ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary] = None,
    ):
        self.fp_shot_notary = fp_shot_notary

    def validate(self):
        if self.fp_shot_notary:
            for k in self.fp_shot_notary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotNotary'] = []
        if self.fp_shot_notary is not None:
            for k in self.fp_shot_notary:
                result['FpShotNotary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_notary = []
        if m.get('FpShotNotary') is not None:
            for k in m.get('FpShotNotary'):
                temp_model = ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary()
                self.fp_shot_notary.append(temp_model.from_map(k))
        return self


class ListFpShotNotaryResponseBody(TeaModel):
    def __init__(
        self,
        fp_shot_notary_list: ListFpShotNotaryResponseBodyFpShotNotaryList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.fp_shot_notary_list = fp_shot_notary_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.fp_shot_notary_list:
            self.fp_shot_notary_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_notary_list is not None:
            result['FpShotNotaryList'] = self.fp_shot_notary_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotNotaryList') is not None:
            temp_model = ListFpShotNotaryResponseBodyFpShotNotaryList()
            self.fp_shot_notary_list = temp_model.from_map(m['FpShotNotaryList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotNotaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFpShotNotaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFpShotNotaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInferenceJobRequest(TeaModel):
    def __init__(
        self,
        max_page_size: int = None,
        page_number: int = None,
        server_name: str = None,
    ):
        self.max_page_size = max_page_size
        self.page_number = page_number
        self.server_name = server_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_page_size is not None:
            result['MaxPageSize'] = self.max_page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.server_name is not None:
            result['ServerName'] = self.server_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxPageSize') is not None:
            self.max_page_size = m.get('MaxPageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ServerName') is not None:
            self.server_name = m.get('ServerName')
        return self


class ListInferenceJobResponseBodyJobs(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_params: str = None,
        job_time: int = None,
        message: str = None,
        result: str = None,
        status: str = None,
        user_id: int = None,
    ):
        self.job_id = job_id
        self.job_params = job_params
        self.job_time = job_time
        self.message = message
        self.result = result
        self.status = status
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.job_time is not None:
            result['JobTime'] = self.job_time
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('JobTime') is not None:
            self.job_time = m.get('JobTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListInferenceJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        jobs: List[ListInferenceJobResponseBodyJobs] = None,
        message: str = None,
        request_id: str = None,
        total_size: int = None,
    ):
        self.code = code
        self.jobs = jobs
        self.message = message
        self.request_id = request_id
        self.total_size = total_size

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListInferenceJobResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListInferenceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInferenceJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInferenceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(
        self,
        end_of_job_created_time_range: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_of_job_created_time_range: str = None,
        state: str = None,
    ):
        self.end_of_job_created_time_range = end_of_job_created_time_range
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_id = pipeline_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_of_job_created_time_range = start_of_job_created_time_range
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListJobResponseBodyJobListJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class ListJobResponseBodyJobListJobOutputAudioVolume(TeaModel):
    def __init__(
        self,
        level: str = None,
        method: str = None,
    ):
        self.level = level
        self.method = method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class ListJobResponseBodyJobListJobOutputAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        qscale: str = None,
        samplerate: str = None,
        volume: ListJobResponseBodyJobListJobOutputAudioVolume = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.qscale = qscale
        self.samplerate = samplerate
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class ListJobResponseBodyJobListJobOutputClipTimeSpan(TeaModel):
    def __init__(
        self,
        duration: str = None,
        seek: str = None,
    ):
        self.duration = duration
        self.seek = seek

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.seek is not None:
            result['Seek'] = self.seek
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        return self


class ListJobResponseBodyJobListJobOutputClip(TeaModel):
    def __init__(
        self,
        time_span: ListJobResponseBodyJobListJobOutputClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class ListJobResponseBodyJobListJobOutputContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListJobResponseBodyJobListJobOutputEncryption(TeaModel):
    def __init__(
        self,
        id: str = None,
        key: str = None,
        key_type: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
        type: str = None,
    ):
        self.id = id
        self.key = key
        self.key_type = key_type
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        md_5support: bool = None,
        size_support: bool = None,
    ):
        self.md_5support = md_5support
        self.size_support = size_support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class ListJobResponseBodyJobListJobOutputMergeListMerge(TeaModel):
    def __init__(
        self,
        duration: str = None,
        merge_url: str = None,
        role_arn: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.merge_url = merge_url
        self.role_arn = role_arn
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListJobResponseBodyJobListJobOutputMergeList(TeaModel):
    def __init__(
        self,
        merge: List[ListJobResponseBodyJobListJobOutputMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = ListJobResponseBodyJobListJobOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigGif(TeaModel):
    def __init__(
        self,
        dither_mode: str = None,
        final_delay: str = None,
        is_custom_palette: str = None,
        loop: str = None,
    ):
        self.dither_mode = dither_mode
        self.final_delay = final_delay
        self.is_custom_palette = is_custom_palette
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigWebp(TeaModel):
    def __init__(
        self,
        loop: str = None,
    ):
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfig(TeaModel):
    def __init__(
        self,
        gif: ListJobResponseBodyJobListJobOutputMuxConfigGif = None,
        segment: ListJobResponseBodyJobListJobOutputMuxConfigSegment = None,
        webp: ListJobResponseBodyJobListJobOutputMuxConfigWebp = None,
    ):
        self.gif = gif
        self.segment = segment
        self.webp = webp

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()
        if self.webp:
            self.webp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        if m.get('Webp') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        return self


class ListJobResponseBodyJobListJobOutputOpeningListOpening(TeaModel):
    def __init__(
        self,
        height: str = None,
        start: str = None,
        width: str = None,
        open_url: str = None,
    ):
        self.height = height
        self.start = start
        self.width = width
        self.open_url = open_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.start is not None:
            result['Start'] = self.start
        if self.width is not None:
            result['Width'] = self.width
        if self.open_url is not None:
            result['openUrl'] = self.open_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('openUrl') is not None:
            self.open_url = m.get('openUrl')
        return self


class ListJobResponseBodyJobListJobOutputOpeningList(TeaModel):
    def __init__(
        self,
        opening: List[ListJobResponseBodyJobListJobOutputOpeningListOpening] = None,
    ):
        self.opening = opening

    def validate(self):
        if self.opening:
            for k in self.opening:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Opening'] = []
        if self.opening is not None:
            for k in self.opening:
                result['Opening'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.opening = []
        if m.get('Opening') is not None:
            for k in m.get('Opening'):
                temp_model = ListJobResponseBodyJobListJobOutputOpeningListOpening()
                self.opening.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
        message: str = None,
        out_subtitle_file: ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile = None,
        success: bool = None,
    ):
        self.map = map
        self.message = message
        self.out_subtitle_file = out_subtitle_file
        self.success = success

    def validate(self):
        if self.out_subtitle_file:
            self.out_subtitle_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        if self.message is not None:
            result['Message'] = self.message
        if self.out_subtitle_file is not None:
            result['OutSubtitleFile'] = self.out_subtitle_file.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OutSubtitleFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile()
            self.out_subtitle_file = temp_model.from_map(m['OutSubtitleFile'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleList(TeaModel):
    def __init__(
        self,
        out_subtitle: List[ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle] = None,
    ):
        self.out_subtitle = out_subtitle

    def validate(self):
        if self.out_subtitle:
            for k in self.out_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutSubtitle'] = []
        if self.out_subtitle is not None:
            for k in self.out_subtitle:
                result['OutSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.out_subtitle = []
        if m.get('OutSubtitle') is not None:
            for k in m.get('OutSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle()
                self.out_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesFormat(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        format_long_name: str = None,
        format_name: str = None,
        num_programs: str = None,
        num_streams: str = None,
        size: str = None,
        start_time: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.format_long_name = format_long_name
        self.format_name = format_name
        self.num_programs = num_programs
        self.num_streams = num_streams
        self.size = size
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        num_frames: str = None,
        sample_fmt: str = None,
        samplerate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        self.bitrate = bitrate
        self.channel_layout = channel_layout
        self.channels = channels
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.duration = duration
        self.index = index
        self.lang = lang
        self.num_frames = num_frames
        self.sample_fmt = sample_fmt
        self.samplerate = samplerate
        self.start_time = start_time
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
        preload_time: str = None,
    ):
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth
        self.preload_time = preload_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bitrate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        network_cost: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        sar: str = None,
        start_time: str = None,
        timebase: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bitrate = bitrate
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.dar = dar
        self.duration = duration
        self.fps = fps
        self.has_bframes = has_bframes
        self.height = height
        self.index = index
        self.lang = lang
        self.level = level
        self.network_cost = network_cost
        self.num_frames = num_frames
        self.pix_fmt = pix_fmt
        self.profile = profile
        self.sar = sar
        self.start_time = start_time
        self.timebase = timebase
        self.width = width

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreams(TeaModel):
    def __init__(
        self,
        audio_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList = None,
        video_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList = None,
    ):
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list
        self.video_stream_list = video_stream_list

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class ListJobResponseBodyJobListJobOutputProperties(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_format: str = None,
        file_size: str = None,
        format: ListJobResponseBodyJobListJobOutputPropertiesFormat = None,
        fps: str = None,
        height: str = None,
        streams: ListJobResponseBodyJobListJobOutputPropertiesStreams = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.file_format = file_format
        self.file_size = file_size
        self.format = format
        self.fps = fps
        self.height = height
        self.streams = streams
        self.width = width

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Streams') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList = None,
        subtitle_list: ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class ListJobResponseBodyJobListJobOutputSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class ListJobResponseBodyJobListJobOutputTailSlateListTailSlate(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        blend_duration: str = None,
        height: str = None,
        is_merge_audio: bool = None,
        start: str = None,
        tail_url: str = None,
        width: str = None,
    ):
        self.bg_color = bg_color
        self.blend_duration = blend_duration
        self.height = height
        self.is_merge_audio = is_merge_audio
        self.start = start
        self.tail_url = tail_url
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.blend_duration is not None:
            result['BlendDuration'] = self.blend_duration
        if self.height is not None:
            result['Height'] = self.height
        if self.is_merge_audio is not None:
            result['IsMergeAudio'] = self.is_merge_audio
        if self.start is not None:
            result['Start'] = self.start
        if self.tail_url is not None:
            result['TailUrl'] = self.tail_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BlendDuration') is not None:
            self.blend_duration = m.get('BlendDuration')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsMergeAudio') is not None:
            self.is_merge_audio = m.get('IsMergeAudio')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('TailUrl') is not None:
            self.tail_url = m.get('TailUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputTailSlateList(TeaModel):
    def __init__(
        self,
        tail_slate: List[ListJobResponseBodyJobListJobOutputTailSlateListTailSlate] = None,
    ):
        self.tail_slate = tail_slate

    def validate(self):
        if self.tail_slate:
            for k in self.tail_slate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TailSlate'] = []
        if self.tail_slate is not None:
            for k in self.tail_slate:
                result['TailSlate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tail_slate = []
        if m.get('TailSlate') is not None:
            for k in m.get('TailSlate'):
                temp_model = ListJobResponseBodyJobListJobOutputTailSlateListTailSlate()
                self.tail_slate.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputTransConfig(TeaModel):
    def __init__(
        self,
        adj_dar_method: str = None,
        is_check_audio_bitrate: str = None,
        is_check_audio_bitrate_fail: str = None,
        is_check_reso: str = None,
        is_check_reso_fail: str = None,
        is_check_video_bitrate: str = None,
        is_check_video_bitrate_fail: str = None,
        trans_mode: str = None,
    ):
        self.adj_dar_method = adj_dar_method
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail
        self.is_check_reso = is_check_reso
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class ListJobResponseBodyJobListJobOutputVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class ListJobResponseBodyJobListJobOutputVideo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        bitrate_bnd: ListJobResponseBodyJobListJobOutputVideoBitrateBnd = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        degrain: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        max_fps: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        qscale: str = None,
        reso_priority: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.bitrate_bnd = bitrate_bnd
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.crop = crop
        self.degrain = degrain
        self.fps = fps
        self.gop = gop
        self.height = height
        self.max_fps = max_fps
        self.maxrate = maxrate
        self.pad = pad
        self.pix_fmt = pix_fmt
        self.preset = preset
        self.profile = profile
        self.qscale = qscale
        self.reso_priority = reso_priority
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        height: str = None,
        input_file: ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile = None,
        refer_pos: str = None,
        type: str = None,
        water_mark_template_id: str = None,
        width: str = None,
    ):
        self.dx = dx
        self.dy = dy
        self.height = height
        self.input_file = input_file
        self.refer_pos = refer_pos
        self.type = type
        self.water_mark_template_id = water_mark_template_id
        self.width = width

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.type is not None:
            result['Type'] = self.type
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutput(TeaModel):
    def __init__(
        self,
        audio: ListJobResponseBodyJobListJobOutputAudio = None,
        audio_stream_map: str = None,
        clip: ListJobResponseBodyJobListJobOutputClip = None,
        container: ListJobResponseBodyJobListJobOutputContainer = None,
        de_watermark: str = None,
        encryption: ListJobResponseBodyJobListJobOutputEncryption = None,
        m_3u8non_standard_support: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport = None,
        merge_config_url: str = None,
        merge_list: ListJobResponseBodyJobListJobOutputMergeList = None,
        mux_config: ListJobResponseBodyJobListJobOutputMuxConfig = None,
        opening_list: ListJobResponseBodyJobListJobOutputOpeningList = None,
        out_subtitle_list: ListJobResponseBodyJobListJobOutputOutSubtitleList = None,
        output_file: ListJobResponseBodyJobListJobOutputOutputFile = None,
        priority: str = None,
        properties: ListJobResponseBodyJobListJobOutputProperties = None,
        rotate: str = None,
        subtitle_config: ListJobResponseBodyJobListJobOutputSubtitleConfig = None,
        super_reso: ListJobResponseBodyJobListJobOutputSuperReso = None,
        tail_slate_list: ListJobResponseBodyJobListJobOutputTailSlateList = None,
        template_id: str = None,
        trans_config: ListJobResponseBodyJobListJobOutputTransConfig = None,
        user_data: str = None,
        video: ListJobResponseBodyJobListJobOutputVideo = None,
        video_stream_map: str = None,
        water_mark_config_url: str = None,
        water_mark_list: ListJobResponseBodyJobListJobOutputWaterMarkList = None,
    ):
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.clip = clip
        self.container = container
        self.de_watermark = de_watermark
        self.encryption = encryption
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.merge_config_url = merge_config_url
        self.merge_list = merge_list
        self.mux_config = mux_config
        self.opening_list = opening_list
        self.out_subtitle_list = out_subtitle_list
        self.output_file = output_file
        self.priority = priority
        self.properties = properties
        self.rotate = rotate
        self.subtitle_config = subtitle_config
        self.super_reso = super_reso
        self.tail_slate_list = tail_slate_list
        self.template_id = template_id
        self.trans_config = trans_config
        self.user_data = user_data
        self.video = video
        self.video_stream_map = video_stream_map
        self.water_mark_config_url = water_mark_config_url
        self.water_mark_list = water_mark_list

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.clip:
            self.clip.validate()
        if self.container:
            self.container.validate()
        if self.encryption:
            self.encryption.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.opening_list:
            self.opening_list.validate()
        if self.out_subtitle_list:
            self.out_subtitle_list.validate()
        if self.output_file:
            self.output_file.validate()
        if self.properties:
            self.properties.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.tail_slate_list:
            self.tail_slate_list.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.opening_list is not None:
            result['OpeningList'] = self.opening_list.to_map()
        if self.out_subtitle_list is not None:
            result['OutSubtitleList'] = self.out_subtitle_list.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.tail_slate_list is not None:
            result['TailSlateList'] = self.tail_slate_list.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('Clip') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('Container') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('Encryption') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MergeList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('MuxConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('OpeningList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOpeningList()
            self.opening_list = temp_model.from_map(m['OpeningList'])
        if m.get('OutSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleList()
            self.out_subtitle_list = temp_model.from_map(m['OutSubtitleList'])
        if m.get('OutputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Properties') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('SuperReso') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('TailSlateList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTailSlateList()
            self.tail_slate_list = temp_model.from_map(m['TailSlateList'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TransConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Video') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('WaterMarkList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        return self


class ListJobResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        finish_time: str = None,
        input: ListJobResponseBodyJobListJobInput = None,
        job_id: str = None,
        mnsmessage_result: ListJobResponseBodyJobListJobMNSMessageResult = None,
        message: str = None,
        output: ListJobResponseBodyJobListJobOutput = None,
        percent: int = None,
        pipeline_id: str = None,
        state: str = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.mnsmessage_result = mnsmessage_result
        self.message = message
        self.output = output
        self.percent = percent
        self.pipeline_id = pipeline_id
        self.state = state

    def validate(self):
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = ListJobResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            temp_model = ListJobResponseBodyJobListJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListJobResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[ListJobResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = ListJobResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(
        self,
        job_list: ListJobResponseBodyJobList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.job_list = job_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = ListJobResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        to: str = None,
    ):
        self.from_ = from_
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class ListMediaResponseBodyMediaListMediaFile(TeaModel):
    def __init__(
        self,
        state: str = None,
        url: str = None,
    ):
        self.state = state
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class ListMediaResponseBodyMediaListMediaRunIdList(TeaModel):
    def __init__(
        self,
        run_id: List[str] = None,
    ):
        self.run_id = run_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class ListMediaResponseBodyMediaListMediaTags(TeaModel):
    def __init__(
        self,
        tag: List[str] = None,
    ):
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class ListMediaResponseBodyMediaListMedia(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        cate_id: int = None,
        censor_state: str = None,
        cover_url: str = None,
        creation_time: str = None,
        description: str = None,
        duration: str = None,
        file: ListMediaResponseBodyMediaListMediaFile = None,
        format: str = None,
        fps: str = None,
        height: str = None,
        media_id: str = None,
        publish_state: str = None,
        run_id_list: ListMediaResponseBodyMediaListMediaRunIdList = None,
        size: str = None,
        tags: ListMediaResponseBodyMediaListMediaTags = None,
        title: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.cate_id = cate_id
        self.censor_state = censor_state
        self.cover_url = cover_url
        self.creation_time = creation_time
        self.description = description
        self.duration = duration
        self.file = file
        self.format = format
        self.fps = fps
        self.height = height
        self.media_id = media_id
        self.publish_state = publish_state
        self.run_id_list = run_id_list
        self.size = size
        self.tags = tags
        self.title = title
        self.width = width

    def validate(self):
        if self.file:
            self.file.validate()
        if self.run_id_list:
            self.run_id_list.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.size is not None:
            result['Size'] = self.size
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('File') is not None:
            temp_model = ListMediaResponseBodyMediaListMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('RunIdList') is not None:
            temp_model = ListMediaResponseBodyMediaListMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Tags') is not None:
            temp_model = ListMediaResponseBodyMediaListMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaResponseBodyMediaList(TeaModel):
    def __init__(
        self,
        media: List[ListMediaResponseBodyMediaListMedia] = None,
    ):
        self.media = media

    def validate(self):
        if self.media:
            for k in self.media:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Media'] = []
        if self.media is not None:
            for k in self.media:
                result['Media'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media = []
        if m.get('Media') is not None:
            for k in m.get('Media'):
                temp_model = ListMediaResponseBodyMediaListMedia()
                self.media.append(temp_model.from_map(k))
        return self


class ListMediaResponseBody(TeaModel):
    def __init__(
        self,
        media_list: ListMediaResponseBodyMediaList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.media_list = media_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.media_list:
            self.media_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_list is not None:
            result['MediaList'] = self.media_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaList') is not None:
            temp_model = ListMediaResponseBodyMediaList()
            self.media_list = temp_model.from_map(m['MediaList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMediaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaWorkflowExecutionsRequest(TeaModel):
    def __init__(
        self,
        input_file_url: str = None,
        maximum_page_size: int = None,
        media_workflow_id: str = None,
        media_workflow_name: str = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.input_file_url = input_file_url
        self.maximum_page_size = maximum_page_size
        self.media_workflow_id = media_workflow_id
        self.media_workflow_name = media_workflow_name
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file_url is not None:
            result['InputFileURL'] = self.input_file_url
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFileURL') is not None:
            self.input_file_url = m.get('InputFileURL')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity(TeaModel):
    def __init__(
        self,
        code: str = None,
        end_time: str = None,
        job_id: str = None,
        mnsmessage_result: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult = None,
        message: str = None,
        name: str = None,
        start_time: str = None,
        state: str = None,
        type: str = None,
    ):
        self.code = code
        self.end_time = end_time
        self.job_id = job_id
        self.mnsmessage_result = mnsmessage_result
        self.message = message
        self.name = name
        self.start_time = start_time
        self.state = state
        self.type = type

    def validate(self):
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList(TeaModel):
    def __init__(
        self,
        activity: List[ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity] = None,
    ):
        self.activity = activity

    def validate(self):
        if self.activity:
            for k in self.activity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Activity'] = []
        if self.activity is not None:
            for k in self.activity:
                result['Activity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.activity = []
        if m.get('Activity') is not None:
            for k in m.get('Activity'):
                temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity()
                self.activity.append(temp_model.from_map(k))
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput(TeaModel):
    def __init__(
        self,
        input_file: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile = None,
        user_data: str = None,
    ):
        self.input_file = input_file
        self.user_data = user_data

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution(TeaModel):
    def __init__(
        self,
        activity_list: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList = None,
        creation_time: str = None,
        input: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput = None,
        media_id: str = None,
        media_workflow_id: str = None,
        name: str = None,
        run_id: str = None,
        state: str = None,
    ):
        self.activity_list = activity_list
        self.creation_time = creation_time
        self.input = input
        self.media_id = media_id
        self.media_workflow_id = media_workflow_id
        self.name = name
        self.run_id = run_id
        self.state = state

    def validate(self):
        if self.activity_list:
            self.activity_list.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_list is not None:
            result['ActivityList'] = self.activity_list.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.run_id is not None:
            result['RunId'] = self.run_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActivityList') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList()
            self.activity_list = temp_model.from_map(m['ActivityList'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Input') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList(TeaModel):
    def __init__(
        self,
        media_workflow_execution: List[ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution] = None,
    ):
        self.media_workflow_execution = media_workflow_execution

    def validate(self):
        if self.media_workflow_execution:
            for k in self.media_workflow_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaWorkflowExecution'] = []
        if self.media_workflow_execution is not None:
            for k in self.media_workflow_execution:
                result['MediaWorkflowExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_workflow_execution = []
        if m.get('MediaWorkflowExecution') is not None:
            for k in m.get('MediaWorkflowExecution'):
                temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution()
                self.media_workflow_execution.append(temp_model.from_map(k))
        return self


class ListMediaWorkflowExecutionsResponseBody(TeaModel):
    def __init__(
        self,
        media_workflow_execution_list: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.media_workflow_execution_list = media_workflow_execution_list
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.media_workflow_execution_list:
            self.media_workflow_execution_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_execution_list is not None:
            result['MediaWorkflowExecutionList'] = self.media_workflow_execution_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaWorkflowExecutionList') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList()
            self.media_workflow_execution_list = temp_model.from_map(m['MediaWorkflowExecutionList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMediaWorkflowExecutionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMediaWorkflowExecutionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPornPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        state: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListPornPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListPornPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: ListPornPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = ListPornPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListPornPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListPornPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListPornPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListPornPipelineResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pipeline_list: ListPornPipelineResponseBodyPipelineList = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.pipeline_list = pipeline_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PipelineList') is not None:
            temp_model = ListPornPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPornPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListPornPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPornPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTerrorismPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        state: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListTerrorismPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListTerrorismPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListTerrorismPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListTerrorismPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListTerrorismPipelineResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pipeline_list: ListTerrorismPipelineResponseBodyPipelineList = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.pipeline_list = pipeline_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PipelineList') is not None:
            temp_model = ListTerrorismPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTerrorismPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTerrorismPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTerrorismPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LogicalDeleteResourceRequest(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        message: str = None,
        pk: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.message = message
        self.pk = pk
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        return self


class LogicalDeleteResourceResponseBody(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        message: str = None,
        pk: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.message = message
        self.pk = pk
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        return self


class LogicalDeleteResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: LogicalDeleteResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LogicalDeleteResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PhysicalDeleteResourceRequest(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        message: str = None,
        pk: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.message = message
        self.pk = pk
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        return self


class PhysicalDeleteResourceResponseBody(TeaModel):
    def __init__(
        self,
        bid: str = None,
        country: str = None,
        gmt_wakeup: str = None,
        hid: int = None,
        interrupt: bool = None,
        invoker: str = None,
        message: str = None,
        pk: str = None,
        success: bool = None,
        task_extra_data: str = None,
        task_identifier: str = None,
    ):
        self.bid = bid
        self.country = country
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.interrupt = interrupt
        self.invoker = invoker
        self.message = message
        self.pk = pk
        self.success = success
        self.task_extra_data = task_extra_data
        self.task_identifier = task_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.country is not None:
            result['Country'] = self.country
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.message is not None:
            result['Message'] = self.message
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.success is not None:
            result['Success'] = self.success
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        return self


class PhysicalDeleteResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PhysicalDeleteResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PhysicalDeleteResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PlayInfoRequest(TeaModel):
    def __init__(
        self,
        auth_info: str = None,
        auth_timeout: int = None,
        formats: str = None,
        hls_uri_token: str = None,
        media_id: str = None,
        owner_account: str = None,
        owner_id: str = None,
        play_domain: str = None,
        rand: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
        terminal: str = None,
    ):
        self.auth_info = auth_info
        self.auth_timeout = auth_timeout
        self.formats = formats
        self.hls_uri_token = hls_uri_token
        self.media_id = media_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.play_domain = play_domain
        self.rand = rand
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_info is not None:
            result['AuthInfo'] = self.auth_info
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.formats is not None:
            result['Formats'] = self.formats
        if self.hls_uri_token is not None:
            result['HlsUriToken'] = self.hls_uri_token
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.rand is not None:
            result['Rand'] = self.rand
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.terminal is not None:
            result['Terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthInfo') is not None:
            self.auth_info = m.get('AuthInfo')
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('Formats') is not None:
            self.formats = m.get('Formats')
        if m.get('HlsUriToken') is not None:
            self.hls_uri_token = m.get('HlsUriToken')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('Rand') is not None:
            self.rand = m.get('Rand')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Terminal') is not None:
            self.terminal = m.get('Terminal')
        return self


class PlayInfoResponseBodyNotFoundCDNDomain(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class PlayInfoResponseBodyPlayInfoListPlayInfo(TeaModel):
    def __init__(
        self,
        url: str = None,
        activity_name: str = None,
        bitrate: str = None,
        complexity: str = None,
        definition: str = None,
        download_type: str = None,
        duration: str = None,
        encryption: str = None,
        encryption_type: str = None,
        format: str = None,
        fps: str = None,
        height: str = None,
        plaintext: str = None,
        rand: str = None,
        size: str = None,
        width: str = None,
    ):
        self.url = url
        self.activity_name = activity_name
        self.bitrate = bitrate
        self.complexity = complexity
        self.definition = definition
        self.download_type = download_type
        self.duration = duration
        self.encryption = encryption
        self.encryption_type = encryption_type
        self.format = format
        self.fps = fps
        self.height = height
        self.plaintext = plaintext
        self.rand = rand
        self.size = size
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        if self.activity_name is not None:
            result['activityName'] = self.activity_name
        if self.bitrate is not None:
            result['bitrate'] = self.bitrate
        if self.complexity is not None:
            result['complexity'] = self.complexity
        if self.definition is not None:
            result['definition'] = self.definition
        if self.download_type is not None:
            result['downloadType'] = self.download_type
        if self.duration is not None:
            result['duration'] = self.duration
        if self.encryption is not None:
            result['encryption'] = self.encryption
        if self.encryption_type is not None:
            result['encryptionType'] = self.encryption_type
        if self.format is not None:
            result['format'] = self.format
        if self.fps is not None:
            result['fps'] = self.fps
        if self.height is not None:
            result['height'] = self.height
        if self.plaintext is not None:
            result['plaintext'] = self.plaintext
        if self.rand is not None:
            result['rand'] = self.rand
        if self.size is not None:
            result['size'] = self.size
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('activityName') is not None:
            self.activity_name = m.get('activityName')
        if m.get('bitrate') is not None:
            self.bitrate = m.get('bitrate')
        if m.get('complexity') is not None:
            self.complexity = m.get('complexity')
        if m.get('definition') is not None:
            self.definition = m.get('definition')
        if m.get('downloadType') is not None:
            self.download_type = m.get('downloadType')
        if m.get('duration') is not None:
            self.duration = m.get('duration')
        if m.get('encryption') is not None:
            self.encryption = m.get('encryption')
        if m.get('encryptionType') is not None:
            self.encryption_type = m.get('encryptionType')
        if m.get('format') is not None:
            self.format = m.get('format')
        if m.get('fps') is not None:
            self.fps = m.get('fps')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('plaintext') is not None:
            self.plaintext = m.get('plaintext')
        if m.get('rand') is not None:
            self.rand = m.get('rand')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class PlayInfoResponseBodyPlayInfoList(TeaModel):
    def __init__(
        self,
        play_info: List[PlayInfoResponseBodyPlayInfoListPlayInfo] = None,
    ):
        self.play_info = play_info

    def validate(self):
        if self.play_info:
            for k in self.play_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PlayInfo'] = []
        if self.play_info is not None:
            for k in self.play_info:
                result['PlayInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.play_info = []
        if m.get('PlayInfo') is not None:
            for k in m.get('PlayInfo'):
                temp_model = PlayInfoResponseBodyPlayInfoListPlayInfo()
                self.play_info.append(temp_model.from_map(k))
        return self


class PlayInfoResponseBody(TeaModel):
    def __init__(
        self,
        not_found_cdndomain: PlayInfoResponseBodyNotFoundCDNDomain = None,
        play_info_list: PlayInfoResponseBodyPlayInfoList = None,
        request_id: str = None,
    ):
        self.not_found_cdndomain = not_found_cdndomain
        self.play_info_list = play_info_list
        self.request_id = request_id

    def validate(self):
        if self.not_found_cdndomain:
            self.not_found_cdndomain.validate()
        if self.play_info_list:
            self.play_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.not_found_cdndomain is not None:
            result['NotFoundCDNDomain'] = self.not_found_cdndomain.to_map()
        if self.play_info_list is not None:
            result['PlayInfoList'] = self.play_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotFoundCDNDomain') is not None:
            temp_model = PlayInfoResponseBodyNotFoundCDNDomain()
            self.not_found_cdndomain = temp_model.from_map(m['NotFoundCDNDomain'])
        if m.get('PlayInfoList') is not None:
            temp_model = PlayInfoResponseBodyPlayInfoList()
            self.play_info_list = temp_model.from_map(m['PlayInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PlayInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PlayInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PlayerAuthRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class PlayerAuthResponseBodySwitchListSwitch(TeaModel):
    def __init__(
        self,
        function_id: str = None,
        function_name: str = None,
        state: str = None,
        switch_id: str = None,
    ):
        self.function_id = function_id
        self.function_name = function_name
        self.state = state
        self.switch_id = switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_id is not None:
            result['FunctionId'] = self.function_id
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.state is not None:
            result['State'] = self.state
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FunctionId') is not None:
            self.function_id = m.get('FunctionId')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class PlayerAuthResponseBodySwitchList(TeaModel):
    def __init__(
        self,
        switch: List[PlayerAuthResponseBodySwitchListSwitch] = None,
    ):
        self.switch = switch

    def validate(self):
        if self.switch:
            for k in self.switch:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Switch'] = []
        if self.switch is not None:
            for k in self.switch:
                result['Switch'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.switch = []
        if m.get('Switch') is not None:
            for k in m.get('Switch'):
                temp_model = PlayerAuthResponseBodySwitchListSwitch()
                self.switch.append(temp_model.from_map(k))
        return self


class PlayerAuthResponseBody(TeaModel):
    def __init__(
        self,
        log_url: str = None,
        request_id: str = None,
        switch_list: PlayerAuthResponseBodySwitchList = None,
    ):
        self.log_url = log_url
        self.request_id = request_id
        self.switch_list = switch_list

    def validate(self):
        if self.switch_list:
            self.switch_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_url is not None:
            result['LogURL'] = self.log_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.switch_list is not None:
            result['SwitchList'] = self.switch_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogURL') is not None:
            self.log_url = m.get('LogURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SwitchList') is not None:
            temp_model = PlayerAuthResponseBodySwitchList()
            self.switch_list = temp_model.from_map(m['SwitchList'])
        return self


class PlayerAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PlayerAuthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PlayerAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAnalysisJobListRequest(TeaModel):
    def __init__(
        self,
        analysis_job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.analysis_job_ids = analysis_job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_job_ids is not None:
            result['AnalysisJobIds'] = self.analysis_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisJobIds') is not None:
            self.analysis_job_ids = m.get('AnalysisJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop(TeaModel):
    def __init__(
        self,
        height: str = None,
        left: str = None,
        mode: str = None,
        top: str = None,
        width: str = None,
    ):
        self.height = height
        self.left = left
        self.mode = mode
        self.top = top
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.left is not None:
            result['Left'] = self.left
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.top is not None:
            result['Top'] = self.top
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl(TeaModel):
    def __init__(
        self,
        crop: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop = None,
        deinterlace: str = None,
    ):
        self.crop = crop
        self.deinterlace = deinterlace

    def validate(self):
        if self.crop:
            self.crop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.crop is not None:
            result['Crop'] = self.crop.to_map()
        if self.deinterlace is not None:
            result['Deinterlace'] = self.deinterlace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Crop') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop()
            self.crop = temp_model.from_map(m['Crop'])
        if m.get('Deinterlace') is not None:
            self.deinterlace = m.get('Deinterlace')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl(TeaModel):
    def __init__(
        self,
        method_streaming: str = None,
        rate_quality: str = None,
    ):
        self.method_streaming = method_streaming
        self.rate_quality = rate_quality

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_streaming is not None:
            result['MethodStreaming'] = self.method_streaming
        if self.rate_quality is not None:
            result['RateQuality'] = self.rate_quality
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MethodStreaming') is not None:
            self.method_streaming = m.get('MethodStreaming')
        if m.get('RateQuality') is not None:
            self.rate_quality = m.get('RateQuality')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig(TeaModel):
    def __init__(
        self,
        properties_control: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl = None,
        quality_control: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl = None,
    ):
        self.properties_control = properties_control
        self.quality_control = quality_control

    def validate(self):
        if self.properties_control:
            self.properties_control.validate()
        if self.quality_control:
            self.quality_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.properties_control is not None:
            result['PropertiesControl'] = self.properties_control.to_map()
        if self.quality_control is not None:
            result['QualityControl'] = self.quality_control.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PropertiesControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl()
            self.properties_control = temp_model.from_map(m['PropertiesControl'])
        if m.get('QualityControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl()
            self.quality_control = temp_model.from_map(m['QualityControl'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        qscale: str = None,
        samplerate: str = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.qscale = qscale
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        loop: str = None,
    ):
        self.final_delay = final_delay
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif = None,
        segment: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig(TeaModel):
    def __init__(
        self,
        trans_mode: str = None,
    ):
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        bitrate_bnd: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        degrain: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        maxrate: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        qscale: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.bitrate_bnd = bitrate_bnd
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.degrain = degrain
        self.fps = fps
        self.gop = gop
        self.height = height
        self.maxrate = maxrate
        self.pix_fmt = pix_fmt
        self.preset = preset
        self.profile = profile
        self.qscale = qscale
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate(TeaModel):
    def __init__(
        self,
        audio: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio = None,
        container: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer = None,
        id: str = None,
        mux_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig = None,
        name: str = None,
        state: str = None,
        trans_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig = None,
        video: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo = None,
    ):
        self.audio = audio
        self.container = container
        self.id = id
        self.mux_config = mux_config
        self.name = name
        self.state = state
        self.trans_config = trans_config
        self.video = video

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MuxConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TransConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Video') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList(TeaModel):
    def __init__(
        self,
        template: List[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob(TeaModel):
    def __init__(
        self,
        analysis_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig = None,
        code: str = None,
        creation_time: str = None,
        id: str = None,
        input_file: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile = None,
        mnsmessage_result: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult = None,
        message: str = None,
        percent: int = None,
        pipeline_id: str = None,
        priority: str = None,
        state: str = None,
        template_list: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList = None,
        user_data: str = None,
    ):
        self.analysis_config = analysis_config
        self.code = code
        self.creation_time = creation_time
        self.id = id
        self.input_file = input_file
        self.mnsmessage_result = mnsmessage_result
        self.message = message
        self.percent = percent
        self.pipeline_id = pipeline_id
        self.priority = priority
        self.state = state
        self.template_list = template_list
        self.user_data = user_data

    def validate(self):
        if self.analysis_config:
            self.analysis_config.validate()
        if self.input_file:
            self.input_file.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.template_list:
            self.template_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_config is not None:
            result['AnalysisConfig'] = self.analysis_config.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig()
            self.analysis_config = temp_model.from_map(m['AnalysisConfig'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InputFile') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TemplateList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobList(TeaModel):
    def __init__(
        self,
        analysis_job: List[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob] = None,
    ):
        self.analysis_job = analysis_job

    def validate(self):
        if self.analysis_job:
            for k in self.analysis_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnalysisJob'] = []
        if self.analysis_job is not None:
            for k in self.analysis_job:
                result['AnalysisJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.analysis_job = []
        if m.get('AnalysisJob') is not None:
            for k in m.get('AnalysisJob'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob()
                self.analysis_job.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAnalysisJobListResponseBody(TeaModel):
    def __init__(
        self,
        analysis_job_list: QueryAnalysisJobListResponseBodyAnalysisJobList = None,
        non_exist_analysis_job_ids: QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds = None,
        request_id: str = None,
    ):
        self.analysis_job_list = analysis_job_list
        self.non_exist_analysis_job_ids = non_exist_analysis_job_ids
        self.request_id = request_id

    def validate(self):
        if self.analysis_job_list:
            self.analysis_job_list.validate()
        if self.non_exist_analysis_job_ids:
            self.non_exist_analysis_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_job_list is not None:
            result['AnalysisJobList'] = self.analysis_job_list.to_map()
        if self.non_exist_analysis_job_ids is not None:
            result['NonExistAnalysisJobIds'] = self.non_exist_analysis_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisJobList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobList()
            self.analysis_job_list = temp_model.from_map(m['AnalysisJobList'])
        if m.get('NonExistAnalysisJobIds') is not None:
            temp_model = QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds()
            self.non_exist_analysis_job_ids = temp_model.from_map(m['NonExistAnalysisJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAnalysisJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAnalysisJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAnalysisJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAnnotationJobListRequest(TeaModel):
    def __init__(
        self,
        annotation_job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.annotation_job_ids = annotation_job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation_job_ids is not None:
            result['AnnotationJobIds'] = self.annotation_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnnotationJobIds') is not None:
            self.annotation_job_ids = m.get('AnnotationJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation(TeaModel):
    def __init__(
        self,
        label: str = None,
        score: str = None,
    ):
        self.label = label
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations(TeaModel):
    def __init__(
        self,
        annotation: List[QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation] = None,
    ):
        self.annotation = annotation

    def validate(self):
        if self.annotation:
            for k in self.annotation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Annotation'] = []
        if self.annotation is not None:
            for k in self.annotation:
                result['Annotation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.annotation = []
        if m.get('Annotation') is not None:
            for k in m.get('Annotation'):
                temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation()
                self.annotation.append(temp_model.from_map(k))
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult(TeaModel):
    def __init__(
        self,
        annotations: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations = None,
        details: str = None,
    ):
        self.annotations = annotations
        self.details = details

    def validate(self):
        if self.annotations:
            self.annotations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['Annotations'] = self.annotations.to_map()
        if self.details is not None:
            result['Details'] = self.details
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotations') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations()
            self.annotations = temp_model.from_map(m['Annotations'])
        if m.get('Details') is not None:
            self.details = m.get('Details')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        id: str = None,
        input: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        state: str = None,
        user_data: str = None,
        video_annotation_result: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.id = id
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.state = state
        self.user_data = user_data
        self.video_annotation_result = video_annotation_result

    def validate(self):
        if self.input:
            self.input.validate()
        if self.video_annotation_result:
            self.video_annotation_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video_annotation_result is not None:
            result['VideoAnnotationResult'] = self.video_annotation_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VideoAnnotationResult') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult()
            self.video_annotation_result = temp_model.from_map(m['VideoAnnotationResult'])
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobList(TeaModel):
    def __init__(
        self,
        annotation_job: List[QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob] = None,
    ):
        self.annotation_job = annotation_job

    def validate(self):
        if self.annotation_job:
            for k in self.annotation_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnnotationJob'] = []
        if self.annotation_job is not None:
            for k in self.annotation_job:
                result['AnnotationJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.annotation_job = []
        if m.get('AnnotationJob') is not None:
            for k in m.get('AnnotationJob'):
                temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob()
                self.annotation_job.append(temp_model.from_map(k))
        return self


class QueryAnnotationJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAnnotationJobListResponseBody(TeaModel):
    def __init__(
        self,
        annotation_job_list: QueryAnnotationJobListResponseBodyAnnotationJobList = None,
        non_exist_ids: QueryAnnotationJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.annotation_job_list = annotation_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.annotation_job_list:
            self.annotation_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation_job_list is not None:
            result['AnnotationJobList'] = self.annotation_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnnotationJobList') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobList()
            self.annotation_job_list = temp_model.from_map(m['AnnotationJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryAnnotationJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAnnotationJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAnnotationJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAnnotationJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAsrJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAsrJobListResponseBodyJobListJobAsrConfig(TeaModel):
    def __init__(
        self,
        scene: str = None,
    ):
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene is not None:
            result['Scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        return self


class QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextListAsrText(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        end_time: str = None,
        speech_rate: str = None,
        start_time: int = None,
        text: str = None,
    ):
        self.channel_id = channel_id
        self.end_time = end_time
        self.speech_rate = speech_rate
        self.start_time = start_time
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextList(TeaModel):
    def __init__(
        self,
        asr_text: List[QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextListAsrText] = None,
    ):
        self.asr_text = asr_text

    def validate(self):
        if self.asr_text:
            for k in self.asr_text:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AsrText'] = []
        if self.asr_text is not None:
            for k in self.asr_text:
                result['AsrText'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asr_text = []
        if m.get('AsrText') is not None:
            for k in m.get('AsrText'):
                temp_model = QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextListAsrText()
                self.asr_text.append(temp_model.from_map(k))
        return self


class QueryAsrJobListResponseBodyJobListJobAsrResult(TeaModel):
    def __init__(
        self,
        asr_text_list: QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextList = None,
        duration: str = None,
    ):
        self.asr_text_list = asr_text_list
        self.duration = duration

    def validate(self):
        if self.asr_text_list:
            self.asr_text_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_text_list is not None:
            result['AsrTextList'] = self.asr_text_list.to_map()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrTextList') is not None:
            temp_model = QueryAsrJobListResponseBodyJobListJobAsrResultAsrTextList()
            self.asr_text_list = temp_model.from_map(m['AsrTextList'])
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryAsrJobListResponseBodyJobListJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryAsrJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        asr_config: QueryAsrJobListResponseBodyJobListJobAsrConfig = None,
        asr_result: QueryAsrJobListResponseBodyJobListJobAsrResult = None,
        code: str = None,
        creation_time: str = None,
        id: str = None,
        input: QueryAsrJobListResponseBodyJobListJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.asr_config = asr_config
        self.asr_result = asr_result
        self.code = code
        self.creation_time = creation_time
        self.id = id
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.state = state
        self.user_data = user_data

    def validate(self):
        if self.asr_config:
            self.asr_config.validate()
        if self.asr_result:
            self.asr_result.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_config is not None:
            result['AsrConfig'] = self.asr_config.to_map()
        if self.asr_result is not None:
            result['AsrResult'] = self.asr_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrConfig') is not None:
            temp_model = QueryAsrJobListResponseBodyJobListJobAsrConfig()
            self.asr_config = temp_model.from_map(m['AsrConfig'])
        if m.get('AsrResult') is not None:
            temp_model = QueryAsrJobListResponseBodyJobListJobAsrResult()
            self.asr_result = temp_model.from_map(m['AsrResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            temp_model = QueryAsrJobListResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryAsrJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryAsrJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryAsrJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryAsrJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAsrJobListResponseBody(TeaModel):
    def __init__(
        self,
        job_list: QueryAsrJobListResponseBodyJobList = None,
        non_exist_ids: QueryAsrJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.job_list = job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.job_list:
            self.job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = QueryAsrJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryAsrJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAsrJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAsrJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAsrJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAsrPipelineListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_ids: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_ids = pipeline_ids
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAsrPipelineListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue_name: str = None,
        topic: str = None,
    ):
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class QueryAsrPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryAsrPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[QueryAsrPipelineListResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = QueryAsrPipelineListResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class QueryAsrPipelineListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_ids: QueryAsrPipelineListResponseBodyNonExistIds = None,
        pipeline_list: QueryAsrPipelineListResponseBodyPipelineList = None,
        request_id: str = None,
    ):
        self.non_exist_ids = non_exist_ids
        self.pipeline_list = pipeline_list
        self.request_id = request_id

    def validate(self):
        if self.non_exist_ids:
            self.non_exist_ids.validate()
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistIds') is not None:
            temp_model = QueryAsrPipelineListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('PipelineList') is not None:
            temp_model = QueryAsrPipelineListResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAsrPipelineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAsrPipelineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAsrPipelineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAuthConfigRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAuthConfigResponseBody(TeaModel):
    def __init__(
        self,
        key_1: str = None,
        key_2: str = None,
        request_id: str = None,
    ):
        self.key_1 = key_1
        self.key_2 = key_2
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_1 is not None:
            result['Key1'] = self.key_1
        if self.key_2 is not None:
            result['Key2'] = self.key_2
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key1') is not None:
            self.key_1 = m.get('Key1')
        if m.get('Key2') is not None:
            self.key_2 = m.get('Key2')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAuthConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAuthConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAuthConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCensorJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfigOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfig(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        interval: str = None,
        output_file: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfigOutputFile = None,
        save_type: str = None,
        scenes: str = None,
    ):
        self.biz_type = biz_type
        self.interval = interval
        self.output_file = output_file
        self.save_type = save_type
        self.scenes = scenes

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        if self.scenes is not None:
            result['Scenes'] = self.scenes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OutputFile') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        if m.get('Scenes') is not None:
            self.scenes = m.get('Scenes')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterListCounter(TeaModel):
    def __init__(
        self,
        count: int = None,
        label: str = None,
    ):
        self.count = count
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterList(TeaModel):
    def __init__(
        self,
        counter: List[QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterListCounter] = None,
    ):
        self.counter = counter

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopListTop(TeaModel):
    def __init__(
        self,
        index: str = None,
        label: str = None,
        object: str = None,
        score: str = None,
        timestamp: str = None,
    ):
        self.index = index
        self.label = label
        self.object = object
        self.score = score
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopList(TeaModel):
    def __init__(
        self,
        top: List[QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopListTop] = None,
    ):
        self.top = top

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResult(TeaModel):
    def __init__(
        self,
        average_score: str = None,
        label: str = None,
        max_score: str = None,
        porn_counter_list: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterList = None,
        porn_top_list: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopList = None,
        suggestion: str = None,
    ):
        self.average_score = average_score
        self.label = label
        self.max_score = max_score
        self.porn_counter_list = porn_counter_list
        self.porn_top_list = porn_top_list
        self.suggestion = suggestion

    def validate(self):
        if self.porn_counter_list:
            self.porn_counter_list.validate()
        if self.porn_top_list:
            self.porn_top_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.porn_counter_list is not None:
            result['PornCounterList'] = self.porn_counter_list.to_map()
        if self.porn_top_list is not None:
            result['PornTopList'] = self.porn_top_list.to_map()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('PornCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornCounterList()
            self.porn_counter_list = temp_model.from_map(m['PornCounterList'])
        if m.get('PornTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResultPornTopList()
            self.porn_top_list = temp_model.from_map(m['PornTopList'])
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterListCounter(TeaModel):
    def __init__(
        self,
        count: int = None,
        label: str = None,
    ):
        self.count = count
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterList(TeaModel):
    def __init__(
        self,
        counter: List[QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterListCounter] = None,
    ):
        self.counter = counter

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopListTop(TeaModel):
    def __init__(
        self,
        index: str = None,
        label: str = None,
        object: str = None,
        score: str = None,
        timestamp: str = None,
    ):
        self.index = index
        self.label = label
        self.object = object
        self.score = score
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopList(TeaModel):
    def __init__(
        self,
        top: List[QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopListTop] = None,
    ):
        self.top = top

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResult(TeaModel):
    def __init__(
        self,
        average_score: str = None,
        label: str = None,
        max_score: str = None,
        suggestion: str = None,
        terrorism_counter_list: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterList = None,
        terrorism_top_list: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopList = None,
    ):
        self.average_score = average_score
        self.label = label
        self.max_score = max_score
        self.suggestion = suggestion
        self.terrorism_counter_list = terrorism_counter_list
        self.terrorism_top_list = terrorism_top_list

    def validate(self):
        if self.terrorism_counter_list:
            self.terrorism_counter_list.validate()
        if self.terrorism_top_list:
            self.terrorism_top_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.terrorism_counter_list is not None:
            result['TerrorismCounterList'] = self.terrorism_counter_list.to_map()
        if self.terrorism_top_list is not None:
            result['TerrorismTopList'] = self.terrorism_top_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TerrorismCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismCounterList()
            self.terrorism_counter_list = temp_model.from_map(m['TerrorismCounterList'])
        if m.get('TerrorismTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResultTerrorismTopList()
            self.terrorism_top_list = temp_model.from_map(m['TerrorismTopList'])
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResultsImageCensorResult(TeaModel):
    def __init__(
        self,
        image_bucket: str = None,
        image_location: str = None,
        image_object: str = None,
        result: str = None,
    ):
        self.image_bucket = image_bucket
        self.image_location = image_location
        self.image_object = image_object
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_bucket is not None:
            result['ImageBucket'] = self.image_bucket
        if self.image_location is not None:
            result['ImageLocation'] = self.image_location
        if self.image_object is not None:
            result['ImageObject'] = self.image_object
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageBucket') is not None:
            self.image_bucket = m.get('ImageBucket')
        if m.get('ImageLocation') is not None:
            self.image_location = m.get('ImageLocation')
        if m.get('ImageObject') is not None:
            self.image_object = m.get('ImageObject')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResults(TeaModel):
    def __init__(
        self,
        image_censor_result: List[QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResultsImageCensorResult] = None,
    ):
        self.image_censor_result = image_censor_result

    def validate(self):
        if self.image_censor_result:
            for k in self.image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageCensorResult'] = []
        if self.image_censor_result is not None:
            for k in self.image_censor_result:
                result['ImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_censor_result = []
        if m.get('ImageCensorResult') is not None:
            for k in m.get('ImageCensorResult'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResultsImageCensorResult()
                self.image_censor_result.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyCensorJobListCensorJob(TeaModel):
    def __init__(
        self,
        barrage_censor_result: str = None,
        censor_config: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfig = None,
        censor_porn_result: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResult = None,
        censor_terrorism_result: QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResult = None,
        code: str = None,
        creation_time: str = None,
        desc_censor_result: str = None,
        id: str = None,
        image_censor_results: QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResults = None,
        input: QueryCensorJobListResponseBodyCensorJobListCensorJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        result_save_object: str = None,
        state: str = None,
        title_censor_result: str = None,
        user_data: str = None,
    ):
        self.barrage_censor_result = barrage_censor_result
        self.censor_config = censor_config
        self.censor_porn_result = censor_porn_result
        self.censor_terrorism_result = censor_terrorism_result
        self.code = code
        self.creation_time = creation_time
        self.desc_censor_result = desc_censor_result
        self.id = id
        self.image_censor_results = image_censor_results
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.result_save_object = result_save_object
        self.state = state
        self.title_censor_result = title_censor_result
        self.user_data = user_data

    def validate(self):
        if self.censor_config:
            self.censor_config.validate()
        if self.censor_porn_result:
            self.censor_porn_result.validate()
        if self.censor_terrorism_result:
            self.censor_terrorism_result.validate()
        if self.image_censor_results:
            self.image_censor_results.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result
        if self.censor_config is not None:
            result['CensorConfig'] = self.censor_config.to_map()
        if self.censor_porn_result is not None:
            result['CensorPornResult'] = self.censor_porn_result.to_map()
        if self.censor_terrorism_result is not None:
            result['CensorTerrorismResult'] = self.censor_terrorism_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result
        if self.id is not None:
            result['Id'] = self.id
        if self.image_censor_results is not None:
            result['ImageCensorResults'] = self.image_censor_results.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.result_save_object is not None:
            result['ResultSaveObject'] = self.result_save_object
        if self.state is not None:
            result['State'] = self.state
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            self.barrage_censor_result = m.get('BarrageCensorResult')
        if m.get('CensorConfig') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorConfig()
            self.censor_config = temp_model.from_map(m['CensorConfig'])
        if m.get('CensorPornResult') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorPornResult()
            self.censor_porn_result = temp_model.from_map(m['CensorPornResult'])
        if m.get('CensorTerrorismResult') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobCensorTerrorismResult()
            self.censor_terrorism_result = temp_model.from_map(m['CensorTerrorismResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            self.desc_censor_result = m.get('DescCensorResult')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ImageCensorResults') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobImageCensorResults()
            self.image_censor_results = temp_model.from_map(m['ImageCensorResults'])
        if m.get('Input') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResultSaveObject') is not None:
            self.result_save_object = m.get('ResultSaveObject')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TitleCensorResult') is not None:
            self.title_censor_result = m.get('TitleCensorResult')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryCensorJobListResponseBodyCensorJobList(TeaModel):
    def __init__(
        self,
        censor_job: List[QueryCensorJobListResponseBodyCensorJobListCensorJob] = None,
    ):
        self.censor_job = censor_job

    def validate(self):
        if self.censor_job:
            for k in self.censor_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorJob'] = []
        if self.censor_job is not None:
            for k in self.censor_job:
                result['CensorJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_job = []
        if m.get('CensorJob') is not None:
            for k in m.get('CensorJob'):
                temp_model = QueryCensorJobListResponseBodyCensorJobListCensorJob()
                self.censor_job.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCensorJobListResponseBody(TeaModel):
    def __init__(
        self,
        censor_job_list: QueryCensorJobListResponseBodyCensorJobList = None,
        non_exist_ids: QueryCensorJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.censor_job_list = censor_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.censor_job_list:
            self.censor_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_job_list is not None:
            result['CensorJobList'] = self.censor_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CensorJobList') is not None:
            temp_model = QueryCensorJobListResponseBodyCensorJobList()
            self.censor_job_list = temp_model.from_map(m['CensorJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryCensorJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCensorJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCensorJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCensorJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCensorPipelineListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_ids: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_ids = pipeline_ids
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryCensorPipelineListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCensorPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class QueryCensorPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: QueryCensorPipelineListResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryCensorPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryCensorPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[QueryCensorPipelineListResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = QueryCensorPipelineListResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class QueryCensorPipelineListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_ids: QueryCensorPipelineListResponseBodyNonExistIds = None,
        pipeline_list: QueryCensorPipelineListResponseBodyPipelineList = None,
        request_id: str = None,
    ):
        self.non_exist_ids = non_exist_ids
        self.pipeline_list = pipeline_list
        self.request_id = request_id

    def validate(self):
        if self.non_exist_ids:
            self.non_exist_ids.validate()
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistIds') is not None:
            temp_model = QueryCensorPipelineListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('PipelineList') is not None:
            temp_model = QueryCensorPipelineListResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCensorPipelineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCensorPipelineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCensorPipelineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryComplexJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect(TeaModel):
    def __init__(
        self,
        effect: str = None,
        effect_config: str = None,
    ):
        self.effect = effect
        self.effect_config = effect_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('EffectConfig') is not None:
            self.effect_config = m.get('EffectConfig')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects(TeaModel):
    def __init__(
        self,
        effect: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect] = None,
    ):
        self.effect = effect

    def validate(self):
        if self.effect:
            for k in self.effect:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Effect'] = []
        if self.effect is not None:
            for k in self.effect:
                result['Effect'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effect = []
        if m.get('Effect') is not None:
            for k in m.get('Effect'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect()
                self.effect.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip(TeaModel):
    def __init__(
        self,
        effects: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects = None,
        id: str = None,
        in_: str = None,
        out: str = None,
        source_id: str = None,
        source_strm_map: str = None,
        source_type: str = None,
        type: str = None,
    ):
        self.effects = effects
        self.id = id
        self.in_ = in_
        self.out = out
        self.source_id = source_id
        self.source_strm_map = source_strm_map
        self.source_type = source_type
        self.type = type

    def validate(self):
        if self.effects:
            self.effects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effects is not None:
            result['Effects'] = self.effects.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.source_id is not None:
            result['SourceID'] = self.source_id
        if self.source_strm_map is not None:
            result['SourceStrmMap'] = self.source_strm_map
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effects') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects()
            self.effects = temp_model.from_map(m['Effects'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('SourceID') is not None:
            self.source_id = m.get('SourceID')
        if m.get('SourceStrmMap') is not None:
            self.source_strm_map = m.get('SourceStrmMap')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList(TeaModel):
    def __init__(
        self,
        clip: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio(TeaModel):
    def __init__(
        self,
        channel_layout: str = None,
        channels: str = None,
        samplerate: str = None,
    ):
        self.channel_layout = channel_layout
        self.channels = channels
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        fps: str = None,
        height: str = None,
        is_gpu_data: str = None,
        is_one_track_data: str = None,
        reclose_prec: str = None,
        render_ratio: str = None,
        width: str = None,
    ):
        self.bg_color = bg_color
        self.fps = fps
        self.height = height
        self.is_gpu_data = is_gpu_data
        self.is_one_track_data = is_one_track_data
        self.reclose_prec = reclose_prec
        self.render_ratio = render_ratio
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.is_gpu_data is not None:
            result['IsGpuData'] = self.is_gpu_data
        if self.is_one_track_data is not None:
            result['IsOneTrackData'] = self.is_one_track_data
        if self.reclose_prec is not None:
            result['ReclosePrec'] = self.reclose_prec
        if self.render_ratio is not None:
            result['RenderRatio'] = self.render_ratio
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsGpuData') is not None:
            self.is_gpu_data = m.get('IsGpuData')
        if m.get('IsOneTrackData') is not None:
            self.is_one_track_data = m.get('IsOneTrackData')
        if m.get('ReclosePrec') is not None:
            self.reclose_prec = m.get('ReclosePrec')
        if m.get('RenderRatio') is not None:
            self.render_ratio = m.get('RenderRatio')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig(TeaModel):
    def __init__(
        self,
        timeline_config_audio: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio = None,
        timeline_config_video: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo = None,
    ):
        self.timeline_config_audio = timeline_config_audio
        self.timeline_config_video = timeline_config_video

    def validate(self):
        if self.timeline_config_audio:
            self.timeline_config_audio.validate()
        if self.timeline_config_video:
            self.timeline_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config_audio is not None:
            result['TimelineConfigAudio'] = self.timeline_config_audio.to_map()
        if self.timeline_config_video is not None:
            result['TimelineConfigVideo'] = self.timeline_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfigAudio') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio()
            self.timeline_config_audio = temp_model.from_map(m['TimelineConfigAudio'])
        if m.get('TimelineConfigVideo') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo()
            self.timeline_config_video = temp_model.from_map(m['TimelineConfigVideo'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo(TeaModel):
    def __init__(
        self,
        l: str = None,
        t: str = None,
    ):
        self.l = l
        self.t = t

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.l is not None:
            result['L'] = self.l
        if self.t is not None:
            result['T'] = self.t
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('L') is not None:
            self.l = m.get('L')
        if m.get('T') is not None:
            self.t = m.get('T')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig(TeaModel):
    def __init__(
        self,
        clips_config_video: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo = None,
    ):
        self.clips_config_video = clips_config_video

    def validate(self):
        if self.clips_config_video:
            self.clips_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config_video is not None:
            result['ClipsConfigVideo'] = self.clips_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfigVideo') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo()
            self.clips_config_video = temp_model.from_map(m['ClipsConfigVideo'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip(TeaModel):
    def __init__(
        self,
        clips_config: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig = None,
        in_: str = None,
        out: str = None,
        clip_id: str = None,
    ):
        self.clips_config = clips_config
        self.in_ = in_
        self.out = out
        self.clip_id = clip_id

    def validate(self):
        if self.clips_config:
            self.clips_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config is not None:
            result['ClipsConfig'] = self.clips_config.to_map()
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.clip_id is not None:
            result['clipID'] = self.clip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig()
            self.clips_config = temp_model.from_map(m['ClipsConfig'])
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('clipID') is not None:
            self.clip_id = m.get('clipID')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips(TeaModel):
    def __init__(
        self,
        clip: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack(TeaModel):
    def __init__(
        self,
        clips: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips = None,
        id: str = None,
        order: str = None,
        type: str = None,
    ):
        self.clips = clips
        self.id = id
        self.order = order
        self.type = type

    def validate(self):
        if self.clips:
            self.clips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips is not None:
            result['Clips'] = self.clips.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.order is not None:
            result['Order'] = self.order
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clips') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips()
            self.clips = temp_model.from_map(m['Clips'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList(TeaModel):
    def __init__(
        self,
        track: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack] = None,
    ):
        self.track = track

    def validate(self):
        if self.track:
            for k in self.track:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Track'] = []
        if self.track is not None:
            for k in self.track:
                result['Track'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track = []
        if m.get('Track') is not None:
            for k in m.get('Track'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack()
                self.track.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline(TeaModel):
    def __init__(
        self,
        timeline_config: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig = None,
        track_list: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList = None,
    ):
        self.timeline_config = timeline_config
        self.track_list = track_list

    def validate(self):
        if self.timeline_config:
            self.timeline_config.validate()
        if self.track_list:
            self.track_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config is not None:
            result['TimelineConfig'] = self.timeline_config.to_map()
        if self.track_list is not None:
            result['TrackList'] = self.track_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig()
            self.timeline_config = temp_model.from_map(m['TimelineConfig'])
        if m.get('TrackList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList()
            self.track_list = temp_model.from_map(m['TrackList'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing(TeaModel):
    def __init__(
        self,
        clip_list: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList = None,
        timeline: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline = None,
    ):
        self.clip_list = clip_list
        self.timeline = timeline

    def validate(self):
        if self.clip_list:
            self.clip_list.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clip_list is not None:
            result['ClipList'] = self.clip_list.to_map()
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList()
            self.clip_list = temp_model.from_map(m['ClipList'])
        if m.get('Timeline') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs(TeaModel):
    def __init__(
        self,
        editing: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing = None,
    ):
        self.editing = editing

    def validate(self):
        if self.editing:
            self.editing.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing is not None:
            result['Editing'] = self.editing.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Editing') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing()
            self.editing = temp_model.from_map(m['Editing'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs(TeaModel):
    def __init__(
        self,
        complex_editing_configs: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs] = None,
    ):
        self.complex_editing_configs = complex_editing_configs

    def validate(self):
        if self.complex_editing_configs:
            for k in self.complex_editing_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplexEditingConfigs'] = []
        if self.complex_editing_configs is not None:
            for k in self.complex_editing_configs:
                result['ComplexEditingConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.complex_editing_configs = []
        if m.get('ComplexEditingConfigs') is not None:
            for k in m.get('ComplexEditingConfigs'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs()
                self.complex_editing_configs.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig(TeaModel):
    def __init__(
        self,
        deinterlace_method: str = None,
        is_normal_sar: str = None,
    ):
        self.deinterlace_method = deinterlace_method
        self.is_normal_sar = is_normal_sar

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deinterlace_method is not None:
            result['DeinterlaceMethod'] = self.deinterlace_method
        if self.is_normal_sar is not None:
            result['IsNormalSar'] = self.is_normal_sar
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeinterlaceMethod') is not None:
            self.deinterlace_method = m.get('DeinterlaceMethod')
        if m.get('IsNormalSar') is not None:
            self.is_normal_sar = m.get('IsNormalSar')
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput(TeaModel):
    def __init__(
        self,
        id: str = None,
        input_config: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig = None,
        input_file: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile = None,
    ):
        self.id = id
        self.input_config = input_config
        self.input_file = input_file

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InputConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs(TeaModel):
    def __init__(
        self,
        editing_input: List[QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput] = None,
    ):
        self.editing_input = editing_input

    def validate(self):
        if self.editing_input:
            for k in self.editing_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EditingInput'] = []
        if self.editing_input is not None:
            for k in self.editing_input:
                result['EditingInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.editing_input = []
        if m.get('EditingInput') is not None:
            for k in m.get('EditingInput'):
                temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput()
                self.editing_input.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputs(TeaModel):
    def __init__(
        self,
        editing_inputs: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs = None,
    ):
        self.editing_inputs = editing_inputs

    def validate(self):
        if self.editing_inputs:
            self.editing_inputs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditingInputs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs()
            self.editing_inputs = temp_model.from_map(m['EditingInputs'])
        return self


class QueryComplexJobListResponseBodyJobListJobInputs(TeaModel):
    def __init__(
        self,
        inputs: List[QueryComplexJobListResponseBodyJobListJobInputsInputs] = None,
    ):
        self.inputs = inputs

    def validate(self):
        if self.inputs:
            for k in self.inputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inputs'] = []
        if self.inputs is not None:
            for k in self.inputs:
                result['Inputs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inputs = []
        if m.get('Inputs') is not None:
            for k in m.get('Inputs'):
                temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputs()
                self.inputs.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume(TeaModel):
    def __init__(
        self,
        level: str = None,
        method: str = None,
    ):
        self.level = level
        self.method = method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        qscale: str = None,
        samplerate: str = None,
        volume: QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.qscale = qscale
        self.samplerate = samplerate
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan(TeaModel):
    def __init__(
        self,
        duration: str = None,
        seek: str = None,
    ):
        self.duration = duration
        self.seek = seek

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.seek is not None:
            result['Seek'] = self.seek
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip(TeaModel):
    def __init__(
        self,
        time_span: QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark(TeaModel):
    def __init__(
        self,
        alpha: str = None,
        input_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile = None,
        type: str = None,
    ):
        self.alpha = alpha
        self.input_file = input_file
        self.type = type

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alpha is not None:
            result['Alpha'] = self.alpha
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alpha') is not None:
            self.alpha = m.get('Alpha')
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption(TeaModel):
    def __init__(
        self,
        id: str = None,
        key: str = None,
        key_type: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
        type: str = None,
    ):
        self.id = id
        self.key = key
        self.key_type = key_type
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        md_5support: bool = None,
        size_support: bool = None,
    ):
        self.md_5support = md_5support
        self.size_support = size_support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge(TeaModel):
    def __init__(
        self,
        duration: str = None,
        merge_url: str = None,
        role_arn: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.merge_url = merge_url
        self.role_arn = role_arn
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList(TeaModel):
    def __init__(
        self,
        merge: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif(TeaModel):
    def __init__(
        self,
        dither_mode: str = None,
        final_delay: str = None,
        is_custom_palette: str = None,
        loop: str = None,
    ):
        self.dither_mode = dither_mode
        self.final_delay = final_delay
        self.is_custom_palette = is_custom_palette
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif = None,
        segment: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        format_long_name: str = None,
        format_name: str = None,
        num_programs: str = None,
        num_streams: str = None,
        size: str = None,
        start_time: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.format_long_name = format_long_name
        self.format_name = format_name
        self.num_programs = num_programs
        self.num_streams = num_streams
        self.size = size
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        num_frames: str = None,
        sample_fmt: str = None,
        samplerate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        self.bitrate = bitrate
        self.channel_layout = channel_layout
        self.channels = channels
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.duration = duration
        self.index = index
        self.lang = lang
        self.num_frames = num_frames
        self.sample_fmt = sample_fmt
        self.samplerate = samplerate
        self.start_time = start_time
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
        preload_time: str = None,
    ):
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth
        self.preload_time = preload_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bitrate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        network_cost: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        sar: str = None,
        start_time: str = None,
        timebase: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bitrate = bitrate
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.dar = dar
        self.duration = duration
        self.fps = fps
        self.has_bframes = has_bframes
        self.height = height
        self.index = index
        self.lang = lang
        self.level = level
        self.network_cost = network_cost
        self.num_frames = num_frames
        self.pix_fmt = pix_fmt
        self.profile = profile
        self.sar = sar
        self.start_time = start_time
        self.timebase = timebase
        self.width = width

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams(TeaModel):
    def __init__(
        self,
        audio_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList = None,
        video_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList = None,
    ):
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list
        self.video_stream_list = video_stream_list

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_format: str = None,
        file_size: str = None,
        format: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat = None,
        fps: str = None,
        height: str = None,
        streams: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.file_format = file_format
        self.file_size = file_size
        self.format = format
        self.fps = fps
        self.height = height
        self.streams = streams
        self.width = width

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Streams') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList = None,
        subtitle_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig(TeaModel):
    def __init__(
        self,
        adj_dar_method: str = None,
        duration: str = None,
        is_check_audio_bitrate: str = None,
        is_check_audio_bitrate_fail: str = None,
        is_check_reso: str = None,
        is_check_reso_fail: str = None,
        is_check_video_bitrate: str = None,
        is_check_video_bitrate_fail: str = None,
        trans_mode: str = None,
    ):
        self.adj_dar_method = adj_dar_method
        self.duration = duration
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail
        self.is_check_reso = is_check_reso
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        bitrate_bnd: QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        degrain: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        max_fps: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        qscale: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.bitrate_bnd = bitrate_bnd
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.crop = crop
        self.degrain = degrain
        self.fps = fps
        self.gop = gop
        self.height = height
        self.max_fps = max_fps
        self.maxrate = maxrate
        self.pad = pad
        self.pix_fmt = pix_fmt
        self.preset = preset
        self.profile = profile
        self.qscale = qscale
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        height: str = None,
        input_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile = None,
        refer_pos: str = None,
        type: str = None,
        water_mark_template_id: str = None,
        width: str = None,
    ):
        self.dx = dx
        self.dy = dy
        self.height = height
        self.input_file = input_file
        self.refer_pos = refer_pos
        self.type = type
        self.water_mark_template_id = water_mark_template_id
        self.width = width

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.type is not None:
            result['Type'] = self.type
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutput(TeaModel):
    def __init__(
        self,
        audio: QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio = None,
        audio_stream_map: str = None,
        clip: QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip = None,
        container: QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer = None,
        de_watermark: str = None,
        digi_water_mark: QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark = None,
        encryption: QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption = None,
        m_3u8non_standard_support: QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport = None,
        merge_config_url: str = None,
        merge_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList = None,
        mux_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig = None,
        output_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile = None,
        priority: str = None,
        properties: QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties = None,
        rotate: str = None,
        subtitle_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig = None,
        super_reso: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso = None,
        template_id: str = None,
        trans_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig = None,
        user_data: str = None,
        video: QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo = None,
        video_stream_map: str = None,
        water_mark_config_url: str = None,
        water_mark_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList = None,
    ):
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.clip = clip
        self.container = container
        self.de_watermark = de_watermark
        self.digi_water_mark = digi_water_mark
        self.encryption = encryption
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.merge_config_url = merge_config_url
        self.merge_list = merge_list
        self.mux_config = mux_config
        self.output_file = output_file
        self.priority = priority
        self.properties = properties
        self.rotate = rotate
        self.subtitle_config = subtitle_config
        self.super_reso = super_reso
        self.template_id = template_id
        self.trans_config = trans_config
        self.user_data = user_data
        self.video = video
        self.video_stream_map = video_stream_map
        self.water_mark_config_url = water_mark_config_url
        self.water_mark_list = water_mark_list

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.clip:
            self.clip.validate()
        if self.container:
            self.container.validate()
        if self.digi_water_mark:
            self.digi_water_mark.validate()
        if self.encryption:
            self.encryption.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.output_file:
            self.output_file.validate()
        if self.properties:
            self.properties.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.digi_water_mark is not None:
            result['DigiWaterMark'] = self.digi_water_mark.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('Clip') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('Container') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('DigiWaterMark') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark()
            self.digi_water_mark = temp_model.from_map(m['DigiWaterMark'])
        if m.get('Encryption') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MergeList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('MuxConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('OutputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Properties') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('SuperReso') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TransConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Video') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('WaterMarkList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        return self


class QueryComplexJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        complex_editing_configs: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs = None,
        creation_time: str = None,
        finish_time: str = None,
        inputs: QueryComplexJobListResponseBodyJobListJobInputs = None,
        job_id: str = None,
        mnsmessage_result: QueryComplexJobListResponseBodyJobListJobMNSMessageResult = None,
        message: str = None,
        percent: int = None,
        pipeline_id: str = None,
        state: str = None,
        transcode_output: QueryComplexJobListResponseBodyJobListJobTranscodeOutput = None,
    ):
        self.code = code
        self.complex_editing_configs = complex_editing_configs
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.inputs = inputs
        self.job_id = job_id
        self.mnsmessage_result = mnsmessage_result
        self.message = message
        self.percent = percent
        self.pipeline_id = pipeline_id
        self.state = state
        self.transcode_output = transcode_output

    def validate(self):
        if self.complex_editing_configs:
            self.complex_editing_configs.validate()
        if self.inputs:
            self.inputs.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.transcode_output:
            self.transcode_output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.complex_editing_configs is not None:
            result['ComplexEditingConfigs'] = self.complex_editing_configs.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.inputs is not None:
            result['Inputs'] = self.inputs.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.transcode_output is not None:
            result['transcodeOutput'] = self.transcode_output.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ComplexEditingConfigs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs()
            self.complex_editing_configs = temp_model.from_map(m['ComplexEditingConfigs'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Inputs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputs()
            self.inputs = temp_model.from_map(m['Inputs'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('transcodeOutput') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutput()
            self.transcode_output = temp_model.from_map(m['transcodeOutput'])
        return self


class QueryComplexJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryComplexJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryComplexJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryComplexJobListResponseBody(TeaModel):
    def __init__(
        self,
        job_list: QueryComplexJobListResponseBodyJobList = None,
        non_exist_job_ids: QueryComplexJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
    ):
        self.job_list = job_list
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id

    def validate(self):
        if self.job_list:
            self.job_list.validate()
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryComplexJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryComplexJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryComplexJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryComplexJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCoverJobListRequest(TeaModel):
    def __init__(
        self,
        cover_job_ids: str = None,
        end_of_job_created_time_range: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_of_job_created_time_range: str = None,
        state: str = None,
    ):
        self.cover_job_ids = cover_job_ids
        self.end_of_job_created_time_range = end_of_job_created_time_range
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_id = pipeline_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_of_job_created_time_range = start_of_job_created_time_range
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_job_ids is not None:
            result['CoverJobIds'] = self.cover_job_ids
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoverJobIds') is not None:
            self.cover_job_ids = m.get('CoverJobIds')
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfigOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfig(TeaModel):
    def __init__(
        self,
        output_file: QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfigOutputFile = None,
    ):
        self.output_file = output_file

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputFile') is not None:
            temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageListCoverImage(TeaModel):
    def __init__(
        self,
        score: str = None,
        time: str = None,
        url: str = None,
    ):
        self.score = score
        self.time = time
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.score is not None:
            result['Score'] = self.score
        if self.time is not None:
            result['Time'] = self.time
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageList(TeaModel):
    def __init__(
        self,
        cover_image: List[QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageListCoverImage] = None,
    ):
        self.cover_image = cover_image

    def validate(self):
        if self.cover_image:
            for k in self.cover_image:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImage'] = []
        if self.cover_image is not None:
            for k in self.cover_image:
                result['CoverImage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cover_image = []
        if m.get('CoverImage') is not None:
            for k in m.get('CoverImage'):
                temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageListCoverImage()
                self.cover_image.append(temp_model.from_map(k))
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCoverJobListResponseBodyCoverJobListCoverJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        cover_config: QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfig = None,
        cover_image_list: QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageList = None,
        creation_time: str = None,
        id: str = None,
        input: QueryCoverJobListResponseBodyCoverJobListCoverJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.cover_config = cover_config
        self.cover_image_list = cover_image_list
        self.creation_time = creation_time
        self.id = id
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.state = state
        self.user_data = user_data

    def validate(self):
        if self.cover_config:
            self.cover_config.validate()
        if self.cover_image_list:
            self.cover_image_list.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.cover_config is not None:
            result['CoverConfig'] = self.cover_config.to_map()
        if self.cover_image_list is not None:
            result['CoverImageList'] = self.cover_image_list.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CoverConfig') is not None:
            temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJobCoverConfig()
            self.cover_config = temp_model.from_map(m['CoverConfig'])
        if m.get('CoverImageList') is not None:
            temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJobCoverImageList()
            self.cover_image_list = temp_model.from_map(m['CoverImageList'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryCoverJobListResponseBodyCoverJobList(TeaModel):
    def __init__(
        self,
        cover_job: List[QueryCoverJobListResponseBodyCoverJobListCoverJob] = None,
    ):
        self.cover_job = cover_job

    def validate(self):
        if self.cover_job:
            for k in self.cover_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverJob'] = []
        if self.cover_job is not None:
            for k in self.cover_job:
                result['CoverJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cover_job = []
        if m.get('CoverJob') is not None:
            for k in m.get('CoverJob'):
                temp_model = QueryCoverJobListResponseBodyCoverJobListCoverJob()
                self.cover_job.append(temp_model.from_map(k))
        return self


class QueryCoverJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCoverJobListResponseBody(TeaModel):
    def __init__(
        self,
        cover_job_list: QueryCoverJobListResponseBodyCoverJobList = None,
        next_page_token: str = None,
        non_exist_ids: QueryCoverJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.cover_job_list = cover_job_list
        self.next_page_token = next_page_token
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.cover_job_list:
            self.cover_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_job_list is not None:
            result['CoverJobList'] = self.cover_job_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoverJobList') is not None:
            temp_model = QueryCoverJobListResponseBodyCoverJobList()
            self.cover_job_list = temp_model.from_map(m['CoverJobList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NonExistIds') is not None:
            temp_model = QueryCoverJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCoverJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCoverJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCoverJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCoverPipelineListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_ids: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_ids = pipeline_ids
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryCoverPipelineListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue: str = None,
        topic: str = None,
    ):
        self.queue = queue
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class QueryCoverPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        notify_config: QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        role: str = None,
        state: str = None,
    ):
        self.id = id
        self.name = name
        self.notify_config = notify_config
        self.priority = priority
        self.role = role
        self.state = state

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.role is not None:
            result['Role'] = self.role
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryCoverPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[QueryCoverPipelineListResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = QueryCoverPipelineListResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class QueryCoverPipelineListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_ids: QueryCoverPipelineListResponseBodyNonExistIds = None,
        pipeline_list: QueryCoverPipelineListResponseBodyPipelineList = None,
        request_id: str = None,
    ):
        self.non_exist_ids = non_exist_ids
        self.pipeline_list = pipeline_list
        self.request_id = request_id

    def validate(self):
        if self.non_exist_ids:
            self.non_exist_ids.validate()
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistIds') is not None:
            temp_model = QueryCoverPipelineListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('PipelineList') is not None:
            temp_model = QueryCoverPipelineListResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCoverPipelineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCoverPipelineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCoverPipelineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryEditingJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume(TeaModel):
    def __init__(
        self,
        level: str = None,
        method: str = None,
    ):
        self.level = level
        self.method = method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        qscale: str = None,
        samplerate: str = None,
        volume: QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.qscale = qscale
        self.samplerate = samplerate
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan(TeaModel):
    def __init__(
        self,
        duration: str = None,
        seek: str = None,
    ):
        self.duration = duration
        self.seek = seek

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.seek is not None:
            result['Seek'] = self.seek
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigClip(TeaModel):
    def __init__(
        self,
        time_span: QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark(TeaModel):
    def __init__(
        self,
        alpha: str = None,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile = None,
        type: str = None,
    ):
        self.alpha = alpha
        self.input_file = input_file
        self.type = type

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alpha is not None:
            result['Alpha'] = self.alpha
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alpha') is not None:
            self.alpha = m.get('Alpha')
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect(TeaModel):
    def __init__(
        self,
        effect: str = None,
        effect_config: str = None,
    ):
        self.effect = effect
        self.effect_config = effect_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('EffectConfig') is not None:
            self.effect_config = m.get('EffectConfig')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects(TeaModel):
    def __init__(
        self,
        effect: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect] = None,
    ):
        self.effect = effect

    def validate(self):
        if self.effect:
            for k in self.effect:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Effect'] = []
        if self.effect is not None:
            for k in self.effect:
                result['Effect'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effect = []
        if m.get('Effect') is not None:
            for k in m.get('Effect'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect()
                self.effect.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip(TeaModel):
    def __init__(
        self,
        effects: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects = None,
        id: str = None,
        in_: str = None,
        out: str = None,
        source_id: str = None,
        source_strm_map: str = None,
        source_type: str = None,
        type: str = None,
    ):
        self.effects = effects
        self.id = id
        self.in_ = in_
        self.out = out
        self.source_id = source_id
        self.source_strm_map = source_strm_map
        self.source_type = source_type
        self.type = type

    def validate(self):
        if self.effects:
            self.effects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effects is not None:
            result['Effects'] = self.effects.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.source_id is not None:
            result['SourceID'] = self.source_id
        if self.source_strm_map is not None:
            result['SourceStrmMap'] = self.source_strm_map
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effects') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects()
            self.effects = temp_model.from_map(m['Effects'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('SourceID') is not None:
            self.source_id = m.get('SourceID')
        if m.get('SourceStrmMap') is not None:
            self.source_strm_map = m.get('SourceStrmMap')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList(TeaModel):
    def __init__(
        self,
        clip: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio(TeaModel):
    def __init__(
        self,
        channel_layout: str = None,
        channels: str = None,
        samplerate: str = None,
    ):
        self.channel_layout = channel_layout
        self.channels = channels
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        fps: str = None,
        height: str = None,
        is_gpu_data: str = None,
        is_one_track_data: str = None,
        reclose_prec: str = None,
        render_ratio: str = None,
        width: str = None,
    ):
        self.bg_color = bg_color
        self.fps = fps
        self.height = height
        self.is_gpu_data = is_gpu_data
        self.is_one_track_data = is_one_track_data
        self.reclose_prec = reclose_prec
        self.render_ratio = render_ratio
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.is_gpu_data is not None:
            result['IsGpuData'] = self.is_gpu_data
        if self.is_one_track_data is not None:
            result['IsOneTrackData'] = self.is_one_track_data
        if self.reclose_prec is not None:
            result['ReclosePrec'] = self.reclose_prec
        if self.render_ratio is not None:
            result['RenderRatio'] = self.render_ratio
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsGpuData') is not None:
            self.is_gpu_data = m.get('IsGpuData')
        if m.get('IsOneTrackData') is not None:
            self.is_one_track_data = m.get('IsOneTrackData')
        if m.get('ReclosePrec') is not None:
            self.reclose_prec = m.get('ReclosePrec')
        if m.get('RenderRatio') is not None:
            self.render_ratio = m.get('RenderRatio')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig(TeaModel):
    def __init__(
        self,
        timeline_config_audio: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio = None,
        timeline_config_video: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo = None,
    ):
        self.timeline_config_audio = timeline_config_audio
        self.timeline_config_video = timeline_config_video

    def validate(self):
        if self.timeline_config_audio:
            self.timeline_config_audio.validate()
        if self.timeline_config_video:
            self.timeline_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config_audio is not None:
            result['TimelineConfigAudio'] = self.timeline_config_audio.to_map()
        if self.timeline_config_video is not None:
            result['TimelineConfigVideo'] = self.timeline_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfigAudio') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio()
            self.timeline_config_audio = temp_model.from_map(m['TimelineConfigAudio'])
        if m.get('TimelineConfigVideo') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo()
            self.timeline_config_video = temp_model.from_map(m['TimelineConfigVideo'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo(TeaModel):
    def __init__(
        self,
        l: str = None,
        t: str = None,
    ):
        self.l = l
        self.t = t

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.l is not None:
            result['L'] = self.l
        if self.t is not None:
            result['T'] = self.t
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('L') is not None:
            self.l = m.get('L')
        if m.get('T') is not None:
            self.t = m.get('T')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig(TeaModel):
    def __init__(
        self,
        clips_config_video: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo = None,
    ):
        self.clips_config_video = clips_config_video

    def validate(self):
        if self.clips_config_video:
            self.clips_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config_video is not None:
            result['ClipsConfigVideo'] = self.clips_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfigVideo') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo()
            self.clips_config_video = temp_model.from_map(m['ClipsConfigVideo'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip(TeaModel):
    def __init__(
        self,
        clips_config: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig = None,
        in_: str = None,
        out: str = None,
        clip_id: str = None,
    ):
        self.clips_config = clips_config
        self.in_ = in_
        self.out = out
        self.clip_id = clip_id

    def validate(self):
        if self.clips_config:
            self.clips_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config is not None:
            result['ClipsConfig'] = self.clips_config.to_map()
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.clip_id is not None:
            result['clipID'] = self.clip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig()
            self.clips_config = temp_model.from_map(m['ClipsConfig'])
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('clipID') is not None:
            self.clip_id = m.get('clipID')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips(TeaModel):
    def __init__(
        self,
        clip: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack(TeaModel):
    def __init__(
        self,
        clips: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips = None,
        id: str = None,
        order: str = None,
        type: str = None,
    ):
        self.clips = clips
        self.id = id
        self.order = order
        self.type = type

    def validate(self):
        if self.clips:
            self.clips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips is not None:
            result['Clips'] = self.clips.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.order is not None:
            result['Order'] = self.order
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clips') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips()
            self.clips = temp_model.from_map(m['Clips'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList(TeaModel):
    def __init__(
        self,
        track: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack] = None,
    ):
        self.track = track

    def validate(self):
        if self.track:
            for k in self.track:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Track'] = []
        if self.track is not None:
            for k in self.track:
                result['Track'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track = []
        if m.get('Track') is not None:
            for k in m.get('Track'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack()
                self.track.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline(TeaModel):
    def __init__(
        self,
        timeline_config: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig = None,
        track_list: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList = None,
    ):
        self.timeline_config = timeline_config
        self.track_list = track_list

    def validate(self):
        if self.timeline_config:
            self.timeline_config.validate()
        if self.track_list:
            self.track_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config is not None:
            result['TimelineConfig'] = self.timeline_config.to_map()
        if self.track_list is not None:
            result['TrackList'] = self.track_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig()
            self.timeline_config = temp_model.from_map(m['TimelineConfig'])
        if m.get('TrackList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList()
            self.track_list = temp_model.from_map(m['TrackList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditing(TeaModel):
    def __init__(
        self,
        clip_list: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList = None,
        timeline: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline = None,
    ):
        self.clip_list = clip_list
        self.timeline = timeline

    def validate(self):
        if self.clip_list:
            self.clip_list.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clip_list is not None:
            result['ClipList'] = self.clip_list.to_map()
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList()
            self.clip_list = temp_model.from_map(m['ClipList'])
        if m.get('Timeline') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption(TeaModel):
    def __init__(
        self,
        id: str = None,
        key: str = None,
        key_type: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
        type: str = None,
    ):
        self.id = id
        self.key = key
        self.key_type = key_type
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        md_5support: bool = None,
        size_support: bool = None,
    ):
        self.md_5support = md_5support
        self.size_support = size_support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge(TeaModel):
    def __init__(
        self,
        duration: str = None,
        merge_url: str = None,
        role_arn: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.merge_url = merge_url
        self.role_arn = role_arn
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList(TeaModel):
    def __init__(
        self,
        merge: List[QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif(TeaModel):
    def __init__(
        self,
        dither_mode: str = None,
        final_delay: str = None,
        is_custom_palette: str = None,
        loop: str = None,
    ):
        self.dither_mode = dither_mode
        self.final_delay = final_delay
        self.is_custom_palette = is_custom_palette
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif = None,
        segment: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
        role_arn: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object
        self.role_arn = role_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        format_long_name: str = None,
        format_name: str = None,
        num_programs: str = None,
        num_streams: str = None,
        size: str = None,
        start_time: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.format_long_name = format_long_name
        self.format_name = format_name
        self.num_programs = num_programs
        self.num_streams = num_streams
        self.size = size
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        num_frames: str = None,
        sample_fmt: str = None,
        samplerate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        self.bitrate = bitrate
        self.channel_layout = channel_layout
        self.channels = channels
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.duration = duration
        self.index = index
        self.lang = lang
        self.num_frames = num_frames
        self.sample_fmt = sample_fmt
        self.samplerate = samplerate
        self.start_time = start_time
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
        preload_time: str = None,
    ):
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth
        self.preload_time = preload_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bitrate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        network_cost: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        sar: str = None,
        start_time: str = None,
        timebase: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bitrate = bitrate
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.dar = dar
        self.duration = duration
        self.fps = fps
        self.has_bframes = has_bframes
        self.height = height
        self.index = index
        self.lang = lang
        self.level = level
        self.network_cost = network_cost
        self.num_frames = num_frames
        self.pix_fmt = pix_fmt
        self.profile = profile
        self.sar = sar
        self.start_time = start_time
        self.timebase = timebase
        self.width = width

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams(TeaModel):
    def __init__(
        self,
        audio_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList = None,
        video_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList = None,
    ):
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list
        self.video_stream_list = video_stream_list

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigProperties(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_format: str = None,
        file_size: str = None,
        format: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat = None,
        fps: str = None,
        height: str = None,
        streams: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.file_format = file_format
        self.file_size = file_size
        self.format = format
        self.fps = fps
        self.height = height
        self.streams = streams
        self.width = width

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Streams') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList = None,
        subtitle_list: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig(TeaModel):
    def __init__(
        self,
        adj_dar_method: str = None,
        duration: str = None,
        is_check_audio_bitrate: str = None,
        is_check_audio_bitrate_fail: str = None,
        is_check_reso: str = None,
        is_check_reso_fail: str = None,
        is_check_video_bitrate: str = None,
        is_check_video_bitrate_fail: str = None,
        trans_mode: str = None,
    ):
        self.adj_dar_method = adj_dar_method
        self.duration = duration
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail
        self.is_check_reso = is_check_reso
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigVideo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        bitrate_bnd: QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        degrain: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        max_fps: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        qscale: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.bitrate_bnd = bitrate_bnd
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.crop = crop
        self.degrain = degrain
        self.fps = fps
        self.gop = gop
        self.height = height
        self.max_fps = max_fps
        self.maxrate = maxrate
        self.pad = pad
        self.pix_fmt = pix_fmt
        self.preset = preset
        self.profile = profile
        self.qscale = qscale
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        height: str = None,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile = None,
        refer_pos: str = None,
        type: str = None,
        water_mark_template_id: str = None,
        width: str = None,
    ):
        self.dx = dx
        self.dy = dy
        self.height = height
        self.input_file = input_file
        self.refer_pos = refer_pos
        self.type = type
        self.water_mark_template_id = water_mark_template_id
        self.width = width

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.type is not None:
            result['Type'] = self.type
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfig(TeaModel):
    def __init__(
        self,
        audio: QueryEditingJobListResponseBodyJobListJobEditingConfigAudio = None,
        audio_stream_map: str = None,
        clip: QueryEditingJobListResponseBodyJobListJobEditingConfigClip = None,
        container: QueryEditingJobListResponseBodyJobListJobEditingConfigContainer = None,
        de_watermark: str = None,
        digi_water_mark: QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark = None,
        editing: QueryEditingJobListResponseBodyJobListJobEditingConfigEditing = None,
        encryption: QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption = None,
        m_3u8non_standard_support: QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport = None,
        merge_config_url: str = None,
        merge_list: QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList = None,
        mux_config: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig = None,
        output_file: QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile = None,
        priority: str = None,
        properties: QueryEditingJobListResponseBodyJobListJobEditingConfigProperties = None,
        rotate: str = None,
        subtitle_config: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig = None,
        super_reso: QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso = None,
        template_id: str = None,
        trans_config: QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig = None,
        user_data: str = None,
        video: QueryEditingJobListResponseBodyJobListJobEditingConfigVideo = None,
        video_stream_map: str = None,
        water_mark_config_url: str = None,
        water_mark_list: QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList = None,
    ):
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.clip = clip
        self.container = container
        self.de_watermark = de_watermark
        self.digi_water_mark = digi_water_mark
        self.editing = editing
        self.encryption = encryption
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.merge_config_url = merge_config_url
        self.merge_list = merge_list
        self.mux_config = mux_config
        self.output_file = output_file
        self.priority = priority
        self.properties = properties
        self.rotate = rotate
        self.subtitle_config = subtitle_config
        self.super_reso = super_reso
        self.template_id = template_id
        self.trans_config = trans_config
        self.user_data = user_data
        self.video = video
        self.video_stream_map = video_stream_map
        self.water_mark_config_url = water_mark_config_url
        self.water_mark_list = water_mark_list

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.clip:
            self.clip.validate()
        if self.container:
            self.container.validate()
        if self.digi_water_mark:
            self.digi_water_mark.validate()
        if self.editing:
            self.editing.validate()
        if self.encryption:
            self.encryption.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.output_file:
            self.output_file.validate()
        if self.properties:
            self.properties.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.digi_water_mark is not None:
            result['DigiWaterMark'] = self.digi_water_mark.to_map()
        if self.editing is not None:
            result['Editing'] = self.editing.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('Clip') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('Container') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('DigiWaterMark') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark()
            self.digi_water_mark = temp_model.from_map(m['DigiWaterMark'])
        if m.get('Editing') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditing()
            self.editing = temp_model.from_map(m['Editing'])
        if m.get('Encryption') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MergeList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('MuxConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('OutputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Properties') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('SuperReso') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TransConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Video') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('WaterMarkList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig(TeaModel):
    def __init__(
        self,
        deinterlace_method: str = None,
        is_normal_sar: str = None,
    ):
        self.deinterlace_method = deinterlace_method
        self.is_normal_sar = is_normal_sar

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deinterlace_method is not None:
            result['DeinterlaceMethod'] = self.deinterlace_method
        if self.is_normal_sar is not None:
            result['IsNormalSar'] = self.is_normal_sar
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeinterlaceMethod') is not None:
            self.deinterlace_method = m.get('DeinterlaceMethod')
        if m.get('IsNormalSar') is not None:
            self.is_normal_sar = m.get('IsNormalSar')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput(TeaModel):
    def __init__(
        self,
        id: str = None,
        input_config: QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig = None,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile = None,
    ):
        self.id = id
        self.input_config = input_config
        self.input_file = input_file

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InputConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputs(TeaModel):
    def __init__(
        self,
        editing_input: List[QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput] = None,
    ):
        self.editing_input = editing_input

    def validate(self):
        if self.editing_input:
            for k in self.editing_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EditingInput'] = []
        if self.editing_input is not None:
            for k in self.editing_input:
                result['EditingInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.editing_input = []
        if m.get('EditingInput') is not None:
            for k in m.get('EditingInput'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput()
                self.editing_input.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryEditingJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        editing_config: QueryEditingJobListResponseBodyJobListJobEditingConfig = None,
        editing_inputs: QueryEditingJobListResponseBodyJobListJobEditingInputs = None,
        finish_time: str = None,
        job_id: str = None,
        mnsmessage_result: QueryEditingJobListResponseBodyJobListJobMNSMessageResult = None,
        message: str = None,
        percent: int = None,
        pipeline_id: str = None,
        state: str = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.editing_config = editing_config
        self.editing_inputs = editing_inputs
        self.finish_time = finish_time
        self.job_id = job_id
        self.mnsmessage_result = mnsmessage_result
        self.message = message
        self.percent = percent
        self.pipeline_id = pipeline_id
        self.state = state

    def validate(self):
        if self.editing_config:
            self.editing_config.validate()
        if self.editing_inputs:
            self.editing_inputs.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config.to_map()
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs.to_map()
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('EditingConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfig()
            self.editing_config = temp_model.from_map(m['EditingConfig'])
        if m.get('EditingInputs') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputs()
            self.editing_inputs = temp_model.from_map(m['EditingInputs'])
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryEditingJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryEditingJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryEditingJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryEditingJobListResponseBody(TeaModel):
    def __init__(
        self,
        job_list: QueryEditingJobListResponseBodyJobList = None,
        non_exist_job_ids: QueryEditingJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
    ):
        self.job_list = job_list
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id

    def validate(self):
        if self.job_list:
            self.job_list.validate()
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryEditingJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryEditingJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryEditingJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryEditingJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFacerecogJobListRequest(TeaModel):
    def __init__(
        self,
        facerecog_job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.facerecog_job_ids = facerecog_job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.facerecog_job_ids is not None:
            result['FacerecogJobIds'] = self.facerecog_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FacerecogJobIds') is not None:
            self.facerecog_job_ids = m.get('FacerecogJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFacesFace(TeaModel):
    def __init__(
        self,
        name: str = None,
        score: str = None,
        target: str = None,
    ):
        self.name = name
        self.score = score
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.score is not None:
            result['Score'] = self.score
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFaces(TeaModel):
    def __init__(
        self,
        face: List[QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFacesFace] = None,
    ):
        self.face = face

    def validate(self):
        if self.face:
            for k in self.face:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Face'] = []
        if self.face is not None:
            for k in self.face:
                result['Face'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.face = []
        if m.get('Face') is not None:
            for k in m.get('Face'):
                temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFacesFace()
                self.face.append(temp_model.from_map(k))
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecog(TeaModel):
    def __init__(
        self,
        faces: QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFaces = None,
        time: str = None,
    ):
        self.faces = faces
        self.time = time

    def validate(self):
        if self.faces:
            self.faces.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.faces is not None:
            result['Faces'] = self.faces.to_map()
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Faces') is not None:
            temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecogFaces()
            self.faces = temp_model.from_map(m['Faces'])
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogs(TeaModel):
    def __init__(
        self,
        facerecog: List[QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecog] = None,
    ):
        self.facerecog = facerecog

    def validate(self):
        if self.facerecog:
            for k in self.facerecog:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Facerecog'] = []
        if self.facerecog is not None:
            for k in self.facerecog:
                result['Facerecog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.facerecog = []
        if m.get('Facerecog') is not None:
            for k in m.get('Facerecog'):
                temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogsFacerecog()
                self.facerecog.append(temp_model.from_map(k))
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResult(TeaModel):
    def __init__(
        self,
        facerecogs: QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogs = None,
    ):
        self.facerecogs = facerecogs

    def validate(self):
        if self.facerecogs:
            self.facerecogs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.facerecogs is not None:
            result['Facerecogs'] = self.facerecogs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Facerecogs') is not None:
            temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResultFacerecogs()
            self.facerecogs = temp_model.from_map(m['Facerecogs'])
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        id: str = None,
        input: QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        state: str = None,
        user_data: str = None,
        video_facerecog_result: QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResult = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.id = id
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.state = state
        self.user_data = user_data
        self.video_facerecog_result = video_facerecog_result

    def validate(self):
        if self.input:
            self.input.validate()
        if self.video_facerecog_result:
            self.video_facerecog_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video_facerecog_result is not None:
            result['VideoFacerecogResult'] = self.video_facerecog_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VideoFacerecogResult') is not None:
            temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJobVideoFacerecogResult()
            self.video_facerecog_result = temp_model.from_map(m['VideoFacerecogResult'])
        return self


class QueryFacerecogJobListResponseBodyFacerecogJobList(TeaModel):
    def __init__(
        self,
        facerecog_job: List[QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJob] = None,
    ):
        self.facerecog_job = facerecog_job

    def validate(self):
        if self.facerecog_job:
            for k in self.facerecog_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FacerecogJob'] = []
        if self.facerecog_job is not None:
            for k in self.facerecog_job:
                result['FacerecogJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.facerecog_job = []
        if m.get('FacerecogJob') is not None:
            for k in m.get('FacerecogJob'):
                temp_model = QueryFacerecogJobListResponseBodyFacerecogJobListFacerecogJob()
                self.facerecog_job.append(temp_model.from_map(k))
        return self


class QueryFacerecogJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFacerecogJobListResponseBody(TeaModel):
    def __init__(
        self,
        facerecog_job_list: QueryFacerecogJobListResponseBodyFacerecogJobList = None,
        non_exist_ids: QueryFacerecogJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.facerecog_job_list = facerecog_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.facerecog_job_list:
            self.facerecog_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.facerecog_job_list is not None:
            result['FacerecogJobList'] = self.facerecog_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FacerecogJobList') is not None:
            temp_model = QueryFacerecogJobListResponseBodyFacerecogJobList()
            self.facerecog_job_list = temp_model.from_map(m['FacerecogJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFacerecogJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFacerecogJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFacerecogJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFacerecogJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpCompareJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMasterMediaInfo(TeaModel):
    def __init__(
        self,
        audio_bit_rate: str = None,
        audio_channels: str = None,
        audio_sample_rate: str = None,
        duration: str = None,
        fp_num: str = None,
        fps: str = None,
        height: str = None,
        total_video_frame: str = None,
        width: str = None,
    ):
        self.audio_bit_rate = audio_bit_rate
        self.audio_channels = audio_channels
        self.audio_sample_rate = audio_sample_rate
        self.duration = duration
        self.fp_num = fp_num
        self.fps = fps
        self.height = height
        self.total_video_frame = total_video_frame
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_bit_rate is not None:
            result['AudioBitRate'] = self.audio_bit_rate
        if self.audio_channels is not None:
            result['AudioChannels'] = self.audio_channels
        if self.audio_sample_rate is not None:
            result['AudioSampleRate'] = self.audio_sample_rate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fp_num is not None:
            result['FpNum'] = self.fp_num
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.total_video_frame is not None:
            result['TotalVideoFrame'] = self.total_video_frame
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioBitRate') is not None:
            self.audio_bit_rate = m.get('AudioBitRate')
        if m.get('AudioChannels') is not None:
            self.audio_channels = m.get('AudioChannels')
        if m.get('AudioSampleRate') is not None:
            self.audio_sample_rate = m.get('AudioSampleRate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FpNum') is not None:
            self.fp_num = m.get('FpNum')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('TotalVideoFrame') is not None:
            self.total_video_frame = m.get('TotalVideoFrame')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegmentsMediaMatchSegment(TeaModel):
    def __init__(
        self,
        master_end_frame: str = None,
        master_end_time: str = None,
        master_start_frame: str = None,
        master_start_time: str = None,
        query_end_frame: str = None,
        query_end_time: str = None,
        query_start_frame: str = None,
        query_start_time: str = None,
        score: str = None,
        total_match_frame_num: str = None,
    ):
        self.master_end_frame = master_end_frame
        self.master_end_time = master_end_time
        self.master_start_frame = master_start_frame
        self.master_start_time = master_start_time
        self.query_end_frame = query_end_frame
        self.query_end_time = query_end_time
        self.query_start_frame = query_start_frame
        self.query_start_time = query_start_time
        self.score = score
        self.total_match_frame_num = total_match_frame_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_end_frame is not None:
            result['MasterEndFrame'] = self.master_end_frame
        if self.master_end_time is not None:
            result['MasterEndTime'] = self.master_end_time
        if self.master_start_frame is not None:
            result['MasterStartFrame'] = self.master_start_frame
        if self.master_start_time is not None:
            result['MasterStartTime'] = self.master_start_time
        if self.query_end_frame is not None:
            result['QueryEndFrame'] = self.query_end_frame
        if self.query_end_time is not None:
            result['QueryEndTime'] = self.query_end_time
        if self.query_start_frame is not None:
            result['QueryStartFrame'] = self.query_start_frame
        if self.query_start_time is not None:
            result['QueryStartTime'] = self.query_start_time
        if self.score is not None:
            result['Score'] = self.score
        if self.total_match_frame_num is not None:
            result['TotalMatchFrameNum'] = self.total_match_frame_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterEndFrame') is not None:
            self.master_end_frame = m.get('MasterEndFrame')
        if m.get('MasterEndTime') is not None:
            self.master_end_time = m.get('MasterEndTime')
        if m.get('MasterStartFrame') is not None:
            self.master_start_frame = m.get('MasterStartFrame')
        if m.get('MasterStartTime') is not None:
            self.master_start_time = m.get('MasterStartTime')
        if m.get('QueryEndFrame') is not None:
            self.query_end_frame = m.get('QueryEndFrame')
        if m.get('QueryEndTime') is not None:
            self.query_end_time = m.get('QueryEndTime')
        if m.get('QueryStartFrame') is not None:
            self.query_start_frame = m.get('QueryStartFrame')
        if m.get('QueryStartTime') is not None:
            self.query_start_time = m.get('QueryStartTime')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('TotalMatchFrameNum') is not None:
            self.total_match_frame_num = m.get('TotalMatchFrameNum')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegments(TeaModel):
    def __init__(
        self,
        media_match_segment: List[QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegmentsMediaMatchSegment] = None,
    ):
        self.media_match_segment = media_match_segment

    def validate(self):
        if self.media_match_segment:
            for k in self.media_match_segment:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaMatchSegment'] = []
        if self.media_match_segment is not None:
            for k in self.media_match_segment:
                result['MediaMatchSegment'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_match_segment = []
        if m.get('MediaMatchSegment') is not None:
            for k in m.get('MediaMatchSegment'):
                temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegmentsMediaMatchSegment()
                self.media_match_segment.append(temp_model.from_map(k))
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultQueryMediaInfo(TeaModel):
    def __init__(
        self,
        audio_bit_rate: str = None,
        audio_channels: str = None,
        audio_sample_rate: str = None,
        duration: str = None,
        fp_num: str = None,
        fps: str = None,
        height: str = None,
        total_video_frame: str = None,
        width: str = None,
    ):
        self.audio_bit_rate = audio_bit_rate
        self.audio_channels = audio_channels
        self.audio_sample_rate = audio_sample_rate
        self.duration = duration
        self.fp_num = fp_num
        self.fps = fps
        self.height = height
        self.total_video_frame = total_video_frame
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_bit_rate is not None:
            result['AudioBitRate'] = self.audio_bit_rate
        if self.audio_channels is not None:
            result['AudioChannels'] = self.audio_channels
        if self.audio_sample_rate is not None:
            result['AudioSampleRate'] = self.audio_sample_rate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fp_num is not None:
            result['FpNum'] = self.fp_num
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.total_video_frame is not None:
            result['TotalVideoFrame'] = self.total_video_frame
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioBitRate') is not None:
            self.audio_bit_rate = m.get('AudioBitRate')
        if m.get('AudioChannels') is not None:
            self.audio_channels = m.get('AudioChannels')
        if m.get('AudioSampleRate') is not None:
            self.audio_sample_rate = m.get('AudioSampleRate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FpNum') is not None:
            self.fp_num = m.get('FpNum')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('TotalVideoFrame') is not None:
            self.total_video_frame = m.get('TotalVideoFrame')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResult(TeaModel):
    def __init__(
        self,
        master_media_info: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMasterMediaInfo = None,
        media_match_segments: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegments = None,
        query_media_info: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultQueryMediaInfo = None,
    ):
        self.master_media_info = master_media_info
        self.media_match_segments = media_match_segments
        self.query_media_info = query_media_info

    def validate(self):
        if self.master_media_info:
            self.master_media_info.validate()
        if self.media_match_segments:
            self.media_match_segments.validate()
        if self.query_media_info:
            self.query_media_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_media_info is not None:
            result['MasterMediaInfo'] = self.master_media_info.to_map()
        if self.media_match_segments is not None:
            result['MediaMatchSegments'] = self.media_match_segments.to_map()
        if self.query_media_info is not None:
            result['QueryMediaInfo'] = self.query_media_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterMediaInfo') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMasterMediaInfo()
            self.master_media_info = temp_model.from_map(m['MasterMediaInfo'])
        if m.get('MediaMatchSegments') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultMediaMatchSegments()
            self.media_match_segments = temp_model.from_map(m['MediaMatchSegments'])
        if m.get('QueryMediaInfo') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResultQueryMediaInfo()
            self.query_media_info = temp_model.from_map(m['QueryMediaInfo'])
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMasterFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMasterMediaFrames(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMatchedFramesDescFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageQueryMediaFrames(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorage(TeaModel):
    def __init__(
        self,
        master_media_frames: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMasterMediaFrames = None,
        matched_frames_desc_file: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMatchedFramesDescFile = None,
        query_media_frames: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageQueryMediaFrames = None,
    ):
        self.master_media_frames = master_media_frames
        self.matched_frames_desc_file = matched_frames_desc_file
        self.query_media_frames = query_media_frames

    def validate(self):
        if self.master_media_frames:
            self.master_media_frames.validate()
        if self.matched_frames_desc_file:
            self.matched_frames_desc_file.validate()
        if self.query_media_frames:
            self.query_media_frames.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_media_frames is not None:
            result['MasterMediaFrames'] = self.master_media_frames.to_map()
        if self.matched_frames_desc_file is not None:
            result['MatchedFramesDescFile'] = self.matched_frames_desc_file.to_map()
        if self.query_media_frames is not None:
            result['QueryMediaFrames'] = self.query_media_frames.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterMediaFrames') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMasterMediaFrames()
            self.master_media_frames = temp_model.from_map(m['MasterMediaFrames'])
        if m.get('MatchedFramesDescFile') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageMatchedFramesDescFile()
            self.matched_frames_desc_file = temp_model.from_map(m['MatchedFramesDescFile'])
        if m.get('QueryMediaFrames') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorageQueryMediaFrames()
            self.query_media_frames = temp_model.from_map(m['QueryMediaFrames'])
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobQueryFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        finish_time: str = None,
        fp_compare_result: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResult = None,
        fp_dbid: str = None,
        id: str = None,
        master_file: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMasterFile = None,
        match_frame_storage: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorage = None,
        message: str = None,
        pipeline_id: str = None,
        query_file: QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobQueryFile = None,
        state: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.fp_compare_result = fp_compare_result
        self.fp_dbid = fp_dbid
        self.id = id
        self.master_file = master_file
        self.match_frame_storage = match_frame_storage
        self.message = message
        self.pipeline_id = pipeline_id
        self.query_file = query_file
        self.state = state
        self.user_data = user_data

    def validate(self):
        if self.fp_compare_result:
            self.fp_compare_result.validate()
        if self.master_file:
            self.master_file.validate()
        if self.match_frame_storage:
            self.match_frame_storage.validate()
        if self.query_file:
            self.query_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_compare_result is not None:
            result['FpCompareResult'] = self.fp_compare_result.to_map()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.id is not None:
            result['Id'] = self.id
        if self.master_file is not None:
            result['MasterFile'] = self.master_file.to_map()
        if self.match_frame_storage is not None:
            result['MatchFrameStorage'] = self.match_frame_storage.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.query_file is not None:
            result['QueryFile'] = self.query_file.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpCompareResult') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobFpCompareResult()
            self.fp_compare_result = temp_model.from_map(m['FpCompareResult'])
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MasterFile') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMasterFile()
            self.master_file = temp_model.from_map(m['MasterFile'])
        if m.get('MatchFrameStorage') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobMatchFrameStorage()
            self.match_frame_storage = temp_model.from_map(m['MatchFrameStorage'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('QueryFile') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJobQueryFile()
            self.query_file = temp_model.from_map(m['QueryFile'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpCompareJobListResponseBodyFpCompareJobList(TeaModel):
    def __init__(
        self,
        fp_compare_job: List[QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJob] = None,
    ):
        self.fp_compare_job = fp_compare_job

    def validate(self):
        if self.fp_compare_job:
            for k in self.fp_compare_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpCompareJob'] = []
        if self.fp_compare_job is not None:
            for k in self.fp_compare_job:
                result['FpCompareJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_compare_job = []
        if m.get('FpCompareJob') is not None:
            for k in m.get('FpCompareJob'):
                temp_model = QueryFpCompareJobListResponseBodyFpCompareJobListFpCompareJob()
                self.fp_compare_job.append(temp_model.from_map(k))
        return self


class QueryFpCompareJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpCompareJobListResponseBody(TeaModel):
    def __init__(
        self,
        fp_compare_job_list: QueryFpCompareJobListResponseBodyFpCompareJobList = None,
        non_exist_ids: QueryFpCompareJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.fp_compare_job_list = fp_compare_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.fp_compare_job_list:
            self.fp_compare_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_compare_job_list is not None:
            result['FpCompareJobList'] = self.fp_compare_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpCompareJobList') is not None:
            temp_model = QueryFpCompareJobListResponseBodyFpCompareJobList()
            self.fp_compare_job_list = temp_model.from_map(m['FpCompareJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpCompareJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpCompareJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFpCompareJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFpCompareJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpDBDeleteJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        del_type: str = None,
        finish_time: str = None,
        fp_dbid: str = None,
        id: str = None,
        message: str = None,
        pipeline_id: str = None,
        status: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.del_type = del_type
        self.finish_time = finish_time
        self.fp_dbid = fp_dbid
        self.id = id
        self.message = message
        self.pipeline_id = pipeline_id
        self.status = status
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.del_type is not None:
            result['DelType'] = self.del_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DelType') is not None:
            self.del_type = m.get('DelType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList(TeaModel):
    def __init__(
        self,
        fp_dbdelete_job: List[QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob] = None,
    ):
        self.fp_dbdelete_job = fp_dbdelete_job

    def validate(self):
        if self.fp_dbdelete_job:
            for k in self.fp_dbdelete_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpDBDeleteJob'] = []
        if self.fp_dbdelete_job is not None:
            for k in self.fp_dbdelete_job:
                result['FpDBDeleteJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_dbdelete_job = []
        if m.get('FpDBDeleteJob') is not None:
            for k in m.get('FpDBDeleteJob'):
                temp_model = QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob()
                self.fp_dbdelete_job.append(temp_model.from_map(k))
        return self


class QueryFpDBDeleteJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpDBDeleteJobListResponseBody(TeaModel):
    def __init__(
        self,
        fp_dbdelete_job_list: QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList = None,
        non_exist_ids: QueryFpDBDeleteJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.fp_dbdelete_job_list = fp_dbdelete_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.fp_dbdelete_job_list:
            self.fp_dbdelete_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbdelete_job_list is not None:
            result['FpDBDeleteJobList'] = self.fp_dbdelete_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpDBDeleteJobList') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList()
            self.fp_dbdelete_job_list = temp_model.from_map(m['FpDBDeleteJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpDBDeleteJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFpDBDeleteJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpFileDeleteJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        creation_time: str = None,
        file_ids: str = None,
        finish_time: str = None,
        fp_dbid: str = None,
        id: str = None,
        message: str = None,
        pipeline_id: str = None,
        status: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.creation_time = creation_time
        self.file_ids = file_ids
        self.finish_time = finish_time
        self.fp_dbid = fp_dbid
        self.id = id
        self.message = message
        self.pipeline_id = pipeline_id
        self.status = status
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList(TeaModel):
    def __init__(
        self,
        fp_file_delete_job: List[QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob] = None,
    ):
        self.fp_file_delete_job = fp_file_delete_job

    def validate(self):
        if self.fp_file_delete_job:
            for k in self.fp_file_delete_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpFileDeleteJob'] = []
        if self.fp_file_delete_job is not None:
            for k in self.fp_file_delete_job:
                result['FpFileDeleteJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_file_delete_job = []
        if m.get('FpFileDeleteJob') is not None:
            for k in m.get('FpFileDeleteJob'):
                temp_model = QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob()
                self.fp_file_delete_job.append(temp_model.from_map(k))
        return self


class QueryFpFileDeleteJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpFileDeleteJobListResponseBody(TeaModel):
    def __init__(
        self,
        fp_file_delete_job_list: QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList = None,
        non_exist_ids: QueryFpFileDeleteJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.fp_file_delete_job_list = fp_file_delete_job_list
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.fp_file_delete_job_list:
            self.fp_file_delete_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_file_delete_job_list is not None:
            result['FpFileDeleteJobList'] = self.fp_file_delete_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpFileDeleteJobList') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList()
            self.fp_file_delete_job_list = temp_model.from_map(m['FpFileDeleteJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpFileDeleteJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFpFileDeleteJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpImportResultRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        owner_account: str = None,
        owner_id: int = None,
        page_index: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_index = page_index
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryFpImportResultResponseBodyFpResultLogInfoListFpResultLogInfo(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        log_end_time: int = None,
        log_name: str = None,
        log_path: str = None,
        log_size: int = None,
        log_start_time: int = None,
    ):
        self.create_time = create_time
        self.log_end_time = log_end_time
        self.log_name = log_name
        self.log_path = log_path
        self.log_size = log_size
        self.log_start_time = log_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.log_start_time is not None:
            result['LogStartTime'] = self.log_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('LogStartTime') is not None:
            self.log_start_time = m.get('LogStartTime')
        return self


class QueryFpImportResultResponseBodyFpResultLogInfoList(TeaModel):
    def __init__(
        self,
        fp_result_log_info: List[QueryFpImportResultResponseBodyFpResultLogInfoListFpResultLogInfo] = None,
    ):
        self.fp_result_log_info = fp_result_log_info

    def validate(self):
        if self.fp_result_log_info:
            for k in self.fp_result_log_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpResultLogInfo'] = []
        if self.fp_result_log_info is not None:
            for k in self.fp_result_log_info:
                result['FpResultLogInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_result_log_info = []
        if m.get('FpResultLogInfo') is not None:
            for k in m.get('FpResultLogInfo'):
                temp_model = QueryFpImportResultResponseBodyFpResultLogInfoListFpResultLogInfo()
                self.fp_result_log_info.append(temp_model.from_map(k))
        return self


class QueryFpImportResultResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        page_index: int = None,
        page_size: int = None,
        total: int = None,
    ):
        self.page_index = page_index
        self.page_size = page_size
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class QueryFpImportResultResponseBody(TeaModel):
    def __init__(
        self,
        fp_result_log_info_list: QueryFpImportResultResponseBodyFpResultLogInfoList = None,
        log_count: int = None,
        page_info: QueryFpImportResultResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.fp_result_log_info_list = fp_result_log_info_list
        self.log_count = log_count
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.fp_result_log_info_list:
            self.fp_result_log_info_list.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_result_log_info_list is not None:
            result['FpResultLogInfoList'] = self.fp_result_log_info_list.to_map()
        if self.log_count is not None:
            result['LogCount'] = self.log_count
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpResultLogInfoList') is not None:
            temp_model = QueryFpImportResultResponseBodyFpResultLogInfoList()
            self.fp_result_log_info_list = temp_model.from_map(m['FpResultLogInfoList'])
        if m.get('LogCount') is not None:
            self.log_count = m.get('LogCount')
        if m.get('PageInfo') is not None:
            temp_model = QueryFpImportResultResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpImportResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFpImportResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFpImportResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpShotJobListRequest(TeaModel):
    def __init__(
        self,
        end_of_job_created_time_range: str = None,
        job_ids: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        pipeline_id: str = None,
        primary_key_list: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_of_job_created_time_range: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.end_of_job_created_time_range = end_of_job_created_time_range
        self.job_ids = job_ids
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.pipeline_id = pipeline_id
        self.primary_key_list = primary_key_list
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_of_job_created_time_range = start_of_job_created_time_range
        self.state = state
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.primary_key_list is not None:
            result['PrimaryKeyList'] = self.primary_key_list
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('PrimaryKeyList') is not None:
            self.primary_key_list = m.get('PrimaryKeyList')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig(TeaModel):
    def __init__(
        self,
        fp_dbid: str = None,
        notary: str = None,
        primary_key: str = None,
        save_type: str = None,
    ):
        self.fp_dbid = fp_dbid
        self.notary = notary
        self.primary_key = primary_key
        self.save_type = save_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.notary is not None:
            result['Notary'] = self.notary
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Notary') is not None:
            self.notary = m.get('Notary')
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(
        self,
        duplication: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication = None,
        input: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput = None,
        similarity: str = None,
    ):
        self.duplication = duplication
        self.input = input
        self.similarity = similarity

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(
        self,
        fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice] = None,
    ):
        self.fp_shot_slice = fp_shot_slice

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot(TeaModel):
    def __init__(
        self,
        fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices = None,
        primary_key: str = None,
        similarity: str = None,
    ):
        self.fp_shot_slices = fp_shot_slices
        self.primary_key = primary_key
        self.similarity = similarity

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots(TeaModel):
    def __init__(
        self,
        fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot] = None,
    ):
        self.fp_shot = fp_shot

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(
        self,
        duplication: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication = None,
        input: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput = None,
        similarity: str = None,
    ):
        self.duplication = duplication
        self.input = input
        self.similarity = similarity

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(
        self,
        fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice] = None,
    ):
        self.fp_shot_slice = fp_shot_slice

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot(TeaModel):
    def __init__(
        self,
        fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices = None,
        primary_key: str = None,
        similarity: str = None,
    ):
        self.fp_shot_slices = fp_shot_slices
        self.primary_key = primary_key
        self.similarity = similarity

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots(TeaModel):
    def __init__(
        self,
        fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot] = None,
    ):
        self.fp_shot = fp_shot

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        self.duration = duration
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice(TeaModel):
    def __init__(
        self,
        duplication_text: str = None,
        input_fragment: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment = None,
        input_text: str = None,
        similarity: str = None,
    ):
        self.duplication_text = duplication_text
        self.input_fragment = input_fragment
        self.input_text = input_text
        self.similarity = similarity

    def validate(self):
        if self.input_fragment:
            self.input_fragment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication_text is not None:
            result['DuplicationText'] = self.duplication_text
        if self.input_fragment is not None:
            result['InputFragment'] = self.input_fragment.to_map()
        if self.input_text is not None:
            result['InputText'] = self.input_text
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DuplicationText') is not None:
            self.duplication_text = m.get('DuplicationText')
        if m.get('InputFragment') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment()
            self.input_fragment = temp_model.from_map(m['InputFragment'])
        if m.get('InputText') is not None:
            self.input_text = m.get('InputText')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices(TeaModel):
    def __init__(
        self,
        text_fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice] = None,
    ):
        self.text_fp_shot_slice = text_fp_shot_slice

    def validate(self):
        if self.text_fp_shot_slice:
            for k in self.text_fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TextFpShotSlice'] = []
        if self.text_fp_shot_slice is not None:
            for k in self.text_fp_shot_slice:
                result['TextFpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.text_fp_shot_slice = []
        if m.get('TextFpShotSlice') is not None:
            for k in m.get('TextFpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice()
                self.text_fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot(TeaModel):
    def __init__(
        self,
        primary_key: str = None,
        similarity: str = None,
        text_fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices = None,
    ):
        self.primary_key = primary_key
        self.similarity = similarity
        self.text_fp_shot_slices = text_fp_shot_slices

    def validate(self):
        if self.text_fp_shot_slices:
            self.text_fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.text_fp_shot_slices is not None:
            result['TextFpShotSlices'] = self.text_fp_shot_slices.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('TextFpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices()
            self.text_fp_shot_slices = temp_model.from_map(m['TextFpShotSlices'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots(TeaModel):
    def __init__(
        self,
        text_fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot] = None,
    ):
        self.text_fp_shot = text_fp_shot

    def validate(self):
        if self.text_fp_shot:
            for k in self.text_fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map(