#include <iostream>
#include <ctime>
#include <math.h>

#include <eigen3/Eigen/Dense>
#include <cstdlib>
#include <random>
#define EIGEN_DONT_VECTORIZE
#define EIGEN_DISABLE_UNALIGNED_ARRAY_ASSERT

using Eigen::MatrixXd;
using Eigen::MatrixXi;
using Eigen::VectorXd;
using Eigen::VectorXi;


void translationSSA_custompool_trna(int* k_index, double* k_trna, int total_species, double k_diffusion, double* t_array, int Nt, double kbind, double kcompl, int* SSA_result,int* trna_result, int N, int FRAP, int Inhibitor, double inhibit_time, int seed, double* SSA_ribtimes, int* nribs, int ribtimesize, int fNt, int* frap_result, int cNt, int* col_result, double* col_t, int* col_x, int colNp, int* x0, double kelong)
{
	// Declare the variables
	
	/*
	Inputs explaination: 
	
	kelong - a double 1xGeneLength vector of each codon at postition rate
	t_array - a time array of when to record the SSA_result
	Nt - the size of the t_array int
	kbind - ki the rate of initation
	kcompl - ktermination the rate of unbinding / release
	SSA_result - the result of the ssa, preallocated from python (N time points x 200 ribosomes x N trajectories)
	
	N - number trajectories
	FRAP - true false to do frap at inhibit time
	
	Inhibitor - True false to inhibit k_in at inhibit time
	inhibit_time - time of inhibition
	
	
	seed - RNG seed passed from python to ensure it doesnt use the same seeds for groups of trajectories - preallocated by python random vector
	rib_times - an array to be filled with the times of a Nribs to watch how long they take to go through the simulation
	nribs - the number of ribosomes to watch, this is to get around a dynamic array; basically the code will just watch "X" amount of ribosomes and record their data
	        instead of trying to do a dynamic array
	ribtimesize - the size of the ribosome watching array
	
	so to do the frap the simulation just returns the section that underwent frap, then the python wrapper will do the logic to bleach that section, as it gets complex 
	with ribosomes that were partially bleached
	
	fNt - the number of frap times, basically we need to record the section of the simulation that undergoes frap to manually "bleach it later" as the logic is complex
	frap_result - the area of the ssa result that undergoes frap 
	
	cNt - the size of the collision recording array 
	col_result - records collisions
	
	colNp - number of collisions to record as well - vectorized
	col_x - posistions of collisions
	col_t - time of said collision
	
	
	
	
	*/
	
	
    int R = 9; // ribosome exclusion.
    int N_rib = 200; // maximum number of ribosomes. 
	//std::cout << "-------nrib=" << N_rib << "-------" << std::endl;
	
	std::mt19937_64 rng; 
	//INCLUDE <#chrono> to seed from computer clock
    // initialize the random number generator with time-dependent seed
    //uint64_t timeSeed = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    //std::seed_seq ss{uint32_t(timeSeed & 0xffffffff), uint32_t(timeSeed>>32)};
    rng.seed(seed);
	std::uniform_real_distribution<double> unif(0, 1);
	
	
    int it = 0;
	int number_ribs = 0;
	int fit = 0;
	
	
    // int N = 10; // gene length
    //bool Inhibitor = 0;
    //bool FRAP = 0;
    double Inhibit_condition=1;
    bool inhibit_off=1;
    //double inhibit_time = 0;
	
	bool inhibitor_pres=0;
	bool FRAP_pres =0;
	
	if (Inhibitor==1){
		inhibitor_pres =1;
	}
	if (FRAP==1){
		FRAP_pres =1;
	}	
    int NR = 0;
	int old_NR = 0;
//	N = 10;
    double a0, r1, r2, t, tf;
    t=t_array[0];
    tf = t_array[Nt-1];
    int ind = 0;
    //srand (1537478928);  
	//std::cout << time(NULL) << std::endl;
    // print a test random number
    // Define the state vector
    MatrixXi X(1,N_rib);	
    X.setZero(1,N_rib);
	for(int i=0; i <= N_rib; i++)	{
		X(0,i) = x0[i];
	}
	
    MatrixXi trna_pool(1,total_species);	
    trna_pool.setZero(1,total_species);	
	
	//stoichiometry of the tRNA  species x reactions
	
	MatrixXi trna_S(2*total_species,total_species);
	trna_S.setZero(2*total_species,total_species);
	for(int i = 0; i < total_species; i++){
		trna_S(i,i) = 1;
		trna_S(i+total_species,i) = -1;
	}
	
	
	// set up W1 propensities for tRNA
	Eigen::VectorXd trna_wn;
	trna_wn.setZero(total_species*2);
	
	for (int i = 0; i < 2*total_species; i++){
		if (i < total_species){
			trna_wn(i) = k_trna[i];
		}
		else{
			trna_wn(i) = k_diffusion;
		}
	}
	

	
	
	MatrixXi col(1,N_rib);
	col.setZero(1,N_rib);
	
    MatrixXi T(1,N_rib); //ribosome travel time array
    T.setZero(1,N_rib);
	
	//VectorXd T_array(200);
	int t_counter = 0;
	int col_counter = 0;
	
    // Create an eigen matrix that stores the results. 
    Eigen::Map<Eigen::MatrixXi> X_array(SSA_result,Nt,N_rib);
	
	Eigen::Map<Eigen::MatrixXi> tRNA_array(trna_result,Nt,total_species);
	
	Eigen::Map<Eigen::MatrixXi> frap_array(frap_result,fNt,N_rib);
	
	
	
	
	Eigen::Map<Eigen::VectorXd> T_array(SSA_ribtimes,ribtimesize);  // this map function will fill the python allocated array
	Eigen::Map<Eigen::VectorXi> col_array(col_result,cNt);
	
	
	Eigen::Map<Eigen::VectorXd> colarrayt(col_t,colNp);
	Eigen::Map<Eigen::VectorXi> colarrayx(col_x,colNp);
	
	Eigen::Map<Eigen::VectorXi> n_ribs(nribs,1);

	int tsize = T_array.size();
	int col_size = colarrayt.size();

    while( t < tf)
    {
        // Determine inhibitor stuff
        if (inhibitor_pres) {
            if (t>=inhibit_time){
                inhibit_off = 0;
                Inhibit_condition = 0;
            } else {
                inhibit_off = 1; 
                Inhibit_condition=1;
            }}
        else { 
            Inhibit_condition=1;
        }


		
        // Update the number of ribosomes, always making sure to have
        // a zero on the right side of X (space for a new ribosome) 
		
        int NR = 0;
        while (X(0,NR)>0){
            NR+=1;
        }
		
		//std::cout << "-------NR=" << NR << "-------" << std::endl;
		
		
		if (NR > old_NR){

			T(0,NR-1) = t;
			number_ribs +=1;
			
			
		}


        old_NR = 0;
        while (X(0,old_NR)>0){
            old_NR+=1;
			
        }
			
		
				
        //std::cout << "X: " << X << std::endl;
        MatrixXi rib_S(NR+1,NR+1);
        rib_S.setIdentity(NR+1,NR+1);
        //std::cout << "Stoichiometry Matrix: \n" << Sn << std::endl;
        Eigen::VectorXd rib_wn;
        rib_wn.setZero(NR+1);
        // for loop instead of "where"       
        // also, account for the exclusion here.
        for(int i=0; i <= NR; i++)
        {	
	
            if( X(0,i) > 0 ){
                rib_wn(i) = kelong* trna_pool(k_index[X(0,i) - 1]);  //kelong here
				
            }
            if( i>0){
                if( X(0,i-1)-X(0,i)<=R ){
					
                    rib_wn(i) = 0;
                }

				
            }
        }
		
		//if (ind == 123){
			//std::cout << "calculating ribwin"  << std::endl;
			//std::cout << "N" << N << std::endl;
		//}

        // If a nascent protein reaches full length
        // add in the completion rate
//       std::cout  << X << std::endl;
        if( X(0,0) == N ){
            // shift everyone if completing
            for(int i=0; i <= NR-1; i++)
            {
                rib_S(0,i) = X(0,i+1) - X(0,i); 
            }
            rib_S(0,NR-1) = -X(0,NR-1);
            rib_wn(0) = kcompl;
//            std::cout << "Updated propensity: \n" << wn << std::endl;
//            std::cout << "Updated stoichiometry: \n " << Sn << std::endl;
        }

        // include the initiation condition
        if( (NR==0) || ( X(0,NR-1)>R) ){
            rib_wn(NR) = kbind*Inhibit_condition;
        }
		
		
		for (int i = total_species; i < total_species*2; i++){
			trna_wn(i) = trna_pool(i-total_species)*k_diffusion;
		}
		
		
		Eigen::VectorXd wn(trna_wn.size() + rib_wn.size());
		wn << trna_wn, rib_wn;
		
		
		//Eigen::MatrixXi Sn(trna_S.rows()+rib_S.rows,   Sn_elong.cols() + 61);
		//Sn.setZero();
		
		//Sn << trna_S,rib_S;
		
        // Update the propensity
		
        a0 = wn.sum();

        // Generate some random numbers.
		
        r1 =  unif(rng);
        r2 =  unif(rng);
		
		
		// if rand() gets a 0 resample, since ln(0) = -inf 
		if((r1==0)){
			//std::cout << r1 << " " << r1a << " " << t <<  std::endl;
			
			r1 =  unif(rng);			
		}
		
		

        // Update the time vector
//        std::cout << "TIME " << t << std::endl;
        t -= log(r1)/a0;
		//std::cout << t << std::endl;

		
        //std::cout << "TIME " << t << std::endl;
  //      std::cout << "-------------" << std::endl;
        // Store the X vector
        //while( ((it<=Nt-1) || (t>t_array[it])) ){
        while( (it<=Nt-1) && (t>t_array[it])) {
			//std::cout << it << std::endl;
            X_array.row(it) = X.row(0);
			tRNA_array.row(it) = trna_pool.row(0);
			if (FRAP_pres){
				
				if ( (t>= inhibit_time) && (t< inhibit_time+20)) {
					frap_array.row(fit) = X.row(0);
					fit +=1;
				}
			}			
			
            it+=1;
			//std::cout << it << std::endl;
			
         }
		 

		
        // update the state
        ind = 1;
        while (wn.head(ind).sum() < r2*a0)
        {	
            ind +=1;
        }
		
		

		
		if (ind <= total_species*2){
			//std::cout << "current_prop trna: " << trna_S.row(ind-1) << std::endl;
			trna_pool.topLeftCorner(1,total_species) = trna_pool.topLeftCorner(1,total_species) + trna_S.row(ind-1);
			//bool f  = (trna_pool.topLeftCorner(1,61).array() < 0.0).any();
			//if (f == true){
				//std::cout << "current_rxn: " << ind-1 << std::endl;
				//std::cout << "current_trna_pool: " << trna_pool.topLeftCorner(1,61) << std::endl;
			//}
		}
		else{
			
			// convert ind
			int rib_ind = ind - (total_species*2+1);
			
			//X.topLeftCorner(1,NR+1) = X.topLeftCorner(1,NR+1) + rib_S.row(rib_ind);
		
			if (rib_S.row(rib_ind).sum() < 0){
				X.topLeftCorner(1,NR+1) = X.topLeftCorner(1,NR+1) + rib_S.row(rib_ind);
				if (t_counter < tsize){
					T_array(t_counter) = t - T(0,0);
							
					T.block(0,0,1,NR) = T.block(0,1,1,NR);
					T(0,NR) = 0;	
					
					col_array(t_counter) = col(0,0);	
					col.block(0,0,1,NR) = col.block(0,1,1,NR);	
					col(0,NR)= 0;
					t_counter +=1;		
					
				}
			}
			else {
				if(X(rib_ind) != 0){          // if elongating forward, eat a tRNA ignore when its binding
					trna_pool(k_index[X(rib_ind) - 1]) = trna_pool(k_index[X(rib_ind) - 1])-1;
					

				}
				
				X.topLeftCorner(1,NR+1) = X.topLeftCorner(1,NR+1) + rib_S.row(rib_ind); // move forward
				
				if (NR > 1){  // iterate collision counter
					if (X(0,rib_ind-1) == X(0,rib_ind) + R){
						col(0,rib_ind) +=1;
						if (col_counter < col_size){
							colarrayt(col_counter) = t;
							colarrayx(col_counter) = X(0,rib_ind);
							col_counter+=1;
						}
						
					}
				}


			}
		}
		//std::cout << "oneiter" << std::endl;

    }
	n_ribs(0) = number_ribs;
	
        
}
 
/*
int main()
{
    //double k[2][5] = {{1, 2, 3, 4, 5},{6,7,8,9,10}};
    //double k[1][10] = {{3.1,3.2,3.3,3.4,3.5,3.1,3.2,3.3,3.4,3.5}};
    double k[10] = {3.1,3.2,3.3,3.4,3.5,3.1,3.2,3.3,3.4,3.5};
    double t_array[3] = {0, 50,100};
    double kbind = 9.0; 
    double kcompl = 15.0; 
	double inhibit_time = 10.0;
	int FRAP = 0;
	int Inhibitor = 1;
    int Nt;
    int result[10];
	double ribtimes[50];
	int seed;
    //seed = srand (time(NULL));
    Nt = (sizeof(t_array)/sizeof(*t_array));
    for(int kk=0; kk<3; kk++){
        translationSSA(k, t_array, 3, kbind, kcompl, result, 10, FRAP, Inhibitor, inhibit_time,15,ribtimes);
    }
}   

*/
