import L from "leaflet";
import { GeodesicGeometry, Statistics } from "./geodesic-geom";
import { GeodesicOptions } from "./geodesic-core";
/**
 * Can be used to create a geodesic circle based on L.Polyline
 */
export declare class GeodesicCircleClass extends L.Polyline {
    defaultOptions: GeodesicOptions;
    readonly geom: GeodesicGeometry;
    center: L.LatLng;
    radius: number;
    statistics: Statistics;
    constructor(center?: L.LatLngExpression, options?: GeodesicOptions);
    /**
     * Updates the geometry and re-calculates some statistics
     */
    private update;
    /**
     * Calculate the distance between the current center and an arbitrary position.
     * @param latlng geo-position to calculate distance to
     * @return distance in meters
     */
    distanceTo(latlng: L.LatLngExpression): number;
    /**
     * Set a new center for the geodesic circle and update the geometry. Radius may also be set.
     * @param center the new center
     * @param radius the new radius
     */
    setLatLng(center: L.LatLngExpression, radius?: number): void;
    /**
     * Set a new radius for the geodesic circle and update the geometry. Center may also be set.
     * @param radius the new radius
     * @param center the new center
     */
    setRadius(radius: number, center?: L.LatLngExpression): void;
}
