"""
PyDetex
https://github.com/ppizarror/PyDetex

SYMBOLS
Contain latex commands converted to symbols.
"""

__all__ = [
    'REPLACE_EQUATION_SYMBOLS_LIBRARY',
    'REPLACE_SYMBOLS_LIBRARY',
    'REPLACE_TEX_COMMANDS_LIBRARY'
]

from typing import List, Tuple

REPLACE_SYMBOLS_LIBRARY: List[Tuple[str, str]] = [
    # Common
    ('\\ ', ' '),
    ('\\\\', '\n'),

    # Letters
    ('--', '–'),
    ('---', '—'),
    ('\&', '&'),
    ('~', ' '),
    ('ﬁ', 'fi')
]

REPLACE_EQUATION_SYMBOLS_LIBRARY: List[Tuple[str, str]] = [
    ('^(', '⁽'),
    ('^)', '⁾'),
    ('^+', '⁺'),
    ('^-', '⁻'),
    ('^0', '⁰'),
    ('^1', '¹'),
    ('^2', '²'),
    ('^3', '³'),
    ('^4', '⁴'),
    ('^5', '⁵'),
    ('^6', '⁶'),
    ('^7', '⁷'),
    ('^8', '⁸'),
    ('^9', '⁹'),
    ('^=', '⁼'),
    ('^A', 'ᴬ'),
    ('^a', 'ᵃ'),
    ('^B', 'ᴮ'),
    ('^b', 'ᵇ'),
    ('^c', 'ᶜ'),
    ('^D', 'ᴰ'),
    ('^d', 'ᵈ'),
    ('^E', 'ᴱ'),
    ('^e', 'ᵉ'),
    ('^f', 'ᶠ'),
    ('^G', 'ᴳ'),
    ('^g', 'ᵍ'),
    ('^h', 'ʰ'),
    ('^H', 'ᴴ'),
    ('^I', 'ᴵ'),
    ('^i', 'ⁱ'),
    ('^j', 'ʲ'),
    ('^J', 'ᴶ'),
    ('^K', 'ᴷ'),
    ('^k', 'ᵏ'),
    ('^l', 'ˡ'),
    ('^L', 'ᴸ'),
    ('^M', 'ᴹ'),
    ('^m', 'ᵐ'),
    ('^N', 'ᴺ'),
    ('^n', 'ⁿ'),
    ('^O', 'ᴼ'),
    ('^o', 'ᵒ'),
    ('^P', 'ᴾ'),
    ('^p', 'ᵖ'),
    ('^r', 'ʳ'),
    ('^R', 'ᴿ'),
    ('^s', 'ˢ'),
    ('^T', 'ᵀ'),
    ('^t', 'ᵗ'),
    ('^U', 'ᵁ'),
    ('^u', 'ᵘ'),
    ('^v', 'ᵛ'),
    ('^w', 'ʷ'),
    ('^W', 'ᵂ'),
    ('^x', 'ˣ'),
    ('^y', 'ʸ'),
    ('^z', 'ᶻ'),
    ('_(', '₍'),
    ('_)', '₎'),
    ('_+', '₊'),
    ('_-', '₋'),
    ('_0', '₀'),
    ('_1', '₁'),
    ('_2', '₂'),
    ('_3', '₃'),
    ('_4', '₄'),
    ('_5', '₅'),
    ('_6', '₆'),
    ('_7', '₇'),
    ('_8', '₈'),
    ('_9', '₉'),
    ('_=', '₌'),
    ('_a', 'ₐ'),
    ('_e', 'ₑ'),
    ('_h', 'ₕ'),
    ('_i', 'ᵢ'),
    ('_k', 'ₖ'),
    ('_l', 'ₗ'),
    ('_m', 'ₘ'),
    ('_n', 'ₙ'),
    ('_o', 'ₒ'),
    ('_p', 'ₚ'),
    ('_r', 'ᵣ'),
    ('_s', 'ₛ'),
    ('_t', 'ₜ'),
    ('_u', 'ᵤ'),
    ('_v', 'ᵥ'),
    ('_x', 'ₓ')
]

REPLACE_TEX_COMMANDS_LIBRARY: List[Tuple[str, str]] = [
    ('\\AC', '∿'),
    ('\\aleph', 'ℵ'),
    ('\\alpha', 'α'),
    ('\\amalg', '⨿'),
    ('\\angle', '∠'),
    ('\\approx', '≈'),
    ('\\approxeq', '≊'),
    ('\\asterism', '⁂'),
    ('\\asymp', '≍'),
    ('\\backepsilon', '϶'),
    ('\\backprime', '‵'),
    ('\\backsim', '∽'),
    ('\\backsimeq', '⋍'),
    ('\\barwedge', '⊼'),
    ('\\because', '∵'),
    ('\\beta', 'β'),
    ('\\beth', 'ℶ'),
    ('\\between', '≬'),
    ('\\bigcap', '⋂'),
    ('\\bigcup', '⋃'),
    ('\\bigodot', '⨀'),
    ('\\bigoplus', '⨁'),
    ('\\bigotimes', '⨂'),
    ('\\bigsqcap', '⨅'),
    ('\\bigsqcup', '⨆'),
    ('\\bigvee', '⋁'),
    ('\\bigwedge', '⋀'),
    ('\\bot', '⊥'),
    ('\\bowtie', '⋈'),
    ('\\boxdot', '⊡'),
    ('\\boxminus', '⊟'),
    ('\\boxplus', '⊞'),
    ('\\boxtimes', '⊠'),
    ('\\bullet', '•'),
    ('\\Bumpeq', '≎'),
    ('\\bumpeq', '≏'),
    ('\\cap', '∩'),
    ('\\Cap', '⋒'),
    ('\\cdot', '·'),
    ('\\cdots', '⋯'),
    ('\\checkmark', '✓'),
    ('\\chi', 'χ'),
    ('\\circ', '∘'),
    ('\\circeq', '≗'),
    ('\\circlearrowleft', '↺'),
    ('\\circlearrowright', '↻'),
    ('\\circledast', '⊛'),
    ('\\circledcirc', '⊚'),
    ('\\circleddash', '⊝'),
    ('\\clubsuit', '♣'),
    ('\\coloneqq', '≔'),
    ('\\complement', '∁'),
    ('\\cong', '≅'),
    ('\\coprod', '∐'),
    ('\\copyright', '©'),
    ('\\cup', '∪'),
    ('\\Cup', '⋓'),
    ('\\curlyeqprec', '⋞'),
    ('\\curlyeqsucc', '⋟'),
    ('\\curlyvee', '⋎'),
    ('\\curlywedge', '⋏'),
    ('\\curvearrowleft', '↶'),
    ('\\curvearrowright', '↷'),
    ('\\dagger', '†'),
    ('\\daleth', 'ℸ'),
    ('\\dashleftarrow', '⇠'),
    ('\\dashrightarrow', '⇢'),
    ('\\dashv', '⊣'),
    ('\\dbend', '☡'),
    ('\\ddag', '‡'),
    ('\\ddots', '⋱'),
    ('\\Delta', 'Δ'),
    ('\\delta', 'δ'),
    ('\\diameter', '⌀'),
    ('\\diamond', '⋄'),
    ('\\diamondsuit', '♢'),
    ('\\Digamma', 'Ϝ'),
    ('\\digamma', 'ϝ'),
    ('\\div', '÷'),
    ('\\divideontimes', '⋇'),
    ('\\doteq', '≐'),
    ('\\doteqdot', '≑'),
    ('\\dotminus', '∸'),
    ('\\dotplus', '∔'),
    ('\\downarrow', '↓'),
    ('\\Downarrow', '⇓'),
    ('\\downdownarrows', '⇊'),
    ('\\downharpoonleft', '⇃'),
    ('\\downharpoonright', '⇂'),
    ('\\ell', 'ℓ'),
    ('\\epsilon', 'ϵ'),
    ('\\eqcirc', '≖'),
    ('\\eqcolon', '∹'),
    ('\\eqqcolon', '≕'),
    ('\\equiv', '≡'),
    ('\\eta', 'η'),
    ('\\Euler', 'ℇ'),
    ('\\euro', '€'),
    ('\\exists', '∃'),
    ('\\fallingdotseq', '≒'),
    ('\\Finv', 'Ⅎ'),
    ('\\flat', '♭'),
    ('\\forall', '∀'),
    ('\\frac{1}{2}', '½'),
    ('\\frac{1}{3}', '⅓'),
    ('\\frac{1}{4}', '¼'),
    ('\\frac{1}{5}', '⅕'),
    ('\\frac{1}{6}', '⅙'),
    ('\\frac{1}{8}', '⅛'),
    ('\\frac{2}{3}', '⅔'),
    ('\\frac{2}{5}', '⅖'),
    ('\\frac{3}{4}', '¾'),
    ('\\frac{3}{5}', '⅗'),
    ('\\frac{4}{5}', '⅘'),
    ('\\frac{5}{6}', '⅚'),
    ('\\frac{5}{8}', '⅝'),
    ('\\frac{7}{8}', '⅞'),
    ('\\frown', '⌢'),
    ('\\frownie', '☹'),
    ('\\Game', '⅁'),
    ('\\Gamma', 'Γ'),
    ('\\gamma', 'γ'),
    ('\\ge', '≥'),
    ('\\geqq', '≧'),
    ('\\geqslant', '⩾'),
    ('\\gg', '≫'),
    ('\\ggg', '⋙'),
    ('\\gimel', 'ℷ'),
    ('\\gneqq', '≩'),
    ('\\gnsim', '⋧'),
    ('\\gtrdot', '⋗'),
    ('\\gtreqless', '⋛'),
    ('\\gtrless', '≷'),
    ('\\gtrsim', '≳'),
    ('\\guillemotleft', '«'),
    ('\\guillemotright', '»'),
    ('\\guilsinglleft', '‹'),
    ('\\guilsinglright', '›'),
    ('\\hbar', 'ℏ'),
    ('\\heartsuit', '♡'),
    ('\\hookleftarrow', '↩'),
    ('\\hookrightarrow', '↪'),
    ('\\iddots', '⋰'),
    ('\\iiiint', '⨌'),
    ('\\iiint', '∭'),
    ('\\iint', '∬'),
    ('\\IM', 'ℑ'),
    ('\\imath', 'ı'),
    ('\\in', '∈'),
    ('\\infty', '∞'),
    ('\\int', '∫'),
    ('\\intercal', '⊺'),
    ('\\invamp', '⅋'),
    ('\\iota', 'ι'),
    ('\\jmath', 'ȷ'),
    ('\\Join', '⨝'),
    ('\\kappa', 'κ'),
    ('\\Koppa', 'Ϟ'),
    ('\\koppa', 'ϟ'),
    ('\\Lambda', 'Λ'),
    ('\\lambda', 'λ'),
    ('\\langle', '〈'),
    ('\\lceil', '⌈'),
    ('\\ldots', '…'),
    ('\\le', '≤'),
    ('\\leftarrow', '←'),
    ('\\Leftarrow', '⇐'),
    ('\\LeftArrowBar', '⇤'),
    ('\\leftarrowtail', '↢'),
    ('\\leftarrowtriangle', '⇽'),
    ('\\leftharpoondown', '↽'),
    ('\\leftharpoonup', '↼'),
    ('\\leftleftarrows', '⇇'),
    ('\\leftrightarrow', '↔'),
    ('\\Leftrightarrow', '⇔'),
    ('\\leftrightarrows', '⇆'),
    ('\\leftrightarrowtriangle', '⇿'),
    ('\\leftrightharpoons', '⇋'),
    ('\\leftrightsquigarrow', '↭'),
    ('\\leftsquigarrow', '⇜'),
    ('\\leftthreetimes', '⋋'),
    ('\\leqq', '≦'),
    ('\\leqslant', '⩽'),
    ('\\lessdot', '⋖'),
    ('\\lesseqgtr', '⋚'),
    ('\\lessgtr', '≶'),
    ('\\lesssim', '≲'),
    ('\\lfloor', '⌊'),
    ('\\lightning', '↯'),
    ('\\ll', '≪'),
    ('\\llangle', '⟪'),
    ('\\llbracket', '〚'),
    ('\\Lleftarrow', '⇚'),
    ('\\lll', '⋘'),
    ('\\ln', '㏑'),
    ('\\lneqq', '≨'),
    ('\\lnsim', '⋦'),
    ('\\log', '㏒'),
    ('\\longleftarrow', '⟵'),
    ('\\longrightarrow', '⟶'),
    ('\\looparrowleft', '↫'),
    ('\\looparrowright', '↬'),
    ('\\Lsh', '↰'),
    ('\\ltimes', '⋉'),
    ('\\mapsfrom', '↤'),
    ('\\mapsto', '↦'),
    ('\\Mapsto', '⇰'),
    ('\\mathbb{0}', '𝟘'),
    ('\\mathbb{1}', '𝟙'),
    ('\\mathbb{2}', '𝟚'),
    ('\\mathbb{3}', '𝟛'),
    ('\\mathbb{4}', '𝟜'),
    ('\\mathbb{5}', '𝟝'),
    ('\\mathbb{6}', '𝟞'),
    ('\\mathbb{7}', '𝟟'),
    ('\\mathbb{8}', '𝟠'),
    ('\\mathbb{9}', '𝟡'),
    ('\\mathbb{\\gamma}', 'ℽ'),
    ('\\mathbb{\\Gamma}', 'ℿ'),
    ('\\mathbb{\\pi}', 'ℼ'),
    ('\\mathbb{\\Pi}', 'ℾ'),
    ('\\mathbb{\\Sigma}', '⅀'),
    ('\\mathbb{A}', '𝔸'),
    ('\\mathbb{a}', '𝕒'),
    ('\\mathbb{B}', '𝔹'),
    ('\\mathbb{b}', '𝕓'),
    ('\\mathbb{C}', 'ℂ'),
    ('\\mathbb{c}', '𝕔'),
    ('\\mathbb{D}', '𝔻'),
    ('\\mathbb{d}', '𝕕'),
    ('\\mathbb{E}', '𝔼'),
    ('\\mathbb{e}', '𝕖'),
    ('\\mathbb{F}', '𝔽'),
    ('\\mathbb{f}', '𝕗'),
    ('\\mathbb{G}', '𝔾'),
    ('\\mathbb{g}', '𝕘'),
    ('\\mathbb{H}', 'ℍ'),
    ('\\mathbb{h}', '𝕙'),
    ('\\mathbb{I}', '𝕀'),
    ('\\mathbb{i}', '𝕚'),
    ('\\mathbb{J}', '𝕁'),
    ('\\mathbb{j}', '𝕛'),
    ('\\mathbb{K}', '𝕂'),
    ('\\mathbb{k}', '𝕜'),
    ('\\mathbb{L}', '𝕃'),
    ('\\mathbb{l}', '𝕝'),
    ('\\mathbb{M}', '𝕄'),
    ('\\mathbb{m}', '𝕞'),
    ('\\mathbb{N}', 'ℕ'),
    ('\\mathbb{n}', '𝕟'),
    ('\\mathbb{O}', '𝕆'),
    ('\\mathbb{o}', '𝕠'),
    ('\\mathbb{P}', 'ℙ'),
    ('\\mathbb{p}', '𝕡'),
    ('\\mathbb{Q}', 'ℚ'),
    ('\\mathbb{q}', '𝕢'),
    ('\\mathbb{R}', 'ℝ'),
    ('\\mathbb{r}', '𝕣'),
    ('\\mathbb{S}', '𝕊'),
    ('\\mathbb{s}', '𝕤'),
    ('\\mathbb{T}', '𝕋'),
    ('\\mathbb{t}', '𝕥'),
    ('\\mathbb{U}', '𝕌'),
    ('\\mathbb{u}', '𝕦'),
    ('\\mathbb{V}', '𝕍'),
    ('\\mathbb{v}', '𝕧'),
    ('\\mathbb{W}', '𝕎'),
    ('\\mathbb{w}', '𝕨'),
    ('\\mathbb{X}', '𝕏'),
    ('\\mathbb{x}', '𝕩'),
    ('\\mathbb{Y}', '𝕐'),
    ('\\mathbb{y}', '𝕪'),
    ('\\mathbb{Z}', 'ℤ'),
    ('\\mathbb{z}', '𝕫'),
    ('\\mathcal g', 'ℊ'),
    ('\\mathfrak C', 'ℭ'),
    ('\\mathfrak H', 'ℌ'),
    ('\\mathfrak Z', 'ℨ'),
    ('\\mathring{\\mathrm A}', 'Å'),
    ('\\mathrm K', 'K'),
    ('\\mathrm{d}', 'ⅆ'),
    ('\\mathrsfs B', 'ℬ'),
    ('\\mathrsfs e', 'ℯ'),
    ('\\mathrsfs E', 'ℰ'),
    ('\\mathrsfs F', 'ℱ'),
    ('\\mathrsfs H', 'ℋ'),
    ('\\mathrsfs I', 'ℐ'),
    ('\\mathrsfs L', 'ℒ'),
    ('\\measuredangle', '∡'),
    ('\\mho', '℧'),
    ('\\mid', '∣'),
    ('\\models', '⊧'),
    ('\\mp', '∓'),
    ('\\mu', 'μ'),
    ('\\multimap', '⊸'),
    ('\\nabla', '∇'),
    ('\\natural', '♮'),
    ('\\ncong', '≇'),
    ('\\ne', '≠'),
    ('\\nearrow', '↗'),
    ('\\neg', '¬'),
    ('\\nexist', '∄'),
    ('\\ngeq', '≱'),
    ('\\ngtr', '≯'),
    ('\\ni', '∋'),
    ('\\nleftarrow', '↚'),
    ('\\nLeftarrow', '⇍'),
    ('\\nleftrightarrow', '↮'),
    ('\\nLeftrightarrow', '⇎'),
    ('\\nleq', '≰'),
    ('\\nless', '≮'),
    ('\\nmid', '∤'),
    ('\\not\\approx', '≉'),
    ('\\not\\asymp', '≭'),
    ('\\not\\equiv', '≢'),
    ('\\not\\gtrless', '≹'),
    ('\\not\\gtrsim', '≵'),
    ('\\not\\lessgtr', '≸'),
    ('\\not\\lesssim', '≴'),
    ('\\not\\preceq', '⋠'),
    ('\\not\\simeq', '≄'),
    ('\\not\\sqsubseteq', '⋢'),
    ('\\not\\sqsupseteq', '⋣'),
    ('\\not\\subset', '⊄'),
    ('\\not\\succeq', '⋡'),
    ('\\not\\supset', '⊅'),
    ('\\not\\triangleleft', '⋪'),
    ('\\not\\trianglelefteq', '⋬'),
    ('\\not\\triangleright', '⋫'),
    ('\\not\\trianglerighteq', '⋭'),
    ('\\not\\vdash', '⊬'),
    ('\\not\\vDash', '⊭'),
    ('\\not\\Vdash', '⊮'),
    ('\\not\\VDash', '⊯'),
    ('\\notin', '∉'),
    ('\\notni', '∌'),
    ('\\nparallel', '∦'),
    ('\\nprec', '⊀'),
    ('\\nrightarrow', '↛'),
    ('\\nRightarrow', '⇏'),
    ('\\nsim', '≁'),
    ('\\nsubseteq', '⊈'),
    ('\\nsucc', '⊁'),
    ('\\nsupseteq', '⊉'),
    ('\\nu', 'ν'),
    ('\\nwarrow', '↖'),
    ('\\odot', '⊙'),
    ('\\oiiint', '∰'),
    ('\\oiint', '∯'),
    ('\\oiintctrclockwise', '∳'),
    ('\\oint', '∮'),
    ('\\ointclockwise', '∲'),
    ('\\Omega', 'Ω'),
    ('\\omega', 'ω'),
    ('\\ominus', '⊖'),
    ('\\oplus', '⊕'),
    ('\\oslash', '⊘'),
    ('\\otimes', '⊗'),
    ('\\overline{0}', '‾'),
    ('\\parallel', '∥'),
    ('\\partial', '∂'),
    ('\\perp', '⟂'),
    ('\\Phi', 'Φ'),
    ('\\phi', 'φ'),
    ('\\Pi', 'Π'),
    ('\\pi', 'π'),
    ('\\pitchfork', '⋔'),
    ('\\pm', '±'),
    ('\\pounds', '£'),
    ('\\prec', '≺'),
    ('\\preccurlyeq', '≼'),
    ('\\precnsim', '⋨'),
    ('\\precsim', '≾'),
    ('\\prime', '′'),
    ('\\prod', '∏'),
    ('\\Proportion', '∷'),
    ('\\propto', '∝'),
    ('\\Psi', 'Ψ'),
    ('\\psi', 'ψ'),
    ('\\Qoppa', 'Ϙ'),
    ('\\qoppa', 'ϙ'),
    ('\\quotedblbase', '„'),
    ('\\quotesinglbase', '‚'),
    ('\\rangle', '〉'),
    ('\\rceil', '⌉'),
    ('\\Re', 'ℜ'),
    ('\\rfloor', '⌋'),
    ('\\RHD', '‣'),
    ('\\rho', 'ρ'),
    ('\\rightarrow', '→'),
    ('\\Rightarrow', '⇒'),
    ('\\RightArrowBar', '⇥'),
    ('\\rightarrowtail', '↣'),
    ('\\rightarrowtriangle', '⇾'),
    ('\\rightharpoondown', '⇁'),
    ('\\rightharpoonup', '⇀'),
    ('\\rightleftarrows', '⇄'),
    ('\\rightleftharpoons', '⇌'),
    ('\\rightrightarrows', '⇉'),
    ('\\rightsquigarrow', '⇝'),
    ('\\rightthreetimes', '⋌'),
    ('\\risingdotseq', '≓'),
    ('\\rrangle', '⟫'),
    ('\\rrbracket', '〛'),
    ('\\Rrightarrow', '⇛'),
    ('\\Rsh', '↱'),
    ('\\rtimes', '⋊'),
    ('\\Sampi', 'Ϡ'),
    ('\\sampi', 'ϡ'),
    ('\\searrow', '↘'),
    ('\\second', '″'),
    ('\\sharp', '♯'),
    ('\\Sigma', 'Σ'),
    ('\\sigma', 'σ'),
    ('\\sim', '∼'),
    ('\\simeq', '≃'),
    ('\\smallsetminus', '∖'),
    ('\\smile', '⌣'),
    ('\\smiley', '☺'),
    ('\\spadesuit', '♠'),
    ('\\sphericalangle', '∢'),
    ('\\sqbullet', '∍'),
    ('\\sqcap', '⊓'),
    ('\\sqcup', '⊔'),
    ('\\sqrt[3]{}', '∛'),
    ('\\sqrt[4]{}', '∜'),
    ('\\sqrt{}', '√'),
    ('\\sqsubset', '⊏'),
    ('\\sqsubseteq', '⊑'),
    ('\\sqsubsetneq', '⋤'),
    ('\\sqsupset', '⊐'),
    ('\\sqsupseteq', '⊒'),
    ('\\sqsupsetneq', '⋥'),
    ('\\square', '□'),
    ('\\stackrel{=}{=}', '≣'),
    ('\\stackrel{\\frown}{=}', '≘'),
    ('\\stackrel{\\star}{=}', '≛'),
    ('\\stackrel{\\text{\\tiny ?}}{=}', '≟'),
    ('\\stackrel{\\text{\\tiny def}}{=}', '≝'),
    ('\\stackrel{\\vee}{=}', '≚'),
    ('\\stackrel{\\wedge}{=}', '≙'),
    ('\\star', '∗'),
    ('\\Stigma', 'Ϛ'),
    ('\\stigma', 'ϛ'),
    ('\\subset', '⊂'),
    ('\\Subset', '⋐'),
    ('\\subseteq', '⊆'),
    ('\\subsetneq', '⊊'),
    ('\\succ', '≻'),
    ('\\succccurlyeq', '≽'),
    ('\\succnsim', '⋩'),
    ('\\succsim', '≿'),
    ('\\sum', '∑'),
    ('\\supset', '⊃'),
    ('\\Supset', '⋑'),
    ('\\supseteq', '⊇'),
    ('\\supsetneq', '⊋'),
    ('\\swarrow', '↙'),
    ('\\tau', 'τ'),
    ('\\textasciimacron', '¯'),
    ('\\textbardbl', '‖'),
    ('\\textbrokenbar', '¦'),
    ('\\textcent', '¢'),
    ('\\textcurrency', '¤'),
    ('\\textdiscount', '⁒'),
    ('\\textestimated', '℮'),
    ('\\textexclamdown', '¡'),
    ('\\textinterrobang', '‽'),
    ('\\textinterrobangdown', '⸘'),
    ('\\textlquill', '⁅'),
    ('\\textmu', 'µ'),
    ('\\textordfeminine', 'ª'),
    ('\\textordmasculine', 'º'),
    ('\\textpertenthousand', '‱'),
    ('\\textperthousand', '‰'),
    ('\\textquestiondown', '¿'),
    ('\\textquotedblleft', '“'),
    ('\\textquotedblright', '”'),
    ('\\textquoteleft', '‘'),
    ('\\textquoteright', '’'),
    ('\\textreferencemark', '※'),
    ('\\textregistered', '®'),
    ('\\textrquill', '⁆'),
    ('\\textsuperscript{1}', '¹'),
    ('\\textsuperscript{2}', '²'),
    ('\\textsuperscript{3}', '³'),
    ('\\textsuperscript{o}', '°'),
    ('\\texttrademark', '™'),
    ('\\textyen', '¥'),
    ('\\therefore', '∴'),
    ('\\Theta', 'Θ'),
    ('\\theta', 'θ'),
    ('\\third', '‴'),
    ('\\times', '×'),
    ('\\top', '⊤'),
    ('\\triangle', '△'),
    ('\\triangleleft', '⊲'),
    ('\\triangleq', '≜'),
    ('\\triangleright', '⊳'),
    ('\\twoheadleftarrow', '↞'),
    ('\\twoheadrightarrow', '↠'),
    ('\\unlhd', '⊴'),
    ('\\unrhd', '⊵'),
    ('\\uparrow', '↑'),
    ('\\Uparrow', '⇑'),
    ('\\updownarrow', '↕'),
    ('\\Updownarrow', '⇕'),
    ('\\updownarrows', '⇅'),
    ('\\upharpoonleft', '↿'),
    ('\\upharpoonright', '↾'),
    ('\\uplus', '⊎'),
    ('\\Upsilon', 'Υ'),
    ('\\upsilon', 'υ'),
    ('\\upuparrows', '⇈'),
    ('\\varepsilon', 'ε'),
    ('\\varkappa', 'ϰ'),
    ('\\varnothing', '∅'),
    ('\\varsigma', 'ς'),
    ('\\vdash', '⊢'),
    ('\\Vdash', '⊩'),
    ('\\VDash', '⊫'),
    ('\\vdots', '⋮'),
    ('\\vee', '∨'),
    ('\\veebar', '⊻'),
    ('\\Vvdash', '⊪'),
    ('\\wedge', '∧'),
    ('\\wp', '℘'),
    ('\\wr', '≀'),
    ('\\Xi', 'Ξ'),
    ('\\xi', 'ξ'),
    ('\\Yup', '⅄'),
    ('\\zeta', 'ζ')
]
