# coding: utf-8

"""
    SYSNET RUIAN services API

    SYSNET RÚIAN service REST API  # noqa: E501

    OpenAPI spec version: 1.0.2
    Contact: info@sysnet.cz
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ruian.api_client import ApiClient


class PublicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def compile_address_api(self, **kwargs):  # noqa: E501
        """compile adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addreses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: query by form
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.compile_address_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.compile_address_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def compile_address_api_with_http_info(self, **kwargs):  # noqa: E501
        """compile adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addreses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: query by form
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compile_address_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/compile/address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def compile_address_ft_api(self, query, **kwargs):  # noqa: E501
        """compile adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addreses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_ft_api(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: Search query (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.compile_address_ft_api_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.compile_address_ft_api_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def compile_address_ft_api_with_http_info(self, query, **kwargs):  # noqa: E501
        """compile adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addreses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_ft_api_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: Search query (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compile_address_ft_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `compile_address_ft_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/compile/address', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def compile_address_id_api(self, id, **kwargs):  # noqa: E501
        """compile adresses by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addres   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.compile_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.compile_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def compile_address_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """compile adresses by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain formatted addres   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.compile_address_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compile_address_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `compile_address_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/compile/address/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_point_jtsk_api(self, lat, lon, **kwargs):  # noqa: E501
        """converts one point from WGS-84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_jtsk_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: PointJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_point_jtsk_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_point_jtsk_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def convert_point_jtsk_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """converts one point from WGS-84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_jtsk_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: PointJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_point_jtsk_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `convert_point_jtsk_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `convert_point_jtsk_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/point/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PointJtsk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_point_jtsk_post_api(self, **kwargs):  # noqa: E501
        """converts one point from WGS-84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_jtsk_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: PointJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_point_jtsk_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.convert_point_jtsk_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def convert_point_jtsk_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """converts one point from WGS-84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_jtsk_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: PointJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_point_jtsk_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/point/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PointJtsk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_point_wgs_api(self, x, y, **kwargs):  # noqa: E501
        """converts one point from JTSK to WGS-84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_wgs_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: PointWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_point_wgs_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_point_wgs_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def convert_point_wgs_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """converts one point from JTSK to WGS-84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_wgs_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: PointWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_point_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `convert_point_wgs_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `convert_point_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/point/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PointWgs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_point_wgs_post_api(self, **kwargs):  # noqa: E501
        """converts one point from JTSK to WGS-84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: PointWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_point_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.convert_point_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def convert_point_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """converts one point from JTSK to WGS-84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_point_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: PointWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_point_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/point/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PointWgs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_polygon_jtsk_api(self, **kwargs):  # noqa: E501
        """converts polygon from WGS84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_polygon_jtsk_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PolygonWgs body:
        :return: PolygonJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_polygon_jtsk_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.convert_polygon_jtsk_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def convert_polygon_jtsk_api_with_http_info(self, **kwargs):  # noqa: E501
        """converts polygon from WGS84 to JTSK  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_polygon_jtsk_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PolygonWgs body:
        :return: PolygonJtsk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_polygon_jtsk_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/polygon/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PolygonJtsk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_polygon_wgs_api(self, **kwargs):  # noqa: E501
        """converts polygon from JTSK to WGS84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_polygon_wgs_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PolygonJtsk body:
        :return: PolygonWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_polygon_wgs_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.convert_polygon_wgs_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def convert_polygon_wgs_api_with_http_info(self, **kwargs):  # noqa: E501
        """converts polygon from JTSK to WGS84  # noqa: E501

        By passing in the appropriate options, you can obtain converted value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_polygon_wgs_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PolygonJtsk body:
        :return: PolygonWgs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_polygon_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/polygon/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PolygonWgs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address_id_api(self, id, **kwargs):  # noqa: E501
        """get addres point full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain addres point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: FullAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_address_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """get addres point full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain addres point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: FullAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_address_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/address/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FullAddress',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ku_id_api(self, id, **kwargs):  # noqa: E501
        """get cadastral territory full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ku_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: cadastral territory identifier (required)
        :return: FullCadaster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ku_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ku_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_ku_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """get cadastral territory full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ku_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: cadastral territory identifier (required)
        :return: FullCadaster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ku_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ku_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cadaster/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FullCadaster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zsj_id_api(self, id, **kwargs):  # noqa: E501
        """get basic settlement unit full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zsj_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: basic settlement unit identifier (required)
        :return: FullSettlement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zsj_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zsj_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_zsj_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """get basic settlement unit full info by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zsj_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: basic settlement unit identifier (required)
        :return: FullSettlement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zsj_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_zsj_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/settlement/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FullSettlement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ku_api(self, x, y, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ku_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.ku_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def ku_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ku_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `ku_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `ku_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/cadaster/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KatastralniUzemi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ku_post_api(self, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ku_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ku_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def ku_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the cadastral territory   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ku_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/cadaster/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KatastralniUzemi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ku_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ku_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.ku_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def ku_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ku_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `ku_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `ku_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/cadaster/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KatastralniUzemi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ku_wgs_post_api(self, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ku_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ku_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def ku_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find cadastral territory by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ku_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: KatastralniUzemi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ku_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/cadaster/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KatastralniUzemi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mapy50_api(self, x, y, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mapy50_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.mapy50_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def mapy50_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mapy50_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `mapy50_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `mapy50_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/sheet50/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapovyList50',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mapy50_post_api(self, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mapy50_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.mapy50_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def mapy50_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mapy50_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/sheet50/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapovyList50',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mapy50_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mapy50_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.mapy50_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def mapy50_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mapy50_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `mapy50_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `mapy50_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/sheet50/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapovyList50',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mapy50_wgs_post_api(self, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mapy50_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.mapy50_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def mapy50_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find map sheets layout by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the map sheets layout   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mapy50_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: MapovyList50
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mapy50_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/sheet50/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapovyList50',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def nearby_address_api(self, x, y, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.nearby_address_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.nearby_address_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def nearby_address_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method nearby_address_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `nearby_address_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `nearby_address_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/nearby/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NearbyAddress]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def nearby_address_post_api(self, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.nearby_address_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.nearby_address_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def nearby_address_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method nearby_address_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/nearby/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NearbyAddress]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def nearby_address_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.nearby_address_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.nearby_address_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def nearby_address_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method nearby_address_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `nearby_address_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `nearby_address_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/nearby/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NearbyAddress]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def nearby_address_wgs_post_api(self, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.nearby_address_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.nearby_address_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def nearby_address_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find nearby adresses by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the nearby adresses   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.nearby_address_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: list[NearbyAddress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method nearby_address_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/nearby/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NearbyAddress]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def parcela_api(self, x, y, **kwargs):  # noqa: E501
        """find land parcel by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.parcela_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.parcela_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def parcela_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find land parcel by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method parcela_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `parcela_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `parcela_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/parcel/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Parcela',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def parcela_post_api(self, **kwargs):  # noqa: E501
        """find plot (of land) by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Jtsk body: JTSK coordinates
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.parcela_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.parcela_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def parcela_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find plot (of land) by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Jtsk body: JTSK coordinates
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method parcela_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/parcel/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Parcela',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def parcela_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find land parcel by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.parcela_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.parcela_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def parcela_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find land parcel by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method parcela_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `parcela_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `parcela_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/parcel/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Parcela',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def parcela_wgs_post_api(self, **kwargs):  # noqa: E501
        """find plot (of land) by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Wgs body: WGS coordinates
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.parcela_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.parcela_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def parcela_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find plot (of land) by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the plot of land   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.parcela_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Wgs body: WGS coordinates
        :return: Parcela
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method parcela_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/parcel/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Parcela',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def povodi_api(self, x, y, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.povodi_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.povodi_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def povodi_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method povodi_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `povodi_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `povodi_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/basin/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Povodi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def povodi_post_api(self, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.povodi_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.povodi_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def povodi_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method povodi_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/basin/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Povodi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def povodi_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.povodi_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.povodi_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def povodi_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method povodi_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `povodi_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `povodi_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/basin/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Povodi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def povodi_wgs_post_api(self, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.povodi_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.povodi_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def povodi_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find basin info by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basin info   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.povodi_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: Povodi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method povodi_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/basin/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Povodi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_address_api(self, **kwargs):  # noqa: E501
        """search adresses by structured query  # noqa: E501

        By passing in the appropriate options, you can obtain search results   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: query by form
        :return: list[Address]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_address_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_address_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_address_api_with_http_info(self, **kwargs):  # noqa: E501
        """search adresses by structured query  # noqa: E501

        By passing in the appropriate options, you can obtain search results   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: query by form
        :return: list[Address]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_address_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/search/address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Address]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_address_ft_api(self, query, **kwargs):  # noqa: E501
        """search adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain search results   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_ft_api(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: Search query (required)
        :return: list[Address]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_address_ft_api_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_address_ft_api_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_address_ft_api_with_http_info(self, query, **kwargs):  # noqa: E501
        """search adresses by query  # noqa: E501

        By passing in the appropriate options, you can obtain search results   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_ft_api_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: Search query (required)
        :return: list[Address]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_address_ft_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_address_ft_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/search/address', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Address]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_address_id_api(self, id, **kwargs):  # noqa: E501
        """seach address by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain addres point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: Address
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.search_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def search_address_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """seach address by identifier  # noqa: E501

        By passing in the appropriate options, you can obtain addres point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_address_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: Address
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_address_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `search_address_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/search/address/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Address',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_address_id_api(self, id, **kwargs):  # noqa: E501
        """validate adresses by identifier  # noqa: E501

        By passing in the appropriate options, you can validate address point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_address_id_api(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_address_id_api_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def validate_address_id_api_with_http_info(self, id, **kwargs):  # noqa: E501
        """validate adresses by identifier  # noqa: E501

        By passing in the appropriate options, you can validate address point   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_address_id_api_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Address point identifier (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_address_id_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `validate_address_id_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/validate/address/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zsj_api(self, x, y, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_api(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zsj_api_with_http_info(x, y, **kwargs)  # noqa: E501
        else:
            (data) = self.zsj_api_with_http_info(x, y, **kwargs)  # noqa: E501
            return data

    def zsj_api_with_http_info(self, x, y, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_api_with_http_info(x, y, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float x: JTSK x coordinate (required)
        :param float y: JTSK y coordinate (required)
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zsj_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `zsj_api`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `zsj_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'x' in params:
            query_params.append(('x', params['x']))  # noqa: E501
        if 'y' in params:
            query_params.append(('y', params['y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/settlement/jtsk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zsj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zsj_post_api(self, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zsj_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.zsj_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def zsj_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointJtsk body:
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zsj_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/settlement/jtsk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zsj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zsj_wgs_api(self, lat, lon, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_wgs_api(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zsj_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
        else:
            (data) = self.zsj_wgs_api_with_http_info(lat, lon, **kwargs)  # noqa: E501
            return data

    def zsj_wgs_api_with_http_info(self, lat, lon, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_wgs_api_with_http_info(lat, lon, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lat: WGS-84 lat coordinate (required)
        :param str lon: WGS-84 lon coordinate (required)
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lat', 'lon']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zsj_wgs_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lat' is set
        if ('lat' not in params or
                params['lat'] is None):
            raise ValueError("Missing the required parameter `lat` when calling `zsj_wgs_api`")  # noqa: E501
        # verify the required parameter 'lon' is set
        if ('lon' not in params or
                params['lon'] is None):
            raise ValueError("Missing the required parameter `lon` when calling `zsj_wgs_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lat' in params:
            query_params.append(('lat', params['lat']))  # noqa: E501
        if 'lon' in params:
            query_params.append(('lon', params['lon']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/settlement/wgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zsj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zsj_wgs_post_api(self, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_wgs_post_api(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zsj_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.zsj_wgs_post_api_with_http_info(**kwargs)  # noqa: E501
            return data

    def zsj_wgs_post_api_with_http_info(self, **kwargs):  # noqa: E501
        """find basic settlement unit by coordinates  # noqa: E501

        By passing in the appropriate options, you can search for the basic settlement unit   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zsj_wgs_post_api_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PointWgs body:
        :return: Zsj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zsj_wgs_post_api" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reverse/settlement/wgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zsj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
