# RÚIAN service client
SYSNET RÚIAN service REST API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.2
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import ruian 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import ruian
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import ruian
from ruian.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = ruian.DevelopersApi(ruian.ApiClient(configuration))

try:
    # get service info
    api_response = api_instance.info_api()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopersApi->info_api: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://service.sysnet.cz/sysnetcz/RUIAN/1.0.2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DevelopersApi* | [**info_api**](docs/DevelopersApi.md#info_api) | **GET** /info | get service info
*PublicApi* | [**compile_address_api**](docs/PublicApi.md#compile_address_api) | **POST** /compile/address | compile adresses by query
*PublicApi* | [**compile_address_ft_api**](docs/PublicApi.md#compile_address_ft_api) | **GET** /compile/address | compile adresses by query
*PublicApi* | [**compile_address_id_api**](docs/PublicApi.md#compile_address_id_api) | **GET** /compile/address/{id} | compile adresses by identifier
*PublicApi* | [**convert_point_jtsk_api**](docs/PublicApi.md#convert_point_jtsk_api) | **GET** /convert/point/jtsk | converts one point from WGS-84 to JTSK
*PublicApi* | [**convert_point_jtsk_post_api**](docs/PublicApi.md#convert_point_jtsk_post_api) | **POST** /convert/point/jtsk | converts one point from WGS-84 to JTSK
*PublicApi* | [**convert_point_wgs_api**](docs/PublicApi.md#convert_point_wgs_api) | **GET** /convert/point/wgs | converts one point from JTSK to WGS-84
*PublicApi* | [**convert_point_wgs_post_api**](docs/PublicApi.md#convert_point_wgs_post_api) | **POST** /convert/point/wgs | converts one point from JTSK to WGS-84
*PublicApi* | [**convert_polygon_jtsk_api**](docs/PublicApi.md#convert_polygon_jtsk_api) | **POST** /convert/polygon/jtsk | converts polygon from WGS84 to JTSK
*PublicApi* | [**convert_polygon_wgs_api**](docs/PublicApi.md#convert_polygon_wgs_api) | **POST** /convert/polygon/wgs | converts polygon from JTSK to WGS84
*PublicApi* | [**get_address_id_api**](docs/PublicApi.md#get_address_id_api) | **GET** /address/{id} | get addres point full info by identifier
*PublicApi* | [**get_ku_id_api**](docs/PublicApi.md#get_ku_id_api) | **GET** /cadaster/{id} | get cadastral territory full info by identifier
*PublicApi* | [**get_zsj_id_api**](docs/PublicApi.md#get_zsj_id_api) | **GET** /settlement/{id} | get basic settlement unit full info by identifier
*PublicApi* | [**ku_api**](docs/PublicApi.md#ku_api) | **GET** /reverse/cadaster/jtsk | find cadastral territory by coordinates
*PublicApi* | [**ku_post_api**](docs/PublicApi.md#ku_post_api) | **POST** /reverse/cadaster/jtsk | find cadastral territory by coordinates
*PublicApi* | [**ku_wgs_api**](docs/PublicApi.md#ku_wgs_api) | **GET** /reverse/cadaster/wgs | find cadastral territory by coordinates
*PublicApi* | [**ku_wgs_post_api**](docs/PublicApi.md#ku_wgs_post_api) | **POST** /reverse/cadaster/wgs | find cadastral territory by coordinates
*PublicApi* | [**mapy50_api**](docs/PublicApi.md#mapy50_api) | **GET** /reverse/sheet50/jtsk | find map sheets layout by coordinates
*PublicApi* | [**mapy50_post_api**](docs/PublicApi.md#mapy50_post_api) | **POST** /reverse/sheet50/jtsk | find map sheets layout by coordinates
*PublicApi* | [**mapy50_wgs_api**](docs/PublicApi.md#mapy50_wgs_api) | **GET** /reverse/sheet50/wgs | find map sheets layout by coordinates
*PublicApi* | [**mapy50_wgs_post_api**](docs/PublicApi.md#mapy50_wgs_post_api) | **POST** /reverse/sheet50/wgs | find map sheets layout by coordinates
*PublicApi* | [**nearby_address_api**](docs/PublicApi.md#nearby_address_api) | **GET** /reverse/nearby/jtsk | find nearby adresses by coordinates
*PublicApi* | [**nearby_address_post_api**](docs/PublicApi.md#nearby_address_post_api) | **POST** /reverse/nearby/jtsk | find nearby adresses by coordinates
*PublicApi* | [**nearby_address_wgs_api**](docs/PublicApi.md#nearby_address_wgs_api) | **GET** /reverse/nearby/wgs | find nearby adresses by coordinates
*PublicApi* | [**nearby_address_wgs_post_api**](docs/PublicApi.md#nearby_address_wgs_post_api) | **POST** /reverse/nearby/wgs | find nearby adresses by coordinates
*PublicApi* | [**parcela_api**](docs/PublicApi.md#parcela_api) | **GET** /reverse/parcel/jtsk | find land parcel by coordinates
*PublicApi* | [**parcela_post_api**](docs/PublicApi.md#parcela_post_api) | **POST** /reverse/parcel/jtsk | find plot (of land) by coordinates
*PublicApi* | [**parcela_wgs_api**](docs/PublicApi.md#parcela_wgs_api) | **GET** /reverse/parcel/wgs | find land parcel by coordinates
*PublicApi* | [**parcela_wgs_post_api**](docs/PublicApi.md#parcela_wgs_post_api) | **POST** /reverse/parcel/wgs | find plot (of land) by coordinates
*PublicApi* | [**povodi_api**](docs/PublicApi.md#povodi_api) | **GET** /reverse/basin/jtsk | find basin info by coordinates
*PublicApi* | [**povodi_post_api**](docs/PublicApi.md#povodi_post_api) | **POST** /reverse/basin/jtsk | find basin info by coordinates
*PublicApi* | [**povodi_wgs_api**](docs/PublicApi.md#povodi_wgs_api) | **GET** /reverse/basin/wgs | find basin info by coordinates
*PublicApi* | [**povodi_wgs_post_api**](docs/PublicApi.md#povodi_wgs_post_api) | **POST** /reverse/basin/wgs | find basin info by coordinates
*PublicApi* | [**search_address_api**](docs/PublicApi.md#search_address_api) | **POST** /search/address | search adresses by structured query
*PublicApi* | [**search_address_ft_api**](docs/PublicApi.md#search_address_ft_api) | **GET** /search/address | search adresses by query
*PublicApi* | [**search_address_id_api**](docs/PublicApi.md#search_address_id_api) | **GET** /search/address/{id} | seach address by identifier
*PublicApi* | [**validate_address_id_api**](docs/PublicApi.md#validate_address_id_api) | **GET** /validate/address/{id} | validate adresses by identifier
*PublicApi* | [**zsj_api**](docs/PublicApi.md#zsj_api) | **GET** /reverse/settlement/jtsk | find basic settlement unit by coordinates
*PublicApi* | [**zsj_post_api**](docs/PublicApi.md#zsj_post_api) | **POST** /reverse/settlement/jtsk | find basic settlement unit by coordinates
*PublicApi* | [**zsj_wgs_api**](docs/PublicApi.md#zsj_wgs_api) | **GET** /reverse/settlement/wgs | find basic settlement unit by coordinates
*PublicApi* | [**zsj_wgs_post_api**](docs/PublicApi.md#zsj_wgs_post_api) | **POST** /reverse/settlement/wgs | find basic settlement unit by coordinates

## Documentation For Models

 - [Address](docs/Address.md)
 - [AdministrativeDivision](docs/AdministrativeDivision.md)
 - [CadastralTerritory](docs/CadastralTerritory.md)
 - [Coordinates](docs/Coordinates.md)
 - [FullAddress](docs/FullAddress.md)
 - [FullCadaster](docs/FullCadaster.md)
 - [FullSettlement](docs/FullSettlement.md)
 - [Jtsk](docs/Jtsk.md)
 - [KatastralniUzemi](docs/KatastralniUzemi.md)
 - [MapovyList50](docs/MapovyList50.md)
 - [NearbyAddress](docs/NearbyAddress.md)
 - [Parcela](docs/Parcela.md)
 - [PointJtsk](docs/PointJtsk.md)
 - [PointWgs](docs/PointWgs.md)
 - [PolygonJtsk](docs/PolygonJtsk.md)
 - [PolygonWgs](docs/PolygonWgs.md)
 - [Povodi](docs/Povodi.md)
 - [Settlement](docs/Settlement.md)
 - [Wgs](docs/Wgs.md)
 - [Zsj](docs/Zsj.md)

## Documentation For Authorization


## apiKey

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

info@sysnet.cz
