# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TeamArgs', 'Team']

@pulumi.input_type
class TeamArgs:
    def __init__(__self__, *,
                 copy_cc: pulumi.Input[bool],
                 team_members: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 team_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a Team resource.
        :param pulumi.Input[bool] copy_cc: Whether Credit Card is copied
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] team_members: Members of the team. (Owner must be specified, which is the owner of the api key.)
        :param pulumi.Input[str] team_name: Name of the team
        """
        pulumi.set(__self__, "copy_cc", copy_cc)
        pulumi.set(__self__, "team_members", team_members)
        pulumi.set(__self__, "team_name", team_name)

    @property
    @pulumi.getter(name="copyCc")
    def copy_cc(self) -> pulumi.Input[bool]:
        """
        Whether Credit Card is copied
        """
        return pulumi.get(self, "copy_cc")

    @copy_cc.setter
    def copy_cc(self, value: pulumi.Input[bool]):
        pulumi.set(self, "copy_cc", value)

    @property
    @pulumi.getter(name="teamMembers")
    def team_members(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Members of the team. (Owner must be specified, which is the owner of the api key.)
        """
        return pulumi.get(self, "team_members")

    @team_members.setter
    def team_members(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "team_members", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> pulumi.Input[str]:
        """
        Name of the team
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "team_name", value)


@pulumi.input_type
class _TeamState:
    def __init__(__self__, *,
                 copy_cc: Optional[pulumi.Input[bool]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 team_members: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Team resources.
        :param pulumi.Input[bool] copy_cc: Whether Credit Card is copied
        :param pulumi.Input[str] team_id: Unique Cluster ID for created cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] team_members: Members of the team. (Owner must be specified, which is the owner of the api key.)
        :param pulumi.Input[str] team_name: Name of the team
        """
        if copy_cc is not None:
            pulumi.set(__self__, "copy_cc", copy_cc)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if team_members is not None:
            pulumi.set(__self__, "team_members", team_members)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)

    @property
    @pulumi.getter(name="copyCc")
    def copy_cc(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Credit Card is copied
        """
        return pulumi.get(self, "copy_cc")

    @copy_cc.setter
    def copy_cc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_cc", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Cluster ID for created cluster
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="teamMembers")
    def team_members(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Members of the team. (Owner must be specified, which is the owner of the api key.)
        """
        return pulumi.get(self, "team_members")

    @team_members.setter
    def team_members(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "team_members", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the team
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_name", value)


class Team(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_cc: Optional[pulumi.Input[bool]] = None,
                 team_members: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_team = upstash.Team("exampleTeam",
            team_name="TerraformTeam",
            copy_cc=False,
            team_members={
                "X@Y.Z": "owner",
                "A@B.C": "dev",
                "E@E.F": "finance",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] copy_cc: Whether Credit Card is copied
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] team_members: Members of the team. (Owner must be specified, which is the owner of the api key.)
        :param pulumi.Input[str] team_name: Name of the team
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_team = upstash.Team("exampleTeam",
            team_name="TerraformTeam",
            copy_cc=False,
            team_members={
                "X@Y.Z": "owner",
                "A@B.C": "dev",
                "E@E.F": "finance",
            })
        ```

        :param str resource_name: The name of the resource.
        :param TeamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_cc: Optional[pulumi.Input[bool]] = None,
                 team_members: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamArgs.__new__(TeamArgs)

            if copy_cc is None and not opts.urn:
                raise TypeError("Missing required property 'copy_cc'")
            __props__.__dict__["copy_cc"] = copy_cc
            if team_members is None and not opts.urn:
                raise TypeError("Missing required property 'team_members'")
            __props__.__dict__["team_members"] = team_members
            if team_name is None and not opts.urn:
                raise TypeError("Missing required property 'team_name'")
            __props__.__dict__["team_name"] = team_name
            __props__.__dict__["team_id"] = None
        super(Team, __self__).__init__(
            'upstash:index/team:Team',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            copy_cc: Optional[pulumi.Input[bool]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            team_members: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            team_name: Optional[pulumi.Input[str]] = None) -> 'Team':
        """
        Get an existing Team resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] copy_cc: Whether Credit Card is copied
        :param pulumi.Input[str] team_id: Unique Cluster ID for created cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] team_members: Members of the team. (Owner must be specified, which is the owner of the api key.)
        :param pulumi.Input[str] team_name: Name of the team
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamState.__new__(_TeamState)

        __props__.__dict__["copy_cc"] = copy_cc
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["team_members"] = team_members
        __props__.__dict__["team_name"] = team_name
        return Team(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="copyCc")
    def copy_cc(self) -> pulumi.Output[bool]:
        """
        Whether Credit Card is copied
        """
        return pulumi.get(self, "copy_cc")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        Unique Cluster ID for created cluster
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="teamMembers")
    def team_members(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Members of the team. (Owner must be specified, which is the owner of the api key.)
        """
        return pulumi.get(self, "team_members")

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> pulumi.Output[str]:
        """
        Name of the team
        """
        return pulumi.get(self, "team_name")

