# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['KafkaClusterArgs', 'KafkaCluster']

@pulumi.input_type
class KafkaClusterArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 multizone: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a KafkaCluster resource.
        :param pulumi.Input[str] cluster_name: Name of the cluster
        :param pulumi.Input[str] region: region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        :param pulumi.Input[bool] multizone: Whether cluster has multizone attribute
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "region", region)
        if multizone is not None:
            pulumi.set(__self__, "multizone", multizone)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the cluster
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def multizone(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether cluster has multizone attribute
        """
        return pulumi.get(self, "multizone")

    @multizone.setter
    def multizone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multizone", value)


@pulumi.input_type
class _KafkaClusterState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 max_message_size: Optional[pulumi.Input[int]] = None,
                 max_messages_per_second: Optional[pulumi.Input[int]] = None,
                 max_partitions: Optional[pulumi.Input[int]] = None,
                 max_retention_size: Optional[pulumi.Input[int]] = None,
                 max_retention_time: Optional[pulumi.Input[int]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest_endpoint: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tcp_endpoint: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaCluster resources.
        :param pulumi.Input[str] cluster_id: Unique Cluster ID for created cluster
        :param pulumi.Input[str] cluster_name: Name of the cluster
        :param pulumi.Input[int] creation_time: Creation time of the cluster
        :param pulumi.Input[int] max_message_size: Max Message Size for the cluster
        :param pulumi.Input[int] max_messages_per_second: Max Messages Per Second for the cluster
        :param pulumi.Input[int] max_partitions: Max Partitions for the cluster
        :param pulumi.Input[int] max_retention_size: Max Retention Size of the cluster
        :param pulumi.Input[int] max_retention_time: Max Retention Time of the cluster
        :param pulumi.Input[bool] multizone: Whether cluster has multizone attribute
        :param pulumi.Input[str] password: Password for the cluster
        :param pulumi.Input[str] region: region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        :param pulumi.Input[str] rest_endpoint: REST Endpoint of the cluster
        :param pulumi.Input[str] state: State, where the cluster is originated
        :param pulumi.Input[str] tcp_endpoint: TCP Endpoint of the cluster
        :param pulumi.Input[str] type: Type of the cluster
        :param pulumi.Input[str] username: Base64 encoded username for the cluster
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if max_messages_per_second is not None:
            pulumi.set(__self__, "max_messages_per_second", max_messages_per_second)
        if max_partitions is not None:
            pulumi.set(__self__, "max_partitions", max_partitions)
        if max_retention_size is not None:
            pulumi.set(__self__, "max_retention_size", max_retention_size)
        if max_retention_time is not None:
            pulumi.set(__self__, "max_retention_time", max_retention_time)
        if multizone is not None:
            pulumi.set(__self__, "multizone", multizone)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tcp_endpoint is not None:
            pulumi.set(__self__, "tcp_endpoint", tcp_endpoint)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Cluster ID for created cluster
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cluster
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Creation time of the cluster
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[int]]:
        """
        Max Message Size for the cluster
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_message_size", value)

    @property
    @pulumi.getter(name="maxMessagesPerSecond")
    def max_messages_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Max Messages Per Second for the cluster
        """
        return pulumi.get(self, "max_messages_per_second")

    @max_messages_per_second.setter
    def max_messages_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_messages_per_second", value)

    @property
    @pulumi.getter(name="maxPartitions")
    def max_partitions(self) -> Optional[pulumi.Input[int]]:
        """
        Max Partitions for the cluster
        """
        return pulumi.get(self, "max_partitions")

    @max_partitions.setter
    def max_partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_partitions", value)

    @property
    @pulumi.getter(name="maxRetentionSize")
    def max_retention_size(self) -> Optional[pulumi.Input[int]]:
        """
        Max Retention Size of the cluster
        """
        return pulumi.get(self, "max_retention_size")

    @max_retention_size.setter
    def max_retention_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retention_size", value)

    @property
    @pulumi.getter(name="maxRetentionTime")
    def max_retention_time(self) -> Optional[pulumi.Input[int]]:
        """
        Max Retention Time of the cluster
        """
        return pulumi.get(self, "max_retention_time")

    @max_retention_time.setter
    def max_retention_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retention_time", value)

    @property
    @pulumi.getter
    def multizone(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether cluster has multizone attribute
        """
        return pulumi.get(self, "multizone")

    @multizone.setter
    def multizone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multizone", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the cluster
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        REST Endpoint of the cluster
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rest_endpoint", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State, where the cluster is originated
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tcpEndpoint")
    def tcp_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        TCP Endpoint of the cluster
        """
        return pulumi.get(self, "tcp_endpoint")

    @tcp_endpoint.setter
    def tcp_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_endpoint", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the cluster
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded username for the cluster
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class KafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_cluster = upstash.KafkaCluster("exampleCluster",
            cluster_name="TerraformCluster",
            multizone=False,
            region="eu-west-1")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Name of the cluster
        :param pulumi.Input[bool] multizone: Whether cluster has multizone attribute
        :param pulumi.Input[str] region: region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_cluster = upstash.KafkaCluster("exampleCluster",
            cluster_name="TerraformCluster",
            multizone=False,
            region="eu-west-1")
        ```

        :param str resource_name: The name of the resource.
        :param KafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaClusterArgs.__new__(KafkaClusterArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["multizone"] = multizone
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["max_message_size"] = None
            __props__.__dict__["max_messages_per_second"] = None
            __props__.__dict__["max_partitions"] = None
            __props__.__dict__["max_retention_size"] = None
            __props__.__dict__["max_retention_time"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["rest_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tcp_endpoint"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["username"] = None
        super(KafkaCluster, __self__).__init__(
            'upstash:index/kafkaCluster:KafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            max_message_size: Optional[pulumi.Input[int]] = None,
            max_messages_per_second: Optional[pulumi.Input[int]] = None,
            max_partitions: Optional[pulumi.Input[int]] = None,
            max_retention_size: Optional[pulumi.Input[int]] = None,
            max_retention_time: Optional[pulumi.Input[int]] = None,
            multizone: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rest_endpoint: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tcp_endpoint: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'KafkaCluster':
        """
        Get an existing KafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Unique Cluster ID for created cluster
        :param pulumi.Input[str] cluster_name: Name of the cluster
        :param pulumi.Input[int] creation_time: Creation time of the cluster
        :param pulumi.Input[int] max_message_size: Max Message Size for the cluster
        :param pulumi.Input[int] max_messages_per_second: Max Messages Per Second for the cluster
        :param pulumi.Input[int] max_partitions: Max Partitions for the cluster
        :param pulumi.Input[int] max_retention_size: Max Retention Size of the cluster
        :param pulumi.Input[int] max_retention_time: Max Retention Time of the cluster
        :param pulumi.Input[bool] multizone: Whether cluster has multizone attribute
        :param pulumi.Input[str] password: Password for the cluster
        :param pulumi.Input[str] region: region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        :param pulumi.Input[str] rest_endpoint: REST Endpoint of the cluster
        :param pulumi.Input[str] state: State, where the cluster is originated
        :param pulumi.Input[str] tcp_endpoint: TCP Endpoint of the cluster
        :param pulumi.Input[str] type: Type of the cluster
        :param pulumi.Input[str] username: Base64 encoded username for the cluster
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaClusterState.__new__(_KafkaClusterState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["max_message_size"] = max_message_size
        __props__.__dict__["max_messages_per_second"] = max_messages_per_second
        __props__.__dict__["max_partitions"] = max_partitions
        __props__.__dict__["max_retention_size"] = max_retention_size
        __props__.__dict__["max_retention_time"] = max_retention_time
        __props__.__dict__["multizone"] = multizone
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["state"] = state
        __props__.__dict__["tcp_endpoint"] = tcp_endpoint
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        return KafkaCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Unique Cluster ID for created cluster
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the cluster
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        Creation time of the cluster
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Output[int]:
        """
        Max Message Size for the cluster
        """
        return pulumi.get(self, "max_message_size")

    @property
    @pulumi.getter(name="maxMessagesPerSecond")
    def max_messages_per_second(self) -> pulumi.Output[int]:
        """
        Max Messages Per Second for the cluster
        """
        return pulumi.get(self, "max_messages_per_second")

    @property
    @pulumi.getter(name="maxPartitions")
    def max_partitions(self) -> pulumi.Output[int]:
        """
        Max Partitions for the cluster
        """
        return pulumi.get(self, "max_partitions")

    @property
    @pulumi.getter(name="maxRetentionSize")
    def max_retention_size(self) -> pulumi.Output[int]:
        """
        Max Retention Size of the cluster
        """
        return pulumi.get(self, "max_retention_size")

    @property
    @pulumi.getter(name="maxRetentionTime")
    def max_retention_time(self) -> pulumi.Output[int]:
        """
        Max Retention Time of the cluster
        """
        return pulumi.get(self, "max_retention_time")

    @property
    @pulumi.getter
    def multizone(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether cluster has multizone attribute
        """
        return pulumi.get(self, "multizone")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password for the cluster
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        region of the cluster. Possible values (may change) are: "eu-west-1", "us-east-1"
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[str]:
        """
        REST Endpoint of the cluster
        """
        return pulumi.get(self, "rest_endpoint")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State, where the cluster is originated
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tcpEndpoint")
    def tcp_endpoint(self) -> pulumi.Output[str]:
        """
        TCP Endpoint of the cluster
        """
        return pulumi.get(self, "tcp_endpoint")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the cluster
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Base64 encoded username for the cluster
        """
        return pulumi.get(self, "username")

