# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class AddTagsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddTagsRequest(TeaModel):
    def __init__(
        self,
        group_ids: List[str] = None,
        region_id: str = None,
        tag: List[AddTagsRequestTag] = None,
    ):
        self.group_ids = group_ids
        self.region_id = region_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddTagsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        apply_mode: str = None,
        enable_end_time: int = None,
        enable_start_time: int = None,
        group_id: int = None,
        notify_level: int = None,
        silence_time: int = None,
        template_ids: str = None,
        webhook: str = None,
    ):
        self.apply_mode = apply_mode
        self.enable_end_time = enable_end_time
        self.enable_start_time = enable_start_time
        self.group_id = group_id
        self.notify_level = notify_level
        self.silence_time = silence_time
        self.template_ids = template_ids
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_mode is not None:
            result['ApplyMode'] = self.apply_mode
        if self.enable_end_time is not None:
            result['EnableEndTime'] = self.enable_end_time
        if self.enable_start_time is not None:
            result['EnableStartTime'] = self.enable_start_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.notify_level is not None:
            result['NotifyLevel'] = self.notify_level
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyMode') is not None:
            self.apply_mode = m.get('ApplyMode')
        if m.get('EnableEndTime') is not None:
            self.enable_end_time = m.get('EnableEndTime')
        if m.get('EnableStartTime') is not None:
            self.enable_start_time = m.get('EnableStartTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('NotifyLevel') is not None:
            self.notify_level = m.get('NotifyLevel')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class ApplyMetricRuleTemplateResponseBodyResourceAlertResults(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        rule_id: str = None,
        rule_name: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(
        self,
        alert_results: List[ApplyMetricRuleTemplateResponseBodyResourceAlertResults] = None,
        group_id: int = None,
    ):
        self.alert_results = alert_results
        self.group_id = group_id

    def validate(self):
        if self.alert_results:
            for k in self.alert_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResults'] = []
        if self.alert_results is not None:
            for k in self.alert_results:
                result['AlertResults'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_results = []
        if m.get('AlertResults') is not None:
            for k in m.get('AlertResults'):
                temp_model = ApplyMetricRuleTemplateResponseBodyResourceAlertResults()
                self.alert_results.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ApplyMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: ApplyMetricRuleTemplateResponseBodyResource = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resource = resource
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateIntantSiteMonitorRequestTaskList(TeaModel):
    def __init__(
        self,
        address: str = None,
        isp_cities: str = None,
        options_json: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.address = address
        self.isp_cities = isp_cities
        self.options_json = options_json
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class BatchCreateIntantSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        task_list: List[BatchCreateIntantSiteMonitorRequestTaskList] = None,
    ):
        self.region_id = region_id
        self.task_list = task_list

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = BatchCreateIntantSiteMonitorRequestTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class BatchCreateIntantSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateIntantSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateIntantSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateIntantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsCallNumOrderRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        auto_renew_period: int = None,
        auto_use_coupon: bool = None,
        period: int = None,
        period_unit: str = None,
        phone_count: str = None,
    ):
        self.auto_pay = auto_pay
        self.auto_renew_period = auto_renew_period
        self.auto_use_coupon = auto_use_coupon
        self.period = period
        self.period_unit = period_unit
        self.phone_count = phone_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_count is not None:
            result['PhoneCount'] = self.phone_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneCount') is not None:
            self.phone_count = m.get('PhoneCount')
        return self


class CreateCmsCallNumOrderResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsCallNumOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCmsCallNumOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsCallNumOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsOrderRequest(TeaModel):
    def __init__(
        self,
        api_count: str = None,
        auto_pay: bool = None,
        auto_renew_period: int = None,
        auto_use_coupon: bool = None,
        custom_time_series: str = None,
        event_store_num: str = None,
        event_store_time: str = None,
        log_monitor_stream: str = None,
        pay_type: str = None,
        period: int = None,
        period_unit: str = None,
        phone_count: str = None,
        site_ecs_num: str = None,
        site_operator_num: str = None,
        site_task_num: str = None,
        sms_count: str = None,
        suggest_type: str = None,
    ):
        self.api_count = api_count
        self.auto_pay = auto_pay
        self.auto_renew_period = auto_renew_period
        self.auto_use_coupon = auto_use_coupon
        self.custom_time_series = custom_time_series
        self.event_store_num = event_store_num
        self.event_store_time = event_store_time
        self.log_monitor_stream = log_monitor_stream
        self.pay_type = pay_type
        self.period = period
        self.period_unit = period_unit
        self.phone_count = phone_count
        self.site_ecs_num = site_ecs_num
        self.site_operator_num = site_operator_num
        self.site_task_num = site_task_num
        self.sms_count = sms_count
        self.suggest_type = suggest_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_count is not None:
            result['ApiCount'] = self.api_count
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.custom_time_series is not None:
            result['CustomTimeSeries'] = self.custom_time_series
        if self.event_store_num is not None:
            result['EventStoreNum'] = self.event_store_num
        if self.event_store_time is not None:
            result['EventStoreTime'] = self.event_store_time
        if self.log_monitor_stream is not None:
            result['LogMonitorStream'] = self.log_monitor_stream
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_count is not None:
            result['PhoneCount'] = self.phone_count
        if self.site_ecs_num is not None:
            result['SiteEcsNum'] = self.site_ecs_num
        if self.site_operator_num is not None:
            result['SiteOperatorNum'] = self.site_operator_num
        if self.site_task_num is not None:
            result['SiteTaskNum'] = self.site_task_num
        if self.sms_count is not None:
            result['SmsCount'] = self.sms_count
        if self.suggest_type is not None:
            result['SuggestType'] = self.suggest_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiCount') is not None:
            self.api_count = m.get('ApiCount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('CustomTimeSeries') is not None:
            self.custom_time_series = m.get('CustomTimeSeries')
        if m.get('EventStoreNum') is not None:
            self.event_store_num = m.get('EventStoreNum')
        if m.get('EventStoreTime') is not None:
            self.event_store_time = m.get('EventStoreTime')
        if m.get('LogMonitorStream') is not None:
            self.log_monitor_stream = m.get('LogMonitorStream')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneCount') is not None:
            self.phone_count = m.get('PhoneCount')
        if m.get('SiteEcsNum') is not None:
            self.site_ecs_num = m.get('SiteEcsNum')
        if m.get('SiteOperatorNum') is not None:
            self.site_operator_num = m.get('SiteOperatorNum')
        if m.get('SiteTaskNum') is not None:
            self.site_task_num = m.get('SiteTaskNum')
        if m.get('SmsCount') is not None:
            self.sms_count = m.get('SmsCount')
        if m.get('SuggestType') is not None:
            self.suggest_type = m.get('SuggestType')
        return self


class CreateCmsOrderResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCmsOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsSmspackageOrderRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        auto_renew_period: int = None,
        auto_use_coupon: bool = None,
        period: int = None,
        period_unit: str = None,
        sms_count: str = None,
    ):
        self.auto_pay = auto_pay
        self.auto_renew_period = auto_renew_period
        self.auto_use_coupon = auto_use_coupon
        self.period = period
        self.period_unit = period_unit
        self.sms_count = sms_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.sms_count is not None:
            result['SmsCount'] = self.sms_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('SmsCount') is not None:
            self.sms_count = m.get('SmsCount')
        return self


class CreateCmsSmspackageOrderResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsSmspackageOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCmsSmspackageOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsSmspackageOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDynamicTagGroupRequestMatchExpress(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_value_match_function: str = None,
    ):
        self.tag_value = tag_value
        self.tag_value_match_function = tag_value_match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class CreateDynamicTagGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
        enable_install_agent: bool = None,
        enable_subscribe_event: bool = None,
        match_express: List[CreateDynamicTagGroupRequestMatchExpress] = None,
        match_express_filter_relation: str = None,
        region_id: str = None,
        tag_key: str = None,
        tag_region_id: str = None,
        template_id_list: List[str] = None,
    ):
        self.contact_group_list = contact_group_list
        self.enable_install_agent = enable_install_agent
        self.enable_subscribe_event = enable_subscribe_event
        self.match_express = match_express
        self.match_express_filter_relation = match_express_filter_relation
        self.region_id = region_id
        self.tag_key = tag_key
        self.tag_region_id = tag_region_id
        self.template_id_list = template_id_list

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateDynamicTagGroupRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class CreateDynamicTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.id = id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDynamicTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDynamicTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalations(TeaModel):
    def __init__(
        self,
        critical: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical = None,
        info: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo = None,
        warn: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        self.validate_required(self.critical, 'critical')
        if self.critical:
            self.critical.validate()
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()
        self.validate_required(self.warn, 'warn')
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMetricRulesRequestGroupMetricRules(TeaModel):
    def __init__(
        self,
        escalations: CreateGroupMetricRulesRequestGroupMetricRulesEscalations = None,
        category: str = None,
        contact_groups: str = None,
        dimensions: str = None,
        effective_interval: str = None,
        email_subject: str = None,
        interval: str = None,
        labels: List[CreateGroupMetricRulesRequestGroupMetricRulesLabels] = None,
        metric_name: str = None,
        namespace: str = None,
        no_data_policy: str = None,
        no_effective_interval: str = None,
        period: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: int = None,
        webhook: str = None,
    ):
        self.escalations = escalations
        self.category = category
        self.contact_groups = contact_groups
        self.dimensions = dimensions
        self.effective_interval = effective_interval
        self.email_subject = email_subject
        self.interval = interval
        self.labels = labels
        self.metric_name = metric_name
        self.namespace = namespace
        self.no_data_policy = no_data_policy
        self.no_effective_interval = no_effective_interval
        self.period = period
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.silence_time = silence_time
        self.webhook = webhook

    def validate(self):
        self.validate_required(self.escalations, 'escalations')
        if self.escalations:
            self.escalations.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.email_subject is not None:
            result['EmailSubject'] = self.email_subject
        if self.interval is not None:
            result['Interval'] = self.interval
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EmailSubject') is not None:
            self.email_subject = m.get('EmailSubject')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRulesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMetricRulesRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_metric_rules: List[CreateGroupMetricRulesRequestGroupMetricRules] = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.group_metric_rules = group_metric_rules
        self.region_id = region_id

    def validate(self):
        if self.group_metric_rules:
            for k in self.group_metric_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['GroupMetricRules'] = []
        if self.group_metric_rules is not None:
            for k in self.group_metric_rules:
                result['GroupMetricRules'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.group_metric_rules = []
        if m.get('GroupMetricRules') is not None:
            for k in m.get('GroupMetricRules'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRules()
                self.group_metric_rules.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMetricRulesResponseBodyResourcesAlertResult(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        rule_id: str = None,
        rule_name: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponseBodyResources(TeaModel):
    def __init__(
        self,
        alert_result: List[CreateGroupMetricRulesResponseBodyResourcesAlertResult] = None,
    ):
        self.alert_result = alert_result

    def validate(self):
        if self.alert_result:
            for k in self.alert_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResult'] = []
        if self.alert_result is not None:
            for k in self.alert_result:
                result['AlertResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_result = []
        if m.get('AlertResult') is not None:
            for k in m.get('AlertResult'):
                temp_model = CreateGroupMetricRulesResponseBodyResourcesAlertResult()
                self.alert_result.append(temp_model.from_map(k))
        return self


class CreateGroupMetricRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resources: CreateGroupMetricRulesResponseBodyResources = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resources = resources
        self.success = success

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = CreateGroupMetricRulesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGroupMetricRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMonitoringAgentProcessRequestAlertConfig(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        effective_interval: str = None,
        escalations_level: str = None,
        no_effective_interval: str = None,
        silence_time: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
        webhook: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.effective_interval = effective_interval
        self.escalations_level = escalations_level
        self.no_effective_interval = no_effective_interval
        self.silence_time = silence_time
        self.statistics = statistics
        self.threshold = threshold
        self.times = times
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMonitoringAgentProcessRequestMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        self.function = function
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        alert_config: List[CreateGroupMonitoringAgentProcessRequestAlertConfig] = None,
        group_id: str = None,
        match_express: List[CreateGroupMonitoringAgentProcessRequestMatchExpress] = None,
        match_express_filter_relation: str = None,
        process_name: str = None,
        region_id: str = None,
    ):
        self.alert_config = alert_config
        self.group_id = group_id
        self.match_express = match_express
        self.match_express_filter_relation = match_express_filter_relation
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = CreateGroupMonitoringAgentProcessRequestAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateGroupMonitoringAgentProcessRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHostAvailabilityRequestAlertConfig(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        notify_type: int = None,
        silence_time: int = None,
        start_time: int = None,
        web_hook: str = None,
    ):
        self.end_time = end_time
        self.notify_type = notify_type
        self.silence_time = silence_time
        self.start_time = start_time
        self.web_hook = web_hook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class CreateHostAvailabilityRequestTaskOption(TeaModel):
    def __init__(
        self,
        http_header: str = None,
        http_method: str = None,
        http_negative: bool = None,
        http_post_content: str = None,
        http_response_charset: str = None,
        http_response_match_content: str = None,
        http_uri: str = None,
        interval: int = None,
        telnet_or_ping_host: str = None,
    ):
        self.http_header = http_header
        self.http_method = http_method
        self.http_negative = http_negative
        self.http_post_content = http_post_content
        self.http_response_charset = http_response_charset
        self.http_response_match_content = http_response_match_content
        self.http_uri = http_uri
        self.interval = interval
        self.telnet_or_ping_host = telnet_or_ping_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_header is not None:
            result['HttpHeader'] = self.http_header
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_response_match_content is not None:
            result['HttpResponseMatchContent'] = self.http_response_match_content
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpHeader') is not None:
            self.http_header = m.get('HttpHeader')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpResponseMatchContent') is not None:
            self.http_response_match_content = m.get('HttpResponseMatchContent')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class CreateHostAvailabilityRequestAlertConfigEscalationList(TeaModel):
    def __init__(
        self,
        aggregate: str = None,
        metric_name: str = None,
        operator: str = None,
        times: int = None,
        value: str = None,
    ):
        self.aggregate = aggregate
        self.metric_name = metric_name
        self.operator = operator
        self.times = times
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHostAvailabilityRequest(TeaModel):
    def __init__(
        self,
        alert_config: CreateHostAvailabilityRequestAlertConfig = None,
        task_option: CreateHostAvailabilityRequestTaskOption = None,
        alert_config_escalation_list: List[CreateHostAvailabilityRequestAlertConfigEscalationList] = None,
        group_id: int = None,
        instance_list: List[str] = None,
        region_id: str = None,
        task_name: str = None,
        task_scope: str = None,
        task_type: str = None,
    ):
        self.alert_config = alert_config
        self.task_option = task_option
        self.alert_config_escalation_list = alert_config_escalation_list
        self.group_id = group_id
        self.instance_list = instance_list
        self.region_id = region_id
        self.task_name = task_name
        self.task_scope = task_scope
        self.task_type = task_type

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.task_option:
            self.task_option.validate()
        if self.alert_config_escalation_list:
            for k in self.alert_config_escalation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        result['AlertConfigEscalationList'] = []
        if self.alert_config_escalation_list is not None:
            for k in self.alert_config_escalation_list:
                result['AlertConfigEscalationList'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = CreateHostAvailabilityRequestAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('TaskOption') is not None:
            temp_model = CreateHostAvailabilityRequestTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        self.alert_config_escalation_list = []
        if m.get('AlertConfigEscalationList') is not None:
            for k in m.get('AlertConfigEscalationList'):
                temp_model = CreateHostAvailabilityRequestAlertConfigEscalationList()
                self.alert_config_escalation_list.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateHostAvailabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        task_id: int = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateHostAvailabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHostAvailabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorNamespaceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        namespace: str = None,
        region_id: str = None,
        spec: str = None,
    ):
        self.description = description
        self.namespace = namespace
        self.region_id = region_id
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorSLSGroupRequestSLSGroupConfig(TeaModel):
    def __init__(
        self,
        slslogstore: str = None,
        slsproject: str = None,
        slsregion: str = None,
        slsuser_id: str = None,
    ):
        self.slslogstore = slslogstore
        self.slsproject = slsproject
        self.slsregion = slsregion
        self.slsuser_id = slsuser_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class CreateHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        slsgroup_config: List[CreateHybridMonitorSLSGroupRequestSLSGroupConfig] = None,
        slsgroup_description: str = None,
        slsgroup_name: str = None,
    ):
        self.region_id = region_id
        self.slsgroup_config = slsgroup_config
        self.slsgroup_description = slsgroup_description
        self.slsgroup_name = slsgroup_name

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = CreateHybridMonitorSLSGroupRequestSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class CreateHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorTaskRequestAttachLabels(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigExpress(TeaModel):
    def __init__(
        self,
        alias: str = None,
        express: str = None,
    ):
        self.alias = alias
        self.express = express

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.express is not None:
            result['Express'] = self.express
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters(TeaModel):
    def __init__(
        self,
        operator: str = None,
        slskey_name: str = None,
        value: str = None,
    ):
        self.operator = operator
        self.slskey_name = slskey_name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilter(TeaModel):
    def __init__(
        self,
        filters: List[CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters] = None,
        relation: str = None,
    ):
        self.filters = filters
        self.relation = relation

    def validate(self):
        if self.filters:
            for k in self.filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filters'] = []
        if self.filters is not None:
            for k in self.filters:
                result['Filters'].append(k.to_map() if k else None)
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filters = []
        if m.get('Filters') is not None:
            for k in m.get('Filters'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters()
                self.filters.append(temp_model.from_map(k))
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy(TeaModel):
    def __init__(
        self,
        alias: str = None,
        slskey_name: str = None,
    ):
        self.alias = alias
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigStatistics(TeaModel):
    def __init__(
        self,
        alias: str = None,
        function: str = None,
        parameter_1: str = None,
        parameter_2: str = None,
        slskey_name: str = None,
    ):
        self.alias = alias
        self.function = function
        self.parameter_1 = parameter_1
        self.parameter_2 = parameter_2
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.function is not None:
            result['Function'] = self.function
        if self.parameter_1 is not None:
            result['Parameter1'] = self.parameter_1
        if self.parameter_2 is not None:
            result['Parameter2'] = self.parameter_2
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Parameter1') is not None:
            self.parameter_1 = m.get('Parameter1')
        if m.get('Parameter2') is not None:
            self.parameter_2 = m.get('Parameter2')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfig(TeaModel):
    def __init__(
        self,
        express: List[CreateHybridMonitorTaskRequestSLSProcessConfigExpress] = None,
        filter: CreateHybridMonitorTaskRequestSLSProcessConfigFilter = None,
        group_by: List[CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy] = None,
        statistics: List[CreateHybridMonitorTaskRequestSLSProcessConfigStatistics] = None,
    ):
        self.express = express
        self.filter = filter
        self.group_by = group_by
        self.statistics = statistics

    def validate(self):
        if self.express:
            for k in self.express:
                if k:
                    k.validate()
        if self.filter:
            self.filter.validate()
        if self.group_by:
            for k in self.group_by:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Express'] = []
        if self.express is not None:
            for k in self.express:
                result['Express'].append(k.to_map() if k else None)
        if self.filter is not None:
            result['Filter'] = self.filter.to_map()
        result['GroupBy'] = []
        if self.group_by is not None:
            for k in self.group_by:
                result['GroupBy'].append(k.to_map() if k else None)
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.express = []
        if m.get('Express') is not None:
            for k in m.get('Express'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigExpress()
                self.express.append(temp_model.from_map(k))
        if m.get('Filter') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilter()
            self.filter = temp_model.from_map(m['Filter'])
        self.group_by = []
        if m.get('GroupBy') is not None:
            for k in m.get('GroupBy'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy()
                self.group_by.append(temp_model.from_map(k))
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class CreateHybridMonitorTaskRequest(TeaModel):
    def __init__(
        self,
        attach_labels: List[CreateHybridMonitorTaskRequestAttachLabels] = None,
        collect_interval: str = None,
        collect_target_type: str = None,
        description: str = None,
        group_id: str = None,
        namespace: str = None,
        region_id: str = None,
        slsprocess_config: CreateHybridMonitorTaskRequestSLSProcessConfig = None,
        target_user_id: str = None,
        target_user_id_list: str = None,
        task_name: str = None,
        task_type: str = None,
        yarmconfig: str = None,
    ):
        self.attach_labels = attach_labels
        self.collect_interval = collect_interval
        self.collect_target_type = collect_target_type
        self.description = description
        self.group_id = group_id
        self.namespace = namespace
        self.region_id = region_id
        self.slsprocess_config = slsprocess_config
        self.target_user_id = target_user_id
        self.target_user_id_list = target_user_id_list
        self.task_name = task_name
        self.task_type = task_type
        self.yarmconfig = yarmconfig

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.slsprocess_config:
            self.slsprocess_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsprocess_config is not None:
            result['SLSProcessConfig'] = self.slsprocess_config.to_map()
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.target_user_id_list is not None:
            result['TargetUserIdList'] = self.target_user_id_list
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = CreateHybridMonitorTaskRequestAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSProcessConfig') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfig()
            self.slsprocess_config = temp_model.from_map(m['SLSProcessConfig'])
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TargetUserIdList') is not None:
            self.target_user_id_list = m.get('TargetUserIdList')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class CreateHybridMonitorTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstantSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        isp_cities: str = None,
        options_json: str = None,
        random_isp_city: int = None,
        region_id: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.address = address
        self.isp_cities = isp_cities
        self.options_json = options_json
        self.random_isp_city = random_isp_city
        self.region_id = region_id
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.random_isp_city is not None:
            result['RandomIspCity'] = self.random_isp_city
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RandomIspCity') is not None:
            self.random_isp_city = m.get('RandomIspCity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateInstantSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateInstantSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_result_list: List[CreateInstantSiteMonitorResponseBodyCreateResultList] = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.create_result_list = create_result_list
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateInstantSiteMonitorResponseBodyCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstantSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstantSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        overwrite: str = None,
        resources: str = None,
        rule_id: str = None,
    ):
        self.overwrite = overwrite
        self.resources = resources
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Overwrite') is not None:
            self.overwrite = m.get('Overwrite')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalations(TeaModel):
    def __init__(
        self,
        critical: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical = None,
        info: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo = None,
        warn: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        self.validate_required(self.critical, 'critical')
        if self.critical:
            self.critical.validate()
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()
        self.validate_required(self.warn, 'warn')
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplates(TeaModel):
    def __init__(
        self,
        escalations: CreateMetricRuleTemplateRequestAlertTemplatesEscalations = None,
        category: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: int = None,
        rule_name: str = None,
        selector: str = None,
        webhook: str = None,
    ):
        self.escalations = escalations
        self.category = category
        self.metric_name = metric_name
        self.namespace = namespace
        self.period = period
        self.rule_name = rule_name
        self.selector = selector
        self.webhook = webhook

    def validate(self):
        self.validate_required(self.escalations, 'escalations')
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        alert_templates: List[CreateMetricRuleTemplateRequestAlertTemplates] = None,
        description: str = None,
        name: str = None,
        region_id: str = None,
    ):
        self.alert_templates = alert_templates
        self.description = description
        self.name = name
        self.region_id = region_id

    def validate(self):
        if self.alert_templates:
            for k in self.alert_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertTemplates'] = []
        if self.alert_templates is not None:
            for k in self.alert_templates:
                result['AlertTemplates'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_templates = []
        if m.get('AlertTemplates') is not None:
            for k in m.get('AlertTemplates'):
                temp_model = CreateMetricRuleTemplateRequestAlertTemplates()
                self.alert_templates.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.id = id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_name: str = None,
        process_user: str = None,
        region_id: str = None,
    ):
        self.instance_id = instance_id
        self.process_name = process_name
        self.process_user = process_user
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.id = id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupRequest(TeaModel):
    def __init__(
        self,
        contact_groups: str = None,
        group_name: str = None,
        region_id: str = None,
    ):
        self.contact_groups = contact_groups
        self.group_name = group_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        group_id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.group_id = group_id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupByResourceGroupIdRequest(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
        enable_install_agent: bool = None,
        enable_subscribe_event: bool = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_group_name: str = None,
    ):
        self.contact_group_list = contact_group_list
        self.enable_install_agent = enable_install_agent
        self.enable_subscribe_event = enable_subscribe_event
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.resource_group_name = resource_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class CreateMonitorGroupByResourceGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.id = id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupByResourceGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupByResourceGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupByResourceGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupInstancesRequestInstances(TeaModel):
    def __init__(
        self,
        category: str = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        self.category = category
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instances: List[CreateMonitorGroupInstancesRequestInstances] = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.instances = instances
        self.region_id = region_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = CreateMonitorGroupInstancesRequestInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        group_id: str = None,
        policy_type: str = None,
        region_id: str = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.group_id = group_id
        self.policy_type = policy_type
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: int = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupNotifyPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_name: str = None,
        process_user: str = None,
        region_id: str = None,
    ):
        self.instance_id = instance_id
        self.process_name = process_name
        self.process_user = process_user
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.id = id
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        alert_ids: str = None,
        interval: str = None,
        isp_cities: str = None,
        options_json: str = None,
        region_id: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.address = address
        self.alert_ids = alert_ids
        self.interval = interval
        self.isp_cities = isp_cities
        self.options_json = options_json
        self.region_id = region_id
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.alert_ids is not None:
            result['AlertIds'] = self.alert_ids
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('AlertIds') is not None:
            self.alert_ids = m.get('AlertIds')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateSiteMonitorResponseBodyCreateResultListCreateResultList(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(
        self,
        create_result_list: List[CreateSiteMonitorResponseBodyCreateResultListCreateResultList] = None,
    ):
        self.create_result_list = create_result_list

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateSiteMonitorResponseBodyCreateResultListCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResultContact(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        rule_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.rule_id = rule_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResult(TeaModel):
    def __init__(
        self,
        contact: List[CreateSiteMonitorResponseBodyDataAttachAlertResultContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResultContact()
                self.contact.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyData(TeaModel):
    def __init__(
        self,
        attach_alert_result: CreateSiteMonitorResponseBodyDataAttachAlertResult = None,
    ):
        self.attach_alert_result = attach_alert_result

    def validate(self):
        if self.attach_alert_result:
            self.attach_alert_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_alert_result is not None:
            result['AttachAlertResult'] = self.attach_alert_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachAlertResult') is not None:
            temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResult()
            self.attach_alert_result = temp_model.from_map(m['AttachAlertResult'])
        return self


class CreateSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_result_list: CreateSiteMonitorResponseBodyCreateResultList = None,
        data: CreateSiteMonitorResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.create_result_list = create_result_list
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.create_result_list:
            self.create_result_list.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_result_list is not None:
            result['CreateResultList'] = self.create_result_list.to_map()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateResultList') is not None:
            temp_model = CreateSiteMonitorResponseBodyCreateResultList()
            self.create_result_list = temp_model.from_map(m['CreateResultList'])
        if m.get('Data') is not None:
            temp_model = CreateSiteMonitorResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactRequest(TeaModel):
    def __init__(
        self,
        contact_name: str = None,
    ):
        self.contact_name = contact_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        return self


class DeleteContactResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContactResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
    ):
        self.contact_group_name = contact_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        return self


class DeleteContactGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContactGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomMetricRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        md_5: str = None,
        metric_name: str = None,
        region_id: str = None,
        uuid: str = None,
    ):
        self.group_id = group_id
        self.md_5 = md_5
        self.metric_name = metric_name
        self.region_id = region_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['UUID'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UUID') is not None:
            self.uuid = m.get('UUID')
        return self


class DeleteCustomMetricResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomMetricResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomMetricResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomMetricResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDynamicTagGroupRequest(TeaModel):
    def __init__(
        self,
        dynamic_tag_rule_id: str = None,
        region_id: str = None,
    ):
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDynamicTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDynamicTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDynamicTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRuleTargetsRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
        region_id: str = None,
        rule_name: str = None,
    ):
        self.ids = ids
        self.region_id = region_id
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteEventRuleTargetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRuleTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventRuleTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRulesRequest(TeaModel):
    def __init__(
        self,
        rule_names: List[str] = None,
    ):
        self.rule_names = rule_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        return self


class DeleteEventRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterOutputRequest(TeaModel):
    def __init__(
        self,
        dest_name: str = None,
        region_id: str = None,
    ):
        self.dest_name = dest_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteExporterOutputResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExporterOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterRuleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
    ):
        self.region_id = region_id
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteExporterRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExporterRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHostAvailabilityRequest(TeaModel):
    def __init__(
        self,
        id: List[int] = None,
        region_id: str = None,
    ):
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHostAvailabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHostAvailabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHostAvailabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorNamespaceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        region_id: str = None,
    ):
        self.namespace = namespace
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        slsgroup_name: str = None,
    ):
        self.region_id = region_id
        self.slsgroup_name = slsgroup_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DeleteHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorTaskRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        region_id: str = None,
        target_user_id: str = None,
        task_id: str = None,
    ):
        self.namespace = namespace
        self.region_id = region_id
        self.target_user_id = target_user_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteHybridMonitorTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLogMonitorRequest(TeaModel):
    def __init__(
        self,
        log_id: int = None,
        region_id: str = None,
    ):
        self.log_id = log_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLogMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteLogMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLogMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLogMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        resources: str = None,
        rule_id: str = None,
    ):
        self.resources = resources
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTargetsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_id: str = None,
        target_ids: List[str] = None,
    ):
        self.region_id = region_id
        self.rule_id = rule_id
        self.target_ids = target_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds(TeaModel):
    def __init__(
        self,
        target_id: List[str] = None,
    ):
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIds(TeaModel):
    def __init__(
        self,
        target_ids: DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds = None,
    ):
        self.target_ids = target_ids

    def validate(self):
        if self.target_ids:
            self.target_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds()
            self.target_ids = temp_model.from_map(m['TargetIds'])
        return self


class DeleteMetricRuleTargetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        fail_ids: DeleteMetricRuleTargetsResponseBodyFailIds = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.fail_ids = fail_ids
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.fail_ids:
            self.fail_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_ids is not None:
            result['FailIds'] = self.fail_ids.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIds()
            self.fail_ids = temp_model.from_map(m['FailIds'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        template_id: str = None,
    ):
        self.region_id = region_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: DeleteMetricRuleTemplateResponseBodyResource = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resource = resource
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRulesRequest(TeaModel):
    def __init__(
        self,
        id: List[str] = None,
        region_id: str = None,
    ):
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMetricRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DeleteMonitorGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        contact_groups: DeleteMonitorGroupResponseBodyGroupContactGroups = None,
        group_name: str = None,
    ):
        self.contact_groups = contact_groups
        self.group_name = group_name

    def validate(self):
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroupContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteMonitorGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        group: DeleteMonitorGroupResponseBodyGroup = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.group = group
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Group') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupDynamicRuleRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        region_id: str = None,
    ):
        self.category = category
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupDynamicRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupDynamicRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupDynamicRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupDynamicRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        instance_id_list: str = None,
        region_id: str = None,
    ):
        self.category = category
        self.group_id = group_id
        self.instance_id_list = instance_id_list
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        policy_type: str = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.policy_type = policy_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: int = None,
        success: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupNotifyPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_id: str = None,
        process_name: str = None,
        region_id: str = None,
    ):
        self.instance_id = instance_id
        self.process_id = process_id
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSiteMonitorsRequest(TeaModel):
    def __init__(
        self,
        is_delete_alarms: bool = None,
        region_id: str = None,
        task_ids: str = None,
    ):
        self.is_delete_alarms = is_delete_alarms
        self.region_id = region_id
        self.task_ids = task_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_delete_alarms is not None:
            result['IsDeleteAlarms'] = self.is_delete_alarms
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsDeleteAlarms') is not None:
            self.is_delete_alarms = m.get('IsDeleteAlarms')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DeleteSiteMonitorsResponseBodyData(TeaModel):
    def __init__(
        self,
        count: int = None,
    ):
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class DeleteSiteMonitorsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteSiteMonitorsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteSiteMonitorsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSiteMonitorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSiteMonitorsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSiteMonitorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActiveMetricRuleListRequest(TeaModel):
    def __init__(
        self,
        product: str = None,
    ):
        self.product = product

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations(TeaModel):
    def __init__(
        self,
        critical: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical = None,
        info: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo = None,
        warn: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlert(TeaModel):
    def __init__(
        self,
        alert_state: str = None,
        contact_groups: str = None,
        dimensions: str = None,
        effective_interval: str = None,
        enable_state: bool = None,
        escalations: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations = None,
        mail_subject: str = None,
        metric_name: str = None,
        namespace: str = None,
        no_effective_interval: str = None,
        period: str = None,
        resources: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
        webhook: str = None,
    ):
        self.alert_state = alert_state
        self.contact_groups = contact_groups
        self.dimensions = dimensions
        self.effective_interval = effective_interval
        self.enable_state = enable_state
        self.escalations = escalations
        self.mail_subject = mail_subject
        self.metric_name = metric_name
        self.namespace = namespace
        self.no_effective_interval = no_effective_interval
        self.period = period
        self.resources = resources
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.silence_time = silence_time
        self.webhook = webhook

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.mail_subject is not None:
            result['MailSubject'] = self.mail_subject
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('Escalations') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('MailSubject') is not None:
            self.mail_subject = m.get('MailSubject')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertList(TeaModel):
    def __init__(
        self,
        alert: List[DescribeActiveMetricRuleListResponseBodyAlertListAlert] = None,
    ):
        self.alert = alert

    def validate(self):
        if self.alert:
            for k in self.alert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alert'] = []
        if self.alert is not None:
            for k in self.alert:
                result['Alert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert = []
        if m.get('Alert') is not None:
            for k in m.get('Alert'):
                temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlert()
                self.alert.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBodyDatapointsAlarm(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        contact_groups: str = None,
        enable: str = None,
        end_time: str = None,
        evaluation_count: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
        start_time: str = None,
        state: str = None,
        statistics: str = None,
        threshold: str = None,
        webhook: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.contact_groups = contact_groups
        self.enable = enable
        self.end_time = end_time
        self.evaluation_count = evaluation_count
        self.metric_name = metric_name
        self.namespace = namespace
        self.period = period
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.silence_time = silence_time
        self.start_time = start_time
        self.state = state
        self.statistics = statistics
        self.threshold = threshold
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        alarm: List[DescribeActiveMetricRuleListResponseBodyDatapointsAlarm] = None,
    ):
        self.alarm = alarm

    def validate(self):
        if self.alarm:
            for k in self.alarm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarm'] = []
        if self.alarm is not None:
            for k in self.alarm:
                result['Alarm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm = []
        if m.get('Alarm') is not None:
            for k in m.get('Alarm'):
                temp_model = DescribeActiveMetricRuleListResponseBodyDatapointsAlarm()
                self.alarm.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBody(TeaModel):
    def __init__(
        self,
        alert_list: DescribeActiveMetricRuleListResponseBodyAlertList = None,
        code: str = None,
        datapoints: DescribeActiveMetricRuleListResponseBodyDatapoints = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.alert_list = alert_list
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.alert_list:
            self.alert_list.validate()
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_list is not None:
            result['AlertList'] = self.alert_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertList') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertList()
            self.alert_list = temp_model.from_map(m['AlertList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeActiveMetricRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeActiveMetricRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertHistoryListRequest(TeaModel):
    def __init__(
        self,
        ascending: bool = None,
        end_time: str = None,
        group_id: str = None,
        metric_name: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        start_time: str = None,
        state: str = None,
        status: str = None,
    ):
        self.ascending = ascending
        self.end_time = end_time
        self.group_id = group_id
        self.metric_name = metric_name
        self.namespace = namespace
        self.page = page
        self.page_size = page_size
        self.region_id = region_id
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.start_time = start_time
        self.state = state
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ascending is not None:
            result['Ascending'] = self.ascending
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ascending') is not None:
            self.ascending = m.get('Ascending')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs(TeaModel):
    def __init__(
        self,
        contact_aliim: List[str] = None,
    ):
        self.contact_aliim = contact_aliim

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_aliim is not None:
            result['ContactALIIM'] = self.contact_aliim
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactALIIM') is not None:
            self.contact_aliim = m.get('ContactALIIM')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails(TeaModel):
    def __init__(
        self,
        contact_mail: List[str] = None,
    ):
        self.contact_mail = contact_mail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_mail is not None:
            result['ContactMail'] = self.contact_mail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactMail') is not None:
            self.contact_mail = m.get('ContactMail')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses(TeaModel):
    def __init__(
        self,
        contact_sms: List[str] = None,
    ):
        self.contact_sms = contact_sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_sms is not None:
            result['ContactSms'] = self.contact_sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactSms') is not None:
            self.contact_sms = m.get('ContactSms')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts(TeaModel):
    def __init__(
        self,
        contact: List[str] = None,
    ):
        self.contact = contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory(TeaModel):
    def __init__(
        self,
        alert_time: int = None,
        contact_aliims: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs = None,
        contact_groups: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups = None,
        contact_mails: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails = None,
        contact_smses: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses = None,
        contacts: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts = None,
        dimensions: str = None,
        evaluation_count: int = None,
        expression: str = None,
        group_id: str = None,
        instance_name: str = None,
        last_time: int = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        rule_id: str = None,
        rule_name: str = None,
        state: str = None,
        status: int = None,
        value: str = None,
        webhooks: str = None,
    ):
        self.alert_time = alert_time
        self.contact_aliims = contact_aliims
        self.contact_groups = contact_groups
        self.contact_mails = contact_mails
        self.contact_smses = contact_smses
        self.contacts = contacts
        self.dimensions = dimensions
        self.evaluation_count = evaluation_count
        self.expression = expression
        self.group_id = group_id
        self.instance_name = instance_name
        self.last_time = last_time
        self.level = level
        self.metric_name = metric_name
        self.namespace = namespace
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.state = state
        self.status = status
        self.value = value
        self.webhooks = webhooks

    def validate(self):
        if self.contact_aliims:
            self.contact_aliims.validate()
        if self.contact_groups:
            self.contact_groups.validate()
        if self.contact_mails:
            self.contact_mails.validate()
        if self.contact_smses:
            self.contact_smses.validate()
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.contact_aliims is not None:
            result['ContactALIIMs'] = self.contact_aliims.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.contact_mails is not None:
            result['ContactMails'] = self.contact_mails.to_map()
        if self.contact_smses is not None:
            result['ContactSmses'] = self.contact_smses.to_map()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        if self.webhooks is not None:
            result['Webhooks'] = self.webhooks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('ContactALIIMs') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs()
            self.contact_aliims = temp_model.from_map(m['ContactALIIMs'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('ContactMails') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails()
            self.contact_mails = temp_model.from_map(m['ContactMails'])
        if m.get('ContactSmses') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses()
            self.contact_smses = temp_model.from_map(m['ContactSmses'])
        if m.get('Contacts') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Webhooks') is not None:
            self.webhooks = m.get('Webhooks')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryList(TeaModel):
    def __init__(
        self,
        alarm_history: List[DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory] = None,
    ):
        self.alarm_history = alarm_history

    def validate(self):
        if self.alarm_history:
            for k in self.alarm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmHistory'] = []
        if self.alarm_history is not None:
            for k in self.alarm_history:
                result['AlarmHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_history = []
        if m.get('AlarmHistory') is not None:
            for k in m.get('AlarmHistory'):
                temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory()
                self.alarm_history.append(temp_model.from_map(k))
        return self


class DescribeAlertHistoryListResponseBody(TeaModel):
    def __init__(
        self,
        alarm_history_list: DescribeAlertHistoryListResponseBodyAlarmHistoryList = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: str = None,
    ):
        self.alarm_history_list = alarm_history_list
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.alarm_history_list:
            self.alarm_history_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_history_list is not None:
            result['AlarmHistoryList'] = self.alarm_history_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmHistoryList') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryList()
            self.alarm_history_list = temp_model.from_map(m['AlarmHistoryList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertHistoryListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertHistoryListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertHistoryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogCountRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        start_time: int = None,
    ):
        self.contact_group = contact_group
        self.end_time = end_time
        self.group_by = group_by
        self.group_id = group_id
        self.last_min = last_min
        self.level = level
        self.metric_name = metric_name
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.product = product
        self.region_id = region_id
        self.rule_name = rule_name
        self.search_key = search_key
        self.send_status = send_status
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCountLogs(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCount(TeaModel):
    def __init__(
        self,
        count: int = None,
        logs: List[DescribeAlertLogCountResponseBodyAlertLogCountLogs] = None,
    ):
        self.count = count
        self.logs = logs

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCountLogs()
                self.logs.append(temp_model.from_map(k))
        return self


class DescribeAlertLogCountResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_count: List[DescribeAlertLogCountResponseBodyAlertLogCount] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.alert_log_count = alert_log_count
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.alert_log_count:
            for k in self.alert_log_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogCount'] = []
        if self.alert_log_count is not None:
            for k in self.alert_log_count:
                result['AlertLogCount'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_count = []
        if m.get('AlertLogCount') is not None:
            for k in m.get('AlertLogCount'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCount()
                self.alert_log_count.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogHistogramRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        start_time: int = None,
    ):
        self.contact_group = contact_group
        self.end_time = end_time
        self.group_by = group_by
        self.group_id = group_id
        self.last_min = last_min
        self.level = level
        self.metric_name = metric_name
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.product = product
        self.region_id = region_id
        self.rule_name = rule_name
        self.search_key = search_key
        self.send_status = send_status
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogHistogramResponseBodyAlertLogHistogramList(TeaModel):
    def __init__(
        self,
        count: int = None,
        from_: int = None,
        to: int = None,
    ):
        self.count = count
        self.from_ = from_
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.from_ is not None:
            result['From'] = self.from_
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class DescribeAlertLogHistogramResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_histogram_list: List[DescribeAlertLogHistogramResponseBodyAlertLogHistogramList] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.alert_log_histogram_list = alert_log_histogram_list
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.alert_log_histogram_list:
            for k in self.alert_log_histogram_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogHistogramList'] = []
        if self.alert_log_histogram_list is not None:
            for k in self.alert_log_histogram_list:
                result['AlertLogHistogramList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_histogram_list = []
        if m.get('AlertLogHistogramList') is not None:
            for k in m.get('AlertLogHistogramList'):
                temp_model = DescribeAlertLogHistogramResponseBodyAlertLogHistogramList()
                self.alert_log_histogram_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogHistogramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogHistogramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogListRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        start_time: int = None,
    ):
        self.contact_group = contact_group
        self.end_time = end_time
        self.group_by = group_by
        self.group_id = group_id
        self.last_min = last_min
        self.level = level
        self.metric_name = metric_name
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.product = product
        self.region_id = region_id
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.search_key = search_key
        self.send_status = send_status
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogListResponseBodyAlertLogListDimensions(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListEscalation(TeaModel):
    def __init__(
        self,
        expression: str = None,
        level: str = None,
        times: int = None,
    ):
        self.expression = expression
        self.level = level
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertLogListResponseBodyAlertLogListExtendedInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList(TeaModel):
    def __init__(
        self,
        code: str = None,
        detail: str = None,
        request_id: str = None,
        success: bool = None,
        notify_target_list: List[str] = None,
    ):
        self.code = code
        self.detail = detail
        self.request_id = request_id
        self.success = success
        self.notify_target_list = notify_target_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.notify_target_list is not None:
            result['notifyTargetList'] = self.notify_target_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('notifyTargetList') is not None:
            self.notify_target_list = m.get('notifyTargetList')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList(TeaModel):
    def __init__(
        self,
        channel: str = None,
        result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList] = None,
    ):
        self.channel = channel
        self.result_list = result_list

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetail(TeaModel):
    def __init__(
        self,
        channel_result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList] = None,
        result_code: str = None,
    ):
        self.channel_result_list = channel_result_list
        self.result_code = result_code

    def validate(self):
        if self.channel_result_list:
            for k in self.channel_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelResultList'] = []
        if self.channel_result_list is not None:
            for k in self.channel_result_list:
                result['ChannelResultList'].append(k.to_map() if k else None)
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel_result_list = []
        if m.get('ChannelResultList') is not None:
            for k in m.get('ChannelResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList()
                self.channel_result_list.append(temp_model.from_map(k))
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendResultList(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListWebhookList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        url: str = None,
    ):
        self.code = code
        self.message = message
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class DescribeAlertLogListResponseBodyAlertLogList(TeaModel):
    def __init__(
        self,
        alert_time: str = None,
        black_list_detail: str = None,
        black_list_name: str = None,
        black_list_uuid: str = None,
        contact_aliiwwlist: List[str] = None,
        contact_ding_list: List[str] = None,
        contact_groups: List[str] = None,
        contact_mail_list: List[str] = None,
        contact_on_call_list: List[str] = None,
        contact_smslist: List[str] = None,
        dimensions: List[DescribeAlertLogListResponseBodyAlertLogListDimensions] = None,
        dingding_webhook_list: List[str] = None,
        escalation: DescribeAlertLogListResponseBodyAlertLogListEscalation = None,
        event_name: str = None,
        extended_info: List[DescribeAlertLogListResponseBodyAlertLogListExtendedInfo] = None,
        group_id: str = None,
        group_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        level: str = None,
        level_change: str = None,
        message: str = None,
        metric_name: str = None,
        namespace: str = None,
        product: str = None,
        rule_id: str = None,
        rule_name: str = None,
        send_detail: DescribeAlertLogListResponseBodyAlertLogListSendDetail = None,
        send_result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendResultList] = None,
        send_status: str = None,
        webhook_list: List[DescribeAlertLogListResponseBodyAlertLogListWebhookList] = None,
    ):
        self.alert_time = alert_time
        self.black_list_detail = black_list_detail
        self.black_list_name = black_list_name
        self.black_list_uuid = black_list_uuid
        self.contact_aliiwwlist = contact_aliiwwlist
        self.contact_ding_list = contact_ding_list
        self.contact_groups = contact_groups
        self.contact_mail_list = contact_mail_list
        self.contact_on_call_list = contact_on_call_list
        self.contact_smslist = contact_smslist
        self.dimensions = dimensions
        self.dingding_webhook_list = dingding_webhook_list
        self.escalation = escalation
        self.event_name = event_name
        self.extended_info = extended_info
        self.group_id = group_id
        self.group_name = group_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.level = level
        self.level_change = level_change
        self.message = message
        self.metric_name = metric_name
        self.namespace = namespace
        self.product = product
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.send_detail = send_detail
        self.send_result_list = send_result_list
        self.send_status = send_status
        self.webhook_list = webhook_list

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()
        if self.escalation:
            self.escalation.validate()
        if self.extended_info:
            for k in self.extended_info:
                if k:
                    k.validate()
        if self.send_detail:
            self.send_detail.validate()
        if self.send_result_list:
            for k in self.send_result_list:
                if k:
                    k.validate()
        if self.webhook_list:
            for k in self.webhook_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.black_list_detail is not None:
            result['BlackListDetail'] = self.black_list_detail
        if self.black_list_name is not None:
            result['BlackListName'] = self.black_list_name
        if self.black_list_uuid is not None:
            result['BlackListUUID'] = self.black_list_uuid
        if self.contact_aliiwwlist is not None:
            result['ContactALIIWWList'] = self.contact_aliiwwlist
        if self.contact_ding_list is not None:
            result['ContactDingList'] = self.contact_ding_list
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.contact_mail_list is not None:
            result['ContactMailList'] = self.contact_mail_list
        if self.contact_on_call_list is not None:
            result['ContactOnCallList'] = self.contact_on_call_list
        if self.contact_smslist is not None:
            result['ContactSMSList'] = self.contact_smslist
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.dingding_webhook_list is not None:
            result['DingdingWebhookList'] = self.dingding_webhook_list
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        result['ExtendedInfo'] = []
        if self.extended_info is not None:
            for k in self.extended_info:
                result['ExtendedInfo'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.level_change is not None:
            result['LevelChange'] = self.level_change
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product is not None:
            result['Product'] = self.product
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.send_detail is not None:
            result['SendDetail'] = self.send_detail.to_map()
        result['SendResultList'] = []
        if self.send_result_list is not None:
            for k in self.send_result_list:
                result['SendResultList'].append(k.to_map() if k else None)
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        result['WebhookList'] = []
        if self.webhook_list is not None:
            for k in self.webhook_list:
                result['WebhookList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('BlackListDetail') is not None:
            self.black_list_detail = m.get('BlackListDetail')
        if m.get('BlackListName') is not None:
            self.black_list_name = m.get('BlackListName')
        if m.get('BlackListUUID') is not None:
            self.black_list_uuid = m.get('BlackListUUID')
        if m.get('ContactALIIWWList') is not None:
            self.contact_aliiwwlist = m.get('ContactALIIWWList')
        if m.get('ContactDingList') is not None:
            self.contact_ding_list = m.get('ContactDingList')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('ContactMailList') is not None:
            self.contact_mail_list = m.get('ContactMailList')
        if m.get('ContactOnCallList') is not None:
            self.contact_on_call_list = m.get('ContactOnCallList')
        if m.get('ContactSMSList') is not None:
            self.contact_smslist = m.get('ContactSMSList')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('DingdingWebhookList') is not None:
            self.dingding_webhook_list = m.get('DingdingWebhookList')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        self.extended_info = []
        if m.get('ExtendedInfo') is not None:
            for k in m.get('ExtendedInfo'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListExtendedInfo()
                self.extended_info.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelChange') is not None:
            self.level_change = m.get('LevelChange')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SendDetail') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetail()
            self.send_detail = temp_model.from_map(m['SendDetail'])
        self.send_result_list = []
        if m.get('SendResultList') is not None:
            for k in m.get('SendResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendResultList()
                self.send_result_list.append(temp_model.from_map(k))
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        self.webhook_list = []
        if m.get('WebhookList') is not None:
            for k in m.get('WebhookList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListWebhookList()
                self.webhook_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_list: List[DescribeAlertLogListResponseBodyAlertLogList] = None,
        code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.alert_log_list = alert_log_list
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.alert_log_list:
            for k in self.alert_log_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogList'] = []
        if self.alert_log_list is not None:
            for k in self.alert_log_list:
                result['AlertLogList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_list = []
        if m.get('AlertLogList') is not None:
            for k in m.get('AlertLogList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogList()
                self.alert_log_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertingMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        group_id: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_id: str = None,
    ):
        self.dimensions = dimensions
        self.group_id = group_id
        self.namespace = namespace
        self.page = page
        self.page_size = page_size
        self.region_id = region_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.metric_name = metric_name
        self.period = period
        self.statistics = statistics
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList(TeaModel):
    def __init__(
        self,
        expression_list: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList] = None,
    ):
        self.expression_list = expression_list

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        expression: str = None,
        expression_list: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList = None,
        expression_list_join: str = None,
        level: int = None,
        pre_condition: str = None,
        tag: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.expression = expression
        self.expression_list = expression_list
        self.expression_list_join = expression_list_join
        self.level = level
        self.pre_condition = pre_condition
        self.tag = tag
        self.threshold = threshold
        self.times = times

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.level is not None:
            result['Level'] = self.level
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('ExpressionList') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation(TeaModel):
    def __init__(
        self,
        resource: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        enable: str = None,
        escalation: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation = None,
        group_id: str = None,
        last_alert_time: str = None,
        last_modify_time: str = None,
        level: int = None,
        metric_name: str = None,
        metric_values: str = None,
        namespace: str = None,
        product_category: str = None,
        resource: str = None,
        retry_times: str = None,
        rule_id: str = None,
        rule_name: str = None,
        start_time: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        self.dimensions = dimensions
        self.enable = enable
        self.escalation = escalation
        self.group_id = group_id
        self.last_alert_time = last_alert_time
        self.last_modify_time = last_modify_time
        self.level = level
        self.metric_name = metric_name
        self.metric_values = metric_values
        self.namespace = namespace
        self.product_category = product_category
        self.resource = resource
        self.retry_times = retry_times
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.start_time = start_time
        self.statistics = statistics
        self.threshold = threshold

    def validate(self):
        if self.escalation:
            self.escalation.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_alert_time is not None:
            result['LastAlertTime'] = self.last_alert_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_values is not None:
            result['MetricValues'] = self.metric_values
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product_category is not None:
            result['ProductCategory'] = self.product_category
        if self.resource is not None:
            result['Resource'] = self.resource
        if self.retry_times is not None:
            result['RetryTimes'] = self.retry_times
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastAlertTime') is not None:
            self.last_alert_time = m.get('LastAlertTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricValues') is not None:
            self.metric_values = m.get('MetricValues')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ProductCategory') is not None:
            self.product_category = m.get('ProductCategory')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        if m.get('RetryTimes') is not None:
            self.retry_times = m.get('RetryTimes')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resources: DescribeAlertingMetricRuleResourcesResponseBodyResources = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertingMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertingMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactGroupListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts(TeaModel):
    def __init__(
        self,
        contact: List[str] = None,
    ):
        self.contact = contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroup(TeaModel):
    def __init__(
        self,
        contacts: DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts = None,
        create_time: int = None,
        describe: str = None,
        enable_subscribed: bool = None,
        enabled_weekly_report: bool = None,
        name: str = None,
        update_time: int = None,
    ):
        self.contacts = contacts
        self.create_time = create_time
        self.describe = describe
        self.enable_subscribed = enable_subscribed
        self.enabled_weekly_report = enabled_weekly_report
        self.name = name
        self.update_time = update_time

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.enable_subscribed is not None:
            result['EnableSubscribed'] = self.enable_subscribed
        if self.enabled_weekly_report is not None:
            result['EnabledWeeklyReport'] = self.enabled_weekly_report
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contacts') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('EnableSubscribed') is not None:
            self.enable_subscribed = m.get('EnableSubscribed')
        if m.get('EnabledWeeklyReport') is not None:
            self.enabled_weekly_report = m.get('EnabledWeeklyReport')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactGroupListResponseBodyContactGroupList(TeaModel):
    def __init__(
        self,
        contact_group: List[DescribeContactGroupListResponseBodyContactGroupListContactGroup] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DescribeContactGroupListResponseBodyContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactGroupListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contact_group_list: DescribeContactGroupListResponseBodyContactGroupList = None,
        contact_groups: DescribeContactGroupListResponseBodyContactGroups = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.contact_group_list = contact_group_list
        self.contact_groups = contact_groups
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactGroupListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactGroupListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListRequest(TeaModel):
    def __init__(
        self,
        chanel_type: str = None,
        chanel_value: str = None,
        contact_name: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.chanel_type = chanel_type
        self.chanel_value = chanel_value
        self.contact_name = contact_name
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chanel_type is not None:
            result['ChanelType'] = self.chanel_type
        if self.chanel_value is not None:
            result['ChanelValue'] = self.chanel_value
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChanelType') is not None:
            self.chanel_type = m.get('ChanelType')
        if m.get('ChanelValue') is not None:
            self.chanel_value = m.get('ChanelValue')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListResponseBodyContactsContactChannels(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        self.ali_im = ali_im
        self.ding_web_hook = ding_web_hook
        self.mail = mail
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactChannelsState(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        self.ali_im = ali_im
        self.ding_web_hook = ding_web_hook
        self.mail = mail
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactListResponseBodyContactsContact(TeaModel):
    def __init__(
        self,
        channels: DescribeContactListResponseBodyContactsContactChannels = None,
        channels_state: DescribeContactListResponseBodyContactsContactChannelsState = None,
        contact_groups: DescribeContactListResponseBodyContactsContactContactGroups = None,
        create_time: int = None,
        desc: str = None,
        lang: str = None,
        name: str = None,
        update_time: int = None,
    ):
        self.channels = channels
        self.channels_state = channels_state
        self.contact_groups = contact_groups
        self.create_time = create_time
        self.desc = desc
        self.lang = lang
        self.name = name
        self.update_time = update_time

    def validate(self):
        if self.channels:
            self.channels.validate()
        if self.channels_state:
            self.channels_state.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.channels_state is not None:
            result['ChannelsState'] = self.channels_state.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('ChannelsState') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannelsState()
            self.channels_state = temp_model.from_map(m['ChannelsState'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListResponseBodyContacts(TeaModel):
    def __init__(
        self,
        contact: List[DescribeContactListResponseBodyContactsContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contacts: DescribeContactListResponseBodyContacts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.contacts = contacts
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListByContactGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
        region_id: str = None,
    ):
        self.contact_group_name = contact_group_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContactChannels(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        self.ali_im = ali_im
        self.ding_web_hook = ding_web_hook
        self.mail = mail
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContact(TeaModel):
    def __init__(
        self,
        channels: DescribeContactListByContactGroupResponseBodyContactsContactChannels = None,
        create_time: int = None,
        desc: str = None,
        name: str = None,
        update_time: int = None,
    ):
        self.channels = channels
        self.create_time = create_time
        self.desc = desc
        self.name = name
        self.update_time = update_time

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListByContactGroupResponseBodyContacts(TeaModel):
    def __init__(
        self,
        contact: List[DescribeContactListByContactGroupResponseBodyContactsContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListByContactGroupResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListByContactGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contacts: DescribeContactListByContactGroupResponseBodyContacts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.contacts = contacts
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeContactListByContactGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactListByContactGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListByContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventAttributeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.event_id = event_id
        self.group_id = group_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent(TeaModel):
    def __init__(
        self,
        content: str = None,
        group_id: str = None,
        id: str = None,
        name: str = None,
        time: str = None,
    ):
        self.content = content
        self.group_id = group_id
        self.id = id
        self.name = name
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEvents(TeaModel):
    def __init__(
        self,
        custom_event: List[DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent] = None,
    ):
        self.custom_event = custom_event

    def validate(self):
        if self.custom_event:
            for k in self.custom_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEvent'] = []
        if self.custom_event is not None:
            for k in self.custom_event:
                result['CustomEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_event = []
        if m.get('CustomEvent') is not None:
            for k in m.get('CustomEvent'):
                temp_model = DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent()
                self.custom_event.append(temp_model.from_map(k))
        return self


class DescribeCustomEventAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        custom_events: DescribeCustomEventAttributeResponseBodyCustomEvents = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.custom_events = custom_events
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.custom_events:
            self.custom_events.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_events is not None:
            result['CustomEvents'] = self.custom_events.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEvents') is not None:
            temp_model = DescribeCustomEventAttributeResponseBodyCustomEvents()
            self.custom_events = temp_model.from_map(m['CustomEvents'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventCountRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        name: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.event_id = event_id
        self.group_id = group_id
        self.name = name
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount(TeaModel):
    def __init__(
        self,
        name: str = None,
        num: int = None,
        time: int = None,
    ):
        self.name = name
        self.num = num
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.num is not None:
            result['Num'] = self.num
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCounts(TeaModel):
    def __init__(
        self,
        custom_event_count: List[DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount] = None,
    ):
        self.custom_event_count = custom_event_count

    def validate(self):
        if self.custom_event_count:
            for k in self.custom_event_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEventCount'] = []
        if self.custom_event_count is not None:
            for k in self.custom_event_count:
                result['CustomEventCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_event_count = []
        if m.get('CustomEventCount') is not None:
            for k in m.get('CustomEventCount'):
                temp_model = DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount()
                self.custom_event_count.append(temp_model.from_map(k))
        return self


class DescribeCustomEventCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        custom_event_counts: DescribeCustomEventCountResponseBodyCustomEventCounts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.custom_event_counts = custom_event_counts
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.custom_event_counts:
            self.custom_event_counts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_event_counts is not None:
            result['CustomEventCounts'] = self.custom_event_counts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEventCounts') is not None:
            temp_model = DescribeCustomEventCountResponseBodyCustomEventCounts()
            self.custom_event_counts = temp_model.from_map(m['CustomEventCounts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventHistogramRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        level: str = None,
        name: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.event_id = event_id
        self.group_id = group_id
        self.level = level
        self.name = name
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram(TeaModel):
    def __init__(
        self,
        count: int = None,
        end_time: int = None,
        start_time: int = None,
    ):
        self.count = count
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistograms(TeaModel):
    def __init__(
        self,
        event_histogram: List[DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram] = None,
    ):
        self.event_histogram = event_histogram

    def validate(self):
        if self.event_histogram:
            for k in self.event_histogram:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventHistogram'] = []
        if self.event_histogram is not None:
            for k in self.event_histogram:
                result['EventHistogram'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_histogram = []
        if m.get('EventHistogram') is not None:
            for k in m.get('EventHistogram'):
                temp_model = DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram()
                self.event_histogram.append(temp_model.from_map(k))
        return self


class DescribeCustomEventHistogramResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        event_histograms: DescribeCustomEventHistogramResponseBodyEventHistograms = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.event_histograms = event_histograms
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.event_histograms:
            self.event_histograms.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_histograms is not None:
            result['EventHistograms'] = self.event_histograms.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventHistograms') is not None:
            temp_model = DescribeCustomEventHistogramResponseBodyEventHistograms()
            self.event_histograms = temp_model.from_map(m['EventHistograms'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventHistogramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventHistogramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomMetricListRequest(TeaModel):
    def __init__(
        self,
        dimension: str = None,
        group_id: str = None,
        md_5: str = None,
        metric_name: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
    ):
        self.dimension = dimension
        self.group_id = group_id
        self.md_5 = md_5
        self.metric_name = metric_name
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomMetricListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DescribeCustomMetricListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomMetricListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDynamicTagRuleListRequest(TeaModel):
    def __init__(
        self,
        page_number: str = None,
        page_size: str = None,
        tag_key: str = None,
        tag_region_id: str = None,
        tag_value: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.tag_key = tag_key
        self.tag_region_id = tag_region_id
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
    ):
        self.contact_group_list = contact_group_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_value_match_function: str = None,
    ):
        self.tag_value = tag_value
        self.tag_value_match_function = tag_value_match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress(TeaModel):
    def __init__(
        self,
        match_express: List[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress] = None,
    ):
        self.match_express = match_express

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList(TeaModel):
    def __init__(
        self,
        template_id_list: List[str] = None,
    ):
        self.template_id_list = template_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup(TeaModel):
    def __init__(
        self,
        contact_group_list: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList = None,
        dynamic_tag_rule_id: str = None,
        match_express: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress = None,
        match_express_filter_relation: str = None,
        region_id: str = None,
        status: str = None,
        tag_key: str = None,
        template_id_list: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList = None,
    ):
        self.contact_group_list = contact_group_list
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        self.match_express = match_express
        self.match_express_filter_relation = match_express_filter_relation
        self.region_id = region_id
        self.status = status
        self.tag_key = tag_key
        self.template_id_list = template_id_list

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.match_express:
            self.match_express.validate()
        if self.template_id_list:
            self.template_id_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TemplateIdList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList()
            self.template_id_list = temp_model.from_map(m['TemplateIdList'])
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupList(TeaModel):
    def __init__(
        self,
        tag_group: List[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup] = None,
    ):
        self.tag_group = tag_group

    def validate(self):
        if self.tag_group:
            for k in self.tag_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagGroup'] = []
        if self.tag_group is not None:
            for k in self.tag_group:
                result['TagGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag_group = []
        if m.get('TagGroup') is not None:
            for k in m.get('TagGroup'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup()
                self.tag_group.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: str = None,
        page_size: str = None,
        request_id: str = None,
        success: bool = None,
        tag_group_list: DescribeDynamicTagRuleListResponseBodyTagGroupList = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.tag_group_list = tag_group_list
        self.total = total

    def validate(self):
        if self.tag_group_list:
            self.tag_group_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_group_list is not None:
            result['TagGroupList'] = self.tag_group_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupList()
            self.tag_group_list = temp_model.from_map(m['TagGroupList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDynamicTagRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDynamicTagRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleAttributeRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
    ):
        self.region_id = region_id
        self.rule_name = rule_name
        self.silence_time = silence_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList(TeaModel):
    def __init__(
        self,
        level_list: List[str] = None,
    ):
        self.level_list = level_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternNameList(TeaModel):
    def __init__(
        self,
        name_list: List[str] = None,
    ):
        self.name_list = name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList(TeaModel):
    def __init__(
        self,
        status_list: List[str] = None,
    ):
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPattern(TeaModel):
    def __init__(
        self,
        level_list: DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList = None,
        name_list: DescribeEventRuleAttributeResponseBodyResultEventPatternNameList = None,
        product: str = None,
        status_list: DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList = None,
    ):
        self.level_list = level_list
        self.name_list = name_list
        self.product = product
        self.status_list = status_list

    def validate(self):
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()
        if self.status_list:
            self.status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.status_list is not None:
            result['StatusList'] = self.status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('StatusList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList()
            self.status_list = temp_model.from_map(m['StatusList'])
        return self


class DescribeEventRuleAttributeResponseBodyResult(TeaModel):
    def __init__(
        self,
        description: str = None,
        event_pattern: DescribeEventRuleAttributeResponseBodyResultEventPattern = None,
        event_type: str = None,
        group_id: str = None,
        name: str = None,
        state: str = None,
    ):
        self.description = description
        self.event_pattern = event_pattern
        self.event_type = event_type
        self.group_id = group_id
        self.name = name
        self.state = state

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: DescribeEventRuleAttributeResponseBodyResult = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEventRuleAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleListRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        name_prefix: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.name_prefix = name_prefix
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name_prefix is not None:
            result['NamePrefix'] = self.name_prefix
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('NamePrefix') is not None:
            self.name_prefix = m.get('NamePrefix')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList(TeaModel):
    def __init__(
        self,
        event_type_list: List[str] = None,
    ):
        self.event_type_list = event_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords(TeaModel):
    def __init__(
        self,
        keywords: List[str] = None,
    ):
        self.keywords = keywords

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter(TeaModel):
    def __init__(
        self,
        keywords: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords = None,
        relation: str = None,
    ):
        self.keywords = keywords
        self.relation = relation

    def validate(self):
        if self.keywords:
            self.keywords.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords.to_map()
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords()
            self.keywords = temp_model.from_map(m['Keywords'])
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList(TeaModel):
    def __init__(
        self,
        level_list: List[str] = None,
    ):
        self.level_list = level_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList(TeaModel):
    def __init__(
        self,
        name_list: List[str] = None,
    ):
        self.name_list = name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern(TeaModel):
    def __init__(
        self,
        custom_filters: str = None,
        event_type_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList = None,
        keyword_filter: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter = None,
        level_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList = None,
        name_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList = None,
        product: str = None,
        sqlfilter: str = None,
    ):
        self.custom_filters = custom_filters
        self.event_type_list = event_type_list
        self.keyword_filter = keyword_filter
        self.level_list = level_list
        self.name_list = name_list
        self.product = product
        self.sqlfilter = sqlfilter

    def validate(self):
        if self.event_type_list:
            self.event_type_list.validate()
        if self.keyword_filter:
            self.keyword_filter.validate()
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_filters is not None:
            result['CustomFilters'] = self.custom_filters
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list.to_map()
        if self.keyword_filter is not None:
            result['KeywordFilter'] = self.keyword_filter.to_map()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.sqlfilter is not None:
            result['SQLFilter'] = self.sqlfilter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomFilters') is not None:
            self.custom_filters = m.get('CustomFilters')
        if m.get('EventTypeList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList()
            self.event_type_list = temp_model.from_map(m['EventTypeList'])
        if m.get('KeywordFilter') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter()
            self.keyword_filter = temp_model.from_map(m['KeywordFilter'])
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('SQLFilter') is not None:
            self.sqlfilter = m.get('SQLFilter')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern(TeaModel):
    def __init__(
        self,
        event_pattern: List[DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern] = None,
    ):
        self.event_pattern = event_pattern

    def validate(self):
        if self.event_pattern:
            for k in self.event_pattern:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventPattern'] = []
        if self.event_pattern is not None:
            for k in self.event_pattern:
                result['EventPattern'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_pattern = []
        if m.get('EventPattern') is not None:
            for k in m.get('EventPattern'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern()
                self.event_pattern.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        event_pattern: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern = None,
        event_type: str = None,
        group_id: str = None,
        name: str = None,
        silence_time: int = None,
        state: str = None,
    ):
        self.description = description
        self.event_pattern = event_pattern
        self.event_type = event_type
        self.group_id = group_id
        self.name = name
        self.silence_time = silence_time
        self.state = state

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleListResponseBodyEventRules(TeaModel):
    def __init__(
        self,
        event_rule: List[DescribeEventRuleListResponseBodyEventRulesEventRule] = None,
    ):
        self.event_rule = event_rule

    def validate(self):
        if self.event_rule:
            for k in self.event_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventRule'] = []
        if self.event_rule is not None:
            for k in self.event_rule:
                result['EventRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_rule = []
        if m.get('EventRule') is not None:
            for k in m.get('EventRule'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRule()
                self.event_rule.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        event_rules: DescribeEventRuleListResponseBodyEventRules = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.event_rules = event_rules
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.event_rules:
            self.event_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_rules is not None:
            result['EventRules'] = self.event_rules.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventRules') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRules()
            self.event_rules = temp_model.from_map(m['EventRules'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeEventRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleTargetListRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
    ):
        self.region_id = region_id
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeEventRuleTargetListResponseBodyContactParametersContactParameter(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
        id: str = None,
        level: str = None,
    ):
        self.contact_group_name = contact_group_name
        self.id = id
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeEventRuleTargetListResponseBodyContactParameters(TeaModel):
    def __init__(
        self,
        contact_parameter: List[DescribeEventRuleTargetListResponseBodyContactParametersContactParameter] = None,
    ):
        self.contact_parameter = contact_parameter

    def validate(self):
        if self.contact_parameter:
            for k in self.contact_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactParameter'] = []
        if self.contact_parameter is not None:
            for k in self.contact_parameter:
                result['ContactParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_parameter = []
        if m.get('ContactParameter') is not None:
            for k in m.get('ContactParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyContactParametersContactParameter()
                self.contact_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyFcParametersFCParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        function_name: str = None,
        id: str = None,
        region: str = None,
        service_name: str = None,
    ):
        self.arn = arn
        self.function_name = function_name
        self.id = id
        self.region = region
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.id is not None:
            result['Id'] = self.id
        if self.region is not None:
            result['Region'] = self.region
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeEventRuleTargetListResponseBodyFcParameters(TeaModel):
    def __init__(
        self,
        fcparameter: List[DescribeEventRuleTargetListResponseBodyFcParametersFCParameter] = None,
    ):
        self.fcparameter = fcparameter

    def validate(self):
        if self.fcparameter:
            for k in self.fcparameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FCParameter'] = []
        if self.fcparameter is not None:
            for k in self.fcparameter:
                result['FCParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fcparameter = []
        if m.get('FCParameter') is not None:
            for k in m.get('FCParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyFcParametersFCParameter()
                self.fcparameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        queue: str = None,
        region: str = None,
        topic: str = None,
    ):
        self.arn = arn
        self.id = id
        self.queue = queue
        self.region = region
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.region is not None:
            result['Region'] = self.region
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DescribeEventRuleTargetListResponseBodyMnsParameters(TeaModel):
    def __init__(
        self,
        mns_parameter: List[DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter] = None,
    ):
        self.mns_parameter = mns_parameter

    def validate(self):
        if self.mns_parameter:
            for k in self.mns_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MnsParameter'] = []
        if self.mns_parameter is not None:
            for k in self.mns_parameter:
                result['MnsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mns_parameter = []
        if m.get('MnsParameter') is not None:
            for k in m.get('MnsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter()
                self.mns_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters(TeaModel):
    def __init__(
        self,
        action: str = None,
        arn: str = None,
        id: str = None,
        product: str = None,
        region: str = None,
        role: str = None,
        version: str = None,
    ):
        self.action = action
        self.arn = arn
        self.id = id
        self.product = product
        self.region = region
        self.role = role
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.product is not None:
            result['Product'] = self.product
        if self.region is not None:
            result['Region'] = self.region
        if self.role is not None:
            result['Role'] = self.role
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParameters(TeaModel):
    def __init__(
        self,
        open_api_parameters: List[DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters] = None,
    ):
        self.open_api_parameters = open_api_parameters

    def validate(self):
        if self.open_api_parameters:
            for k in self.open_api_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OpenApiParameters'] = []
        if self.open_api_parameters is not None:
            for k in self.open_api_parameters:
                result['OpenApiParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.open_api_parameters = []
        if m.get('OpenApiParameters') is not None:
            for k in m.get('OpenApiParameters'):
                temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters()
                self.open_api_parameters.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        log_store: str = None,
        project: str = None,
        region: str = None,
    ):
        self.arn = arn
        self.id = id
        self.log_store = log_store
        self.project = project
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeEventRuleTargetListResponseBodySlsParameters(TeaModel):
    def __init__(
        self,
        sls_parameter: List[DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter] = None,
    ):
        self.sls_parameter = sls_parameter

    def validate(self):
        if self.sls_parameter:
            for k in self.sls_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlsParameter'] = []
        if self.sls_parameter is not None:
            for k in self.sls_parameter:
                result['SlsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sls_parameter = []
        if m.get('SlsParameter') is not None:
            for k in m.get('SlsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter()
                self.sls_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter(TeaModel):
    def __init__(
        self,
        id: str = None,
        method: str = None,
        protocol: str = None,
        url: str = None,
    ):
        self.id = id
        self.method = method
        self.protocol = protocol
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.method is not None:
            result['Method'] = self.method
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParameters(TeaModel):
    def __init__(
        self,
        webhook_parameter: List[DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter] = None,
    ):
        self.webhook_parameter = webhook_parameter

    def validate(self):
        if self.webhook_parameter:
            for k in self.webhook_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WebhookParameter'] = []
        if self.webhook_parameter is not None:
            for k in self.webhook_parameter:
                result['WebhookParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.webhook_parameter = []
        if m.get('WebhookParameter') is not None:
            for k in m.get('WebhookParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter()
                self.webhook_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contact_parameters: DescribeEventRuleTargetListResponseBodyContactParameters = None,
        fc_parameters: DescribeEventRuleTargetListResponseBodyFcParameters = None,
        message: str = None,
        mns_parameters: DescribeEventRuleTargetListResponseBodyMnsParameters = None,
        open_api_parameters: DescribeEventRuleTargetListResponseBodyOpenApiParameters = None,
        request_id: str = None,
        sls_parameters: DescribeEventRuleTargetListResponseBodySlsParameters = None,
        webhook_parameters: DescribeEventRuleTargetListResponseBodyWebhookParameters = None,
    ):
        self.code = code
        self.contact_parameters = contact_parameters
        self.fc_parameters = fc_parameters
        self.message = message
        self.mns_parameters = mns_parameters
        self.open_api_parameters = open_api_parameters
        self.request_id = request_id
        self.sls_parameters = sls_parameters
        self.webhook_parameters = webhook_parameters

    def validate(self):
        if self.contact_parameters:
            self.contact_parameters.validate()
        if self.fc_parameters:
            self.fc_parameters.validate()
        if self.mns_parameters:
            self.mns_parameters.validate()
        if self.open_api_parameters:
            self.open_api_parameters.validate()
        if self.sls_parameters:
            self.sls_parameters.validate()
        if self.webhook_parameters:
            self.webhook_parameters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_parameters is not None:
            result['ContactParameters'] = self.contact_parameters.to_map()
        if self.fc_parameters is not None:
            result['FcParameters'] = self.fc_parameters.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.mns_parameters is not None:
            result['MnsParameters'] = self.mns_parameters.to_map()
        if self.open_api_parameters is not None:
            result['OpenApiParameters'] = self.open_api_parameters.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sls_parameters is not None:
            result['SlsParameters'] = self.sls_parameters.to_map()
        if self.webhook_parameters is not None:
            result['WebhookParameters'] = self.webhook_parameters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyContactParameters()
            self.contact_parameters = temp_model.from_map(m['ContactParameters'])
        if m.get('FcParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyFcParameters()
            self.fc_parameters = temp_model.from_map(m['FcParameters'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MnsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyMnsParameters()
            self.mns_parameters = temp_model.from_map(m['MnsParameters'])
        if m.get('OpenApiParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParameters()
            self.open_api_parameters = temp_model.from_map(m['OpenApiParameters'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodySlsParameters()
            self.sls_parameters = temp_model.from_map(m['SlsParameters'])
        if m.get('WebhookParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyWebhookParameters()
            self.webhook_parameters = temp_model.from_map(m['WebhookParameters'])
        return self


class DescribeEventRuleTargetListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleTargetListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleTargetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterOutputListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson(TeaModel):
    def __init__(
        self,
        ak: str = None,
        endpoint: str = None,
        logstore: str = None,
        project: str = None,
    ):
        self.ak = ak
        self.endpoint = endpoint
        self.logstore = logstore
        self.project = project

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ak is not None:
            result['ak'] = self.ak
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.logstore is not None:
            result['logstore'] = self.logstore
        if self.project is not None:
            result['project'] = self.project
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ak') is not None:
            self.ak = m.get('ak')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('logstore') is not None:
            self.logstore = m.get('logstore')
        if m.get('project') is not None:
            self.project = m.get('project')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(
        self,
        config_json: DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson = None,
        create_time: int = None,
        dest_name: str = None,
        dest_type: str = None,
    ):
        self.config_json = config_json
        self.create_time = create_time
        self.dest_name = dest_name
        self.dest_type = dest_type

    def validate(self):
        if self.config_json:
            self.config_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_json is not None:
            result['ConfigJson'] = self.config_json.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.dest_type is not None:
            result['DestType'] = self.dest_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigJson') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson()
            self.config_json = temp_model.from_map(m['ConfigJson'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('DestType') is not None:
            self.dest_type = m.get('DestType')
        return self


class DescribeExporterOutputListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        datapoint: List[DescribeExporterOutputListResponseBodyDatapointsDatapoint] = None,
    ):
        self.datapoint = datapoint

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterOutputListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: DescribeExporterOutputListResponseBodyDatapoints = None,
        message: str = None,
        page_number: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.page_number = page_number
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterOutputListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExporterOutputListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterOutputListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterRuleListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapointDstName(TeaModel):
    def __init__(
        self,
        dst_name: List[str] = None,
    ):
        self.dst_name = dst_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_name is not None:
            result['DstName'] = self.dst_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstName') is not None:
            self.dst_name = m.get('DstName')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        describe: str = None,
        dimension: str = None,
        dst_name: DescribeExporterRuleListResponseBodyDatapointsDatapointDstName = None,
        enabled: bool = None,
        metric_name: str = None,
        namespace: str = None,
        rule_name: str = None,
        target_windows: str = None,
    ):
        self.create_time = create_time
        self.describe = describe
        self.dimension = dimension
        self.dst_name = dst_name
        self.enabled = enabled
        self.metric_name = metric_name
        self.namespace = namespace
        self.rule_name = rule_name
        self.target_windows = target_windows

    def validate(self):
        if self.dst_name:
            self.dst_name.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.dst_name is not None:
            result['DstName'] = self.dst_name.to_map()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.target_windows is not None:
            result['TargetWindows'] = self.target_windows
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('DstName') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapointDstName()
            self.dst_name = temp_model.from_map(m['DstName'])
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('TargetWindows') is not None:
            self.target_windows = m.get('TargetWindows')
        return self


class DescribeExporterRuleListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        datapoint: List[DescribeExporterRuleListResponseBodyDatapointsDatapoint] = None,
    ):
        self.datapoint = datapoint

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: DescribeExporterRuleListResponseBodyDatapoints = None,
        message: str = None,
        page_number: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.page_number = page_number
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExporterRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        process_name: str = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.page_number = page_number
        self.page_size = page_size
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        effective_interval: str = None,
        escalations_level: str = None,
        no_effective_interval: str = None,
        silence_time: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
        webhook: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.effective_interval = effective_interval
        self.escalations_level = escalations_level
        self.no_effective_interval = no_effective_interval
        self.silence_time = silence_time
        self.statistics = statistics
        self.threshold = threshold
        self.times = times
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig(TeaModel):
    def __init__(
        self,
        alert_config: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig] = None,
    ):
        self.alert_config = alert_config

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        self.function = function
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress(TeaModel):
    def __init__(
        self,
        match_express: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress] = None,
    ):
        self.match_express = match_express

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess(TeaModel):
    def __init__(
        self,
        alert_config: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig = None,
        group_id: str = None,
        id: str = None,
        match_express: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress = None,
        match_express_filter_relation: str = None,
        process_name: str = None,
    ):
        self.alert_config = alert_config
        self.group_id = group_id
        self.id = id
        self.match_express = match_express
        self.match_express_filter_relation = match_express_filter_relation
        self.process_name = process_name

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.match_express:
            self.match_express.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcesses(TeaModel):
    def __init__(
        self,
        process: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess] = None,
    ):
        self.process = process

    def validate(self):
        if self.process:
            for k in self.process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Process'] = []
        if self.process is not None:
            for k in self.process:
                result['Process'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.process = []
        if m.get('Process') is not None:
            for k in m.get('Process'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess()
                self.process.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: str = None,
        page_size: str = None,
        processes: DescribeGroupMonitoringAgentProcessResponseBodyProcesses = None,
        request_id: str = None,
        success: bool = None,
        total: str = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.processes = processes
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.processes:
            self.processes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.processes is not None:
            result['Processes'] = self.processes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Processes') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcesses()
            self.processes = temp_model.from_map(m['Processes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHostAvailabilityListRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        id: int = None,
        ids: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        task_name: str = None,
    ):
        self.group_id = group_id
        self.id = id
        self.ids = ids
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList(TeaModel):
    def __init__(
        self,
        aggregate: str = None,
        metric_name: str = None,
        operator: str = None,
        times: str = None,
        value: str = None,
    ):
        self.aggregate = aggregate
        self.metric_name = metric_name
        self.operator = operator
        self.times = times
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList(TeaModel):
    def __init__(
        self,
        escalation_list: List[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList] = None,
    ):
        self.escalation_list = escalation_list

    def validate(self):
        if self.escalation_list:
            for k in self.escalation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['escalationList'] = []
        if self.escalation_list is not None:
            for k in self.escalation_list:
                result['escalationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.escalation_list = []
        if m.get('escalationList') is not None:
            for k in m.get('escalationList'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList()
                self.escalation_list.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        escalation_list: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList = None,
        notify_type: int = None,
        silence_time: int = None,
        start_time: int = None,
        web_hook: str = None,
    ):
        self.end_time = end_time
        self.escalation_list = escalation_list
        self.notify_type = notify_type
        self.silence_time = silence_time
        self.start_time = start_time
        self.web_hook = web_hook

    def validate(self):
        if self.escalation_list:
            self.escalation_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.escalation_list is not None:
            result['EscalationList'] = self.escalation_list.to_map()
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EscalationList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList()
            self.escalation_list = temp_model.from_map(m['EscalationList'])
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances(TeaModel):
    def __init__(
        self,
        instance: List[str] = None,
    ):
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption(TeaModel):
    def __init__(
        self,
        http_keyword: str = None,
        http_method: str = None,
        http_negative: bool = None,
        http_post_content: str = None,
        http_response_charset: str = None,
        http_uri: str = None,
        interval: int = None,
        telnet_or_ping_host: str = None,
    ):
        self.http_keyword = http_keyword
        self.http_method = http_method
        self.http_negative = http_negative
        self.http_post_content = http_post_content
        self.http_response_charset = http_response_charset
        self.http_uri = http_uri
        self.interval = interval
        self.telnet_or_ping_host = telnet_or_ping_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_keyword is not None:
            result['HttpKeyword'] = self.http_keyword
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpKeyword') is not None:
            self.http_keyword = m.get('HttpKeyword')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig(TeaModel):
    def __init__(
        self,
        alert_config: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig = None,
        disabled: bool = None,
        group_id: int = None,
        group_name: str = None,
        id: int = None,
        instances: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances = None,
        task_name: str = None,
        task_option: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption = None,
        task_scope: str = None,
        task_type: str = None,
    ):
        self.alert_config = alert_config
        self.disabled = disabled
        self.group_id = group_id
        self.group_name = group_name
        self.id = id
        self.instances = instances
        self.task_name = task_name
        self.task_option = task_option
        self.task_scope = task_scope
        self.task_type = task_type

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.instances:
            self.instances.validate()
        if self.task_option:
            self.task_option.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Instances') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskOption') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHostAvailabilityListResponseBodyTaskList(TeaModel):
    def __init__(
        self,
        node_task_config: List[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig] = None,
    ):
        self.node_task_config = node_task_config

    def validate(self):
        if self.node_task_config:
            for k in self.node_task_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeTaskConfig'] = []
        if self.node_task_config is not None:
            for k in self.node_task_config:
                result['NodeTaskConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_task_config = []
        if m.get('NodeTaskConfig') is not None:
            for k in m.get('NodeTaskConfig'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig()
                self.node_task_config.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        task_list: DescribeHostAvailabilityListResponseBodyTaskList = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.task_list = task_list
        self.total = total

    def validate(self):
        if self.task_list:
            self.task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_list is not None:
            result['TaskList'] = self.task_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskList()
            self.task_list = temp_model.from_map(m['TaskList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHostAvailabilityListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHostAvailabilityListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHostAvailabilityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorDataListRequest(TeaModel):
    def __init__(
        self,
        end: int = None,
        namespace: str = None,
        period: str = None,
        prom_sql: str = None,
        region_id: str = None,
        start: int = None,
    ):
        self.end = end
        self.namespace = namespace
        self.period = period
        self.prom_sql = prom_sql
        self.region_id = region_id
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.prom_sql is not None:
            result['PromSQL'] = self.prom_sql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PromSQL') is not None:
            self.prom_sql = m.get('PromSQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels(TeaModel):
    def __init__(
        self,
        k: str = None,
        v: str = None,
    ):
        self.k = k
        self.v = v

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.k is not None:
            result['K'] = self.k
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('K') is not None:
            self.k = m.get('K')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesValues(TeaModel):
    def __init__(
        self,
        ts: str = None,
        v: str = None,
    ):
        self.ts = ts
        self.v = v

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['Ts'] = self.ts
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ts') is not None:
            self.ts = m.get('Ts')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeries(TeaModel):
    def __init__(
        self,
        labels: List[DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels] = None,
        metric_name: str = None,
        values: List[DescribeHybridMonitorDataListResponseBodyTimeSeriesValues] = None,
    ):
        self.labels = labels
        self.metric_name = metric_name
        self.values = values

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        time_series: List[DescribeHybridMonitorDataListResponseBodyTimeSeries] = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.time_series = time_series

    def validate(self):
        if self.time_series:
            for k in self.time_series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TimeSeries'] = []
        if self.time_series is not None:
            for k in self.time_series:
                result['TimeSeries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.time_series = []
        if m.get('TimeSeries') is not None:
            for k in m.get('TimeSeries'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeries()
                self.time_series.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorDataListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorDataListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorNamespaceListRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        show_task_statistic: bool = None,
    ):
        self.keyword = keyword
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.show_task_statistic = show_task_statistic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_task_statistic is not None:
            result['ShowTaskStatistic'] = self.show_task_statistic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowTaskStatistic') is not None:
            self.show_task_statistic = m.get('ShowTaskStatistic')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList(TeaModel):
    def __init__(
        self,
        list: List[str] = None,
        period: int = None,
    ):
        self.list = list
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            self.list = m.get('List')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList(TeaModel):
    def __init__(
        self,
        metric_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList] = None,
        namespace: str = None,
    ):
        self.metric_list = metric_list
        self.namespace = namespace

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList()
                self.metric_list.append(temp_model.from_map(k))
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList(TeaModel):
    def __init__(
        self,
        namespace_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList] = None,
        user_id: int = None,
        yamlconfig: str = None,
    ):
        self.namespace_list = namespace_list
        self.user_id = user_id
        self.yamlconfig = yamlconfig

    def validate(self):
        if self.namespace_list:
            for k in self.namespace_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NamespaceList'] = []
        if self.namespace_list is not None:
            for k in self.namespace_list:
                result['NamespaceList'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.yamlconfig is not None:
            result['YAMLConfig'] = self.yamlconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.namespace_list = []
        if m.get('NamespaceList') is not None:
            for k in m.get('NamespaceList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList()
                self.namespace_list.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('YAMLConfig') is not None:
            self.yamlconfig = m.get('YAMLConfig')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail(TeaModel):
    def __init__(
        self,
        spec: str = None,
    ):
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace(TeaModel):
    def __init__(
        self,
        aliyun_product_metric_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList] = None,
        create_time: str = None,
        description: str = None,
        detail: DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail = None,
        id: str = None,
        is_delete: int = None,
        modify_time: str = None,
        namespace: str = None,
        not_aliyun_task_number: int = None,
    ):
        self.aliyun_product_metric_list = aliyun_product_metric_list
        self.create_time = create_time
        self.description = description
        self.detail = detail
        self.id = id
        self.is_delete = is_delete
        self.modify_time = modify_time
        self.namespace = namespace
        self.not_aliyun_task_number = not_aliyun_task_number

    def validate(self):
        if self.aliyun_product_metric_list:
            for k in self.aliyun_product_metric_list:
                if k:
                    k.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AliyunProductMetricList'] = []
        if self.aliyun_product_metric_list is not None:
            for k in self.aliyun_product_metric_list:
                result['AliyunProductMetricList'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_delete is not None:
            result['IsDelete'] = self.is_delete
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.not_aliyun_task_number is not None:
            result['NotAliyunTaskNumber'] = self.not_aliyun_task_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aliyun_product_metric_list = []
        if m.get('AliyunProductMetricList') is not None:
            for k in m.get('AliyunProductMetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList()
                self.aliyun_product_metric_list.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Detail') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail()
            self.detail = temp_model.from_map(m['Detail'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsDelete') is not None:
            self.is_delete = m.get('IsDelete')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NotAliyunTaskNumber') is not None:
            self.not_aliyun_task_number = m.get('NotAliyunTaskNumber')
        return self


class DescribeHybridMonitorNamespaceListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        describe_hybrid_monitor_namespace: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        total: int = None,
    ):
        self.code = code
        self.describe_hybrid_monitor_namespace = describe_hybrid_monitor_namespace
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.describe_hybrid_monitor_namespace:
            for k in self.describe_hybrid_monitor_namespace:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DescribeHybridMonitorNamespace'] = []
        if self.describe_hybrid_monitor_namespace is not None:
            for k in self.describe_hybrid_monitor_namespace:
                result['DescribeHybridMonitorNamespace'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.describe_hybrid_monitor_namespace = []
        if m.get('DescribeHybridMonitorNamespace') is not None:
            for k in m.get('DescribeHybridMonitorNamespace'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace()
                self.describe_hybrid_monitor_namespace.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorNamespaceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorNamespaceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
        slsgroup_name: str = None,
    ):
        self.keyword = keyword
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.slsgroup_name = slsgroup_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig(TeaModel):
    def __init__(
        self,
        slslogstore: str = None,
        slsproject: str = None,
        slsregion: str = None,
        slsuser_id: str = None,
    ):
        self.slslogstore = slslogstore
        self.slsproject = slsproject
        self.slsregion = slsregion
        self.slsuser_id = slsuser_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        slsgroup_config: List[DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig] = None,
        slsgroup_description: str = None,
        slsgroup_name: int = None,
        update_time: str = None,
    ):
        self.create_time = create_time
        self.slsgroup_config = slsgroup_config
        self.slsgroup_description = slsgroup_description
        self.slsgroup_name = slsgroup_name
        self.update_time = update_time

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        list: List[DescribeHybridMonitorSLSGroupResponseBodyList] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        total: int = None,
    ):
        self.code = code
        self.list = list
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorTaskListRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        include_aliyun_task: bool = None,
        keyword: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        task_id: str = None,
        task_type: str = None,
    ):
        self.group_id = group_id
        self.include_aliyun_task = include_aliyun_task
        self.keyword = keyword
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.task_id = task_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.include_aliyun_task is not None:
            result['IncludeAliyunTask'] = self.include_aliyun_task
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IncludeAliyunTask') is not None:
            self.include_aliyun_task = m.get('IncludeAliyunTask')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        self.function = function
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskList(TeaModel):
    def __init__(
        self,
        attach_labels: List[DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels] = None,
        collect_interval: int = None,
        collect_target_endpoint: str = None,
        collect_target_path: str = None,
        collect_target_type: str = None,
        collect_timout: int = None,
        create_time: str = None,
        description: str = None,
        extra_info: str = None,
        group_id: str = None,
        instances: List[str] = None,
        log_file_path: str = None,
        log_process: str = None,
        log_sample: str = None,
        log_split: str = None,
        match_express: List[DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress] = None,
        match_express_relation: str = None,
        namespace: str = None,
        network_type: str = None,
        slsprocess: str = None,
        target_user_id: str = None,
        task_id: str = None,
        task_name: str = None,
        task_type: str = None,
        upload_region: str = None,
        yarmconfig: str = None,
    ):
        self.attach_labels = attach_labels
        self.collect_interval = collect_interval
        self.collect_target_endpoint = collect_target_endpoint
        self.collect_target_path = collect_target_path
        self.collect_target_type = collect_target_type
        self.collect_timout = collect_timout
        self.create_time = create_time
        self.description = description
        self.extra_info = extra_info
        self.group_id = group_id
        self.instances = instances
        self.log_file_path = log_file_path
        self.log_process = log_process
        self.log_sample = log_sample
        self.log_split = log_split
        self.match_express = match_express
        self.match_express_relation = match_express_relation
        self.namespace = namespace
        self.network_type = network_type
        self.slsprocess = slsprocess
        self.target_user_id = target_user_id
        self.task_id = task_id
        self.task_name = task_name
        self.task_type = task_type
        self.upload_region = upload_region
        self.yarmconfig = yarmconfig

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_endpoint is not None:
            result['CollectTargetEndpoint'] = self.collect_target_endpoint
        if self.collect_target_path is not None:
            result['CollectTargetPath'] = self.collect_target_path
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.collect_timout is not None:
            result['CollectTimout'] = self.collect_timout
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instances is not None:
            result['Instances'] = self.instances
        if self.log_file_path is not None:
            result['LogFilePath'] = self.log_file_path
        if self.log_process is not None:
            result['LogProcess'] = self.log_process
        if self.log_sample is not None:
            result['LogSample'] = self.log_sample
        if self.log_split is not None:
            result['LogSplit'] = self.log_split
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_relation is not None:
            result['MatchExpressRelation'] = self.match_express_relation
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.slsprocess is not None:
            result['SLSProcess'] = self.slsprocess
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.upload_region is not None:
            result['UploadRegion'] = self.upload_region
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetEndpoint') is not None:
            self.collect_target_endpoint = m.get('CollectTargetEndpoint')
        if m.get('CollectTargetPath') is not None:
            self.collect_target_path = m.get('CollectTargetPath')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('CollectTimout') is not None:
            self.collect_timout = m.get('CollectTimout')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Instances') is not None:
            self.instances = m.get('Instances')
        if m.get('LogFilePath') is not None:
            self.log_file_path = m.get('LogFilePath')
        if m.get('LogProcess') is not None:
            self.log_process = m.get('LogProcess')
        if m.get('LogSample') is not None:
            self.log_sample = m.get('LogSample')
        if m.get('LogSplit') is not None:
            self.log_split = m.get('LogSplit')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressRelation') is not None:
            self.match_express_relation = m.get('MatchExpressRelation')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('SLSProcess') is not None:
            self.slsprocess = m.get('SLSProcess')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UploadRegion') is not None:
            self.upload_region = m.get('UploadRegion')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class DescribeHybridMonitorTaskListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        task_list: List[DescribeHybridMonitorTaskListResponseBodyTaskList] = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.task_list = task_list
        self.total = total

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorTaskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorTaskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorAttributeRequest(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        region_id: str = None,
    ):
        self.metric_name = metric_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates(TeaModel):
    def __init__(
        self,
        alias: str = None,
        field_name: str = None,
        function: str = None,
        max: str = None,
        min: str = None,
    ):
        self.alias = alias
        self.field_name = field_name
        self.function = function
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.function is not None:
            result['Function'] = self.function
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        value: str = None,
    ):
        self.key = key
        self.operator = operator
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitor(TeaModel):
    def __init__(
        self,
        aggregates: List[DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates] = None,
        gmt_create: int = None,
        group_id: int = None,
        groupbys: List[str] = None,
        log_id: int = None,
        metric_express: str = None,
        metric_name: str = None,
        sls_logstore: str = None,
        sls_project: str = None,
        sls_region_id: str = None,
        tumblingwindows: List[str] = None,
        value_filter: List[DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter] = None,
        value_filter_relation: str = None,
    ):
        self.aggregates = aggregates
        self.gmt_create = gmt_create
        self.group_id = group_id
        self.groupbys = groupbys
        self.log_id = log_id
        self.metric_express = metric_express
        self.metric_name = metric_name
        self.sls_logstore = sls_logstore
        self.sls_project = sls_project
        self.sls_region_id = sls_region_id
        self.tumblingwindows = tumblingwindows
        self.value_filter = value_filter
        self.value_filter_relation = value_filter_relation

    def validate(self):
        if self.aggregates:
            for k in self.aggregates:
                if k:
                    k.validate()
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Aggregates'] = []
        if self.aggregates is not None:
            for k in self.aggregates:
                result['Aggregates'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.groupbys is not None:
            result['Groupbys'] = self.groupbys
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_express is not None:
            result['MetricExpress'] = self.metric_express
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        if self.tumblingwindows is not None:
            result['Tumblingwindows'] = self.tumblingwindows
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aggregates = []
        if m.get('Aggregates') is not None:
            for k in m.get('Aggregates'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates()
                self.aggregates.append(temp_model.from_map(k))
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Groupbys') is not None:
            self.groupbys = m.get('Groupbys')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricExpress') is not None:
            self.metric_express = m.get('MetricExpress')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        if m.get('Tumblingwindows') is not None:
            self.tumblingwindows = m.get('Tumblingwindows')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        log_monitor: DescribeLogMonitorAttributeResponseBodyLogMonitor = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.log_monitor = log_monitor
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.log_monitor:
            self.log_monitor.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.log_monitor is not None:
            result['LogMonitor'] = self.log_monitor.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('LogMonitor') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitor()
            self.log_monitor = temp_model.from_map(m['LogMonitor'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeLogMonitorAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogMonitorAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorListRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        search_value: str = None,
    ):
        self.group_id = group_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.search_value = search_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorListValueFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        value: str = None,
    ):
        self.key = key
        self.operator = operator
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorList(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        group_id: int = None,
        log_id: int = None,
        metric_name: str = None,
        sls_logstore: str = None,
        sls_project: str = None,
        sls_region_id: str = None,
        value_filter: List[DescribeLogMonitorListResponseBodyLogMonitorListValueFilter] = None,
        value_filter_relation: str = None,
    ):
        self.gmt_create = gmt_create
        self.group_id = group_id
        self.log_id = log_id
        self.metric_name = metric_name
        self.sls_logstore = sls_logstore
        self.sls_project = sls_project
        self.sls_region_id = sls_region_id
        self.value_filter = value_filter
        self.value_filter_relation = value_filter_relation

    def validate(self):
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorListValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        log_monitor_list: List[DescribeLogMonitorListResponseBodyLogMonitorList] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.log_monitor_list = log_monitor_list
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.log_monitor_list:
            for k in self.log_monitor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['LogMonitorList'] = []
        if self.log_monitor_list is not None:
            for k in self.log_monitor_list:
                result['LogMonitorList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.log_monitor_list = []
        if m.get('LogMonitorList') is not None:
            for k in m.get('LogMonitorList'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorList()
                self.log_monitor_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLogMonitorListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogMonitorListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricDataRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.dimensions = dimensions
        self.end_time = end_time
        self.express = express
        self.length = length
        self.metric_name = metric_name
        self.namespace = namespace
        self.period = period
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        period: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.period = period
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricLastRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        next_token: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.dimensions = dimensions
        self.end_time = end_time
        self.express = express
        self.length = length
        self.metric_name = metric_name
        self.namespace = namespace
        self.next_token = next_token
        self.period = period
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricLastResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        next_token: str = None,
        period: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.next_token = next_token
        self.period = period
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricLastResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricLastResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricLastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricListRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        next_token: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.dimensions = dimensions
        self.end_time = end_time
        self.express = express
        self.length = length
        self.metric_name = metric_name
        self.namespace = namespace
        self.next_token = next_token
        self.period = period
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        next_token: str = None,
        period: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.next_token = next_token
        self.period = period
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricMetaListRequest(TeaModel):
    def __init__(
        self,
        labels: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.labels = labels
        self.metric_name = metric_name
        self.namespace = namespace
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMetricMetaListResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        description: str = None,
        dimensions: str = None,
        labels: str = None,
        metric_name: str = None,
        namespace: str = None,
        periods: str = None,
        statistics: str = None,
        unit: str = None,
    ):
        self.description = description
        self.dimensions = dimensions
        self.labels = labels
        self.metric_name = metric_name
        self.namespace = namespace
        self.periods = periods
        self.statistics = statistics
        self.unit = unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.periods is not None:
            result['Periods'] = self.periods
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Periods') is not None:
            self.periods = m.get('Periods')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeMetricMetaListResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMetricMetaListResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMetricMetaListResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMetricMetaListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        resources: DescribeMetricMetaListResponseBodyResources = None,
        success: bool = None,
        total_count: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMetricMetaListResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeMetricMetaListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricMetaListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleCountRequest(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        namespace: str = None,
        region_id: str = None,
    ):
        self.metric_name = metric_name
        self.namespace = namespace
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMetricRuleCountResponseBodyMetricRuleCount(TeaModel):
    def __init__(
        self,
        alarm: int = None,
        disable: int = None,
        nodata: int = None,
        ok: int = None,
        total: int = None,
    ):
        self.alarm = alarm
        self.disable = disable
        self.nodata = nodata
        self.ok = ok
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm is not None:
            result['Alarm'] = self.alarm
        if self.disable is not None:
            result['Disable'] = self.disable
        if self.nodata is not None:
            result['Nodata'] = self.nodata
        if self.ok is not None:
            result['Ok'] = self.ok
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alarm') is not None:
            self.alarm = m.get('Alarm')
        if m.get('Disable') is not None:
            self.disable = m.get('Disable')
        if m.get('Nodata') is not None:
            self.nodata = m.get('Nodata')
        if m.get('Ok') is not None:
            self.ok = m.get('Ok')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        metric_rule_count: DescribeMetricRuleCountResponseBodyMetricRuleCount = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.metric_rule_count = metric_rule_count
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.metric_rule_count:
            self.metric_rule_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_rule_count is not None:
            result['MetricRuleCount'] = self.metric_rule_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricRuleCount') is not None:
            temp_model = DescribeMetricRuleCountResponseBodyMetricRuleCount()
            self.metric_rule_count = temp_model.from_map(m['MetricRuleCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricRuleCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleListRequest(TeaModel):
    def __init__(
        self,
        alert_state: str = None,
        dimensions: str = None,
        enable_state: bool = None,
        group_id: str = None,
        metric_name: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_ids: str = None,
        rule_name: str = None,
    ):
        self.alert_state = alert_state
        self.dimensions = dimensions
        self.enable_state = enable_state
        self.group_id = group_id
        self.metric_name = metric_name
        self.namespace = namespace
        self.page = page
        self.page_size = page_size
        self.region_id = region_id
        self.rule_ids = rule_ids
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: int = None,
        statistics: str = None,
        threshold: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.metric_name = metric_name
        self.period = period
        self.statistics = statistics
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList(TeaModel):
    def __init__(
        self,
        expression_list: List[DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList] = None,
    ):
        self.expression_list = expression_list

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression(TeaModel):
    def __init__(
        self,
        expression_list: DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList = None,
        expression_list_join: str = None,
        expression_raw: str = None,
        level: str = None,
        times: int = None,
    ):
        self.expression_list = expression_list
        self.expression_list_join = expression_list_join
        self.expression_raw = expression_raw
        self.level = level
        self.times = times

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.expression_raw is not None:
            result['ExpressionRaw'] = self.expression_raw
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpressionList') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('ExpressionRaw') is not None:
            self.expression_raw = m.get('ExpressionRaw')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations(TeaModel):
    def __init__(
        self,
        critical: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical = None,
        info: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo = None,
        warn: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmLabels(TeaModel):
    def __init__(
        self,
        labels: List[DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels] = None,
    ):
        self.labels = labels

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels()
                self.labels.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations(TeaModel):
    def __init__(
        self,
        annotations: List[DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations] = None,
    ):
        self.annotations = annotations

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations()
                self.annotations.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus(TeaModel):
    def __init__(
        self,
        annotations: DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations = None,
        level: str = None,
        prom_ql: str = None,
        times: int = None,
    ):
        self.annotations = annotations
        self.level = level
        self.prom_ql = prom_ql
        self.times = times

    def validate(self):
        if self.annotations:
            self.annotations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['Annotations'] = self.annotations.to_map()
        if self.level is not None:
            result['Level'] = self.level
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotations') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations()
            self.annotations = temp_model.from_map(m['Annotations'])
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarm(TeaModel):
    def __init__(
        self,
        alert_state: str = None,
        composite_expression: DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression = None,
        contact_groups: str = None,
        dimensions: str = None,
        effective_interval: str = None,
        enable_state: bool = None,
        escalations: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations = None,
        group_id: str = None,
        group_name: str = None,
        labels: DescribeMetricRuleListResponseBodyAlarmsAlarmLabels = None,
        mail_subject: str = None,
        metric_name: str = None,
        namespace: str = None,
        no_data_policy: str = None,
        no_effective_interval: str = None,
        period: str = None,
        prometheus: DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus = None,
        resources: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: int = None,
        source_type: str = None,
        webhook: str = None,
    ):
        self.alert_state = alert_state
        self.composite_expression = composite_expression
        self.contact_groups = contact_groups
        self.dimensions = dimensions
        self.effective_interval = effective_interval
        self.enable_state = enable_state
        self.escalations = escalations
        self.group_id = group_id
        self.group_name = group_name
        self.labels = labels
        self.mail_subject = mail_subject
        self.metric_name = metric_name
        self.namespace = namespace
        self.no_data_policy = no_data_policy
        self.no_effective_interval = no_effective_interval
        self.period = period
        self.prometheus = prometheus
        self.resources = resources
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.silence_time = silence_time
        self.source_type = source_type
        self.webhook = webhook

    def validate(self):
        if self.composite_expression:
            self.composite_expression.validate()
        if self.escalations:
            self.escalations.validate()
        if self.labels:
            self.labels.validate()
        if self.prometheus:
            self.prometheus.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.composite_expression is not None:
            result['CompositeExpression'] = self.composite_expression.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.labels is not None:
            result['Labels'] = self.labels.to_map()
        if self.mail_subject is not None:
            result['MailSubject'] = self.mail_subject
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.prometheus is not None:
            result['Prometheus'] = self.prometheus.to_map()
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('CompositeExpression') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression()
            self.composite_expression = temp_model.from_map(m['CompositeExpression'])
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('Escalations') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Labels') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmLabels()
            self.labels = temp_model.from_map(m['Labels'])
        if m.get('MailSubject') is not None:
            self.mail_subject = m.get('MailSubject')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Prometheus') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus()
            self.prometheus = temp_model.from_map(m['Prometheus'])
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeMetricRuleListResponseBodyAlarms(TeaModel):
    def __init__(
        self,
        alarm: List[DescribeMetricRuleListResponseBodyAlarmsAlarm] = None,
    ):
        self.alarm = alarm

    def validate(self):
        if self.alarm:
            for k in self.alarm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarm'] = []
        if self.alarm is not None:
            for k in self.alarm:
                result['Alarm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm = []
        if m.get('Alarm') is not None:
            for k in m.get('Alarm'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarm()
                self.alarm.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBody(TeaModel):
    def __init__(
        self,
        alarms: DescribeMetricRuleListResponseBodyAlarms = None,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: str = None,
    ):
        self.alarms = alarms
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.alarms:
            self.alarms.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarms is not None:
            result['Alarms'] = self.alarms.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alarms') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarms()
            self.alarms = temp_model.from_map(m['Alarms'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTargetsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_id: str = None,
    ):
        self.region_id = region_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeMetricRuleTargetsResponseBodyTargetsTarget(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        json_params: str = None,
        level: str = None,
    ):
        self.arn = arn
        self.id = id
        self.json_params = json_params
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_params is not None:
            result['JsonParams'] = self.json_params
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParams') is not None:
            self.json_params = m.get('JsonParams')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeMetricRuleTargetsResponseBodyTargets(TeaModel):
    def __init__(
        self,
        target: List[DescribeMetricRuleTargetsResponseBodyTargetsTarget] = None,
    ):
        self.target = target

    def validate(self):
        if self.target:
            for k in self.target:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Target'] = []
        if self.target is not None:
            for k in self.target:
                result['Target'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target = []
        if m.get('Target') is not None:
            for k in m.get('Target'):
                temp_model = DescribeMetricRuleTargetsResponseBodyTargetsTarget()
                self.target.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTargetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        targets: DescribeMetricRuleTargetsResponseBodyTargets = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.targets = targets

    def validate(self):
        if self.targets:
            self.targets.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.targets is not None:
            result['Targets'] = self.targets.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Targets') is not None:
            temp_model = DescribeMetricRuleTargetsResponseBodyTargets()
            self.targets = temp_model.from_map(m['Targets'])
        return self


class DescribeMetricRuleTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTemplateAttributeRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        region_id: str = None,
        template_id: str = None,
    ):
        self.name = name
        self.region_id = region_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations(TeaModel):
    def __init__(
        self,
        critical: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical = None,
        info: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo = None,
        warn: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate(TeaModel):
    def __init__(
        self,
        category: str = None,
        escalations: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations = None,
        metric_name: str = None,
        namespace: str = None,
        no_data_policy: str = None,
        rule_name: str = None,
        selector: str = None,
        webhook: str = None,
    ):
        self.category = category
        self.escalations = escalations
        self.metric_name = metric_name
        self.namespace = namespace
        self.no_data_policy = no_data_policy
        self.rule_name = rule_name
        self.selector = selector
        self.webhook = webhook

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Escalations') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates(TeaModel):
    def __init__(
        self,
        alert_template: List[DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate] = None,
    ):
        self.alert_template = alert_template

    def validate(self):
        if self.alert_template:
            for k in self.alert_template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertTemplate'] = []
        if self.alert_template is not None:
            for k in self.alert_template:
                result['AlertTemplate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_template = []
        if m.get('AlertTemplate') is not None:
            for k in m.get('AlertTemplate'):
                temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate()
                self.alert_template.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResource(TeaModel):
    def __init__(
        self,
        alert_templates: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates = None,
        description: str = None,
        name: str = None,
        rest_version: str = None,
        template_id: str = None,
    ):
        self.alert_templates = alert_templates
        self.description = description
        self.name = name
        self.rest_version = rest_version
        self.template_id = template_id

    def validate(self):
        if self.alert_templates:
            self.alert_templates.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_templates is not None:
            result['AlertTemplates'] = self.alert_templates.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.rest_version is not None:
            result['RestVersion'] = self.rest_version
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertTemplates') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates()
            self.alert_templates = temp_model.from_map(m['AlertTemplates'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RestVersion') is not None:
            self.rest_version = m.get('RestVersion')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: DescribeMetricRuleTemplateAttributeResponseBodyResource = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resource = resource
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricRuleTemplateAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleTemplateAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTemplateListRequest(TeaModel):
    def __init__(
        self,
        history: bool = None,
        keyword: str = None,
        name: str = None,
        order: bool = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        template_id: int = None,
    ):
        self.history = history
        self.keyword = keyword
        self.name = name
        self.order = order
        self.order_by = order_by
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.history is not None:
            result['History'] = self.history
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.name is not None:
            result['Name'] = self.name
        if self.order is not None:
            result['Order'] = self.order
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('History') is not None:
            self.history = m.get('History')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory(TeaModel):
    def __init__(
        self,
        apply_time: int = None,
        group_id: int = None,
        group_name: str = None,
    ):
        self.apply_time = apply_time
        self.group_id = group_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_time is not None:
            result['ApplyTime'] = self.apply_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyTime') is not None:
            self.apply_time = m.get('ApplyTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories(TeaModel):
    def __init__(
        self,
        apply_history: List[DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory] = None,
    ):
        self.apply_history = apply_history

    def validate(self):
        if self.apply_history:
            for k in self.apply_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplyHistory'] = []
        if self.apply_history is not None:
            for k in self.apply_history:
                result['ApplyHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_history = []
        if m.get('ApplyHistory') is not None:
            for k in m.get('ApplyHistory'):
                temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory()
                self.apply_history.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate(TeaModel):
    def __init__(
        self,
        apply_histories: DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        name: str = None,
        rest_version: int = None,
        template_id: int = None,
    ):
        self.apply_histories = apply_histories
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.name = name
        self.rest_version = rest_version
        self.template_id = template_id

    def validate(self):
        if self.apply_histories:
            self.apply_histories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_histories is not None:
            result['ApplyHistories'] = self.apply_histories.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.rest_version is not None:
            result['RestVersion'] = self.rest_version
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyHistories') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories()
            self.apply_histories = temp_model.from_map(m['ApplyHistories'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RestVersion') is not None:
            self.rest_version = m.get('RestVersion')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplates(TeaModel):
    def __init__(
        self,
        template: List[DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        templates: DescribeMetricRuleTemplateListResponseBodyTemplates = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.templates = templates
        self.total = total

    def validate(self):
        if self.templates:
            self.templates.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.templates is not None:
            result['Templates'] = self.templates.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Templates') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBodyTemplates()
            self.templates = temp_model.from_map(m['Templates'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleTemplateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleTemplateListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricTopRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        order_desc: str = None,
        orderby: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.dimensions = dimensions
        self.end_time = end_time
        self.express = express
        self.length = length
        self.metric_name = metric_name
        self.namespace = namespace
        self.order_desc = order_desc
        self.orderby = orderby
        self.period = period
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.order_desc is not None:
            result['OrderDesc'] = self.order_desc
        if self.orderby is not None:
            result['Orderby'] = self.orderby
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OrderDesc') is not None:
            self.order_desc = m.get('OrderDesc')
        if m.get('Orderby') is not None:
            self.orderby = m.get('Orderby')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricTopResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        period: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.period = period
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricTopResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricTopResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricTopResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupCategoriesRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem(TeaModel):
    def __init__(
        self,
        category: str = None,
        count: int = None,
    ):
        self.category = category
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory(TeaModel):
    def __init__(
        self,
        category_item: List[DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem] = None,
    ):
        self.category_item = category_item

    def validate(self):
        if self.category_item:
            for k in self.category_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CategoryItem'] = []
        if self.category_item is not None:
            for k in self.category_item:
                result['CategoryItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category_item = []
        if m.get('CategoryItem') is not None:
            for k in m.get('CategoryItem'):
                temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem()
                self.category_item.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        monitor_group_category: DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory = None,
    ):
        self.group_id = group_id
        self.monitor_group_category = monitor_group_category

    def validate(self):
        if self.monitor_group_category:
            self.monitor_group_category.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.monitor_group_category is not None:
            result['MonitorGroupCategory'] = self.monitor_group_category.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MonitorGroupCategory') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory()
            self.monitor_group_category = temp_model.from_map(m['MonitorGroupCategory'])
        return self


class DescribeMonitorGroupCategoriesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        monitor_group_categories: DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.monitor_group_categories = monitor_group_categories
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.monitor_group_categories:
            self.monitor_group_categories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.monitor_group_categories is not None:
            result['MonitorGroupCategories'] = self.monitor_group_categories.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MonitorGroupCategories') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories()
            self.monitor_group_categories = temp_model.from_map(m['MonitorGroupCategories'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitorGroupCategoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupCategoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupDynamicRulesRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        self.function = function
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters(TeaModel):
    def __init__(
        self,
        filter: List[DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter] = None,
    ):
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResource(TeaModel):
    def __init__(
        self,
        category: str = None,
        filter_relation: str = None,
        filters: DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters = None,
    ):
        self.category = category
        self.filter_relation = filter_relation
        self.filters = filters

    def validate(self):
        if self.filters:
            self.filters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.filter_relation is not None:
            result['FilterRelation'] = self.filter_relation
        if self.filters is not None:
            result['Filters'] = self.filters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('FilterRelation') is not None:
            self.filter_relation = m.get('FilterRelation')
        if m.get('Filters') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters()
            self.filters = temp_model.from_map(m['Filters'])
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResource(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMonitorGroupDynamicRulesResponseBodyResourceResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupDynamicRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: DescribeMonitorGroupDynamicRulesResponseBodyResource = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resource = resource
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitorGroupDynamicRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupDynamicRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupInstanceAttributeRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        instance_ids: str = None,
        keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        total: bool = None,
    ):
        self.category = category
        self.group_id = group_id
        self.instance_ids = instance_ids
        self.keyword = keyword
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion(TeaModel):
    def __init__(
        self,
        availability_zone: str = None,
        region_id: str = None,
    ):
        self.availability_zone = availability_zone
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc(TeaModel):
    def __init__(
        self,
        vpc_instance_id: str = None,
        vswitch_instance_id: str = None,
    ):
        self.vpc_instance_id = vpc_instance_id
        self.vswitch_instance_id = vswitch_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vswitch_instance_id is not None:
            result['VswitchInstanceId'] = self.vswitch_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VswitchInstanceId') is not None:
            self.vswitch_instance_id = m.get('VswitchInstanceId')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        category: str = None,
        desc: str = None,
        dimension: str = None,
        instance_id: str = None,
        instance_name: str = None,
        network_type: str = None,
        region: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion = None,
        tags: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags = None,
        vpc: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc = None,
    ):
        self.category = category
        self.desc = desc
        self.dimension = dimension
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.network_type = network_type
        self.region = region
        self.tags = tags
        self.vpc = vpc

    def validate(self):
        if self.region:
            self.region.validate()
        if self.tags:
            self.tags.validate()
        if self.vpc:
            self.vpc.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.region is not None:
            result['Region'] = self.region.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.vpc is not None:
            result['Vpc'] = self.vpc.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Region') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion()
            self.region = temp_model.from_map(m['Region'])
        if m.get('Tags') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Vpc') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc()
            self.vpc = temp_model.from_map(m['Vpc'])
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstanceAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        resources: DescribeMonitorGroupInstanceAttributeResponseBodyResources = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstanceAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupInstanceAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        instance_ids: str = None,
        keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.category = category
        self.group_id = group_id
        self.instance_ids = instance_ids
        self.keyword = keyword
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstancesResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        category: str = None,
        id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        self.category = category
        self.id = id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstancesResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMonitorGroupInstancesResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupInstancesResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        resources: DescribeMonitorGroupInstancesResponseBodyResources = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupInstancesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupNotifyPolicyListRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        policy_type: str = None,
        region_id: str = None,
    ):
        self.group_id = group_id
        self.page_number = page_number
        self.page_size = page_size
        self.policy_type = policy_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        group_id: str = None,
        id: str = None,
        start_time: int = None,
        type: str = None,
    ):
        self.end_time = end_time
        self.group_id = group_id
        self.id = id
        self.start_time = start_time
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList(TeaModel):
    def __init__(
        self,
        notify_policy: List[DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy] = None,
    ):
        self.notify_policy = notify_policy

    def validate(self):
        if self.notify_policy:
            for k in self.notify_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NotifyPolicy'] = []
        if self.notify_policy is not None:
            for k in self.notify_policy:
                result['NotifyPolicy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.notify_policy = []
        if m.get('NotifyPolicy') is not None:
            for k in m.get('NotifyPolicy'):
                temp_model = DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy()
                self.notify_policy.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        notify_policy_list: DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList = None,
        request_id: str = None,
        success: str = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.notify_policy_list = notify_policy_list
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.notify_policy_list:
            self.notify_policy_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_policy_list is not None:
            result['NotifyPolicyList'] = self.notify_policy_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyPolicyList') is not None:
            temp_model = DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList()
            self.notify_policy_list = temp_model.from_map(m['NotifyPolicyList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupNotifyPolicyListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupNotifyPolicyListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupNotifyPolicyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupsRequest(TeaModel):
    def __init__(
        self,
        dynamic_tag_rule_id: str = None,
        group_founder_tag_key: str = None,
        group_founder_tag_value: str = None,
        group_id: str = None,
        group_name: str = None,
        include_template_history: bool = None,
        instance_id: str = None,
        keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        select_contact_groups: bool = None,
        tag: List[DescribeMonitorGroupsRequestTag] = None,
        type: str = None,
    ):
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        self.group_founder_tag_key = group_founder_tag_key
        self.group_founder_tag_value = group_founder_tag_value
        self.group_id = group_id
        self.group_name = group_name
        self.include_template_history = include_template_history
        self.instance_id = instance_id
        self.keyword = keyword
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.select_contact_groups = select_contact_groups
        self.tag = tag
        self.type = type

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.group_founder_tag_key is not None:
            result['GroupFounderTagKey'] = self.group_founder_tag_key
        if self.group_founder_tag_value is not None:
            result['GroupFounderTagValue'] = self.group_founder_tag_value
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.include_template_history is not None:
            result['IncludeTemplateHistory'] = self.include_template_history
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.select_contact_groups is not None:
            result['SelectContactGroups'] = self.select_contact_groups
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('GroupFounderTagKey') is not None:
            self.group_founder_tag_key = m.get('GroupFounderTagKey')
        if m.get('GroupFounderTagValue') is not None:
            self.group_founder_tag_value = m.get('GroupFounderTagValue')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IncludeTemplateHistory') is not None:
            self.include_template_history = m.get('IncludeTemplateHistory')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SelectContactGroups') is not None:
            self.select_contact_groups = m.get('SelectContactGroups')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds(TeaModel):
    def __init__(
        self,
        template_id: List[str] = None,
    ):
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        bind_url: str = None,
        contact_groups: DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups = None,
        dynamic_tag_rule_id: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_founder_tag_key: str = None,
        group_founder_tag_value: str = None,
        group_id: int = None,
        group_name: str = None,
        service_id: str = None,
        tags: DescribeMonitorGroupsResponseBodyResourcesResourceTags = None,
        template_ids: DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds = None,
        type: str = None,
    ):
        self.bind_url = bind_url
        self.contact_groups = contact_groups
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.group_founder_tag_key = group_founder_tag_key
        self.group_founder_tag_value = group_founder_tag_value
        self.group_id = group_id
        self.group_name = group_name
        self.service_id = service_id
        self.tags = tags
        self.template_ids = template_ids
        self.type = type

    def validate(self):
        if self.contact_groups:
            self.contact_groups.validate()
        if self.tags:
            self.tags.validate()
        if self.template_ids:
            self.template_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_url is not None:
            result['BindUrl'] = self.bind_url
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_founder_tag_key is not None:
            result['GroupFounderTagKey'] = self.group_founder_tag_key
        if self.group_founder_tag_value is not None:
            result['GroupFounderTagValue'] = self.group_founder_tag_value
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindUrl') is not None:
            self.bind_url = m.get('BindUrl')
        if m.get('ContactGroups') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupFounderTagKey') is not None:
            self.group_founder_tag_key = m.get('GroupFounderTagKey')
        if m.get('GroupFounderTagValue') is not None:
            self.group_founder_tag_value = m.get('GroupFounderTagValue')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('Tags') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TemplateIds') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds()
            self.template_ids = temp_model.from_map(m['TemplateIds'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupsResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMonitorGroupsResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        resources: DescribeMonitorGroupsResponseBodyResources = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorResourceQuotaAttributeRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        show_used: bool = None,
    ):
        self.region_id = region_id
        self.show_used = show_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_used is not None:
            result['ShowUsed'] = self.show_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowUsed') is not None:
            self.show_used = m.get('ShowUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        suit_info: str = None,
    ):
        self.instance_id = instance_id
        self.suit_info = suit_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.suit_info is not None:
            result['SuitInfo'] = self.suit_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SuitInfo') is not None:
            self.suit_info = m.get('SuitInfo')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask(TeaModel):
    def __init__(
        self,
        quota_limit: int = None,
        quota_package: int = None,
        quota_used: int = None,
    ):
        self.quota_limit = quota_limit
        self.quota_package = quota_package
        self.quota_used = quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota(TeaModel):
    def __init__(
        self,
        api: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi = None,
        custom_monitor: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor = None,
        enterprise_quota: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota = None,
        event_monitor: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor = None,
        expire_time: str = None,
        instance_id: str = None,
        log_monitor: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor = None,
        phone: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone = None,
        sms: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS = None,
        site_monitor_ecs_probe: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe = None,
        site_monitor_operator_probe: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe = None,
        site_monitor_task: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask = None,
        suit_info: str = None,
    ):
        self.api = api
        self.custom_monitor = custom_monitor
        self.enterprise_quota = enterprise_quota
        self.event_monitor = event_monitor
        self.expire_time = expire_time
        self.instance_id = instance_id
        self.log_monitor = log_monitor
        self.phone = phone
        self.sms = sms
        self.site_monitor_ecs_probe = site_monitor_ecs_probe
        self.site_monitor_operator_probe = site_monitor_operator_probe
        self.site_monitor_task = site_monitor_task
        self.suit_info = suit_info

    def validate(self):
        if self.api:
            self.api.validate()
        if self.custom_monitor:
            self.custom_monitor.validate()
        if self.enterprise_quota:
            self.enterprise_quota.validate()
        if self.event_monitor:
            self.event_monitor.validate()
        if self.log_monitor:
            self.log_monitor.validate()
        if self.phone:
            self.phone.validate()
        if self.sms:
            self.sms.validate()
        if self.site_monitor_ecs_probe:
            self.site_monitor_ecs_probe.validate()
        if self.site_monitor_operator_probe:
            self.site_monitor_operator_probe.validate()
        if self.site_monitor_task:
            self.site_monitor_task.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api is not None:
            result['Api'] = self.api.to_map()
        if self.custom_monitor is not None:
            result['CustomMonitor'] = self.custom_monitor.to_map()
        if self.enterprise_quota is not None:
            result['EnterpriseQuota'] = self.enterprise_quota.to_map()
        if self.event_monitor is not None:
            result['EventMonitor'] = self.event_monitor.to_map()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_monitor is not None:
            result['LogMonitor'] = self.log_monitor.to_map()
        if self.phone is not None:
            result['Phone'] = self.phone.to_map()
        if self.sms is not None:
            result['SMS'] = self.sms.to_map()
        if self.site_monitor_ecs_probe is not None:
            result['SiteMonitorEcsProbe'] = self.site_monitor_ecs_probe.to_map()
        if self.site_monitor_operator_probe is not None:
            result['SiteMonitorOperatorProbe'] = self.site_monitor_operator_probe.to_map()
        if self.site_monitor_task is not None:
            result['SiteMonitorTask'] = self.site_monitor_task.to_map()
        if self.suit_info is not None:
            result['SuitInfo'] = self.suit_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Api') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi()
            self.api = temp_model.from_map(m['Api'])
        if m.get('CustomMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor()
            self.custom_monitor = temp_model.from_map(m['CustomMonitor'])
        if m.get('EnterpriseQuota') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota()
            self.enterprise_quota = temp_model.from_map(m['EnterpriseQuota'])
        if m.get('EventMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor()
            self.event_monitor = temp_model.from_map(m['EventMonitor'])
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor()
            self.log_monitor = temp_model.from_map(m['LogMonitor'])
        if m.get('Phone') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone()
            self.phone = temp_model.from_map(m['Phone'])
        if m.get('SMS') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS()
            self.sms = temp_model.from_map(m['SMS'])
        if m.get('SiteMonitorEcsProbe') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe()
            self.site_monitor_ecs_probe = temp_model.from_map(m['SiteMonitorEcsProbe'])
        if m.get('SiteMonitorOperatorProbe') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe()
            self.site_monitor_operator_probe = temp_model.from_map(m['SiteMonitorOperatorProbe'])
        if m.get('SiteMonitorTask') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask()
            self.site_monitor_task = temp_model.from_map(m['SiteMonitorTask'])
        if m.get('SuitInfo') is not None:
            self.suit_info = m.get('SuitInfo')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        resource_quota: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.resource_quota = resource_quota

    def validate(self):
        if self.resource_quota:
            self.resource_quota.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_quota is not None:
            result['ResourceQuota'] = self.resource_quota.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceQuota') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota()
            self.resource_quota = temp_model.from_map(m['ResourceQuota'])
        return self


class DescribeMonitorResourceQuotaAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitorResourceQuotaAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentAccessKeyRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentAccessKeyResponseBody(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        code: int = None,
        message: str = None,
        request_id: str = None,
        secret_key: str = None,
        success: bool = None,
    ):
        self.access_key = access_key
        self.code = code
        self.message = message
        self.request_id = request_id
        self.secret_key = secret_key
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentAccessKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringAgentAccessKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentAccessKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentConfigRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentConfigResponseBody(TeaModel):
    def __init__(
        self,
        auto_install: bool = None,
        code: str = None,
        enable_active_alert: str = None,
        enable_install_agent_new_ecs: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.auto_install = auto_install
        self.code = code
        self.enable_active_alert = enable_active_alert
        self.enable_install_agent_new_ecs = enable_install_agent_new_ecs
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.code is not None:
            result['Code'] = self.code
        if self.enable_active_alert is not None:
            result['EnableActiveAlert'] = self.enable_active_alert
        if self.enable_install_agent_new_ecs is not None:
            result['EnableInstallAgentNewECS'] = self.enable_install_agent_new_ecs
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnableActiveAlert') is not None:
            self.enable_active_alert = m.get('EnableActiveAlert')
        if m.get('EnableInstallAgentNewECS') is not None:
            self.enable_install_agent_new_ecs = m.get('EnableInstallAgentNewECS')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringAgentConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentHostsRequest(TeaModel):
    def __init__(
        self,
        aliyun_host: bool = None,
        host_name: str = None,
        instance_ids: str = None,
        instance_region_id: str = None,
        key_word: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        serial_numbers: str = None,
        status: str = None,
    ):
        self.aliyun_host = aliyun_host
        self.host_name = host_name
        self.instance_ids = instance_ids
        self.instance_region_id = instance_region_id
        self.key_word = key_word
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.serial_numbers = serial_numbers
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_host is not None:
            result['AliyunHost'] = self.aliyun_host
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.instance_region_id is not None:
            result['InstanceRegionId'] = self.instance_region_id
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.serial_numbers is not None:
            result['SerialNumbers'] = self.serial_numbers
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliyunHost') is not None:
            self.aliyun_host = m.get('AliyunHost')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('InstanceRegionId') is not None:
            self.instance_region_id = m.get('InstanceRegionId')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SerialNumbers') is not None:
            self.serial_numbers = m.get('SerialNumbers')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeMonitoringAgentHostsResponseBodyHostsHost(TeaModel):
    def __init__(
        self,
        agent_version: str = None,
        ali_uid: int = None,
        eip_address: str = None,
        eip_id: str = None,
        host_name: str = None,
        instance_id: str = None,
        instance_type_family: str = None,
        ip_group: str = None,
        nat_ip: str = None,
        network_type: str = None,
        operating_system: str = None,
        region: str = None,
        serial_number: str = None,
        is_aliyun_host: bool = None,
    ):
        self.agent_version = agent_version
        self.ali_uid = ali_uid
        self.eip_address = eip_address
        self.eip_id = eip_id
        self.host_name = host_name
        self.instance_id = instance_id
        self.instance_type_family = instance_type_family
        self.ip_group = ip_group
        self.nat_ip = nat_ip
        self.network_type = network_type
        self.operating_system = operating_system
        self.region = region
        self.serial_number = serial_number
        self.is_aliyun_host = is_aliyun_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.eip_id is not None:
            result['EipId'] = self.eip_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.ip_group is not None:
            result['IpGroup'] = self.ip_group
        if self.nat_ip is not None:
            result['NatIp'] = self.nat_ip
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.operating_system is not None:
            result['OperatingSystem'] = self.operating_system
        if self.region is not None:
            result['Region'] = self.region
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.is_aliyun_host is not None:
            result['isAliyunHost'] = self.is_aliyun_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('EipId') is not None:
            self.eip_id = m.get('EipId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('IpGroup') is not None:
            self.ip_group = m.get('IpGroup')
        if m.get('NatIp') is not None:
            self.nat_ip = m.get('NatIp')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OperatingSystem') is not None:
            self.operating_system = m.get('OperatingSystem')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('isAliyunHost') is not None:
            self.is_aliyun_host = m.get('isAliyunHost')
        return self


class DescribeMonitoringAgentHostsResponseBodyHosts(TeaModel):
    def __init__(
        self,
        host: List[DescribeMonitoringAgentHostsResponseBodyHostsHost] = None,
    ):
        self.host = host

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = DescribeMonitoringAgentHostsResponseBodyHostsHost()
                self.host.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentHostsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        hosts: DescribeMonitoringAgentHostsResponseBodyHosts = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        page_total: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.hosts = hosts
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.page_total = page_total
        self.request_id = request_id
        self.success = success
        self.total = total

    def validate(self):
        if self.hosts:
            self.hosts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.hosts is not None:
            result['Hosts'] = self.hosts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_total is not None:
            result['PageTotal'] = self.page_total
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Hosts') is not None:
            temp_model = DescribeMonitoringAgentHostsResponseBodyHosts()
            self.hosts = temp_model.from_map(m['Hosts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageTotal') is not None:
            self.page_total = m.get('PageTotal')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitoringAgentHostsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringAgentHostsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentProcessesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        region_id: str = None,
    ):
        self.instance_id = instance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess(TeaModel):
    def __init__(
        self,
        command: str = None,
        group_id: str = None,
        instance_id: str = None,
        process_id: int = None,
        process_name: str = None,
        process_user: str = None,
    ):
        self.command = command
        self.group_id = group_id
        self.instance_id = instance_id
        self.process_id = process_id
        self.process_name = process_name
        self.process_user = process_user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['Command'] = self.command
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        return self


class DescribeMonitoringAgentProcessesResponseBodyNodeProcesses(TeaModel):
    def __init__(
        self,
        node_process: List[DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess] = None,
    ):
        self.node_process = node_process

    def validate(self):
        if self.node_process:
            for k in self.node_process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeProcess'] = []
        if self.node_process is not None:
            for k in self.node_process:
                result['NodeProcess'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_process = []
        if m.get('NodeProcess') is not None:
            for k in m.get('NodeProcess'):
                temp_model = DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess()
                self.node_process.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentProcessesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        node_processes: DescribeMonitoringAgentProcessesResponseBodyNodeProcesses = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.node_processes = node_processes
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.node_processes:
            self.node_processes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.node_processes is not None:
            result['NodeProcesses'] = self.node_processes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeProcesses') is not None:
            temp_model = DescribeMonitoringAgentProcessesResponseBodyNodeProcesses()
            self.node_processes = temp_model.from_map(m['NodeProcesses'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentProcessesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringAgentProcessesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentStatusesRequest(TeaModel):
    def __init__(
        self,
        instance_ids: str = None,
        region_id: str = None,
    ):
        self.instance_ids = instance_ids
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus(TeaModel):
    def __init__(
        self,
        auto_install: bool = None,
        instance_id: str = None,
        status: str = None,
    ):
        self.auto_install = auto_install
        self.instance_id = instance_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeMonitoringAgentStatusesResponseBodyNodeStatusList(TeaModel):
    def __init__(
        self,
        node_status: List[DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus] = None,
    ):
        self.node_status = node_status

    def validate(self):
        if self.node_status:
            for k in self.node_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeStatus'] = []
        if self.node_status is not None:
            for k in self.node_status:
                result['NodeStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_status = []
        if m.get('NodeStatus') is not None:
            for k in m.get('NodeStatus'):
                temp_model = DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus()
                self.node_status.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentStatusesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        node_status_list: DescribeMonitoringAgentStatusesResponseBodyNodeStatusList = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.node_status_list = node_status_list
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.node_status_list:
            self.node_status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.node_status_list is not None:
            result['NodeStatusList'] = self.node_status_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeStatusList') is not None:
            temp_model = DescribeMonitoringAgentStatusesResponseBodyNodeStatusList()
            self.node_status_list = temp_model.from_map(m['NodeStatusList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentStatusesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringAgentStatusesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentStatusesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringConfigRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringConfigResponseBody(TeaModel):
    def __init__(
        self,
        auto_install: bool = None,
        code: str = None,
        enable_install_agent_new_ecs: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.auto_install = auto_install
        self.code = code
        self.enable_install_agent_new_ecs = enable_install_agent_new_ecs
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.code is not None:
            result['Code'] = self.code
        if self.enable_install_agent_new_ecs is not None:
            result['EnableInstallAgentNewECS'] = self.enable_install_agent_new_ecs
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnableInstallAgentNewECS') is not None:
            self.enable_install_agent_new_ecs = m.get('EnableInstallAgentNewECS')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMonitoringConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductResourceTagKeyListRequest(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        region_id: str = None,
    ):
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeProductResourceTagKeyListResponseBodyTagKeys(TeaModel):
    def __init__(
        self,
        tag_key: List[str] = None,
    ):
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeProductResourceTagKeyListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        tag_keys: DescribeProductResourceTagKeyListResponseBodyTagKeys = None,
    ):
        self.code = code
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.tag_keys = tag_keys

    def validate(self):
        if self.tag_keys:
            self.tag_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagKeys') is not None:
            temp_model = DescribeProductResourceTagKeyListResponseBodyTagKeys()
            self.tag_keys = temp_model.from_map(m['TagKeys'])
        return self


class DescribeProductResourceTagKeyListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProductResourceTagKeyListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductResourceTagKeyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductsOfActiveMetricRuleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig(TeaModel):
    def __init__(
        self,
        evaluation_count: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        self.evaluation_count = evaluation_count
        self.metric_name = metric_name
        self.namespace = namespace
        self.period = period
        self.statistics = statistics
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList(TeaModel):
    def __init__(
        self,
        alert_init_config: List[DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig] = None,
    ):
        self.alert_init_config = alert_init_config

    def validate(self):
        if self.alert_init_config:
            for k in self.alert_init_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertInitConfig'] = []
        if self.alert_init_config is not None:
            for k in self.alert_init_config:
                result['AlertInitConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_init_config = []
        if m.get('AlertInitConfig') is not None:
            for k in m.get('AlertInitConfig'):
                temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig()
                self.alert_init_config.append(temp_model.from_map(k))
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule(TeaModel):
    def __init__(
        self,
        alert_init_config_list: DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList = None,
        product: str = None,
    ):
        self.alert_init_config_list = alert_init_config_list
        self.product = product

    def validate(self):
        if self.alert_init_config_list:
            self.alert_init_config_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_init_config_list is not None:
            result['AlertInitConfigList'] = self.alert_init_config_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertInitConfigList') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList()
            self.alert_init_config_list = temp_model.from_map(m['AlertInitConfigList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList(TeaModel):
    def __init__(
        self,
        all_product_init_metric_rule: List[DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule] = None,
    ):
        self.all_product_init_metric_rule = all_product_init_metric_rule

    def validate(self):
        if self.all_product_init_metric_rule:
            for k in self.all_product_init_metric_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllProductInitMetricRule'] = []
        if self.all_product_init_metric_rule is not None:
            for k in self.all_product_init_metric_rule:
                result['AllProductInitMetricRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.all_product_init_metric_rule = []
        if m.get('AllProductInitMetricRule') is not None:
            for k in m.get('AllProductInitMetricRule'):
                temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule()
                self.all_product_init_metric_rule.append(temp_model.from_map(k))
        return self


class DescribeProductsOfActiveMetricRuleResponseBody(TeaModel):
    def __init__(
        self,
        all_product_init_metric_rule_list: DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList = None,
        code: int = None,
        datapoints: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.all_product_init_metric_rule_list = all_product_init_metric_rule_list
        self.code = code
        self.datapoints = datapoints
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.all_product_init_metric_rule_list:
            self.all_product_init_metric_rule_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_product_init_metric_rule_list is not None:
            result['AllProductInitMetricRuleList'] = self.all_product_init_metric_rule_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllProductInitMetricRuleList') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList()
            self.all_product_init_metric_rule_list = temp_model.from_map(m['AllProductInitMetricRuleList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeProductsOfActiveMetricRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProductsOfActiveMetricRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProjectMetaRequest(TeaModel):
    def __init__(
        self,
        labels: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.labels = labels
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeProjectMetaResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        description: str = None,
        labels: str = None,
        namespace: str = None,
    ):
        self.description = description
        self.labels = labels
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DescribeProjectMetaResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeProjectMetaResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeProjectMetaResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeProjectMetaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: str = None,
        page_size: str = None,
        request_id: str = None,
        resources: DescribeProjectMetaResponseBodyResources = None,
        success: bool = None,
        total: str = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.resources = resources
        self.success = success
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeProjectMetaResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeProjectMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProjectMetaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProjectMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorAttributeRequest(TeaModel):
    def __init__(
        self,
        include_alert: bool = None,
        region_id: str = None,
        task_id: str = None,
    ):
        self.include_alert = include_alert
        self.region_id = region_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_alert is not None:
            result['IncludeAlert'] = self.include_alert
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncludeAlert') is not None:
            self.include_alert = m.get('IncludeAlert')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule(TeaModel):
    def __init__(
        self,
        action_enable: str = None,
        alarm_actions: str = None,
        comparison_operator: str = None,
        dimensions: str = None,
        evaluation_count: str = None,
        expression: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        ok_actions: str = None,
        period: str = None,
        rule_id: str = None,
        rule_name: str = None,
        state_value: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        self.action_enable = action_enable
        self.alarm_actions = alarm_actions
        self.comparison_operator = comparison_operator
        self.dimensions = dimensions
        self.evaluation_count = evaluation_count
        self.expression = expression
        self.level = level
        self.metric_name = metric_name
        self.namespace = namespace
        self.ok_actions = ok_actions
        self.period = period
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.state_value = state_value
        self.statistics = statistics
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_enable is not None:
            result['ActionEnable'] = self.action_enable
        if self.alarm_actions is not None:
            result['AlarmActions'] = self.alarm_actions
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.ok_actions is not None:
            result['OkActions'] = self.ok_actions
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.state_value is not None:
            result['StateValue'] = self.state_value
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionEnable') is not None:
            self.action_enable = m.get('ActionEnable')
        if m.get('AlarmActions') is not None:
            self.alarm_actions = m.get('AlarmActions')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OkActions') is not None:
            self.ok_actions = m.get('OkActions')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StateValue') is not None:
            self.state_value = m.get('StateValue')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeSiteMonitorAttributeResponseBodyMetricRules(TeaModel):
    def __init__(
        self,
        metric_rule: List[DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule] = None,
    ):
        self.metric_rule = metric_rule

    def validate(self):
        if self.metric_rule:
            for k in self.metric_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricRule'] = []
        if self.metric_rule is not None:
            for k in self.metric_rule:
                result['MetricRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.metric_rule = []
        if m.get('MetricRule') is not None:
            for k in m.get('MetricRule'):
                temp_model = DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule()
                self.metric_rule.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity(TeaModel):
    def __init__(
        self,
        city: str = None,
        city_name: str = None,
        isp: str = None,
        isp_name: str = None,
    ):
        self.city = city
        self.city_name = city_name
        self.isp = isp
        self.isp_name = isp_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities(TeaModel):
    def __init__(
        self,
        isp_city: List[DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity] = None,
    ):
        self.isp_city = isp_city

    def validate(self):
        if self.isp_city:
            for k in self.isp_city:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCity'] = []
        if self.isp_city is not None:
            for k in self.isp_city:
                result['IspCity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_city = []
        if m.get('IspCity') is not None:
            for k in m.get('IspCity'):
                temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity()
                self.isp_city.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson(TeaModel):
    def __init__(
        self,
        attempts: int = None,
        authentication: int = None,
        cookie: str = None,
        dns_match_rule: str = None,
        dns_server: str = None,
        dns_type: str = None,
        expect_value: str = None,
        failure_rate: float = None,
        header: str = None,
        http_method: str = None,
        is_base_64encode: str = None,
        match_rule: int = None,
        password: str = None,
        ping_num: int = None,
        port: int = None,
        protocol: str = None,
        request_content: str = None,
        request_format: str = None,
        response_content: str = None,
        response_format: str = None,
        time_out: int = None,
        username: str = None,
    ):
        self.attempts = attempts
        self.authentication = authentication
        self.cookie = cookie
        self.dns_match_rule = dns_match_rule
        self.dns_server = dns_server
        self.dns_type = dns_type
        self.expect_value = expect_value
        self.failure_rate = failure_rate
        self.header = header
        self.http_method = http_method
        self.is_base_64encode = is_base_64encode
        self.match_rule = match_rule
        self.password = password
        self.ping_num = ping_num
        self.port = port
        self.protocol = protocol
        self.request_content = request_content
        self.request_format = request_format
        self.response_content = response_content
        self.response_format = response_format
        self.time_out = time_out
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attempts is not None:
            result['attempts'] = self.attempts
        if self.authentication is not None:
            result['authentication'] = self.authentication
        if self.cookie is not None:
            result['cookie'] = self.cookie
        if self.dns_match_rule is not None:
            result['dns_match_rule'] = self.dns_match_rule
        if self.dns_server is not None:
            result['dns_server'] = self.dns_server
        if self.dns_type is not None:
            result['dns_type'] = self.dns_type
        if self.expect_value is not None:
            result['expect_value'] = self.expect_value
        if self.failure_rate is not None:
            result['failure_rate'] = self.failure_rate
        if self.header is not None:
            result['header'] = self.header
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.is_base_64encode is not None:
            result['isBase64Encode'] = self.is_base_64encode
        if self.match_rule is not None:
            result['match_rule'] = self.match_rule
        if self.password is not None:
            result['password'] = self.password
        if self.ping_num is not None:
            result['ping_num'] = self.ping_num
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.request_content is not None:
            result['request_content'] = self.request_content
        if self.request_format is not None:
            result['request_format'] = self.request_format
        if self.response_content is not None:
            result['response_content'] = self.response_content
        if self.response_format is not None:
            result['response_format'] = self.response_format
        if self.time_out is not None:
            result['time_out'] = self.time_out
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attempts') is not None:
            self.attempts = m.get('attempts')
        if m.get('authentication') is not None:
            self.authentication = m.get('authentication')
        if m.get('cookie') is not None:
            self.cookie = m.get('cookie')
        if m.get('dns_match_rule') is not None:
            self.dns_match_rule = m.get('dns_match_rule')
        if m.get('dns_server') is not None:
            self.dns_server = m.get('dns_server')
        if m.get('dns_type') is not None:
            self.dns_type = m.get('dns_type')
        if m.get('expect_value') is not None:
            self.expect_value = m.get('expect_value')
        if m.get('failure_rate') is not None:
            self.failure_rate = m.get('failure_rate')
        if m.get('header') is not None:
            self.header = m.get('header')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('isBase64Encode') is not None:
            self.is_base_64encode = m.get('isBase64Encode')
        if m.get('match_rule') is not None:
            self.match_rule = m.get('match_rule')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('ping_num') is not None:
            self.ping_num = m.get('ping_num')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('request_content') is not None:
            self.request_content = m.get('request_content')
        if m.get('request_format') is not None:
            self.request_format = m.get('request_format')
        if m.get('response_content') is not None:
            self.response_content = m.get('response_content')
        if m.get('response_format') is not None:
            self.response_format = m.get('response_format')
        if m.get('time_out') is not None:
            self.time_out = m.get('time_out')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitors(TeaModel):
    def __init__(
        self,
        address: str = None,
        interval: str = None,
        isp_cities: DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities = None,
        option_json: DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson = None,
        task_id: str = None,
        task_name: str = None,
        task_state: str = None,
        task_type: str = None,
    ):
        self.address = address
        self.interval = interval
        self.isp_cities = isp_cities
        self.option_json = option_json
        self.task_id = task_id
        self.task_name = task_name
        self.task_state = task_state
        self.task_type = task_type

    def validate(self):
        if self.isp_cities:
            self.isp_cities.validate()
        if self.option_json:
            self.option_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities.to_map()
        if self.option_json is not None:
            result['OptionJson'] = self.option_json.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCities') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities()
            self.isp_cities = temp_model.from_map(m['IspCities'])
        if m.get('OptionJson') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson()
            self.option_json = temp_model.from_map(m['OptionJson'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeSiteMonitorAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        metric_rules: DescribeSiteMonitorAttributeResponseBodyMetricRules = None,
        request_id: str = None,
        site_monitors: DescribeSiteMonitorAttributeResponseBodySiteMonitors = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.metric_rules = metric_rules
        self.request_id = request_id
        self.site_monitors = site_monitors
        self.success = success

    def validate(self):
        if self.metric_rules:
            self.metric_rules.validate()
        if self.site_monitors:
            self.site_monitors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_rules is not None:
            result['MetricRules'] = self.metric_rules.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_monitors is not None:
            result['SiteMonitors'] = self.site_monitors.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricRules') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodyMetricRules()
            self.metric_rules = temp_model.from_map(m['MetricRules'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteMonitors') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitors()
            self.site_monitors = temp_model.from_map(m['SiteMonitors'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorDataRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        length: int = None,
        metric_name: str = None,
        next_token: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
        task_id: str = None,
        type: str = None,
    ):
        self.end_time = end_time
        self.length = length
        self.metric_name = metric_name
        self.next_token = next_token
        self.period = period
        self.region_id = region_id
        self.start_time = start_time
        self.task_id = task_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSiteMonitorDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorISPCityListRequest(TeaModel):
    def __init__(
        self,
        city: str = None,
        ipv4: bool = None,
        ipv6: bool = None,
        isp: str = None,
        region_id: str = None,
    ):
        self.city = city
        self.ipv4 = ipv4
        self.ipv6 = ipv6
        self.isp = isp
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.ipv4 is not None:
            result['IPV4'] = self.ipv4
        if self.ipv6 is not None:
            result['IPV6'] = self.ipv6
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('IPV4') is not None:
            self.ipv4 = m.get('IPV4')
        if m.get('IPV6') is not None:
            self.ipv6 = m.get('IPV6')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool(TeaModel):
    def __init__(
        self,
        ippool: List[str] = None,
    ):
        self.ippool = ippool

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ippool is not None:
            result['IPPool'] = self.ippool
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPPool') is not None:
            self.ippool = m.get('IPPool')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity(TeaModel):
    def __init__(
        self,
        area_en: str = None,
        area_zh_c_n: str = None,
        city: str = None,
        city_name_en: str = None,
        city_name_zh_c_n: str = None,
        country: str = None,
        country_en: str = None,
        country_zh_c_n: str = None,
        ippool: DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool = None,
        ipv4probe_count: str = None,
        ipv6probe_count: str = None,
        isp: str = None,
        isp_name_en: str = None,
        isp_name_zh_c_n: str = None,
        region: str = None,
        region_en: str = None,
        region_zh_c_n: str = None,
    ):
        self.area_en = area_en
        self.area_zh_c_n = area_zh_c_n
        self.city = city
        self.city_name_en = city_name_en
        self.city_name_zh_c_n = city_name_zh_c_n
        self.country = country
        self.country_en = country_en
        self.country_zh_c_n = country_zh_c_n
        self.ippool = ippool
        self.ipv4probe_count = ipv4probe_count
        self.ipv6probe_count = ipv6probe_count
        self.isp = isp
        self.isp_name_en = isp_name_en
        self.isp_name_zh_c_n = isp_name_zh_c_n
        self.region = region
        self.region_en = region_en
        self.region_zh_c_n = region_zh_c_n

    def validate(self):
        if self.ippool:
            self.ippool.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area_en is not None:
            result['Area.en'] = self.area_en
        if self.area_zh_c_n is not None:
            result['Area.zh_CN'] = self.area_zh_c_n
        if self.city is not None:
            result['City'] = self.city
        if self.city_name_en is not None:
            result['CityName.en'] = self.city_name_en
        if self.city_name_zh_c_n is not None:
            result['CityName.zh_CN'] = self.city_name_zh_c_n
        if self.country is not None:
            result['Country'] = self.country
        if self.country_en is not None:
            result['Country.en'] = self.country_en
        if self.country_zh_c_n is not None:
            result['Country.zh_CN'] = self.country_zh_c_n
        if self.ippool is not None:
            result['IPPool'] = self.ippool.to_map()
        if self.ipv4probe_count is not None:
            result['IPV4ProbeCount'] = self.ipv4probe_count
        if self.ipv6probe_count is not None:
            result['IPV6ProbeCount'] = self.ipv6probe_count
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.isp_name_en is not None:
            result['IspName.en'] = self.isp_name_en
        if self.isp_name_zh_c_n is not None:
            result['IspName.zh_CN'] = self.isp_name_zh_c_n
        if self.region is not None:
            result['Region'] = self.region
        if self.region_en is not None:
            result['Region.en'] = self.region_en
        if self.region_zh_c_n is not None:
            result['Region.zh_CN'] = self.region_zh_c_n
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area.en') is not None:
            self.area_en = m.get('Area.en')
        if m.get('Area.zh_CN') is not None:
            self.area_zh_c_n = m.get('Area.zh_CN')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CityName.en') is not None:
            self.city_name_en = m.get('CityName.en')
        if m.get('CityName.zh_CN') is not None:
            self.city_name_zh_c_n = m.get('CityName.zh_CN')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Country.en') is not None:
            self.country_en = m.get('Country.en')
        if m.get('Country.zh_CN') is not None:
            self.country_zh_c_n = m.get('Country.zh_CN')
        if m.get('IPPool') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool()
            self.ippool = temp_model.from_map(m['IPPool'])
        if m.get('IPV4ProbeCount') is not None:
            self.ipv4probe_count = m.get('IPV4ProbeCount')
        if m.get('IPV6ProbeCount') is not None:
            self.ipv6probe_count = m.get('IPV6ProbeCount')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('IspName.en') is not None:
            self.isp_name_en = m.get('IspName.en')
        if m.get('IspName.zh_CN') is not None:
            self.isp_name_zh_c_n = m.get('IspName.zh_CN')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Region.en') is not None:
            self.region_en = m.get('Region.en')
        if m.get('Region.zh_CN') is not None:
            self.region_zh_c_n = m.get('Region.zh_CN')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityList(TeaModel):
    def __init__(
        self,
        isp_city: List[DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity] = None,
    ):
        self.isp_city = isp_city

    def validate(self):
        if self.isp_city:
            for k in self.isp_city:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCity'] = []
        if self.isp_city is not None:
            for k in self.isp_city:
                result['IspCity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_city = []
        if m.get('IspCity') is not None:
            for k in m.get('IspCity'):
                temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity()
                self.isp_city.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorISPCityListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        isp_city_list: DescribeSiteMonitorISPCityListResponseBodyIspCityList = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.isp_city_list = isp_city_list
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.isp_city_list:
            self.isp_city_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.isp_city_list is not None:
            result['IspCityList'] = self.isp_city_list.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IspCityList') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityList()
            self.isp_city_list = temp_model.from_map(m['IspCityList'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorISPCityListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorISPCityListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorListRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        task_id: str = None,
        task_type: str = None,
    ):
        self.keyword = keyword
        self.page = page
        self.page_size = page_size
        self.region_id = region_id
        self.task_id = task_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson(TeaModel):
    def __init__(
        self,
        attempts: int = None,
        authentication: int = None,
        cookie: str = None,
        dns_match_rule: str = None,
        dns_server: str = None,
        dns_type: str = None,
        failure_rate: float = None,
        header: str = None,
        http_method: str = None,
        match_rule: int = None,
        password: str = None,
        ping_num: int = None,
        port: int = None,
        protocol: str = None,
        request_content: str = None,
        request_format: str = None,
        response_content: str = None,
        response_format: str = None,
        time_out: int = None,
        username: str = None,
    ):
        self.attempts = attempts
        self.authentication = authentication
        self.cookie = cookie
        self.dns_match_rule = dns_match_rule
        self.dns_server = dns_server
        self.dns_type = dns_type
        self.failure_rate = failure_rate
        self.header = header
        self.http_method = http_method
        self.match_rule = match_rule
        self.password = password
        self.ping_num = ping_num
        self.port = port
        self.protocol = protocol
        self.request_content = request_content
        self.request_format = request_format
        self.response_content = response_content
        self.response_format = response_format
        self.time_out = time_out
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attempts is not None:
            result['attempts'] = self.attempts
        if self.authentication is not None:
            result['authentication'] = self.authentication
        if self.cookie is not None:
            result['cookie'] = self.cookie
        if self.dns_match_rule is not None:
            result['dns_match_rule'] = self.dns_match_rule
        if self.dns_server is not None:
            result['dns_server'] = self.dns_server
        if self.dns_type is not None:
            result['dns_type'] = self.dns_type
        if self.failure_rate is not None:
            result['failure_rate'] = self.failure_rate
        if self.header is not None:
            result['header'] = self.header
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.match_rule is not None:
            result['match_rule'] = self.match_rule
        if self.password is not None:
            result['password'] = self.password
        if self.ping_num is not None:
            result['ping_num'] = self.ping_num
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.request_content is not None:
            result['request_content'] = self.request_content
        if self.request_format is not None:
            result['request_format'] = self.request_format
        if self.response_content is not None:
            result['response_content'] = self.response_content
        if self.response_format is not None:
            result['response_format'] = self.response_format
        if self.time_out is not None:
            result['time_out'] = self.time_out
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attempts') is not None:
            self.attempts = m.get('attempts')
        if m.get('authentication') is not None:
            self.authentication = m.get('authentication')
        if m.get('cookie') is not None:
            self.cookie = m.get('cookie')
        if m.get('dns_match_rule') is not None:
            self.dns_match_rule = m.get('dns_match_rule')
        if m.get('dns_server') is not None:
            self.dns_server = m.get('dns_server')
        if m.get('dns_type') is not None:
            self.dns_type = m.get('dns_type')
        if m.get('failure_rate') is not None:
            self.failure_rate = m.get('failure_rate')
        if m.get('header') is not None:
            self.header = m.get('header')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('match_rule') is not None:
            self.match_rule = m.get('match_rule')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('ping_num') is not None:
            self.ping_num = m.get('ping_num')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('request_content') is not None:
            self.request_content = m.get('request_content')
        if m.get('request_format') is not None:
            self.request_format = m.get('request_format')
        if m.get('response_content') is not None:
            self.response_content = m.get('response_content')
        if m.get('response_format') is not None:
            self.response_format = m.get('response_format')
        if m.get('time_out') is not None:
            self.time_out = m.get('time_out')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor(TeaModel):
    def __init__(
        self,
        address: str = None,
        create_time: str = None,
        interval: str = None,
        options_json: DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson = None,
        task_id: str = None,
        task_name: str = None,
        task_state: str = None,
        task_type: str = None,
        update_time: str = None,
    ):
        self.address = address
        self.create_time = create_time
        self.interval = interval
        self.options_json = options_json
        self.task_id = task_id
        self.task_name = task_name
        self.task_state = task_state
        self.task_type = task_type
        self.update_time = update_time

    def validate(self):
        if self.options_json:
            self.options_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OptionsJson') is not None:
            temp_model = DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson()
            self.options_json = temp_model.from_map(m['OptionsJson'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitors(TeaModel):
    def __init__(
        self,
        site_monitor: List[DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor] = None,
    ):
        self.site_monitor = site_monitor

    def validate(self):
        if self.site_monitor:
            for k in self.site_monitor:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SiteMonitor'] = []
        if self.site_monitor is not None:
            for k in self.site_monitor:
                result['SiteMonitor'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.site_monitor = []
        if m.get('SiteMonitor') is not None:
            for k in m.get('SiteMonitor'):
                temp_model = DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor()
                self.site_monitor.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        site_monitors: DescribeSiteMonitorListResponseBodySiteMonitors = None,
        success: str = None,
        total_count: int = None,
    ):
        self.code = code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.site_monitors = site_monitors
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.site_monitors:
            self.site_monitors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_monitors is not None:
            result['SiteMonitors'] = self.site_monitors.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteMonitors') is not None:
            temp_model = DescribeSiteMonitorListResponseBodySiteMonitors()
            self.site_monitors = temp_model.from_map(m['SiteMonitors'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSiteMonitorListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorLogRequest(TeaModel):
    def __init__(
        self,
        city: str = None,
        end_time: str = None,
        filter: str = None,
        isp: str = None,
        length: int = None,
        metric_name: str = None,
        next_token: str = None,
        region_id: str = None,
        start_time: str = None,
        task_ids: str = None,
    ):
        self.city = city
        self.end_time = end_time
        self.filter = filter
        self.isp = isp
        self.length = length
        self.metric_name = metric_name
        self.next_token = next_token
        self.region_id = region_id
        self.start_time = start_time
        self.task_ids = task_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter is not None:
            result['Filter'] = self.filter
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Filter') is not None:
            self.filter = m.get('Filter')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DescribeSiteMonitorLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorQuotaRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSiteMonitorQuotaResponseBodyData(TeaModel):
    def __init__(
        self,
        second_monitor: bool = None,
        site_monitor_idc_quota: int = None,
        site_monitor_operator_quota_quota: int = None,
        site_monitor_quota_task_used: int = None,
        site_monitor_task_quota: int = None,
        site_monitor_version: str = None,
    ):
        self.second_monitor = second_monitor
        self.site_monitor_idc_quota = site_monitor_idc_quota
        self.site_monitor_operator_quota_quota = site_monitor_operator_quota_quota
        self.site_monitor_quota_task_used = site_monitor_quota_task_used
        self.site_monitor_task_quota = site_monitor_task_quota
        self.site_monitor_version = site_monitor_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.second_monitor is not None:
            result['SecondMonitor'] = self.second_monitor
        if self.site_monitor_idc_quota is not None:
            result['SiteMonitorIdcQuota'] = self.site_monitor_idc_quota
        if self.site_monitor_operator_quota_quota is not None:
            result['SiteMonitorOperatorQuotaQuota'] = self.site_monitor_operator_quota_quota
        if self.site_monitor_quota_task_used is not None:
            result['SiteMonitorQuotaTaskUsed'] = self.site_monitor_quota_task_used
        if self.site_monitor_task_quota is not None:
            result['SiteMonitorTaskQuota'] = self.site_monitor_task_quota
        if self.site_monitor_version is not None:
            result['SiteMonitorVersion'] = self.site_monitor_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecondMonitor') is not None:
            self.second_monitor = m.get('SecondMonitor')
        if m.get('SiteMonitorIdcQuota') is not None:
            self.site_monitor_idc_quota = m.get('SiteMonitorIdcQuota')
        if m.get('SiteMonitorOperatorQuotaQuota') is not None:
            self.site_monitor_operator_quota_quota = m.get('SiteMonitorOperatorQuotaQuota')
        if m.get('SiteMonitorQuotaTaskUsed') is not None:
            self.site_monitor_quota_task_used = m.get('SiteMonitorQuotaTaskUsed')
        if m.get('SiteMonitorTaskQuota') is not None:
            self.site_monitor_task_quota = m.get('SiteMonitorTaskQuota')
        if m.get('SiteMonitorVersion') is not None:
            self.site_monitor_version = m.get('SiteMonitorVersion')
        return self


class DescribeSiteMonitorQuotaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSiteMonitorQuotaResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSiteMonitorQuotaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorStatisticsRequest(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        region_id: str = None,
        start_time: str = None,
        task_id: str = None,
        time_range: str = None,
    ):
        self.metric_name = metric_name
        self.region_id = region_id
        self.start_time = start_time
        self.task_id = task_id
        self.time_range = time_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        return self


class DescribeSiteMonitorStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSiteMonitorStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventAttributeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_type: str = None,
        group_id: str = None,
        level: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
        status: str = None,
    ):
        self.end_time = end_time
        self.event_type = event_type
        self.group_id = group_id
        self.level = level
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.product = product
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent(TeaModel):
    def __init__(
        self,
        content: str = None,
        group_id: str = None,
        instance_name: str = None,
        level: str = None,
        name: str = None,
        product: str = None,
        region_id: str = None,
        resource_id: str = None,
        status: str = None,
        time: int = None,
    ):
        self.content = content
        self.group_id = group_id
        self.instance_name = instance_name
        self.level = level
        self.name = name
        self.product = product
        self.region_id = region_id
        self.resource_id = resource_id
        self.status = status
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeSystemEventAttributeResponseBodySystemEvents(TeaModel):
    def __init__(
        self,
        system_event: List[DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent] = None,
    ):
        self.system_event = system_event

    def validate(self):
        if self.system_event:
            for k in self.system_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEvent'] = []
        if self.system_event is not None:
            for k in self.system_event:
                result['SystemEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.system_event = []
        if m.get('SystemEvent') is not None:
            for k in m.get('SystemEvent'):
                temp_model = DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent()
                self.system_event.append(temp_model.from_map(k))
        return self


class DescribeSystemEventAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        system_events: DescribeSystemEventAttributeResponseBodySystemEvents = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.system_events = system_events

    def validate(self):
        if self.system_events:
            self.system_events.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_events is not None:
            result['SystemEvents'] = self.system_events.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEvents') is not None:
            temp_model = DescribeSystemEventAttributeResponseBodySystemEvents()
            self.system_events = temp_model.from_map(m['SystemEvents'])
        return self


class DescribeSystemEventAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSystemEventAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventCountRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_type: str = None,
        group_id: str = None,
        level: str = None,
        name: str = None,
        product: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
        status: str = None,
    ):
        self.end_time = end_time
        self.event_type = event_type
        self.group_id = group_id
        self.level = level
        self.name = name
        self.product = product
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount(TeaModel):
    def __init__(
        self,
        content: str = None,
        group_id: str = None,
        instance_name: str = None,
        level: str = None,
        name: str = None,
        num: int = None,
        product: str = None,
        region_id: str = None,
        resource_id: str = None,
        status: str = None,
        time: int = None,
    ):
        self.content = content
        self.group_id = group_id
        self.instance_name = instance_name
        self.level = level
        self.name = name
        self.num = num
        self.product = product
        self.region_id = region_id
        self.resource_id = resource_id
        self.status = status
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.num is not None:
            result['Num'] = self.num
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeSystemEventCountResponseBodySystemEventCounts(TeaModel):
    def __init__(
        self,
        system_event_count: List[DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount] = None,
    ):
        self.system_event_count = system_event_count

    def validate(self):
        if self.system_event_count:
            for k in self.system_event_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEventCount'] = []
        if self.system_event_count is not None:
            for k in self.system_event_count:
                result['SystemEventCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.system_event_count = []
        if m.get('SystemEventCount') is not None:
            for k in m.get('SystemEventCount'):
                temp_model = DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount()
                self.system_event_count.append(temp_model.from_map(k))
        return self


class DescribeSystemEventCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        system_event_counts: DescribeSystemEventCountResponseBodySystemEventCounts = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.system_event_counts = system_event_counts

    def validate(self):
        if self.system_event_counts:
            self.system_event_counts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_event_counts is not None:
            result['SystemEventCounts'] = self.system_event_counts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEventCounts') is not None:
            temp_model = DescribeSystemEventCountResponseBodySystemEventCounts()
            self.system_event_counts = temp_model.from_map(m['SystemEventCounts'])
        return self


class DescribeSystemEventCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSystemEventCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventHistogramRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_type: str = None,
        group_id: str = None,
        level: str = None,
        name: str = None,
        product: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
        status: str = None,
    ):
        self.end_time = end_time
        self.event_type = event_type
        self.group_id = group_id
        self.level = level
        self.name = name
        self.product = product
        self.region_id = region_id
        self.search_keywords = search_keywords
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram(TeaModel):
    def __init__(
        self,
        count: int = None,
        end_time: int = None,
        start_time: int = None,
    ):
        self.count = count
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSystemEventHistogramResponseBodySystemEventHistograms(TeaModel):
    def __init__(
        self,
        system_event_histogram: List[DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram] = None,
    ):
        self.system_event_histogram = system_event_histogram

    def validate(self):
        if self.system_event_histogram:
            for k in self.system_event_histogram:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEventHistogram'] = []
        if self.system_event_histogram is not None:
            for k in self.system_event_histogram:
                result['SystemEventHistogram'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.system_event_histogram = []
        if m.get('SystemEventHistogram') is not None:
            for k in m.get('SystemEventHistogram'):
                temp_model = DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram()
                self.system_event_histogram.append(temp_model.from_map(k))
        return self


class DescribeSystemEventHistogramResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        system_event_histograms: DescribeSystemEventHistogramResponseBodySystemEventHistograms = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.system_event_histograms = system_event_histograms

    def validate(self):
        if self.system_event_histograms:
            self.system_event_histograms.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_event_histograms is not None:
            result['SystemEventHistograms'] = self.system_event_histograms.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEventHistograms') is not None:
            temp_model = DescribeSystemEventHistogramResponseBodySystemEventHistograms()
            self.system_event_histograms = temp_model.from_map(m['SystemEventHistograms'])
        return self


class DescribeSystemEventHistogramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSystemEventHistogramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventMetaListRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSystemEventMetaListResponseBodyDataResource(TeaModel):
    def __init__(
        self,
        event_type: str = None,
        level: str = None,
        name: str = None,
        name_desc: str = None,
        name_desc_en: str = None,
        product: str = None,
        status: str = None,
        status_desc: str = None,
    ):
        self.event_type = event_type
        self.level = level
        self.name = name
        self.name_desc = name_desc
        self.name_desc_en = name_desc_en
        self.product = product
        self.status = status
        self.status_desc = status_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.name_desc is not None:
            result['NameDesc'] = self.name_desc
        if self.name_desc_en is not None:
            result['NameDesc.En'] = self.name_desc_en
        if self.product is not None:
            result['Product'] = self.product
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameDesc') is not None:
            self.name_desc = m.get('NameDesc')
        if m.get('NameDesc.En') is not None:
            self.name_desc_en = m.get('NameDesc.En')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        return self


class DescribeSystemEventMetaListResponseBodyData(TeaModel):
    def __init__(
        self,
        resource: List[DescribeSystemEventMetaListResponseBodyDataResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeSystemEventMetaListResponseBodyDataResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeSystemEventMetaListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DescribeSystemEventMetaListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSystemEventMetaListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSystemEventMetaListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSystemEventMetaListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagKeyListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeTagKeyListResponseBodyTagKeys(TeaModel):
    def __init__(
        self,
        tag_key: List[str] = None,
    ):
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeTagKeyListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        tag_keys: DescribeTagKeyListResponseBodyTagKeys = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.tag_keys = tag_keys

    def validate(self):
        if self.tag_keys:
            self.tag_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagKeys') is not None:
            temp_model = DescribeTagKeyListResponseBodyTagKeys()
            self.tag_keys = temp_model.from_map(m['TagKeys'])
        return self


class DescribeTagKeyListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTagKeyListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTagKeyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagValueListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        tag_key: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeTagValueListResponseBodyTagValues(TeaModel):
    def __init__(
        self,
        tag_value: List[str] = None,
    ):
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeTagValueListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        tag_values: DescribeTagValueListResponseBodyTagValues = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.tag_values = tag_values

    def validate(self):
        if self.tag_values:
            self.tag_values.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_values is not None:
            result['TagValues'] = self.tag_values.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagValues') is not None:
            temp_model = DescribeTagValueListResponseBodyTagValues()
            self.tag_values = temp_model.from_map(m['TagValues'])
        return self


class DescribeTagValueListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTagValueListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTagValueListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUnhealthyHostAvailabilityRequest(TeaModel):
    def __init__(
        self,
        id: List[int] = None,
        region_id: str = None,
    ):
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstanceInstanceList(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstance(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_list: DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstanceInstanceList = None,
    ):
        self.id = id
        self.instance_list = instance_list

    def validate(self):
        if self.instance_list:
            self.instance_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceList') is not None:
            temp_model = DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstanceInstanceList()
            self.instance_list = temp_model.from_map(m['InstanceList'])
        return self


class DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyList(TeaModel):
    def __init__(
        self,
        node_task_instance: List[DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstance] = None,
    ):
        self.node_task_instance = node_task_instance

    def validate(self):
        if self.node_task_instance:
            for k in self.node_task_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeTaskInstance'] = []
        if self.node_task_instance is not None:
            for k in self.node_task_instance:
                result['NodeTaskInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_task_instance = []
        if m.get('NodeTaskInstance') is not None:
            for k in m.get('NodeTaskInstance'):
                temp_model = DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyListNodeTaskInstance()
                self.node_task_instance.append(temp_model.from_map(k))
        return self


class DescribeUnhealthyHostAvailabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        unhealthy_list: DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyList = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.unhealthy_list = unhealthy_list

    def validate(self):
        if self.unhealthy_list:
            self.unhealthy_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.unhealthy_list is not None:
            result['UnhealthyList'] = self.unhealthy_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('UnhealthyList') is not None:
            temp_model = DescribeUnhealthyHostAvailabilityResponseBodyUnhealthyList()
            self.unhealthy_list = temp_model.from_map(m['UnhealthyList'])
        return self


class DescribeUnhealthyHostAvailabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUnhealthyHostAvailabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUnhealthyHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableActiveMetricRuleRequest(TeaModel):
    def __init__(
        self,
        product: str = None,
        region_id: str = None,
    ):
        self.product = product
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DisableActiveMetricRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableActiveMetricRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableActiveMetricRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableActiveMetricRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableEventRulesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_names: List[str] = None,
    ):
        self.region_id = region_id
        self.rule_names = rule_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        return self


class DisableEventRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.