# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fair',
 'fair.configuration',
 'fair.registry',
 'fair.templates',
 'fair.user_config']

package_data = \
{'': ['*']}

install_requires = \
['GitPython>=3.1.18,<4.0.0',
 'Jinja2>=3.0.1,<4.0.0',
 'PyYAML>=5.4.1,<7.0.0',
 'click>=8.0.0,<9.0.0',
 'email-validator>=1.1.3,<2.0.0',
 'netCDF4>=1.5.8,<2.0.0',
 'pre-commit>=2.15.0,<3.0.0',
 'pydantic[email]>=1.9.0,<2.0.0',
 'requests>=2.23.0,<3.0.0',
 'rich>=10.2.3,<12.0.0',
 'semver>=2.13.0,<3.0.0',
 'simplejson>=3.17.5,<4.0.0',
 'toml>=0.10.2,<0.11.0',
 'validators>=0.18.2,<0.19.0']

entry_points = \
{'console_scripts': ['fair = fair.cli:cli']}

setup_kwargs = {
    'name': 'fair-cli',
    'version': '0.4.0',
    'description': 'Synchronization interface for the SCRC FAIR Data Pipeline registry',
    'long_description': '# FAIR Data Pipeline Command Line Interface\n\n[![PyPI](https://img.shields.io/pypi/v/fair-cli)](https://pypi.org/project/fair-cli/) [![PyPI - Python Version](https://img.shields.io/pypi/pyversions/fair-cli)](https://pypi.org/project/fair-cli/) [![DOI](https://zenodo.org/badge/377398464.svg)](https://zenodo.org/badge/latestdoi/377398464) ![PyPI - License](https://img.shields.io/pypi/l/fair-cli)  [![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/5411/badge)](https://bestpractices.coreinfrastructure.org/projects/5411)\n\n[![FAIR Data Pipeline CLI](https://github.com/FAIRDataPipeline/FAIR-CLI/actions/workflows/fair-cli.yaml/badge.svg?branch=main)](https://github.com/FAIRDataPipeline/FAIR-CLI/actions/workflows/fair-cli.yaml)  [![codecov](https://codecov.io/gh/FAIRDataPipeline/FAIR-CLI/branch/dev/graph/badge.svg?token=h93TkTiiWf)](https://codecov.io/gh/FAIRDataPipeline/FAIR-CLI) [![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=FAIRDataPipeline_FAIR-CLI&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=FAIRDataPipeline_FAIR-CLI)\n\nFAIR-CLI forms the main interface for synchronising changes between local and shared remote FAIR Data Pipeline registries, it is also used to instantiate model runs/data submissions to the pipeline. Full documentation of the FAIR Data Pipeline can be found on the project [website](https://www.fairdatapipeline.org/).\n\n## Installation\n\nThe package is installed using Pip:\n\n```sh\npip install fair-cli\n```\n\nTo enable tab completion you need to modify your shell:\n\n### Bash\n```\n_FAIR_COMPLETE=bash_source fair > ~/.config/.fair-complete.bash\necho \'. ~/.config/.fair-complete.bash\' >> ~/.bashrc\n```\n\n### zsh\n```\n_FAIR_COMPLETE=zsh_source fair > ~/.fair-complete.zsh\necho \'. ~/.fair-complete.zsh\' >> ~/.bashrc\n```\n\n### Fish\n```\n_FAIR_COMPLETE=bash_source fair > ~/.config/fish/.fair-complete.fish\necho \'. ~/.config/fish/.fair-complete.fish\' >> ~/.bashrc\n```\n\n## Uninstallation\nTo uninstall the CLI run:\n```\nfair purge --all\npip uninstall fair\n```\n\n## The User Configuration File\nJob runs are configured via `config.yaml` files. Upon initialisation of a project, FAIR-CLI automatically generates a starter configuration file with all requirements in place. To execute a process (e.g. perform a model run from a compiled binary/script) an additional key of either `script` or `script_path` must be provided. Alternatively the command `fair run bash` can be used to append the key and run a command directly.\n\nBy default the shell used to execute a process is `sh` or `batch` for UNIX and Windows systems respectively. This can be overwritten by assigning the optional `shell` key with one of the following values (where `{0}` is the script file):\n\n| **Shell**    | **Command**                     |\n| ------------ | ------------------------------- |\n| `bash`       | `bash -eo pipefail {0}`         |\n| `java`       | `java {0}`                      |\n| `julia`      | `julia {0}`                     |\n| `powershell` | `powershell -command ". \'{0}\'"` |\n| `pwsh`       | `pwsh -command ". \'{0}\'"`       |\n| `python2`    | `python2 {0}`                   |\n| `python3`    | `python3 {0}`                   |\n| `python`     | `python {0}`                    |\n| `R`          | `R -f {0}`                      |\n| `sh`         | `sh -e {0}`                     |\n| `batch`      | `{0}`                           |\n\nA full description of `config.yaml` files can be found [here](https://www.fairdatapipeline.org/docs/interface/config/).\n\n## Available Commands\n\n### `init`\n\nInitialises a new FAIR repository within the given directory. This should ideally be the same location as the `.git` folder for the current project, however during setup an option is given to specify an alternative. The command will ask the user a series of questions which will provide metadata for tracking run authors, and also allow for the creation of a starter `config.yaml` file. Initialisation will also configure the CLI itself.\n\n#### Custom CLI Configuration\nAfter setup is complete, the current CLI configuration can also be saved using the command:\n```\nfair init --export\n```\nthe created file can then be re-read at a later point during setup. Alternatively, if creating a configuration from scratch the YAML file should contain the following information:\n\n```yaml\nnamespaces:\n  input: testing\n  output: testing\nregistries:\n  local:\n    data_store: /path/to/local/data_store/,\n    directory: /local/registry/install/directory\n    uri: http://127.0.0.1:8000/api/\n  origin:\n    data_store: /remote/registry/data/store/path/\n    token: /path/to/remote/token\n    uri: https://data.scrc.uk/api/\'\nuser:\n  email: \'test@noreply\',\n  family_name: \'Test\'\n  given_names: \'Interface\'\n  orcid: None,\n  uuid: \'2ddb2358-84bf-43ff-b2aa-3ac7dc3b49f1\'\ngit:\n  local_repo: /local/repo/path\n  remote: origin\ndescription: Testing Project\n```\nthis file is then read during the initialisation:\n\n```sh\nfair init --using <cli-config.yaml file>\n```\n\nFor integration into a CI workflow, the setup can be skipped by running:\n\n```sh\nfair init --ci\n```\n\nwhich will create temporary directories for some of the required location paths.\n\n\n### `run`\n\nThe purpose of `run` is to execute a model/submission run and submit results to the local registry. Outputs of a run will be stored within the `coderun` folder in the directory specified under the `data_store` tag in the `config.yaml`, by default this is `$HOME/.fair/data/coderun`.\n\n```sh\nfair run\n```\n\nIf you wish to use an alternative `config.yaml` then specify it as an additional argument:\n\n```sh\nfair run /path/to/config.yaml\n```\n\nYou can also launch a bash command directly, this will be automatically written into the `config.yaml`:\n\n```sh\nfair run --script \'echo "Hello World"\'\n```\n\nnote the command itself must be quoted as it is a single argument.\n\nBy default the CLI will not allow the user to perform a run if the state of the analysis repository is such that it is behind the git remote, or contains uncommitted changes. To override this behaviour use the `--dirty` flag.\n\n### `pull`\n\nThe command `pull` will update any entries within the `config.yaml` under the `register` heading creating `external_object` and `data_product` objects on the registry and downloading the data to the local data storage. Any data required for a run is downloaded and stored within the local registry. In addition any data products requested that are available on the remote registry are pulled locally.\n\n```sh\nfair pull /path/to/config.yaml\n```\n\n### `status`\nThis command displays objects which are awaiting staging or have been staged behaving in a manner similar to `git status`:\n```sh\nfair status\n```\nstaged changes are displayed in green, and unstaged in red.\n\n### `add`\nBefore changes can be pushed to the remote registry they must be staged. This command allows you to stage objects displayed when running `fair status` so that they can be sent to the remote registry. Data products are displayed and staged in the form `namespace:data_product_name@version`:\n```sh\nfair add my_namespace:data_object@v0.1.0\n```\n\n### `push`\nThe `push` command will push any staged data products to the remote registry:\n\n```sh\nfair push\n```\n\n### `purge`\n\nThe `purge` command removes setup of the current project so it can bereinitialised:\n\n```sh\nfair purge\n```\n\nTo remove all configurations entirely (including those global to all projects) run:\n\n```sh\nfair purge --global\n```\n\nTo remove the data directory itself run:\n\n```sh\nfair purge --data\n```\n\n**WARNING**: This is not recommended as the registry may still have entries pointing to this location!\n\nFinally to remove everything run:\n\n```sh\nfair purge --all\n```\n\nthis will remove the current repository `.fair` folder and the global FAIR directory which also contains the local registry.\n\nYou can skip any confirmation messages by running:\n\n```sh\nfair purge --yes\n```\n\n### `registry`\n\nBy default the CLI will launch the registry whenever a synchronisation or run is called. The server will only be halted once all ongoing CLI processes (in the case of multiple parallel calls) have been completed.\n\nHowever the user may also specify a manual launch that will override this behaviour, instead leaving the server running constantly allowing them to view the registry in the browser.\n\nThe commands:\n\n```sh\nfair registry start\n```\n\nand\n\n```sh\nfair registry stop\n```\n\nwill launch and halt the server respectively.\n\nThe registry can be installed using the CLI as well by running:\n```sh\nfair registry install\n```\nwith the additional options to specify the installation location, and the data registry repository tag to install from:\n```sh\nfair registry install --directory ~/.fair/my_registry --version v1.0-rc5\n```\n\n### `log`\n\nRuns are logged locally within the local FAIR repository. A full list of runs is shown by running:\n\n```sh\nfair log\n```\n\nThis will present a list of runs in a summary analogous to a `git log` call:\n\n```yaml\nrun 0db35c20946a1ebeaafdc3b30103cd74a57eb6b6\nAuthor: Joe Bloggs <jbloggs@noreply.uk>\nDate:   Wed Jun 30 09:09:30 2021\n```\n\n| **NOTE**                                                                                                                            |\n| ----------------------------------------------------------------------------------------------------------------------------------- |\n| The SHA for a job is *not* related to a registry code run identifier as multiple code runs can be executed within a single job. |\n\n### `view`\n\nTo view the `stdout` of a run given its SHA as shown by running `fair log` use the command:\n\n```sh\nfair view <sha>\n```\n\nyou do not need to specify the full SHA but rather the first few unique characters.\n\n## Template Variables\n\nWithin the `config.yaml` file, template variables can be specified by using the notation `${{ VAR }}`, the following variables are currently recognised:\n\n| **Variable**        | **Description**                                                                  |\n| ------------------- | -------------------------------------------------------------------------------- |\n| `DATE`              | Date in the form `%Y%m%d`                                                        |\n| `DATETIME`          | Date and time in the form `%Y-%m-%sT%H:%M:S`                                     |\n| `DATETIME-%Y%H%M`   | Date and time in custom format (where `%Y%H%M` can be any valid form)            |\n| `USER`              | The current user as defined in the CLI                                           |\n| `USER_ID`           | The unique identifier for the current user        |\n| `REPO_DIR`          | The FAIR repository root directory                                               |\n| `CONFIG_DIR`        | The directory containing the `config.yaml` after template substitution           |\n| `LOCAL_TOKEN`       | The token for access to the local registry                                       |\n| `SOURCE_CONFIG`     | Path of the user defined `config.yaml`                                           |\n| `GIT_BRANCH`        | Current branch of the `git` repository                                           |\n| `GIT_REMOTE`        | The URI of the git repository specified during setup                             |\n| `GIT_TAG`           | The latest tag on `git`                                                          |\n',
    'author': 'Richard Reeve',
    'author_email': 'richard.reeve@glasgow.ac.uk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://www.fairdatapipeline.org/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
