from pydantic import BaseModel, Field, computed_field, field_validator, model_validator
from almanac.data_models.types import *

class SourceMetadata(BaseModel):

    # Identifiers
    sdss_id: Int64 = Field(default=-1)
    catalogid: Int64 = Field(default=-1)
    version_id: int = Field(default=-1)
    lead: str = Field(default="")
    allstar_dr17_synspec_rev1: Str = Field(default=-1)
    allwise: Int64 = Field(default=-1)
    bhm_rm_v0: Int64 = Field(default=-1)
    bhm_rm_v0_2: Int64 = Field(default=-1)
    catwise: Str = Field(default=-1)
    catwise2020: Str = Field(default=-1)
    gaia_dr2_source: Int64 = Field(default=-1)
    gaia_dr3_source: Int64 = Field(default=-1)
    glimpse: Int64 = Field(default=-1)
    guvcat: Int64 = Field(default=-1)
    legacy_survey_dr10: Int64 = Field(default=-1)
    legacy_survey_dr8: Int64 = Field(default=-1)
    mangatarget: Str = Field(default=-1)
    marvels_dr11_star: Str = Field(default=-1)
    marvels_dr12_star: Int64 = Field(default=-1)
    mastar_goodstars: Str = Field(default=-1)
    panstarrs1: Int64 = Field(default=-1)
    ps1_g18: Int64 = Field(default=-1)
    sdss_dr13_photoobj: Int64 = Field(default=-1)
    sdss_dr17_specobj: Str = Field(default=-1)
    skymapper_dr1_1: Int64 = Field(default=-1)
    skymapper_dr2: Int64 = Field(default=-1)
    supercosmos: Int64 = Field(default=-1)
    tic_v8: Int64 = Field(default=-1)
    twomass_psc: Int64 = Field(default=-1)
    tycho2: Str = Field(default=-1)
    unwise: Str = Field(default=-1)

    # Gaia
    source_id: Int = Field(default=-1)
    solution_id: Int = Field(default=-1)
    designation: Str = Field(default=-1)
    random_index: Float = Field(default=-1)
    ref_epoch: Float = Field(default=-1)
    ra: Float = Field(default=-1)
    ra_error: Float = Field(default=-1)
    dec: Float = Field(default=-1)
    dec_error: Float = Field(default=-1)
    parallax: Float = Field(default=-1)
    parallax_error: Float = Field(default=-1)
    parallax_over_error: Float = Field(default=-1)
    pm: Float = Field(default=-1)
    pmra: Float = Field(default=-1)
    pmra_error: Float = Field(default=-1)
    pmdec: Float = Field(default=-1)
    pmdec_error: Float = Field(default=-1)
    ra_dec_corr: Float = Field(default=-1)
    ra_parallax_corr: Float = Field(default=-1)
    ra_pmra_corr: Float = Field(default=-1)
    ra_pmdec_corr: Float = Field(default=-1)
    dec_parallax_corr: Float = Field(default=-1)
    dec_pmra_corr: Float = Field(default=-1)
    dec_pmdec_corr: Float = Field(default=-1)
    parallax_pmra_corr: Float = Field(default=-1)
    parallax_pmdec_corr: Float = Field(default=-1)
    pmra_pmdec_corr: Float = Field(default=-1)
    astrometric_n_obs_al: Int = Field(default=-1)
    astrometric_n_obs_ac: Int = Field(default=-1)
    astrometric_n_good_obs_al: Int = Field(default=-1)
    astrometric_n_bad_obs_al: Int = Field(default=-1)
    astrometric_gof_al: Float = Field(default=-1)
    astrometric_chi2_al: Float = Field(default=-1)
    astrometric_excess_noise: Float = Field(default=-1)
    astrometric_excess_noise_sig: Float = Field(default=-1)
    astrometric_params_solved: Int = Field(default=-1)
    astrometric_primary_flag: Bool = Field(default=-1)
    nu_eff_used_in_astrometry: Float = Field(default=-1)
    pseudocolour: Float = Field(default=-1)
    pseudocolour_error: Float = Field(default=-1)
    ra_pseudocolour_corr: Float = Field(default=-1)
    dec_pseudocolour_corr: Float = Field(default=-1)
    parallax_pseudocolour_corr: Float = Field(default=-1)
    pmra_pseudocolour_corr: Float = Field(default=-1)
    pmdec_pseudocolour_corr: Float = Field(default=-1)
    astrometric_matched_transits: Int = Field(default=-1)
    visibility_periods_used: Int = Field(default=-1)
    astrometric_sigma5d_max: Float = Field(default=-1)
    matched_transits: Int = Field(default=-1)
    new_matched_transits: Int = Field(default=-1)
    matched_transits_removed: Int = Field(default=-1)
    ipd_gof_harmonic_amplitude: Float = Field(default=-1)
    ipd_gof_harmonic_phase: Float = Field(default=-1)
    ipd_frac_multi_peak: Float = Field(default=-1)
    ipd_frac_odd_win: Float = Field(default=-1)
    ruwe: Float = Field(default=-1)
    scan_direction_strength_k1: Float = Field(default=-1)
    scan_direction_strength_k2: Float = Field(default=-1)
    scan_direction_strength_k3: Float = Field(default=-1)
    scan_direction_strength_k4: Float = Field(default=-1)
    scan_direction_mean_k1: Float = Field(default=-1)
    scan_direction_mean_k2: Float = Field(default=-1)
    scan_direction_mean_k3: Float = Field(default=-1)
    scan_direction_mean_k4: Float = Field(default=-1)
    duplicated_source: Bool = Field(default=-1)
    phot_g_n_obs: Int = Field(default=-1)
    phot_g_mean_flux: Float = Field(default=-1)
    phot_g_mean_flux_error: Float = Field(default=-1)
    phot_g_mean_flux_over_error: Float = Field(default=-1)
    phot_g_mean_mag: Float = Field(default=-1)
    phot_bp_n_obs: Int = Field(default=-1)
    phot_bp_mean_flux: Float = Field(default=-1)
    phot_bp_mean_flux_error: Float = Field(default=-1)
    phot_bp_mean_flux_over_error: Float = Field(default=-1)
    phot_bp_mean_mag: Float = Field(default=-1)
    phot_rp_n_obs: Int = Field(default=-1)
    phot_rp_mean_flux: Float = Field(default=-1)
    phot_rp_mean_flux_error: Float = Field(default=-1)
    phot_rp_mean_flux_over_error: Float = Field(default=-1)
    phot_rp_mean_mag: Float = Field(default=-1)
    phot_bp_rp_excess_factor: Float = Field(default=-1)
    phot_bp_n_contaminated_transits: Int = Field(default=-1)
    phot_bp_n_blended_transits: Int = Field(default=-1)
    phot_rp_n_contaminated_transits: Int = Field(default=-1)
    phot_rp_n_blended_transits: Int = Field(default=-1)
    phot_proc_mode: Int = Field(default=-1)
    bp_rp: Float = Field(default=-1)
    bp_g: Float = Field(default=-1)
    g_rp: Float = Field(default=-1)
    radial_velocity: Float = Field(default=-1)
    radial_velocity_error: Float = Field(default=-1)
    rv_method_used: Str = Field(default=-1)
    rv_nb_transits: Int = Field(default=-1)
    rv_nb_deblended_transits: Int = Field(default=-1)
    rv_visibility_periods_used: Int = Field(default=-1)
    rv_expected_sig_to_noise: Float = Field(default=-1)
    rv_renormalised_gof: Float = Field(default=-1)
    rv_chisq_pvalue: Float = Field(default=-1)
    rv_time_duration: Float = Field(default=-1)
    rv_amplitude_robust: Float = Field(default=-1)
    rv_template_teff: Float = Field(default=-1)
    rv_template_logg: Float = Field(default=-1)
    rv_template_fe_h: Float = Field(default=-1)
    rv_atm_param_origin: Str = Field(default=-1)
    vbroad: Float = Field(default=-1)
    vbroad_error: Float = Field(default=-1)
    vbroad_nb_transits: Int = Field(default=-1)
    grvs_mag: Float = Field(default=-1)
    grvs_mag_error: Float = Field(default=-1)
    grvs_mag_nb_transits: Int = Field(default=-1)
    rvs_spec_sig_to_noise: Float = Field(default=-1)
    phot_variable_flag: Str = Field(default=-1)
    l: Float = Field(default=-1)
    b: Float = Field(default=-1)
    ecl_lon: Float = Field(default=-1)
    ecl_lat: Float = Field(default=-1)
    in_qso_candidates: Bool = Field(default=-1)
    in_galaxy_candidates: Bool = Field(default=-1)
    non_single_star: Bool = Field(default=-1)
    has_xp_continuous: Bool = Field(default=-1)
    has_xp_sampled: Bool = Field(default=-1)
    has_rvs: Bool = Field(default=-1)
    has_epoch_photometry: Bool = Field(default=-1)
    has_epoch_rv: Bool = Field(default=-1)
    has_mcmc_gspphot: Bool = Field(default=-1)
    has_mcmc_msc: Bool = Field(default=-1)
    in_andromeda_survey: Bool = Field(default=-1)
    classprob_dsc_combmod_quasar: Float = Field(default=-1)
    classprob_dsc_combmod_galaxy: Float = Field(default=-1)
    classprob_dsc_combmod_star: Float = Field(default=-1)
    teff_gspphot: Float = Field(default=-1)
    teff_gspphot_lower: Float = Field(default=-1)
    teff_gspphot_upper: Float = Field(default=-1)
    logg_gspphot: Float = Field(default=-1)
    logg_gspphot_lower: Float = Field(default=-1)
    logg_gspphot_upper: Float = Field(default=-1)
    mh_gspphot: Float = Field(default=-1)
    mh_gspphot_lower: Float = Field(default=-1)
    mh_gspphot_upper: Float = Field(default=-1)
    distance_gspphot: Float = Field(default=-1)
    distance_gspphot_lower: Float = Field(default=-1)
    distance_gspphot_upper: Float = Field(default=-1)
    azero_gspphot: Float = Field(default=-1)
    azero_gspphot_lower: Float = Field(default=-1)
    azero_gspphot_upper: Float = Field(default=-1)
    ag_gspphot: Float = Field(default=-1)
    ag_gspphot_lower: Float = Field(default=-1)
    ag_gspphot_upper: Float = Field(default=-1)
    ebpminrp_gspphot: Float = Field(default=-1)
    ebpminrp_gspphot_lower: Float = Field(default=-1)
    ebpminrp_gspphot_upper: Float = Field(default=-1)
    libname_gspphot: Str = Field(default=-1)
    j_m: Float = Field(default=-1)
    j_cmsig: Float = Field(default=-1)
    j_msigcom: Float = Field(default=-1)
    j_snr: Float = Field(default=-1)
    h_m: Float = Field(default=-1)
    h_cmsig: Float = Field(default=-1)
    h_msigcom: Float = Field(default=-1)
    h_snr: Float = Field(default=-1)
    k_m: Float = Field(default=-1)
    k_cmsig: Float = Field(default=-1)
    k_msigcom: Float = Field(default=-1)
    k_snr: Float = Field(default=-1)
    ph_qual: Str = Field(default=-1)
    rd_flg: Str = Field(default=-1)
    bl_flg: Str = Field(default=-1)
    cc_flg: Str = Field(default=-1)
    ndet: Int = Field(default=-1)
    prox: Float = Field(default=-1)
    pxpa: Float = Field(default=-1)
    pxcntr: Float = Field(default=-1)
    gal_contam: Int = Field(default=-1)
    mp_flg: Int = Field(default=-1)
    scan: Int = Field(default=-1)
    glon: Float = Field(default=-1)
    glat: Float = Field(default=-1)
    x_scan: Float = Field(default=-1)
    jdate: Float = Field(default=-1)
    j_psfchi: Float = Field(default=-1)
    h_psfchi: Float = Field(default=-1)
    k_psfchi: Float = Field(default=-1)
    j_m_stdap: Float = Field(default=-1)
    j_msig_stdap: Float = Field(default=-1)
    h_m_stdap: Float = Field(default=-1)
    h_msig_stdap: Float = Field(default=-1)
    k_m_stdap: Float = Field(default=-1)
    k_msig_stdap: Float = Field(default=-1)
    dist_edge_ns: Float = Field(default=-1)
    dist_edge_ew: Float = Field(default=-1)
    dist_edge_flg: Str = Field(default=-1)
    dup_src: Int = Field(default=-1)
    use_src: Int = Field(default=-1)
    a: Str = Field(default=-1)
    dist_opt: Float = Field(default=-1)
    phi_opt: Float = Field(default=-1)
    b_m_opt: Float = Field(default=-1)
    vr_m_opt: Float = Field(default=-1)
    nopt_mchs: Int = Field(default=-1)
    ext_key: Int = Field(default=-1)
    scan_key: Int = Field(default=-1)
    coadd_key: Int = Field(default=-1)
    coad: Int = Field(default=-1)

    class Config:
        validate_by_name = True
        validate_assignment = True
        arbitrary_types_allowed = True
