# coding: utf-8

"""
    Unity Cloud Build

    This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found at https://build.cloud.unity3d.com/login/me  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ```   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class OrgsorgidprojectsprojectidbuildtargetsBuilds(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'build': 'float',
        'buildtargetid': 'str',
        'build_target_name': 'str',
        'build_guid': 'str',
        'build_status': 'str',
        'clean_build': 'bool',
        'failure_details': 'list[OrgsorgidprojectsprojectidbuildtargetsFailureDetails]',
        'canceled_by': 'str',
        'platform': 'str',
        'workspace_size': 'float',
        'created': 'str',
        'finished': 'str',
        'checkout_start_time': 'str',
        'checkout_time_in_seconds': 'float',
        'build_start_time': 'str',
        'build_time_in_seconds': 'float',
        'publish_start_time': 'str',
        'publish_time_in_seconds': 'float',
        'total_time_in_seconds': 'float',
        'unit_test_time_in_seconds': 'float',
        'edit_mode_test_time_in_seconds': 'float',
        'play_mode_test_time_in_seconds': 'float',
        'last_built_revision': 'str',
        'changeset': 'list[object]',
        'favorited': 'bool',
        'label': 'str',
        'deleted': 'bool',
        'headless': 'object',
        'credentials_outdated': 'bool',
        'deleted_by': 'str',
        'queued_reason': 'str',
        'cooldown_date': 'str',
        'scm_branch': 'str',
        'unity_version': 'str',
        'xcode_version': 'str',
        'audit_changes': 'float',
        'project_version': 'OrgsorgidprojectsprojectidbuildtargetsProjectVersion',
        'project_name': 'str',
        'project_id': 'str',
        'project_guid': 'str',
        'org_id': 'str',
        'org_fk': 'str',
        'filetoken': 'str',
        'links': 'dict(str, OrgsorgidprojectsprojectidbuildtargetsLinks)',
        'build_report': 'OrgsorgidprojectsprojectidbuildtargetsBuildReport',
        'test_results': 'OrgsorgidprojectsprojectidbuildtargetsTestResults',
        'error': 'str'
    }

    attribute_map = {
        'build': 'build',
        'buildtargetid': 'buildtargetid',
        'build_target_name': 'buildTargetName',
        'build_guid': 'buildGUID',
        'build_status': 'buildStatus',
        'clean_build': 'cleanBuild',
        'failure_details': 'failureDetails',
        'canceled_by': 'canceledBy',
        'platform': 'platform',
        'workspace_size': 'workspaceSize',
        'created': 'created',
        'finished': 'finished',
        'checkout_start_time': 'checkoutStartTime',
        'checkout_time_in_seconds': 'checkoutTimeInSeconds',
        'build_start_time': 'buildStartTime',
        'build_time_in_seconds': 'buildTimeInSeconds',
        'publish_start_time': 'publishStartTime',
        'publish_time_in_seconds': 'publishTimeInSeconds',
        'total_time_in_seconds': 'totalTimeInSeconds',
        'unit_test_time_in_seconds': 'unitTestTimeInSeconds',
        'edit_mode_test_time_in_seconds': 'editModeTestTimeInSeconds',
        'play_mode_test_time_in_seconds': 'playModeTestTimeInSeconds',
        'last_built_revision': 'lastBuiltRevision',
        'changeset': 'changeset',
        'favorited': 'favorited',
        'label': 'label',
        'deleted': 'deleted',
        'headless': 'headless',
        'credentials_outdated': 'credentialsOutdated',
        'deleted_by': 'deletedBy',
        'queued_reason': 'queuedReason',
        'cooldown_date': 'cooldownDate',
        'scm_branch': 'scmBranch',
        'unity_version': 'unityVersion',
        'xcode_version': 'xcodeVersion',
        'audit_changes': 'auditChanges',
        'project_version': 'projectVersion',
        'project_name': 'projectName',
        'project_id': 'projectId',
        'project_guid': 'projectGuid',
        'org_id': 'orgId',
        'org_fk': 'orgFk',
        'filetoken': 'filetoken',
        'links': 'links',
        'build_report': 'buildReport',
        'test_results': 'testResults',
        'error': 'error'
    }

    def __init__(self, build=None, buildtargetid=None, build_target_name=None, build_guid=None, build_status=None, clean_build=None, failure_details=None, canceled_by=None, platform=None, workspace_size=None, created=None, finished=None, checkout_start_time=None, checkout_time_in_seconds=None, build_start_time=None, build_time_in_seconds=None, publish_start_time=None, publish_time_in_seconds=None, total_time_in_seconds=None, unit_test_time_in_seconds=None, edit_mode_test_time_in_seconds=None, play_mode_test_time_in_seconds=None, last_built_revision=None, changeset=None, favorited=None, label=None, deleted=None, headless=None, credentials_outdated=None, deleted_by=None, queued_reason=None, cooldown_date=None, scm_branch=None, unity_version=None, xcode_version=None, audit_changes=None, project_version=None, project_name=None, project_id=None, project_guid=None, org_id=None, org_fk=None, filetoken=None, links=None, build_report=None, test_results=None, error=None):  # noqa: E501
        """OrgsorgidprojectsprojectidbuildtargetsBuilds - a model defined in Swagger"""  # noqa: E501

        self._build = None
        self._buildtargetid = None
        self._build_target_name = None
        self._build_guid = None
        self._build_status = None
        self._clean_build = None
        self._failure_details = None
        self._canceled_by = None
        self._platform = None
        self._workspace_size = None
        self._created = None
        self._finished = None
        self._checkout_start_time = None
        self._checkout_time_in_seconds = None
        self._build_start_time = None
        self._build_time_in_seconds = None
        self._publish_start_time = None
        self._publish_time_in_seconds = None
        self._total_time_in_seconds = None
        self._unit_test_time_in_seconds = None
        self._edit_mode_test_time_in_seconds = None
        self._play_mode_test_time_in_seconds = None
        self._last_built_revision = None
        self._changeset = None
        self._favorited = None
        self._label = None
        self._deleted = None
        self._headless = None
        self._credentials_outdated = None
        self._deleted_by = None
        self._queued_reason = None
        self._cooldown_date = None
        self._scm_branch = None
        self._unity_version = None
        self._xcode_version = None
        self._audit_changes = None
        self._project_version = None
        self._project_name = None
        self._project_id = None
        self._project_guid = None
        self._org_id = None
        self._org_fk = None
        self._filetoken = None
        self._links = None
        self._build_report = None
        self._test_results = None
        self._error = None
        self.discriminator = None

        if build is not None:
            self.build = build
        if buildtargetid is not None:
            self.buildtargetid = buildtargetid
        if build_target_name is not None:
            self.build_target_name = build_target_name
        if build_guid is not None:
            self.build_guid = build_guid
        if build_status is not None:
            self.build_status = build_status
        if clean_build is not None:
            self.clean_build = clean_build
        if failure_details is not None:
            self.failure_details = failure_details
        if canceled_by is not None:
            self.canceled_by = canceled_by
        if platform is not None:
            self.platform = platform
        if workspace_size is not None:
            self.workspace_size = workspace_size
        if created is not None:
            self.created = created
        if finished is not None:
            self.finished = finished
        if checkout_start_time is not None:
            self.checkout_start_time = checkout_start_time
        if checkout_time_in_seconds is not None:
            self.checkout_time_in_seconds = checkout_time_in_seconds
        if build_start_time is not None:
            self.build_start_time = build_start_time
        if build_time_in_seconds is not None:
            self.build_time_in_seconds = build_time_in_seconds
        if publish_start_time is not None:
            self.publish_start_time = publish_start_time
        if publish_time_in_seconds is not None:
            self.publish_time_in_seconds = publish_time_in_seconds
        if total_time_in_seconds is not None:
            self.total_time_in_seconds = total_time_in_seconds
        if unit_test_time_in_seconds is not None:
            self.unit_test_time_in_seconds = unit_test_time_in_seconds
        if edit_mode_test_time_in_seconds is not None:
            self.edit_mode_test_time_in_seconds = edit_mode_test_time_in_seconds
        if play_mode_test_time_in_seconds is not None:
            self.play_mode_test_time_in_seconds = play_mode_test_time_in_seconds
        if last_built_revision is not None:
            self.last_built_revision = last_built_revision
        if changeset is not None:
            self.changeset = changeset
        if favorited is not None:
            self.favorited = favorited
        if label is not None:
            self.label = label
        if deleted is not None:
            self.deleted = deleted
        if headless is not None:
            self.headless = headless
        if credentials_outdated is not None:
            self.credentials_outdated = credentials_outdated
        if deleted_by is not None:
            self.deleted_by = deleted_by
        if queued_reason is not None:
            self.queued_reason = queued_reason
        if cooldown_date is not None:
            self.cooldown_date = cooldown_date
        if scm_branch is not None:
            self.scm_branch = scm_branch
        if unity_version is not None:
            self.unity_version = unity_version
        if xcode_version is not None:
            self.xcode_version = xcode_version
        if audit_changes is not None:
            self.audit_changes = audit_changes
        if project_version is not None:
            self.project_version = project_version
        if project_name is not None:
            self.project_name = project_name
        if project_id is not None:
            self.project_id = project_id
        if project_guid is not None:
            self.project_guid = project_guid
        if org_id is not None:
            self.org_id = org_id
        if org_fk is not None:
            self.org_fk = org_fk
        if filetoken is not None:
            self.filetoken = filetoken
        if links is not None:
            self.links = links
        if build_report is not None:
            self.build_report = build_report
        if test_results is not None:
            self.test_results = test_results
        if error is not None:
            self.error = error

    @property
    def build(self):
        """Gets the build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._build

    @build.setter
    def build(self, build):
        """Sets the build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param build: The build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._build = build

    @property
    def buildtargetid(self):
        """Gets the buildtargetid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        unique id auto-generated from the build target name  # noqa: E501

        :return: The buildtargetid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._buildtargetid

    @buildtargetid.setter
    def buildtargetid(self, buildtargetid):
        """Sets the buildtargetid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        unique id auto-generated from the build target name  # noqa: E501

        :param buildtargetid: The buildtargetid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._buildtargetid = buildtargetid

    @property
    def build_target_name(self):
        """Gets the build_target_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The build_target_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._build_target_name

    @build_target_name.setter
    def build_target_name(self, build_target_name):
        """Sets the build_target_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param build_target_name: The build_target_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """
        if build_target_name is not None and len(build_target_name) > 64:
            raise ValueError("Invalid value for `build_target_name`, length must be less than or equal to `64`")  # noqa: E501

        self._build_target_name = build_target_name

    @property
    def build_guid(self):
        """Gets the build_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        unique GUID identifying this build  # noqa: E501

        :return: The build_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._build_guid

    @build_guid.setter
    def build_guid(self, build_guid):
        """Sets the build_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        unique GUID identifying this build  # noqa: E501

        :param build_guid: The build_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._build_guid = build_guid

    @property
    def build_status(self):
        """Gets the build_status of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The build_status of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._build_status

    @build_status.setter
    def build_status(self, build_status):
        """Sets the build_status of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param build_status: The build_status of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """
        allowed_values = ["queued", "sentToBuilder", "started", "restarted", "success", "failure", "canceled", "unknown"]  # noqa: E501
        if build_status not in allowed_values:
            raise ValueError(
                "Invalid value for `build_status` ({0}), must be one of {1}"  # noqa: E501
                .format(build_status, allowed_values)
            )

        self._build_status = build_status

    @property
    def clean_build(self):
        """Gets the clean_build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        if the build was built without using data cached from previous builds  # noqa: E501

        :return: The clean_build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: bool
        """
        return self._clean_build

    @clean_build.setter
    def clean_build(self, clean_build):
        """Sets the clean_build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        if the build was built without using data cached from previous builds  # noqa: E501

        :param clean_build: The clean_build of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: bool
        """

        self._clean_build = clean_build

    @property
    def failure_details(self):
        """Gets the failure_details of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        list of failure details for this build attempt, when available  # noqa: E501

        :return: The failure_details of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: list[OrgsorgidprojectsprojectidbuildtargetsFailureDetails]
        """
        return self._failure_details

    @failure_details.setter
    def failure_details(self, failure_details):
        """Sets the failure_details of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        list of failure details for this build attempt, when available  # noqa: E501

        :param failure_details: The failure_details of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: list[OrgsorgidprojectsprojectidbuildtargetsFailureDetails]
        """

        self._failure_details = failure_details

    @property
    def canceled_by(self):
        """Gets the canceled_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The canceled_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._canceled_by

    @canceled_by.setter
    def canceled_by(self, canceled_by):
        """Sets the canceled_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param canceled_by: The canceled_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """
        allowed_values = ["api", "service", "service-timelimit"]  # noqa: E501
        if canceled_by not in allowed_values:
            raise ValueError(
                "Invalid value for `canceled_by` ({0}), must be one of {1}"  # noqa: E501
                .format(canceled_by, allowed_values)
            )

        self._canceled_by = canceled_by

    @property
    def platform(self):
        """Gets the platform of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The platform of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param platform: The platform of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """
        allowed_values = ["ios", "android", "webplayer", "webgl", "standaloneosxintel", "standaloneosxintel64", "standaloneosxuniversal", "standalonewindows", "standalonewindows64", "standalonelinux", "standalonelinux64", "standalonelinuxuniversal"]  # noqa: E501
        if platform not in allowed_values:
            raise ValueError(
                "Invalid value for `platform` ({0}), must be one of {1}"  # noqa: E501
                .format(platform, allowed_values)
            )

        self._platform = platform

    @property
    def workspace_size(self):
        """Gets the workspace_size of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        size of workspace in bytes  # noqa: E501

        :return: The workspace_size of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._workspace_size

    @workspace_size.setter
    def workspace_size(self, workspace_size):
        """Sets the workspace_size of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        size of workspace in bytes  # noqa: E501

        :param workspace_size: The workspace_size of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._workspace_size = workspace_size

    @property
    def created(self):
        """Gets the created of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        when the build was created  # noqa: E501

        :return: The created of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        when the build was created  # noqa: E501

        :param created: The created of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._created = created

    @property
    def finished(self):
        """Gets the finished of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        when the build completely finished  # noqa: E501

        :return: The finished of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        when the build completely finished  # noqa: E501

        :param finished: The finished of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._finished = finished

    @property
    def checkout_start_time(self):
        """Gets the checkout_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        when the build starting checking out code  # noqa: E501

        :return: The checkout_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._checkout_start_time

    @checkout_start_time.setter
    def checkout_start_time(self, checkout_start_time):
        """Sets the checkout_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        when the build starting checking out code  # noqa: E501

        :param checkout_start_time: The checkout_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._checkout_start_time = checkout_start_time

    @property
    def checkout_time_in_seconds(self):
        """Gets the checkout_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        amount of time spent checking out code  # noqa: E501

        :return: The checkout_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._checkout_time_in_seconds

    @checkout_time_in_seconds.setter
    def checkout_time_in_seconds(self, checkout_time_in_seconds):
        """Sets the checkout_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        amount of time spent checking out code  # noqa: E501

        :param checkout_time_in_seconds: The checkout_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._checkout_time_in_seconds = checkout_time_in_seconds

    @property
    def build_start_time(self):
        """Gets the build_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        when the build started compiling  # noqa: E501

        :return: The build_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._build_start_time

    @build_start_time.setter
    def build_start_time(self, build_start_time):
        """Sets the build_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        when the build started compiling  # noqa: E501

        :param build_start_time: The build_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._build_start_time = build_start_time

    @property
    def build_time_in_seconds(self):
        """Gets the build_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        amount of time spend compiling  # noqa: E501

        :return: The build_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._build_time_in_seconds

    @build_time_in_seconds.setter
    def build_time_in_seconds(self, build_time_in_seconds):
        """Sets the build_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        amount of time spend compiling  # noqa: E501

        :param build_time_in_seconds: The build_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._build_time_in_seconds = build_time_in_seconds

    @property
    def publish_start_time(self):
        """Gets the publish_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        when the build started saving build artifacts  # noqa: E501

        :return: The publish_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._publish_start_time

    @publish_start_time.setter
    def publish_start_time(self, publish_start_time):
        """Sets the publish_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        when the build started saving build artifacts  # noqa: E501

        :param publish_start_time: The publish_start_time of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._publish_start_time = publish_start_time

    @property
    def publish_time_in_seconds(self):
        """Gets the publish_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        amount of time spent saving build artifacts  # noqa: E501

        :return: The publish_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._publish_time_in_seconds

    @publish_time_in_seconds.setter
    def publish_time_in_seconds(self, publish_time_in_seconds):
        """Sets the publish_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        amount of time spent saving build artifacts  # noqa: E501

        :param publish_time_in_seconds: The publish_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._publish_time_in_seconds = publish_time_in_seconds

    @property
    def total_time_in_seconds(self):
        """Gets the total_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        total time for the build  # noqa: E501

        :return: The total_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._total_time_in_seconds

    @total_time_in_seconds.setter
    def total_time_in_seconds(self, total_time_in_seconds):
        """Sets the total_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        total time for the build  # noqa: E501

        :param total_time_in_seconds: The total_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._total_time_in_seconds = total_time_in_seconds

    @property
    def unit_test_time_in_seconds(self):
        """Gets the unit_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        total time for unit test execution step  # noqa: E501

        :return: The unit_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._unit_test_time_in_seconds

    @unit_test_time_in_seconds.setter
    def unit_test_time_in_seconds(self, unit_test_time_in_seconds):
        """Sets the unit_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        total time for unit test execution step  # noqa: E501

        :param unit_test_time_in_seconds: The unit_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._unit_test_time_in_seconds = unit_test_time_in_seconds

    @property
    def edit_mode_test_time_in_seconds(self):
        """Gets the edit_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        total time for unit test execution step  # noqa: E501

        :return: The edit_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._edit_mode_test_time_in_seconds

    @edit_mode_test_time_in_seconds.setter
    def edit_mode_test_time_in_seconds(self, edit_mode_test_time_in_seconds):
        """Sets the edit_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        total time for unit test execution step  # noqa: E501

        :param edit_mode_test_time_in_seconds: The edit_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._edit_mode_test_time_in_seconds = edit_mode_test_time_in_seconds

    @property
    def play_mode_test_time_in_seconds(self):
        """Gets the play_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        total time for unit test execution step  # noqa: E501

        :return: The play_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._play_mode_test_time_in_seconds

    @play_mode_test_time_in_seconds.setter
    def play_mode_test_time_in_seconds(self, play_mode_test_time_in_seconds):
        """Sets the play_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        total time for unit test execution step  # noqa: E501

        :param play_mode_test_time_in_seconds: The play_mode_test_time_in_seconds of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._play_mode_test_time_in_seconds = play_mode_test_time_in_seconds

    @property
    def last_built_revision(self):
        """Gets the last_built_revision of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        source control commit id for the build  # noqa: E501

        :return: The last_built_revision of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._last_built_revision

    @last_built_revision.setter
    def last_built_revision(self, last_built_revision):
        """Sets the last_built_revision of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        source control commit id for the build  # noqa: E501

        :param last_built_revision: The last_built_revision of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._last_built_revision = last_built_revision

    @property
    def changeset(self):
        """Gets the changeset of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        a list of source control changes between this and the last build  # noqa: E501

        :return: The changeset of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: list[object]
        """
        return self._changeset

    @changeset.setter
    def changeset(self, changeset):
        """Sets the changeset of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        a list of source control changes between this and the last build  # noqa: E501

        :param changeset: The changeset of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: list[object]
        """

        self._changeset = changeset

    @property
    def favorited(self):
        """Gets the favorited of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        if the build is marked as do not delete or not  # noqa: E501

        :return: The favorited of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: bool
        """
        return self._favorited

    @favorited.setter
    def favorited(self, favorited):
        """Sets the favorited of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        if the build is marked as do not delete or not  # noqa: E501

        :param favorited: The favorited of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: bool
        """

        self._favorited = favorited

    @property
    def label(self):
        """Gets the label of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        description given when a build is favorited  # noqa: E501

        :return: The label of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        description given when a build is favorited  # noqa: E501

        :param label: The label of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def deleted(self):
        """Gets the deleted of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        if the build is deleted or not  # noqa: E501

        :return: The deleted of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        if the build is deleted or not  # noqa: E501

        :param deleted: The deleted of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def headless(self):
        """Gets the headless of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        if the build was built to run in linux headless mode  # noqa: E501

        :return: The headless of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: object
        """
        return self._headless

    @headless.setter
    def headless(self, headless):
        """Sets the headless of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        if the build was built to run in linux headless mode  # noqa: E501

        :param headless: The headless of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: object
        """

        self._headless = headless

    @property
    def credentials_outdated(self):
        """Gets the credentials_outdated of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        if a newer credential has been attached to this buildtarget and the build can be re-signed  # noqa: E501

        :return: The credentials_outdated of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: bool
        """
        return self._credentials_outdated

    @credentials_outdated.setter
    def credentials_outdated(self, credentials_outdated):
        """Sets the credentials_outdated of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        if a newer credential has been attached to this buildtarget and the build can be re-signed  # noqa: E501

        :param credentials_outdated: The credentials_outdated of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: bool
        """

        self._credentials_outdated = credentials_outdated

    @property
    def deleted_by(self):
        """Gets the deleted_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        email address of the user who deleted this attempt  # noqa: E501

        :return: The deleted_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._deleted_by

    @deleted_by.setter
    def deleted_by(self, deleted_by):
        """Sets the deleted_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        email address of the user who deleted this attempt  # noqa: E501

        :param deleted_by: The deleted_by of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._deleted_by = deleted_by

    @property
    def queued_reason(self):
        """Gets the queued_reason of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        reason the build is currently waiting  # noqa: E501

        :return: The queued_reason of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._queued_reason

    @queued_reason.setter
    def queued_reason(self, queued_reason):
        """Sets the queued_reason of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        reason the build is currently waiting  # noqa: E501

        :param queued_reason: The queued_reason of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """
        allowed_values = ["targetConcurrency", "cooldown", "buildConcurrency", "waitingForBuildAgent", "evaluating", "sentToBuilder", "notPending"]  # noqa: E501
        if queued_reason not in allowed_values:
            raise ValueError(
                "Invalid value for `queued_reason` ({0}), must be one of {1}"  # noqa: E501
                .format(queued_reason, allowed_values)
            )

        self._queued_reason = queued_reason

    @property
    def cooldown_date(self):
        """Gets the cooldown_date of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        time until this build will be reconsidered for building  # noqa: E501

        :return: The cooldown_date of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._cooldown_date

    @cooldown_date.setter
    def cooldown_date(self, cooldown_date):
        """Sets the cooldown_date of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        time until this build will be reconsidered for building  # noqa: E501

        :param cooldown_date: The cooldown_date of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._cooldown_date = cooldown_date

    @property
    def scm_branch(self):
        """Gets the scm_branch of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        scm branch to be built  # noqa: E501

        :return: The scm_branch of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._scm_branch

    @scm_branch.setter
    def scm_branch(self, scm_branch):
        """Sets the scm_branch of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        scm branch to be built  # noqa: E501

        :param scm_branch: The scm_branch of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._scm_branch = scm_branch

    @property
    def unity_version(self):
        """Gets the unity_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        'latest' or a unity dot version with underscores (ex. '4_6_5')  # noqa: E501

        :return: The unity_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._unity_version

    @unity_version.setter
    def unity_version(self, unity_version):
        """Sets the unity_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        'latest' or a unity dot version with underscores (ex. '4_6_5')  # noqa: E501

        :param unity_version: The unity_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._unity_version = unity_version

    @property
    def xcode_version(self):
        """Gets the xcode_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501

        'latest' or a supported xcode version (ex. 'xcode7')  # noqa: E501

        :return: The xcode_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._xcode_version

    @xcode_version.setter
    def xcode_version(self, xcode_version):
        """Sets the xcode_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.

        'latest' or a supported xcode version (ex. 'xcode7')  # noqa: E501

        :param xcode_version: The xcode_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._xcode_version = xcode_version

    @property
    def audit_changes(self):
        """Gets the audit_changes of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The audit_changes of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: float
        """
        return self._audit_changes

    @audit_changes.setter
    def audit_changes(self, audit_changes):
        """Sets the audit_changes of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param audit_changes: The audit_changes of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: float
        """

        self._audit_changes = audit_changes

    @property
    def project_version(self):
        """Gets the project_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The project_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: OrgsorgidprojectsprojectidbuildtargetsProjectVersion
        """
        return self._project_version

    @project_version.setter
    def project_version(self, project_version):
        """Sets the project_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param project_version: The project_version of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: OrgsorgidprojectsprojectidbuildtargetsProjectVersion
        """

        self._project_version = project_version

    @property
    def project_name(self):
        """Gets the project_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The project_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._project_name

    @project_name.setter
    def project_name(self, project_name):
        """Sets the project_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param project_name: The project_name of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._project_name = project_name

    @property
    def project_id(self):
        """Gets the project_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The project_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param project_id: The project_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._project_id = project_id

    @property
    def project_guid(self):
        """Gets the project_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The project_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._project_guid

    @project_guid.setter
    def project_guid(self, project_guid):
        """Sets the project_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param project_guid: The project_guid of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._project_guid = project_guid

    @property
    def org_id(self):
        """Gets the org_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The org_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param org_id: The org_id of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def org_fk(self):
        """Gets the org_fk of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The org_fk of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._org_fk

    @org_fk.setter
    def org_fk(self, org_fk):
        """Sets the org_fk of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param org_fk: The org_fk of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._org_fk = org_fk

    @property
    def filetoken(self):
        """Gets the filetoken of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The filetoken of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._filetoken

    @filetoken.setter
    def filetoken(self, filetoken):
        """Sets the filetoken of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param filetoken: The filetoken of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._filetoken = filetoken

    @property
    def links(self):
        """Gets the links of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The links of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: dict(str, OrgsorgidprojectsprojectidbuildtargetsLinks)
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param links: The links of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: dict(str, OrgsorgidprojectsprojectidbuildtargetsLinks)
        """

        self._links = links

    @property
    def build_report(self):
        """Gets the build_report of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The build_report of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: OrgsorgidprojectsprojectidbuildtargetsBuildReport
        """
        return self._build_report

    @build_report.setter
    def build_report(self, build_report):
        """Sets the build_report of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param build_report: The build_report of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: OrgsorgidprojectsprojectidbuildtargetsBuildReport
        """

        self._build_report = build_report

    @property
    def test_results(self):
        """Gets the test_results of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The test_results of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: OrgsorgidprojectsprojectidbuildtargetsTestResults
        """
        return self._test_results

    @test_results.setter
    def test_results(self, test_results):
        """Sets the test_results of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param test_results: The test_results of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: OrgsorgidprojectsprojectidbuildtargetsTestResults
        """

        self._test_results = test_results

    @property
    def error(self):
        """Gets the error of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501


        :return: The error of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this OrgsorgidprojectsprojectidbuildtargetsBuilds.


        :param error: The error of this OrgsorgidprojectsprojectidbuildtargetsBuilds.  # noqa: E501
        :type: str
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrgsorgidprojectsprojectidbuildtargetsBuilds, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgsorgidprojectsprojectidbuildtargetsBuilds):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
