# coding: utf-8

"""
    Unity Cloud Build

    This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found at https://build.cloud.unity3d.com/login/me  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ```   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient


class BuildsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_delete_build_artifacts(self, orgid, projectid, options, **kwargs):  # noqa: E501
        """Delete artifacts for a batch of builds  # noqa: E501

        Delete all artifacts associated with the builds identified by the provided build target ids and build numbers. Builds marked as do not delete or that are currently building will be ignored.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_delete_build_artifacts(orgid, projectid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param Options8 options: Options to specify what builds to delete (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.batch_delete_build_artifacts_with_http_info(orgid, projectid, options, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_delete_build_artifacts_with_http_info(orgid, projectid, options, **kwargs)  # noqa: E501
            return data

    def batch_delete_build_artifacts_with_http_info(self, orgid, projectid, options, **kwargs):  # noqa: E501
        """Delete artifacts for a batch of builds  # noqa: E501

        Delete all artifacts associated with the builds identified by the provided build target ids and build numbers. Builds marked as do not delete or that are currently building will be ignored.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_delete_build_artifacts_with_http_info(orgid, projectid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param Options8 options: Options to specify what builds to delete (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_delete_build_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `batch_delete_build_artifacts`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `batch_delete_build_artifacts`")  # noqa: E501
        # verify the required parameter 'options' is set
        if ('options' not in params or
                params['options'] is None):
            raise ValueError("Missing the required parameter `options` when calling `batch_delete_build_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/artifacts/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_all_builds(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Cancel all builds  # noqa: E501

        Cancel all builds in progress for this build target (or all targets, if '_all' is specified as the buildtargetid). Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_all_builds(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_all_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_all_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
            return data

    def cancel_all_builds_with_http_info(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Cancel all builds  # noqa: E501

        Cancel all builds in progress for this build target (or all targets, if '_all' is specified as the buildtargetid). Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_all_builds_with_http_info(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_all_builds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `cancel_all_builds`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `cancel_all_builds`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `cancel_all_builds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_build(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Cancel build  # noqa: E501

        Cancel a build in progress. Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_build(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_build_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_build_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def cancel_build_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Cancel build  # noqa: E501

        Cancel a build in progress. Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_build_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `cancel_build`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `cancel_build`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `cancel_build`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `cancel_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_builds_for_org(self, orgid, **kwargs):  # noqa: E501
        """Cancel builds for org  # noqa: E501

        Cancel all in progress builds for an organization. Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_builds_for_org(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_builds_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_builds_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
            return data

    def cancel_builds_for_org_with_http_info(self, orgid, **kwargs):  # noqa: E501
        """Cancel builds for org  # noqa: E501

        Cancel all in progress builds for an organization. Canceling an already finished build will do nothing and respond successfully.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_builds_for_org_with_http_info(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_builds_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `cancel_builds_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/builds', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_share(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Create a new link to share a project  # noqa: E501

        Create a new short link to share a project. If this is called when a share already exists, that share will be revoked and a new one created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_share(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def create_share_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Create a new link to share a project  # noqa: E501

        Create a new short link to share a project. If this is called when a share already exists, that share will be revoked and a new one created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_share_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `create_share`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `create_share`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `create_share`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `create_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_all_build_artifacts(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Delete all artifacts associated with all non-favorited builds for a specified buildtargetid (_all is allowed).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_all_build_artifacts(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_all_build_artifacts_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_all_build_artifacts_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
            return data

    def delete_all_build_artifacts_with_http_info(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Delete all artifacts associated with all non-favorited builds for a specified buildtargetid (_all is allowed).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_all_build_artifacts_with_http_info(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_all_build_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `delete_all_build_artifacts`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `delete_all_build_artifacts`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `delete_all_build_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/artifacts', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_build_artifacts(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Delete all artifacts associated with a specific build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_build_artifacts(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_build_artifacts_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_build_artifacts_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def delete_build_artifacts_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Delete all artifacts associated with a specific build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_build_artifacts_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_build_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `delete_build_artifacts`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `delete_build_artifacts`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `delete_build_artifacts`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `delete_build_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/artifacts', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_log(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of settings changes between the last and current build.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_log_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_log_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def get_audit_log_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of settings changes between the last and current build.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number', 'per_page', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_audit_log`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_audit_log`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_audit_log`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_audit_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/auditlog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2006]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_log_for_build_target(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of historical settings changes for this build target.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_for_build_target(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_log_for_build_target_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_log_for_build_target_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
            return data

    def get_audit_log_for_build_target_with_http_info(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of historical settings changes for this build target.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_for_build_target_with_http_info(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'per_page', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log_for_build_target" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_audit_log_for_build_target`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_audit_log_for_build_target`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_audit_log_for_build_target`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/auditlog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2006]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_build(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Build Status  # noqa: E501

        Retrieve information for a specific build. A Build resource contains information related to a build attempt for a build target, including the build number, changeset, build times, and other pertinent data.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param str include: Extra fields to include in the response
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_build_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_build_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def get_build_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Build Status  # noqa: E501

        Retrieve information for a specific build. A Build resource contains information related to a build attempt for a build target, including the build number, changeset, build times, and other pertinent data.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param str include: Extra fields to include in the response
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_build`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_build`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_build`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'filetoken', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_build_log(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get build log  # noqa: E501

        Retrieve the plain text log for a specifc build.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build_log(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param float offsetlines: Stream log from the given line number
        :param bool linenumbers: Include log line numbers in the text output
        :param float last_line_number: The last line number seen, numbering will continue from here
        :param bool compact: Return the compact log, showing only errors and warnings
        :param bool with_html: Surround important lines (errors, warnings) with SPAN and CSS markup 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_build_log_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_build_log_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def get_build_log_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get build log  # noqa: E501

        Retrieve the plain text log for a specifc build.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build_log_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param float offsetlines: Stream log from the given line number
        :param bool linenumbers: Include log line numbers in the text output
        :param float last_line_number: The last line number seen, numbering will continue from here
        :param bool compact: Return the compact log, showing only errors and warnings
        :param bool with_html: Surround important lines (errors, warnings) with SPAN and CSS markup 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number', 'offsetlines', 'linenumbers', 'last_line_number', 'compact', 'with_html']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_build_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_build_log`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_build_log`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_build_log`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_build_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'offsetlines' in params:
            query_params.append(('offsetlines', params['offsetlines']))  # noqa: E501
        if 'linenumbers' in params:
            query_params.append(('linenumbers', params['linenumbers']))  # noqa: E501
        if 'last_line_number' in params:
            query_params.append(('lastLineNumber', params['last_line_number']))  # noqa: E501
        if 'compact' in params:
            query_params.append(('compact', params['compact']))  # noqa: E501
        if 'with_html' in params:
            query_params.append(('withHtml', params['with_html']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_build_steps(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get the build steps for a given build  # noqa: E501

        Retrieves all build steps for a build, this replaces the old method where we would manually download the build report artifacts and allows us to add more functionality into build steps.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build_steps(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: list[InlineResponse20011]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_build_steps_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_build_steps_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def get_build_steps_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get the build steps for a given build  # noqa: E501

        Retrieves all build steps for a build, this replaces the old method where we would manually download the build report artifacts and allows us to add more functionality into build steps.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build_steps_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: list[InlineResponse20011]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_build_steps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_build_steps`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_build_steps`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_build_steps`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_build_steps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/steps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse20011]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_builds(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """List all builds  # noqa: E501

        List all running and finished builds, sorted by build number (optionally paginating the results). Use '_all' as the buildtargetid to get all configured build targets. The response includes a Content-Range header that identifies the range of results returned and the total number of results matching the given query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_builds(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str include: Extra fields to include in the response
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :param str build_status: Query for only builds of a specific status
        :param str platform: Query for only builds of a specific platform
        :param bool show_deleted: Query for builds that have been deleted
        :param bool only_favorites: Query for builds that have been favorited
        :param bool clean_build: Query for builds that have either been built clean or using caches
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
            return data

    def get_builds_with_http_info(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """List all builds  # noqa: E501

        List all running and finished builds, sorted by build number (optionally paginating the results). Use '_all' as the buildtargetid to get all configured build targets. The response includes a Content-Range header that identifies the range of results returned and the total number of results matching the given query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_builds_with_http_info(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str include: Extra fields to include in the response
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :param str build_status: Query for only builds of a specific status
        :param str platform: Query for only builds of a specific platform
        :param bool show_deleted: Query for builds that have been deleted
        :param bool only_favorites: Query for builds that have been favorited
        :param bool clean_build: Query for builds that have either been built clean or using caches
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'include', 'per_page', 'page', 'build_status', 'platform', 'show_deleted', 'only_favorites', 'clean_build']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_builds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_builds`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_builds`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_builds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'build_status' in params:
            query_params.append(('buildStatus', params['build_status']))  # noqa: E501
        if 'platform' in params:
            query_params.append(('platform', params['platform']))  # noqa: E501
        if 'show_deleted' in params:
            query_params.append(('showDeleted', params['show_deleted']))  # noqa: E501
        if 'only_favorites' in params:
            query_params.append(('onlyFavorites', params['only_favorites']))  # noqa: E501
        if 'clean_build' in params:
            query_params.append(('cleanBuild', params['clean_build']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrgsorgidprojectsprojectidbuildtargetsBuilds]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_builds_for_org(self, orgid, **kwargs):  # noqa: E501
        """List all builds for org  # noqa: E501

        List all running and finished builds, sorted by build number (optionally paginating the results). The response includes a Content-Range header that identifies the range of results returned and the total number of results matching the given query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_builds_for_org(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str include: Extra fields to include in the response
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :param str build_status: Query for only builds of a specific status
        :param str platform: Query for only builds of a specific platform
        :param bool show_deleted: Query for builds that have been deleted
        :param bool only_favorites: Query for builds that have been favorited
        :param bool clean_build: Query for builds that have either been built clean or using caches
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_builds_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_builds_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
            return data

    def get_builds_for_org_with_http_info(self, orgid, **kwargs):  # noqa: E501
        """List all builds for org  # noqa: E501

        List all running and finished builds, sorted by build number (optionally paginating the results). The response includes a Content-Range header that identifies the range of results returned and the total number of results matching the given query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_builds_for_org_with_http_info(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str include: Extra fields to include in the response
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :param str build_status: Query for only builds of a specific status
        :param str platform: Query for only builds of a specific platform
        :param bool show_deleted: Query for builds that have been deleted
        :param bool only_favorites: Query for builds that have been favorited
        :param bool clean_build: Query for builds that have either been built clean or using caches
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'include', 'per_page', 'page', 'build_status', 'platform', 'show_deleted', 'only_favorites', 'clean_build']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_builds_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_builds_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'build_status' in params:
            query_params.append(('buildStatus', params['build_status']))  # noqa: E501
        if 'platform' in params:
            query_params.append(('platform', params['platform']))  # noqa: E501
        if 'show_deleted' in params:
            query_params.append(('showDeleted', params['show_deleted']))  # noqa: E501
        if 'only_favorites' in params:
            query_params.append(('onlyFavorites', params['only_favorites']))  # noqa: E501
        if 'clean_build' in params:
            query_params.append(('cleanBuild', params['clean_build']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/builds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrgsorgidprojectsprojectidbuildtargetsBuilds]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_share(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get the share link  # noqa: E501

        Gets a share link if it exists  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_share(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def get_share_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Get the share link  # noqa: E501

        Gets a share link if it exists  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_share_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `get_share`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `get_share`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `get_share`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resign_build_artifact(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Re-sign a build artifact  # noqa: E501

        Re-sign a build artifact using the most recent credentials associated with the buildtarget.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resign_build_artifact(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resign_build_artifact_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.resign_build_artifact_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def resign_build_artifact_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Re-sign a build artifact  # noqa: E501

        Re-sign a build artifact using the most recent credentials associated with the buildtarget.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resign_build_artifact_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resign_build_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `resign_build_artifact`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `resign_build_artifact`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `resign_build_artifact`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `resign_build_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/resign', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrgsorgidprojectsprojectidbuildtargetsBuilds]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revoke_share(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Revoke a shared link  # noqa: E501

        Revoke a shared link, both {buildtargetid} and {number} may use _all to revoke all share links for a given buildtarget or entire project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_share(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revoke_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
        else:
            (data) = self.revoke_share_with_http_info(orgid, projectid, buildtargetid, number, **kwargs)  # noqa: E501
            return data

    def revoke_share_with_http_info(self, orgid, projectid, buildtargetid, number, **kwargs):  # noqa: E501
        """Revoke a shared link  # noqa: E501

        Revoke a shared link, both {buildtargetid} and {number} may use _all to revoke all share links for a given buildtarget or entire project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_share_with_http_info(orgid, projectid, buildtargetid, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `revoke_share`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `revoke_share`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `revoke_share`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `revoke_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_builds(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Create new build  # noqa: E501

        Start the build process for this build target (or all targets, if '_all' is specified as the buildtargetid), if there is not one currently in process.  If a build is currently in process that information will be related in the 'error' field.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_builds(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param Options9 options: Options for starting the builds. You can specify a platform and label only when  starting a local (_local) build. A local build will return immediately and be  marked as successful. 
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
        else:
            (data) = self.start_builds_with_http_info(orgid, projectid, buildtargetid, **kwargs)  # noqa: E501
            return data

    def start_builds_with_http_info(self, orgid, projectid, buildtargetid, **kwargs):  # noqa: E501
        """Create new build  # noqa: E501

        Start the build process for this build target (or all targets, if '_all' is specified as the buildtargetid), if there is not one currently in process.  If a build is currently in process that information will be related in the 'error' field.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_builds_with_http_info(orgid, projectid, buildtargetid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param Options9 options: Options for starting the builds. You can specify a platform and label only when  starting a local (_local) build. A local build will return immediately and be  marked as successful. 
        :return: list[OrgsorgidprojectsprojectidbuildtargetsBuilds]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_builds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `start_builds`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `start_builds`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `start_builds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrgsorgidprojectsprojectidbuildtargetsBuilds]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_build(self, orgid, projectid, buildtargetid, number, options, **kwargs):  # noqa: E501
        """Update build information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_build(orgid, projectid, buildtargetid, number, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param Options10 options: Options for build update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_build_with_http_info(orgid, projectid, buildtargetid, number, options, **kwargs)  # noqa: E501
        else:
            (data) = self.update_build_with_http_info(orgid, projectid, buildtargetid, number, options, **kwargs)  # noqa: E501
            return data

    def update_build_with_http_info(self, orgid, projectid, buildtargetid, number, options, **kwargs):  # noqa: E501
        """Update build information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_build_with_http_info(orgid, projectid, buildtargetid, number, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str buildtargetid: unique id auto-generated from the build target name (required)
        :param str number: Build number or in some cases _all (required)
        :param Options10 options: Options for build update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'buildtargetid', 'number', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if ('orgid' not in params or
                params['orgid'] is None):
            raise ValueError("Missing the required parameter `orgid` when calling `update_build`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if ('projectid' not in params or
                params['projectid'] is None):
            raise ValueError("Missing the required parameter `projectid` when calling `update_build`")  # noqa: E501
        # verify the required parameter 'buildtargetid' is set
        if ('buildtargetid' not in params or
                params['buildtargetid'] is None):
            raise ValueError("Missing the required parameter `buildtargetid` when calling `update_build`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `update_build`")  # noqa: E501
        # verify the required parameter 'options' is set
        if ('options' not in params or
                params['options'] is None):
            raise ValueError("Missing the required parameter `options` when calling `update_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'buildtargetid' in params:
            path_params['buildtargetid'] = params['buildtargetid']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
