# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_readers.ipynb.

# %% auto 0
__all__ = ['read_opus', 'read_spectra', 'read_spa']

# %% ../nbs/00_readers.ipynb 3
from brukeropusreader import read_file
import numpy as np
from typing import Tuple, Dict, Callable
import pandas as pd

# %% ../nbs/00_readers.ipynb 5
def read_opus(
    fname:str # file name
) -> Tuple: # (spectrum, wavenumbers) as `np.ndarray`
    """OPUS (Bruker Optics) infrared spectra reader
    
    It uses patched `brukeropusreader` third party Python package. 
    
    To install it run: 
    `conda install -c "spectrocat/label/dev" brukeropusreader`
    """
    f = read_file(fname)
    return f['AB'], f.get_range('AB')    

# %% ../nbs/00_readers.ipynb 7
def read_spectra(
    fname:str # file name
) -> Tuple: # (spectrum, wavenumbers) as `np.ndarray`
    'Read KSSL MIRS data exported as .csv by USDA/NRCS'
    series = pd.read_csv(fname, index_col=0).squeeze("columns")
    return series.values, series.index.values

# %% ../nbs/00_readers.ipynb 9
def read_spa(filepath):
    '''
    Input
    Read a file (string) *.spa
    ----------
    Output
    Return spectra, wavelength (nm), titles
    '''
    with open(filepath, 'rb') as f:
        f.seek(564)
        Spectrum_Pts = np.fromfile(f, np.int32,1)[0]
        f.seek(30)
        SpectraTitles = np.fromfile(f, np.uint8,255)
        SpectraTitles = ''.join([chr(x) for x in SpectraTitles if x!=0])

        f.seek(576)
        Max_Wavenum=np.fromfile(f, np.single, 1)[0]
        Min_Wavenum=np.fromfile(f, np.single, 1)[0]
        Wavenumbers = np.flip(np.linspace(Min_Wavenum, Max_Wavenum, Spectrum_Pts))
        # print(Wavenumbers)

        f.seek(288);

        Flag=0
        while Flag != 3:
            Flag = np.fromfile(f, np.uint16, 1)

        DataPosition=np.fromfile(f,np.uint16, 1)
        f.seek(DataPosition[0])

        Spectra = np.fromfile(f, np.single, Spectrum_Pts)
    # return Spectra, 1e7/Wavenumbers, SpectraTitles
    # return Spectra, Wavenumbers, SpectraTitles
    return Spectra, Wavenumbers
