from typing import Dict, Union
from pydantic import Field

from .FuncaptchaRequestBase import FuncaptchaRequestBase
from .proxy_info import ProxyInfo

class FuncaptchaRequest(FuncaptchaRequestBase, ProxyInfo):
    type: str = Field(default='FunCaptchaTask')

    def getTaskDict(self) -> Dict[str, Union[str, int, bool]]:
        task = {}
        task['type'] = self.type
        task['websiteURL'] = self.websiteUrl
        task['websitePublicKey'] = self.websitePublicKey
        task['proxyType'] = self.proxy_type
        task['proxyAddress'] = self.proxy_address
        task['proxyPort'] = self.proxy_port
        task['proxyLogin'] = self.proxy_login
        task['proxyPassword'] = self.proxy_password
        if self.funcaptchaApiJSSubdomain is not None:
            task['funcaptchaApiJSSubdomain'] = self.funcaptchaApiJSSubdomain
        if self.data is not None:
            task['data'] = self.data
        return task